;;; Snd tests
;;;
;;; test 0: constants 
;;; test 1: default values
;;; test 2: headers 
;;; test 3: can variables be set/reset
;;; test 4: sndlib tests 
;;; test 5: simple overall checks
;;; test 6: vcts 
;;; test 7: colors 
;;; test 8: clm
;;; test 9: mix 
;;; test 10: marks 
;;; test 11: dialogs 
;;; test 12: sound file extensions etc 
;;; test 13: menus, edit lists, hooks, etc
;;; test 14: all functions
;;; test 15: chan-local vars 
;;; test 16: regularized funcs
;;; test 17: graphics
;;; test 18: enved
;;; test 19: save and restore
;;; test 20: transforms
;;; test 21: goops
;;; test 22: Snd user-interface
;;; test 23: X/Xt/Xm/Xpm
;;; test 24: Glib/gdk/gdk-pixbuf/pango/gtk
;;; test 25: errors

;;; TODO: gtk tests
;;; TODO: Xt selection tests?
;;; TODO: rest of Snd callbacks triggered
;;; TODO: header editor tests

(use-modules (ice-9 format) (ice-9 debug) (ice-9 popen) (ice-9 optargs) (ice-9 syncase))

;;; redefine if for tracing and so on (backtrace is sometimes very confused)
;(define-syntax IF
;  (syntax-rules ()
;    ((IF <form1> <form2>) (begin <form2>))
;    ((IF <form1> <form2> <form3>) (begin <form2>))))
;(define last-form #f)
;(define-syntax IF
;  (syntax-rules ()
;    ((IF <form1> <form2>) (begin (set! last-form (quote <form1>)) (if <form1> <form2>)))
;    ((IF <form1> <form2> <form3>) (begin (set! last-form (quote <form1>)) (if <form1> <form2> <form3>)))))
(define-syntax IF
  (syntax-rules ()
    ((IF <form1> <form2>) (if <form1> <form2>))
    ((IF <form1> <form2> <form3>) (if <form1> <form2> <form3>))))

(if (string=? (version) "1.4") (load "fix-optargs.scm"))

(define tests 1)
(define snd-test -1)
(define keep-going #f)
(define full-test (< snd-test 0))
(define total-tests 25)
(define with-exit (< snd-test 0))
(set! (with-background-processes) #f)
(define all-args #f) ; huge arg testing

(define home-dir "/home")
(define sf-dir "/sf1")
(define sample-reader-tests 300)
(define original-save-dir (or (save-dir) "/zap/snd"))
(define original-temp-dir (or (temp-dir) "/zap/tmp"))
(debug-set! stack 0)
(debug-enable 'debug 'backtrace)
(read-enable 'positions)
(define (irandom n) (inexact->exact (random n)))

(if (not (file-exists? (string-append home-dir "/bil/cl/oboe.snd")))
    (begin
      (set! sample-reader-tests 10)
      (set! home-dir "/usr/people")
      (set! sf-dir "/sf")))
(if (not (file-exists? (string-append home-dir "/bil/cl/oboe.snd")))
    (begin
      (set! sample-reader-tests 10)
      (set! home-dir "/space/home")
      (set! sf-dir "/sf")))
(if (not (file-exists? (string-append home-dir "/bil/cl/oboe.snd")))
    (begin
      (set! sample-reader-tests 10)
      (set! home-dir "/user/b")
      (set! sf-dir "/sf")))

(define sf-dir1 (string-append home-dir "/bil" sf-dir "/"))
(if (not (file-exists? (string-append sf-dir1 "alaw.wav")))
    (begin
      (set! sf-dir "/sf")
      (set! sf-dir1 (string-append home-dir "/bil" sf-dir "/"))
      (if (not (file-exists? (string-append sf-dir1 "alaw.wav")))
	  (begin
	    (snd-print "can't find sf directory!")
	    (set! sf-dir1 #f)))))
(set! sf-dir sf-dir1)

(if (and (not (file-exists? "4.aiff"))
	 (not (string=? (getcwd) (string-append home-dir "/bil/cl"))))
    (copy-file (string-append home-dir "/bil/cl/4.aiff") (string-append (getcwd) "/4.aiff")))
(if (and (not (file-exists? "2.snd"))
	 (not (string=? (getcwd) (string-append home-dir "/bil/cl"))))
    (copy-file (string-append home-dir "/bil/cl/2.snd") (string-append (getcwd) "/2.snd")))
(if (and (not (file-exists? "obtest.snd"))
	 (not (string=? (getcwd) (string-append home-dir "/bil/cl"))))
    (copy-file (string-append home-dir "/bil/cl/oboe.snd") (string-append (getcwd) "/obtest.snd")))
(if (and (not (file-exists? "sndxtest"))
	 (not (string=? (getcwd) (string-append home-dir "/bil/cl"))))
    (copy-file (string-append home-dir "/bil/cl/sndxtest") (string-append (getcwd) "/sndxtest")))

(define times '())
(defmacro time (a) 
  `(let ((start (get-internal-real-time))) 
   ,a 
   (let ((val (/ (- (get-internal-real-time) start) 100)))
     (set! times (cons (list ',a val) times)))))

(define include-clm #f)
(define original-prompt (listener-prompt))
(show-listener)
(set! (window-x) 600)
(set! (window-y) 10)

(define (snd-display . args)
  (let ((str (apply format #f args)))
    (newline) (display str)
    (if (not (provided? 'snd-nogui))
	(begin
	  (snd-print "\n")
	  (snd-print str)))))

(define test14-file #f)
(define fneq (lambda (a b) (> (abs (- a b)) .001)))
(define ffneq (lambda (a b) (> (abs (- a b)) .01)))
(define fffneq (lambda (a b) (> (abs (- a b)) .1)))
(define feql
  (lambda (a b)
    (if (null? a)
	(null? b)
	(if (null? b)
	    #f
	    (if (fneq (car a) (car b))
		#f
		(feql (cdr a) (cdr b)))))))
(define ffeql
  (lambda (a b)
    (if (null? a)
	(null? b)
	(if (null? b)
	    #f
	    (if (fffneq (car a) (car b))
		#f
		(ffeql (cdr a) (cdr b)))))))
(define fveql 
  (lambda (a b i)
    (if (null? b)
	#t
	(if (fneq (car b) (vct-ref a i))
	    #f
	    (fveql a (cdr b) (+ i 1))))))

(define (vequal v0 v1)
  (define (dequal ctr len)
    (if (= ctr len)
	#t
	(and (< (abs (- (vct-ref v0 ctr) (vct-ref v1 ctr))) .001)
	     (dequal (1+ ctr) len))))
  (let ((len (vct-length v0)))
    (and (= len (vct-length v1))
	 (dequal 0 len))))

(define ran-state (seed->random-state (current-time)))
(define my-random
  (lambda (n)
    (if (= n 0) 
	0 ;sigh...
	(random n ran-state))))

;(define rs (lambda (n) (< (my-random 1.0) n)))
(define rs (lambda (n) #t))

;;; preliminaries -- check constants, default variable values (assumes -noinit), sndlib and clm stuff

(define timings (make-vector (+ total-tests 1)))

(snd-display ";;~A" (snd-version))
(define test-hook (lambda (n)
		     ;(let ((fd (open-sound-file (format #f "/tmp/test~D.snd" n))))
		     ;  (close-sound-file fd 0))
		     (if (and (> n 0) (number? (vector-ref timings (- n 1))))
			 (vector-set! timings (- n 1) (- (get-internal-real-time) (vector-ref timings (- n 1)))))
		     (vector-set! timings n (get-internal-real-time))
		     (snd-display ";test ~D" n)
		     (gc)
		     ;(snd-display (gc-stats))
		     ;(if (file-exists? "memlog")
		     ;	 (system (format #f "cp memlog memlog.~D" (1- n))))
		     ;(mem-report)
		     ))

(define overall-start-time (get-internal-real-time))
(snd-display "~%~A~%" (strftime "%d-%b %H:%M %Z" (localtime (current-time))))

(define (log-mem tst) (if (and (> tests 50) (= (modulo tst 10) 0))  (mem-report)))

(defmacro without-errors (func)
  `(catch #t 
	  (lambda ()
	    ,func)
	  (lambda args 
	    ;(snd-display ";warning: ~A" (car args))
	    (car args))))
;(defmacro without-errors (func) `(begin ,func))
(load "hooks.scm")
;(reset-all-hooks)

(define (arity-ok func args)
  (let ((arity (procedure-property func 'arity)))
    (and (list? arity)
	 (>= args (car arity))
	 (or (caddr arity)
	     (<= args (+ (car arity) (cadr arity)))))))

(if (and (> (length (script-args)) 0)
	 (> (script-arg) 0))
    (let ((arg (script-arg))
	  (args (script-args)))
      (if (not (string=? (list-ref args (1- arg)) "-l")) 
	  (snd-display ";script-args[~A]: ~A?" (1- arg) (list-ref args (1- arg))))
      (if (not (string=? (list-ref args arg) "snd-test")) 
	  (snd-display ";script-args[~A]: ~A?" arg (list-ref args arg)))
      (if (> (length args) (1+ arg))
	  (begin
	    ;; test-number tests
	    (set! snd-test (string->number (list-ref args (1+ arg))))
	    (set! full-test (< snd-test 0))
	    (set! with-exit #t)
	    (set! (script-arg) (1+ arg))
	    (if (> (length (script-args)) (+ arg 2))
		(begin
		  (set! tests (string->number (list-ref args (+ arg 2))))
		  (set! (script-arg) (+ arg 2))))))))


;;; ---------------- test 0: constants ----------------
(if (or full-test (= snd-test 0) (and keep-going (<= snd-test 0)))
    (letrec ((test-constants 
	      (lambda (lst)
		(if (not (null? lst))
		    (begin
		      (if (not (= (cadr lst) (caddr lst)))
			  (snd-display ";~A /= ~A (~A)~%"
				       (car lst) (cadr lst) (caddr lst)))
		      (test-constants (cdddr lst)))))))
      (if (procedure? test-hook) (test-hook 0))
      (test-constants
       (list
	'enved-amplitude enved-amplitude 0 
	'autocorrelation autocorrelation 4 
	'bartlett-window bartlett-window 4 
	'blackman2-window blackman2-window 6 
	'blackman3-window blackman3-window 7 
	'blackman4-window blackman4-window 8
	'cauchy-window cauchy-window 12 
	'channels-combined channels-combined 1 
	'channels-separate channels-separate 0 
	'channels-superimposed channels-superimposed 2
	'chebyshev-transform chebyshev-transform 5 
	'cursor-in-middle cursor-in-middle 3
	'cursor-in-view cursor-in-view 0 
	'cursor-no-action cursor-no-action 5 
	'cursor-on-left cursor-on-left 1 
	'cursor-on-right cursor-on-right 2 
	'cursor-update-display cursor-update-display 4 
	'dolph-chebyshev-window dolph-chebyshev-window 16
	'exponential-window exponential-window 9 
	'zoom-focus-active zoom-focus-active 2
	'zoom-focus-left zoom-focus-left 0
	'zoom-focus-middle zoom-focus-middle 3
	'zoom-focus-right zoom-focus-right 1 
	'fourier-transform fourier-transform 0 
	'gaussian-window gaussian-window 14 
	'graph-dots graph-dots 1
	'graph-dots-and-lines graph-dots-and-lines 3 
	'graph-filled graph-filled 2 
	'graph-lines graph-lines 0 
	'graph-lollipops graph-lollipops 4
	'hadamard-transform hadamard-transform 7 
	'haar-transform haar-transform 8
	'hamming-window hamming-window 5
	'hankel-transform hankel-transform 2 
	'hanning-window hanning-window 1
	'kaiser-window kaiser-window 11 
	'keyboard-no-action keyboard-no-action 6
	'cepstrum cepstrum 6
	'graph-transform-once graph-transform-once 0 
	'parzen-window parzen-window 3
	'poisson-window poisson-window 13
	'rectangular-window rectangular-window 0 
	'riemann-window riemann-window 10 
	'graph-transform-as-sonogram graph-transform-as-sonogram 1
	'graph-transform-as-spectrogram graph-transform-as-spectrogram 2 
        'graph-time-once graph-time-once 0
        'graph-time-as-wavogram graph-time-as-wavogram 1
	'enved-spectrum enved-spectrum 1
	'speed-control-as-float speed-control-as-float 0 
	'speed-control-as-ratio speed-control-as-ratio 1 
	'speed-control-as-semitone speed-control-as-semitone 2 
	'enved-srate enved-srate 2 
	'tukey-window tukey-window 15 
	'walsh-transform walsh-transform 3
	'wavelet-transform wavelet-transform 1
	'welch-window welch-window 2 
	'cursor-cross cursor-cross 0
	'cursor-line cursor-line 1
	'dont-normalize-transform dont-normalize-transform 0
	'normalize-transform-by-channel normalize-transform-by-channel 1
	'normalize-transform-by-sound normalize-transform-by-sound 2
	'normalize-transform-globally normalize-transform-globally 3
	'x-axis-in-samples x-axis-in-samples 1 
	'x-axis-in-beats x-axis-in-beats 4
	'x-axis-in-seconds x-axis-in-seconds 0 
	'x-axis-as-percentage x-axis-as-percentage 2
	'enved-add-point enved-add-point 0
	'enved-delete-point enved-delete-point 1
	'enved-move-point enved-move-point 2
	'time-graph time-graph 0
	'transform-graph transform-graph 1
	'lisp-graph lisp-graph 2
	'copy-context copy-context 0
	'cursor-context cursor-context 3
	'selection-context selection-context 2

	;; sndlib constants
	'mus-next mus-next 0
	'mus-aifc mus-aifc 1
	'mus-riff mus-riff 2
	'mus-nist mus-nist 4
	'mus-raw mus-raw 10
	'mus-ircam mus-ircam 14
	'mus-aiff mus-aiff 56
	'mus-bicsf mus-bicsf 3
	'mus-voc mus-voc 8
	'mus-svx mus-svx 7
	'mus-soundfont mus-soundfont 31
	'mus-bshort mus-bshort 1
	'mus-lshort mus-lshort 10
	'mus-mulaw mus-mulaw 2
	'mus-alaw mus-alaw 6
	'mus-byte mus-byte 3
	'mus-ubyte mus-ubyte 7
	'mus-bfloat mus-bfloat 4
	'mus-lfloat mus-lfloat 12
	'mus-bint mus-bint 5
	'mus-lint mus-lint 11
	'mus-bintn mus-bintn 17
	'mus-lintn mus-lintn 18
	'mus-b24int mus-b24int 8
	'mus-l24int mus-l24int 16
	'mus-bdouble mus-bdouble 9
	'mus-ldouble mus-ldouble 13
	'mus-ubshort mus-ubshort 14
	'mus-ulshort mus-ulshort 15
	'mus-bfloat-unscaled mus-bfloat-unscaled 20
	'mus-lfloat-unscaled mus-lfloat-unscaled 21
	'mus-bdouble-unscaled mus-bdouble-unscaled 22
	'mus-ldouble-unscaled mus-ldouble-unscaled 23
	'mus-audio-default mus-audio-default 0
	'mus-audio-duplex-default mus-audio-duplex-default 1
	'mus-audio-line-out mus-audio-line-out 4
	'mus-audio-line-in mus-audio-line-in 5
	'mus-audio-microphone mus-audio-microphone 6
	'mus-audio-speakers mus-audio-speakers 7
	'mus-audio-dac-out mus-audio-dac-out 10
	'mus-audio-adat-in mus-audio-adat-in 2
	'mus-audio-aes-in mus-audio-aes-in 3
	'mus-audio-digital-in mus-audio-digital-in 8
	'mus-audio-digital-out mus-audio-digital-out 9
	'mus-audio-adat-out mus-audio-adat-out 11
	'mus-audio-aes-out mus-audio-aes-out 12
	'mus-audio-dac-filter mus-audio-dac-filter 13
	'mus-audio-mixer mus-audio-mixer 14
	'mus-audio-line1 mus-audio-line1 15
	'mus-audio-line2 mus-audio-line2 16
	'mus-audio-line3 mus-audio-line3 17
	'mus-audio-aux-input mus-audio-aux-input 18
	'mus-audio-cd mus-audio-cd 19
	'mus-audio-aux-output mus-audio-aux-output 20
	'mus-audio-spdif-in mus-audio-spdif-in 21
	'mus-audio-spdif-out mus-audio-spdif-out 22
	'mus-audio-amp mus-audio-amp 23
	'mus-audio-srate mus-audio-srate 24
	'mus-audio-channel mus-audio-channel 25
	'mus-audio-format mus-audio-format 26
	'mus-audio-port mus-audio-port 37
	'mus-audio-imix mus-audio-imix 27
	'mus-audio-igain mus-audio-igain 28
	'mus-audio-reclev mus-audio-reclev 29
	'mus-audio-pcm mus-audio-pcm 30
	'mus-audio-pcm2 mus-audio-pcm2 31
	'mus-audio-ogain mus-audio-ogain 32
	'mus-audio-line mus-audio-line 33
	'mus-audio-synth mus-audio-synth 34
	'mus-audio-bass mus-audio-bass 35
	'mus-audio-treble mus-audio-treble 36
	'mus-audio-direction mus-audio-direction 39
	'mus-audio-samples-per-channel mus-audio-samples-per-channel 38
	))

      (set! (region-graph-style) (region-graph-style))
      (IF (not (equal? (region-graph-style) graph-lines))
	  (snd-display ";region-graph-style set def: ~A" (region-graph-style)))
      (set! (ask-before-overwrite) (ask-before-overwrite)) 
      (IF (not (equal? (ask-before-overwrite) #f)) 
	  (snd-display ";ask-before-overwrite set def: ~A" (ask-before-overwrite)))
      (set! (audio-output-device) (audio-output-device))
      (IF (not (equal? (audio-output-device)  0)) 
	  (snd-display ";audio-output-device set def: ~A" (audio-output-device)))
      (set! (audio-state-file) (audio-state-file))
      (IF (not (equal? (audio-state-file)  ".snd-mixer" )) 
	  (snd-display ";audio-state-file set def: ~A" (audio-state-file)))
      (set! (auto-resize) (auto-resize))
      (IF (not (equal? (auto-resize)  #t )) 
	  (snd-display ";auto-resize set def: ~A" (auto-resize)))
      (set! (auto-update) (auto-update))
      (IF (not (equal? (auto-update)  #f)) 
	  (snd-display ";auto-update set def: ~A" (auto-update)))
      (set! (channel-style) (channel-style))
      (IF (not (equal? (channel-style)  0 )) 
	  (snd-display ";channel-style set def: ~A" (channel-style)))
      (set! (color-cutoff) (color-cutoff))
      (IF (fneq (color-cutoff)  0.003 )
	  (snd-display ";color-cutoff set def: ~A" (color-cutoff)))
      (set! (color-inverted) (color-inverted))
      (IF (not (equal? (color-inverted)  #t)) 
	  (snd-display ";color-inverted set def: ~A" (color-inverted)))
      (set! (color-scale) (color-scale))
      (IF (fneq (color-scale)  1.0 )
	  (snd-display ";color-scale set def: ~A" (color-scale)))
      (set! (auto-update-interval) (auto-update-interval))
      (IF (fneq (auto-update-interval)  60.0 )
	  (snd-display ";auto-update-interval set def: ~A" (auto-update-interval)))
      (set! (dac-combines-channels) (dac-combines-channels))
      (IF (not (equal? (dac-combines-channels)  #t)) 
	  (snd-display ";dac-combines-channels set def: ~A" (dac-combines-channels)))
      (set! (dac-size) (dac-size))
      (IF (not (equal? (dac-size)  256 )) 
	  (snd-display ";dac-size set def: ~A" (dac-size)))
      (set! (minibuffer-history-length) (minibuffer-history-length))
      (IF (not (equal? (minibuffer-history-length)  8)) 
	  (snd-display ";minibuffer-history-length set def: ~A" (minibuffer-history-length)))
      (set! (data-clipped) (data-clipped))
      (IF (not (equal? (data-clipped)  #f )) 
	  (snd-display ";data-clipped set def: ~A" (data-clipped)))
      (set! (default-output-chans) (default-output-chans))
      (IF (not (equal? (default-output-chans)  1 )) 
	  (snd-display ";default-output-chans set def: ~A" (default-output-chans)))
      (set! (default-output-format) (default-output-format))
      (IF (not (equal? (default-output-format)  1)) 
	  (snd-display ";default-output-format set def: ~A" (default-output-format)))
      (set! (default-output-srate) (default-output-srate))
      (IF (not (equal? (default-output-srate)  22050 )) 
	  (snd-display ";default-output-srate set def: ~A" (default-output-srate)))
      (set! (default-output-type) (default-output-type))
      (IF (not (equal? (default-output-type)  0 )) 
	  (snd-display ";default-output-type set def: ~A" (default-output-type)))
      (set! (dot-size) (dot-size))
      (IF (not (equal? (dot-size)  1 )) 
	  (snd-display ";dot-size set def: ~A" (dot-size)))
      (set! (emacs-style-save-as) (emacs-style-save-as))
      (IF (not (equal? (emacs-style-save-as)  #f)) 
	  (snd-display ";emacs-style-save-as set def: ~A" (emacs-style-save-as)))
      (set! (enved-base) (enved-base))
      (IF (fneq (enved-base)  1.0 )
	  (snd-display ";enved-base set def: ~A" (enved-base)))
      (set! (enved-clip?) (enved-clip?))
      (IF (not (equal? (enved-clip?)  #f )) 
	  (snd-display ";enved-clip? set def: ~A" (enved-clip?)))
      (set! (enved-filter) (enved-filter))
      (IF (not (equal? (enved-filter) #t)) 
	  (snd-display ";enved-filter set def: ~A" (enved-filter)))
      (set! (enved-filter-order) (enved-filter-order))
      (IF (not (equal? (enved-filter-order)  40)) 
	  (snd-display ";enved-filter-order set def: ~A" (enved-filter-order)))
      (set! (enved-in-dB) (enved-in-dB))
      (IF (not (equal? (enved-in-dB)  #f )) 
	  (snd-display ";enved-in-dB set def: ~A" (enved-in-dB)))
      (set! (enved-exp?) (enved-exp?))
      (IF (not (equal? (enved-exp?)  #f )) 
	  (snd-display ";enved-exp? set def: ~A" (enved-exp?)))
      (set! (enved-power) (enved-power))
      (IF (fneq (enved-power)  3.0)
	  (snd-display ";enved-power set def: ~A" (enved-power)))
      (set! (enved-target) (enved-target))
      (IF (not (equal? (enved-target)  0 )) 
	  (snd-display ";enved-target set def: ~A" (enved-target)))
      (set! (enved-wave?) (enved-wave?))
      (IF (not (equal? (enved-wave?)  #f )) 
	  (snd-display ";enved-wave? set def: ~A" (enved-wave?)))
      (set! (enved-active-env) (enved-active-env))
      (IF (not (equal? (enved-active-env)  '())) 
	  (snd-display ";enved-active-env set def: ~A" (enved-active-env)))
      (set! (eps-file) (eps-file))
      (IF (not (equal? (eps-file)  "snd.eps" )) 
	  (snd-display ";eps-file set def: ~A" (eps-file)))
      (set! (eps-bottom-margin) (eps-bottom-margin))
      (IF (fneq (eps-bottom-margin)  0.0)
	  (snd-display ";eps-bottom-margin set def: ~A" (eps-bottom-margin)))
      (set! (eps-left-margin) (eps-left-margin))
      (IF (fneq (eps-left-margin)  0.0)
	  (snd-display ";eps-left-margin set def: ~A" (eps-left-margin)))
      (set! (eps-size) (eps-size))
      (IF (fneq (eps-size)  1.0)
	  (snd-display ";eps-size set def: ~A" (eps-size)))
      (set! (fft-window-beta) (fft-window-beta))
      (IF (fneq (fft-window-beta)  0.0 )
	  (snd-display ";fft-window-beta set def: ~A" (fft-window-beta)))
      (set! (fft-log-frequency) (fft-log-frequency))
      (IF (not (equal? (fft-log-frequency)  #f )) 
	  (snd-display ";fft-log-frequency set def: ~A" (fft-log-frequency)))
      (set! (fft-log-magnitude) (fft-log-magnitude))
      (IF (not (equal? (fft-log-magnitude)  #f )) 
	  (snd-display ";fft-log-magnitude set def: ~A" (fft-log-magnitude)))
      (set! (transform-size) (transform-size))
      (IF (not (equal? (transform-size)  256 )) 
	  (snd-display ";transform-size set def: ~A" (transform-size)))
      (set! (transform-graph-type) (transform-graph-type))
      (IF (not (equal? (transform-graph-type)  0)) 
	  (snd-display ";transform-graph-type set def: ~A" (transform-graph-type)))
      (set! (fft-window) (fft-window))
      (IF (not (equal? (fft-window)  6 )) 
	  (snd-display ";fft-window set def: ~A" (fft-window)))
      (set! (filter-env-in-hz) (filter-env-in-hz))
      (IF (not (equal? (filter-env-in-hz)  #f)) 
	  (snd-display ";filter-env-in-hz set def: ~A" (filter-env-in-hz)))
      (set! (graph-cursor) (graph-cursor))
      (IF (not (equal? (graph-cursor)  34)) 
	  (snd-display ";graph-cursor set def: ~A" (graph-cursor)))
      (set! (graph-style) (graph-style))
      (IF (not (equal? (graph-style)  0 )) 
	  (snd-display ";graph-style set def: ~A" (graph-style)))
      (set! (graphs-horizontal) (graphs-horizontal))
      (IF (not (equal? (graphs-horizontal)  #t)) 
	  (snd-display ";graphs-horizontal set def: ~A" (graphs-horizontal)))
      (set! (hankel-jn) (hankel-jn))
      (IF (fneq (hankel-jn)  0.0)
	  (snd-display ";hankel-jn set def: ~A" (hankel-jn)))
      (set! (just-sounds) (just-sounds))
      (IF (not (equal? (just-sounds)  #f)) 
	  (snd-display ";just-sounds set def: ~A" (just-sounds)))
      (set! (listener-prompt) (listener-prompt))
      (IF (not (equal? (listener-prompt)  ">" )) 
	  (snd-display ";listener-prompt set def: ~A" (listener-prompt)))
      (set! (max-transform-peaks) (max-transform-peaks))
      (IF (not (equal? (max-transform-peaks)  100)) 
	  (snd-display ";max-transform-peaks set def: ~A" (max-transform-peaks)))
      (set! (max-regions) (max-regions))
      (IF (not (equal? (max-regions)  16 )) 
	  (snd-display ";max-regions set def: ~A" (max-regions)))
      (set! (min-dB) (min-dB))
      (IF (fneq (min-dB)  -60.0 )
	  (snd-display ";min-dB set def: ~A" (min-dB)))
      (set! (movies) (movies))
      (IF (not (equal? (movies)  #t )) 
	  (snd-display ";movies set def: ~A" (movies)))
      (set! (selection-creates-region) (selection-creates-region))
      (IF (not (equal? (selection-creates-region)  #t )) 
	  (snd-display ";selection-creates-region set def: ~A" (selection-creates-region)))
      (set! (transform-normalization) (transform-normalization))
      (IF (not (equal? (transform-normalization)  normalize-transform-by-channel)) 
	  (snd-display ";transform-normalization set def: ~A" (transform-normalization)))
      (set! (previous-files-sort) (previous-files-sort))
      (IF (not (equal? (previous-files-sort)  0 )) 
	  (snd-display ";previous-files-sort set def: ~A" (previous-files-sort)))
      (set! (print-length) (print-length))
      (IF (not (equal? (print-length)  12 )) 
	  (snd-display ";print-length set def: ~A" (print-length)))
      (set! (recorder-autoload) (recorder-autoload))
      (IF (not (equal? (recorder-autoload)  #f)) 
	  (snd-display ";recorder-autoload set def: ~A" (recorder-autoload)))
      (set! (recorder-buffer-size) (recorder-buffer-size))
      (IF (not (equal? (recorder-buffer-size)  4096 )) 
	  (snd-display ";recorder-buffer-size set def: ~A" (recorder-buffer-size)))
      (set! (recorder-file) (recorder-file))
      (IF (not (equal? (recorder-file)  #f )) 
	  (snd-display ";recorder-file set def: ~A" (recorder-file)))
      (set! (recorder-max-duration) (recorder-max-duration))
      (IF (fneq (recorder-max-duration)  1000000.0)
	  (snd-display ";recorder-max-duration set def: ~A" (recorder-max-duration)))
      (set! (recorder-out-chans) (recorder-out-chans))
      (IF (not (equal? (recorder-out-chans)  2 )) 
	  (snd-display ";recorder-out-chans set def: ~A" (recorder-out-chans)))
      (set! (recorder-srate) (recorder-srate))
      (IF (not (equal? (recorder-srate)  22050 )) 
	  (snd-display ";recorder-srate set def: ~A" (recorder-srate)))
      (set! (recorder-trigger) (recorder-trigger))
      (IF (fneq (recorder-trigger)  0.0)
	  (snd-display ";recorder-trigger set def: ~A" (recorder-trigger)))
      (set! (reverb-control-decay) (reverb-control-decay))
      (IF (fneq (reverb-control-decay)  1.0 )
	  (snd-display ";reverb-control-decay set def: ~A" (reverb-control-decay)))
      (set! (save-state-file) (save-state-file))
      (IF (not (equal? (save-state-file)  "saved-snd.scm" )) 
	  (snd-display ";save-state-file set def: ~A" (save-state-file)))
      (set! (show-axes) (show-axes))
      (IF (not (equal? (show-axes)  1)) 
	  (snd-display ";show-axes set def: ~A" (show-axes)))
      (set! (show-transform-peaks) (show-transform-peaks))
      (IF (not (equal? (show-transform-peaks)  #f )) 
	  (snd-display ";show-transform-peaks set def: ~A" (show-transform-peaks)))
      (set! (show-indices) (show-indices))
      (IF (not (equal? (show-indices)  #f)) 
	  (snd-display ";show-indices set def: ~A" (show-indices)))
      (set! (show-backtrace) (show-backtrace))
      (IF (not (equal? (show-backtrace)  #f)) 
	  (snd-display ";show-backtrace set def: ~A" (show-backtrace)))
      (set! (show-marks) (show-marks))
      (IF (not (equal? (show-marks)  #t )) 
	  (snd-display ";show-marks set def: ~A" (show-marks)))
      (set! (show-mix-waveforms) (show-mix-waveforms))
      (IF (not (equal? (show-mix-waveforms)  #t)) 
	  (snd-display ";show-mix-waveforms set def: ~A" (show-mix-waveforms)))
      (set! (show-selection-transform) (show-selection-transform))
      (IF (not (equal? (show-selection-transform)  #f )) 
	  (snd-display ";show-selection-transform set def: ~A" (show-selection-transform)))
      (set! (show-y-zero) (show-y-zero))
      (IF (not (equal? (show-y-zero)  #f )) 
	  (snd-display ";show-y-zero set def: ~A" (show-y-zero)))
      (set! (sinc-width) (sinc-width))
      (IF (not (equal? (sinc-width)  10 )) 
	  (snd-display ";sinc-width set def: ~A" (sinc-width)))
      (set! (spectro-cutoff) (spectro-cutoff))
      (IF (fneq (spectro-cutoff)  1.0)
	  (snd-display ";spectro-cutoff set def: ~A" (spectro-cutoff)))
      (set! (spectro-hop) (spectro-hop))
      (IF (not (equal? (spectro-hop)  4 )) 
	  (snd-display ";spectro-hop set def: ~A" (spectro-hop)))
      (set! (spectro-start) (spectro-start))
      (IF (fneq (spectro-start)  0.0 )
	  (snd-display ";spectro-start set def: ~A" (spectro-start)))
      (set! (spectro-x-angle) (spectro-x-angle))
      (IF (fneq (spectro-x-angle)  90.0 )
	  (snd-display ";spectro-x-angle set def: ~A" (spectro-x-angle)))
      (set! (spectro-x-scale) (spectro-x-scale))
      (IF (fneq (spectro-x-scale)  1.0)
	  (snd-display ";spectro-x-scale set def: ~A" (spectro-x-scale)))
      (set! (spectro-y-angle) (spectro-y-angle))
      (IF (fneq (spectro-y-angle)  0.0 )
	  (snd-display ";spectro-y-angle set def: ~A" (spectro-y-angle)))
      (set! (spectro-y-scale) (spectro-y-scale))
      (IF (fneq (spectro-y-scale)  1.0 )
	  (snd-display ";spectro-y-scale set def: ~A" (spectro-y-scale)))
      (set! (spectro-z-angle) (spectro-z-angle))
      (IF (fneq (spectro-z-angle)  -2.0)
	  (snd-display ";spectro-z-angle set def: ~A" (spectro-z-angle)))
      (set! (spectro-z-scale) (spectro-z-scale))
      (IF (fneq (spectro-z-scale)  0.1 )
	  (snd-display ";spectro-z-scale set def: ~A" (spectro-z-scale)))
      (set! (speed-control-style) (speed-control-style))
      (IF (not (equal? (speed-control-style)  0 )) 
	  (snd-display ";speed-control-style set def: ~A" (speed-control-style)))
      (set! (speed-control-tones) (speed-control-tones))
      (IF (not (equal? (speed-control-tones)  12)) 
	  (snd-display ";speed-control-tones set def: ~A" (speed-control-tones)))
      (set! (temp-dir) (temp-dir))
      (IF (not (equal? (temp-dir)  #f )) 
	  (snd-display ";temp-dir set def: ~A" (temp-dir)))
      (set! (ladspa-dir) (ladspa-dir))
      (IF (not (equal? (ladspa-dir)  #f )) 
	  (snd-display ";ladspa-dir set def: ~A" (ladspa-dir)))
      (set! (tiny-font) (tiny-font))
      (IF (not (equal? (tiny-font)  "6x12")) 
	  (snd-display ";tiny-font set def: ~A" (tiny-font)))
      (set! (transform-type) (transform-type))
      (IF (not (equal? (transform-type)  0 )) 
	  (snd-display ";transform-type set def: ~A" (transform-type)))
      (set! (trap-segfault) (trap-segfault))
      (IF (not (equal? (trap-segfault)  #f)) 
	  (snd-display ";trap-segfault set def: ~A" (trap-segfault)))
      (set! (use-sinc-interp) (use-sinc-interp))
      (IF (not (equal? (use-sinc-interp)  #t )) 
	  (snd-display ";use-sinc-interp set def: ~A" (use-sinc-interp)))
      (set! (verbose-cursor) (verbose-cursor))
      (IF (not (equal? (verbose-cursor)  #f)) 
	  (snd-display ";verbose-cursor set def: ~A" (verbose-cursor)))
      (set! (vu-font) (vu-font))
      (IF (not (equal? (vu-font)  #f )) 
	  (snd-display ";vu-font set def: ~A" (vu-font)))
      (set! (vu-font-size) (vu-font-size))
      (IF (fneq (vu-font-size)  1.0 )
	  (snd-display ";vu-font-size set def: ~A" (vu-font-size)))
      (set! (vu-size) (vu-size))
      (IF (fneq (vu-size)  1.0 )
	  (snd-display ";vu-size set def: ~A" (vu-size)))
      (set! (wavelet-type) (wavelet-type))
      (IF (not (equal? (wavelet-type)  0 )) 
	  (snd-display ";wavelet-type set def: ~A" (wavelet-type)))
      (set! (time-graph-type) (time-graph-type))
      (IF (not (equal? (time-graph-type)  graph-time-once)) 
	  (snd-display ";time-graph-type set def: ~A" (time-graph-type)))
      (set! (wavo-hop) (wavo-hop))
      (IF (not (equal? (wavo-hop)  3 )) 
	  (snd-display ";wavo-hop set def: ~A" (wavo-hop)))
      (set! (wavo-trace) (wavo-trace))
      (IF (not (equal? (wavo-trace)  64 )) 
	  (snd-display ";wavo-trace set def: ~A" (wavo-trace)))
      (set! (x-axis-style) (x-axis-style))
      (IF (not (equal? (x-axis-style)  0 )) 
	  (snd-display ";x-axis-style set def: ~A" (x-axis-style)))
      (set! (beats-per-minute) (beats-per-minute))
      (IF (fneq (beats-per-minute)  60.0 )
	  (snd-display ";beats-per-minute set def: ~A" (beats-per-minute)))
      (set! (zero-pad) (zero-pad))
      (IF (not (equal? (zero-pad)  0)) 
	  (snd-display ";zero-pad set def: ~A" (zero-pad)))
      (set! (zoom-focus-style) (zoom-focus-style))
      (IF (not (equal? (zoom-focus-style)  2 )) 
	  (snd-display ";zoom-focus-style set def: ~A" (zoom-focus-style)))
      (set! (mix-waveform-height) (mix-waveform-height))
      (IF (not (equal? (mix-waveform-height)  20 )) 
	  (snd-display ";mix-waveform-height set def: ~A" (mix-waveform-height)))
      (set! (mix-tag-width) (mix-tag-width))
      (IF (not (equal? (mix-tag-width)  6)) 
	  (snd-display ";mix-tag-width set def: ~A" (mix-tag-width)))
      (set! (mix-tag-height) (mix-tag-height))
      (IF (not (equal? (mix-tag-height)  14)) 
	  (snd-display ";mix-tag-height set def: ~A" (mix-tag-height)))
      (set! (audio-output-device) (audio-output-device))
      (IF (not (equal? (audio-output-device)  0 )) 
	  (snd-display ";audio-output-device set def: ~A" (audio-output-device)))
      (set! (selected-mix) (selected-mix))
      (IF (not (equal? (selected-mix)  -1)) 
	  (snd-display ";selected-mix set def: ~A" (selected-mix)))

      ))


;;; ---------------- test 1: default values ----------------
(if (or full-test (= snd-test 1) (and keep-going (<= snd-test 1)))
    (letrec ((test-defaults
	      (lambda (lst)
		(if (not (null? lst))
		    (begin
		      (if (not (equal? (cadr lst)  (caddr lst)))
			  (if (and (number? (caddr lst))
				   (inexact? (caddr lst)))
			      (if (fneq (cadr lst) (caddr lst))
				  (snd-display ";~A /= ~A (~A)" (car lst) (caddr lst) (cadr lst)))
			      (snd-display ";~A /= ~A (~A)" (car lst) (caddr lst) (cadr lst))))
		      (test-defaults (cdddr lst)))))))
      (if (procedure? test-hook) (test-hook 1))
      (test-defaults
       (list
	'amp-control (without-errors (amp-control)) 'no-such-sound
	'ask-before-overwrite (ask-before-overwrite) #f 
	'audio-output-device (audio-output-device) 0
	'audio-state-file (audio-state-file) ".snd-mixer" 
	'auto-resize (auto-resize) #t 
	'auto-update (auto-update) #f
	'channel-style (channel-style) 0 
	'color-cutoff (color-cutoff) 0.003 
	'color-inverted (color-inverted) #t
	'color-scale (color-scale) 1.0 
	'colormap (colormap) -1 
	'contrast-control (without-errors (contrast-control)) 'no-such-sound
	'contrast-control-amp (without-errors (contrast-control-amp)) 'no-such-sound
	'contrast-control? (without-errors (contrast-control?)) 'no-such-sound
	'auto-update-interval (auto-update-interval) 60.0 
	'cursor-follows-play (without-errors (cursor-follows-play)) 'no-such-sound
	'dac-combines-channels (dac-combines-channels) #t
	'emacs-style-save-as (emacs-style-save-as) #f
	'dac-size (dac-size) 256 
	'minibuffer-history-length (minibuffer-history-length) 8
	'data-clipped (data-clipped) #f 
	'default-output-chans (default-output-chans) 1 
	'default-output-format (default-output-format) 1
	'default-output-srate (default-output-srate) 22050 
	'default-output-type (default-output-type) 0 
	'dot-size (dot-size) 1 
	'enved-base (enved-base) 1.0 
	'enved-clip? (enved-clip?) #f 
	'enved-filter-order (enved-filter-order) 40
	'enved-filter (enved-filter) #t
	'enved-in-dB (enved-in-dB) #f 
	'enved-exp? (enved-exp?) #f 
	'enved-power (enved-power) 3.0
	'enved-target (enved-target) 0 
	'enved-wave? (enved-wave?) #f 
	'enved-active-env (enved-active-env) '()
	'enved-selected-env (enved-selected-env) '()
	'eps-file (eps-file) "snd.eps" 
	'eps-bottom-margin (eps-bottom-margin) 0.0
	'eps-left-margin (eps-left-margin) 0.0
	'eps-size (eps-size) 1.0
	'expand-control (without-errors (expand-control)) 'no-such-sound
	'expand-control-hop (without-errors (expand-control-hop)) 'no-such-sound
	'expand-control-length (without-errors (expand-control-length)) 'no-such-sound
	'expand-control-ramp (without-errors (expand-control-ramp)) 'no-such-sound
	'expand-control? (without-errors (expand-control?)) 'no-such-sound
	'fft-window-beta (fft-window-beta) 0.0 
	'fft-log-frequency (fft-log-frequency) #f 
	'fft-log-magnitude (fft-log-magnitude) #f 
	'transform-size (transform-size) 256 
	'transform-graph-type (transform-graph-type) 0
	'fft-window (fft-window) 6 
	'graph-transform? (without-errors (graph-transform?)) 'no-such-sound
	'filter-control-in-dB (without-errors (filter-control-in-dB)) 'no-such-sound
	'filter-control-env (without-errors (filter-control-env)) 'no-such-sound
	'filter-env-in-hz (filter-env-in-hz) #f
	'filter-control-order (without-errors (filter-control-order)) 'no-such-sound
	'filter-control? (without-errors (filter-control?)) 'no-such-sound
	'graph-cursor (graph-cursor) 34
	'graph-style (graph-style) 0 
	'graph-lisp? (without-errors (graph-lisp?)) 'no-such-sound
	'graphs-horizontal (graphs-horizontal) #t
	'hankel-jn (hankel-jn) 0.0
	'just-sounds (just-sounds) #f
	'listener-prompt (listener-prompt) ">" 
	'max-transform-peaks (max-transform-peaks) 100
	'max-regions (max-regions) 16 
	'min-dB (min-dB) -60.0 
	'movies (movies) #t 
	'selection-creates-region (selection-creates-region) #t 
	'transform-normalization (transform-normalization) normalize-transform-by-channel
	'previous-files-sort (previous-files-sort) 0 
	'print-length (print-length) 12 
	'read-only (without-errors (read-only)) 'no-such-sound
	'recorder-autoload (recorder-autoload) #f
	'recorder-buffer-size (recorder-buffer-size) 4096 
	'recorder-file (recorder-file) #f 
	'recorder-max-duration (recorder-max-duration) 1000000.0
	'recorder-out-chans (recorder-out-chans) 2 
	'recorder-srate (recorder-srate) 22050 
	'recorder-trigger (recorder-trigger) 0.0
	'region-graph-style (region-graph-style) graph-lines
	'reverb-control-decay (reverb-control-decay) 1.0 
	'reverb-control-feedback (without-errors (reverb-control-feedback)) 'no-such-sound
	'reverb-control-length (without-errors (reverb-control-length)) 'no-such-sound
	'reverb-control-lowpass (without-errors (reverb-control-lowpass)) 'no-such-sound
	'reverb-control-scale (without-errors (reverb-control-scale)) 'no-such-sound
	'reverb-control? (without-errors (reverb-control?)) 'no-such-sound
	'save-state-file (save-state-file) "saved-snd.scm" 
	'show-axes (show-axes) 1
	'show-transform-peaks (show-transform-peaks) #f 
	'show-indices (show-indices) #f
	'show-backtrace (show-backtrace) #f
	'show-marks (show-marks) #t 
	'show-mix-waveforms (show-mix-waveforms) #t
	'show-selection-transform (show-selection-transform) #f 
	'show-y-zero (show-y-zero) #f 
	'show-controls (without-errors (show-controls)) 'no-such-sound
	'sinc-width (sinc-width) 10 
	'spectro-cutoff (spectro-cutoff) 1.0
	'spectro-hop (spectro-hop) 4 
	'spectro-start (spectro-start) 0.0 
	'spectro-x-angle (spectro-x-angle) 90.0 
	'spectro-x-scale (spectro-x-scale) 1.0
	'spectro-y-angle (spectro-y-angle) 0.0 
	'spectro-y-scale (spectro-y-scale) 1.0 
	'spectro-z-angle (spectro-z-angle) -2.0
	'spectro-z-scale (spectro-z-scale) 0.1 
	'speed-control (without-errors (speed-control)) 'no-such-sound
	'speed-control-style (speed-control-style) 0 
	'speed-control-tones (speed-control-tones) 12
	'sync (without-errors (sync)) 'no-such-sound
	'temp-dir (temp-dir) #f 
	'ladspa-dir (ladspa-dir) #f 
	'tiny-font (tiny-font) "6x12"
	'transform-type (transform-type) 0 
	'trap-segfault (trap-segfault) #f
	'use-sinc-interp (use-sinc-interp) #t 
	'verbose-cursor (verbose-cursor) #f
	'vu-font (vu-font) #f 
	'vu-font-size (vu-font-size) 1.0 
	'vu-size (vu-size) 1.0 
	'wavelet-type (wavelet-type) 0 
	'graph-time? (without-errors (graph-time?)) 'no-such-sound
	'time-graph-type (time-graph-type) graph-time-once
	'wavo-hop (wavo-hop) 3 
	'wavo-trace (wavo-trace) 64 
	'x-axis-style (x-axis-style) 0 
	'beats-per-minute (beats-per-minute) 60.0
	'zero-pad (zero-pad) 0
	'zoom-focus-style (zoom-focus-style) 2 
	'mix-waveform-height (mix-waveform-height) 20 
	'mix-tag-width (mix-tag-width) 6
	'mix-tag-height (mix-tag-height) 14
	'audio-output-device (audio-output-device) 0 
	'selected-mix (selected-mix) -1
	))))


;;; headers

;;; ---------------- test 2: headers ----------------
(if (or full-test (= snd-test 2) (and keep-going (<= snd-test 2)))
    (if (string? sf-dir)
	(letrec ((test-headers
		  (lambda (base-files)
		    (if (not (null? base-files))
			(let ((testf (car base-files)))
			  (let ((file (string-append sf-dir (list-ref testf 0))))
			    (if (file-exists? file)
				(begin
				  (IF (not (equal? (mus-sound-chans file) (list-ref testf 1)))
				      (snd-display ";~A: chans ~A /= ~A" 
							 (list-ref testf 0) 
							 (mus-sound-chans file) 
							 (list-ref testf 1)))
				  (IF (not (equal? (mus-sound-srate file) (list-ref testf 2)))
				      (snd-display ";~A: srate ~A /= ~A" 
							 (list-ref testf 0) 
							 (mus-sound-srate file) 
							 (list-ref testf 2)))
				  (IF (fneq (mus-sound-duration file) (list-ref testf 3))
				      (snd-display ";~A: duration ~A /= ~A" 
							 (list-ref testf 0)
							 (mus-sound-duration file) 
							 (list-ref testf 3)))
				  (IF (and (not (= (mus-sound-data-format file) -1))
					   (not (= (mus-sound-header-type file) 33)) ; bogus header on test case
					   (< (+ (mus-sound-length file) 1)
					      (* (mus-sound-datum-size file) (mus-sound-duration file)
						 (mus-sound-srate file) (mus-sound-chans file))))
				      (snd-display ";mus-sound-length ~A: ~A (~A)" file
							   (mus-sound-length file)
							   (* (mus-sound-duration file) (mus-sound-srate file) 
							      (mus-sound-chans file) (mus-sound-datum-size file))))
				  (IF (fneq (/ (mus-sound-frames file) (mus-sound-srate file)) (mus-sound-duration file))
				      (snd-display ";mus-sound-frames ~A: ~A (~A ~A)" file
							   (mus-sound-frames file)
							   (mus-sound-duration file)
							   (/ (mus-sound-frames file) (mus-sound-srate file))))
				  (IF (> (abs (- (mus-sound-frames file) (/ (mus-sound-samples file) (mus-sound-chans file)))) 1)
				      (snd-display ";mus-sound-samples ~A: ~A ~A" file
							   (mus-sound-samples file)
							   (* (mus-sound-frames file) (mus-sound-chans file))))
				  (IF (not (equal? (mus-header-type-name (mus-sound-header-type file)) (list-ref testf 4)))
				      (snd-display ";~A: type ~A /= ~A" 
							 (list-ref testf 0) 
							 (mus-header-type-name (mus-sound-header-type file))
							 (list-ref testf 4)))
				  (IF (not (equal? (mus-data-format-name (mus-sound-data-format file)) (list-ref testf 5)))
				      (snd-display ";~A: type ~A /= ~A"
							 (list-ref testf 0) 
							 (mus-data-format-name (mus-sound-data-format file)) 
							 (list-ref testf 5)))
				  (let ((lst (mus-sound-loop-info file)))
				    (if (> (length testf) 6)
					(begin
					  (IF (not (equal? (car lst) (list-ref testf 6))) 
					      (snd-display ";~A: loop start: ~A" (car lst) (list-ref testf 6)))
					  (IF (not (equal? (cadr lst) (list-ref testf 7))) 
					      (snd-display ";~A: loop end: ~A" (cadr lst) (list-ref testf 7))))
					(if (not (null? lst))
					    (snd-display ";~A thinks it has loop info: ~A" file lst)))))
				(snd-display ";~A missing?" file))
			    (test-headers (cdr base-files))))))))
	  (if (procedure? test-hook) (test-hook 2))
	  (test-headers
	   (list
	    (list "8svx-8.snd" 1 22050 1.88766443729401 "SVX8" "signed byte (8 bits)")
	    (list "Fnonull.aif" 1 8000 0.00112499995157123 "AIFC" "mulaw (8 bits)")
	    (list "Pmiscck.aif" 1 8000 0.00112499995157123 "AIFC" "mulaw (8 bits)")
	    (list "Pmiscck.wav" 1 8000 0.00112499995157123 "RIFF" "mulaw (8 bits)")
	    (list "Pnossnd.aif" 1 8000 0.0 "AIFC" "mulaw (8 bits)")
	    (list "Poffset.aif" 1 8000 0.00112499995157123 "AIFC" "mulaw (8 bits)")
	    (list "Porder.aif" 1 8000 0.00112499995157123 "AIFC" "mulaw (8 bits)")
	    (list "Ptjunk.aif" 1 8000 0.00112499995157123 "AIFC" "mulaw (8 bits)")
	    (list "Ptjunk.wav" 1 8000 0.00112499995157123 "RIFF" "mulaw (8 bits)")
	    (list "SINE24-S.WAV" 2 44100 2.0 "RIFF" "little endian int (24 bits)")
	    (list "a1.asf" 1 16000 0.0 "asf" "unsupported")
	    (list "a2.asf" 1 8000 0.0 "asf" "unsupported")
	    (list "addf8.afsp" 1 8000 2.9760000705719 "Sun" "big endian short (16 bits)")
	    (list "addf8.d" 1 8000 2.9760000705719 "SPPACK" "big endian short (16 bits)")
	    (list "addf8.dwd" 1 8000 2.9760000705719 "DiamondWare" "little endian short (16 bits)")
	    (list "addf8.nh" 2 44100 0.269931972026825 "raw (no header)" "big endian short (16 bits)")
	    (list "addf8.sd" 1 8000 2.9760000705719 "ESPS" "big endian short (16 bits)")
	    (list "addf8.sf_mipseb" 1 8000 2.9760000705719 "IRCAM" "big endian short (16 bits)")
	    (list "addf8.sf_sun" 1 8000 2.9760000705719 "IRCAM" "big endian short (16 bits)")
	    (list "addf8.sf_vax_b" 1 8000 2.9760000705719 "IRCAM" "big endian short (16 bits)")
	    (list "addf8.wav" 1 8000 2.9760000705719 "RIFF" "little endian short (16 bits)")
	    (list "aebass.krz" 1 44100 3.0 "Kurzweil 2000" "big endian short (16 bits)")
	    (list "aiff-16.snd" 2 44100 0.746666669845581 "AIFF" "big endian short (16 bits)")
	    (list "aiff-8.snd" 2 44100 0.746666669845581 "AIFF" "signed byte (8 bits)")
	    (list "alaw.aifc" 1 44100 0.0367800444364548 "AIFC" "alaw (8 bits)")
	    (list "alaw.wav" 1 11025 8.70666694641113 "RIFF" "alaw (8 bits)")
	    (list "astor_basia.mp2" 2 44100 1.02179133892059 "raw (no header)" "big endian short (16 bits)")
	    (list "c.asf" 1 8000 0.0 "asf" "unsupported")
	    (list "ce-c3.w02" 1 33000 3.88848495483398 "TX-16W" "unsupported")
	    (list "ce-c4.w03" 1 33000 2.91618180274963 "TX-16W" "unsupported")
	    (list "ce-d2.w01" 1 33000 3.46439385414124 "TX-16W" "unsupported")
	    (list "clbonef.wav" 1 22050 2.57832193374634 "RIFF" "little endian float (32 bits)")
	    (list "cranker.krz" 1 44100 3.48267579078674 "Kurzweil 2000" "big endian short (16 bits)")
	    (list "d40130.aif" 1 10000 0.100000001490116 "AIFF" "big endian short (16 bits)")
	    (list "d40130.au" 1 10000 0.100000001490116 "Sun" "big endian short (16 bits)")
	    (list "d40130.dsf" 1 8000 0.125 "Delusion" "little endian short (16 bits)")
	    (list "d40130.fsm" 1 8000 0.125249996781349 "Farandole" "little endian short (16 bits)")
	    (list "d40130.iff" 1 10000 0.100000001490116 "SVX8" "signed byte (8 bits)")
	    (list "d40130.pat" 1 10000 0.100000001490116 "Gravis Ultrasound patch" "little endian short (16 bits)")
	    (list "d40130.sds" 1 10000 0.100000001490116 "MIDI sample dump" "unsupported")
	    (list "d40130.sdx" 1 10000 0.100000001490116 "Sample dump" "unsigned little endian short (16 bits)")
	    (list "d40130.sf" 1 10000 0.100000001490116 "IRCAM" "little endian short (16 bits)")
	    (list "d40130.smp" 1 8000 0.125 "SMP" "little endian short (16 bits)")
	    (list "d40130.sou" 1 8000 0.125 "SBStudioII" "little endian short (16 bits)")
	    (list "d40130.st3" 1 8000 0.125 "Digiplayer ST3" "unsigned little endian short (16 bits)")
	    (list "d40130.uwf" 1 8000 0.125249996781349 "Ultratracker" "little endian short (16 bits)")
	    (list "d40130.voc" 1 10000 0.100100003182888 "VOC" "unsigned byte (8 bits)")
	    (list "d40130.w00" 1 16000 0.0625 "TX-16W" "unsupported")
	    (list "d40130.wav" 1 10000 0.100000001490116 "RIFF" "little endian short (16 bits)")
	    (list "d43.wav" 1 10000 0.100000001490116 "RIFF" "little endian short (16 bits)")
	    (list "digit0v0.aiff" 1 8000 0.560000002384186 "AIFC" "big endian short (16 bits)")
	    (list "esps-16.snd" 1 8000 3.09737491607666 "ESPS" "big endian short (16 bits)")
	    (list "forest.aiff" 2 44100 3.907143 "AIFF" "big endian short (16 bits)" 24981 144332)
	    (list "g721.au" 1 11025 4.35328817367554 "Sun" "unsupported")
	    (list "g722.aifc" 1 44100 0.0184353739023209 "AIFC" "unsupported")
	    (list "gong.wve" 1 8000 3.96799993515015 "PSION" "alaw (8 bits)")
	    (list "gsm610.wav" 1 11025 1.7687075138092 "RIFF" "unsupported")
	    (list "inrs-16.snd" 1 8000 2.46399998664856 "INRS" "little endian short (16 bits)")
	    (list "kirk.wve" 1 8000 1.40799999237061 "PSION" "alaw (8 bits)")
	    (list "loop.aiff" 1 44100 0.0367120169103146 "AIFC" "big endian short (16 bits)" 12 23)
	    (list "m.asf" 1 8000 0.0 "asf" "unsupported")
	    (list "mary-sun4.sig" 1 8000 5.95137500762939 "Comdisco SPW signal" "big endian double (64 bits)")
	    (list "mocksong.wav" 1 11025 7.86956930160522 "RIFF" "little endian short (16 bits)")
	    (list "mono24.wav" 1 22050 1.98997735977173 "RIFF" "little endian int (24 bits)")
	    (list "msadpcm.wav" 1 11025 4.43501138687134 "RIFF" "unsupported")
	    (list "n8.snd" 1 44100 0.0367800444364548 "Sun" "signed byte (8 bits)")
	    (list "nasahal.aif" 1 11025 9.89841270446777 "AIFF" "signed byte (8 bits)")
	    (list "nasahal.avi" 1 11025 0.0 "AVI" "unsupported")
	    (list "nasahal.dig" 1 11025 9.89841270446777 "Sound Designer 1" "big endian short (16 bits)")
	    (list "nasahal.ivc" 2 44100 0.449002265930176 "raw (no header)" "big endian short (16 bits)")
	    (list "nasahal.pat" 1 11025 3.95410442352295 "Gravis Ultrasound patch" "unsigned byte (8 bits)")
	    (list "nasahal.snd" 1 11025 9.89841270446777 "SNDT" "unsigned byte (8 bits)")
	    (list "nasahal.svx" 1 11025 9.89841270446777 "SVX8" "signed byte (8 bits)")
	    (list "nasahal.v8" 1 8000 13.6412496566772 "Covox V8" "unsigned byte (8 bits)")
	    (list "nasahal.voc" 1 11025 9.89941024780273 "VOC" "unsigned byte (8 bits)")
	    (list "nasahal.vox" 2 44100 0.224444448947906 "raw (no header)" "big endian short (16 bits)")
	    (list "nasahal8.wav" 1 11025 9.89841270446777 "RIFF" "unsigned byte (8 bits)")
	    (list "nasahalad.smp" 1 11025 4.94920635223389 "Goldwave sample" "little endian short (16 bits)")
	    (list "next-16.snd" 1 22050 1.00004529953003 "Sun" "big endian short (16 bits)")
	    (list "next-8.snd" 1 22050 0.226757362484932 "Sun" "signed byte (8 bits)")
	    (list "next-dbl.snd" 1 22050 0.226757362484932 "Sun" "big endian double (64 bits)")
	    (list "oboe.ldbl" 1 22050 2.30512475967407 "RIFF" "little endian double (64 bits)")
	    (list "next-flt.snd" 1 22050 0.226757362484932 "Sun" "big endian float (32 bits)")
	    (list "next-mulaw.snd" 1 8012 2.03295063972473 "Sun" "mulaw (8 bits)")
	    (list "next24.snd" 1 44100 0.0367800444364548 "Sun" "big endian int (24 bits)")
	    (list "nist-01.wav" 1 16000 2.26912498474121 "NIST" "little endian short (16 bits)")
	    (list "nist-10.wav" 1 16000 2.26912498474121 "NIST" "big endian short (16 bits)")
	    (list "nist-16.snd" 1 16000 1.02400004863739 "NIST" "big endian short (16 bits)")
	    (list "nist-shortpack.wav" 1 16000 4.53824996948242 "NIST" "unsupported")
	    (list "none.aifc" 1 44100 0.0367800444364548 "AIFC" "big endian short (16 bits)")
	    (list "nylon2.wav" 2 22050 1.14376413822174 "RIFF" "unsupported")
	    (list "o2.avr" 1 44100 0.0183900222182274 "AVR" "big endian short (16 bits)")
	    (list "o2.bicsf" 1 44100 0.0367800444364548 "IRCAM" "big endian short (16 bits)")
	    (list "o2.mpeg1" 2 44100 0.00709750549867749 "raw (no header)" "big endian short (16 bits)")
	    (list "o2.sd2" 2 44100 0.0183900222182274 "raw (no header)" "big endian short (16 bits)")
	    (list "o2.sf2" 1 44100 0.0367800444364548 "SoundFont" "little endian short (16 bits)")
	    (list "o2.smp" 1 8000 0.202749997377396 "SMP" "little endian short (16 bits)")
	    (list "o2.voc" 1 44100 0.0368934236466885 "VOC" "little endian short (16 bits)")
	    (list "o2.wave" 1 44100 0.0367800444364548 "RIFF" "little endian short (16 bits)")
	    (list "o2_12bit.aiff" 1 44100 0.0367800444364548 "AIFF" "big endian short (16 bits)")
	    (list "o2_18bit.aiff" 1 44100 0.0367800444364548 "AIFF" "big endian int (24 bits)")
	    (list "o2_711u.wave" 1 44100 0.0367800444364548 "RIFF" "mulaw (8 bits)")
	    (list "o2_722.snd" 1 44100 0.0183900222182274 "Sun" "unsupported")
	    (list "o2_726.aiff" 1 8000 0.0367499999701977 "AIFC" "unsupported")
	    (list "o2_726.snd" 1 44100 0.0230158735066652 "Sun" "unsupported")
	    (list "o2_728.aiff" 1 8000 0.0367499999701977 "AIFC" "unsupported")
	    (list "o2_8.iff" 1 44100 0.0367800444364548 "SVX8" "signed byte (8 bits)")
	    (list "o2_8.voc" 1 44100 0.0370294786989689 "VOC" "unsigned byte (8 bits)")
	    (list "o2_dvi.wave" 1 44100 0.0232199542224407 "RIFF" "unsupported")
	    (list "o2_float.bicsf" 1 44100 0.0367800444364548 "IRCAM" "big endian float (32 bits)")
	    (list "o2_gsm.aiff" 1 8000 0.0367499999701977 "AIFC" "unsupported")
	    (list "o2_u8.avr" 1 44100 0.0367800444364548 "AVR" "unsigned byte (8 bits)")
	    (list "o2_u8.wave" 1 44100 0.0367800444364548 "RIFF" "unsigned byte (8 bits)")
	    (list "oboe.g721" 1 22050 1.15287983417511 "Sun" "unsupported")
	    (list "oboe.g723_24" 1 22050 0.864761888980865 "Sun" "unsupported")
	    (list "oboe.g723_40" 1 22050 1.44126987457275 "Sun" "unsupported")
	    (list "oboe.sf2" 1 22050 2.30512475967407 "SoundFont" "little endian short (16 bits)")
	    (list "oboe.paf" 1 22050 2.305125 "Ensoniq Paris" "big endian short (16 bits)")
	    (list "oboe.smp" 1 22050 2.305125 "snack SMP" "little endian short (16 bits)")
	    (list "oboe.nsp" 1 22050 2.305125 "CSL" "little endian short (16 bits)")
	    (list "oki.snd" 2 44100 0.0041950112208724 "raw (no header)" "big endian short (16 bits)")
	    (list "oki.wav" 1 44100 0.016780 "RIFF" "unsupported")
	    (list "orv-dvi-adpcm.wav" 1 44100 1.92725622653961 "RIFF" "unsupported")
	    (list "riff-16.snd" 1 22050 1.88766443729401 "RIFF" "little endian short (16 bits)")
	    (list "riff-8-u.snd" 1 11025 0.506848096847534 "RIFF" "unsigned byte (8 bits)")
	    (list "rooster.wve" 1 8000 2.04800009727478 "PSION" "alaw (8 bits)")
	    (list "sd1-16.snd" 1 44100 0.400544226169586 "Sound Designer 1" "big endian short (16 bits)")
	    (list "segfault.snd" 16777216 576061440 1.24986669902682e-7 "Sun" "unsupported")
	    (list "sf-16.snd" 1 22050 1.88766443729401 "IRCAM" "big endian short (16 bits)")
	    (list "si654.adc" 1 16000 6.71362495422363 "ADC/OGI" "big endian short (16 bits)")
	    (list "smp-16.snd" 1 8000 5.2028751373291 "SMP" "little endian short (16 bits)")
	    (list "sound.pat" 1 8000 1.95050001144409 "Gravis Ultrasound patch" "unsigned little endian short (16 bits)")
	    (list "sound.sap" 1 8000 1.95050001144409 "Goldwave sample" "little endian short (16 bits)")
	    (list "sound.sds" 1 8000 1.95050001144409 "MIDI sample dump" "unsupported")
	    (list "sound.sfr" 1 8000 1.95050001144409 "SRFS" "little endian short (16 bits)")
	    (list "sound.v8" 1 8000 1.95050001144409 "Covox V8" "unsigned byte (8 bits)")
	    (list "sound.vox" 2 44100 0.044217687100172 "raw (no header)" "big endian short (16 bits)")
	    (list "step.omf" 1 11025 8.70666694641113 "OMF" "signed byte (8 bits)")
	    (list "step.qt" 1 11025 8.70630359649658 "Quicktime" "unsigned byte (8 bits)")
	    (list "sun-16-afsp.snd" 1 8000 2.9760000705719 "Sun" "big endian short (16 bits)")
	    (list "sun-mulaw.snd" 1 8000 4.61950016021729 "Sun" "mulaw (8 bits)")
	    (list "sw1038t_short.wav" 2 8000 6.0 "NIST" "mulaw (8 bits)")
	    (list "swirl.pat" 1 22050 1.0619500875473 "Gravis Ultrasound patch" "unsigned little endian short (16 bits)")
	    (list "sy85.snd" 1 8000 5.05600023269653 "Sy-85" "big endian short (16 bits)")
	    (list "sy99.snd" 1 8000 4.54400014877319 "Sy-99" "big endian short (16 bits)")
	    (list "telephone.wav" 1 16000 2.27881240844727 "NIST" "little endian short (16 bits)")
	    (list "truspech.wav" 1 8000 1.1599999666214 "RIFF" "unsupported")
	    (list "ulaw.aifc" 1 44100 0.0367800444364548 "AIFC" "mulaw (8 bits)")
	    (list "voc-8-u.snd" 1 8000 1.49937498569489 "VOC" "unsigned byte (8 bits)")
	    (list "voxware.wav" 1 8000 0.324000000953674 "RIFF" "unsupported")
	    (list "wd.w00" 1 8000 0.202749997377396 "Sy-99" "big endian short (16 bits)")
	    (list "wd1.smp" 1 8000 0.202749997377396 "SMP" "little endian short (16 bits)")
	    (list "wd1.wav" 1 44100 0.0367800444364548 "RIFF" "little endian short (16 bits)")
	    (list "wheel.mat" 2 44100 0.145646259188652 "raw (no header)" "big endian short (16 bits)")
	    (list "b8.pvf" 1 44100 0.036803 "Portable Voice Format" "signed byte (8 bits)")
	    (list "b16.pvf" 1 44100 0.036803 "Portable Voice Format" "big endian short (16 bits)")
	    (list "b32.pvf" 1 44100 0.036803 "Portable Voice Format" "big endian int (32 bits)")
	    (list "wood.dsf" 1 8000 0.202749997377396 "Delusion" "little endian short (16 bits)")
	    (list "wood.dvi" 1 22100 0.0278733037412167 "RIFF" "unsupported")
	    (list "wood.dwd" 1 22100 0.0733936652541161 "DiamondWare" "signed byte (8 bits)")
	    (list "wood.fsm" 1 8000 0.202999994158745 "Farandole" "little endian short (16 bits)")
	    (list "wood.mad" 1 22100 0.0372398197650909 "RIFF" "unsupported")
	    (list "wood.maud" 1 44100 0.0183900222182274 "MAUD" "big endian short (16 bits)")
	    (list "wood.pat" 1 22100 0.0733936652541161 "Gravis Ultrasound patch" "little endian short (16 bits)")
	    (list "wood.riff" 1 44100 0.0367800444364548 "RIFF" "little endian short (16 bits)")
	    (list "wood.rifx" 1 44100 0.0367800444364548 "RIFF" "big endian short (16 bits)")
	    (list "wood.sds" 1 22100 0.0733936652541161 "MIDI sample dump" "unsupported")
	    (list "wood.sdx" 1 22100 0.0733936652541161 "Sample dump" "unsigned little endian short (16 bits)")
	    (list "wood.sf" 1 44100 0.0367800444364548 "IRCAM" "big endian short (16 bits)")
	    (list "wood.sndr" 2 44100 0.0092290248721838 "raw (no header)" "big endian short (16 bits)")
	    (list "wood.sndt" 1 44100 0.0367800444364548 "SNDT" "unsigned byte (8 bits)")
	    (list "wood.st3" 1 8000 0.202749997377396 "Digiplayer ST3" "unsigned little endian short (16 bits)")
	    (list "wood.uwf" 1 8000 0.202999994158745 "Ultratracker" "little endian short (16 bits)")
	    (list "wood.w00" 1 16000 0.101374998688698 "TX-16W" "unsupported")
	    (list "wood12.aiff" 1 44100 0.0367800444364548 "AIFF" "big endian short (16 bits)")
	    (list "wood16.dwd" 2 44100 0.0367800444364548 "DiamondWare" "little endian short (16 bits)")
	    (list "wood16.wav" 2 44100 0.0367800444364548 "RIFF" "little endian short (16 bits)")
	    (list "wood16.nsp" 2 44100 0.0367800444364548 "CSL" "little endian short (16 bits)")
	    (list "wood16.smp" 2 44100 0.0367800444364548 "snack SMP" "little endian short (16 bits)")
	    (list "wood24.aiff" 1 44100 0.0367800444364548 "AIFF" "big endian int (24 bits)")
	    (list "woodblock.aiff" 1 44100 0.0367800444364548 "AIFF" "big endian short (16 bits)")
	    (list "woodflt.snd" 1 44100 0.0367800444364548 "Sun" "big endian float (32 bits)")
	    (list "RealDrums.sf2" 1 44100 6.39725637435913 "SoundFont" "little endian short (16 bits)")
	    (list "32bit.sf" 1 44100 4.6 "IRCAM" "little endian float (32 bits, unscaled)")
	    (list "PCM_48_8bit_m.w64" 1 48000 0.375 "SoundForge" "unsigned byte (8 bits)")
	    (list "addf8.24we" 1 8000 2.976000 "RIFF" "little endian int (24 bits)")
	    (list "hybrid.snd" 1 44100 4.600000 "BICSF" "big endian float (32 bits)")
	    (list "zulu_a4.w11" 1 33000 1.21987879276276 "TX-16W" "unsupported" 23342 40042)))))
    )


;;; ---------------- test 3: can variables be set/reset ----------------
(if (or full-test (= snd-test 3) (and keep-going (<= snd-test 3)))
    (begin
      (if (procedure? test-hook) (test-hook 3))
      (open-sound "oboe.snd")
      (if (file-exists? "funcs.cl") (load "funcs.cl"))
      (let ((td (temp-dir)))
	(set! (temp-dir) "/hoho/wasup")
	(IF (not (string=? (temp-dir) "/hoho/wasup")) (snd-display ";set temp-dir: ~A?" (temp-dir)))
	(if td 
	    (set! (temp-dir) td)
	    (set! (temp-dir) "")))
      (IF (fneq (sample 1000) 0.0328) (snd-display ";sample: ~A?" (sample 1000)))
      (IF (or (not (hook? output-name-hook)) (not (hook-empty? output-name-hook)))
	  (snd-display ";output-name-hook: ~A?" output-name-hook))
      (IF (or (not (hook? output-comment-hook)) (not (hook-empty? output-comment-hook)))
	  (snd-display ";output-comment-hook: ~A?" output-comment-hook))
      (IF (or (not (hook? mark-drag-hook)) (not (hook-empty? mark-drag-hook)))
	  (snd-display ";mark-drag-hook: ~A?" mark-drag-hook))
      (IF (or (not (hook? mouse-drag-hook)) (not (hook-empty? mouse-drag-hook)))
	  (snd-display ";mouse-drag-hook: ~A?" mouse-drag-hook))
      (IF (or (not (hook? mouse-release-hook)) (not (hook-empty? mouse-release-hook)))
	  (snd-display ";mouse-release-hook: ~A?" mouse-release-hook))
      (IF (or (not (hook? mouse-click-hook)) (not (hook-empty? mouse-click-hook)))
	  (snd-display ";mouse-click-hook: ~A?" mouse-click-hook))
      (IF (or (not (hook? mouse-press-hook)) (not (hook-empty? mouse-press-hook)))
	  (snd-display ";mouse-press-hook: ~A?" mouse-press-hook))
      (IF (or (not (hook? start-playing-hook)) (not (hook-empty? start-playing-hook)))
	  (snd-display ";start-playing-hook: ~A?" start-playing-hook))
      (IF (or (not (hook? stop-playing-hook)) (not (hook-empty? stop-playing-hook)))
	  (snd-display ";stop-playing-hook: ~A?" stop-playing-hook))
      (IF (or (not (hook? key-press-hook)) (not (hook-empty? key-press-hook)))
	  (snd-display ";key-press-hook: ~A?" key-press-hook))
      (IF (or (not (hook? snd-error-hook)) (not (hook-empty? snd-error-hook)))
	  (snd-display ";snd-error-hook: ~A?" snd-error-hook))
      (IF (or (not (hook? snd-warning-hook)) (not (hook-empty? snd-warning-hook)))
	  (snd-display ";snd-warning-hook: ~A?" snd-warning-hook))
      (IF (or (not (hook? name-click-hook)) (not (hook-empty? name-click-hook)))
	  (snd-display ";name-click-hook: ~A?" name-click-hook))
      (IF (or (not (hook? before-apply-hook)) (not (hook-empty? before-apply-hook)))
	  (snd-display ";before-apply-hook: ~A?" before-apply-hook))
      (IF (or (not (hook? after-apply-hook)) (not (hook-empty? after-apply-hook)))
	  (snd-display ";after-apply-hook: ~A?" after-apply-hook))
      (IF (or (not (hook? enved-hook)) (not (hook-empty? enved-hook)))
	  (snd-display ";enved-hook: ~A?" enved-hook))
      (IF (or (not (hook? mouse-enter-label-hook)) (not (hook-empty? mouse-enter-label-hook)))
	  (snd-display ";mouse-enter-label-hook: ~A?" mouse-enter-label-hook))
      (IF (or (not (hook? mouse-enter-graph-hook)) (not (hook-empty? mouse-enter-graph-hook)))
	  (snd-display ";mouse-enter-graph-hook: ~A?" mouse-enter-graph-hook))
      (IF (or (not (hook? mouse-enter-listener-hook)) (not (hook-empty? mouse-enter-listener-hook)))
	  (snd-display ";mouse-enter-listener-hook: ~A?" mouse-enter-listener-hook))
      (IF (or (not (hook? mouse-leave-label-hook)) (not (hook-empty? mouse-leave-label-hook)))
	  (snd-display ";mouse-leave-label-hook: ~A?" mouse-leave-label-hook))
      (IF (or (not (hook? mouse-leave-graph-hook)) (not (hook-empty? mouse-leave-graph-hook)))
	  (snd-display ";mouse-leave-graph-hook: ~A?" mouse-leave-graph-hook))
      (IF (or (not (hook? mouse-leave-listener-hook)) (not (hook-empty? mouse-leave-listener-hook)))
	  (snd-display ";mouse-leave-listener-hook: ~A?" mouse-leave-listener-hook))
      (IF (or (not (hook? property-changed-hook)) (not (hook-empty? property-changed-hook)))
	  (snd-display ";property-changed-hook: ~A?" property-changed-hook))
      (IF (or (not (hook? initial-graph-hook)) (not (hook-empty? initial-graph-hook)))
	  (snd-display ";initial-graph-hook: ~A?" initial-graph-hook))
      (IF (or (not (hook? after-graph-hook)) (not (hook-empty? after-graph-hook)))
	  (snd-display ";after-graph-hook: ~A?" after-graph-hook))
      (IF (or (not (hook? graph-hook)) (not (hook-empty? graph-hook)))
	  (snd-display ";graph-hook: ~A?" graph-hook))

      (set! (show-controls) #t)
      (if (not (provided? 'snd-nogui))
	  (begin
	    (enved-dialog) 
	    (IF (not (list-ref (dialog-widgets) 2)) (snd-display ";enved-dialog?"))
	    (set! (enved-active-env) '(0.0 0.0 1.0 1.0 2.0 0.0))
	    (IF (not (equal? (enved-active-env) (list 0.0 0.0 1.0 1.0 2.0 0.0)))
		(snd-display ";set enved-active-env: ~A?" (enved-active-env)))
	    (orientation-dialog) 
	    (IF (not (list-ref (dialog-widgets) 1)) (snd-display ";orientation-dialog?"))))

      (letrec ((test-vars
		(lambda (lst)
		  (if (not (null? lst))
		      (let ((name (list-ref (car lst) 0))
			    (getfnc (list-ref (car lst) 1))
			    (setfnc (list-ref (car lst) 3))
			    (initval (list-ref (car lst) 2))
			    (newval (list-ref (car lst) 4)))
			
			(setfnc newval)
			(let ((nowval (getfnc)))
			  (if (not (equal? newval nowval))
			      (if (and (number? newval) (inexact? newval))
				  (if (> (abs (- newval nowval)) .01)
				      (snd-display ";~A /= ~A (~A)" name newval nowval))
				  (snd-display ";~A /= ~A (~A)" name newval nowval)))
			  (setfnc initval)
			  (set! (getfnc) newval)
			  (let ((nowval (getfnc)))
			    (if (not (equal? newval nowval))
				(if (and (number? newval) (inexact? newval))
				    (if (> (abs (- newval nowval)) .01)
					(snd-display ";set! ~A /= ~A (~A)" name newval nowval))
				    (snd-display ";set! ~A /= ~A (~A)" name newval nowval)))
			    (setfnc initval))
			  (test-vars (cdr lst))))))))
	(test-vars 
	 (list
	  (list 'amp-control amp-control 1.0 set-amp-control 0.5)
	  (list 'ask-before-overwrite ask-before-overwrite #f set-ask-before-overwrite #t)
	  (list 'audio-state-file audio-state-file ".snd-mixer" set-audio-state-file "not-a-file")
	  (list 'audio-input-device audio-input-device 0 set-audio-input-device 1)
	  (list 'audio-output-device audio-output-device 0 set-audio-output-device 1)
	  (list 'auto-resize auto-resize #t set-auto-resize #f)
	  (list 'auto-update auto-update #f set-auto-update #t)
	  (list 'channel-style channel-style 0 set-channel-style 1)
	  (list 'colormap colormap 2 set-colormap 0)
	  (list 'color-cutoff color-cutoff 0.003 set-color-cutoff 0.01)
	  (list 'color-inverted color-inverted #t set-color-inverted #f)
	  (list 'color-scale color-scale 1.0 set-color-scale 0.5)
	  (list 'contrast-control contrast-control 0.0 set-contrast-control 0.5)
	  (list 'contrast-control-amp contrast-control-amp 1.0 set-contrast-control-amp 0.5)
	  (list 'contrast-control? contrast-control? #f set-contrast-control? #t)
	  (list 'auto-update-interval auto-update-interval 60.0 set-auto-update-interval 120.0)
	  (list 'cursor-follows-play cursor-follows-play #f set-cursor-follows-play #t)
	  (list 'dac-combines-channels dac-combines-channels #t set-dac-combines-channels #f)
	  (list 'dac-size dac-size 256 set-dac-size 512)
	  (list 'minibuffer-history-length minibuffer-history-length 8 set-minibuffer-history-length 16)
	  (list 'data-clipped data-clipped #f set-data-clipped #t)
	  (list 'default-output-chans default-output-chans 1 set-default-output-chans 2)
	  (list 'default-output-format default-output-format 1 set-default-output-format 1)
	  (list 'default-output-srate default-output-srate 22050 set-default-output-srate 44100)
	  (list 'default-output-type default-output-type 0 set-default-output-type 1)
	  (list 'dot-size dot-size 1 set-dot-size 4)
	  (list 'enved-base enved-base 1.0  set-enved-base 1.5)
	  (list 'enved-clip? enved-clip? #f set-enved-clip? #t)
	  (list 'enved-in-dB enved-in-dB #f set-enved-in-dB #t)
	  (list 'enved-exp? enved-exp? #f set-enved-exp? #t)
	  (list 'enved-power enved-power 3.0 set-enved-power 3.5)
	  (list 'enved-target enved-target 0 set-enved-target 1)
	  (list 'enved-wave? enved-wave? #f set-enved-wave? #t)
	  (list 'eps-file eps-file "snd.eps" set-eps-file "snd-1.eps")
	  (list 'eps-left-margin eps-left-margin 0.0 set-eps-left-margin 72.0)
	  (list 'eps-size eps-size 1.0 set-eps-size 2.0)
	  (list 'eps-bottom-margin eps-bottom-margin 0.0 set-eps-bottom-margin 36.0)
	  (list 'expand-control expand-control 1.0 set-expand-control 2.0)
	  (list 'expand-control-hop expand-control-hop 0.05 set-expand-control-hop 0.1)
	  (list 'expand-control-length expand-control-length 0.15 set-expand-control-length 0.2)
	  (list 'expand-control-ramp expand-control-ramp 0.4 set-expand-control-ramp 0.2)
	  (list 'expand-control? expand-control? #f set-expand-control? #t)
	  (list 'fft-window-beta fft-window-beta 0.0  set-fft-window-beta 0.5)
	  (list 'fft-log-frequency fft-log-frequency #f set-fft-log-frequency #t)
	  (list 'fft-log-magnitude fft-log-magnitude #f set-fft-log-magnitude #t)
	  (list 'transform-size transform-size 256 set-transform-size 512)
	  (list 'transform-graph-type transform-graph-type 0 set-transform-graph-type 1)
	  (list 'fft-window fft-window 6 set-fft-window 5)
	  (list 'graph-transform? graph-transform? #f set-graph-transform? #t)
	  (list 'filter-control-in-dB filter-control-in-dB #f set-filter-control-in-dB #t)
	  (list 'filter-control-env filter-control-env (list 0.0 1.0 1.0 1.0) set-filter-control-env (list 0.0 1.0 1.0 0.0))
	  (list 'enved-filter enved-filter #t set-enved-filter #f)
	  (list 'enved-filter-order enved-filter-order 40 set-enved-filter-order 20)
	  (list 'filter-env-in-hz filter-env-in-hz #f set-filter-env-in-hz #t)
	  (list 'filter-control-order filter-control-order 20 set-filter-control-order 40)
	  (list 'filter-control? filter-control? #f set-filter-control? #t)
	  (list 'graph-cursor graph-cursor 34 set-graph-cursor 33)
	  (list 'graph-style graph-style 0 set-graph-style 1)
	  (list 'just-sounds just-sounds #f set-just-sounds #t)
	  (list 'listener-prompt listener-prompt ">" set-listener-prompt ":")
	  (list 'max-transform-peaks max-transform-peaks 100 set-max-transform-peaks 10)
	  (list 'max-regions max-regions 16 set-max-regions 6)
	  (list 'min-dB min-dB -60.0 set-min-dB -90.0)
	  (list 'mix-waveform-height mix-waveform-height 20 set-mix-waveform-height 40)
	  (list 'mix-tag-height mix-tag-height 14 set-mix-tag-height 20)
	  (list 'mix-tag-width mix-tag-width 6 set-mix-tag-width 20)
	  (list 'movies movies #t set-movies #f)
	  (list 'selection-creates-region selection-creates-region #t set-selection-creates-region #f)
	  (list 'transform-normalization transform-normalization normalize-transform-by-channel set-transform-normalization dont-normalize-transform)
	  (list 'previous-files-sort previous-files-sort 0 set-previous-files-sort 1)
	  (list 'print-length print-length 12 set-print-length 16)
	  (list 'recorder-autoload recorder-autoload #f set-recorder-autoload #t)
	  (list 'recorder-out-chans recorder-out-chans 2 set-recorder-out-chans 1)
	  (list 'recorder-buffer-size recorder-buffer-size 4096 set-recorder-buffer-size 256)
	  (list 'recorder-max-duration recorder-max-duration 1000000.0 set-recorder-max-duration 1000.0)
	  (list 'recorder-trigger recorder-trigger 0.0 set-recorder-trigger 0.1)
	  (list 'region-graph-style region-graph-style graph-lines set-region-graph-style graph-lollipops)
	  (list 'reverb-control-decay reverb-control-decay 1.0 set-reverb-control-decay 2.0)
	  (list 'reverb-control-feedback reverb-control-feedback 1.09 set-reverb-control-feedback 1.6)
	  (list 'reverb-control-length reverb-control-length 1.0 set-reverb-control-length 2.0)
	  (list 'reverb-control-lowpass reverb-control-lowpass 0.7 set-reverb-control-lowpass 0.9)
	  (list 'reverb-control-scale reverb-control-scale 0.0 set-reverb-control-scale 0.2)
	  (list 'reverb-control? reverb-control? #f set-reverb-control? #t)
	  (list 'show-axes show-axes 1 set-show-axes 0)
	  (list 'show-transform-peaks show-transform-peaks #f set-show-transform-peaks #t)
	  (list 'show-indices show-indices #f set-show-indices #t)
	  (list 'show-backtrace show-backtrace #f set-show-backtrace #t)
	  (list 'show-marks show-marks #t set-show-marks #f)
	  (list 'show-mix-waveforms show-mix-waveforms #t set-show-mix-waveforms #f)
	  (list 'show-selection-transform show-selection-transform #f set-show-selection-transform #t)
	  (list 'show-y-zero show-y-zero #f set-show-y-zero #t)
	  (list 'sinc-width sinc-width 10 set-sinc-width 40)
	  (list 'spectro-cutoff spectro-cutoff 1.0 set-spectro-cutoff 0.7)
	  (list 'spectro-hop spectro-hop 4 set-spectro-hop 10)
	  (list 'spectro-start spectro-start 0.0 set-spectro-start 0.1)
	  (list 'spectro-x-angle spectro-x-angle 90.0 set-spectro-x-angle 60.0)
	  (list 'spectro-x-scale spectro-x-scale 1.0 set-spectro-x-scale 2.0)
	  (list 'spectro-y-angle spectro-y-angle 0.0 set-spectro-y-angle 60.0)
	  (list 'spectro-y-scale spectro-y-scale 1.0 set-spectro-y-scale 2.0)
	  (list 'spectro-z-angle spectro-z-angle 358.0 set-spectro-z-angle 60.0)
	  (list 'spectro-z-scale spectro-z-scale 0.1 set-spectro-z-scale 0.2)
	  (list 'speed-control speed-control 1.0 set-speed-control 0.5)
	  (list 'speed-control-style speed-control-style 0 set-speed-control-style 1)
	  (list 'speed-control-tones speed-control-tones 12 set-speed-control-tones 18)
	  (list 'sync sync 0 set-sync 1)
	  (list 'tiny-font tiny-font "6x12" set-tiny-font "9x15")
	  (list 'transform-type transform-type 0 set-transform-type 1)
	  (list 'use-sinc-interp use-sinc-interp #t set-use-sinc-interp #f)
	  (list 'verbose-cursor verbose-cursor #f set-verbose-cursor #t)
	  (list 'vu-size vu-size 1.0 set-vu-size 2.0)
	  (list 'vu-font-size vu-font-size 1.0 set-vu-font-size 2.0)
	  (list 'wavelet-type wavelet-type 0 set-wavelet-type 1)
	  (list 'graph-time? graph-time? #f set-graph-time? #t)
	  (list 'time-graph-type time-graph-type graph-time-once set-time-graph-type graph-time-as-wavogram)
	  (list 'wavo-hop wavo-hop 3 set-wavo-hop 6)
	  (list 'wavo-trace wavo-trace 64 set-wavo-trace 128)
	  (list 'with-mix-tags with-mix-tags #t set-with-mix-tags #f)
	  (list 'x-axis-style x-axis-style 0 set-x-axis-style 1)
	  (list 'beats-per-minute beats-per-minute 30.0 set-beats-per-minute 120.0)
	  (list 'zero-pad zero-pad 0 set-zero-pad 1)
	  (list 'zoom-focus-style zoom-focus-style 2 set-zoom-focus-style 1))))
    
      (letrec ((test-bad-args
		(lambda (lst)
		  (if (not (null? lst))
		      (let ((name (list-ref (car lst) 0))
			    (getfnc (list-ref (car lst) 1))
			    (setfnc (list-ref (car lst) 3))
			    (initval (list-ref (car lst) 2))
			    (newvals (list-ref (car lst) 4)))
			(map (lambda (n)
			       (catch #t 
				      (lambda ()
					(setfnc n))
				      (lambda args (car args)))
			       (let ((nowval (getfnc)))
				 (IF (equal? n nowval)
				     (snd-display ";~A = ~A (~A)" name n initval))
				 (setfnc initval)))
			     newvals)
			(test-bad-args (cdr lst)))))))
	(test-bad-args
	 (list
	  (list 'amp-control amp-control 1.0 set-amp-control '(-1.0 123.123))
	  (list 'channel-style channel-style 0 set-channel-style '(32 -1 1.0))
	  (list 'colormap colormap 2 set-colormap '(321 -123))
	  (list 'color-cutoff color-cutoff 0.003 set-color-cutoff '(-1.0 123.123))
	  (list 'color-scale color-scale 1.0 set-color-scale '(-32.0 2000.0))
	  (list 'contrast-control contrast-control 0.0 set-contrast-control '(-123.123 123.123))
	  (list 'dac-size dac-size 256 set-dac-size '(-1 0 -123))
	  (list 'dot-size dot-size 1 set-dot-size '(0 -1 -123))
	  (list 'enved-target enved-target 0 set-enved-target '(123 -321))
	  (list 'expand-control expand-control 1.0 set-expand-control '(-1.0 0.0))
	  (list 'expand-control-hop expand-control-hop 0.05 set-expand-control-hop '(-1.0))
	  (list 'expand-control-length expand-control-length 0.15 set-expand-control-length '(-1.0 0.0))
	  (list 'expand-control-ramp expand-control-ramp 0.4 set-expand-control-ramp '(-1.0 1.0 123.123))
	  (list 'fft-window-beta fft-window-beta 0.0  set-fft-window-beta '(-1.0 123.123))
	  (list 'transform-size transform-size 256 set-transform-size '(-1 0))
	  (list 'zero-pad zero-pad 0 set-zero-pad '(-1 -123))
	  (list 'cursor-style cursor-style cursor-cross set-cursor-style '(-1))
	  (list 'cursor-style cursor-style cursor-line set-cursor-style '(2 123))
	  (list 'transform-graph-type transform-graph-type 0 set-transform-graph-type '(-1 123))
	  (list 'fft-window fft-window 6 set-fft-window '(-1 123))
	  (list 'enved-filter-order enved-filter-order 40 set-enved-filter-order '(-1 0))
	  (list 'filter-control-order filter-control-order 20 set-filter-control-order '(-10 -1 0))
	  (list 'max-transform-peaks max-transform-peaks 100 set-max-transform-peaks '(-1))
	  (list 'max-regions max-regions 16 set-max-regions '(-1 -123))
	  (list 'previous-files-sort previous-files-sort 0 set-previous-files-sort '(-1 123))
	  (list 'reverb-control-length reverb-control-length 1.0 set-reverb-control-length '(-1.0))
	  (list 'show-axes show-axes 1 set-show-axes '(-1 123))
	  (list 'sinc-width sinc-width 10 set-sinc-width '(-10))
	  (list 'spectro-cutoff spectro-cutoff 1.0 set-spectro-cutoff '(-1.0))
	  (list 'spectro-hop spectro-hop 4 set-spectro-hop '(-10 -1 0))
	  (list 'spectro-start spectro-start 0.0 set-spectro-start '(-1.0))
	  (list 'speed-control speed-control 1.0 set-speed-control '(0.0))
	  (list 'speed-control-style speed-control-style 0 set-speed-control-style '(-1 10))
	  (list 'transform-type transform-type 0 set-transform-type '(-1 123))
	  (list 'wavelet-type wavelet-type 0 set-wavelet-type '(-1 123))
	  (list 'wavo-hop wavo-hop 1 set-wavo-hop '(0 -123))
	  (list 'wavo-trace wavo-trace 1 set-wavo-trace '(0 -123))
	  (list 'x-axis-style x-axis-style 0 set-x-axis-style '(-1 123))
	  (list 'zoom-focus-style zoom-focus-style 2 set-zoom-focus-style '(-1 123)))))

      (set! (window-width) 300)
      (set! (window-height) 300)
      (IF (not (equal? (window-width) 300))
	  (snd-display ";window width: ~A /= 300?" (window-width)))
      (IF (not (equal? (window-height) 300))
	  (snd-display ";window height: ~A /= 300?" (window-height)))
      (set! (window-x) 123)
      (set! (window-y) 321)
      (IF (not (equal? (window-x) 123))
	  (snd-display ";window x: ~A /= 123?" (window-x)))
      (IF (not (equal? (window-y) 321))
	  (snd-display ";window y: ~A /= 321?" (window-y)))
      (set! (window-y) 10) ; get it back out of harm's way
      (set! (vu-font) "8x15")
      (set! (color-scale) 100.0)
      (IF (fneq (color-scale) 100.0) (snd-display ";color-scale to 100: ~A" (color-scale)))

      (close-sound 0) 
      (dismiss-all-dialogs)
      ))

(define play-sound
  (lambda (file)
    (let* ((sound-fd (mus-sound-open-input file))
           (chans (mus-sound-chans file))
           (frames (mus-sound-frames file))
           (bufsize 256)
           (data (make-sound-data chans bufsize))
           (bytes (* bufsize chans 2)))
      (mus-sound-read sound-fd 0 (1- bufsize) chans data)
      (catch 'mus-error
	     (lambda ()
	       (let ((audio-fd (mus-audio-open-output mus-audio-default (mus-sound-srate file) chans mus-lshort bytes)))
		 (if (= audio-fd -1)
		     (set! audio-fd (mus-audio-open-output mus-audio-default (mus-sound-srate file) chans mus-bshort bytes)))
		 (if (= audio-fd -1)
		     (snd-display ";can't play ~A" file)
		     (begin
		       (do ((i 0 (+ i bufsize)))
			   ((>= i frames))
			 (mus-audio-write audio-fd data bufsize)
			 (mus-sound-read sound-fd 0 (1- bufsize) chans data))
		       (mus-audio-close audio-fd)))))
	     (lambda args "can't open audio"))
      (mus-sound-close-input sound-fd))))


;;; ---------------- test 4: sndlib tests ----------------

(define (frame->byte file frame)
  (+ (mus-sound-data-location file)
     (* (mus-sound-chans file)
	(mus-sound-datum-size file)
	frame)))

(define (show-input-1 . arg)
  ;; from rtio.scm
  (define (card+device card device)
    (logior (ash card 16) device))
  (let* ((our-short (if (little-endian?) mus-lshort mus-bshort))
	 (our-srate 22050)
	 (our-dac-buffer-size-in-bytes 512)
	 (our-dac-buffer-size-in-shorts 256)
	 (our-chans 1)
	 (our-chan 0)
	 (our-default-card-number 0)
	 (in-sys (if (not (null? arg)) 
		     (car arg) 
		     our-default-card-number))
	 (in-port (catch 'mus-error
			 (lambda ()
			   (mus-audio-open-input 
			    (card+device in-sys mus-audio-default) 
			    our-srate our-chans our-short our-dac-buffer-size-in-bytes))
			 (lambda args -1)))
	 (data (make-sound-data our-chans our-dac-buffer-size-in-shorts))
    	 (vobj (make-vct our-dac-buffer-size-in-shorts)))
    (if (= in-port -1)
	(snd-display "can't open audio input port!")
	(begin
	  (do ((i 0 (1+ i)))
	      ((= i 10))
	    (mus-audio-read in-port data our-dac-buffer-size-in-shorts)
	    (graph (sound-data->vct data our-chan vobj)))
	  (mus-audio-close in-port)))))

(if (or full-test (= snd-test 4) (and keep-going (<= snd-test 4)))
    (begin
      (if (procedure? test-hook) (test-hook 4))
      (do ((clmtest 0 (1+ clmtest))) ((= clmtest tests)) (if (> tests 1) (snd-display ";test ~D " clmtest))
    (let ((chns (mus-sound-chans "oboe.snd"))
	  (dl (mus-sound-data-location "oboe.snd"))
	  (fr (mus-sound-frames "oboe.snd"))
	  (smps (mus-sound-samples "oboe.snd"))
	  (len (mus-sound-length "oboe.snd"))
	  (size (mus-sound-datum-size "oboe.snd"))
	  (com (mus-sound-comment "oboe.snd"))
	  (sr (mus-sound-srate "oboe.snd"))
	  (m1 (mus-sound-maxamp-exists? "oboe.snd"))
	  (mal (mus-sound-maxamp "oboe.snd"))
	  (bytes (mus-data-format-bytes-per-sample (mus-sound-data-format "oboe.snd")))
	  (sys (mus-audio-systems)))
      (mus-sound-report-cache "hiho.tmp")
      (if (defined? 'read-line)
	  (let ((p (open-input-file "hiho.tmp")))
	    (if (not p)
		(snd-display ";mus-sound-report-cache->hiho.tmp failed?")
		(let ((line (read-line p)))
		  (if (or (not (string? line))
			  (not (string=? "sound table:")))
		      (snd-display ";print-cache 1: ~A?" line))
		  (close-port p)
		  (delete-file "hiho.tmp")))))
      (IF (< (string-length (mus-audio-report)) 10)
	  (snd-display ";mus-audio-report: ~A" (mus-audio-report)))
      (IF (and (not (= sys 1)) (not (= sys 2))) (snd-display ";mus-audio-systems: ~A?" sys))
      (IF (not (= chns 1)) (snd-display ";oboe: mus-sound-chans ~D?" chns))
      (IF (not (= dl 28)) (snd-display ";oboe: mus-sound-data-location ~D?" dl))
      (IF (not (= fr 50828)) (snd-display ";oboe: mus-sound-frames ~D?" fr))
      (IF (not (= smps 50828)) (snd-display ";oboe: mus-sound-samples ~D?" smps))
      (IF (not (= len (+ 28 (* 2 50828)))) (snd-display ";oboe: mus-sound-length ~D?" len))
      (IF (not (= size 2)) (snd-display ";oboe: mus-sound-datum-size ~D?" size))
      (IF (not (= bytes 2)) (snd-display ";oboe: sound-bytes ~D?" bytes))
      (IF (not (= sr 22050)) (snd-display ";oboe: mus-sound-srate ~D?" sr))
      (IF (and m1 (= clmtest 0)) (snd-display ";oboe: mus-sound-maxamp-exists before maxamp: ~A" m1))
      (IF (not (mus-sound-maxamp-exists? "oboe.snd")) 
	  (snd-display ";oboe: mus-sound-maxamp-exists after maxamp: ~A" (mus-sound-maxamp-exists? "oboe.snd")))

      (let ((str (strftime "%d-%b %H:%M %Z" (localtime (mus-sound-write-date "oboe.snd")))))
	(IF (not (string=? str "03-Feb 13:25 PST"))
	    (snd-display ";mus-sound-write-date oboe.snd: ~A?" str)))
      (let ((str (strftime "%d-%b %H:%M %Z" (localtime (mus-sound-write-date "pistol.snd")))))
	(IF (not (string=? str "30-Dec 12:04 PST"))
	    (snd-display ";mus-sound-write-date pistol.snd: ~A?" str)))

      (let* ((fsnd (string-append sf-dir "forest.aiff")))
	(if (file-exists? fsnd)
	    (begin
	      (system (format #f "cp ~A fmv.snd" fsnd))
	      (let ((index (open-sound "fmv.snd")))
		(IF (not (equal? (sound-loop-info index) (mus-sound-loop-info fsnd)))
		    (snd-display ";loop-info: ~A ~A" (sound-loop-info index) (mus-sound-loop-info fsnd)))
		(set! (sound-loop-info index) (list 12000 14000 1 2 3 4))
		(IF (not (equal? (sound-loop-info index) (list 12000 14000 1 2 3 4 1 1)))
		    (snd-display ";set loop-info: ~A" (sound-loop-info index)))
		(save-sound-as "fmv1.snd" index mus-aifc)
		(close-sound index)
		(IF (not (equal? (mus-sound-loop-info "fmv1.snd") (list 12000 14000 1 2 3 4 1 1)))
		    (snd-display ";saved loop-info: ~A" (mus-sound-loop-info "fmv1.snd"))))))
	(let ((index (open-sound "oboe.snd")))
	  (save-sound-as "fmv.snd" index mus-aifc)
	  (close-sound index))
	(let ((index (open-sound "fmv.snd")))
	  (IF (not (equal? (sound-loop-info index) '()))
	      (snd-display ";null loop-info: ~A" (sound-loop-info index)))
	  (set! (sound-loop-info index) (list 1200 1400 4 3 2 1))
	  (IF (not (equal? (sound-loop-info index) (list 1200 1400 4 3 2 1 1 1)))
	      (snd-display ";set null loop-info: ~A" (sound-loop-info index)))
	  (save-sound-as "fmv1.snd" index mus-aifc)
	  (close-sound index)
	  (IF (not (equal? (mus-sound-loop-info "fmv1.snd") (list 1200 1400 4 3 2 1 1 1)))
	      (snd-display ";saved null loop-info: ~A" (mus-sound-loop-info "fmv1.snd")))))

      (if com (snd-display ";oboe: mus-sound-comment ~A?" com))
      (let ((fsnd (string-append sf-dir "nasahal8.wav")))
	(if (file-exists? fsnd)
	    (begin
	      (set! com (mus-sound-comment fsnd))
	      (IF (or (not (string? com)) (not (string=? com "ICRD: 1997-02-22\nIENG: Paul R. Roger\nISFT: Sound Forge 4.0\n")))
		  (snd-display ";mus-sound-comment \"nasahal8.wav\") -> ~A?" com)))))
      (let ((fsnd (string-append sf-dir "8svx-8.snd")))
	(if (file-exists? fsnd)
	    (begin
	      (set! com (mus-sound-comment fsnd))
	      (IF (or (not (string? com)) (not (string=? com "File created by Sound Exchange  ")))
		  (snd-display ";mus-sound-comment \"8svx-8.snd\") -> ~A?" com)))))
      (let ((fsnd (string-append sf-dir "sun-16-afsp.snd")))
	(if (file-exists? fsnd)
	    (begin
	      (set! com (mus-sound-comment fsnd))
	      (IF (or (not (string? com)) (not (string=? com "AFspdate:1981/02/11 23:03:34 UTC")))
		  (snd-display ";mus-sound-comment \"sun-16-afsp.snd\") -> ~A?" com)))))
      (let ((fsnd (string-append sf-dir "smp-16.snd")))
	(if (file-exists? fsnd)
	    (begin
	      (set! com (mus-sound-comment fsnd))
	      (IF (or (not (string? com)) (not (string=? com "Converted using Sox.                                        ")))
		  (snd-display ";mus-sound-comment \"smp-16.snd\") -> ~A?" com)))))
      (let ((fsnd (string-append sf-dir "d40130.au")))
	(if (file-exists? fsnd)
	    (begin
	      (set! com (mus-sound-comment fsnd))
	      (IF (or (not (string? com)) (not (string=? com "1994 Jesus Villena")))
		  (snd-display ";mus-sound-comment \"d40130.au\") -> ~A?" com)))))
      (let ((fsnd (string-append sf-dir "wood.maud")))
	(if (file-exists? fsnd)
	    (begin
	      (set! com (mus-sound-comment fsnd))
	      (IF (or (not (string? com)) (not (string=? com "file written by SOX MAUD-export ")))
		  (snd-display ";mus-sound-comment \"wood.maud\") -> ~A?" com)))))
      (let ((fsnd (string-append sf-dir "addf8.sf_mipseb")))
	(if (file-exists? fsnd)
	    (begin
	      (set! com (mus-sound-comment fsnd))
	      (IF (or (not (string? com)) 
		      (not (string=? com "date=\"Feb 11 18:03:34 1981\" info=\"Original recorded at 20 kHz, 15-bit D/A, digitally filtered and resampled\" speaker=\"AMK female\" text=\"Add the sum to the product of these three.\" ")))
		  (snd-display ";mus-sound-comment \"addf8.sf_mipseb\") -> ~A?" com)))))
      (let ((fsnd (string-append sf-dir "mary-sun4.sig")))
	(if (file-exists? fsnd)
	    (begin
	      (set! com (mus-sound-comment fsnd))
	      (IF (or (not (string? com)) (not (string=? com "MARY HAD A LITTLE LAMB\n")))
		  (snd-display ";mus-sound-comment \"mary-sun4.sig\") -> ~A?" com)))))
      (let ((fsnd (string-append sf-dir "nasahal.pat")))
	(if (file-exists? fsnd)
	    (begin
	      (set! com (mus-sound-comment fsnd))
	      (IF (or (not (string? com)) (not (string=? com "This patch saved with Sound Forge 3.0.")))
		  (snd-display ";mus-sound-comment \"nasahal.pat\") -> ~A?" com)))))
      (let ((fsnd (string-append sf-dir "next-16.snd")))
	(if (file-exists? fsnd)
	    (begin
	      (set! com (mus-sound-comment fsnd))
	      (IF (or (not (string? com)) 
		      (not (string=? com ";Written on Mon 1-Jul-91 at 12:10 PDT  at localhost (NeXT) using Allegro CL and clm of 25-June-91")))
		  (snd-display ";mus-sound-comment \"next-16.snd\") -> ~A?" com)))))
      (let ((fsnd (string-append sf-dir "wood16.nsp")))
	(if (file-exists? fsnd)
	    (begin
	      (set! com (mus-sound-comment fsnd))
	      (IF (or (not (string? com)) (not (string=? com "Created by Snack   ")))
		  (snd-display ";mus-sound-comment \"wood16.nsp\") -> ~A?" com)))))
      (let ((fsnd (string-append sf-dir "wood.sdx")))
	(if (file-exists? fsnd)
	    (begin
	      (set! com (mus-sound-comment fsnd))
	      (IF (or (not (string? com)) (not (string=? com "1994 Jesus Villena")))
		  (snd-display ";mus-sound-comment \"wood.sdx\") -> ~A?" com)))))
      (let ((fsnd (string-append sf-dir "clmcom.aif")))
	(if (file-exists? fsnd)
	    (begin
	      (set! com (mus-sound-comment fsnd))
	      (IF (or (not (string? com)) (not (string=? com "this is a comment")))
		  (snd-display ";mus-sound-comment \"clmcom.aif\") -> ~A?" com)))))
      (let ((fsnd (string-append sf-dir "anno.aif")))
	(if (file-exists? fsnd)
	    (begin
	      (set! com (mus-sound-comment fsnd))
	      (IF (or (not (string? com)) (not (string=? com "1994 Jesus Villena\n")))
		  (snd-display ";mus-sound-comment \"anno.aif\") -> ~A?" com)))))
      (let ((fsnd (string-append sf-dir "telephone.wav")))
	(if (file-exists? fsnd)
	    (begin
	      (set! com (mus-sound-comment fsnd))
	      (IF (or (not (string? com)) 
		      (not (string=? com "sample_byte_format -s2 01\nchannel_count -i 1\nsample_count -i 36461\nsample_rate -i 16000\nsample_n_bytes -i 2\nsample_sig_bits -i 16\n")))
		  (snd-display ";mus-sound-comment \"telephone.wav\") -> ~A?" com)))))
      
      (IF (fneq (cadr mal) .14724) (snd-display ";oboe: mus-sound-maxamp ~F?" (cadr mal)))
      (IF (not (= (car mal) 24971)) (snd-display ";oboe: mus-sound-maxamp at ~D?" (car mal)))
      (mus-sound-set-maxamp "oboe.snd" (list 1234 .5))
      (set! mal (mus-sound-maxamp "oboe.snd"))
      (IF (fneq (cadr mal) .5) (snd-display ";oboe: mus-sound-set-maxamp ~F?" (cadr mal)))
      (IF (not (= (car mal) 1234)) (snd-display ";oboe: mus-sound-set-maxamp at ~D?" (car mal)))
      (set! mal (mus-sound-maxamp "4.aiff"))
      (IF (not (feql mal (list 810071 0.245 810071 0.490 810071 0.735 810071 0.980)))
	  (snd-display ";mus-sound-maxamp 4.aiff: ~A?" mal))
      (mus-sound-set-maxamp "4.aiff" (list 12345 .5 54321 .2 0 .1 9999 .01))
      (set! mal (mus-sound-maxamp "4.aiff"))
      (IF (not (feql mal (list 12345 .5 54321 .2 0 .1 9999 .01)))
	  (snd-display ";mus-sound-set-maxamp 4.aiff: ~A?" mal))
      (let ((var (catch #t (lambda () (mus-sound-set-maxamp "oboe.snd" (list 1234))) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";mus-sound-set-maxamp bad arg: ~A" var)))
      (IF (and (not (= (mus-sound-type-specifier "oboe.snd") #x646e732e))  ;little endian reader
	       (not (= (mus-sound-type-specifier "oboe.snd") #x2e736e64))) ;big endian reader
	  (snd-display ";oboe: mus-sound-type-specifier: ~X?" (mus-sound-type-specifier "oboe.snd")))
      (IF (not (string=? (strftime "%d-%b-%Y %H:%M" (localtime (file-write-date "oboe.snd"))) "03-Feb-2002 13:25"))
	  (snd-display ";oboe: file-write-date: ~A?" (strftime "%d-%b-%Y %H:%M" (localtime (file-write-date "oboe.snd")))))
      (play-sound "oboe.snd")

      (set! (transform-normalization) dont-normalize-transform)
      (IF (not (= (transform-normalization) dont-normalize-transform))
	  (snd-display ";set-transform-normalization none -> ~A" (transform-normalization)))
      (set! (transform-normalization) normalize-transform-globally)
      (IF (not (= (transform-normalization) normalize-transform-globally))
	  (snd-display ";set-transform-normalization globally -> ~A" (transform-normalization)))
      (set! (transform-normalization) normalize-transform-by-channel)
      (IF (not (= (transform-normalization) normalize-transform-by-channel))
	  (snd-display ";set-transform-normalization channel -> ~A" (transform-normalization)))

      (let* ((ob (view-sound "oboe.snd"))
	     (samp (sample 1000 ob))
	     (old-comment (mus-sound-comment "oboe.snd"))
	     (str (string-append "written " 
				 (strftime "%a %d-%b-%Y %H:%M %Z" 
					   (localtime (current-time))))))
	(set! (comment ob) str)
	(save-sound-as "test.snd" ob mus-aifc)
	(set! (transform-normalization ob 0) #t)
	(IF (not (= (transform-normalization ob 0) normalize-transform-by-channel))
	    (snd-display ";set-transform-normalization #t -> ~A" (transform-normalization ob 0)))
	(set! (transform-normalization ob 0) #f)
	(IF (not (= (transform-normalization ob 0) dont-normalize-transform))
	    (snd-display ";set-transform-normalization #f -> ~A" (transform-normalization ob 0)))
	(set! (filter-env-in-hz) #t)
	(let ((ab (open-sound "test.snd")))
	  (IF (not (= (header-type ab) mus-aifc)) 
	      (snd-display ";save-as aifc -> ~A?" (mus-header-type-name (header-type ab))))
	  (IF (not (= (mus-sound-header-type "test.snd") mus-aifc)) 
	      (snd-display ";saved-as aifc -> ~A?" (mus-header-type-name (mus-sound-header-type "test.snd"))))
	  (IF (fneq (sample 1000 ab) samp) (snd-display ";aifc[1000] = ~A?" (sample 1000 ab)))
	  (IF (not (string=? (mus-sound-comment "test.snd") str))
	      (snd-display ";output-comment: ~A ~A" (mus-sound-comment "test.snd") str))
	  (IF (or (not (string? (comment ab)))
		  (not (string=? (comment ab) str)))
	      (snd-display ";output-comment (comment): ~A ~A" (comment ab) str))
	  (close-sound ab))
	(IF (not (equal? old-comment (mus-sound-comment "oboe.snd")))
	    (snd-display ";set-comment overwrote current ~A ~A" old-comment (mus-sound-comment "oboe.snd")))
	(set! (filter-env-in-hz) #f)
	(save-sound-as "test.snd" ob mus-raw)
	(let ((ab (open-raw-sound "test.snd" 1 22050 mus-bshort)))
	  (IF (not (= (header-type ab) mus-raw)) 
	      (snd-display ";save-as raw -> ~A?" (mus-header-type-name (header-type ab))))
	  (IF (not (= (mus-sound-header-type "test.snd") mus-raw)) 
	      (snd-display ";saved-as raw -> ~A?" (mus-header-type-name (mus-sound-header-type "test.snd"))))
	  (IF (fneq (sample 1000 ab) samp) (snd-display ";raw[1000] = ~A?" (sample 1000 ab)))
	  (close-sound ab))
	(save-sound-as "test.snd" ob mus-nist mus-bint)
	(let ((ab (open-sound "test.snd")))
	  (IF (not (= (header-type ab) mus-nist)) 
	      (snd-display ";save-as nist -> ~A?" (mus-header-type-name (header-type ab))))
	  (IF (not (= (mus-sound-header-type "test.snd") mus-nist)) 
	      (snd-display ";saved-as nist -> ~A?" (mus-header-type-name (mus-sound-header-type "test.snd"))))
	  (IF (not (= (data-format ab) mus-bint)) 
	      (snd-display ";save-as int -> ~A?" (mus-data-format-name (data-format ab))))
	  (IF (not (= (mus-sound-data-format "test.snd") mus-bint)) 
	      (snd-display ";saved-as int -> ~A?" (mus-data-format-name (mus-sound-data-format "test.snd"))))
	  (IF (fneq (sample 1000 ab) samp) (snd-display ";nist[1000] = ~A?" (sample 1000 ab)))
	  (close-sound ab))
	(add-hook! output-comment-hook
		   (lambda (str) 
		     (string-append "written " (strftime "%a %d-%b-%Y %H:%M %Z" (localtime (current-time))))))
	(save-sound-as "test.snd" ob mus-riff mus-lfloat)
	(reset-hook! output-comment-hook)
	(let ((ab (open-sound "test.snd")))
	  (IF (not (= (header-type ab) mus-riff)) 
	      (snd-display ";save-as riff -> ~A?" (mus-header-type-name (header-type ab))))
	  (IF (not (= (mus-sound-header-type "test.snd") mus-riff)) 
	      (snd-display ";saved-as riff -> ~A?" (mus-header-type-name (mus-sound-header-type "test.snd"))))
	  (IF (not (= (data-format ab) mus-lfloat)) 
	      (snd-display ";save-as float -> ~A?" (mus-data-format-name (data-format ab))))
	  (IF (not (= (mus-sound-data-format "test.snd") mus-lfloat)) 
	      (snd-display ";saved-as float -> ~A?" (mus-data-format-name (mus-sound-data-format "test.snd"))))
	  (IF (fneq (sample 1000 ab) samp) (snd-display ";riff[1000] = ~A?" (sample 1000 ab)))
	  (IF (not (string=? (mus-sound-comment "test.snd") str))
	      (snd-display ";output-comment 2: ~A ~A" (mus-sound-comment "test.snd") str))
	  (IF (or (not (string? (comment ab)))
		  (not (string=? (comment ab) (string-append "written " (strftime "%a %d-%b-%Y %H:%M %Z" (localtime (current-time)))))))
	      (snd-display ";output-comment-hook: ~A" (comment ab)))
	  (close-sound ab))
	(save-sound-as "test.snd" ob mus-aiff mus-b24int)
	(let ((ab (open-sound "test.snd")))
	  (IF (not (= (header-type ab) mus-aiff)) 
	      (snd-display ";save-as aiff -> ~A?" (mus-header-type-name (header-type ab))))
	  (IF (not (= (mus-sound-header-type "test.snd") mus-aiff)) 
	      (snd-display ";saved-as aiff -> ~A?" (mus-header-type-name (mus-sound-header-type "test.snd"))))
	  (IF (not (= (data-format ab) mus-b24int))
	      (snd-display ";save-as 24-bit -> ~A?" (mus-data-format-name (data-format ab))))
	  (IF (not (= (mus-sound-data-format "test.snd") mus-b24int))
	      (snd-display ";saved-as 24-bit -> ~A?" (mus-data-format-name (mus-sound-data-format "test.snd"))))
	  (IF (fneq (sample 1000 ab) samp) (snd-display ";aiff[1000] = ~A?" (sample 1000 ab)))
	  (close-sound ab))
	(save-sound-as "test.snd" ob mus-ircam mus-mulaw)
	(let ((ab (open-sound "test.snd")))
	  (IF (not (= (header-type ab) mus-ircam)) 
	      (snd-display ";save-as ircam -> ~A?" (mus-header-type-name (header-type ab))))
	  (IF (not (= (mus-sound-header-type "test.snd") mus-ircam)) 
	      (snd-display ";saved-as ircam -> ~A?" (mus-header-type-name (mus-sound-header-type "test.snd"))))
	  (IF (not (= (data-format ab) mus-mulaw))
	      (snd-display ";save-as mulaw -> ~A?" (mus-data-format-name (data-format ab))))
	  (IF (not (= (mus-sound-data-format "test.snd") mus-mulaw))
	      (snd-display ";saved-as mulaw -> ~A?" (mus-data-format-name (mus-sound-data-format "test.snd"))))
	  (IF (fneq (sample 1000 ab) samp) (snd-display ";ircam[1000] = ~A?" (sample 1000 ab)))
	  (close-sound ab))
	(save-sound-as "test.snd" ob mus-next mus-alaw)
	(let ((ab (open-sound "test.snd")))
	  (IF (not (= (header-type ab) mus-next)) 
	      (snd-display ";save-as next -> ~A?" (mus-header-type-name (header-type ab))))
	  (IF (not (= (mus-sound-header-type "test.snd") mus-next)) 
	      (snd-display ";saved-as next -> ~A?" (mus-header-type-name (mus-sound-header-type "test.snd"))))
	  (IF (not (= (data-format ab) mus-alaw)) 
	      (snd-display ";save-as alaw -> ~A?" (mus-data-format-name (data-format ab))))
	  (IF (not (= (mus-sound-data-format "test.snd") mus-alaw)) 
	      (snd-display ";saved-as alaw -> ~A?" (mus-data-format-name (mus-sound-data-format "test.snd"))))
	  (IF (fneq (sample 1000 ab) samp) (snd-display ";next (alaw)[1000] = ~A?" (sample 1000 ab)))
	  (close-sound ab))
	(save-sound-as "test.snd" ob mus-next mus-bdouble)
	(let ((ab (open-sound "test.snd")))
	  (IF (not (= (header-type ab) mus-next)) 
	      (snd-display ";save-as dbl next -> ~A?" (mus-header-type-name (header-type ab))))
	  (IF (not (= (data-format ab) mus-bdouble)) 
	      (snd-display ";save-as dbl -> ~A?" (mus-data-format-name (data-format ab))))
	  (IF (fneq (sample 1000 ab) samp) (snd-display ";next (dbl)[1000] = ~A?" (sample 1000 ab)))
	  (close-sound ab))
	(save-sound-as "test.snd" ob mus-next mus-bshort)
	(let ((ab (open-sound "test.snd")))
	  (IF (not (= (header-type ab) mus-next)) 
	      (snd-display ";save-as next -> ~A?" (mus-header-type-name (header-type ab))))
	  (IF (not (= (mus-sound-header-type "test.snd") mus-next)) 
	      (snd-display ";saved-as next -> ~A?" (mus-header-type-name (mus-sound-header-type "test.snd"))))
	  (IF (not (= (data-format ab) mus-bshort)) 
	      (snd-display ";save-as short -> ~A?" (mus-data-format-name (data-format ab))))
	  (IF (not (= (mus-sound-data-format "test.snd") mus-bshort)) 
	      (snd-display ";saved-as short -> ~A?" (mus-data-format-name (mus-sound-data-format "test.snd"))))
	  (IF (fneq (sample 1000 ab) samp) (snd-display ";next (short)[1000] = ~A?" (sample 1000 ab)))
	  (set! (y-bounds ab 0) (list -3.0 3.0))
	  (set! (data-format ab) mus-lshort)
	  (IF (not (= ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd"))) ; these set!'s can change the index via update-sound
	  (IF (not (= (data-format ab) mus-lshort)) (snd-display ";set data-format: ~A?" (mus-data-format-name (data-format ab))))
	  (IF (not (equal? (y-bounds ab 0) (list -3.0 3.0))) (snd-display ";set data format y-bounds: ~A?" (y-bounds ab 0)))
	  (set! (y-bounds ab 0) (list 2.0))
	  (IF (not (equal? (y-bounds ab 0) (list -2.0 2.0))) (snd-display ";set data format y-bounds 1: ~A?" (y-bounds ab 0)))
	  (set! (header-type ab) mus-aifc)
	  (IF (not (= ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	  (IF (not (= (header-type ab) mus-aifc)) (snd-display ";set header-type: ~A?" (mus-header-type-name (header-type ab))))
	  (set! (channels ab) 3)
	  (IF (not (= ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	  (IF (not (= (channels ab) 3)) (snd-display ";set chans: ~A?" (channels ab)))
	  (set! (data-location ab) 1234)
	  (IF (not (= ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	  (IF (not (= (data-location ab) 1234)) (snd-display ";set data-location: ~A?" (data-location ab)))
	  (set! (srate ab) 12345)
	  (IF (not (= ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	  (IF (not (= (srate ab) 12345)) (snd-display ";set srate: ~A?" (srate ab)))
	  (close-sound ab))
	(save-sound-as "test.snd" ob mus-next mus-bfloat)
	(let ((ab (open-sound "test.snd")))
	  (IF (not (= (header-type ab) mus-next)) 
	      (snd-display ";save-as next -> ~A?" (mus-header-type-name (header-type ab))))
	  (IF (not (= (mus-sound-header-type "test.snd") mus-next)) 
	      (snd-display ";saved-as next -> ~A?" (mus-header-type-name (mus-sound-header-type "test.snd"))))
	  (IF (not (= (data-format ab) mus-bfloat)) 
	      (snd-display ";save-as float -> ~A?" (mus-data-format-name (data-format ab))))
	  (IF (not (= (mus-sound-data-format "test.snd") mus-bfloat)) 
	      (snd-display ";saved-as float -> ~A?" (mus-data-format-name (mus-sound-data-format "test.snd"))))
	  (IF (fneq (sample 1000 ab) samp) (snd-display ";next (float)[1000] = ~A?" (sample 1000 ab)))
	  (close-sound ab))
	(save-sound-as "test.snd" ob mus-next mus-bshort)
	(close-sound ob)
	(let ((ab (open-sound "test.snd")))
	  (set! (data-format) mus-lshort)
	  (IF (not (= ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	  (IF (not (= (data-format) mus-lshort)) (snd-display ";set data-format: ~A?" (mus-data-format-name (data-format))))
	  (set! (header-type) mus-aifc)
	  (IF (not (= ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	  (IF (not (= (header-type) mus-aifc)) (snd-display ";set header-type: ~A?" (mus-header-type-name (header-type))))
	  (set! (channels) 3)
	  (IF (not (= ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	  (IF (not (= (channels) 3)) (snd-display ";set chans: ~A?" (channels)))
	  (set! (data-location) 1234)
	  (IF (not (= ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	  (IF (not (= (data-location) 1234)) (snd-display ";set data-location: ~A?" (data-location)))
	  (set! (srate) 12345)
	  (IF (not (= ab (find-sound "test.snd"))) (set! ab (find-sound "test.snd")))
	  (IF (not (= (srate) 12345)) (snd-display ";set srate: ~A?" (srate)))
	  (close-sound ab)))
      (let* ((ob (open-sound "oboe.snd"))
	     (sd (samples->sound-data))
	     (mx (sound-data-maxamp sd)))
	(IF (not (= (sound-data-length sd) 50828)) (snd-display ";oboe->sd: len ~A?" (sound-data-length sd)))
	(IF (fneq (sound-data-ref sd 0 1000) .0328369) (snd-display ";oboe->sd[1000]: ~A?" (sound-data-ref sd 0 1000)))
	(IF (not (= (length mx) 1)) (snd-display ";sound-data-maxamp oboe.snd: ~A?" (sound-data-maxamp sd)))
	(IF (not (= (maxamp ob 0) (car mx))) (snd-display ";sound-data-maxamp oboe.snd: ~A ~A?" (sound-data-maxamp sd) (maxamp ob 0)))

	(let ((var (catch #t (lambda () (set! (selected-channel) 1)) (lambda args args))))
	  (IF (not (eq? (car var) 'no-such-channel))
	      (snd-display ";set selected-channel bad chan: ~A" var)))
	(let ((var (catch #t (lambda () (set! (selected-channel 123456) 1)) (lambda args args))))
	  (IF (not (eq? (car var) 'no-such-sound))
	      (snd-display ";set selected-channel bad snd: ~A" var)))
	(let ((var (catch #t (lambda () (sound-data-ref sd 2 1000)) (lambda args args))))
	  (IF (not (eq? (car var) 'mus-error))
	      (snd-display ";sound-data-ref bad chan: ~A" var)))
	(let ((var (catch #t (lambda () (sound-data-ref sd -1 1000)) (lambda args args))))
	  (IF (not (eq? (car var) 'mus-error))
	      (snd-display ";sound-data-ref bad chan -1: ~A" var)))
	(let ((var (catch #t (lambda () (sound-data-ref sd 0 -1)) (lambda args args))))
	  (IF (not (eq? (car var) 'mus-error))
	      (snd-display ";sound-data-ref bad frame: ~A" var)))
	(let ((var (catch #t (lambda () (sound-data-ref sd 0 10000000)) (lambda args args))))
	  (IF (not (eq? (car var) 'mus-error))
	      (snd-display ";sound-data-ref bad frame high: ~A" var)))
	(let ((var (catch #t (lambda () (sound-data-set! sd 2 1000 1)) (lambda args args))))
	  (IF (not (eq? (car var) 'mus-error))
	      (snd-display ";sound-data-set! bad chan: ~A" var)))
	(let ((var (catch #t (lambda () (sound-data-set! sd 0 10000000 1)) (lambda args args))))
	  (IF (not (eq? (car var) 'mus-error))
	      (snd-display ";sound-data-set! bad frame: ~A" var)))
	(let* ((v (make-vct 3))
	       (var (catch #t (lambda () (vct->sound-data v sd 2)) (lambda args args))))
	  (IF (not (eq? (car var) 'mus-error))
	      (snd-display ";vct->sound-data-set! bad chan: ~A" var)))
	(close-sound ob))
      (IF (not (= (selected-sound) -1))
	  (snd-display ";selected-sound ~A ~A" (selected-sound) (sounds)))
      
      (let* ((vals (make-vector 32))
	     (err (mus-audio-mixer-read mus-audio-microphone mus-audio-amp 0 vals)))
	(if (= err -1) 
	    (snd-display ";mus-audio-mixer-read?")
	    (begin
	      (mus-audio-save)
	      (let ((old-val (vector-ref vals 0)))
		(vector-set! vals 0 .5)
		(set! err (mus-audio-mixer-write mus-audio-microphone mus-audio-amp 0 vals))
		(if (= err -1) 
		    (snd-display ";mus-audio-mixer-write?"))
		(clear-audio-inputs)
		(mus-audio-restore)
		(mus-audio-mixer-read mus-audio-microphone mus-audio-amp 0 vals)
		(IF (fneq (vector-ref vals 0) old-val) (snd-display ";mus-audio-restore: ~A ~A?" old-val (vector-ref vals 0)))))))

      (if (file-exists? (string-append (or sf-dir "") "a.sf2"))
	  (let ((fil (open-sound (string-append (or sf-dir "") "a.sf2"))))
	    (if fil
		(let ((loops (and fil (soundfont-info))))
		  (IF (or (null? loops)
			  (not (= (caddar loops) 65390))
			  (not (= (cadadr loops) 65490)))
		      (snd-display ";soundfont-info: ~A?" loops))
		  (close-sound fil)))))

      (if (file-exists? "fmv5.snd") (delete-file "fmv5.snd"))
      (let ((fd (mus-sound-open-output "fmv5.snd" 22050 1 mus-bshort mus-aiff "no comment"))
	    (sdata (make-sound-data 1 100)))
	(do ((i 0 (1+ i)))
	    ((= i 100))
	  (sound-data-set! sdata 0 i (* i .01)))
	(IF (not (string=? "#<sound-data: 1 chan, 100 frames>" (format #f "~A" sdata)))
	    (snd-display ";print sound-data: ~A?" (format #f "~A" sdata)))
	(let ((edat sdata)
	      (edat1 (make-sound-data 1 100))
	      (edat2 (make-sound-data 2 100)))
	  (IF (not (eq? sdata edat)) (snd-display ";sound-data not eq? ~A ~A" sdata edat))
	  (IF (not (equal? sdata edat)) (snd-display ";sound-data not equal? ~A ~A" sdata edat))
	  (IF (equal? sdata edat1) (snd-display ";sound-data 1 equal? ~A ~A" sdata edat1))
	  (IF (equal? edat2 edat1) (snd-display ";sound-data 2 equal? ~A ~A" edat2 edat1))
	  (do ((i 0 (1+ i)))
	      ((= i 100))
	    (sound-data-set! edat1 0 i (sound-data-ref sdata 0 i)))
	  (IF (not (equal? sdata edat1)) (snd-display ";sound-data 3 not equal? ~A ~A" sdata edat1)))
	(let ((v0 (make-vct 100)))
	  (sound-data->vct sdata 0 v0) 
	  (IF (fneq (vct-ref v0 10) .1) (snd-display ";sound-data->vct: ~A?" v0))
	  (vct->sound-data v0 sdata 0) 
	  (IF (fneq (sound-data-ref sdata 0 10) .1) (snd-display ";vct->sound-data: ~A?" (sound-data-ref sdata 0 10)))
	  (let ((var (catch #t (lambda () (sound-data->vct sdata 2 v0)) (lambda args args))))
	    (IF (not (eq? (car var) 'mus-error))
		(snd-display ";sound-data->vct bad chan: ~A" var)))
	  (let ((var (catch #t (lambda () (mus-audio-write 1 (make-sound-data 3 3) 123)) (lambda args args))))
	    (IF (not (eq? (car var) 'mus-error))
		(snd-display ";mus-audio-write bad frames: ~A" var))))

	(let ((v0 (make-vct 10))
	      (sdata2 (make-sound-data 2 10)))
	  (do ((i 0 (1+ i)))
	      ((= i 10))
	    (sound-data-set! sdata2 0 i 0.1)
	    (sound-data-set! sdata2 1 i 0.2))
	  (sound-data->vct sdata2 0 v0) 
	  (IF (fneq (vct-ref v0 1) .1) (snd-display ";sound-data->vct[1]: ~A?" v0))
	  (sound-data->vct sdata2 1 v0) 
	  (IF (fneq (vct-ref v0 1) .2) (snd-display ";sound-data->vct[2]: ~A?" v0))
	  (vct->sound-data v0 sdata2 0) 
	  (IF (fneq (sound-data-ref sdata2 0 1) .2) 
	      (snd-display ";vct->sound-data[2]: ~A?" (sound-data-ref sdata2 0 1)))
	  (vct-fill! v0 .3)
	  (vct->sound-data v0 sdata2 1) 
	  (IF (fneq (sound-data-ref sdata2 1 1) .3) 
	      (snd-display ";vct->sound-data[3]: ~A?" (sound-data-ref sdata2 1 1))))
	(mus-sound-write fd 0 99 1 sdata)
	(mus-sound-close-output fd 200)
	(set! fd (mus-sound-reopen-output "fmv5.snd" 1 mus-bshort mus-aiff (mus-sound-data-location "fmv5.snd")))
	(mus-sound-close-output fd 200)
	(set! fd (mus-sound-open-input "fmv5.snd"))
	(mus-sound-read fd 0 99 1 sdata)
	(IF (fneq (sound-data-ref sdata 0 10) .1) (snd-display ";mus-sound-write: ~A?" (sound-data-ref sdata 0 10)))
	(let ((pos (mus-sound-seek-frame fd 20)))
	  (IF (not (= pos (ftell fd))) 
	      (snd-display ";mus-sound-seek-frame: ~A ~A?" pos (ftell fd)))
	  (IF (not (= pos (frame->byte "fmv5.snd" 20)))
	      (snd-display ";mus-sound-seek-frame(2): ~A ~A?" pos (frame->byte "fmv5.snd" 20))))
	(mus-sound-read fd 0 10 1 sdata)
	(IF (fneq (sound-data-ref sdata 0 0) .2) (snd-display ";mus-sound-seek: ~A?" (sound-data-ref sdata 0 0)))
	(let ((pos (mus-sound-seek fd 20 0)))
	  (IF (not (= pos (ftell fd))) (snd-display ";mus-sound-seek: ~A ~A?" pos (ftell fd))))
	(mus-sound-close-input fd))

      (let ((var (catch #t (lambda () (mus-sound-open-output "fmv.snd" 22050 -1 mus-bshort mus-aiff "no comment")) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";mus-sound-open-output bad chans: ~A" var)))
      (let ((var (catch #t (lambda () (mus-sound-open-output "fmv.snd" 22050 1 -1 mus-aiff "no comment")) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";mus-sound-open-output bad format: ~A" var)))
      (let ((var (catch #t (lambda () (mus-sound-open-output "fmv.snd" 22050 1 mus-bshort -1 "no comment")) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";mus-sound-open-output bad type: ~A" var)))

      (let ((var (catch #t (lambda () (mus-sound-reopen-output "fmv.snd" -1 mus-bshort mus-aiff #f)) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";mus-sound-reopen-output bad chans: ~A" var)))
      (let ((var (catch #t (lambda () (mus-sound-reopen-output "fmv.snd" 1 -1 mus-aiff #f)) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";mus-sound-reopen-output bad format: ~A" var)))
      (let ((var (catch #t (lambda () (mus-sound-reopen-output "fmv.snd" 1 mus-bshort -1 #f)) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";mus-sound-reopen-output bad type: ~A" var)))

      (for-each
       (lambda (proc name)
	 (let ((var (catch #t (lambda () (proc mus-audio-default 22050 -1 mus-lshort 512)) (lambda args args))))
	   (IF (not (eq? (car var) 'mus-error))
	       (snd-display ";~A bad chans: ~A" name var)))
	 (let ((var (catch #t (lambda () (proc mus-audio-default 22050 1 -1 512)) (lambda args args))))
	   (IF (not (eq? (car var) 'mus-error))
	       (snd-display ";~A bad format: ~A" name var)))
	 (let ((var (catch #t (lambda () (proc -1 22050 1 mus-lshort 512)) (lambda args args))))
	   (IF (not (eq? (car var) 'mus-error))
	       (snd-display ";~A bad device: ~A" name var)))
	 (let ((var (catch #t (lambda () (proc mus-audio-default -22050 1 mus-lshort 512)) (lambda args args))))
	   (IF (not (eq? (car var) 'mus-error))
	       (snd-display ";~A bad srate: ~A" name var)))
	 (let ((var (catch #t (lambda () (proc mus-audio-default 22050 1 mus-lshort -512)) (lambda args args))))
	   (IF (not (eq? (car var) 'mus-error))
	       (snd-display ";~A bad size: ~A" name var))))
       (list mus-audio-open-output mus-audio-open-input)
       (list "mus-audio-open-output" "mus-audio-open-input"))

      (let ((vals (make-vector 32)))
	(for-each 
	 (lambda (proc name)
	   (let ((var (catch #t (lambda () (proc -1 mus-audio-amp 0 vals)) (lambda args args))))
	     (IF (not (eq? (car var) 'mus-error))
		 (snd-display ";~A bad device: ~A" name var)))
	   (let ((var (catch #t (lambda () (proc mus-audio-microphone -1 0 vals)) (lambda args args))))
	     (IF (not (eq? (car var) 'mus-error))
		 (snd-display ";~A bad field: ~A" name var))))
	 (list mus-audio-mixer-read mus-audio-mixer-write)
	 (list "mus-audio-mixer-read" "mus-audio-mixer-write")))

      (let* ((ind (open-sound "2.snd"))
	     (sd1 (samples->sound-data 12000 10 ind 0))
	     (vc1 (sound-data->vct sd1))
	     (vc2 (samples->vct 12000 10 ind 0))
	     (sd2 (vct->sound-data vc2)))
	(IF (not (equal? vc1 vc2)) (snd-display ";samples->sound-data->vct: ~A ~A" vc1 vc2))
	(IF (not (equal? sd1 sd2)) (snd-display ";sound-data->vct->sound-data: ~A ~A" sd1 sd2))
	(scale-by 2.0 ind 0)
	(set! sd1 (samples->sound-data 12000 10 ind 0 #f 0))
	(set! vc1 (sound-data->vct sd1))
	(set! vc2 (samples->vct 12000 10 ind 0 #f 0))
	(set! sd2 (vct->sound-data vc2))
	(IF (not (equal? vc1 vc2)) (snd-display ";edpos samples->sound-data->vct: ~A ~A" vc1 vc2))
	(IF (not (equal? sd1 sd2)) (snd-display ";edpos sound-data->vct->sound-data: ~A ~A" sd1 sd2))
	(set! sd1 (samples->sound-data 12000 10 ind 1))
	(set! vc1 (sound-data->vct sd1))
	(set! vc2 (samples->vct 12000 10 ind 1))
	(set! sd2 (vct->sound-data vc2))
	(IF (not (equal? vc1 vc2)) (snd-display ";1 samples->sound-data->vct: ~A ~A" vc1 vc2))
	(IF (not (equal? sd1 sd2)) (snd-display ";1 sound-data->vct->sound-data: ~A ~A" sd1 sd2))
	(scale-by 2.0 ind 1)
	(set! sd1 (samples->sound-data 12000 10 ind 1))
	(set! vc1 (sound-data->vct sd1))
	(set! vc2 (samples->vct 12000 10 ind 1))
	(set! sd2 (vct->sound-data vc2))
	(IF (not (equal? vc1 vc2)) (snd-display ";1 scaled samples->sound-data->vct: ~A ~A" vc1 vc2))
	(IF (not (equal? sd1 sd2)) (snd-display ";1 scaled sound-data->vct->sound-data: ~A ~A" sd1 sd2))
	(close-sound ind))

      (for-each 
       (lambda (chans)
	 (for-each 
	  (lambda (df-ht)
	    (let ((samps (if (= chans 1) 100000
			     (if (= chans 2) 50000
				 1000))))
	      (if (file-exists? "fmv5.snd") (delete-file "fmv5.snd"))
	      (let ((fd (mus-sound-open-output "fmv5.snd" 22050 chans (car df-ht) (cadr df-ht) "no comment"))
		    (sdata (make-sound-data chans samps))
		    (ndata (make-sound-data chans samps)))
		(do ((k 0 (1+ k)))
		    ((= k chans))
		  (do ((i 0 (1+ i)))
		      ((= i samps))
		    (sound-data-set! sdata k i (- (random 2.0) 1.0))))
		(mus-sound-write fd 0 (- samps 1) chans sdata)
		(mus-sound-close-output fd (* samps chans (mus-data-format-bytes-per-sample (car df-ht))))
		(set! fd (mus-sound-open-input "fmv5.snd"))
		(mus-sound-read fd 0 (- samps 1) chans ndata)
		(let ((pos (mus-sound-seek-frame fd 100)))
		  (IF (not (= pos (ftell fd))) 
		      (snd-display ";mus-sound-seek-frame[~A]: chans ~A ~A?" pos chans (ftell fd)))
		  (IF (not (= pos (frame->byte "fmv5.snd" 100))) 
		      (snd-display ";mus-sound-seek-frame(100): ~A ~A?" pos (frame->byte "fmv5.snd" 100))))
		(mus-sound-close-input fd)
		(catch #t
		       (lambda ()
			 (do ((k 0 (1+ k)))
			     ((= k chans))
			   (do ((i 0 (1+ i)))
			       ((= i samps))
			     (if (fneq (sound-data-ref sdata k i) (sound-data-ref ndata k i))
				 (throw 'read-write-error
					(car df-ht) (mus-data-format-name (car df-ht))
					(cadr df-ht) (mus-header-type-name (cadr df-ht))
					i k
					(sound-data-ref sdata k i) (sound-data-ref ndata k i))))))
		       (lambda args (begin (snd-display "~A" args) (car args)))))))
	  (list (list mus-bshort mus-next)
		(list mus-bfloat mus-aifc)
		(list mus-lfloat mus-riff)
		(list mus-lshort mus-nist)
		(list mus-bint mus-aiff)
		(list mus-lint mus-next)
		(list mus-b24int mus-aifc)
		(list mus-l24int mus-riff)
		(list mus-bfloat mus-ircam)
		(list mus-bdouble mus-next)
		(list mus-ldouble mus-next)
		(list mus-ulshort mus-next)
		(list mus-ubshort mus-next))))
       (list 1 2 4 8))
      
      (let ((ind (open-sound "oboe.snd")))
	(show-input-1)
	(close-sound ind))

      (let ((fd (mus-sound-open-output "fmv.snd" 22050 1 mus-bshort mus-next "no comment"))
	    (sdata (make-sound-data 1 10)))
	(define (sound-data-channel->list sd chan)
	  (let ((ls '()))
	    (do ((i (1- (sound-data-length sd)) (1- i)))
		((< i 0) ls)
	      (set! ls (cons (sound-data-ref sd chan i) ls)))))
	(define (sound-data->list sd)
	  (let ((lst '()))
	    (do ((i (1- (sound-data-chans sd)) (1- i)))
		((< i 0) lst)
	      (set! lst (cons (sound-data-channel->list sd i) lst)))))
	(sound-data-set! sdata 0 1 .1)
	(mus-sound-write fd 0 9 1 sdata)
	(mus-sound-close-output fd 20)
	(set! fd (mus-sound-open-input "fmv.snd"))
	(mus-sound-read fd 0 9 1 sdata)
	(IF (or (fneq (sound-data-ref sdata 0 0) 0.0)
		(fneq (sound-data-ref sdata 0 1) 0.1)
		(fneq (sound-data-ref sdata 0 2) 0.0)
		(fneq (sound-data-ref sdata 0 6) 0.0))
	    (snd-display ";read/write: ~A?" (sound-data->list sdata)))
	(mus-sound-close-input fd)  
	(set! fd (mus-sound-reopen-output "fmv.snd" 1 mus-bshort mus-next (mus-sound-data-location "fmv.snd")))
	(mus-sound-seek fd (mus-sound-data-location "fmv.snd") 0)
	(sound-data-set! sdata 0 2 .1)
	(sound-data-set! sdata 0 3 .1)
	(mus-sound-write fd 0 9 1 sdata)
	(mus-sound-close-output fd 20)
	(set! fd (mus-sound-open-input "fmv.snd"))
	(mus-sound-read fd 0 9 1 sdata)
	(IF (or (fneq (sound-data-ref sdata 0 0) 0.0)
		(fneq (sound-data-ref sdata 0 1) 0.1)
		(fneq (sound-data-ref sdata 0 2) 0.1)
		(fneq (sound-data-ref sdata 0 3) 0.1)
		(fneq (sound-data-ref sdata 0 6) 0.0))
	    (snd-display ";re-read/write: ~A?" (sound-data->list sdata)))
	(mus-sound-close-input fd)
	
	(delete-file "fmv.snd")
	(set! fd (mus-sound-open-output "fmv.snd" 22050 4 mus-lshort mus-riff "no comment"))
	(set! sdata (make-sound-data 4 10))
	(do ((i 0 (1+ i)))
	    ((= i 4))
	  (sound-data-set! sdata i 1 .1))
	(mus-sound-write fd 0 9 4 sdata)
	(mus-sound-close-output fd 80)
	(set! fd (mus-sound-open-input "fmv.snd"))
	(mus-sound-read fd 0 9 4 sdata)
	(do ((i 0 (1+ i)))
	    ((= i 4))
	  (IF (or (fneq (sound-data-ref sdata i 0) 0.0)
		  (fneq (sound-data-ref sdata i 1) 0.1)
		  (fneq (sound-data-ref sdata i 2) 0.0)
		  (fneq (sound-data-ref sdata i 6) 0.0))
	      (snd-display ";read/write[~A]: ~A?" i (sound-data-channel->list sdata i))))
	(mus-sound-close-input fd)  
	(set! fd (mus-sound-reopen-output "fmv.snd" 4 mus-lshort mus-riff (mus-sound-data-location "fmv.snd")))
	(mus-sound-seek fd (mus-sound-data-location "fmv.snd") 0)
	(do ((i 0 (1+ i)))
	    ((= i 4))
	  (sound-data-set! sdata i 2 .1)
	  (sound-data-set! sdata i 3 .1))
	(mus-sound-write fd 0 9 4 sdata)
	(mus-sound-close-output fd 80)
	(set! fd (mus-sound-open-input "fmv.snd"))
	(mus-sound-read fd 0 9 4 sdata)
	(do ((i 0 (1+ i)))
	    ((= i 4))
	  (IF (or (fneq (sound-data-ref sdata i 0) 0.0)
		  (fneq (sound-data-ref sdata i 1) 0.1)
		  (fneq (sound-data-ref sdata i 2) 0.1)
		  (fneq (sound-data-ref sdata i 3) 0.1)
		  (fneq (sound-data-ref sdata i 6) 0.0))
	      (snd-display ";re-read/write[~A]: ~A?" i (sound-data-channel->list sdata i))))
	(mus-sound-close-input fd))

      (if (file-exists? (string-append sf-dir "32bit.sf"))
	  (let ((ind (open-sound (string-append sf-dir "32bit.sf"))))
	    (IF (fneq (maxamp ind 0) .228) (snd-display ";32bit max: ~A" (maxamp ind 0)))
	    (close-sound ind)))

      (let ((test-data (lambda (file beg dur data)
			 (catch #t
				(lambda ()
				  (let* ((ind (open-sound file))
					 (ndata (samples->vct beg dur ind 0)))
				    (IF (not (vequal data ndata))
					(snd-display ";~A: ~A != ~A" file data ndata))
				    (close-sound ind)))
				(lambda args args)))))
	(test-data (string-append sf-dir "next-dbl.snd") 10 10 (vct 0.475 0.491 0.499 0.499 0.492 0.476 0.453 0.423 0.387 0.344))
	(test-data (string-append sf-dir "oboe.ldbl") 1000 10 (vct 0.033 0.035 0.034 0.031 0.026 0.020 0.013 0.009 0.005 0.004))

	(test-data (string-append sf-dir "next-flt.snd") 10 10 (vct 0.475 0.491 0.499 0.499 0.492 0.476 0.453 0.423 0.387 0.344))
	(test-data (string-append sf-dir "clbonef.wav") 1000 10 (vct 0.111 0.101 0.070 0.032 -0.014 -0.060 -0.085 -0.108 -0.129 -0.152))

	(test-data (string-append sf-dir "next-8.snd") 10 10 (vct 0.898 0.945 0.977 0.992 0.992 0.977 0.945 0.906 0.844 0.773))
	(test-data (string-append sf-dir "o2_u8.wave") 1000 10 (vct -0.164 -0.219 -0.258 -0.242 -0.180 -0.102 -0.047 0.000 0.039 0.055))

	(test-data (string-append sf-dir "next-16.snd") 1000 10 (vct -0.026 -0.022 -0.024 -0.030 -0.041 -0.048 -0.050 -0.055 -0.048 -0.033))
	(test-data (string-append sf-dir "o2.wave") 1000 10 (vct -0.160 -0.216 -0.254 -0.239 -0.175 -0.102 -0.042 0.005 0.041 0.059))

	(test-data (string-append sf-dir "o2_18bit.aiff") 1000 10 (vct -0.160 -0.216 -0.254 -0.239 -0.175 -0.102 -0.042 0.005 0.041 0.059))
	(test-data (string-append sf-dir "o2_12bit.aiff") 1000 10 (vct -0.160 -0.216 -0.254 -0.239 -0.175 -0.102 -0.042 0.005 0.041 0.059))

	(test-data (string-append sf-dir "next24.snd") 1000 10 (vct -0.160 -0.216 -0.254 -0.239 -0.175 -0.102 -0.042 0.005 0.041 0.059))
	(test-data (string-append sf-dir "mono24.wav") 1000 10 (vct 0.005 0.010 0.016 0.008 -0.007 -0.018 -0.025 -0.021 -0.005 0.001))

	(test-data (string-append sf-dir "o2_711u.wave") 1000 10 (vct -0.164 -0.219 -0.254 -0.242 -0.172 -0.103 -0.042 0.005 0.042 0.060))
	(test-data (string-append sf-dir "alaw.wav") 1000 10 (vct -0.024 -0.048 -0.024 0.000 0.008 0.008 0.000 -0.040 -0.064 -0.024))

	(test-data (string-append sf-dir "b32.pvf") 1000 10 (vct -0.160 -0.216 -0.254 -0.239 -0.175 -0.102 -0.042 0.005 0.041 0.059))
	(test-data (string-append sf-dir "b32.wave") 1000 10 (vct -0.160 -0.216 -0.254 -0.239 -0.175 -0.102 -0.042 0.005 0.041 0.059))
	(test-data (string-append sf-dir "b32.snd") 1000 10 (vct -0.160 -0.216 -0.254 -0.239 -0.175 -0.102 -0.042 0.005 0.041 0.059))
	(test-data (string-append sf-dir "32bit.sf") 1000 10 (vct 0.016 0.014 0.013 0.011 0.010 0.010 0.010 0.010 0.012 0.014))

	(test-data (string-append sf-dir "nist-shortpack.wav") 10000 10 (vct 0.021 0.018 0.014 0.009 0.004 -0.001 -0.004 -0.006 -0.007 -0.008))
	(test-data (string-append sf-dir "wood.sds") 1000 10 (vct -0.160 -0.216 -0.254 -0.239 -0.175 -0.102 -0.042 0.005 0.041 0.059))
	(test-data (string-append sf-dir "oboe.g721") 1000 10 (vct -0.037 -0.040 -0.040 -0.041 -0.042 -0.038 -0.028 -0.015 -0.005 0.002))
	(test-data (string-append sf-dir "oboe.g723_40") 1000 10 (vct -0.037 -0.040 -0.041 -0.041 -0.041 -0.038 -0.028 -0.015 -0.005 0.003))
	(test-data (string-append sf-dir "mus10.snd") 10000 10 (vct 0.004 0.001 0.005 0.009 0.017 0.015 0.008 0.011 0.009 0.012))
	(test-data (string-append sf-dir "ieee-text-16.snd") 1000 10 (vct -0.052 -0.056 -0.069 -0.077 -0.065 -0.049 -0.054 -0.062 -0.066 -0.074))
	(test-data (string-append sf-dir "hcom-16.snd") 10000 10 (vct 0.000 0.000 0.000 0.008 0.000 -0.016 -0.016 -0.016 -0.008 0.000))
	(test-data (string-append sf-dir "ce-c3.w02") 1000 10 (vct 0.581 0.598 0.596 0.577 0.552 0.530 0.508 0.479 0.449 0.425))
	(test-data (string-append sf-dir "nasahal.avi") 20000 10 (vct 0.464 0.189 -0.458 -0.150 0.593 0.439 -0.208 -0.130 0.460 0.429))
	(test-data (string-append sf-dir "PCM_48_8bit_m.w64") 1000 10 (vct 0.062 0.070 0.070 0.086 0.086 0.102 0.102 0.109 0.109 0.117))
	(test-data (string-append sf-dir "oki.wav") 100 10 (vct 0.396 0.564 0.677 0.779 0.761 0.540 0.209 -0.100 -0.301 -0.265))
	)
      ))))

(define a-ctr 0)

(define (test-edpos test-func func-name change-thunk ind1)
  (let ((fr1 (test-func ind1 0))
	(fr2 (test-func ind1 0 0))
	(fr3 (test-func ind1 0 current-edit-position))
	(fr4 (test-func ind1 0 (lambda (snd chn) 0))))
    (IF (not (and (= fr1 fr2)
		  (= fr1 fr3)
		  (= fr1 fr4)))
	(snd-display ";initial ~A: ~A ~A ~A ~A?" func-name fr1 fr2 fr3 fr4))
    (change-thunk)
    (let ((fr5 (test-func ind1 0))
	  (fr6 (test-func ind1 0 1))
	  (fr7 (test-func ind1 0 current-edit-position))
	  (fr8 (test-func ind1 0 (lambda (snd chn) (edit-position snd chn)))))
      (IF (not (and (= fr5 fr6)
		    (= fr5 fr7)
		    (= fr5 fr8)))
	  (snd-display ";~A (edpos 1): ~A ~A ~A ~A?" func-name fr5 fr6 fr7 fr8))
      (set! fr5 (test-func ind1 0 0))
      (set! fr6 (test-func ind1 0 (lambda (snd chn) 0)))
      (IF (not (and (= fr1 fr5)
		    (= fr1 fr6)))
	  (snd-display ";~A (edpos -1): ~A ~A ~A?" func-name fr1 fr5 fr6))
      (undo 1 ind1 0)
      (set! fr5 (test-func ind1 0 1))
      (set! fr6 (test-func ind1 0 (lambda (snd chn) (+ (edit-position snd chn) 1))))
      (IF (not (and (= fr8 fr5)
		    (= fr8 fr6)))
	  (snd-display ";~A (edpos +1): ~A ~A ~A?" func-name fr8 fr5 fr6))))
  (revert-sound ind1))

(define (test-edpos-1 test-func func-name ind1)
  (let ((v0 (samples->vct 12000 10 ind1 0)))
    (test-func ind1 0)
    (let ((v1 (samples->vct 12000 10 ind1 0)))
      (IF (vequal v0 v1)
	  (snd-display ";~A (0) no change! ~A ~A" func-name v0 v1))
      (test-func ind1 0)
      (let ((v2 (samples->vct 12000 10 ind1 0)))
	(IF (not (vequal v1 v2))
	    (snd-display ";~A (1) ~A ~A" func-name v1 v2))
	(test-func ind1 (lambda (snd chn) 0))
	(set! v2 (samples->vct 12000 10 ind1 0))
	(IF (not (vequal v1 v2))
	    (snd-display ";~A (2) ~A ~A" func-name v1 v2))
	(let ((edp (edit-position ind1 0)))
	  (test-func ind1 current-edit-position)
	  (set! v2 (samples->vct 12000 10 ind1 0))
	  (undo 2 ind1)
	  (test-func ind1 edp)
	  (set! v1 (samples->vct 12000 10 ind1 0))
	  (IF (not (vequal v1 v2))
	      (snd-display ";~A (3) ~A ~A" func-name v1 v2)))))
    (revert-sound ind1)))

(define (vfequal v0 v1)
  (define (dequal ctr len)
    (if (= ctr len)
	#t
	(and (< (abs (- (vct-ref v0 ctr) (vct-ref v1 ctr))) .01)
	     (dequal (1+ ctr) len))))
  (let ((len (vct-length v0)))
    (and (= len (vct-length v1))
	 (dequal 0 len))))

(define (test-orig func0 func1 func-name ind1)
  (let ((v0 (samples->vct 12000 10 ind1 0)))
    (func0 ind1)
    (let ((v1 (samples->vct 12000 10 ind1 0)))
      (if (vfequal v0 v1)
	  (snd-display ";~A (orig: 0) no change! ~A ~A" func-name v0 v1))
      (func1 ind1)
      (let ((v2 (samples->vct 12000 10 ind1 0)))
	(if (not (vfequal v0 v2))
	    (snd-display ";~A (orig: 1) ~A ~A" func-name v0 v2))))
    (revert-sound ind1)))


;;; ---------------- test 5: simple overall checks ----------------

(load "extensions.scm")
(load "examp.scm")
(load "snd4.scm") ; needed for various scan/map extensions, external program testers etc
(load "dsp.scm")
(load "pvoc.scm")

(define (our-x->position ind x) 
  (let ((ax (axis-info ind)))
    (list
     (+ (list-ref ax 10) 
	(/ (* (- x (list-ref ax 2))
	      (- (list-ref ax 12) (list-ref ax 10)))
	   (- (list-ref ax 4) (list-ref ax 2))))
     (x->position x ind))))

(define (region-to-vct r c len)
  (let* ((rs (make-region-sample-reader 0 r c))
	 (v (make-vct len)))
    (do ((i 0 (1+ i)))
	((= i len) v)
      (vct-set! v i (next-sample rs)))))

(define (region2vct r c len)
  (region-samples->vct 0 len r c))

(if (or full-test (= snd-test 5) (and keep-going (<= snd-test 5)))
    (let* ((index (open-sound "oboe.snd"))
	   (bnds (x-bounds index))
	   (xp (x-position-slider))
	   (yp (y-position-slider))
	   (xz (x-zoom-slider))
	   (yz (y-zoom-slider)))
      (if (procedure? test-hook) (test-hook 5))
      (IF (not (string=? (snd-completion " open-so") " open-sound"))
	  (snd-display ";completion: ~A" (snd-completion " open-so")))
      (IF (not (string=? (snd-completion " open-sound") " open-sound"))
	  (snd-display ";completion: ~A" (snd-completion " open-so")))
      (IF (not (string=? (snd-completion " zoom-focus-r") " zoom-focus-right"))
	  (snd-display ";completion: ~A" (snd-completion " zoom-focus-r")))
      (play-and-wait "oboe.snd")
      (play-and-wait "oboe.snd" 12000)
      (play-and-wait "oboe.snd" 12000 15000)
      (play-and-wait 0 #f #f #f #f (1- (edit-position)))
      (bomb index #t)
      (let ((k (disk-kspace "oboe.snd")))
	(IF (or (not (number? k))
		(<= k 0))
	    (snd-display ";disk-kspace = ~A" (disk-kspace "oboe.snd")))
	(set! k (disk-kspace "/baddy/hiho"))
	(IF (not (= k -1))
	    (snd-display ";disk-kspace of bogus file = ~A" (disk-kspace "/baddy/hiho"))))
      (IF (not (= (transform-samples-size) 0)) (snd-display ";transform-samples-size ~A?" (transform-samples-size)))
      (set! (graph-transform?) #t)
      (set! (graph-time?) #t)
      (graph '(0 0 1 1 2 0))
      (update-lisp-graph)
      (graph '#(0 0 1 1 2 0))
      (do ((i 0 (1+ i))) 
	  ((= i 32)) 
	(graph '#(0 1 2)) 
	(graph (list '#(0 1 2) '#(3 2 1) '#(1 2 3)))
	(graph (list '#(0 1 2) '#(3 2 1))))
      (IF (= (transform-samples-size) 0) (snd-display ";graph-transform? transform-samples-size ~A?" (transform-samples-size)))
      (update-transform)
      (peaks "tmp.peaks")
      (if (defined? 'read-line)
	  (let ((p (open-input-file "tmp.peaks")))
	    (if (not p)
		(snd-display ";peaks->tmp.peaks failed?")
		(let ((line (read-line p)))
		  (IF (or (not (string? line))
			  (not (string=? "Snd: fft peaks" (substring line 0 14))))
		      (snd-display ";peaks 1: ~A?" line))
		  (set! line (read-line p))
		  (set! line (read-line p))
		  (IF (or (not (string? line))
			  (not (string=? "oboe.snd, fft 256 points beginning at sample 0 (0.000 secs)" line)))
		      (snd-display ";peaks 2: ~A?" line))
		  (set! line (read-line p))
		  (set! line (read-line p))
		  (IF (or (not (string? line))
			  (and (not (string=? "  86.132812  1.00000" line))
			       (not (string=? "  0.000000  1.00000" line)))) ; fht/fft disagreement about 0/1 (groan)
		      (snd-display ";peaks 3: ~A?" line))
		  (close-port p)
		  (delete-file "tmp.peaks")))))
      (let* ((num-transforms 9)
	     (num-transform-graph-types 3))
	(set! (graph-transform? index 0) #t)
	(set! (transform-size index 0) 64)
	(do ((i 0 (1+ i)))
	    ((= i num-transforms))
	  (set! (transform-type) i)
	  (do ((j 0 (1+ j)))
	      ((= j num-transform-graph-types))
	    (set! (transform-graph-type index 0) j)
	    (update-transform index 0))))

      (IF (read-only index) (snd-display ";read-only open-sound: ~A?" (read-only index)))
      (set! (read-only index) #t)
      (IF (not (read-only index)) (snd-display ";set-read-only: ~A?" (read-only index)))
      (bind-key (char->integer #\a) 0 (lambda () (set! a-ctr 3)))
      (key (char->integer #\a) 0) 
      (IF (not (= a-ctr 3)) (snd-display ";bind-key: ~A?" a-ctr))
      (let ((str (with-output-to-string (lambda () (display (key-binding (char->integer #\a) 0))))))
	(IF (not (string=? str "#<procedure #f (() (set! a-ctr 3))>"))
	    (snd-display ";key-binding: ~A?" str)))
      (unbind-key (char->integer #\a) 0)
      (set! a-ctr 0)
      (key (char->integer #\a) 0) 
      (do ((i 0 (1+ i)))
	  ((= i 5))
	(let ((psf (eps-file)))
	  (if (and psf (string? psf))
	      (begin
		(if (file-exists? psf) (delete-file psf))
		(set! (graph-style) i)
		(graph->ps)
		(if (not (file-exists? psf)) 
		    (snd-display ";graph->ps: ~A?" psf)
		    (delete-file psf))))))
      (let ((err (catch 'cannot-print 
		   (lambda () 
		     (graph->ps "/bad/bad.eps"))
		   (lambda args 12345))))
	(IF (not (= err 12345)) (snd-display ";graph->ps err: ~A?" err)))
      (let ((n2 (or (open-sound "2.snd") (open-sound "4.aiff"))))
	(set! (channel-style n2) channels-superimposed)
	(IF (not (= (channel-style n2) channels-superimposed)) (snd-display ";channel-style->~D: ~A?" channels-superimposed (channel-style n2)))
	(set! (channel-style n2) channels-combined)
	(IF (not (= (channel-style n2) channels-combined)) (snd-display ";channel-style->~D: ~A?" channels-combined (channel-style n2)))
	(set! (channel-style n2) channels-separate)
	(IF (not (= (channel-style n2) channels-separate)) (snd-display ";channel-style->~D: ~A?" channels-separate (channel-style n2)))
	(close-sound n2))
      (IF (= (channels index) 1)
	  (begin
	    (set! (channel-style index) channels-superimposed)
	    (IF (not (= (channel-style index) channels-separate)) (snd-display ";channel-style[0]->~D: ~A?" channels-separate (channel-style index)))))
      (set! (sync index) 32)
      (IF (not (= (sync index) 32)) (snd-display ";sync->32: ~A?" (sync index)))
      (set! (sync index) 0)
      (set! (channel-sync index 0) 12)
      (IF (not (= (channel-sync index 0) 12)) (snd-display ";sync-chn->12: ~A?" (channel-sync index 0)))
      (set! (channel-sync index 0) 0)
      (IF (not (= a-ctr 0)) (snd-display ";unbind-key: ~A?" a-ctr))
      (IF (fneq xp 0.0) (snd-display ";x-position-slider: ~A?" xp))
      (IF (fneq yp 0.0) (snd-display ";y-position-slider: ~A?" yp))
      (IF (fneq xz 0.04338) (snd-display ";x-zoom-slider: ~A?" xz))
      (IF (fneq yz 1.0) (snd-display ";y-zoom-slider: ~A?" yz))
      (IF (or (fneq (car bnds) 0.0) (fneq (cadr bnds) 0.1)) (snd-display ";x-bounds: ~A?" bnds))
      (IF (not (= (find-sound "oboe.snd") index)) (snd-display ";oboe: index ~D /= ~D?" (find-sound "oboe.snd") index))
      (IF (not (sound? index)) (snd-display ";oboe: ~D not ok?" index))
      (IF (not (= (chans index) 1)) (snd-display ";oboe: chans ~D?" (chans index)))
      (IF (not (= (channels index) 1)) (snd-display ";oboe: channels ~D?" (channels index)))
      (IF (not (= (frames index) 50828)) (snd-display ";oboe: frames ~D?" (frames index)))
      (IF (not (= (srate index) 22050)) (snd-display ";oboe: srate ~D?" (srate index)))
      (IF (not (= (data-location index) 28)) (snd-display ";oboe: location ~D?" (data-location index)))
      (IF (not (= (data-format index) 1)) (snd-display ";oboe: format ~A?" (data-format index)))
      (IF (fneq (maxamp index) .14724) (snd-display ";oboe: maxamp ~F?" (maxamp index)))
      (IF (comment index) (snd-display ";oboe: comment ~A?" (comment index)))
      (IF (not (= (string-length "asdf") 4)) (snd-display ";string-length: ~A?" (string-length "asdf")))
      (IF (not (string=? (short-file-name index) "oboe.snd")) (snd-display ";oboe short name: ~S?" (short-file-name index)))
      (let ((matches (count-matches (lambda (a) (> a .125)))))
	(IF (not (= matches 1313)) (snd-display ";count-matches: ~A?" matches)))
      (let ((spot (find (lambda (a) (> a .13)))))
	(IF (or (null? spot) (not (= (cadr spot) 8862))) (snd-display ";find: ~A?" spot)))
      (set! (right-sample) 3000) 
      (let ((samp (right-sample)))
	(IF (> (abs (- samp 3000)) 1) (snd-display ";right-sample: ~A?" samp)))
      (set! (left-sample) 1000) 
      (let ((samp (left-sample)))
	(IF (> (abs (- samp 1000)) 1) (snd-display ";left-sample: ~A?" samp)))
      (let ((eds (edits)))
	(IF (or (not (= (car eds) 0)) (not (= (cadr eds) 0)))
	    (snd-display ";edits: ~A?" eds))
	(IF (not (= (edit-position) (car eds)))
	    (snd-display ";edit-position: ~A ~A?" (edit-position) eds)))
      (play-and-wait 0 index 0)

      (bomb index #f)
      (select-all index 0) 
      (let ((r0 (car (regions))))
	(IF (not (selection?)) (snd-display "selection?"))
	(IF (not (region? r0)) (snd-display "region?"))
	(IF (not (= (selection-chans) 1)) (snd-display ";selection-chans(1): ~A" (selection-chans)))
	(IF (not (= (selection-srate) (srate index))) (snd-display ";selection-srate: ~A ~A" (selection-srate) (srate index)))
	(IF (fneq (region-maxamp r0) (maxamp index)) (snd-display ";region-maxamp (1): ~A?" (region-maxamp r0)))
	(save-region r0 "temp.dat")
	(if (file-exists? "temp.dat")
	    (delete-file "temp.dat")
	    (snd-display ";save-region file disappeared?"))
	(play-region r0 #t) ;needs to be #t here or it never gets run
	(IF (not (= (length (regions)) 1)) (snd-display ";regions: ~A?" (regions)))
	(IF (not (selection-member? index)) (snd-display ";selection-member?: ~A" (selection-member? index)))
	(IF (not (= (region-srate r0) 22050)) (snd-display ";region-srate: ~A?" (region-srate r0)))
	(IF (not (= (region-chans r0) 1)) (snd-display ";region-chans: ~A?" (region-chans r0)))
	(IF (not (= (region-length r0) 50828)) (snd-display ";region-length: ~A?" (region-length r0)))
	(IF (not (= (selection-length) 50828)) (snd-display ";selection-length: ~A?" (selection-length 0)))
	(IF (not (= (selection-position) 0)) (snd-display ";selection-position: ~A?" (selection-position)))
	(IF (fneq (region-maxamp r0) (maxamp index)) (snd-display ";region-maxamp: ~A?" (region-maxamp r0)))
	(let ((samps1 (samples->vct 0 50827 index 0))
	      (samps2 (region-samples->vct r0 50827 0 0))
	      (vr (make-sample-reader 0 index 0 1)))
	  (IF (not (sample-reader? vr)) (snd-display ";~A not sample-reader?" vr))
	  (IF (not (equal? (sample-reader-home vr) (list index 0))) 
	      (snd-display ";sample-reader-home: ~A ~A?" (sample-reader-home vr) (list index 0)))
	  (let ((reader-string (format #f "~A" vr)))
	    (IF (not (string=? (substring reader-string 0 18) "#<sample-reader 0x"))
		(snd-display ";sample reader actually got: [~S]" (substring reader-string 0 18)))
	    (IF (not (string=? (substring reader-string 25) ": oboe.snd from 0, at 0>"))
		(snd-display ";sample reader actually got: [~S]" (substring reader-string 25))))
	  (let ((evr vr))
	    (IF (not (equal? evr vr)) (snd-display ";sample-reader equal? ~A ~A" vr evr)))
	  (catch 'break
		 (lambda ()
		   (do ((i 0 (1+ i)))
		       ((= i 50827))
		     (if (not (= (next-sample vr) (vct-ref samps1 i) (vct-ref samps2 i)))
			 (begin
			   (snd-display ";readers disagree at ~D" i)
			   (throw 'break)))))
		 (lambda args (car args)))
	  (free-sample-reader vr)))
      (let ((var (catch #t (lambda () (make-sample-reader 0 index -1)) (lambda args args))))
	(IF (not (eq? (car var) 'no-such-channel))
	    (snd-display ";make-sample-reader bad chan (-1): ~A" var)))
      (let ((var (catch #t (lambda () (make-sample-reader 0 index 1)) (lambda args args))))
	(IF (not (eq? (car var) 'no-such-channel))
	    (snd-display ";make-sample-reader bad chan (1): ~A" var)))
      (let* ((reg (car (regions)))
	     (chns (region-chans reg))
	     (var (catch #t (lambda () (make-region-sample-reader 0 index (+ chns 1))) (lambda args args))))
	(IF (not (eq? (car var) 'no-such-channel))
	    (snd-display ";make-sample-reader bad chan (1): ~A" var)))
      
      (revert-sound index)
      (insert-sample 100 .5 index) 
      (let ((var (catch #t (lambda () (insert-sound "oboe.snd" 0 1)) (lambda args args))))
	(IF (not (eq? (car var) 'no-such-channel))
	    (snd-display ";insert-sound bad chan (1): ~A" var)))
      (let ((var (catch #t (lambda () (insert-sample -12 1.0)) (lambda args args))))
	(IF (not (eq? (car var) 'no-such-sample))
	    (snd-display ";insert-sample bad pos: ~A" var)))
      (update-transform index) 
      (update-time-graph index) 
      (IF (or (fneq (sample 100) .5)
	      (not (= (frames index) 50829)))
	  (snd-display ";insert-sample: ~A ~A?" (sample 100) (frames index)))
      (let ((v0 (make-vector 3))
	    (v1 (make-vct 3)))
	(vct-fill! v1 .75)
	(do ((i 0 (1+ i))) ((= i 3)) (vector-set! v0 i .25))
	(insert-samples 200 3 v0 index) 
	(insert-samples 300 3 v1 index) 
	(IF (or (fneq (sample 201) .25)
		(fneq (sample 301) .75)
	      (not (= (frames index) 50835)))
	    (snd-display ";insert-samples: ~A ~A ~A?" (sample 201) (sample 301) (frames index))))
      (save-sound-as "hiho.snd" index mus-next mus-bshort 22050)
      (let ((nindex (view-sound "hiho.snd")))
	(IF (fneq (sample 101 nindex) (sample 101 index))
	    (snd-display ";save-sound-as: ~A ~A?" (sample 101 nindex) (sample 101 index)))
	(IF (not (read-only nindex)) (snd-display ";read-only view-sound: ~A?" (read-only nindex)))

	(set! (speed-control-style nindex) speed-control-as-semitone)
	(IF (not (= (speed-control-style nindex) speed-control-as-semitone))
	    (snd-display ";speed-control-style set semi: ~A" (speed-control-style nindex)))
	(set! (speed-control-tones nindex) -8)
	(IF (not (= (speed-control-tones nindex) 12))
	    (snd-display ";speed-control-tones -8: ~A" (speed-control-tones nindex)))
	(set! (speed-control-tones nindex) 18)
	(IF (not (= (speed-control-tones nindex) 18))
	    (snd-display ";speed-control-tones 18: ~A" (speed-control-tones nindex)))
	(graph->ps "aaa.eps")
	(close-sound nindex))
      (revert-sound index)
      (set! (sample 50 index) .5) 
      (IF (fneq (sample 50) .5) (snd-display ";set-sample: ~A?" (sample 50)))
      (let ((v0 (make-vector 3)))
	(do ((i 0 (1+ i))) ((= i 3)) (vector-set! v0 i .25))
	(set! (samples 60 3 index) v0) 
	(IF (or (fneq (sample 60) .25) (fneq (sample 61) .25))
	    (snd-display ";set-samples: ~A ~A ~A?" (sample 60) (sample 61) (sample 62))))
      (set! (samples 10 3 index) (list 0.1 0.2 0.3))
      (IF (not (vequal (samples->vct 10 3 index) (vct 0.1 0.2 0.3)))
	  (snd-display ";set-samples via list: ~A" (samples->vct 10 3 index)))
      (revert-sound index)
      (save-sound-as "temporary.snd" index)
      (set! (samples 100000 20000 index) "temporary.snd")
      (IF (not (vequal (samples->vct 110000 10) (samples->vct 10000 10)))
	  (snd-display ";set samples to self: ~A ~A" (samples->vct 110000 10) (samples->vct 10000 10)))
      (revert-sound index)
      (delete-sample 100 index) 
      (if (file-exists? "temporary.snd")
	  (snd-display ";temp not deleted?"))
      (IF (not (= (frames index) 50827)) (snd-display ";delete-sample: ~A?" (frames index)))
      (delete-samples 0 100 index) 
      (IF (not (= (frames index) 50727)) (snd-display ";delete-samples: ~A?" (frames index)))
      (revert-sound index)
      (let ((maxa (maxamp index)))
	(scale-to .5 index) 
	(let ((newmaxa (maxamp index)))
	  (IF (fneq newmaxa .5) (snd-display ";scale-to: ~A?" newmaxa))
	  (undo 1 index) 
	  (scale-by 2.0 index) 
	  (set! newmaxa (maxamp index))
	  (IF (fneq newmaxa (* 2.0 maxa)) (snd-display ";scale-by: ~A?" newmaxa))
	  (revert-sound index)
	  (select-all index) 
	  (IF (not (= (length (regions)) 2)) (snd-display ";regions(2): ~A?" (regions)))
	  (scale-selection-to .5) 
	  (set! newmaxa (maxamp index))
	  (IF (fneq newmaxa .5) (snd-display ";scale-selection-to: ~A?" newmaxa))
	  (revert-sound index)
	  (select-all index) 
	  (scale-selection-by 2.0) 
	  (set! newmaxa (maxamp index))
	  (IF (fneq newmaxa (* 2.0 maxa)) (snd-display ";scale-selection-by: ~A?" newmaxa))
	  (revert-sound index)
	  (select-all index) 
	  (let ((rread (make-region-sample-reader 0 (car (regions))))
		(sread (make-sample-reader 0 index))
		(rvect (region-samples 0 100 (car (regions))))
		(svect (samples 0 100 index)))
	    (IF (fneq (vector-ref rvect 1) (region-sample 1 (car (regions))))
		(snd-display ";region-sample: ~A ~A?" (region-sample 1 (car (regions))) (vector-ref rvect 1)))
	    (do ((i 0 (1+ i)))
		((= i 100))
	      (let ((rval (next-sample rread))
		    (sval (next-sample sread)))
		(IF (fneq rval sval) (snd-display ";sample-read: ~A ~A?" rval sval))
		(IF (fneq rval (vector-ref rvect i)) (snd-display ";region-samples: ~A ~A?" rval (vector-ref rvect i)))
		(IF (fneq sval (vector-ref svect i)) (snd-display ";samples: ~A ~A?" sval (vector-ref svect i)))))
	    (free-sample-reader rread) 
	    (let ((val0 (next-sample sread)))
	      (IF (sample-reader-at-end? sread) (snd-display "premature end?"))
	      (previous-sample sread)
	      (let ((val1 (previous-sample sread)))
		(IF (fneq val0 val1) (snd-display ";previous-sample: ~A ~A?" val0 val1))))
	    (free-sample-reader sread))))
      (revert-sound index)
      (let ((s100 (sample 100))
	    (s40 (sample 40))
	    (len (frames))
	    (addlen (mus-sound-frames "fyow.snd")))
	(set! (cursor-style) cursor-line)
	(set! (cursor-size) 25)
	(set! (cursor index) 50) 
	(IF (not (= (cursor-style) cursor-line))
	    (snd-display ";cursor-style: ~A? " (cursor-style)))
	(IF (not (= (cursor-size) 25))
	    (snd-display ";cursor-size: ~A? " (cursor-size)))
	(set! (cursor-style) cursor-cross)
	(set! (cursor-size) 15)
	(set! (cursor index 0) 30) 
	(set! (cursor-style) cursor-line)
	(set! (cursor index 0) 20) 
	(if (not (provided? 'snd-nogui))
	    (set! (cursor-style index 0)
		  (lambda (snd chn ax)
		    (let* ((point (cursor-position))
			   (x (car point))
			   (y (cadr point))
			   (size (inexact->exact (/ (cursor-size) 2))))
		      (draw-line (- x size) (- y size) (+ x size) (+ y size) snd chn cursor-context)    
		      (draw-line (- x size) (+ y size) (+ x size) (- y size) snd chn cursor-context)))))
	(set! (cursor index) 50)
	(insert-sound "fyow.snd" (cursor) 0 index 0) 
	(IF (or (fneq (sample 40) s40) (not (fneq (sample 100) s100)) (fneq (sample 100) 0.001831))
	    (snd-display ";insert-sound: ~A?" (sample 100)))
	(IF (not (= (frames) (+ len addlen))) (snd-display ";insert-sound len: ~A?" (frames)))
	(save-sound-as "temporary.snd")
	(insert-samples 0 100 "temporary.snd")
	(revert-sound)
	(let ((id (make-region 0 99)))
	  (insert-region 60 id index) 
	  (IF (not (= (frames) (+ len 100))) (snd-display ";insert-region len: ~A?" (frames)))
	  (IF (fneq (sample 100) s40) (snd-display ";insert-region: ~A ~A?" (sample 100) s40))
	  (let ((var (catch #t (lambda () (insert-region 0 (+ 1000 (apply max (regions))))) (lambda args args))))
	    (IF (not (eq? (car var) 'no-such-region))
		(snd-display ";insert-region bad id: ~A" var)))
	  (save-region id "fmv.snd")
	  (IF (not (= (mus-sound-header-type "fmv.snd") mus-next))
	      (snd-display ";save-region header: ~A?" (mus-header-type-name (mus-sound-header-type "fmv.snd"))))
	  (IF (not (= (mus-sound-data-format "fmv.snd") mus-out-format))
	      (snd-display ";save-region format: ~A?" (mus-data-format-name (mus-sound-data-format "fmv.snd"))))
	  (IF (not (= (mus-sound-srate "fmv.snd") (region-srate id)))
	      (snd-display ";save-region srate: ~A (~A)" (mus-sound-srate "fmv.snd") (region-srate id)))
	  (IF (not (= (mus-sound-chans "fmv.snd") (region-chans id)))
	      (snd-display ";save-region chans: ~A (~A)" (mus-sound-chans "fmv.snd") (region-chans id)))
	  (IF (not (= (mus-sound-frames "fmv.snd") (region-length id)))
	      (snd-display ";save-region length: ~A (~A)" (mus-sound-frames "fmv.snd") (region-length id)))
	  (delete-file "fmv.snd")
	  (save-region id "fmv.snd" mus-riff mus-lshort "this is a comment")
	  (IF (not (= (mus-sound-header-type "fmv.snd") mus-riff))
	      (snd-display ";save-region riff header: ~A?" (mus-header-type-name (mus-sound-header-type "fmv.snd"))))
	  (IF (not (= (mus-sound-data-format "fmv.snd") mus-lshort))
	      (snd-display ";save-region lshort format: ~A?" (mus-data-format-name (mus-sound-data-format "fmv.snd"))))
	  (IF (not (= (mus-sound-frames "fmv.snd") (region-length id)))
	      (snd-display ";save-region length: ~A (~A)" (mus-sound-frames "fmv.snd") (region-length id)))
	  (IF (not (string=? (mus-sound-comment "fmv.snd") "this is a comment"))
	      (snd-display ";save-region comment: ~A" (mus-sound-comment "fmv.snd")))
	  (delete-file "fmv.snd")))
      (close-sound index)
      (let ((var (catch #t (lambda () (new-sound "hi.snd" 0 1 100 0)) (lambda args args))))
	  (IF (not (eq? (car var) 'mus-error))
	      (snd-display ";new-sound bad chan: ~A" var)))
      (set! index (new-sound "fmv.snd" mus-next mus-bshort 22050 2 "unequal lens"))
      (insert-silence 0 1000 index 1)
      (IF (or (not (= (frames index 0) 2))
	      (not (= (frames index 1) 1002)))
	  (snd-display ";silence 1: ~A ~A" (frames index 0) (frames index 1)))
      (save-sound index)
      (IF (or (not (= (frames index 0) 1002))
	      (not (= (frames index 1) 1002)))
	  (snd-display ";saved silence 1: ~A ~A" (frames index 0) (frames index 1)))
      (IF (not (= (mus-sound-frames "fmv.snd") 1002))
	  (snd-display ";saved framers silence 1: ~A" (mus-sound-frames "fmv.snd")))
      (let ((v0 (samples->vct 0 1000 index 0))
	    (v1 (samples->vct 0 1000 index 1)))
	(IF (fneq (vct-peak v0) 0.0)
	    (snd-display ";auto-pad 0: ~A" (vct-peak v0)))
	(IF (fneq (vct-peak v1) 0.0)
	    (snd-display ";silence 0: ~A" (vct-peak v1))))
      (close-sound index)
      (delete-file "fmv.snd")

      (set! index (new-sound "fmv.snd" mus-next mus-bshort 22050 2 "unequal lens"))
      (pad-channel 0 1000 index 1)
      (IF (or (not (= (frames index 0) 2))
	      (not (= (frames index 1) 1002)))
	  (snd-display ";pad-channel 1: ~A ~A" (frames index 0) (frames index 1)))
      (let ((v0 (samples->vct 0 1000 index 0))
	    (v1 (samples->vct 0 1000 index 1)))
	(IF (fneq (vct-peak v0) 0.0)
	    (snd-display ";pad 0: ~A" (vct-peak v0)))
	(IF (fneq (vct-peak v1) 0.0)
	    (snd-display ";pad 1: ~A" (vct-peak v1))))
      (map-channel (lambda (n) 1.0) 0 2 index 0)
      (map-channel (lambda (n) 1.0) 0 1002 index 1)
      (pad-channel 0 1000 index 0 1)
      (IF (not (= (frames index 1) 1002))
	  (snd-display ";pad-channel ed 1: ~A ~A" (frames index 0) (frames index 1)))
      (close-sound index)
      (delete-file "fmv.snd")

      (set! index (new-sound "fmv.snd" mus-ircam mus-bshort 22050 1 "this is a comment"))
      (let ((v0 (make-vct 128)))
	(vct-set! v0 64 .5)
	(vct-set! v0 127 .5)
	(vct->samples 0 128 v0 index 0)
	(make-selection 0 126) 
	(smooth-selection) 
	(set! v0 (samples->vct 0 128 index 0 v0))
	(IF (or (fneq (sample 127) .5) (fneq (sample 120) .4962) (fneq (sample 32) 0.07431) (fneq (sample 64) 0.25308))
	    (snd-display ";smooth-selection: ~A?" v0))
	(revert-sound index)
	(vct-fill! v0 0.0)
	(vct-set! v0 10 .5)
	(vct->samples 0 128 v0 index 0) 
	(select-all) 
	(set! (sinc-width) 40)
	(src-selection 0.5) 
	(set! v0 (samples->vct 0 128 index 0 v0))
	(IF (or (fneq (sample 20) .5) (fneq (sample 30) 0.0) (fneq (sample 17) -.1057) )
	    (snd-display ";src-selection: ~A?" v0))
	(revert-sound index)
	(vct-fill! v0 0.0)
	(vct-set! v0 10 .5)
	(vct->samples 0 128 v0 index 0) 
	(select-all) 
	(filter-selection '(0 0 .1 1 1 0) 40) 
	(set! v0 (samples->vct 0 128 index 0 v0)) 
	(IF (or (fneq (sample 29) .1945) (fneq (sample 39) -.0137) (fneq (sample 24) -0.01986))
	    (snd-display ";filter-selection: ~A?" v0))
	(revert-sound index)
	(vct-fill! v0 1.0)
	(vct->samples 0 128 v0 index 0) 
	(select-all) 
	(filter-selection (make-one-zero :a0 .5 :a1 0.0))
	(set! v0 (samples->vct 0 128 index 0 v0)) 
	(IF (or (fneq (sample 29) .5) (fneq (sample 39) .5) (fneq (sample 24) 0.5))
	    (snd-display ";filter-selection one-zero: ~A?" v0))
	(revert-sound index)
	(vct-fill! v0 1.0)
	(vct->samples 0 128 v0 index 0) 
	(if (file-exists? "fmv5.snd") (delete-file "fmv5.snd"))
	(select-all) 
	(env-selection '(0 0 1 1 2 0) 1.0) 
	(set! v0 (samples->vct 0 128 index 0 v0)) 
	(IF (or (fneq (sample 64) 1.0) (fneq (sample 20) .3125) (fneq (sample 120) 0.125))
	    (snd-display ";env-selection: ~A ~A ~A ~A?" (sample 64) (sample 20) (sample 120) v0))
	(save-selection "fmv5.snd" mus-next mus-bint 22050 "") ;1.0->-1.0 if short
	(revert-sound index)
	(file->array "fmv5.snd" 0 0 128 v0) 
	(IF (or (fneq (vct-ref v0 64) 1.0) (fneq (vct-ref v0 20) .3125) (fneq (vct-ref v0 120) 0.125))
	    (snd-display ";save-selection: ~A ~A ~A ~A?" (vct-ref v0 64) (vct-ref v0 20) (vct-ref v0 120) v0))
	(IF (not (= (mus-sound-header-type "fmv5.snd") mus-next))
	    (snd-display ";save-selection type: ~A?" (mus-header-type-name (mus-sound-header-type "fmv5.snd"))))
	(IF (not (= (mus-sound-data-format "fmv5.snd") mus-bint))
	    (snd-display ";save-selection format: ~A?" (mus-data-format-name (mus-sound-data-format "fmv5.snd"))))
	(IF (not (= (mus-sound-srate "fmv5.snd") 22050))
	    (snd-display ";save-selection srate: ~A?" (mus-sound-srate "fmv5.snd")))
	(vct-fill! v0 0.0)
	(vct-set! v0 100 .5)
	(vct-set! v0 2 -.5)
	(vct->samples 0 128 v0 index 0) 
	(select-all) 
	(without-errors (reverse-selection)) 
	(save-selection "fmv4.snd" mus-riff mus-lfloat 44100 "this is a comment")
	(set! v0 (samples->vct 0 128 index 0 v0)) 
	(IF (or (fneq (sample 27) 0.5) (fneq (sample 125) -.5))
	    (snd-display ";reverse-selection: ~A?" v0))
	(file->array "fmv4.snd" 0 0 128 v0) 
	(IF (or (fneq (sample 27) 0.5) (fneq (sample 125) -.5))
	    (snd-display ";save reverse-selection: ~A?" v0))
	(IF (not (= (mus-sound-header-type "fmv4.snd") mus-riff))
	    (snd-display ";save-selection type 1: ~A?" (mus-header-type-name (mus-sound-header-type "fmv4.snd"))))
	(IF (not (= (mus-sound-data-format "fmv4.snd") mus-lfloat))
	    (snd-display ";save-selection format 1: ~A?" (mus-data-format-name (mus-sound-data-format "fmv4.snd"))))
	(IF (not (= (mus-sound-srate "fmv4.snd") 44100))
	    (snd-display ";save-selection srate 1: ~A?" (mus-sound-srate "fmv4.snd")))
	(IF (not (string=? (mus-sound-comment "fmv4.snd") "this is a comment"))
	    (snd-display ";save-selection comment: ~A?" (mus-sound-comment "fmv4.snd")))
	(delete-file "fmv4.snd")
	(revert-sound index)
	(vct-fill! v0 0.0)
	(vct-set! v0 2 1.0)
	(vct->samples 0 128 v0 index 0) 
	(select-all) 
	(convolve-selection-with "fmv5.snd" .5) 
	(set! v0 (samples->vct 0 128 index 0 v0))
	(IF (fneq (sample 66) -.5) (snd-display ";convolve-selection-with: ~A ~A ~A?" (vct-ref v0 66) (sample 66) v0))
	(close-sound index))
      (let* ((obind (open-sound "oboe.snd"))
	     (vol (maxamp obind))
	     (dur (frames)))
	(set! (amp-control obind) 2.0)
	(IF (fffneq (amp-control obind) 2.0) (snd-display ";set amp-control ~A" (amp-control obind)))
	(reset-controls obind)
	(IF (ffneq (amp-control obind) 1.0) (snd-display ";reset amp-control ~A" (amp-control obind)))
	(set! (amp-control obind) 2.0)
	(IF (eq? (without-errors (apply-controls obind)) 'no-such-sound) (snd-display "apply-controls can't find oboe.snd?"))
	(let ((newamp (maxamp obind)))
	  (IF (> (abs (- (* 2.0 vol) newamp)) .05) (snd-display ";apply amp: ~A -> ~A?" vol newamp))
	  (set! (speed-control obind) 0.5)
	  (apply-controls obind)
	  (let ((newdur (frames obind)))
	    (set! (speed-control obind) 1.0)
	    (IF (not (< (- newdur (* 2.0 dur)) 256)) (snd-display ";apply speed: ~A -> ~A?" dur newdur))
	    ;; within 256 which is apply's buffer size (it always flushes full buffers) 
	    (set! (contrast-control? obind) #t)
	    (set! (contrast-control obind) 1.0)
	    (apply-controls obind)
	    (let ((secamp (maxamp obind))
		  (secdur (frames obind)))
	      (IF (fneq secamp .989) (snd-display ";apply contrast: ~A?" secamp))
	      (IF (not (= secdur newdur)) (snd-display ";apply contrast length: ~A -> ~A?" newdur secdur))
	      (undo 3 obind)
	      (set! (reverb-control? obind) #t)
	      (set! (reverb-control-scale obind) .2)
	      (apply-controls obind)
	      (let ((revamp (maxamp obind))
		    (revdur (frames obind)))
		(IF (fneq revamp .213) (snd-display ";apply reverb scale: ~A?" revamp))
		(IF (not (< (- revdur (+ 50828 (inexact->exact (* (reverb-control-decay) 22050)))) 256)) 
		    (snd-display ";apply reverb length: ~A?" revdur))
		(undo 1 obind)
		(set! (expand-control? obind) #t)
		(set! (expand-control obind) 1.5)
		(apply-controls obind)
		(let ((expamp (maxamp obind))
		      (expdur (frames obind)))
		  (IF (fneq expamp .152) (snd-display ";apply expand-control scale: ~A?" expamp))
		  (IF (not (> expdur (* 1.25 50828))) (snd-display ";apply expand-control length: ~A?" expdur))
		  (undo 1 obind)
		  (set! (filter-control? obind) #t)
		  (set! (filter-control-order obind) 40)
		  (set! (filter-control-env obind) '(0 0 1 .5 1 0))
		  (apply-controls obind)
		  (let ((fltamp (maxamp obind))
			(fltdur (frames obind)))
		    (IF (> (abs (- fltamp .01)) .005) (snd-display ";apply filter scale: ~A?" fltamp))
		    (IF (> (- fltdur (+ 40 50828)) 256) (snd-display ";apply filter length: ~A?" fltdur))
		    (undo obind)))))))
	(revert-sound obind)
	(make-selection 1000 1000)
	(scale-selection-to .1)
	(scale-selection-by 2.0)
	(make-selection 2000 2001)
	(scale-selection-by 2.0)
	(scale-selection-to .5)
	(make-selection 1000 2001)
	(scale-selection-to .5)
	(scale-selection-by .5)
	(make-selection 2000 2000)
	(scale-selection-by 2.0)
	(scale-selection-to .5)
	(make-selection 1000 1001)
	(scale-selection-to .1)
	(scale-selection-by 2.0)
	(make-selection 999 2002)
	(scale-selection-to 1.0)
	(scale-selection-by .5)
	(let ((tree (edit-tree))
	      (true-tree '((0 0 0 998 1.0) 
			   (999 0 999 999 0.999969720840454) 
			   (1000 0 1000 1000 6.09052181243896) 
			   (1001 0 1001 1001 0.999969720840454) 
			   (1002 0 1002 1999 0.499984979629517) 
			   (2000 0 2000 2000 7.54652404785156) 
			   (2001 0 2001 2001 3.7732629776001) 
			   (2002 0 2002 2002 0.999969720840454) 
			   (2003 0 2003 50827 1.0) 
			   (50828 -2 0 0 0.0))))
	  (IF (not (= (length tree) (length true-tree)))
	      (snd-display ";edit trees are not same length: ~A ~A?" (length tree) (length true-tree))
	      (let ((len (length tree)))
		(do ((i 0 (1+ i)))
		    ((= i len))
		  (let ((branch (list-ref tree i))
			(true-branch (list-ref true-tree i)))
		    (IF (or (not (= (car branch) (car true-branch)))
			    (not (= (cadr branch) (cadr true-branch)))
			    (not (= (caddr branch) (caddr true-branch)))
			    (not (= (cadddr branch) (cadddr true-branch)))
			    (fneq (list-ref branch 4) (list-ref true-branch 4)))
			(snd-display ";edit trees disagree at ~D: ~A ~A" i branch true-branch)))))))
	(insert-silence 1001 8)
	(insert-silence 900 50)
	(insert-silence 2005 1)
	(insert-silence 999 2)
	(let ((tree (edit-tree))
	      (true-tree '((0 0 0 899 1.0) 
			   (900 2 0 49 1.0) 
			   (950 0 900 948 1.0) 
			   (999 4 0 1 1.0) 
			   (1001 0 949 998 1.0) 
			   (1051 0 999 999 0.999969720840454) 
			   (1052 0 1000 1000 6.09052181243896) 
			   (1053 1 0 7 1.0) 
			   (1061 0 1001 1001 0.999969720840454)
			   (1062 0 1002 1946 0.499984979629517) 
			   (2007 3 0 0 1.0) 
			   (2008 0 1947 1999 0.499984979629517) 
			   (2061 0 2000 2000 7.54652404785156) 
			   (2062 0 2001 2001 3.7732629776001) 
			   (2063 0 2002 2002 0.999969720840454) 
			   (2064 0 2003 50827 1.0) 
			   (50889 -2 0 0 0.0))))
	  (IF (not (= (length tree) (length true-tree)))
	      (snd-display ";silenced edit trees are not same length: ~A ~A?" (length tree) (length true-tree))
	      (let ((len (length tree)))
		(do ((i 0 (1+ i)))
		    ((= i len))
		  (let ((branch (list-ref tree i))
			(true-branch (list-ref true-tree i)))
		    (IF (or (not (= (car branch) (car true-branch)))
			    (not (= (cadr branch) (cadr true-branch)))
			    (not (= (caddr branch) (caddr true-branch)))
			    (not (= (cadddr branch) (cadddr true-branch)))
			    (fneq (list-ref branch 4) (list-ref true-branch 4)))
			(snd-display ";silenced edit trees disagree at ~D: ~A ~A" i branch true-branch)))))))
	(IF (or (fneq (sample 998) -.03)
		(fneq (sample 999) 0.0)
		(fneq (sample 1000) 0.0)
		(fneq (sample 1001) -.03))
	    (snd-display (format ";insert-silence [999 for 2]: ~A ~A ~A ~A?" (sample 998) (sample 999) (sample 1000) (sample 1001) )))
	(IF (or (fneq (sample 2006) -.033)
		(fneq (sample 2007) 0.0)
		(fneq (sample 2008) -.033))
	    (snd-display (format ";insert-silence [2007 for 1]: ~A ~A ~A?" (sample 2006) (sample 2007) (sample 2008))))
	(revert-sound obind)
	(add-mark 1200 obind 0)
	(let ((mark-num (length (marks obind 0))))
	  (scale-by 2.0 obind 0)
	  (let ((mark-now (length (marks obind 0))))
	    (IF (not (= mark-num mark-now))
		(snd-display ";mark lost after scaling?"))
	    (set! (selection-position) 0)
	    (set! (selection-length) 100)
	    (scale-selection-to .5)
	    (set! mark-now (length (marks obind 0)))
	    (IF (not (= mark-num mark-now))
		(snd-display ";mark lost after selection scaling?")))
	  (let ((m1 (add-mark 1000)))
	    (set! (cursor obind 0) 100)
	    (key (char->integer #\u) 4 obind)
	    (key (char->integer #\1) 0 obind)
	    (key (char->integer #\0) 0 obind)
	    (key (char->integer #\0) 0 obind)
	    (key (char->integer #\o) 4 obind)
	    (IF (not (= (mark-sample m1) 1100))
		(snd-display ";mark after zeros: ~D (1100)? " (mark-sample m1)))))
	(revert-sound obind)
	(let ((frs (frames obind)))
	  (make-region 0 999 obind 0)
	  (IF (not (selection?)) (snd-display ";make-region but no selection? ~A" (selection?)))
	  (delete-selection)
	  (IF (not (= (frames obind) (- frs 1000)))
	      (snd-display ";delete-selection: ~A?" (frames obind)))
	  (let ((val (sample 0 obind 0)))
	    (undo)
	    (IF (fneq (sample 1000) val)
		(snd-display ";delete-selection val: ~A ~A" val (sample 1000)))
	    (insert-selection)
	    (let ((var (catch #t (lambda () (insert-selection 0 obind 123)) (lambda args args))))
	      (IF (not (eq? (car var) 'no-such-channel))
		  (snd-display ";insert-selection bad chan: ~A" var)))
	    (let ((var (catch #t (lambda () (mix-selection 0 obind 123)) (lambda args args))))
	      (IF (not (eq? (car var) 'no-such-channel))
		  (snd-display ";mix-selection bad chan: ~A" var)))
	    (IF (not (= (frames obind) (+ frs 1000)))
		(snd-display ";insert-selection: ~A?" (frames obind)))
	    (IF (fneq (sample 2000) val)
		(snd-display ";insert-selection val: ~A ~A" val (sample 2000)))
	    (set! val (sample 900))
	    (mix-selection)
	    (IF (fneq (sample 900) (* 2 val))
		(snd-display ";mix-selection val: ~A ~A" (* 2 val) (sample 900)))
	    (IF (not (= (frames obind) (+ frs 1000)))
		(snd-display ";mix-selection: ~A?" (frames obind)))))
	(close-sound obind))

      (let* ((ind1 (open-sound "oboe.snd"))
	     (mx1 (maxamp ind1 0))
	     (ind2 (open-sound "2.snd"))
	     (mx20 (maxamp ind2 0))
	     (mx21 (maxamp ind2 1)))
	(select-sound ind1)
	(scale-sound-by 2.0)
	(let ((nmx (maxamp ind1 0)))
	  (IF (fneq (* 2 mx1) nmx) (snd-display ";scale-sound-by 2.0: ~A ~A?" mx1 nmx))
	  (IF (not (equal? (edit-fragment 1 ind1 0) (list "scale-channel 2.0000 0 50828" "lambda" 0 50828)))
	      (snd-display ";scale-sound-by: ~A?" (edit-fragment 1 ind1 0))))
	(scale-sound-to 0.5)
	(let ((nmx (maxamp ind1 0)))
	  (IF (fneq nmx 0.5) (snd-display ";scale-sound-to 0.5: ~A?" nmx))
	  (IF (not (equal? (edit-fragment 2 ind1 0) (list "scale-channel 1.6978 0 50828" "lambda" 0 50828)))
	      (snd-display ";scale-sound-to: ~A?" (edit-fragment 2 ind1 0))))
	(scale-sound-by 0.0 0 1000 ind1 0)
	(let ((nmx (maxamp ind1 0)))
	  (IF (fneq 0.5 nmx) (snd-display ";scale-sound-by 0.0: ~A ~A?" mx1 nmx))
	  (IF (not (equal? (edit-fragment 3 ind1 0) (list "scale-channel 0.0000 0 1000" "lambda" 0 1000)))
	      (snd-display ";scale-sound-by 0.0: ~A?" (edit-fragment 3 ind1 0))))
	(let* ((v (samples->vct 0 1000 ind1 0))
	       (pk (vct-peak v)))
	  (IF (fneq pk 0.0) (snd-display ";scale-sound-by 0.0 [0:1000]: ~A?" pk)))
	(revert-sound ind1)
	(let ((oldv (samples->vct 12000 10 ind1 0)))
	  (scale-sound-by 2.0 12000 10 ind1 0)
	  (let ((newv (samples->vct 12000 10 ind1 0)))
	    (do ((i 0 (1+ i)))
		((= i 10))
	      (IF (fneq (* 2.0 (vct-ref oldv i)) (vct-ref newv i))
		  (snd-display ";scale ~D: ~A ~A?" i (vct-ref oldv i) (vct-ref newv i)))))
	  (IF (not (equal? (edit-fragment 1 ind1 0) (list "scale-channel 2.0000 12000 10" "lambda" 12000 10)))
	      (snd-display ";scale-sound-by 2.0 [12000:10]: ~A?" (edit-fragment 1 ind1 0))))
	(revert-sound ind1)
	(select-sound ind2)
	(scale-sound-by 2.0)
	(let ((nmx (maxamp ind2 0)))
	  (IF (fneq (* 2 mx20) nmx) (snd-display ";2:0 scale-sound-by 2.0: ~A ~A?" mx20 nmx)))
	(let ((nmx (maxamp ind2 1)))
	  (IF (fneq (* 2 mx21) nmx) (snd-display ";2:1 scale-sound-by 2.0: ~A ~A?" mx21 nmx)))
	(scale-sound-to 0.5)
	(let ((nmx (max (maxamp ind2 0) (maxamp ind2 1))))
	  (IF (fneq nmx 0.5) (snd-display ";2 scale-sound-to 0.5: ~A (~A)?" nmx (maxamp ind2))))
	(scale-sound-by 0.0 0 1000 ind2 1)
	(IF (not (equal? (edit-fragment 3 ind2 1) (list "scale-channel 0.0000 0 1000" "lambda" 0 1000)))
	    (snd-display ";2:1 scale-sound-by 0.0: ~A?" (edit-fragment 3 ind2 1)))
	(let* ((v (samples->vct 0 1000 ind2 1))
	       (pk (vct-peak v)))
	  (IF (fneq pk 0.0) (snd-display ";2:1 scale-sound-by 0.0 [0:1000]: ~A?" pk)))
	(revert-sound ind2)
	(let ((oldv (samples->vct 12000 10 ind2 0)))
	  (scale-sound-by 2.0 12000 10 ind2 0)
	  (let ((newv (samples->vct 12000 10 ind2 0)))
	    (do ((i 0 (1+ i)))
		((= i 10))
	      (IF (fneq (* 2.0 (vct-ref oldv i)) (vct-ref newv i))
		  (snd-display ";2 scale ~D: ~A ~A?" i (vct-ref oldv i) (vct-ref newv i))))))
	(revert-sound ind2)
	(set! (sync ind2) 3)
	(set! (sync ind1) 3)
	(scale-sound-by 2.0)
	(let ((nmx (maxamp ind1 0)))
	  (IF (fneq mx1 nmx) (snd-display ";sync scale-sound-by 2.0: ~A ~A?" mx1 nmx)))
	(let ((nmx (maxamp ind2 0)))
	  (IF (fneq (* 2 mx20) nmx) (snd-display ";2:0 sync scale-sound-by 2.0: ~A ~A?" mx20 nmx)))
	(let ((nmx (maxamp ind2 1)))
	  (IF (fneq (* 2 mx21) nmx) (snd-display ";2:1 sync scale-sound-by 2.0: ~A ~A?" mx21 nmx)))
	(scale-sound-to 1.0 20000 40000 ind2 1)
	(let ((nmx (maxamp ind1 0)))
	  (IF (fneq mx1 nmx) (snd-display ";sync scale-sound-to 1.0: ~A ~A?" mx1 nmx)))
	(let ((nmx (maxamp ind2 0)))
	  (IF (fneq (* 2 mx20) nmx) (snd-display ";2:0 sync scale-sound-to 1.0: ~A ~A?" mx20 nmx)))
	(let ((nmx (maxamp ind2 1)))
	  (IF (fneq nmx 1.0) (snd-display ";2:1 sync scale-sound-to 1.0: ~A?" nmx)))

	(close-sound ind1)
	(close-sound ind2))

      (let* ((ind (open-sound "oboe.snd"))
	     (cur-amp (amp-control ind)))
	(set! (amp-control ind) .5)
	(IF (ffneq (amp-control ind) .5) (snd-display ";amp-control (.5): ~A?" (amp-control ind)))
	(set! (amp-control ind 0) .25)
	(IF (ffneq (amp-control ind) .5) (snd-display ";amp-control after local set (.5): ~A?" (amp-control ind)))
	(IF (ffneq (amp-control ind 0) .25) (snd-display ";amp-control 0 (.25): ~A?" (amp-control ind 0)))
	(set! (amp-control ind) 1.0)
	(IF (ffneq (amp-control ind) 1.0) (snd-display ";amp-control (1.0): ~A?" (amp-control ind)))
	(IF (ffneq (amp-control ind 0) .25) (snd-display ";amp-control 0 after set (.25): ~A?" (amp-control ind 0)))
	(close-sound ind)
	(set! ind (open-sound "4.aiff"))
	(IF (ffneq (amp-control ind) 1.0) (snd-display ";amp-control upon open (1.0): ~A?" (amp-control ind)))
	(IF (ffneq (amp-control ind 2) 1.0) (snd-display ";amp-control 2 upon open (1.0): ~A?" (amp-control ind 2)))
	(set! (amp-control ind) .5)
	(IF (ffneq (amp-control ind 2) .5) (snd-display ";amp-control 2 after global set (.5): ~A?" (amp-control ind 2)))
	(set! (amp-control ind 2) .25)
	(IF (ffneq (amp-control ind 2) .25) (snd-display ";amp-control 2 (.25): ~A?" (amp-control ind 2)))
	(IF (ffneq (amp-control ind 1) .5) (snd-display ";amp-control 1 after local set (.5): ~A?" (amp-control ind 1)))
	(let ((before-ran #f)
	      (after-ran #f))
	  (add-hook! after-apply-hook (lambda (snd) (set! after-ran snd)))
	  (add-hook! before-apply-hook (lambda (snd) (set! before-ran snd)))
	  (apply-controls ind)
	  (IF (not (= ind before-ran)) (snd-display ";before-apply-hook: ~A?" before-ran))
	  (IF (not (= ind after-ran)) (snd-display ";after-apply-hook: ~A?" after-ran))
	  (reset-hook! before-apply-hook)
	  (reset-hook! after-apply-hook))
	(close-sound ind))

      (let* ((obind (open-sound "4.aiff"))
	     (amps (maxamp obind #t)))
	(IF (< (window-width) 600) 
	    (set! (window-width) 600))
	(IF (< (window-height) 600)
	    (set! (window-height) 600))
	(set! (x-bounds obind 0) (list 0.0 0.1))
	(update-time-graph)
	(set! (amp-control obind) 0.1)
	(select-channel 2)
	(IF (eq? (without-errors (apply-controls obind 1)) 'no-such-sound) (snd-display "apply-controls can't find 4.aiff?"))
	(let ((newamps (maxamp obind #t)))
	  (IF (or (fneq (car amps) (car newamps))
		  (fneq (cadr amps) (cadr newamps))
		  (> (abs (- (* 0.1 (caddr amps)) (caddr newamps))) .05)
		  (fneq (cadddr amps) (cadddr newamps)))
	      (snd-display ";apply amps:~%  ~A ->~%  ~A?" amps newamps))
	  (undo 1 obind 2)
	  (set! (amp-control obind) 0.1)
	  (make-region 0 (frames obind) obind 1)
	  (without-errors (apply-controls obind 2))
	  (set! newamps (maxamp obind #t))
	  (IF (or (fneq (car amps) (car newamps))
		  (> (abs (- (* 0.1 (cadr amps)) (cadr newamps))) .05)
		  (fneq (caddr amps) (caddr newamps))
		  (fneq (cadddr amps) (cadddr newamps)))
	      (snd-display ";apply selection amp:~%  ~A ->~%  ~A?" amps newamps))
	  (if (not (provided? 'snd-nogui))
	      (let* ((axinfo (axis-info obind 0 time-graph))
		     (losamp (car axinfo))
		     (hisamp (cadr axinfo))
		     (x0 (list-ref axinfo 2))
		     (y0 (list-ref axinfo 3))
		     (x1 (list-ref axinfo 4))
		     (y1 (list-ref axinfo 5))
		     (xpos (+ x0 (* .5 (- x1 x0))))
		     (ypos (+ y0 (* .75 (- y1 y0)))))
		(define (cp-x x) (inexact->exact (+ (list-ref axinfo 10) 
						    (* (- x x0) (/ (- (list-ref axinfo 12) (list-ref axinfo 10)) 
								   (- x1 x0))))))
		(define (cp-y y) (inexact->exact (+ (list-ref axinfo 13) 
						    (* (- y1 y) (/ (- (list-ref axinfo 11) (list-ref axinfo 13)) 
								   (- y1 y0))))))
		(set! (cursor obind) 100)
		(let ((xy (cursor-position obind)))
		  (IF (fneq (position->x (car xy)) (/ (cursor obind) (srate obind)))
		      (snd-display ";cursor-position: ~A ~A ~A?" (car xy) (position->x (car xy)) (/ (cursor obind) (srate obind)))))
		(IF (fneq (position->x (x->position xpos)) xpos)
		    (snd-display ";x<->position: ~A ~A?" (position->x (x->position xpos)) xpos))
		(IF (> (abs (- (position->y (y->position ypos)) ypos)) .5)
		    (snd-display ";y<->position: ~A ~A?" (position->y (y->position ypos)) ypos))
		(IF (not (= losamp (left-sample obind 0)))
		    (snd-display ";axis-info[0 losamp]: ~A ~A?" losamp (left-sample obind 0)))
		(IF (not (= hisamp (right-sample obind 0)))
		    (snd-display ";axis-info[1 hisamp]: ~A ~A?" hisamp (right-sample obind 0)))
		(IF (fneq (list-ref axinfo 6) 0.0)
		    (snd-display ";axis-info[6 xmin]: ~A?" (list-ref axinfo 6)))
		(IF (fneq (list-ref axinfo 7) -1.0)
		    (snd-display ";axis-info[7 ymin]: ~A?" (list-ref axinfo 7)))
		(IF (fneq (list-ref axinfo 9) 1.0)
		    (snd-display ";axis-info[9 ymax]: ~A?" (list-ref axinfo 9)))
		(IF (> (abs (apply - (our-x->position obind x0))) 1) 
		    (snd-display ";x0->position: ~A?" (our-x->position obind x0)))
		(IF (> (abs (apply - (our-x->position obind x1))) 1) 
		    (snd-display ";x1->position: ~A?" (our-x->position obind x1)))
		(IF (> (abs (apply - (our-x->position obind (* 0.5 (+ x0 x1))))) 1)
		    (snd-display ";xmid->position: ~A?" (our-x->position obind (* 0.5 (+ x0 x1)))))
		(IF (not full-test)
		    (begin
		      (IF (> (abs (- (x->position xpos) (cp-x xpos))) 1)
			  (snd-display ";cp-x .5: ~A ~A?" (x->position xpos) (cp-x xpos)))
		      (IF (> (abs (- (y->position ypos) (cp-y ypos))) 1)
			  (snd-display ";cp-y .75: ~A ~A?" (y->position ypos) (cp-y ypos)))
		      (do ((i 0 (1+ i)))
			  ((= i 10))
			(let ((xpos (+ x0 (my-random (- x1 x0))))
			      (ypos (+ y0 (my-random (- y1 y0)))))
			  (IF (> (abs (- (x->position xpos) (cp-x xpos))) 1)
			      (snd-display ";cp-x[~A] ~A: ~A ~A?" i xpos (x->position xpos) (cp-x xpos)))
			  (IF (> (abs (- (y->position ypos) (cp-y ypos))) 1)
			      (snd-display ";cp-y[~A] ~A: ~A ~A?" i ypos (y->position ypos) (cp-y ypos)))
			  (IF (fneq (position->x (cp-x xpos)) xpos)
			      (snd-display ";x->position cp-x ~A ~A" xpos (position->x (cp-x xpos))))
			  (IF (fffneq (position->y (cp-y ypos)) ypos)
			      (snd-display ";y->position cp-y ~A ~A" ypos (position->y (cp-y ypos))))))))
		(set! (left-sample obind 0) 1234)
		(IF (not (= 1234 (car (axis-info obind 0))))
		    (snd-display ";axis-info[0 losamp at 1234]: ~A ~A?" (car (axis-info obind 0)) (left-sample obind 0)))
		(set! x0 (list-ref axinfo 2))
		(set! x1 (list-ref axinfo 4))
		(IF (> (abs (apply - (our-x->position obind x0))) 1) 
		    (snd-display ";x0a->position: ~A?" (our-x->position obind x0)))
		(IF (> (abs (apply - (our-x->position obind x1))) 1) 
		    (snd-display ";x1a->position: ~A?" (our-x->position obind x1)))
		(IF (> (abs (apply - (our-x->position obind (* 0.5 (+ x0 x1))))) 1)
		    (snd-display ";xmida->position: ~A?" (our-x->position obind (* 0.5 (+ x0 x1)))))
		(set! (y-bounds obind 0) (list -2.0 3.0))
		(IF (fneq (list-ref (axis-info obind 0) 7) -2.0)
		    (snd-display ";axis-info[7 ymin -2.0]: ~A?" (list-ref (axis-info obind 0) 7)))
		(IF (fneq (list-ref (axis-info obind 0) 9) 3.0)
		    (snd-display ";axis-info[9 ymax 3.0]: ~A?" (list-ref (axis-info obind 0) 9)))
		
		))
	  (close-sound obind)))

      (let ((ind1 (open-sound "oboe.snd")))
	(test-orig (lambda (snd) (src-sound 2.0 ind1)) (lambda (snd) (src-sound 0.5 ind1)) 'src-sound ind1)
	(test-orig (lambda (snd) (src-channel 2.0)) (lambda (snd) (src-channel 0.5)) 'src-channel ind1)
	(test-orig (lambda (snd) (scale-by 2.0 ind1)) (lambda (snd) (scale-by 0.5 ind1)) 'scale-by ind1)
	(test-orig (lambda (snd) (scale-sound-by 2.0 ind1)) (lambda (snd) (scale-sound-by 0.5 ind1)) 'scale-sound-by ind1)
	(test-orig (lambda (snd) (scale-channel 2.0)) (lambda (snd) (scale-channel 0.5)) 'scale-channel ind1)
	(test-orig (lambda (snd) (reverse-sound ind1)) (lambda (snd) (reverse-sound ind1)) 'reverse-sound ind1)
	(test-orig (lambda (snd) (reverse-channel)) (lambda (snd) (reverse-channel)) 'reverse-channel ind1)
	(test-orig (lambda (snd) (env-sound '(0 1.0 1 2.0) ind1)) (lambda (snd) (env-sound '(0 1.0 1 0.5) ind1)) 'env-sound ind1)
	(test-orig (lambda (snd) (env-sound '(0 1.0 1 2.0 2 1.0) ind1)) (lambda (snd) (env-sound '(0 1.0 1 0.5 2 1.0) ind1)) 'env-sound ind1)
	(test-orig (lambda (snd) (env-channel (make-env :envelope '(0 1.0 1 2.0) :end (frames))))
		   (lambda (snd) (env-channel (make-env :envelope '(0 1.0 1 0.5) :end (frames)))) 'env-channel ind1)
	(test-orig (lambda (snd) (env-channel (make-env :envelope '(0 2 1 2 2 0.5 3 0.5) :base 0 :end (frames))))
		   (lambda (snd) (env-channel (make-env :envelope '(0 0.5 1 0.5 2 2 3 2) :base 0 :end (frames)))) 'env-channel ind1)
	(test-orig (lambda (snd) (map-channel (lambda (n) (* n 2)))) (lambda (snd) (map-channel (lambda (n) (* n 0.5)))) 'map-channel ind1)
	(test-orig (lambda (snd) (map-chan (lambda (n) (* n 2)))) (lambda (snd) (map-chan (lambda (n) (* n 0.5)))) 'map-chan ind1)
	(test-orig (lambda (snd) (pad-channel 1000 2000 ind1)) (lambda (snd) (delete-samples 1000 2000 ind1)) 'pad-channel ind1)
	(test-orig (lambda (snd) (clm-channel (make-one-zero :a0 2.0 :a1 0.0)))
		   (lambda (snd) (clm-channel (make-one-zero :a0 0.5 :a1 0.0))) 'clm-channel ind1)
	(test-orig (lambda (snd) (filter-sound (make-one-zero :a0 2.0 :a1 0.0) 0 ind1 0)) 
		   (lambda (snd) (filter-sound (make-one-zero :a0 0.5 :a1 0.0)) 0 ind1 0) 'filter-sound ind1)

	(let ((var (catch #t (lambda () (src-sound '(0 0 1 1))) (lambda args args))))
	  (IF (not (eq? (car var) 'mus-error))
	      (snd-display ";src-sound env at 0: ~A" var)))
	(let ((var (catch #t (lambda () (src-sound '(0 1 1 -1))) (lambda args args))))
	  (IF (not (eq? (car var) 'mus-error))
	      (snd-display ";src-sound env through 0: ~A" var)))

	(scale-to 1.0 ind1)
	(let ((v0 (make-vct 10))
	      (v1 (samples->vct 12000 10 ind1 0)))
	  (vct-set! v0 0 1.0)
	  (array->file "fmv3.snd" v0 10 22050 1)
	  (copy-file "oboe.snd" "fmv4.snd")
	  (convolve-with "fmv3.snd" 1.0 ind1)
	  (convolve-files "fmv4.snd" "fmv3.snd" 1.0 "fmv5.snd")
	  (let ((v2 (samples->vct 12000 10 ind1 0)))
	    (IF (not (vfequal v1 v2))
		(snd-display ";~A (orig: 0) ~A ~A" 'convolve-with v1 v2))
	    (file->array "fmv5.snd" 0 12000 10 v2)
	    (IF (not (vfequal v1 v2))
		(snd-display ";convolve-files: (orig: 0) ~A ~A" v1 v2)))
	  (delete-file "fmv3.snd")
	  (delete-file "fmv5.snd"))
	(convolve-files "2.snd" "oboe.snd" 0.5 "fmv5.snd")
	(IF (fneq (cadr (mus-sound-maxamp "fmv5.snd")) 0.5) (snd-display ";convolve-files stereo: ~A" (mus-sound-maxamp "fmv5.snd")))
	(delete-file "fmv5.snd")
	(scale-to .25 ind1)
	(set! (y-bounds ind1) '())
	(IF (not (equal? (y-bounds ind1) (list -.25 .25)))
	    (snd-display ";y-bounds '(): ~A?" (y-bounds ind1)))
	(revert-sound ind1)

	(scale-to 1.0 ind1)
	(let ((v0 (make-vct 10))
	      (v1 (samples->vct 12000 10 ind1 0)))
	  (vct-set! v0 5 1.0)
	  (array->file "fmv3.snd" v0 10 22050 1)
	  (convolve-with "fmv3.snd" 1.0 ind1)
	  (convolve-files "fmv4.snd" "fmv3.snd" 1.0 "fmv5.snd")
	  (let ((v2 (samples->vct 12005 10 ind1 0)))
	    (IF (not (vfequal v1 v2))
		(snd-display ";~A (orig: 2) ~A ~A" 'convolve-with v1 v2))
	    (file->array "fmv5.snd" 0 12005 10 v2)
	    (IF (not (vfequal v1 v2))
		(snd-display ";convolve-files: (orig: 2) ~A ~A" v1 v2)))
	  (delete-file "fmv3.snd")
	  (delete-file "fmv4.snd")
	  (delete-file "fmv5.snd"))

	(revert-sound ind1)
	(let ((old-val (selection-creates-region))
	      (old-regions (regions)))
	  (set! (selection-creates-region) #f)
	  (select-all ind1)
	  (set! (selection-creates-region) old-val)
	  (IF (not (equal? old-regions (regions)))
	      (snd-display ";selection-create-region: ~A -> ~A?" old-regions (regions))))
	(convolve-selection-with "pistol.snd" (maxamp))
	(let ((data (samples->vct 12000 10 ind1 0)))
	  (convolve-with "pistol.snd" (maxamp ind1 0 0) ind1 0 0)
	  (let ((new-data (samples->vct 12000 10 ind1 0)))
	    (IF (not (vfequal data new-data))
		(snd-display ";convolve-selection-with: ~A ~A?" data new-data))))
	(revert-sound ind1)
	(make-selection 1000 2000 ind1)
	(let ((ma (maxamp ind1)))
	  (convolve-selection-with "pistol.snd" ma)
	  (IF (fneq (maxamp ind1) ma) (snd-display ";convolve-selection-with 1000: ~A ~A?" ma (maxamp ind1))))
	(make-selection 1000 2000 ind1)
	(let ((id (make-region)))
	  (IF (not (region? id))
	      (snd-display ";make-region argless: ~A" id))
	  (IF (not (= (region-length id) (selection-length)))
	      (snd-display ";region/selection-lengths: ~A ~A?" (region-length id) (selection-length)))
	  (IF (fneq (region-sample 0 id) (sample 1000 ind1))
	      (snd-display ";region-sample from make-region: ~A ~A?" (region-sample 0 id) (sample 1000 ind1))))
	(close-sound ind1))

      (let ((ind1 (open-sound "2.snd")))
	(let ((v0 (samples->vct 12000 10 ind1 0))
	      (v1 (samples->vct 12000 10 ind1 1)))
	  (swap-channels ind1)
	  (let ((v2 (samples->vct 12000 10 ind1 0))
		(v3 (samples->vct 12000 10 ind1 1)))
	    (IF (or (vequal v0 v2)
		    (vequal v1 v3))
		(snd-display ";swap-channels 0: no change! ~A ~A ~A ~A" v0 v2 v1 v3)))
	  (swap-channels ind1)
	  (let ((v2 (samples->vct 12000 10 ind1 0))
		(v3 (samples->vct 12000 10 ind1 1)))
	    (IF (or (not (vequal v0 v2))
		    (not (vequal v1 v3)))
		(snd-display ";swap-channels 1: ~A ~A ~A ~A" v0 v2 v1 v3)))
	  ;; as long as we're here...
	  (set! (cursor ind1 0) 100)
	  (set! (cursor ind1 1) 200)
	  (IF (or (not (= (cursor ind1 0) 100)) 
		  (not (= (cursor ind1 1) 200)))
	      (snd-display ";cursor: ~A ~A?" (cursor ind1 0) (cursor ind1 1)))
	  (forward-sample 10 ind1 0)
	  (forward-sample -10 ind1 1)
	  (IF (or (not (= (cursor ind1 0) 110)) 
		  (not (= (cursor ind1 1) 190)))
	      (snd-display ";cursor (1): ~A ~A?" (cursor ind1 0) (cursor ind1 1)))
	  (backward-sample -10 ind1 0)
	  (backward-sample 10 ind1 1)
	  (IF (or (not (= (cursor ind1 0) 120)) 
		  (not (= (cursor ind1 1) 180)))
	      (snd-display ";cursor (2): ~A ~A?" (cursor ind1 0) (cursor ind1 1)))
	  (close-sound ind1)))

      (let ((ind1 (open-sound "oboe.snd"))
	    (ind2 (open-sound "2.snd")))
	(let ((ups1 (count-matches (lambda (n) (> n .1)) 0 ind1 0))
	      (ups2 (let ((count 0))
		      (scan-chan (lambda (n)
				   (if (> n .1)
				       (set! count (+ count 1)))
				   #f)
				 0 (frames ind1) ind1 0)
		      count)))
	  (IF (not (= ups1 ups2))
	      (snd-display ";scan-chan: ~A ~A?" ups1 ups2))
	  (set! ups1 (count-matches (lambda (n) (> n .03)) 0 ind2 0))
	  (set! ups2 (count-matches (lambda (n) (> n .03)) 0 ind2 1))
	  (let ((ups3 (let ((count 0))
			(scan-chan (lambda (n)
				     (if (> n .03)
					 (set! count (+ count 1)))
				     #f)
				   0 (frames ind2) ind2 0)
			count))
		(ups4 (let ((count 0))
			(scan-chan (lambda (n)
				     (if (> n .03)
					 (set! count (+ count 1)))
				     #f)
				   0 (frames ind2) ind2 1)
			count)))
	    (IF (not (= ups1 ups3))
		(snd-display ";2[0] scan-chan: ~A ~A?" ups1 ups3))
	    (IF (not (= ups2 ups4))
		(snd-display ";2[1] scan-chan: ~A ~A?" ups2 ups4)))

	  (set! (sync ind2) #t)
	  (let ((total
		 (let ((count 0)) 
		   (scan-chans (lambda (n) 
				 (if (> n .03) 
				     (set! count (+ count 1))) 
				 #f))
		   count)))
	    (IF (not (= total (+ ups1 ups2)))
		(snd-display ";scan-chans: ~A ~A?" total (+ ups1 ups2))))
	  (set! (sync ind2) #f)
	  (let ((total
		 (let ((count 0)) 
		   (scan-sound-chans (lambda (n) 
				       (if (> n .03) 
					   (set! count (+ count 1))) 
				       #f)
				     0 (frames ind2) ind2)
		   count)))
	    (IF (not (= total (+ ups1 ups2)))
		(snd-display ";scan-sound-chans: ~A ~A?" total (+ ups1 ups2))))
	  (set! (sync ind2) #f)
	  (let ((total
		 (let ((count 0)) 
		   (scan-across-all-chans (lambda (nd len) 
					    (do ((i 0 (1+ i)))
						((= i len) #f) 
					      (if (> (vector-ref nd i) .03) 
						  (set! count (+ count 1))))))
		   count))
		(ups3 (count-matches (lambda (n) (> n .03)) 0 ind1 0)))
	    (IF (not (= total (+ ups1 ups2 ups3)))
		(snd-display ";scan-across-all-chans: ~A ~A?" total (+ ups1 ups2 ups3))))
	  (let ((total
		 (let ((count 0)) 
		   (scan-all-chans (lambda (n) 
				     (if (> n .03)
					 (set! count (+ count 1)))
				     #f))
		   count))
		(ups3 (count-matches (lambda (n) (> n .03)) 0 ind1 0)))
	    (IF (not (= total (+ ups1 ups2 ups3)))
		(snd-display ";scan-all-chans: ~A ~A?" total (+ ups1 ups2 ups3)))))

	(select-sound ind1)
	(forward-graph)
	(IF (or (not (= (selected-sound) ind2))
		(not (= (selected-channel) 0)))
	    (snd-display ";forward from ~A 0 to ~A ~A?" ind1 (selected-sound) (selected-channel)))
	(forward-graph)
	(IF (or (not (= (selected-sound) ind2))
		(not (= (selected-channel) 1)))
	    (snd-display ";forward from ~A 0 to ~A ~A?" ind2 (selected-sound) (selected-channel)))
	(forward-graph 1)
	(IF (or (not (= (selected-sound) ind1))
		(not (= (selected-channel) 0)))
	    (snd-display ";forward from ~A 1 to ~A ~A?" ind2 (selected-sound) (selected-channel)))
	(forward-graph 2)
	(IF (or (not (= (selected-sound) ind2))
		(not (= (selected-channel) 1)))
	    (snd-display ";forward from ~A 0 to ~A ~A?" ind1 (selected-sound) (selected-channel)))
	(forward-graph 0)
	(IF (or (not (= (selected-sound) ind2))
		(not (= (selected-channel) 1)))
	    (snd-display ";forward 0 from ~A 1 to ~A ~A?" ind2 (selected-sound) (selected-channel)))
	(backward-graph 2)
	(IF (or (not (= (selected-sound) ind1))
		(not (= (selected-channel) 0)))
	    (snd-display ";backward 2 from ~A 1 to ~A ~A?" ind2 (selected-sound) (selected-channel)))
	(backward-graph)
	(IF (or (not (= (selected-sound) ind2))
		(not (= (selected-channel) 1)))
	    (snd-display ";backward 2 from ~A 0 to ~A ~A?" ind1 (selected-sound) (selected-channel)))

	(close-sound ind1)
	(close-sound ind2))

      (let ((ind1 (open-sound "oboe.snd"))
	    (ind2 (open-sound "2.snd")))
	(let ((ups1 (maxamp ind1 0))
	      (ups2 (maxamp ind2 #t)))
	  (map-chan (lambda (n)
		      (* n 2.0))
		    0 (frames ind1) "times 2" ind1 0)
	  (map-sound-chans (lambda (n)
			     (* n 2.0))
			   0 (frames ind2) "times 2" ind2)
	  (let ((ups3 (maxamp ind1 0))
		(ups4 (maxamp ind2 #t)))
	    (IF (fneq ups3 (* ups1 2.0))
		(snd-display ";map-chan: ~A ~A?" ups3 (* ups1 2.0)))
	    (IF (or (fneq (car ups4) (* (car ups2) 2.0))
		    (fneq (cadr ups4) (* (cadr ups2) 2.0)))
		(snd-display ";map-sound-chans: ~A ~A?" (map (lambda (n) (* 2 n)) ups2) ups4)))
	  
	  (set! (sync ind2) #t)
	  (set! (sync ind1) #t)
	  (map-chans (lambda (n) (* n 0.5)))
	  (let ((ups3 (maxamp ind1 0))
		(ups4 (maxamp ind2 #t)))
	    (IF (fneq ups3 ups1)
		(snd-display ";map-chans: ~A ~A?" ups3 ups1))
	    (IF (or (fneq (car ups4) (car ups2))
		    (fneq (cadr ups4) (cadr ups2)))
		(snd-display ";map-chans: ~A ~A?" ups2 ups4)))
	  (set! (sync ind1) #f)

	  (let ((len-err #f))
	    (map-across-all-chans (lambda (data len)
				    (if (not (= len 3))
					(set! len-err len)
					(begin
					  (vector-set! data 0 (* (vector-ref data 0) 4.0))
					  (let ((chan0-sample (vector-ref data 1)))
					    (vector-set! data 1 (vector-ref data 2))
					    (vector-set! data 2 chan0-sample))))
				    data))

	    (IF (number? len-err)
		(snd-display ";map-across-all-chans len: ~A?" len-err))
	    (let ((ups3 (maxamp ind1 0))
		  (ups4 (maxamp ind2 #t)))
	      (IF (fneq ups3 (* 4 ups1))
		  (snd-display ";map-across-all-chans 1: ~A ~A?" ups3 ups1))
	      (IF (or (fneq (car ups4) (cadr ups2))
		      (fneq (car ups4) (cadr ups2)))
		  (snd-display ";map-across-all-chans 2: ~A ~A?" ups2 ups4))))
	  (revert-sound ind1)
	  (revert-sound ind2)
	  (map-all-chans (lambda (n) (* n 4.0)))

	  (let ((ups3 (maxamp ind1 0))
		(ups4 (maxamp ind2 0))
		(ups5 (maxamp ind1 0 0))
		(ups6 (maxamp ind2 0 0)))
	    (IF (fneq ups3 (* 4 ups5))
		(snd-display ";map-all-chans: ~A ~A?" ups3 ups5))
	    (IF (fneq ups4 (* 4 ups6))
		(snd-display ";map-all-chans(2): ~A ~A?" ups4 ups6)))
  
	  (close-sound ind1)
	  (close-sound ind2)))

      (let* ((ind1 (open-sound "oboe.snd"))
	     (len (frames ind1))
	     (ctr 0))
	(map-chan (lambda (n)
		    (if (= ctr 1) (set! ctr 0) (set! ctr 1))
		    (if (= ctr 0)
			(* n 2.0)
			#f))
		  0 (frames ind1) "cut 2" ind1 0)
	(IF (> (frames ind1) (+ (* len 2) 1))
	    (snd-display ";map-chan cut: ~A ~A?" len (frames ind1)))
	(revert-sound ind1)
	(set! ctr 0)
	(map-chan (lambda (n)
		    (set! ctr (1+ ctr))
		    (if (> ctr 3)
			#t
			n))
		  0 (frames ind1) "cut none" ind1 0)
	(IF (> ctr 4)
	    (snd-display ";map-chan no-edit count: ~A?" ctr))
	(revert-sound ind1)
	(let ((v1 (make-vct 2)))
	  (map-chan (lambda (n)
		      (vct-set! v1 0 n)
		      (vct-set! v1 1 (* n 3))
		      v1)
		    0 (frames ind1) "cut 2" ind1 0))
	(IF (> (abs (- (frames ind1) (* len 2))) 3)
	    (snd-display ";map-chan double: ~A ~A?" len (frames ind1)))
	(close-sound ind1))
      (let* ((ind1 (open-sound "oboe.snd")))
	(test-edpos maxamp 'maxamp (lambda () (scale-by 2.0 ind1 0)) ind1)
	(test-edpos frames 'frames (lambda () (src-sound 2.0 ind1 0)) ind1)
	(test-edpos 
	 (lambda* (#:optional (snd 0) (chn 0) (edpos current-edit-position)) (count-matches (lambda (n) (> n .1)) 0 snd chn edpos)) 
	 'count-matches
	 (lambda () (scale-by 2.0 ind1 0)) 
	 ind1)
	(test-edpos 
	 (lambda* (#:optional (snd 0) (chn 0) (edpos current-edit-position)) (cadr (find (lambda (n) (> n .1)) 0 snd chn edpos)))
	 'find
	 (lambda () (delete-samples 0 100 ind1 0))
	 ind1)
	(test-edpos 
	 (lambda* (#:optional (snd 0) (chn 0) (edpos current-edit-position)) 
		  (let ((samp 0)) 
		    (scan-chan (lambda (n) 
				 (if (> n .1) 
				     samp 
				     (begin 
				       (set! samp (1+ samp)) 
				       #f)))
			       0 (frames snd chn) snd chn edpos)
		    samp))
	 'scan-chan
	 (lambda () (delete-samples 0 100 ind1 0))
	 ind1)

	(src-sound 2.0 ind1 0)
	(play-and-wait 0 ind1 0 #f #f 0)
	(play-and-wait 0 ind1 0 #f #f 1)
	(play-and-wait 0 ind1 0 #f #f (lambda (snd chn) (edit-position snd chn)))
	(undo 1 ind1 0)
	(play-and-wait 0 ind1 0 #f #f 1)

	(if (defined? 'get-test-a2)
	    (let* ((ind4 (open-sound "oboe.snd"))
		   (s1000 (sample 1000 ind4 0)))
	      (loop-samples (make-sample-reader 0 ind4 0) (get-test-a2) 50828 "a2")
	      (IF (fneq (sample 1000 ind4) (* 2 s1000))
		  (snd-display ";loop-samples ~A -> ~A" s1000 (sample 1000 ind4 0)))
	      (close-sound ind4)))

	(delete-samples 0 10000 ind1 0)
	(save-sound-as "fmv.snd" ind1 #f #f #f #f 0)
	(save-sound-as "fmv1.snd" ind1 #f #f #f #f (lambda (snd chn) 1))
	(let ((var (catch #t (lambda () (save-sound-as "fmv2.snd" ind1 #f #f #f 1234)) (lambda args args))))
	  (IF (not (eq? (car var) 'no-such-channel))
	      (snd-display ";save-sound-as bad chan: ~A" var)))
	(IF (not (= (mus-sound-frames "fmv.snd") (frames ind1 0 0)))
	    (snd-display ";save-sound-as (edpos): ~A ~A?" (mus-sound-frames "fmv.snd") (frames ind1 0 0)))
	(IF (not (= (mus-sound-frames "fmv1.snd") (frames ind1 0 1)))
	    (snd-display ";save-sound-as (edpos 1): ~A ~A?" (mus-sound-frames "fmv.snd") (frames ind1 0 1)))
	(IF (= (mus-sound-frames "fmv.snd") (frames ind1 0 1))
	    (snd-display ";save-sound-as (edpos 1): ~A ~A?" (mus-sound-frames "fmv.snd") (frames ind1 0 1)))
	(let ((ind2 (open-sound "fmv.snd"))
	      (ind3 (open-sound "fmv1.snd")))
	  (IF (not (vequal (samples->vct 12000 10 ind1 0 #f 0) (samples->vct 12000 10 ind2 0)))
	      (snd-display ";save-sound-as (edpos 3): ~A ~A?" (samples->vct 12000 10 ind1 0 #f 0) (samples->vct 12000 10 ind2 0)))
	  (IF (not (vequal (samples->vct 12000 10 ind1 0 #f 1) (samples->vct 12000 10 ind3 0)))
	      (snd-display ";save-sound-as (edpos 4): ~A ~A?" (samples->vct 12000 10 ind1 0 #f 1) (samples->vct 12000 10 ind3 0)))
	  (IF (vequal (samples->vct 12000 10 ind2 0) (samples->vct 12000 10 ind3 0))
	      (snd-display ";save-sound-as (edpos 5): ~A ~A?" (samples->vct 12000 10 ind2 0) (samples->vct 12000 10 ind3 0)))
	  (close-sound ind2)
	  (close-sound ind3))
	(delete-file "fmv.snd")
	(delete-file "fmv1.snd")

	(test-edpos-1 (lambda (snd pos) (reverse-sound snd 0 pos)) 'reverse-sound ind1)
	(test-edpos-1 (lambda (snd pos) (env-sound '(0 0 1 1 2 0) 0 20000 1.0 snd 0 pos)) 'env-sound ind1)
	(test-edpos-1 (lambda (snd pos) (src-sound 0.5 1.0 snd 0 pos)) 'src-sound ind1)
	(test-edpos-1 (lambda (snd pos) (filter-sound (make-fir-filter 6 (list->vct '(.1 .2 .3 .3 .2 .1))) 6 snd 0 pos)) 'filter-sound ind1)
	(test-edpos-1 (lambda (snd pos) (convolve-with "pistol.snd" .5 snd 0 pos)) 'convolve-with ind1)

	(set! (previous-files-sort-procedure)
	      (lambda (lst)
		(sort lst 
		      (lambda (a b)
			(define (mxall mxcur mxlst)
			  (if (null? mxlst)
			      mxcur
			      (mxall (max mxcur (cadr mxlst)) (cddr mxlst))))
			(let ((mxa (mus-sound-maxamp a))
			      (mxb (mus-sound-maxamp b)))
			  (or (null? mxb)
			      (and (not (null? mxa))
				   (> (mxall 0.0 mxa)
				      (mxall 0.0 mxb)))))))))
	(set! (previous-files-sort) 5)
	(close-sound ind1)
	(set! (previous-files-sort) 1)
	)

      (with-output-to-file "sndtst" 
	(lambda ()
	  (display "#!/home/bil/cl/snd -b
!#
(use-modules (ice-9 format))
(if (= (length (script-args)) 2) ;i.e. (\"-l\" \"script\")
  (display \"usage: script file-name...\n\")
  (do ((arg (+ (script-arg) 1) (1+ arg)))
      ((= arg (length (script-args))))
    (let ((name (list-ref (script-args) arg)))
      (display (format #f \"~A: ~A~%\" name (mus-sound-comment name))))))
(exit)
")))

      (system "chmod 777 sndtst")
      (let ((val (shell "sndtst fyow.snd")))
        (IF (not (string=? val "fyow.snd: ;Written on Tue 11-May-93 at 15:55 PDT by me at localhost (NeXT) using Allegro CL and clm of 11-May-93
"))
            (snd-display ";script: ~A?" val)
            (delete-file "sndtst")))

      (with-output-to-file "sndtst" 
	(lambda ()
	  (display "#!/home/bil/cl/snd -b
!#
(open-sound \"fmv.snd\")
(scale-by 2.0)
(save-sound)
(exit)
")))
      (system "chmod 777 sndtst")
      (system "cp oboe.snd fmv.snd")
      (sleep 1) ; force dates to be different
      (let* ((ind (open-sound "fmv.snd"))
             (samps (samples->vct 5000 10))
             (date (mus-sound-write-date "fmv.snd")))
        (scale-by 3.0)
        (system "sndtst") 
        (IF (= (mus-sound-write-date "fmv.snd") date)
            (snd-display ";script didn't overwrite fmv.snd?"))
        (update-sound ind)
        (IF (not (equal? (edits ind) (list 0 0)))
            (snd-display ";update-sound edits: ~A?" (edits ind)))
        (let ((nsamps (samples->vct 5000 10)))
	  (IF (not (vequal samps (vct-scale! nsamps 0.5)))
	      (snd-display ";udpate-sound amps: ~A ~A?" samps nsamps)))

        (close-sound ind)
        (delete-file "fmv.snd")
        (delete-file "sndtst"))

      (let* ((ind (open-sound "oboe.snd"))
	     (mx (maxamp ind 0))
	     (e0 (channel-amp-envs ind 0)))
	
	(define (vector-peak v)
	  (let ((mx (abs (vector-ref v 0)))
		(len (vector-length v)))
	    (do ((i 1 (1+ i)))
		((= i len) mx)
	      (if (> (abs (vector-ref v i)) mx)
		  (set! mx (abs (vector-ref v i)))))))
	
	(define (peak-env-equal? index e)
	  (let* ((reader (make-sample-reader 0 index 0))
		 (e-size (vector-length (car e)))
		 (samps-per-bin (/ (frames index) e-size)))
	    (call-with-current-continuation
	     (lambda (return)
	       (do ((e-bin 0)
		    (samp 0 (1+ samp))
		    (mx 0.0))
		   ((= e-bin e-size) #t)
		 (let ((val (abs (next-sample reader))))
		   (if (> val mx)
		       (set! mx val))
		   (if (>= samp samps-per-bin)
		       (begin
			 (set! samp 0)
			 (IF (ffneq mx (max (abs (vector-ref (car e) e-bin))
					    (abs (vector-ref (cadr e) e-bin))))
			     (begin
			       (snd-display "peak-env-equal? ~D (~A, ~A): ~A ~A ~A" 
						  e-bin samp samps-per-bin mx 
						  (vector-ref (car e) e-bin) 
						  (vector-ref (cadr e) e-bin))
			       (return #f)))
			 (set! mx 0.0)
			 (set! e-bin (+ e-bin 1))))))))))
	
	(if (null? e0)
	    (snd-display ";no amp env data")
	    (let ((mx1 (vector-peak (car e0)))
		  (mx2 (vector-peak (cadr e0))))
	      (IF (fneq mx (max mx1 mx2))
		  (snd-display "amp env max: ~A ~A ~A" mx mx1 mx2))
	      (peak-env-equal? ind e0)
	      (scale-by 3.0)
	      (let* ((e1 (channel-amp-envs ind 0 1))
		     (mx3 (vector-peak (car e1)))
		     (mx4 (vector-peak (cadr e1))))
		(IF (or (fneq (* 3.0 mx1) mx3)
			(fneq (* 3.0 mx2) mx4))
		    (snd-display "3.0 amp env max: ~A ~A ~A ~A" mx1 mx2 mx3 mx4)))
	      (IF (fneq (maxamp ind 0) (* 3 mx)) 
		  (snd-display "maxamp after scale: ~A ~A" mx (maxamp ind 0)))
	      (undo)
	      (set! (selection-member? #t) #f)
	      (set! (selection-member? ind 0) #t)
	      (set! (selection-position ind 0) 20000)
	      (set! (selection-length ind 0) 12000)
	      (scale-selection-by 3.0)
	      (let* ((e1 (channel-amp-envs ind 0 1))
		     (mx3 (vector-peak (car e1)))
		     (mx4 (vector-peak (cadr e1))))
		(IF (or (fneq (* 3.0 mx1) mx3)
			(fneq (* 3.0 mx2) mx4))
		    (snd-display "selection 3.0 amp env max: ~A ~A ~A ~A" mx1 mx2 mx3 mx4))
		(IF (fneq (maxamp ind 0) (* 3 mx)) 
		    (snd-display "maxamp after selection scale: ~A ~A" mx (maxamp ind 0))))
	      (map-chan abs ind 0)
	      (let* ((e1 (channel-amp-envs ind 0 2))
		     (mx3 (vector-peak (car e1)))
		     (mx4 (vector-peak (cadr e1))))
		(IF (fneq (* 3.0 mx2) mx4)
		    (snd-display "abs selection 3.0 amp env max: ~A ~A ~A ~A" mx1 mx2 mx3 mx4))
		(IF (fneq (maxamp ind 0) (* 3 mx)) 
		    (snd-display "maxamp after abs selection scale: ~A ~A" mx (maxamp ind 0)))
		(IF (ffneq mx3 0.03)
		    (snd-display "abs max: ~A ~A" mx3 mx4)))
	      (delete-samples 10000 5000)
	      (let* ((e1 (channel-amp-envs ind 0 3))
		     (mx3 (vector-peak (car e1)))
		     (mx4 (vector-peak (cadr e1))))
		(IF (fneq (* 3.0 mx2) mx4)
		    (snd-display "abs selection 3.0 amp env max: ~A ~A ~A ~A" mx1 mx2 mx3 mx4))
		(IF (fneq (maxamp ind 0) (* 3 mx)) 
		    (snd-display "maxamp after abs selection scale: ~A ~A" mx (maxamp ind 0)))
		(IF (ffneq mx3 0.03)
		    (snd-display "abs max: ~A ~A" mx3 mx4)))
	      (scale-selection-by -.333)
	      (let* ((e1 (channel-amp-envs ind 0 4))
		     (mx3 (vector-peak (car e1)))
		     (mx4 (vector-peak (cadr e1))))
		(IF (fneq (maxamp ind 0) mx)
		    (snd-display "maxamp after minus abs selection scale: ~A ~A" mx (maxamp ind 0)))
		(IF (fneq (maxamp ind 0) mx3)
		    (snd-display "mx3 maxamp after minus abs selection scale: ~A ~A" mx mx3)))))
	(close-sound ind))

      (let ((index (new-sound "fmv.snd" mus-next mus-bshort 22050 2 "channel tests")))
	(define (test-channel-func func val-func init-val)
	  (let* ((len (frames index))
		 (chns (chans index))
		 (val #f))
	    (do ((k 0 (1+ k)))
		((= k 2))
	      (set! val (val-func len))
	      (set! (sync index) k)
	      (do ((i 0 (1+ i)))
		  ((= i chns))
		(map-channel (lambda (n) 0.0) 0 len index i)
		(IF (scan-channel (lambda (n) (fneq n 0.0)) 0 len index i)
		    (snd-display ";init scan: ~A?" (scan-channel (lambda (n) (fneq n 0.0))))))
	      ;; now it's cleared
	      (do ((i 0 (1+ i)))
		  ((= i chns))
		(map-channel (lambda (n) init-val) 0 len index i)
		(func 0 len index i)
		(do ((j 0 (1+ j)))
		    ((= j chns))
		  (let ((vi (channel->vct 0 len index j)))
		    (if (= j i)
			(IF (not (vequal vi val))
			    (snd-display ";chan func: ~A ~A" vi val))
			(IF (scan-channel (lambda (n) (fneq n 0.0)) 0 len index j)
			    (snd-display ";chan func leaks? ~A ~A: ~A" i j (scan-channel (lambda (n) (fneq n 0.0)) 0 len index j))))))
		(map-channel (lambda (n) 0.0) 0 len index i))
	      (do ((i 0 (1+ i)))
		  ((= i chns))
		(map-channel (lambda (n) init-val) 0 len index i)
		(let ((ed (edit-position index i)))
		  (map-channel (lambda (n) (+ init-val 1.0)) 0 len index i)
		  (func 0 len index i ed)
		  (do ((j 0 (1+ j)))
		      ((= j chns))
		    (let ((vi (channel->vct 0 len index j)))
		      (if (= j i)
			  (IF (not (vequal vi val))
			      (snd-display ";ed chan func: ~A ~A" vi val))
			  (IF (scan-channel (lambda (n) (fneq n 0.0)) 0 len index j)
			      (snd-display ";ed chan func leaks? ~A ~A ~A: ~A" i j ed (scan-channel (lambda (n) (fneq n 0.0)) 0 len index j))))))
		  (map-channel (lambda (n) 0.0) 0 len index i)))
	      (let* ((beg (inexact->exact (/ len 3)))
		     (dur beg)
		     (nv (val-func dur)))
		(vct-fill! val 0.0)
		(do ((i beg (1+ i))
		     (j 0 (1+ j)))
		    ((= j dur))
		  (vct-set! val i (vct-ref nv j)))
		(do ((i 0 (1+ i)))
		    ((= i chns))
		  (map-channel (lambda (n) init-val) beg dur index i)
		  (func beg dur index i)
		  (add-mark beg index i)
		  (do ((j 0 (1+ j)))
		      ((= j chns))
		    (let ((vi (channel->vct 0 len index j)))
		      (if (= j i)
			  (IF (not (vequal vi val))
			      (snd-display ";chan func n: ~A ~A" vi val))
			  (IF (scan-channel (lambda (n) (fneq n 0.0)) 0 len index j)
			      (snd-display ";dur chan func leaks? ~A ~A: ~A" i j (scan-channel (lambda (n) (fneq n 0.0)) 0 len index j))))))
		  (map-channel (lambda (n) 0.0) 0 len index i))))))

	(insert-silence 0 10 index 0)
	(insert-silence 0 10 index 1)

	(test-channel-func (lambda* (beg dur index chan #:optional edpos)
			     (clm-channel (make-env :envelope '(0 0 1 1) :end (1- dur)) beg dur index chan edpos))
			   (lambda (dur)
			     (let ((e (make-env :envelope '(0 0 1 1) :end (1- dur)))
				   (v (make-vct dur)))
			       (do ((i 0 (1+ i)))
				   ((= i dur))
				 (vct-set! v i (env e)))
			       v))
			   0.0)

	(test-channel-func (lambda* (beg dur index chan #:optional edpos)
			     (clm-channel (make-oscil :frequency 0.0 :initial-phase (/ pi 2)) beg dur index chan edpos))
			   (lambda (dur)
			     (let ((v (make-vct dur)))
			       (vct-fill! v 1.0)
			       v))
			   0.0)

	(test-channel-func (lambda* (beg dur index chan #:optional edpos)
			     (scale-channel 0.5 beg dur index chan edpos))
			   (lambda (dur)
			     (let ((v (make-vct dur)))
			       (vct-fill! v 0.5)
			       v))
			   1.0)

	(test-channel-func (lambda* (beg dur index chan #:optional edpos)
			     (env-channel (make-env :envelope '(0 0 1 1) :end (1- dur)) beg dur index chan edpos))
			   (lambda (dur)
			     (let ((e (make-env :envelope '(0 0 1 1) :end (1- dur)))
				   (v (make-vct dur)))
			       (do ((i 0 (1+ i)))
				   ((= i dur))
				 (vct-set! v i (env e)))
			       v))
			   1.0)

	(test-channel-func (lambda* (beg dur index chan #:optional edpos)
			     (let ((v (make-vct dur)))
			       (vct-fill! v -1.0)
			       (vct->channel v beg dur index chan)))
			   (lambda (dur)
			     (let ((v (make-vct dur)))
			       (vct-fill! v -1.0)
			       v))
			   1.0)

	(test-channel-func (lambda* (beg dur index chan #:optional edpos)
			     (delete-samples beg dur index chan edpos)
			     (pad-channel beg dur index chan edpos))
			   (lambda (dur)
			     (make-vct dur))
			   1.0)

	(test-channel-func (lambda* (beg dur index chan #:optional edpos)
			     (let ((v (make-vct dur)))
			       (vct-fill! v -1.0)
			       (delete-samples beg dur index chan edpos)
			       (insert-samples beg dur v index chan edpos)))
			   (lambda (dur)
			     (let ((v (make-vct dur)))
			       (vct-fill! v -1.0)
			       v))
			   1.0)

	(test-channel-func (lambda* (beg dur index chan #:optional edpos)
			     (let ((v (make-vct dur)))
			       (vct-fill! v -1.0)
			       (set! (samples beg dur index chan #f "test-channel" 0 edpos) v)))
			   (lambda (dur)
			     (let ((v (make-vct dur)))
			       (vct-fill! v -1.0)
			       v))
			   1.0)

	(test-channel-func (lambda* (beg dur index chan #:optional edpos)
			     (env-channel (make-env :envelope '(0 0 1 1) :end (1- dur)) beg dur index chan edpos)
			     (reverse-channel beg dur index chan))
			   (lambda (dur)
			     (let ((e (make-env :envelope '(0 1 1 0) :end (1- dur)))
				   (v (make-vct dur)))
			       (env e)
			       (do ((i 0 (1+ i)))
				   ((= i dur))
				 (vct-set! v i (env e)))
			       v))
			   1.0)

	(test-channel-func (lambda* (beg dur index chan #:optional edpos)
			     (env-channel (make-env :envelope '(0 0 1 1) :end (1- dur)) beg dur index chan edpos)
			     (set! (sample (+ beg dur) index chan) 1.0)
			     (smooth-channel beg dur index chan)
			     (if (not (= beg 0))
				 (set! (sample (+ beg dur) index chan) 0.0)))
			   (lambda (dur)
			     (let ((v (make-vct dur)))
			       (do ((i 0 (1+ i)))
				   ((= i dur))
				 (vct-set! v i (+ 0.5 (* 0.5 (cos (+ 3.14159 (/ (* 3.14159 i) dur)))))))
			       v))
			   1.0)
	(IF (not (equal? (edits index) (list 255 0)))
	    (snd-display ";channel edits: ~A" (edits index)))
	(let ((old-max (maxamp index #t))
	      (regdata (map (lambda (n)
			      (region-samples->vct 0 10 n))
			    (regions)))
	      (old-pos0 (edit-position index 0))
	      (old-pos1 (edit-position index 1))
	      (old-reglen (map region-length (regions))))
	  (save-state "s61.scm")
	  (close-sound index)
	  (load "s61.scm")
	  (IF (not (equal? old-reglen (map region-length (regions))))
	      (snd-display ";region-length after save: ~A ~A" old-reglen (map region-length (regions))))
	  (for-each (lambda (n data)
		      (IF (not (vequal data (region-samples->vct 0 10 n)))
			  (snd-display ";region after save ~A: ~A ~A" n data (region-samples->vct 0 10 n))))
		    (regions)
		    regdata)
	  (set! index (find-sound "fmv.snd"))
	  (IF (not (equal? (maxamp index #t) old-max))
	      (snd-display ";maxes: ~A ~A" (maxamp index #t) old-max))
	  (IF (not (equal? (edits index) (list 258 0))) ; extend adds 2
	      (snd-display ";saved channel edits: ~A" (edits index)))

	  (do ((i 0 (1+ i)))
	      ((= i 10))
	    (let ((pos (random (car (edits index)))))
	      (scale-channel (random 2.0) (random 5) (random 5) index 0 pos)
	      (set! (edit-position index) (inexact->exact (* (car (edits index)) .7)))))

	  (close-sound index)
	  (delete-file "s61.scm")
	  ))

      (let ((index (new-sound "fmv.snd" mus-next mus-bshort 22050 2 "channel tests"))
	    (v (make-vct 10))
	    (sw (sinc-width)))
        (set! (sinc-width) 10)
	(vct-set! v 0 1.0)
	(vct->channel v 0 10 index 0)
	(src-channel 0.5 0 10 index 0)
	(let ((v (make-vct 10))
	      (s (make-src :srate 0.5
			   :input (let ((val 1.0))
				    (lambda (dir)
				      (let ((rtn val))
					(set! val 0.0)
					rtn))))))
	  (vct-set! v 0 (src s))
	  (do ((i 1 (1+ i)))
	      ((= i 10))
	    (vct-set! v i (src s)))
	  (IF (not (vequal v (channel->vct 0 10 index 0)))
	      (snd-display "src-channel: ~A ~A" v (channel->vct 0 10 index 0)))
	  (IF (not (vequal (make-vct 10) (channel->vct 0 10 index 1)))
	      (snd-display ";src-channel leaks: ~A" (channel->vct 0 10 index 1))))
	(revert-sound index)
	(vct->channel v 0 10 index 1)
	(vct->channel v 10 10 index 1)
	(src-channel (make-env :envelope '(1 1 2 2) :end 19) 0 20 index 1)
	(IF (not (vequal (channel->vct 0 10 index 1) (vct 1.000 -0.000 -0.048 0.068 -0.059 0.022 0.030 -0.100 0.273 0.606)))
	    (snd-display ";src-channel env: ~A" (channel->vct 0 10 index 1)))
	(IF (not (vequal (make-vct 10) (channel->vct 0 10 index 0)))
	    (snd-display ";src-channel env leaks: ~A" (channel->vct 0 10 index 0)))
        (set! (sinc-width) sw)
	(close-sound index))

      (let* ((ind (open-sound "oboe.snd"))
	     (rid0 (make-region 2000 2020 ind 0))
	     (rid0-data (region2vct rid0 0 20)))
        (scale-sound-by 2.0)
        (play-region rid0 #t)
        (let ((nv (region2vct rid0 0 20)))
          (IF (not (vequal rid0-data nv)) (snd-display ";deferred region after scaling:~%  ~A~%  ~A" rid0-data nv)))
        (let ((nv (region-to-vct rid0 0 20)))
          (IF (not (vequal rid0-data nv)) (snd-display ";deferred region after scaling (rs):~%  ~A~%  ~A" rid0-data nv)))
        (undo)
        (scale-by 4.0)
        (play-region rid0 #t)
        (let ((nv (region2vct rid0 0 20)))
          (IF (not (vequal rid0-data nv)) (snd-display ";file region after scaling:~%  ~A~%  ~A" rid0-data nv)))
        (let ((nv (region-to-vct rid0 0 20)))
          (IF (not (vequal rid0-data nv)) (snd-display ";file region after scaling (rs):~%  ~A~%  ~A" rid0-data nv)))
        (let* ((rid1 (make-region 2000 2020 ind 0))
	       (rid1-data (region2vct rid1 0 20)))
          (scale-to .5)
          (let ((nv (region2vct rid1 0 20)))
            (IF (not (vequal rid1-data nv)) (snd-display ";deferred region after scale-to:~%  ~A~%  ~A" rid1-data nv)))
          (close-sound ind)
          (play-region rid0 #t)
          (play-region rid1 #t)
          (let ((nv (region2vct rid1 0 20)))
            (IF (not (vequal rid1-data nv)) (snd-display ";deferred region after close:~%  ~A~%  ~A" rid1-data nv)))
          (let ((nv (region2vct rid0 0 20)))
            (IF (not (vequal rid0-data nv)) (snd-display ";file region after close:~%  ~A~%  ~A" rid0-data nv))))

        (for-each
         (lambda (s1 l1 s2 l2)
           (set! ind (open-sound "2.snd"))
           (set! (selection-member? #t) #f)
           (set! (selection-member? ind 0) #t)
           (set! (selection-position ind 0) s1)
           (set! (selection-length ind 0) l1)
           (set! (selection-member? ind 1) #t)
           (set! (selection-position ind 1) s2)
           (set! (selection-length ind 1) l2)
           (let* ((rid2 (make-region))
      	          (rid20-data (region2vct rid2 0 l1))
      	          (rid21-data (region2vct rid2 1 l2)))
             (IF (not (= (region-chans rid2) 2)) (snd-display ";region-chans of sync'd sound: ~A?" (region-chans rid2)))
             (swap-channels ind 0 ind 1)
             (let ((nv (region2vct rid2 0 l1)))
      	       (IF (not (vequal rid20-data nv)) (snd-display ";deferred region after scaling (20):~%  ~A~%  ~A" rid20-data nv)))
             (let ((nv (region-to-vct rid2 0 l1)))
      	       (IF (not (vequal rid20-data nv)) (snd-display ";deferred region after scaling (20 rs):~%  ~A~%  ~A" rid20-data nv)))
             (let ((nv (region2vct rid2 1 l2)))
      	       (IF (not (vequal rid21-data nv)) (snd-display ";deferred region after scaling (21):~%  ~A~%  ~A" rid21-data nv)))
             (let ((nv (region-to-vct rid2 1 l2)))
      	       (IF (not (vequal rid21-data nv)) (snd-display ";deferred region after scaling (21 rs):~%  ~A~%  ~A" rid21-data nv)))
             (close-sound ind)
             (let ((nv (region2vct rid2 0 l1)))
      	       (IF (not (vequal rid20-data nv)) (snd-display ";deferred region after scaling (20):~%  ~A~%  ~A" rid20-data nv)))
             (let ((nv (region-to-vct rid2 0 l1)))
      	       (IF (not (vequal rid20-data nv)) (snd-display ";deferred region after scaling (20 rs):~%  ~A~%  ~A" rid20-data nv)))
             (let ((nv (region2vct rid2 1 l2)))
      	       (IF (not (vequal rid21-data nv)) (snd-display ";deferred region after scaling (21):~%  ~A~%  ~A" rid21-data nv)))
             (let ((nv (region-to-vct rid2 1 l2)))
      	       (IF (not (vequal rid21-data nv)) (snd-display ";deferred region after scaling (21 rs):~%  ~A~%  ~A" rid21-data nv)))
             ))
         (list 2000 2000 2000 0 2000 0 2000)
         (list 20 10 20 20 20 10 20)
         (list 2000 2000 2000 2000 0 2000 0)
         (list 20 20 10 20 20 20 10))
        )))


;;; ---------------- test 6 vcts ----------------

(load "prc95.scm")
(load "flute.scm")

(if (or full-test (= snd-test 6) (and keep-going (<= snd-test 6)))
    (begin 
      (if (procedure? test-hook) (test-hook 6))
    (do ((clmtest 0 (1+ clmtest))) ((= clmtest tests)) (IF (> tests 1) (snd-display ";test ~D " clmtest))
    (let ((v0 (make-vct 10))
	  (v1 (make-vct 10))
	  (vlst (make-vct 3)))
      (IF (not (vct? v0)) (snd-display ";v0 isn't a vct?!?"))
      (IF (equal? v0 10) (snd-display ";v0 is 10!?"))
      (IF (vct? 10) (snd-display ";10 is a vct?"))
      (IF (not (= (vct-length v0) 10)) (snd-display ";v0 length = ~D?" (vct-length v0)))
      (vct-fill! v0 1.0)
      (vct-fill! v1 0.5)
      (IF (equal? v0 v1) (snd-display ";vct equal? ~A ~A" v0 v1))
      (IF (eq? v0 v1) (snd-display ";vct eq? ~A ~A" v0 v1))
      (let ((v2 v1)
	    (v3 (make-vct 10))
	    (v4 (make-vct 3)))
	(IF (not (eq? v1 v2)) (snd-display ";vct not eq? ~A ~A" v1 v2))
	(vct-fill! v3 0.5) 
	(IF (not (equal? v3 v1)) (snd-display ";vct not equal? ~A ~A" v3 v1))
	(IF (equal? v4 v1) (snd-display ";len diff vct equal? ~A ~A" v4 v1)))
      (vct-set! vlst 1 .1)
      (IF (not (feql (vct->list vlst) (list 0.0 0.1 0.0))) (snd-display ";vct->list: ~A?" (vct->list vlst)))
      (let* ((vect '#(0 1 2 3))
	     (v2 (vector->vct vect))
	     (v3 v2)
	     (str (format #f "~A" v2)))
	(IF (not (string=? str "#<vct[len=4]: 0.000 1.000 2.000 3.000>"))
	    (snd-display ";vct print: ~%  ~A~%  ~A?" str v2))
	(IF (not (equal? v3 v2)) (snd-display ";vct=? ~A ~A?" v2 v3))
	(IF (not (= (vct-length v2) 4)) (snd-display ";vector->vct length: ~A?" (vct-length v2)))
	(IF (fneq (vct-ref v2 2) 2.0) (snd-display ";vector->vct: ~A?" v2))
	(vct-move! v2 0 2)
	(IF (fneq (vct-ref v2 0) 2.0) (snd-display ";vct-move!: ~A?" v2)))
      (let ((v2 (make-vct 4)))
	(do ((i 0 (1+ i)))
	    ((= i 4))
	  (vct-set! v2 i i))
	(vct-move! v2 3 2 #t)
	(IF (or (fneq (vct-ref v2 3) 2.0) (fneq (vct-ref v2 2) 1.0))
	    (snd-display ";vct-move! back: ~A?" v2)))

      (let ((v0 (make-vct 3)))
	(let ((var (catch #t (lambda () (vct-ref v0 10)) (lambda args args))))
	  (IF (not (eq? (car var) 'mus-error))
	      (snd-display ";vct-ref high index: ~A" var)))
	(let ((var (catch #t (lambda () (vct-ref v0 -1)) (lambda args args))))
	  (IF (not (eq? (car var) 'mus-error))
	      (snd-display ";vct-ref low index: ~A" var)))
	(let ((var (catch #t (lambda () (vct-set! v0 10 1.0)) (lambda args args))))
	  (IF (not (eq? (car var) 'mus-error))
	      (snd-display ";vct-set! high index: ~A" var)))
	(let ((var (catch #t (lambda () (vct-set! v0 -1 1.0)) (lambda args args))))
	  (IF (not (eq? (car var) 'mus-error))
	      (snd-display ";vct-set! low index: ~A" var)))
	(let ((var (catch #t (lambda () (vct-move! v0 10 0 #t)) (lambda args args))))
	  (IF (not (eq? (car var) 'mus-error))
	      (snd-display ";vct-move! high index: ~A" var)))
	(let ((var (catch #t (lambda () (vct-move! v0 0 10 #t)) (lambda args args))))
	  (IF (not (eq? (car var) 'mus-error))
	      (snd-display ";vct-move! high 2 index: ~A" var)))
	(let ((var (catch #t (lambda () (vct-move! v0 -10 0 #f)) (lambda args args))))
	  (IF (not (eq? (car var) 'mus-error))
	      (snd-display ";vct-move! back high index: ~A" var)))
	(let ((var (catch #t (lambda () (vct-move! v0 0 -10 #f)) (lambda args args))))
	  (IF (not (eq? (car var) 'mus-error))
	      (snd-display ";vct-move! back high 2 index: ~A" var)))
	(let ((var (catch #t (lambda () (vcts-map! v0 v0 #f)) (lambda args args))))
	  (IF (not (eq? (car var) 'mus-error))
	      (snd-display ";vcts-map! no func: ~A" var)))
	(let ((var (catch #t (lambda () (vcts-map! v0 #f #f)) (lambda args args))))
	  (IF (not (eq? (car var) 'wrong-type-arg))
	      (snd-display ";vcts-map! not vct: ~A" var)))
	(let ((var (catch #t (lambda () (vcts-do! v0 v0 (lambda () #f))) (lambda args args))))
	  (IF (not (eq? (car var) 'mus-error))
	      (snd-display ";vcts-do! func arity bad: ~A" var)))
	(let ((var (catch #t (lambda () (vcts-do! v0 #f #f)) (lambda args args))))
	  (IF (not (eq? (car var) 'wrong-type-arg))
	      (snd-display ";vcts-do! not vct: ~A" var))))

      (let ((v (make-vct 4))
	    (vv (make-vct 4)))
	(vct-map! v (let ((ctr 0)) 
		      (lambda () 
			(set! ctr (1+ ctr)) 
			(if (< ctr 3) ctr 'oops))))
	(IF (not (vequal v (vct 1.0 2.0 0.0 0.0)))
	    (snd-display ";vct-map! with symbol: ~A" v))
	(vct-fill! v 10.0)
	(vct-do! v (let ((ctr 0)) 
		     (lambda (n) 
		       (set! ctr (1+ ctr)) 
		       (if (< ctr 3) n 'oops))))
	(IF (not (vequal v (vct 0.0 1.0 10.0 10.0)))
	    (snd-display ";vct-do! with symbol: ~A" v))
	(vct-fill! v 10.0)
	(vct-fill! vv 10.0)
	(vcts-map! v vv (let ((ctr 0)) 
			  (lambda (len) 
			    (set! ctr (1+ ctr)) 
			    (if (< ctr 3) (list ctr (1+ ctr)) 'oops))))
	(IF (not (vequal v (vct 1.0 2.0 10.0 10.0)))
	    (snd-display ";vcts-do! with symbol (1): ~A" v))
	(IF (not (vequal vv (vct 2.0 3.0 10.0 10.0)))
	    (snd-display ";vcts-do! with symbol (2): ~A" vv))
	(vct-fill! v 10.0)
	(vct-fill! vv 10.0)
	(vcts-do! v vv (let ((ctr 0)) 
			 (lambda (len n) 
			   (set! ctr (1+ ctr)) 
			   (if (< ctr 3) (list n (1+ n)) 'oops))))
	(IF (not (vequal v (vct 0.0 1.0 10.0 10.0)))
	    (snd-display ";vcts-do! with symbol (1): ~A" v))
	(IF (not (vequal vv (vct 1.0 2.0 10.0 10.0)))
	    (snd-display ";vcts-do! with symbol (2): ~A" vv)))

      (do ((i 0 (1+ i)))
	  ((= i 10))
	(IF (fneq (vct-ref v0 i) 1.0) (snd-display ";fill v0[~D] = ~F?" i (vct-ref v0 i)))
	(IF (fneq (vct-ref v1 i) 0.5) (snd-display ";preset v1[~D] = ~F?" i (vct-ref v1 i))))
      (vct-add! v0 v1)
      (do ((i 0 (1+ i)))
	  ((= i 10))
	(IF (fneq (vct-ref v0 i) 1.5) (snd-display ";add v0[~D] = ~F?" i (vct-ref v0 i))))
      (vct-subtract! v0 v1)
      (do ((i 0 (1+ i)))
	  ((= i 10))
	(IF (fneq (vct-ref v0 i) 1.0) (snd-display ";subtract v0[~D] = ~F?" i (vct-ref v0 i))))
      (let ((v2 (vct-copy v0)))
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (IF (fneq (vct-ref v2 i) 1.0) (snd-display ";copy v0[~D] = ~F?" i (vct-ref v2 i))))
	(vct-scale! v2 5.0)
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (IF (fneq (vct-ref v2 i) 5.0) (snd-display ";scale v2[~D] = ~F?" i (vct-ref v2 i))))
	(vct-offset! v0 -1.0)
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (IF (fneq (vct-ref v0 i) 0.0) (snd-display ";offset v0[~D] = ~F?" i (vct-ref v0 i))))
	(vct-multiply! v2 v1)
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (IF (fneq (vct-ref v2 i) 2.5) (snd-display ";multiply v2[~D] = ~F?" i (vct-ref v2 i))))
	(IF (fneq (vct-peak v2) 2.5) (snd-display ";v2's peak is ~F?" (vct-peak v2)))
	(vct-set! v2 5 123.0)
	(IF (fneq (vct-peak v2) 123.0) (snd-display ";v2's set peak is ~F?" (vct-peak v2)))
	(let ((vn (make-vct 32))
	      (vb (make-vct 64))
	      (vs (make-vct 3))
	      (vss (make-vct 1)))
	  (do ((i 0 (1+ i)))
	      ((= i 32))
	    (vct-set! vn i i))
	  (let ((vnew (vct-subseq vn 3)))
	    (IF (fneq (vct-ref vnew 0) 3.0) (snd-display ";vct-subseq[3:] ~A?" (vct-ref vnew 0)))
	    (IF (not (= (vct-length vnew) 29)) (snd-display ";vct-subseq[3:] length: ~A?" (vct-length vnew))))
	  (let ((vnew (vct-subseq vn 3 8)))
	    (IF (fneq (vct-ref vnew 0) 3.0) (snd-display ";vct-subseq[3:8] ~A?" (vct-ref vnew 0)))
	    (IF (not (= (vct-length vnew) 6)) (snd-display ";vct-subseq[3:8] length: ~A?" (vct-length vnew))))
	  (vct-subseq vn 3 3 vs)
	  (IF (or (fneq (vct-ref vs 0) 3.0)
		  (fneq (vct-ref vs 1) 0.0)
		  (fneq (vct-ref vs 2) 0.0))
	      (snd-display ";vct-subseq[3:3->vs] ~A?" vs))
	  (vct-subseq vn 0 32 vs)
	  (IF (not (= (vct-length vs) 3)) (snd-display ";vct-subseq[0:32->vs] length: ~A?" (vct-length vs)))
	  (vct-subseq vn 2 3 vss)
	  (IF (fneq (vct-ref vss 0) 2.0) (snd-display ";vct-subseq[2:3->vss] ~A?" (vct-ref vss 0)))
	  (vct-set! vb 8 123.0)
	  (vct-subseq vn 1 8 vb)
	  (IF (fneq (vct-ref vb 0) 1.0) (snd-display ";vct-subseq[1:8->vb] ~A?" (vct-ref vb 0)))
	  (IF (fneq (vct-ref vb 8) 123.0) (snd-display ";vct-subseq[1:8->vb][8] ~A?" (vct-ref vb 8))))
	(vct-do! v0 (lambda (i) (* i .5)))
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (IF (fneq (vct-ref v0 i) (* i .5)) (snd-display ";do v0[~D] = ~F?" i (vct-ref v0 i))))
	(vct-map! v0 (lambda () 1.0))
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (IF (fneq (vct-ref v0 i) 1.0) (snd-display ";map v0[~D] = ~F?" i (vct-ref v0 i))))
	(vcts-do! v0 v1 v2 (lambda (num i) (list i 0.0 (* i 2))))
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (IF (fneq (vct-ref v0 i) i) (snd-display ";dos v0[~D] = ~F?" i (vct-ref v0 i)))
	  (IF (fneq (vct-ref v1 i) 0.0) (snd-display ";dos v1[~D] = ~F?" i (vct-ref v1 i)))
	  (IF (fneq (vct-ref v2 i) (* i 2)) (snd-display ";dos v2[~D] = ~F?" i (vct-ref v2 i))))
	(vcts-map! v0 v1 v2 (lambda (num) (list 0.0 1.0 2.0)))
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (IF (fneq (vct-ref v0 i) 0.0) (snd-display ";maps v0[~D] = ~F?" i (vct-ref v0 i)))
	  (IF (fneq (vct-ref v1 i) 1.0) (snd-display ";maps v1[~D] = ~F?" i (vct-ref v1 i)))
	  (IF (fneq (vct-ref v2 i) 2.0) (snd-display ";maps v2[~D] = ~F?" i (vct-ref v2 i))))
	(let ((fd (open-sound-file "hiho.snd" 1 22050 "hiho is from snd-test")))
	  (vct->sound-file fd v2 10)
	  (close-sound-file fd 10)
	  (let ((var (catch #t (lambda () (vct->sound-file -1 v2 1)) (lambda args args))))
	    (IF (not (eq? (car var) 'mus-error))
		(snd-display ";vct->sound-file bad fd: ~A" var)))
	  (let ((v3 (make-vct 40)))
	    (file->array "hiho.snd" 0 0 10 v3)
	    (IF (fneq (vct-ref v3 5) (vct-ref v2 5))
		(snd-display ";vct->sound-file: ~A ~A?" v2 v3)))))
      (IF (fneq ((vct 1.0 2.0 3.0) 1) 2.0)
	  (snd-display ";(vct...) = ~A?" ((vct 1.0 2.0 3.0) 1)))
      (let ((v1 (vct 1 2 3 4)))
	(IF (fneq (v1 1) 2.0)
	    (snd-display ";(v1 1) = ~A?" (v1 1))))
      (let ((nind (new-sound "tmp.snd" mus-next mus-bshort 22050 1 "hiho a comment")))
	(test-prc95)
	(play-and-wait 0 nind)
	(set! (use-sinc-interp) #f)
	(set! (speed-control nind) .5)
	(play-and-wait)
	(apply-controls)
	(set! (use-sinc-interp) #t)
	(close-sound nind)
	(delete-file "tmp.snd"))
      (let ((nind (new-sound "tmp.snd" mus-next mus-bshort 22050 2 "hiho a comment")))
	(stereo-flute 0 1 440 .55 :flow-envelope '(0 0 1 1 2 1 3 0))
	(play-and-wait 0 nind)
	(close-sound nind)
	(delete-file "tmp.snd"))
      ))
    ))


;;; ---------------- test 7: colors ----------------
(if (and (or full-test (= snd-test 7) (and keep-going (<= snd-test 7)))
	 (or (provided? 'snd-gtk)
	     (provided? 'snd-motif)))
    (letrec ((test-color
	      (lambda (lst)
		(if (not (null? lst))
		    (let ((name (list-ref (car lst) 0))
			  (getfnc (list-ref (car lst) 1))
			  (setfnc (list-ref (car lst) 2))
			  (initval (list-ref (car lst) 3)))
		      (IF (not (color? initval)) (snd-display ";~A not color?" initval))
		      ;; we'll get warnings here if the cell chosen didn't exactly match the one requested -- not a bug
		      ;; (IF (not (equal? (getfnc) initval))
		      ;;	  (snd-display ";~A /= ~A (~A)?" name initval (getfnc)))
		      (setfnc beige)
		      (IF (not (equal? (getfnc) beige))
			  (snd-display ";set-~A /= beige (~A)?" name (getfnc)))
		      (setfnc initval)
		      (test-color (cdr lst)))))))
      (if (procedure? test-hook) (test-hook 7))
      (let* ((c1 (make-color 0 0 1))
	     (c2 c1)
	     (c3 (make-color 0 0 1)))
	(IF (not (equal? c1 c2)) (snd-display ";color equal? ~A ~A?" c1 c2))
	(IF (not (eq? c1 c2)) (snd-display ";color eq? ~A ~A?" c1 c2))
	(IF (not (equal? c1 c3)) (snd-display ";diff color equal? ~A ~A?" c1 c3))
	(IF (eq? c1 c3) (snd-display ";diff color eq? ~A ~A?" c1 c3))
	(let ((str (format #f "~A" c1)))
	  (IF (not (string=? str "#<color: (0.00 0.00 1.00)>"))
	      (snd-display ";print color: ~A ~A?" str c1))))
      (do ((i 0 (1+ i))) ((= i 15)) 
	(let ((val (colormap-ref i 0))
	      (true-val (list-ref (list '(0.0 0.0 0.0) '(1.0 0.0 0.0) '(0.00520332646677348 0.0 0.0) '(0.0 1.0 1.0)
					'(0.0 0.0 7.01915007248035e-4) '(0.0 0.0 0.0) '(0.0417029068436713 0.0 0.0)
					'(0.0 0.0 0.50780498970016) '(1.0 0.0 0.0) '(1.0 0.0 0.0) '(0.0 0.0 1.0)
					'(1.0 0.0 1.0) '(0.0 0.500007629510948 0.4) '(0.166704814221408 0.166704814221408 0.0)
					'(1.0 0.0 0.0)) i)))
	  (IF (not (feql val true-val))
	      (snd-display ";colormap-ref ~A: ~A (~A)" i val true-val))))
      (load "rgb.scm")
      (test-color
       (list
	(list 'basic-color basic-color set-basic-color ivory2)
	(list 'cursor-color cursor-color set-cursor-color red)
	(list 'data-color data-color set-data-color black)
	(list 'enved-waveform-color enved-waveform-color set-enved-waveform-color blue)
	(list 'filter-waveform-color filter-waveform-color set-filter-waveform-color blue)
	(list 'graph-color graph-color set-graph-color white)
	(list 'highlight-color highlight-color set-highlight-color ivory1)
	(list 'listener-color listener-color set-listener-color alice-blue)
	(list 'listener-text-color listener-text-color set-listener-text-color black)
	(list 'mark-color mark-color set-mark-color red)
	(list 'mix-color mix-color set-mix-color dark-gray)
	(list 'selected-mix-color selected-mix-color set-selected-mix-color light-green)
	(list 'position-color position-color set-position-color ivory3)
	(list 'pushed-button-color pushed-button-color set-pushed-button-color lightsteelblue1)
	(list 'sash-color sash-color set-sash-color light-green)
	(list 'selected-data-color selected-data-color set-selected-data-color black)
	(list 'selected-graph-color selected-graph-color set-selected-graph-color white)
	(list 'selection-color selection-color set-selection-color lightsteelblue1)
	(list 'text-focus-color text-focus-color set-text-focus-color white)
	(list 'zoom-color zoom-color set-zoom-color ivory4)))
      (let ((ind (open-sound "oboe.snd")))
	(recolor-widget (cadr (sound-widgets ind)) (make-color 1 0 0))
	(close-sound ind))
      ))


(reset-hook! graph-hook)
(load "mix.scm")
(load "pqwvox.scm")
(clear-sincs)

;;; ---------------- test 8: clm ----------------

(define (fltit)
  "(fltit) returns a time-varying filter: (map-chan (fltit))"
  (let* ((coeffs (list .1 .2 .3 .4 .4 .3 .2 .1))
	 (flt (make-fir-filter 8 (list->vct coeffs)))
	 (es (make-vector 8)))
    (do ((i 0 (1+ i)))
	((= i 8))
      (vector-set! es i (make-env (list 0 (list-ref coeffs i) 1 0) :end 100)))
    (vector-set! es 5 (make-env '(0 .4 1 1) :duration 1.0))
    (lambda (x)
      (let ((val (fir-filter flt x))
	    (xcof (mus-data flt)))
	(do ((i 0 (1+ i)))
	    ((= i 8))
	  (vct-set! xcof i (env (vector-ref es i))))
	val))))

(define (print-and-check gen name desc insp)
  (IF (not (string=? (mus-name gen) name))
      (snd-display ";mus-name ~A: ~A?" name (mus-name gen)))
  (IF (not (string=? (mus-describe gen) desc))
      (snd-display ";mus-describe ~A: ~A?" (mus-name gen) (mus-describe gen)))
  (IF (not (string=? (mus-inspect gen) insp))
      (snd-display ";mus-inspect ~A: ~A?" (mus-name gen) (mus-inspect gen)))
  (let ((egen gen))
    (IF (not (equal? egen gen))
	(snd-display ";equal? ~A: ~A?" gen egen))))

(define (test-gen-equal g0 g1 g2)
  ;; g0 = g1 at start != g2
  (let ((g3 g0)
	(gad (make-frame 2)))
    (IF (not (eq? g0 g3))
	(snd-display ";let ~A eq? ~A ~A" (mus-name g0) g0 g3))
    (IF (eq? g0 g1)
	(snd-display ";arg ~A eq? ~A ~A" (mus-name g0) g0 g1))
    (IF (not (equal? g0 g1))
	(snd-display ";~A equal? ~A ~A" (mus-name g0) g0 g1))
    (IF (equal? g0 g2)
	(snd-display ";~A not equal? ~A ~A" (mus-name g0) g0 g2))
    (IF (equal? g0 gad)
	(snd-display ";~A equal frame? ~A ~A" (mus-name g0) g0 gad))
    (g0)
    (g3)
    (g3)
    (IF (not (eq? g0 g3))
	(snd-display ";run let ~A eq? ~A ~A" (mus-name g0) g0 g3))
    (IF (eq? g0 g1)
	(snd-display ";arg ~A eq? ~A ~A" (mus-name g0) g0 g1))
    (IF (equal? g0 g1)
	(snd-display ";run ~A equal? ~A ~A" (mus-name g0) g0 g1))
    (IF (equal? g0 g2)
	(snd-display ";run ~A not equal? ~A ~A" (mus-name g0) g0 g2))))
    
(define (fm-test gen)
  (set! (mus-frequency gen) 0.0)
  (set! (mus-phase gen) 0.0)
  (gen 0.0)
  (IF (fneq (mus-phase gen) 0.0) (snd-display ";~A phase(0): ~A" gen (mus-phase gen)))
  (gen 1.0)
  (IF (fneq (mus-phase gen) 1.0) (snd-display ";~A phase(1): ~A" gen (mus-phase gen)))
  (gen 0.0)
  (IF (fneq (mus-phase gen) 1.0) (snd-display ";~A phase(1, 0): ~A" gen (mus-phase gen)))
  (set! (mus-frequency gen) (radians->hz 2.0))
  (gen 0.0)
  (IF (fneq (mus-phase gen) 3.0) (snd-display ";~A phase(1, 2): ~A ~A" gen (mus-phase gen) (mus-frequency gen)))
  (gen 1.0)
  (IF (fneq (mus-phase gen) 6.0) (snd-display ";~A phase(3, 2, 1): ~A ~A" gen (mus-phase gen) (mus-frequency gen)))
  (do ((i 0 (1+ i))) ((= i 10)) (gen 10.0))
  (IF (fneq (mus-phase gen) (+ 26 (- 100 (* 2 3.14159 20)))) (snd-display ";~A phase (over): ~A ~A" gen (mus-phase gen) (mus-frequency gen))))

(if (or full-test (= snd-test 8) (and keep-going (<= snd-test 8)))
    (do ((clmtest 0 (1+ clmtest))) ((= clmtest tests))
      (if (procedure? test-hook) (test-hook 8))
      (log-mem clmtest)
      (if (> tests 1) (snd-display ";clm test ~D " clmtest))
      (set! (mus-srate) 22050)
      (IF (not (= (mus-file-buffer-size) 8192)) (snd-display ";mus-file-buffer-size: ~D?" (mus-file-buffer-size)))
      (let ((var (catch #t (lambda () (set! (mus-file-buffer-size) #f)) (lambda args args))))
	(IF (not (eq? (car var) 'wrong-type-arg))
	    (snd-display ";mus-file-buffer-size bad size: ~A" var)))
      (set! (mus-file-buffer-size) 128)
      (IF (not (= (mus-file-buffer-size) 128)) (snd-display ";mus-file-buffer-size: ~D?" (mus-file-buffer-size)))
      (set! (mus-file-buffer-size) 8192)

      (IF (not (= (mus-array-print-length) 8)) (snd-display ";mus-array-print-length: ~D?" (mus-array-print-length)))
      (set! (mus-array-print-length) 32)
      (IF (not (= (mus-array-print-length) 32)) (snd-display ";set mus-array-print-length: ~D?" (mus-array-print-length)))
      (set! (mus-array-print-length) 8)
      (IF (fneq (mus-srate) 22050.0) (snd-display ";mus-srate: ~F?" (mus-srate)))
      (IF (fneq (hz->radians 1.0) 2.84951704088598e-4) (snd-display ";hz->radians: ~F?" (hz->radians 1.0)))
      (IF (fneq (radians->hz 2.84951704088598e-4) 1.0) (snd-display ";radians->hz: ~F?" (radians->hz 2.84951704088598e-4)))
      (IF (fneq (radians->degrees 1.0) 57.2957801818848) (snd-display ";radians->degrees: ~F?" (radians->degrees 1.0)))
      (IF (fneq (degrees->radians 57.2957801818848) 1.0) (snd-display ";degrees->radians: ~F?" (degrees->radians 57.2957801818848)))
      (IF (fneq (linear->db .25) -12.0411996841431) (snd-display ";linear->db: ~F?" (linear->db .25)))
      (IF (fneq (db->linear -12.0411996841431) .25) (snd-display ";db->linear: ~F?" (db->linear -12.0411996841431)))
      (IF (fneq (hz->radians 1.0) (in-hz 1.0)) (snd-display ";in-hz: ~F? " (in-hz 1.0)))
      (IF (fneq (ring-modulate .4 .5) .2) (snd-display ";ring-modulate: ~F?" (ring-modulate .4 .5)))
      (IF (fneq (amplitude-modulate 1.0 .5 .4) .7) (snd-display ";amplitude-modulate: ~F?" (amplitude-modulate 1.0 .5 .4)))
      (IF (fneq (contrast-enhancement 0.1 0.75) (sin (+ (* 0.1 (/ pi 2)) (* .75 (sin (* 0.1 2.0 pi))))))
	  (snd-display ";contrast-enhancement: ~F (0.562925306221587)" (contrast-enhancement 0.1 0.75)))
      (let ((v0 (partials->polynomial '(1 1 2 1) 1))
	    (v1 (partials->polynomial '(1 1 2 1) 0))
	    (v2 (partials->polynomial '(1 1 2 1 3 1 5 1) 1))
	    (v3 (partials->polynomial '(1 1 2 1 3 1 5 1) 0))
	    (v4 (partials->polynomial '(1 1 2 .5 3 .1 6 .01) 1))
	    (v5 (partials->polynomial '(1 1 2 .5 3 .1 6 .01) 0)))
	(IF (not (fveql v0 '(-1.000 1.000 2.000) 0)) (snd-display ";partials->polynomial(1): ~A?" v0))
	(IF (not (fveql v1 '(1.000 2.000 0.0) 0)) (snd-display ";partials->polynomial(2): ~A?" v1))
	(IF (not (fveql v2 '(-1.000 3.000 2.000 -16.000 0.000 16.000) 0)) (snd-display ";partials->polynomial(3): ~A?" v2))
	(IF (not (fveql v3 '(1.000 2.000 -8.000 0.000 16.000 0.000) 0)) (snd-display ";partials->polynomial(4): ~A?" v3))
	(IF (not (fveql v4 '(-0.510 0.700 1.180 0.400 -0.480 0.000 0.320) 0)) (snd-display ";partials->polynomial(5): ~A?" v4))
	(IF (not (fveql v5 '(0.900 1.060 0.400 -0.320 0.000 0.320 0.000) 0)) (snd-display ";partials->polynomial(6): ~A?" v5)))

      (let* ((amps (list->vct '(1.0)))
	     (phases (list->vct '(0.0)))
	     (val (sum-of-sines amps phases)))
	(IF (fneq val 0.0) (snd-display ";sum-of-sines: ~A 0.0?" val))
	(vct-set! phases 0 (/ pi 2))
	(set! val (sum-of-sines amps phases))
	(IF (fneq val 1.0) (snd-display ";sum-of-sines: ~A 1.0?" val))
	(set! amps (list->vct '(0.5 0.25 1.0)))
	(set! phases (list->vct '(1.0 0.5 2.0)))
	(set! val (sum-of-sines amps phases))
	(IF (fneq val 1.44989) (snd-display ";sum-of-sines: ~A 1.449?" val)))

      (let ((rdat (make-vct 16))
	    (idat (make-vct 16))
	    (vdat (make-vct 16)))
	(vct-set! rdat 0 1.0)
	(vct-set! vdat 0 1.0)
	(let ((v0 (spectrum rdat idat (make-fft-window rectangular-window 16) 16 1)) ;rectangular here to avoid clobbering 0-th data point
	      (v1 (snd-spectrum vdat rectangular-window 16 #t)))
	  (do ((i 0 (1+ i)))
	      ((= i 8)) ;should all be 1.0 (impulse in)
	    (IF (fneq (vct-ref v0 i) (vct-ref v1 i))
		(snd-display ";spectra not equal: ~A ~A" v0 v1))))
	(let ((v0 (spectrum rdat idat (make-fft-window rectangular-window 17) 17 1)) ;rectangular here to avoid clobbering 0-th data point
	      (v1 (snd-spectrum vdat rectangular-window 16 #t)))
	  (do ((i 0 (1+ i)))
	      ((= i 8)) ;should all be 1.0 (impulse in)
	    (IF (fneq (vct-ref v0 i) (vct-ref v1 i))
		(snd-display ";spectra not equal: ~A ~A" v0 v1))))
	(let ((var (catch #t (lambda () (spectrum rdat idat #f -1)) (lambda args args))))
	  (IF (not (eq? (car var) 'mus-error))
	      (snd-display ";spectrum bad len: ~A" var))))

      (let ((rdat (make-vct 16))
	    (idat (make-vct 16))
	    (xdat (make-vct 16))
	    (ydat (make-vct 16)))
	(vct-set! rdat 0 1.0)
	(vct-set! idat 1 1.0)
	(vct-set! xdat 0 1.0)
	(vct-set! ydat 1 1.0)
	(let ((v0 (convolution rdat idat 8))
	      (v1 (convolve-arrays xdat ydat)))
	  (IF (or (fneq (vct-ref v0 0) 0.0) (fneq (vct-ref v0 1) 1.0)) (snd-display ";convolution: ~A?" v0))
	  (IF (or (fneq (vct-ref v1 0) 0.0) (fneq (vct-ref v1 1) 1.0)) (snd-display ";convolve-arrays: ~A?" v1))
	  (do ((i 0 (1+ i)))
	      ((= i 8)) 
	    (IF (fneq (vct-ref v0 i) (vct-ref v1 i))
		(snd-display ";convolutions not equal: ~A ~A" v0 v1))))
	(let ((var (catch #t (lambda () (convolution rdat idat -1)) (lambda args args))))
	  (IF (not (eq? (car var) 'mus-error))
	      (snd-display ";convolution bad len: ~A" var))))

      (let ((rdat (make-vct 16))
	    (idat (make-vct 16))
	    (xdat (make-vct 16))
	    (ydat (make-vct 16)))
	(vct-set! rdat 3 1.0)
	(vct-set! xdat 3 1.0)
	(fft rdat idat 1)
	(mus-fft xdat ydat 16 1)
	(IF (fneq (vct-ref rdat 0) (vct-ref xdat 0)) (snd-display ";ffts: ~A ~A?" rdat xdat))
	(fft rdat idat -1)
	(mus-fft xdat ydat 17 -1) ; mistake is deliberate
	(do ((i 0 (1+ i)))
	    ((= i 16))
	  (IF (or (and (= i 3) (or (fneq (vct-ref rdat i) 16.0) (fneq (vct-ref xdat i) 16.0)))
		  (and (not (= i 3)) (or (fneq (vct-ref rdat i) 0.0) (fneq (vct-ref xdat i) 0.0))))
	      (snd-display ";fft real[~D]: ~A ~A?" i (vct-ref rdat i) (vct-ref xdat i)))
	  (IF (or (fneq (vct-ref idat i) 0.0) (fneq (vct-ref ydat i) 0.0))
	      (snd-display ";fft imag[~D]: ~A ~A?" i (vct-ref idat i) (vct-ref ydat i))))
	(let ((var (catch #t (lambda () (mus-fft xdat ydat -1 0)) (lambda args args))))
	  (IF (not (eq? (car var) 'mus-error))
	      (snd-display ";mus-fft bad len: ~A" var))))

      (let ((rdat (make-vector 16))
	    (idat (make-vector 16)))
	(do ((i 0 (1+ i)))
	    ((= i 16))
	  (vector-set! rdat i 0.0)
	  (vector-set! idat i 0.0))
	(vector-set! rdat 3 1.0)
	(fft rdat idat 1)
	(fft rdat idat -1)
	(IF (or (fneq (vector-ref rdat 3) 16.0)
		(fneq (vector-ref rdat 4) 0.0))
	    (snd-display ";vector fft real[3 or 4]: ~A ~A?" (vector-ref rdat 3) (vector-ref rdat 4))))

      (for-each
       (lambda (size)
	 (let* ((rdat (make-vct size))
		(idat (make-vct size))
		(xdat (make-vct size)))
	   (vct-set! rdat 3 1.0)
	   (vct-set! xdat 3 1.0)
	   (fft rdat idat 1)
	   (fht xdat)
	   (do ((i 1 (1+ i)))
	       ((= i (/ size 2)))
	     (let ((hdat (* (sqrt (+ (* (vct-ref xdat i) (vct-ref xdat i))
				     (* (vct-ref xdat (- size i)) (vct-ref xdat (- size i)))))
			    (/ (sqrt 2.0) size)))
		   (fdat (* (sqrt (+ (* (vct-ref rdat i) (vct-ref rdat i))
				     (* (vct-ref idat i) (vct-ref idat i))))
			    (/ 2 size))))
	       (if (fneq fdat hdat)
		   (snd-display ";~D: fft ~A, fht ~A " i fdat hdat))))
	   (fft rdat idat -1)
	   (fht xdat)
	   (IF (fneq (vct-ref rdat 3) size)
	       (snd-display ";ifft ~A: ~A" size (vct-ref rdat 3)))
	   (IF (fneq (vct-ref xdat 3) size)
	       (snd-display ";ifht ~A: ~A" size (vct-ref xdat 3)))
	   (IF (fneq (vct-ref rdat 4) 0.0)
	       (snd-display ";ifft ~A: ~A" size (vct-ref rdat 3)))
	   (IF (fneq (vct-ref xdat 4) 0.0)
	       (snd-display ";ifht ~A: ~A" size (vct-ref xdat 3)))))
       (list 256 64 1024 4096))

      (let ((v0 (make-vct 10))
	    (v1 (make-vct 10)))
	(vct-fill! v0 1.0)
	(multiply-arrays v0 v1 1)
	(IF (not (vequal v0 (vct 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0)))
	    (snd-display ";multiply-arrays[0]: ~A?" v0))
	(multiply-arrays v0 v1 100)
	(IF (fneq (vct-peak v0) 0.0)
	    (snd-display ";multiply-arrays[100]: ~A?" v0))
	(vct-fill! v0 1.0)
	(vct-fill! v1 0.5)
	(multiply-arrays v0 v1)
	(IF (fneq (vct-ref v0 0) 0.5) (snd-display ";multiple-arrays: ~F?" (vct-ref v0 0)))
	(let ((sum (dot-product v0 v1)))
	  (IF (fneq sum 2.5) (snd-display ";dot-product: ~F?" sum)))
	(clear-array v0)
	(IF (fneq (vct-ref v0 3) 0.0) (snd-display ";clear-array: ~A?" v0))
	(vct-fill! v0 1.0)
	(vct-fill! v1 0.5)
	(let ((v2 (rectangular->polar v0 v1)))
	  (IF (fneq (vct-ref v2 0) 1.118) (snd-display ";rectangular->polar: ~A?" v2)))
	(vct-set! v0 0 1.0)
	(vct-set! v1 0 1.0)
	(rectangular->polar v0 v1)
	(IF (or (fneq (vct-ref v0 0) (sqrt 2.0))
		(fneq (vct-ref v1 0) (- (atan 1.0 1.0)))) ;(tan (atan 1.0 1.0)) -> 1.0 
	    (snd-display ";rectangular->polar (~A ~A): ~A ~A?" (sqrt 2.0) (- (atan 1.0 1.0)) (vct-ref v0 0) (vct-ref v1 0)))
	(polar->rectangular v0 v1)
	(IF (or (fneq (vct-ref v0 0) 1.0)
		(fneq (vct-ref v1 0) 1.0))
	    (snd-display ";polar->rectangular (1 1): ~A ~A?" (vct-ref v0 0) (vct-ref v1 0)))
      (let* ((ind (open-sound "oboe.snd"))
	     (rl (samples->vct 1200 512))
	     (im (make-vct 512)))
	(fft rl im 512)
	(let ((rl-copy (vct-copy rl))
	      (im-copy (vct-copy im)))
	  (rectangular->polar rl im)
	  (polar->rectangular rl im)
	  (do ((i 0 (1+ i)))
	      ((= i 512))
	    (if (or (fneq (vct-ref rl i) (vct-ref rl-copy i))
		    (fneq (vct-ref im i) (vct-ref im-copy i)))
		(snd-display ";polar->rectangular[~D]: ~A ~A ~A ~A" 
			     i 
			     (vct-ref rl i) (vct-ref rl-copy i)
			     (vct-ref im i) (vct-ref im-copy i)))))
	  (close-sound ind)))

      (let ((v0 (make-vct 3)))
	(vct-set! v0 0 1.0)
	(vct-set! v0 1 0.5)
	(vct-set! v0 2 0.1)
	(IF (or (fneq (polynomial v0 0.0) 1.0)
		(fneq (polynomial v0 1.0) 1.6)
		(fneq (polynomial v0 2.0) 2.4))
	    (snd-display ";polynomial: ~A ~A ~A?"
				 (polynomial v0 0.0)
				 (polynomial v0 1.0)
				 (polynomial v0 2.0))))

      (let ((v0 (make-vct 10)))
	(do ((i 0 (1+ i))) ((= i 10))
	  (vct-set! v0 i i))
	(IF (fneq (array-interp v0 3.5) 3.5) (snd-display ";array-interp: ~F?" (array-interp v0 3.5)))
	(IF (fneq (array-interp v0 13.5) 3.5) (snd-display ";array-interp(13.5): ~F?" (array-interp v0 13.5)))
	(IF (fneq (array-interp v0 -6.5) 3.5) (snd-display ";array-interp(-6.5): ~F?" (array-interp v0 -6.5)))
	(IF (fneq (array-interp v0 103.6) 3.6) (snd-display ";array-interp(103.5): ~F?" (array-interp v0 103.6)))
	(IF (fneq (array-interp v0 -106.6) 3.4) (snd-display ";array-interp(-106.6): ~F?" (array-interp v0 -106.6)))
	(IF (fneq (array-interp v0 -0.5) 4.5) (snd-display ";array-interp(-0.5): ~F?" (array-interp v0 -0.5)))
	;; interpolating between 9 and 0 here (confusing...)
	(IF (fneq (array-interp v0 -0.9) 8.1) (snd-display ";array-interp(-0.9): ~F?" (array-interp v0 -0.9)))
	(IF (fneq (array-interp v0 -0.1) 0.9) (snd-display ";array-interp(-0.1): ~F?" (array-interp v0 -0.1)))
	(IF (fneq (array-interp v0 9.1) 8.1) (snd-display ";array-interp(9.1): ~F?" (array-interp v0 9.1)))
	(IF (fneq (array-interp v0 9.9) 0.9) (snd-display ";array-interp(9.9): ~F?" (array-interp v0 9.9)))
	(IF (fneq (array-interp v0 10.1) 0.1) (snd-display ";array-interp(10.1): ~F?" (array-interp v0 10.1)))
	(let ((var (catch #t (lambda () (array-interp v0 1 -10)) (lambda args args))))
	  (IF (not (eq? (car var) 'mus-error))
	      (snd-display ";array-interp bad index: ~A" var))))

      (let ((gen (make-delay 3))
	    (gen1 (make-delay 4 :initial-contents '(1.0 0.5 0.25 0.0)))
	    (v0 (make-vct 10)))
	(print-and-check gen 
			 "delay" 
			 "delay: line[3]: [0.000 0.000 0.000]"
			 "dly line[3,3 at 0,0 (external)]: [0.000 0.000 0.000], xscl: 0.000000, yscl: 0.000000")
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (delay gen i)))
	(IF (not (delay? gen)) (snd-display ";~A not delay?" gen))
	(IF (not (= (mus-length gen) 3)) (snd-display ";delay length: ~D?" (mus-length gen)))
	(IF (or (fneq (vct-ref v0 1) 0.0) (fneq (vct-ref v0 4) 1.0) (fneq (vct-ref v0 8) 5.0))
	    (snd-display ";delay output: ~A" v0))
	(IF (or (fneq (delay gen1) 1.0) 
		(fneq (delay gen1) 0.5)
		(fneq (delay gen1) 0.25)
		(fneq (delay gen1) 0.0)
		(fneq (delay gen1) 0.0))
	    (snd-display ";delay with initial-contents confused"))
	(let ((var (catch #t (lambda () (make-delay :size #f)) (lambda args args))))
	  (IF (not (eq? (car var) 'wrong-type-arg))
	      (snd-display ";make-delay bad size #f: ~A" var)))
	(let ((var (catch #t (lambda () (make-delay 3 :initial-element (make-oscil))) (lambda args args))))
	  (IF (not (eq? (car var) 'wrong-type-arg))
	      (snd-display ";make-delay bad initial element: ~A" var))))

      (test-gen-equal (let ((d1 (make-delay 3))) (delay d1 1.0) d1) 
		      (let ((d2 (make-delay 3))) (delay d2 1.0) d2)
		      (let ((d3 (make-delay 4))) (delay d3 1.0) d3))
      (test-gen-equal (make-delay 3 :initial-element 1.0) (make-delay 3 :initial-element 1.0) (make-delay 3 :initial-element 0.5))
      (test-gen-equal (make-delay 3 :initial-contents '(1.0 0.0 0.0)) 
		      (make-delay 3 :initial-contents '(1.0 0.0 0.0)) 
		      (make-delay 3 :initial-contents '(1.0 1.0 1.0)))

      (let ((gen (make-delay 5)))
	(delay gen 1.0)
	(delay gen 0.0)
	(delay gen 0.5)
	(let ((data (vct-copy (mus-data gen))))
	  (vct-set! (mus-data gen) 0 0.3)
	  (IF (fneq (vct-ref (mus-data gen) 0) 0.3)
	      (snd-display ";delay data 0: ~A" (vct-ref (mus-data gen) 0)))
	  (vct-set! data 0 .75)
	  (set! (mus-data gen) data)
	  (IF (fneq (vct-ref (mus-data gen) 0) 0.75)
	      (snd-display ";delay set data 0: ~A" (vct-ref (mus-data gen) 0)))
	  (delay gen 0.0)
	  (delay gen 0.0)
	  (let ((val (delay gen 0.0)))
	    (IF (fneq val 0.75)
		(snd-display ";set delay data: ~A ~A" val (mus-data gen)))))
	(IF (mus-data (make-oscil))
	    (snd-display ";mus-data osc: ~A" (mus-data (make-oscil)))))

      (let* ((del (make-delay 5 :max-size 8)))
	(delay del 1.0)
	(do ((i 0 (1+ i))) ((= i 4)) (delay del 0.0))
	(let ((v0 (make-vct 5)))
	  (do ((i 0 (1+ i)))
	      ((= i 5))
	    (vct-set! v0 i (delay del 0.0 0.4)))
	  (IF (not (vequal v0 (vct 0.600 0.400 0.000 0.000 0.000)))
	      (snd-display ";zdelay: ~A" v0))
	  (delay del 1.0)
	  (delay del 0.0 0.4)
	  (IF (not (string=? (mus-describe del) "delay: line[5,8]: [0.000 0.000 0.000 1.000 0.000]"))
	      (snd-display ";describe zdelay: ~A" (mus-describe del)))
	  (IF (not (string=? (mus-inspect del) "dly line[5,8 at 4,7 (external)]: [0.000 0.000 0.000 1.000 0.000], xscl: 0.000000, yscl: 0.000000"))
	      (snd-display ";inspect zdelay: ~A" (mus-inspect del)))))

      (let ((gen (make-all-pass .4 .6 3))
	    (v0 (make-vct 10)))
	(print-and-check gen 
			 "all_pass"
			 "all_pass: feedback: 0.600, feedforward: 0.400, line[3]:[0.000 0.000 0.000]"
			 "dly line[3,3 at 0,0 (external)]: [0.000 0.000 0.000], xscl: 0.600000, yscl: 0.400000")
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (all-pass gen 1.0)))
	(IF (not (all-pass? gen)) (snd-display ";~A not all-pass?" gen))
	(IF (not (= (mus-length gen) 3)) (snd-display ";all-pass length: ~D?" (mus-length gen)))
	(IF (not (= (mus-order gen) 3)) (snd-display ";all-pass order: ~D?" (mus-order gen)))
	(IF (fneq (mus-feedback gen) .4) (snd-display ";all-pass feedback: ~F?" (mus-feedback gen)))
	(IF (fneq (mus-feedforward gen) .6) (snd-display ";all-pass feedforward: ~F?" (mus-feedforward gen)))
	(IF (or (fneq (vct-ref v0 1) 0.6) (fneq (vct-ref v0 4) 1.84) (fneq (vct-ref v0 8) 2.336))
	    (snd-display ";all-pass output: ~A" v0))
	(set! (mus-feedback gen) 0.5) 
	(IF (fneq (mus-feedback gen) .5) (snd-display ";all-pass set-feedback: ~F?" (mus-feedback gen)))
	(set! (mus-feedforward gen) 0.5) 
	(IF (fneq (mus-feedforward gen) .5) (snd-display ";all-pass set-feedforward: ~F?" (mus-feedforward gen))))

      (test-gen-equal (let ((d1 (make-all-pass 0.7 0.5 3))) (all-pass d1 1.0) d1)
		      (let ((d2 (make-all-pass 0.7 0.5 3))) (all-pass d2 1.0) d2) 
		      (let ((d3 (make-all-pass 0.7 0.5 4))) (all-pass d3 1.0) d3))
      (test-gen-equal (make-all-pass 0.7 0.5 3 :initial-element 1.0) 
		      (make-all-pass 0.7 0.5 3 :initial-element 1.0) 
		      (make-all-pass 0.7 0.5 3 :initial-element 0.5))
      (test-gen-equal (make-all-pass 0.7 0.5 3 :initial-element 1.0) 
		      (make-all-pass 0.7 0.5 3 :initial-element 1.0) 
		      (make-all-pass 0.5 0.5 3 :initial-element 1.0))
      (test-gen-equal (make-all-pass 0.7 0.5 3 :initial-contents '(1.0 0.0 0.0)) 
		      (make-all-pass 0.7 0.5 3 :initial-contents '(1.0 0.0 0.0)) 
		      (make-all-pass 0.7 0.5 3 :initial-contents '(1.0 1.0 1.0)))

      (let ((gen (make-comb .4 3))
	    (v0 (make-vct 10)))
	(print-and-check gen 
			 "comb"
			 "comb: scaler: 0.400, line[3]: [0.000 0.000 0.000]"
			 "dly line[3,3 at 0,0 (external)]: [0.000 0.000 0.000], xscl: 0.400000, yscl: 0.000000")
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (comb gen 1.0)))
	(IF (not (comb? gen)) (snd-display ";~A not comb?" gen))
	(IF (not (= (mus-length gen) 3)) (snd-display ";comb length: ~D?" (mus-length gen)))
	(IF (not (= (mus-order gen) 3)) (snd-display ";comb order: ~D?" (mus-order gen)))
	(IF (fneq (mus-feedback gen) .4) (snd-display ";comb feedback: ~F?" (mus-feedback gen)))
	(IF (or (fneq (vct-ref v0 1) 0.0) (fneq (vct-ref v0 4) 1.0) (fneq (vct-ref v0 8) 1.4))
	    (snd-display ";comb output: ~A" v0)))

      (test-gen-equal (let ((d1 (make-comb 0.7 3))) (comb d1 1.0) d1) 
		      (let ((d2 (make-comb 0.7 3))) (comb d2 1.0) d2) 
		      (let ((d3 (make-comb 0.7 4))) (comb d3 1.0) d3))
      (test-gen-equal (make-comb 0.7 3 :initial-element 1.0) 
		      (make-comb 0.7 3 :initial-element 1.0) 
		      (make-comb 0.7 3 :initial-element 0.5))
      (test-gen-equal (make-comb 0.7 3 :initial-element 1.0) 
		      (make-comb 0.7 3 :initial-element 1.0) 
		      (make-comb 0.5 3 :initial-element 1.0))
      (test-gen-equal (make-comb 0.7 3 :initial-contents '(1.0 0.0 0.0)) 
		      (make-comb 0.7 3 :initial-contents '(1.0 0.0 0.0)) 
		      (make-comb 0.7 3 :initial-contents '(1.0 1.0 1.0)))

      (let* ((del (make-comb 0.0 5 :max-size 8)))
	(comb del 1.0)
	(do ((i 0 (1+ i))) ((= i 4)) (comb del 0.0))
	(let ((v0 (make-vct 5)))
	  (do ((i 0 (1+ i)))
	      ((= i 5))
	    (vct-set! v0 i (comb del 0.0 0.4)))
	  (IF (not (vequal v0 (vct 0.600 0.400 0.000 0.000 0.000)))
	      (snd-display ";zcomb: ~A" v0))
	  (comb del 1.0)
	  (comb del 0.0 0.4)
	  (IF (not (string=? (mus-describe del) "comb: scaler: 0.000, line[5,8]: [0.000 0.000 0.000 1.000 0.000]"))
	      (snd-display ";describe zcomb: ~A" (mus-describe del)))
	  (IF (not (string=? (mus-inspect del) "dly line[5,8 at 4,7 (external)]: [0.000 0.000 0.000 1.000 0.000], xscl: 0.000000, yscl: 0.000000"))
	      (snd-display ";inspect zcomb: ~A" (mus-inspect del))))
	(set! (mus-feedback del) 1.0)
	(IF (fneq (mus-feedback del) 1.0)
	    (snd-display ";comb feedback set: ~A" (mus-feedback del))))

      (let ((gen (make-notch .4 3))
	    (v0 (make-vct 10)))
	(print-and-check gen 
			 "notch"
			 "notch: scaler: 0.400, line[3]: [0.000 0.000 0.000]"
			 "dly line[3,3 at 0,0 (external)]: [0.000 0.000 0.000], xscl: 0.400000, yscl: 0.000000")
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (notch gen 1.0)))
	(IF (not (notch? gen)) (snd-display ";~A not notch?" gen))
	(IF (not (= (mus-length gen) 3)) (snd-display ";notch length: ~D?" (mus-length gen)))
	(IF (not (= (mus-order gen) 3)) (snd-display ";notch order: ~D?" (mus-order gen)))
	(IF (fneq (mus-feedforward gen) .4) (snd-display ";notch feedforward: ~F?" (mus-feedforward gen)))
	(IF (or (fneq (vct-ref v0 1) 0.4) (fneq (vct-ref v0 4) 1.4) (fneq (vct-ref v0 8) 1.4))
	    (snd-display ";notch output: ~A" v0))
	(set! (mus-feedforward gen) 1.0)
	(IF (fneq (mus-feedforward gen) 1.0)
	    (snd-display ";notch feedforward set: ~A" (mus-feedforward gen))))

      (test-gen-equal (let ((d1 (make-notch 0.7 3))) (notch d1 1.0) d1)
		      (let ((d2 (make-notch 0.7 3))) (notch d2 1.0) d2)
		      (let ((d3 (make-notch 0.7 4))) (notch d3 1.0) d3))
      (test-gen-equal (make-notch 0.7 3 :initial-element 1.0) 
		      (make-notch 0.7 3 :initial-element 1.0) 
		      (make-notch 0.7 3 :initial-element 0.5))
      (test-gen-equal (make-notch 0.7 3 :initial-element 1.0) 
		      (make-notch 0.7 3 :initial-element 1.0) 
		      (make-notch 0.5 3 :initial-element 1.0))
      (test-gen-equal (make-notch 0.7 3 :initial-contents '(1.0 0.0 0.0)) 
		      (make-notch 0.7 3 :initial-contents '(1.0 0.0 0.0)) 
		      (make-notch 0.7 3 :initial-contents '(1.0 1.0 1.0)))

      (let ((gen (make-one-pole .4 .7))
	    (v0 (make-vct 10)))
	(print-and-check gen 
			 "one_pole"
			 "one_pole: a0: 0.400, b1: 0.700, y1: 0.000"
			 "smpflt a0: 0.400000, a1: 0.000000, a2: 0.000000, b1: 0.700000, b2: 0.000000, x1: 0.000000, x2: 0.000000, y1: 0.000000, y2: 0.000000")
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (one-pole gen 1.0)))
	(IF (not (one-pole? gen)) (snd-display ";~A not one-pole?" gen))
	(IF (not (= (mus-order gen) 1)) (snd-display ";one-pole order: ~D?" (mus-order gen)))
	(IF (fneq (mus-a0 gen) .4) (snd-display ";one-pole a0: ~F?" (mus-a0 gen)))
	(IF (fneq (mus-b1 gen) .7) (snd-display ";one-pole b1: ~F?" (mus-b1 gen)))
	(IF (or (fneq (vct-ref v0 1) 0.120) (fneq (vct-ref v0 4) 0.275) (fneq (vct-ref v0 8) 0.245))
	    (snd-display ";one-pole output: ~A" v0)))

      (let ((gen (make-one-zero .4 .7))
	    (v0 (make-vct 10)))
	(print-and-check gen
			 "one_zero"
			 "one_zero: a0: 0.400, a1: 0.700, x1: 0.000"
			 "smpflt a0: 0.400000, a1: 0.700000, a2: 0.000000, b1: 0.000000, b2: 0.000000, x1: 0.000000, x2: 0.000000, y1: 0.000000, y2: 0.000000")
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (one-zero gen 1.0)))
	(IF (not (one-zero? gen)) (snd-display ";~A not one-zero?" gen))
	(IF (not (= (mus-order gen) 1)) (snd-display ";one-zero order: ~D?" (mus-order gen)))
	(IF (fneq (mus-a0 gen) .4) (snd-display ";one-zero a0: ~F?" (mus-a0 gen)))
	(IF (fneq (mus-a1 gen) .7) (snd-display ";one-zero a1: ~F?" (mus-a1 gen)))
	(IF (fneq (vct-ref v0 1) 1.1) (snd-display ";one-zero output: ~A" v0)))

      (let ((gen (make-two-zero .4 .7 .3))
	    (v0 (make-vct 10)))
	(print-and-check gen 
			 "two_zero"
			 "two_zero: a0: 0.400, a1: 0.700, a2: 0.300, x1: 0.000, x2: 0.000"
			 "smpflt a0: 0.400000, a1: 0.700000, a2: 0.300000, b1: 0.000000, b2: 0.000000, x1: 0.000000, x2: 0.000000, y1: 0.000000, y2: 0.000000")
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (two-zero gen 1.0)))
	(IF (not (two-zero? gen)) (snd-display ";~A not two-zero?" gen))
	(IF (not (= (mus-order gen) 2)) (snd-display ";two-zero order: ~D?" (mus-order gen)))
	(IF (fneq (mus-a0 gen) .4) (snd-display ";two-zero a0: ~F?" (mus-a0 gen)))
	(IF (fneq (mus-a1 gen) .7) (snd-display ";two-zero a1: ~F?" (mus-a1 gen)))
	(IF (fneq (mus-a2 gen) .3) (snd-display ";two-zero a2: ~F?" (mus-a2 gen)))
	(IF (or (fneq (vct-ref v0 1) 1.1) (fneq (vct-ref v0 8) 1.4)) (snd-display ";two-zero output: ~A" v0)))

      (let ((gen (make-two-pole .4 .7 .3))
	    (v0 (make-vct 10)))
	(print-and-check gen 
			 "two_pole"
			 "two_pole: a0: 0.400, b1: 0.700, b2: 0.300, y1: 0.000, y2: 0.000"
			 "smpflt a0: 0.400000, a1: 0.000000, a2: 0.000000, b1: 0.700000, b2: 0.300000, x1: 0.000000, x2: 0.000000, y1: 0.000000, y2: 0.000000")
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (two-pole gen 1.0)))
	(IF (not (two-pole? gen)) (snd-display ";~A not two-pole?" gen))
	(IF (not (= (mus-order gen) 2)) (snd-display ";two-pole order: ~D?" (mus-order gen)))
	(IF (fneq (mus-a0 gen) .4) (snd-display ";two-pole a0: ~F?" (mus-a0 gen)))
	(IF (fneq (mus-b1 gen) .7) (snd-display ";two-pole b1: ~F?" (mus-b1 gen)))
	(IF (fneq (mus-b2 gen) .3) (snd-display ";two-pole b2: ~F?" (mus-b2 gen)))
	(IF (or (fneq (vct-ref v0 1) 0.12) (fneq (vct-ref v0 8) 0.201)) (snd-display ";two-pole output: ~A" v0)))

      (let ((var (catch #t (lambda () (make-two-pole :b1 3.0)) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";make-two-pole bad b1: ~A" var)))
      (let ((var (catch #t (lambda () (make-two-pole :b2 2.0)) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";make-two-pole bad b2: ~A" var)))
      (let ((var (catch #t (lambda () (make-two-pole :b2 2.0 :b1)) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";make-two-pole bad keys: ~A" var)))
      (let ((var (catch #t (lambda () (make-two-pole :b2 2.0 3.0)) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";make-two-pole bad args: ~A" var)))

      (let ((gen (make-oscil 440.0))
	    (gen1 (make-oscil 440.0))
	    (v0 (make-vct 10))
	    (v1 (make-vct 10)))
	(print-and-check gen 
			 "oscil"
			 "oscil freq: 440.000Hz, phase: 0.000"
			 "osc freq: 0.125379, phase: 0.000000")
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (oscil gen 0.0))
	  (vct-set! v1 i (mus-apply gen1 0.0 0.0)))
	(IF (not (oscil? gen)) (snd-display ";~A not oscil?" gen))
	(IF (fneq (mus-phase gen) 1.253787) (snd-display ";oscil phase: ~F?" (mus-phase gen)))
	(IF (fneq (mus-frequency gen) 440.0) (snd-display ";oscil frequency: ~F?" (mus-frequency gen)))
	(IF (not (= (mus-cosines gen) 1)) (snd-display ";oscil cosines: ~D?" (mus-cosines gen)))
	(IF (or (fneq (vct-ref v0 1) 0.125) (fneq (vct-ref v0 8) 0.843)) (snd-display ";oscil output: ~A" v0))
	(set! (mus-phase gen) 0.0)
	(IF (fneq (mus-phase gen) 0.0) (snd-display ";oscil set-phase: ~F?" (mus-phase gen)))
	(set! (mus-frequency gen) 100.0)
	(IF (fneq (mus-frequency gen) 100.0) (snd-display ";oscil set-frequency: ~F?" (mus-frequency gen)))
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (IF (fneq (vct-ref v0 i) (vct-ref v1 i))
	      (snd-display ";mus-apply oscil at ~D: ~A ~A?" i (vct-ref v0 i) (vct-ref v1 i))))
	(IF (fneq (mus-apply) 0.0)
	    (snd-display ";(mus-apply): ~A" (mus-apply))))

      (fm-test (make-oscil))
      (fm-test (make-sine-summation))
      (fm-test (make-square-wave))
      (fm-test (make-triangle-wave))
      (fm-test (make-sum-of-cosines))
      (fm-test (make-sawtooth-wave))
      (fm-test (make-rand))
      (fm-test (make-rand-interp))
      (fm-test (make-pulse-train))

      (let ((gen (make-oscil 440.0))
	    (gen1 (make-oscil 440.0)))
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (let ((oval (oscil gen .1))
		(mval (mus-run gen1 .1)))
	    (IF (fneq oval mval)
		(snd-display ";mus-run ~A but oscil ~A?" mval oval)))))

      (let ((gen (make-oscil 440.0))
	    (gen1 (make-oscil 440.0))
	    (gen2 (make-oscil 440.0))
	    (gen3 (make-oscil 440.0))
	    (fm-index (hz->radians 440.0))
	    (v0 (make-vct 10))
	    (v1 (make-vct 10)))
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (oscil gen (* fm-index (oscil gen1 0.0))))
	  (vct-set! v1 i (mus-apply gen2 (* fm-index (mus-apply gen3 0.0 0.0)) 0.0)))
	(IF (or (fneq (vct-ref v0 1) 0.125) (fneq (vct-ref v0 6) 0.830) (fneq (vct-ref v0 8) 0.987))
	    (snd-display ";oscil fm output: ~A" v0))
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (IF (fneq (vct-ref v0 i) (vct-ref v1 i))
	      (snd-display ";mus-apply fm oscil at ~D: ~A ~A?" i (vct-ref v0 i) (vct-ref v1 i)))))

      (test-gen-equal (make-oscil 440.0) (make-oscil 440.0) (make-oscil 100.0))
      (test-gen-equal (make-oscil 440.0) (make-oscil 440.0) (make-oscil 440.0 1.0))
      
      (let ((gen (make-oscil 440.0))
	    (gen1 (make-oscil 440.0))
	    (pm-index 2.0)
	    (v0 (make-vct 10)))
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (gen 0.0 (* pm-index (gen1 0.0)))))
	(IF (or (fneq (vct-ref v0 1) 0.367) (fneq (vct-ref v0 6) 0.854) (fneq (vct-ref v0 8) 0.437))
	    (snd-display ";oscil pm output: ~A" v0)))

      (let ((var (catch #t (lambda () (mus-location (make-oscil))) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";mus-location bad gen: ~A" var)))
      (let ((var (catch #t (lambda () (set! (mus-location (make-oscil)) 0)) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";set mus-location bad gen: ~A" var)))
      (let ((var (catch #t (lambda () (mus-scaler (make-oscil))) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";mus-scaler bad gen: ~A" var)))
      (let ((var (catch #t (lambda () (set! (mus-scaler (make-oscil)) 0)) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";set mus-scaler bad gen: ~A" var)))
      (let ((var (catch #t (lambda () (mus-length (make-oscil))) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";mus-length bad gen: ~A" var)))
      (let ((var (catch #t (lambda () (set! (mus-length (make-oscil)) 0)) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";set mus-length bad gen: ~A" var)))
      (let ((var (catch #t (lambda () (mus-frequency (make-one-pole))) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";mus-frequency bad gen: ~A" var)))
      (let ((var (catch #t (lambda () (set! (mus-frequency (make-one-pole)) 0)) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";set mus-frequency bad gen: ~A" var)))
      (let ((var (catch #t (lambda () (mus-scaler (make-one-pole))) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";mus-scaler bad gen: ~A" var)))
      (let ((var (catch #t (lambda () (set! (mus-scaler (make-one-pole)) 0)) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";set mus-scaler bad gen: ~A" var)))

      (let ((amps (make-vector 3))
	    (oscils (make-vector 3))
	    (fms (make-vector 3))
	    (results (make-vector 10)))
	(do ((i 0 (1+ i))) ((= i 3))
	  (vector-set! amps i (* (+ i 1) .1))
	  (vector-set! oscils i (make-oscil :frequency (* (+ i 1) 220.0)))
	  (vector-set! fms i (* i .05)))
	(do ((i 0 (1+ i))) ((= i 10))
	  (vector-set! results i (oscil-bank amps oscils fms)))
	(IF (or (fneq (vector-ref results 1) 0.12639)
		(fneq (vector-ref results 5) 0.48203)
		(fneq (vector-ref results 9) 0.41001))
	    (snd-display ";oscil-bank: ~A?" results)))

      (let ((amps (make-vector 3))
	    (oscils (make-vector 3))
	    (fms (make-vector 3))
	    (results (make-vector 10)))
	(do ((i 0 (1+ i))) ((= i 3))
	  (vector-set! amps i (* (+ i 1) .1))
	  (vector-set! oscils i (make-oscil :frequency (* (+ i 1) 220.0)))
	  (vector-set! fms i (* i .05)))
	(do ((i 0 (1+ i))) ((= i 10))
	  (vector-set! results i (mus-bank oscils amps fms)))
	(IF (or (fneq (vector-ref results 1) 0.12639)
		(fneq (vector-ref results 5) 0.48203)
		(fneq (vector-ref results 9) 0.41001))
	    (snd-display ";mus-bank: ~A?" results)))

      (let ((gen (make-buffer 3)))
	(IF (not (buffer-empty? gen)) (snd-display ";new buf not buffer-empty: ~A?" gen))
	(sample->buffer gen 1.0)
	(sample->buffer gen 0.5)
	(sample->buffer gen 0.25)

	(print-and-check gen 
			 "buffer"
			 "buffer: length: 3, loc: 0, fill: 3.000"
			 "rblk buf[3 (external)]: [1.000 0.500 0.250], loc: 0, fill_time: 3.000000, empty: 1")
	(IF (not (buffer-full? gen)) (snd-display ";buffer-full: ~A?" gen))
	(IF (not (buffer? gen)) (snd-display ";~A not buffer?" gen))
	(IF (not (= (mus-length gen) 3)) (snd-display ";buffer length: ~D?" (mus-length gen)))
	(IF (or (fneq (buffer->sample gen) 1.0) (fneq (buffer->sample gen) 0.5) (fneq (buffer->sample gen) 0.25))
	    (snd-display (format "buffer output?")))
	(IF (not (buffer-empty? gen)) (snd-display ";emptied buf not buffer-empty: ~A?" gen))
	(let ((fr0 (make-frame 2 .1 .2))
	      (fr1 (make-frame 2 0.0 0.0)))
	  (frame->buffer gen fr0)
	  (set! fr1 (buffer->frame gen fr1))
	  (IF (not (equal? fr0 fr1)) (snd-display ";frame->buffer: ~A ~A?" fr0 fr1)))
	(set! (mus-data gen) (make-vct 3)))
      (gc)
      (let ((gen (make-buffer 6))
	    (fr1 (make-frame 2 .1 .2))
	    (fr2 (make-frame 2 .3 .4))
	    (fr3 (make-frame 2 .5 .6))
	    (fr4 (make-frame 2 .7 .8)))
	(frame->buffer gen fr1)

	(print-and-check gen 
			 "buffer"
			 "buffer: length: 6, loc: 0, fill: 2.000"
			 "rblk buf[6 (external)]: [0.100 0.200 0.000 0.000 0.000 0.000], loc: 0, fill_time: 2.000000, empty: 1")
	(frame->buffer gen fr2)
	(frame->buffer gen fr3)

	(print-and-check gen 
			 "buffer"
			 "buffer: length: 6, loc: 0, fill: 6.000"
			 "rblk buf[6 (external)]: [0.100 0.200 0.300 0.400 0.500 0.600], loc: 0, fill_time: 6.000000, empty: 1")
	(buffer->frame gen fr2)
	(IF (not (equal? fr2 fr1)) (snd-display ";buffer->frame: ~A ~A?" fr1 fr2))

	(print-and-check gen 
			 "buffer"
			 "buffer: length: 6, loc: 2, fill: 6.000"
			 "rblk buf[6 (external)]: [0.100 0.200 0.300 0.400 0.500 0.600], loc: 2, fill_time: 6.000000, empty: 1")
	(let ((f (buffer->frame gen)))
	  (IF (not (= (mus-channels f) 1)) (snd-display ";buffer->frame default: ~A?" f))
	  (IF (fneq (frame-ref f 0) .3) (snd-display ";buffer->frame: ~A?" f))
	  (buffer->frame gen fr1)
	  (IF (not (equal? fr1 (make-frame 2 .4 .5))) (snd-display ";buffer->frame offset: ~A?" fr1))
	  (frame->buffer gen fr4)

	(print-and-check gen 
			 "buffer"
			 "buffer: length: 6, loc: 0, fill: 3.000"
			 "rblk buf[6 (external)]: [0.600 0.700 0.800 0.000 0.000 0.000], loc: 0, fill_time: 3.000000, empty: 1")))

      (test-gen-equal (make-buffer 3) (make-buffer 3) (make-buffer 4))
      (let ((gen (make-buffer 3))
	    (gen1 (make-buffer 3))
	    (gen2 (make-buffer 3)))
	(sample->buffer gen 1.0)
	(sample->buffer gen 0.5)
	(sample->buffer gen1 1.0)
	(sample->buffer gen1 0.5)
	(sample->buffer gen2 1.0)
	(sample->buffer gen2 0.5)
	(sample->buffer gen2 0.25)
	(test-gen-equal gen gen1 gen2))

      (let ((gen (make-sum-of-cosines 10 440.0))
	    (v0 (make-vct 10)))
	(print-and-check gen 
			 "sum_of_cosines"
			 "sum_of_cosines freq: 440.000Hz, phase: 0.000, cosines: 10"
			 "cosp freq: 0.125379, phase: 0.000000, cosines: 10, scaler: 0.047619")
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (sum-of-cosines gen 0.0)))
	(IF (not (sum-of-cosines? gen)) (snd-display ";~A not sum-of-cosines?" gen))
	(IF (fneq (mus-phase gen) 1.253787) (snd-display ";sum-of-cosines phase: ~F?" (mus-phase gen)))
	(IF (fneq (mus-frequency gen) 440.0) (snd-display ";sum-of-cosines frequency: ~F?" (mus-frequency gen)))
	(IF (fneq (mus-scaler gen) (/ 1.0 21.0)) (snd-display ";sum-of-cosines scaler: ~F?" (mus-scaler gen)))
	(IF (not (= (mus-cosines gen) 10)) (snd-display ";sum-of-cosines cosines: ~D?" (mus-cosines gen)))
	(IF (not (= (mus-length gen) 10)) (snd-display ";sum-of-cosines length: ~D?" (mus-length gen)))
	(IF (or (fneq (vct-ref v0 1) 0.736) (fneq (vct-ref v0 8) -0.089)) (snd-display ";sum-of-cosines output: ~A" v0))
	(set! (mus-scaler gen) .5) (IF (fneq (mus-scaler gen) 0.5) (snd-display ";sum-of-cosines set-scaler: ~F?" (mus-scaler gen))))

      (test-gen-equal (make-sum-of-cosines 3 440.0) (make-sum-of-cosines 3 440.0) (make-sum-of-cosines 5 440.0))
      (test-gen-equal (make-sum-of-cosines 3 440.0) (make-sum-of-cosines 3 440.0) (make-sum-of-cosines 3 440.0 1.0))
      (test-gen-equal (make-sum-of-cosines 3 440.0) (make-sum-of-cosines 3 440.0) (make-sum-of-cosines 3 400.0))

      (let ((gen (make-sine-summation 440.0))
	    (v0 (make-vct 10)))
	(print-and-check gen 
			 "sine_summation"
			 "sine_summation: frequency: 440.000, phase: 0.000, n: 1, a: 0.500, ratio: 1.000"
			 "sss freq: 0.125379, phase: 0.000000, a: 0.500000, b: 1.000000, an: 0.250000, a2: 1.250000, n: 1")
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (sine-summation gen 0.0)))
	(IF (not (sine-summation? gen)) (snd-display ";~A not sine-summation?" gen))
	(IF (fneq (mus-phase gen) 1.253787) (snd-display ";sine-summation phase: ~F?" (mus-phase gen)))
	(IF (fneq (mus-frequency gen) 440.0) (snd-display ";sine-summation frequency: ~F?" (mus-frequency gen)))
	(IF (or (fneq (vct-ref v0 1) 0.249) (fneq (vct-ref v0 8) 1.296)) (snd-display ";sine-summation output: ~A" v0))
	(IF (fneq (mus-scaler gen) 0.5) (snd-display ";mus-scaler (a) sine-summation: ~A" (mus-scaler gen)))
	(set! (mus-scaler gen) 0.75)
	(IF (fneq (mus-scaler gen) 0.75) (snd-display ";mus-scaler (set a) sine-summation: ~A" (mus-scaler gen))))

      (test-gen-equal (make-sine-summation 440.0) (make-sine-summation 440.0) (make-sine-summation 100.0))
      (test-gen-equal (make-sine-summation 440.0) (make-sine-summation 440.0) (make-sine-summation 440.0 1.0))
      (test-gen-equal (make-sine-summation 440.0) (make-sine-summation 440.0) (make-sine-summation 440.0 0.0 3))

      (let ((gen1 (make-sine-summation 1000 0 1 0.0 1))
	    (gen2 (make-oscil 1000))
	    (gen3 (make-sine-summation 1000 0 1 0.5 2))
	    (gen4 (make-oscil 1000))
	    (gen5 (make-oscil 3000))
	    (v0 (make-vct 10)))

	(call-with-current-continuation
	 (lambda (give-up)
	   (do ((i 0 (1+ i)))
	       ((= i 100))
	     (let ((ss (sine-summation gen1 0.0))
		   (os (oscil gen2 0.0))
		   (ss1 (sine-summation gen3 0.0))
		   (os1 (+ (oscil gen4 0.0) 
			   (* 0.5 (oscil gen5 0.0)))))
	       (IF (ffneq ss os)
		   (begin
		     (snd-display ";sine-summation 1: ~A: os: ~A ss: ~A" i os ss)
		     (give-up)))
	       (IF (ffneq ss1 os1)
		   (begin
		     (snd-display ";sine-summation 2: ~A: os1: ~A ss1: ~A" i os1 ss1)
		     (give-up))))))))


      (let ((gen (make-asymmetric-fm 440.0))
	    (v0 (make-vct 10)))
	(print-and-check gen 
			 "asymmetric_fm"
			 "asymmetric-fm freq: 440.000Hz, phase: 0.000, ratio: 1.000, r: 1.000"
			 "asyfm r: 1.000000, freq: 0.125379, phase: 0.000000, ratio: 1.000000, cosr: 0.000000, sinr: 1.000000")
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (asymmetric-fm gen 0.0)))
	(IF (not (asymmetric-fm? gen)) (snd-display ";~A not asymmetric-fm?" gen))
	(IF (fneq (mus-phase gen) 1.253787) (snd-display ";asymmetric-fm phase: ~F?" (mus-phase gen)))
	(IF (fneq (mus-frequency gen) 440.0) (snd-display ";asymmetric-fm frequency: ~F?" (mus-frequency gen)))
	(IF (or (fneq (vct-ref v0 2) 0.248) (fneq (vct-ref v0 8) .843)) (snd-display ";asymmetric-fm output: ~A" v0))
	(IF (fneq (mus-scaler gen) 1.0) (snd-display ";mus-scaler (r) asymmetric-fm: ~A" (mus-scaler gen)))
	(set! (mus-scaler gen) 0.5)
	(IF (fneq (mus-scaler gen) 0.5) (snd-display ";mus-scaler (set r) asymmetric-fm: ~A" (mus-scaler gen))))

      (test-gen-equal (make-asymmetric-fm 440.0) (make-asymmetric-fm 440.0) (make-asymmetric-fm 100.0))
      (test-gen-equal (make-asymmetric-fm 440.0) (make-asymmetric-fm 440.0) (make-asymmetric-fm 440.0 1.0))
      (test-gen-equal (make-asymmetric-fm 440.0) (make-asymmetric-fm 440.0) (make-asymmetric-fm 440.0 0.0 3))

      (let ((gen1 (make-asymmetric-fm 1000 0 1.0 0.1))
	    (gen2 (make-oscil 1000)))
	(call-with-current-continuation
	 (lambda (give-up)
	   (do ((i 0 (1+ i)))
	       ((= i 100))
	     (let ((ss (asymmetric-fm gen1 0.0 0.0))
		   (os (oscil gen2 0.0)))
	       (IF (fneq ss os)
		   (begin
		     (snd-display ";asymmetric-fm 1: ~A: os: ~A ss: ~A" i os ss)
		     (give-up))))))))

      (let ((vct0 (make-vct 2048))
	    (vct1 (make-vct 2048))
	    (gen3 (make-asymmetric-fm 1000 0 1.0 0.2))
	    (gen4 (make-oscil 1000))
	    (gen5 (make-oscil 200))
	    (fm1 (in-hz (* 1.0 .2 1000)))) ; make notions of "index" match
	(do ((i 0 (1+ i)))
	    ((= i 2048))
	  (vct-set! vct0 i (asymmetric-fm gen3 1.0 0.0))
	  (vct-set! vct1 i (oscil gen4 (* fm1 (oscil gen5)))))
	(let* ((spectr1 (snd-spectrum vct0 rectangular-window 2048 #t))
	       (spectr2 (snd-spectrum vct1 rectangular-window 2048 #t)))
	  (call-with-current-continuation
	   (lambda (give-up)
	     (do ((i 1 (1+ i)))
		 ((= i 512))
	       (IF (ffneq (vct-ref spectr1 i) (vct-ref spectr2 i))
		   (begin
		     (snd-display ";asymmetric-fm 2: ~A: ~A ~A" (* i (/ 22050 2048)) (vct-ref spectr1 i) (vct-ref spectr2 i))
		     (give-up))))))))

      (let ((vct0 (make-vct 2048))
	    (vct1 (make-vct 2048))
	    (gen3 (make-asymmetric-fm 1000 0 2.0 0.1))
	    (gen4 (make-asymmetric-fm 1000 0 0.5 0.1)))
	(do ((i 0 (1+ i)))
	    ((= i 2048))
	  (vct-set! vct0 i (asymmetric-fm gen3 2.0 0.0))
	  (vct-set! vct1 i (asymmetric-fm gen4 2.0 0.0)))
	(let* ((spectr1 (snd-spectrum vct0 rectangular-window 2048 #t))
	       (spectr2 (snd-spectrum vct1 rectangular-window 2048 #t))
	       (s1-loc 0)
	       (s2-loc 0))
	  (do ((i 1 (1+ i)))
	      ((= i 256))
	    (if (< (abs (- 1.0 (vct-ref spectr1 i))) .01) (set! s1-loc i))
	    (if (< (abs (- 1.0 (vct-ref spectr2 i))) .01) (set! s2-loc i)))
	  (IF (> s2-loc s1-loc) (snd-display ";asymmetric-fm peaks: ~A ~A" s1-loc s2-loc))
	  (let ((center (* (/ 22050 2048) (* .5 (+ s1-loc s2-loc)))))
	    (IF (> (abs (- 1000 center)) 50) (snd-display ";asymmetric-fm center: ~A" center)))
	  (set! (mus-scaler gen3) 0.5)
	  (do ((i 0 (1+ i)))
	      ((= i 2048))
	    (vct-set! vct0 i (asymmetric-fm gen3 2.0 0.0)))
	  (set! spectr1 (snd-spectrum vct0 rectangular-window 2048 #t))
	  (do ((i 1 (1+ i)))
	      ((= i 256))
	    (if (< (abs (- 1.0 (vct-ref spectr1 i))) .01) (set! s1-loc i)))
	  (if (not (= s2-loc s1-loc)) (snd-print (format #f "asymmetric-fm set r peaks: ~A ~A" s1-loc s2-loc)))))


      (let ((gen (make-fir-filter 3 (list->vct '(.5 .25 .125))))
	    (v0 (make-vct 10)))
	(print-and-check gen 
			 "fir_filter"
			 "fir_filter: order: 3"
			 "flt order: 3, state (local): [0.000 0.000 0.000], x: [0.500 0.250 0.125], y: nil")
	(vct-set! v0 0 (fir-filter gen 1.0))
	(do ((i 1 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (fir-filter gen 0.0)))
	(IF (not (fir-filter? gen)) (snd-display ";~A not fir-filter?" gen))
	(IF (not (= (mus-length gen) 3)) (snd-display ";fir-filter length: ~D?" (mus-length gen)))
	(IF (or (fneq (vct-ref v0 1) 0.25) (fneq (vct-ref v0 2) .125)) (snd-display ";fir-filter output: ~A" v0))
	(let ((data (mus-xcoeffs gen)))
	  (IF (fneq (vct-ref data 1) .25) (snd-display ";fir-filter xcoeffs: ~A?" data))))

      (test-gen-equal (let ((f1 (make-fir-filter 3 (list->vct '(.5 .25 .125))) )) (fir-filter f1 1.0) f1)
		      (let ((f2 (make-fir-filter 3 (list->vct '(.5 .25 .125))) )) (fir-filter f2 1.0) f2)
		      (let ((f3 (make-fir-filter 3 (list->vct '(.75 .25 .125))))) (fir-filter f3 1.0) f3))
      (test-gen-equal (let ((f1 (make-fir-filter 3 (list->vct '(.5 .25 .125))) )) (fir-filter f1 1.0) f1)
		      (let ((f2 (make-fir-filter 3 (list->vct '(.5 .25 .125))) )) (fir-filter f2 1.0) f2)
		      (let ((f3 (make-fir-filter 2 (list->vct '(.5 .25))))) (fir-filter f3 1.0) f3))

      (let* ((coeffs (list .1 .2 .3 .4 .4 .3 .2 .1))
	     (flt (make-fir-filter 8 (list->vct coeffs)))
	     (es (make-vector 8)))
	(do ((i 0 (1+ i)))
	    ((= i 8))
	  (vector-set! es i (make-env (list 0 (list-ref coeffs i) 1 0) :end 100)))
	(vector-set! es 5 (make-env '(0 .4 1 1) :end 100))
	(let ((data (make-vct 100)))
	  (do ((k 0 (1+ k)))
	      ((= k 100))
	    (let ((val (fir-filter flt (if (= (modulo k 12) 0) 1.0 0.0)))
		  (xcof (mus-data flt)))
	      (do ((i 0 (1+ i)))
		  ((= i 8))
		(vct-set! xcof i (env (vector-ref es i))))
	      (vct-set! data k val)))
	  (IF (or (fneq (vct-ref data 1) .2)
		  (fneq (vct-ref data 10) 0.0)
		  (fneq (vct-ref data 18) 0.166)
		  (fneq (vct-ref data 89) 0.923))
	      (snd-display ";filter xcoeffs: ~A?" data))))

      (let ((gen (make-iir-filter 3 (list->vct '(.5 .25 .125))))
	    (v0 (make-vct 10)))
	(print-and-check gen 
			 "iir_filter"
			 "iir_filter: order: 3"
			 "flt order: 3, state (local): [0.000 0.000 0.000], x: nil, y: [0.500 0.250 0.125]")
	(vct-set! v0 0 (iir-filter gen 1.0))
	(do ((i 1 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (iir-filter gen 0.0)))
	(IF (not (iir-filter? gen)) (snd-display ";~A not iir-filter?" gen))
	(IF (not (= (mus-length gen) 3)) (snd-display ";iir-filter length: ~D?" (mus-length gen)))
	(IF (or (fneq (vct-ref v0 1) -0.25) (fneq (vct-ref v0 2) -.062)) (snd-display ";iir-filter output: ~A" v0))
	(let ((data (mus-ycoeffs gen)))
	  (IF (fneq (vct-ref data 1) .25) (snd-display ";iir-filter ycoeffs: ~A?" data))))

      (test-gen-equal (let ((f1 (make-iir-filter 3 (list->vct '(.5 .25 .125))))) (iir-filter f1 1.0) f1)
		      (let ((f2 (make-iir-filter 3 (list->vct '(.5 .25 .125))) )) (iir-filter f2 1.0) f2)
		      (let ((f3 (make-iir-filter 3 (list->vct '(.75 .25 .125))))) (iir-filter f3 1.0) f3))
      (test-gen-equal (let ((f1 (make-iir-filter 3 (list->vct '(.5 .25 .125))) )) (iir-filter f1 1.0) f1)
		      (let ((f2 (make-iir-filter 3 (list->vct '(.5 .25 .125))) )) (iir-filter f2 1.0) f2)
		      (let ((f3 (make-iir-filter 2 (list->vct '(.5 .25))))) (iir-filter f3 1.0) f3))

      (let ((gen (make-filter 3 (list->vct '(.5 .25 .125)) (list->vct '(.5 .25 .125))))
	    (v0 (make-vct 10)))
	(print-and-check gen 
			 "filter"
			 "filter: order: 3"
			 "flt order: 3, state (local): [0.000 0.000 0.000], x: [0.500 0.250 0.125], y: [0.500 0.250 0.125]")
	(vct-set! v0 0 (filter gen 1.0))
	(do ((i 1 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (filter gen 0.0)))
	(IF (not (filter? gen)) (snd-display ";~A not filter?" gen))
	(IF (not (= (mus-length gen) 3)) (snd-display ";filter length: ~D?" (mus-length gen)))
	(IF (or (fneq (vct-ref v0 1) 0.125) (fneq (vct-ref v0 2) .031)) (snd-display ";filter output: ~A" v0))
	(let ((xs (mus-xcoeffs gen))
	      (ys (mus-ycoeffs gen)))
	  (IF (or (not (equal? xs (list->vct '(.5 .25 .125))))
		  (not (equal? xs ys)))
	      (snd-display ";mus-xcoeffs: ~A ~A?" xs ys))))

      (let ((var (catch #t (lambda () (make-filter :order 2 :xcoeffs (vct 1.0 0.5) :ycoeffs (vct 2.0 1.0 0.5))) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";make-filter bad coeffs: ~A" var)))

      (test-gen-equal (let ((f1 (make-filter 3 (list->vct '(.5 .25 .125)) (list->vct '(.5 .25 .125))))) (filter f1 1.0) f1)
		      (let ((f2 (make-filter 3 (list->vct '(.5 .25 .125)) (list->vct '(.5 .25 .125))))) (filter f2 1.0) f2)
		      (let ((f3 (make-filter 3 (list->vct '(.5 .25 .125)) (list->vct '(.5 .5 .5))))) (filter f3 1.0) f3))
      (test-gen-equal (let ((f1 (make-filter 3 (list->vct '(.5 .25 .125)) (list->vct '(.5 .25 .125))))) (filter f1 1.0) f1)
		      (let ((f2 (make-filter 3 (list->vct '(.5 .25 .125)) (list->vct '(.5 .25 .125))))) (filter f2 1.0) f2)
		      (let ((f3 (make-filter 3 (list->vct '(.5 .5 .125)) (list->vct '(.5 .25 .0625))))) (filter f3 1.0) f3))

      (let ((var (catch #t (lambda () (make-filter 0)) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";make-filter no coeffs: ~A" var)))

      (let ((gen (make-sawtooth-wave 440.0))
	    (v0 (make-vct 10)))
	(print-and-check gen 
			 "sawtooth_wave"
			 "sawtooth freq: 440.000Hz, phase: 3.142, amp: 1.000"
			 "sw current_value: 0.000000, freq: 0.125379, phase: 3.141593, base: 0.318310")
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (sawtooth-wave gen 0.0)))
	(IF (not (sawtooth-wave? gen)) (snd-display ";~A not sawtooth-wave?" gen))
	(IF (fneq (mus-phase gen) 4.39538) (snd-display ";sawtooth-wave phase: ~F?" (mus-phase gen))) ;starts at pi
	(IF (fneq (mus-frequency gen) 440.0) (snd-display ";sawtooth-wave frequency: ~F?" (mus-frequency gen)))
	(IF (fneq (mus-scaler gen) 1.0) (snd-display ";sawtooth-wave scaler: ~F?" (mus-scaler gen)))
	(IF (or (fneq (vct-ref v0 1) 0.04) (fneq (vct-ref v0 8) .319)) (snd-display ";sawtooth-wave output: ~A" v0)))

      (test-gen-equal (make-sawtooth-wave 440.0) (make-sawtooth-wave 440.0) (make-sawtooth-wave 120.0))
      (test-gen-equal (make-sawtooth-wave 440.0) (make-sawtooth-wave 440.0) (make-sawtooth-wave 440.0 1.0 1.0))
      (test-gen-equal (make-sawtooth-wave 440.0) (make-sawtooth-wave 440.0) (make-sawtooth-wave 440.0 0.5))

      (let ((gen (make-square-wave 440.0))
	    (v0 (make-vct 10)))
	(print-and-check gen 
			 "square_wave"
			 "square_wave freq: 440.000Hz, phase: 0.000, amp: 1.000"
			 "sw current_value: 1.000000, freq: 0.125379, phase: 0.000000, base: 1.000000")
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (square-wave gen 0.0)))
	(IF (not (square-wave? gen)) (snd-display ";~A not square-wave?" gen))
	(IF (fneq (mus-phase gen) 1.253787) (snd-display ";square-wave phase: ~F?" (mus-phase gen)))
	(IF (fneq (mus-frequency gen) 440.0) (snd-display ";square-wave frequency: ~F?" (mus-frequency gen)))
	(IF (fneq (mus-scaler gen) 1.0) (snd-display ";square-wave scaler: ~F?" (mus-scaler gen)))
	(IF (or (fneq (vct-ref v0 1) 1.0) (fneq (vct-ref v0 8) 1.0)) (snd-display ";square-wave output: ~A" v0)))

      (test-gen-equal (make-square-wave 440.0) (make-square-wave 440.0) (make-square-wave 120.0))
      (test-gen-equal (make-square-wave 440.0) (make-square-wave 440.0) (make-square-wave 440.0 1.0 1.0))
      (test-gen-equal (make-square-wave 440.0) (make-square-wave 440.0) (make-square-wave 440.0 0.5))

      (let ((gen (make-triangle-wave 440.0))
	    (gen1 (make-triangle-wave 440.0 1.0 pi))
	    (v0 (make-vct 10)))
	(print-and-check gen 
			 "triangle_wave"
			 "triangle_wave freq: 440.000Hz, phase: 0.000, amp: 1.000"
			 "sw current_value: 0.000000, freq: 0.125379, phase: 0.000000, base: 0.636620")
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (triangle-wave gen 0.0)))
	(IF (not (triangle-wave? gen)) (snd-display ";~A not triangle-wave?" gen))
	(IF (fneq (mus-phase gen) 1.253787) (snd-display ";triangle-wave phase: ~F?" (mus-phase gen)))
	(IF (fneq (mus-phase gen1) pi) (snd-display ";init triangle-wave phase: ~F?" (mus-phase gen1)))
	(IF (fneq (mus-frequency gen) 440.0) (snd-display ";triangle-wave frequency: ~F?" (mus-frequency gen)))
	(IF (fneq (mus-scaler gen) 1.0) (snd-display ";triangle-wave scaler: ~F?" (mus-scaler gen)))
	(IF (or (fneq (vct-ref v0 1) 0.080) (fneq (vct-ref v0 8) 0.639)) (snd-display ";triangle-wave output: ~A" v0)))

      (test-gen-equal (make-triangle-wave 440.0) (make-triangle-wave 440.0) (make-triangle-wave 120.0))
      (test-gen-equal (make-triangle-wave 440.0) (make-triangle-wave 440.0) (make-triangle-wave 440.0 1.0 1.0))
      (test-gen-equal (make-triangle-wave 440.0) (make-triangle-wave 440.0) (make-triangle-wave 440.0 0.5))

      (let ((gen (make-pulse-train 440.0))
	    (v0 (make-vct 10)))
	(print-and-check gen 
			 "pulse_train"
			 "pulse_train freq: 440.000Hz, phase: 6.283, amp: 1.000"
			 "sw current_value: 0.000000, freq: 0.125379, phase: 6.283185, base: 1.000000")
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (pulse-train gen 0.0)))
	(IF (not (pulse-train? gen)) (snd-display ";~A not pulse-train?" gen))
	(IF (fneq (mus-phase gen) 1.253787) (snd-display ";pulse-train phase: ~F?" (mus-phase gen)))
	(IF (fneq (mus-frequency gen) 440.0) (snd-display ";pulse-train frequency: ~F?" (mus-frequency gen)))
	(IF (fneq (mus-scaler gen) 1.0) (snd-display ";pulse-train scaler: ~F?" (mus-scaler gen)))
	(IF (or (fneq (vct-ref v0 0) 1.0) (fneq (vct-ref v0 8) 0.0)) (snd-display ";pulse-train output: ~A" v0)))

      (test-gen-equal (make-pulse-train 440.0) (make-pulse-train 440.0) (make-pulse-train 120.0))
      (test-gen-equal (make-pulse-train 440.0) (make-pulse-train 440.0) (make-pulse-train 440.0 1.0 1.0))
      (test-gen-equal (make-pulse-train 440.0) (make-pulse-train 440.0) (make-pulse-train 440.0 0.5))

      (let ((gen (make-ppolar .1 1200.0))
	    (v0 (make-vct 10)))
	(vct-set! v0 0 (two-pole gen 1.0))
	(do ((i 1 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (two-pole gen 0.0)))
	(IF (not (two-pole? gen)) (snd-display ";~A not ppolar?" gen))
	(IF (not (= (mus-order gen) 2)) (snd-display ";ppolar order: ~D?" (mus-order gen)))
	(IF (fneq (mus-a0 gen) 1.0) (snd-display ";ppolar a0: ~F?" (mus-a0 gen)))
	(IF (fneq (mus-b1 gen) -.188) (snd-display ";ppolar b1: ~F?" (mus-b1 gen)))
	(IF (fneq (mus-b2 gen) .01) (snd-display ";ppolar b2: ~F?" (mus-b2 gen)))
	(IF (or (fneq (vct-ref v0 0) 1.0) (fneq (vct-ref v0 1) .188)) (snd-display ";ppolar output: ~A" v0)))

      (test-gen-equal (let ((z1 (make-ppolar .1 600.0))) (two-pole z1 1.0) z1)
		      (let ((z2 (make-ppolar .1 600.0))) (two-pole z2 1.0) z2)
		      (let ((z3 (make-ppolar .1 1200.0))) (two-pole z3 1.0) z3))
      (test-gen-equal (let ((z1 (make-ppolar .1 600.0))) (two-pole z1 1.0) z1)
		      (let ((z2 (make-ppolar .1 600.0))) (two-pole z2 1.0) z2)
		      (let ((z3 (make-ppolar .2 1200.0))) (two-pole z3 1.0) z3))
      (test-gen-equal (let ((z1 (make-ppolar .1 600.0))) (two-pole z1 1.0) z1)
		      (let ((z2 (make-ppolar .1 600.0))) (two-pole z2 1.0) z2)
		      (let ((z3 (make-ppolar .1 600.0))) (two-pole z3 0.5) z3))

      (let ((gen (make-zpolar .1 1200.0))
	    (v0 (make-vct 10)))
	(vct-set! v0 0 (two-zero gen 1.0))
	(do ((i 1 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (two-zero gen 0.0)))
	(IF (not (two-zero? gen)) (snd-display ";~A not zpolar?" gen))
	(IF (not (= (mus-order gen) 2)) (snd-display ";zpolar order: ~D?" (mus-order gen)))
	(IF (fneq (mus-a0 gen) 1.0) (snd-display ";zpolar a0: ~F?" (mus-a0 gen)))
	(IF (fneq (mus-a1 gen) -.188) (snd-display ";zpolar a1: ~F?" (mus-a1 gen)))
	(IF (fneq (mus-a2 gen) .01) (snd-display ";zpolar a2: ~F?" (mus-a2 gen)))
	(IF (or (fneq (vct-ref v0 0) 1.0) (fneq (vct-ref v0 1) -.188)) (snd-display ";zpolar output: ~A" v0)))

      (test-gen-equal (let ((z1 (make-zpolar .1 600.0))) (two-zero z1 1.0) z1)
		      (let ((z2 (make-zpolar .1 600.0))) (two-zero z2 1.0) z2)
		      (let ((z3 (make-zpolar .1 1200.0))) (two-zero z3 1.0) z3))
      (test-gen-equal (let ((z1 (make-zpolar .1 600.0))) (two-zero z1 1.0) z1)
		      (let ((z2 (make-zpolar .1 600.0))) (two-zero z2 1.0) z2)
		      (let ((z3 (make-zpolar .2 1200.0))) (two-zero z3 1.0) z3))
      (test-gen-equal (let ((z1 (make-zpolar .1 600.0))) (two-zero z1 1.0) z1)
		      (let ((z2 (make-zpolar .1 600.0))) (two-zero z2 1.0) z2)
		      (let ((z3 (make-zpolar .1 600.0))) (two-zero z3 0.5) z3))

      (let ((gen (make-formant .9 1200.0 1.0))
	    (v0 (make-vct 10)))
	(print-and-check gen 
			 "formant"
			 "formant: radius: 0.900, frequency: 1200.000, (gain: 1.000)"
			 "smpflt a0: 0.063710, a1: 1.000000, a2: -0.900000, b1: -1.695789, b2: 0.810000, x1: 0.000000, x2: 0.000000, y1: 0.000000, y2: 0.000000")
	(vct-set! v0 0 (formant gen 1.0))
	(do ((i 1 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (formant gen 0.0)))
	(IF (not (formant? gen)) (snd-display ";~A not formant?" gen))
	(IF (not (= (mus-order gen) 2)) (snd-display ";formant order: ~D?" (mus-order gen)))
	(IF (fneq (mus-a0 gen) 0.06371) (snd-display ";formant a0: ~F?" (mus-a0 gen)))
	(IF (fneq (mus-a1 gen) 1.0) (snd-display ";formant a1: ~F?" (mus-a1 gen)))
	(IF (fneq (mus-a2 gen) -0.9) (snd-display ";formant a2: ~F?" (mus-a2 gen)))
	(IF (fneq (mus-b1 gen) -1.6957893) (snd-display ";formant b1: ~F?" (mus-b1 gen)))
	(IF (fneq (mus-b2 gen) 0.81) (snd-display ";formant b2: ~F?" (mus-b2 gen)))
	(IF (fneq (mus-formant-radius gen) .9) (snd-display ";formant radius: ~F?" (mus-formant-radius gen)))
	(IF (fneq (mus-frequency gen) 1200.0) (snd-display ";formant frequency: ~F?" (mus-frequency gen)))
	(IF (or (fneq (vct-ref v0 0) .064) (fneq (vct-ref v0 1) .108)) (snd-display ";formant output: ~A" v0))
	(set! (mus-a0 gen) .5) (IF (fneq (mus-a0 gen) 0.5) (snd-display ";formant set-a0: ~F?" (mus-a0 gen)))
	(set! (mus-a1 gen) .5) (IF (fneq (mus-a1 gen) 0.5) (snd-display ";formant set-a1: ~F?" (mus-a1 gen)))
	(set! (mus-a2 gen) .5) (IF (fneq (mus-a2 gen) 0.5) (snd-display ";formant set-a2: ~F?" (mus-a2 gen)))
	(set! (mus-b1 gen) .5) (IF (fneq (mus-b1 gen) 0.5) (snd-display ";formant set-b1: ~F?" (mus-b1 gen)))
	(set! (mus-b2 gen) .5) (IF (fneq (mus-b2 gen) 0.5) (snd-display ";formant set-b2: ~F?" (mus-b2 gen)))
	(set! (mus-formant-radius gen) .01) 
	(IF (fneq (mus-formant-radius gen) 0.01) (snd-display ";formant set-radius: ~F?" (mus-formant-radius gen))))

      (test-gen-equal (let ((f1 (make-formant .9 1200.0 1.0))) (formant f1 1.0) f1)
		      (let ((f2 (make-formant .9 1200.0 1.0))) (formant f2 1.0) f2)
		      (let ((f3 (make-formant .9 600.0 1.0))) (formant f3 1.0) f3))
      (test-gen-equal (let ((f1 (make-formant .9 1200.0 1.0))) (formant f1 1.0) f1)
		      (let ((f2 (make-formant .9 1200.0 1.0))) (formant f2 1.0) f2)
		      (let ((f3 (make-formant .99 1200.0 1.0))) (formant f3 1.0) f3))
      (test-gen-equal (let ((f1 (make-formant .9 1200.0 1.0))) (formant f1 1.0) f1)
		      (let ((f2 (make-formant .9 1200.0 1.0))) (formant f2 1.0) f2)
		      (let ((f3 (make-formant .9 1200.0 0.5))) (formant f3 1.0) f3))

      (let ((ob (open-sound "oboe.snd")))
	(define (poltergeist frek amp R gain frek-env R-env)
	  ;; test courtesy of Anders Vinjar
	  (let ((filt (make-formant R frek gain))
		(fe (make-env :envelope frek-env :end (frames) :offset frek))
		(re (make-env :envelope R-env :end (frames) :offset R)))
	    (lambda (y)
	      (let ((outval (formant filt (* amp y))))
		(mus-set-formant-radius-and-frequency filt (env re) (env fe))
		outval))))
	(map-chan (poltergeist 300 0.1 0.0 30.0 '(0 100 1 4000.0) '(0 0.99 1 .9)))  ;; should sound like "whyieee?"
	(play-and-wait 0 ob)
	(close-sound ob))

      (let ((gen (make-mixer 2 .5 .25 .125 1.0))
	    (fr0 (make-frame 2 1.0 1.0))
	    (fr1 (make-frame 2 0.0 0.0)))
	(print-and-check gen 
			 "mixer"
			 "mixer: chans: 2, vals: [(0.500 0.250) (0.125 1.000)]"
			 "mixer: chans: 2, vals: [(0.500 0.250) (0.125 1.000)]")
	(print-and-check fr0 
			 "frame"
			 "frame[2]: [1.000 1.000]"
			 "frame[2]: [1.000 1.000]")
	(IF (not (frame? fr0)) (snd-display ";~A not a frame?" fr0))
	(IF (not (mixer? gen)) (snd-display ";~A not a mixer?" gen))
	(IF (equal? fr0 fr1) (snd-display ";frame=? ~A ~A?" fr0 fr1))
	(IF (not (= (mus-channels fr0) 2)) (snd-display ";frame channels: ~D?" (mus-channels fr0)))
	(IF (not (= (mus-length fr1) 2)) (snd-display ";frame length: ~D?" (mus-length fr0)))
	(IF (not (= (mus-channels gen) 2)) (snd-display ";mixer channels: ~D?" (mus-channels gen)))
	(frame->frame gen fr0 fr1)
	(IF (or (fneq (frame-ref fr0 0) 1.0)
		(fneq (frame-ref fr1 1) 1.25)
		(fneq (mixer-ref gen 0 0) .5))
	    (snd-display ";fr0: ~A" fr0))
	(frame-set! fr1 0 1.0)
	(frame-set! fr1 1 1.0)
	(let ((fr3 (frame+ fr0 fr1))
	      (fr4 (frame* fr0 fr1))
	      (fr5 (sample->frame fr1 .5)))
	  (IF (or (fneq (frame-ref fr3 0) 2.0)
		  (fneq (frame-ref fr4 0) 1.0))
	      (snd-display ";fr+*: ~A ~A" fr3 fr4))
	  (IF (fneq (frame-ref fr5 0) .5) 
	      (snd-display ";sample->frame: ~A?" (frame-ref fr5 0))))
	(let ((fr3 (make-frame 2))
	      (fr4 (make-frame 4)))
	  (frame-set! fr3 0 1.0)
	  (frame-set! fr4 0 0.5)
	  (frame-set! fr4 2 1.0)
	  (IF (not (feql (frame->list (frame+ fr3 fr4)) (list 1.5 0.0)))
	      (snd-display ";frame+ unequal chans: ~A?" (frame+ fr3 fr4))))
	(let ((fr3 (make-frame 2))
	      (fr4 (make-frame 4)))
	  (frame-set! fr3 0 1.0)
	  (frame-set! fr4 0 0.5)
	  (frame-set! fr4 2 1.0)
	  (IF (not (feql (frame->list (frame* fr3 fr4)) (list 0.5 0.0)))
	      (snd-display ";frame* unequal chans: ~A?" (frame* fr3 fr4))))
	(let* ((mx1 (make-mixer 2 1.0 0.0 0.0 1.0))
	       (mx2 (mixer* gen mx1))
	       (fr4 (make-frame 2 1.0 1.0))
	       (fr5 (make-frame 2 1.0 1.0))
	       (val (frame->sample mx1 fr1)))
	  (IF (fneq val 1.0) (snd-display ";frame->sample: ~A?" val))
	  (IF (fneq (frame->sample fr5 fr4) 2.0) (snd-display ";frame->sample ~A" (frame->sample fr5 fr4)))
	  (IF (not (equal? (frame->list fr1) (list 1.0 1.0))) (snd-display ";frame->list: ~A?" (frame->list fr1)))
	  (IF (or (fneq (mixer-ref mx2 0 1) .25) (fneq (mixer-ref mx2 1 0) .125)) (snd-display ";mixer*: ~A?" mx2))
	  (IF (not (equal? mx2 gen)) (snd-display ";mixer=? ~A ~A?" gen mx2))
	  (IF (equal? mx2 mx1) (snd-display ";mixer/=? ~A ~A?" mx1 mx2))
	  (mixer-set! mx2 0 0 2.0)
	  (IF (fneq (mixer-ref mx2 0 0) 2.0) (snd-display ";mixer-set: ~A?" mx2))
	  (set! fr0 (sample->frame mx2 1.0))
	  (IF (or (fneq (frame-ref fr0 0) 2.0) (fneq (frame-ref fr0 1) .25)) (snd-display ";sample->frame: ~A?" fr0))
	  (let ((frout (make-frame 2)))
	    (sample->frame mx2 1.0 frout)
	    (IF (not (equal? frout fr0)) (snd-display ";sample->frame via frout: ~A ~A?" frout fr0)))))

      (let ((var (catch #t (lambda () (make-mixer 2 0.0 0.0 0.0 0.0 0.0)) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";make-mixer extra args: ~A" var)))
      (let ((var (catch #t (lambda () (let ((fr1 (make-frame 2 1.0 0.0))) (frame->sample (make-oscil) fr1))) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";frame->sample bad arg: ~A" var)))

      (let ((fr1 (make-frame 1 1))
	    (fr2 (make-frame 2 1 2))
	    (fr4 (make-frame 4 1 2 3 4)) 
	    (fr8 (make-frame 8 1 2 3 4 5 6 7 8))
	    (mx1 (make-mixer 1 5))
	    (mx1id (make-mixer 1 1))
	    (mx2 (make-mixer 2 1 2 3 4))
	    (mx2id (make-mixer 2 1 0 0 1))
	    (mx4 (make-mixer 4))
	    (mx4id (make-mixer 4))
	    (mx8 (make-mixer 8))
	    (mx8id (make-mixer 8)))
	(do ((i 0 (1+ i)))
	    ((= i 4))
	  (mixer-set! mx4id i i 1)
	  (mixer-set! mx4 0 i 1))
	(do ((i 0 (1+ i)))
	    ((= i 8))
	  (mixer-set! mx8id i i 1)
	  (mixer-set! mx8 i 0 1))
	(IF (not (equal? (frame->frame mx1id fr1) (make-frame 1 1))) (snd-display ";frame->frame 1 id: ~A?"            (frame->frame mx1id fr1)))
	(IF (not (equal? (frame->frame mx1 fr1) (make-frame 1 5))) (snd-display ";frame->frame 1: ~A?"                 (frame->frame mx1 fr1)))  
	(IF (not (equal? (frame->frame mx2id fr1) (make-frame 2 1 0))) (snd-display ";frame->frame 2 1 id: ~A?"        (frame->frame mx2id fr1)))  
	(IF (not (equal? (frame->frame mx2 fr1) (make-frame 2 1 2))) (snd-display ";frame->frame 2 1: ~A?"             (frame->frame mx2 fr1)))  
	(IF (not (equal? (frame->frame mx4 fr1) (make-frame 4 1 1 1 1))) (snd-display ";frame->frame 4 1: ~A?"         (frame->frame mx4 fr1)))  
	(IF (not (equal? (frame->frame mx8 fr1) (make-frame 8 1 0 0 0 0 0 0 0))) (snd-display ";frame->frame 8 1: ~A?" (frame->frame mx8 fr1))) 
	(IF (not (equal? (frame->frame mx1 fr2) (make-frame 1 5))) (snd-display ";frame->frame 1 2: ~A?"               (frame->frame mx1 fr2)))   
	(IF (not (equal? (frame->frame mx2id fr2) (make-frame 2 1 2))) (snd-display ";frame->frame 2id 2: ~A?"         (frame->frame mx2id fr2)))  
	(IF (not (equal? (frame->frame mx2 fr2) (make-frame 2 7 10))) (snd-display ";frame->frame 2 2: ~A?"            (frame->frame mx2 fr2)))  
	(IF (not (equal? (frame->frame mx4id fr2) (make-frame 4 1 2 0 0))) (snd-display ";frame->frame 4id 2: ~A?"     (frame->frame mx4id fr2)))  
	(IF (not (equal? (frame->frame mx8id fr2) (make-frame 8 1 2 0 0 0 0 0 0))) (snd-display ";frame->frame 8id 2: ~A?" (frame->frame mx8id fr2)))  
	(IF (not (equal? (frame->frame mx4 fr2) (make-frame 4 1 1 1 1))) (snd-display ";frame->frame 4 2: ~A?"         (frame->frame mx4 fr2)))  
	(IF (not (equal? (frame->frame mx8 fr2) (make-frame 8 3 0 0 0 0 0 0 0))) (snd-display ";frame->frame 8 2: ~A?" (frame->frame mx8 fr2))) 
	(IF (not (equal? (frame->frame mx1 fr4) (make-frame 1 5))) (snd-display ";frame->frame 1 4: ~A?"               (frame->frame mx1 fr4))) 
	(IF (not (equal? (frame->frame mx1 fr8) (make-frame 1 5))) (snd-display ";frame->frame 1 8: ~A?"               (frame->frame mx1 fr8))) 
	(IF (not (equal? (frame->frame mx8id fr2) (make-frame 8 1 2 0 0 0 0 0 0))) (snd-display ";frame->frame 8id 2: ~A?" (frame->frame mx8id fr2)))
	(IF (not (equal? (frame->frame mx4id fr2) (make-frame 4 1 2 0 0))) (snd-display ";frame->frame 4id 2: ~A?"     (frame->frame mx4id fr2)))  
	(IF (not (equal? (frame->frame mx8 fr4) (make-frame 8 10 0 0 0 0 0 0 0))) (snd-display ";frame->frame 8 4: ~A?" (frame->frame mx8 fr4))) 
	(IF (not (equal? (frame->frame mx4 fr4) (make-frame 4 1 1 1 1))) (snd-display ";frame->frame 4 4: ~A?"         (frame->frame mx4 fr4))))

      (for-each 
       (lambda (chans)
	 (let ((m1 (make-mixer chans)))
	   (IF (or (not (= (mus-channels m1) chans))
		   (not (= (mus-length m1) chans)))
	       (snd-display ";mixer ~A chans but: ~A ~A" chans (mus-channels m1) (mus-length m1)))
	   (do ((i 0 (1+ i)))
	       ((= i chans))
	     (do ((j 0 (1+ j)))
		 ((= j chans))
	       (mixer-set! m1 i j (+ (* i .01) (* j .1)))))
	   (do ((i 0 (1+ i)))
	       ((= i chans))
	     (do ((j 0 (1+ j)))
		 ((= j chans))
	       (IF (fneq (mixer-ref m1 i j) (+ (* i .01) (* j .1)))
		   (snd-display ";mixer[~A ~A] = ~A (~A)?" i j (mixer-ref m1 i j) (+ (* i .01) (* j .1))))))
	   (let ((mempty (make-mixer chans))
		 (midentity (make-mixer chans))
		 (mpick (make-mixer chans)))
	     (do ((i 0 (1+ i)))
		 ((= i chans))
	       (mixer-set! midentity i i 1.0))
	     (mixer-set! mpick (1- chans) (1- chans) 1.0)
	     (let ((mzero (mixer* m1 mempty))
		   (msame (mixer* m1 midentity))
		   (mone (mixer* m1 mpick)))
	       (do ((i 0 (1+ i)))
		   ((= i chans))
		 (do ((j 0 (1+ j)))
		     ((= j chans))
		   (IF (fneq (mixer-ref mzero i j) 0.0) (snd-display ";mzero ~A ~A = ~A?" i j (mixer-ref mzero i j)))
		   (IF (fneq (mixer-ref m1 i j) (mixer-ref msame i j)) (snd-display ";msame ~A ~A?" (mixer-ref msame i j) (mixer-ref m1 i j)))
		   (IF (and (fneq (mixer-ref mone i j) 0.0)
			    (not (= i (1- chans)))
			    (not (= j (1- chans))))
		       (snd-display ";mone ~A ~A = ~A?" i j (mixer-ref mone i j)))))))))
       (list 1 2 4 8))

      (let ((gen (make-fft-window hamming-window 16)))
	(IF (not (vequal gen (vct 0.080 0.115 0.215 0.364 0.540 0.716 0.865 1.000 1.000 0.865 0.716 0.540 0.364 0.215 0.115 0.080)))
	    (snd-display ";hamming window: ~A" gen)))
      (let ((gen (make-fft-window rectangular-window 16)))
	(IF (not (vequal gen (vct 1.000 1.000 1.000 1.000 1.000 1.000 1.000 1.000 1.000 1.000 1.000 1.000 1.000 1.000 1.000 1.000)))
	    (snd-display ";rectangular window: ~A" gen)))
      (let ((gen (make-fft-window hanning-window 16)))
	(IF (not (vequal gen (vct 0.000 0.038 0.146 0.309 0.500 0.691 0.854 1.000 1.000 0.854 0.691 0.500 0.309 0.146 0.038 0.000)))
	    (snd-display ";hanning window: ~A" gen)))
      (let ((gen (make-fft-window welch-window 16)))
	(IF (not (vequal gen (vct 0.000 0.234 0.438 0.609 0.750 0.859 0.938 1.000 1.000 0.938 0.859 0.750 0.609 0.438 0.234 0.000)))
	    (snd-display ";welch window: ~A" gen)))
      (let ((gen (make-fft-window parzen-window 16)))
	(IF (not (vequal gen (vct 0.000 0.125 0.250 0.375 0.500 0.625 0.750 1.000 1.000 0.750 0.625 0.500 0.375 0.250 0.125 0.000)))
	    (snd-display ";parzen window: ~A" gen)))
      (let ((gen (make-fft-window bartlett-window 16)))
	(IF (not (vequal gen (vct 0.000 0.125 0.250 0.375 0.500 0.625 0.750 1.000 1.000 0.750 0.625 0.500 0.375 0.250 0.125 0.000)))
	    (snd-display ";bartlett window: ~A" gen)))
      (let ((gen (make-fft-window blackman2-window 16)))
	(IF (not (vequal gen (vct 0.005 0.020 0.071 0.177 0.344 0.558 0.775 1.000 1.000 0.775 0.558 0.344 0.177 0.071 0.020 0.005)))
	    (snd-display ";blackman2 window: ~A" gen)))
      (let ((gen (make-fft-window blackman3-window 16)))
	(IF (not (vequal gen (vct 0.000 0.003 0.022 0.083 0.217 0.435 0.696 1.000 1.000 0.696 0.435 0.217 0.083 0.022 0.003 0.000)))
	    (snd-display ";blackman3 window: ~A" gen)))
      (let ((gen (make-fft-window blackman4-window 16)))
	(IF (not (vequal gen (vct 0.002 0.002 0.003 0.017 0.084 0.263 0.562 1.000 1.000 0.562 0.263 0.084 0.017 0.003 0.002 0.002)))
	    (snd-display ";blackman4 window: ~A" gen)))
      (let ((gen (make-fft-window exponential-window 16)))
	(IF (not (vequal gen (vct 0.000 0.087 0.181 0.283 0.394 0.515 0.646 0.944 0.944 0.646 0.515 0.394 0.283 0.181 0.087 0.000)))
	    (snd-display ";exponential window: ~A" gen)))
      (let ((gen (make-fft-window riemann-window 16)))
	(IF (not (vequal gen (vct 0.000 0.139 0.300 0.471 0.637 0.784 0.900 1.000 1.000 0.900 0.784 0.637 0.471 0.300 0.139 0.000)))
	    (snd-display ";riemann window: ~A" gen)))
      (let ((gen (make-fft-window kaiser-window 16 2.5)))
	(IF (not (vequal gen (vct 0.304 0.426 0.550 0.670 0.779 0.871 0.941 1.000 1.000 0.941 0.871 0.779 0.670 0.550 0.426 0.304)))
	    (snd-display ";kaiser window: ~A" gen)))
      (let ((gen (make-fft-window cauchy-window 16 2.5)))
	(IF (not (vequal gen (vct 0.138 0.173 0.221 0.291 0.390 0.532 0.719 1.000 1.000 0.719 0.532 0.390 0.291 0.221 0.173 0.138)))
	    (snd-display ";cauchy window: ~A" gen)))
      (let ((gen (make-fft-window poisson-window 16 2.5)))
	(IF (not (vequal gen (vct 0.082 0.112 0.153 0.210 0.287 0.392 0.535 1.000 1.000 0.535 0.392 0.287 0.210 0.153 0.112 0.082)))
	    (snd-display ";poisson window: ~A" gen)))
      (let ((gen (make-fft-window gaussian-window 16 1.0)))
	(IF (not (vequal gen (vct 0.607 0.682 0.755 0.823 0.882 0.932 0.969 1.000 1.000 0.969 0.932 0.882 0.823 0.755 0.682 0.607)))
	    (snd-display ";gaussian window: ~A" gen)))
      (let ((gen (make-fft-window tukey-window 16)))
	(IF (not (vequal gen (vct 0.000 0.038 0.146 0.309 0.500 0.691 0.854 1.000 1.000 0.854 0.691 0.500 0.309 0.146 0.038 0.000)))
	    (snd-display ";tukey window: ~A" gen)))
      (without-errors
       (let ((gen (make-fft-window dolph-chebyshev-window 16 1.0)))
	 (IF (not (vequal gen (vct 0.000 0.494 0.604 0.710 0.806 0.887 0.949 0.987 1.000 0.987 0.949 0.887 0.806 0.710 0.604 0.494)))
	     (snd-display ";dolph-chebyshev window: ~A" gen))))

      (let ((v0 (make-vct 10))
	    (gen (make-env '(0 0 1 1 2 0) :scaler 0.5 :end 9)))
	(print-and-check gen 
			 "env"
			 "env: linear, pass: 0 (dur: 10), index: 0, data: [0.000 0.000 1.000 1.000 2.000 0.000]"
			 "seg rate: 0.100000, current_value: 0.000000, base: 0.000000, offset: 0.000000, scaler: 0.500000, power: 0.000000, init_y: 0.000000, init_power: 0.000000, b1: 0.000000, pass: 0, end: 9, style: 0, index: 0, size: 3, original_data[6]: [0.000 0.000 1.000 1.000 2.000 0.000], rates[3]: [0.100 -0.100 0.000], passes[3]: [5 10 100000000]")
	(IF (not (env? gen)) (snd-display ";~A not env?" gen))
	(IF (fneq (mus-scaler gen) 0.5) (snd-display ";env scaler ~F?" (mus-scaler gen)))
	(IF (fneq (mus-increment gen) 1.0) (snd-display ";env base (1.0): ~A?" (mus-increment gen)))
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (env gen)))
	(IF (or (fneq (vct-ref v0 0) 0.0) (fneq (vct-ref v0 1) .1) (fneq (vct-ref v0 6) .4))
	    (snd-display ";~A output: ~A" gen v0))
	(IF (fneq (env-interp 1.5 gen) 0.25) (snd-display ";env-interp ~A at 1.5: ~F?" gen (env-interp 1.5 gen)))
	(set! gen (make-env :envelope '(0 1 1 0) :base 32.0 :end 9))
	(IF (fneq (mus-increment gen) 32.0) (snd-display ";env base (32.0): ~A?" (mus-increment gen)))
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (env gen)))
	(IF (or (fneq (vct-ref v0 0) 1.0) (fneq (vct-ref v0 1) .698) (fneq (vct-ref v0 8) .032))
	    (snd-display ";~A output: ~A" gen v0))
	(set! gen (make-env :envelope '(0 1 1 0) :base .0325 :end 9))
	(IF (fneq (mus-increment gen) .0325) (snd-display ";env base (.0325): ~A?" (mus-increment gen)))
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (env gen)))
	(IF (or (fneq (vct-ref v0 0) 1.0) (fneq (vct-ref v0 1) .986) (fneq (vct-ref v0 8) .513))
	    (snd-display ";~A output: ~A" gen v0))
	(set! gen (make-env :envelope '(0 1 1 .5 2 0) :base 0.0 :end 9 :offset 1.0))
	(IF (fneq (mus-increment gen) 0.0) (snd-display ";env base (0.0): ~A?" (mus-increment gen)))
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (IF (= i 3)
	      (IF (not (= (mus-location gen) 3))
		  (snd-display ";env location: ~A?" (mus-location gen))))
	  (vct-set! v0 i (env gen)))
	(IF (or (fneq (vct-ref v0 0) 2.0) (fneq (vct-ref v0 6) 1.5) (fneq (vct-ref v0 8) 1.5))
	    (snd-display ";~A output: ~A" gen v0))
	(IF (fneq (env-interp 1.5 gen) 1.5) (snd-display ";env-interp ~A at 1.5: ~F?" gen (env-interp 1.5 gen)))
	(set! (mus-location gen) 6)
	(IF (not (= (mus-location gen) 6)) (snd-display ";mus-set-location ~A (6)?" (mus-location gen)))
	(let ((val (env gen)))
	  (IF (fneq val 1.5) (snd-display ";mus-set-location 6 -> ~A (1.5)?" val)))
	(set! (mus-location gen) 0)
	(let ((val (env gen)))
	  (IF (fneq val 2.0) (snd-display ";mus-set-location 0 -> ~A (2.0)?" val)))

	(let ((e1 (make-env '(0 0 1 1) :base .03125 :end 9))
	      (e2 (make-env '(0 0 1 1 2 0) :base 32.0 :end 9))
	      (e3 (make-env '(0 0 .1 1 2 0) :base 1.1 :end 99)))
	  (do ((i 0 (1+ i)))
	      ((= i 10))
	    (let ((v1 (env-interp (* i .1) e1))
		  (v2 (env e1))
		  (v3 (env-interp (* i .2) e2))
		  (v4 (env e2)))
	      (IF (ffneq v1 v2) (snd-display ";env-interp[rmp ~F]: ~A (~A)?" (* .1 i) v1 v2))
	      (IF (ffneq v3 v4) (snd-display ";env-interp[pyr ~F]: ~A (~A)?" (* .2 i) v3 v4))))
	  (do ((i 0 (1+ i)))
	      ((= i 100))
	    (let ((v5 (env-interp (* i .02) e3))
		  (v6 (env e3)))
	      (IF (ffneq v5 v6) (snd-display ";env-interp[tri ~F]: ~A (~A)?" (* .02 i) v5 v6)))))
	
	(let ((e1 (make-env '(0 0 1 1 2 0) :end 9))
	      (v1 (make-vct 11))
	      (v2 (make-vct 11))
	      (v3 (make-vct 11)))
	  (do ((i 0 (1+ i))) ((= i 11)) (vct-set! v1 i (env e1)))
	  (do ((i 0 (1+ i))) ((= i 11)) (vct-set! v2 i (env e1)))
	  (restart-env e1)
	  (do ((i 0 (1+ i))) ((= i 11)) (vct-set! v3 i (env e1)))
	  (IF (not (vequal v1 v3)) (snd-display ";restart-env: ~A ~A?" v1 v3))
	  (IF (not (vequal v2 (make-vct 11))) (snd-display ";restart-env 1: ~A?" v2)))

	(set! gen (make-env '(0 0 1 1 2 0) :end 9))
	(do ((i 0 (1+ i))) ((= i 4)) (env gen))
	(let ((val (env gen)))
	  (IF (fneq val .8) (snd-display ";env(5): ~A?" val))
	  (restart-env gen)
	  (do ((i 0 (1+ i))) ((= i 4)) (env gen))
	  (set! val (env gen))
	  (IF (fneq val .8) (snd-display ";restart-env: ~A?" val))
	  (set! (mus-location gen) 6)
	  (let ((val (env gen)))
	    (IF (fneq val 0.8) (snd-display ";mus-set-location 6 -> ~A (0.8)?" val)))))
 
      (let ((gen (make-env '(0 0 1 1) :base .032 :end 10)))
	(set! (mus-location gen) 5)
	(let ((val (env gen)))
	  (IF (fneq val 0.817)
	      (snd-display "set env location with base: ~A ~A" val gen))))

      (test-gen-equal (make-env '(0 0 1 1 2 0) :scaler 0.5 :end 9) (make-env '(0 0 1 1 2 0) :scaler 0.5 :end 9) (make-env '(0 0 1 1 2 0) :scaler 0.25 :end 9))
      (test-gen-equal (make-env '(0 0 1 1 2 0) :scaler 0.5 :end 9) (make-env '(0 0 1 1 2 0) :scaler 0.5 :end 9) (make-env '(0 0 1 1 2 0) :scaler 0.5 :end 10))
      (test-gen-equal (make-env '(0 0 1 1 2 0) :scaler 0.5 :end 9) (make-env '(0 0 1 1 2 0) :scaler 0.5 :end 9) (make-env '(0 0 1 1 3 0) :scaler 0.5 :end 9))

      (let ((var (catch #t (lambda () (make-env :envelope '())) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";make-env null env: ~A" var)))
      (let ((var (catch #t (lambda () (make-env :end 0)) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";make-env no env: ~A" var)))
      (let ((var (catch #t (lambda () (make-env :envelope '(0 0) :end -1)) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";make-env bad end: ~A" var)))
      (let ((var (catch #t (lambda () (make-env :envelope '(0 0) :start -1)) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";make-env bad start: ~A" var)))
      (let ((var (catch #t (lambda () (make-env :envelope '(0 0) :duration -1.0)) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";make-env bad duration: ~A" var)))
      (let ((var (catch #t (lambda () (make-env :envelope '(0 0) :base -1.0)) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";make-env bad base: ~A" var)))

      (let ((gen (make-table-lookup 440.0 :wave (partials->wave '(1 1 2 1))))
	    (gen1 (make-table-lookup 440.0 :wave (partials->wave '(1 1 2 1))))
	    (gen2 (partials->wave '(1 1 2 1 3 1 4 1) #f #t))
	    (gen3 (make-table-lookup))
	    (v0 (make-vct 10))
	    (v1 (make-vct 10)))
	(print-and-check gen 
			 "table_lookup"
			 "table_lookup: freq: 440.000Hz, phase: 0.000, length: 512"
			 (mus-inspect gen))
	;; problem with mus-inspect here is that it includes the table pointer itself
	(IF (not (= (mus-length gen) 512)) (snd-display ";table-lookup length: ~A?" (mus-length gen)))
	(IF (not (= (mus-length gen3) 512)) (snd-display ";default table-lookup length: ~A?" (mus-length gen3)))
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (table-lookup gen 0.0))
	  (vct-set! v1 i (mus-apply gen1 0.0)))
	(IF (not (table-lookup? gen)) (snd-display ";~A not table-lookup?" gen))
	(IF (fneq (mus-phase gen) 1.253787) (snd-display ";table-lookup phase: ~F?" (mus-phase gen)))
	(IF (fneq (mus-frequency gen) 440.0) (snd-display ";table-lookup frequency: ~F?" (mus-frequency gen)))
	(IF (or (fneq (vct-ref v0 1) 0.373) (fneq (vct-ref v0 8) 1.75)) (snd-display ";table-lookup output: ~A" v0))
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (IF (fneq (vct-ref v0 i) (vct-ref v1 i))
	      (snd-display ";mus-apply table-lookup at ~D: ~A ~A?" i (vct-ref v0 i) (vct-ref v1 i))))
	(set! gen (make-table-lookup 440.0 :wave (phase-partials->wave (list 1 1 0 2 1 (* pi .5)))))
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (table-lookup gen 0.0)))
	(IF (or (fneq (vct-ref v0 1) 1.094) (fneq (vct-ref v0 8) .421)) (snd-display ";table-lookup phase output: ~A" v0))
	(IF (or (fneq (vct-peak (partials->wave '(1 1 2 1))) 1.76035475730896)
		(fneq (vct-peak (partials->wave '(1 1 2 1) #f #t)) 1.0)
		(fneq (vct-peak (partials->wave '(1 1 2 1 3 1 4 1) #f #t)) 1.0))
	    (snd-display ";normalized partials?"))
	(set! (mus-data gen) (phase-partials->wave (list 1 1 0 2 1 (* pi .5)) #f #t)))

      (test-gen-equal (make-table-lookup 440.0 :wave (partials->wave '(1 1 2 1)))
		      (make-table-lookup 440.0 :wave (partials->wave '(1 1 2 1)))
		      (make-table-lookup 100.0 :wave (partials->wave '(1 1 2 1))))
      (test-gen-equal (make-table-lookup 440.0 :wave (partials->wave '(1 1 2 1)))
		      (make-table-lookup 440.0 :wave (partials->wave '(1 1 2 1)))
		      (make-table-lookup 440.0 :wave (partials->wave '(1 1 2 .5))))

      (let ((gen0 (make-waveshape 440.0 :wave (partials->waveshape '(1 1))))
	    (gen (make-waveshape 440.0 :size 512 :partials '(1 1)))
	    (v0 (make-vct 10)))
	(print-and-check gen 
			 "waveshape"
			 "waveshape freq: 440.000Hz, phase: 0.000, size: 512"
			 "ws freq: 0.125379, phase: 0.000000, offset: 256.000000, table[512 (external)]: [-1.000 -0.996 -0.992 -0.988 -0.984 -0.980 -0.977 -0.973...]")
	(IF (not (= (mus-length gen) 512)) (snd-display ";waveshape length: ~A?" (mus-length gen)))
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (let ((val0 (waveshape gen0 1.0 0.0))
		(val (waveshape gen 1.0 0.0)))
	    (IF (fneq val val0) (snd-display ";waveshape: ~A /= ~F?" val val0))
	    (vct-set! v0 i val)))
	(IF (not (waveshape? gen)) (snd-display ";~A not waveshape?" gen))
	(IF (fneq (mus-phase gen) 1.253787) (snd-display ";waveshape phase: ~F?" (mus-phase gen)))
	(IF (fneq (mus-frequency gen) 440.0) (snd-display ";waveshape frequency: ~F?" (mus-frequency gen)))
	(IF (or (fneq (vct-ref v0 1) 0.125) (fneq (vct-ref v0 8) .843)) (snd-display ";waveshape output: ~A" v0))
	(set! (mus-data gen0) (make-vct 512)))

      (test-gen-equal (make-waveshape 440.0 :partials '(1 1)) (make-waveshape 440.0 :partials '(1 1)) (make-waveshape 100.0 :partials '(1 1)))
      (test-gen-equal (make-waveshape 440.0 :partials '(1 1)) (make-waveshape 440.0 :partials '(1 1)) (make-waveshape 4400.0 :partials '(1 1 2 .5)))

      (let ((var (catch #t (lambda () (make-waveshape 440.0 :partials '(1 1) :size #f)) (lambda args args))))
	(IF (not (eq? (car var) 'wrong-type-arg))
	    (snd-display ";make-waveshape bad size: ~A" var)))
      (let ((var (catch #t (lambda () (make-waveshape 440.0 :wave 3.14)) (lambda args args))))
	(IF (not (eq? (car var) 'wrong-type-arg))
	    (snd-display ";make-waveshape bad wave: ~A" var)))
      (let ((var (catch #t (lambda () (make-waveshape 440.0 :size 0)) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";make-waveshape bad size -1: ~A" var)))

      (let ((gen (make-wave-train 440.0 0.0 (make-vct 20)))
	    (v0 (make-vct 10)))
	(print-and-check gen 
			 "wave_train"
			 "wave_train freq: 440.000Hz, phase: 0.000, size: 20"
			 "wt freq: 440.000000, phase: 0.000000, wave[20 (external)]: [0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000...], b: rblk buf[20 (local)]: [0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000...], loc: 0, fill_time: 0.000000, empty: 1")
	(do ((i 0 (1+ i)))
	    ((= i 20))
	  (vct-set! (mus-data gen) i (* i .5)))
	(IF (not (= (vct-length (mus-data gen)) 20)) (snd-display ";wave-train data length: ~A?" (vct-length (mus-data gen))))
	(IF (not (= (mus-length gen) 20)) (snd-display ";wave-train length: ~A?" (mus-length gen)))
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (wave-train gen 0.0)))
	(IF (not (wave-train? gen)) (snd-display ";~A not wave-train?" gen))
	(IF (fneq (mus-phase gen) 0.0) (snd-display ";wave-train phase: ~F?" (mus-phase gen)))
	(IF (fneq (mus-frequency gen) 440.0) (snd-display ";wave-train frequency: ~F?" (mus-frequency gen)))
	(IF (or (fneq (vct-ref v0 1) 0.5) (fneq (vct-ref v0 8) 4.0)) (snd-display ";wave-train output: ~A" v0))
	(set! (mus-data gen) (make-vct 3)))

      (test-gen-equal (make-wave-train 440.0 0.0 (make-vct 20)) (make-wave-train 440.0 0.0 (make-vct 20)) (make-wave-train 100.0 0.0 (make-vct 20)))
      (test-gen-equal (make-wave-train 440.0 0.0 (make-vct 20)) (make-wave-train 440.0 0.0 (make-vct 20)) (make-wave-train 440.0 1.0 (make-vct 20)))

      (let ((gen (make-readin "oboe.snd" 0 1490))
	    (v0 (make-vct 10)))
	(print-and-check gen 
			 "readin"
			 "readin: oboe.snd[chan 0], loc: 1490, dir: 1"
			 "rdin chan: 0, dir: 1, loc: 1490, chans: 1, data_start: 0, data_end: -1, file_end: 50828, file_name: oboe.snd")
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (readin gen)))
	(IF (not (readin? gen)) (snd-display ";~A not readin?" gen))
	(IF (not (mus-input? gen)) (snd-display ";~A not input?" gen))
	(IF (not (= (mus-channel gen) 0)) (snd-display ";readin chan: ~A?" (mus-channel gen)))
	(IF (or (fneq (vct-ref v0 1) -0.009) (fneq (vct-ref v0 7) .029)) (snd-display ";readin output: ~A" v0))
	(set! (mus-location gen) 1000)
	(IF (not (= (mus-location gen) 1000)) (snd-display ";mus-set-location: ~A?" (mus-location gen)))
	(let ((val (readin gen)))
	  (IF (fneq val 0.033) (snd-display ";mus-set-location readin: ~A?" val))))

      (test-gen-equal (make-readin "oboe.snd" 0) (make-readin "oboe.snd" 0) (make-readin "oboe.snd" 0 1230))
      (test-gen-equal (make-readin "oboe.snd" 0) (make-readin "oboe.snd" 0) (make-readin "pistol.snd" 0))
      (test-gen-equal (make-readin "2.snd" 1) (make-readin "2.snd" 1) (make-readin "2.snd" 0))

      (let ((gen (make-readin "2.snd" 1))
	    (v0 (make-vct 10)))
	(print-and-check gen 
			 "readin"
			 "readin: 2.snd[chan 1], loc: 0, dir: 1"
			 "rdin chan: 1, dir: 1, loc: 0, chans: 2, data_start: 0, data_end: -1, file_end: 22051, file_name: 2.snd")
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (readin gen)))
	(IF (not (= (mus-channel gen) 1)) (snd-display ";readin chan 1: ~A?" (mus-channel gen)))
	(IF (or (fneq (vct-ref v0 1) 0.010) (fneq (vct-ref v0 7) -.006)) (snd-display ";readin 1 output: ~A" v0))
	(print-and-check gen 
			 "readin"
			 "readin: 2.snd[chan 1], loc: 10, dir: 1"
			 "rdin chan: 1, dir: 1, loc: 10, chans: 2, data_start: 0, data_end: 8191, file_end: 22051, file_name: 2.snd"))

      (let ((gen (make-file->sample "oboe.snd"))
	    (v0 (make-vct 10)))
	(print-and-check gen 
			 "file2sample"
			 "file2sample: oboe.snd"
			 "rdin chan: 0, dir: 0, loc: 0, chans: 1, data_start: 0, data_end: -1, file_end: 50828, file_name: oboe.snd")
	(IF (not (mus-input? gen)) (snd-display ";~A not input?" gen))
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (file->sample gen (+ 1490 i))))
	(IF (not (file->sample? gen)) (snd-display ";~A not file->sample?" gen))
	(IF (or (fneq (vct-ref v0 1) -0.009) (fneq (vct-ref v0 7) .029)) (snd-display ";file->sample output: ~A" v0)))

      (let ((gen (make-file->frame "oboe.snd"))
	    (v0 (make-vct 10)))
	(print-and-check gen 
			 "file2frame"
			 "file2frame: oboe.snd"
			 "rdin chan: 0, dir: 0, loc: 0, chans: 1, data_start: 0, data_end: -1, file_end: 50828, file_name: oboe.snd")
	(IF (not (mus-input? gen)) (snd-display ";~A not input?" gen))
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (frame-ref (file->frame gen (+ 1490 i)) 0)))
	(IF (not (file->frame? gen)) (snd-display ";~A not file->frame?" gen))
	(IF (or (fneq (vct-ref v0 1) -0.009) (fneq (vct-ref v0 7) .029)) (snd-display ";file->frame output: ~A" v0)))

      (if (file-exists? "fmv.snd") (delete-file "fmv.snd"))
      (if (file-exists? "fmv1.snd") (delete-file "fmv1.snd"))
      (if (file-exists? "fmv2.snd") (delete-file "fmv2.snd"))
      (if (file-exists? "fmv3.snd") (delete-file "fmv3.snd"))
      (let ((gen (make-sample->file "fmv.snd" 2 mus-lshort mus-riff)))
	(print-and-check gen 
			 "sample2file"
			 "sample2file: fmv.snd"
			 "rdout chan: 0, loc: 0, file_name: fmv.snd, chans: 2, data_start: 0, data_end: 8191, out_end: 0")
	(IF (not (mus-output? gen)) (snd-display ";~A not output?" gen))
	(IF (not (sample->file? gen)) (snd-display ";~A not sample->file?" gen))
	(do ((i 0 (1+ i)))
	    ((= i 100))
	  (sample->file gen i 0 (* i .001))
	  (sample->file gen i 1 (* i .01)))
	(outa 50 .015 gen)
	(outb 50 .15 gen)
	(out-any 60 .015 0 gen)
	(out-any 60 .15 1 gen)
	(mus-close gen))
      (let* ((gen (make-file->sample "fmv.snd"))
	     (val0 (in-any 20 0 gen))
	     (val1 (in-any 20 1 gen))
	     (val2 (ina 30 gen))
	     (val3 (inb 30 gen))
	     (val4 (file->sample gen 40 0))
	     (val5 (file->sample gen 40 1))
	     (val6 (in-any 50 0 gen))
	     (val7 (in-any 50 1 gen))
	     (val8 (in-any 60 0 gen))
	     (val9 (in-any 60 1 gen)))
	(print-and-check gen 
			 "file2sample"
			 "file2sample: fmv.snd"
			 "rdin chan: 0, dir: 0, loc: 0, chans: 2, data_start: 20, data_end: 100, file_end: 100, file_name: fmv.snd")
	(IF (not (= (mus-channels gen) 2)) (snd-display ";make-sample->file chans: ~A?" (mus-channels gen)))
	(IF (not (mus-input? gen)) (snd-display ";~A not input?" gen))
	(IF (or (fneq val0 .02) (fneq val1 .2)) (snd-display ";in-any: ~A ~A?" val0 val1))
	(IF (or (fneq val2 .03) (fneq val3 .3)) (snd-display ";inab: ~A ~A?" val2 val3))
	(IF (or (fneq val4 .04) (fneq val5 .4)) (snd-display ";sample->file: ~A ~A?" val4 val5))
	(IF (or (fneq val6 .065) (fneq val7 .65)) (snd-display ";outab: ~A ~A?" val6 val7))
	(IF (or (fneq val8 .075) (fneq val9 .75)) (snd-display ";out-any: ~A ~A?" val8 val9)))

      (let ((gen (make-sample->file "fmv.snd" 4 mus-lshort mus-riff)))
	(print-and-check gen 
			 "sample2file"
			 "sample2file: fmv.snd"
			 "rdout chan: 0, loc: 0, file_name: fmv.snd, chans: 4, data_start: 0, data_end: 8191, out_end: 0")
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (outa i .1 gen)
	  (outb i .2 gen)
	  (outc i .3 gen)
	  (outd i .4 gen))
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (outa i .01 gen)
	  (outb i .02 gen)
	  (outc i .03 gen)
	  (outd i .04 gen))
	(mus-close gen))
      (let* ((gen (make-file->sample "fmv.snd")))
	(print-and-check gen 
			 "file2sample"
			 "file2sample: fmv.snd"
			 "rdin chan: 0, dir: 0, loc: 0, chans: 4, data_start: 0, data_end: -1, file_end: 10, file_name: fmv.snd")
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (IF (or (fneq (ina i gen) .11)
		  (fneq (inb i gen) .22)
		  (fneq (in-any i 2 gen) .33)
		  (fneq (in-any i 3 gen) .44))
	      (snd-display ";4-chan out/in[~A]: ~A ~A ~A ~A?" i (ina i gen) (inb i gen) (in-any i 2 gen) (in-any i 3 gen)))))

      (let ((var (catch #t (lambda () (make-sample->file "fmv.snd" -1 mus-lshort mus-next)) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";make-sample->file bad chans: ~A" var)))
      (let ((var (catch #t (lambda () (mus-location (make-oscil))) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";mus-location oscil: ~A" var)))
      (let ((var (catch #t (lambda () (make-sample->file "fmv.snd" 1 -1 mus-next)) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";make-sample->file bad format: ~A" var)))
      (let ((var (catch #t (lambda () (make-sample->file "fmv.snd" 1 mus-lshort -1)) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";make-sample->file bad type: ~A" var)))

      (let ((gen (make-frame->file "fmv1.snd" 2 mus-bshort mus-next)))
	(print-and-check gen 
			 "frame2file"
			 "frame2file: fmv1.snd"
			 "rdout chan: 0, loc: 0, file_name: fmv1.snd, chans: 2, data_start: 0, data_end: 8191, out_end: 0")
	(IF (not (mus-output? gen)) (snd-display ";~A not output?" gen))
	(IF (not (frame->file? gen)) (snd-display ";~A not frame->file?" gen))
	(let ((fr0 (make-frame 2 0.0 0.0)))
	  (do ((i 0 (1+ i)))
	      ((= i 100))
	    (frame-set! fr0 0 (* i .001))
	    (frame-set! fr0 1 (* i .01))
	    (frame->file gen i fr0)))
	(mus-close gen))
      (let* ((gen (make-file->frame "fmv1.snd"))
	     (val4 (file->frame gen 40))
	     (frout (make-frame 2)))
	(IF (or (fneq (frame-ref val4 0) .04) (fneq (frame-ref val4 1) .4))
	    (snd-display ";frame->file output: ~A?" val4))
	(file->frame gen 40 frout)
	(IF (not (equal? frout val4))
	    (snd-display ";frame->file output via frame: ~A ~A?" frout val4)))

      (let ((gen (make-sample->file "fmv2.snd" 4 mus-bshort mus-aifc)))
	(print-and-check gen 
			 "sample2file"
			 "sample2file: fmv2.snd"
			 "rdout chan: 0, loc: 0, file_name: fmv2.snd, chans: 4, data_start: 0, data_end: 8191, out_end: 0")
	(IF (not (mus-output? gen)) (snd-display ";~A not output?" gen))
	(IF (not (sample->file? gen)) (snd-display ";~A not sample->file?" gen))
	(do ((i 0 (1+ i)))
	    ((= i 100))
	  (sample->file gen i 0 (* i .001))
	  (sample->file gen i 1 (* i .01))
	  (sample->file gen i 2 (* i .002))
	  (sample->file gen i 3 (* i .003)))
	(outa 50 .015 gen)
	(outb 50 .15 gen)
	(outc 50 .02 gen)
	(outd 50 .03 gen)
	(out-any 60 .015 0 gen)
	(out-any 60 .15 1 gen)
	(out-any 60 .02 2 gen)
	(out-any 60 .03 3 gen)
	(mus-close gen))
      (let* ((gen (make-file->sample "fmv2.snd"))
	     (val0 (in-any 20 2 gen))
	     (val1 (in-any 20 3 gen))
	     (val2 (file->sample gen 50 2))
	     (val3 (file->sample gen 50 3))
	     (val4 (file->sample gen 60 2))
	     (val5 (file->sample gen 60 3)))
	(IF (not (= (mus-channels gen) 4)) (snd-display ";make-sample->file (4) chans: ~A?" (mus-channels gen)))
	(IF (or (fneq val0 .04) (fneq val1 .06)) (snd-display ";in-any(4): ~A ~A?" val0 val1))
	(IF (or (fneq val2 .12) (fneq val3 .18)) (snd-display ";sample->file(4): ~A ~A?" val2 val3))
	(IF (or (fneq val4 .14) (fneq val5 .21)) (snd-display ";out-any(4): ~A ~A?" val4 val5)))

      (let ((v0 (make-vct 1000))
	    (os (make-oscil 440.0)))
	(do ((i 0 (1+ i)))
	    ((= i 1000))
	  (vct-set! v0 i (* .1 (oscil os))))
	(array->file "fmv3.snd" v0 1000 22050 1)
	(let ((v1 (make-vct 1000)))
	  (file->array "fmv3.snd" 0 0 1000 v1)
	  (do ((i 0 (1+ i)))
	      ((= i 1000))
	    (if (fneq (vct-ref v0 i) (vct-ref v1 i)) 
		(snd-display ";array->file->array: ~A ~A ~A?" i (vct-ref v0 i) (vct-ref v1 i)))))

	(let ((var (catch #t (lambda () (array->file "fmv3.snd" v0 -1 1000 1)) (lambda args args))))
	  (IF (not (eq? (car var) 'mus-error))
	      (snd-display ";array->file bad samps: ~A" var)))
	(let ((var (catch #t (lambda () (file->array "fmv3.snd" -1 0 -1 v0)) (lambda args args))))
	  (IF (not (eq? (car var) 'mus-error))
	      (snd-display ";file->array bad samps: ~A" var))))

      (let ((gen (make-rand 10000.0))
	    (v0 (make-vct 10)))
	(print-and-check gen 
			 "rand"
			 "rand freq: 10000.000Hz, phase: 0.000, amp: 1.000"
			 "noi freq: 2.849517, phase: 0.000000, base: 1.000000, output: 0.000000, incr: 0.000000")
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (rand gen 0.0)))
	(IF (not (rand? gen)) (snd-display ";~A not rand?" gen))
	(IF (fneq (mus-phase gen) 3.3624296) (snd-display ";rand phase: ~F?" (mus-phase gen)))
	(IF (fneq (mus-frequency gen) 10000.0) (snd-display ";rand frequency: ~F?" (mus-frequency gen)))
	(IF (= (vct-ref v0 1) (vct-ref v0 8)) (snd-display ";rand output: ~A" v0)))

      (test-gen-equal (make-rand 1000) (make-rand 1000) (make-rand 500))
      (test-gen-equal (make-rand 1000) (make-rand 1000) (make-rand 1000 0.5))

      (let ((gen (make-rand-interp 4000.0))
	    (v0 (make-vct 10)))
	(print-and-check gen 
			 "rand_interp"
			 (mus-describe gen)
			 (mus-inspect gen)) ; problem here is the random incr field
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (rand-interp gen 0.0)))
	(IF (not (rand-interp? gen)) (snd-display ";~A not rand-interp?" gen))
	(IF (fneq (mus-phase gen) 5.114882) (snd-display ";rand-interp phase: ~F?" (mus-phase gen)))
	(IF (fneq (mus-frequency gen) 4000.0) (snd-display ";rand-interp frequency: ~F?" (mus-frequency gen)))
	(IF (= (vct-ref v0 1) (vct-ref v0 8)) (snd-display ";rand-interp output: ~A" v0)))

      (let* ((gen (make-locsig 30.0 :channels 2))
	     (gen1 (make-locsig 60.0 :channels 2))
	     (gen2 (make-locsig 60.0 :channels 4))
	     (gen200 (make-locsig 200.0 :channels 4))
	     (gen3 gen1)
	     (fr0 (locsig gen 0 1.0)))
	(print-and-check gen 
			 "locsig"
			 "locsig: chans 2, outn: [0.667 0.333]"
			 "locs outn[2]: [0.667 0.333], revn[0]: nil")
	(IF (not (locsig? gen)) (snd-display ";~A not locsig?" gen))
	(IF (not (eq? gen1 gen3)) (snd-display ";locsig eq? ~A ~A" gen1 gen3))
	(IF (not (equal? gen1 gen3)) (snd-display ";locsig equal? ~A ~A" gen1 gen3))
	(IF (eq? gen1 gen2) (snd-display ";locsig 1 eq? ~A ~A" gen1 gen2))
	(IF (equal? gen gen1) (snd-display ";locsig 2 equal? ~A ~A" gen gen1))
	(IF (equal? gen gen2) (snd-display ";locsig 3 equal? ~A ~A" gen gen2))
	(IF (or (fneq (frame-ref fr0 0) .667) (fneq (frame-ref fr0 1) .333)) (snd-display ";locsig output: ~A" fr0))
	(IF (or (fneq (locsig-ref gen 0) .667) (fneq (locsig-ref gen 1) .333))
	    (snd-display ";locsig ref: ~F ~F?" (locsig-ref gen 0) (locsig-ref gen 1)))
	(locsig-set! gen 0 .5)
	(set! fr0 (locsig gen 0 1.0))
	(IF (fneq (frame-ref fr0 0) .5) (snd-display ";locsig-set: ~F?" (frame-ref fr0 0)))
	(set! gen (make-locsig 120.0 2.0 .1 :channels 4))
	(set! fr0 (locsig gen 0 1.0))
	(IF (or (fneq (frame-ref fr0 1) .333) (fneq (frame-ref fr0 2) .167)) (snd-display ";locsig quad output: ~A" fr0))
	(set! gen (make-locsig 300.0 2.0 .1 :channels 4))
	(set! fr0 (locsig gen 0 1.0))
	(IF (or (fneq (frame-ref fr0 3) .333) (fneq (frame-ref fr0 0) .167)) (snd-display ";300 locsig quad output: ~A" fr0)))

      (for-each 
       (lambda (chans)
	 (let ((m1 (make-locsig :channels chans)))
	   (IF (or (not (= (mus-channels m1) chans))
		   (not (= (mus-length m1) chans)))
	       (snd-display ";locsig ~A chans but: ~A ~A" chans (mus-channels m1) (mus-length m1)))
	   (do ((i 0 (1+ i)))
	       ((= i chans))
	     (locsig-set! m1 i (* i .1)))
	   (do ((i 0 (1+ i)))
	       ((= i chans))
	     (IF (fneq (locsig-ref m1 i) (* i .1))
		 (snd-display ";locsig[~A] = ~A (~A)?" i (locsig-ref m1 i) (* i .1))))))
       (list 1 2 4 8))

      (let ((var (catch #t (lambda () (make-locsig :output 1)) (lambda args args))))
	(IF (not (eq? (car var) 'wrong-type-arg))
	    (snd-display ";make-locsig bad output: ~A" var)))
      (let ((var (catch #t (lambda () (locsig-ref (make-locsig) 1)) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";locsig-ref bad chan: ~A" var)))
      (let ((var (catch #t (lambda () (make-locsig :revout 1)) (lambda args args))))
	(IF (not (eq? (car var) 'wrong-type-arg))
	    (snd-display ";make-locsig bad revout: ~A" var)))
      (let ((var (catch #t (lambda () (let ((locs (make-locsig 200 :channels 2))) (locsig-ref locs -1))) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";locsig-ref bad chan: ~A" var)))
      (let ((var (catch #t (lambda () (let ((locs (make-locsig))) (locsig-set! locs 2 .1))) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";locsig-set! bad chan (2): ~A" var)))
      (let ((var (catch #t (lambda () (let ((locs (make-locsig :reverb .1))) (locsig-reverb-ref locs 2))) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";locsig-reverb-ref bad reverb chan (2): ~A" var)))
      (let ((var (catch #t (lambda () (let ((locs (make-locsig :reverb .1))) (locsig-reverb-set! locs 2 .1))) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";locsig-reverb-set! bad reverb chan (2): ~A" var)))

      (if (file-exists? "fmv4.snd") (delete-file "fmv4.snd"))
      (if (file-exists? "fmv4.reverb") (delete-file "fmv4.reverb"))
      (let* ((gen (make-frame->file "fmv4.snd" 2 mus-bshort mus-next))
	     (rev (make-frame->file "fmv4.reverb" 1 mus-bshort mus-next))
	     (lc (make-locsig 60.0 :reverb .1 :channels 2 :output gen :revout rev)))
	(do ((i 0 (1+ i)))
	    ((= i 100))
	  (locsig lc i 1.0))
	(IF (fneq (locsig-reverb-ref lc 0) .1) (snd-display ";locsig reverb ref: ~A?" (locsig-reverb-ref lc 0)))
	(locsig-reverb-set! lc 0 .2)
	(IF (fneq (locsig-reverb-ref lc 0) .2) (snd-display ";locsig reverb set: ~A?" (locsig-reverb-ref lc 0)))
	(mus-close gen)
	(mus-close rev)
	(let ((v0 (make-vct 100))
	      (v1 (make-vct 100))
	      (v2 (make-vct 100)))
	  (file->array "fmv4.snd" 0 0 100 v0)
	  (file->array "fmv4.snd" 1 0 100 v1)
	  (file->array "fmv4.reverb" 0 0 100 v2)
	  (IF (fneq (vct-ref v2 0) .1) (snd-display ";locsig reverb: ~A?" v2))
	  (IF (fneq (* 2 (vct-ref v0 0)) (vct-ref v1 0)) (snd-display ";locsig direct: ~A ~A?" (vct-ref v0 0) (vct-ref v1 0)))))

      (let* ((gen (make-frame->file "fmv4.snd" 4 mus-bshort mus-next))
	     (rev (make-frame->file "fmv4.reverb" 4 mus-bshort mus-next))
	     (lc (make-locsig 60.0 :reverb .1 :channels 4 :distance 4.0 :output gen :revout rev)))
	(print-and-check lc
			 "locsig"
			 "locsig: chans 4, outn: [0.083 0.167 0.000 0.000]"
			 "locs outn[4]: [0.083 0.167 0.000 0.000], revn[4]: [0.050 0.050 0.050 0.050]")
	(do ((i 0 (1+ i)))
	    ((= i 100))
	  (locsig lc i 1.0))
	(do ((i 0 (1+ i)))
	    ((= i 4))
	  (IF (fneq (locsig-reverb-ref lc i) .05)
	      (snd-display ";locsig reverb ref[~A]: ~A?" i (locsig-reverb-ref lc i)))
	  (locsig-reverb-set! lc i (* i .1))
	  (IF (fneq (locsig-reverb-ref lc i) (* i .1))
	      (snd-display ";locsig reverb set![~A]: ~A?" i (locsig-reverb-ref lc i))))
	(print-and-check lc
			 "locsig"
			 "locsig: chans 4, outn: [0.083 0.167 0.000 0.000]"
			 "locs outn[4]: [0.083 0.167 0.000 0.000], revn[4]: [0.000 0.100 0.200 0.300]")
	(mus-close gen)
	(mus-close rev))

	(print-and-check (make-locsig 160 :channels 4)
			 "locsig"
			 "locsig: chans 4, outn: [0.000 0.222 0.778 0.000]"
			 "locs outn[4]: [0.000 0.222 0.778 0.000], revn[0]: nil")
	(print-and-check (make-locsig 160 :channels 4 :distance .5)
			 "locsig"
			 "locsig: chans 4, outn: [0.000 0.222 0.778 0.000]"
			 "locs outn[4]: [0.000 0.222 0.778 0.000], revn[0]: nil")
	(print-and-check (make-locsig 320 :channels 4)
			 "locsig"
			 "locsig: chans 4, outn: [0.556 0.000 0.000 0.444]"
			 "locs outn[4]: [0.556 0.000 0.000 0.444], revn[0]: nil")
	(print-and-check (make-locsig 320 :channels 2)
			 "locsig"
			 "locsig: chans 2, outn: [0.000 1.000]"
			 "locs outn[2]: [0.000 1.000], revn[0]: nil")

      (let ((gen (make-src :srate 2.0))
	    (v0 (make-vct 10))
	    (rd (make-readin "oboe.snd" 0 2000)))
	(print-and-check gen 
			 "src"
			 "src: width: 10, x: 0.000, incr: 2.000, len: 10000"
			 "sr x: 0.000000, incr: 2.000000, width: 10, len: 10000, data[21]: [0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000...]")
	(do ((i 0 (1+ i)))
	    ((= i 10))
	  (vct-set! v0 i (src gen 0.0 (lambda (dir) (readin rd)))))
	(IF (not (src? gen)) (snd-display ";~A not scr?" gen))
	(IF (or (fneq (vct-ref v0 1) .001) (fneq (vct-ref v0 7) .021)) (snd-display ";src output: ~A" v0))
	(IF (fneq (mus-increment gen) 2.0) (snd-display ";src increment: ~F?" (mus-increment gen))))

      (let ((var (catch #t (lambda () (make-src :width -1)) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";make-src bad width: ~A" var)))

      (let ((gen (make-granulate :expansion 2.0))
	    (v0 (make-vct 1000))
	    (rd (make-readin "oboe.snd" 0 4000)))
	(print-and-check gen 
			 "granulate"
			 "granulate: expansion: 2.000 (551/1102), scaler: 0.600, length: 0.150 secs (3308 samps), ramp: 0.060"
			 "grn_info s20: 1102, s50: 441, rmp: 1323, amp: 0.600000, len: 3308, cur_out: 0, cur_in: 0, input_hop: 551, ctr: 0, output_hop: 1102, in_data_start: 5513, in_data[5513]: [0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000...], data[4410]: [0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000...]")
	(do ((i 0 (1+ i)))
	    ((= i 1000))
	  (vct-set! v0 i (granulate gen (lambda (dir) (readin rd)))))
	(IF (= (vct-peak v0) 0.0) (snd-display ";granulate output peak: ~F?" (vct-peak v0)))
	(IF (not (granulate? gen)) (snd-display ";~A not granulate?" gen))
	(IF (fneq (mus-increment gen) 2.0) (snd-display ";granulate increment: ~F?" (mus-increment gen)))
	(IF (fneq (mus-scaler gen) 0.6) (snd-display ";granulate scaler: ~F?" (mus-scaler gen)))
	(IF (fneq (mus-frequency gen) 0.05) (snd-display ";granulate frequency: ~F?" (mus-frequency gen)))
	(IF (not (= (mus-ramp gen) 1323)) (snd-display ";granulate ramp: ~F?" (mus-ramp gen)))
	(IF (not (= (mus-length gen) 3308)) (snd-display ";granulate length: ~A?" (mus-length gen)))
	(IF (not (= (mus-hop gen) 1102)) (snd-display ";granulate hop: ~A?" (mus-hop gen)))
	(set! (mus-hop gen) 1000) (IF (not (= (mus-hop gen) 1000)) (snd-display ";granulate set-hop: ~A?" (mus-hop gen)))
	(set! (mus-ramp gen) 1000) (IF (not (= (mus-ramp gen) 1000)) (snd-display ";granulate set-ramp: ~A?" (mus-ramp gen)))
	(set! (mus-length gen) 3000) (IF (not (= (mus-length gen) 3000)) (snd-display ";granulate set-length: ~A?" (mus-length gen)))
	(set! (mus-increment gen) 3.0)
	(IF (> (abs (- (mus-increment gen) 3.0)) .01) (snd-display ";granulate set-increment: ~F?" (mus-increment gen))))

      (let ((var (catch #t (lambda () (make-granulate :hop 35.0 :length 35.0)) (lambda args args))))
	(IF (not (eq? (car var) 'mus-error))
	    (snd-display ";make-granulate bad sizes: ~A" var)))

      (let* ((v0 (make-vct 32))
	     (v1 (make-vct 256))
	     (v2 (make-vct 256)))
	(do ((i 1 (1+ i)))
	    ((= i 16))
	  (vct-set! v0 i (/ 1.0 i)))
	(vct-set! v1 0 1.0)
	(let ((gen (make-convolve :filter v0))
	      (n -1))
	  (print-and-check gen 
			   "convolve"
			   "convolve: size: 64"
			   "conv fftsize: 64, fftsize2: 32, filtersize: 32, ctr: 32, rl1: [0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000...], rl2: [0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000...], buf: [0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000...], filter: [0.000 1.000 0.500 0.333 0.250 0.200 0.167 0.143...]")
	  (IF (not (convolve? gen)) (snd-display ";~A not convolve?" gen))
	  (IF (not (= (mus-length gen) 64)) (snd-display ";convolve fft len: ~D?" (mus-length gen)))
	  (do ((i 0 (1+ i)))
	      ((= i 128))
	    (vct-set! v2 i (convolve gen (lambda (dir) (set! n (+ n 1)) (vct-ref v1 n)))))
	  (IF (or (fneq (vct-ref v2 0) 0.0)
		  (fneq (vct-ref v2 1) 1.0)
		  (fneq (vct-ref v2 4) 0.25)
		  (fneq (vct-ref v2 7) 0.143))
	      (snd-display ";convolve output: ~A?" v2)))
	(convolve-files "oboe.snd" "fyow.snd" .5 "fmv.snd")
	(IF (fneq (cadr (mus-sound-maxamp "fmv.snd")) .5) 
	    (snd-display ";convolve-files: ~A /= .5?" (cadr (mus-sound-maxamp "fmv.snd"))))
	(play-sound "fmv.snd"))

      (let* ((fd (mus-sound-open-input "oboe.snd"))
	     (chans (mus-sound-chans "oboe.snd"))
	     (data (make-sound-data chans 2000)))
	(IF (not (sound-data? data)) (snd-display ";~A not sound-data?" data))
	(IF (not (= (sound-data-chans data) 1)) (snd-display ";sound-data chans: ~A?" (sound-data-chans data)))
	(IF (not (= (sound-data-length data) 2000)) (snd-display ";sound-data length: ~A?" (sound-data-length data)))
	(mus-sound-read fd 0 1999 chans data)
	(let ((val (sound-data-ref data 0 1497)))
	  (mus-sound-close-input fd)
	  (IF (fneq val 0.02893066) (snd-display ";mus-sound-read: ~F?" val))))

      (let ((ind (new-sound "fmv.snd")))
	(set! (sample 1) .1)
	(save-sound ind)
	(IF (not (equal? (edits ind 0) (list 0 0)))
	    (snd-display ";weird: edits not cleared after save-sound?: ~A" (edits ind 0)))
	(close-sound ind)
	(set! ind (open-sound "fmv.snd"))
	(IF (not (= (frames ind 0) 2))
	    (snd-display ";save-sound 2 samps: ~A?" (frames ind 0)))
	(IF (or (fneq (sample 0) 0.0)
		(fneq (sample 1) 0.1))
	    (snd-display ";save-sound: ~A ~A?" (sample 0) (sample 1)))
	(do ((i 3 (1+ i)))
	    ((= i 6))
	  (set! (sample i) (* i .1))
	  (save-sound ind)
	  (IF (not (equal? (edits ind 0) (list 0 0)))
	      (snd-display ";weird: edits not cleared after save-sound ~A?: ~A" i (edits ind 0)))
	  (close-sound ind)
	  (set! ind (open-sound "fmv.snd"))
	  (IF (not (= (frames ind 0) (+ i 1)))
	      (snd-display ";save-sound ~A samps: ~A?" (+ i 1) (frames ind 0)))
	  (IF (or (fneq (sample 0) 0.0)
		  (fneq (sample 1) 0.1)
		  (fneq (sample i) (* i 0.1)))
	      (snd-display ";save-sound ~A: ~A ~A ~A?" i (sample 0) (sample 1) (sample i))))
	(close-sound ind))

      (let ((nind (new-sound "fmv.snd" mus-aifc mus-bshort 22050 1 "this is a comment")))
	(time (fm-violin 0 1 440 .1))
	(fofins 1 1 270 .2 .001 730 .6 1090 .3 2440 .1) 
	(scissor 2.0) 
	(play-and-wait 0 nind)
	(save-sound nind)
	(let ((oboe-index (or (find-sound "oboe.snd") (open-sound "oboe.snd"))))
	  (cnvtest oboe-index nind .1) 
	  (select-sound nind)
	  (select-channel 0)
	  (IF (not (= (selected-sound) nind)) (snd-display ";selected-sound: ~A?" (selected-sound)))
	  (IF (not (= (selected-channel) 0)) (snd-display ";selected-channel: ~A?" (selected-channel)))
	  (jc-reverb 1.0 #f .1 #f) 
	  (play-and-wait 0 nind)
	  (voiced->unvoiced 1.0 256 2.0 2.0) 
	  (map-chan (fltit))
	  (close-sound oboe-index))
	(let ((fr (frames nind 0)))
	  (do ((k 0 (1+ k)))
	      ((= k 10))
	    (delete-samples 10 100 nind 0)
	    (save-sound nind)) ;flush out memory leaks here
	  (IF (not (= (frames nind 0) (- fr 1000)))
	      (snd-display ";delete-samples: ~A ~A" fr (frames nind 0))))
	(revert-sound nind)
	(close-sound nind))
      (if (file-exists? "fmv.snd") (delete-file "fmv.snd"))

      (let ((nind (new-sound "fmv.snd")))
	(IF (not (= (header-type nind) (default-output-type)))
	    (snd-display ";new-sound default header-type: ~A ~A?"
			       (mus-header-type-name (header-type nind))
			       (mus-header-type-name (default-output-type))))
	(IF (not (= (data-format nind) (default-output-format)))
	    (snd-display ";new-sound default data-format: ~A ~A?"
			       (mus-data-format-name (data-format nind))
			       (mus-data-format-name (default-output-format))))
	(IF (not (= (chans nind) (default-output-chans)))
	    (snd-display ";new-sound default chans: ~A ~A?" (chans nind) (default-output-chans)))
	(IF (not (= (srate nind) (default-output-srate)))
	    (snd-display ";new-sound default srate: ~A ~A?" (srate nind) (default-output-srate)))
	(close-sound nind)
	(if (file-exists? "fmv.snd") (delete-file "fmv.snd")))
      (let ((nind (new-sound "fmv.snd" mus-nist mus-bshort 22050 1 "this is a comment")))
	(set! (sample 0 nind) 1.0) 
	(start-progress-report nind)
	(convolve-with "oboe.snd") 
	(progress-report .1 "hiho" 0 1 nind)
	(IF (fneq (sample 1000) -0.22299) (snd-display ";convolve-with: ~A?" (sample 1000)))
	(progress-report .3 "hiho" 0 1 nind)
	(revert-sound nind)
	(progress-report .5 "hiho" 0 1 nind)
	(set! (sample 200) .0001) 
	(set! (sample 100) 1.0) 
	(progress-report .8 "hiho" 0 1 nind)
	(smooth-sound 0 100) 
	(finish-progress-report nind)
	(IF (or (fneq (sample 50) .5) (fneq (sample 30) 0.20608) (fneq (sample 90) 0.9755))
	    (snd-display ";smooth: ~A ~A ~A?" (sample 50) (sample 30) (sample 90)))
	(undo) 
	(set! (sinc-width) 40) 
	(set! (sample 100) 0.5) 
	(IF (fneq (sample 100) 0.5) (snd-display ";set-sample 100: ~A?" (sample 100)))
	(src-sound .1) 
	(IF (or (fneq (sample 1000) 0.5) (fneq (sample 1024) 0.0625) (fneq (sample 1010) 0.0))
	    (snd-display ";src-sound: ~A ~A ~A?" (sample 1000) (sample 1024) (sample 1010)))
	(revert-sound)
	(close-sound nind))
      (let ((nind (new-sound "fmv.snd" mus-riff mus-lshort 22050 1 "this is a comment")))
	(mix "pistol.snd") 
	(map-chan (expsrc 2.0 nind)) 
	(play-and-wait 0 nind)
	(undo) 
	(let ((eds (edits)))
	  (IF (or (not (= (car eds) 1)) (not (= (cadr eds) 1)))
	      (snd-display ";undo edits: ~A?" eds))
	  (IF (not (= (edit-position) (car eds)))
	      (snd-display ";undo edit-position: ~A ~A?" (edit-position) eds)))
	(expsnd '(0 1 2 .4)) 
	(map-chan (comb-chord .95 100 .3)) 
	(map-chan (formants .99 900 .02 1800 .01 2700)) 
	(map-chan (moving-formant .99 '(0 1200 1 2400))) 
	(scale-to .3) 
	(play-and-wait 0)
	(let ((eds (edits)))
	  (IF (or (not (= (car eds) 6)) (not (= (cadr eds) 0)))
	      (snd-display ";edits(6): ~A?" eds))
	  (IF (not (= (edit-position) (car eds)))
	      (snd-display ";edit-position(6): ~A ~A?" (edit-position) eds)))
	(set! (edit-position) 1)
	(IF (not (= (edit-position) 1))
	    (snd-display ";set edit-position(1): ~A?" (edit-position)))
	(set! (edit-position) 4)
	(IF (not (= (edit-position) 4))
	    (snd-display ";set edit-position(4): ~A?" (edit-position)))
	(revert-sound nind)
	(mix "pistol.snd") 
	(map-chan (zecho .5 .75 6 10.0) 0 65000) 
	(map-chan (am 440)) 
	(add-mark 1200)
	(add-mark 2300)
	(key (char->integer #\x) 4)
	(key (char->integer #\c) 0) ; trigger mark-define-region
	(reverse-sound nind) 
	(play-and-wait 0 nind)
	(revert-sound nind)
	(let ((mid (mix-sound "pistol.snd" 0)))
	  (IF (not (equal? (mix-home mid) (list (selected-sound) 0)))
	      (snd-display ";mix-sound mix-home: ~A (~A or ~A 0)" (mix-home mid) (selected-sound) nind)))
	(hello-dentist 40.0 .1) 
	(fp 1.0 .3 20) 
	(play-and-wait 0 nind)
	(revert-sound nind)
	(enveloped-mix "oboe.snd" 0 '(0 0 1 1 2 0)) 
	(pvoc :pitch 0.5 :time 1.0 :snd nind) 
	(play-and-wait 0 nind)
	(revert-sound nind)
	(pqw-vox 0 1 300 300 .1 '(0 0 50 1 100 0) '(0 0 100 0) 0 '(0 L 100 L) '(.33 .33 .33) '((1 1 2 .5) (1 .5 2 .5 3 1) (1 1 4 .5)))
	(play-and-wait 0 nind)
	(close-sound nind))

      (if (file-exists? "fmv.snd") (delete-file "fmv.snd"))
      (if (file-exists? "fmv1.snd") (delete-file "fmv1.snd"))
      (if (file-exists? "fmv2.snd") (delete-file "fmv2.snd"))
      (if (file-exists? "fmv3.snd") (delete-file "fmv3.snd"))
      (let ((v0 (make-vct 12)))
	(vct-fill! v0 0.1)
	(array->file "fmv1.snd" v0 12 22050 1)
	(vct-fill! v0 0.2)
	(array->file "fmv2.snd" v0 12 22050 2)
	(vct-fill! v0 0.3)
	(array->file "fmv3.snd" v0 12 22050 4)
	(do ((i 0 (1+ i))) ((= i 12)) (vct-set! v0 i (* i .01)))
	(array->file "fmv.snd" v0 12 22050 1)
	(mus-mix "fmv.snd" "fmv1.snd")
	(file->array "fmv.snd" 0 0 12 v0)
	(do ((i 0 (1+ i))) ((= i 12)) (IF (fneq (vct-ref v0 i) (+ 0.1 (* i .01))) (snd-display ";mus-mix(1->1): ~A?" v0)))
	(mus-mix "fmv.snd" "fmv2.snd" 3 9 0 (make-mixer 2 0.3 0.0 0.7 0.0))
	(file->array "fmv.snd" 0 0 12 v0)
	(IF (or (fneq (vct-ref v0 0) .1) (fneq (vct-ref v0 3) .33) (fneq (vct-ref v0 9) .19)) (snd-display ";mus-mix(2->1): ~A?" v0))
	(mus-mix "fmv.snd" "fmv3.snd")
	(file->array "fmv.snd" 0 0 12 v0)
	(IF (or (fneq (vct-ref v0 0) .4) (fneq (vct-ref v0 3) .33)) (snd-display ";mus-mix(4->1): ~A?" v0))
	(let ((e0 (make-env '(0 0 1 1) :end 9))
	      (vf (make-vector 1))
	      (vf1 (make-vector 1)))
	  (vector-set! vf 0 vf1)
	  (vector-set! vf1 0 e0)
	  (mus-mix "fmv.snd" "fmv1.snd" 0 12 0 (make-mixer 1 1.0) vf)
	  (file->array "fmv.snd" 0 0 12 v0)
	  (IF (or (fneq (vct-ref v0 0) .4) (fneq (vct-ref v0 3) .360) (fneq (vct-ref v0 9) .28)) (snd-display ";mus-mix(env): ~A?" v0))
	  (mus-mix "fmv.snd" "fmv2.snd" 0 12 0 (make-mixer 2 1.0 1.0 1.0 1.0) vf)) ; clm2xen should protect us here
	(let ((vf (make-vector 2))
	      (vf1 (make-vector 2))
	      (vf2 (make-vector 2)))
	  (vector-set! vf 0 vf1)
	  (vector-set! vf 1 vf2)
	  (vector-set! vf1 0 (make-env '(0 0 1 1) :end 9))
	  (vector-set! vf2 1 (make-env '(0 0 1 1) :end 9))
	  (mus-mix "fmv.snd" "fmv2.snd" 0 12 0 (make-mixer 2 1.0 1.0 1.0 1.0) vf))
	(delete-file "fmv.snd")
	(do ((i 0 (1+ i))) ((= i 12)) (vct-set! v0 i (* i .01)))
	(array->file "fmv.snd" v0 12 22050 4)
	(mus-mix "fmv.snd" "fmv1.snd")
	(file->array "fmv.snd" 0 0 3 v0) ; chan 0 start 0 len 3
	(IF (or (fneq (vct-ref v0 0) .1) (fneq (vct-ref v0 2) .18)) (snd-display ";mus-mix(1->4): ~A?" v0))
	(mus-mix "fmv.snd" "fmv2.snd"  0 3 0 (make-mixer 2 0.3 0.0 0.7 0.0))
	(file->array "fmv.snd" 0 0 3 v0)
	(IF (or (fneq (vct-ref v0 0) .3) (fneq (vct-ref v0 2) .38)) (snd-display ";mus-mix(2->4): ~A?" v0))
	(mus-mix "fmv.snd" "fmv3.snd" 0 2 0)
	(file->array "fmv.snd" 0 0 3 v0)
	(IF (or (fneq (vct-ref v0 0) .6) (fneq (vct-ref v0 2) .38)) (snd-display ";mus-mix(4->4): ~A?" v0)))

      (if (file-exists? "fmv.snd") (delete-file "fmv.snd"))
      (let ((v0 (make-vct 12))
	    (len (mus-sound-frames "oboe.snd")))
	(array->file "fmv.snd" v0 12 22050 1)
	(mus-mix "fmv.snd" "oboe.snd")
	(mus-mix "fmv.snd" "oboe.snd" 0 len 0 (make-mixer 1 0.5))
	(let* ((egen (make-vector 1))
	       (outv (make-vector 1)))
	  (vector-set! outv 0 egen)
	  (vector-set! egen 0 (make-env :envelope '(0 0 1 1) :end len))
	  (mus-mix "fmv.snd" "oboe.snd" 0 len 0 #f outv)
	  (vector-set! egen 0 (make-env :envelope '(0 1 1 0) :end len))
	  (mus-mix "fmv.snd" "oboe.snd" 0 len 0 (make-mixer 1 1.0) outv))
	(let ((ind-oboe (open-sound "oboe.snd"))
	      (ind-mix (open-sound "fmv.snd")))
	  (IF (not (vequal (samples->vct 1000 10 ind-oboe)
			   (vct-scale! (samples->vct 1000 10 ind-mix) (/ 1.0 2.5))))
	      (snd-display ";mus-mix 1 chan: ~A ~A"
			   (samples->vct 1000 10 ind-oboe)
			   (samples->vct 1000 10 ind-mix)))
	  (close-sound ind-oboe)
	  (close-sound ind-mix))
	(delete-file "fmv.snd")
	(let ((v0 (make-vct 12))
	      (len (mus-sound-frames "2.snd")))
	  (array->file "fmv.snd" v0 12 22050 2)
	  (IF (not (= (mus-sound-chans "fmv.snd") 2))
	      (snd-display ";array->file chans? ~A" (mus-sound-chans "fmv.snd")))
	  (mus-mix "fmv.snd" "2.snd")
	  (mus-mix "fmv.snd" "2.snd" 0 len 0 (make-mixer 2 0.5 0.0 0.0 0.5))
	  (let* ((egen0 (make-vector 2))
		 (egen1 (make-vector 2))
		 (outv (make-vector 2)))
	    (vector-set! outv 0 egen0)
	    (vector-set! outv 1 egen1)
	    (vector-set! egen0 0 (make-env :envelope '(0 0 1 1) :end len))
	    (vector-set! egen1 1 (make-env :envelope '(0 0 1 1) :end len))
	    (mus-mix "fmv.snd" "2.snd" 0 len 0 #f outv))
	  (let ((ind-mix (open-sound "fmv.snd")))
	    (IF (not (= (channels ind-mix) 2))
		(snd-display ";fmv re-read chans? ~A ~A" (mus-sound-chans "fmv.snd") (channels ind-mix)))
	    (IF (not (vequal (samples->vct 1000 10 ind-mix 0)
			     (vct 0.001 0.009 0.012 0.012 0.009 0.005 0.002 0.002 0.005 0.014)))
		(snd-display ";mus-mix 2 chan: ~A ~A"
			     (samples->vct 1000 10 ind-mix 0)
			     (samples->vct 1000 10 ind-mix 1)))
	    (close-sound ind-mix)
	    (delete-file "fmv.snd"))))

      (let* ((ind (open-sound "oboe.snd"))
	     (pi2 (* 2.0 pi))
	     (pv (make-phase-vocoder #f
				    512 4 128 1.0
				    #f ;no change to analysis
				    #f ;no change to edits
				    #f ;no change to synthesis
				    ))
	    (reader (make-sample-reader 0)))
	(IF (not (phase-vocoder? pv)) (snd-display ";~A not phase-vocoder?" pv))
	(print-and-check pv 
			 "phase_vocoder"
			 "phase_vocoder: outctr: 128, interp: 128, filptr: 0, N: 512, D: 128, in_data: nil"
			 "pv_info outctr: 128, interp: 128, filptr: 0, N: 512, D: 128, in_data: nil, amps: [0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000...], freqs: [0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000...]")
	(select-sound ind)
	(map-chan (lambda (val)
 		    (phase-vocoder pv (lambda (dir) 
					(next-sample reader)))))
	(IF (fneq (pv-ampinc pv 0) (vct-ref (pv-ampinc-1 pv) 0))
	    (snd-display ";pvoc ampinc: ~A ~A?" (pv-ampinc pv 0) (vct-ref (pv-ampinc-1 pv) 0)))
	(set-pv-ampinc pv 0 .1)
	(IF (fneq (pv-ampinc pv 0) .1)
	    (snd-display ";set-pv-ampinc: ~A?" (pv-ampinc pv 0)))
	(IF (fneq (pv-amps pv 0) (vct-ref (pv-amps-1 pv) 0))
	    (snd-display ";pvoc amps: ~A ~A?" (pv-amps pv 0) (vct-ref (pv-amps-1 pv) 0)))
	(set-pv-amps pv 0 .1)
	(IF (fneq (pv-amps pv 0) .1)
	    (snd-display ";set-pv-amps: ~A?" (pv-amps pv 0)))
	(IF (fneq (pv-phases pv 0) (vct-ref (pv-phases-1 pv) 0))
	    (snd-display ";pvoc phases: ~A ~A?" (pv-phases pv 0) (vct-ref (pv-phases-1 pv) 0)))
	(set-pv-phases pv 0 .1)
	(IF (fneq (pv-phases pv 0) .1)
	    (snd-display ";set-pv-phases: ~A?" (pv-phases pv 0)))
	(IF (fneq (pv-phaseinc pv 0) (vct-ref (pv-phaseinc-1 pv) 0))
	    (snd-display ";pvoc phaseinc: ~A ~A?" (pv-phaseinc pv 0) (vct-ref (pv-phaseinc-1 pv) 0)))
	(set-pv-phaseinc pv 0 .1)
	(IF (fneq (pv-phaseinc pv 0) .1)
	    (snd-display ";set-pv-phaseinc: ~A?" (pv-phaseinc pv 0)))
	(IF (fneq (pv-lastphase pv 0) (vct-ref (pv-lastphase-1 pv) 0))
	    (snd-display ";pvoc lastphase: ~A ~A?" (pv-lastphase pv 0) (vct-ref (pv-lastphase-1 pv) 0)))
	(set-pv-lastphase pv 0 .1)
	(IF (fneq (pv-lastphase pv 0) .1)
	    (snd-display ";set-pv-lastphase: ~A?" (pv-lastphase pv 0)))
	(IF (fneq (pv-freqs pv 0) (vct-ref (pv-freqs-1 pv) 0))
	    (snd-display ";pvoc freqs: ~A ~A?" (pv-freqs pv 0) (vct-ref (pv-freqs-1 pv) 0)))
	(set-pv-freqs pv 0 .1)
	(IF (fneq (pv-freqs pv 0) .1)
	    (snd-display ";set-pv-freqs: ~A?" (pv-freqs pv 0)))
	(undo 1)
	(free-sample-reader reader)
	(set! pv (make-phase-vocoder #f
				     512 4 128 1.0
				     #f ;no change to analysis
				     (lambda (v)
				       ; new editing func changes pitch
				       (let* ((N (mus-length v)) ;mus-increment => interp, mus-data => in-data
					      (D (mus-hop v)))
					 (do ((k 0 (1+ k))
					      (pscl (/ 1.0 D))
					      (kscl (/ pi2 N)))
					     ((= k (inexact->exact (floor (/ N 2)))))
					   (let ((phasediff (- (pv-freqs v k) (pv-lastphase v k))))
					     (set-pv-lastphase v k (pv-freqs v k))
					     (if (> phasediff pi) (do () ((<= phasediff pi)) (set! phasediff (- phasediff pi2))))
					     (if (< phasediff (- pi)) (do () ((>= phasediff (- pi))) (set! phasediff (+ phasediff pi2))))
					     (set-pv-freqs v k 
							   (* 0.5
							      (+ (* pscl phasediff)
								 (* k kscl))))))
					 #f))
				     #f ; no change to synthesis
				     ))
	(set! reader (make-sample-reader 0))
	(map-chan (lambda (val)
		    (phase-vocoder pv (lambda (dir) 
					(reader)))))
	(undo 1)
	(free-sample-reader reader)
	(set! pv (make-phase-vocoder #f
				     512 4 (inexact->exact (* 128 2.0)) 1.0
				     #f ;no change to analysis
				     #f ;no change to edits
				     #f ;no change to synthesis
				     ))
	(set! reader (make-sample-reader 0))
	(let* ((len (inexact->exact (* 2.0 (frames ind))))
	       (data (make-vct len)))
	  (vct-map! data
		    (lambda ()
		      (phase-vocoder pv (lambda (dir) (next-sample reader)))))
	  (set! (samples 0 len) data))
	(undo 1)
	(free-sample-reader reader)

	(let ((incalls 0)
	      (outcalls 0))
	  (set! pv (make-phase-vocoder #f
				       512 4 (inexact->exact (* 128 2.0)) 1.0
				       (lambda (v infunc)
					 (set! incalls (+ incalls 1))
					 #t)
				       #f ;no change to edits
				       (lambda (v)
					 (set! outcalls (+ outcalls 1))
					 0.0)
				       ))
	  (set! reader (make-sample-reader 0))
	  (let* ((len (inexact->exact (* 2.0 (frames ind))))
		 (data (make-vct len)))
	    (vct-map! data
		      (lambda ()
			(phase-vocoder pv (lambda (dir) (next-sample reader)))))
	    (set! (samples 0 len) data))
	  (undo 1)
	  (free-sample-reader reader)
	  (IF (or (= incalls 0)
		  (= outcalls 0))
	      (snd-display "phase-vocoder incalls: ~A, outcalls: ~A" incalls outcalls)))

	(close-sound ind))

      ))


;;; ---------------- test 9: mix ----------------
(if (or full-test (= snd-test 9) (and keep-going (<= snd-test 9)))
    (begin
    (do ((test-ctr 0 (1+ test-ctr)))
	((= test-ctr tests))
      (let ((new-index (new-sound "hiho.wave" mus-next mus-bshort 22050 1)))
	(if (procedure? test-hook) (test-hook 9))
	(log-mem test-ctr)
	(select-sound new-index)
	(let ((mix-id (mix "pistol.snd" 100)))
	  (IF (not (mix? mix-id)) (snd-display ";~A not mix?" mix-id))
	  (mix-panel)
	  (let ((pos (mix-position mix-id))
		(len (mix-length mix-id))
		(loc (mix-locked mix-id))
		(anc (mix-anchor mix-id))
		(spd (mix-speed mix-id))
		(trk (mix-track mix-id))
		(snd (car (mix-home mix-id)))
		(chn (cadr (mix-home mix-id)))
		(chns (mix-chans mix-id))
		(amp (mix-amp mix-id 0))
		(mr (make-mix-sample-reader mix-id)))
	    (IF (not (mix-sample-reader? mr)) (snd-display ";~A not mix-sample-reader?" mr))
	    (let ((reader-string (format #f "~A" mr)))
	      (IF (not (string=? (substring reader-string 0 22) "#<mix-sample-reader 0x"))
		  (snd-display ";mix sample reader actually got: [~S]" (substring reader-string 0 22)))
	      (IF (not (string=? (substring reader-string 29 62) (string-append ": " home-dir "/bil/cl/pistol.snd via mix")))
		  (snd-display ";mix sample reader actually got: [~S]" (substring reader-string 29 62))))
	    (let ((var (catch #t (lambda () (mix-amp mix-id 1234)) (lambda args args))))
	      (IF (not (eq? (car var) 'no-such-channel))
		  (snd-display ";mix-amp bad chan: ~A" var)))
	    (let ((var (catch #t (lambda () (set! (mix-amp mix-id 1234) .1)) (lambda args args))))
	      (IF (not (eq? (car var) 'no-such-channel))
		  (snd-display ";set mix-amp bad chan: ~A" var)))
	    (let ((var (catch #t (lambda () (set! (mix-amp-env mix-id 1234) '(0 0 1 1))) (lambda args args))))
	      (IF (not (eq? (car var) 'no-such-channel))
		  (snd-display ";set mix-amp-env bad chan: ~A" var)))
	    (do ((i 0 (1+ i)))
		((= i 99))
	      (let ((mx (next-mix-sample mr))
		    (sx (sample (+ 100 i))))
		(IF (fneq mx sx) (snd-display ";next-mix-sample: ~A ~A?" mx sx))))
	    (let ((mx (mr))
		  (sx (sample 199)))
	      (IF (fneq mx sx) (snd-display ";mix-sample 100: ~A ~A?" mx sx)))
	    (free-mix-sample-reader mr)
	    (IF (not (= pos 100)) (snd-display ";mix-position: ~A?" pos))
	    (IF (not (= len 41623)) (snd-display ";mix-length: ~A?" len))
	    (IF loc (snd-display ";mix-locked: ~A?" loc))
	    (IF (not (= anc 0)) (snd-display ";mix-anchor: ~A?" anc))
	    (IF (not (= trk 0)) (snd-display ";mix-track: ~A?" trk))
	    (IF (not (= snd new-index)) (snd-display ";s mix-home: ~A?" snd))		
	    (IF (not (= chn 0)) (snd-display ";c mix-home: ~A?" chn))
	    (IF (not (= chns 1)) (snd-display ";mix-chans: ~A?" chn))
	    (IF (fneq amp 1.0) (snd-display ";mix-amp: ~A?" amp))
	    (IF (fneq spd 1.0) (snd-display ";mix-speed: ~A?" spd))
	    (catch 'mus-error
		   (lambda () (play-mix mix-id))
		   (lambda args (snd-display "can't play mix")))
	    (set! (mix-position mix-id) 200) 
	    (set! (mix-name mix-id) "asdf") 
	    (set! (mix-amp mix-id 0) 0.5) 
	    (set! (mix-speed mix-id) 2.0) 
	    (set! (mix-track mix-id) 3) 
	    (set! (mix-anchor mix-id) 30) 
	    (set! (mix-amp-env mix-id 0) '(0.0 0.0 1.0 1.0)) 
	    (set! (mix-tag-y mix-id) 20) 
	    (let ((pos (mix-position mix-id))
		  (spd (mix-speed mix-id))
		  (trk (mix-track mix-id))
		  (amp (mix-amp mix-id 0))
		  (nam (mix-name mix-id))
		  (my (mix-tag-y mix-id))
		  (anc (mix-anchor mix-id)))
	      (IF (not (= pos 200)) (snd-display ";set-mix-position: ~A?" pos))
	      (IF (not (= my 20)) (snd-display ";set-mix-tag-y: ~A?" my))
	      (IF (not (= trk 3)) (snd-display ";set-mix-track: ~A?" trk))
	      (IF (fneq amp 0.5) (snd-display ";set-mix-amp: ~A?" amp))
	      (IF (fneq spd 2.0) (snd-display ";set-mix-speed: ~A?" spd))
	      (IF (not (= anc 30)) (snd-display ";set-mix-anchor: ~A?" anc))
	      (IF (not (equal? (mix-amp-env mix-id 0) '(0.0 0.0 1.0 1.0))) (snd-display ";set-mix-amp-env: ~A?" (mix-amp-env mix-id 0)))
	      (IF (not (string=? nam "asdf")) (snd-display ";set-mix-name: ~A?" nam))
	      (IF (= mix-id (selected-mix)) (snd-display ";selected-mix: ~A?" mix-id))
	      (set! (selected-mix) mix-id)
	      (IF (not (= mix-id (selected-mix))) (snd-display ";set! select-mix: ~A ~A?" mix-id (selected-mix)))
	      (set! (selected-mix) -1)
	      (select-mix mix-id)
	      (IF (not (= mix-id (selected-mix))) (snd-display ";select-mix: ~A ~A?" mix-id (selected-mix))))
	    (let ((id (make-region 0 100)))
	      (mix-region 100 id) 
	      (mix-region 200 id))
	    (IF (not (= (mix-name->id "asdf") mix-id)) (snd-display ";mix-name->id: ~A?" (mix-name->id "asdf")))))
	(set! (cursor) 0)
	(let ((nid (forward-mix)))
	  (IF (or (not (mix? nid))
		  (not (= (cursor) (mix-position nid))))
	      (snd-display ";forward-mix ~A ~A ~A?" nid (cursor) (and (mix? nid) (mix-position nid))))
	  (let ((nid1 (forward-mix 2)))
	    (IF (or (not (mix? nid1))
		    (= nid nid1)
		    (not (= (cursor) (mix-position nid1))))
		(snd-display ";forward-mix(2) ~A ~A ~A ~A?" nid nid1 (cursor) (and (mix? nid1) (mix-position nid1))))
	    (set! nid1 (backward-mix))
	    (IF (or (not (mix? nid1))
		    (not (= (cursor) (mix-position nid1))))
		(snd-display ";backward-mix(2) ~A ~A ~A?" nid1 (cursor) (and (mix? nid1) (mix-position nid1))))))
	(let ((nid (find-mix 100)))
	  (IF (or (not (mix? nid))
		  (not (= (mix-position nid) 100)))
	      (snd-display ";find-mix(100): ~A ~A?" nid (and (mix? nid) (mix-position nid)))))
	(let ((nid (find-mix 200)))
	  (IF (or (not (mix? nid))
		  (not (= (mix-position nid) 200)))
	      (snd-display ";find-mix(200): ~A ~A?" nid (and (mix? nid) (mix-position nid)))))
	(let ((mix-id (mix "oboe.snd" 100)))
	  (IF (not (sound? (list mix-id))) (snd-display ";mix oboe: ~D not ok?" mix-id))
	  (IF (not (= (chans (list mix-id)) 1)) (snd-display ";mix oboe: chans ~D?" (chans (list mix-id))))
	  (IF (not (= (channels (list mix-id)) 1)) (snd-display ";mix oboe: channels ~D?" (channels (list mix-id))))
	  (IF (not (= (frames (list mix-id)) 50828)) (snd-display ";mix oboe: frames ~D?" (frames (list mix-id))))
	  (IF (not (= (srate (list mix-id)) 22050)) (snd-display ";mix oboe: srate ~D?" (srate (list mix-id))))
	  (IF (not (= (data-location (list mix-id)) 28)) (snd-display ";mix oboe: location ~D?" (data-location (list mix-id))))
	  (IF (not (= (data-format (list mix-id)) 1)) (snd-display ";mix oboe: format ~A?" (data-format (list mix-id))))
	  (IF (fneq (maxamp (list mix-id)) .14724) (snd-display ";mix oboe: maxamp ~F?" (maxamp (list mix-id))))
	  (IF (comment (list mix-id)) (snd-display ";mix oboe: comment ~A?" (comment (list mix-id))))
	  (IF (not (string=? (short-file-name (list mix-id)) "oboe.snd")) (snd-display ";mix oboe short name: ~S?" (short-file-name (list mix-id))))
	  (let ((matches (count-matches (lambda (a) (> a .125)) 0 (list mix-id))))
	    (IF (not (= matches 1313)) (snd-display ";mix count-matches: ~A?" matches)))
	  (let ((spot (find (lambda (a) (> a .13)) 0 (list mix-id))))
	    (IF (or (null? spot) (not (= (cadr spot) 8862))) (snd-display ";mix find: ~A?" spot)))
	  (let ((eds (edits (list mix-id))))
	    (IF (or (not (= (car eds) 0)) (not (= (cadr eds) 0)))
		(snd-display ";mix edits: ~A?" eds))
	    (IF (not (= (edit-position (list mix-id)) (car eds)))
		(snd-display ";mix edit-position: ~A ~A?" (edit-position (list mix-id)) eds)))
	  (let ((samps1 (samples->vct 0 50828 (list mix-id) 0))
		(vr (make-sample-reader 0 (list mix-id) 0 1)))
	    (IF (not (sample-reader? vr)) (snd-display ";(mix) ~A not sample-reader?" vr))
	    (catch 'break
		   (lambda ()
		     (do ((i 0 (1+ i)))
			 ((= i 50828))
		       (if (not (= (vr) (samps1 i)))
			   (begin
			     (snd-display ";(mix) readers disagree at ~D" i)
			     (throw 'break)))))
		   (lambda args (car args)))
	    (free-sample-reader vr))
	  (insert-sample 100 .5 (list mix-id)) 
	  (IF (or (fneq (sample 100 (list mix-id)) .5)
		  (not (= (frames (list mix-id)) 50829)))
	      (snd-display ";(mix) insert-sample: ~A ~A?" (sample 100 (list mix-id)) (frames (list mix-id))))
	  (let ((v0 (make-vector 3))
		(v1 (make-vct 3)))
	    (vct-fill! v1 .75)
	    (do ((i 0 (1+ i))) ((= i 3)) (vector-set! v0 i .25))
	    (insert-samples 200 3 v0 (list mix-id)) 
	    (insert-samples 300 3 v1 (list mix-id)) 
	    (IF (or (fneq (sample 201 (list mix-id)) .25)
		    (fneq (sample 301 (list mix-id)) .75)
		    (not (= (frames (list mix-id)) 50835)))
		(snd-display ";(mix) insert-samples: ~A ~A ~A?" (sample 201 (list mix-id)) (sample 301 (list mix-id)) (frames (list mix-id)))))
	  (undo 2)
	  (set! (sample 50 (list mix-id)) .5) 
	  (IF (fneq (sample 50 (list mix-id)) .5) (snd-display ";(mix) set-sample: ~A?" (sample 50 (list mix-id))))
	  (let ((v0 (make-vector 3)))
	    (do ((i 0 (1+ i))) ((= i 3)) (vector-set! v0 i .25))
	    (set! (samples 60 3 (list mix-id)) v0) 
	    (IF (or (fneq (sample 60 (list mix-id)) .25) (fneq (sample 61 (list mix-id)) .25))
		(snd-display ";(mix) set-samples: ~A ~A ~A?" (sample 60 (list mix-id)) (sample 61 (list mix-id)) (sample 62 (list mix-id)))))
	  (undo)
	  (let ((fr (frames (list mix-id))))
	    (delete-sample 100 (list mix-id)) 
	    (IF (not (= (frames (list mix-id)) (1- fr))) (snd-display ";(mix) delete-sample: ~A from ~A?" (frames (list mix-id)) fr)))
	  (let ((fr (frames (list mix-id))))
	    (delete-samples 0 100 (list mix-id)) 
	    (IF (not (= (frames (list mix-id)) (- fr 100))) (snd-display ";(mix) delete-samples: ~A from ~A?" (frames (list mix-id)) fr)))
	  (undo 2)
	  (let ((maxa (maxamp (list mix-id))))
	  (scale-to .5 (list mix-id)) 
	  (let ((newmaxa (maxamp (list mix-id))))
	    (IF (fneq newmaxa .5) (snd-display ";(mix) scale-to: ~A?" newmaxa))
	    (undo)
	    (scale-by 2.0 (list mix-id)) 
	    (set! newmaxa (maxamp (list mix-id)))
	    (IF (fneq newmaxa (* 2.0 maxa)) (snd-display ";(mix) scale-by: ~A?" newmaxa))
	    (revert-sound)
	    (let ((tag (catch 'no-such-mix
			      (lambda ()
				(delete-sample 100 (list mix-id)))
			      (lambda args (car args)))))
	      (IF (not (eq? tag 'no-such-mix))
		  (snd-display ";edit of invalid mix: ~A ~A" tag (edits))))
	    )))
	;; now track tests (mix.scm)
	(revert-sound new-index)
	(let ((mix-ids (make-vector 6)))
	  (do ((i 0 (1+ i)))
	      ((= i 6))
	    (vector-set! mix-ids i (mix "oboe.snd" (* i 1000))))
	  (set! (mix-track (vector-ref mix-ids 0)) 1)
	  (set! (mix-track (vector-ref mix-ids 2)) 1)
	  (set! (mix-track (vector-ref mix-ids 4)) 1)
	  (IF (not (= (track-position (track 1)) 0)) (snd-display ";track-position: ~D?" (track-position (track 1))))
	  (let* ((mr (make-track-sample-reader 1))
		 (reader-string (format #f "~A" mr)))
	      (IF (not (string=? (substring reader-string 0 24) "#<track-sample-reader 0x"))
		  (snd-display ";track sample reader actually got: [~S]" (substring reader-string 0 24)))
	      (IF (not (string=? (substring reader-string 31) (string-append ": " home-dir "/bil/cl/oboe.snd chan 0 via mixes '(9 11 13)>")))
		  (snd-display ";track sample reader actually got: [~S]" (substring reader-string 31)))
	      (free-track-sample-reader mr))
	  (let ((curend (track-end (track 1))))
	    (set-track-position (track 1) 500)
	    (IF (not (= (track-position (track 1)) 500)) (snd-display ";set-track-position: ~D?" (track-position (track 1))))
	    (IF (not (= (mix-position (vector-ref mix-ids 0)) 500)) (snd-display ";track-position ~D = ~D?" 0 (mix-position (vector-ref mix-ids 0))))
	    (IF (not (= (mix-position (vector-ref mix-ids 1)) 1000)) (snd-display ";track-position ~D = ~D?" 1 (mix-position (vector-ref mix-ids 1))))
	    (IF (not (= (mix-position (vector-ref mix-ids 4)) 4500)) (snd-display ";track-position ~D = ~D?" 4 (mix-position (vector-ref mix-ids 4))))
	    (IF (not (= (track-end (track 1)) (+ curend 500))) (snd-display ";track-end: ~D (~D)?" (track-end (track 1)) (+ curend 500))))
	  (IF (not (= (track-length (track 1)) (+ (frames (list (vector-ref mix-ids 0))) 4000)))
	      (snd-display ";track-length: ~D (~D)?" (track-length (track 1)) (+ 4000 50828)))
	  (set-track-amp (track 1) .5)
	  (IF (fneq (mix-amp (vector-ref mix-ids 2) 0) .5) (snd-display ";set-track-amp ~F?" (mix-amp (vector-ref mix-ids 2) 0)))
	  (incf-track-amp (track 1) .25)
	  (IF (fneq (mix-amp (vector-ref mix-ids 4) 0) .75) (snd-display ";incf-track-amp ~F?" (mix-amp (vector-ref mix-ids 4) 0)))
	  (transpose-track (track 1) 12)
	  (IF (fneq (mix-speed (vector-ref mix-ids 2)) 2.0)
	      (snd-display ";transpose-track: ~F?" (mix-speed (vector-ref mix-ids 2))))
	  (IF (not (= (frames (list (vector-ref mix-ids 1))) 50828))
	      (snd-display ";transpose-track mixup: ~D (~D)?" (frames (list (vector-ref mix-ids 1))) 50828))
	  (set-track-tempo (track 1) 2.0)
	  (IF (not (= (track-length (track 1)) (/ (+ 4000 50828) 2)))
	      (snd-display ";track-tempo: ~D (~D)?" (track-length (track 1)) (/ (+ 4000 50828) 2)))
	  (set-track-color (track 1) (make-color .8 .8 .8))
	  (set! (mix-track (vector-ref mix-ids 1)) 2)
	  (set! (mix-track (vector-ref mix-ids 3)) 2)
	  (set-track-color (track 2) (make-color .2 .8 0))
	  (let ((t2 (track->vct (track 2)))
		(t3 (mix->vct (vector-ref mix-ids 5))))
	    (IF (or (fneq (vct-ref t2 1000) (vct-ref t3 1000))
		    (fneq (vct-ref t3 1000) 0.0328369))
		(snd-display ";track->vct: ~F, mix->vct: ~F (.0328369)?" (vct-ref t2 1000) (vct-ref t3 1000))))
	  (set-track-amp-env (track 1) 0 '(0 0 1 1))
	  (filter-track (track 1) '(.1 .2 .3 .3 .2 .1))
	  (play-and-wait))
	(let ((v1 (envelope-interp 1.0 '(0 0 2.0 1.0)))
	      (v2 (envelope-interp 1.0 '(0 0.0 1 1.0 2 0.0)))
	      (v3 (envelope-interp 2.0 '(0 0.0 1 1.0)))
	      (v4 (envelope-interp 0.0 '(1 .5 2 0))))
	  (IF (fneq v1 0.5) (snd-display ";envelope-interp(1): ~F (0.5)?" v1))
	  (IF (fneq v2 1.0) (snd-display ";envelope-interp(2): ~F (1.0)?" v2))
	  (IF (fneq v3 1.0) (snd-display ";envelope-interp(3): ~F (1.0)?" v3))
	  (IF (fneq v4 0.5) (snd-display ";envelope-interp(4): ~F (0.5)?" v4)))
	(let ((v1 (multiply-envelopes '(0.0 0.0 2.0 0.5) '(0.0 0.0 1.0 2.0 2.0 1.0)))
	      (v2 (window-envelope 1.0 3.0 '(0.0 0.0 5.0 1.0))))
	  (IF (not (feql v1 (list 0.0 0.0 0.5 0.5 1.0 0.5))) (snd-display ";multiply-envelopes: ~A?" v1))
	  (IF (not (feql v2 (list 1.0 0.2 3.0 0.6))) (snd-display ";window-envelope: ~A?" v2)))
	(close-sound new-index))
      (let ((index (open-sound "pistol.snd"))
	    (data (samples->vct 0 100)))
	(close-sound index)
	(let ((reader (make-sample-reader 0 "pistol.snd")))
	  (do ((i 0 (1+ i)))
	      ((= i 10))
	    (IF (fneq (vct-ref data i) (next-sample reader))
		(snd-display "external reader trouble")))
	  (free-sample-reader reader)))
      )
    (load "bird.scm")
    (time (make-birds "fmv.snd"))
    ;(play-and-wait 0 (find-sound "fmv.snd"))
    (close-sound (find-sound "fmv.snd"))
    (dismiss-all-dialogs)

    (let ((ind (new-sound "new.snd"))
	  (mxs (make-vector 10)))
      (call-with-current-continuation
       (lambda (quit)
	 (do ((i 0 (1+ i)))
	     ((= i 10))
	   (let ((v (make-vct 1)))
	     (vct-set! v 0 (* i .05))
	     (vector-set! mxs i (mix-vct v i ind 0))
	     (IF (not (mix? (vector-ref mxs i)))
		 (quit (snd-display ";mix-vct at ~A failed? " i))
		 (set! (mix-track (vector-ref mxs i)) 33))))
	 (let ((tr (make-track-sample-reader 33)))
	   (do ((i 0 (1+ i)))
	       ((= i 10))
	     (let ((val (next-track-sample tr)))
	       (IF (fneq val (* i .05))
		   (begin
		     (close-sound ind)
		     (quit (snd-display ";read track at ~A: ~A?" i val))))))
	   (free-track-sample-reader tr)
	   (save-sound ind)
	   (IF (not (mix? (vector-ref mxs 0)))
	       (snd-display ";saved mixes not re-activated?"))
	   (close-sound ind)))))

    (let* ((ind (open-sound "oboe.snd"))
	   (open-readers (make-vector 100 #f))
	   (mix1 (mix-vct (vct 0.1 0.2 0.3) 120 ind 0 #t "origin!"))
	   (mix2 (mix-vct (vct 0.1 0.2 0.3) 1200 ind 0 #t))
	   (mix3 (mix-vct (vct 0.1 0.2 0.3) 12000 ind 0 #t))
	   (reg1 (make-region 200 300 ind 0)))
      (set! (mix-track mix1) 123)
      (set! (mix-track mix2) 123)
      (set! (mix-track mix3) 123)
      (do ((i 0 (1+ i)))
	  ((= i sample-reader-tests))
	(let* ((cur (random 4))
	       (r (random 100)))
	  (if (= cur 0)
	      (begin
		(vector-set! open-readers r (make-sample-reader (random 30000) ind 0))
		(IF (not (sample-reader? (vector-ref open-readers r))) (snd-display ";sample-reader? ~A?" (vector-ref open-readers r)))
		(next-sample (vector-ref open-readers r))
		(IF (not (equal? (list ind 0) (sample-reader-home (vector-ref open-readers r))))
		    (snd-display ";sample-reader-home ~A?" (sample-reader-home (vector-ref open-readers r)))))
	      (if (= cur 1)
		  (begin
		    (vector-set! open-readers r (make-region-sample-reader (random 90) reg1))
		    (IF (not (sample-reader? (vector-ref open-readers r))) (snd-display ";region-sample-reader? ~A?" (vector-ref open-readers r)))
		    (next-sample (vector-ref open-readers r)))
		  (if (= cur 2)
		      (begin
			(vector-set! open-readers r (make-mix-sample-reader mix1))
			(IF (not (mix-sample-reader? (vector-ref open-readers r))) (snd-display ";mix-sample-reader? ~A?" (vector-ref open-readers r)))
			(let ((val (next-mix-sample (vector-ref open-readers r))))
			  (IF (fneq val 0.1) (snd-display ";next-mix-sample: ~A" val))))
		      (begin
			(vector-set! open-readers r (make-track-sample-reader 123))
			(IF (not (track-sample-reader? (vector-ref open-readers r))) (snd-display ";track-sample-reader? ~A?" (vector-ref open-readers r)))
			(let ((val (next-track-sample (vector-ref open-readers r))))
			  (IF (fneq val 0.1) (snd-display ";next-track-sample: ~A" val)))))))
	  (if (> (random 1.0) .25)
	      (let ((rr (random 100)))
		(if (vector-ref open-readers rr)
		    (if (sample-reader? (vector-ref open-readers rr)) (free-sample-reader (vector-ref open-readers rr))
			(if (mix-sample-reader? (vector-ref open-readers rr)) (free-mix-sample-reader (vector-ref open-readers rr))
			    (if (track-sample-reader? (vector-ref open-readers rr)) (free-track-sample-reader (vector-ref open-readers rr))))))
		(vector-set! open-readers rr #f)))))
      (do ((i 0 (1+ i)))
	  ((= i 100))
	(vector-set! open-readers i #f))
      (close-sound ind)
      (gc))

    (let ((id (open-sound "oboe.snd")))
      (make-selection 1000 2000 id 0)
      (let ((mix-id (mix-selection 3000 id 0)))
	(set! (mix-amp mix-id 0) .5)
	(IF (fneq (mix-amp mix-id 0) .5)
	    (snd-display ";mix-amp .5: ~A" (mix-amp mix-id 0)))
	(scale-by .5)
	(IF (not (mix-locked mix-id))
	    (snd-display ";mix not locked? ~A" mix-id))
	(let ((var (catch #t (lambda () (set! (mix-amp mix-id 0) 1.0)) (lambda args args))))
	  (IF (not (eq? (car var) 'no-such-mix))
	      (snd-display ";set locked mix amp: ~A" var)))
	(let ((var (catch #t (lambda () (set! (mix-position mix-id) 10)) (lambda args args))))
	  (IF (not (eq? (car var) 'no-such-mix))
	      (snd-display ";set locked mix position: ~A" var)))
	(let ((var (catch #t (lambda () (set! (mix-speed mix-id) 1.5)) (lambda args args))))
	  (IF (not (eq? (car var) 'no-such-mix))
	      (snd-display ";set locked mix speed: ~A" var)))
	(let ((var (catch #t (lambda () (set! (mix-amp-env mix-id 0) '(0 0 1 1))) (lambda args args))))
	  (IF (not (eq? (car var) 'no-such-mix))
	      (snd-display ";set locked mix amp env: ~A" var)))
	(undo)
	(IF (mix-locked mix-id)
	    (snd-display ";undo locked mix: ~A" mix-id)
	    (begin
	      (set! (mix-position mix-id) 10)
	      (IF (not (= (mix-position mix-id) 10))
		  (snd-display ";mix-position 10: ~A" (mix-position mix-id)))))
	(close-sound id)))
    (set! (print-length) 30)
    (let ((index (new-sound "test.snd"))
	  (v1 (make-vct 1))
	  (v2 (make-vct 2))
	  (v3 (make-vct 3)))
      (vct-fill! v1 .1)
      (vct-fill! v2 .2)
      (vct-fill! v3 .3)
      (let ((id1 (map (lambda (start)
			(mix-vct v1 start))
		      (list 0 10 20)))
	    (id2 (map (lambda (start)
			(mix-vct v2 start))
		      (list 1 12 23)))
	    (id3 (map (lambda (start)
			(mix-vct v3 start))
		      (list 2 14 26)))
	    (trk1 (unused-track)))
	(IF (not (vequal (channel->vct)
			 (vct .1 .2 .5 .3 .3  0 0  0 0 0  
			      .1 0  .2 .2 .3 .3 .3 0 0 0
			      .1 0  0  .2 .2  0 .3 .3 .3)))
	    (snd-display ";mix tests off to a bad start: ~A" (channel->vct)))
	(IF (not (vequal (mix->vct (car id2)) (vct .2 .2)))
	    (snd-display ";mix->vct of .2: ~A" (mix->vct (car id2))))
	(for-each
	 (lambda (proc name)
	   (let ((tag (catch #t (lambda () (proc (track trk1))) (lambda args (car args)))))
	     (IF (not (eq? tag 'no-such-track)) (snd-display ";~A err: ~A" name tag))))
	 (list track-position track-end track-length track-amp track-speed)
	 (list 'track-position 'track-end 'track-length 'track-amp 'track-speed))
	(set! (mix-track (car id1)) trk1)
	(let ((tr1 (track trk1)))
	  (IF (not (equal? tr1 (list (car id1))))
	      (snd-display ";1 track->~A ~A" tr1 (car id1)))
	  (IF (not (= (track-position tr1) (mix-position (car id1))))
	      (snd-display ";1 track-position ~A ~A (~A)" tr1 (track-position tr1) (mix-position (car id1))))
	  (IF (not (= (track-length tr1) (mix-length (car id1))))
	      (snd-display ";1 track-length ~A ~A (~A)" tr1 (track-length tr1) (mix-length (car id1))))
	  (IF (not (= (track-end tr1) (+ (mix-position (car id1)) (mix-length (car id1)))))
	      (snd-display ";1 track-end ~A ~A ~A" (track-end tr1) (mix-position (car id1)) (mix-length (car id1))))
	  (IF (fneq (track-amp tr1) (mix-amp (car id1) 0))
	      (snd-display ";1 track-amp: ~A ~A" (track-amp tr1) (mix-amp (car id1) 0)))
	  (IF (fneq (track-speed tr1) (mix-speed (car id1)))
	      (snd-display ";1 track-speed: ~A ~A" (track-speed tr1) (mix-speed (car id1))))
	  (IF (not (vequal (track->vct tr1) (mix->vct (car id1))))
	      (snd-display ";1 track->vct ~A ~A" (track->vct tr1) (mix->vct (car id1))))
	  (delete-track tr1)
	  (IF (fneq (mix-amp (car id1) 0) 0.0)
	      (snd-display ";1 delete-track amp: ~A" (mix-amp (car id1) 0)))
	  (IF (not (vequal (channel->vct)
			   (vct 0 .2 .5 .3 .3  0 0  0 0 0  
				.1 0  .2 .2 .3 .3 .3 0 0 0
				.1 0  0  .2 .2  0 .3 .3 .3)))
	      (snd-display ";first mix deleted: ~A" (channel->vct)))
	  (undo)
	  (IF (fneq (mix-amp (car id1) 0) 1.0)
	      (snd-display ";1 undo delete-track amp: ~A" (mix-amp (car id1) 0)))
	  (set! (track-amp tr1) 2.0)
	  (IF (not (vequal (channel->vct)
			   (vct .2 .2 .5 .3 .3  0 0  0 0 0  
				.1 0  .2 .2 .3 .3 .3 0 0 0
				.1 0  0  .2 .2  0 .3 .3 .3)))
	      (snd-display ";1 set track-amp: ~A" (channel->vct)))
	  (set! (track-position tr1) 8)
	  (IF (not (= (track-position tr1) 8))
	      (snd-display ";moved track 1: ~A" (track-position tr1)))
	  (IF (not (vequal (channel->vct)
			   (vct 0 .2 .5 .3 .3  0 0  0 .2 0  
				.1 0  .2 .2 .3 .3 .3 0 0 0
				.1 0  0  .2 .2  0 .3 .3 .3)))
	      (snd-display ";1 set track-position 8: ~A" (channel->vct)))
	  (reverse-track tr1)
	  (IF (not (vequal (channel->vct)
			   (vct 0 .2 .5 .3 .3  0 0  0 .2 0  
				.1 0  .2 .2 .3 .3 .3 0 0 0
				.1 0  0  .2 .2  0 .3 .3 .3)))
	      (snd-display ";1 reverse track: ~A" (channel->vct)))
	  
	  (let* ((trk2 (unused-track))
		 (tr2 (make-track trk2 (list (cadr id1) (cadr id2) (cadr id3)))))
	    (IF (not (= (track-position tr2) (mix-position (cadr id1))))
		(snd-display ";2 track-position ~A ~A (~A)" tr2 (track-position tr2) (mix-position (cadr id1))))
	    (set! (track-amp tr2) 2.0)
	    (IF (not (vequal (channel->vct)
			     (vct 0 .2 .5 .3 .3  0 0  0 .2 0  
				  .2 0  .4 .4 .6 .6 .6 0 0 0
				  .1 0  0  .2 .2  0 .3 .3 .3)))
		(snd-display ";2 set track-amp: ~A" (channel->vct)))
	    (set! (track-position tr2) (- (track-position tr2) 1))
	    (IF (not (vequal (channel->vct)
			     (vct 0 .2 .5 .3 .3  0 0  0 .2 .2  
				  0 .4 .4 .6 .6 .6 0 0 0 0
				  .1 0  0  .2 .2  0 .3 .3 .3)))
		(snd-display ";2 set track-position: ~A" (channel->vct)))
	    (delete-all-tracks)
	    (IF (not (vequal (channel->vct)
			     (vct 0 .2 .5 .3 .3  0 0  0 0 0
				  0 0 0 0 0 0 0 0 0 0
				  .1 0  0  .2 .2  0 .3 .3 .3)))
		(snd-display ";2 delete-all-tracks: ~A" (channel->vct)))
	    (undo)
	    (IF (not (vequal (channel->vct)
			     (vct 0 .2 .5 .3 .3  0 0  0 .2 .2  
				  0 .4 .4 .6 .6 .6 0 0 0 0
				  .1 0  0  .2 .2  0 .3 .3 .3)))
		(snd-display ";2 undo delete-all-tracks: ~A" (channel->vct)))
	    (revert-sound index)
	    
	    (set! id1 (map (lambda (start)
			     (mix-vct v1 start))
			   (list 0 10 20)))
	    (set! id2 (map (lambda (start)
			     (mix-vct v2 start))
			   (list 1 12 23)))
	    (set! id3 (map (lambda (start)
			     (mix-vct v3 start))
			   (list 2 14 26)))
	    (IF (not (vequal (channel->vct)
			     (vct .1 .2 .5 .3 .3  0 0  0 0 0  
				  .1 0  .2 .2 .3 .3 .3 0 0 0
				  .1 0  0  .2 .2  0 .3 .3 .3)))
		(snd-display ";mix tests 2nd start: ~A" (channel->vct)))
	    (set! tr1 (make-track (unused-track) id1))
	    (set! tr2 (make-track (unused-track) id3))
	    (let ((old-pos (map mix-position tr1)))
	      (IF (not (equal? old-pos (map mix-position id1)))
		  (snd-display ";old-pos: ~A ~A" old-pos (map mix-position id1)))
	      (set-track-tempo tr1 2) ; tempo > 1 is faster
	      (IF (not (vequal (channel->vct)
			       (vct .1 .2 .5 .3 .3  .1 0  0 0 0  
				    .1 0  .2 .2 .3 .3 .3 0 0 0
				    0 0  0  .2 .2  0 .3 .3 .3)))
		  (snd-display ";3 track-tempo .5: ~A -> ~A, ~A" old-pos (map mix-position tr1) (channel->vct))))
	    (set! (track-amp tr1) 0.0)
	    (IF (not (vequal (channel->vct)
			     (vct 0 .2 .5 .3 .3  0 0  0 0 0  
				  0 0  .2 .2 .3 .3 .3 0 0 0
				  0 0  0  .2 .2  0 .3 .3 .3)))
		(snd-display ";3 track-amp 0: ~A" (channel->vct)))
	    (delete-all-mixes)
	    (IF (fneq (vct-peak (channel->vct)) 0.0)
		(snd-display "2 delete-all-mixes: ~A ~A" (vct-peak (channel->vct)) (channel->vct)))))
	
	(close-sound index)
	))

    (let* ((oboe (open-sound "oboe.snd"))
	   (orig-vals (channel->vct 0 10 oboe 0))
	   (mix-vals (vct-fill! (make-vct 10) .1))
	   (md (mix-vct mix-vals 0 oboe 0 #t))
	   (vals (channel->vct 0 10 oboe 0)))
      (IF (not (vequal vals (vct-add! (vct-copy orig-vals) mix-vals)))
	  (snd-display ";mix ~A = ~A + ~A" vals orig-vals mix-vals))
      (IF (not (equal? (edits (list md)) (list 0 0)))
	  (snd-display ";initial mix edits: ~A?" (edits (list md))))
      (scale-by 3.0 (list md))
      (let ((new-vals (channel->vct 0 10 oboe 0))
	    (old-vals (vct-add! (vct-scale! (vct-copy mix-vals) 3.0) orig-vals)))
	(IF (not (vequal new-vals old-vals))
	    (snd-display ";scale-by mix ~A: ~A ~A" md vals new-vals)))
      (IF (not (equal? (edits (list md)) (list 1 0)))
	  (snd-display ";scaled mix edits: ~A?" (edits (list md))))
      (let ((tag (catch 'no-such-edit
			(lambda ()
			  (undo 1 (list md)))
			(lambda args (car args)))))
	(IF (not (eq? tag 'no-such-edit))
	    (snd-display ";undo 1 (~A) got: ~A with ~A" md tag (edits (list md)))))
      (IF (not (equal? (edits (list md)) (list 1 0)))
	  (snd-display ";undo scaled mix edits: ~A?" (edits (list md))))
      (let ((tag (catch 'no-such-edit
			(lambda ()
			  (revert-sound (list md)))
			(lambda args (car args)))))
	(IF (not (eq? tag 'no-such-edit))
	    (snd-display ";revert-sound (~A) got: ~A with ~A" md tag (edits (list md)))))
      (IF (not (equal? (edits (list md)) (list 1 0)))
	  (snd-display ";revert scaled mix edits: ~A?" (edits (list md))))
      (undo 1 oboe)
      (IF (not (equal? (edits (list md)) (list 0 1)))
	  (snd-display ";outer undo scaled mix edits: ~A?" (edits (list md))))
      (IF (not (vequal (channel->vct 0 10 oboe 0) vals))
	  (snd-display ";undo outer mix: ~A ~A" vals (channel->vct 0 10 oboe 0)))
      (redo 1 oboe)
      (IF (not (equal? (edits (list md)) (list 1 0)))
	  (snd-display ";redo scaled mix edits: ~A?" (edits (list md))))
      (let ((new-vals (channel->vct 0 10 oboe 0))
	    (old-vals (vct-add! (vct-scale! (vct-copy mix-vals) 3.0) orig-vals)))
	(IF (not (vequal new-vals old-vals))
	    (snd-display ";redo scale-by mix ~A: ~A ~A" md vals new-vals)))
      (set! (sample 1 (list md)) .5)
      (IF (not (equal? (edits (list md)) (list 2 0)))
	  (snd-display ";set .5 mix edits: ~A?" (edits (list md))))
      (let ((new-vals (channel->vct 0 10 oboe 0))
	    (old-vals (vct-add! (vct-scale! (vct-copy mix-vals) 3.0) orig-vals)))
	(vct-set! old-vals 1 .5)
	(IF (not (vequal new-vals old-vals))
	    (snd-display ";set 1 to .5 mix ~A: ~A ~A" md vals new-vals)))
      (scale-by .5)
      (IF (not (equal? (edits (list md)) (list 2 0)))
	  (snd-display ";outer scale set .5 mix edits: ~A?" (edits (list md))))
      (revert-sound)
      (redo)
      (IF (not (equal? (edits (list md)) (list 0 2)))
	  (snd-display ";revert outer mix edits: ~A?" (edits (list md))))
      (scale-by 3.0 (list md))
      (let ((new-vals (channel->vct 0 10 oboe 0))
	    (old-vals (vct-add! (vct-scale! (vct-copy mix-vals) 3.0) orig-vals)))
	(IF (not (vequal new-vals old-vals))
	    (snd-display ";3rd scale-by mix ~A: ~A ~A" md vals new-vals)))
      (IF (not (equal? (edits (list md)) (list 1 0)))
	  (snd-display ";3rd scaled mix edits: ~A?" (edits (list md))))
      (scale-by 3.0 (list md))
      (let ((new-vals (channel->vct 0 10 oboe 0))
	    (old-vals (vct-add! (vct-scale! (vct-copy mix-vals) 9.0) orig-vals)))
	(IF (not (vequal new-vals old-vals))
	    (snd-display ";4th scale-by mix ~A: ~A ~A" md vals new-vals)))
      (IF (not (equal? (edits (list md)) (list 2 0)))
	  (snd-display ";4th scaled mix edits: ~A?" (edits (list md))))
      (if (mix? md) (set! (mix-length md) 4))
      (close-sound oboe)
      )

    ))

(clear-sincs)

(define data-max
  (lambda (beg end)
    (let ((maxval 0.0))
      (apply for-each 
	     (lambda (snd chn)
	       (scan-chan (lambda (n)
			    (set! maxval (max maxval (abs n))))
			     0 #f snd chn))
	     (all-chans))
      maxval)))

(define data-max2
  (lambda (beg end snd)
    (let ((maxval 0.0))
      (do ((i 0 (1+ i)))
	  ((= i (chans snd)) maxval)
	(scan-chan (lambda (n)
		     (set! maxval (max maxval (abs n))))
		   0 #f snd i)))))

(define data-max1
  (lambda (beg end snd chn)
    (let ((maxval 0.0))
      (scan-chan 
       (lambda (data)
	 (let ((curval (abs data)))
	   (if (> curval maxval) (set! maxval curval))
	   #f))
       beg end snd chn)
      maxval)))

(load "marks.scm")


;;; ---------------- test 10: marks ----------------
(if (or full-test (= snd-test 10) (and keep-going (<= snd-test 10)))
    (do ((test-ctr 0 (1+ test-ctr)))
	((= test-ctr tests))
      (let ((ind0 (view-sound "oboe.snd"))
	    (ind1 (view-sound "pistol.snd"))
	    (v0 (make-vct 100))
	    (vc (make-vector 10)))
	(if (procedure? test-hook) (test-hook 10))
	(log-mem test-ctr)
	(vct-fill! v0 .1)
	(vector-set! vc 0 (mix-vct v0 0 ind0))
	(vector-set! vc 1 (mix-vct v0 1000 ind0))
	(vector-set! vc 2 (mix-vct v0 2000 ind0))
	(vector-set! vc 3 (mix-vct v0 3000 ind0))
	(vector-set! vc 4 (mix-vct v0 4000 ind0))
	(vector-set! vc 5 (mix-vct v0 0 ind1))
	(vector-set! vc 6 (mix-vct v0 1000 ind1))
	(vector-set! vc 7 (mix-vct v0 2000 ind1))
	(vector-set! vc 8 (mix-vct v0 3000 ind1))
	(vector-set! vc 9 (mix-vct v0 4000 ind1))
	(let ((t0 (make-track 1 (list (vector-ref vc 0) (vector-ref vc 3) (vector-ref vc 5))))
	      (t1 (make-track 2 (list (vector-ref vc 2) (vector-ref vc 6) (vector-ref vc 8)))))
	  (set-track-amp t0 .5)
	  (time (transpose-track t1 3))
	  (set-track-color t1 (make-color 0 0 1))
	  (let ((t0e (track-end t0)))
	    (set-track-position t0 1000)
	    (IF (not (= (track-position t0) 1000)) (snd-display ";track-position: ~A?" (track-position t0)))
	    (IF (not (= (track-end t0) (+ t0e 1000))) (snd-display ";track-end: ~A ~A?" t0e (track-end t0))))
	  (IF (not (= (track-length t0) 3100)) (snd-display ";track-length: ~A?" (track-length t0)))
	  (set-track-tempo t0 2.0)
	  (if (not (provided? 'snd-nogui))
	      (let ((col (color->list (track-color t1))))
		(IF (or (fneq (car col) 0.0) (fneq (cadr col) 0.0) (fneq (caddr col) 1.0))
		    (snd-display ";track-color: ~A?" col))))
	  (IF (not (= (track-length t0) 1600)) (snd-display ";track-tempo -> length: ~A?" (track-length t0))))
	(close-sound ind0)
	(close-sound ind1)
	(set! ind0 (new-sound "fmv.snd" mus-aifc mus-bshort 22050 1 "this is a comment"))
	(let ((v0 (make-vector 10)))
	  (do ((i 0 (1+ i))) ((= i 10)) (vector-set! v0 i 1.0))
	  (insert-samples 0 10 v0 ind0) 
	  (time (env-sound '(0 0 1 1) 0 10 1.0 ind0))
	  (do ((i 0 (1+ i))) ((= i 10)) (IF (fneq (sample i) (* i .1)) (snd-display ";1 env-sound[~D]: ~A?" i (sample i))))
	  (undo) 
	  (env-sound (make-env '(0 0 1 1) :end 9) 0 10 1.0 ind0) 
	  (do ((i 0 (1+ i))) ((= i 10)) (IF (fneq (sample i) (* i .1)) (snd-display ";2 env-sound[~D]: ~A?" i (sample i))))
	  (undo) 
	  (env-sound '(0 0 .5 1 1 1) 0 10 0.0 ind0) 
	  (IF (or (fneq (sample 3) 0.0) (fneq (sample 8) 1.0) )
	      (snd-display ";env-sound stepped: ~A ~A?" (sample 3) (sample 8)))
	  (undo) 
	  (env-sound '(0 0 1 1) 0 10 32.0 ind0) 
	  (IF (or (fneq (sample 3) 0.0589) (fneq (sample 8) 0.484) )
	      (snd-display ";env-sound exp: ~A ~A?" (sample 3) (sample 8)))
	  (undo) 
	  (env-sound (make-env '(0 0 1 1) :base 32.0 :end 9) 0 10 32.0 ind0) 
	  (IF (or (fneq (sample 3) 0.0589) (fneq (sample 8) 0.484) )
	      (snd-display ";env-sound exp: ~A ~A?" (sample 3) (sample 8)))
	  (undo)
	  (env-sound '(0 2))
	  (do ((i 0 (1+ i))) ((= i 10)) (IF (fneq (sample i) 2.0) (snd-display ";3 env-sound[~D]: ~A?" i (sample i))))
	  (undo)
	  (env-sound '(0 2) 2 4 1.0 ind0)
	  (IF (or (fneq (sample 1) 1.0) (fneq (sample 2) 2.0) (fneq (sample 5) 2.0) (fneq (sample 8) 1.0))
	      (snd-display ";3 env-sound exp: ~A ~A ~A ~A?" (sample 1) (sample 2) (sample 5) (sample 8)))
	  (undo) 
	  (do ((i 1 (1+ i))) ((= i 10)) (set! (sample i) 0.0))
	  (filter-sound '(0 1 1 0) 4)
	  (IF (or (fneq (sample 1) 0.3678) (fneq (sample 2) .3678) (fneq (sample 3) .132) (fneq (sample 4) 0.0))
	      (snd-display ";filter-sound env: ~A?" (samples 0 8)))
	  (undo)
	  (filter-sound '(0 1 1 0) 1024)
	  (undo)
	  (filter-sound (make-fir-filter 6 (list->vct '(.1 .2 .3 .3 .2 .1))))
	  (undo)
	  (filter-sound (make-delay 120))
	  (undo)
	  (filter-sound (make-formant .99 1200))
	  (undo)
	  (let ((vc0 (make-vct 4)))
	    (vct-set! vc0 0 .125) (vct-set! vc0 1 .25) (vct-set! vc0 2 .25) (vct-set! vc0 3 .125) 
	    (filter-sound vc0 4) 
	    (IF (or (fneq (sample 0) 0.125) (fneq (sample 1) .25) (fneq (sample 2) .25) (fneq (sample 5) 0.0))
		(snd-display ";filter-sound direct: ~A?" (samples 0 8)))
	    (revert-sound)))
	(close-sound ind0)

	(set! ind0 (new-sound "fmv.snd" mus-aifc mus-bshort 22050 2 "this is a comment"))
	(let ((v0 (make-vector 10))
	      (ind1 (new-sound "fmv1.snd" mus-aifc mus-bshort 22050 1 "this is a comment")))
	  (set! (sync ind0) 123)
	  (set! (sync ind1) 123)
	  (do ((i 0 (1+ i))) ((= i 10)) (vector-set! v0 i 1.0))
	  (insert-samples 0 10 v0 ind0 0)
	  (insert-samples 0 10 v0 ind0 1)
	  (insert-samples 0 10 v0 ind1 0)
	  (env-sound '(0 0 1 1) 0 10 1.0 ind0)
	  (do ((i 0 (1+ i))) 
	      ((= i 10)) 
	    (IF (fneq (sample i ind0 0) (* i .1)) (snd-display ";ind0:0 1 env-sound[~D]: ~A?" i (sample i ind0 0)))
	    (IF (fneq (sample i ind0 1) (* i .1)) (snd-display ";ind0:1 1 env-sound[~D]: ~A?" i (sample i ind0 1)))
	    (IF (fneq (sample i ind1 0) (* i .1)) (snd-display ";ind1:0 1 env-sound[~D]: ~A?" i (sample i ind1 0))))
	  (undo) 
	  (env-sound (make-env '(0 0 1 1) :end 9) 0 10 1.0 ind0) 
	  (do ((i 0 (1+ i))) 
	      ((= i 10)) 
	    (IF (fneq (sample i ind0 0) (* i .1)) (snd-display ";ind0:0 2 env-sound[~D]: ~A?" i (sample i ind0 0)))
	    (IF (fneq (sample i ind0 1) (* i .1)) (snd-display ";ind0:1 2 env-sound[~D]: ~A?" i (sample i ind0 1)))
	    (IF (fneq (sample i ind1 0) (* i .1)) (snd-display ";ind1:0 2 env-sound[~D]: ~A?" i (sample i ind1 0))))
	  (undo) 
	  (env-sound '(0 0 .5 1 1 1) 0 10 0.0 ind0) 
	  (IF (or (fneq (sample 3 ind0 0) 0.0) (fneq (sample 8 ind0 0) 1.0) ) 
	      (snd-display ";ind0:0 env-sound stepped: ~A ~A?" (sample 3 ind0 0) (sample 8 ind0 0)))
	  (IF (or (fneq (sample 3 ind0 1) 0.0) (fneq (sample 8 ind0 1) 1.0) ) 
	      (snd-display ";ind0:1 env-sound stepped: ~A ~A?" (sample 3 ind0 1) (sample 8 ind0 1)))
	  (IF (or (fneq (sample 3 ind1 0) 0.0) (fneq (sample 8 ind1 0) 1.0) ) 
	      (snd-display ";ind1:0 env-sound stepped: ~A ~A?" (sample 3 ind1 0) (sample 8 ind1 0)))
	  (undo)
	  (set! (graph-style ind1 0) graph-lollipops)
	  (graph->ps "aaa.eps")
	  (set! (graph-transform? ind1 0) #t)
	  (set! (transform-graph-type ind1 0) graph-transform-as-sonogram)
	  (update-transform)
	  (let ((size (transform-samples-size ind1 0)))
	    (IF (or (number? size)
		    (not (= (length size) 3)))
		(snd-display ";transform-samples-size of sonogram: ~A" size)))
	  (graph->ps "aaa.eps")

	  (revert-sound ind0)
	  (revert-sound ind1)
	  (insert-samples 0 10 v0 ind0 0)
	  (insert-samples 0 10 v0 ind0 1)
	  (insert-samples 0 10 v0 ind1 0)
	  (filter-sound (make-one-zero :a0 0.5 :a1 0.0) 0 ind0)
	  (do ((i 0 (1+ i))) 
	      ((= i 10)) 
	    (IF (fneq (sample i ind0 0) 0.5) (snd-display ";ind0:0 1 filter-sound[~D]: ~A?" i (sample i ind0 0)))
	    (IF (fneq (sample i ind0 1) 0.5) (snd-display ";ind0:1 1 filter-sound[~D]: ~A?" i (sample i ind0 1)))
	    (IF (fneq (sample i ind1 0) 0.5) (snd-display ";ind1:0 1 filter-sound[~D]: ~A?" i (sample i ind1 0))))

	  (close-sound ind1))
	(close-sound ind0)

	(set! ind0 (new-sound "fmv.snd" mus-aifc mus-bshort 22050 1 "this is a comment"))
	(let ((v0 (make-vct 10))
	      (old5 (sample 5 ind0)))
	  (vct-fill! v0 0.1)
	  (insert-samples 10 10 v0 ind0)
	  (env-sound '(0 0 1 2) 10 10 1.0 ind0)
	  (do ((i 0 (1+ i))) ((= i 10)) 
	    (IF (fneq (sample (+ i 10) ind0) (* i .02)) (snd-display ";env-sound [~D]: ~A?" (+ i 10) (sample (+ i 10) ind0))))
	  (IF (fneq (sample 5 ind0) old5) (snd-display ";env-sound 5: ~A ~A?" old5 (sample 5 ind0)))
	  (undo)
	  (env-sound '(0 0 1 2) 10 10 4.0 ind0)
	  (set! v0 (samples->vct 10 10))
	  (IF (or (fneq (vct-ref v0 3) 0.034) (fneq (vct-ref v0 8) .135)) (snd-display ";env-sound 4: ~A" v0))
	  (undo)
	  (env-sound '(0 0 1 2) 10 10 .05 ind0)
	  (set! v0 (samples->vct 10 10))
	  (IF (or (fneq (vct-ref v0 3) 0.125) (fneq (vct-ref v0 8) .191)) (snd-display ";env-sound 05: ~A" v0)))
	
	(close-sound ind0)
	(set! ind0 (new-sound "fmv.snd" mus-aifc mus-bshort 22050 2 "this is a comment"))
	(set! ind1 (new-sound "fmv1.snd" mus-next mus-bshort 22050 1 "this is a comment"))
	(let ((v0 (make-vector 10)))
	  (do ((i 0 (1+ i))) ((= i 10)) (vector-set! v0 i 1.0))
	  (insert-samples 0 10 v0 ind0 0) 
	  (do ((i 0 (1+ i))) ((= i 10)) (vector-set! v0 i 0.1))
	  (insert-samples 0 10 v0 ind0 1) 
	  (do ((i 0 (1+ i))) ((= i 10)) (vector-set! v0 i 0.01))
	  (insert-samples 0 10 v0 ind1 0) 
	  (let ((val (data-max1 0 9 ind0 0)))
	    (IF (fneq val 1.0) (snd-display ";scan-chan[0,0]: ~A?" val)))
	  (let ((val (data-max1 0 9 ind0 1)))
	    (IF (fneq val 0.1) (snd-display ";scan-chan[0,1]: ~A?" val)))
	  (let ((val (data-max1 0 9 ind1 0)))
	    (IF (fneq val 0.01) (snd-display ";scan-chan[1,0]: ~A?" val)))
	  (let ((val (data-max1 0 9 #f #f)))
	    (IF (fneq val 0.01) (snd-display ";scan-chans: ~A?" val)))
	  (let ((val (data-max 0 9)))
	    (IF (fneq val 1.0) (snd-display ";scan-all-chans: ~A?" val)))
	  (let ((val (data-max2 0 9 ind0)))
	    (IF (fneq val 1.0) (snd-display ";scan-across-sound-chans: ~A?" val))))
	(close-sound ind0)
	(close-sound ind1)

	(set! ind0 (new-sound "fmv.snd" mus-aifc mus-bshort 22050 2 "this is a comment"))
	(mix "oboe.snd")
	(let ((m1 (add-mark 100)))
	  (delete-sample 10)
	  (let ((m2 (add-mark 200)))
	    (delete-sample 10)
	    (let ((m3 (add-mark 300)))
	      (undo)
	      (save-sound)
	      (IF (not (= (length (marks ind0 0)) 2))
		  (snd-display ";marks after save: ~A" (marks ind0 0)))
	      (IF (or (not (mark? m1))
		      (not (= (mark-sample m1) 99)))
		  (snd-display ";save-sound mark1: ~A" (mark-sample m1)))
	      (IF (or (not (mark? m2))
		      (not (= (mark-sample m2) 200)))
		  (snd-display ";save-sound mark2: ~A" (mark-sample m2)))
	      (IF (mark? m3) (snd-display ";save-sound mark3: ~A" m3)))))
	(close-sound ind0)

	(let ((fd (open-sound "oboe.snd"))
	      (m1 (add-mark 123))
	      (sync-val (+ 1 (mark-sync-max))))
	  (IF (not (mark? m1)) (snd-display ";mark?"))
	  (IF (not (= (mark-sample m1) 123)) (snd-display ";add-mark: ~A? " (mark-sample m1)))
	  (if (not (eq? (without-errors (mark-sample 12345678)) 'no-such-mark)) (snd-display ";mark-sample err: ~A?" (mark-sample 12345678)))
	  (if (not (eq? (without-errors (add-mark 123 123)) 'no-such-sound)) (snd-display ";add-mark err: ~A?" (add-mark 123 123)))
	  (let ((m2 (without-errors (add-mark 12345 fd 0))))
	    (IF (eq? m2 'no-such-mark) (snd-display ";add-mark failed?"))
	    (IF (not (= (mark-sample m2) 12345)) (snd-display ";add-mark 0 0: ~A?" (mark-sample m2)))
	    (IF (not (= (mark-sync m2) 0)) (snd-display ";init mark-sync: ~A?" (mark-sync m2)))
	    (set! (mark-sync m2) sync-val)
	    (IF (not (= (mark-sync m2) sync-val)) (snd-display ";set-mark-sync (~A): ~A?" sync-val (mark-sync m2)))
	    (let* ((syncs (syncd-marks sync-val))
		   (chans (marks fd 0))
		   (samps (map mark-sample chans)))
	      (IF (not (equal? syncs (list m2))) (snd-display ";syncd-marks: ~A?" syncs))
	      (IF (not (equal? chans (list m1 m2))) (snd-display ";marks: ~A?" chans))
	      (IF (not (equal? samps (list (mark-sample m1) (mark-sample m2)))) (snd-display ";map samps: ~A?" samps))
	      (delete-samples 200 100 fd 0)
	      (set! chans (marks fd))
	      (set! samps (map mark-sample (car chans)))
	      (IF (not (equal? samps (list (mark-sample m1 0) (- (mark-sample m2 0) 100)))) (snd-display ";map samps: ~A?" samps))
	      (let ((descr (describe-mark m2)))
		(IF (not (equal? descr (list (list 'mark m2 'sound fd "oboe.snd" 'channel 0) 12345 12245)))
		    (snd-display ";describe-mark: ~A?" descr)))
	      (set! (mark-sync m1) (mark-sync m2))
	      (move-syncd-marks sync-val 100)
	      (set! chans (marks fd))
	      (set! samps (map mark-sample (car chans)))
	      (IF (not (equal? samps (list (+ (mark-sample m1 0) 100) (mark-sample m2 0)))) (snd-display ";syncd move samps: ~A?" samps))
	      (set! (cursor) 500)
	      (backward-mark)
	      (IF (not (= (cursor) (mark-sample m1))) (snd-display ";backward-mark: ~A?" (cursor)))
	      (forward-mark 1)
	      (IF (not (= (cursor) (mark-sample m2))) (snd-display ";forward-mark: ~A?" (cursor)))
	      (delete-mark m1)
	      (set! chans (marks fd 0))
	      (IF (not (equal? chans (list m2))) (snd-display ";delete-mark? ~A" chans))
	      (undo)
	      (set! chans (marks fd 0))
	      (IF (not (equal? chans (list m1 m2))) (snd-display ";delete-mark then undo? ~A" chans))
	      (redo)
	      (IF (not (string=? (mark-name m2) "")) (snd-display ";init mark-name: ~A?" (mark-name m2)))
	      (set! (mark-name m2) "hiho!")
	      (IF (not (string=? (mark-name m2) "hiho!")) (snd-display ";set-mark-name: ~A?" (mark-name m2)))
	      (undo)
	      (IF (not (string=? (mark-name m2) "")) (snd-display ";undo mark-name: ~A?" (mark-name m2)))
	      (redo)
	      (IF (not (string=? (mark-name m2) "hiho!")) (snd-display ";redo mark-name: ~A?" (mark-name m2)))
	      (let ((m3 (find-mark "hiho!"))
		    (m4 (find-mark (mark-sample m2)))
		    (m5 (find-mark "not-a-mark"))
		    (m6 (find-mark 123456787))
		    (m7 (mark-name->id "hiho!"))
		    (m8 (add-mark -123))
		    (m9 (add-mark (* 2 (frames)))))
		(IF (not (eq? m2 m3 m4 m7)) (snd-display ";find-mark: ~A ~A ~A ~A?" m2 m3 m4 m7))
		(IF (not (eq? m5 m6 #f)) (snd-display ";find-not-a-mark: ~A ~A?" m5 m6))
		(IF (not (eq? m8 #f)) (snd-display ";add-mark -123 -> ~A" m8))
		(IF (not (eq? m9 #f)) (snd-display ";add-mark ~A -> ~A" (* 2 (frames)) m9))
		(set! (mark-sample m2) 2000)
		(set! m1 (add-mark 1000))
		(set! m3 (add-mark 3000))
		(set! m4 (add-mark 4000))
		(insert-samples 2500 500 (make-vct 500) fd 0)
		(set! samps (map mark-sample (marks fd 0)))
		(IF (not (equal? samps '(1000 2000 3500 4500))) (snd-display ";insert ripple: ~A?" samps))
		(set! (mark-sample m3) 300)
		(set! (cursor) 500)
		(backward-mark)
		(IF (not (= (cursor) 300)) (snd-display ";sort marks: ~A?" (cursor)))
		(IF (not (equal? (mark-home m2) (list fd 0))) (snd-display ";mark-home: ~A?" (mark-home m2)))
		(let ((sd (open-sound "4.aiff")))
		  (set! m3 (add-mark 1000 sd 2))
		  (set! m4 (add-mark 1000 sd 3))
		  (IF (not (equal? (mark-home m3) (list sd 2))) (snd-display ";marks->sound 4: ~A?" (mark-home m3)))
		  (close-sound sd))
		(let ((file (save-marks fd)))
		  (IF (or (not file)
			  (not (string=? file (string-append home-dir "/bil/cl/oboe.marks"))))
		      (snd-display ";save-marks -> ~A?" file)))
		(close-sound fd)
		(let ((fd (open-sound "pistol.snd")))
		  (let ((file (save-marks)))
		    (IF file
			(snd-display ";save-marks no marks -> ~A?" file)))
		  (close-sound fd))
		(let ((fd (open-sound "oboe.snd")))
		  (load "oboe.marks")
		  (let ((mlst (marks fd 0)))
		    (IF (not (= (length mlst) 2)) (snd-display ";restore-marks: ~A?" mlst))
		    (IF (or (not (= (mark-sample (car mlst)) 123))
			    (not (= (mark-sample (cadr mlst)) 12345)))
			(snd-display ";restored-marks: ~D ~D?" (mark-sample (car mlst)) (mark-sample (cadr mlst)))))
		  (close-sound fd))
		(let ((fd (open-sound "4.aiff")))
		  (let ((m1 (add-mark 1000 fd 0))
			(m2 (add-mark 2000 fd 1))
			(m3 (add-mark 3000 fd 2))
			(m4 (add-mark 4000 fd 3)))
		    (save-marks fd)
		    (close-sound fd)
		    (set! fd (open-sound "4.aiff"))
		    (load "4.marks")
		    (delete-file "4.marks")
		    (do ((i 0 (1+ i)))
			((= i 4))
		      (let ((mlst (marks fd i)))
			(IF (not (= (length mlst) 1))
			    (snd-display ";save-marks[~A]: ~A?" i mlst))
			(IF (not (= (mark-sample (car mlst)) (* (+ i 1) 1000)))
			    (snd-display ";save-marks[~A] at ~A?" i (mark-sample (car mlst))))))
		    (close-sound fd)))
		
		))))

	(let* ((ind (open-sound "pistol.snd"))
	       (samp1 1834)
	       (samp2 8345)
	       (m1 (add-mark samp1 ind 0))
	       (m2 (add-mark samp2)))
	  (src-sound -1)
	  (IF (not (= (mark-sample m1) 39788))
	      (snd-display ";src -1 m1 -> ~A" (mark-sample m1)))
	  (IF (not (= (mark-sample m2) 33277))
	      (snd-display ";src -1 m2 -> ~A" (mark-sample m2)))
	  (undo)
	  (src-sound .5)
	  (IF (not (= (mark-sample m1) (* 2 samp1)))
	      (snd-display ";src .5 m1 -> ~A" (mark-sample m1)))
	  (IF (not (= (mark-sample m2) (* 2 samp2)))
	      (snd-display ";src .5 m2 -> ~A" (mark-sample m2)))
	  (undo)
	  (delete-samples 1000 100)
	  (IF (not (= (mark-sample m1) (- samp1 100)))
	      (snd-display ";delete 100 m1 -> ~A" (mark-sample m1)))
	  (insert-silence 1000 100)
	  (IF (not (= (mark-sample m1) samp1))
	      (snd-display ";insert 100 m1 -> ~A" (mark-sample m1)))
	  (revert-sound ind)
	  (delete-samples 2000 100)
	  (IF (not (= (mark-sample m1) samp1))
	      (snd-display ";delete(2) 100 m1 -> ~A" (mark-sample m1)))
	  (IF (not (= (mark-sample m2) (- samp2 100)))
	      (snd-display ";delete(2) 100 m2 -> ~A" (mark-sample m2)))
	  (insert-silence 2000 100)
	  (IF (not (= (mark-sample m1) samp1))
	      (snd-display ";insert(2) 100 m1 -> ~A" (mark-sample m1)))
	  (IF (not (= (mark-sample m2) samp2))
	      (snd-display ";insert(2) 100 m2 -> ~A" (mark-sample m2)))
	  (revert-sound ind)
	  (delete-samples 10000 100)
	  (IF (not (= (mark-sample m1) samp1))
	      (snd-display ";delete(3) 100 m1 -> ~A" (mark-sample m1)))
	  (IF (not (= (mark-sample m2) samp2))
	      (snd-display ";delete(3) 100 m2 -> ~A" (mark-sample m2)))
	  (insert-silence 10000 100)
	  (IF (not (= (mark-sample m1) samp1))
	      (snd-display ";insert(3) 100 m1 -> ~A" (mark-sample m1)))
	  (IF (not (= (mark-sample m2) samp2))
	      (snd-display ";insert(3) 100 m2 -> ~A" (mark-sample m2)))
	  (src-sound '(0 .5 1 .5 2 1))
	  (IF (not (= (mark-sample m1) (* 2 samp1)))
	      (snd-display ";src env .5 m1 -> ~A" (mark-sample m1)))
	  (IF (not (= (mark-sample m2) (* 2 samp2)))
	      (snd-display ";src env .5 m2 -> ~A" (mark-sample m2)))
	  (undo)
	  (reverse-sound)
	  (IF (not (= (mark-sample m1) 39788))
	      (snd-display ";reverse-sound m1 -> ~A" (mark-sample m1)))
	  (IF (not (= (mark-sample m2) 33277))
	      (snd-display ";reverse-sound m2 -> ~A" (mark-sample m2)))
	  (undo)
	  (src-sound '(0 -.5 1 -.5 2 -1))
	  (IF (not (= (mark-sample m1) 68599))
	      (snd-display ";src -env m1 -> ~A" (mark-sample m1)))
	  (IF (not (= (mark-sample m2) 61160))
	      (snd-display ";src -env m2 -> ~A" (mark-sample m2)))
	  (revert-sound ind)
	  (src-channel (make-env '(0 .5 1 1) :end 8000) 2000 10000)
	  (IF (not (= (mark-sample m1) samp1))
	      (snd-display ";src-channel(1) m1 -> ~A" (mark-sample m1)))
	  (IF (not (= (mark-sample m2) 11345))
	      (snd-display ";src-channel(1) m2 -> ~A" (mark-sample m2)))
	  (undo)
	  (src-channel (make-env '(0 .5 1 1) :end 8000) 0 8000)
	  (IF (not (= (mark-sample m1) 3304))
	      (snd-display ";src-channel(2) m1 -> ~A" (mark-sample m1)))
	  (IF (not (= (mark-sample m2) samp2))
	      (snd-display ";src-channel(2) m2 -> ~A" (mark-sample m2)))
	  (undo)
	  (src-channel (make-env '(0 .5 1 1) :end 8000) 10000 8000)
	  (IF (not (= (mark-sample m1) samp1))
	      (snd-display ";src-channel(3) m1 -> ~A" (mark-sample m1)))
	  (IF (not (= (mark-sample m2) samp2))
	      (snd-display ";src-channel(3) m2 -> ~A" (mark-sample m2)))
	  (close-sound ind)
	  (set! ind (open-sound "2.snd"))
	  (set! (sync ind) #t)
	  (let ((m3 (add-mark 1000 ind 0))
		(m4 (add-mark 8000 ind 1)))
	    (swap-channels)
	    (IF (or (not (equal? (mark-home m3) (list ind 1)))
		    (not (equal? (mark-home m4) (list ind 0))))
		(snd-display ";swapped mark homes: ~A ~A?" (mark-home m3) (mark-home m4)))
	    (IF (or (not (= (mark-sample m3) 1000))
		    (not (= (mark-sample m4) 8000)))
		(snd-display ";swapped mark samples: ~A ~A?" (mark-sample m3) (mark-sample m4)))
	    (close-sound ind))
	  (set! ind (open-sound "2.snd"))
	  (set! (sync ind) #t)
	  (let ((m3 (add-mark 1000 ind 0)))
	    (delete-samples 1000 10 ind 1)
	    (swap-channels)
	    (IF (not (equal? (mark-home m3) (list ind 1)))
		(snd-display ";edited swapped mark home: ~A?" (mark-home m3)))
	    (IF (not (= (mark-sample m3) 1000))
		(snd-display ";edited swapped mark sample: ~A" (mark-sample m3)))
	    (delete-marks))
	  (close-sound ind))

	(let* ((ind (open-sound "oboe.snd"))
	       (m1 (add-mark 123 ind 0))
	       (m2 (add-mark 234 ind 0)))
	  (define-selection-via-marks m1 m2)
	  (IF (not (selection?))
	      (snd-display ";define-selection-via-marks failed?")
	      (let ((mc (selection-members)))
		(IF (not (equal? mc (list (list ind 0)))) (snd-display ";selection-members after mark definition: ~A (should be '((~A 0)))" mc ind))
		(IF (not (= (selection-position) 123)) (snd-display ";selection-position 123: ~A" (selection-position)))
		(IF (not (= (selection-length) 112)) (snd-display ";selection-length 112: ~A" (selection-length)))))
	  (set! m1 (add-mark 1000 ind 0))
	  (set! m2 (add-mark 2000 ind 0))
	  (define-selection-via-marks m1 m2)
	  (IF (not (selection?))
	      (snd-display ";define-selection-via-marks repeat failed?")
	      (let ((mc (selection-members)))
		(IF (not (equal? mc (list (list ind 0)))) (snd-display ";selection-members after 2nd mark definition: ~A (should be '((~A 0)))" mc ind))
		(IF (not (= (selection-position) 1000)) (snd-display ";selection-position 1000: ~A" (selection-position)))
		(IF (not (= (selection-length) 1001)) (snd-display ";selection-length 1001: ~A" (selection-length)))))
	  (set! (selection-member? #t) #f)
	  (IF (selection?) (snd-display ";can't clear selection via selection-member?"))
	  (set! (selection-member? ind 0) #t)
	  (set! (selection-position ind 0) 2000)
	  (set! (selection-length ind 0) 1234)
	  (snap-marks)
	  (set! m1 (find-mark 2000 ind 0))
	  (IF (not (mark? m1)) (snd-display ";snap-marks start: ~A" (map mark-sample (marks ind 0))))
	  (set! m2 (find-mark (+ 2000 1234)))
	  (IF (not (mark? m2)) (snd-display ";snap-marks end: ~A" (map mark-sample (marks ind 0))))
	  (close-sound ind)
	  )

	(let ((ind (open-sound "oboe.snd"))
	      (mtests 100))
	  (do ((i 0 (1+ i)))
	      ((= i mtests))
	    (let* ((current-marks (marks ind 0))
		   (current-samples (map mark-sample current-marks)))
	      (case (irandom 15)
		((0) (let* ((beg (irandom (frames)))
			    (dur (max 1 (irandom 100)))
			    (end (+ beg dur)))
		       (insert-silence beg dur)
		       (if (not (null? current-marks))
			   (for-each
			    (lambda (id old-loc)
			      (if (> old-loc beg)
				  (begin
				    (IF (not (mark? id))
					(snd-display ";insert clobbered mark: ~A" id)
					(IF (not (= (mark-sample id) (+ old-loc dur)))
					    (snd-display ";insert, mark ~D ~D -> ~D (~D)" id old-loc (mark-sample id) dur))))))
			    current-marks
			    current-samples))))
		((1) (IF (> (car (edits ind 0)) 0) (undo)))
		((2) (IF (> (cadr (edits ind 0)) 0) (redo)))
		((3) (IF (> (maxamp ind 0) .1) (scale-channel .5) (scale-channel 2.0))
		     (IF (not (equal? (marks ind 0) current-marks))
			 (snd-display ";scaling changed marks: ~A ~A" (marks ind 0) current-marks))
		     (IF (not (equal? (map mark-sample (marks ind 0)) current-samples))
			 (snd-display ";scaling changed mark locations: ~A ~A" (map mark-sample (marks ind 0)) current-samples)))
		((4) (set! (sample (irandom (1- (frames)))) .5)
		     (IF (not (equal? (marks ind 0) current-marks))
			 (snd-display ";set-sample changed marks: ~A ~A" (marks ind 0) current-marks))
		     (IF (not (equal? (map mark-sample (marks ind 0)) current-samples))
			 (snd-display ";set-sample changed mark locations: ~A ~A" (map mark-sample (marks ind 0)) current-samples)))
		((5) (let* ((beg (irandom (frames)))
			    (dur (max 1 (irandom 100)))
			    (end (+ beg dur)))
		       (delete-samples beg dur)
		       (if (not (null? current-marks))
			   (for-each
			    (lambda (id old-loc)
			      (if (and (> old-loc beg)
				       (< old-loc end)
				       (mark? id))
				  (snd-display ";delete did not clobber mark: ~A ~A [~A ~A]" id old-loc beg end)
				  (IF (and (> old-loc end)
					   (not (= (mark-sample id) (- old-loc dur))))
				      (snd-display ";delete ripple mark ~D ~D -> ~D (~D)" id old-loc (mark-sample id) dur)
				      (IF (and (< old-loc beg)
					       (not (= (mark-sample id) old-loc)))
					  (snd-display ";delete but mark before: ~A ~A ~A ~A" id old-loc (mark-sample id) beg)))))
			    current-marks
			    current-samples))))
		((6) (revert-sound))
		((7) (if (and (not (null? current-marks))
			      (> (length current-marks) 1))
			 (let ((id (list-ref current-marks (irandom (- (length current-marks) 1)))))
			   (delete-mark id)
			   (IF (mark? id)
			       (snd-display ";delete-mark failed? ~A" id))
			   (IF (not (= (length (marks ind 0)) (1- (length current-marks))))
			       (snd-display "delete-mark list trouble: ~A ~A ~A" id current-marks (marks ind 0))))))
		((8) (let ((rate (if (> (frames) 200000) 2.0 0.5)))
		       (src-channel rate)
		       (if (not (null? current-marks))
			   (for-each
			    (lambda (id old-loc)
			      (IF (not (mark? id))
				  (snd-display ";src-channel clobbered mark: ~A" id)
				  (IF (> (abs (- (/ old-loc rate) (mark-sample id))) 2)
				      (snd-display "src moved mark: ~A ~A ~A (~A -> ~A)" 
						   id old-loc (mark-sample id) rate (- (/ old-loc rate) (mark-sample id))))))
			    current-marks
			    current-samples))))
		((9) (reverse-channel)
		     (if (not (null? current-marks))
			 (for-each
			  (lambda (id old-loc)
			    (IF (not (mark? id))
				(snd-display ";reverse-channel clobbered mark: ~A" id)
				(IF (> (abs (- (- (frames) old-loc) (mark-sample id))) 2)
				    (snd-display "reverse moved mark: ~A ~A ~A (~A)" 
						 id old-loc (- (frames) old-loc) (mark-sample id)))))
			  current-marks
			  current-samples)))
		(else (add-mark (irandom (1- (frames))))))))
	  (close-sound ind))
	
	)))


;;; ---------------- test 11: dialogs ----------------

(define (string-equal-ignoring-white-space s1 s2)
  (let ((len1 (string-length s2)))
    (define (white-space? str pos)
      (or (char=? (string-ref str pos) #\space)
	  (char=? (string-ref str pos) #\newline)))
    (call-with-current-continuation
     (lambda (return)
       (do ((i 0)
	    (j 0))
	   ((= i len1) (begin (while (and (< j len1) (white-space? s2 j)) (set! j (+ j 1))) (= j len1)))
	 (if (char=? (string-ref s1 i) (string-ref s2 j))
	     (begin
	       (set! i (+ i 1))
	       (set! j (+ j 1)))
	     (begin
	       (while (and (< i len1) (white-space? s1 i)) (set! i (+ i 1)))
	       (while (and (< j len1) (white-space? s2 j)) (set! j (+ j 1)))
	       (if (not (char=? (string-ref s1 i) (string-ref s2 j)))
		   (return #f)))))))))

(define env1 '(0 0 1 1))
(if (and (not (provided? 'snd-nogui))
	 (or full-test (= snd-test 11) (and keep-going (<= snd-test 11))))
    (begin
      (if (procedure? test-hook) (test-hook 11))
     (without-errors (peaks))
     (mus-audio-describe) 
     (define-envelope "env1" '(0 1 1 0)) 
     (let ((envd (enved-dialog) ))
       (let ((cold (color-dialog))
	     (ord (orientation-dialog))
	     (trd (transform-dialog))
	     (fild (file-dialog))
	     (regd (region-dialog))
	     (ehd (without-errors (edit-header-dialog))))
	 (open-file-dialog #f)
	 (mix-file-dialog #f)
	 (if (not (provided? 'snd-gtk))
	     (begin
	       ;(recorder-dialog) 
	       (set! (recorder-file) "hiho.snd")
	       (IF (not (string=? (recorder-file) "hiho.snd")) (snd-display ";set-recorder-file: ~A?" (recorder-file)))
	       (set! (recorder-in-format) mus-mulaw)
	       (IF (not (= (recorder-in-format) mus-mulaw)) (snd-display ";set-recorder-in-format: ~A?" (recorder-in-format)))
	       (set! (recorder-in-device) mus-audio-line-in)
	       (IF (not (= (recorder-in-device) mus-audio-line-in)) (snd-display ";set-recorder-in-device: ~A?" (recorder-in-device)))
	       (set! (recorder-out-format) mus-mulaw)
	       (IF (not (= (recorder-out-format) mus-mulaw)) (snd-display ";set-recorder-out-format: ~A?" (recorder-out-format)))
	       (set! (recorder-srate) 44100)
	       (IF (not (= (recorder-srate) 44100)) (snd-display ";set-recorder-srate: ~A?" (recorder-srate)))
	       (set! (recorder-gain 0) 0.5)
	       (IF (fneq (recorder-gain 0) 0.5) (snd-display ";set-recorder-gain: ~A?" (recorder-gain 0)))
	       (set! (recorder-out-amp 0) 0.5)
	       (IF (> (abs (- (recorder-out-amp 0) 0.5)) .01) (snd-display ";set-recorder-out-amp: ~A?" (recorder-out-amp 0)))
	       (set! (recorder-in-amp 0 0) 0.5)
	       (IF (> (abs (- (recorder-in-amp 0 0) 0.5)) .01) (snd-display ";set-recorder-in-amp: ~A?" (recorder-in-amp 0 0)))))
	 (let ((held (help-dialog "Test" "snd-test here")))
	   (if (provided? 'snd-html)
	       (begin
		 ;; these are trying to flush out html syntax errors
		 (help-dialog "Find" "#find")
		 (help-dialog "CLM" "grfsnd.html#sndwithclm")
		 (help-dialog "Find" "snd.html#find")
		 (help-dialog "Constants" "extsnd.html#sndconstants")
		 (help-dialog "Sndinfo" "sndlib.html#sndinfo")
		 (help-dialog "Generators" "clm.html#generators")
		 (IF (not (string=? (html-dir) "."))
		     (snd-display ";default html-dir: ~A" (html-dir)))
		 (set! (html-dir) "/usr/local/share")
		 (IF (not (string=? (html-dir) "/usr/local/share"))
		     (snd-display ";html-dir: ~A" (html-dir)))
		 ))
	   (IF (not (= (length (menu-widgets)) 6)) (snd-display ";menu-widgets: ~A?" (menu-widgets)))
	   (IF (not (equal? (widget-position (car (menu-widgets))) (list 0 0)))
	       (snd-display ";position main menubar: ~A?" (widget-position (car (menu-widgets)))))
	   (save-envelopes "hiho.env")
	   (load "hiho.env")
	   ;(IF (not (equal? env1 (list 0.0 1.0 1.0 0.0))) (snd-display ";save-envelopes: ~A?" env1))
	   ;this test is out-of-date
	   (delete-file "hiho.env")
	   (dismiss-all-dialogs)
	   )))

     (let ((ind (open-sound "oboe.snd")))
       (edit-header-dialog ind)
       (dismiss-all-dialogs)
       (close-sound ind))
     (let ((str1 (snd-help open-sound))
	   (str2 (snd-help 'open-sound))
	   (str3 (snd-help "open-sound")))
       (IF (or (not (string? str1)) ; can happen if we're running -DTIMING
	       (not (string-equal-ignoring-white-space str2 str3)))
	   (snd-display ";snd-help open-sound: ~A ~A ~A" str1 str2 str3)))
     (IF (not (string-equal-ignoring-white-space (snd-help enved-base) "(enved-base) -> envelope editor exponential base value (1.0)"))
	 (snd-display ";snd-help enved-base: ~A?" (snd-help enved-base)))
     (IF (not (string-equal-ignoring-white-space (snd-help x-axis-style) "(x-axis-style (snd #t) (chn #t)) -> labelling of time domain x axis (x-in-seconds)"))
	 (snd-display ";snd-help x-axis-style: ~A?" (snd-help x-axis-style)))
     (IF (not (string-equal-ignoring-white-space (snd-help vu-font) "(vu-font) -> name of font used to make VU meter labels (courier)"))
	 (snd-display ";snd-help vu-font: ~A?" (snd-help vu-font)))
     (IF (not (string-equal-ignoring-white-space (snd-help 'enved-base) "(enved-base) -> envelope editor exponential base value (1.0)"))
	 (snd-display ";snd-help 'enved-base: ~A?" (snd-help 'enved-base)))
     (IF (not (string-equal-ignoring-white-space (snd-help 'x-axis-style) "(x-axis-style (snd #t) (chn #t)) -> labelling of time domain x axis (x-in-seconds)"))
	 (snd-display ";snd-help 'x-axis-style: ~A?" (snd-help 'x-axis-style)))
     (IF (not (string-equal-ignoring-white-space (snd-help 'vu-font) "(vu-font) -> name of font used to make VU meter labels (courier)"))
	 (snd-display ";snd-help 'vu-font: ~A?" (snd-help 'vu-font)))
     (IF (not (string-equal-ignoring-white-space (snd-help "enved-base") "(enved-base) -> envelope editor exponential base value (1.0)"))
	 (snd-display ";snd-help \"enved-base\": ~A?" (snd-help "enved-base")))
     (IF (not (string-equal-ignoring-white-space (snd-help "x-axis-style") "(x-axis-style (snd #t) (chn #t)) -> labelling of time domain x axis (x-in-seconds)"))
	 (snd-display ";snd-help \"x-axis-style\": ~A?" (snd-help "x-axis-style")))
     (IF (not (string-equal-ignoring-white-space (snd-help "vu-font") "(vu-font) -> name of font used to make VU meter labels (courier)"))
	 (snd-display ";snd-help \"vu-font\": ~A?" (snd-help "vu-font")))
     (let ((str1 (snd-help 'hamming-window))
	   (str2 (snd-help "hamming-window")))
       (IF (or (not (string-equal-ignoring-white-space str1 str2))
	       (not (string-equal-ignoring-white-space str1 "A raised cosine")))
	   (snd-display ";snd-help hamming-window: ~A ~A" str1 str2)))

     (let ((ind (open-sound "oboe.snd")))
       (IF (< (length (sound-widgets ind)) 4)
	   (snd-display ";sound-widgets: ~A?" (sound-widgets ind)))
       (report-in-minibuffer "hi there" ind)
       (let ((str (widget-text (list-ref (sound-widgets ind) 3))))
	 (IF (not (string=? str "hi there"))
	     (snd-display ";report-in-minibuffer: ~A?" str))
	 (append-to-minibuffer "away!" ind)
	 (set! str (widget-text (list-ref (sound-widgets ind) 3)))
	 (IF (not (string=? str "hi thereaway!"))
	     (snd-display ";report-in-minibuffer 1: ~A?" str)))
       (close-sound ind))
     ))

(define map-silence
  (lambda (silence replacement)
    (let ((sum-of-squares 0.0)
          (buffer (make-vector 128 0.0))
          (position 0)
          (current-sample 0)
          (chan-samples (frames)))
      (lambda (y)
	(let ((old-y (vector-ref buffer position)))
	  (set! sum-of-squares (- (+ sum-of-squares (* y y)) (* old-y old-y)))
	  (vector-set! buffer position y)
	  (set! position (1+ position))
	  (if (= position 128) (set! position 0))
	  (set! current-sample (1+ current-sample))
	  (if (> sum-of-squares silence)
	      (if (= current-sample chan-samples)
		  ;; at end return trailing samples as long as it looks like sound
		  (let ((temp-buffer (make-vector 128 0.0)))
		    (do ((i 0 (1+ i)))
			((= i 128) temp-buffer)
		      (let ((final-y (vector-ref buffer position)))
			(vector-set! temp-buffer i (if (> sum-of-squares silence) final-y 0.0))
			(set! sum-of-squares (- sum-of-squares (* final-y final-y)))
			(set! position (1+ position))
			(if (= position 128) (set! position 0)))))
		  old-y)
	      replacement))))))

(define sf-dir-files (if (string? sf-dir) (sound-files-in-directory sf-dir) #f))
(define sf-dir-len (if sf-dir-files (length sf-dir-files) 0))
(define cur-dir-files (sound-files-in-directory "."))
(define cur-dir-len (length cur-dir-files))
(define buffer-menu #f)

(define (remove-if p l)
  (cond ((null? l) '())
	((p (car l)) (remove-if p (cdr l)))
	(else (cons (car l) (remove-if p (cdr l))))))


;;; ---------------- test 12:  extensions etc ----------------

(define (spectral-difference snd1 snd2)
  (let* ((size (max (frames snd1) (frames snd2)))
	 (pow2 (ceiling (/ (log size) (log 2))))
	 (fftlen (inexact->exact (expt 2 pow2)))
	 (fdr1 (samples->vct 0 fftlen snd1 0))
	 (fdr2 (samples->vct 0 fftlen snd2 0))
	 (spectr1 (snd-spectrum fdr1 blackman2-window fftlen #t))
	 (spectr2 (snd-spectrum fdr2 blackman2-window fftlen #t))
	 (diff 0.0)
	 (diffs (vct-subtract! spectr1 spectr2))
	 (len (vct-length diffs)))
    (do ((i 0 (1+ i)))
	((= i len) diff)
      (set! diff (+ diff (abs (vct-ref diffs i)))))))

(define (test-spectral-difference snd1 snd2 maxok)
  (let ((s1 (open-sound snd1))
	(s2 (open-sound snd2)))
    (let ((diff (spectral-difference s1 s2)))
      (close-sound s1)
      (close-sound s2)
      (if (> diff maxok)
	  (snd-display ";translate ~A: ~A > ~A?" snd2 diff maxok)))))

(if (or full-test (= snd-test 12) (and keep-going (<= snd-test 12)))
    (if sf-dir-files
	(let ((open-files '())
	      (open-ctr 0))
	  (if (procedure? test-hook) (test-hook 12))
	  (add-sound-file-extension "wave")
	  (do ()
	      ((= open-ctr 32))
	    (let* ((len (length open-files))
		   (open-chance (* (- 8 len) .125))
		   (close-chance (* len .125)))
	      (if (or (= len 0) (> (random 1.0) .5))
		  (let* ((choice (inexact->exact (floor (my-random sf-dir-len))))
			 (name (string-append sf-dir (list-ref sf-dir-files choice)))
			 (ht (mus-sound-header-type name))
			 (df (mus-sound-data-format name))
			 (fd (if (or (= ht mus-raw) (= df -1)) 
				 -1 
				 (or (view-sound name) -1))))
		    (if (not (= fd -1))
			(begin
			  (set! open-ctr (+ open-ctr 1))
			  (set! open-files (cons fd open-files)))))
		  (if (and (> len 0) (> (random 1.0) 0.3))
		      (let* ((choice (inexact->exact (floor (my-random (exact->inexact (length open-files))))))
			     (fd (list-ref open-files choice)))
			(close-sound fd)
			(set! open-files (remove-if (lambda (a) (= a fd)) open-files)))))))
	  (if open-files (map close-sound open-files))
	  (if (not (= (length (sounds)) 0)) (snd-display ";active-sounds: ~A?" (sounds)))
	  (let* ((name (string-append sf-dir (list-ref sf-dir-files 0)))
		 (index (view-sound name)))
	    (IF (not (string=? name (file-name index))) (snd-display ";file-name: ~A?" (file-name index)))
	    (close-sound index))
	  (let ((fd (open-raw-sound (string-append sf-dir "addf8.nh") 1 8012 mus-mulaw)))
	    (IF (not (= (data-format fd) mus-mulaw)) (snd-display ";open-raw-sound: ~A?" (mus-data-format-name (data-format fd))))
	    (close-sound fd))

	  (time (test-spectral-difference "oboe.snd" (string-append sf-dir "oboe.g723_24") 20.0))
	  (test-spectral-difference "oboe.snd" (string-append sf-dir "oboe.g723_40") 3.0)
	  (test-spectral-difference "oboe.snd" (string-append sf-dir "oboe.g721") 6.0)
	  (test-spectral-difference (string-append sf-dir "o2.wave") (string-append sf-dir "o2_dvi.wave") 10.0)
	  (test-spectral-difference (string-append sf-dir "wood.riff") (string-append sf-dir "wood.sds") 1.0)
	  (test-spectral-difference (string-append sf-dir "nist-10.wav") (string-append sf-dir "nist-shortpack.wav") 1.0)

	  )))

(define read-or-run
  (lambda (fil)
    (let ((val (peek-char fil)))
      (or (and val (read-char fil))
          (c-g?)
          (read-or-run fil)))))

(define execute-and-wait
  (lambda (cmd)
    (let ((fil (open-pipe cmd "r")))
      (do ((val (read-or-run fil) (read-or-run fil)))
          ((or (eq? val #t) (eof-object? val))
           (eq? val #t))
        (write-char val (current-output-port)))
      (close-pipe fil))))

(define loop-through-files
  (lambda (description make-cmd select)
    (let* ((data (if select 
		     (selection-to-temps mus-next mus-out-format) 
		     (sound-to-temps mus-next mus-out-format)))
           (input-names (temp-filenames data))
           (files (vector-length input-names))
           (output-names (make-vector files ""))
           (stopped #f))
      (do ((i 0 (1+ i)))
          ((or stopped (= i files)))
        (vector-set! output-names i (string-append (tmpnam) ".snd"))
        (set! stopped (execute-and-wait (make-cmd (vector-ref input-names i) (vector-ref output-names i)))))
      (if select 
	  (temps-to-selection data output-names description)
	  (temps-to-sound data output-names description)))))

(define copyfile-1
  (lambda (select)
    (loop-through-files
      "(cp)"
      (lambda (in out)
        (string-append "cp " in " " out))
      select)))

(define sndxtest
   (lambda (func-out func-in)
     (let ((data (func-out)))
       (if data
           (let* ((str "")
                  (input-names (temp-filenames data))
                  (output-name (string-append (tmpnam) ".snd"))
                  (cmd (string-append "./sndxtest \"" (vector-ref input-names 0) "\" \"" output-name "\""))
                  (fil (open-pipe cmd "r")))
             (do ((val (read-char fil) (read-char fil))) 
                 ((eof-object? val))
               (set! str (string-append str (string val))))
             (close-pipe fil)
             (func-in data output-name "(sndxtest)")
             str)
           (report-in-minibuffer "no current selection")))))

(define clm-fm-violin
  (lambda (dur frq amp)
    (let* ((beg (/ (cursor) (srate)))
           (fmv-call (string-append "(fm-violin "
                                    (number->string beg) " "
                                    (number->string dur) " "
                                    (number->string frq) " "
                                    (number->string amp) ")")))
      (loop-through-files
       fmv-call
       (lambda (in out)
       (string-append
        "lisp -I clm.dxl "
        "-e '(progn (restart-clm) "
        "      (with-sound (:play nil :output \"" out "\") "
        "        (mix \"" in "\") "
                 fmv-call
        "        ) (exit))'"))
       #f))))

(define histogram
  (add-transform "histogram" "bins" 0.0 1.0 
		 (lambda (len fd)
		   (let ((v (make-vct len))
			 (steps (/ len 16))
			 (step (/ 1.0 len)))
		     (vct-fill! v 0.0)
		     (do ((i 0 (1+ i)))
			 ((= i len) v)
		       (let* ((val (next-sample fd))
			      (bin (inexact->exact (* (abs val) 16.0))))
			 (do ((j 0 (1+ j)))
			     ((= j steps))
			   (vct-set! v (+ j bin) (+ step (vct-ref v (+ j bin)))))))))))

  (defmacro carg0 (hook)
    `(let ((str (with-output-to-string (lambda () (display (hook->list ,hook))))))
       (IF (not (string=? str "(#<procedure arg0 (() 32)>)"))
	   (snd-display ";~A: ~A?" ',hook str))))

  (defmacro carg1 (hook)
    `(let ((str (with-output-to-string (lambda () (display (hook->list ,hook))))))
       (IF (not (string=? str "(#<procedure arg1 ((n) (+ n 32))>)"))
	   (snd-display ";~A: ~A?" ',hook str))))

  (defmacro carg2 (hook)
    `(let ((str (with-output-to-string (lambda () (display (hook->list ,hook))))))
       (IF (not (string=? str "(#<procedure arg2 ((n m) (+ n m 32))>)"))
	   (snd-display ";~A: ~A?" ',hook str))))
  
  (defmacro carg3 (hook)
    `(let ((str (with-output-to-string (lambda () (display (hook->list ,hook))))))
       (IF (not (string=? str "(#<procedure arg3 ((a b c) (+ a b c 32))>)"))
	   (snd-display ";~A: ~A?" ',hook str))))

  (defmacro carg4 (hook)
    `(let ((str (with-output-to-string (lambda () (display (hook->list ,hook))))))
       (IF (not (string=? str "(#<procedure arg4 ((a b c d) (+ a b c d 32))>)"))
	   (snd-display ";~A: ~A?" ',hook str))))
  
  (defmacro carg5 (hook)
    `(let ((str (with-output-to-string (lambda () (display (hook->list ,hook))))))
       (IF (not (string=? str "(#<procedure arg5 ((a b c d e) (list 0 0 1 1))>)"))
	   (snd-display ";~A: ~A?" ',hook str))))
  
  (defmacro carg6 (hook)
    `(let ((str (with-output-to-string (lambda () (display (hook->list ,hook))))))
       (IF (not (string=? str "(#<procedure arg6 ((a b c d e f) (+ a b c d e f 32))>)"))
	   (snd-display ";~A: ~A?" ',hook str))))

(define (test-hooks)
  (define (arg0) 32)
  (define (arg1 n) (+ n 32))
  (define (arg2 n m) (+ n m 32))
  (define (arg3 a b c) (+ a b c 32))
  (define (arg4 a b c d) (+ a b c d 32))
  (define (arg5 a b c d e) (list 0 0 1 1))
  (define (arg6 a b c d e f) (+ a b c d e f 32))
  (reset-all-hooks)

  (add-hook! after-graph-hook arg2) (carg2 after-graph-hook)
  (add-hook! lisp-graph-hook arg2) (carg2 lisp-graph-hook)
  (add-hook! before-transform-hook arg2) (carg2 before-transform-hook)
  (add-hook! mix-position-changed-hook arg2) (carg2 mix-position-changed-hook)
  (add-hook! stop-playing-channel-hook arg2) (carg2 stop-playing-channel-hook)
  (add-hook! save-hook arg2) (carg2 save-hook)
  (add-hook! mus-error-hook arg2) (carg2 mus-error-hook)
  (add-hook! mouse-enter-graph-hook arg2) (carg2 mouse-enter-graph-hook)
  (add-hook! mouse-leave-graph-hook arg2) (carg2 mouse-leave-graph-hook)
  (add-hook! open-raw-sound-hook arg2) (carg2 open-raw-sound-hook)
  (add-hook! select-channel-hook arg2) (carg2 select-channel-hook)

  (add-hook! after-open-hook arg1) (carg1 after-open-hook)
  (add-hook! close-hook arg1) (carg1 close-hook)
  (add-hook! draw-mark-hook arg1) (carg1 draw-mark-hook)
  (add-hook! drop-hook arg1) (carg1 drop-hook)
  (add-hook! just-sounds-hook arg1) (carg1 just-sounds-hook)
  (add-hook! mark-click-hook arg1) (carg1 mark-click-hook)
  (add-hook! mark-drag-hook arg1) (carg1 mark-drag-hook)
  (add-hook! mix-amp-changed-hook arg1) (carg1 mix-amp-changed-hook)
  (add-hook! mix-speed-changed-hook arg1) (carg1 mix-speed-changed-hook)
  (add-hook! name-click-hook arg1) (carg1 name-click-hook)
  (add-hook! before-apply-hook arg1) (carg1 before-apply-hook)
  (add-hook! after-apply-hook arg1) (carg1 after-apply-hook)
  (add-hook! open-hook arg1) (carg1 open-hook)
  (add-hook! output-comment-hook arg1) (carg1 output-comment-hook)
  (add-hook! multichannel-mix-hook arg1) (carg1 multichannel-mix-hook)
  (add-hook! play-hook arg1) (carg1 play-hook)
  (add-hook! dac-hook arg1) (carg1 dac-hook)
  (add-hook! new-widget-hook arg1) (carg1 new-widget-hook)
  (add-hook! snd-error-hook arg1) (carg1 snd-error-hook)
  (add-hook! snd-warning-hook arg1) (carg1 snd-warning-hook)
  (add-hook! start-hook arg1) (carg1 start-hook)
  (add-hook! start-playing-hook arg1) (carg1 start-playing-hook)
  (add-hook! stop-playing-hook arg1) (carg1 stop-playing-hook)
  (add-hook! stop-playing-region-hook arg1) (carg1 stop-playing-region-hook)
  (add-hook! mouse-enter-listener-hook arg1) (carg1 mouse-enter-listener-hook)
  (add-hook! mouse-leave-listener-hook arg1) (carg1 mouse-leave-listener-hook)
  (add-hook! property-changed-hook arg1) (carg1 property-changed-hook)
  (add-hook! select-sound-hook arg1) (carg1 select-sound-hook)
  (add-hook! select-mix-hook arg1) (carg1 select-mix-hook)
  (add-hook! print-hook arg1) (carg1 print-hook)
  (add-hook! read-hook arg1) (carg1 read-hook)
  (add-hook! previous-files-select-hook arg1) (carg1 previous-files-select-hook)

  (add-hook! exit-hook arg0) (carg0 exit-hook)
  (add-hook! stop-dac-hook arg0) (carg0 stop-dac-hook)
  (add-hook! output-name-hook arg0) (carg0 output-name-hook)
  (add-hook! stop-playing-selection-hook arg0) (carg0 stop-playing-selection-hook)

  (add-hook! during-open-hook arg3) (carg3 during-open-hook)
  (add-hook! transform-hook arg3) (carg3 transform-hook)
  (add-hook! mouse-enter-label-hook arg3) (carg3 mouse-enter-label-hook)
  (add-hook! mouse-leave-label-hook arg3) (carg3 mouse-leave-label-hook)
  (add-hook! initial-graph-hook arg3) (carg3 initial-graph-hook)

  (add-hook! graph-hook arg4) (carg4 graph-hook)
  (add-hook! key-press-hook arg4) (carg4 key-press-hook)
  (add-hook! mark-hook arg4) (carg4 mark-hook)

  (add-hook! mouse-drag-hook arg6) (carg6 mouse-drag-hook)
  (add-hook! mouse-press-hook arg6) (carg6 mouse-press-hook)
  (add-hook! mouse-release-hook arg6) (carg6 mouse-release-hook)

  (add-hook! enved-hook arg5) (carg5 enved-hook)
  (reset-all-hooks)
  )
  
;;; ---------------- test 13: menus, edit lists, hooks, seach/key funcs ----------------

(define (test-menus)
  (for-each
   (lambda (top-menu)
     (for-each-child
      top-menu
      (lambda (w)
	(let ((option-holder (cadr (|XtGetValues w (list |XmNsubMenuId 0)))))
	  (for-each-child
	   option-holder
	   (lambda (menu)
	     (if (and (|XmIsPushButton menu)
		      (|XtIsSensitive menu)
		      (not (member (|XtName menu)
				   (list "Exit" "New" 
					 "Save   C-x C-s" 
					 "Close  C-x k" 
					 "Click for help" "Mix Panel"))))
		 (|XtCallCallbacks menu |XmNactivateCallback (snd-global-state)))))))))
   (cdr (menu-widgets)))
  (dismiss-all-dialogs))

(if (or full-test (= snd-test 13) (and keep-going (<= snd-test 13)))
    (let ((fd (view-sound "oboe.snd"))
	  (mb (add-to-main-menu "clm")))
      (if (procedure? test-hook) (test-hook 13))

      (let ((var (catch #t (lambda () (add-to-menu -1 "fm-violin" (lambda () #f))) (lambda args args))))
	(IF (not (eq? (car var) 'no-such-menu))
	    (snd-display ";add-to-menu bad menu: ~A" var)))

      (set! (cursor fd) 2000)
      (set! (transform-graph-type) graph-transform-once)
      (set! (graph-transform? fd) #t)
      (add-to-menu mb "fm-violin" (lambda () (IF (sound?) (clm-fm-violin .1 660 .1))))
      (add-to-menu mb "not here" (lambda () (snd-display ";oops")))
      (set! (menu-sensitive mb "not here") #f)
      (IF (menu-sensitive mb "not here") (snd-display ";menu-sensitive?"))
      (remove-from-menu mb "not here")
      (add-to-menu 3 "Denoise" (lambda () (report-in-minibuffer "denoise")))
      (change-menu-label 3 "Denoise" "hiho")
      (if include-clm
	  (begin
	    (clm-fm-violin .1 660 .1)
	    (play-and-wait)))
      (let ((fr (frames fd))
	    (chn (chans fd))
	    (sr (srate fd))
	    (mx (maxamp fd)))
	(copyfile-1 #f)
	(IF (not (equal? (edit-fragment) '("(cp)" "set" 0 50828))) (snd-display ";copyfile-1: ~A?" (edit-fragment)))
	(IF (or (not (= fr (frames fd)))
		(not (= chn (chans fd)))
		(fneq mx (maxamp fd))
		(fneq sr (srate fd)))
	    (snd-display ";copyfile(1): ~A ~A ~A ~A?" (frames fd) (chans fd) (srate fd) (maxamp fd)))
	(let ((eds (edits)))
	  (preload-file "oboe.snd")
	  (preload-directory ".")
	  (select-all)
	  (copyfile-1 #t)
	  (IF (not (equal? (edit-fragment) '("(cp)" "set" 0 50828))) (snd-display ";copyfile-1 (select): ~A?" (edit-fragment)))
	  (IF (not (equal? (edits) (list (+ (car eds) 1) (cadr eds)))) (snd-display ";copyfile-1 (select eds): ~A ~A?" eds (edits)))
	  (IF (or (not (= fr (frames fd)))
		  (not (= chn (chans fd)))
		  (fneq mx (maxamp fd))
		  (fneq sr (srate fd)))
	      (snd-display ";copyfile(2): ~A ~A ~A ~A?" (frames fd) (chans fd) (srate fd) (maxamp fd)))))

      (update-transform fd)
      (let ((v0 (transform-samples->vct fd))
	    (vc (transform-samples fd))
	    (val (transform-sample 50 0 fd)))
	(IF (and v0 vc)
	    (begin
	      (IF (fneq val (vector-ref vc 50)) (snd-display ";transform-sample: ~A ~A?" val (vector-ref vc 50)))
	      (do ((i 0 (1+ i))) ((= i 100)) 
		(IF (fneq (vector-ref vc i) (vct-ref v0 i)) 
		    (snd-display ";transform-samples[~D]: ~A ~A?" i (vector-ref vc i) (vct-ref v0 i)))))
	    (snd-display ";fft not ready yet: ~A ~A" v0 vc)))

      (close-sound fd)

      (add-hook! after-open-hook
		 (lambda (snd)
		   (set! (x-axis-style snd #t) x-axis-in-samples)))
      (set! fd (open-sound "2.snd"))
      (let ((fr (frames fd))
	    (chn (chans fd))
	    (sr (srate fd))
	    (mx0 (maxamp fd 0))
	    (mx1 (maxamp fd 1)))
	(set! (sync fd) 1)
	(select-all)
	(play-selection #t)
	(sndxtest selection-to-temp temp-to-selection)
	(IF (or (not (= fr (frames fd)))
		(not (= chn (chans fd)))
		(fneq (* 2.0 mx0) (maxamp fd 0))
		(fneq (* 2.0 mx1) (maxamp fd 1))
		(fneq sr (srate fd)))
	    (snd-display ";sndxtest(2): ~A ~A ~A (~A ~A) (~A ~A)?" (frames fd) (chans fd) (srate fd) mx0 (maxamp fd 0) mx1 (maxamp fd 1)))
	(close-sound fd))
      (reset-hook! after-open-hook)

      (add-hook! after-open-hook
		 (lambda (snd)
		   (set! (x-axis-style snd #t) x-axis-as-percentage)))
      (add-hook! initial-graph-hook
		 (lambda (snd chn dur)
		   (IF (mus-sound-maxamp-exists? (file-name snd))
		       (let* ((amp-vals (mus-sound-maxamp (file-name snd)))
			      (max-val (list-ref amp-vals (+ (* chn 2) 1))))
			 (list 0.0 dur (- max-val) max-val))
		       (list 0.0 dur -1.0 1.0))))
      (set! fd (open-sound "obtest.snd"))
      (let ((fr (frames fd))
	    (chn (chans fd))
	    (sr (srate fd))
	    (mx (maxamp fd)))
	(select-all)
	(sndxtest selection-to-temp temp-to-selection)
	(IF (or (not (= fr (frames fd)))
		(not (= chn (chans fd)))
		(fneq (* 2.0 mx) (maxamp fd))
		(fneq sr (srate fd)))
	    (snd-display ";sndxtest: ~A ~A ~A ~A?" (frames fd) (chans fd) (srate fd) (maxamp fd)))
	(revert-sound fd))
      (let* ((reg (make-region 10000 10020 fd))
	     (new-data (region-samples->vct))
	     (old-data (samples->vct 10030 20 fd)))
	(sndxtest selection-to-temp temp-to-selection)
	(let ((newer-data (samples->vct 10000 21 fd))
	      (new-old-data (samples->vct 10030 20 fd)))
	  (vct-scale! newer-data 0.5)
	  (IF (not (vequal newer-data new-data))
	      (snd-display ";sndxtest new: ~A ~A" new-data newer-data))
	  (IF (not (vequal old-data new-old-data))
	      (snd-display ";sndxtest old: ~A ~A" old-data new-old-data))))
      (close-sound fd)
      (reset-hook! after-open-hook)
      (reset-hook! initial-graph-hook)

      (set! fd (open-sound "2.snd"))
      (set! (selection-position fd 1) 1000)
      (set! (selection-length fd 1) 10)
      (set! (selection-member? fd 1) #t)
      (IF (selection-member? fd 0) (snd-display ";chan 0 is selection-member?"))
      (let ((old0 (samples->vct 1000 10 fd 0))
	    (old1 (samples->vct 1000 10 fd 1)))
	(sndxtest selection-to-temp temp-to-selection)
	(let ((new0 (samples->vct 1000 10 fd 0))
	      (new1 (vct-scale! (samples->vct 1000 10 fd 1) .5)))
	  (IF (not (vequal new0 old0))
	      (snd-display ";sndxtest chan 1 hit chan 0? ~A ~A" old0 new0))
	  (IF (not (vequal new1 old1))
	      (snd-display ";sndxtest chan 1 ? ~A ~A" old1 new1))))
      (close-sound fd)

      (set! fd (open-sound "2.snd"))
      (let ((fr (frames fd))
	    (chn (chans fd))
	    (sr (srate fd))
	    (mx0 (maxamp fd 0))
	    (mx1 (maxamp fd 1)))
	(set! (sync fd) 1)
	(sndxtest sound-to-temp temp-to-sound)
	(IF (or (not (= fr (frames fd)))
		(not (= chn (chans fd)))
		(fneq (* 2.0 mx0) (maxamp fd 0))
		(fneq (* 2.0 mx1) (maxamp fd 1))
		(fneq sr (srate fd)))
	    (snd-display ";sndxtest(snd 2): ~A ~A ~A (~A ~A) (~A ~A)?" (frames fd) (chans fd) (srate fd) mx0 (maxamp fd 0) mx1 (maxamp fd 1))))
      (close-sound fd)

      (set! fd (open-sound "obtest.snd"))
      (let ((fr (frames fd))
	    (chn (chans fd))
	    (sr (srate fd))
	    (mx (maxamp fd)))
	(do ((i 0 (1+ i)))
	    ((= i 3))
	  (sndxtest sound-to-temp temp-to-sound)
	  (scale-by 0.5 fd)
	  (IF (or (not (= fr (frames fd)))
		  (not (= chn (chans fd)))
		  (fneq mx (maxamp fd))
		  (fneq sr (srate fd)))
	      (snd-display ";sndxtest snd [~D]: ~A ~A ~A ~A?" i (frames fd) (chans fd) (srate fd) (maxamp fd))))
	(revert-sound fd))

      (let ((names (short-file-name #t)))
	(change-property "SND_VERSION" "WM_NAME"
			 (format #f "snd (~A)~A"
				 (strftime "%d-%b %H:%M %Z" (localtime (current-time)))
				 (if (null? names)
				     ""
				     (format #f ":~{~A~^, ~}" names)))))
      (let ((gotit #f)
	    (oldsize (vu-size)))
	(add-hook! property-changed-hook (lambda (hi) (set! gotit #t) #f))
	(change-property "SND_VERSION" "SND_COMMAND" "(set! (vu-size) .5)")
	(reset-hook! property-changed-hook)
	(if (and gotit
		 (fneq (vu-size) 0.5))
	    (snd-display ";property vu-size: ~A" (vu-size)))
	;; this basically never gets called -- force-event didn't help
	(change-property "SND_VERSION" "SND_COMMAND" "(make-vector 10 3.14)")
	(set! (vu-size) oldsize))

      (if (provided? 'snd-motif) (load "new-effects.scm"))

      (add-hook! menu-hook
		 (lambda (name option)
		   (IF (and (string=? name "File")
			    (string=? option "Exit"))
		       (begin
			 (snd-display ";no exit!")
			 #f)
		       #t))) ; #t to make sure other menu items remain active
      (let ((ctr 0))
	(add-hook! menu-hook
		   (lambda (name option)
		     (IF (and (string=? name "Options")
			      (string=? option "Save options"))
			 (begin
			   (set! ctr (+ ctr 1))
			   #f)
			 #t)))
	(add-hook! menu-hook
		   (lambda (name option)
		     (IF (and (string=? name "View")
			      (string=? option "Files"))
			 (set! ctr (+ ctr 1)))
		     #t))
	(if (provided? 'xm)
	    (add-hook! menu-hook
		       (lambda (name option)
			 (IF (and (string=? name "Effects")
				  (string=? option "invert"))
			     (set! ctr (+ ctr 1)))
			 #t)))

	(let ((added 0))
	  (set! (with-background-processes) #t)
	  (set! (vu-size) 1.25)
	  (add-hook! new-widget-hook
		     (lambda (w)
		       (set! added (+ added 1))))
	  (if (provided? 'snd-motif)
	      (without-errors
	       (test-menus))) ; built-in self-test function
	  (set! (with-background-processes) #f)
	  (IF (= added 0)
	      (snd-display ";no widgets added?"))
	  (reset-hook! new-widget-hook))

	(if (provided? 'snd-ladspa)
	    (if (file-exists? "/home/bil/test/cmt/plugins")
		(begin
		  (set! (ladspa-dir) "/home/bil/test/cmt/plugins")
		  (apply-ladspa (make-sample-reader 0) (list "cmt" "delay_5s" .3 .5) 1000 "delayed"))
		(snd-display ";ladspa loaded but can't find plugin dir")))

	(revert-sound fd)
	(close-sound fd)
	(IF (not (= ctr 1)) (snd-display ";ctr after test-menus: ~A? " ctr))
	(reset-hook! menu-hook))

      (test-hooks)
      (let ((ind (open-sound "oboe.snd")))
	(set! (cursor) 2000)
	(key (char->integer #\u) 4 ind)
	(key (char->integer #\1) 0 ind)
	(key (char->integer #\0) 0 ind)
	(key (char->integer #\0) 0 ind)
	(key (char->integer #\x) 4 ind)
	(key (char->integer #\z) 4 ind)
	(IF (not (equal? (edit-fragment) (list "C-x C-z" "set" 2000 100)))
	    (snd-display ";C-x C-z fragment: ~A" (edit-fragment)))
	(IF (not (vequal (samples->vct 2010 10) (vct 0.064 0.063 0.063 0.062 0.062 0.061 0.060 0.059 0.059 0.058)))
	    (snd-display ";C-x C-z samps: ~A" (samples->vct 2010 10)))
	(set! (cursor) 0)
	(select-all)
	(key (char->integer #\x) 4 ind)
	(key (char->integer #\o) 0 ind)
	(key (char->integer #\x) 4 ind)
	(key (char->integer #\p) 0 ind)
	(set! (selection-member? #t) #f)
	(revert-sound ind)
	(set! (search-procedure ind) (lambda (n) (> n .1)))
	(key (char->integer #\a) 4 ind 0)
	(IF (not (= (cursor ind 0) 0))
	    (snd-display ";C-a cursor: ~D?" (cursor ind 0)))
	(key (char->integer #\s) 4 ind 0)
	(key (char->integer #\s) 4 ind 0)
	(IF (not (= (cursor ind 0) 4423))
	    (snd-display ";search-procedure C-s C-s cursor: ~D?" (cursor ind 0)))
	(let ((str (with-output-to-string (lambda () (display (search-procedure ind))))))
	  (IF (not (string=? str "#<procedure #f ((n) (> n 0.1))>"))
	      (snd-display ";search-procedure: ~A?" str)))
	(reset-hook! (edit-hook ind 0))
	(add-hook! (edit-hook ind 0) (lambda () (+ snd chn)))
	(let ((str (with-output-to-string (lambda () (display (hook->list (edit-hook ind 0)))))))
	  (IF (not (string=? str "(#<procedure #f (() (+ snd chn))>)"))
	      (snd-display ";edit-hook: ~A?" str)))
	(reset-hook! (edit-hook ind 0))
	(reset-hook! (after-edit-hook ind 0))
	(add-hook! (after-edit-hook ind 0) (lambda () (+ snd chn)))
	(let ((str (with-output-to-string (lambda () (display (hook->list (after-edit-hook ind 0)))))))
	  (IF (not (string=? str "(#<procedure #f (() (+ snd chn))>)"))
	      (snd-display ";after-edit-hook: ~A?" str)))
	(reset-hook! (after-edit-hook ind 0))
	(reset-hook! (undo-hook ind 0))
	(add-hook! (undo-hook ind 0) (lambda () (+ snd chn)))
	(let ((str (with-output-to-string (lambda () (display (hook->list (undo-hook ind 0)))))))
	  (IF (not (string=? str "(#<procedure #f (() (+ snd chn))>)"))
	      (snd-display ";undo-hook: ~A?" str)))
	(reset-hook! (undo-hook ind 0))
	(close-sound ind)
	)

      (IF (not (hook-empty? open-raw-sound-hook)) (reset-hook! open-raw-sound-hook))
      (add-hook! open-raw-sound-hook (lambda (file choices) (list 1 22050 mus-bshort)))
      (let* ((ind (open-sound "../sf/addf8.nh")))
	(play-and-wait 0 ind)
	(reset-hook! open-raw-sound-hook)
	(IF (or (not (= (chans ind) 1))
		(not (= (srate ind) 22050))
		(not (= (data-format ind) mus-bshort))
		(not (= (frames ind) 23808)))
	    (snd-display ";open-raw: ~A ~A ~A ~A" 
				 (chans ind) (srate ind) (data-format ind) (frames ind)))
	(close-sound ind))

      (let ((ind (open-sound "oboe.snd")))
	(save-sound-as "test.snd" ind mus-raw)
	(close-sound ind)
	(reset-hook! open-raw-sound-hook)
	(add-hook! open-raw-sound-hook 
		   (lambda (file choice)
		     (IF (not (string=? (substring file (- (string-length file) 8)) "test.snd"))
			 (snd-display ";open-raw-sound-hook file: ~A?" (substring file (- (string-length file) 8))))
		     (IF (not (eq? choice #f))
			 (snd-display ";open-raw-sound-hook choice: ~A?" choice))
		     (list 2 44100 mus-mulaw)))
	(set! ind (open-sound "test.snd"))
	(IF (or (not (= (header-type ind) mus-raw))
		(not (= (data-format ind) mus-mulaw))
		(not (= (chans ind) 2))
		(not (= (srate ind) 44100))
		(not (= (frames ind) 50828)))
	    (snd-display ";open-raw-sound-hook 1: ~A ~A ~A ~A ~A" 
				 (header-type ind) (data-format ind) (chans ind) (srate ind) (frames ind)))
	(close-sound ind)
	(add-hook! open-raw-sound-hook
		   (lambda (file choice)
		     ;; append to list
		     (IF (not (equal? choice (list 2 44100 mus-mulaw)))
			 (snd-display ";open-raw-sound-hook 2: ~A" choice))
		     (list 1 22050 mus-lint))
		   #t)
	(set! ind (open-sound "test.snd"))
	(IF (or (not (= (header-type ind) mus-raw))
		(not (= (data-format ind) mus-lint))
		(not (= (chans ind) 1))
		(not (= (srate ind) 22050))
		(not (= (frames ind) (/ 50828 2))))
	    (snd-display ";open-raw-sound-hook 3: ~A ~A ~A ~A ~A" 
				 (header-type ind) (data-format ind) (chans ind) (srate ind) (frames ind)))
	(close-sound ind)
	(reset-hook! open-raw-sound-hook)
	(add-hook! open-raw-sound-hook 
		   (lambda (file choice)
		     (list 2)))
	(set! ind (open-sound "test.snd"))
	(IF (or (not (= (header-type ind) mus-raw))
		(not (= (data-format ind) mus-lint))
		(not (= (chans ind) 2))
		(not (= (srate ind) 22050)))
	    (snd-display ";open-raw-sound-hook 4: ~A ~A ~A ~A"
				 (header-type ind) (data-format ind) (chans ind) (srate ind)))
	(close-sound ind)
	(reset-hook! open-raw-sound-hook)
	(add-hook! open-raw-sound-hook 
		   (lambda (file choice)
		     (list 1 22050 mus-bshort 120 320)))
	(set! ind (open-sound "test.snd"))
	(IF (or (not (= (header-type ind) mus-raw))
		(not (= (data-format ind) mus-bshort))
		(not (= (chans ind) 1))
		(not (= (srate ind) 22050))
		(not (= (data-location ind) 120))
		(not (= (frames ind) 160)))
	    (snd-display ";open-raw-sound-hook 5: ~A ~A ~A ~A ~A ~A" 
				 (header-type ind) (data-format ind) (chans ind) (srate ind)
				 (data-location ind) (/ (frames ind) 2)))
	(close-sound ind)
	(reset-hook! open-raw-sound-hook))

      (let ((ind #f)
	    (op #f)
	    (sl #f)
	    (aop #f)
	    (dop #f)
	    (cl #f)
	    (ig #f)
	    (scl #f)
	    (other #f))
	(add-hook! open-hook 
		   (lambda (filename)
		     (IF (not (string=? filename (mus-expand-filename "oboe.snd")))
			 (snd-display ";open-hook: ~A?" filename))
		     (set! op #t)
		     #f))
	(add-hook! after-open-hook 
		   (lambda (snd)
		     (set! aop snd)))
	(add-hook! during-open-hook 
		   (lambda (fd filename reason)
		     (set! dop #t)
		     (IF (not (string=? filename (mus-expand-filename "oboe.snd")))
			 (snd-display ";during-open-hook filename: ~A?" filename))
		     (IF (not (= reason 1))
			 (snd-display ";during-open-hook reason: ~A?" reason))))
	(add-hook! initial-graph-hook
		   (lambda (snd chn dur)
		     (IF (not (= chn 0))
			 (snd-display ";initial-graph-hook (channel): ~A not 0?" chn))
		     (set! ig #t)
		     #f))

	(set! ind (open-sound "oboe.snd"))

	(IF (not op) (snd-display ";open-hook not called?"))
	(IF (not dop) (snd-display ";during-open-hook not called?"))
	(IF (not ig) (snd-display ";initial-graph-hook not called?"))
	(IF (not (number? aop)) (snd-display ";after-open-hook not called?"))
	(IF (not (= aop ind)) (snd-display ";after-open-hook ~A but ind: ~A?" aop ind))
	(reset-hook! open-hook)
	(reset-hook! during-open-hook)
	(reset-hook! after-open-hook)
	(reset-hook! initial-graph-hook)

	(add-hook! open-hook (lambda (filename) #t))
	(let ((pistol (open-sound "pistol.snd")))
	  (if (not (eq? pistol #f))
	      (begin
		(snd-display ";open-hook #t, but open-sound -> ~A" pistol)
		(if (sound? pistol) (close-sound pistol)))))
	(reset-hook! open-hook)

	(let ((gr #f)
	      (agr #f))
	  (add-hook! graph-hook
		     (lambda (snd chn y0 y1)
		       (IF (not (= snd ind))
			   (snd-display ";graph-hook: ~A not ~A?" snd ind))
		       (IF (not (= chn 0))
			   (snd-display ";graph-hook (channel): ~A not 0?" chn))
		       (set! gr #t)))
	  (add-hook! after-graph-hook
		     (lambda (snd chn)
		       (IF (not (= snd ind))
			   (snd-display ";after-graph-hook: ~A not ~A?" snd ind))
		       (IF (not (= chn 0))
			   (snd-display ";after-graph-hook (channel): ~A not 0?" chn))
		       (set! agr #t)))
	  (update-time-graph ind 0)
	  (IF (not gr) (snd-display ";graph-hook not called?"))
	  (IF (not agr) (snd-display ";after-graph-hook not called?"))
	  (reset-hook! graph-hook)
	  (reset-hook! after-graph-hook))

	(set! other (open-sound "pistol.snd"))
	
	(add-hook! select-sound-hook 
		   (lambda (snd) 
		     (IF (not (= snd ind))
			 (snd-display ";select-sound-hook: ~A not ~A?" snd ind))
		     (set! sl #t)))
	(add-hook! select-channel-hook 
		   (lambda (snd chn) 
		     (IF (not (= snd ind))
			 (snd-display ";select-channel-hook: ~A not ~A?" snd ind))
		     (IF (not (= chn 0))
			 (snd-display ";select-channel-hook (channel): ~A not 0?" chn))
		     (set! scl #t)))

	(select-sound ind)
	(IF (not sl) (snd-display ";select-sound-hook not called?"))
	(IF (not scl) (snd-display ";select-channel-hook not called?"))
	(reset-hook! select-sound-hook)
	(reset-hook! select-channel-hook)

	(let ((spl #f)
	      (stl #f)
	      (ph #f)
	      (ph1 #f)
	      (pc #f))
	  (add-hook! start-playing-hook
		     (lambda (snd)
		       (IF (not (= snd ind))
			   (snd-display ";start-playing-hook: ~A not ~A?" snd ind))
		       (set! spl #t)))
	  (add-hook! stop-playing-hook
		     (lambda (snd)
		       (IF (not (= snd ind))
			   (snd-display ";stop-playing-hook: ~A not ~A?" snd ind))
		       (set! stl #t)))
	  (add-hook! stop-playing-channel-hook
		     (lambda (snd chn)
		       (IF (not (= snd ind))
			   (snd-display ";stop-playing-channel-hook: ~A not ~A?" snd ind))
		       (IF (not (= chn 0))
			   (snd-display ";stop-playing-channel-hook (channel): ~A not 0?" chn))
		       (set! pc #t)))
	  (add-hook! play-hook
		     (lambda (n)
		       (IF (< n 128)
			   (snd-display ";play-hook samps: ~A?" n))
		       (set! ph #t)))
	  (add-hook! dac-hook
		     (lambda (n)
		       (IF (not (sound-data? n))
			   (snd-display ";dac-hook data: ~A?" n))
		       (IF (< (sound-data-length n) 128)
			   (snd-display ";dac-hook data length: ~A?" (sound-data-length n)))
		       (set! ph1 #t)))

	  (play-and-wait 0 ind)

	  (IF (not spl) (snd-display ";start-playing-hook not called?"))
	  (IF (not stl) (snd-display ";stop-playing-hook not called?"))
	  (IF (not pc) (snd-display ";stop-playing-channel-hook not called?"))
	  (IF (not ph) (snd-display ";play-hook not called?"))
	  (IF (not ph1) (snd-display ";dac-hook not called?"))
	  (reset-hook! start-playing-hook)
	  (reset-hook! stop-playing-hook)
	  (reset-hook! stop-playing-channel-hook)
	  (reset-hook! play-hook)
	  (reset-hook! dac-hook)

	  ;; stop-playing-region-hook selection also
	  ;;   what about start-playing-region-hook? 
	  )

	(let ((e0 #f)
	      (e1 #f)
	      (u0 #f)
	      (u1 #f))
	  (add-hook! (edit-hook ind 0) 
		     (lambda ()
		       (set! e0 #t)
		       #t))
	  (add-hook! (edit-hook other 0) 
		     (lambda ()
		       (set! e1 #t)
		       #f))
	  (add-hook! (undo-hook ind 0) 
		     (lambda ()
		       (set! u0 #t)))
	  (add-hook! (undo-hook other 0) 
		     (lambda ()
		       (set! u1 #t)))
	  
	  ;; edit of ind should be disallowed, but not other
	  (delete-sample 0 ind 0)
	  (IF (not (= (edit-position ind 0) 0))
	      (snd-display ";edit-hook #t didn't disallow edit!"))
	  (IF (not e0) (snd-display ";edit-hook #t not called?"))
	  (undo 1 ind 0)
	  (IF u0 (snd-display ";undo-hook called?"))
	  
	  (delete-sample 0 other 0)
	  (IF (not (= (edit-position other 0) 1))
	      (snd-display ";edit-hook #f didn't allow edit!"))
	  (IF (not e1) (snd-display ";edit-hook #f not called?"))
	  (undo 1 other 0)
	  (IF (not u1) (snd-display ";undo-hook not called?"))

	  (reset-hook! (edit-hook ind 0))
	  (reset-hook! (edit-hook other 0))
	  (reset-hook! (undo-hook ind 0))
	  (reset-hook! (undo-hook other 0)))

	(let ((se #f)
	      (sw #f)
	      (me #f))
	  (add-hook! snd-error-hook
		     (lambda (msg)
		       (set! se #t)
		       #t))
	  (add-hook! snd-warning-hook
		     (lambda (msg)
		       (set! sw #t)
		       #t))
	  (add-hook! mus-error-hook
		     (lambda (typ msg)
		       (set! me #t)
		       #t))

	  (snd-error "uhoh")
	  (snd-warning "hiho")
	  (mus-sound-samples "/bad/baddy")
	  
	  (IF (not se) (snd-display ";snd-error-hook not called?"))
	  (IF (not sw) (snd-display ";snd-warning-hook not called?"))
	  (IF (not me) (snd-display ";mus-error-hook not called?"))
	  (reset-hook! snd-error-hook)
	  (reset-hook! snd-warning-hook)
	  (reset-hook! mus-error-hook))

	(add-hook! exit-hook (lambda () #f))
	(add-hook! exit-hook (lambda () #t))
	(add-hook! exit-hook (lambda () #f))
	(exit)
	(reset-hook! exit-hook)

	(let ((sh #f))
	  (if (file-exists? "baddy.snd") (delete-file "baddy.snd"))
	  (add-hook! save-hook
		     (lambda (snd filename)
		       (IF (or (not (string? filename))
			       (not (string=? filename (mus-expand-filename "baddy.snd"))))
			   (snd-display ";save-hook filename: ~A?" filename))
		       (IF (not (= snd ind))
			   (snd-display ";save-hook snd: ~A ~A?" snd ind))
		       (set! sh #t)
		       #t))
	  (save-sound-as "baddy.snd" ind)
	  (IF (not sh) (snd-display ";save-hook not called?"))
	  (if (file-exists? "baddy.snd")
	      (begin
		(snd-display ";save-hook didn't cancel save?")
		(delete-file "baddy.snd")))
	  (reset-hook! save-hook))

	;; transform-hooks require some way to force the fft to run to completion
	;; property-changed hook is similar (seems to happen whenever it's good and ready)

	(add-hook! close-hook
		   (lambda (snd)
		     (IF (not (= snd ind))
			 (snd-display ";close-hook: ~A not ~A?" snd ind))
		     (set! cl #t)))
	
	(close-sound ind)
	(IF (not cl) (snd-display ";close-hook not called?"))
	(reset-hook! close-hook)
	(close-sound other))
      ))


(define test-panel
  (lambda (func name)
    (define next-case 
      (lambda (snd)
	(if (< snd (max-sounds))
	    (if (sound? snd)
		(cons (func snd) (next-case (1+ snd)))
		(next-case (1+ snd)))
	    '())))
    (IF (not (feql (func #t) (next-case 0)))
	(snd-display ";test-panel ~A: ~A ~A?" name (func #t) (next-case 0)))))

(define test-channel
  (lambda (func name)
    (define next-chan
      (lambda (snd chn)
	(if (< chn (channels snd))
	    (cons (func snd chn) (next-chan snd (1+ chn)))
	    '())))
    (define next-snd-case 
      (lambda (snd)
	(if (< snd (max-sounds))
	    (if (sound? snd)
		(cons (next-chan snd 0) (next-snd-case (1+ snd)))
		(next-snd-case (1+ snd)))
	    '())))
    (IF (not (equal? (func #t #t) (next-snd-case 0)))
	(snd-display ";test-channel ~A: ~A ~A?" name (func #t #t) (next-snd-case 0)))))

(define duration 
  (lambda (ind)
    (/ (frames ind) (srate ind))))

(define outputs (make-vector 24))
(define delay-line #f)
(define delay-time 0.5)
(define rev-funcs-set #f)

(define (safe-make-region beg end snd)
  (let ((len (frames snd)))
    ;(snd-display "make ~D ~D " beg end)
    (if (> len 1)
	(if (< end len)
	    (make-region beg end snd)
	    (if (< beg len)
		(make-region beg (1- len) snd)
		(make-region 0 (1- len) snd))))))

(define sfile 0)

(define* (clone-sound-as new-name #:optional snd)
  ;; copies any edit-sounds to save-dir!
  (let* ((tmpf (snd-tempnam))
	 (scm (string-append (substring tmpf 0 (- (string-length tmpf) 3)) "scm"))
	 (oldsnd (or snd (selected-sound))))
    (if (not (string? (save-dir))) (set! (save-dir) "/tmp"))
    (save-edit-history scm oldsnd)
    (copy-file (file-name oldsnd) new-name)
    (set! sfile (open-sound new-name))
    (load scm)
    (delete-file scm)
    sfile))


;;; ---------------- test 14: all together now ----------------

(if (or full-test (= snd-test 14) (and keep-going (<= snd-test 14)))
    (let* ((stereo-files '())
	   (quad-files '())
	   (mono-files '())
	   (octo-files '())
	   (open-files '())
	   (s8-snd (if (file-exists? "s8.snd") "s8.snd" "oboe.snd"))
	   (open-ctr 0))
      (if (procedure? test-hook) (test-hook 14))
      (do ((i 0 (1+ i)))
	  ((= i cur-dir-len))
	(let* ((name (list-ref cur-dir-files i))
	       (ht (mus-sound-header-type name))
	       (df (mus-sound-data-format name))
	       (chans (mus-sound-chans name)))
	  (if (and (not (= ht mus-raw))
		   (not (= df -1)))
	      (if (= chans 1)
		  (set! mono-files (cons name mono-files))
		(if (= chans 2)
		    (set! stereo-files (cons name stereo-files))
		  (if (= chans 4)
		      (set! quad-files (cons name quad-files))
		    (if (= chans 8)
			(set! octo-files (cons name octo-files)))))))))
      
      (set! buffer-menu (add-to-main-menu "Buffers"))  
      (add-hook! open-hook open-buffer)
      (add-hook! close-hook close-buffer)
      
      (do ((test-ctr 0 (1+ test-ctr)))
	  ((= test-ctr tests))
	(if (> (length open-files) 8)
	    (begin
	      (map close-sound open-files)
	      (set! open-files '())))
	(log-mem test-ctr)
	(let* ((len (length open-files))
	       (open-chance (max 0.0 (* (- 8 len) .125)))
	       (close-chance (* len .125)))
	  (if (or (= len 0) (rs open-chance))
	      (let* ((choice (my-random cur-dir-len))
		     (name (list-ref cur-dir-files choice))
		     (ht (mus-sound-header-type name))
		     (df (mus-sound-data-format name))
		     (fd (if (or (= ht mus-raw) (= df -1)) -1 (view-sound name))))
		(if (and (number? fd)
			 (not (= fd -1)))
		    (set! open-files (cons fd open-files))))
	    (if (and (> len 0) (rs close-chance))
		(let* ((choice (my-random (length open-files)))
		       (fd (list-ref open-files choice)))
		  (close-sound fd)
		  (set! open-files (remove-if (lambda (a) (= a fd)) open-files)))))
	  
	  (clear-sincs)
	  (set! open-ctr (length open-files))
	  (if (= open-ctr 0)
	      (let ((fd (view-sound "oboe.snd")))
		(set! open-ctr 1)
		(set! open-files (cons fd open-files))))

	  (let ((choose-fd (lambda () (list-ref open-files (my-random open-ctr)))))

	    (if (> tests 1) (snd-display ";main test ~D " test-ctr))

	    (let* ((frame-list (map frames open-files))
		   (curloc (min 1200 (1- (list-ref frame-list 0))))
		   (curfd (choose-fd))
		   (old-marks (length (marks curfd 0))))
	      (set! test14-file (short-file-name curfd))
	      (if (> (duration curfd) 0.0)
		  (begin
		    (set! (x-bounds curfd) (list 0.0 (min (duration curfd) 1.0)))
		    (let ((xb (x-bounds curfd)))
		      (IF (or (fneq (car xb) 0.0) 
			      (fneq (cadr xb) (min (duration curfd) 1.0))) 
			  (snd-display ";x-bounds: ~A?" xb)))))
	      (set! (y-bounds curfd) (list -0.5 0.5))
	      (let ((yb (y-bounds curfd)))
		(IF (or (fneq (car yb) -0.5) (fneq (cadr yb) 0.5)) (snd-display ";y-bounds: ~A?" yb)))
	      (set! (cursor curfd) curloc)
	      (let ((cl (cursor curfd)))
		(IF (not (= cl curloc)) (snd-display ";cursor ~A /= ~A?" cl curloc)))
	      (let* ((id (add-mark curloc curfd)))
		(if (and (number? id) (not (= id -1)))
		    (let* ((cl (mark-sample id))
			   (new-marks (length (marks curfd 0))))
		      (IF (not (= cl curloc)) (snd-display ";mark ~A /= ~A?" cl curloc))
		      (IF (not (= new-marks (1+ old-marks))) (snd-display ";marks ~A ~A?" new-marks old-marks))
		      (let ((new-id (find-mark curloc curfd)))
			(IF (or (not (mark? new-id))
				(not (= id new-id)))
			    (snd-display ";find-mark (by sample): ~A ~A (~A for ~A ~A)?" 
						 id new-id curloc (mark-sample id) (mark-sample new-id))))
		      (set! (mark-name id) "hiho")
		      (let ((new-id (find-mark "hiho" curfd)))
			(IF (or (not (mark? new-id))
				(not (= id new-id)))
			    (snd-display ";find-mark (by name): ~A ~A?" id new-id)))
		      (IF (not (string=? (mark-name id) "hiho")) (snd-display ";mark name: ~A?" (mark-name id)))
		      (set! (mark-sample id) (max 0 (- curloc 100)))
		      (set! cl (mark-sample id))
		      (IF (not (= cl (max 0 (- curloc 100)))) (snd-display ";set mark ~A /= ~A?" cl curloc))
		      (delete-mark id)))
		(IF (> (duration curfd) 1.2) (set! (x-bounds curfd) '(1.0 1.1)))
		(add-mark 10 curfd)
		(add-mark 20 curfd)
		(key (char->integer #\m) 0 curfd)
		(set! (cursor curfd) 0)
		(forward-mark 1 curfd)
		(IF (and (> (frames curfd) 10)
			 (not (= (cursor curfd) 10)))
		    (snd-display ";forward-mark (10): ~A (~A)?" (cursor curfd) (frames curfd)))
		(forward-mark 1 curfd)
		(IF (and (> (frames curfd) 20)
			 (not (= (cursor curfd) 20)))
		    (snd-display ";forward-mark (20): ~A (~A)?" (cursor curfd) (frames curfd)))
		(set! (cursor curfd) 25)
		(backward-mark 2 curfd)
		(IF (and (> (frames curfd) 10)
			 (not (= (cursor curfd) 10)))
		    (snd-display ";backward-mark (10): ~A (~A)?" (cursor curfd) (frames curfd)))
		(forward-sample 5 curfd)
		(IF (and (> (frames curfd) 15)
			 (not (= (cursor curfd) 15)))
		    (snd-display ";forward-sample (5): ~A (~A)?" (cursor curfd) (frames curfd)))
		(backward-sample 1 curfd)
		(IF (and (> (frames curfd) 15)
			 (not (= (cursor curfd) 14)))
		    (snd-display ";backward-sample (1): ~A (~A)?" (cursor curfd) (frames curfd)))
		(let ((new-marks (length (marks curfd 0))))
		  (delete-marks curfd)
		  (IF (> (duration curfd) 0.0)
		      (set! (x-bounds curfd) (list 0.0 (min (duration curfd) 0.1))))
		  (set! (y-bounds curfd) '(-1.0 1.0))
		  (IF (or (> (length (marks curfd 0)) 0)
			  (not (= new-marks (+ old-marks 2))))
		      (snd-display ";delete marks: ~A ~A?" new-marks old-marks)))
		))
	  
	    (if (rs 0.5)
		(add-hook! exit-hook (lambda () (report-in-minibuffer "") (unsaved-edits? 0)))
	    (reset-hook! exit-hook))
	    (if (rs 0.5)
		(add-hook! start-hook (lambda (file) (if (> (string-length file) 0) (no-startup-file? 0 file) #f)))
	      (reset-hook! start-hook))

	    (key (char->integer #\x) 4)
	    (key (char->integer #\() 0)
	    (key (char->integer #\f) 4)
	    (key (char->integer #\f) 4)
	    (key (char->integer #\x) 4)
	    (key (char->integer #\)) 0)
	    (key (char->integer #\x) 4)
	    (key (char->integer #\e) 0)

	    (key (char->integer #\u) 4)
	    (key (char->integer #\.) 4)
	    (key (char->integer #\5) 4)
	    (key (char->integer #\x) 4)
	    (key (char->integer #\v) 4)

	    (key (char->integer #\>) 4 (choose-fd))
	    (key (char->integer #\i) 4 (choose-fd))
	    (key (char->integer #\<) 4 (choose-fd))
	    (key (char->integer #\i) 4 (choose-fd))
	    (key (char->integer #\>) 0 (choose-fd))
	    (key (char->integer #\i) 4 (choose-fd))
	    (key (char->integer #\<) 0 (choose-fd))
	    (key (char->integer #\i) 4 (choose-fd))
	    (key (char->integer #\a) 4 (choose-fd))
	    (key (char->integer #\i) 4 (choose-fd))
	    (key (char->integer #\e) 4 (choose-fd))
	    (key (char->integer #\i) 4 (choose-fd))
	    (key (char->integer #\b) 4 (choose-fd))
	    (key (char->integer #\i) 4 (choose-fd))
	    (if (not (provided? 'snd-gtk)) (key (char->integer #\p) 4 (choose-fd))) ;this is apparently getting hung in gtk (or maybe it's the c-q below)
	    (key (char->integer #\i) 4 (choose-fd))
	    (key (char->integer #\n) 4 (choose-fd))
	    (key (char->integer #\i) 4 (choose-fd))
	    (key (char->integer #\l) 4 (choose-fd))
	    (if (rs 0.5) (begin (key (char->integer #\x) 4) (key (char->integer #\b) 0)))
	    (set! (cursor (choose-fd)) 1200)
	    (safe-make-region 1000 2000 (choose-fd))
	    (if (selection?) (delete-selection))
	    (set! (cursor (choose-fd)) 0)
	    (insert-region (cursor) (car (regions)) (choose-fd))
	    (revert-sound (choose-fd))
	    (key (char->integer #\m) 4 (choose-fd))
	    (key (char->integer #\v) 4 (choose-fd))
	    (key (char->integer #\d) 4 (choose-fd))
	    (key (char->integer #\z) 4 (choose-fd))
	    (key (char->integer #\o) 4 (choose-fd))
	    (if (rs 0.5) (begin (key (char->integer #\x) 4)) (key (char->integer #\u) 0))
	    (undo 2 (choose-fd))
	    (key (char->integer #\<) 4 (choose-fd))
	    (key (char->integer #\i) 4 (choose-fd))
	    (key (char->integer #\w) 4 (choose-fd))
	    (key (char->integer #\y) 4 (choose-fd))
	    (if (not (provided? 'snd-gtk)) (key (char->integer #\q) 4 (choose-fd)))
	    (set! (cursor (choose-fd)) 8000)
	    (if (rs 0.5) (begin (key (char->integer #\x) 4) (key (char->integer #\f) 0) (key (char->integer #\g) 4)))
	    (if (rs 0.5) (begin (key (char->integer #\x) 4) (key (char->integer #\i) 0) (key (char->integer #\g) 4)))
	    (if (rs 0.5) (begin (key (char->integer #\x) 4) (key (char->integer #\l) 0) (key (char->integer #\g) 4)))
	    (if (rs 0.5) (begin (key (char->integer #\x) 4) (key (char->integer #\u) 0)))
	    (if (rs 0.5) (begin (key (char->integer #\x) 4) (key (char->integer #\r) 0)))
	    (if (rs 0.5) (begin (key (char->integer #\x) 4) (key (char->integer #\v) 0)))
	    (if (rs 0.5) (begin (key (char->integer #\x) 4) (key (char->integer #\o) 4)))
	    (if (rs 0.5) (begin (key (char->integer #\x) 4) (key (char->integer #\u) 4)))

	    (revert-sound)
	    (select-all)
	    (without-errors
	     (if (and (region? 0) (selection?))
		 ;; these are not necessarily coupled any more
		 (let ((r1 (region-rms (car (regions))))
		       (r2 (selection-rms))
		       (r3 (selection-rms-1))
		       (r4 (region-rms-1 (car (regions)))))
		   (IF (fneq r1 r4)
		       (snd-display ";region rms: ~A ~A?" r1 r4))
		   (IF (fneq r2 r3)
		       (snd-display ";selection rms: ~A ~A?" r2 r3)))))

	    (forward-graph (choose-fd))
	    (backward-graph (choose-fd))
	    (forward-mix (choose-fd))
	    (backward-mix (choose-fd))

	    (without-errors (protect-region (list-ref (regions) 2) #t))
	    (without-errors (play-region (list-ref (regions) 2) #t))
	    (without-errors (mix-region))
	    (set! (use-sinc-interp) #t)
	    (play-and-wait)
	    (set! (use-sinc-interp) #f)
	    (scale-to .1 (choose-fd))
	    (scale-by 2.0 (choose-fd))
	    (equalize-panes)
	    (save-controls)
	    (set! (amp-control) .5)
	    (test-panel amp-control 'amp-control)
	    (restore-controls)
	    (report-in-minibuffer "hi")
	    (append-to-minibuffer "ho")
	  
	    (without-errors
	     (begin
	       (let ((cfd (choose-fd)))
		 (safe-make-region 1000 2000 cfd)
		 (src-selection .5)
		 (undo 1 cfd))
	       (let ((cfd (choose-fd)))
		 (safe-make-region 1000 2000 cfd)
		 (src-selection -1.5)
		 (undo 1 cfd))
	       (let ((cfd (choose-fd)))
		 (safe-make-region 1000 2000 cfd)
		 (scale-selection-by .5)
		 (undo 1 cfd))
	       (let ((cfd (choose-fd)))
		 (safe-make-region 1000 2000 cfd)
		 (env-selection '(0 0 1 1 2 0))
		 (undo 1 cfd))
	       (let ((cfd (choose-fd)))
		 (safe-make-region 1000 2000 cfd)
		 (scale-selection-to .5)
		 (reverse-selection)
		 (undo 2 cfd))
	       (if (> (length (regions)) 2) (forget-region (list-ref (regions) 2)))))
	    (map revert-sound open-files)

	    (without-errors
	     (let ((cfd (car open-files)))
	       (set! (sync cfd) 1)
	       (if (not (null? (cdr open-files))) (set! (sync (cadr open-files)) 1))
	       (if (rs 0.5)
		   (begin
		     (safe-make-region 1000 2000 cfd)
		     (src-selection .5)
		     (undo 1 cfd)))
	       (if (rs 0.5)
		   (begin
		     (safe-make-region 1000 2000 cfd)
		     (src-selection -1.5)
		     (undo 1 cfd)))
	       (if (rs 0.5)
		   (begin
		     (safe-make-region 1000 2000 cfd)
		     (env-selection '(0 0 1 1 2 0))
		     (undo 1 cfd)))
	       (if (rs 0.5)
		   (begin
		     (safe-make-region 1000 2000 cfd)
		     (reverse-selection)
		     (undo 1 cfd)))
	       (if (rs 0.5)
		   (begin
		     (safe-make-region 1000 2000 cfd)
		     (filter-selection '(0 0 .1 1 1 0) 40)
		     (undo 1 cfd)))
	       (if (rs 0.5)
		   (begin
		     (safe-make-region 1000 2000 cfd)
		     (convolve-selection-with "oboe.snd")
		     (undo 1 cfd)))
	       (if (rs 0.5)
		   (begin
		     (safe-make-region 1000 2000 cfd)
		     (smooth-selection)
		     (undo 1 cfd)))
	       (if (rs 0.5)
		   (begin
		     (safe-make-region 1000 2000 cfd)
		     (scale-selection-by .5)
		     (undo 1 cfd)))
	       (if (rs 0.5)
		   (begin
		     (scale-selection-to .5)
		     (reverse-selection)
		     (undo 2)
		     (src-selection '(0 .5 1 1))
		     (undo)))
	       (revert-sound cfd)
	       (if (not (null? (cdr open-files))) (revert-sound (cadr open-files)))))
	  
	    (if (> (frames) 1) 
		(begin
		  (make-region 0 (frames))
		  (convolve-selection-with "fyow.snd" .5)
		  (play-and-wait)))
	    (convolve-with "fyow.snd" .25)
	    (insert-sound "oboe.snd")
	    (reset-hook! graph-hook)
	    (reset-hook! transform-hook)
	    (map revert-sound open-files)
	  
	    (let ((ind (open-sound "z.snd")))
	      (IF (not (equal? (peak-env-info ind) '()))
		  (snd-display ";peak-env-info z.snd: ~A" (peak-env-info ind)))
	      (let ((var (catch #t (lambda () (write-peak-env-info-file ind 0 "hi")) (lambda args args))))
		(IF (not (eq? (car var) 'no-such-envelope))
		    (snd-display ";write-peak-env-info-file null env: ~A" var)))
	      (let ((var (catch #t (lambda () (read-peak-env-info-file ind 0 "hi")) (lambda args args))))
		(IF (not (eq? (car var) 'no-such-file))
		    (snd-display ";read-peak-env-info-file null file: ~A" var)))
	      (IF (not (= (frames ind) 0)) (snd-display ";frames z.snd ~A" (frames ind)))
	      (IF (fneq (maxamp ind) 0.0) (snd-display ";maxamp z.snd ~A" (maxamp ind)))
	      (IF (fneq (sample 100 ind) 0.0) (snd-display ";sample 100 z.snd ~A" (sample 100 ind)))
	      (let ((var (catch #t (lambda () (samples->vct)) (lambda args args))))
		(IF (not (eq? (car var) 'impossible-bounds))
		    (snd-display ";samples->vct null: ~A" var)))
	      (close-sound ind))
	    (IF (channel-amp-envs "z.snd" 0 100)
		(snd-display ";channel-amp-envs of empty file: ~A" (channel-amp-envs "z.snd" 0 100)))

	    (let ((zz (view-sound "z.snd")))
	      (select-sound zz)
	      (let ((md (mix "4.aiff")))
		(add-mark 0)
		(add-mark 1200)
		(delete-marks)
		(if (and (number? md) (>= md 0))
		    (begin
		      (set! (mix-locked md) #t)
		      (IF (not (mix-locked md)) (snd-display ";set-mix-locked: ~A?" (mix-locked md))))))
	      (revert-sound zz)
	      (let ((editctr (edit-position zz)))
		(IF (not (= (edit-position) 0)) (snd-display ";revert-sound edit-position: ~A" (edit-position)))
		(as-one-edit 
		 (lambda ()
		   (mix s8-snd 24000)
		   (select-all)
		   (if (selection?) 
		       (begin
			 (filter-selection '(0 0 .2 1 .5 0 1 0) 40)
			 (delete-selection)
			 (mix-region)))))
		(IF (not (= (edit-position) 1)) (snd-display ";as-one-edit mix zz: ~A -> ~A" editctr (edit-position))))
	      (close-sound zz))
	    (let ((s8 (view-sound s8-snd)))
	      (select-sound s8)
	      (if (= (channels s8) 8)
		  (begin
		    (select-channel 5)
		    (IF (or (not (number? (selected-channel)))
			    (not (= (selected-channel) 5))) 
			(snd-display ";select-channel: ~A?" (selected-channel)))))
	      (let ((editctr (edit-position)))
		(as-one-edit 
		 (lambda ()
		   (select-all)
		   (delete-selection)
		   (mix "4.aiff")
		   (set! (sync) 1)
		   (mix "oboe.snd" 60000)
		   (scale-by .1)
		   (set! (sync) 1)
		   (if (> (channels s8) 3)
		       (select-channel 3))
		   (insert-region 80000)))
		(IF (not (= (edit-position) (1+ editctr))) (snd-display ";as-one-edit s8: ~A -> ~A" editctr (edit-position))))
	      (revert-sound s8)
	      (close-sound s8))
	  
	    (let ((cfd (choose-fd)))
	      (if (> (chans cfd) 1)
		  (let ((uval (my-random 3)))
		    (set! (channel-style cfd) uval)
		    (IF (not (= uval (channel-style cfd))) (snd-display ";channel-style: ~A ~A?" uval (channel-style cfd)))))
	      (if (rs 0.5) (src-sound 2.5 1.0 cfd))
	      (if (rs 0.5) (src-sound -2.5 1.0 cfd))
	      (if (rs 0.5) (src-sound .5 1.0 cfd))
	      (if (rs 0.5) (revert-sound cfd))
	      (if (rs 0.5) (src-sound -.5 1.0 cfd))
	      (if (rs 0.5) (src-sound '(0 .5 1 1.5) 1.0 cfd))
	      (if (rs 0.5) (if (> (frames cfd) 0) (src-sound (make-env '(0 .5 1 1.5) :end (1- (frames cfd))) 1.0 cfd)))
	      (if (rs 0.5) (revert-sound cfd))
	      (if (rs 0.5) (filter-sound '(0 1 .2 0 .5 1 1 0) 20 cfd))      ; FIR direct form
	      (if (rs 0.5) (filter-sound '(0 0 .1 0 .11 1 .12 0 1 0) 2048 cfd))
	      (if (rs 0.5) (env-sound '(0 0 .5 1 1 0) 0 (frames cfd) 1.0 cfd))
	      (if (rs 0.5)
		  (begin
		   (insert-sample 1200 .1 cfd)
		   (IF (fneq (sample 1200 cfd) .1) (snd-display ";insert-sample(looped): ~A?" (sample 1200 cfd)))))
	      (revert-sound cfd))

	  (let ((cfd (open-sound "obtest.snd")))
	    (select-sound cfd)
	    (let ((cfd2 (open-sound "pistol.snd")))
	      (select-sound cfd2)
	      ;; now run apply a few times
	      (if (rs 0.5) (set! (use-sinc-interp) #t))
	      (set! (amp-control) .5) 
	      (set! (speed-control) 2.0) 
	      (test-panel speed-control 'speed-control)
	      (apply-controls) 
	      (play-and-wait)

	      (IF (fneq (reverb-control-decay cfd) (reverb-control-decay))
		  (snd-display ";reverb-control-decay local: ~A, global: ~A" (reverb-control-decay cfd) (reverb-control-decay)))
	      (set! (reverb-control?) #t)
	      (set! (reverb-control-scale) .2) 
	      (test-panel reverb-control-scale 'reverb-control-scale)
	      (test-panel reverb-control-length 'reverb-control-length)
	      (test-panel reverb-control-lowpass 'reverb-control-lowpass)
	      (test-panel reverb-control-feedback 'reverb-control-feedback)
	      (apply-controls) 
	      (play-and-wait)
	      (set! (contrast-control?) #t)
	      (set! (contrast-control) .5) 
	      (test-panel contrast-control 'contrast-control)
	      (test-panel contrast-control-amp 'contrast-control-amp)
	      (apply-controls) 
	      (play-and-wait)
	      (set! (expand-control?) #t)
	      (set! (expand-control) 2.5) 
	      (test-panel expand-control 'expand-control)
	      (test-panel expand-control-length 'expand-control-length)
	      (test-panel expand-control-hop 'expand-control-hop)
	      (test-panel expand-control-ramp 'expand-control-ramp)
	      (apply-controls) 
	      (play-and-wait)
	      (set! (filter-control?) #t)
	      (set! (filter-control-order) 40) 
	      (test-panel filter-control-order 'filter-control-order)
	      (set! (filter-control-env) '(0 0 .1 1 .2 0 1 0)) 
	      (filter-control-env) 
	      (apply-controls) 
	      (play-and-wait)
	      (set! (amp-control) 1.5) 
	      (test-panel amp-control 'amp-control)
	      (apply-controls) 
	      (play-and-wait)
	      (swap-channels cfd 0 cfd2 0)
	      (set! (amp-control #t) .75)
	      (test-panel amp-control 'amp-control)
	      (IF (> (abs (- (amp-control cfd2) .75)) .05) (snd-display ";set-amp .75 #t -> ~A?" (amp-control cfd2)))
	      (set! (contrast-control-amp #t) .75)
	      (IF (fneq (contrast-control-amp cfd2) .75) (snd-display ";set-contrast-control-amp .75 #t -> ~A?" (contrast-control-amp cfd2)))
	      (set! (expand-control-length #t) .025)
	      (IF (fneq (expand-control-length cfd2) .025) (snd-display ";set-expand-control-length .025 #t -> ~A?" (expand-control-length cfd2)))
	      (set! (expand-control-hop #t) .025)
	      (IF (fneq (expand-control-hop cfd2) .025) (snd-display ";set-expand-control-hop .025 #t -> ~A?" (expand-control-hop cfd2)))
	      (set! (expand-control-ramp #t) .025)
	      (IF (fneq (expand-control-ramp cfd2) .025) (snd-display ";set-expand-control-ramp .025 #t -> ~A?" (expand-control-ramp cfd2)))
	      (let ((clone (clone-sound-as "/tmp/cloned.snd" cfd2)))
		(IF (not (= (frames cfd2) (frames clone)))
		    (snd-display ";clone frames: ~A ~A" (frames cfd2) (frames clone)))
		(IF (not (equal? (edits cfd2) (edits clone)))
		    (snd-display ";clone edits: ~A ~A" (edits cfd2) (edits clone)))
		(let ((eds (apply + (edits))))
		  (call-with-current-continuation
		   (lambda (break)
		     (do ((i 0 (1+ i)))
			 ((= i eds))
		       (IF (not (equal? (edit-fragment i cfd2) (edit-fragment i clone)))
			   (begin
			     (snd-display ";clone fragment[~A]: ~A ~A?" i (edit-fragment i cfd2) (edit-fragment i clone))
			     (break)))))))
		(close-sound clone))
	      (delete-file "/tmp/cloned.snd")
	      (close-sound cfd2)
	      (close-sound cfd)
	      (set! (use-sinc-interp) #f)))

	  (add-hook! (edit-hook) (lambda () #f))
	  (let ((editctr (edit-position)))
	    (as-one-edit (lambda () (set! (sample 200) .2) (set! (sample 300) .3)))
	    (IF (not (= (edit-position) (1+ editctr))) (snd-display ";as-one-edit: ~A -> ~A" editctr (edit-position))))
	  (delete-sample 250)
	  (add-hook! (undo-hook) (lambda () #f))
	  (undo)
	  (delete-sample 250)
	  (undo)
	  (as-one-edit (lambda () (set! (sample 20) .2) (set! (sample 30) .3)))
	  (undo 1)
	  (as-one-edit (lambda () (set! (sample 2) .2) (set! (sample 3) .3)))
	  (undo 2)
	  (reset-hook! (undo-hook))
	  (reset-hook! (edit-hook))
	  (add-hook! snd-error-hook 
		     (lambda (msg) 
		       (IF (not (string=? msg "hiho")) (snd-display ";snd-error-hook: ~A?" msg))
		       #t))
	  (snd-error "hiho")
	  (add-hook! snd-warning-hook 
		     (lambda (msg) 
		       (IF (not (string=? msg "hiho")) (snd-display ";snd-warning-hook: ~A?" msg))
		       #t))
	  (snd-warning "hiho")
	  (reset-hook! snd-error-hook)
	  (reset-hook! snd-warning-hook)
	  (add-hook! name-click-hook 
		     (lambda (n) 
		       #t))
	  (redo 1)
	  (reset-hook! name-click-hook)
	  (set! (graph-transform?) #t)
	  (test-channel graph-transform? 'graph-transform?)
	  (test-channel graph-time? 'graph-time?)
	  (test-channel graph-lisp? 'graph-lisp?)
	  (test-channel frames 'frames)
	  (test-channel cursor 'cursor)
	  (test-channel cursor-size 'cursor-size)
	  (test-channel cursor-style 'cursor-style)
	  (test-channel left-sample 'left-sample)
	  (test-channel right-sample 'right-sample)
	  (test-channel squelch-update 'squelch-update)
	  (test-channel x-zoom-slider 'x-zoom-slider)
	  (test-channel y-zoom-slider 'y-zoom-slider)
	  (test-channel x-position-slider 'x-position-slider)
	  (test-channel y-position-slider 'y-position-slider)
	  (test-channel edit-position 'edit-position)
	  (test-channel maxamp 'maxamp)
	  (test-channel edit-hook 'edit-hook)
	  (test-channel after-edit-hook 'after-edit-hook)
	  (test-channel undo-hook 'undo-hook)
	  (set! (transform-type) histogram)
	  (set! (x-bounds) '(.1 .2))
	  (set! (transform-type) graph-transform-once)
	  (set! (x-bounds) '(.1 .2))
	  (add-hook! lisp-graph-hook display-energy)
	  (shell "df")
	  (reset-hook! graph-hook)
	  (add-hook! graph-hook correlate)
	  (set! (x-bounds) '(.1 .12))
	  (set! (x-bounds) '(.1 .2))
	  (remove-hook! graph-hook correlate)
	  (set! (graph-lisp?) #f)
	  (map-chan (map-silence .01 #f))
	  (let ((maxval (+ (maxamp) .01)))
	    (IF (not (every-sample? (lambda (y) (< y maxval)))) (snd-display ";every-sample: ~A?" maxval)))
	  (map-chan (echo .5 .75) 0 60000)
	  (reset-hook! transform-hook)
	  (reset-hook! lisp-graph-hook)
	  (add-hook! lisp-graph-hook 
		     (lambda (snd chn) 
		       (if (> (random 1.0) .5) 
			   (graph '#(0 1 2)) 
			   (graph (list '#(0 1 2) '#(3 2 0))))))

	  (do ((i 0 (1+ i)))
	      ((= i (max-sounds)))
	    (if (and (sound? i) (rs .5))
		(set! (sync i) (inexact->exact (my-random 3)))))
	  (add-hook! graph-hook superimpose-ffts)
	  (do ((i 0 (1+ i)))
	      ((= i 10))
	    (do ((j 0 (1+ j)))
		((= j (max-sounds)))
	      (if (and (sound? j) (> (frames j) 0) (rs .5))
		  (let* ((dur (/ (frames j) (srate j)))
			 (start (max 0.0 (min (- dur .1) (my-random dur)))))
		    (IF (> dur 0.0) 
			(set! (x-bounds) (list start (min (+ start .1) dur))))
		    ))))
	  (reset-hook! graph-hook)
	  (reset-hook! lisp-graph-hook)

	  ;; new variable settings 
	  (letrec ((reset-vars
		    (lambda (lst)
		      (if (not (null? lst))
			  (let ((name (list-ref (car lst) 0))
				(index (if (list-ref (car lst) 1) (choose-fd) #f))
				(setfnc (list-ref (car lst) 3))
				(minval (list-ref (car lst) 2))
				(maxval (list-ref (car lst) 4)))
			    
			    (if index
				(if (equal? minval #f)
				    (setfnc (rs 0.5) index)
				  (if (exact? minval)
				      (if (equal? name #t)
					  (setfnc (inexact->exact
						   (floor (expt 2 (min 31 (ceiling (/ (log (+ minval (floor (* (- maxval minval) (my-random 1.0))))) 
											(log 2)))))))
						  index)
					(setfnc (+ minval (inexact->exact (floor (* (- maxval minval) (my-random 1.0))))) index))
				    (setfnc (+ minval (* (- maxval minval) (my-random 1.0))) index)))
			      (if (equal? minval #f)
				  (setfnc (rs 0.5))
				(if (exact? minval)
				    (if (equal? name #t)
					(setfnc (inexact->exact
						 (floor (expt 2 (min 31 (ceiling (/ (log (+ minval (floor (* (- maxval minval) (my-random 1.0))))) 
										    (log 2))))))))
				      (setfnc (+ minval (inexact->exact (floor (* (- maxval minval) (my-random 1.0)))))))
				  (setfnc (+ minval (* (- maxval minval) (my-random 1.0)))))))
			    (reset-vars (cdr lst)))))))
		  (reset-vars 
		   (list
		    (list 'amp-control #t .1 set-amp-control 1.0)
		    ;(list 'ask-before-overwrite #f #f set-ask-before-overwrite #t)
		    (list 'auto-resize #f #f set-auto-resize #t)
		    (list 'auto-update #f #f set-auto-update #t)
		    (list 'channel-style #f 0 set-channel-style 2)
		    (list 'color-cutoff #f 0.0 set-color-cutoff 0.2)
		    (list 'color-inverted #f #f set-color-inverted #t)
		    (list 'color-scale #f 0.1 set-color-scale 1000.0)
		    (list 'contrast-control #t 0.0 set-contrast-control 1.0)
		    (list 'contrast-control-amp #t 0.0 set-contrast-control-amp 1.0)
		    (list 'contrast-control? #t #f set-contrast-control? #t)
		    (list 'auto-update-interval #f 60.0 set-auto-update-interval 120.0)
		    (list 'cursor-follows-play #f #f set-cursor-follows-play #t)
		    (list 'data-clipped #f #f set-data-clipped #t)
		    (list 'default-output-chans #f 1 set-default-output-chans 8)
		    ;(list 'default-output-format #f 1 set-default-output-format 12)
		    (list 'default-output-srate #f 22050 set-default-output-srate 44100)
		    ;(list 'default-output-type #f 0 set-default-output-type 2)
		    (list 'dot-size #f 1 set-dot-size 10)
		    (list 'enved-base #f 0.01  set-enved-base 100.0)
		    (list 'enved-clip? #f #f set-enved-clip? #t)
		    (list 'enved-in-dB #f #f set-enved-in-dB #t)
		    (list 'enved-exp? #f #f set-enved-exp? #t)
		    (list 'enved-power #f 3.0 set-enved-power 3.5)
		    (list 'enved-target #f 0 set-enved-target 2)
		    (list 'enved-wave? #f #f set-enved-wave? #t)
		    (list 'expand-control #t 0.1 set-expand-control 5.0)
		    (list 'expand-control-hop #t 0.01 set-expand-control-hop 0.5)
		    (list 'expand-control-length #t 0.1 set-expand-control-length 0.25)
		    (list 'expand-control-ramp #t 0.1 set-expand-control-ramp 0.4)
		    (list 'expand-control? #t #f set-expand-control? #t)
		    (list 'fft-window-beta #f 0.0  set-fft-window-beta 1.0)
		    (list 'fft-log-frequency #f #f set-fft-log-frequency #t)
		    (list 'fft-log-magnitude #f #f set-fft-log-magnitude #t)
		    (list 'transform-size #f 16 set-transform-size 4096)
		    (list 'transform-graph-type #f 0 set-transform-graph-type 2)
		    (list 'fft-window #f 0 set-fft-window dolph-chebyshev-window)
		    (list 'graph-transform? #t #f set-graph-transform? #t)
		    (list 'filter-control-in-dB #t #f set-filter-control-in-dB #t)
		    (list 'filter-control-order #t 2 set-filter-control-order 400)
		    (list 'filter-control? #t #f set-filter-control? #t)
		    (list 'graph-cursor #f 0 set-graph-cursor 35)
		    (list 'graph-style #f 0 set-graph-style 4)
		    (list 'graphs-horizontal #f #f set-graphs-horizontal #t)
		    (list 'max-transform-peaks #f 1 set-max-transform-peaks 100)
		    (list 'max-regions #f 1 set-max-regions 32)
		    (list 'min-dB #f -120.0 set-min-dB -30.0)
		    (list 'movies #f #f set-movies #t)
		    (list 'selection-creates-region #f #f set-selection-creates-region #t)
		    (list 'transform-normalization #f dont-normalize-transform set-transform-normalization normalize-transform-globally)
		    (list 'previous-files-sort #f 0 set-previous-files-sort 5)
		    (list 'print-length #f 2 set-print-length 32)
		    (list 'region-graph-style #f graph-lines set-region-graph-style graph-lollipops)
		    (list 'reverb-control-decay #f 0.0 set-reverb-control-decay 2.0)
		    (list 'reverb-control-feedback #t 1.00 set-reverb-control-feedback 1.1)
		    (list 'reverb-control-length #t 1.0 set-reverb-control-length 2.0)
		    (list 'reverb-control-lowpass #t 0.2 set-reverb-control-lowpass 0.99)
		    (list 'reverb-control-scale #t 0.0 set-reverb-control-scale 0.2)
		    (list 'reverb-control? #t #f set-reverb-control? #t)
		    (list 'show-axes #f 0 set-show-axes 2)
		    (list 'show-transform-peaks #f #f set-show-transform-peaks #t)
		    (list 'show-indices #f #f set-show-indices #t)
		    (list 'show-backtrace #f #f set-show-backtrace #t)
		    (list 'show-marks #f #f set-show-marks #t)
		    (list 'show-mix-waveforms #t #f set-show-mix-waveforms #t)
		    (list 'show-selection-transform #f #f set-show-selection-transform #t)
		    (list 'show-y-zero #f #f set-show-y-zero #t)
		    (list 'sinc-width #f 4 set-sinc-width 100)
		    (list 'spectro-cutoff #f 0.5 set-spectro-cutoff 0.8)
		    (list 'spectro-hop #f 2 set-spectro-hop 20)
		    (list 'spectro-start #f 0.0 set-spectro-start 0.1)
		    (list 'spectro-x-angle #f 0.0 set-spectro-x-angle 90.0)
		    (list 'spectro-x-scale #f 0.1 set-spectro-x-scale 2.0)
		    (list 'spectro-y-angle #f 0.0 set-spectro-y-angle 90.0)
		    (list 'spectro-y-scale #f 0.1 set-spectro-y-scale 2.0)
		    (list 'spectro-z-angle #f 0.0 set-spectro-z-angle 359.0)
		    (list 'spectro-z-scale #f 0.1 set-spectro-z-scale 0.2)
		    (list 'speed-control #t 0.1 set-speed-control 5.0)
		    (list 'speed-control-style #f 0 set-speed-control-style 2)
		    (list 'speed-control-tones #f 2 set-speed-control-tones 100)
		    (list 'sync #t 0 set-sync 5)
		    (list 'transform-type #f 0 set-transform-type 6)
		    (list 'use-sinc-interp #f #f set-use-sinc-interp #t)
		    (list 'verbose-cursor #f #f set-verbose-cursor #t)
		    (list 'wavelet-type #f 0 set-wavelet-type 10)
		    (list 'graph-time? #t #f set-graph-time? #t)
		    (list 'x-axis-style #f 0 set-x-axis-style 2)
		    (list 'beats-per-minute #f 60.0 set-beats-per-minute 120.0)
		    (list 'zero-pad #f 0 set-zero-pad 2)
		    (list 'zoom-focus-style #f 0 set-zoom-focus-style 3))))
	  
	  (save-options "hiho.scm")
	  (if (not (= (transform-type) fourier-transform))
	      (begin
		(set! (graph-transform? #t #t) #f)
		(set! (transform-size) (min (transform-size) 128))))

	  )))
      (if open-files (map close-sound open-files))
      (set! open-files '())
      (set! (mus-rand-seed) 1234)
      (IF (not (= (mus-rand-seed) 1234)) (snd-display ";mus-rand-seed: ~A (1234)!" (mus-rand-seed)))
      (let ((val (mus-random 1.0))
	    (val1 (mus-random 1.0)))
	(IF (or (fneq val -0.7828) 
		(fneq val1 -0.8804))
	    (snd-display ";mus-random: ~A ~A?" val val1))
	(IF (= (mus-rand-seed) 1234) (snd-display ";mus-rand-seed: ~A!" (mus-rand-seed))))
      (set! (mus-rand-seed) 1234)
      (let ((val (mus-random 1.0))
	    (val1 (mus-random 1.0)))
	(IF (or (fneq val -0.7828) 
		(fneq val1 -0.8804))
	    (snd-display ";mus-random repeated: ~A ~A?" val val1)))
      )
    )

(define prefix-it
  (lambda (n id)
    (let* ((ns (number->string n))
	   (digits (string-length ns)))
      (key (char->integer #\u) 0 id)
      (do ((i 0 (1+ i)))
	  ((= i digits))
	(key (char->integer (string-ref ns i)) 0 id)))))

(define prefix-uit
  (lambda (n id)
    (let* ((ns (number->string n))
	   (digits (string-length ns)))
      (do ((i 0 (1+ i)))
	  ((= i digits))
	(key (char->integer (string-ref ns i)) 0 id)))))

(define funcs (list time-graph-type wavo-hop wavo-trace max-transform-peaks show-transform-peaks zero-pad transform-graph-type fft-window 
		    verbose-cursor fft-log-frequency fft-log-magnitude min-dB wavelet-type transform-size fft-window-beta transform-type 
		    transform-normalization show-mix-waveforms graph-style dot-size show-axes show-y-zero show-marks
		    spectro-x-angle spectro-x-scale spectro-y-angle spectro-y-scale spectro-z-angle spectro-z-scale
		    spectro-hop spectro-cutoff spectro-start graphs-horizontal x-axis-style beats-per-minute
		    ))
(define set-funcs (list set-time-graph-type set-wavo-hop set-wavo-trace set-max-transform-peaks 
			set-show-transform-peaks set-zero-pad set-transform-graph-type set-fft-window 
			set-verbose-cursor set-fft-log-frequency set-fft-log-magnitude set-min-dB set-wavelet-type 
			set-transform-size set-fft-window-beta set-transform-type 
			set-transform-normalization set-show-mix-waveforms set-graph-style set-dot-size set-show-axes set-show-y-zero set-show-marks
			set-spectro-x-angle set-spectro-x-scale set-spectro-y-angle set-spectro-y-scale set-spectro-z-angle set-spectro-z-scale
			set-spectro-hop set-spectro-cutoff set-spectro-start set-graphs-horizontal set-x-axis-style set-beats-per-minute
		    ))
(define func-names (list 'time-graph-type 'wavo-hop 'wavo-trace 'max-transform-peaks 'show-transform-peaks 'zero-pad 'transform-graph-type 'fft-window
			 'verbose-cursor 'fft-log-frequency 'fft-log-magnitude 'min-dB 'wavelet-type 'transform-size 'fft-window-beta 'transform-type
			 'transform-normalization 'show-mix-waveforms 'graph-style 'dot-size 'show-axes 'show-y-zero 'show-marks
			 'spectro-x-angle 'spectro-x-scale 'spectro-y-angle 'spectro-y-scale 'spectro-z-angle 'spectro-z-scale
			 'spectro-hop 'spectro-cutoff 'spectro-start 'graphs-horizontal 'x-axis-style 'beats-per-minute
			 ))
(define new-values (list graph-time-as-wavogram 12 512 3 #t 32 graph-transform-as-sonogram cauchy-window
			 #t #t #t -120.0 3 32 .5 autocorrelation
			 0 #t graph-lollipops 8 show-no-axes #t #f
			 32.0 .5 32.0 .5 32.0 .5
			 14 .3 .1 #f x-axis-in-samples 120.0
			 ))

(define test-history-channel
  (lambda (func set-func name new-value snd1 snd2 snd3)
    (define next-chan
      (lambda (snd chn)
	(if (< chn (channels snd))
	    (cons (func snd chn) (next-chan snd (1+ chn)))
	    '())))
    (define next-snd-case 
      (lambda (snd)
	(if (< snd (max-sounds))
	    (if (sound? snd)
		(cons (next-chan snd 0) (next-snd-case (1+ snd)))
		(next-snd-case (1+ snd)))
	    '())))
    (define test-equal
      (lambda (nv new-value)
	(if (and (number? nv)
		 (inexact? nv))
	    (not (fneq nv new-value))
	    (equal? nv new-value))))
    (define chan-equal? 
      (lambda (vals new-value)
	(cond ((null? vals) #t)
	      ((list? vals) (and (chan-equal? (car vals) new-value)
				 (chan-equal? (cdr vals) new-value)))
	      (else (test-equal vals new-value)))))
    (IF (not (equal? (func #t #t) (next-snd-case 0)))
	(snd-display ";test-history-channel ~A[0]: ~A ~A?" name (func #t #t) (next-snd-case 0)))
    (let ((old-value (func))
	  (old-chan-value (func snd1 0)))
      (set-func new-value snd1 0)
      (let ((nv (func snd1 0)))
	(IF (not (test-equal nv new-value))
	    (snd-display ";test-history-channel set-~A[1]: ~A ~A?" name new-value (func snd1 0))))
      (set-func new-value snd3 2)
      (let ((nv (func snd3 2)))
	(IF (not (test-equal nv new-value))
	    (snd-display ";test-history-channel set-~A[2]: ~A ~A?" name new-value (func snd3 2))))
      (IF (not (test-equal old-value new-value))
	  (let ((nv (func snd3 1)))
	    (IF (test-equal nv new-value)
		(snd-display ";test-history-channel set-~A[3]: ~A ~A?" name new-value (func snd3 1)))))
      (set-func new-value snd2 #t)
      (let ((nv (func snd2 1)))
	(IF (not (test-equal nv new-value))
	    (snd-display ";test-history-channel set-~A[4]: ~A ~A?" name new-value (func snd2 1))))
      (set-func new-value)
      (IF (not (chan-equal? (func #t #t) new-value))
	  (snd-display ";test-history-channel ~A[5]: ~A ~A?" name (func #t #t) (next-snd-case 0)))
      (set-func old-value)
      )))
      
(load "rubber.scm")

;;; ---------------- test 15: chan-local vars ----------------

(define (smoother y0 y1 num)
   (let ((v (make-vct (1+ num))) 
	 (angle (if (> y1 y0) pi 0.0)) 
	 (off (* .5 (+ y0 y1))) 
	 (incr (/ pi num))
	 (scale (* 0.5 (abs (- y1 y0)))))
     (do ((i 0 (1+ i)))
         ((= i num) v)
       (vct-set! v i (+ off (* scale (cos (+ angle (* i incr)))))))))

(if (and (not (provided? 'snd-nogui)) 
	 (or full-test (= snd-test 15) (and keep-going (<= snd-test 15))))
    (let ((obi (open-sound (car (match-sound-files (lambda (file) 
						     (and (not (= (mus-sound-header-type file) mus-raw))
							  (= (mus-sound-chans file) 1))))))))

      (define (test-selection ind beg len scaler)
	(set! (selection-member? ind 0) #t)
	(set! (selection-position) beg)
	(set! (selection-length) len)
	(scale-selection-by scaler)
	(let* ((diff 0.0)
	       (pos (edit-position ind 0))
	       (old-reader (make-sample-reader beg ind 0 1 (1- pos)))
	       (new-reader (make-sample-reader beg ind 0 1 pos)))
	  (do ((i 0 (1+ i)))
	      ((= i len))
	    (let* ((ov (* scaler (old-reader)))
		   (nv (next-sample new-reader))
		   (val (abs (- ov nv))))
	      (set! diff (+ diff val))))
	  (IF (> diff 0.0) (snd-display ";diff (~D ~D): ~A" beg len diff))
	  (set! diff 0.0)
	  (do ((i 0 (1+ i)))
	      ((= i 100))
	    (let* ((ov (next-sample old-reader))
		   (nv (next-sample new-reader))
		   (val (abs (- ov nv))))
	      (set! diff (+ diff val))))
	  (IF (> diff 0.0) (snd-display ";zdiff (~D ~D): ~A" beg len diff))
	  (free-sample-reader old-reader)
	  (free-sample-reader new-reader)))

      (define (test-selection-to ind beg len maxval)
	(set! (selection-member? ind 0) #t)
	(set! (selection-position) beg)
	(set! (selection-length) len)
	(scale-selection-to maxval)
	(let* ((newmax 0.0)
	       (new-reader (make-sample-reader beg ind 0)))
	  (do ((i 0 (1+ i)))
	      ((= i len))
	    (let* ((nv (abs (next-sample new-reader))))
	      (if (> nv newmax) (set! newmax nv))))
	  (IF (fneq newmax maxval)
	      (snd-display ";scale-selection-to (~D ~D) ~A: ~A?" beg len maxval newmax))
	  (free-sample-reader new-reader)))

      (define play-with-amps
	(lambda (sound . amps)
	  (let ((chans (chans sound)))
	    (do ((chan 0 (1+ chan)))
		((= chan chans))
	      (let ((player (make-player sound chan)))
		(IF (not (player? player)) (snd-display ";player? ~A -> #f?" player))
		(IF (not (equal? (player-home player) (list sound chan)))
		    (snd-display ";player-home ~A ~A?" (player-home player) (list sound chan)))
		(set! (amp-control player) (list-ref amps chan))
		(set! (speed-control player) .5)
		(set! (expand-control? player) #t)
		(set! (expand-control player) 2.0)
		(set! (contrast-control? player) #t)
		(set! (contrast-control player) 1.0)
		(set! (reverb-control? player) #t)
		(set! (reverb-control-scale player) .02)
		(add-player player)))
	    (start-playing chans (srate sound) #f))))

      (if (procedure? test-hook) (test-hook 15))
      (IF (not (equal? (all-chans) (list (list obi) (list 0)))) (snd-display ";all-chans: ~A?" (all-chans)))
      (let ((s2i (open-sound (car (match-sound-files (lambda (file) (= (mus-sound-chans file) 2)))))))
	(IF (and (not (equal? (all-chans) (list (list obi s2i s2i) (list 0 0 1))))
		 (not (equal? (all-chans) (list (list s2i s2i obi) (list 0 1 0)))))
		 (snd-display ";all-chans(2): ~A?" (all-chans)))
	(IF (not (string=? (finfo "oboe.snd") "oboe.snd: chans: 1, srate: 22050, Sun, big endian short (16 bits), len: 2.305"))
	    (snd-display ";finfo: ~A?" (finfo "oboe.snd")))
	(close-sound s2i)
	(close-sound obi)
	(IF (not (equal? (all-chans) '(() ()))) (snd-display ";all-chans(0): ~A?" (all-chans)))
	(set! obi (open-sound "oboe.snd"))
	(set! (cursor obi) 1000)
	(IF (not (= (locate-zero .001) 1050)) (snd-display ";locate-zero: ~A?" (locate-zero .001)))
	(add-hook! graph-hook auto-dot)
	(add-hook! graph-hook superimpose-ffts)
	(set! (graph-transform? obi 0) #t)
	(update-graphs)
	(set! s2i (open-sound (car (match-sound-files (lambda (file) (= (mus-sound-chans file) 2))))))
	(IF (not (= (chans s2i) 2)) (snd-display ";match 2 got ~A with ~A chans" (short-file-name s2i) (chans s2i)))
	(update-graphs)
	(remove-hook! graph-hook auto-dot)
	(remove-hook! graph-hook superimpose-ffts)
	(set! (graph-transform? obi 0) #f)
	(select-sound obi)
	(let ((m1 (add-mark 100 obi 0)))
	  (first-mark-in-window-at-left)
	  (IF (> (abs (- (left-sample obi 0) 100)) 1) (snd-display ";mark-in-window: ~A ~A?" (left-sample obi 0) (mark-sample m1)))
	  (delete-mark m1))
	(close-sound s2i)
	(safe-make-region 1000 2000 obi)
	(delete-selection-and-smooth)
	(IF (not (equal? (edit-fragment 0 obi 0) '(#f "init" 0 50828))) 
	    (snd-display ";edit-fragment(0): ~A?" (edit-fragment 0 obi 0)))
	(IF (not (equal? (edit-fragment 1 obi 0) '("delete-samples" "delete" 1000 1001))) 
	    (snd-display ";edit-fragment(1): ~A?" (edit-fragment 0 obi 0)))
	(IF (not (equal? (edit-fragment 2 obi 0) '("smooth-sound" "set" 984 32))) 
	    (snd-display ";edit-fragment(2): ~A?" (edit-fragment 0 obi 0)))

	(let ((samp100 (sample 1100 obi 0)))
	  (safe-make-region 1000 2000 obi)
	  (eval-over-selection (lambda (val) (* 2.0 val)))
	  (let ((nsamp100 (sample 1100 obi 0)))
	    (IF (fneq (* 2.0 samp100) nsamp100) 
		(snd-display ";eval-over-selection: ~A ~A [~A ~A]?" 
				     samp100 nsamp100 (selection-position) (selection-length)))
	    (let ((m2 (add-mark 1000 obi 0))
		  (m3 (add-mark 2000 obi 0)))
	      (IF (not (equal? (marks obi 0) (list m2 m3))) (snd-display ";add-mark: ~A ~A?" (marks obi 0) (list m2 m3)))
	      (eval-between-marks (lambda (val) (* 2.0 val)))
	      (let ((msamp100 (sample 1100 obi 0)))
		(IF (fneq (* 2.0 nsamp100) msamp100) (snd-display ";eval-between-marks: ~A ~A?" nsamp100 msamp100))
		(revert-sound obi)))))
	(let ((maxa (maxamp obi)))
	  (normalized-mix "pistol.snd" 1000 0 obi 0)
	  (let ((nmaxa (maxamp obi)))
	    (IF (fneq maxa nmaxa) (snd-display ";normalized-mix: ~A ~A?" maxa nmaxa)))
	  (revert-sound obi))
	(set! s2i (open-sound (car (match-sound-files (lambda (file) 
							  (and (= (mus-sound-chans file) 2)
							       (> (mus-sound-frames file) 1000)))))))
	(IF (not (= (chans s2i) 2)) (snd-display ";match 2+1000 got ~A with ~A chans" (short-file-name s2i) (chans s2i)))
	(let ((o1 (sample 1000 obi 0))
	      (s1 (sample 1000 s2i 0))
	      (s2 (sample 1000 s2i 1)))
	  (do-all-chans (lambda (val) (IF val (* 2.0 val) #f)) "double all samples")
	  (let ((o11 (sample 1000 obi 0))
		(s11 (sample 1000 s2i 0))
		(s21 (sample 1000 s2i 1)))
	    (IF (or (fneq (* 2.0 o1) o11)
		    (fneq (* 2.0 s1) s11)
		    (fneq (* 2.0 s2) s21))
		(snd-display ";do-all-chans: ~A?" (list o1 s1 s2 o11 s11 s21)))))
	(update-graphs)
	(let ((m1 (maxamp obi 0))
	      (m2 (maxamp s2i 0))
	      (m3 (maxamp s2i 1))
	      (mc (apply map maxamp (list (list obi s2i s2i) (list 0 0 1)))))
	  (IF (or (fneq m1 (car mc))
		  (fneq m2 (cadr mc))
		  (fneq m3 (caddr mc)))
	      (snd-display ";map maxamp all-chans: ~A ~A ~A ~A?" m1 m2 m3 mc))
	  (set! (sync obi) 1)
	  (set! (sync s2i) 1)
	  (do-chans (lambda (val) (if val (* 2.0 val) #f)) "*2")
	  (let ((mc1 (apply map maxamp (list (list obi s2i s2i) (list 0 0 1)))))
	    (IF (or (fneq (* 2.0 m1) (car mc1))
		    (fneq (* 2.0 m2) (cadr mc1))
		    (fneq (* 2.0 m3) (caddr mc1)))
		(snd-display ";do-chans: ~A ~A?" mc mc1))
	    (set! (sync obi) 0)
	    (set! (sync s2i) 0)
	    (select-sound s2i)
	    (do-sound-chans (lambda (val) (if val (* 0.5 val) #f)) "/2")
	    (let ((mc2 (apply map maxamp (list (list obi s2i s2i) (list 0 0 1)))))
	      (IF (or (fneq (* 2.0 m1) (car mc2))
		      (fneq m2 (cadr mc2))
		      (fneq m3 (caddr mc2)))
		  (snd-display ";do-sound-chans: ~A ~A ~A?" mc mc1 mc2)))
	    (IF (every-sample? (lambda (val) (> val .5))) (snd-display ";every-sample(0)?")) 
	    (IF (not (every-sample? (lambda (val) (< val 5.0)))) (snd-display ";every-sample(1)?")) 
	    (select-sound obi)
	    (let ((bins (sort-samples 32)))
	      (IF (not (= (vector-ref bins 1) 4504)) (snd-display ";sort-samples: ~A?" bins)))
	    ))
	(revert-sound s2i)
	(revert-sound obi)
	(set! (sync obi) 3)
	(set! (sync s2i) 3)
	(let* ((half-way (inexact->exact (* 0.5 (frames obi))))
	       (o1 (sample half-way obi 0))
	       (s1 (sample half-way s2i 0))
	       (s2 (sample half-way s2i 1)))
	  (place-sound obi s2i '(0 .5 1 .5))
	  (let ((s21 (sample half-way s2i 0))
		(s22 (sample half-way s2i 1)))
	    (revert-sound s2i)
	    (place-sound obi s2i 45.0)
	    (let ((s31 (sample half-way s2i 0))
		  (s32 (sample half-way s2i 1)))
	      (IF (or (fneq (+ s1 (* 0.5 o1)) s21)
			(fneq (+ s2 (* 0.5 o1)) s22)
			(fneq s21 s31)
			(fneq s22 s32))
		    (snd-display ";place: ~A " (list o1 s1 s2 s21 s22 s31 s32))))))
	(revert-sound s2i)
	(revert-sound obi)
	(set! (sync obi) 0)
	(set! (sync s2i) 0)
	(IF (or (fneq ((compand) 0.0) 0.0)
		(fneq ((compand) 1.0) 1.0)
		(fneq ((compand) .1) .2)
		(fneq ((compand) .99) .997)
		(fneq ((compand) .95) .984))
	    (snd-display ";compand: ~A?" (list ((compand) 0.0) ((compand) 1.0) ((compand) .1) ((compand) .99) ((compand) .95))))
	
	(close-sound obi)
	(revert-sound s2i)
	(let ((s1 (sample 1000 s2i 0))
	      (s2 (sample 1000 s2i 1)))
	  (set! (sync s2i) 4)
	  (select-all)
	  (IF (not (= (selection-chans) 2)) 
	      (begin
		(snd-display ";selection-chans(2): ~A?" (selection-chans))
		(for-each
		 (lambda (snd)
		   (do ((i 0 (1+ i)))
		       ((= i (chans snd)))
		     (IF (selection-member? snd i)
			 (snd-display ";  ~A[~A] at ~A" (short-file-name snd) i (selection-position snd i)))))
		 (sounds))))
	  (IF (not (= (selection-srate) (srate s2i))) (snd-display ";selection-srate: ~A ~A?" (selection-srate) (srate s2i)))
	  (swap-selection-channels)
	  (IF (or (fneq s1 (sample 1000 s2i 1))
		  (fneq s2 (sample 1000 s2i 0)))
	      (snd-display ";swap-selection-channels: ~A?" (list s1 s2 (sample 1000 s2i 0) (sample 1000 s2i 1)))))
	(revert-sound s2i)
	(close-sound s2i)

	(set! obi (open-sound "oboe.snd"))
	(select-all)
	(for-each forget-region (regions))
	(IF (not (equal? (regions) '())) (snd-display ";no regions? ~A" (regions)))
	(let ((id (make-region 100 200 obi 0)))
	  (IF (not (equal? (regions) (list id))) (snd-display ";make-region regions: ~A?" (regions))))

	;; need tests for mixes 
	;; and all the temp|sound -to- sound|temp calls

	(revert-sound obi)
	(let ((oldlen (frames obi)))
	  (env-sound-interp '(0 0 1 1 2 0) 2.0 obi 0)
	  (let ((newlen (frames obi)))
	    (IF (> (abs (- (* 2 oldlen) newlen)) 3)
		(snd-display ";env-sound-interp: ~A ~A?" oldlen newlen))))

	(close-sound obi)
	)

      (let* ((id (open-sound "oboe.snd"))
	     (fr (frames id 0))
	     (mx (maxamp id 0)))
	(set! (frames id 0) 25000)
	(IF (not (= (frames id 0) 25000)) (snd-display ";set-frames 25000: ~A?" (frames id 0)))
	(IF (not (= (edit-position id 0) 1)) (snd-display ";set-frames 25000 edit: ~A?" (edit-position id 0)))
	(set! (frames id 0) 75000)
	(IF (not (= (frames id 0) 75000)) (snd-display ";set-frames 75000: ~A?" (frames id 0)))
	(IF (not (= (edit-position id 0) 2)) (snd-display ";set-frames 75000 edit: ~A?" (edit-position id 0)))
	(IF (fneq (sample 30000 id 0) 0.0) (snd-display ";set-frames 75000 zeros: ~A?" (sample 30000 id 0)))
	(set! (frames id 0) 0)
	(IF (not (= (frames id 0) 0)) (snd-display ";set-frames 0: ~A?" (frames id 0)))
	(set! (frames id 0) 100)
	(IF (not (= (frames id 0) 100)) (snd-display ";set-frames 100: ~A?" (frames id 0)))
	(revert-sound)
	(IF (fneq (sample 30000 id 0) -0.0844) (snd-display ";revert from set-frames: ~A?" (sample 30000 id 0)))
	(IF (not (= fr (frames id 0))) (snd-display ";revert set-frames: ~A != ~A?" (frames id 0) fr))
	(set! (maxamp id 0) .5)
	(IF (fneq (maxamp id 0) .5) (snd-display ";set-maxamp: ~A?" (maxamp id 0)))
	(IF (not (= (edit-position id 0) 1)) (snd-display ";set-maxamp edit: ~A?" (edit-position id 0)))
	(set! (maxamp id 0) .1)
	(IF (fneq (maxamp id 0) .1) (snd-display ";set-maxamp .1: ~A?" (maxamp id 0)))
	(IF (not (= (edit-position id 0) 2)) (snd-display ";set-maxamp .1 edit: ~A?" (edit-position id 0)))
	(revert-sound)
	(IF (fneq (maxamp id 0) mx) (snd-display ";maxamp after set: ~A ~A?" (maxamp id 0) mx))
	(set! (x-position-slider id 0) .1)
	(IF (fneq (x-position-slider id 0) .1) (snd-display ";set x-position-slider .1: ~A?" (x-position-slider id 0)))
	;(IF (> (abs (- (left-sample id 0) 5083)) 3) (snd-display ";set x-position-slider sample 5083: ~A?" (left-sample id 0)))
	(set! (x-zoom-slider id 0) .5)
	(IF (fneq (x-zoom-slider id 0) .5) (snd-display ";set x-zoom-slider: ~A?" (x-zoom-slider id 0)))
	(IF (> (abs (- fr (* 2 (- (right-sample id 0) (left-sample id 0))))) 10)
	    (snd-display ";set x-zoom-slider: ~A ~A -> ~A?" 
			       (left-sample id 0) (right-sample id 0)
			       (abs (- fr (* 2 (right-sample id 0) (left-sample id 0))))))
	(set! (y-position-slider id 0) .1)
	(IF (fneq (y-position-slider id 0) .1) (snd-display ";set y-position-slider .1: ~A?" (y-position-slider id 0)))
	(set! (y-zoom-slider id 0) .5)
	(IF (fneq (y-zoom-slider id 0) .5) (snd-display ";set y-zoom-slider: ~A?" (y-zoom-slider id 0)))
	(let ((vals (channel-amp-envs "oboe.snd" 0 10)))
	  (if (not (equal? vals
			   (list '#(-4.8828125e-4 -0.104156494140625 -0.125213623046875 -0.1356201171875 -0.138916015625 
				   -0.14093017578125 -0.14093017578125 -0.131439208984375 -0.11248779296875 -0.080047607421875) 
				 '#(0.0 0.10955810546875 0.130706787109375 0.14068603515625 0.141204833984375 0.147247314453125 
                                   0.145904541015625 0.140289306640625 0.126861572265625 0.08172607421875))))
	      (snd-display ";channel-amp-envs: ~A?" vals)))

	(let ((len (length (channel-properties id 0))))
	  (IF (channel-property 'hiho id 0)
	      (snd-display ";channel-property 'hiho: ~A?" (channel-property 'hiho id 0)))
	  (set! (channel-property 'hiho id 0) 123)
	  (IF (not (= (channel-property 'hiho id 0) 123))
	      (snd-display ";channel-property 'hiho (123): ~A?" (channel-property 'hiho id 0)))
	  (IF (channel-property 'hi id 0)
	      (snd-display ";channel-property 'hi: ~A?" (channel-property 'hi id 0)))
	  (set! (channel-property 'hi id 0) 3.1415)
	  (IF (fneq (channel-property 'hi id 0) 3.1415)
	      (snd-display ";channel-property 'hi (3.1415): ~A?" (channel-property 'hi id 0)))
	  (IF (not (= (channel-property 'hiho id 0) 123))
	      (snd-display ";channel-property '2nd hiho (123): ~A?" (channel-property 'hiho id 0)))
	  (IF (not (= (length (channel-properties id 0)) (+ len 2)))
	      (snd-display ";channel-properties: ~A?" (channel-properties id 0))))

	(let ((len (length (sound-properties id))))
	  (IF (sound-property 'hiho id)
	      (snd-display ";sound-property 'hiho: ~A?" (sound-property 'hiho id)))
	  (set! (sound-property 'hiho id) 123)
	  (IF (not (= (sound-property 'hiho id) 123))
	      (snd-display ";sound-property 'hiho (123): ~A?" (sound-property 'hiho id)))
	  (IF (sound-property 'hi id)
	      (snd-display ";sound-property 'hi: ~A?" (sound-property 'hi id)))
	  (set! (sound-property 'hi id) 3.1415)
	  (IF (fneq (sound-property 'hi id) 3.1415)
	      (snd-display ";sound-property 'hi (3.1415): ~A?" (sound-property 'hi id)))
	  (IF (not (= (sound-property 'hiho id) 123))
	      (snd-display ";sound-property '2nd hiho (123): ~A?" (sound-property 'hiho id)))
	  (IF (not (= (length (sound-properties id)) (+ len 2)))
	      (snd-display ";sound-properties: ~A?" (sound-properties id))))

	(close-sound id))

      (let ((id (open-sound "oboe.snd")))
	(prefix-it 1000 id)
	(key (char->integer #\x) 4 id)
	(key (char->integer #\b) 4 id)
	(let ((left (left-sample id)))
	  (IF (and (not (= left 1000)) (not (= left 1001))) (snd-display ";u1000: ~A" left)))
	(prefix-it 0 id)
	(key (char->integer #\x) 4 id)
	(key (char->integer #\b) 4 id)
	(let ((left (left-sample id)))
	  (IF (not (= left 0)) (snd-display ";u0: ~A" left)))
	(set! (cursor id) 1234)
	(prefix-it 0 id)
	(key (char->integer #\f) 4 id)
	(let ((cr (cursor id)))
	  (IF (not (= cr 1234)) (snd-display ";0f: ~A" cr)))
	(prefix-it 100 id)
	(key (char->integer #\f) 4 id)
	(let ((cr (cursor id)))
	  (IF (not (= cr 1334)) (snd-display ";100f: ~A" cr)))
	(prefix-it -100 id)
	(key (char->integer #\f) 4 id)
	(let ((cr (cursor id)))
	  (IF (not (= cr 1234)) (snd-display ";-100f: ~A" cr)))
	(prefix-it 1 id)
	(key (char->integer #\f) 4 id)
	(let ((cr (cursor id)))
	  (IF (not (= cr 1235)) (snd-display ";1f: ~A" cr)))
	(key (char->integer #\+) 4 id)
	(key (char->integer #\f) 4 id)
	(let ((cr (cursor id)))
	  (IF (not (= cr 1236)) (snd-display ";+f: ~A" cr)))
	(key (char->integer #\-) 4 id)
	(key (char->integer #\f) 4 id)
	(let ((cr (cursor id)))
	  (IF (not (= cr 1235)) (snd-display ";-f: ~A" cr)))
	(prefix-it 1000 id)
	(key (char->integer #\x) 4 id)
	(key (char->integer #\p) 4 id)
	(let ((left (left-sample id))
	      (right (right-sample id)))
	  (IF (> (abs (- right left 1000)) 2) (snd-display ";1000xp: ~A:~A" left right)))
	(prefix-it 1 id)
	(key (char->integer #\.) 0 id)
	(key (char->integer #\2) 0 id)
	(key (char->integer #\x) 4 id)
	(key (char->integer #\p) 4 id)
	(let ((left (left-sample id))
	      (right (right-sample id)))
	  (IF (> (abs (- right left (* 22050 1.2))) 2) (snd-display ";1.2xp: ~A:~A" left right)))
	
	(prefix-uit 1000 id)
	(key (char->integer #\x) 4 id)
	(key (char->integer #\b) 4 id)
	(let ((left (left-sample id)))
	  (IF (and (not (= left 1000)) (not (= left 1001))) (snd-display ";uu1000: ~A" left)))
	(prefix-uit 0 id)
	(key (char->integer #\x) 4 id)
	(key (char->integer #\b) 4 id)
	(let ((left (left-sample id)))
	  (IF (not (= left 0)) (snd-display ";uu0: ~A" left)))
	(set! (cursor id) 1234)
	(prefix-uit 0 id)
	(key (char->integer #\f) 4 id)
	(let ((cr (cursor id)))
	  (IF (not (= cr 1234)) (snd-display ";u0f: ~A" cr)))
	(prefix-uit 100 id)
	(key (char->integer #\f) 4 id)
	(let ((cr (cursor id)))
	  (IF (not (= cr 1334)) (snd-display ";u100f: ~A" cr)))
	(prefix-uit -100 id)
	(key (char->integer #\f) 4 id)
	(let ((cr (cursor id)))
	  (IF (not (= cr 1234)) (snd-display ";u-100f: ~A" cr)))
	(prefix-uit 1 id)
	(key (char->integer #\f) 4 id)
	(let ((cr (cursor id)))
	  (IF (not (= cr 1235)) (snd-display ";u1f: ~A" cr)))
	(key (char->integer #\+) 4 id)
	(key (char->integer #\f) 4 id)
	(let ((cr (cursor id)))
	  (IF (not (= cr 1236)) (snd-display ";u+f: ~A" cr)))
	(key (char->integer #\-) 4 id)
	(key (char->integer #\f) 4 id)
	(let ((cr (cursor id)))
	  (IF (not (= cr 1235)) (snd-display ";u-f: ~A" cr)))
	(prefix-uit 1000 id)
	(key (char->integer #\x) 4 id)
	(key (char->integer #\p) 4 id)
	(let ((left (left-sample id))
	      (right (right-sample id)))
	  (IF (> (abs (- right left 1000)) 2) (snd-display ";u1000xp: ~A:~A" left right)))
	(prefix-uit 1 id)
	(key (char->integer #\.) 0 id)
	(key (char->integer #\2) 0 id)
	(key (char->integer #\x) 4 id)
	(key (char->integer #\p) 4 id)
	(let ((left (left-sample id))
	      (right (right-sample id)))
	  (IF (> (abs (- right left (* 22050 1.2))) 2) (snd-display ";u1.2xp: ~A:~A" left right)))
	(close-sound id))
      (let ((id (open-sound (car (match-sound-files (lambda (file) 
							(and (>= (mus-sound-chans file) 2)
							     (> (mus-sound-frames file) 1000))))))))
	(set! (sync id) 1)
	(select-sound id)
	(make-region 200 500 id)
	(select-channel 1)
	(key (char->integer #\x) 4 id)
	(key (char->integer #\v) 0 id)
	(let ((x0 (x-bounds id 0))
	      (x1 (x-bounds id 1)))
	  (IF (or (fneq (car x0) (car x1)) 
		  (fneq (cadr x0) (cadr x1)))
	      (snd-display ";C-X v: ~A ~A?" x0 x1)))
	(close-sound id))

      (let ((snd1 (open-sound "oboe.snd"))
	    (snd2 (or (open-sound "2.snd") (open-sound "4.aiff")))
	    (snd3 (open-sound "4.aiff")))
	(define tests-1
	  (lambda (f sf fn nv)
	    (if (not (null? f))
		(begin
		  (test-history-channel (car f) (car sf) (car fn) (car nv) snd1 snd2 snd3)
		  (tests-1 (cdr f) (cdr sf) (cdr fn) (cdr nv))))))
	(tests-1 funcs set-funcs func-names new-values)
	(close-sound snd1)
	(close-sound snd2)
	(close-sound snd3))

      (let ((snd2 (open-sound "2.snd")))
	(if (sound? snd2)
	    (play-with-amps snd2 0.2 0.1))
	(close-sound snd2))
      (let ((ind (open-sound "pistol.snd")))
	(IF (selection-member? ind 0) 
	    (snd-display ";initial selection-member? ~A ~A?" 
			       (selection-member? ind 0)
			       (selection?)))
	(set! (selection-member? ind 0) #t)
	(IF (or (not (selection-member? ind 0))
		(not (selection-member? ind)))
	    (snd-display ";selection-member? ~A ~A ~A?" 
			       (selection-member? ind 0)
			       (selection-member? ind)
			       (selection?)))
	(IF (not (= (selection-length) 1))
	    (snd-display ";initial selection-length: ~A?" (selection-length)))
	(set! (selection-length) 1200)
	(IF (not (= (selection-length) 1200))
	    (snd-display ";selection-length: 1200 ~A?" (selection-length)))
	(delete-selection)
	(IF (selection?) (snd-display ";selection active after cut?"))
	(undo)
	(IF (not (selection?)) (snd-display ";selection inactive after undo?"))
	(IF (or (not (selection-member? ind 0))
		(not (selection-member? ind)))
	    (snd-display ";selection-member? after undo ~A ~A ~A?" 
			       (selection-member? ind 0)
			       (selection-member? ind)
			       (selection?)))
	(IF (or (not (= (selection-length) 1200))
		(not (= (selection-position) 0)))
	    (snd-display ";selection after undo: '(0 1200) '(~A ~A)?" 
			       (selection-position) 
			       (selection-length)))
	(set! (selection-position) 1000)
	(IF (or (not (= (selection-length) 200))
		(not (= (selection-position) 1000)))
	    (snd-display ";selection after reposition: '(1000 200) '(~A ~A)?" 
			       (selection-position) 
			       (selection-length)))
	(reverse-selection)
	(IF (or (not (= (selection-length) 200))
		(not (= (selection-position) 1000)))
	    (snd-display ";selection after reverse: '(1000 200) '(~A ~A)?" 
			       (selection-position) 
			       (selection-length)))

	(let ((old-frames (frames ind)))
	  (src-selection .5)
	  (IF (or (> (abs (- (frames ind) (+ 200 old-frames))) 5)
		  (> (abs (- (selection-length) 400)) 5))
	      (snd-display ";selection after src .5: '(1000 400) '(~A ~A)?" 
				 (selection-position) 
				 (selection-length)))
	  (undo)
	  (redo)
	  (IF (or (> (abs (- (frames ind) (+ 200 old-frames))) 5)
		  (> (abs (- (selection-length) 400)) 5))
	      (snd-display ";selection after src .5 with undo/redo: '(1000 400) '(~A ~A)?" 
				 (selection-position) 
				 (selection-length)))
	  (undo 3))
	(close-sound ind))

      (if (< (print-length) 12) (set! (print-length) 12))
      (let ((ind (new-sound "hi.snd")))
	(do ((i 0 (1+ i)))
	    ((= i 10)) 
	  (set! (sample i ind) (* i .1)))
	(select-all ind)
	(set! (sample 10 ind) 1.0)
	(smooth-selection)
	(IF (not (vequal (vct-subseq (samples->vct 0 11 ind) 0 9) (vct-subseq (smoother 0.0 1.0 10) 0 9)))
	    (snd-display ";smooth-selection: ~A ~A?" (samples->vct 0 11 ind) (smoother 0.0 1.0 10)))
	(revert-sound)
	(do ((i 0 (1+ i)))
	    ((= i 10)) 
	  (set! (sample i ind) (- 1.0 (* i .1))))
	(select-all ind)
	(set! (sample 10 ind) 0.0)
	(smooth-selection)
	(IF (not (vequal (vct-subseq (samples->vct 0 11 ind) 0 9) (vct-subseq (smoother 1.0 0.0 10) 0 9)))
	    (snd-display ";smooth-selection back: ~A ~A?" (samples->vct 0 11 ind) (smoother 1.0 0.0 10)))
	(close-sound ind))

      (let ((ind (new-sound "hi.snd")))
	(do ((i 0 (1+ i)))
	    ((= i 10)) 
	  (set! (sample i ind) (* i .1)))
	(set! (sample 10 ind) 1.0)
	(smooth-sound 0 10 ind)
	(IF (not (vequal (vct-subseq (samples->vct 0 11 ind) 0 9) (vct-subseq (smoother 0.0 1.0 10) 0 9)))
	    (snd-display ";smooth-sound: ~A ~A?" (samples->vct 0 11 ind) (smoother 0.0 1.0 10)))
	(revert-sound)
	(do ((i 0 (1+ i)))
	    ((= i 10)) 
	  (set! (sample i ind) (- 1.0 (* i .1))))
	(set! (sample 10 ind) 0.0)
	(smooth-sound 0 10 ind)
	(IF (not (vequal (vct-subseq (samples->vct 0 11 ind) 0 9) (vct-subseq (smoother 1.0 0.0 10) 0 9)))
	    (snd-display ";smooth-sound back: ~A ~A?" (samples->vct 0 11 ind) (smoother 1.0 0.0 10)))
	(close-sound ind))

      (let* ((ind (open-sound "oboe.snd"))
	     (len (frames ind)))
	(set! (cursor ind) 1200)
	(key (char->integer #\u) 4 ind)
	(key (char->integer #\1) 0 ind)
	(key (char->integer #\0) 0 ind)
	(key (char->integer #\0) 0 ind)
	(key (char->integer #\o) 4 ind)
	(IF (not (= (frames ind) (+ 100 len)))
	    (snd-display ";C-o len: ~A? " (frames)))
	(if (not (provided? 'snd-nogui))
	    (let ((reader (make-sample-reader 1200 ind)))
	      (do ((i 0 (1+ i)))
		  ((= i 100))
		(let ((val (next-sample reader)))
		  (if (fneq val 0.0) (snd-display ";C-o[~D]: ~A?" i val))))
	      (free-sample-reader reader)))
	(revert-sound ind)
	(set! (cursor ind) 1200)
	(key (char->integer #\u) 4 ind)
	(key (char->integer #\1) 0 ind)
	(key (char->integer #\0) 0 ind)
	(key (char->integer #\0) 0 ind)
	(key (char->integer #\z) 4 ind)
	(IF (not (= (frames ind) len))
	    (snd-display ";C-z len: ~A? " (frames)))
	(if (not (provided? 'snd-nogui))
	    (let ((reader (make-sample-reader 1200 ind)))
	      (do ((i 0 (1+ i)))
		  ((= i 100))
		(let ((val (next-sample reader)))
		  (if (fneq val 0.0) (snd-display ";C-z[~D]: ~A?" i val))))
	      (free-sample-reader reader)))
	(revert-sound ind)
	(set! (cursor ind) 1200)
	(key (char->integer #\u) 4 ind)
	(key (char->integer #\1) 0 ind)
	(key (char->integer #\.) 0 ind)
	(key (char->integer #\0) 0 ind)
	(key (char->integer #\o) 4 ind)
	(IF (not (= (frames ind) (+ (srate ind) len)))
	    (snd-display ";C-o 1.0 len: ~A? " (frames)))
	(if (not (provided? 'snd-nogui))
	    (let ((reader (make-sample-reader 1200 ind)))
	      (do ((i 0 (1+ i)))
		  ((= i (srate ind)))
		(let ((val (next-sample reader)))
		  (if (fneq val 0.0) (snd-display ";C-o 1.0[~D]: ~A?" i val))))
	      (free-sample-reader reader)))
	(revert-sound ind)
	(set! (cursor ind) 1200)
	(key (char->integer #\u) 4 ind)
	(key (char->integer #\1) 0 ind)
	(key (char->integer #\.) 0 ind)
	(key (char->integer #\0) 0 ind)
	(key (char->integer #\z) 4 ind)
	(IF (not (= (frames ind) len))
	    (snd-display ";C-z 1.0 len: ~A? " (frames)))
	(if (not (provided? 'snd-nogui))
	    (let ((reader (make-sample-reader 1200 ind)))
	      (do ((i 0 (1+ i)))
		  ((= i (srate ind)))
		(let ((val (next-sample reader)))
		  (if (fneq val 0.0) (snd-display ";C-z 1.0[~D]: ~A?" i val))))
	      (free-sample-reader reader)))
	(close-sound ind))

      (let ((ind (open-sound "2.snd")))
	(set! (sync ind) 1)
	(key (char->integer #\>) 4)
	(key (char->integer #\space) 4)
	(key (char->integer #\<) 4)
	(IF (or (not (selection-member? ind 0))
		(not (selection-member? ind 1))
		(not (= (selection-position ind 0) 0))
		(not (= (selection-position ind 1) 0))
		(not (= (selection-length ind 0) (frames ind 0)))
		(not (= (selection-length ind 1) (frames ind 1))))
	    (snd-display ";sync selection via <-: ~A ~A ~A ~A ~A ~A"
			 (selection-member? ind 0) (selection-member? ind 1)
			 (selection-position ind 0) (selection-position ind 1)
			 (selection-length ind 0) (selection-length ind 1)))
	(key (char->integer #\space) 4)
	(key (char->integer #\>) 4)
	(IF (or (not (selection-member? ind 0))
		(not (selection-member? ind 1))
		(not (= (selection-position ind 0) 0))
		(not (= (selection-position ind 1) 0))
		(not (= (selection-length ind 0) (frames ind 0)))
		(not (= (selection-length ind 1) (frames ind 1))))
	    (snd-display ";sync selection via ->: ~A ~A ~A ~A ~A ~A"
			 (selection-member? ind 0) (selection-member? ind 1)
			 (selection-position ind 0) (selection-position ind 1)
			 (selection-length ind 0) (selection-length ind 1)))
	(set! (cursor ind 1) 0)
	(set! (cursor ind 0) 1000)
	(IF (not (= (cursor ind 1) 1000)) (snd-display ";syncd cursors: ~A ~A" (cursor ind 0) (cursor ind 1)))
	(key (char->integer #\f) 4)
	(IF (not (= (cursor ind 1) 1001)) (snd-display ";syncd cursors C-f: ~A ~A" (cursor ind 0) (cursor ind 1)))
	(close-sound ind))

      (let ((ind (open-sound "oboe.snd")))
	(test-selection ind 1200 100 2.0)
	(test-selection ind 600 1200 2.0)
	(test-selection ind 0 100 2.0)
	(test-selection ind 22500 (- 50827 22500) 0.5)
	(test-selection ind 0 50828 0.5)

	(test-selection-to ind 1200 100 1.0)
	(test-selection-to ind 600 1200 0.1)
	(test-selection-to ind 0 100 0.5)
	(test-selection-to ind 22500 (- 50827 22500) 2.0)
	(test-selection-to ind 0 50828 0.5)

	(revert-sound ind)
	(make-selection 1200 1200)
	(IF (not (selection?)) (snd-display ";no selection from 1 samp region?"))
	(IF (not (= (selection-length) 1)) (snd-display ";1 samp selection: ~A samps?" (selection-length)))
	(scale-selection-to 1.0)
	(IF (fneq (sample 1200 ind 0) 1.0) (snd-display ";scale 1 samp selection: ~A?" (sample 1200 ind 0)))

	(revert-sound ind)
	(let ((id (make-region 500 1000)))
	  (src-selection .5)
	  (IF (> (abs (- (region-length id) 500)) 1) (snd-display ";region-length after src-selection: ~A?" (region-length id)))
	  (let ((reg-mix-id (mix-region 1500 id ind 0)))
	    (IF (not (= (mix-length reg-mix-id) (region-length id)))
		(snd-display ";mix-region: ~A != ~A?" (region-length id) (mix-length reg-mix-id)))
	    (IF (not (equal? (mix-home reg-mix-id) (list ind 0)))
		(snd-display ";mix-region mix-home ~A (~A 0)?" (mix-home reg-mix-id) ind))
	    (let ((sel-mix-id (mix-selection 2500 ind 0)))
	      (IF (not (= (selection-length) (mix-length sel-mix-id)))
		  (snd-display ";mix-selection: ~A != ~A?" (selection-length) (mix-length sel-mix-id)))
	      (IF (> (abs (- (* 2 (mix-length reg-mix-id)) (mix-length sel-mix-id))) 3)
		  (snd-display ";mix selection and region: ~A ~A (~A ~A)?" 
				       (mix-length reg-mix-id) (mix-length sel-mix-id) (region-length id) (selection-length)))
	      (IF (not (equal? (mix-home sel-mix-id) (list ind 0)))
		  (snd-display ";mix-selection mix-home: ~A (~A 0)?" (mix-home sel-mix-id) ind))
	      (insert-selection 3000 ind 0)
	      (delete-selection)
	      (revert-sound ind))))
	(close-sound ind)
	)

      (if (file-exists? "storm.snd")
	  (let ((ind (open-sound "storm.snd")))
	    (set! (sinc-width) 10)
	    (time (src-sound 1.3))
	    (time (env-sound '(0 0 1 1 2 0)))
	    (time (filter-sound '(0 1 .2 0 .5 1 1 0) 20))      ; FIR direct form
	    (time (filter-sound '(0 0 .1 0 .11 1 .12 0 1 0) 2048)) ; convolution
	    (time (map-chan (map-silence .01 #f)))
	    (close-sound ind)))
      (if (file-exists? "1a.snd")
	  (let ((ind1 (open-sound "1a.snd")))
	    (time (rubber-sound 1.25))
	    (close-sound ind1)))

      (let* ((oboe (open-sound "oboe.snd"))
	     (a4 (open-sound "4.aiff"))
	     (sr (srate oboe))
	     (fr (frames oboe 0))
	     (typ (header-type oboe))
	     (frm (data-format oboe))
	     (loc (data-location oboe))
	     (com (comment oboe)))
	(save-sound-as "test.aif" oboe mus-aifc)
	(let ((oboe-aif (open-sound "test.aif")))
	  (IF (not (= (header-type oboe-aif) mus-aifc)) (snd-display ";oboe-aif header: ~A?" (mus-header-type-name (header-type oboe-aif))))
	  (set! (srate oboe-aif) (* sr 2.0))
	  (IF (fneq (* sr 2.0) (srate oboe-aif)) (snd-display ";set! srate: ~A ~A" (* sr 2.0) (srate oboe-aif)))
	  (set! (header-type oboe-aif) mus-next)
	  (IF (not (= (header-type oboe-aif) mus-next)) (snd-display ";set! header: ~A?" (mus-header-type-name (header-type oboe-aif))))
	  (set! (data-location oboe-aif) 28)
	  (IF (not (= (data-location oboe-aif) 28)) (snd-display ";set! data-location: ~A?" (data-location oboe-aif)))
	  (set! (data-format oboe-aif) mus-mulaw)
	  (IF (not (= (data-format oboe-aif) mus-mulaw)) (snd-display ";set! format: ~A?" (mus-data-format-name (data-format oboe-aif))))
	  (save-sound-as "test.aif" oboe-aif mus-aifc mus-bshort 22050 0)
	  (close-sound oboe-aif)
	  (delete-file "test.aif")
	  (set! (selected-sound) a4)
	  (IF (not (= (selected-sound) a4)) (snd-display ";set! selected-sound: ~A ~A?" (selected-sound) a4))
	  (set! (selected-channel) 2)
	  (IF (not (= (selected-channel a4) 2)) (snd-display ";set! selected-channel: ~A?" (selected-channel a4)))
	  (set! (selected-channel a4) 3)
	  (IF (not (= (selected-channel a4) 3)) (snd-display ";set! selected-channel a4: ~A?" (selected-channel a4)))
	  (close-sound a4)
	  (close-sound oboe)))

      (load "env.scm")
      (IF (fneq (envelope-interp .1 '(0 0 1 1)) 0.1) 
	  (snd-display ";envelope-interp .1 -> ~A?" (envelope-interp .1 '(0 0 1 1))))
      (IF (fneq (envelope-interp .1 '(0 0 1 1) 32.0) 0.01336172) 
	  (snd-display ";envelope-interp .013 -> ~A?" (envelope-interp .1 '(0 0 1 1) 32.0)))
      (IF (fneq (envelope-interp .1 '(0 0 1 1) .012) 0.36177473) 
	  (snd-display ";envelope-interp .361 -> ~A?" (envelope-interp .1 '(0 0 1 1) .012))) 
      (IF (fneq (envelope-interp .3 '(0 0 .5 1 1 0)) .6)
	  (snd-display ";envelope-interp .3 '(0 0 .5 1 1 0)) -> ~A" (envelope-interp .3 '(0 0 .5 1 1 0))))
      (IF (not (feql (window-envelope 1.0 3.0 '(0.0 0.0 5.0 1.0)) (list 1.0 0.2 3.0 0.6))) 
	  (snd-display ";window-envelope: ~A?" (window-envelope 1.0 3.0 '(0.0 0.0 5.0 1.0))))
      (IF (not (feql (multiply-envelopes '(0 0 1 1) '(0 0 1 1 2 0)) (list 0 0 0.5 0.5 1 0))) 
	  (snd-display ";multiply-envelopes: ~A?" (multiply-envelopes '(0 0 1 1) '(0 0 1 1 2 0))))
      (IF (fneq (max-envelope '(0 0 1 1 2 3 4 0)) 3.0)
	  (snd-display ";max-envelope: ~A?" (max-envelope '(0 0 1 1 2 3 4 0))))
      (IF (fneq (integrate-envelope '(0 0 1 1)) 0.5) 
	  (snd-display ";integrate-envelope: ~A?" (integrate-envelope '(0 0 1 1))))
      (IF (fneq (integrate-envelope '(0 1 1 1)) 1.0) 
	  (snd-display ";integrate-envelope: ~A?" (integrate-envelope '(0 1 1 1))))
      (IF (fneq (integrate-envelope '(0 0 1 1 2 .5)) 1.25) 
	  (snd-display ";integrate-envelope: ~A?" (integrate-envelope '(0 0 1 1 2 .5))))
      (IF (not (feql (stretch-envelope '(0 0 1 1) .1 .2) (list 0 0 0.2 0.1 1.0 1))) 
	  (snd-display ";stretch-envelope att: ~A?" (stretch-envelope '(0 0 1 1) .1 .2)))
      (IF (not (feql (stretch-envelope '(0 0 1 1 2 0) .1 .2 1.5 1.6) (list 0 0 0.2 0.1 1.1 1 1.6 0.5 2.0 0))) 
	  (snd-display ";stretch-envelope dec: ~A?" (stretch-envelope '(0 0 1 1 2 0) .1 .2 1.5 1.6)))
      (IF (not (feql (add-envelopes '(0 0 1 1 2 0) '(0 0 1 1)) '(0 0 0.5 1.5 1 1)))
	  (snd-display ";add-envelopes: ~A" (add-envelopes '(0 0 1 1 2 0) '(0 0 1 1))))
      (IF (not (feql (scale-envelope '(0 0 1 1) 2) '(0 0 1 2)))
	  (snd-display ";scale-envelope: ~A" (scale-envelope '(0 0 1 1) 2)))
      (IF (not (feql (scale-envelope '(0 0 1 1) 2 1) '(0 1 1 3)))
	  (snd-display ";scale-envelope off: ~A" (scale-envelope '(0 0 1 1) 2 1)))
      (IF (not (feql (reverse-envelope '(0 0 1 1)) '(0 1 1 0)))
	  (snd-display ";reverse-envelope ramp: ~A" (reverse-envelope '(0 0 1 1))))
      (IF (not (feql (reverse-envelope '(0 0 .5 1 2 0)) '(0 0 1.5 1 2 0)))
	  (snd-display ";reverse-envelope ramp 2: ~A" (reverse-envelope '(0 0 .5 1 2 0))))
      (IF (not (feql (reverse-envelope '(0 0 .5 1 2 1)) '(0 1 1.5 1 2 0)))
	  (snd-display ";reverse-envelope ramp 2: ~A" (reverse-envelope '(0 0 .5 1 2 1))))
      (IF (not (feql (concatenate-envelopes '(0 0 1 1) '(0 1 1 0)) '(0.0 0 1.0 1 2.0 0)))
	  (snd-display ";concatenate-envelopes: ~A" (concatenate-envelopes '(0 0 1 1) '(0 1 1 0))))
      (IF (not (feql (concatenate-envelopes '(0 0 1 1.5) '(0 1 1 0)) '(0.0 0 1.0 1.5 1.01 1 2.01 0)))
	  (snd-display ";concatenate-envelopes: ~A" (concatenate-envelopes '(0 0 1 1.5) '(0 1 1 0))))
      ))

;;; ---------------- test 16: regularized funcs ----------------

(if (or full-test (= snd-test 16) (and keep-going (<= snd-test 16)))
    (begin
      (if (procedure? test-hook) (test-hook 16))
      (let ((oboe (open-sound "oboe.snd")))

	(for-each
	 (lambda (func name)
	   (func)
	   (IF (not (= (edit-position oboe) 0))
	       (snd-display ";dur:0 ~A? ~A ~A" name (edit-position oboe) (edit-fragment))))
	 (list 
	  (lambda () (scale-channel 2.0 0 0 oboe))
	  (lambda () (env-channel (make-env '(0 0 1 1) :end 123) 0 0 oboe))
	  (lambda () (clm-channel (make-oscil) 0 0 oboe))
	  (lambda () (vct->channel (make-vct 3) 0 0 oboe))
	  (lambda () (smooth-channel 0 0 oboe))
	  (lambda () (pad-channel 0 0 oboe))
	  (lambda () (src-channel 2.0 0 0 oboe))
	  (lambda () (mix-channel "pistol.snd" 0 0 oboe))
	  (lambda () (insert-channel "pistol.snd" 0 0 oboe))
	  (lambda () (reverse-channel 0 0 oboe))
	  (lambda () (play-channel 0 0 oboe))
	  (lambda () (scale-sound-by 2.0 0 0 oboe))
	  (lambda () (env-sound '(0 0 1 1) 0 0 oboe))
	  (lambda () (set-samples 0 0 (make-vct 3) oboe))
	  (lambda () (smooth-sound 0 0 oboe))
	  (lambda () (insert-silence 0 0 oboe)))
	 (list 
	  "scale-channel" "env-channel" "clm-channel" "vct->channel" "smooth-channel" "pad-channel" "src-channel"
	  "mix-channel" "insert-channel" "reverse-channel" "play-channel" 
	  "scale-sound-by" "env-sound" "set-samples" "smooth-sound" "insert-silence"))

	(if (defined? 'get-test-a2)
	    (begin
	      (c-channel (get-test-a2) 0 0 oboe)
	      (IF (not (= (edit-position oboe) 0))
		  (snd-display ";dur:0 c-channel? ~A ~A" (edit-position oboe) (edit-fragment)))))

	(for-each
	 (lambda (func name)
	   (let ((tag (catch #t
			     func
			     (lambda args (car args)))))
	     (IF (not (eq? tag 'no-such-sample))
		 (snd-display "~A beg -1->~A" name tag))
	     (IF (not (= (edit-position oboe) 0))
		 (snd-display ";beg:-1 ~A? ~A ~A" name (edit-position oboe) (edit-fragment)))))
	 (list 
	  (lambda () (scale-channel 2.0 -1 123 oboe))
	  (lambda () (env-channel (make-env '(0 0 1 1) :end 123) -1 123 oboe))
	  (lambda () (clm-channel (make-oscil) -1 123 oboe))
	  (lambda () (vct->channel (make-vct 3) -1 123 oboe))
	  (lambda () (smooth-channel -1 123 oboe))
	  (lambda () (pad-channel -1 123 oboe))
	  (lambda () (src-channel 2.0 -1 123 oboe))
	  (lambda () (mix-channel "pistol.snd" -1 123 oboe))
	  (lambda () (insert-channel "pistol.snd" -1 123 oboe))
	  (lambda () (reverse-channel -1 123 oboe))
	  (lambda () (play-channel -1 123 oboe))
	  (lambda () (scale-sound-by 2.0 -1 123 oboe))
	  (lambda () (env-sound '(0 0 1 1) -1 123 oboe))
	  (lambda () (set-samples -1 123 (make-vct 3) oboe))
	  (lambda () (smooth-sound -1 123 oboe))
	  (lambda () (insert-silence -1 123 oboe)))
	 (list 
	  "scale-channel" "env-channel" "clm-channel" "vct->channel" "smooth-channel" "pad-channel" "src-channel"
	  "mix-channel" "insert-channel" "reverse-channel" "play-channel" 
	  "scale-sound-by" "env-sound" "set-samples" "smooth-sound" "insert-silence"))

	(if (defined? 'get-test-a2)
	    (let ((tag
		   (catch #t
			  (lambda () (c-channel (get-test-a2) -1 123 oboe))
			  (lambda args (car args)))))
	     (IF (not (eq? tag 'no-such-sample))
		 (snd-display "c-channel beg -1->~A"  tag))
	     (IF (not (= (edit-position oboe) 0))
		 (snd-display ";beg:-1 c-channel? ~A ~A" (edit-position oboe) (edit-fragment)))))

	(scale-channel 2.0 12345678 123 oboe)
	(IF (not (= (edit-position oboe) 0))
	    (snd-display ";beg:12345678 scale-channel? ~A ~A" (edit-position oboe) (edit-fragment)))
	(env-channel (make-env '(0 0 1 1) :end 123) 12345678 123 oboe)
	(IF (not (= (edit-position oboe) 0))
	    (snd-display ";beg:12345678 env-channel? ~A ~A" (edit-position oboe) (edit-fragment)))
	(smooth-channel 12345678 123 oboe)
	(IF (not (= (edit-position oboe) 0))
	    (snd-display ";beg:12345678 smooth-channel? ~A ~A" (edit-position oboe) (edit-fragment)))
	(src-channel 2.0 12345678 123 oboe)
	(IF (not (= (edit-position oboe) 0))
	    (snd-display ";beg:12345678 src-channel? ~A ~A" (edit-position oboe) (edit-fragment)))
	(reverse-channel 12345678 123 oboe)
	(IF (not (= (edit-position oboe) 0))
	    (snd-display ";beg:12345678 reverse-channel? ~A ~A" (edit-position oboe) (edit-fragment)))
	(play-channel 12345678 123 oboe)

	(scale-channel 2.0 0 123 oboe 0)
	(IF (not (= (edit-position oboe) 1))
	    (snd-display ";oboe scale-channel? ~A ~A" (edit-position oboe) (edit-fragment)))
	(env-channel (make-env '(0 0 1 1) :end 123) 0 123 oboe 0)
	(IF (not (= (edit-position oboe) 2))
	    (snd-display ";oboe env-channel? ~A ~A" (edit-position oboe) (edit-fragment)))
	(clm-channel (make-oscil) 0 123 oboe 0)
	(IF (not (= (edit-position oboe) 3))
	    (snd-display ";oboe clm-channel? ~A ~A" (edit-position oboe) (edit-fragment)))
	(vct->channel (make-vct 3) 0 123 oboe 0)
	(IF (not (= (edit-position oboe) 4))
	    (snd-display ";oboe vct->channel? ~A ~A" (edit-position oboe) (edit-fragment)))
	(smooth-channel 0 123 oboe 0)
	(IF (not (= (edit-position oboe) 5))
	    (snd-display ";oboe smooth-channel? ~A ~A" (edit-position oboe) (edit-fragment)))
	(pad-channel 0 123 oboe 0)
	(IF (not (= (edit-position oboe) 6))
	    (snd-display ";oboe pad-channel? ~A ~A" (edit-position oboe) (edit-fragment)))
	(src-channel 2.0 0 123 oboe 0)
	(IF (not (= (edit-position oboe) 7))
	    (snd-display ";oboe src-channel? ~A ~A" (edit-position oboe) (edit-fragment)))
	(mix-channel "pistol.snd" 0 123 oboe 0)
	(IF (not (= (edit-position oboe) 8))
	    (snd-display ";oboe mix-channel? ~A ~A" (edit-position oboe) (edit-fragment)))
	(insert-channel "pistol.snd" 0 123 oboe 0)
	(IF (not (= (edit-position oboe) 9))
	    (snd-display ";oboe insert-channel? ~A ~A" (edit-position oboe) (edit-fragment)))
	(reverse-channel 0 123 oboe 0)
	(IF (not (= (edit-position oboe) 10))
	    (snd-display ";oboe reverse-channel? ~A ~A" (edit-position oboe) (edit-fragment)))
	(if (defined? 'get-test-a2)
	    (begin
	      (c-channel (get-test-a2) 0 123 oboe 0)
	      (IF (not (= (edit-position oboe) 11))
		  (snd-display ";oboe c-channel? ~A ~A" (edit-position oboe) (edit-fragment)))))
	(revert-sound)
	
	(let ((tag (catch #t (lambda () (scale-channel 2.0 0 123 oboe 0 (lambda (hi) #f))) (lambda args (car args)))))
	  (IF (not (eq? tag 'bad-arity)) (snd-display ";bad edpos scale-channel: ~A" tag))
	  (IF (not (= (edit-position oboe) 0))
	      (snd-display ";edpos:func scale-channel? ~A ~A" (edit-position oboe) (edit-fragment))))
	(let ((tag (catch #t (lambda () (env-channel (make-env '(0 0 1 1) :end 123) 0 123 oboe 0 (lambda (hi) #f))) (lambda args (car args)))))
	  (IF (not (= (edit-position oboe) 0))
	      (snd-display ";edpos:func env-channel? ~A ~A" (edit-position oboe) (edit-fragment))))
	(let ((tag (catch #t (lambda () (clm-channel (make-oscil) 0 123 oboe 0 (lambda (hi) #f))) (lambda args (car args)))))
	  (IF (not (= (edit-position oboe) 0))
	      (snd-display ";edpos:func clm-channel? ~A ~A" (edit-position oboe) (edit-fragment))))
	(let ((tag (catch #t (lambda () (vct->channel (make-vct 3) 0 123 oboe 0 (lambda (hi) #f))) (lambda args (car args)))))
	  (IF (not (= (edit-position oboe) 0))
	      (snd-display ";edpos:func vct->channel? ~A ~A" (edit-position oboe) (edit-fragment))))
	(let ((tag (catch #t (lambda () (smooth-channel 0 123 oboe 0 (lambda (hi) #f))) (lambda args (car args)))))
	  (IF (not (= (edit-position oboe) 0))
	      (snd-display ";edpos:func smooth-channel? ~A ~A" (edit-position oboe) (edit-fragment))))
	(let ((tag (catch #t (lambda () (pad-channel 0 123 oboe 0 (lambda (hi) #f))) (lambda args (car args)))))
	  (IF (not (= (edit-position oboe) 0))
	      (snd-display ";edpos:func pad-channel? ~A ~A" (edit-position oboe) (edit-fragment))))
	(let ((tag (catch #t (lambda () (src-channel 2.0 0 123 oboe 0 (lambda (hi) #f))) (lambda args (car args)))))
	  (IF (not (= (edit-position oboe) 0))
	      (snd-display ";edpos:func src-channel? ~A ~A" (edit-position oboe) (edit-fragment))))
	(let ((tag (catch #t (lambda () (mix-channel "pistol.snd" 0 123 oboe 0 (lambda (hi) #f))) (lambda args (car args)))))
	  (IF (not (= (edit-position oboe) 0))
	      (snd-display ";edpos:func mix-channel? ~A ~A" (edit-position oboe) (edit-fragment))))
	(let ((tag (catch #t (lambda () (insert-channel "pistol.snd" 0 123 oboe 0 (lambda (hi) #f))) (lambda args (car args)))))
	  (IF (not (= (edit-position oboe) 0))
	      (snd-display ";edpos:func insert-channel? ~A ~A" (edit-position oboe) (edit-fragment))))
	(if (defined? 'get-test-a2)
	    (let ((tag (catch #t (lambda () (c-channel (get-test-a2) 0 123 oboe 0 (lambda (hi) #f))) (lambda args (car args)))))
	      (IF (not (= (edit-position oboe) 0))
		  (snd-display ";edpos:func c-channel? ~A ~A" (edit-position oboe) (edit-fragment)))))
	(let ((tag (catch #t (lambda () (reverse-channel 0 123 oboe 0 (lambda (hi) #f))) (lambda args (car args)))))
	  (IF (not (= (edit-position oboe) 0))
	      (snd-display ";edpos:func reverse-channel? ~A ~A" (edit-position oboe) (edit-fragment))))

	(let ((tag (catch #t (lambda () (scale-channel 2.0 0 123 oboe 0 123)) (lambda args (car args)))))
	  (IF (not (eq? tag 'no-such-edit)) (snd-display ";bad edpos scale-channel: ~A" tag))
	  (IF (not (= (edit-position oboe) 0))
	      (snd-display ";edpos 123 scale-channel? ~A ~A" (edit-position oboe) (edit-fragment))))
	(let ((tag (catch #t (lambda () (env-channel (make-env '(0 0 1 1) :end 123) 0 123 oboe 0 123)) (lambda args (car args)))))
	  (IF (not (= (edit-position oboe) 0))
	      (snd-display ";edpos 123 env-channel? ~A ~A" (edit-position oboe) (edit-fragment))))
	(let ((tag (catch #t (lambda () (clm-channel (make-oscil) 0 123 oboe 0 123)) (lambda args (car args)))))
	  (IF (not (= (edit-position oboe) 0))
	      (snd-display ";edpos 123 clm-channel? ~A ~A" (edit-position oboe) (edit-fragment))))
	(let ((tag (catch #t (lambda () (vct->channel (make-vct 3) 0 123 oboe 0 123)) (lambda args (car args)))))
	  (IF (not (= (edit-position oboe) 0))
	      (snd-display ";edpos 123 vct->channel? ~A ~A" (edit-position oboe) (edit-fragment))))
	(let ((tag (catch #t (lambda () (smooth-channel 0 123 oboe 0 123)) (lambda args (car args)))))
	  (IF (not (= (edit-position oboe) 0))
	      (snd-display ";edpos 123 smooth-channel? ~A ~A" (edit-position oboe) (edit-fragment))))
	(let ((tag (catch #t (lambda () (pad-channel 0 123 oboe 0 123)) (lambda args (car args)))))
	  (IF (not (= (edit-position oboe) 0))
	      (snd-display ";edpos 123 pad-channel? ~A ~A" (edit-position oboe) (edit-fragment))))
	(let ((tag (catch #t (lambda () (src-channel 2.0 0 123 oboe 0 123)) (lambda args (car args)))))
	  (IF (not (= (edit-position oboe) 0))
	      (snd-display ";edpos 123 src-channel? ~A ~A" (edit-position oboe) (edit-fragment))))
	(let ((tag (catch #t (lambda () (mix-channel "pistol.snd" 0 123 oboe 0 123)) (lambda args (car args)))))
	  (IF (not (= (edit-position oboe) 0))
	      (snd-display ";edpos 123 mix-channel? ~A ~A" (edit-position oboe) (edit-fragment))))
	(let ((tag (catch #t (lambda () (insert-channel "pistol.snd" 0 123 oboe 0 123)) (lambda args (car args)))))
	  (IF (not (= (edit-position oboe) 0))
	      (snd-display ";edpos 123 insert-channel? ~A ~A" (edit-position oboe) (edit-fragment))))
	(if (defined? 'get-test-a2)
	    (let ((tag (catch #t (lambda () (c-channel (get-test-a2) 0 123 oboe 0 123)) (lambda args (car args)))))
	      (IF (not (= (edit-position oboe) 0))
		  (snd-display ";edpos 123 c-channel? ~A ~A" (edit-position oboe) (edit-fragment)))))
	(let ((tag (catch #t (lambda () (reverse-channel 0 123 oboe 0 123)) (lambda args (car args)))))
	  (IF (not (= (edit-position oboe) 0))
	      (snd-display ";edpos 123 reverse-channel? ~A ~A" (edit-position oboe) (edit-fragment))))
	(let ((tag (catch #t (lambda () (play-channel 0 123 oboe 0 123)) (lambda args (car args)))))
	  (IF (not (eq? tag 'no-such-edit)) (snd-display ";bad edpos play-channel: ~A" tag)))
	(revert-sound oboe)

	(let ((oldv (channel->vct 1000 10 oboe)))
	  (mix-channel "oboe.snd" 0)
	  (vct-scale! oldv 2.0)
	  (IF (not (vequal oldv (channel->vct 1000 10 oboe)))
	      (snd-display ";mix-channel at 0: ~A ~A" oldv (channel->vct 1000 10 oboe)))
	  (revert-sound oboe)
	  (vct-scale! oldv 0.5)
	  (insert-channel "oboe.snd" 0)
	  (IF (not (vequal oldv (channel->vct 1000 10 oboe)))
	      (snd-display ";insert-channel at 0: ~A ~A" oldv (channel->vct 1000 10 oboe)))
	  (IF (not (= (frames oboe 0) (* 2 (frames oboe 0 0))))
	      (snd-display ";insert-channel frames: ~A ~A" (frames oboe 0) (frames oboe 0 0)))
	  (revert-sound oboe)
	  (if (defined? 'get-test-a2) 
	      (begin
		(c-channel (get-test-a2) 0)
		(vct-scale! oldv 2.0)
		(IF (not (vequal oldv (channel->vct 1000 10 oboe)))
		    (snd-display ";c-channel at 0: ~A ~A" oldv (channel->vct 1000 10 oboe))))))
  
	(close-sound oboe)

	(IF (not (= (default-output-chans) 1)) (set! (default-output-chans) 1))
	(let ((ind (new-sound "fmv.snd"))
	      (v0 (vct-fill! (make-vct 20) 1.0)))
	  (vct->channel v0)
	  (IF (not (= (frames) 20)) (snd-display ";vct->channel new 20: ~A" (frames)))
	  (IF (fneq (maxamp) 1.0) (snd-display ";vct 1->new: ~A" (maxamp)))
	  
	  (env-channel (make-env '(0 0 1 1 2 1) :base 0 :end 19))
	  (let ((v1 (channel->vct)))
	    (IF (not (vequal v1 (vct 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1)))
		(snd-display ";env-channel step 1: ~A" v1)))
	  (undo)
	  (env-channel (make-env '(0 0 1 1 2 1) :base 0 :end 19) 8)
	  (let ((v1 (channel->vct)))
	    (IF (not (vequal v1 (vct 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 1 1)))
		(snd-display ";env-channel step 1 at 8: ~A" v1)))
	  (undo)
	  (env-channel (make-env '(0 0 1 1 2 1) :base 0 :end 11))
	  (let ((v1 (channel->vct)))
	    (IF (not (vequal v1 (vct 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1)))
		(snd-display ";env-channel step 1 at 6: ~A" v1)))
	  (undo)
	  (env-channel (make-env '(0 0 1 1 2 1) :base 0 :end 11) 4)
	  (let ((v1 (channel->vct)))
	    (IF (not (vequal v1 (vct 1 1 1 1 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1)))
		(snd-display ";env-channel step 1 at 6: ~A" v1)))
	  (undo)
	  (env-channel (make-env '(0 0 1 1 2 1) :base 0 :end 11) 4 3)
	  (let ((v1 (channel->vct)))
	    (IF (not (vequal v1 (vct 1 1 1 1 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1)))
		(snd-display ";env-channel step 1 at 6: ~A" v1)))
	  (undo)
	  (env-channel (make-env '(0 1 1 0 2 0) :base 0 :end 7) 0 12)
	  (let ((v1 (channel->vct)))
	    (IF (not (vequal v1 (vct 1 1 1 1 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1)))
		(snd-display ";env-channel step 1 at 6: ~A" v1)))
	  (undo)
	  (env-channel (make-env '(0 0 1 1 2 1 3 0 4 0) :base 0 :end 20))
	  (let ((v1 (channel->vct)))
	    (IF (not (vequal v1 (vct 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0)))
		(snd-display ";env-channel step 1: ~A" v1)))
	  (env-channel (make-env '(0 0 1 .5 2 .25 3 0 4 0) :base 0 :end 20))
	  (let ((v1 (channel->vct)))
	    (IF (not (vequal v1 (vct 0 0 0 0 0 .5 .5 .5 .5 .5 .25 .25 .25 .25 .25 0 0 0 0 0)))
		(snd-display ";env-channel step 1: ~A" v1)))
	  (close-sound ind))

	(let* ((ind (open-sound "2.snd"))
	       (fr (frames))
	       (m0 (maxamp ind 0))
	       (m1 (maxamp ind 1)))
	  (set! (sync ind) 64)
	  (insert-sound "2.snd")
	  (insert-sound "2.snd")
	  (IF (not (= (frames) (* 3 fr))) (snd-display ";2.snd 3x = ~A ~A" fr (frames)))
	  (IF (not (= (frames ind 0) (frames ind 1))) (snd-display ";insert sync'd: ~A ~A" (frames ind 0) (frames ind 1)))
	  (swap-channels)
	  (IF (or (fneq m0 (maxamp ind 1)) (fneq m1 (maxamp ind 0)))
	      (snd-display "swapped: ~A ~A -> ~A ~A" m0 m1 (maxamp ind 0) (maxamp ind 1)))
	  (close-sound ind))

	(let ((oboe0 (open-sound "oboe.snd"))
	      (oboe1 (open-sound "oboe.snd")))

	  (define (funcs-equal? name func0 func1)
	    (func0 #f #f oboe0)
	    (func1 #f #f oboe1)
	    (IF (not (vequal (channel->vct 1000 100 oboe0) (channel->vct 1000 100 oboe1)))
		(snd-display ";~A via #f: ~A ~A" name (channel->vct 1000 100 oboe0) (channel->vct 1000 100 oboe1)))
	    (revert-sound oboe0)
	    (revert-sound oboe1)
	    (select-sound oboe0)
	    (func0)
	    (select-sound oboe1)
	    (func1)
	    (IF (not (vequal (channel->vct 1000 100 oboe0) (channel->vct 1000 100 oboe1)))
		(snd-display ";~A via none: ~A ~A" name (channel->vct 1000 100 oboe0) (channel->vct 1000 100 oboe1)))
	    (revert-sound oboe0)
	    (revert-sound oboe1)
	    (func0 0 (frames oboe0) oboe0)
	    (func1 0 (frames oboe1) oboe1)
	    (IF (not (vequal (channel->vct 1000 100 oboe0) (channel->vct 1000 100 oboe1)))
		(snd-display ";~A via frames: ~A ~A" name (channel->vct 1000 100 oboe0) (channel->vct 1000 100 oboe1)))
	    (revert-sound oboe0)
	    (revert-sound oboe1))

	  (funcs-equal? "scale-sound-by" 
			(lambda args (apply scale-sound-by (cons 2.0 args)))
			(lambda args (apply scale-channel (cons 2.0 args))))
	  (funcs-equal? "smooth-sound"
			(lambda args (apply smooth-sound args))
			(lambda args (apply smooth-channel args)))
	  (funcs-equal? "env-sound"
			(lambda args (apply env-sound (list (list 0 0 1 1)
							    (if (> (length args) 0) (car args) 0)
							    (if (and (> (length args) 1) 
								     (number? (cadr args)))
								(1- (cadr args))
								#f)
							    1.0
							    (if (> (length args) 2)
								(caddr args)
								(selected-sound)))))
			(lambda args (apply env-channel 
					    (cons (make-env :envelope (list 0 0 1 1) 
							    :end (if (and (> (length args) 1)
									  (number? (cadr args)))
								     (cadr args)
								     (1- (frames (if (> (length args) 2)
										     (caddr args)
										     (selected-sound))))))
						  args))))
	  (funcs-equal? "map-chan"
			(lambda args (apply map-chan (list (lambda (n) (* n 2)) 
							   (if (> (length args) 0) (car args) 0)
							   (if (and (> (length args) 1) 
								    (number? (cadr args)))
							       (1- (cadr args))
							       #f)
							   "testing..."
							   (if (> (length args) 2)
							       (caddr args)
							       (selected-sound)))))
			(lambda args (apply map-channel (cons (lambda (n) (* n 2)) args))))
	  (funcs-equal? "src-sound"
			(lambda args (apply src-sound (list 2.0 1.0 (if (> (length args) 2) (caddr args) #f))))
			(lambda args (apply src-channel (cons 2.0 args))))
	  (funcs-equal? "reverse-sound"
			(lambda args (apply reverse-sound (list (if (> (length args) 2) (caddr args) #f))))
			(lambda args (apply reverse-channel args)))
	  (funcs-equal? "mix"
			(lambda args (apply mix (list "pistol.snd" 0 0 (if (> (length args) 2) (caddr args) #f))))
			(lambda args (apply mix-channel "pistol.snd" args)))
	  (funcs-equal? "insert-sound"
			(lambda args (apply insert-sound (list "pistol.snd" 0 0 (if (> (length args) 2) (caddr args) #f))))
			(lambda args (apply insert-channel "pistol.snd" args)))
	  (close-sound oboe0)
	  (close-sound oboe1))

	)))



;;; ---------------- test 17: dialogs and graphics ----------------

(define (-> x0 y0 size snd chn)
  "draw an arrow pointing (from the left) at the point (x0 y0)"
  (let ((points (make-vector 8)))
    (define (point i x y)
      (vector-set! points (* i 2) x)
      (vector-set! points (+ (* i 2) 1) y))
    (define (arrow-head x y)
      (point 0 x y)
      (point 1 (- x (* 2 size)) (- y size))
      (point 2 (- x (* 2 size)) (+ y size))
      (point 3 x y)
      (fill-polygon points snd chn))
    (arrow-head x0 y0)
    (fill-rectangle (- x0 (* 4 size)) 
		    (inexact->exact (- y0 (* .4 size)))
		    (* 2 size)
		    (inexact->exact (* .8 size))
		    snd chn)))  

(if (and (or full-test (= snd-test 17) (and keep-going (<= snd-test 17)))
	 (not (provided? 'snd-nogui)))
    (begin
      (if (procedure? test-hook) (test-hook 17))
      (if (not (file-exists? "cmn-glyphs.lisp"))
	  (copy-file (string-append home-dir "/bil/cl/cmn-glyphs.lisp") (string-append (getcwd) "/cmn-glyphs.lisp")))
      (load "musglyphs.scm")
      (load "draw.scm")
      (add-hook! after-graph-hook display-previous-edits)
      (add-hook! lisp-graph-hook display-energy)
      (let* ((ind (open-sound "oboe.snd"))
	     (wids (channel-widgets))
	     (wids1 (channel-widgets (selected-sound)))
	     (wids2 (channel-widgets (selected-sound) (selected-channel))))
	(do ((i 1 (1+ i)))
	    ((= i 4))
	  (scale-by 0.5)
	  (set! (x-bounds) (list 0 (* i .3))))
	(revert-sound ind)
	(draw-bass-clef 100 100 100 0 ind 0)
	(update-time-graph ind 0)
	(draw-fermata 200 100 60 0 ind 0)
	(draw-line 100 100 200 200 ind 0)
	(draw-dot 300 300 10 ind 0)
	(draw-string "hiho" 20 20 ind 0)
	(draw-dots '#(25 25 50 50 100 100) 10 ind 0)
	(-> 100 50 10 ind 0)
	(fill-rectangle 20 20 100 100 ind 0)
	(make-bezier 0 0 20 20 40 30 60 10 10)
	(update-time-graph ind 0)
	(reset-hook! after-graph-hook)
	(reset-hook! lisp-graph-hook)
	(let* ((ind1 (open-sound "2.snd"))
	       (wids3 (channel-widgets ind1 0))
	       (wids4 (channel-widgets ind1 1)))
	  (IF (or (not (list? wids))
		  (not (list? wids3))
		  (not (= (length wids1) 11))
		  (not (= (length wids2) 11)))
	      (snd-display ";channel-widgets confused: ~A ~A ~A ~A ~A" wids wids1 wids2 wids3 wids4))
	  (hide-widget (car (channel-widgets)))
	  (show-widget (car (channel-widgets)))
	  (close-sound ind1))
	(close-sound ind))))


;;; ---------------- test 18: enved ----------------

(load "enved.scm")
(if (and (or full-test (= snd-test 18) (and keep-going (<= snd-test 18)))
	 (not (provided? 'snd-nogui)))
    (begin
      (if (procedure? test-hook) (test-hook 18))
      (start-enveloping)
      (let ((nind (open-sound "oboe.snd")))
	(IF (not (equal? (channel-envelope nind 0) (list 0.0 1.0 1.0 1.0)))
	    (snd-display ";channel-envelope: ~A?" (channel-envelope nind 0)))
	(set! (channel-envelope nind 0) (list 0 0 1 1 2 0))
	(IF (not (equal? (channel-envelope nind 0) (list 0 0 1 1 2 0)))
	    (snd-display ";set channel-envelope: ~A?" (channel-envelope nind 0)))
	(close-sound nind)
	(stop-enveloping))))


;;; ---------------- test 19: save and restore ----------------

(define sfile 0)

(if (or full-test (= snd-test 19) (and keep-going (<= snd-test 19)))
    (let ((nind (open-sound "oboe.snd")))
      (if (procedure? test-hook) (test-hook 19))
      (add-mark 123)
      (delete-sample 12)
      (set! (x-bounds) (list .2 .4))
      (let ((old-bounds (x-bounds)))
	(save-state (save-state-file))
	(save-options "test.temp")
	(close-sound nind)
	(load (save-state-file))
	(let ((ind (find-sound "oboe.snd")))
	  (IF (or (> (abs (- (car old-bounds) (car (x-bounds ind 0)))) .05)
		  (> (abs (- (cadr old-bounds) (cadr (x-bounds ind 0)))) .05))
	      (snd-display ";save bounds: ~A" (x-bounds ind 0)))
	  (IF (not (= (length (marks ind 0)) 1))
	      (snd-display ";save marks: ~A?" (marks ind 0)))
	  (IF (not (= (mark-sample (car (marks ind 0))) 122))
	      (snd-display ";save mark: ~A?" (mark-sample (car (marks ind 0)))))
	  (IF (not (= (edit-position ind 0) 1))
	      (snd-display ";save edit-position: ~A" (edit-position ind 0)))
	  (IF (not (equal? (edit-fragment 1 ind 0) (list "delete-sample" "delete" 12 1)))
	      (snd-display ";save edits: ~A" (edit-fragment 1 ind 0)))
	  (IF (not (equal? (edit-tree ind 0) 
			   (list (list 0 0 0 11 1.0) (list 12 0 13 50827 1.0) (list 50827 -2 0 0 0.0))))
	      (snd-display ";save edit tree: ~A" (edit-tree ind 0)))
	  (close-sound ind)

	  (let ((err (catch 'cannot-save
		   (lambda () 
		     (save-state "/bad/bad.save"))
		   (lambda args 12345))))
	    (IF (not (= err 12345)) (snd-display ";save-state err: ~A?" err)))

	  (let ((err (catch 'cannot-save
		   (lambda () 
		     (save-listener "/bad/bad.save"))
		   (lambda args 12345))))
	    (IF (not (= err 12345)) (snd-display ";save-listener err: ~A?" err)))
	  ))
      (set! nind (open-sound "oboe.snd"))
      (set! (sample 1) .5)
      (delete-sample 100)
      (insert-sample 10 .5)
      (scale-channel 2.0)
      (save-edit-history "hiho.scm")
      (revert-sound nind)
      (set! sfile nind)
      (load "hiho.scm")
      (IF (not (equal? (edit-fragment 1) '("set-sample" "set" 1 1))) (snd-display ";save-edit-history 1: ~A?" (edit-fragment 1)))
      (IF (not (equal? (edit-fragment 2) '("delete-sample" "delete" 100 1))) (snd-display ";save-edit-history 2: ~A?" (edit-fragment 2)))
      (IF (not (equal? (edit-fragment 3) '("insert-sample" "insert" 10 1))) (snd-display ";save-edit-history 3: ~A?" (edit-fragment 3)))
      (IF (not (equal? (edit-fragment 4) '("scale-channel 2.0000 0 50828" "lambda" 0 50828))) (snd-display ";save-edit-history 4: ~A?" (edit-fragment 4)))
      (let ((str (display-edits)))
	(IF (not (string=? str "
EDITS: 4

 (begin) [0:2]:
   (at 0, cp->sounds[0][0:50827, 1.000000]) [file: /home/bil/cl/oboe.snd[0]]
   (at 50828, cp->sounds[-2][0:0, 0.000000])

 (set 1 1) ; set-sample [1:4]:
   (at 0, cp->sounds[0][0:0, 1.000000]) [file: /home/bil/cl/oboe.snd[0]]
   (at 1, cp->sounds[1][0:0, 1.000000]) [buf: 1] 
   (at 2, cp->sounds[0][2:50827, 1.000000]) [file: /home/bil/cl/oboe.snd[0]]
   (at 50828, cp->sounds[-2][0:0, 0.000000])

 (delete 100 1) ; delete-sample [2:5]:
   (at 0, cp->sounds[0][0:0, 1.000000]) [file: /home/bil/cl/oboe.snd[0]]
   (at 1, cp->sounds[1][0:0, 1.000000]) [buf: 1] 
   (at 2, cp->sounds[0][2:99, 1.000000]) [file: /home/bil/cl/oboe.snd[0]]
   (at 100, cp->sounds[0][101:50827, 1.000000]) [file: /home/bil/cl/oboe.snd[0]]
   (at 50827, cp->sounds[-2][0:0, 0.000000])

 (insert 10 1) ; insert-sample [3:7]:
   (at 0, cp->sounds[0][0:0, 1.000000]) [file: /home/bil/cl/oboe.snd[0]]
   (at 1, cp->sounds[1][0:0, 1.000000]) [buf: 1] 
   (at 2, cp->sounds[0][2:9, 1.000000]) [file: /home/bil/cl/oboe.snd[0]]
   (at 10, cp->sounds[2][0:0, 1.000000]) [buf: 1] 
   (at 11, cp->sounds[0][10:99, 1.000000]) [file: /home/bil/cl/oboe.snd[0]]
   (at 101, cp->sounds[0][101:50827, 1.000000]) [file: /home/bil/cl/oboe.snd[0]]
   (at 50828, cp->sounds[-2][0:0, 0.000000])

 (scale-channel 2.0000 0 50828 0 50828) ; scale-channel 2.0000 0 50828 [4:7]:
   (at 0, cp->sounds[0][0:0, 2.000000]) [file: /home/bil/cl/oboe.snd[0]]
   (at 1, cp->sounds[1][0:0, 2.000000]) [buf: 1] 
   (at 2, cp->sounds[0][2:9, 2.000000]) [file: /home/bil/cl/oboe.snd[0]]
   (at 10, cp->sounds[2][0:0, 2.000000]) [buf: 1] 
   (at 11, cp->sounds[0][10:99, 2.000000]) [file: /home/bil/cl/oboe.snd[0]]
   (at 101, cp->sounds[0][101:50827, 2.000000]) [file: /home/bil/cl/oboe.snd[0]]
   (at 50828, cp->sounds[-2][0:0, 0.000000])
"))
	    (snd-display ";display-edits: ~A?" str)))
      (save-edit-history "hiho.scm" nind 0)
      (scale-sound-to 1.0 nind 0)
      (let ((eds (edit-position nind 0))
	    (val (insert-sound "zero.snd")))
	(IF (or (not (= 0 val))
		(not (= eds (edit-position nind 0))))
	    (snd-display ";insert-sound zero.snd was an edit? ~A ~A ~A" val eds (edit-position nind 0))))
      (revert-sound nind)
      (close-sound nind)

      (let ((ind (new-sound "fmv.snd")))
	(set! (sample 10) .1)
	(save-sound ind)
	(set! (sample 1) .1)
	(let ((eds (display-edits ind)))
	  (save-state "t1.scm")
	  (close-sound ind)
	  (load "t1.scm")
	  (set! ind (find-sound "fmv.snd"))
	  (IF (not (sound? ind))
	      (snd-display ";save-state restored but no sound?"))
	  (let ((new-eds (display-edits ind)))
	    (IF (not (string=? eds new-eds))
		(snd-display ";save-state from ~A to ~A?" eds new-eds)))
	  (do ((i 3 (1+ i)))
	      ((= i 6))
	    (set! (sample i) (* i .1))
	    (set! eds (display-edits ind))
	    (save-state "t1.scm")
	    (close-sound ind)
	    (load "t1.scm")
	    (set! ind (find-sound "fmv.snd"))
	    (IF (not (sound? ind))
		(snd-display ";save-state ~A restored but no sound?" i))
	    (let ((new-eds (display-edits ind)))
	      (IF (not (string=? eds new-eds))
		  (snd-display ";save-state ~A from ~A to ~A?" i eds new-eds)))))
	(close-sound ind)
	(delete-file "t1.scm"))
      
      (let ((ind (new-sound "fmv.snd" mus-next mus-bshort 22050 8 "this is an 8-channel save-state test"))
	    (ind1 (new-sound "fmv1.snd" mus-next mus-bshort 22050 2 "this is a 2-channel save-state test")))
	(set! (sample 10 ind 0) .1)
	(set! (sample 10 ind 1) .2)
	(set! (sample 10 ind 2) .3)
	(set! (sample 10 ind 3) .4)
	(set! (sample 10 ind1 0) -.1)
	(set! (sample 10 ind1 1) -.2)
	(save-sound ind)
	(save-sound ind1)
	(set! (sample 1 ind 0) .1)
	(set! (sample 1 ind 1) .2)
	(set! (sample 1 ind 2) .3)
	(set! (sample 1 ind 3) .4)
	(set! (sample 1 ind1 0) -.1)
	(set! (sample 1 ind1 1) -.2)
	(let ((eds (display-edits ind))
	      (eds1 (display-edits ind1)))
	  (save-state "t1.scm")
	  (close-sound ind)
	  (close-sound ind1)
	  (load "t1.scm")
	  (set! ind (find-sound "fmv.snd"))
	  (set! ind1 (find-sound "fmv1.snd"))
	  (IF (or (not (sound? ind))
		  (not (sound? ind1)))
	      (snd-display ";save-state(2) restored but no sound? ~A ~A" ind ind1))
	  (let ((new-eds (display-edits ind))
		(new-eds1 (display-edits ind1)))
	    (IF (not (string=? eds new-eds))
		(snd-display ";save-state(1) from ~A to ~A?" eds new-eds))
	    (IF (not (string=? eds1 new-eds1))
		(snd-display ";save-state(2) from ~A to ~A?" eds1 new-eds1))))
	(close-sound ind)
	(close-sound ind1)
	(delete-file "t1.scm"))

      ))


;;; ---------------- test 20: transforms ----------------

(define (bes-j0 x)				;returns J0(x) for any real x
  (if (< (abs x) 8.0)			;direct rational function fit
      (let* ((y (* x x))
	     (ans1 (+ 57568490574.0
		      (* y (+ -13362590354.0 
			      (* y  (+ 651619640.7
				       (* y (+ -11214424.18 
					       (* y (+ 77392.33017
						       (* y -184.9052456)))))))))))
	     (ans2 (+ 57568490411.0 
		      (* y (+ 1029532985.0 
			      (* y (+ 9494680.718
				      (* y (+ 59272.64853
					      (* y (+ 267.8532712 y)))))))))))
	(/ ans1 ans2))
    (let* ((ax (abs x))
	   (z (/ 8.0 ax))
	   (y (* z z))
	   (xx (- ax 0.785398164))
	   (ans1 (+ 1.0 
		    (* y (+ -0.1098628627e-2 
			    (* y (+ 0.2734510407e-4
				    (* y (+ -0.2073370639e-5
					    (* y 0.2093887211e-6)))))))))
	   (ans2 (+ -0.1562499995e-1
		    (* y (+ 0.1430488765e-3
			    (* y (+ -0.6911147651e-5
				    (* y (+ 0.7621095161e-6
					    (* y -0.934945152e-7))))))))))
      (* (sqrt (/ 0.636619772 ax))
	 (- (* (cos xx) ans1)
	    (* z (sin xx) ans2))))))

(define (peak-at data)
  (let ((len (vct-length data))
	(peak (vct-ref data 0))
	(loc 0))
    (do ((i 1 (1+ i)))
	((= i len) (list loc peak))
      (if (> (vct-ref data i) peak)
	  (begin
	    (set! peak (vct-ref data i))
	    (set! loc i))))))

(define (chebyshev-polynomial a x kind lim)	
  ;; evaluate the sum of the Chebyshev polynomials (coeffs in a) at x
  ;;  similar to make-waveshape-table which runs through -1<=x<=1 internally,
  ;;  but intended to be parallel to the polynomial unit generator --
  ;; (polynomial (get-chebyshev-coefficients harms-and-amps) x) is equivalent to 
  ;; (chebyshev-polynomial harm-amps x)
  (let* ((n (1- (vct-length a)))
	 (r (* kind x))
	 (s 1.0)
	 (h 0.0)
	 (sum (vct-ref a 0)))
    (do ((k 1 (1+ k)))
	((= k n))
      (set! h r)
      (set! sum (+ sum (* r (vct-ref a k))))
      (set! r (- (* 2 r x) s))
      (set! s h))
    (+ sum (* r (vct-ref a n)))))

(define (inverse-haar f)
  (let* ((n (vct-length f))
	 (g (make-vct n))
	 (s2 (sqrt 2.0))
	 (v (/ 1.0 (sqrt n))))
    (vct-set! f 0 (* (vct-ref f 0) v))
    (do ((m 2 (* m 2)))
	((> m n))
      (let ((mh (/ m 2)))
	(do ((j 0 (+ j 2))
	     (k 0 (+ k 1)))
	    ((= j m))
	  (let ((x (vct-ref f k))
		(y (* (vct-ref f (+ mh k)) v)))
	    (vct-set! g j (+ x y))
	    (vct-set! g (+ j 1) (- x y))))
	(do ((i (- m 1) (- i 1)))
	    ((< i 0))
	  (vct-set! f i (vct-ref g i)))
	(set! v (* v s2))))
    f))

(define (wavelet data n isign wf cc)
  (let* ((cc-size (vct-length cc))
	 (ccr (make-vct cc-size))
	 (sig -1.0))
    (do ((i 0 (1+ i))
	 (j (- cc-size 1) (1- j)))
	((= i cc-size))
      (vct-set! ccr j (* sig (vct-ref cc i)))
      (set! sig (- sig)))
    (if (>= n 4)
	(if (>= isign 0)
	    (do ((nn n (/ nn 2)))
		((< nn 4))
	      (wf data nn isign cc ccr))
	    (do ((nn 4 (* nn 2)))
		((> nn n))
	      (wf data nn isign cc ccr))))))

(define (pwt data n isign cc cr)
  (let* ((data1 (make-vct n))
	 (n1 (1- n))
	 (ncof (vct-length cc))
	 (nmod (* ncof n))
	 (nh (inexact->exact (floor (/ n 2))))
	 (joff (inexact->exact (- (floor (/ ncof 2)))))
	 (ioff joff))
    (if (>= isign 0)
	(do ((ii 0 (1+ ii))
	     (i 1 (+ i 2)))
	    ((> i n))
	  (let ((ni (+ i nmod ioff))
		(nj (+ i nmod joff)))
	    (do ((k 1 (1+ k)))
		((> k ncof))
	      (let ((jf (logand n1 (+ ni k))) ;gad wotta kludge...
		    (jr (logand n1 (+ nj k))))
		(vct-set! data1 ii (+ (vct-ref data1 ii)
				      (* (vct-ref cc (1- k)) 
					 (vct-ref data jf))))
		(vct-set! data1 (+ ii nh) (+ (vct-ref data1 (+ ii nh))
					     (* (vct-ref cr (1- k)) 
						(vct-ref data jr))))))))
	(do ((ii 0 (1+ ii))
	     (i 1 (+ i 2)))
	    ((> i n))
	  (let ((ai (vct-ref data ii))
		(ai1 (vct-ref data (+ ii nh)))
		(ni (+ i nmod ioff))
		(nj (+ i nmod joff)))
	    (do ((k 1 (1+ k)))
		((> k ncof))
	      (let ((jf (logand n1 (+ ni k)))
		    (jr (logand n1 (+ nj k))))
		(vct-set! data1 jf (+ (vct-ref data1 jf) 
					       (* ai (vct-ref cc (1- k)))))
		(vct-set! data1 jr (+ (vct-ref data1 jr)
				      (* ai1 (vct-ref cr (1- k))))))))))
    (do ((i 0 (1+ i)))
	((= i n))
      (vct-set! data i (vct-ref data1 i)))
    data))

(if (or full-test (= snd-test 20) (and keep-going (<= snd-test 20)))
    (let* ((daub4 (vct 0.4829629131445341 0.8365163037378079 0.2241438680420134 -0.1294095225512604))
	   (daub6 (vct 0.332670552950 0.806891509311 0.459877502118 -0.135011020010 -0.085441273882 0.035226291886))
	   (daub8 (vct 0.230377813309 0.714846570553 0.630880767930 -0.027983769417 -0.187034811719 0.030841381836
		       0.032883011667 -0.010597401785))
	   (daub10 (vct 0.160102397974 0.603829269797 0.724308528438 0.138428145901 -0.242294887066 -0.032244869585
			0.077571493840 -0.006241490213 -0.012580751999 0.003335725285))
	   (daub12 (vct 0.111540743350 0.494623890398 0.751133908021 0.315250351709 -0.226264693965 -0.129766867567
			0.097501605587 0.027522865530 -0.031582039317 0.000553842201 0.004777257511 -0.001077301085))
	   (daub14 (vct 0.077852054085 0.396539319482 0.729132090846 0.469782287405 -0.143906003929 -0.224036184994
			0.071309219267 0.080612609151 -0.038029936935 -0.016574541631 0.012550998556 0.000429577973
			-0.001801640704 0.000353713800))
	   (daub16 (vct 0.054415842243 0.312871590914 0.675630736297 0.585354683654 -0.015829105256 -0.284015542962
			0.000472484574 0.128747426620 -0.017369301002 -0.044088253931 0.013981027917 0.008746094047
			-0.004870352993 -0.000391740373 0.000675449406 -0.000117476784))
	   (daub18 (vct 0.038077947364 0.243834674613 0.604823123690 0.657288078051 0.133197385825 -0.293273783279
			-0.096840783223 0.148540749338 0.030725681479 -0.067632829061 0.000250947115 0.022361662124
			-0.004723204758 -0.004281503682 0.001847646883 0.000230385764 -0.000251963189 0.000039347320))
	   (daub20 (vct 0.026670057901 0.188176800077 0.527201188931 0.688459039453 0.281172343661 -0.249846424327
			-0.195946274377 0.127369340336 0.093057364604 -0.071394147166 -0.029457536822 0.033212674059
			0.003606553567 -0.010733175483 0.001395351747 0.001992405295 -0.000685856695 -0.000116466855
			0.000093588670 -0.000013264203))
	   (SQRT2 1.41421356237309504880168872420969808)
	   (Battle-Lemarie (vct (* SQRT2 -0.002) (* SQRT2 -0.003) (* SQRT2  0.006) (* SQRT2  0.006) (* SQRT2 -0.013)
				(* SQRT2 -0.012) (* SQRT2  0.030) (* SQRT2  0.023) (* SQRT2 -0.078) (* SQRT2 -0.035)
				(* SQRT2  0.307) (* SQRT2  0.542) (* SQRT2  0.307) (* SQRT2 -0.035) (* SQRT2 -0.078)
				(* SQRT2  0.023) (* SQRT2  0.030) (* SQRT2 -0.012) (* SQRT2 -0.013) (* SQRT2  0.006)
				(* SQRT2  0.006) (* SQRT2 -0.003) (* SQRT2 -0.002) 0.0))
	   (Burt-Adelson (vct (* SQRT2 (/ -1.0 20.0)) (* SQRT2 (/ 5.0 20.0)) (* SQRT2 (/ 12.0 20.0))
			      (* SQRT2 (/ 5.0 20.0)) (* SQRT2 (/ -1.0 20.0)) 0.0))
	   (Beylkin (vct 0.099305765374353 0.424215360812961 0.699825214056600 0.449718251149468
			 -.110927598348234 -.264497231446384 0.026900308803690 0.155538731877093
			 -.017520746266529 -.088543630622924 0.019679866044322 0.042916387274192
			 -.017460408696028 -.014365807968852 0.010040411844631 .0014842347824723
			 -.002736031626258 .0006404853285212))
	   (SQRT15 3.87298334620741688517927)
	   (coif2 (vct (/ (* SQRT2 (- SQRT15 3)) 32.0) (/ (* SQRT2 (- 1 SQRT15)) 32.0) (/ (* SQRT2 (- 6 (* 2 SQRT15))) 32.0)
		       (/ (* SQRT2 (+ (* 2 SQRT15) 6)) 32.0) (/ (* SQRT2 (+ SQRT15 13)) 32.0) (/ (* SQRT2 (- 9 SQRT15)) 32.0)))
	   (coif4 (vct 0.0011945726958388 	-0.01284557955324 0.024804330519353 0.050023519962135 -0.15535722285996
		       -0.071638282295294 0.57046500145033 0.75033630585287 0.28061165190244 -0.0074103835186718
		       -0.014611552521451 -0.0013587990591632))
	   (coif6 (vct -0.0016918510194918 -0.00348787621998426 0.019191160680044 0.021671094636352 -0.098507213321468
		       -0.056997424478478 0.45678712217269 0.78931940900416 0.38055713085151 -0.070438748794943 
		       -0.056514193868065 0.036409962612716 0.0087601307091635 -0.011194759273835 -0.0019213354141368
		       0.0020413809772660 0.00044583039753204 -0.00021625727664696))
	   (sym2 (vct (* SQRT2 -0.125) (* SQRT2  0.25) (* SQRT2  0.75) (* SQRT2  0.25) (* SQRT2 -0.125)))
	   (sym3 (vct (/ (* SQRT2 1.0) 8.0) (/ (* SQRT2 3.0) 8.0) (/ (* SQRT2 3.0) 8.0) (/ (* SQRT2 1.0) 8.0)))
	   (sym4 (vct (/ (* SQRT2   3.0) 128.0) (/ (* SQRT2  -6.0) 128.0) (/ (* SQRT2 -16.0) 128.0)
		      (/ (* SQRT2  38.0) 128.0) (/ (* SQRT2  90.0) 128.0) (/ (* SQRT2  38.0) 128.0)
		      (/ (* SQRT2 -16.0) 128.0) (/ (* SQRT2  -6.0) 128.0) (/ (* SQRT2   3.0) 128.0) 0.0))
	   (sym5 (vct (/ (* SQRT2  3.0) 64.0) (/ (* SQRT2 -9.0) 64.0) (/ (* SQRT2 -7.0) 64.0) (/ (* SQRT2 45.0) 64.0)
		      (/ (* SQRT2 45.0) 64.0) (/ (* SQRT2 -7.0) 64.0) (/ (* SQRT2 -9.0) 64.0) (/ (* SQRT2  3.0) 64.0)))
	   (sym6 (vct (/ (* SQRT2   -35.0) 16384.0) (/ (* SQRT2  -105.0) 16384.0) (/ (* SQRT2  -195.0) 16384.0)
		      (/ (* SQRT2   865.0) 16384.0) (/ (* SQRT2   363.0) 16384.0) (/ (* SQRT2 -3489.0) 16384.0)
		      (/ (* SQRT2  -307.0) 16384.0) (/ (* SQRT2 11025.0) 16384.0) (/ (* SQRT2 11025.0) 16384.0)
		      (/ (* SQRT2  -307.0) 16384.0) (/ (* SQRT2 -3489.0) 16384.0) (/ (* SQRT2   363.0) 16384.0)
		      (/ (* SQRT2   865.0) 16384.0) (/ (* SQRT2  -195.0) 16384.0) (/ (* SQRT2  -105.0) 16384.0)
		      (/ (* SQRT2   -35.0) 16384.0))))
      (define wts (list 
		   daub4 daub6 daub8 daub10 daub12 daub14 daub16 daub18 daub20
		   Battle-Lemarie Burt-Adelson Beylkin coif2 coif4 coif6
		   sym2 sym3 sym4 sym5 sym6))

      (if (procedure? test-hook) (test-hook 20))
    (do ((clmtest 0 (1+ clmtest))) ((= clmtest tests)) (if (> tests 1) (snd-display ";test ~D " clmtest))
    (let ((d0 #f) (d1 #f) (fn #f))

      (let ((index (open-sound "oboe.snd")))
	;; check small transform cases
	(set! (graph-transform?) #t)
	(for-each 
	 (lambda (transform)
	   (set! (transform-type) transform)
	   (for-each
	    (lambda (size)
	      (set! (transform-size) size)
	      (update-transform))
	    (list 8 7 -7 4 3 2 1 0)))
	 (list fourier-transform  wavelet-transform   hankel-transform    chebyshev-transform
	       autocorrelation    walsh-transform     hadamard-transform  cepstrum     haar-transform))
	(close-sound index))

      ;; -------- fft

      (set! d0 (make-vct 16))
      (vct-set! d0 0 1.0)
      (snd-transform fourier-transform d0 0)
      (do ((i 0 (1+ i)))
	  ((= i 16))
	(IF (fneq (vct-ref d0 i) 1.0)
	    (snd-display ";fourier (1.0) [~D]: ~A?" i (vct-ref d0 i))))

      (snd-transform fourier-transform d0 0)
      (IF (fneq (vct-ref d0 0) 256.0)
	  (snd-display (format ";fourier (256.0): ~A?" (vct-ref d0 0))))
      (do ((i 1 (1+ i)))
	  ((= i 16))
	(IF (fneq (vct-ref d0 i) 0.0)
	    (snd-display ";fourier (0.0) [~D]: ~A?" i (vct-ref d0 i))))

      (set! d0 (make-vct 8))
      (set! d1 (make-vct 8))
      (vct-set! d0 2 1.0)
      (mus-fft d0 d1 8 1)
      (IF (or (not (vequal d0 (vct 1.000 0.000 -1.000 -0.000 1.000 0.000 -1.000 -0.000)))
	      (not (vequal d1 (vct 0.000 1.000 0.000 -1.000 0.000 1.000 0.000 -1.000))))
	  (snd-display ";mus-fft 1: ~A ~A?" d0 d1))
      (mus-fft d0 d1 8 -1)
      (IF (or (not (vequal d0 (vct 0.000 0.000 8.000 0.000 0.000 0.000 0.000 0.000)))
	      (not (vequal d1 (vct 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000))))
	  (snd-display ";mus-fft -1: ~A ~A?" d0 d1))
      
      (vct-fill! d0 1.0)
      (vct-fill! d1 0.0)
      (mus-fft d0 d1 8)
      (IF (or (not (vequal d0 (vct 8.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	      (not (vequal d1 (vct 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000))))
	  (snd-display ";mus-fft 2: ~A ~A?" d0 d1))
      (mus-fft d0 d1 8 -1)
      (IF (or (not (vequal d0 (vct 8.000 8.000 8.000 8.000 8.000 8.000 8.000 8.000)))
	      (not (vequal d1 (vct 0.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000))))
	  (snd-display ";mus-fft -2: ~A ~A?" d0 d1))

      (vct-fill! d1 0.0)
      (vct-map! d0 (lambda () (random 1.0)))
      (set! fn (vct-copy d0))
      (mus-fft d0 d1 8)
      (mus-fft d0 d1 8 -1)
      (vct-scale! d0 (/ 1.0 8.0))
      (IF (not (vequal d0 fn))
	  (snd-display ";mus-fft 3: ~A ~A?" d0 fn))

      (for-each 
       (lambda (size)
	 (set! d0 (make-vct size))
	 (vct-set! d0 0 1.0)
	 (set! d1 (snd-spectrum d0 rectangular-window size))
	 (do ((i 0 (1+ i)))
	     ((= i (/ size 2)))
	   (IF (fneq (vct-ref d1 i) 1.0)
	       (snd-display ";snd-spectrum (1.0) [~D: ~D]: ~A?" i size (vct-ref d1 i))))

	 (set! d1 (snd-spectrum d0 rectangular-window))
	 (IF (fneq (vct-ref d1 0) 1.0)
	     (snd-display (format ";snd-spectrum back (1.0 ~D): ~A?" size (vct-ref d1 0))))
	 (do ((i 1 (1+ i)))
	     ((= i (/ size 2)))
	   (IF (fneq (vct-ref d1 i) 0.0)
	       (snd-display ";snd-spectrum (0.0) [~D: ~D]: ~A?" i size (vct-ref d1 i))))

	 (set! d1 (snd-spectrum d0 rectangular-window size #f)) ; dB (0.0 = max)
	 (do ((i 0 (1+ i)))
	     ((= i (/ size 2)))
	   (IF (fneq (vct-ref d1 i) 0.0)
	       (snd-display ";snd-spectrum dB (0.0) [~D: ~D]: ~A?" i size (vct-ref d1 i)))))

       (list 8 16))


      ;; -------- fht
      
      (set! d0 (make-vct 16))
      (set! d1 (make-vct 16))
      (do ((i 0 (1+ i)))
	  ((= i 16))
	(vct-set! d0 i (random 1.0)) 
	(vct-set! d1 i (vct-ref d0 i)))
      (fht d0)
      (fht d0)
      (vct-scale! d0 (/ 1.0 16.0))
      (do ((i 0 (1+ i)))
	  ((= i 16))
	(IF (fneq (vct-ref d0 i) (vct-ref d1 i))
	    (snd-display (format ";fht twice [~D]:~A ~A?" i (vct-ref d0 i) (vct-ref d1 i)))))

      (for-each 
       (lambda (size)
	 (for-each
	  (lambda (loc)
	    (let ((rdat (make-vct size)))
	      (vct-set! rdat loc 1.0)
	      (autocorrelate rdat)
	      (IF (fneq (vct-ref rdat 0) 2.0) (snd-display ";autocorrelate ~D:~D: ~A?" size loc rdat))
	      (do ((i 1 (1+ i)))
		  ((= i (/ size 2)))
		(if (fneq (vct-ref rdat i) 0.0) (snd-display ";autocorrelate ~D:~D[~D]: ~A?" size loc i (vct-ref rdat i))))))
	  (list 0 1 2 3)))
       (list 8 16 128 256))

      (for-each 
       (lambda (size)
	 (for-each
	  (lambda (loc)
	    (let ((rdat (make-vct size)))
	      (vct-set! rdat loc 1.0)
	      (vct-set! rdat (+ loc 1) 1.0)
	      (autocorrelate rdat)
	      (IF (fneq (vct-ref rdat 0) 4.0) (snd-display ";autocorrelate(4) ~D:~D: ~A?" size loc rdat))
	      (IF (fneq (vct-ref rdat 1) 2.0) (snd-display ";autocorrelate(4:1) ~D:~D: ~A?" size loc rdat))
	      (do ((i 2 (1+ i)))
		  ((= i (/ size 2)))
		(if (fneq (vct-ref rdat i) 0.0) (snd-display ";autocorrelate(4) ~D:~D[~D]: ~A?" size loc i (vct-ref rdat i))))))
	  (list 0 1 2 3)))
       (list 8 16 128 256))


      ;; -------- hankel

      (set! d0 (make-vct 128))
      (do ((i 0 (1+ i))) 
	  ((= i 128)) 
	(vct-set! d0 i (bes-j0 (/ (* i 12 3.14159) 128.0))))
      (snd-transform hankel-transform d0)
      (let ((pinfo (peak-at d0)))
	(IF (not (= (car pinfo) 5))
	    (snd-display ";hankel 1: ~A ~A?" pinfo d0)))

      (do ((i 0 (1+ i))) 
	  ((= i 128)) 
	(vct-set! d0 i (+ (bes-j0 (/ (* i 12 3.14159) 128.0)) 
			  (bes-j0 (/ (* i 20 3.14159) 128.0)))))
      (snd-transform hankel-transform d0)
      (let ((pinfo (peak-at d0)))
	(IF (and (not (= (car pinfo) 5))
		 (not (= (car pinfo) 9)))
	    (snd-display ";hankel 2: ~A ~A?" pinfo d0))
	(vct-set! d0 (car pinfo) 0.0)
	(let ((pinfo (peak-at d0)))
	  (IF (and (not (= (car pinfo) 5))
		   (not (= (car pinfo) 9)))
	      (snd-display ";hankel 3: ~A?" pinfo))))

      (do ((i 0 (1+ i))) 
	  ((= i 128)) 
	(vct-set! d0 i (+ (bes-j0 (/ (* i 12 3.14159) 128.0)) 
			  (* 4.0 (bes-j0 (/ (* i 20 3.14159) 128.0))))))
      (snd-transform hankel-transform d0)
      (let ((pinfo (peak-at d0)))
	(IF (not (= (car pinfo) 9))
	    (snd-display ";hankel 4: ~A?" pinfo))
	(vct-set! d0 9 0.0)
	(let ((npinfo (peak-at d0)))
	  (IF (not (= (car npinfo) 5))
	      (snd-display ";hankel 5: ~A?" npinfo))
	  (IF (not (> (cadr pinfo) (cadr npinfo)))
	      (snd-display ";hankel 6: ~A?" pinfo))))

      (do ((i 0 (1+ i))) 
	  ((= i 128)) 
	(vct-set! d0 i (bes-j0 (/ (* i 3.14159) 128.0))))
      (snd-transform hankel-transform d0)
      (let ((pinfo (peak-at d0)))
	(IF (not (= (car pinfo) 0))
	    (snd-display ";hankel 7: ~A?" pinfo)))

      (set! d0 (make-vct 8))
      (do ((i 0 (1+ i))) 
	  ((= i 8)) 
	(vct-set! d0 i (bes-j0 (/ (* i 3.14159) 8.0))))
      (snd-transform hankel-transform d0)
      (IF (< (/ (abs (vct-ref d0 0))
		(abs (vct-ref d0 1)))
	     3.0)
	  (snd-display ";hankel 8: ~A?" d0))


      ;; -------- walsh

      (set! d0 (make-vct 8))
      (vct-set! d0 0 1.0)
      (snd-transform walsh-transform d0)
      (IF (not (vequal d0 (vct 1.000 1.000 1.000 1.000 1.000 1.000 1.000 1.000)))
	  (snd-display ";walsh 1: ~A" d0))
      (snd-transform walsh-transform d0)
      (IF (not (vequal d0 (vct 8.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display ";walsh -1: ~A" d0))
      
      (set! d0 (make-vct 8))
      (vct-set! d0 1 1.0)
      (snd-transform walsh-transform d0)
      (IF (not (vequal d0 (vct 1.000 -1.000 1.000 -1.000 1.000 -1.000 1.000 -1.000)))
	  (snd-display ";walsh 2: ~A" d0))
      (snd-transform walsh-transform d0)
      (IF (not (vequal d0 (vct 0.000 8.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display ";walsh -2: ~A" d0))

      (set! d0 (make-vct 8))
      (vct-set! d0 1 1.0)
      (vct-set! d0 0 0.5)
      (snd-transform walsh-transform d0)
      (IF (not (vequal d0 (vct 1.500 -0.500 1.500 -0.500 1.500 -0.500 1.500 -0.500)))
	  (snd-display ";walsh 3: ~A" d0))
      (snd-transform walsh-transform d0)
      (IF (not (vequal d0 (vct 4.000 8.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display ";walsh -3: ~A" d0))

      (set! d0 (make-vct 8))
      (vct-map! d0 (lambda () (random 1.0)))
      (set! d1 (vct-copy d0))
      (snd-transform walsh-transform d0)
      (snd-transform walsh-transform d0)
      (vct-scale! d0 (/ 1.0 8.0))
      (IF (not (vequal d0 d1))
	  (snd-display ";walsh 4: ~A ~A" d0 d1))


      ;; -------- haar
      
      (set! d0 (make-vct 8))
      (vct-set! d0 2 1.0)
      (snd-transform haar-transform d0)
      (IF (not (vequal d0 (vct 0.354 0.354 -0.500 0.000 0.000 0.707 0.000 0.000)))
	  (snd-display ";haar 1: ~A" d0))
      (inverse-haar d0)
      (IF (not (vequal d0 (vct 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display ";inverse haar 1: ~A" d0))

      (set! d0 (make-vct 8))
      (vct-set! d0 0 1.0)
      (snd-transform haar-transform d0)
      (IF (not (vequal d0 (vct 0.354 0.354 0.500 0.000 0.707 0.000 0.000 0.000)))
	  (snd-display ";haar 2: ~A" d0))
      (inverse-haar d0)
      (IF (not (vequal d0 (vct 1.000 0.000 0.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display ";inverse haar 2: ~A" d0))

      (set! d0 (make-vct 8))
      (set! d1 (make-vct 8))
      (do ((i 0 (1+ i)))
	  ((= i 8))
	(vct-set! d0 i (random 1.0))
	(vct-set! d1 i (vct-ref d0 i)))
      (snd-transform haar-transform d0)
      (inverse-haar d0)
      (IF (not (vequal d0 d1))
	  (snd-display ";inverse haar 3: ~A ~A" d0 d1))


      ;; -------- chebyshev

      (set! fn (make-vct 128))
      (do ((i 0 (1+ i)))
	  ((= i 128))
	(vct-set! fn i (* i (/ 1.0 128))))
      (snd-transform chebyshev-transform fn)
      (set! d0 (make-vct 128))
      (do ((i 0 (1+ i)))
	  ((= i 128))
	(vct-set! d0 i (chebyshev-polynomial fn (- (* i (/ 2.0 128)) 1.0) 1 128)))
      (if (> (vct-ref d0 1) (vct-ref d0 4))
	  (snd-display ";cheby ramp: ~A?" d0))

      (do ((i 0 (1+ i)))
	  ((= i 128))
	(vct-set! fn i (sin (/ (* i 3.14159) 64.0))))
      (snd-transform chebyshev-transform fn)
      (set! d0 (make-vct 128))
      (do ((i 0 (1+ i)))
	  ((= i 128))
	(vct-set! d0 i (chebyshev-polynomial fn (- (* i (/ 2.0 128)) 1.0) 1 128)))
      (let ((error 0.0))
	(do ((i 0 (1+ i)))
	    ((= i 128))
	  (set! error (+ error (abs (- (sin (/ (* i 3.14159) 64.0)) (* .01 (vct-ref d0 i)))))))
	(if (> error 3.0)
	    (snd-display ";cheby sine: ~A?" error)))


      ;; --------- wavelet

      (for-each 
       (lambda (size)
	 (do ((i 0 (1+ i)))
	     ((= i 20))
	   (let ((d1 (make-vct size))
		 (d2 (make-vct size)))
	     (vct-set! d1 2 1.0)
	     (vct-set! d2 2 1.0)
	     (wavelet d1 size 0 pwt (list-ref wts i))
	     (snd-transform wavelet-transform d2 i)
	     (IF (not (vequal d1 d2))
		 (snd-display ";wavelet ~D: ~A ~A" i d1 d2))
	     (wavelet d2 size -1 pwt (list-ref wts i))
	     (vct-fill! d1 0.0)
	     (vct-set! d1 2 1.0)
	     (IF (not (vequal d1 d2))
		 (IF (or (= i 9) (= i 10))
		     (begin
		       (vct-set! d2 2 0.0)
		       (IF (> (vct-peak d2) .1)
			   (snd-display ";inverse wavelet ~D: ~A ~A" i d1 d2)))
		     (IF (> i 14)
			 (let ((pk (vct-ref d2 2)))
			   (vct-set! d2 2 0.0)
			   (IF (> (vct-peak d2) pk)
			       (snd-display ";inverse wavelet ~D: ~A ~A" i d1 d2)))
			 (snd-display ";inverse wavelet ~D: ~A ~A" i d1 d2))))))
	 (do ((i 0 (1+ i)))
	     ((= i 9))
	   (let ((d1 #f)
		 (d2 (make-vct size)))
	     (vct-map! d2 (lambda () (random 1.0)))
	     (set! d1 (vct-copy d2))
	     (snd-transform wavelet-transform d2 i)
	     (wavelet d2 size -1 pwt (list-ref wts i))
	     (IF (not (vequal d1 d2))
		 (snd-display ";random wavelet ~D: ~A ~A" i d1 d2)))))
       (list 16 64))


      ;; -------- hadamard (assuming blindly here that it should be its own inverse)

      (set! d0 (make-vct 8))
      (vct-set! d0 2 1.0)
      (snd-transform hadamard-transform d0)
      (IF (not (vequal d0 (vct 1.000 1.000 -1.000 -1.000 -1.000 -1.000 1.000 1.000)))
	  (snd-display ";hadamard 1: ~A?" d0))
      (snd-transform hadamard-transform d0)
      (vct-scale! d0 (/ 1.0 8.0))
      (IF (not (vequal d0 (vct 0.000 0.000 1.000 0.000 0.000 0.000 0.000 0.000)))
	  (snd-display ";hadamard -1: ~A?" d0))

      (let ((d1 #f)
	    (d2 (make-vct 64)))
	(vct-map! d2 (lambda () (random 1.0)))
	(set! d1 (vct-copy d2))
	(snd-transform hadamard-transform d2)
	(snd-transform hadamard-transform d2)
	(vct-scale! d2 (/ 1.0 64.0))
	(IF (not (vequal d1 d2))
	    (snd-display ";random hadamard: ~A ~A" d1 d2)))
      ))
      ))

#!
(if (or full-test (= snd-test 20) (and keep-going (<= snd-test 20)))
    (begin
      (load "gm.scm")
      (load "/home/bil/test/gmeteor-0.91/examples/example-1.scm")
      (let ((v1 (vector->vct *coefficients*))
	    (v2 (vct 0.0197 -0.0406 -0.0739 0.1340 0.4479 0.4479 0.13403 -0.0739 -0.0406 0.0197)))
	(IF (not (vfequal v1 v2))
	    (snd-display ";gm ~A ~A?" v1 v2)))))
!#



;;; ---------------- test 21: goops ----------------

(define (gcomb gen input)
  (gen input))	

(define (make-gcomb length feedback a0 a1)
  (let ((dly (make-delay length))
        (flt (make-one-zero a0 a1)))
    (lambda (input)
      (dly (+ input (* (flt (tap dly)) feedback))))))

(if (or full-test (= snd-test 21) (and keep-going (<= snd-test 21)))
    (begin
      (if (procedure? test-hook) (test-hook 21))
      (load "goopsnd.scm")
      (let ((f0 (make fcmb :length 4 :feedback 0.7))
	    (g0 (make-gcomb 4 0.7 0.5 0.5)))
	(fcomb f0 1.0)
	(gcomb g0 1.0)
	(do ((i 0 (1+ i)))
	    ((= i 20))
	  (let ((fval (fcomb f0 0.0))
		(gval (gcomb g0 0.0)))
	    (IF (fneq fval gval)
		(snd-display ";fcomb at ~A: ~A ~A?" i fval gval)))))))

(if (provided? 'snd-nogui) (exit))


;;; ---------------- test 22: user-interface ----------------

(if (provided? 'snd-motif)
    (begin
      (load "popup.scm")
      (load "snd-motif.scm")
      (load "event.scm")))

(define* (widget-string widget text #:optional (cleared #t))
  (define (shifted? ch)
    (if (or (and (char>=? ch #\A) (char<=? ch #\Z))
	    (char=? ch #\!) (char=? ch #\@) (char=? ch #\#) (char=? ch #\$) (char=? ch #\%) 
	    (char=? ch #\^) (char=? ch #\&) (char=? ch #\*) (char=? ch #\() (char=? ch #\)) 
	    (char=? ch #\_) (char=? ch #\+) (char=? ch #\:) (char=? ch #\") (char=? ch #\?)
	    (char=? ch #\<) (char=? ch #\>) (char=? ch #\{) (char=? ch #\}) (char=? ch #\|)  
	    (char=? ch #\~))
	1
	0))
  (take-keyboard-focus widget)
  (if cleared (set! (widget-text widget) ""))
  (do ((i 0 (1+ i)))
      ((= i (string-length text)))
    (let ((ch (string-ref text i)))
      (key-event widget (char->integer ch) (shifted? ch)))
    (force-event)))

(define mxa 32)

(if (not (defined? 'move-scale))
    (define (move-scale a b) #f))

(if (or full-test (= snd-test 22) (and keep-going (<= snd-test 22)))
    (begin
      (if (procedure? test-hook) (test-hook 22))

      (if (provided? 'snd-motif)
	  (let ((snd-return-key #xFF0D)
		(snd-left-key #xFF51)
		(snd-up-key #xFF52)
		(snd-right-key #xFF53)
		(snd-down-key #xFF54)
		(snd-kp-delete-key #xFF9F)
		(snd-kp-multiply-key #xFFAA)
		(snd-kp-add-key #xFFAB)
		(snd-kp-subtract-key #xFFAD)
		(snd-kp-decimal-key #xFFAE)
		(snd-kp-divide-key #xFFAF)
		(snd-kp-0-key #xFFB0)
		(snd-kp-3-key #xFFB3)
		(snd-kp-9-key #xFFB9)
		(snd-kp-enter-key #xFF8D)
		(snd-space-key #x20)
		(snd-kp-left-key #xFF96)
		(snd-kp-right-key #xFF98)
		(snd-kp-up-key #xFF97)
		(snd-tab-key #xFF09)
		(snd-kp-down-key #xFF99))

	    (define (all-help wid)
	      (if (|Widget? wid)
		  (for-each-child
		   wid
		   (lambda (n)
		     (let ((callable (|XtHasCallbacks n |XmNhelpCallback)))
		       (if (= callable |XtCallbackHasSome)
			   (|XtCallCallbacks n |XmNhelpCallback
				(let ((hlp (|XmAnyCallbackStruct)))
				  (set! (|reason hlp) |XmCR_HELP)
				  (set! (|event hlp) (|XEvent))
				  hlp))))))))

	    ;; force-event
	    ;; key-event widget key state
	    ;; click-event widget button state x y
	    ;; drag-event widget button state x0 y0 x1 y1
	    ;; expose-event widget x y width height
	    ;; resize-event widget width height
	    ;; click-button widget
	    ;; select-item list pos
	    ;;   these functions send either Xevents or directly invoke the Motif button callbacks
	    ;; resize-pane pane size 

	    (reset-all-hooks)
	    (for-each all-help (cdr (main-widgets)))
	    (set! (time-graph-type) graph-time-once)
	    (set! (transform-graph-type) graph-transform-once)
	    (|XSynchronize (|XtDisplay (cadr (main-widgets))) #t)
	    ;; don't touch the mouse during this test!

	    ;; -------- drive channel graph
	    (let ((ind (open-sound "oboe.snd")))

	      (IF (< (window-width) 600) 
		  (set! (window-width) 600))
	      (IF (< (window-height) 600)
		  (set! (window-height) 600))
	      (force-event)
	      (set! (x-bounds) (list 0.0 0.1))
	      (IF (< (cadr (widget-size (car (channel-widgets)))) 250)
		  (set! (widget-size (car (sound-widgets))) (list (car (widget-size (car (channel-widgets)))) 400)))

	      (if (defined? 'popup-display-info)
		  (begin
		    (select-sound ind)
		    (popup-display-info)))

	      (let* ((swids (sound-widgets))
		     (name-button (list-ref swids 1))
		     (minibuffer (list-ref swids 3))
		     (play-button (list-ref swids 4))
		     (cwid (car (channel-widgets)))
		     (size (widget-size (car (channel-widgets)))))

		(for-each all-help swids)
		(for-each all-help (channel-widgets))
		
		(|XtCallCallbacks minibuffer |XmNfocusCallback (|XmAnyCallbackStruct))
		(|XtCallCallbacks minibuffer |XmNlosingFocusCallback (|XmAnyCallbackStruct))
		(enter-event minibuffer) (force-event)
		(leave-event minibuffer) (force-event)
		(take-keyboard-focus (car (channel-widgets)))
		(click-event cwid 1 0 100 (inexact->exact (/ (cadr size) 2))) (force-event)
		(let ((pos (cursor-position)))
		  (IF (> (abs (- (car pos) 100)) 1)
		      (snd-display ";pos ~A: ~A?" 100 (car pos))))
		(click-event cwid 1 0 300 (inexact->exact (/ (cadr size) 2))) (force-event)
		(let ((pos (cursor-position)))
		  (IF (> (abs (- (car pos) 300)) 1)
		      (snd-display ";pos ~A: ~A?" 300 (car pos))))
		
		(expose-event cwid 20 20 200 200)
		(resize-event cwid 500 500)
		(take-keyboard-focus (car (channel-widgets)))
		(let ((pos (cursor)))
		  (key-event cwid (char->integer #\f) 4) (force-event)
		  (IF (>= pos (cursor))
		      (snd-display ";C-f: ~A ~A?" pos (cursor))))
		
		(key-event cwid (char->integer #\<) 5) (force-event)
		(IF (not (= (cursor) 0))
		    (snd-display ";C-<: ~A?" (cursor)))
		(key-event cwid (char->integer #\>) 9) (force-event)
		(IF (not (= (cursor) (- (frames) 1)))
		    (snd-display ";C->: ~A (~A)?" (cursor) (frames)))
		
		(key-event cwid (char->integer #\x) 4) (force-event)
		(key-event cwid (char->integer #\<) 1) (force-event)
		(IF (not (= (cursor) 0))
		    (snd-display ";Cx-<: ~A?" (cursor)))
		(key-event cwid (char->integer #\x) 4) (force-event)
		(key-event cwid (char->integer #\>) 1) (force-event)
		(IF (not (= (cursor) (- (frames) 1)))
		    (snd-display ";Cx->: ~A (~A)?" (cursor) (frames)))
		(set! (cursor) 0)
		(key (char->integer #\u) 4 ind)
		(key (char->integer #\1) 0 ind)
		(key (char->integer #\.) 0 ind)
		(key (char->integer #\0) 0 ind)
		(key (char->integer #\f) 4 ind)
		(IF (not (= (cursor) 22050))
		    (snd-display ";C-u 1.0 C-f -> ~A" (cursor)))

		(key-event cwid (char->integer #\x) 4) (force-event)
		(key-event cwid (char->integer #\=) 4) (force-event)

		(drag-event cwid 1 0 100 50 400 50) (force-event)
		(IF (not (selection?))
		    (snd-display ";drag but no selection?")
		    (let* ((pos (selection-position))
			   (end (+ pos (selection-length)))
			   (x0 (x->position (/ pos (srate))))
			   (x1 (x->position (/ end (srate)))))
		      (IF (or (> (abs (- x0 100)) 1)
			      (> (abs (- x1 400)) 1))
			  (snd-display ";selectpos: ~A ~A ~A ~A " pos end x0 x1))
		  
		      (key-event cwid (char->integer #\x) 4) (force-event)
		      (key-event cwid (char->integer #\v) 0) (force-event)
		      (IF (or (> (abs (- pos (left-sample))) 2)
			      (> (abs (- end (right-sample))) 2))
			  (snd-display ";C-x v selectpos: ~A ~A ~A ~A " pos end (left-sample) (right-sample)))
		      ))
		(set! (cursor) 6000)
		(let ((ls (left-sample))
		      (rs (right-sample))
		      (len (- (right-sample) (left-sample))))
		  (key-event cwid snd-right-key 0) (force-event)
		  (IF (> (abs (- (left-sample) rs)) 1)
		      (snd-display ";-> not by window? ~A ~A" rs (left-sample)))
		  (IF (> (abs (- len (- (right-sample) (left-sample)))) 1)
		      (snd-display ";-> size diff? ~A ~A" len (- (right-sample) (left-sample))))
		  (key-event cwid snd-left-key 0) (force-event)
		  (IF (> (abs (- (left-sample) ls)) 1)
		      (snd-display ";<- not by window? ~A ~A" ls (left-sample)))
		  (IF (> (abs (- len (- (right-sample) (left-sample)))) 1)
		      (snd-display ";<- size diff? ~A ~A" len (- (right-sample) (left-sample))))

		  (for-each 
		   (lambda (n val)
		     (key-event cwid (char->integer #\x) 4) (force-event) (key-event cwid snd-right-key n) (force-event)
		     (IF (> (abs (- (left-sample) (* val len) ls)) 1)
			 (snd-display ";~A cx-> not by window? ~A ~A" n rs (left-sample)))
		     (IF (> (abs (- len (- (right-sample) (left-sample)))) 1)
			 (snd-display ";~A cx-> size diff? ~A ~A" n len (- (right-sample) (left-sample))))
		     (key-event cwid (char->integer #\x) 4) (force-event) (key-event cwid snd-left-key n) (force-event)
		     (IF (> (abs (- (left-sample) ls)) 1)
			 (snd-display ";~A cx<- not by window? ~A ~A" n ls (left-sample)))
		     (IF (> (abs (- len (- (right-sample) (left-sample)))) 1)
			 (snd-display ";~A cx<- size diff? ~A ~A" n len (- (right-sample) (left-sample)))))
		   (list 0 4)
		   (list 1.0 0.5))

		  (for-each (lambda (msk val)
			      (key-event cwid snd-right-key msk) (force-event)
			      (IF (> (abs (- (left-sample) (* val len) ls)) 1)
				  (snd-display ";~A-> not by window? ~A ~A" msk rs (left-sample)))
			      (IF (> (abs (- len (- (right-sample) (left-sample)))) 1)
				  (snd-display ";~A-> size diff? ~A ~A" msk len (- (right-sample) (left-sample))))
			      (key-event cwid snd-left-key msk) (force-event)
			      (IF (> (abs (- (left-sample) ls)) 1)
				  (snd-display ";~A<- not by window? ~A ~A" msk ls (left-sample)))
			      (IF (> (abs (- len (- (right-sample) (left-sample)))) 1)
				  (snd-display ";~A<- size diff? ~A ~A" msk len (- (right-sample) (left-sample)))))
			    (list 1 4 8 5 9 13)
			    (list 0.5 0.5 0.5 0.25 0.25 0.125))

		  (key-event cwid snd-up-key 0) (force-event)
		  (IF (> (abs (- (* 2 len) (- (right-sample) (left-sample)))) 3)
		      (snd-display ";up size diff? ~A ~A" ( * 2 len) (- (right-sample) (left-sample))))
		  (key-event cwid snd-down-key 0) (force-event)
		  (IF (> (abs (- len (- (right-sample) (left-sample)))) 3)
		      (snd-display ";down size diff? ~A ~A" len (- (right-sample) (left-sample))))
		  (key-event cwid snd-up-key 4) (force-event)
		  (IF (> (abs (- (* 1.5 len) (- (right-sample) (left-sample)))) 2)
		      (snd-display ";C-up size diff? ~A ~A" ( * 1.5 len) (- (right-sample) (left-sample))))
		  (key-event cwid snd-down-key 4) (force-event)
		  (IF (> (abs (- len (- (right-sample) (left-sample)))) 2)
		      (snd-display ";C-down size diff? ~A ~A" len (- (right-sample) (left-sample))))

		  (for-each
		   (lambda (n val)
		     (key-event cwid (char->integer #\x) 4) (force-event)
		     (key-event cwid snd-up-key n) (force-event)
		     (IF (> (abs (- (* val len) (- (right-sample) (left-sample)))) 2)
			 (snd-display ";~A Cx-up size diff? ~A ~A" n ( * val len) (- (right-sample) (left-sample))))
		     (key-event cwid (char->integer #\x) 4) (force-event)
		     (key-event cwid snd-down-key n) (force-event)
		     (IF (> (abs (- len (- (right-sample) (left-sample)))) 2)
			 (snd-display ";~A Cx-down size diff? ~A ~A" n len (- (right-sample) (left-sample)))))
		   (list 0 4)
		   (list 2.0 1.5))

		  (for-each (lambda (msk val)
			      (key-event cwid snd-up-key msk) (force-event)
			      (IF (> (abs (- (* val len) (- (right-sample) (left-sample)))) 3)
				  (snd-display ";~A up size diff? ~A ~A" msk ( * val len) (- (right-sample) (left-sample))))
			      (key-event cwid snd-down-key msk) (force-event)
			      (IF (> (abs (- len (- (right-sample) (left-sample)))) 3)
				  (snd-display ";~A down size diff? ~A ~A" msk len (- (right-sample) (left-sample)))))
			    (list 1 4 8 5 9 13)
			    (list 1.5 1.5 1.5 1.25 1.25 1.125))
		  
		  (let ((y (spectro-y-angle))
			(x (spectro-x-angle)))
		    (key-event cwid snd-kp-left-key 4) (force-event)
		    (IF (fneq (spectro-y-angle) (- y 1.0))
			(snd-display ";C-keypad-left: ~A ~A" y (spectro-y-angle)))
		    (key-event cwid snd-kp-right-key 4) (force-event)
		    (IF (fneq (spectro-y-angle) y)
			(snd-display ";C-keypad-right: ~A ~A" y (spectro-y-angle)))
		    (key-event cwid snd-kp-down-key 4) (force-event)
		    (IF (fneq (spectro-x-angle) (- x 1.0))
			(snd-display ";C-keypad-down: ~A ~A" x (spectro-x-angle)))
		    (key-event cwid snd-kp-up-key 4) (force-event)
		    (IF (fneq (spectro-x-angle) x)
			(snd-display ";C-keypad-up: ~A ~A" x (spectro-x-angle))))

		  (let ((hop (spectro-hop)))
		    (key-event cwid snd-kp-add-key 0) (force-event)
		    (IF (not (= (spectro-hop) (1+ hop)))
			(snd-display ";keypad-add ~A -> ~A" hop (spectro-hop)))
		    (key-event cwid snd-kp-subtract-key 0) (force-event)
		    (IF (not (= (spectro-hop) hop))
			(snd-display ";keypad-subtract ~A -> ~A" hop (spectro-hop))))

		  (set! (spectro-cutoff) 0.5)
		  (key-event cwid snd-kp-9-key 0) (force-event)
		  (IF (> (abs (- (spectro-cutoff) (/ 0.5 0.95))) .05)
		      (snd-display ";keypad-9 ~A -> ~A" 0.5 (spectro-cutoff)))
		  (key-event cwid snd-kp-3-key 0) (force-event)
		  (IF (fneq (spectro-cutoff) 0.5)
		      (snd-display ";keypad-3 ~A -> ~A" 0.5 (spectro-cutoff)))

		  (let ((za (spectro-z-angle))
			(zs (spectro-z-scale)))
		    (key-event cwid snd-kp-left-key 0) (force-event)
		    (IF (fneq (spectro-z-angle) (- za 1.0))
			(snd-display ";keypad-left: ~A ~A" za (spectro-z-angle)))
		    (key-event cwid snd-kp-right-key 0) (force-event)
		    (IF (fneq (spectro-z-angle) za)
			(snd-display ";keypad-right: ~A ~A" za (spectro-z-angle)))
		    (key-event cwid snd-kp-down-key 0) (force-event)
		    (IF (fneq (spectro-z-scale) (- zs .01))
			(snd-display ";keypad-down: ~A ~A" zs (spectro-z-scale)))
		    (key-event cwid snd-kp-up-key 0) (force-event)
		    (IF (fneq (spectro-z-scale) zs)
			(snd-display ";keypad-up: ~A ~A" zs (spectro-z-scale))))

		  (bind-key (char->integer #\p) 0 (lambda () cursor-on-left))
		  (bind-key (char->integer #\q) 0 (lambda () cursor-in-middle))
		  (bind-key (char->integer #\r) 0 (lambda () cursor-on-right))
		  (key-event cwid (char->integer #\p) 0) (force-event)
		  (IF (> (abs (- (cursor) (left-sample))) 1)
		      (snd-display ";cursor-on-left: ~A ~A" (cursor) (left-sample)))
		  (key-event cwid (char->integer #\r) 0) (force-event)
		  (IF (> (abs (- (cursor) (right-sample))) 1)
		      (snd-display ";cursor-on-right: ~A ~A" (cursor) (right-sample)))
		  (key-event cwid (char->integer #\q) 0) (force-event)
		  (IF (> (abs (- (cursor) (inexact->exact (* .5 (+ (left-sample) (right-sample)))))) 1)
		      (snd-display ";cursor-in middle: ~A ~A" (cursor) (inexact->exact (* .5 (+ (left-sample) (right-sample))))))
		  (key-event cwid (char->integer #\p) 0) (force-event)
		  (IF (> (abs (- (cursor) (left-sample))) 1)
		      (snd-display ";cursor-on-left (1): ~A ~A" (cursor) (left-sample)))
		  (key-event cwid (char->integer #\x) 4) (force-event) 
		  (key-event cwid (char->integer #\t) 4) (force-event)

		  (set! (graph-style) graph-dots)
		  (let ((ds (dot-size)))
		    (key-event cwid snd-kp-decimal-key 1) (force-event)
		    (IF (not (= (dot-size) (1+ ds)))
			(snd-display ";decimal dot-size: ~A -> ~A?" ds (dot-size)))
		    (key-event cwid snd-kp-0-key 1) (force-event)
		    (IF (not (= (dot-size) ds))
			(snd-display ";0 dot-size: ~A -> ~A?" ds (dot-size))))
		  (set! (graph-style) graph-lines)
		  (key-event cwid snd-kp-enter-key 0) (force-event)

		  (set! (graph-transform?) #t)
		  (let ((ds (transform-size)))
		    (key-event cwid snd-kp-multiply-key 0) (force-event)
		    (IF (not (= (transform-size) (* 2 ds)))
			(snd-display ";multiply transform-size: ~A -> ~A?" ds (transform-size)))
		    (key-event cwid snd-kp-divide-key 0) (force-event)
		    (IF (not (= (transform-size) ds))
			(snd-display ";divide transform-size: ~A -> ~A?" ds (transform-size))))
		  (set! (graph-transform?) #f)

		  (take-keyboard-focus (car (channel-widgets)))
		  (key-event cwid (char->integer #\a) 4) (force-event)
		  (IF (not (= (cursor) (left-sample)))
		      (snd-display ";C-a: ~A ~A?" (cursor) (left-sample)))
		  (key-event cwid (char->integer #\e) 4) (force-event)
		  (IF (not (= (cursor) (right-sample)))
		      (snd-display ";C-e: ~A ~A?" (cursor) (right-sample)))
		  (key-event cwid (char->integer #\b) 4) (force-event)
		  (IF (not (= (cursor) (1- (right-sample))))
		      (snd-display ";C-b: ~A ~A?" (cursor) (1- (right-sample))))
		  (key-event cwid (char->integer #\f) 4) (force-event)
		  (IF (not (= (cursor) (right-sample)))
		      (snd-display ";C-f: ~A ~A?" (cursor) (right-sample)))
		  (IF (not (selection?))
		      (snd-display "what happened to our selection?"))
		  (key-event cwid snd-space-key 0) (force-event)
		  (IF (selection?)
		      (snd-display "C-space did not cancel selection?"))
		  (set! (cursor) 100)
		  (key-event cwid (char->integer #\d) 4) (force-event)
		  (IF (not (equal? (edits) '(1 0)))
		      (snd-display ";C-d (edits) -> ~A?" (edits)))
		  (IF (not (equal? (edit-fragment 1) (list "C-d" "delete" 100 1)))
		      (snd-display ";C-d (edit) -> ~A?" (edit-fragment 1)))
		  (key-event cwid (char->integer #\u) 4) (force-event)
		  (key-event cwid (char->integer #\0) 4) (force-event)
		  (key-event cwid (char->integer #\d) 4) (force-event)
		  (IF (not (equal? (edits) '(1 0)))
		      (snd-display ";0 C-d (edits) -> ~A?" (edits)))
		  (key-event cwid (char->integer #\h) 4) (force-event)
		  (IF (not (equal? (edits) '(2 0)))
		      (snd-display ";C-h (edits) -> ~A?" (edits)))
		  (IF (not (equal? (edit-fragment 2) (list "C-h" "delete" 99 1)))
		      (snd-display ";C-h (edit) -> ~A?" (edit-fragment 2)))
		  (set! (cursor) 5000)
		  (let ((fr (frames)))
		    (key-event cwid (char->integer #\o) 4) (force-event)
		    (IF (not (equal? (edits) '(3 0)))
			(snd-display ";C-o (edits) -> ~A?" (edits)))
		    (IF (not (equal? (edit-fragment 3) (list "C-o" "insert" 5000 1)))
			(snd-display ";C-o (edit) -> ~A?" (edit-fragment 3)))
		    (IF (fneq (sample (cursor)) 0.0)
			(snd-display ";C-o sample: ~A?" (sample (cursor))))
		    (IF (not (= (frames) (1+ fr)))
			(snd-display ";frames after C-o: ~A ~A?" (frames) fr))
		    (key-event cwid (char->integer #\v) 4) (force-event)
		    (IF (> (abs (- (cursor) (inexact->exact (* .5 (+ (left-sample) (right-sample)))))) 1)
			(snd-display ";C-v loc: ~A ~A?" (cursor) (inexact->exact (* .5 (+ (left-sample) (right-sample))))))
		    (IF (= (sample (cursor)) 0.0)
			(set! (cursor) (1+ (cursor))))
		    (key-event cwid (char->integer #\z) 4) (force-event)
		    (IF (not (equal? (edits) '(4 0)))
			(snd-display ";C-z (edits) -> ~A?" (edits)))
		    (IF (not (string=? (car (edit-fragment 4)) "scale-channel 0.0000 5001 1"))
			(snd-display ";C-z (edit) -> ~A?" (edit-fragment 4)))
		    (IF (fneq (sample (cursor)) 0.0)
			(snd-display ";C-z sample: ~A?" (sample (cursor))))
		    (IF (not (= (frames) (1+ fr)))
			(snd-display ";frames after C-z: ~A ~A?" (frames) fr)))
		  (IF (> (length (marks ind 0)) 0)
		      (snd-display "there are marks here already!"))
		  (key-event cwid (char->integer #\m) 4) (force-event)
		  (IF (null? (marks ind 0))
		      (snd-display "C-m but no mark!")
		      (let ((m (car (marks ind 0))))
			(IF (not (= (mark-sample m) (cursor)))
			    (snd-display ";C-m mark sample: ~A ~A?" (mark-sample m) (cursor)))))
		  (key-event cwid (char->integer #\-) 4) (force-event)
		  (key-event cwid (char->integer #\m) 4) (force-event)
		  (IF (mark? (find-mark (cursor)))
		      (snd-display ";C-- C-m mark: ~A?" (find-mark (cursor))))
		  (key-event cwid (char->integer #\x) 4) (force-event)		  
		  (key-event cwid (char->integer #\o) 4) (force-event)
		  (IF (not (show-controls))
		      (snd-display "C-x C-o: ~A?" (show-controls)))
		  (key-event cwid (char->integer #\x) 4) (force-event)		  
		  (key-event cwid (char->integer #\c) 4) (force-event)
		  (IF (show-controls)
		      (snd-display "C-x C-c: ~A?" (show-controls)))
		  (key-event cwid (char->integer #\x) 4) (force-event)
		  (key-event cwid (char->integer #\u) 4) (force-event)
		  (IF (not (equal? (edits) '(3 1)))
		      (snd-display ";C-x C-u (edits) -> ~A?" (edits)))
		  (key-event cwid (char->integer #\x) 4) (force-event)
		  (key-event cwid (char->integer #\r) 4) (force-event)
		  (IF (not (equal? (edits) '(4 0)))
		      (snd-display ";C-x C-r (edits) -> ~A?" (edits)))
		  (key-event cwid (char->integer #\u) 4) (force-event)
		  (key-event cwid (char->integer #\1) 0) (force-event)
		  (key-event cwid (char->integer #\2) 0) (force-event)
		  (key-event cwid (char->integer #\3) 0) (force-event)
		  (key-event cwid (char->integer #\x) 4) (force-event)
		  (key-event cwid (char->integer #\b) 4) (force-event)
		  (IF (not (= (left-sample) 123))
		      (snd-display ";C-u 123 C-x: ~A?" (left-sample)))
		  (key-event cwid (char->integer #\u) 4) (force-event)
		  (key-event cwid (char->integer #\5) 0) (force-event)
		  (key-event cwid (char->integer #\0) 0) (force-event)
		  (key-event cwid (char->integer #\0) 0) (force-event)
		  (key-event cwid (char->integer #\0) 0) (force-event)
		  (key-event cwid (char->integer #\x) 4) (force-event)
		  (key-event cwid (char->integer #\b) 4) (force-event)
		  (IF (not (= (left-sample) 5000))
		      (snd-display ";C-u 5000 C-x: ~A?" (left-sample)))
		  (set! (cursor) 123)
		  (key-event cwid (char->integer #\x) 4) (force-event)
		  (key-event cwid (char->integer #\b) 0) (force-event)
		  (IF (not (= (left-sample) 123))
		      (snd-display ";C-x b(123): ~A?" (left-sample)))
		  (key-event cwid (char->integer #\u) 4) (force-event)
		  (key-event cwid (char->integer #\1) 0) (force-event)
		  (key-event cwid (char->integer #\0) 0) (force-event)
		  (key-event cwid (char->integer #\f) 4) (force-event)	
		  (IF (not (= (cursor) 133))
		      (snd-display ";C-u 10 C-f -> ~A?" (cursor)))
		  (key-event cwid (char->integer #\x) 4) (force-event)
		  (key-event cwid (char->integer #\/) 0) (force-event)
		  (widget-string minibuffer "away!")
		  (key-event minibuffer snd-return-key 0) (force-event)
		  (set! (cursor) 0)
		  (key-event cwid (char->integer #\x) 4) (force-event)
		  (key-event cwid (char->integer #\j) 0) (force-event)
		  (widget-string minibuffer "away!")
		  (key-event minibuffer snd-return-key 0) (force-event)
		  (IF (not (= (cursor) 133))
		      (snd-display ";named mark? ~A ~A" (cursor) (find-mark "away!")))
		  (let ((m (find-mark "away!")))
		    (IF (or (not (mark? m))
			    (not (= (mark-sample m) 133)))
			(snd-display ";are we away? ~A" (IF (mark? m) (mark-sample m) "lost"))))
		  (set! (cursor) 130)
		  (key-event cwid (char->integer #\j) 4) (force-event)
		  (IF (not (= (cursor) 133))
		      (snd-display ";goto mark? ~A" (cursor)))
		  (IF (key-binding (char->integer #\n) 4)
		      (unbind-key (char->integer #\n) 4))
		  (key-event cwid (char->integer #\n) 4) (force-event)
		  (IF (not (= (cursor) (+ 128 133)))
		      (snd-display ";ahead line? ~A" (cursor)))
		  (IF (key-binding (char->integer #\p) 4)
		      (unbind-key (char->integer #\p) 4))
		  (key-event cwid (char->integer #\p) 4) (force-event)
		  (IF (not (= (cursor) 133))
		      (snd-display ";back line? ~A" (cursor)))
		  (let ((fr (frames)))
		    (IF (key-binding (char->integer #\k) 4)
			(unbind-key (char->integer #\k) 4))
		    (key-event cwid (char->integer #\k) 4) (force-event)
		    (IF (not (equal? (edits) '(5 0)))
			(snd-display ";C-k (edits) -> ~A?" (edits)))
		    (IF (not (equal? (edit-fragment 5) (list "C-k" "delete" 133 128)))
			(snd-display ";C-k (edit) -> ~A?" (edit-fragment 5)))
		    (IF (not (= (frames) (- fr 128)))
			(snd-display ";frames after C-k: ~A ~A?" (frames) fr)))
		  (key-event cwid (char->integer #\s) 4) (force-event)
		  (widget-string minibuffer "(lambda (n) (< n -.1))")
		  (key-event minibuffer snd-return-key 0) (force-event)
		  (let ((cs (cursor)))
		    (IF (not (< (sample cs) -.1))
			(snd-display ";C-s -.1 -> ~A at ~A?" (sample cs) cs))
		    (key-event cwid (char->integer #\s) 4) (force-event)
		    (key-event cwid (char->integer #\s) 4) (force-event)
		    (IF (not (< (sample (cursor)) -.1))
			(snd-display ";C-s -.1 (1) -> ~A at ~A?" (sample (cursor)) (cursor)))
		    (IF (= cs (cursor))
			(snd-display ";C-s 2 -> ~A at ~A?" cs (cursor)))
		    (key-event cwid (char->integer #\b) 4) (force-event)
		    (key-event cwid (char->integer #\r) 4) (force-event)
		    (widget-string minibuffer "(lambda (n) (>= n .05))")
		    (key-event minibuffer snd-return-key 0) (force-event)
		    (set! cs (cursor))
		    (IF (not (>= (sample cs) .05))
			(snd-display ";C-r >= .05 -> ~A at ~A?" (sample cs) cs))
		    (key-event cwid (char->integer #\r) 4) (force-event)
		    (key-event cwid (char->integer #\r) 4) (force-event)
		    (IF (not (>= (sample (cursor)) .05))
			(snd-display ";C-r >= .05 (1) -> ~A at ~A?" (sample (cursor)) (cursor)))
		    (IF (= cs (cursor))
			(snd-display ";C-r 2 -> ~A at ~A?" cs (cursor)))
		    (key-event cwid (char->integer #\>) 9) (force-event)
		    (key-event cwid (char->integer #\r) 4) (force-event)
		    (key-event cwid (char->integer #\r) 4) (force-event)
		    (set! cs (cursor))
		    (IF (not (>= (sample cs) .05))
			(snd-display ";C-r back >= .05 -> ~A at ~A?" (sample cs) cs))
		    (key-event cwid (char->integer #\>) 9) (force-event)
		    (key-event cwid (char->integer #\b) 4) (force-event)
		    (key-event cwid (char->integer #\r) 4) (force-event)
		    (key-event cwid (char->integer #\r) 4) (force-event)
		    (set! cs (cursor))
		    (IF (not (>= (sample cs) .05))
			(snd-display ";C-r back 2 >= .05 -> ~A at ~A?" (sample cs) cs)))
		  (key-event cwid (char->integer #\q) 4) (force-event)
		  (key-event cwid (char->integer #\i) 4) (force-event) ; just for completeness
		  (key-event cwid (char->integer #\u) 4) (force-event)
		  (key-event cwid (char->integer #\5) 0) (force-event)
		  (key-event cwid (char->integer #\x) 4) (force-event)
		  (key-event cwid (char->integer #\u) 4) (force-event)
		  (IF (not (equal? (edits) '(0 5)))
		      (snd-display ";C-x C-u -> ~A?" (edits)))
		  (key-event cwid (char->integer #\<) 5) (force-event)
		  (IF (not (= (cursor) 0))
		      (snd-display ";C-< (1): ~A?" (cursor)))
		  (let ((s1000 (sample 1000))
			(fr (frames)))
		    (make-region 0 999)
		    (make-selection 0 999)
		    (key-event cwid (char->integer #\w) 4) (force-event)
		    (IF (fneq (sample 0) s1000)
			(snd-display ";C-w: ~A ~A (~A ~A)" s1000 (sample 0) fr (frames)))
		    (IF (not (= fr (+ (frames) 1000)))
			(snd-display ";C-w len: ~A ~A" fr (frames)))
		    (IF (not (equal? (edits) '(1 0)))
			(snd-display ";C-w -> ~A?" (edits)))
		    (IF (not (equal? (edit-fragment 1) (list "C-w" "delete" 0 1000)))
			(snd-display ";C-w (edit) -> ~A [~A]?" 
					     (edit-fragment 1)
					     (car (edit-fragment 1))))
		    (key-event cwid (char->integer #\<) 5) (force-event)
		    (key-event cwid (char->integer #\y) 4) (force-event)
		    (IF (fneq (sample 1000) s1000)
			(snd-display ";C-y: ~A ~A (~A ~A)" s1000 (sample 1000) fr (frames)))
		    (IF (not (= fr (frames)))
			(snd-display ";C-y len: ~A ~A" fr (frames)))
		    (IF (not (equal? (edits) '(2 0)))
			(snd-display ";C-y -> ~A?" (edits)))
		    (IF (not (equal? (edit-fragment 2) (list "C-y" "insert" 0 1000)))
			(snd-display ";C-y (edit) -> ~A?" (edit-fragment 2))))
		  (key-event cwid (char->integer #\<) 5) (force-event)
		  (key-event cwid (char->integer #\x) 8) (force-event)
		  (widget-string minibuffer "(do ((i 0 (1+ i))) ((= i 10)) (set! (sample i) 1.0))")
		  (key-event minibuffer snd-return-key 0) (force-event)
		  (IF (not (equal? (edits) '(3 0)))
		      (snd-display ";M-x edits 10 -> 1.0: ~A?" (edits)))
		  (IF (not (equal? (edit-fragment 3) (list "set-sample" "set" 9 1)))
		      (snd-display ":M-x fragment (wierd!): ~A" (edit-fragment 3)))
		  (key-event cwid snd-space-key 4) (force-event)
		  (do ((i 0 (1+ i)))
		      ((= i 9))
		    (key-event cwid (char->integer #\f) 4) (force-event))
		  (IF (not (selection?))
		      (snd-display ";C-space for selection failed?"))
		  (IF (not (= (selection-length) 10))
		      (snd-display ";C-space for selection len: ~A?" (selection-length)))

		  (key-event cwid (char->integer #\x) 8) (force-event)
		  (widget-string minibuffer "(set! mxa 3)")
		  (key-event minibuffer snd-return-key 0) (force-event)
		  (IF (not (= mxa 3))
		      (snd-display ";M-x (set! mxa 3) -> ~A" mxa))

		  (let ((lst (list-ref (main-widgets) 4))
			(snd-return-key #xFF0D))
		    (take-keyboard-focus lst)
		    (key-event lst snd-return-key 0) (force-event) ; possible pre-existing error msg etc
		    (key-event lst snd-return-key 0) (force-event)
		    (widget-string lst "(set! mxa (+ 1 4))" #f)
		    (key-event lst snd-return-key 0) (force-event)
		    (IF (not (= mxa 5))
			(snd-display ";set! mxa in listener: ~A" mxa)))

		  (take-keyboard-focus cwid)
		  (key-event cwid (char->integer #\x) 4) (force-event)
		  (key-event cwid (char->integer #\a) 0) (force-event)
		  (widget-string minibuffer "'(0 0 1 1)")
		  (key-event minibuffer snd-return-key 0) (force-event)
		  (do ((i 0 (1+ i)))
		      ((= i 10))
		    (IF (fneq (sample i) (* i .1))
			(snd-display ";C-x a [~A]: ~A" i (sample i))))
		  (IF (not (equal? (edit-fragment) (list "C-x a" "set" 0 10)))
		      (snd-display ";C-x a edit: ~A?" (edit-fragment)))
		  (key-event cwid (char->integer #\x) 4) (force-event)
		  (key-event cwid (char->integer #\() 1) (force-event)
		  (key-event cwid (char->integer #\f) 4) (force-event)
		  (key-event cwid (char->integer #\f) 4) (force-event)
		  (key-event cwid (char->integer #\f) 4) (force-event)
		  (key-event cwid (char->integer #\x) 4) (force-event)
		  (key-event cwid (char->integer #\)) 1) (force-event)
		  (set! (cursor) 1000)
		  (key-event cwid (char->integer #\x) 4) (force-event)
		  (key-event cwid (char->integer #\e) 0) (force-event)
		  (IF (not (= (cursor) 1003))
		      (snd-display ";kbd macro: ~A?" (cursor)))
		  (key-event cwid (char->integer #\x) 4) (force-event)
		  (key-event cwid (char->integer #\e) 4) (force-event)
		  (widget-string minibuffer "macro")
		  (key-event minibuffer snd-return-key 0) (force-event)
		  
		  (key-event cwid (char->integer #\u) 4) (force-event)
		  (key-event cwid (char->integer #\8) 0) (force-event)
		  (key-event cwid (char->integer #\x) 4) (force-event)
		  (key-event cwid (char->integer #\e) 0) (force-event)
		  (IF (not (= (cursor) (+ 1003 (* 8 3))))
		      (snd-display ";kbd macro (8): ~A?" (cursor)))
		  (key-event cwid (char->integer #\t) 4) (force-event)

		  (set! (cursor) 4000)
		  (key-event cwid (char->integer #\x) 4) (force-event)
		  (key-event cwid (char->integer #\f) 0) (force-event)
		  (IF (> (abs (- (cursor) (right-sample))) 1)
		      (snd-display ";C-x f -> ~A ~A" (cursor) (right-sample)))

		  (if (file-exists? "hiho.eps") (delete-file "hiho.eps"))
		  (key-event cwid (char->integer #\x) 4) (force-event)
		  (key-event cwid (char->integer #\g) 4) (force-event)
		  (key-event cwid (char->integer #\x) 4) (force-event)
		  (key-event cwid (char->integer #\d) 4) (force-event)
		  (widget-string minibuffer "hiho.eps")
		  (key-event minibuffer snd-return-key 0) (force-event)
		  (IF (not (file-exists? "hiho.eps"))
		      (snd-display ";C-x C-d no output?")
		      (delete-file "hiho.eps"))
		  (with-output-to-file "hiho.scm" (lambda () (display "(define a-test 32)")))
		  (key-event cwid (char->integer #\x) 4) (force-event)
		  (key-event cwid (char->integer #\l) 4) (force-event)
		  (widget-string minibuffer "hiho.scm")
		  (key-event minibuffer snd-return-key 0) (force-event)
		  (IF (or (not (defined? 'a-test))
			  (not (= a-test 32)))
		      (snd-display ";C-x C-l failed?")
		      (delete-file "hiho.scm"))
		  (key-event cwid (char->integer #\u) 4) (force-event)
		  (key-event cwid (char->integer #\1) 0) (force-event)
		  (key-event cwid (char->integer #\.) 0) (force-event)
		  (key-event cwid (char->integer #\0) 0) (force-event)
		  (key-event cwid (char->integer #\x) 4) (force-event)
		  (key-event cwid (char->integer #\p) 4) (force-event)
		  (IF (fneq (/ (- (right-sample) (left-sample)) (srate)) 1.0)
		      (snd-display ";C-x C-p 1.0: ~A?" (/ (- (right-sample) (left-sample) (srate)))))
		  (key-event cwid (char->integer #\<) 5) (force-event)
		  (key-event cwid (char->integer #\u) 4) (force-event)
		  (key-event cwid (char->integer #\1) 0) (force-event)
		  (key-event cwid (char->integer #\.) 0) (force-event)
		  (key-event cwid (char->integer #\0) 0) (force-event)
		  (key-event cwid (char->integer #\f) 4) (force-event)
		  (IF (fneq (/ (cursor) (srate)) 1.0)
		      (snd-display ";C-u 1.0 C-f: ~A?" (/ (cursor) (srate))))

		  (let ((edhist (list-ref (channel-widgets) 7)))
		    (select-item edhist 1) (force-event)
		    (IF (not (= (edit-position) 1))
			(snd-display ";click edit history: ~A ~A" (edit-position) (edits))))
		    
		  (drag-event cwid 1 0 100 50 400 50) (force-event)
		  (IF (not (selection?))
		      (snd-display ";drag(1) but no selection?")
		      (let* ((pos (selection-position))
			     (samp (sample (1+ pos))))
			(key-event cwid (char->integer #\x) 4) (force-event)
			(key-event cwid (char->integer #\x) 0) (force-event)
			(widget-string minibuffer "(lambda (n) (* n 5))")
			(key-event minibuffer snd-return-key 0) (force-event)
			(IF (fneq (sample (1+ pos)) (* 5 samp))
			    (snd-display ";eval-over-selection: ~A ~A (~A)" samp (sample (1+ pos)) (edit-fragment)))))
		  (key-event cwid (char->integer #\x) 4) (force-event)
		  (key-event cwid (char->integer #\z) 0) (force-event)
		  (let* ((md (mix "oboe.snd" 100))
			 (eds (edit-position))
			 (xy (mix-tag-position md))
			 (x (+ (car xy) 1))
			 (y (- (cadr xy) 2)))
		    (drag-event cwid 1 0 x y (+ x 150) y) (force-event)
		    (IF (> (abs (- (car (mix-tag-position md)) (+ x 150))) 5)
			(snd-display ";move mix: ~A ~A" (car xy) (car (mix-tag-position md))))
		    (IF (not (= (edit-position) (1+ eds)))
			(snd-display ";move mix edits: ~A ~A" eds (edit-position)))
		    (set! xy (mix-tag-position md))
		    (click-event cwid 1 0 (+ (car xy) 1) (- (cadr xy) 2)) (force-event))
		  (let* ((mrk (add-mark 100))
			 (x (x->position (/ (mark-sample mrk) (srate))))
			 (y 10))
		    (click-event cwid 1 0 x y) (force-event)
		    (drag-event cwid 1 0 x y (+ x 150) y) (force-event)
		    (IF (not (> (mark-sample mrk) 100))
			(snd-display ";move mark: 100 -> ~A, ~A -> ~A" (mark-sample mrk) x (x->position (/ (mark-sample mrk) (srate)))))
		    (let ((eds (edit-position))
			  (len (frames)))
		      (set! x (x->position (/ (mark-sample mrk) (srate))))
		      (drag-event cwid 1 4 x y (- x 200) y) (force-event)
		      (IF (not (= (edit-position) (1+ eds)))
			  (snd-display ";C-drag mark edits: ~A ~A" eds (edit-position)))
		      (IF (<= len (frames))
			  (snd-display ";C-drag mark len: ~A -> ~A" len (frames)))))
		  (revert-sound ind)
		  (key-event cwid (char->integer #\<) 5) (force-event)
		  (key-event cwid (char->integer #\u) 4) (force-event)
		  (key-event cwid (char->integer #\1) 0) (force-event)
		  (key-event cwid (char->integer #\.) 0) (force-event)
		  (key-event cwid (char->integer #\0) 0) (force-event)
		  (key-event cwid (char->integer #\f) 4) (force-event)
		  (IF (fneq (/ (cursor) (srate)) 1.0)
		      (snd-display ";C-u 1.0 C-f: ~A?" (/ (cursor) (srate))))
		  (let ((fr (frames)))
		    (key-event cwid (char->integer #\x) 4) (force-event)
		    (key-event cwid (char->integer #\i) 4) (force-event)
		    (widget-string minibuffer "oboe.snd")
		    (key-event minibuffer snd-return-key 0) (force-event)
		    (IF (not (= (frames) (* 2 fr)))
			(snd-display ";C-x C-i oboe: ~A ~A" (* 2 fr) (frames)))
		    (IF (fneq (sample 4000) (sample (+ (srate) 4000)))
			(snd-display ";inserted file: ~A ~A" (sample 4000) (sample (+ (srate) 4000))))
		    (IF (not (equal? (edit-fragment 1) (list "C-x C-i" "insert" (inexact->exact (srate)) fr)))
			(snd-display ";C-x C-i edit: ~A" (edit-fragment 1)))
		    (key-event cwid (char->integer #\x) 4) (force-event)
		    (key-event cwid (char->integer #\q) 4) (force-event)
		    (widget-string minibuffer "oboe.snd")
		    (key-event minibuffer snd-return-key 0) (force-event)
		    (IF (not (= (frames) (* 2 fr)))
			(snd-display ";C-x C-q oboe: ~A ~A" (* 2 fr) (frames)))
		    (IF (fneq (* 2 (sample 4000)) (sample (+ (srate) 4000)))
			(snd-display ";mixed file: ~A ~A" (* 2 (sample 4000)) (sample (+ (srate) 4000))))
		    (IF (not (equal? (edit-fragment 2) (list "C-x C-q" "set" (inexact->exact (srate)) fr)))
			(snd-display ";C-x C-q edit: ~A" (edit-fragment 2))))
		  (set! (cursor) 0)
		  (key-event cwid (char->integer #\x) 4) (force-event)
		  (key-event cwid (char->integer #\j) 4) (force-event)
		  (IF (not (= (cursor) (srate)))
		      (snd-display ";C-x C-j: ~A?" (cursor)))
		  (key-event cwid (char->integer #\x) 4) (force-event)
		  (key-event cwid (char->integer #\u) 4) (force-event)
		  (IF (not (equal? (edits) (list 1 1)))
		      (snd-display ";C-x C-u: ~A?" (edits)))
		  (key-event cwid (char->integer #\l) 4) (force-event)		  
		  (IF (fneq (/ (cursor) (srate)) (/ (* .5 (+ (left-sample) (right-sample))) (srate)))
		      (snd-display ";C-l: ~A ~A?" (/ (cursor) (srate)) (/ (* .5 (+ (left-sample) (right-sample))) (srate))))
		  )

		;; named macro
		(let ((fr (frames)))
		  (key-event cwid (char->integer #\x) 4) (force-event)
		  (key-event cwid (char->integer #\() 1) (force-event)
		  (key-event cwid (char->integer #\d) 4) (force-event)
		  (key-event cwid (char->integer #\d) 4) (force-event)
		  (key-event cwid (char->integer #\d) 4) (force-event)
		  (key-event cwid (char->integer #\x) 4) (force-event)
		  (key-event cwid (char->integer #\)) 1) (force-event)

		  (key-event cwid (char->integer #\x) 4) (force-event)
		  (key-event cwid (char->integer #\e) 4) (force-event)
		  (widget-string minibuffer "a-name")
		  (key-event minibuffer snd-return-key 0) (force-event)
		  (IF (not (= (frames) (- fr 3))) (snd-display ";macro definition wasn't effective?: ~A ~A" fr (frames)))

		  (key-event cwid (char->integer #\x) 8) (force-event)
		  (widget-string minibuffer "a-name")
		  (key-event minibuffer snd-return-key 0) (force-event)
		  (IF (not (= (frames) (- fr 6))) (snd-display ";macro call wasn't effective?: ~A ~A" fr (frames)))

		  (key-event cwid (char->integer #\u) 4) (force-event)
		  (key-event cwid (char->integer #\4) 0) (force-event)
		  (key-event cwid (char->integer #\x) 8) (force-event)
		  (widget-string minibuffer "a-name")
		  (key-event minibuffer snd-return-key 0) (force-event)
		  (IF (not (= (frames) (- fr 6 12))) (snd-display ";4 x macro call wasn't effective?: ~A ~A" fr (frames))))

		(revert-sound ind)

		(click-button name-button) (force-event)
		(key-event name-button (char->integer #\x) 4) (force-event)
		(key-event name-button (char->integer #\f) 4) (force-event)
		(widget-string minibuffer "pistol.snd")
		(key-event minibuffer snd-return-key 0) (force-event)
		(IF (not (= (length (sounds)) 2))
		    (snd-display ";C-x C-f -> ~A: ~A?" (sounds) (map short-file-name (sounds))))
		(backward-graph)
		(take-keyboard-focus name-button)
		(key-event name-button (char->integer #\x) 4) (force-event)
		(key-event name-button (char->integer #\k) 0) (force-event)
		(IF (not (= (length (sounds)) 1))
		    (snd-display ";C-x k -> ~A: ~A?" (sounds) (map short-file-name (sounds))))
		(IF (not (string=? (short-file-name (car (sounds))) "pistol.snd"))
		    (snd-display ";backgraph + kill: ~A?" (short-file-name (car (sounds)))))
		(set! swids (sound-widgets))
		(set! name-button (list-ref swids 1))
		(set! minibuffer (list-ref swids 3))
		(set! play-button (list-ref swids 4))
		(set! cwid (car (channel-widgets)))
		(let ((curmax (maxamp)))
		  (take-keyboard-focus name-button)
		  (key-event name-button (char->integer #\x) 4) (force-event)
		  (key-event name-button (char->integer #\a) 4) (force-event)
		  (widget-string minibuffer "'(0 .5 1 .5)")
		  (key-event minibuffer snd-return-key 0) (force-event)
		  (IF (not (equal? (edits) '(1 0)))
		      (snd-display ";C-x C-a (edits) -> ~A?" (edits)))
		  (IF (fneq (maxamp) (* .5 curmax))
		      (snd-display ";C-x C-a (amp) -> ~A ~A?" (maxamp) (* .5 curmax)))
		  (let ((grf (car (channel-widgets))))
		    (take-keyboard-focus grf)
		    (key-event grf (char->integer #\_) 5) (force-event)
		    (IF (not (equal? (edits) '(0 1)))
			(snd-display ";C-x _ (edits) -> ~A?" (edits)))
		    (IF (fneq (maxamp) curmax)
			(snd-display ";C-x _ (amp) -> ~A ~A?" (maxamp) curmax))))
		
		(let ((tmp (temp-dir)))
		  (key-event name-button (char->integer #\x) 4) (force-event)
		  (key-event name-button (char->integer #\d) 0) (force-event)
		  (widget-string minibuffer (string-append home-dir "/bil/test/snd-5"))
		  (key-event minibuffer snd-return-key 0) (force-event)
		  (IF (or (not (string? (temp-dir)))
			  (not (string=? (temp-dir) (string-append home-dir "/bil/test/snd-5"))))
		      (snd-display ";temp-dir via prompt: ~A?" (temp-dir)))
		  (set! (temp-dir) tmp)
		  (IF (not (equal? (temp-dir) tmp))
		      (snd-display ";temp-dir reset: ~A ~A?" (temp-dir) tmp)))
		
		(set! (cursor) 4000)
		(key-event name-button (char->integer #\x) 4) (force-event)
		(key-event name-button (char->integer #\m) 4) (force-event)
		(widget-string minibuffer "hiho!")
		(key-event minibuffer snd-return-key 0) (force-event)
		(let ((m (find-mark 4000)))
		  (IF (or (not (mark? m))
			  (not (string=? (mark-name m) "hiho!")))
		      (snd-display ";named mark prompt: ~A ~A" m (IF (mark? m) (mark-name m) "no name"))))

		(key-event cwid (char->integer #\g) 4) (force-event)		
		(close-sound (car (sounds)))
	      ))
	    
	    (let* ((ind (open-sound "2.snd"))
		   (c0 (frames ind 0))
		   (c1 (frames ind 1))
		   (mx0 (maxamp ind 0))		   
		   (mx1 (maxamp ind 1))
		   (swids (sound-widgets))
		   (cwids (channel-widgets ind 1))
		   (cwid (car cwids))
		   (cw (cadr cwids))
		   (cf (caddr cwids))
		   (minibuffer (list-ref swids 3)))
	      (select-sound ind)
	      (select-channel 1)
	      (click-button cf #t) (force-event)
	      (IF (not (graph-transform? ind 1)) (snd-display ";cf click but not fft"))
	      (click-button cw #f) (force-event)
	      (IF (graph-time? ind 1) (snd-display ";cw click but still time"))
	      (click-button cf #f 4) (force-event)
	      (click-button cw #t) (force-event)
	      (click-button (list-ref swids 6) #t)
	      (set! (channel-style ind) channels-combined)
	      (set! cwids (channel-widgets ind 0)) ; pick up gsy etc
	      ;; drag changed inc/dec for zy sy zx xy, drag changed for gz gsy
	      ;; 3:sx 4:sy 5:zx 6:zy 7:edhist)
	      (let ((sx (list-ref cwids 3))
		    (sy (list-ref cwids 4))
		    (zx (list-ref cwids 5))
		    (zy (list-ref cwids 6))
		    (gsy (list-ref cwids 8))
		    (gzy (list-ref cwids 9)))
		(IF (or (not (|Widget? gsy)) (not (|XtIsManaged gsy))) (snd-display ";unite but no gsy?"))
		(IF (or (not (|Widget? gzy)) (not (|XtIsManaged gzy))) (snd-display ";unite but no gzy?"))
		(for-each
		 (lambda (scrl)
		   (|XtCallCallbacks scrl |XmNvalueChangedCallback
		      (let ((cb (|XmScrollBarCallbackStruct)))
			(set! (|value cb) 75)
			(set! (|event cb) (|XEvent))
			cb))
		   (|XtCallCallbacks scrl |XmNincrementCallback
		      (let ((cb (|XmScrollBarCallbackStruct)))
			(set! (|event cb) (|XEvent))
			cb))
		   (|XtCallCallbacks scrl |XmNdecrementCallback
		     (let ((cb (|XmScrollBarCallbackStruct)))
		       (set! (|event cb) (|XEvent))
		       cb))
		   (|XtCallCallbacks scrl |XmNdragCallback
		      (let ((cb (|XmScrollBarCallbackStruct)))
			(set! (|value cb) 65)
			(set! (|event cb) (|XEvent))
			cb)))
		 (list sx zx zy))
		(if (and (|Widget? gsy) (|Widget? gzy))
		    (for-each
		     (lambda (scrl)
		       (|XtCallCallbacks scrl |XmNvalueChangedCallback
		          (let ((cb (|XmScrollBarCallbackStruct)))
			    (set! (|value cb) 75)
			    (set! (|event cb) (|XEvent))
			    cb))
		       (|XtCallCallbacks scrl |XmNdragCallback
		          (let ((cb (|XmScrollBarCallbackStruct)))
			    (set! (|value cb) 65)
			    (set! (|event cb) (|XEvent))
			    cb)))
		     (list gsy gzy))))
	      (click-button (list-ref swids 6) #f)
	      (click-button (list-ref swids 9) #t)
	      (IF (= (sync) 0) (snd-display "click sync?"))
	      (click-button (list-ref swids 9) #f)
	      (enter-event cwid) (force-event)
	      (leave-event cwid) (force-event)
	      (set! (show-controls ind) #t)
	      (let* ((ctrls (list-ref swids 2)))
		(for-each
		 (lambda (label)
		   (click-button label #t |ControlMask)
		   (click-button label #t 0))
		 (map 
		  (lambda (name)
		    (find-child ctrls name))
		  (list "amp-label" "srate-label" "contrast-label" "expand-label" "revlen-label" "revscl-label" )))
		(for-each
		 (lambda (scrl)
		   (|XtCallCallbacks scrl |XmNdragCallback
		     (let ((cb (|XmScrollBarCallbackStruct)))
		       (set! (|value cb) 50)
		       (set! (|event cb) (|XEvent))
		       cb)))
		 (map 
		  (lambda (name)
		    (find-child ctrls name))
		  (list "speed-scroll" "expand-scroll" "contrast-scroll" "revscl-scroll" "revlen-scroll")))
		(click-button (find-child ctrls "fltdB") #t)
		(let ((flttxt (find-child ctrls "filter-window")))
		  (widget-string flttxt "'(0 0 1 1 2 0)")
		  (key-event flttxt snd-return-key 0) (force-event))
		(let ((fltord (find-child ctrls "filter-order")))
		  (widget-string fltord "40")
		  (key-event fltord snd-return-key 0) (force-event))
		(click-button (find-child ctrls "Reset") #t)
		(click-button (list-ref swids 4) #t |ControlMask)
		(click-button (list-ref swids 4) #f 0)
		(equalize-panes)
		(click-button (find-child ctrls "Apply") #t)
		(undo))
	      (set! (show-controls ind) #f)
	      (select-sound ind)
	      (select-channel 1)
	      (key-event cwid (char->integer #\x) 4) (force-event)
	      (key-event cwid (char->integer #\i) 4) (force-event)
	      (widget-string minibuffer "oboe.snd")
	      (key-event minibuffer snd-return-key 0) (force-event)
	      (IF (not (= (frames ind 0) c0))
		  (snd-display ";C-x C-i wrote to wrong channel: ~A ~A" (frames ind 0) (frames ind 1)))
	      (IF (not (= (- (frames ind 1) c1) 50828))
		  (snd-display ";C-x C-i wrote wrong number of samples: ~A ~A" (frames ind 1) (- (frames ind 1) c1)))
	      (map-chan (lambda (n) .5) 0 (frames ind 1) "fives" ind 1)
	      (IF (or (> (maxamp ind 0) mx0)
		      (fneq (maxamp ind 1) .5))
		  (snd-display ";map fives: ~A ~A" (maxamp ind 0) (maxamp ind 1)))
	      (key-event cwid (char->integer #\x) 4) (force-event)
	      (key-event cwid (char->integer #\a) 4) (force-event)
	      (widget-string minibuffer "'(0 0 1 .5 2 0)")
	      (key-event minibuffer snd-return-key 0) (force-event)
	      (IF (or (> (maxamp ind 0) mx0)
		      (fneq (maxamp ind 1) .25))
		  (snd-display ";map fives env: ~A ~A" (maxamp ind 0) (maxamp ind 1)))
	      (revert-sound ind)
	      (select-channel 1)
	      (key-event cwid (char->integer #\x) 4) (force-event)
	      (key-event cwid (char->integer #\q) 4) (force-event)
	      (widget-string minibuffer "oboe.snd")
	      (key-event minibuffer snd-return-key 0) (force-event)
	      (IF (not (= (frames ind 0) c0))
		  (snd-display ";C-x C-q wrote to wrong channel: ~A ~A" (frames ind 0) (frames ind 1)))
	      (IF (not (= (frames ind 1) 50828))
		  (snd-display ";C-x C-q wrote wrong number of samples: ~A" (frames ind 1)))
	      (key-event cwid (char->integer #\x) 4) (force-event)
	      (key-event cwid (char->integer #\w) 4) (force-event)
	      (widget-string minibuffer "fmv.snd")
	      (key-event minibuffer snd-return-key 0) (force-event)
	      (IF (not (= (mus-sound-frames "fmv.snd") 50828))
		  (snd-display ";C-x C-w wrote wrong number of samples: ~A" (mus-sound-frames "fmv.snd")))
	      (delete-file "fmv.snd")
	      (select-all)
	      (key-event cwid (char->integer #\x) 4) (force-event)
	      (key-event cwid (char->integer #\w) 0) (force-event)
	      (widget-string minibuffer "fmv1.snd")
	      (key-event minibuffer snd-return-key 0) (force-event)
	      (IF (not (= (mus-sound-frames "fmv1.snd") 50828))
		  (snd-display ";C-x w wrote wrong number of samples: ~A" (mus-sound-frames "fmv1.snd")))
	      (delete-file "fmv1.snd")
	      (set! (selection-member? #t) #f)
	      (let* ((rid (car (regions)))
		     (ridstr (number->string rid)))
		(key-event cwid (char->integer #\u) 4) (force-event)
		(do ((i 0 (1+ i)))
		    ((= i (string-length ridstr)))
		  (key-event cwid (char->integer (string-ref ridstr i)) 0) (force-event))
		(key-event cwid (char->integer #\x) 4) (force-event)
		(key-event cwid (char->integer #\w) 0) (force-event)
		(widget-string minibuffer "fmv2.snd")
		(key-event minibuffer snd-return-key 0) (force-event)
		(IF (not (= (mus-sound-frames "fmv2.snd") 50828))
		    (snd-display ";C-u region C-x w wrote wrong number of samples: ~A" (mus-sound-frames "fmv2.snd")))
		(delete-file "fmv2.snd"))
	      (widget-string minibuffer "")
	      (close-sound ind))

	    ;; -------- filter envelope editor
	    (let* ((ind (open-sound "oboe.snd"))
		   (swids (sound-widgets))
		   (filter-grf (list-ref swids 5)))
	      (set! (show-controls ind) #t)
	      (let ((fe (filter-control-env ind)))
		(IF (not (equal? fe '(0.0 1.0 1.0 1.0)))
		    (snd-display ";filter-env (initial): ~A?" fe))
		(let ((psize (widget-size filter-grf)))
		  (IF (< (cadr psize) 100)
		      (begin
			(set! (window-height) 800)
			(resize-pane (list-ref swids 0) 600)
			(resize-pane (list-ref swids 2) 400))))
		(force-event)
		(click-event filter-grf 1 0 100 100) (force-event)
		(IF (not (= (length (filter-control-env ind)) 6))
		    (snd-display ";click filter-env: ~A?" (filter-control-env ind)))
		(click-event filter-grf 1 0 100 100) (force-event)
		(set! fe (filter-control-env ind))
		(IF (not (equal? fe '(0.0 1.0 1.0 1.0)))
		    (snd-display ";filter-env (point deleted): ~A?" fe))
		(close-sound ind)
		))

	    ;; -------- recorder dialog
	    (if (provided? 'snd-debug)
		(begin
		  (recorder-dialog)
		  (let* ((recd (list-ref (dialog-widgets) 18))
			 (record-button (find-child recd "record-button"))
			 (reset-button (|XmMessageBoxGetChild recd |XmDIALOG_CANCEL_BUTTON))
			 (dismiss-button (|XmMessageBoxGetChild recd |XmDIALOG_OK_BUTTON))
			 (panes (find-child recd "rec-panes"))
			 (file-pane (find-child panes "file-pane"))
			 (fdata (find-child file-pane "file-data"))
			 (ff (find-child fdata "ff-form"))
			 (file-text (find-child ff "text"))
			 (buttons '())
			 (sliders '())
			 (numbers '()))
		    (for-each-child recd (lambda (w) 
					   (if (and (|XmIsPushButton w) 
						    (string=? (|XtName w) "A")) 
					       (set! buttons (cons w buttons)))
					   (if (and (|XmIsPushButton w) 
						    (string=? (|XtName w) "amp-number")) 
					       (set! numbers (cons w numbers)))
					   (if (and (|XmIsScrollBar w) 
						    (or (string=? (|XtName w) "amp")
							(string=? (|XtName w) "trigger-scale")))
					       (set! sliders (cons w sliders)))))
		    (|XmTextSetString file-text "fmv.snd")
		    (for-each (lambda (w) (click-button w #t)) buttons)
		    (for-each (lambda (w) (click-button w #t)) numbers)
		    (for-each
		     (lambda (w)
		       (|XtCallCallbacks w |XmNdragCallback
					  (let ((cb (|XmScrollBarCallbackStruct)))
					    (set! (|value cb) 65)
					    (set! (|event cb) (|XEvent))
					    cb)))
		     sliders)
		    (click-button record-button #t)
		    (click-button record-button #f)
		    (click-button reset-button)
		    (click-button dismiss-button))))
	      

	    ;; -------- edit find dialog
	    (if (defined? 'edit-find-dialog)
		(begin
		  (edit-find-dialog)
		  (let* ((find-widgets (find-dialog-widgets))
			 (ind (open-sound "oboe.snd"))
			 (text-widget (cadr find-widgets))
			 (next-button (list-ref find-widgets 2))
			 (previous-button (list-ref find-widgets 3))
			 (cancel-button (list-ref find-widgets 4)))
		    
		    (widget-string text-widget "(lambda (n) (> n .1))")
		    (key-event text-widget snd-return-key 0) (force-event)
		    (IF (or (not (= (cursor) 4423))
			    (not (> (sample (cursor)) .1)))
			(snd-display ";edit find <cr>: ~A ~A" (cursor) (sample (cursor))))
		    (click-button next-button) (force-event)
		    (IF (or (not (= (cursor) 4463))
			    (not (> (sample (cursor)) .1)))
			(snd-display ";edit find (1): ~A ~A" (cursor) (sample (cursor))))
		    (click-button previous-button) (force-event)
		    (IF (or (not (= (cursor) 4423))
			    (not (> (sample (cursor)) .1)))
			(snd-display ";edit find (2): ~A ~A" (cursor) (sample (cursor))))
		    (do ((i 0 (1+ i)))
			((= i 10))
		      (click-button next-button) (force-event)
		      (IF (not (> (sample (cursor)) .1))
			  (snd-display ";edit find (~A): ~A ~A" (+ i 3) (cursor) (sample (cursor)))))
		    (IF (not (= (cursor) 4741))
			(snd-display ";edit find end: ~A?" (cursor)))
		    (click-button cancel-button) (force-event)
		    (close-sound ind))))

	    ;; -------- envelope editor
	    (if (defined? 'enved-dialog-widgets)
		(begin
		  (enved-dialog)
		  (force-event)
		  (let* ((enved-widgets (enved-dialog-widgets))
			 (drawer (cadr enved-widgets))
			 (apply-button (list-ref enved-widgets 4))
			 (undo-apply-button (list-ref enved-widgets 5))
			 (text-widget (list-ref enved-widgets 3))
			 (show-button (list-ref enved-widgets 7))
			 (save-button (list-ref enved-widgets 8))
			 (dismiss-button (list-ref enved-widgets 6))
			 (reset-button (list-ref enved-widgets 24))
			 (revert-button (list-ref enved-widgets 9))
			 (undo-button (list-ref enved-widgets 10))
			 (redo-button (list-ref enved-widgets 11))
			 (print-button (list-ref enved-widgets 12))
			 (graph-button (list-ref enved-widgets 13))
			 (flt-button (list-ref enved-widgets 14))
			 (amp-button (list-ref enved-widgets 15))
			 (src-button (list-ref enved-widgets 16))
			 (clip-button (list-ref enved-widgets 17))
			 (dB-button (list-ref enved-widgets 18))
			 (exp-button (list-ref enved-widgets 20))
			 (lin-button (list-ref enved-widgets 21))
			 (env-list (list-ref enved-widgets 25))
			 (ewid drawer))
		    
		    (click-button reset-button) (force-event)
		    (let* ((axis (enved-axis-info))
			   (axis-x0 (list-ref axis 0))
			   (axis-x1 (list-ref axis 2))
			   (axis-y0 (list-ref axis 1))
			   (axis-y1 (list-ref axis 3)))
		      (define (enved-x x) (inexact->exact (+ axis-x0 (* x (- axis-x1 axis-x0)))))
		      (define (enved-y y) (inexact->exact (- axis-y0 (* y (- axis-y0 axis-y1)))))
		      
		      (select-item env-list 1) (force-event)
		      (let ((e1 (enved-selected-env)))
			(IF (or (not e1)
				(null? e1))
			    (snd-display ";select env failed? ~A" e1))
			(select-item env-list 0)  (force-event)
			(IF (equal? e1 (enved-selected-env))
			    (snd-display ";select env 0 is same as 1? ~A" e1)))
		      
		      (click-event ewid 1 0 (enved-x 0.5) (enved-y 1.0)) (force-event)
		      (let ((active-env (enved-active-env)))
			(IF (not (ffeql active-env (list 0.0 0.0 0.5 1.0 1.0 0.0)))
			    (snd-display ";enved mid-click: ~A?" active-env)))
		      (widget-string text-widget "new-env")
		      (click-button save-button) (force-event)
		      (if (not (defined? 'new-env))
			  (snd-display ";save new-env failed?"))
		      (IF (not (ffeql new-env (list 0.0 0.0 0.5 1.0 1.0 0.0)))
			  (snd-display ";saved new-env: ~A?" new-env))
		      (click-event ewid 1 0 (enved-x 0.5) (enved-y 1.0)) (force-event)
		      (let ((active-env (enved-active-env)))
			(IF (not (ffeql active-env (list 0.0 0.0 1.0 0.0)))
			    (snd-display ";enved mid-click to delete: ~A?" active-env)))
		      (do ((i 0 (1+ i)))
			  ((= i 50))
			(click-event ewid 1 0 (enved-x (random 0.999)) (enved-y (random 1.0))) (force-event)
			(click-event ewid 1 0 (enved-x (random 0.999)) (enved-y (random 1.0))) (force-event)
			(let* ((e (enved-active-env))
			       (len (length e)))
			  (if (> len 4)
			      (let* ((pos (+ 2 (random (- len 4))))
				     (rx (list-ref e (IF (odd? pos) (- pos 1) pos)))
				     (ry (list-ref e (IF (odd? pos) pos (+ pos 1)))))
				(click-event ewid 1 0 (enved-x rx) (enved-y ry)) (force-event)
				(if (>= (length (enved-active-env)) (length e))
				    (snd-display "; enved loop missed a hit ~A ~A ~A ~A" (enved-axis-info) axis e (enved-active-env)))))))
		      (let ((len (length (enved-active-env))))
			(do ((i 0 (1+ i)))
			    ((= i 10))
			  (click-button undo-button) (force-event)
			  (click-button undo-button) (force-event)
			  (click-button redo-button) (force-event)))
		      (click-button revert-button) (force-event)
		      (click-button clip-button) (force-event)
		      (click-button clip-button) (force-event)
		      (let ((active-env (enved-active-env)))
			(IF (not (ffeql active-env (list 0.0 0.0 1.0 0.0)))
			    (snd-display ";enved revert: ~A?" active-env)))
		      (do ((i 0 (1+ i)))
			  ((= i 50))
			(click-event ewid 1 0 (enved-x (random 0.999)) (enved-y (random 1.0))) (force-event)
			(if (> (random 1.0) .5) 
			    (begin
			      (click-button undo-button) (force-event)
			      (if (> (random 1.0) 0.5)
				  (begin
				    (click-button redo-button) (force-event)))))
			(click-event ewid 1 0 (enved-x (random 0.999)) (enved-y (random 1.0))) (force-event)
			(if (> (random 1.0) .9) (begin (click-button save-button) (force-event)))
			(if (> (random 1.0) .9) (begin (click-button print-button) (force-event)))
			(if (> (random 1.0) .9) (begin (click-button dB-button) (force-event)))
			(if (> (random 1.0) .9) (begin (set! (enved-base) 0.0) (click-button exp-button) (force-event)))
			(if (> (random 1.0) .9) (begin (set! (enved-base) (random 2.0)) (click-button exp-button) (force-event)))
			(if (> (random 1.0) .9) (begin (click-button lin-button) (force-event)))
			(let* ((e (enved-active-env)))
			  (if (> (length e) 4)
			      (let* ((pos (+ 2 (random (- (length e) 4))))
				     (rx (list-ref e (if (odd? pos) (- pos 1) pos)))
				     (ry (list-ref e (if (odd? pos) pos (+ pos 1)))))
				(click-event ewid 1 0 (enved-x rx) (enved-y ry))
				(force-event)))))
		      
		      (click-button revert-button) (force-event)
		      (let ((active-env (enved-active-env)))
			(IF (not (ffeql active-env (list 0.0 0.0 1.0 0.0)))
			    (snd-display ";enved revert: ~A?" active-env)))
		      (click-event ewid 1 0 (enved-x (random 0.999)) (enved-y (random 1.0))) (force-event)
		      (drag-event drawer 1 0 10 10 100 100)
		      (click-button reset-button) (force-event)
		      
		      (let* ((ind (open-sound "oboe.snd"))
			     (fr (frames ind)))
			(click-button graph-button) (force-event)
			(widget-string text-widget "'(0 0 .5 1 1 0)") (force-event)
			(key-event text-widget snd-return-key 0) (force-event)
			
			(click-button flt-button) (force-event)
			(IF (not (= (enved-target) enved-spectrum))
			    (snd-display ";click flt button but target: ~A" (enved-target)))
			(click-button src-button) (force-event)
			(IF (not (= (enved-target) enved-srate))
			    (snd-display ";click src button but target: ~A" (enved-target)))
			(click-button amp-button) (force-event)
			(IF (not (= (enved-target) enved-amplitude))
			    (snd-display ";click flt button but target: ~A" (enved-target)))
			(click-button apply-button) (force-event)
			(IF (not (equal? (edits ind) '(1 0)))
			    (snd-display ";apply amp: ~A?" (edits ind)))
			(IF (not (equal? (edit-fragment 1) (list "Enved: amp" "set" 0 50828)))
			    (snd-display ";apply amp fragment: ~A?" (edit-fragment 1)))
			(click-event ewid 1 0 (enved-x 0.25) (enved-y 1.0)) (force-event)
			(click-button undo-apply-button) (force-event)
			(IF (not (equal? (edits ind) '(1 0)))
			    (snd-display ";undo-apply amp: ~A?" (edits ind)))
			(IF (not (equal? (edit-fragment 1) (list "Enved: amp" "set" 0 50828)))
			    (snd-display ";undo-apply amp fragment: ~A?" (edit-fragment 1)))
			(click-button flt-button) (force-event)
			(click-button apply-button) (force-event)
			(IF (not (equal? (edits ind) '(2 0)))
			    (snd-display ";apply flt: ~A?" (edits ind)))
			(IF (and (not (equal? (edit-fragment 2) (list "Enved: flt" "set" 0 50868)))
				 (not (equal? (edit-fragment 2) (list "Enved: flt" "set" 0 50828))))
			    (snd-display ";apply flt fragment: ~A?" (edit-fragment 2)))
			(click-button reset-button) (force-event)
			(widget-string text-widget "'(0 .5 1 .4)") (force-event)
			(key-event text-widget snd-return-key 0) (force-event)
			(click-button src-button) (force-event)
			(click-button apply-button) (force-event)
			(IF (not (equal? (edits ind) '(3 0)))
			    (snd-display ";apply src: ~A?" (edits ind)))
			(IF (and (not (equal? (edit-fragment 3) (list "Enved: src" "set" 0 113510)))
				 (not (equal? (edit-fragment 3) (list "Enved: src" "set" 0 113420))))
			    (snd-display ";apply flt fragment: ~A?" (edit-fragment 3)))
			(IF (not (> (frames ind) (* 2 fr)))
			    (snd-display ";apply src length: ~A ~A?" fr (frames ind)))
			(click-button (find-child (car enved-widgets) "exp:"))
			(|XtCallCallbacks (find-child (car enved-widgets) "expscl") |XmNdragCallback
					  (let ((cb (|XmScrollBarCallbackStruct)))
					    (set! (|value cb) 65)
					    (set! (|event cb) (|XEvent))
					    cb))
			(|XtCallCallbacks (find-child (car enved-widgets) "expscl") |XmNvalueChangedCallback
					  (let ((cb (|XmScrollBarCallbackStruct)))
					    (set! (|value cb) 65)
					    (set! (|event cb) (|XEvent))
					    cb))
			(click-button show-button) (force-event)
			(close-sound ind))
		      
		      (click-button dismiss-button) (force-event)
		      ))))

	    (for-each (lambda (dialog)
			(all-help dialog))
		      (dialog-widgets))

	    (|XSynchronize (|XtDisplay (cadr (main-widgets))) #f)

	    (if (provided? 'snd-motif)
	      (let ((move-scroll
		     (lambda (w val)
		       (if (and w
				(|XmScrollBar? w))
			   (let ((oldvals (|XmScrollBarGetValues w)))
			     (apply |XmScrollBarSetValues (list w
								(+ (car oldvals) val)
								(cadr oldvals)
								(caddr oldvals)
								(cadddr oldvals)
								#t))
			     (let ((newvals (|XmScrollBarGetValues w)))
			       (IF (> (abs (- (car newvals) (car oldvals) val)) 1)
				   (snd-display ";move ~A ~A: ~A" (|XtName w) val (car newvals)))))
			   (snd-display ";move-scroll ~A?" w)))))
		(reset-all-hooks)

		(let* ((ind (open-sound "pistol.snd"))
		       (swids (sound-widgets ind))
		       (spane (car swids))
		       (sctrls (list-ref swids 2))
		       (cmain (find-child spane "chn-main-window")))
		  (move-scroll (find-child cmain "chn-sx") 10)
		  (move-scroll (find-child cmain "chn-zy") -30)
		  (move-scroll (find-child cmain "chn-sy") 10)
		  (move-scroll (find-child cmain "chn-zx") 10)
		  (set! (show-controls ind) #t)
		  (move-scroll (find-child sctrls "amp") 10)
		  (IF (not (> (amp-control ind) 1.0)) (snd-display ";amp-control moved: ~A" (amp-control ind)))
		  (move-scroll (find-child sctrls "speed-scroll") 10)
		  (IF (not (> (speed-control ind) 1.0)) (snd-display ";speed-control moved: ~A" (speed-control ind)))
		  (move-scroll (find-child sctrls "expand-scroll") 10)
		  (IF (not (> (expand-control ind) 1.0)) (snd-display ";expand-control moved: ~A" (expand-control ind)))
		  (move-scroll (find-child sctrls "contrast-scroll") 10)
		  (IF (not (> (contrast-control ind) 0.0)) (snd-display ";contrast-control moved: ~A" (contrast-control ind)))
		  (move-scroll (find-child sctrls "revscl-scroll") 10)
		  (IF (not (> (reverb-control-scale ind) 0.0)) (snd-display ";reverb-control-scale moved: ~A" (reverb-control-scale ind)))
		  (move-scroll (find-child sctrls "revlen-scroll") 10)
		  (IF (not (> (reverb-control-length ind) 1.0)) (snd-display ";reverb-control-length moved: ~A" (reverb-control-length ind)))
		  (|XmToggleButtonSetState (find-child sctrls "dir") #t #t)
		  (IF (>= (speed-control ind) 0.0) (snd-display ";speed arrow: ~A" (speed-control ind)))
		  (|XmToggleButtonSetState (find-child sctrls "expoff") #t #t)
		  (IF (not (expand-control? ind)) (snd-display ";toggle but expand off?"))
		  (|XmToggleButtonSetState (find-child sctrls "conoff") #t #t)
		  (IF (not (contrast-control? ind)) (snd-display ";toggle but contrast off?"))
		  (|XmToggleButtonSetState (find-child sctrls "revoff") #t #t)
		  (IF (not (reverb-control? ind)) (snd-display ";toggle but reverb off?"))
		  (|XmToggleButtonSetState (find-child sctrls "fltoff") #t #t)
		  (IF (not (filter-control? ind)) (snd-display ";toggle but filter off?"))
		  (|XmToggleButtonSetState (find-child sctrls "fltdB") #t #t)
		  (IF (not (filter-control-in-dB ind)) (snd-display ";toggle but filter-in-db off?"))
		  ;(click-button (cadr (find-child sctrls "expand-label")))
		  ;(IF (fneq (expand-control ind) 1.0) (snd-display ";click expand: ~A" (expand-control)))
		  ;need click event here, not just pushbutton callback
		  (close-sound ind))

		(if (not (car (dialog-widgets))) 
		    (begin 
		      (set! (with-background-processes) #t)
		      (without-errors (test-menus)) 
		      (dismiss-all-dialogs)
		      (set! (with-background-processes) #f)))

		;; ---------------- color dialog ----------------
		(let* ((colord (list-ref (dialog-widgets) 0))
		       (inv (find-child colord "invert"))
		       (cut (find-child colord "cutoff"))
		       (scl (find-child colord "ccdscl")))
		  (|XtManageChild colord)
		  (if (and inv (|Widget? inv))
		      (begin
			(move-scale cut 32)
			(IF (fneq (color-cutoff) .032)
			    (snd-display ";moved color-cutoff: ~A ~A" (color-cutoff) (|XmScaleGetValue cut)))
			(move-scale scl 32)
			(IF (fneq (color-scale) .647)
			    (snd-display ";moved color-scale: ~A ~A" (color-scale) (|XmScaleGetValue scl)))
			(|XmToggleButtonSetState inv #f #t)
			(IF (color-inverted)
			    (snd-display ";toggle invert off"))
			(|XmToggleButtonSetState inv #t #t)
			(IF (not (color-inverted))
			    (snd-display ";toggle invert on")))
		      (snd-display ";can't find color invert button?"))
		  (let ((lst (find-child colord "colormap-list")))
		    (do ((i 2 (1+ i)))
			((= i 15))
		      (|XmListSelectPos lst i #t)
		      (IF (not (= (colormap) (- i 1)))
			  (snd-display ";color dialog list ~A: ~A" (- i 1) (colormap)))))
		  (click-button (|XmMessageBoxGetChild colord |XmDIALOG_CANCEL_BUTTON)) (force-event))

                ;; ---------------- orientation dialog ----------------
		(orientation-dialog)
                (let* ((orientd (list-ref (dialog-widgets) 1))
		       (cut (or (find-child orientd "cut") (snd-display ";can't find cut")))
		       (ax (or (find-child orientd "ax") (snd-display ";can't find x angle")))
		       (ay (or (find-child orientd "ay") (snd-display ";can't find y angle")))
		       (az (or (find-child orientd "az") (snd-display ";can't find z angle")))
		       (sx (or (find-child orientd "xs") (snd-display ";can't find x scale")))
		       (sy (or (find-child orientd "ys") (snd-display ";can't find y scale")))
		       (sz (or (find-child orientd "zs") (snd-display ";can't find z scale")))
		       (hop (or (find-child orientd "hop") (snd-display ";can't find hop"))))
		  (set! (spectro-x-scale) 2.0)
		  (click-button (|XmMessageBoxGetChild orientd |XmDIALOG_OK_BUTTON)) (force-event)
		  (IF (fneq (spectro-x-scale) 1.0)
		      (snd-display ";orientation reset: ~A" (spectro-x-scale)))
		  (move-scale cut 32)
		  (IF (fneq (spectro-cutoff) .32)
		      (snd-display ";moved spectro-cutoff: ~A ~A" (spectro-cutoff) (|XmScaleGetValue cut)))
		  (move-scale ax 32)
		  (IF (fneq (spectro-x-angle) 32)
		      (snd-display ";moved spectro-x-angle: ~A ~A" (spectro-x-angle) (|XmScaleGetValue ax)))
		  (move-scale ay 32)
		  (IF (fneq (spectro-y-angle) 32)
		      (snd-display ";moved spectro-y-angle: ~A ~A" (spectro-y-angle) (|XmScaleGetValue ay)))
		  (move-scale az 32)
		  (IF (fneq (spectro-z-angle) 32)
		      (snd-display ";moved spectro-z-angle: ~A ~A" (spectro-z-angle) (|XmScaleGetValue az)))
		  (move-scale sx 32)
		  (IF (fneq (spectro-x-scale) .32)
		      (snd-display ";moved spectro-x-scale: ~A ~A" (spectro-x-scale) (|XmScaleGetValue sx)))
		  (move-scale sy 32)
		  (IF (fneq (spectro-y-scale) .32)
		      (snd-display ";moved spectro-y-scale: ~A ~A" (spectro-y-scale) (|XmScaleGetValue sy)))
		  (move-scale sz 32)
		  (IF (fneq (spectro-z-scale) .32)
		      (snd-display ";moved spectro-z-scale: ~A ~A" (spectro-z-scale) (|XmScaleGetValue sz)))
		  (move-scale hop 12)
		  (IF (fneq (spectro-hop) 12)
		      (snd-display ";moved spectro-hop: ~A ~A" (spectro-hop) (|XmScaleGetValue hop)))
		  (click-button (|XmMessageBoxGetChild orientd |XmDIALOG_OK_BUTTON)) (force-event)
		  (IF (fneq (spectro-x-scale) 1.0)
		      (snd-display ";orientation reset: ~A" (spectro-x-scale)))
		  (set! (widget-position orientd) (list 200 300))
		  (click-button (|XmMessageBoxGetChild orientd |XmDIALOG_CANCEL_BUTTON)) (force-event)
		  (IF (|XtIsManaged orientd)
		      (snd-display ";orientation still active?")))

		;; ---------------- enved dialog ----------------
		(if (defined? 'enved-axis-info)
		    (begin
		      (let* ((envd (list-ref (dialog-widgets) 2)))
			(|XtManageChild envd)
			(let* ((ind2 (open-sound "storm.snd"))
			       (cwid (car (channel-widgets ind2 0)))
			       (waveb (find-child envd "wave"))
			       (selectb (find-child envd "selection"))
			       (mixb (find-child envd "mix")))
			  (make-selection 243873 702138 ind2 0)
			  (click-button selectb)
			  (set! (cursor ind2 0) 1000)
			  (take-keyboard-focus (car (channel-widgets)))
			  (key-event cwid (char->integer #\x) 4) (force-event)
			  (key-event cwid (char->integer #\q) 0) (force-event)
			  (set! (cursor ind2 0) 1195243)
			  (key-event cwid (char->integer #\x) 4) (force-event)
			  (key-event cwid (char->integer #\q) 0) (force-event)
			  (click-button mixb) (force-event)
			  (let* ((axis (enved-axis-info))
				 (axis-x0 (list-ref axis 0))
				 (axis-x1 (list-ref axis 2))
				 (axis-y0 (list-ref axis 1))
				 (axis-y1 (list-ref axis 3))
				 (enved-widgets (enved-dialog-widgets))
				 (drawer (cadr enved-widgets))
				 (ewid drawer))
			    (define (enved-x x) (inexact->exact (+ axis-x0 (* x (- axis-x1 axis-x0)))))
			    (define (enved-y y) (inexact->exact (- axis-y0 (* y (- axis-y0 axis-y1)))))
			    (click-event ewid 1 0 (enved-x 0.5) (enved-y 1.0)) (force-event)
			    (click-button (|XmMessageBoxGetChild envd |XmDIALOG_OK_BUTTON)) (force-event)
			    (click-button (find-child envd "Reset")) (force-event)
			    (click-button (|XmMessageBoxGetChild envd |XmDIALOG_CANCEL_BUTTON)) (force-event)
			    (close-sound ind2))))))

		;; ---------------- error dialog ----------------
		(let ((errord (list-ref (dialog-widgets) 3)))
		  (|XtManageChild errord)
		  (click-button (|XmMessageBoxGetChild errord |XmDIALOG_OK_BUTTON)) (force-event)
		  (IF (|XtIsManaged errord)
		      (snd-display ";why is error dialog alive?")))

		;; ---------------- yes-or-no dialog ----------------
		(let ((old-val (with-background-processes)))
		  (set! (with-background-processes) 1234)
		  (let* ((val (yes-or-no? "hiho"))
			 (yesd (list-ref (dialog-widgets) 4)))
		    (IF (not yesd)
			(snd-display ";no yes dialog"))
		    (|XtManageChild yesd)
		    (click-button (|XmMessageBoxGetChild yesd |XmDIALOG_OK_BUTTON)) (force-event))
		  (set! (with-background-processes) old-val))

		;; ---------------- transform dialog ----------------
		(let* ((transd (list-ref (dialog-widgets) 5))
		       (beta (find-child transd "beta-scale")))
		  ;; push all the buttons
		  (for-each (lambda (name check off2)
			      (let ((button (find-child transd name)))
				(if (and button (|Widget? button))
				    (begin
				      (if off2
					  (begin
					    (|XmToggleButtonSetState button #f #t)
					    (IF (check)
						(snd-display ";toggle ~A off" name))))
				      (|XmToggleButtonSetState button #t #t)
				      (IF (not (check))
					  (snd-display ";toggle ~A on" name)))
				    (snd-display ";no ~A togglebutton widget in transform dialog?" name))))
			    (list "normo-button" "sono-button" "spectro-button" "normo-button" "peaks-button" "db-button" 
				  "logfreq-button" "normalize-button" "selection-button")
			    (list (lambda () (= (transform-graph-type) graph-transform-once))
				  (lambda () (= (transform-graph-type) graph-transform-as-sonogram))
				  (lambda () (= (transform-graph-type) graph-transform-as-spectrogram))
				  (lambda () (= (transform-graph-type) graph-transform-once))
				  show-transform-peaks
				  fft-log-magnitude
				  fft-log-frequency
				  (lambda () (= (transform-normalization) 1))
				  show-selection-transform)
			    (list #f #f #f #f #t #t
				  #t #t #t))
		  (move-scale beta 32)
		  (IF (fneq (fft-window-beta) .32)
		      (snd-display ";moved fft-beta: ~A ~A" (fft-window-beta) (|XmScaleGetValue beta)))
		  ;; click all the lists
		  (for-each (lambda (name check)
			      (let ((lst (find-child transd name)))
				(if (and lst (|Widget? lst))
				    (check lst)
				    (snd-display ";no ~A list widget in transform dialog?" name))))
			    (list "type-list" "size-list" "wavelet-list" "window-list")
			    (list (lambda (w)
				    (|XmListSelectPos w (+ autocorrelation 1) #t)
				    (IF (not (= (transform-type) autocorrelation))
					(snd-display ";transform-type autocorrelation: ~A ~A?" (transform-type) autocorrelation))
				    (|XmListSelectPos w (+ wavelet-transform 1) #t)
				    (IF (not (= (transform-type) wavelet-transform))
					(snd-display ";transform-type wavelet-transform: ~A ~A?" (transform-type) wavelet-transform)))
				  (lambda (w)
				    (|XmListSelectPos w 7 #t)
				    (IF (not (= (transform-size) 1024))
					(snd-display ";transform-size ~A ~A" (transform-size) 1024))
				    (|XmListSelectPos w 2 #t)
				    (IF (not (= (transform-size) 32))
					(snd-display ";transform-size ~A ~A" (transform-size) 32)))
				  (lambda (w)
				    (|XmListSelectPos w 4 #t)
				    (IF (not (= (wavelet-type) 3))
					(snd-display ";wavelet-type: ~A" (wavelet-type))))
				  (lambda (w)
				    (|XmListSelectPos w (+ bartlett-window 1) #t)
				    (IF (not (= (fft-window) bartlett-window))
					(snd-display ";fft-window bartlett: ~A ~A" (fft-window) bartlett-window))
				    (|XmListSelectPos w (+ kaiser-window 1) #t)
				    (IF (not (= (fft-window) kaiser-window))
					(snd-display ";fft-window kaiser: ~A ~A" (fft-window) kaiser-window)))))
		  (click-button (|XmMessageBoxGetChild transd |XmDIALOG_OK_BUTTON)) (force-event)
		  (IF (|XtIsManaged transd)
		      (snd-display ";why is transform dialog active?")))

		;; ---------------- file:open dialog ----------------
                (open-file-dialog)
                (let* ((filed (list-ref (dialog-widgets) 6))
		       (filename (|XmFileSelectionBoxGetChild filed |XmDIALOG_TEXT))
		       (snd-tab-key #xFF09))
		  (|XmTextSetString filename "oboe.s")
		  (key-event filename snd-tab-key 0) (force-event)
		  (|XmUpdateDisplay filename)
		  (IF (not (string=? (|XmTextGetString filename) "oboe.snd")) (snd-display "<tab>->~A?" (|XmTextGetString filename)))
		  (click-button (|XmFileSelectionBoxGetChild filed |XmDIALOG_OK_BUTTON)) (force-event)
		  (let ((ind (find-sound "oboe.snd")))
		    (IF (not (sound? ind))
			(snd-display "file:open failed?"))
		    (close-sound ind)))
                (open-file-dialog)
                (let* ((filed (list-ref (dialog-widgets) 6)))
		  (click-button (|XmFileSelectionBoxGetChild filed |XmDIALOG_APPLY_BUTTON)) (force-event)
		  (click-button (|XmFileSelectionBoxGetChild filed |XmDIALOG_CANCEL_BUTTON)) (force-event)
		  (IF (|XtIsManaged filed)
		      (snd-display ";file:open cancel failed?")))
		(open-file-dialog)
                (let* ((filed (list-ref (dialog-widgets) 6))
		       (sounds (find-child filed "sound files only"))
		       (plays (find-child filed "play selected sound"))
		       (files (|XmFileSelectionBoxGetChild filed |XmDIALOG_LIST)))
		  (|XmToggleButtonSetState sounds #f #t)
		  (|XmToggleButtonSetState sounds #t #t)
		  (|XmListSelectPos files 1 #t)
		  (|XmToggleButtonSetState plays #t #t)
		  (click-button (|XmFileSelectionBoxGetChild filed |XmDIALOG_OK_BUTTON)) (force-event)
		  (let* ((filename (|XmTextGetString (|XmFileSelectionBoxGetChild filed |XmDIALOG_TEXT)))
			 (ind (find-sound filename)))
		    (IF (not (sound? ind))
			(snd-display "chose: ~A but not active?" filename))
		    (|XmToggleButtonSetState plays #f #t)
		    (close-sound ind)
		    (click-button (|XmFileSelectionBoxGetChild filed |XmDIALOG_CANCEL_BUTTON)) 
		    (force-event)))
		(open-file-dialog)
                (let* ((filed (list-ref (dialog-widgets) 6))
		       (pattern (|XmFileSelectionBoxGetChild filed |XmDIALOG_FILTER_TEXT))
		       (sounds (find-child filed "sound files only")))
		  (|XmToggleButtonSetState sounds #t #t)
		  (|XmToggleButtonSetState sounds #f #t)
		  (|XmTextSetString pattern "/home/bil/cl/*.snd")
		  (|XmToggleButtonSetState sounds #t #t)
		  (|XmToggleButtonSetState sounds #f #t)
		  (|XmTextSetString pattern "/home/bil/cl/*.wav")
		  (|XmToggleButtonSetState sounds #t #t)
		  (click-button (|XmFileSelectionBoxGetChild filed |XmDIALOG_CANCEL_BUTTON)) (force-event))
                (open-file-dialog)
                (let* ((filed (list-ref (dialog-widgets) 6))
		       (filename (|XmFileSelectionBoxGetChild filed |XmDIALOG_TEXT))
		       (snd-tab-key #xFF09))
		  (|XmTextSetString filename "oboe.")
		  (key-event filename snd-tab-key 0) (force-event)
		  (|XmUpdateDisplay filename)
		  ;; now the completion help should be active
		  (let ((helper (list-ref (dialog-widgets) 15)))
		    (IF (not helper)
			(snd-display ";help completion inactive?")
			(let ((choices (find-child (list-ref (dialog-widgets) 15) "completion-help-text")))
			  (|XmListSelectPos choices 2 #f)
			  (click-button (|XmMessageBoxGetChild helper |XmDIALOG_OK_BUTTON)) (force-event)
			  )))
		  (click-button (|XmFileSelectionBoxGetChild filed |XmDIALOG_CANCEL_BUTTON)) (force-event))

                ;; ---------------- file save-as dialog ----------------
		(set! (default-output-chans) 1)
		(set! (default-output-format) mus-bshort)
		(set! (default-output-srate) 22050)
		(set! (default-output-type) mus-next)

                (let ((ind (open-sound "oboe.snd")))
		  (if (file-exists? "test.snd") (delete-file "test.snd"))
		  (scale-by 2.0)
		  (file-save-as-dialog)
		  (let* ((saved (list-ref (dialog-widgets) 7))
			 (ok (|XmFileSelectionBoxGetChild saved |XmDIALOG_OK_BUTTON))
			 (filetext (|XmFileSelectionBoxGetChild saved |XmDIALOG_TEXT)))
		    (|XmTextSetString filetext "test.snd")
		    (click-button ok) (force-event)
		    (IF (not (file-exists? "test.snd"))
			(snd-display ";file test.snd not saved?"))
		    (IF (|XtIsManaged saved)
			(snd-display "after save, file dialog still active?"))
		    (let ((ind1 (open-sound "test.snd")))
		      (IF (not (= (header-type ind1) (header-type ind))) 
			  (snd-display ";save-as changed header type? ~A" (mus-header-type-name (header-type ind1))))
		      (IF (not (= (data-format ind1) (data-format ind))) 
			  (snd-display ";save-as changed data format? ~A" (mus-data-format-name (data-format ind1))))
		      (IF (not (= (chans ind1) (chans ind))) 
			  (snd-display ";save-as changed channels? ~A" (chans ind1)))
		      (IF (not (= (srate ind1) (srate ind))) 
			  (snd-display ";save-as changed srate? ~A" (srate ind1)))
		      (IF (not (= (frames ind) (frames ind1)))
			  (snd-display ";save-as changed length? ~A" (frames ind1)))
		      (let* ((r1 (make-sample-reader 0 ind1 0))
			     (ok (scan-channel (lambda (x)
						 (let ((val (next-sample r1)))
						   (if (fneq val x)
						       (list x val)
						       #f)))
					       0 (1- (frames ind)) ind 0)))
			(IF ok
			    (snd-display ";save-as diff: ~A" ok))
			(free-sample-reader r1))
		      (close-sound ind1)))
		  (if (file-exists? "test.snd") (delete-file "test.snd"))
		  (file-save-as-dialog)
		  (let* ((saved (list-ref (dialog-widgets) 7))
			 (types (find-child saved "header type")) ; list
			 (formats (find-child saved "data format")) ; list
			 (srtxt (find-child saved "srate-text")) 
			 (comtxt (find-child saved "comment-text"))
			 (cancel (|XmFileSelectionBoxGetChild saved |XmDIALOG_CANCEL_BUTTON))
			 (ok (|XmFileSelectionBoxGetChild saved |XmDIALOG_OK_BUTTON))
			 (filter (|XmFileSelectionBoxGetChild saved |XmDIALOG_APPLY_BUTTON))
			 (filetext (|XmFileSelectionBoxGetChild saved |XmDIALOG_TEXT)))
		    (do ((i 1 (1+ i)))
			((= i 7))
		      (|XmListSelectPos types i #t))
		    (|XmListSelectPos types 2 #t)
		    (|XmListSelectPos formats 2 #t)
		    (|XmTextSetString filetext "test.snd")
		    (|XmTextSetString srtxt "(* 2 22050)")
		    (|XmTextSetString comtxt "This is a test of the file save-as dialog")
		    (click-button ok) (force-event)
		    (IF (not (file-exists? "test.snd"))
			(snd-display ";file 2 test.snd not saved?"))
		    (IF (|XtIsManaged saved)
			(snd-display "after save, file dialog still active?"))
		    (let ((ind1 (open-sound "test.snd")))
		      (IF (not (= (header-type ind1) mus-aifc))
			  (snd-display ";save-as aifc header type? ~A" (mus-header-type-name (header-type ind1))))
		      (IF (not (= (data-format ind1) mus-mulaw))
			  (snd-display ";save-as mulaw data format? ~A" (mus-data-format-name (data-format ind1))))
		      (IF (not (= (srate ind1) 44100))
			  (snd-display ";save-as 44100 srate? ~A" (srate ind1)))
		      (IF (or (not (string? (comment ind1)))
			      (not (string=? (comment ind1) "This is a test of the file save-as dialog")))
			  (snd-display ";save-as comment: ~A" (comment ind1)))
		      (let* ((r1 (make-sample-reader 0 ind1 0))
			     (ok (scan-channel (lambda (x)
						 (let ((val (next-sample r1)))
						   (if (> (abs (- val x)) .01) ; mulaw not very close sometimes
						       (list x val)
						       #f)))
					       0 (1- (frames ind)) ind 0)))
			(IF ok
			    (snd-display ";save-as 2 diff: ~A" ok))
			(free-sample-reader r1))
		      (close-sound ind1)))
		  (if (file-exists? "test.snd") (delete-file "test.snd"))
		  (file-save-as-dialog)
		  (let* ((saved (list-ref (dialog-widgets) 7))
			 (filetext (|XmFileSelectionBoxGetChild saved |XmDIALOG_TEXT))
			 (cancel (|XmFileSelectionBoxGetChild saved |XmDIALOG_CANCEL_BUTTON))
			 (filter (|XmFileSelectionBoxGetChild saved |XmDIALOG_APPLY_BUTTON)))
		    (click-button filter) (force-event)
		    (IF (string=? (|XmTextGetString filetext) "test.snd")
			(snd-display ";save-as filter: ~A?" (|XmTextGetString filetext)))
		    (click-button cancel) (force-event)
		    (IF (|XtIsManaged saved)
			(snd-display "after cancel, file dialog still active?"))
		    (if (file-exists? "test.snd")
			(snd-display ";cancelled save-as wrote a file?")))
		  (close-sound ind))

                ;; ---------------- edit save-as dialog ----------------
                (let ((ind (open-sound "oboe.snd")))
		  (if (file-exists? "test.snd") (delete-file "test.snd"))
		  (make-selection 2000 3000 ind 0)
		  (scale-selection-by 2.0)
		  (edit-save-as-dialog)
		  (let* ((saved (list-ref (dialog-widgets) 7))
			 (ok (|XmFileSelectionBoxGetChild saved |XmDIALOG_OK_BUTTON))
			 (filetext (|XmFileSelectionBoxGetChild saved |XmDIALOG_TEXT))
			 (types (find-child saved "header type")) ; list
			 (formats (find-child saved "data format"))) ; list
		    (|XmListSelectPos types 1 #t)
		    (|XmListSelectPos formats 1 #t)
		    (|XmTextSetString filetext "test.snd")
		    (click-button ok) (force-event)
		    (IF (not (file-exists? "test.snd"))
			(snd-display ";edit test.snd not saved?"))
		    (IF (|XtIsManaged saved)
			(snd-display "after save, edit dialog still active?"))
		    (let ((ind1 (open-sound "test.snd")))
		      (let* ((r1 (make-sample-reader 2000 ind 0))
			     (ok (scan-channel (lambda (x)
						 (let ((val (next-sample r1)))
						   (if (fneq val x)
						       (list x val)
						       #f)))
					       0 (1- (frames ind1)) ind1 0)))
			(IF ok
			    (snd-display ";edit save-as diff: ~A" ok))
			(free-sample-reader r1))
		      (close-sound ind1)))
		  (if (file-exists? "test.snd") (delete-file "test.snd"))
		  (edit-save-as-dialog)
		  (let* ((saved (list-ref (dialog-widgets) 7))
			 (filetext (|XmFileSelectionBoxGetChild saved |XmDIALOG_TEXT))
			 (cancel (|XmFileSelectionBoxGetChild saved |XmDIALOG_CANCEL_BUTTON))
			 (filter (|XmFileSelectionBoxGetChild saved |XmDIALOG_APPLY_BUTTON)))
		    (click-button cancel) (force-event)
		    (IF (|XtIsManaged saved)
			(snd-display "after cancel, edit save-as dialog still active?"))
		    (if (file-exists? "test.snd")
			(snd-display ";cancelled edit save-as wrote a file?")))
		  (close-sound ind))

		;; ---------------- view files dialog ----------------
		(if (not (defined? 'files-popup-info))
		    (load "nb.scm"))
		(if (hook-empty? mouse-enter-label-hook)
		    (begin
		      (add-hook! mouse-enter-label-hook files-popup-info)
		      (add-hook! mouse-leave-label-hook files-popup-quit)))
                (file-dialog)
		(let ((ind (open-sound "2.snd")))
		  (close-sound ind))
                (let* ((filed (list-ref (dialog-widgets) 8))
		       (curform (find-child filed "curform"))
		       (prevform (find-child filed "prevform"))
		       (sort-menu (find-child prevform "sort"))
		       (option-holder (cadr (|XtGetValues sort-menu (list |XmNsubMenuId 0))))
		       (rw1 (find-child prevform "rw"))
		       (sv1 (find-child rw1 "sv"))
		       (pl1 (find-child rw1 "pl"))
		       (nm1 (find-child rw1 "nm"))
		       (name (cadr (|XmStringGetLtoR (cadr (|XtVaGetValues nm1 (list |XmNlabelString 0))) "bold_button_font")))
		       (rw2 (find-child curform "rw"))
		       (sv2 (find-child rw1 "sv"))
		       (pl2 (find-child rw1 "pl"))
		       (nm2 (find-child rw1 "nm")))
		  (IF (> (length (sounds)) 0) (snd-display ";sounds at view-file: ~A" (sounds)))
		  (catch #t
	            (lambda ()
		      (|XmToggleButtonSetState pl1 #t #t)
		      (|XmToggleButtonSetState pl1 #f #t)
		      (click-button nm1)
		      (IF (or (= (length (sounds)) 0)
			      (not (string=? (short-file-name (car (sounds))) name)))
			  (snd-display ";click previous: ~A ~A" name (map short-file-name (sounds))))
		      (|XmToggleButtonSetState sv2 #t #t)		  
		      (|XmToggleButtonSetState pl2 #t #t)
		      (|XmToggleButtonSetState sv2 #f #t)
		      (|XmToggleButtonSetState pl2 #f #t))
		    (lambda args args))
		  (enter-event nm1)
		  (set! name (cadr (|XmStringGetLtoR (cadr (|XtVaGetValues nm2 (list |XmNlabelString 0))) "bold_button_font")))
		  (close-sound (car (sounds)))
		  (|XmToggleButtonSetState sv1 #t #t)
		  (for-each-child option-holder
				  (lambda (w)
				    (if (|XmIsPushButton w)
					(begin
					  (click-button w #t)
					  (force-event)))))
		  (let ((update (find-child filed "Update")))
		    (click-button update) (force-event))
		  (click-button (|XmMessageBoxGetChild filed |XmDIALOG_CANCEL_BUTTON)) (force-event)     ;clear
		  (set! name (cadr (|XmStringGetLtoR (cadr (|XtVaGetValues nm2 (list |XmNlabelString 0))) "bold_button_font")))
		  (click-button (|XmMessageBoxGetChild filed |XmDIALOG_OK_BUTTON)) (force-event)
		  (reset-hook! mouse-enter-label-hook)
		  (reset-hook! mouse-leave-label-hook)
		  (IF (|XtIsManaged filed)
		      (snd-display ";why is view files active?")))

		;; ---------------- raw data dialog ----------------
                (let ((old-val (with-background-processes)))
		  (set! (with-background-processes) 1234)
		  (let ((rf (open-sound (string-append sf-dir "addf8.nh"))))
		    (IF (not (sound? rf))
			(snd-display ";raw-data file: ~A" rf)
			(close-sound rf))
		    (IF (not (list-ref (dialog-widgets) 9))
			(snd-display ";raw-data open: ~A" (list-ref (dialog-widgets) 9))
			(let ((rd (list-ref (dialog-widgets) 9)))
			  (click-button (|XmMessageBoxGetChild rd |XmDIALOG_CANCEL_BUTTON)) (force-event))))
		  (set! (with-background-processes) old-val))

		;; ---------------- file:new dialog ----------------
		(if (defined? 'new-file-dialog)
		    (begin
		      (let ((old-val (with-background-processes)))
			(set! (with-background-processes) 1234)
			(let ((newind (new-file-dialog)))
			  (IF (not (sound? newind)) 
			      (snd-display ";new file dialog: ~A" newind)
			      (close-sound newind)))
			(set! (with-background-processes) old-val))))

		;; ---------------- file:mix dialog ----------------
                (if (list-ref (dialog-widgets) 11)
		    (let* ((mixd (list-ref (dialog-widgets) 11))
			   (filename (|XmFileSelectionBoxGetChild mixd |XmDIALOG_TEXT))
			   (ind (new-sound "test.snd" mus-next mus-bshort 22050 1 "mixing"))
			   (ind1 (open-sound "oboe.snd")))
		      (|XtManageChild mixd)
		      (set! (cursor ind) 0)
		      (|XmTextSetString filename "oboe.snd")
		      (click-button (|XmFileSelectionBoxGetChild mixd |XmDIALOG_OK_BUTTON)) (force-event)
		      (let* ((r1 (make-sample-reader 0 ind1 0))
			     (ok (scan-channel (lambda (x)
						 (let ((val (next-sample r1)))
						   (if (fneq val x)
						       (list x val)
						       #f)))
					       0 (1- (frames ind)) ind 0)))
			(IF ok
			    (snd-display ";mix diff: ~A" ok))
			(free-sample-reader r1))
		      (close-sound ind1)
		      (|XtManageChild mixd)
		      (click-button (|XmFileSelectionBoxGetChild mixd |XmDIALOG_CANCEL_BUTTON)) (force-event)
		      (IF (|XtIsManaged mixd)
			  (snd-display ";mix file dialog still active?"))
		      (close-sound ind))
		    (snd-display ";no mix file dialog?"))

		;; ---------------- edit header dialog ----------------
                (let ((ind (open-sound "oboe.snd")))
		  (define (type->pos type)
		    (if (= type mus-next) 1
			(if (= type mus-aifc) 2
			    (if (= type mus-riff) 3
				(if (= type mus-raw) 4
				    (if (= type mus-aiff) 5
					(if (= type mus-ircam) 6
					    7)))))))

		  (define (format->pos type format)
		    (let ((next-formats (list mus-bshort mus-mulaw mus-byte mus-bfloat mus-bint mus-alaw mus-b24int mus-bdouble))
			  (ircam-formats (list mus-bshort mus-mulaw mus-bfloat mus-bint mus-alaw))
			  (wave-formats (list mus-mulaw mus-alaw mus-ubyte mus-lshort mus-lint mus-lfloat mus-ldouble mus-l24int))
			  (aifc-formats (list mus-bshort mus-mulaw mus-byte mus-bint mus-alaw mus-b24int 
					      mus-bfloat mus-bdouble mus-ubyte mus-lshort mus-lint mus-l24int mus-ubshort))
			  (aiff-formats (list mus-bshort mus-bint mus-byte mus-b24int))
			  (nist-formats (list mus-bshort mus-lshort mus-bint mus-lint mus-byte mus-b24int mus-l24int))
			  (raw-formats (list mus-bshort mus-mulaw mus-byte mus-bfloat mus-bint mus-alaw mus-ubyte mus-b24int 
					     mus-bdouble mus-lshort mus-lint mus-lfloat mus-ldouble mus-ubshort mus-ulshort
					     mus-l24int mus-bintn mus-lintn)))
		      (define (position val lst pos)
			(call-with-current-continuation
			 (lambda (return)
			   (if (null? lst)
			       #f
			       (if (= val (car lst))
				   (return pos)
				   (position val (cdr lst) (1+ pos)))))))
		      (if (= type mus-next) (position format next-formats 1)
			  (if (= type mus-aifc) (position format aifc-formats 1)
			      (if (= type mus-riff) (position format wave-formats 1)
				  (if (= type mus-raw) (position format raw-formats 1)
				      (if (= type mus-aiff) (position format aiff-formats 1)
					  (if (= type mus-ircam) (position format ircam-formats 1)
					      (position format nist-formats 1)))))))))

		  (if (file-exists? "fmv.snd") (delete-file "fmv.snd"))
		  (save-sound-as "fmv.snd" ind)
		  (close-sound ind)
		  (set! ind (open-sound "fmv.snd"))
		  (edit-header-dialog)
		  (let* ((editd (list-ref (dialog-widgets) 12))
			 ;; cancel ok=save 
			 (types (find-child editd "header type")) ; list
			 (formats (find-child editd "data format")) ; list
			 (srtxt (find-child editd "srate-text")) 
			 (chtxt (find-child editd "chans-text"))
			 (loctxt (find-child editd "location-text"))
			 (comtxt (find-child editd "comment-text")))
		    (|XmListSelectPos types (type->pos mus-riff) #t)
		    (|XmListSelectPos formats (format->pos mus-riff mus-lfloat) #t)
		    (|XmTextSetString srtxt "8")
		    (key-event srtxt snd-tab-key 0) (force-event)
		    (|XmUpdateDisplay srtxt)
		    (|XmTextSetString loctxt "44")
		    (|XmTextSetString comtxt "saved from edit-header dialog")
		    (click-button (|XmMessageBoxGetChild editd |XmDIALOG_OK_BUTTON)) (force-event)
		    (set! ind (find-sound "fmv.snd"))
		    (IF (not (= (header-type ind) mus-riff))
			(snd-display ";edit-header -> riff? ~A" (mus-header-type-name (header-type ind))))
		    (IF (not (= (data-format ind) mus-lfloat))
			  (snd-display ";edit-header -> lfloat? ~A" (mus-data-format-name (data-format ind))))
		    (IF (not (= (srate ind) 8000))
			(snd-display ";edit-header -> 8000? ~A" (srate ind)))
		    (IF (or (not (string? (comment ind)))
			    (not (string=? (comment ind) "saved from edit-header dialog")))
			(snd-display ";edit header comment: ~A" (comment ind)))
		    (IF (|XtIsManaged editd)
			(snd-display "why is edit header dialog active?"))
		    (close-sound ind)
		    (set! ind (open-sound "4.aiff"))
		    (let ((old-data (channel->vct 250000 500 ind 1))
			  (old-silence (channel->vct 103000 500 ind 1))
			  (old-length (mus-sound-duration "4.aiff")))
		      (close-sound ind)
		      (system "cp -f 4.aiff test.aiff")
		      (set! ind (open-sound "test.aiff"))
		      (IF (not (sound? ind)) (snd-display ";cp -> test.aiff: ~A" ind))
		      (for-each
		       (lambda (typ frm chns sr com backout nominal-length)
			 (edit-header-dialog)
			 (IF (not (|XtIsManaged editd))
			     (snd-display "why isn't the edit header dialog active?"))
			 (|XmListSelectPos types (type->pos typ) #t)
			 (|XmListSelectPos formats (format->pos typ frm) #t)
			 (click-button (|XmMessageBoxGetChild editd |XmDIALOG_OK_BUTTON)) (force-event)
			 (set! ind (find-sound "test.aiff"))
			 (IF (not (= (header-type ind) typ))
			     (snd-display ";ledit-header type -> ~A ~A" typ (mus-header-type-name (header-type ind))))
			 (edit-header-dialog)
			 (|XmTextSetString srtxt (number->string sr))
			 (click-button (|XmMessageBoxGetChild editd |XmDIALOG_OK_BUTTON)) (force-event)
			 (set! ind (find-sound "test.aiff"))
			 (IF (not (= (data-format ind) frm))
			     (snd-display ";ledit-header format -> ~A ~A (~A ~A) [~A]" 
					  frm (data-format ind) 
					  (mus-data-format-name (data-format ind))
					  (mus-data-format-name frm)
					  (mus-header-type-name typ)))
			 (IF (not (= (srate ind) sr))
			     (snd-display ";ledit-header srate -> ~A ~A" sr (srate ind)))
			 (edit-header-dialog)
			 (if com (|XmTextSetString comtxt com))
			 (|XmTextSetString chtxt (number->string chns))
			 (click-button (|XmMessageBoxGetChild editd |XmDIALOG_OK_BUTTON)) (force-event)
			 (set! ind (find-sound "test.aiff"))
			 (if com
			     (IF (or (not (string? (comment ind)))
				     (not (string=? (comment ind) com)))
				 (snd-display ";edit header comment ~A: ~A" com (comment ind))))
			 (IF (not (= (chans ind) chns))
			     (snd-display ";ledit-header chans -> ~A ~A" chns (chans ind)))
			 (IF (and nominal-length
				  (fneq (mus-sound-duration "test.aiff") nominal-length))
			     (snd-display ";ledit-header duration: nominal: ~A, current: ~A [~A ~A ~A ~A]" 
					  nominal-length (mus-sound-duration "test.aiff") 
					  (mus-header-type-name typ) 
					  (mus-data-format-name frm)
					  sr chns))
			 (if backout
			     (let ((new-data (channel->vct 250000 500 ind 1))
				   (new-silence (channel->vct 103000 500 ind 1)))
			       (IF (not (vequal new-data old-data))
				   (snd-display ";backout data diffs: ~A ~A ~A"
						(let ((sum 0.0)
						      (sub-data (vct-copy new-data)))
						  (vct-subtract! sub-data old-data)
						  (do ((i 0 (1+ i)))
						      ((= i 500))
						    (set! sum (+ sum (abs (vct-ref sub-data i)))))
						  sum)
						old-data new-data))
			       (IF (not (vequal new-silence old-silence))
				   (snd-display ";backout silence diffs: ~A ~A ~A"
						(let ((sum 0.0)
						      (sub-silence (vct-copy new-silence)))
						  (vct-subtract! sub-silence old-silence)
						  (do ((i 0 (1+ i)))
						      ((= i 500))
						    (set! sum (+ sum (abs (vct-ref sub-silence i)))))
						  sum)
						old-silence new-silence)))))
		       (list mus-aiff mus-aifc mus-next mus-aifc mus-riff 
			     mus-next mus-next mus-aiff mus-aifc
			     mus-nist mus-ircam mus-aifc mus-aifc)
		       (list mus-bshort mus-bshort mus-bshort mus-bshort mus-lfloat 
			     mus-bshort mus-bfloat mus-bshort mus-bshort
			     mus-lint mus-alaw mus-bshort mus-bint)
		       (list 2 4 2 4 4 
			     2 2 2 4
			     2 4 4 4)
		       (list 22050 22050 44100 22050 22050 
			     22050 22050 22050 22050
			     44100 8000 44100 22050)
		       (list #f #f "this is a comment" "this is another comment" "riff time" 
			     "next time" #f "aiff time" "aifc time"
			     #f "ircam time" "aifc time" #f)
		       (list #f #t #f #t #f 
			     #f #f #f #t
			     #f #f #t #f)
		       (list (* 2 old-length) old-length old-length old-length (* 0.5 old-length) 
			     (* 2 old-length) old-length (* 2 old-length) old-length
			     #f #f (* 0.5 old-length) (* 0.5 old-length))))
		    (close-sound ind)
		    (click-button (|XmMessageBoxGetChild editd |XmDIALOG_CANCEL_BUTTON)) (force-event)))
		(if (file-exists? "test.aiff") (delete-file "test.aiff"))

		;; ---------------- edit:find dialog ----------------
		(if (defined? 'edit-find-dialog)
		    (begin
		      (edit-find-dialog)
		      (let* ((findd (list-ref (dialog-widgets) 13))
			     (ind (open-sound "oboe.snd"))
			     ;; ok = dismiss cancel = previous next = next
			     (dismiss (|XmMessageBoxGetChild findd |XmDIALOG_OK_BUTTON))
			     (previous (|XmMessageBoxGetChild findd |XmDIALOG_CANCEL_BUTTON))
			     (next (find-child findd "Next"))
			     (txt (find-child findd "text")))
			(|XmTextSetString txt "(lambda (n) (> n .1))")
			(click-button next) (force-event)
			(IF (not (> (sample (cursor)) .1))
			    (snd-display ";sample at cursor upon edit find > .1: ~A (~A)" (sample (cursor)) (cursor)))
			(click-button next) (force-event)
			(click-button previous) (force-event)
			(click-button dismiss) (force-event)
			(close-sound ind)
			(IF (|XtIsManaged findd)
			    (snd-display ";edit find is still active?")))))

                ;; ---------------- help dialog ----------------
	        (help-dialog "Test" "snd-test here")
                (let* ((helpd (list-ref (dialog-widgets) 14)))
		  (click-button (|XmMessageBoxGetChild helpd |XmDIALOG_OK_BUTTON)) (force-event)
		  (IF (|XtIsManaged helpd)
		      (snd-display ";help still active?")))

		;; ---------------- mix-panel dialog ----------------
		(let* ((ind (open-sound "oboe.snd"))
		       (v (make-vct 3))
		       (s1001 (sample 1001))
		       (s2001 (sample 2001)))
		  (vct-fill! v .1)
		  (let* ((id1 (mix-vct v 1000 ind 0 #t))
			 (id2 (mix-vct v 2000 ind 0 #t)))
		    (mix-panel)
		    (let* ((mixd (list-ref (dialog-widgets) 16))
			   (idtxt (find-child mixd "mix-id"))
			   (nametxt (find-child mixd "mix-name"))
			   (begtxt (find-child mixd "mix-times"))
			   (trktxt (find-child mixd "mix-track"))
			   (playb (find-child mixd "play"))
			   (spdscr (find-child mixd "speed"))
			   (ampscr (find-child mixd "amp")))
		      (IF (fneq (sample 1001) (+ s1001 .1)) 
			  (snd-display ";mix-panel at 1001: ~A (~A)?" (sample 1001) s1001))
		      (IF (fneq (sample 2001) (+ s2001 .1)) 
			  (snd-display ";mix-panel at 2001: ~A (~A)?" (sample 2001) s2001))
		      (select-mix id1)
		      (IF (not (string=? (|XmTextGetString trktxt) "0"))
			  (snd-display ";mix initial track: ~A" (|XmTextGetString trktxt)))
		      (IF (not (string=? (|XmTextGetString idtxt) (number->string id1)))
			  (snd-display ";mix initial id: ~A" (|XmTextGetString idtxt)))
		      (move-scroll ampscr 20)
		      (IF (not (> (sample 1001) (+ s1001 .1)))
			  (snd-display ";amp mix-panel at 1001: ~A (~A)?" (sample 1001) s1001))
		      (IF (fneq (sample 2001) (+ s2001 .1)) 
			  (snd-display ";amp mix-panel at 2001: ~A (~A)?" (sample 2001) s2001))
		      (click-button playb)
		      (move-scroll spdscr 20)
		      (for-each
		       (lambda (scrl)
			 (|XtCallCallbacks scrl |XmNdragCallback
					   (let ((cb (|XmScrollBarCallbackStruct)))
					     (set! (|value cb) 50)
					     (set! (|event cb) (|XEvent))
					     cb)))
		       (list spdscr ampscr))
		      (for-each
		       (lambda (n)
			 (click-button n #t 0)
			 (click-button n #t |ControlMask))
		       (map
			(lambda (w) (find-child mixd w))
			(list "speed-label" "amp-label")))
		      (widget-string begtxt "0.5") (force-event)
		      (key-event begtxt snd-return-key 0) (force-event)
		      (widget-string trktxt "2") (force-event)
		      (key-event trktxt snd-return-key 0) (force-event)
		      (widget-string nametxt "3") (force-event)
		      (key-event nametxt snd-return-key 0) (force-event)
		      (widget-string idtxt "2") (force-event)
		      (key-event idtxt snd-return-key 0) (force-event)
		      (click-button (|XmMessageBoxGetChild mixd |XmDIALOG_OK_BUTTON)) (force-event)     ;dismiss
		      (IF (|XtIsManaged mixd)
			  (snd-display ";why is mix-panel dialog alive?"))))
		  (close-sound ind))

		;; ---------------- print dialog ----------------
		(let* ((ind (open-sound "oboe.snd"))
		       (print-menu (menu-option "Print")))
		  (|XtSetSensitive print-menu #t)
		  (click-button print-menu #t)
		  (let ((printd (list-ref (dialog-widgets) 17)))
		    (if (|Widget? printd)
			(begin
			  (if (not (|XtIsManaged printd)) (|XtManageChild printd))
			  (let ((txt (find-child printd "text")))
			  (|XmTextSetString txt "test.eps")
			  (click-button (|XmMessageBoxGetChild printd |XmDIALOG_OK_BUTTON))
			  (IF (not (file-exists? "test.eps"))
			      (snd-display ";print -> test.eps?")
			      (delete-file "test.eps"))
			  (click-button (|XmMessageBoxGetChild printd |XmDIALOG_CANCEL_BUTTON))
			  (IF (|XtIsManaged printd)
			      (snd-display ";why is print dialog alive?"))))
		      (snd-display ";no print dialog?"))
		  (close-sound ind)))

		;; ---------------- recorder dialog ----------------
                (let ((old-val (with-background-processes)))
		  (set! (with-background-processes) 1234) ; turns off recorder background process altogether
		  (let* ((recd (list-ref (dialog-widgets) 18))
			 (file-pane (find-child recd "file-pane"))
			 (record (find-child recd "record-button"))
			 ;; cancel -> reset, ok -> dismiss
			 )
		    (|XtManageChild recd)
		    (click-button record) (force-event)
		    (click-button record) (force-event)
		    (click-button (|XmMessageBoxGetChild recd |XmDIALOG_CANCEL_BUTTON)) (force-event)
		    (click-button (|XmMessageBoxGetChild recd |XmDIALOG_OK_BUTTON)) (force-event)
		    )
		  (set! (with-background-processes) old-val))

		;; ---------------- region dialog ----------------
                (region-dialog)
                (let* ((regd (list-ref (dialog-widgets) 19))
		       (prtb (find-child regd "print"))
		       (grf (find-child regd "grf"))
		       (frm (find-child regd "formw"))
		       (rw1 (find-child frm "rw"))
		       (sv1 (find-child rw1 "sv"))
		       (pl1 (find-child rw1 "pl"))
		       (nm1 (find-child rw1 "nm"))
		       (name (cadr (|XmStringGetLtoR (cadr (|XtVaGetValues nm1 (list |XmNlabelString 0))) "bold_button_font"))))
		  (|XmToggleButtonSetState pl1 #t #t)
		  (|XmToggleButtonSetState pl1 #f #t)
		  (|XmToggleButtonSetState sv1 #t #t)
		  (|XmToggleButtonSetState sv1 #f #t)
		  (click-button nm1)
		  (click-button (|XmMessageBoxGetChild regd |XmDIALOG_CANCEL_BUTTON)) (force-event)		  
		  (let ((name1 (cadr (|XmStringGetLtoR (cadr (|XtVaGetValues nm1 (list |XmNlabelString 0))) "bold_button_font"))))
		    (IF (string=? name1 name)
			(snd-display ";delete in region dialog: ~A?" name)))
		  (click-button prtb) (force-event)
		  (click-button (find-child grf "down") #t)
		  (click-button (find-child grf "up") #t)
		  (click-button (|XmMessageBoxGetChild regd |XmDIALOG_OK_BUTTON)) (force-event)		  
		  (IF (|XtIsManaged regd)
		      (snd-display ";region dialog is still active?")))
		))))))
    


;;; -------------------- test 23: X/Xt/Xm --------------------
(if (or full-test (= snd-test 23) (and keep-going (<= snd-test 23)))
    (begin
      (if (procedure? test-hook) (test-hook 23))
      (if (provided? 'snd-motif)
	  (begin
	    ;; ---------------- X tests ----------------
	    (let ((scr (current-screen))
		  (dpy (|XtDisplay (cadr (main-widgets)))))
	      (IF (not (= (|height scr) 1200))
		  (snd-display ";screen height: ~A" (|height scr)))
	      (IF (not (= (|width scr) 1600))
		  (snd-display ";screen width: ~A" (|width scr)))
	      (let ((ratio (/ (|mwidth scr) (|width scr))))
		(IF (> (abs (- (* ratio (|height scr)) (|mheight scr))) 2)
		    (snd-display ";mheight/width: ~A ~A" (|mheight scr) (|mwidth scr))))
	      (IF (not (= (|ndepths scr) 7))
		  (snd-display ";screen ndepths: ~A" (|ndepths scr)))
	      (IF (not (= (cadr (|white_pixel scr)) 16777215))
		  (snd-display ";screen white_pixel: ~A" (|white_pixel scr)))
	      (IF (not (= (cadr (|black_pixel scr)) 0))
		  (snd-display ";screen black_pixel: ~A" (|black_pixel scr)))
	      (IF (not (eq? (|backing_store scr) #f))
		  (snd-display ";screen backing_store: ~A" (|backing_store scr)))
	      (IF (not (= (|min_maps scr) 1))
		  (snd-display ";screen min_maps: ~A" (|min_maps scr)))
	      (IF (not (= (|max_maps scr) 1))
		  (snd-display ";screen max_maps: ~A" (|max_maps scr)))
	      (IF (not (eq? (|save_unders scr) #f))
		  (snd-display ";screen save_unders: ~A" (|save_unders scr)))
	      (IF (not (|GC? (|default_gc scr)))
		  (snd-display ";screen default_gc: ~A" (|default_gc scr)))
	      (IF (not (|Window? (|root scr)))
		  (snd-display ";screen root: ~A" (|root scr)))
	      (IF (not (|Colormap? (|cmap scr)))
		  (snd-display ";screen colormap: ~A" (|cmap scr)))
	      
	      (IF (not (equal? (|DisplayOfScreen scr) (|display scr))) 
		  (snd-display ";DisplayOfScreen: ~A ~A" (|DisplayOfScreen scr) (|display scr)))
	      (IF (not (equal? (|RootWindowOfScreen scr) (|root scr))) 
		  (snd-display ";RootWindowOfScreen: ~A ~A" (|RootWindowOfScreen scr) (|root scr)))
	      (IF (not (equal? (|BlackPixelOfScreen scr) (|black_pixel scr))) 
		  (snd-display ";BlackPixelOfScreen: ~A ~A" (|BlackPixelOfScreen scr) (|black_pixel scr)))
	      (IF (not (equal? (|WhitePixelOfScreen scr) (|white_pixel scr))) 
		  (snd-display ";WhitePixelOfScreen: ~A ~A" (|WhitePixelOfScreen scr) (|white_pixel scr)))
	      (IF (not (equal? (|DefaultColormapOfScreen scr) (|cmap scr))) 
		  (snd-display ";DefaultColormapOfScreen: ~A ~A" (|DefaultColormapOfScreen scr) (|cmap scr)))
	      (IF (not (equal? (|DefaultDepthOfScreen scr) (|root_depth scr))) 
		  (snd-display ";DefaultDepthOfScreen: ~A ~A" (|DefaultDepthOfScreen scr) (|root_depth scr)))
	      (IF (not (equal? (|DefaultGCOfScreen scr) (|default_gc scr))) 
		  (snd-display ";DefaultGCOfScreen: ~A ~A" (|DefaultGCOfScreen scr) (|default_gc scr)))
	      (IF (not (equal? (|DefaultVisualOfScreen scr) (|root_visual scr))) 
		  (snd-display ";DefaultVisualOfScreen: ~A ~A" (|DefaultVisualOfScreen scr) (|root_visual scr)))
	      (IF (not (equal? (|WidthOfScreen scr) (|width scr))) 
		  (snd-display ";WidthOfScreen: ~A ~A" (|WidthOfScreen scr) (|width scr)))
	      (IF (not (equal? (|HeightOfScreen scr) (|height scr))) 
		  (snd-display ";HeightOfScreen: ~A ~A" (|HeightOfScreen scr) (|height scr)))
	      (IF (not (equal? (|WidthMMOfScreen scr) (|mwidth scr))) 
		  (snd-display ";WidthMMOfScreen: ~A ~A" (|WidthMMOfScreen scr) (|mwidth scr)))
	      (IF (not (equal? (|HeightMMOfScreen scr) (|mheight scr))) 
		  (snd-display ";HeightMMOfScreen: ~A ~A" (|HeightMMOfScreen scr) (|mheight scr)))
	      (IF (not (equal? (|PlanesOfScreen scr) (|root_depth scr))) 
		  (snd-display ";PlanesOfScreen: ~A ~A" (|PlanesOfScreen scr) (|root_depth scr)))
	      (IF (not (equal? (|MinCmapsOfScreen scr) (|min_maps scr))) 
		  (snd-display ";MinCmapsOfScreen: ~A ~A" (|MinCmapsOfScreen scr) (|min_maps scr)))
	      (IF (not (equal? (|MaxCmapsOfScreen scr) (|max_maps scr))) 
		  (snd-display ";MaxCmapsOfScreen: ~A ~A" (|MaxCmapsOfScreen scr) (|max_maps scr)))
	      (IF (not (equal? (|DoesSaveUnders scr) (|save_unders scr))) 
		  (snd-display ";DoesSaveUnders: ~A ~A" (|DoesSaveUnders scr) (|save_unders scr)))
	      (IF (not (equal? (|DoesBackingStore scr) (|backing_store scr))) 
		  (snd-display ";DoesBackingStore: ~A ~A" (|DoesBackingStore scr) (|backing_store scr)))
	      (IF (not (equal? (|EventMaskOfScreen scr) (|root_input_mask scr))) 
		  (snd-display ";EventMaskOfScreen: ~A ~A" (|EventMaskOfScreen scr) (|root_input_mask scr)))

	      (IF (not (equal? (|XDisplayOfScreen scr) (|display scr))) 
		  (snd-display ";XDisplayOfScreen: ~A ~A" (|XDisplayOfScreen scr) (|display scr)))
	      (IF (not (equal? (|XDisplayOfScreen (|XScreenOfDisplay dpy 0)) dpy))
		  (snd-display ";XScreenOfDisplay ~A ~A" (|XDisplayOfScreen (|XScreenOfDisplay dpy 0)) dpy))
	      (IF (not (equal? (|XDefaultScreenOfDisplay dpy) scr))
		  (snd-display ";XDefaultScreenOfDisplay ~A ~A" (|XDefaultScreenOfDisplay dpy) scr))
	      (IF (not (equal? (|XRootWindowOfScreen scr) (|root scr))) 
		  (snd-display ";XRootWindowOfScreen: ~A ~A" (|XRootWindowOfScreen scr) (|root scr)))
	      (IF (not (equal? (|XBlackPixelOfScreen scr) (|black_pixel scr))) 
		  (snd-display ";XBlackPixelOfScreen: ~A ~A" (|XBlackPixelOfScreen scr) (|black_pixel scr)))
	      (IF (not (equal? (|XWhitePixelOfScreen scr) (|white_pixel scr))) 
		  (snd-display ";XWhitePixelOfScreen: ~A ~A" (|XWhitePixelOfScreen scr) (|white_pixel scr)))
	      (IF (not (equal? (|XDefaultColormapOfScreen scr) (|cmap scr))) 
		  (snd-display ";XDefaultColormapOfScreen: ~A ~A" (|XDefaultColormapOfScreen scr) (|cmap scr)))
	      (IF (not (equal? (|XDefaultDepthOfScreen scr) (|root_depth scr))) 
		  (snd-display ";XDefaultDepthOfScreen: ~A ~A" (|XDefaultDepthOfScreen scr) (|root_depth scr)))
	      (IF (not (equal? (|XDefaultGCOfScreen scr) (|default_gc scr)))
		  (snd-display ";XDefaultGCOfScreen: ~A ~A" (|XDefaultGCOfScreen scr) (|default_gc scr)))
	      (IF (not (equal? (|XDefaultVisualOfScreen scr) (|root_visual scr)))
		  (snd-display ";XDefaultVisualOfScreen: ~A ~A" (|XDefaultVisualOfScreen scr) (|root_visual scr)))
	      (IF (not (equal? (|XWidthOfScreen scr) (|width scr)))
		  (snd-display ";XWidthOfScreen: ~A ~A" (|XWidthOfScreen scr) (|width scr)))
	      (IF (not (equal? (|XHeightOfScreen scr) (|height scr)))
		  (snd-display ";XHeightOfScreen: ~A ~A" (|XHeightOfScreen scr) (|height scr)))
	      (IF (not (equal? (|XWidthMMOfScreen scr) (|mwidth scr))) 
		  (snd-display ";XWidthMMOfScreen: ~A ~A" (|XWidthMMOfScreen scr) (|mwidth scr)))
	      (IF (not (equal? (|XHeightMMOfScreen scr) (|mheight scr))) 
		  (snd-display ";XHeightMMOfScreen: ~A ~A" (|XHeightMMOfScreen scr) (|mheight scr)))
	      (IF (not (equal? (|XPlanesOfScreen scr) (|root_depth scr))) 
		  (snd-display ";XPlanesOfScreen: ~A ~A" (|XPlanesOfScreen scr) (|root_depth scr)))
	      (IF (not (equal? (|XMinCmapsOfScreen scr) (|min_maps scr)))
		  (snd-display ";XMinCmapsOfScreen: ~A ~A" (|XMinCmapsOfScreen scr) (|min_maps scr)))
	      (IF (not (equal? (|XMaxCmapsOfScreen scr) (|max_maps scr)))
		  (snd-display ";XMaxCmapsOfScreen: ~A ~A" (|XMaxCmapsOfScreen scr) (|max_maps scr)))
	      (IF (not (equal? (|XDoesSaveUnders scr) (|save_unders scr)))
		  (snd-display ";XDoesSaveUnders: ~A ~A" (|XDoesSaveUnders scr) (|save_unders scr)))
	      (IF (not (equal? (|XDoesBackingStore scr) (|backing_store scr))) 
		  (snd-display ";XDoesBackingStore: ~A ~A" (|XDoesBackingStore scr) (|backing_store scr)))
	      (IF (not (equal? (|XEventMaskOfScreen scr) (|root_input_mask scr)))
		  (snd-display ";XEventMaskOfScreen: ~A ~A" (|XEventMaskOfScreen scr) (|root_input_mask scr)))
	      )
	    
	    (let* ((scr (current-screen))
		   (scrn (|XScreenNumberOfScreen scr))
		   (dpy (|XtDisplay (cadr (main-widgets))))
		   (vis (|DefaultVisual dpy scrn))
		   (win (|XtWindow (cadr (main-widgets)))))

	      (IF (not (equal? (|RootWindow dpy scrn) (|root scr)))
		  (snd-display ";RootWindow: ~A ~A" (|RootWindow dpy scrn) (|root scr)))
	      (IF (not (equal? (|DefaultRootWindow dpy) (|root (|ScreenOfDisplay dpy (|DefaultScreen dpy)))))
		  (snd-display ";DefaultRootWindow: ~A ~A" (|DefaultRootWindow dpy) (|root (|ScreenOfDisplay dpy (|DefaultScreen dpy)))))
	      (IF (not (equal? (|DefaultVisual dpy scrn) (|root_visual scr)))
		  (snd-display ";DefaultVisual: ~A ~A" (|DefaultVisual dpy scrn) (|root_visual scr)))
	      (IF (not (equal? (|DefaultGC dpy scrn) (|default_gc scr)))
		  (snd-display ";DefaultGC: ~A ~A" (|DefaultGC dpy scrn) (|default_gc scr)))
	      (IF (not (equal? (|BlackPixel dpy scrn) (|black_pixel scr)))
		  (snd-display ";BlackPixel: ~A ~A" (|BlackPixel dpy scrn) (|black_pixel scr)))
	      (IF (not (equal? (|WhitePixel dpy scrn) (|white_pixel scr)))
		  (snd-display ";WhitePixel ~A ~A" (|WhitePixel dpy scrn) (|white_pixel scr)))
	      (IF (not (equal? (|DisplayWidth dpy scrn) (|width scr)))
		  (snd-display ";DisplayWidth: ~A ~A" (|DisplayWidth dpy scrn) (|width scr)))
	      (IF (not (equal? (|DisplayHeight dpy scrn) (|height scr)))
		  (snd-display ";DisplayHeight: ~A ~A" (|DisplayHeight dpy scrn) (|height scr)))
	      (IF (not (equal? (|DisplayWidthMM dpy scrn) (|mwidth scr)))
		  (snd-display ";DisplayWidthMM: ~A ~A" (|DisplayWidthMM dpy scrn) (|mwidth scr)))
	      (IF (not (equal? (|DisplayHeightMM dpy scrn) (|mheight scr)))
		  (snd-display ";DisplayHeightMM: ~A ~A" (|DisplayHeightMM dpy scrn) (|mheight scr)))
	      (IF (not (equal? (|DisplayPlanes dpy scrn) (|root_depth scr)))
		  (snd-display ";DisplayPlanes: ~A ~A" (|DisplayPlanes dpy scrn) (|root_depth scr)))
	      (IF (not (equal? (|DefaultDepth dpy scrn) (|root_depth scr)))
		  (snd-display ";DefaultDepth: ~A ~A" (|DefaultDepth dpy scrn) (|root_depth scr)))
	      (IF (not (equal? (|DefaultColormap dpy scrn) (|cmap scr)))
		  (snd-display ";DefaultColormap: ~A ~A" (|DefaultColormap dpy scrn) (|cmap scr)))
	      
	      (IF (not (equal? (|XRootWindow dpy scrn) (|root scr)))
		  (snd-display ";XRootWindow: ~A ~A" (|XRootWindow dpy scrn) (|root scr)))
	      (IF (not (equal? (|XDefaultRootWindow dpy) (|root (|ScreenOfDisplay dpy (|DefaultScreen dpy)))))
		  (snd-display ";XDefaultRootWindow: ~A ~A" (|XDefaultRootWindow dpy) (|root (|ScreenOfDisplay dpy (|DefaultScreen dpy)))))
	      (IF (not (equal? (|XDefaultVisual dpy scrn) (|root_visual scr)))
		  (snd-display ";XDefaultVisual: ~A ~A" (|XDefaultVisual dpy scrn) (|root_visual scr)))
	      (IF (not (equal? (|XDefaultGC dpy scrn) (|default_gc scr)))
		  (snd-display ";XDefaultGC: ~A ~A" (|XDefaultGC dpy scrn) (|default_gc scr)))
	      (IF (not (equal? (|XBlackPixel dpy scrn) (|black_pixel scr)))
		  (snd-display ";XBlackPixel: ~A ~A" (|XBlackPixel dpy scrn) (|black_pixel scr)))
	      (IF (not (equal? (|XWhitePixel dpy scrn) (|white_pixel scr)))
		  (snd-display ";XWhitePixel ~A ~A" (|XWhitePixel dpy scrn) (|white_pixel scr)))
	      (IF (not (equal? (|XDisplayWidth dpy scrn) (|width scr)))
		  (snd-display ";XDisplayWidth: ~A ~A" (|XDisplayWidth dpy scrn) (|width scr)))
	      (IF (not (equal? (|XDisplayHeight dpy scrn) (|height scr)))
		  (snd-display ";XDisplayHeight: ~A ~A" (|XDisplayHeight dpy scrn) (|height scr)))
	      (IF (not (equal? (|XDisplayWidthMM dpy scrn) (|mwidth scr)))
		  (snd-display ";XDisplayWidthMM: ~A ~A" (|XDisplayWidthMM dpy scrn) (|mwidth scr)))
	      (IF (not (equal? (|XDisplayHeightMM dpy scrn) (|mheight scr)))
		  (snd-display ";XDisplayHeightMM: ~A ~A" (|XDisplayHeightMM dpy scrn) (|mheight scr)))
	      (IF (not (equal? (|XDisplayPlanes dpy scrn) (|root_depth scr)))
		  (snd-display ";XDisplayPlanes: ~A ~A" (|XDisplayPlanes dpy scrn) (|root_depth scr)))
	      (IF (not (equal? (|XDefaultDepth dpy scrn) (|root_depth scr)))
		  (snd-display ";XDefaultDepth: ~A ~A" (|XDefaultDepth dpy scrn) (|root_depth scr)))
	      (IF (not (equal? (|XDefaultColormap dpy scrn) (|cmap scr)))
		  (snd-display ";XDefaultColormap: ~A ~A" (|XDefaultColormap dpy scrn) (|cmap scr)))
	      
	      (IF (not (equal? (|XDefaultVisual dpy scrn) vis))
		  (snd-display ";|XDefaultVisual: ~A ~A" (|XDefaultVisual dpy scrn) vis))
	      (IF (not (equal? (|DisplayCells dpy scrn) (|map_entries vis)))
		  (snd-display ";DisplayCells: ~A ~A" (|DisplayCells dpy scrn) (|map_entries vis)))
	      (IF (not (equal? (|CellsOfScreen scr) (|map_entries (|DefaultVisualOfScreen scr))))
		  (snd-display ";CellsOfScreen: ~A ~A" (|CellsOfScreen scr) (|map_entries (|DefaultVisualOfScreen scr))))
	      (IF (not (equal? (|XDisplayCells dpy scrn) (|map_entries vis)))
		  (snd-display ";XDisplayCells: ~A ~A" (|XDisplayCells dpy scrn) (|map_entries vis)))
	      (IF (not (equal? (|XCellsOfScreen scr) (|map_entries (|DefaultVisualOfScreen scr))))
		  (snd-display ";XCellsOfScreen: ~A ~A" (|XCellsOfScreen scr) (|map_entries (|DefaultVisualOfScreen scr))))
	      (IF (< (|XNextRequest dpy) (|XLastKnownRequestProcessed dpy))
		  (snd-display ";XRequests: ~A ~A" (|XNextRequest dpy) (|XLastKnownRequestProcessed dpy)))
	      (IF (< (|NextRequest dpy) (|LastKnownRequestProcessed dpy))
		  (snd-display ";Requests: ~A ~A" (|NextRequest dpy) (|LastKnownRequestProcessed dpy)))
	      (IF (not (= (|XDisplayMotionBufferSize dpy) 256))
		  (snd-display ";XDisplayMotionBufferSize: ~A" (|XDisplayMotionBufferSize dpy)))
	      (IF (not (= (|XExtendedMaxRequestSize dpy) 1048575))
		  (snd-display ";XExtendedMaxRequestSize ~A" (|XExtendedMaxRequestSize dpy)))
	      (IF (not (= (|XMaxRequestSize dpy) 65535))
		  (snd-display ";XMaxRequestSize ~A" (|XMaxRequestSize dpy)))
	      (IF (not (member (list 'Atom 40) (|XListProperties dpy win)))
		  (snd-display ";XListProperties: ~A" (|XListProperties dpy win)))
	      (IF (not (member "SHAPE" (|XListExtensions dpy)))
		  (snd-display ";XListExtensions: ~A" (|XListExtensions dpy)))
	      (IF (not (= (length (|XListFontsWithInfo dpy "-adobe-times-medium-r-*-*-*-*-*-*-*-*-iso8859-1" 4)) 4))
		  (snd-display ";XListFontsWithInfo: ~A" (|XListFontsWithInfo dpy "-adobe-times-medium-r-*-*-*-*-*-*-*-*-iso8859-1" 4)))
	      (IF (not (= (length (|XListFonts dpy "-adobe-times-medium-r-*-*-*-*-*-*-*-*-iso8859-1" 4)) 4))
		  (snd-display ";XListFonts: ~A" (|XListFonts dpy "-adobe-times-medium-r-*-*-*-*-*-*-*-*-iso8859-1" 4)))
	      (let ((val (|XListInstalledColormaps dpy win)))
		(IF (or (not val)
			(null? val)
			(not (|Colormap? (car val))))
		    (snd-display ";XListInstalledColormaps: ~A" (|XListInstalledColormaps dpy win))))
	      (IF (not (string=? (|XKeysymToString (list 'KeySym 80)) "P"))
		  (snd-display ";XKeysymToString: ~A" (|XKeysymToString (list 'KeySym 80))))
	      (IF (not (string=? (|XGetAtomName dpy (list 'Atom 40)) "WM_NORMAL_HINTS"))
		  (snd-display ";XGetAtomName: ~A" (|XGetAtomName dpy (list 'Atom 40))))

	      (IF (not (= (|bits_per_rgb vis) 8)) (snd-display ";bits_per_rgb: ~A" (|bits_per_rgb vis)))
	      (IF (not (= (|blue_mask vis) 255)) (snd-display ";blue_mask: ~X" (|blue_mask vis)))
	      (IF (not (= (|green_mask vis) 65280)) (snd-display ";green_mask: ~X" (|green_mask vis)))
	      (IF (not (= (|red_mask vis) 16711680)) (snd-display ";red_mask: ~X" (|red_mask vis)))
	      (IF (not (= |AllPlanes 4294967295)) (snd-display ";AllPlanes: ~A" |AllPlanes))
	      
	      (IF (< (|QLength dpy) 0) (snd-display ";QLength: ~A" (|QLength dpy)))
	      (IF (not (= (|ScreenCount dpy) 1)) (snd-display ";ScreenCount: ~A" (|ScreenCount dpy)))
	      (IF (not (string=? (|ServerVendor dpy) "The XFree86 Project, Inc")) (snd-display ";ServerVendor: ~A" (|ServerVendor dpy)))
	      (IF (not (= (|ProtocolRevision dpy) 0)) (snd-display ";ProtocolRevision: ~A" (|ProtocolRevision dpy)))
	      (IF (not (= (|ProtocolVersion dpy) 11)) (snd-display ";ProtocolVersion: ~A" (|ProtocolVersion dpy)))
	      (IF (not (number? (|VendorRelease dpy))) (snd-display ";VendorRelease: ~A" (|VendorRelease dpy)))
	      (IF (not (string=? (|DisplayString dpy) ":0.0")) (snd-display ";DisplayString: ~A" (|DisplayString dpy)))
	      (IF (not (= (|BitmapUnit dpy) 32)) (snd-display ";BitmapUnit: ~A" (|BitmapUnit dpy)))
	      (IF (not (= (|BitmapPad dpy) 32)) (snd-display ";BitmapPad: ~A" (|BitmapPad dpy)))
	      (IF (not (= (|BitmapBitOrder dpy) 0)) (snd-display ";BitmapBitOrder: ~A" (|BitmapBitOrder dpy)))
	      (IF (not (= (|ImageByteOrder dpy) 0)) (snd-display ";ImageByteOrder: ~A" (|ImageByteOrder dpy)))
	      (IF (not (= (|DefaultScreen dpy) 0)) (snd-display ";DefaultScreen: ~A" (|DefaultScreen dpy)))

	      (let* ((col (|XColor))
		     (dpy (|XtDisplay (cadr (main-widgets))))
		     (scr (|DefaultScreen dpy))
		     (cmap (|DefaultColormap dpy scr)))
		(IF (= (|XAllocNamedColor dpy cmap "blue" col col) 0) (snd-display ";XAllocNamedColor blue ~A?" col))
		(IF (not (= (|red col) 0)) (snd-display ";XAllocNamedColor: ~A" (|red col)))
		(IF (= (|XAllocColor dpy cmap col) 0) (snd-display ";XAllocColor?"))
		(IF (not (= (|red col) 0)) (snd-display ";XAllocColor: ~A" (|red col)))
		(IF (= (|XParseColor dpy cmap "blue" col) 0) (snd-display ";XParseColor?"))
		(IF (not (= (|red col) 0)) (snd-display ";XParseColor: ~A" (|red col))))

	      (|XSetAfterFunction dpy (lambda (n) 0))
	      (|XSetAfterFunction dpy #f)
	      (IF (not (equal? (|XDisplayKeycodes dpy) (list 1 8 255)))
		  (snd-display "XDisplayKeycodes: ~A" (|XDisplayKeycodes dpy)))
	      (let ((str (|XFetchName dpy win)))
		(IF (not (string=? str "snd"))
		    (snd-display "XFetchName: ~A" str)))
	      (|XStoreName dpy win "hiho")
	      (let ((str (|XFetchName dpy win)))
		(IF (not (string=? str "hiho"))
		    (snd-display "XStoreName: ~A" str)))
	      (|XStoreName dpy win "snd")
	      (let ((str (|XGetIconName dpy win)))
		(IF (not (string=? str "snd"))
		    (snd-display "XGetIconName: ~A" str)))
	      (|XSetIconName dpy win "hiho")
	      (let ((str (|XGetIconName dpy win)))
		(IF (not (string=? str "hiho"))
		    (snd-display "XSetIconName: ~A" str)))
	      (let ((geo (|XGetGeometry dpy win)))
		(IF (or (not (= (window-width) (list-ref geo 4)))
			(not (= (window-height) (list-ref geo 5))))
		    (snd-display "XGetGeometry: ~A (~A ~A)" geo (window-width) (window-height))))
	      (let ((focus (|XGetInputFocus dpy)))
		(IF (or (not (= (car focus) 1))
			(not (|Window? (cadr focus))))
		    (snd-display ";XGetInputFocus: ~A" focus)))
	      (let ((vals (|XGetPointerControl dpy)))
		(IF (not (equal? vals (list 1 2 1 4))) (snd-display "pointer state: ~A" vals))
		(|XChangePointerControl dpy #f #t 2 1 8)
		(set! vals (|XGetPointerControl dpy))
		(IF (not (equal? vals (list 1 2 1 8))) (snd-display "set pointer state: ~A" vals))
		(|XChangePointerControl dpy #f #t 2 1 4))
	      (let ((vals (beep-state)))
		(IF (not (= (cadr vals) 400)) (snd-display ";beep state: ~A" vals))
		(set! (beep-state) (list 100 200 100))
		(set! vals (beep-state))
		(IF (not (= (cadr vals) 200)) (snd-display ";set beep state: ~A" vals)))
	      (|XAutoRepeatOff dpy)
	      (IF (not (= (list-ref (|XGetKeyboardControl dpy) 5) 0)) (snd-display ";AutoRepeatOff?"))
	      (|XAutoRepeatOn dpy)
	      (IF (not (= (list-ref (|XGetKeyboardControl dpy) 5) 1)) (snd-display ";AutoRepeatOn?"))
	      (let ((vals (|XGetPointerMapping dpy 0 3)))
		(IF (not (equal? vals (list 1 2 3))) (snd-display ";XGetPointerMapping: ~A" vals)))
	      (|XGetScreenSaver dpy)
	      (|XMoveWindow dpy win 100 10)
	      (|XSync dpy #f)
	      (|XResizeWindow dpy win 400 400)
	      (|XSync dpy #f)
	      (|XMoveResizeWindow dpy win 120 20 500 500)
	      (|XSync dpy #f)
	      (let ((attr (|XGetWindowAttributes dpy win)))
		(IF (> (abs (- (|x attr) 120)) 200) (snd-display ";XMoveWindow x etc: ~A" (|x attr)))
		(IF (> (abs (- (|y attr) 20)) 200) (snd-display ";XMoveWindow y etc: ~A" (|y attr)))
		(IF (> (abs (- (|width attr) 500)) 20) (snd-display ";XMoveWindow width etc: ~A" (|width attr)))
		(IF (> (abs (- (|height attr) 500)) 20) (snd-display ";XMoveWindow height etc: ~A" (|height attr)))
		(IF (not (= (|border_width attr) 0)) (snd-display ";XGetWindowAttributes border_width: ~A" (|border_width attr)))
		(IF (not (= (|depth attr) 24)) (snd-display ";XGetWindowAttributes depth: ~A" (|depth attr)))
		(IF (not (= (|bit_gravity attr) 0)) (snd-display ";XGetWindowAttributes bit_gravity: ~A" (|bit_gravity attr)))
		(IF (not (= (|win_gravity attr) 1)) (snd-display ";XGetWindowAttributes win_gravity: ~A" (|win_gravity attr)))
		(IF (|backing_store attr) (snd-display ";XGetWindowAttributes backing_store: ~A" (|backing_store attr)))
		(IF (|override_redirect attr) (snd-display ";XGetWindowAttributes override_redirect: ~A" (|override_redirect attr)))
		(IF (|save_under attr) (snd-display ";XGetWindowAttributes save_under: ~A" (|save_under attr)))
		(IF (not (|map_installed attr)) (snd-display ";XGetWindowAttributes map_installed: ~A" (|map_installed attr)))
		(IF (not (= (|backing_pixel attr) 0)) (snd-display ";XGetWindowAttributes backing_pixel: ~A" (|backing_pixel attr)))
		(IF (not (= (|map_state attr) 2)) (snd-display ";XGetWindowAttributes map_state: ~A" (|map_state attr)))
		(IF (not (= (|your_event_mask attr) #x628033)) (snd-display ";your_event_mask: ~X" (|your_event_mask attr)))
		(IF (not (= (|all_event_masks attr) #xe28033)) (snd-display ";all_event_masks: ~X" (|all_event_masks attr)))
		(IF (not (|Screen? (|screen attr))) (snd-display ";XGetWindowAttributes screen: ~A" (|screen attr)))
		(IF (not (= (|do_not_propagate_mask attr) 0)) (snd-display ";XGetWindowAttributes do_not_propagate_mask: ~A" (|do_not_propagate_mask attr)))
		(IF (|save_under attr) (snd-display ";XGetWindowAttributes save_under ~A" (|save_under attr)))
		(IF (not (= (|backing_pixel attr) 0)) (snd-display ";XGetWindowAttributes backing_pixel: ~A" (|backing_pixel attr)))
		(IF (not (= (|backing_planes attr) |AllPlanes)) (snd-display ";XGetWindowAttributes backing_planes: ~A" (|backing_planes attr)))
		(IF (not (= (|win_gravity attr) 1)) (snd-display ";XGetWindowAttributes win_gravity: ~A" (|win_gravity attr)))
		(IF (not (= (|bit_gravity attr) 0)) (snd-display ";XGetWindowAttributes bit_gravity: ~A" (|bit_gravity attr))))
	      (|XResetScreenSaver dpy)
	      (IF (< (|XPending dpy) 0) (snd-display ";XPending: ~A" (|XPending dpy)))
	      (|XNoOp dpy)
	      (|XQueryBestStipple dpy win 100 100)
	      (|XQueryBestTile dpy win 100 100)
	      (|XQueryBestSize dpy 0 win 100 100)
	      (let ((ext (|XQueryExtension dpy "SHAPE")))
		(IF (not (eq? (car ext) #t))
		    (snd-display ";XQueryExtension: ~A" ext)))
	      (|XQueryKeymap dpy)
	      (let ((tree (|XQueryTree dpy win)))
		(IF (or (not (= (car tree) 1))
			(not (equal? (|XRootWindow dpy 0) (cadr tree))))
		    (snd-display ";XQueryTree: ~A (~A)" tree (|XRootWindow dpy 0))))

	      (IF (< (|XQLength dpy) 0) (snd-display ";XQLength: ~A" (|XQLength dpy)))
	      (IF (not (= (|XScreenCount dpy) 1)) (snd-display ";XScreenCount: ~A" (|XScreenCount dpy)))
	      (IF (not (string=? (|XServerVendor dpy) "The XFree86 Project, Inc")) (snd-display ";XServerVendor: ~A" (|XServerVendor dpy)))
	      (IF (not (= (|XProtocolRevision dpy) 0)) (snd-display ";XProtocolRevision: ~A" (|XProtocolRevision dpy)))
	      (IF (not (= (|XProtocolVersion dpy) 11)) (snd-display ";XProtocolVersion: ~A" (|XProtocolVersion dpy)))
	      (IF (not (number? (|XVendorRelease dpy))) (snd-display ";XVendorRelease: ~A" (|XVendorRelease dpy)))
	      (IF (not (string=? (|XDisplayString dpy) ":0.0")) (snd-display ";XDisplayString: ~A" (|XDisplayString dpy)))
	      (IF (not (= (|XBitmapUnit dpy) 32)) (snd-display ";XBitmapUnit: ~A" (|XBitmapUnit dpy)))
	      (IF (not (= (|XBitmapPad dpy) 32)) (snd-display ";XBitmapPad: ~A" (|XBitmapPad dpy)))
	      (IF (not (= (|XBitmapBitOrder dpy) 0)) (snd-display ";XBitmapBitOrder: ~A" (|XBitmapBitOrder dpy)))
	      (IF (not (= (|XImageByteOrder dpy) 0)) (snd-display ";XImageByteOrder: ~A" (|XImageByteOrder dpy)))
	      (IF (not (= (|XDefaultScreen dpy) 0)) (snd-display ";XDefaultScreen: ~A" (|XDefaultScreen dpy)))
	      (IF (|XGetIconSizes dpy win) (snd-display ";XGetIconSizes: ~A" (|XGetIconSizes dpy win)))
	      (IF (|XGetStandardColormap dpy win |XA_RGB_DEFAULT_MAP)
		  (snd-display "XGetStandardColormap: ~A!" (|XGetStandardColormap dpy win |XA_RGB_DEFAULT_MAP)))
	      (IF (|XGetRGBColormaps dpy win |XA_RGB_DEFAULT_MAP)
		  (snd-display "XGetRGBColormaps: ~A!" (|XGetRGBColormaps dpy win |XA_RGB_DEFAULT_MAP)))
	      (let ((cmap (|XAllocStandardColormap)))
		(for-each 
		 (lambda (func name)
		   (IF (not (= (func cmap) 0)) (snd-display ";standardcolormap ~A: ~A" name (func cmap))))
		 (list |base_pixel |visualid |red_max |red_mult |green_max |green_mult |blue_max |blue_mult)
		 (list 'base_pixel 'visualid 'red_max 'red_mult 'green_max 'green_mult 'blue_max 'blue_mult))
		(IF (|colormap cmap) (snd-display ";colormap: ~A" (|colormap cmap))))
	      (let ((icon (|XAllocIconSize)))
		(for-each
		 (lambda (func name)
		   (IF (not (= (func icon) 0)) (snd-display ";iconsize ~A: ~A" name (func icon))))
		 (list |min_width |min_height |max_width |max_height |width_inc |height_inc)
		 (list 'min_width 'min_height 'max_width 'max_height 'width_inc 'height_inc)))
			  
	      (let ((fs (|XCreateFontSet dpy "*-*-*-*-Normal-*-180-100-100-*-*")))
		(IF (or (not (|XFontSet? fs))
			(= (cadr fs) 0))
		    (snd-display ";XCreateFontSet: ~A" fs)
		    (let* ((fnts (|XFontsOfFontSet fs))
			   (fnt (caar fnts)))
		      (IF (not (|XFontStruct? fnt))
			  (snd-display ";XFontsOfFontSet: ~A" fnts))
		      (IF (|XContextualDrawing fs)
			  (snd-display ";XContextualDrawing: ~A" (|XContextualDrawing fs)))
		      (IF (|XContextDependentDrawing fs)
			  (snd-display ";XContextDependentDrawing: ~A" (|XContextDependentDrawing fs)))
		      (IF (|XDirectionalDependentDrawing fs)
			  (snd-display ";XDirectionalDependentDrawing: ~A" (|XDirectionalDependentDrawing fs)))
		      (IF (not (string=? (|XLocaleOfFontSet fs) "en_US"))
			  (snd-display ";XLocaleOfFontSet: ~A" (|XLocaleOfFontSet fs)))
		      (IF (not (string=? (|XBaseFontNameListOfFontSet fs) "*-*-*-*-Normal-*-180-100-100-*-*"))
			  (snd-display ";XBaseFontNameListOfFontSet: ~A" (|XBaseFontNameListOfFontSet fs)))
		      (let ((wgt (|XGetFontProperty fnt |XA_WEIGHT))
			    (siz (|XGetFontProperty fnt |XA_POINT_SIZE)))
			(IF (or (not (= (cadr wgt) 10))
				(not (= (cadr siz) 180)))
			    (snd-display ";XGetFontProperty: ~A ~A" wgt siz)))
		      (IF (not (= (|descent fnt) 5)) (snd-display ";descent: ~A" (|descent fnt)))
		      (IF (not (= (|ascent fnt) 18)) (snd-display ";ascent: ~A" (|ascent fnt)))
		      (IF (not (|XCharStruct? (|per_char fnt))) (snd-display ";per_char: ~A" (|per_char fnt)))
		      (IF (not (|XCharStruct? (|max_bounds fnt))) (snd-display ";max_bounds: ~A" (|max_bounds fnt)))
		      (IF (not (|XCharStruct? (|min_bounds fnt))) (snd-display ";min_bounds: ~A" (|min_bounds fnt)))
		      (IF (not (|XFontProp? (|properties fnt))) (snd-display ";properties ~A" (|properties fnt)))
		      (|XFreeFontSet dpy fs))))

	      (|XBell dpy 10)
	      (let ((cmd (|XGetCommand dpy win)))
		(IF (or (not (> (length cmd) 0))
			(not (string=? (car cmd) "./snd")))
		  (snd-display ";XGetCommand: ~A" cmd)))
	      (|XSetCommand dpy win (list "hiho" "away") 2)
	      (IF (not (equal? (|XGetCommand dpy win) (list "hiho" "away"))) 
		  (snd-display ";XSetCommand: ~A" (|XGetCommand dpy win)))
	      (let ((wmp (map (lambda (w) (|XGetAtomName dpy w)) (|XGetWMProtocols dpy win))))
		(IF (not (equal? wmp (list "_MOTIF_WM_MESSAGES" "WM_DELETE_WINDOW")))
		    (snd-display ";XGetWMProtocols: ~A" wmp)))
	      (IF (not (equal? (|XListDepths dpy 0) (list 24 1 4 8 15 16 32)))
		  (snd-display ";XListDepths: ~A" (|XListDepths dpy 0)))
	      (IF (not (equal? (|XListPixmapFormats dpy) '((1 1 32) (4 8 32) (8 8 32) (15 16 32) (16 16 32) (24 32 32) (32 32 32))))
		  (snd-display ";XListPixmapFormats: ~A" (|XListPixmapFormats dpy)))

	      (let ((cs (|XQueryBestCursor dpy win 10 10)))
		(IF (not (equal? cs (list 1 32 32))) (snd-display ";XQueryBestCursor: ~A" cs)))
	      (let ((pt (|XQueryPointer dpy win)))
		(IF (not (|Window? (cadr pt))) (snd-display ";XQueryPointer: ~A" pt)))
	      (|XRaiseWindow dpy win)
	      (|XRotateBuffers dpy 1)
	      (|XSetWindowBorderWidth dpy win 10)
	      (let ((hints (|XGetWMHints dpy win)))
		(IF (or (not hints) (not (|XWMHints? hints))) (snd-display ";XGetWMHints?"))
		(IF (not (= (|flags hints) 7)) (snd-display ";flags wmhints: ~A" (|flags hints)))
		(IF (not (= (|initial_state hints) 1)) (snd-display ";initial_state wmhints: ~A" (|initial_state hints)))
		(IF (not (|input hints)) (snd-display ";input wmhints: ~A" (|input hints)))
		(IF (not (|Pixmap? (|icon_pixmap hints))) (snd-display ";icon_pixmap wmhints: ~A" (|icon_pixmap hints)))
		(IF (|icon_window hints) (snd-display ";icon_window: ~A" (|icon_window hints)))
		(IF (not (= (|icon_x hints) -1)) (snd-display ";icon_x wmhints: ~A" (|icon_x hints)))
		(IF (not (= (|icon_y hints) -1)) (snd-display ";icon_y wmhints: ~A" (|icon_y hints)))
		(IF (not (equal? (|icon_mask hints) (list 'Pixmap 0))) (snd-display ";icon_mask: ~A" (|icon_mask hints)))
		(IF (not (number? (|window_group hints))) (snd-display ";window_group: ~A" (|window_group hints)))
		(IF (not (|XWMHints? (|XAllocWMHints))) (snd-display ";XAllocWMHints: ~A" (|XAllocWMHints)))))

	    (IF (not (|IsKeypadKey (list 'KeySym |XK_KP_Space))) (snd-display ";IsKeypadKey kp-space"))
	    (IF (|IsKeypadKey (list 'KeySym |XK_A)) (snd-display ";IsKeypadKey A"))
	    (IF (|IsPrivateKeypadKey (list 'KeySym |XK_A)) (snd-display ";IsPrivateKeypadKey A"))
	    (IF (not (|IsCursorKey (list 'KeySym |XK_Home))) (snd-display ";IsCursorKey Home"))
	    (IF (|IsCursorKey (list 'KeySym |XK_S)) (snd-display ";IsCursorKey S"))
	    (IF (not (|IsPFKey (list 'KeySym |XK_KP_F1))) (snd-display ";IsPFKey F1"))
	    (IF (|IsPFKey (list 'KeySym |XK_S)) (snd-display ";IsPFKey S"))
	    (IF (not (|IsFunctionKey (list 'KeySym |XK_F1))) (snd-display ";IsFunctionKey F1"))
	    (IF (|IsFunctionKey (list 'KeySym |XK_S)) (snd-display ";IsFunctionKey S"))
	    (IF (not (|IsMiscFunctionKey (list 'KeySym |XK_Select))) (snd-display ";IsMiscFunctionKey Select"))
	    (IF (|IsMiscFunctionKey (list 'KeySym |XK_S)) (snd-display ";IsMiscFunctionKey S"))
	    (IF (not (|IsModifierKey (list 'KeySym |XK_Shift_L))) (snd-display ";IsModifierKey Shift"))
	    (IF (|IsModifierKey (list 'KeySym |XK_S)) (snd-display ";IsModifierKey S"))

	    (let* ((scr (current-screen))
		   (scrn (|XScreenNumberOfScreen scr))
		   (dpy (|XtDisplay (cadr (main-widgets))))
		   (val (|XGCValues))
		   (wn (|XtWindow (cadr (main-widgets)))))
	      (set! (|function val) |GXclear)
	      (IF (not (equal? (|function val) |GXclear))
		  (snd-display ";function: ~A ~A" (|function val) |GXclear))
	      (set! (|line_width val) 10)
	      (IF (not (equal? (|line_width val) 10)) 
		  (snd-display ";line_width: ~A ~A" (|line_width val) 10))
	      (set! (|line_style val) |LineSolid)
	      (IF (not (equal? (|line_style val) |LineSolid)) 
		  (snd-display ";line_style: ~A ~A" (|line_style val) |LineSolid))
	      (set! (|background val) (|WhitePixelOfScreen (current-screen)))
	      (IF (not (equal? (|background val) (|WhitePixelOfScreen (current-screen)))) 
		  (snd-display ";background: ~A ~A" (|background val) (|WhitePixelOfScreen (current-screen))))
	      (set! (|foreground val) (|BlackPixelOfScreen (current-screen)))
	      (IF (not (equal? (|foreground val) (|BlackPixelOfScreen (current-screen)))) 
		  (snd-display ";foreground: ~A ~A" (|foreground val) (|BlackPixelOfScreen (current-screen))))
	      ;; plane_mask?
	      (set! (|cap_style val) |CapRound)
	      (IF (not (equal? (|cap_style val) |CapRound)) 
		  (snd-display ";cap_style: ~A ~A" (|cap_style val) |CapRound))
	      (set! (|join_style val) |JoinMiter)
	      (IF (not (equal? (|join_style val) |JoinMiter)) 
		  (snd-display ";join_style: ~A ~A" (|join_style val) |JoinMiter))
	      (set! (|fill_style val) |FillSolid)
	      (IF (not (equal? (|fill_style val) |FillSolid)) 
		  (snd-display ";fill_style: ~A ~A" (|fill_style val) |FillSolid))
	      (set! (|fill_rule val) |EvenOddRule)
	      (IF (not (equal? (|fill_rule val) |EvenOddRule)) 
		  (snd-display ";fill_rule: ~A ~A" (|fill_rule val) |EvenOddRule))
	      (set! (|arc_mode val) |ArcChord)
	      (IF (not (equal? (|arc_mode val) |ArcChord))
		  (snd-display ";arc_mode: ~A ~A" (|arc_mode val) |ArcChord))
	      ;; tile stipple clip_mask are Pixmaps
	      (set! (|ts_x_origin val) 1)
	      (IF (not (equal? (|ts_x_origin val) 1)) 
		  (snd-display ";ts_x_origin: ~A ~A" (|ts_x_origin val) 1))
	      (set! (|ts_y_origin val) 1)
	      (IF (not (equal? (|ts_y_origin val) 1)) 
		  (snd-display ";ts_y_origin: ~A ~A" (|ts_y_origin val) 1))
	      ;; font is Font
	      (set! (|subwindow_mode val) |ClipByChildren)
	      (IF (not (equal? (|subwindow_mode val) |ClipByChildren)) 
		  (snd-display ";subwindow_mode: ~A ~A" (|subwindow_mode val) |ClipByChildren))
	      (set! (|graphics_exposures val) #f)
	      (IF (not (equal? (|graphics_exposures val) #f)) 
		  (snd-display ";graphics_exposures: ~A ~A" (|graphics_exposures val) #f))
	      (set! (|clip_x_origin val) 0)
	      (IF (not (equal? (|clip_x_origin val) 0)) 
		  (snd-display ";clip_x_origin: ~A ~A" (|clip_x_origin val) 0))
	      (set! (|clip_y_origin val) 0)
	      (IF (not (equal? (|clip_y_origin val) 0)) 
		  (snd-display ";clip_y_origin: ~A ~A" (|clip_y_origin val) 0))
	      (set! (|dash_offset val) 1)
	      (IF (not (equal? (|dash_offset val) 1))
		  (snd-display ";dash_offset: ~A ~A" (|dash_offset val) 1))
	      (IF (not (number? (|XConnectionNumber dpy)))
		  (snd-display ";XConnectionNumber: ~A" (|XConnectionNumber dpy)))
	      
	      (let ((gc (|XCreateGC dpy wn (+ |GCFunction |GCForeground |GCBackground |GCLineWidth |GCLineStyle 
					      |GCCapStyle |GCJoinStyle |GCFillStyle |GCFillRule |GCTileStipXOrigin
					      |GCTileStipYOrigin |GCSubwindowMode |GCGraphicsExposures |GCClipXOrigin
					      |GCClipYOrigin |GCDashOffset |GCArcMode)
				    val)))
		
		(IF (not (|GC? gc)) (snd-display ";XCreateGC returned ~A" gc))
		(|XSetArcMode dpy gc |ArcPieSlice)
		(|XSetFunction dpy gc |GXcopy)
		(|XSetLineAttributes dpy gc 3 |LineDoubleDash |CapButt |JoinMiter)
		(|XSetClipOrigin dpy gc 1 1)
		(|XSetTSOrigin dpy gc 0 0)
		(|XSetFillRule dpy gc |WindingRule)
		(|XSetFillStyle dpy gc |FillStippled)
		(|XSetForeground dpy gc (|WhitePixelOfScreen (current-screen)))
		(|XSetBackground dpy gc (|BlackPixelOfScreen (current-screen)))
		(|XSetGraphicsExposures dpy gc #t)
		(|XSetSubwindowMode dpy gc |IncludeInferiors)
		(IF (not (string=? "unix/:7100" (car (|XGetFontPath dpy))))
		    (snd-display ";XGetFontPath: ~A" (|XGetFontPath dpy)))
		(let ((owner (|XGetSelectionOwner dpy |XA_PRIMARY)))
		  (IF (and owner (not (|Window? owner)))
		      (snd-display ";XGetSelectionOwner: ~A" owner)))
		(let ((mods (|XGetModifierMapping dpy)))
		  (IF (not (|XModifierKeymap? mods))
		      (snd-display ";XGetModifierMapping: ~A" mods)))
		(let ((vis (|XGetVisualInfo dpy 0 (list 'XVisualInfo 0))))
		  (IF (or (not vis)
			  (not (|XVisualInfo? (car vis))))
		      (snd-display ";XGetVisualInfo: ~A" vis))
		  (IF (not (= (|depth (car vis)) 24)) (snd-display ";depth vis: ~A" (|depth (car vis))))
		  (IF (not (= (|screen (car vis)) 0)) (snd-display ";screen vis: ~A" (|screen (car vis))))
		  (IF (not (= (|class (car vis)) |TrueColor)) (snd-display ";class vis: ~A (~A)" (|class (car vis)) |TrueColor))
		  (IF (not (= (|colormap_size (car vis)) 256)) (snd-display ";colormap_size vis: ~A" (|colormap_size (car vis))))
		  (IF (not (|XVisualInfo? (|XMatchVisualInfo dpy 0 24 |TrueColor)))
		      (snd-display ";XMatchVisualInfo: ~A" (|XMatchVisualInfo dpy 0 24 |TrueColor))))

		(let ((cursor (|XCreateFontCursor dpy |XC_circle)))
		  (IF (not (|Cursor? cursor)) 
		      (snd-display ";XCreateFontCursor: ~A" cursor)
		      (begin
			(|XDefineCursor dpy wn cursor)
			(|XUndefineCursor dpy wn)
			(let ((old (|XmGetMenuCursor dpy)))
			  (IF (not (|Cursor? old)) (snd-display ";XmGetMenuCursor: ~A" old))
			  (|XmSetMenuCursor dpy cursor)
			  (IF (not (equal? cursor (|XmGetMenuCursor dpy))) (snd-display ";XmSetMenuCursor: ~A ~A" cursor (|XmGetMenuCursor dpy)))
			  (|XmSetMenuCursor dpy old)))))

		(let* ((vals (|XGetGCValues dpy gc (+ |GCFunction |GCForeground |GCBackground |GCLineWidth |GCLineStyle 
						      |GCCapStyle |GCJoinStyle |GCFillStyle |GCFillRule |GCTileStipXOrigin
						      |GCTileStipYOrigin |GCSubwindowMode |GCGraphicsExposures |GCClipXOrigin
						      |GCClipYOrigin |GCDashOffset |GCArcMode)))
		       (val1 (cadr vals)))
		  (IF (= (car vals) 0)
		      (snd-display ";XGetGCValues failed"))
		  
		  (IF (not (equal? (|function val1) |GXcopy))
		      (snd-display ";function: ~A ~A" (|function val1) |GXcopy))
		  (IF (not (equal? (|line_width val1) 3)) 
		      (snd-display ";line_width: ~A ~A" (|line_width val1) 3))
		  (IF (not (equal? (|line_style val1) |LineDoubleDash)) 
		      (snd-display ";line_style: ~A ~A" (|line_style val1) |LineDoubleDash))
		  (IF (not (equal? (|background val1) (|BlackPixelOfScreen (current-screen)))) 
		      (snd-display ";background: ~A ~A" (|background val1) (|BlackPixelOfScreen (current-screen))))
		  (IF (not (equal? (|foreground val1) (|WhitePixelOfScreen (current-screen)))) 
		      (snd-display ";foreground: ~A ~A" (|foreground val1) (|WhitePixelOfScreen (current-screen))))
		  (IF (not (equal? (|cap_style val1) |CapButt)) 
		      (snd-display ";cap_style: ~A ~A" (|cap_style val1) |CapButt))
		  (IF (not (equal? (|join_style val1) |JoinMiter)) 
		      (snd-display ";join_style: ~A ~A" (|join_style val1) |JoinMiter))
		  (IF (not (equal? (|fill_style val1) |FillStippled)) 
		      (snd-display ";fill_style: ~A ~A" (|fill_style val1) |FillStippled))
		  (IF (not (equal? (|fill_rule val1) |WindingRule)) 
		      (snd-display ";fill_rule: ~A ~A" (|fill_rule val1) |WindingRule))
		  (IF (not (equal? (|arc_mode val1) |ArcPieSlice))
		      (snd-display ";arc_mode: ~A ~A" (|arc_mode val1) |ArcPieSlice))
		  (IF (not (equal? (|ts_x_origin val1) 0)) 
		      (snd-display ";ts_x_origin: ~A ~A" (|ts_x_origin val1) 0))
		  (IF (not (equal? (|ts_y_origin val1) 0)) 
		      (snd-display ";ts_y_origin: ~A ~A" (|ts_y_origin val1) 0))
		  (IF (not (equal? (|subwindow_mode val1) |IncludeInferiors)) 
		      (snd-display ";subwindow_mode: ~A ~A" (|subwindow_mode val1) |IncludeInferiors))
		  (IF (not (equal? (|graphics_exposures val1) #t)) 
		      (snd-display ";graphics_exposures: ~A ~A" (|graphics_exposures val1) #t))
		  (IF (not (equal? (|clip_x_origin val1) 1)) 
		      (snd-display ";clip_x_origin: ~A ~A" (|clip_x_origin val1) 1))
		  (IF (not (equal? (|clip_y_origin val1) 1)) 
		      (snd-display ";clip_y_origin: ~A ~A" (|clip_y_origin val1) 1))
		  (IF (not (equal? (|dash_offset val1) 1))
		      (snd-display ";dash_offset: ~A ~A" (|dash_offset val1) 1))

		  (set! (|plane_mask val) 0)
		  (IF (not (equal? (|plane_mask val) 0)) 
		      (snd-display ";plane_mask: ~A ~A" (|plane_mask val) 0))
		  (set! (|tile val) (list 'Pixmap 0))
		  (IF (not (equal? (|tile val) (list 'Pixmap 0)))
		      (snd-display ";tile: ~A" (|tile val)))
		  (set! (|stipple val) (list 'Pixmap 0))
		  (IF (not (equal? (|stipple val) (list 'Pixmap 0)))
		      (snd-display ";stipple: ~A" (|stipple val)))

		  (let* ((dpy (|XtDisplay (cadr (main-widgets))))
			 (win (|XtWindow (cadr (main-widgets))))
			 (newwin (|XCreateWindow dpy win 10 10 100 100 3 
						 |CopyFromParent |InputOutput (list 'Visual |CopyFromParent)
						 (logior |CWBackPixel |CWBorderPixel)
						 (|XSetWindowAttributes #f (snd-pixel (basic-color)) #f (snd-pixel (highlight-color))))))
		    (IF (not (|Window? newwin)) (snd-display ";XCreateWindow: ~A" newwin))
		    (|XChangeWindowAttributes dpy newwin (logior |CWBackPixel) (|XSetWindowAttributes #f (snd-pixel (basic-color))))
		    (|XDestroyWindow dpy newwin)
		    (set! newwin (|XCreateSimpleWindow dpy win 10 10 100 100 3 (snd-pixel (basic-color)) (snd-pixel (highlight-color))))
		    (|XDestroyWindow dpy newwin))

		  (|XSetRegion dpy gc (|XPolygonRegion (list (|XPoint 0 0) (|XPoint 10 0) (|XPoint 10 10) (|XPoint 0 10)) 4 |WindingRule))
		  (let ((pix (make-pixmap (cadr (main-widgets)) arrow-strs)))
		    (IF (not (|Pixmap? pix)) 
			(snd-display ";make-pixmap?")
			(begin
			  (|XSetTile dpy gc pix)
			  ;(|XSetStipple dpy gc pix) -- needs depth 1 I think
			  (|XSetState dpy gc (snd-pixel (basic-color)) (snd-pixel (mark-color)) |GXcopy 0)
			  (|XSetPlaneMask dpy gc 0)
			  (|XSetDashes dpy gc 0 '(3 4 3 1))
			  (|XSetClipRectangles dpy gc 0 0 (list (|XRectangle 0 0 10 10) (|XRectangle 10 10 100 100)) 2 |Unsorted)
			  (let ((err (|XWriteBitmapFile dpy "test.data" pix 16 12 -1 -1)))
			    (if (not (= |BitmapSuccess err)) (snd-display ";XWriteBitmapFile: ~A" err)))
			  ;(let ((vals (|XReadBitmapFile dpy (|XtWindow (cadr (main-widgets))) "test.data")))
			  ;  (if (not (= (car vals |BitmapSuccess))) (snd-display ";XReadBitmapFile: ~A" vals)))
			  ;(let ((vals (|XReadBitmapFileData "test.data")))
			  ;  (if (not (= (car vals |BitmapSuccess))) (snd-display ";XReadBitmapFileData: ~A" vals)))
			  )))
		  (let* ((fid (|XLoadFont dpy "-adobe-times-medium-r-*-*-14-*-*-*-*-*-*-*"))
			 (fnt (|XLoadQueryFont dpy "-adobe-times-medium-r-*-*-14-*-*-*-*-*-*-*"))
			 (chs (|XQueryTextExtents dpy fid "hiho"))
			 (struct (list-ref chs 4))
			 (fnt1 (|XQueryFont dpy fid)))
		    (IF (not (|Font? fid)) (snd-display ";XLoadFont: ~A" fid))
		    (IF (not (|XFontStruct? fnt)) (snd-display ";XLoadQueryFont: ~A" fnt))
		    (IF (not (|XFontStruct? fnt1)) (snd-display ";XQueryFont: ~A" fnt1))
		    (IF (not (|XCharStruct? struct)) (snd-display ";XQueryTextExtents: ~A" chs))
		    (IF (not (= (list-ref chs 2) 12)) (snd-display ";XQueryTextExtents max ascent: ~A" (list-ref chs 2)))
		    (IF (not (= (list-ref chs 3) 3)) (snd-display ";XQueryTextExtents max descent: ~A" (list-ref chs 3)))
		    (IF (not (= (|lbearing struct) 0)) (snd-display ";lbearing: ~A" (|lbearing struct)))
		    (IF (not (= (|rbearing struct) 23)) (snd-display ";rbearing: ~A" (|rbearing struct)))
		    (IF (not (= (|width struct) 24)) (snd-display ";width: ~A" (|width struct)))
		    (IF (not (= (|ascent struct) 10)) (snd-display ";ascent: ~A" (|ascent struct)))
		    (IF (not (= (|descent struct) 0)) (snd-display ";descent: ~A" (|descent struct)))
		    (IF (not (= (|attributes struct) 0)) (snd-display ";attributes: ~A" (|attributes struct)))
		    )
		  )))
	    
	    (let ((atoms (list |XA_PRIMARY |XA_SECONDARY |XA_ARC |XA_ATOM |XA_BITMAP |XA_CARDINAL |XA_COLORMAP |XA_CURSOR |XA_CUT_BUFFER0
			       |XA_CUT_BUFFER1 |XA_CUT_BUFFER2 |XA_CUT_BUFFER3 |XA_CUT_BUFFER4 |XA_CUT_BUFFER5 |XA_CUT_BUFFER6
			       |XA_CUT_BUFFER7 |XA_DRAWABLE |XA_FONT |XA_INTEGER |XA_PIXMAP |XA_POINT |XA_RECTANGLE |XA_RESOURCE_MANAGER
			       |XA_RGB_COLOR_MAP |XA_RGB_BEST_MAP |XA_RGB_BLUE_MAP |XA_RGB_DEFAULT_MAP |XA_RGB_GRAY_MAP |XA_RGB_GREEN_MAP
			       |XA_RGB_RED_MAP |XA_STRING |XA_VISUALID |XA_WINDOW |XA_WM_COMMAND |XA_WM_HINTS |XA_WM_CLIENT_MACHINE
			       |XA_WM_ICON_NAME |XA_WM_ICON_SIZE |XA_WM_NAME |XA_WM_NORMAL_HINTS |XA_WM_SIZE_HINTS |XA_WM_ZOOM_HINTS
			       |XA_MIN_SPACE |XA_NORM_SPACE |XA_MAX_SPACE |XA_END_SPACE |XA_SUPERSCRIPT_X |XA_SUPERSCRIPT_Y
			       |XA_SUBSCRIPT_X |XA_SUBSCRIPT_Y |XA_UNDERLINE_POSITION |XA_UNDERLINE_THICKNESS |XA_STRIKEOUT_ASCENT
			       |XA_STRIKEOUT_DESCENT |XA_ITALIC_ANGLE |XA_X_HEIGHT |XA_QUAD_WIDTH |XA_WEIGHT |XA_POINT_SIZE
			       |XA_RESOLUTION |XA_COPYRIGHT |XA_NOTICE |XA_FONT_NAME |XA_FAMILY_NAME |XA_FULL_NAME |XA_CAP_HEIGHT
			       |XA_WM_CLASS |XA_WM_TRANSIENT_FOR))
		  (atom-names (list '|XA_PRIMARY '|XA_SECONDARY '|XA_ARC '|XA_ATOM '|XA_BITMAP '|XA_CARDINAL '|XA_COLORMAP '|XA_CURSOR '|XA_CUT_BUFFER0
				    '|XA_CUT_BUFFER1 '|XA_CUT_BUFFER2 '|XA_CUT_BUFFER3 '|XA_CUT_BUFFER4 '|XA_CUT_BUFFER5 '|XA_CUT_BUFFER6
				    '|XA_CUT_BUFFER7 '|XA_DRAWABLE '|XA_FONT '|XA_INTEGER '|XA_PIXMAP '|XA_POINT '|XA_RECTANGLE '|XA_RESOURCE_MANAGER
				    '|XA_RGB_COLOR_MAP '|XA_RGB_BEST_MAP '|XA_RGB_BLUE_MAP '|XA_RGB_DEFAULT_MAP '|XA_RGB_GRAY_MAP '|XA_RGB_GREEN_MAP
				    '|XA_RGB_RED_MAP '|XA_STRING '|XA_VISUALID '|XA_WINDOW '|XA_WM_COMMAND '|XA_WM_HINTS '|XA_WM_CLIENT_MACHINE
				    '|XA_WM_ICON_NAME '|XA_WM_ICON_SIZE '|XA_WM_NAME '|XA_WM_NORMAL_HINTS '|XA_WM_SIZE_HINTS '|XA_WM_ZOOM_HINTS
				    '|XA_MIN_SPACE '|XA_NORM_SPACE '|XA_MAX_SPACE '|XA_END_SPACE '|XA_SUPERSCRIPT_X '|XA_SUPERSCRIPT_Y
				    '|XA_SUBSCRIPT_X '|XA_SUBSCRIPT_Y '|XA_UNDERLINE_POSITION '|XA_UNDERLINE_THICKNESS '|XA_STRIKEOUT_ASCENT
				    '|XA_STRIKEOUT_DESCENT '|XA_ITALIC_ANGLE '|XA_X_HEIGHT '|XA_QUAD_WIDTH '|XA_WEIGHT '|XA_POINT_SIZE
				    '|XA_RESOLUTION '|XA_COPYRIGHT '|XA_NOTICE '|XA_FONT_NAME '|XA_FAMILY_NAME '|XA_FULL_NAME '|XA_CAP_HEIGHT
				    '|XA_WM_CLASS '|XA_WM_TRANSIENT_FOR)))
	      (for-each
	       (lambda (n name)
		 (IF (not (|Atom? n))
		     (snd-display ";Atom: ~A -> ~A" name (|Atom? n))))
	       atoms
	       atom-names))

	    (let ((r (|XRectangle 10 20 100 110)))
	      (IF (not (= (|width r) 100))
		  (snd-display ";XRectangle width: ~A" (|width r)))
	      (IF (not (= (|height r) 110))
		  (snd-display ";XRectangle height: ~A" (|height r)))
	      (IF (not (= (|x r) 10))
		  (snd-display ";XRectangle x: ~A" (|x r)))
	      (IF (not (= (|y r) 20))
		  (snd-display ";XRectangle y: ~A" (|y r)))
	      (set! (|width r) 10)
	      (IF (not (= (|width r) 10))
		  (snd-display ";set XRectangle width: ~A" (|width r)))
	      (set! (|height r) 11)
	      (IF (not (= (|height r) 11))
		  (snd-display ";set XRectangle height: ~A" (|height r)))
	      (set! (|x r) 1)
	      (IF (not (= (|x r) 1))
		  (snd-display ";set XRectangle x: ~A" (|x r)))
	      (set! (|y r) 2)
	      (IF (not (= (|y r) 2))
		  (snd-display ";XRectangle y: ~A" (|y r))))
	    
	    (let ((r (|XArc 10 20 100 110 0 235)))
	      (IF (not (= (|width r) 100))
		  (snd-display ";XArc width: ~A" (|width r)))
	      (IF (not (= (|height r) 110))
		  (snd-display ";XArc height: ~A" (|height r)))
	      (IF (not (= (|x r) 10))
		  (snd-display ";XArc x: ~A" (|x r)))
	      (IF (not (= (|y r) 20))
		  (snd-display ";XArc y: ~A" (|y r)))
	      (IF (not (= (|angle1 r) 0))
		  (snd-display ";XArc angle1: ~A" (|angle1 r)))
	      (IF (not (= (|angle2 r) 235))
		  (snd-display ";XArc angle2: ~A" (|angle2 r)))
	      (set! (|width r) 10)
	      (IF (not (= (|width r) 10))
		  (snd-display ";set XArc width: ~A" (|width r)))
	      (set! (|height r) 11)
	      (IF (not (= (|height r) 11))
		  (snd-display ";set XArc height: ~A" (|height r)))
	      (set! (|x r) 1)
	      (IF (not (= (|x r) 1))
		  (snd-display ";set XArc x: ~A" (|x r)))
	      (set! (|y r) 2)
	      (IF (not (= (|y r) 2))
		  (snd-display ";set XArc y: ~A" (|y r)))
	      (set! (|angle1 r) 123)
	      (IF (not (= (|angle1 r) 123))
		  (snd-display ";set XArc angle1: ~A" (|angle1 r)))
	      (set! (|angle2 r) 321)
	      (IF (not (= (|angle2 r) 321))
		  (snd-display ";set XArc angle2: ~A" (|angle2 r))))
	    
	    (let ((r (|XPoint 10 20)))
	      (IF (not (= (|x r) 10))
		  (snd-display ";XPoint x: ~A" (|x r)))
	      (IF (not (= (|y r) 20))
		  (snd-display ";XPoint y: ~A" (|y r)))
	      (set! (|x r) 1)
	      (IF (not (= (|x r) 1))
		  (snd-display ";set XPoint x: ~A" (|x r)))
	      (set! (|y r) 2)
	      (IF (not (= (|y r) 2))
		  (snd-display ";set XPoint y: ~A" (|y r))))
	    
	    (let ((r (|XSegment 10 20 100 110)))
	      (IF (not (= (|x1 r) 10))
		  (snd-display ";XSegment x1: ~A" (|x1 r)))
	      (IF (not (= (|y1 r) 20))
		  (snd-display ";XSegment y1: ~A" (|y1 r)))
	      (IF (not (= (|x2 r) 100))
		  (snd-display ";XSegment x2: ~A" (|x2 r)))
	      (IF (not (= (|y2 r) 110))
		  (snd-display ";XSegment y2: ~A" (|y2 r)))
	      (set! (|x1 r) 1)
	      (IF (not (= (|x1 r) 1))
		  (snd-display ";set XSegment x1: ~A" (|x1 r)))
	      (set! (|y1 r) 2)
	      (IF (not (= (|y1 r) 2))
		  (snd-display ";set XSegment y1: ~A" (|y1 r)))
	      (set! (|x2 r) 10)
	      (IF (not (= (|x2 r) 10))
		  (snd-display ";set XSegment x2: ~A" (|x2 r)))
	      (set! (|y2 r) 11)
	      (IF (not (= (|y2 r) 11))
		  (snd-display ";set XSegment y2: ~A" (|y2 r))))

	    (let ((c (|XColor)))
	      (set! (|red c) 1)
	      (IF (not (= (|red c) 1)) (snd-display ";Xcolor red: ~A" (|red c)))
	      (set! (|green c) 1)
	      (IF (not (= (|green c) 1)) (snd-display ";Xcolor green: ~A" (|green c)))
	      (set! (|blue c) 1)
	      (IF (not (= (|blue c) 1)) (snd-display ";Xcolor blue: ~A" (|blue c)))
	      (set! (|flags c) |DoRed)
	      (IF (not (= (|flags c) |DoRed)) (snd-display ";Xcolor flags: ~A" (|flags c)))
	      (IF (not (= (|pad c) 0)) (snd-display ";pad: ~A" (|pad c)))
	      (set! (|pixel c) (snd-pixel (basic-color)))
	      (IF (not (equal? (|pixel c) (snd-pixel (basic-color)))) (snd-display ";Xcolor pixel: ~A" (|pixel c))))

	    (let ((obj (|XTextItem "hiho" 4 3 (list 'Font 1))))
	      (IF (not (|XTextItem? obj)) (snd-display ";XTextItem -> ~A" obj))
	      (IF (not (equal? (|font obj) (list 'Font 1))) (snd-display ";font ~A" (|font obj)))
	      (set! (|font obj) (list 'Font 2))
	      (IF (not (equal? (|font obj) (list 'Font 2))) (snd-display ";set font ~A" (|font obj)))
	      (IF (not (string=? (|chars obj) "hiho")) (snd-display ";chars: ~A" (|chars obj)))
	      (IF (not (= (|nchars obj) 4)) (snd-display ";chars: ~A" (|nchars obj)))
	      (set! (|chars obj) "away!")
	      (set! (|nchars obj) 5)
	      (IF (not (string=? (|chars obj) "away!")) (snd-display ";set chars: ~A" (|chars obj)))
	      (IF (not (= (|nchars obj) 5)) (snd-display ";set chars: ~A" (|nchars obj)))
	      (IF (not (= (|delta obj) 3)) (snd-display ";delta ~A" (|delta obj)))
	      (set! (|delta obj) 4)
	      (IF (not (= (|delta obj) 4)) (snd-display ";set delta ~A" (|delta obj)))
	      )

	    (let ((reg (|XPolygonRegion (list (|XPoint 0 0) (|XPoint 10 0) (|XPoint 10 10) (|XPoint 0 10)) 4 |WindingRule)))
	      (IF (not (|XPointInRegion reg 4 4)) (snd-display ";XPointInRegion"))
	      (|XShrinkRegion reg 1 2)
	      (IF (not (|XPointInRegion reg 4 7)) (snd-display ";t XShrinkRegion"))
	      (IF (|XPointInRegion reg 4 9) (snd-display ";f XShrinkRegion"))
	      (|XOffsetRegion reg 1 2)
	      (IF (not (|XPointInRegion reg 4 9)) (snd-display ";t XOffsetRegion"))
	      (IF (|XPointInRegion reg 1 9) (snd-display ";f XOffsetRegion"))
	      (let ((reg2 (|XCreateRegion))
		    (reg1 (|XPolygonRegion (list (|XPoint 2 2) (|XPoint 10 2) (|XPoint 10 10) (|XPoint 2 10)) 4 |WindingRule)))
		(IF (|XEqualRegion reg reg1) (snd-display ";f XEqualRegion"))
		(IF (|XEmptyRegion reg) (snd-display ";f XEmptyRegion"))
		(|XXorRegion reg reg1 reg2)
		(let ((box (|XClipBox reg2)))
		  (IF (or (not (= (|x (cadr box)) 2))
			  (not (= (|y (cadr box)) 2))
			  (not (= (|width (cadr box)) 8))
			  (not (= (|height (cadr box)) 2)))
		      (snd-display ";XXorRegion: ~A ~A ~A ~A" (|x (cadr box)) (|y (cadr box)) (|width (cadr box)) (|height (cadr box)))))
		(|XUnionRegion reg reg1 reg2)
		(let ((box (|XClipBox reg2)))
		  (IF (or (not (= (|x (cadr box)) 2))
			  (not (= (|y (cadr box)) 2))
			  (not (= (|width (cadr box)) 8))
			  (not (= (|height (cadr box)) 8)))
		      (snd-display ";XUnionRegion: ~A ~A ~A ~A" (|x (cadr box)) (|y (cadr box)) (|width (cadr box)) (|height (cadr box)))))
		(|XSubtractRegion reg reg1 reg2)
		(let ((box (|XClipBox reg2)))
		  (IF (or (not (= (|x (cadr box)) 0))
			  (not (= (|y (cadr box)) 0))
			  (not (= (|width (cadr box)) 0))
			  (not (= (|height (cadr box)) 0)))
		      (snd-display ";XSubtractRegion: ~A ~A ~A ~A" (|x (cadr box)) (|y (cadr box)) (|width (cadr box)) (|height (cadr box)))))
		(|XIntersectRegion reg reg1 reg2)
		(let ((box (|XClipBox reg2)))
		  (IF (or (not (= (|x (cadr box)) 2))
			  (not (= (|y (cadr box)) 4))
			  (not (= (|width (cadr box)) 8))
			  (not (= (|height (cadr box)) 6)))
		  (snd-display ";XIntersectRegion: ~A ~A ~A ~A" (|x (cadr box)) (|y (cadr box)) (|width (cadr box)) (|height (cadr box)))))
		(|XUnionRectWithRegion (|XRectangle 1 3 100 100) reg1 reg2)
		(let ((box (|XClipBox reg2)))
		  (IF (or (not (= (|x (cadr box)) 1))
			  (not (= (|y (cadr box)) 2))
			  (not (= (|width (cadr box)) 100))
			  (not (= (|height (cadr box)) 101)))
		      (snd-display ";XUnionRectWithRegion: ~A ~A ~A ~A" (|x (cadr box)) (|y (cadr box)) (|width (cadr box)) (|height (cadr box)))))
		(|XRectInRegion reg 0 0 100 100)
		(let ((box (|XClipBox reg1)))
		  (IF (or (not (= (|x (cadr box)) 2))
			  (not (= (|y (cadr box)) 2))
			  (not (= (|width (cadr box)) 8))
			  (not (= (|height (cadr box)) 8)))
		      (snd-display ";XClipBox: ~A ~A ~A ~A" (|x (cadr box)) (|y (cadr box)) (|width (cadr box)) (|height (cadr box)))))
		(|XDestroyRegion reg1)
		))

	    (let ((xid (|XUniqueContext))
		  (dpy (|XtDisplay (cadr (main-widgets)))))
	      (IF (not (eq? (car xid) 'XContext))
		  (snd-display "XUniqueContext: ~A" xid))
	      (|XSaveContext dpy  123 xid "hiho")
	      (let ((val (|XFindContext dpy 123 xid)))
		(IF (or (not (= 0 (car val)))
			(not (string=? (cadr val) "hiho")))
		    (snd-display "XFindContext: ~A" val)))
	      (|XDeleteContext dpy 123 xid)
	      (|XStoreBytes dpy "hiho" 4)
	      (IF (not (string=? (|XFetchBytes dpy) "hiho")) (snd-display ";XStoreBytes: ~A" (|XFetchBytes dpy)))
	      (|XStoreBuffer dpy "hiho" 4 1)
	      (IF (not (string=? (|XFetchBuffer dpy 1) "hiho")) (snd-display ";XStoreBuffer: ~A" (|XFetchBuffer dpy)))
	      )


	    ;; ---------------- Xt tests ----------------
	    (let ((name (|XtGetApplicationNameAndClass (|XtDisplay (cadr (main-widgets))))))
	      (IF (not (equal? name (list "snd" "Snd")))
		  (snd-display ";XtGetApplicationNameAndClass: ~A?" name)))
	    (let ((dpys (|XtGetDisplays (car (main-widgets)))))
	      (IF (not (|Display? (car dpys)))
		  (snd-display ";XtGetDisplays: ~A?" dpys)))
	    (let ((time (|XtGetSelectionTimeout))
		  (time1 (|XtAppGetSelectionTimeout (car (main-widgets)))))
	      (IF (or (not (number? time))
		      (not (= time time1))
		      (< time 1))
		  (snd-display ";XtGetSelectionTimeout: ~A ~A?" time time1)))
	    (let ((app (|XtDisplayToApplicationContext (|XtDisplay (cadr (main-widgets)))))
		  (orig (car (main-widgets)))
		  (wid (|XtWidgetToApplicationContext (cadr (main-widgets)))))
	      (IF (not (equal? app orig))
		  (snd-display ";XtDisplayToApplicationContext: ~A ~A?" app orig))
	      (IF (not (equal? app wid))
		  (snd-display ";XtWidgetToApplicationContext: ~A ~A?" app wid)))
	    (IF (not (string=? (|XtName (caddr (main-widgets))) "mainpane"))
		(snd-display ";XtName main pane: ~A" (|XtName (caddr (main-widgets)))))
	    (IF (not (= (|XtGetMultiClickTime (|XtDisplay (cadr (main-widgets)))) 200))
		(snd-display ";XtGetMultiClickTime: ~A" (|XtGetMultiClickTime (|XtDisplay (cadr (main-widgets))))))
	    (|XtSetMultiClickTime (|XtDisplay (cadr (main-widgets))) 250)
	    (IF (not (= (|XtGetMultiClickTime (|XtDisplay (cadr (main-widgets)))) 250))
		(snd-display ";XtSetMultiClickTime: ~A" (|XtGetMultiClickTime (|XtDisplay (cadr (main-widgets))))))
	    
	    (let* ((shell (cadr (main-widgets)))
		   (wid (|XtCreateWidget "wid" |xmFormWidgetClass shell '()))
		   (wid1 (|XtCreateWidget "wid1" |xmPushButtonWidgetClass wid '()))
		   (wid2 (|XtVaCreateWidget "wid" |xmFormWidgetClass shell '())))
	      (IF (|XtIsApplicationShell wid) (snd-display ";XtIsApplicationShell"))
	      (IF (not (|XtIsApplicationShell shell)) (snd-display ";XtIsApplicationShell of appshell"))
	      (IF (not (|XtIsComposite wid)) (snd-display ";XtIsComposite"))
	      (IF (not (|XtIsConstraint wid)) (snd-display ";XtIsConstraint"))
	      (IF (|XtIsManaged wid) (snd-display ";XtIsManaged"))
	      (IF (not (|XtIsObject wid)) (snd-display ";XtIsObject"))
	      (IF (|XtIsOverrideShell wid) (snd-display ";XtIsOverrideShell"))
	      (IF (|XtIsRealized wid) (snd-display ";XtIsRealized"))
	      (IF (not (|XtIsRealized shell)) (snd-display ";XtIsRealized main shell"))
	      (IF (not (|XtIsRectObj wid)) (snd-display ";XtIsRectObj"))
	      (IF (not (|XtIsSensitive wid)) (snd-display ";XtIsSensitive"))
	      (IF (not (|XtIsSensitive shell)) (snd-display ";XtIsSensitive of main shell"))
	      (|XtSetSensitive wid1 #t)
	      (IF (not (|XtIsSensitive wid1)) (snd-display ";XtIsSensitive of button"))
	      (IF (|XtIsSessionShell wid) (snd-display ";XtIsSessionShell"))
	      (IF (|XtIsShell wid) (snd-display ";XtIsShell"))
	      (IF (not (|XtIsShell shell)) (snd-display ";XtIsShell of main shell"))
	      (IF (|XtIsTopLevelShell wid) (snd-display ";XtIsTopLevelShell"))
	      (IF (not (|XtIsTopLevelShell shell)) (snd-display ";XtIsTopLevelShell of main shell"))
	      (IF (|XtIsTransientShell wid) (snd-display ";XtIsTransientShell"))
	      (IF (|XtIsVendorShell wid) (snd-display ";XtIsVendorShell"))
	      (IF (not (|XtIsVendorShell shell)) (snd-display ";XtIsVendorShell of main shell"))
	      (IF (|XtIsWMShell wid) (snd-display ";XtIsWMShell"))
	      (IF (not (|XtIsWidget wid)) (snd-display ";XtIsWidget"))
	      (|XtRealizeWidget wid)
	      (IF (not (|XtIsRealized wid)) (snd-display ";XtRealizeWidget?"))
	      (|XtUnrealizeWidget wid)
	      (|XtDestroyWidget wid1))
	    (|XtAppWarningMsg (car (main-widgets)) "conversionError" "string" "hi" "oops" '() 0)
	    (|XtWarningMsg "conversionError" "string" "hi" "oops: %s" (list "hi") 1)
	    (|XtFree 0) (|XtCalloc 0 0) (|XtMalloc 0) (|XtRealloc 0 0)
	    (|XtSetLanguageProc 
	      (car (main-widgets)) 
	      (lambda (dpy str data)
		(snd-display ";YOW: language proc: got ~A ~A" str data))
	      "who called us?")
	    (|XtSetLanguageProc (car (main-widgets)) #f "oops")
	    (|XtSetLanguageProc #f #f "oops")
	    (|XtMergeArgLists (list 1 2) 2 (list 1) 1)

	    (let* ((shell (cadr (main-widgets)))
		   (dpy (|XtDisplay shell)))
	      (IF (not (equal? (|XtClass shell) |applicationShellWidgetClass))
		  (snd-display ";XtClass shell: ~A" (|XtClass shell)))
	      (IF (not (equal? (|XtSuperclass shell) |topLevelShellWidgetClass))
		  (snd-display ";XtSuperclass shell: ~A" (|XtClass shell)))
	      (IF (not (string=? (|XtName shell) "snd"))
		  (snd-display ";XtName: ~A" (|XtName shell)))
	      (IF (not (equal? (|XtWindow shell) (|XtWindowOfObject shell)))
		  (snd-display ";XtWindow: ~A ~A" (|XtWindow shell) (|XtWindowOfObject shell)))
	      (IF (not (equal? (|XtScreen shell) (|XtScreenOfObject shell)))
		  (snd-display ";XtScreen: ~A ~A" (|XtScreen shell) (|XtScreenOfObject shell)))
	      (IF (not (equal? (|XtDisplay shell) (|XtDisplayOfObject shell)))
		  (snd-display ";XtDisplay: ~A ~A" (|XtDisplay shell) (|XtDisplayOfObject shell)))
	      (IF (not (|Time? (|XtLastTimestampProcessed dpy)))
		  (snd-display ";XtLastTimestampProcessed: ~A" (|XtLastTimestampProcessed dpy)))
	      (IF (not (|XEvent? (|XtLastEventProcessed dpy)))
		  (snd-display ";XtLastEventProcessed: ~A" (|XtLastEventProcessed dpy)))
	      (|XtBuildEventMask shell)
	      (let ((k (|XtConvertCase dpy (|XKeycodeToKeysym dpy |XK_b 0)))
		    (x (|XConvertCase (|XKeycodeToKeysym dpy |XK_b 0))))
		(IF (not (|KeySym? (car k)))
		    (snd-display ";XtConvertCase: ~A" k))
		(IF (not (equal? k x))
		    (snd-display ";X(t)ConvertCase: ~A ~A" k x)))
	      )

	    (let ((pop (|XtCreatePopupShell "hiho" |xmGrabShellWidgetClass (cadr (main-widgets)) '())))
	      (|XtPopup pop |XtGrabNone)
	      (|XtPopdown pop))
	    (|XtSetWarningHandler (lambda (n) 
				    (IF (not (string=? n "hiho"))
					(snd-display "XtWarning: ~A" n))))
	    (|XtWarning "hiho")
	    (|XtAppSetWarningHandler (car (main-widgets))
				     (lambda (n) 
				       (IF (not (string=? n "hiho"))
					   (snd-display "XtWarning: ~A" n))))
	    (|XtAppWarning (car (main-widgets)) "hiho")


	    ;; ---------------- XM tests ----------------
	    (let ((dpy (|XtDisplay (cadr (main-widgets))))
		  (win (|XtWindow (cadr (main-widgets)))))
	      (let ((version (list-ref (|XGetWindowProperty dpy win
							    (|XInternAtom (|XtDisplay (cadr (main-widgets)))
									  "SND_VERSION"
									  #f)
							    0 32 #f |XA_STRING)
				       5)))
		(IF (not (string=? version (snd-version)))
		    (snd-display ";SND_VERSION: ~A, ~A?" version (snd-version))))
	      (change-prop "SND_VERSION" "WM_NAME" "hiho")
	      (IF (not (string=? (|XFetchName dpy win) "hiho")) (snd-display "change-prop: ~A" (|XFetchName dpy win))))
		       
	    (let* ((tabs (let ((ctr 0))
			   (map
			    (lambda (n)
			      (set! ctr (+ ctr 1))
			      (|XmTabCreate n |XmINCHES (IF (= ctr 1) |XmABSOLUTE |XmRELATIVE) |XmALIGNMENT_BEGINNING "."))
			    (list 1.5 1.5 1.5 1.5))))
		   (tablist (|XmTabListInsertTabs #f tabs (length tabs) 0)))
	      (IF (not (= (|XmTabListTabCount tablist) (length tabs))) 
		  (snd-display ";tablist len: ~A ~A~%" (|XmTabListTabCount tablist) (length tabs)))
	      (IF (not (equal? (|XmTabGetValues (|XmTabListGetTab tablist 0)) (list 1.5 5 0 0 ".")))
		  (snd-display ";XmTabs 0: ~A" (|XmTabGetValues (|XmTabListGetTab tablist 0))))
	      (IF (not (equal? (|XmTabGetValues (|XmTabListGetTab tablist 2)) (list 1.5 5 1 0 ".")))
		  (snd-display ";XmTabs 2: ~A" (|XmTabGetValues (|XmTabListGetTab tablist 2))))
	      (let ((copytab (|XmTabListCopy tablist 0 0)))
		(IF (not (equal? (|XmTabGetValues (|XmTabListGetTab copytab 0)) (list 1.5 5 0 0 ".")))
		    (snd-display ";XmTabListCopy 0: ~A" (|XmTabGetValues (|XmTabListGetTab copytab 0))))
		(let ((another (|XmTabListRemoveTabs copytab (list 0 1)))
		      (atab (|XmTabCreate 3.0 |XmINCHES |XmABSOLUTE |XmALIGNMENT_BEGINNING ".")))
		  (IF (not (equal? (|XmTabGetValues (|XmTabListGetTab another 0)) (list 1.5 5 1 0 ".")))
		      (snd-display ";XmTabListRemoveTabs: ~A" (|XmTabGetValues (|XmTabListGetTab another 0))))
		  (|XmTabListReplacePositions (|XmTabListCopy tablist 0 0) (list 1) (list atab))
		  ;; this (replacepositions) is very prone to segfaults -- *very* poorly implemented! 
		  (|XmTabSetValue atab 6.0)
		  (|XmTabFree atab)
		  (|XmTabListFree another))
		(let ((tabl (|XmStringTableProposeTablist
			      (list (|XmStringCreateLocalized "a-string") (|XmStringCreateLocalized "another")) 2
			      (cadr (main-widgets))
			      1.0
			      |XmABSOLUTE)))
		  (IF (not (|XmTabList? tabl)) (snd-display ";XmStringTableProposeTabList: ~A" tabl))
		  (|XmTabListFree tabl)))

	      (let* ((tmp (|XmStringCreateLocalized "h"))
		     (pm (|XmParseMappingCreate (list |XmNincludeStatus |XmINSERT
						      |XmNsubstitute    tmp
						      |XmNpattern       "i"
						      |XmNpatternType   |XmCHARSET_TEXT))))
		(|XmStringFree tmp)
		(let ((newstr (|XmStringParseText "hi" #f #f |XmCHARSET_TEXT (list pm) 1 #f)))
		  (IF (not (string=? (cadr (|XmStringGetLtoR newstr |XmFONTLIST_DEFAULT_TAG)) "hh"))
		      (snd-display ";XmStringParseText -> ~A" (|XmStringGetLtoR newstr |XmFONTLIST_DEFAULT_TAG))))
		(let ((vals (|XmParseMappingGetValues pm (list |XmNincludeStatus 0 |XmNsubstitute 0))))
		  (IF (or (not (= (cadr vals) |XmINSERT))
			  (not (string=? (cadr (|XmStringGetLtoR (list-ref vals 3) |XmFONTLIST_DEFAULT_TAG)) "h")))
		      (snd-display ";XmParseMappingGetValues: ~A" vals))
		  (|XmParseMappingSetValues pm (list |XmNpattern "b")))
		(|XmParseMappingFree pm))

	      (let* ((fonts (list "fixed"
				  "-adobe-times-bold-r-*-*-14-*-*-*-*-*-*-*"
				  "-adobe-*-medium-i-*-*-18-*-*-*-*-*-*-*"
				  "-*-helvetica-)-*-*-*-18-*-*-*-*-*-*-*"))
		     (tags (list "one" "two" "three" "four"))
		     (colors (list "red" "green" "blue" "orange"))
		     (pixels
		      (let* ((dpy (|XtDisplay (cadr (main-widgets))))
			     (scr (|DefaultScreen dpy))
			     (cmap (|DefaultColormap dpy scr)))
			(let ((col (|XColor)))
			  (|XParseColor dpy cmap "blue" col)
			  (IF (or (not (= (|red col) 0))
				  (not (= (|green col) 0))
				  (not (= (|blue col) 65535)))
			      (snd-display ";XParseColor: ~A ~A ~A ~A" col (|red col) (|blue col) (|green col)))
			  (|XLookupColor dpy cmap "red" col (|XColor))
			  (IF (or (not (= (|red col) 65535))
				  (not (= (|green col) 0))
				  (not (= (|blue col) 0)))
			      (snd-display ";XLookupColor: ~A ~A ~A ~A" col (|red col) (|blue col) (|green col))))
			(map
			 (lambda (color)
			   (let ((col (|XColor)))
			     (if (= (|XAllocNamedColor dpy cmap color col col) 0)
				 (snd-error (format #f "can't allocate ~A" color))
				 (|pixel col))))
			 colors)))
		     (rendertable (|XmRenderTableAddRenditions #f 
							       (let ((ctr 0))
								 (map (lambda (r)
									(set! ctr (+ ctr 1))
									(|XmRenditionCreate (cadr (main-widgets))
											    r
											    (append
											     (if (= ctr 1)
												 (list |XmNtabList tablist)
												 '())
											     (list |XmNrenditionForeground (list-ref pixels (1- ctr))
												    |XmNfontName (list-ref fonts (1- ctr))
												     |XmNfontType |XmFONT_IS_FONT))))
								      tags))
							       (length tags)
							       |XmMERGE_NEW)))

		(let ((prop (cadr (|XmRenderTableCvtToProp (cadr (main-widgets)) rendertable))))
		  (IF (not (string=? (substring prop 0 8) "tag,font"))
		      (snd-display ";XmRenderTableCvtToProp: ~A" (substring prop 0 8)))
		  (let ((copy (|XmRenderTableCopy rendertable)))
		    (if (not (|XmRenderTable? copy)) (snd-display ";XmRenderTableCopy full: ~A" copy))
		    (if (|XmRenderTableCopy) (snd-display ";XmRenderTableCopy null: ~A" (|XmRenderTableCopy)))
		    (let ((rtags (|XmRenderTableGetTags copy))
			  (rends (|XmRenderTableGetRenditions copy (list "one"))))
		      (IF (|XmRenderTableGetRenditions) (snd-display ";XmRenderTableGetRenditions null: ~A" (|XmRenderTableGetRenditions)))
		      (set! copy (|XmRenderTableRemoveRenditions copy (list (car rtags))))
		      (IF (not (equal? (|XmRenderTableGetTags copy) (list "two" "three" "four")))
			  (snd-display ";XmRenderTableRemoveRenditions: ~A" (|XmRenderTableGetTags copy)))
		      (let ((another (|XmRenderTableCvtFromProp (cadr (main-widgets)) prop (string-length prop))))
			(IF (not (|XmRenderTable? another)) (snd-display ";XmRenderTableCvtFromProp: ~A" another))
			(|XmRenderTableFree another))
		      )))

		(let ((tabl (|XmStringTableParseStringArray (list "hi" "ho") 2 "hiho" |XmCHARSET_TEXT #f 0 #f)))
		  (IF (not (|XmString? (car tabl))) (snd-display ";XmStringTableParseStringArray: ~A" tabl))
		  (let ((strs (|XmStringTableUnparse tabl 2 "hiho" |XmCHARSET_TEXT |XmCHARSET_TEXT #f 0 |XmOUTPUT_ALL)))
		    (IF (not (equal? strs (list "hi" "ho"))) (snd-display ";XmStringTableUnparse: ~A" strs)))
		  (let ((str (|XmStringTableToXmString tabl 2 #f)))
		    (IF (not (|XmString? str)) (snd-display ";XmStringTableToXmString: ~A" str))
		    (|XmStringToXmStringTable str #f)
		    (let ((val (|XmStringUnparse str "hiho" |XmCHARSET_TEXT |XmCHARSET_TEXT #f 0 |XmOUTPUT_ALL)))
		      (IF (not (string=? val "hiho")) (snd-display ";XmStringUnparse: ~A" val)))
		    (let* ((ind (open-sound "oboe.snd"))
			   (grf (car (channel-widgets)))
			   (dpy (|XtDisplay grf))
			   (win (|XtWindow grf))
			   (scr (|DefaultScreenOfDisplay dpy))
			   (scrn (|XScreenNumberOfScreen scr))
			   (gv (|XGCValues)))
		      (set! (|foreground gv) (snd-pixel (data-color)))
		      (set! (|background gv) (snd-pixel (basic-color)))
		      (set! (|function gv) |GXcopy)
		      (let* ((gc (|XtAllocateGC grf 
						(|XDefaultDepth dpy scrn) 
						(logior |GCForeground |GCBackground |GCFunction)
						gv
						(logior |GCFont |GCDashList)
						0))
			     (str2 (|XmStringCreateLocalized "hiho")))
			(|XmStringDraw dpy win rendertable str2 gc 10 10 100 
				       |XmALIGNMENT_END |XmSTRING_DIRECTION_L_TO_R (|XRectangle 0 0 100 100))
			(|XmStringDrawImage dpy win rendertable str2 gc 10 10 100 
					    |XmALIGNMENT_END |XmSTRING_DIRECTION_L_TO_R (|XRectangle 0 0 100 100))
			(|XmStringDrawUnderline dpy win rendertable str2 gc 10 10 100 
						|XmALIGNMENT_END |XmSTRING_DIRECTION_L_TO_R (|XRectangle 0 0 100 100) str2)
			(|XtReleaseGC grf gc))
		      (close-sound ind))
		    (let ((lc (|XmStringLineCount (|XmStringCreateLocalized "hiho"))))
		      (IF (not (= lc 1)) (snd-display ";XmStringLineCount: ~A" lc)))
		    (IF (not (|XmStringHasSubstring str (|XmStringCreateLocalized "hi"))) (snd-display ";XmStringHasSubstring?"))
		    (|XmStringNCopy str 2)
		    (|XmStringNConcat str (|XmStringCreateLocalized "hiho") 2)
		    (IF (not (|XmStringByteCompare (|XmStringCreateLocalized "hiho") (|XmStringCreateLocalized "hiho")))
			(snd-display ";XmStringByteCompare?"))))

		(IF (not (equal? (|XmRenderTableGetTags rendertable) (list "one" "two" "three" "four")))
		    (snd-display ";tags: ~A~%" (|XmRenderTableGetTags rendertable)))
		(let* ((rend (|XmRenderTableGetRendition rendertable "one"))
		       (r (|XmRenditionRetrieve rend
						(list |XmNrenditionForeground 0
						      |XmNfontName 0
						      |XmNfontType 0
						      |XmNtag 0))))
		  (IF (or (not (string=? (list-ref r 7) "one"))
			  (not (string=? (list-ref r 3) "fixed")))
		      (snd-display ";rendertable: ~A" r))
		  (let* ((str (|XmStringPutRendition (|XmStringCreateLocalized "hiho") "one"))
			 (ctx (cadr (|XmStringInitContext str)))
			 (comp (|XmStringPeekNextComponent ctx))
			 (comp1 (|XmStringPeekNextTriple ctx))
			 (comp2 (|XmStringGetNextComponent ctx)))
		    (IF (not (= comp |XmSTRING_COMPONENT_RENDITION_BEGIN)) (snd-display ";XmStringPeekNextComponent: ~A" comp))
		    (IF (not (= comp1 comp)) (snd-display ";XmStringPeekNextTriple: ~A" comp1))
		    (IF (not (= (list-ref comp2 4) comp)) (snd-display ";XmStringGetNextComponent: ~A" comp2)))
		  (|XmRenditionUpdate rend (list |XmNstrikethruType |XmSINGLE_LINE))
		  (IF (not (= (cadr (|XmRenditionRetrieve rend (list |XmNstrikethruType 0))) |XmSINGLE_LINE))
		      (snd-display ";XmRenditionUpdate: ~A ~A" (cadr (|XtGetValues rend (list |XmNstrikethruType 0))) |XmSINGLE_LINE)))
		(let ((r1 (|XmRenditionCreate (cadr (main-widgets)) "r1" (list |XmNfontName "fixed"))))
		  (|XmRenditionFree r1))
		
		(let ((tab (|XmStringComponentCreate |XmSTRING_COMPONENT_TAB 0 #f))
		      (row #f)
		      (table '())
		      (our-tags tags))
		  (for-each 
		   (lambda (word)
		     (let ((entry (|XmStringGenerate word
						     #f
						     |XmCHARSET_TEXT
						      (car our-tags))))
		       (IF (|XmStringIsVoid entry) (snd-display ";~A is void?" entry))
		       (IF (|XmStringEmpty entry) (snd-display ";~A is empty?" entry))
		       (IF (<= (|XmStringLength entry) 0) (snd-display ";XmStringLength: ~A ~A" entry (|XmStringLength entry)))
		       (let ((str1 (|XmStringCopy entry))
			     (strn #f))
			 (let ((val (|XmStringCompare entry str1)))
			   (IF (not val) (snd-display ";t XmStringCompare ~A ~A" entry str1)))
			 (set! strn (|XmStringConcat str1 entry))
			 (IF (not (> (|XmStringLength strn) (|XmStringLength entry)))
			     (snd-display ";concat xmstring: ~A ~A" (|XmStringLength strn) (|XmStringLength entry)))
			 (let ((hgt (|XmStringHeight rendertable entry)))
			   (IF (or (< hgt 5) (> hgt 120)) (snd-display ";~A height: ~A" entry hgt))
			   (let ((wid (|XmStringWidth rendertable entry)))
			     (IF (or (< wid 3) (> wid 120)) (snd-display ";~A width: ~A" entry wid))
			     (let ((extent (|XmStringExtent rendertable entry)))
			       (IF (or (not (= (car extent) wid))
				       (not (= (cadr extent) hgt)))
				   (snd-display ";XmStringExtent: ~A, wid: ~A, hgt: ~A", extent wid hgt)))))
			 (let ((hgt (|XmStringBaseline rendertable entry)))
			   (IF (or (< hgt 6) (> hgt 120)) (snd-display ";~A baseline: ~A" entry hgt)))
			 (|XmStringFree strn)
			 (|XmStringFree str1))

		       (if row
			   (let ((tmp (|XmStringConcat row tab)))
			     (|XmStringFree row)
			     (set! row (|XmStringConcatAndFree tmp entry)))
			   (set! row entry))
		       (set! our-tags (cdr our-tags))
		       (if (null? our-tags) 
			   (begin
			     (set! our-tags tags)
			     (set! table (cons row table))
			     (set! row #f)))))
		   (list "this" "is" "a" "test" "of" "the" "renditions" "and" "rendertables" 
			 "perhaps" "all" "will" "go" "well" "and" "then" "again" "perhaps" "not"))
		  (let* ((n (car table))
			 (c (|XmStringInitContext n))
			 (ctr 0))
		    (call-with-current-continuation
		     (lambda (done)
		       (do ((i 0 (1+ i)))
			   (#f)
			 (let ((type (|XmStringGetNextTriple (cadr c))))
			   (if (= (car type) |XmSTRING_COMPONENT_TEXT)
			       (IF (or (not (= (cadr type) (list-ref (list 0 0 2 0 0 0 4 0 0 0 3 0 0 0 4) i)))
				       (not (string=? (caddr type) 
						      (list-ref (list "o" "o" "go" "o" "o" "o" "well" "o" "o" "o" "and" "o" "o" "o" "then") i))))
				   (snd-display ";component ~A -> ~A" i (cdr type)))
			       (if (not (= (car type) |XmSTRING_COMPONENT_TAB))
				   (if (= (car type) |XmSTRING_COMPONENT_END)
				       (done #f))))))))
		    (|XmStringFreeContext (cadr c))))))
	    
	    (|XtAppAddActions (car (main-widgets))
			      (list (list "try1" (lambda (w e strs)	
						   (snd-display ";try1: ~A~%" strs)))
				    (list "try2" (lambda (w e strs)
						   (snd-display ";try2: ~A~%" strs)))))
	    (let* ((tab (|XtParseTranslationTable 
			  (format #f "Ctrl <Key>osfLeft:  try1()~%Ctrl <Key>osfRight: try2()~%Ctrl <Key>osfUp:  try1(hiho)~%Ctrl <Key>osfDown: try2(down, up)~%")))
		   (pane (add-main-pane "hiho" |xmTextWidgetClass '())))
	      (|XtOverrideTranslations pane tab))
	    
	    (open-sound "cardinal.snd")
	    (let*  ((mouse_width 32)
		    (mouse_height 32)
		    (mouse_bits (list
				 #x00 #x00 #x00 #x00 #x00 #x00 #x00 #x00 #x00 #x00 #x00 #x00
				 #x00 #x00 #x00 #x00 #x00 #x00 #x00 #x00 #x00 #x00 #x00 #x00
				 #x80 #xff #xff #x01 #x80 #x00 #x01 #x01 #x80 #x00 #x01 #x01
				 #x80 #x00 #x01 #x01 #x80 #x00 #x01 #x01 #x80 #x00 #x01 #x01
				 #x80 #x00 #x01 #x01 #x80 #xff #xff #x01 #x80 #x00 #x00 #x01
				 #x80 #x00 #x00 #x01 #x80 #x00 #x00 #x01 #x80 #x00 #x00 #x01
				 #x80 #x00 #x00 #x01 #x80 #x00 #x00 #x01 #x80 #x00 #x00 #x01
				 #x80 #x00 #x00 #x01 #x00 #x01 #x80 #x00 #x00 #x01 #x80 #x00
				 #x00 #x06 #x60 #x00 #x00 #xf8 #x1f #x00 #x00 #x00 #x00 #x00
				 #x00 #x00 #x00 #x00 #x00 #x00 #x00 #x00 #x00 #x00 #x00 #x00
				 #x00 #x00 #x00 #x00 #x00 #x00 #x00 #x00))
		    (rb (list
			 #x00 #x04 #x10 #x08 #x00 #x10 #x04 #x20 #x00 #x40 #xa5 #xbf
			 #x00 #x40 #x04 #x20 #x00 #x10 #x10 #x08 #x00 #x04 #x00 #x00))
		    (iconw (list-ref (sound-widgets) 8)))
	      (|XCreateBitmapFromData (|XtDisplay iconw) (|XtWindow iconw) rb 16 12)
	      (|XCreateBitmapFromData (|XtDisplay iconw) (|XtWindow iconw) mouse_bits mouse_width mouse_height))

	    (let* ((grf (car (channel-widgets)))
		   (dpy (|XtDisplay grf))
		   (win (|XtWindow grf))
		   (gc (car (snd-gcs)))
		   (scr (|DefaultScreen dpy))
		   (vis (|DefaultVisual dpy scr))
		   (depth (cadr (|XtGetValues grf (list |XmNdepth 0))))
		   (pix (|XCreatePixmap dpy win 10 10 depth))
		   (rotpix (|XCreatePixmap dpy win 10 10 depth)))
	      (IF (not (string=? (|XmGetAtomName dpy |XA_STRING) "STRING")) (snd-display ";XmGetAtomName: ~A" (|XmGetAtomName dpy |XA_STRING)))
	      (IF (not (|XmTargetsAreCompatible dpy (list |XA_STRING) 1 (list |XA_STRING) 1)) (snd-display ";XmTargetsAreCompatible"))
	      (|XmUpdateDisplay grf)
	      (let ((lines (|XmWidgetGetBaselines (list-ref (main-widgets) 4))))
		(IF (not lines) (snd-display ";XmWidgetGetBaselines?"))
		(IF (< (length lines) 4) (snd-display ";no listener text?? ~A" lines)))
	      (let ((r (|XmWidgetGetDisplayRect (list-ref (sound-widgets) 8))))
		(IF (not (|XRectangle? r)) (snd-display ";XmWidgetGetDisplayRect: ~A" r)))
	      (|XDrawImageString dpy (list 'Window (cadr pix)) gc 0 10 "hiho" 4)
	      (let* ((data (|XtCalloc (* 11 11 depth) 1))
		     (before (|XCreateImage dpy vis depth |XYPixmap 0 data 10 10 8 0))
		     (newimage (|XGetSubImage dpy (list 'Window (cadr pix)) 0 0 10 10 |AllPlanes |XYPixmap before 0 0)))
		(|XSubImage newimage 0 0 3 3)
		(IF (not (= (|bytes_per_line newimage) 2)) (snd-display "bytes_per_line: ~A" (|bytes_per_line newimage)))
		(IF (not (= (|byte_order newimage) 0)) (snd-display "byte_order: ~A" (|byte_order newimage)))
		(IF (not (= (|bitmap_pad newimage) 8)) (snd-display "bitmap_pad: ~A" (|bitmap_pad newimage)))
		(IF (not (= (|bitmap_bit_order newimage) 0)) (snd-display "bitmap_bit_order: ~A" (|bitmap_bit_order newimage)))
		(IF (not (= (|bitmap_unit newimage) 32)) (snd-display "bitmap_unit: ~A" (|bitmap_unit newimage)))
		(IF (not (= (|obdata newimage) 0)) (snd-display "obdata: ~A" (|obdata newimage)))
		(IF (not (= (|xoffset newimage) 0)) (snd-display "xoffset: ~A" (|xoffset newimage)))
		(|XPutPixel before 1 1 (snd-pixel (basic-color)))
		(|XGetPixel before 1 1)
		(|XPutImage dpy (list 'Window (cadr rotpix)) gc before 0 0 0 0 10 10)
		(|XAddPixel before 1)
		(IF (> (|bits_per_pixel before) 123) (snd-display ";bits_per_pixel: ~A" (|bits_per_pixel before)))
		(let ((i1 (|XGetImage dpy (list 'Window (cadr pix)) 0 0 10 10 |AllPlanes |XYPixmap))
		      (attr (|XpmAttributes))
		      (vals (|XtGetValues (cadr (main-widgets)) (list |XmNcolormap 0 |XmNdepth 0)))
		      (sym (|XpmColorSymbol "basiccolor" #f (snd-pixel (basic-color)))))
		  (set! (|visual attr) vis)
		  (IF (not (equal? vis (|visual attr))) (snd-display ";visual xpm attr: ~A" (|visual attr)))
		  (set! (|colorsymbols attr) sym)
		  (set! (|numsymbols attr) 1)
		  (IF (not (equal? 1 (|numsymbols attr))) (snd-display ";numsymbols xpm attr: ~A" (|numsymbols attr)))
		  (set! (|depth attr) (list-ref vals 3))
		  (IF (not (equal? (list-ref vals 3) (|depth attr))) (snd-display ";depth xpm attr: ~A" (|depth attr)))
		  (set! (|colormap attr) (list-ref vals 1))
		  (IF (not (equal? (list-ref vals 1) (|colormap attr))) (snd-display ";colormap xpm attr: ~A" (|colormap attr)))
		  (set! (|valuemask attr) (logior |XpmColorSymbols |XpmDepth |XpmColormap |XpmVisual))
		  (IF (not (= (|valuemask attr) (logior |XpmColorSymbols |XpmDepth |XpmColormap |XpmVisual)))
		      (snd-display ";valuemask: ~A" (|valuemask attr)))
		  (IF (not (= (|x_hotspot attr) 0)) (snd-display ";x_hotspot: ~A" (|x_hotspot attr)))
		  (IF (not (= (|y_hotspot attr) 0)) (snd-display ";y_hotspot: ~A" (|y_hotspot attr)))
		  (IF (not (= (|npixels attr) 0)) (snd-display ";npixels: ~A" (|npixels attr)))
		  (let ((err (|XpmCreatePixmapFromData dpy win 
						       (list "16 14 6 1"
							     " 	c None s None"
							     ".	c gray50"
							     "X	c black"
							     "o	c white"
							     "O	c yellow"
							     "-      c ivory2 s basiccolor"
							     "------.XXX.-----"
							     "-----X.ooo.X----"
							     "----..oXXXo..---"
							     "----XoX...XoX---"
							     "----XoX.--XoX.--"
							     "----XoX.--XoX.--"
							     "---XXXXXXXXXXX--"
							     "---XOOOOOOOOOX.-"
							     "---XO.......OX.-"
							     "---XOOOOOOOOOX.-"
							     "---XO.......OX.-"
							     "---XOOOOOOOOOX.-"
							     "---XXXXXXXXXXX.-"
							     "----...........-")
						       attr)))
		    (IF (or (not (= (car err) |XpmSuccess))
			    (not (|Pixmap? (cadr err))))
			(snd-display ";XpmCreatePixmapFromData: ~A" err)))
		  (|XDestroyImage i1))
		(|XDestroyImage before)
		(|XFreePixmap dpy pix)
		(|XVisualIDFromVisual vis)
		(|XLockDisplay dpy)
		(|XUnlockDisplay dpy)
		(let ((keys (|XGetKeyboardMapping dpy 40 1)))
		  (IF (not (equal? keys (list (list 'KeySym 100) (list 'KeySym 68))))
		      (snd-display ";XGetKeyboardMapping: ~A" keys)))
		))

	    (let* ((gc (car (snd-gcs)))
		   (grf (car (channel-widgets)))
		   (dpy (|XtDisplay grf))
		   (win (|XtWindow grf))
		   (shl (cadr (main-widgets))))
	      (let ((wid (|XtWindowToWidget dpy win)))
		(IF (not (equal? wid grf))
		    (snd-display ";XtWindowToWidget: ~A ~A" grf win)))
	      (IF (not (equal? (|XGetTransientForHint dpy win) (list 0 #f)))
		  (snd-display ";XGetTransientForHint: ~A" (|XGetTransientForHint dpy win)))
	      (IF (not (equal? (|XGetErrorText dpy |BadColor #f 9) (list 0 "BadColor")))
		  (snd-display ";XGetErrorText: ~A" (|XGetErrorText dpy |BadColor #f 9)))
	      (IF (not (equal? (|XGeometry dpy 0 "500x400" "500x400+10+10" 4 7 14 2 2) (list 12 10 10 500 400)))
		  (snd-display ";XGeometry: ~A" (|XGeometry dpy 0 "500x400" "500x400+10+10" 4 7 14 2 2)))
	      (IF (< (|XEventsQueued dpy |QueuedAlready) 0)
		  (snd-display ";XEventsQueued: ~A" (|XEventsQueued dpy |QueuedAlready)))
	      (let ((coords (|XTranslateCoordinates dpy (|XtWindow shl) win 10 10)))
		(IF (not (car coords))
		    (snd-display ";XTranslateCoordinates: ~A" coords)))
	      (let ((coords (|XtTranslateCoords shl 10 10)))
		(IF (not (number? (car coords)))
		    (snd-display ";XtTranslateCoords: ~A" coords)))
	      (IF (not (|XmIsVendorShell shl)) (snd-display ";XmIsVendorShell?"))
	      (IF (|XmIsPrimitive shl) (snd-display ";XmIsPrimitive?"))
	      (IF (|XmIsManager shl) (snd-display ";XmIsManager?"))
	      (IF (|XmIsIconGadget shl) (snd-display ";XmIsIconGadget?"))
	      (IF (|XmIsGadget shl) (snd-display ";XmIsGadget?"))
	      (IF (|XmIsIconHeader shl) (snd-display ";XmIsHeader?"))
	      (IF (|XmIsDropTransfer shl) (snd-display ";XmIsDropTransfer?"))
	      (IF (|XmIsDropSiteManager shl) (snd-display ";XmIsDropSiteManager?"))
	      (IF (|XmIsDragContext shl) (snd-display ";XmIsDragContext?"))
	      (IF (|XmIsDragIconObjectClass shl) (snd-display ";XmIsDragIconObjectClass?"))
	      (IF (|XmIsMessageBox shl) (snd-display ";XmIsMessageBox?"))
	      (IF (|XmIsScreen shl) (snd-display ";XmIsScreen?"))
	      (IF (|XmIsDisplay shl) (snd-display ";XmIsDisplay?"))

	      (|XDrawImageString dpy win gc 10 10 "hiho" 4)
	      (|XDrawRectangle dpy win gc 0 0 10 10)
	      (|XDrawString dpy win gc 10 10 "hi" 2)
	      (|XDrawSegments dpy win gc (list (|XSegment 1 1 2 20) (|XSegment 3 3 40 4)) 2)
	      (|XDrawRectangles dpy win gc (list (|XRectangle 0 0 10 10) (|XRectangle 20 20 30 30)) 2)
	      (|XFillRectangles dpy win gc (list (|XRectangle 0 0 10 10) (|XRectangle 20 20 30 30)) 2)
	      (|XDrawRectangle dpy win gc 10 10 10 10)
	      (|XFillRectangle dpy win gc 10 10 10 10)
	      (|XDrawPoints dpy win gc (list (|XPoint 23 23) (|XPoint 109 10)) 2 |CoordModeOrigin)
	      (|XDrawPoint dpy win gc 10 10)
	      (|XDrawLines dpy win gc (list (|XPoint 23 23) (|XPoint 109 10)) 2 |CoordModeOrigin)
	      (|XDrawLine dpy win gc 10 10 20 20)
	      (|XDrawArcs dpy win gc (list (|XArc 10 10 4 4 0 360) (|XArc 20 20 1 23 0 123)) 2)
	      (|XFillArcs dpy win gc (list (|XArc 10 10 4 4 0 360) (|XArc 20 20 1 23 0 123)) 2)
	      (|XDrawArc dpy win gc 0 0 10 10 45 90)
	      (|XFillArc dpy win gc 0 0 10 10 45 90)
	      (|XFillPolygon dpy win gc (list (|XPoint 0 0) (|XPoint 0 10) (|XPoint 10 10) (|XPoint 10 0) (|XPoint 0 0)) 5 |Convex |CoordModeOrigin)
	      (|XClearArea dpy win 10 10 20 20 #f)
	      (|XClearWindow dpy win))

	    (close-sound)
	    
	    (let* ((frm (add-main-pane "hi" |xmFormWidgetClass (list |XmNpaneMinimum 120)))
		   (browsed 0)
		   (lst (|XtCreateManagedWidget "lst" |xmListWidgetClass frm
						(list |XmNleftAttachment      |XmATTACH_FORM
						      |XmNrightAttachment     |XmATTACH_FORM
						      |XmNtopAttachment       |XmATTACH_FORM
						      |XmNbottomAttachment    |XmATTACH_FORM
						      |XmNautomaticSelection   |XmNO_AUTO_SELECT
						      |XmNdoubleClickInterval  100
						      |XmNitemCount            3
						      |XmNitems                (list (|XmStringCreate "one" |XmFONTLIST_DEFAULT_TAG)
										     (|XmStringCreate "two" |XmFONTLIST_DEFAULT_TAG)
										     (|XmStringCreate "three" |XmFONTLIST_DEFAULT_TAG))
						      |XmNlistMarginHeight     4
						      |XmNlistMarginWidth      1
						      |XmNlistSizePolicy       |XmVARIABLE
						      |XmNlistSpacing          2
						      |XmNmatchBehavior        |XmQUICK_NAVIGATE
						      |XmNprimaryOwnership     |XmOWN_NEVER
						      |XmNscrollBarDisplayPolicy |XmAS_NEEDED
						      |XmNselectColor          (snd-pixel (basic-color))
						      |XmNselectionMode        |XmNORMAL_MODE
						      |XmNselectionPolicy      |XmBROWSE_SELECT))))
	      (|XtAddCallback lst |XmNbrowseSelectionCallback (lambda (w c i) (set! browsed 123)))
	      (let ((vals (|XtVaGetValues lst
					  (list |XmNautomaticSelection 0 |XmNdoubleClickInterval 0 |XmNitemCount 0 |XmNitems 0 |XmNlistMarginHeight 0
						|XmNlistMarginWidth 0 |XmNlistSizePolicy 0 |XmNlistSpacing 0 |XmNmatchBehavior 0
						|XmNprimaryOwnership 0  |XmNscrollBarDisplayPolicy 0 |XmNselectColor 0 |XmNselectionMode 0
						|XmNselectionPolicy 0 |XmNhorizontalScrollBar 0 |XmNselectedItemCount 0 |XmNtopItemPosition 0))))
		(IF (not (= (list-ref vals 1) |XmNO_AUTO_SELECT)) (snd-display ";XmNautomaticSelection: ~A" (list-ref vals 1)))
		(IF (not (= (list-ref vals 3) 100)) (snd-display ";XmNdoubleClickInterval: ~A" (list-ref vals 3)))
		(IF (not (= (list-ref vals 5) 3)) (snd-display ";XmNitemCount: ~A" (list-ref vals 5)))
		(IF (not (|XmString? (car (list-ref vals 7)))) (snd-display ";XmNitems: ~A" (list-ref vals 7)))
		(IF (not (= (list-ref vals 9) 4)) (snd-display ";XmNlistMarginHeight: ~A" (list-ref vals 9)))
		(IF (not (= (list-ref vals 11) 1)) (snd-display ";XmNlistMarginWidth: ~A" (list-ref vals 11)))
		(IF (not (= (list-ref vals 13) |XmVARIABLE)) (snd-display ";XmNlistSizePolicy: ~A" (list-ref vals 13)))
		(IF (not (= (list-ref vals 15) 2)) (snd-display ";XmNlistSpacing: ~A" (list-ref vals 15)))
		(IF (not (= (list-ref vals 17) |XmQUICK_NAVIGATE)) (snd-display ";XmNmatchBehavior: ~A" (list-ref vals 17)))
		(IF (not (= (list-ref vals 19) |XmOWN_NEVER)) (snd-display ";XmNprimaryOwnership : ~A" (list-ref vals 19)))
		(IF (not (= (list-ref vals 21) |XmAS_NEEDED)) (snd-display ";XmNscrollBarDisplayPolicy: ~A" (list-ref vals 21)))
		(IF (not (|Pixel? (list-ref vals 23))) (snd-display ";XmNselectColor: ~A" (list-ref vals 23)))
		(IF (not (= (list-ref vals 25) |XmNORMAL_MODE)) (snd-display ";XmNselectionMode: ~A" (list-ref vals 25)))
		(IF (not (= (list-ref vals 27) |XmBROWSE_SELECT)) (snd-display ";XmNselectionPolicy: ~A" (list-ref vals 27)))
		(IF (list-ref vals 29) (snd-display ";XmNhorizontalScrollBar: ~A" (list-ref vals 29)))
		(IF (not (= (list-ref vals 31) 0)) (snd-display ";XmNselectedItemCount : ~A" (list-ref vals 31)))
		(IF (not (= (list-ref vals 33) 1)) (snd-display ";XmNtopItemPosition: ~A" (list-ref vals 33)))
		
		(let ((tag (catch #t
				  (lambda ()
				    (|XmListAddItem frm (|XmStringCreate "four" |XmFONTLIST_DEFAULT_TAG) 0))
				  (lambda args (car args)))))
		  (IF (not (eq? tag 'wrong-type-arg))
		      (snd-display "list type check: ~A" tag)))

		(|XmListAddItem lst (|XmStringCreate "four" |XmFONTLIST_DEFAULT_TAG) 0) ; 0 -> last position
		(set! vals (|XtGetValues lst (list |XmNitemCount 0 |XmNitems 0)))
		(IF (not (= (list-ref vals 1) 4)) (snd-display ";XmAddItem len: ~A" (list-ref vals 1)))
		(IF (not (string=? (cadr (|XmStringGetLtoR (list-ref (list-ref vals 3) 3) |XmFONTLIST_DEFAULT_TAG)) "four"))
		    (snd-display "added item: ~A" (cadr (|XmStringGetLtoR (list-ref (list-ref vals 3) 3) |XmFONTLIST_DEFAULT_TAG))))
		(|XmListAddItems lst (list (|XmStringCreateLocalized "five") (|XmStringCreateLocalized "six")) 2 0)
		(set! vals (|XtGetValues lst (list |XmNitemCount 0 |XmNitems 0)))
		(IF (not (= (list-ref vals 1) 6)) (snd-display ";XmAddItems len: ~A" (list-ref vals 1)))
		(IF (not (string=? (cadr (|XmStringGetLtoR (list-ref (list-ref vals 3) 5) |XmFONTLIST_DEFAULT_TAG)) "six"))
		    (snd-display "added items: ~A" (cadr (|XmStringGetLtoR (list-ref (list-ref vals 3) 5) |XmFONTLIST_DEFAULT_TAG))))
		
		(|XmListDeletePos lst 1)
		(set! vals (|XtGetValues lst (list |XmNitemCount 0 |XmNitems 0)))
		(IF (not (= (list-ref vals 1) 5)) (snd-display ";XmListDeletePos len: ~A" (list-ref vals 1)))
		(IF (not (string=? (cadr (|XmStringGetLtoR (list-ref (list-ref vals 3) 0) |XmFONTLIST_DEFAULT_TAG)) "two"))
		    (snd-display "deleted item 1: ~A" (cadr (|XmStringGetLtoR (list-ref (list-ref vals 3) 0) |XmFONTLIST_DEFAULT_TAG))))
		(|XmListDeletePositions lst (list 2 4))
		(set! vals (|XtGetValues lst (list |XmNitemCount 0 |XmNitems 0)))
		(IF (not (= (list-ref vals 1) 3)) (snd-display ";XmListDeletePositions len: ~A" (list-ref vals 1)))
		(IF (not (string=? (cadr (|XmStringGetLtoR (list-ref (list-ref vals 3) 1) |XmFONTLIST_DEFAULT_TAG)) "four"))
		    (snd-display "deleted item 2: ~A" (cadr (|XmStringGetLtoR (list-ref (list-ref vals 3) 1) |XmFONTLIST_DEFAULT_TAG))))
		
		(|XmListAddItemUnselected lst (|XmStringCreate "seven" |XmFONTLIST_DEFAULT_TAG) 0) ; 0 -> last position
		(set! vals (|XtGetValues lst (list |XmNitemCount 0 |XmNitems 0)))
		(IF (not (= (list-ref vals 1) 4)) (snd-display ";XmListAddItemUnselected len: ~A" (list-ref vals 1)))
		(IF (not (string=? (cadr (|XmStringGetLtoR (list-ref (list-ref vals 3) 3) |XmFONTLIST_DEFAULT_TAG)) "seven"))
		    (snd-display "added item unselected: ~A" (cadr (|XmStringGetLtoR (list-ref (list-ref vals 3) 3) |XmFONTLIST_DEFAULT_TAG))))
		(|XmListAddItemsUnselected lst (list (|XmStringCreateLocalized "eight") (|XmStringCreateLocalized "nine")) 2 0)
		(set! vals (|XtGetValues lst (list |XmNitemCount 0 |XmNitems 0)))
		(IF (not (= (list-ref vals 1) 6)) (snd-display ";XmListAddItemsUnselected len: ~A" (list-ref vals 1)))
		(IF (not (string=? (cadr (|XmStringGetLtoR (list-ref (list-ref vals 3) 5) |XmFONTLIST_DEFAULT_TAG)) "nine"))
		    (snd-display "added items unselected: ~A" (cadr (|XmStringGetLtoR (list-ref (list-ref vals 3) 5) |XmFONTLIST_DEFAULT_TAG))))
		
		(|XmListDeleteAllItems lst)
		(set! vals (|XtGetValues lst (list |XmNitemCount 0 |XmNitems 0)))
		(IF (not (= (list-ref vals 1) 0)) (snd-display ";XmListDeleteAllItems len: ~A" (list-ref vals 1)))
		(IF (not (null? (list-ref vals 3)))
		    (snd-display "deleted all items: ~A" (list-ref vals 3)))
		
		(let ((item1 (|XmStringCreate "one" |XmFONTLIST_DEFAULT_TAG))
		      (item2 (|XmStringCreate "two" |XmFONTLIST_DEFAULT_TAG))
		      (item3 (|XmStringCreate "three" |XmFONTLIST_DEFAULT_TAG))
		      (item4 (|XmStringCreate "four" |XmFONTLIST_DEFAULT_TAG))
		      (item5 (|XmStringCreate "five" |XmFONTLIST_DEFAULT_TAG)))
		  (|XtVaSetValues lst 
				  (list |XmNitemCount 5
					 |XmNitems (list item1 item2 item3 item4 item5))) 
		  (set! vals (|XtGetValues lst (list |XmNitemCount 0 |XmNitems 0)))
		  (IF (not (= (list-ref vals 1) 5)) (snd-display ";Xt set items len: ~A" (list-ref vals 1)))
		  (IF (not (string=? (cadr (|XmStringGetLtoR (list-ref (list-ref vals 3) 0) |XmFONTLIST_DEFAULT_TAG)) "one"))
		      (snd-display "set items: ~A" (cadr (|XmStringGetLtoR (list-ref (list-ref vals 3) 0) |XmFONTLIST_DEFAULT_TAG))))
		  
		  (|XmListSelectItem lst item3 #t)
		  (IF (not (= browsed 123)) (snd-display ";XmListSelectItem callback: ~A" browsed))
		  (IF (|XmListPosSelected lst 1) (snd-display ";XmList selected pos 1?"))
		  (IF (not (|XmListPosSelected lst 3)) (snd-display ";XmList didn't select pos 3?"))
		  (set! vals (|XtVaGetValues lst (list |XmNselectedItemCount 0 |XmNselectedItems 0)))
		  (IF (not (= (list-ref vals 1) 1)) (snd-display ";selected count: ~A" (list-ref vals 1)))
		  (set! vals (|XmListGetSelectedPos lst))
		  (IF (not (= (length vals) 1)) (snd-display ";XmListGetSelectedPos: ~A" vals))
		  (IF (not (= (car vals) 3)) (snd-display ";XmListGetSelectedPos: ~A" vals))
		  (set! browsed 0)
		  (|XmListSelectPos lst 1 #f)
		  (IF (not (= browsed 0)) (snd-display ";XmListSelectPos callback: ~A" browsed))
		  (IF (not (|XmListPosSelected lst 1)) (snd-display ";XmList select pos?"))
		  (IF (not (= (|XmListItemPos lst item3) 3)) (snd-display ";XmListItemPos: ~A" (|XmListItemPos lst item3)))
		  (IF (not (= (car (|XmListGetMatchPos lst item3)) 3)) (snd-display ";XmListGetMatchPos: ~A" (|XmListGetMatchPos lst item3)))
		  (IF (not (= (|XmListItemExists lst item3))) (snd-display ";XmListItemExists?"))
		  
		  (IF (not (= (|XmListYToPos lst 40) 2)) (snd-display ";XmListYToPos: ~A" (|XmListYToPos lst 40)))
		  (let ((box (|XmListPosToBounds lst 2)))
		    (IF (not (= (cadr box) 3))
			(snd-display "XmListPosToBounds: ~A" box)))
		  (|XmListDeselectPos lst 1)
		  (IF (|XmListPosSelected lst 1) (snd-display ";XmList deselected pos?"))
		  (|XmListSelectItem lst item3 #t)
		  (|XmListDeselectAllItems lst)
		  (IF (|XmListPosSelected lst 3) (snd-display ";XmList deselect all pos?"))
		  (|XmListSelectItem lst item3 #f)
		  (|XmListDeselectItem lst item3)
		  (IF (|XmListPosSelected lst 3) (snd-display ";XmList deselect item?"))
		  
		  (|XmListDeleteItem lst item2)
		  (set! vals (|XtGetValues lst (list |XmNitemCount 0 |XmNitems 0)))
		  (IF (not (= (list-ref vals 1) 4)) (snd-display ";XmDeleteItem len: ~A" (list-ref vals 1)))
		  (IF (not (string=? (cadr (|XmStringGetLtoR (list-ref (list-ref vals 3) 1) |XmFONTLIST_DEFAULT_TAG)) "three"))
		      (snd-display "delete item: ~A" (cadr (|XmStringGetLtoR (list-ref (list-ref vals 3) 1) |XmFONTLIST_DEFAULT_TAG))))
		  (|XmListDeleteItems lst (list item1 item4))
		  (set! vals (|XtGetValues lst (list |XmNitemCount 0 |XmNitems 0)))
		  (IF (not (= (list-ref vals 1) 2)) (snd-display ";XmDeleteItems len: ~A" (list-ref vals 1)))
		  (IF (not (string=? (cadr (|XmStringGetLtoR (list-ref (list-ref vals 3) 0) |XmFONTLIST_DEFAULT_TAG)) "three"))
		      (snd-display "delete items: ~A" (cadr (|XmStringGetLtoR (list-ref (list-ref vals 3) 1) |XmFONTLIST_DEFAULT_TAG))))
		  (|XmListDeleteAllItems lst)
		  (|XtVaSetValues lst 
				  (list |XmNitemCount 5
					 |XmNitems (list item1 item2 item3 item4 item5))) 
		  
		  (let ((item6 (|XmStringCreate "six" |XmFONTLIST_DEFAULT_TAG)))
		    (|XmListReplacePositions lst (list 2) (list item6) 1)
		    (set! vals (|XtGetValues lst (list |XmNitemCount 0 |XmNitems 0)))
		    (IF (not (string=? (cadr (|XmStringGetLtoR (list-ref (list-ref vals 3) 1) |XmFONTLIST_DEFAULT_TAG)) "six"))
			(snd-display "replace pos: ~A ~A" 
				     (cadr (|XmStringGetLtoR (list-ref (list-ref vals 3) 1) |XmFONTLIST_DEFAULT_TAG))
				     (map (lambda (n) 
					    (|XmStringGetLtoR n |XmFONTLIST_DEFAULT_TAG))
					  (list-ref vals 3))))
		    (|XmListReplaceItemsUnselected lst (list item6 item3) 2 (list item2 item6))
		    (set! vals (|XtGetValues lst (list |XmNitemCount 0 |XmNitems 0)))
		    (IF (not (string=? (cadr (|XmStringGetLtoR (list-ref (list-ref vals 3) 2) |XmFONTLIST_DEFAULT_TAG)) "six"))
			(snd-display "replace items unselected: ~A ~A" 
				     (cadr (|XmStringGetLtoR (list-ref (list-ref vals 3) 1) |XmFONTLIST_DEFAULT_TAG))
				     (map (lambda (n) 
					    (|XmStringGetLtoR n |XmFONTLIST_DEFAULT_TAG))
					  (list-ref vals 3))))
		    (|XmListReplaceItemsPosUnselected lst (list item6 item3) 2 1)
		    (set! vals (|XtGetValues lst (list |XmNitemCount 0 |XmNitems 0)))
		    (IF (not (string=? (cadr (|XmStringGetLtoR (list-ref (list-ref vals 3) 0) |XmFONTLIST_DEFAULT_TAG)) "six"))
			(snd-display "replace items pos: ~A ~A" 
				     (cadr (|XmStringGetLtoR (list-ref (list-ref vals 3) 0) |XmFONTLIST_DEFAULT_TAG))
				     (map (lambda (n) 
					    (|XmStringGetLtoR n |XmFONTLIST_DEFAULT_TAG))
					  (list-ref vals 3))))
		    (|XmListReplaceItemsPos lst (list item4) 1 1)
		    (set! vals (|XtGetValues lst (list |XmNitemCount 0 |XmNitems 0)))
		    (IF (not (string=? (cadr (|XmStringGetLtoR (list-ref (list-ref vals 3) 0) |XmFONTLIST_DEFAULT_TAG)) "four"))
			(snd-display "replace items pos: ~A ~A" 
				     (cadr (|XmStringGetLtoR (list-ref (list-ref vals 3) 0) |XmFONTLIST_DEFAULT_TAG))
				     (map (lambda (n) 
					    (|XmStringGetLtoR n |XmFONTLIST_DEFAULT_TAG))
					  (list-ref vals 3))))
		    (|XmListReplaceItems lst (list item4 item3) 2 (list item2 item6))
		    (set! vals (|XtGetValues lst (list |XmNitemCount 0 |XmNitems 0)))
		    (IF (not (string=? (cadr (|XmStringGetLtoR (list-ref (list-ref vals 3) 0) |XmFONTLIST_DEFAULT_TAG)) "two"))
			(snd-display "replace items: ~A ~A" 
				     (cadr (|XmStringGetLtoR (list-ref (list-ref vals 3) 0) |XmFONTLIST_DEFAULT_TAG))
				     (map (lambda (n) 
					    (|XmStringGetLtoR n |XmFONTLIST_DEFAULT_TAG))
					  (list-ref vals 3))))
		    (|XmListSetPos lst 1)
		    (IF (not (|XmListSetKbdItemPos lst 1)) (snd-display ";XmListSetKbdItemPos?"))
		    (|XmListGetKbdItemPos lst)
		    (|XmListUpdateSelectedList lst)
		    (|XmListSetPos lst 1)
		    (|XmListSetHorizPos lst 0)
		    (|XmListSetBottomPos lst 0)
		    (|XmListSetBottomItem lst item5)
		    (|XmListSetAddMode lst #f)
		    (|XmListSetItem lst item6)))
		(|XtUnmanageChild frm)))

	    (let* ((frm (add-main-pane "hi" |xmFormWidgetClass (list |XmNpaneMinimum 120)))
		   (current-time (list 'Time |CurrentTime))
		   (calls (make-vector 10 "none"))
		   (txt (|XtCreateManagedWidget "text" |xmTextWidgetClass frm
						(list |XmNeditable #t
						      |XmNleftAttachment      |XmATTACH_FORM
						      |XmNrightAttachment     |XmATTACH_FORM
						      |XmNtopAttachment       |XmATTACH_FORM
						      |XmNbottomAttachment    |XmATTACH_NONE
						      |XmNdestinationCallback 
						       (list (lambda (w c i) 
							       (vector-set! calls c "dest")
							       (IF (< (|destination_data i) 0) (snd-display "destination_data: A~" (|destination_data i)))
							       (IF (< (|location_data i) 0) (snd-display "location_data: A~" (|location_data i))))
							     1)
						      |XmNactivateCallback (list (lambda (w c i) (vector-set! calls c "act")) 2)
						      |XmNfocusCallback (list (lambda (w c i) (vector-set! calls c "focus")) 3)
						      |XmNlosingFocusCallback (list (lambda (w c i) (vector-set! calls c "losingfocus")) 4)
						      |XmNgainPrimaryCallback (list (lambda (w c i) (vector-set! calls c "gain")) 5)
						      |XmNlosePrimaryCallback (list (lambda (w c i) (vector-set! calls c "lose")) 6)
						      |XmNmodifyVerifyCallback 
						       (list (lambda (w c i) 
							       (vector-set! calls c "modify")
							       (IF (< (|currInsert i) 0) (snd-display "currInsert: A~" (|currInsert i)))
							       (IF (< (|newInsert i) 0) (snd-display "newInsert: A~" (|newInsert i)))
							       (IF (string? (|doit i)) (snd-display "doit: A~" (|doit i)))
							       (IF (< (|startPos i) 0) (snd-display "startPos: A~" (|startPos i)))
							       (IF (< (|endPos i) 0) (snd-display "endPos: A~" (|endPos i))))
							     7)
						      |XmNmotionVerifyCallback (list (lambda (w c i) (vector-set! calls c "motion")) 8)
						      |XmNvalueChangedCallback (list (lambda (w c i) (vector-set! calls c "value")) 9)))))
	      (letrec ((transfer-proc
			(lambda (w c info)
			  (let* ((dpy (|XtDisplay w))
				 (TARGETS (|XmInternAtom dpy "TARGETS" #f))
				 (CB_TARGETS (|XmInternAtom dpy "_MOTIF_CLIPBOARD_TARGETS" #f)))
			    (if (equal? (|target info) |XA_STRING)
				(begin
				  (|XmTextInsert w (|XmTextGetInsertionPosition w) (->string (|value info)))
				  (|XmTransferDone (|transfer_id info) |XmTRANSFER_DONE_SUCCEED))
				(if (and (or (equal? (|target info) TARGETS)
					     (equal? (|target info) CB_TARGETS))
					 (equal? (|type info) |XA_ATOM))
				    (let ((targets (->Atoms (|value info) (|length info)))
					  (happy #f))
				      (for-each
				       (lambda (targ)
					 (if (equal? targ |XA_STRING)
					     (set! happy #t)))
				       targets)
				      (if happy
					  (|XmTransferValue (|transfer_id info) 
							    |XA_STRING
							     transfer-proc
							     #f
							     (|XtLastTimestampProcessed dpy)))))))))
		       (txtf (|XtVaCreateManagedWidget "textfield" |xmTextFieldWidgetClass frm
						       (list |XmNeditable #t
							     |XmNleftAttachment      |XmATTACH_FORM
							     |XmNrightAttachment     |XmATTACH_FORM
							     |XmNtopAttachment       |XmATTACH_WIDGET
							     |XmNtopWidget           txt
							     |XmNbottomAttachment    |XmATTACH_FORM))))
							      
	      (let ((vals (|XtVaGetValues txt (list |XmNrenderTable 0 |XmNselectionArray 0))))
		(IF (not (|XmRenderTable? (list-ref vals 1))) (snd-display ";XmNrenderTable: ~A" (list-ref vals 1)))
		(IF (not (list? (list-ref vals 3))) (snd-display ";XmNselectionArray: ~A" (list-ref vals 3))))
	      (IF (not (|XmTextGetEditable txt)) (snd-display ";XmTextGetEditable?"))
	      (IF (not (|XmTextFieldGetEditable txtf)) (snd-display ";XmTextFieldGetEditable?"))
	      (|XmTextSetEditable txt #f)
	      (|XmTextFieldSetEditable txtf #f)
	      (IF (|XmTextGetEditable txt) (snd-display ";XmTextSetEditable?"))
	      (IF (|XmTextFieldGetEditable txtf) (snd-display ";XmTextFieldSetEditable?"))
	      (|XmTextSetEditable txt #t)
	      (|XmTextFieldSetEditable txtf #t)
	      (|XmTextSetString txt "0123456789")
	      (|XmTextFieldSetString txtf "0123456789")
	      (let ((val (|XmTextGetString txt))
		    (valf (|XmTextFieldGetString txtf))
		    (val1 (cadr (|XtVaGetValues txt (list |XmNvalue 0))))
		    (val1f (cadr (|XtVaGetValues txtf (list |XmNvalue 0)))))
		(IF (not (string=? val "0123456789")) (snd-display ";XmTextSetString: ~A" val))
		(IF (not (string=? valf "0123456789")) (snd-display ";XmTextFieldSetString: ~A" valf))
		(IF (not (string=? val1 "0123456789")) (snd-display ";text value: ~A" val1))
		(IF (not (string=? val1f "0123456789")) (snd-display ";text field value: ~A" val)))
	      (let ((val (|XmTextGetSubstring txt 2 3))
		    (valf (|XmTextFieldGetSubstring txtf 2 3)))
		(IF (not (string=? val "234")) (snd-display ";XmTextGetSubstring: ~A" val))
		(IF (not (string=? valf "234")) (snd-display ";XmTextFieldGetSubstring: ~A" valf)))
	      (|XmTextSetSelection txt 2 5 current-time)
	      (let ((val (|XmTextGetSelection txt)))
		(IF (not (string=? val "234")) (snd-display ";XmTextGetSelection: ~A" val)))
	      (|XmTextClearSelection txt current-time)
	      (let ((val (|XmTextGetSelection txt)))
		(IF val (snd-display ";XmTextClearSelection: ~A" val)))
	      (|XmTextFieldSetSelection txtf 2 5 current-time)
	      (let ((tag (catch #t
				(lambda ()
				  (|XmTextFieldSetSelection txt 2 3 current-time))
				(lambda args (car args)))))
		(IF (not (eq? tag 'wrong-type-arg))
		    (snd-display "text field type check: ~A" tag)))
	      (let ((tag (catch #t
				(lambda ()
				  (|XmTextSetSelection frm 2 3 current-time))
				(lambda args (car args)))))
		(IF (not (eq? tag 'wrong-type-arg))
		    (snd-display "text type check: ~A" tag)))
	      (let ((valf (|XmTextFieldGetSelection txtf)))
		(IF (not (string=? valf "234")) (snd-display ";XmTextFieldGetSelection: ~A" valf)))
	      (|XmTextFieldClearSelection txtf current-time)
	      (let ((valf (|XmTextFieldGetSelection txtf)))
		(IF valf (snd-display ";XmTextFieldClearSelection: ~A" valf)))
	      (let ((val (|XmTextGetInsertionPosition txt))
		    (valf (|XmTextFieldGetInsertionPosition txtf)))
		(IF (not (= val 5)) (snd-display ";XmTextGetInsertionPosition: ~A" val))
		(IF (not (= valf 5)) (snd-display ";XmTextFieldGetInsertionPosition: ~A" val)))
	      
	      (|XmTextSetSelection txt 2 5 current-time)
	      (|XmTextCut txt current-time)
	      (let ((val (|XmTextGetString txt)))
		(IF (not (string=? val "0156789")) (snd-display ";XmTextCut: ~A" val)))
	      (|XmTextPaste txt) 
	      (let ((val (|XmTextGetString txt)))
		(IF (not (string=? val "0123456789")) (snd-display ";XmTextPaste: ~A" val)))
	      (|XmTextFieldSetSelection txtf 2 5 current-time)
	      (|XmTextFieldCut txtf current-time)
	      (let ((val (|XmTextFieldGetString txtf)))
		(IF (not (string=? val "0156789")) (snd-display ";XmTextFieldCut: ~A" val)))
	      (|XmTextFieldPaste txtf) 
	      (let ((val (|XmTextFieldGetString txtf)))
		(IF (not (string=? val "0123456789")) (snd-display ";XmTextFieldPaste: ~A" val)))
	      
	      (|XmTextSetSelection txt 1 2 current-time)
	      (IF (not (equal? (|XmTextGetSelectionPosition txt) (list #t 1 2)))
		  (snd-display ";XmTextGetSelectionPosition: ~A" (|XmTextGetSelectionPosition txt)))
	      (|XmTextCopy txt current-time)
	      (|XmTextSetInsertionPosition txt 8)
	      (|XmTextPaste txt)
	      (let ((dest (|XmGetDestination (|XtDisplay (cadr (main-widgets))))))
		(IF (not (equal? txt dest)) (snd-display ";XmGetDestination: ~A (~A)" dest txt)))
	      (|XmRedisplayWidget txt)
	      (let ((val (|XmTextGetString txt)))
		(IF (not (string=? val "01234567189")) (snd-display ";XmTextCopy and Paste: ~A" val)))
	      (|XmTextFieldSetSelection txtf 1 2 current-time)
	      (IF (not (equal? (|XmTextFieldGetSelectionPosition txtf) (list #t 1 2)))
		  (snd-display ";XmTextFieldGetSelectionPosition: ~A" (|XmTextFieldGetSelectionPosition txtf)))
	      (|XmTextFieldCopy txtf current-time)
	      (|XmTextFieldSetInsertionPosition txtf 8)
	      (|XmTextFieldPaste txtf)
	      (let ((val (|XmTextGetString txtf)))
		(IF (not (string=? val "01234567189")) (snd-display ";XmTextFieldCopy and Paste: ~A" val)))
	      
	      (|XmTextSetMaxLength txt 1234)
	      (IF (not (= (|XmTextGetMaxLength txt) 1234)) (snd-display ";XmTextGetMaxLength: ~A" (|XmTextGetMaxLength txt)))
	      (|XmTextFieldSetMaxLength txtf 1234)
	      (IF (not (= (|XmTextFieldGetMaxLength txtf) 1234)) (snd-display ";XmTextFieldGetMaxLength: ~A" (|XmTextFieldGetMaxLength txtf)))
	      
	      (|XmTextSetCursorPosition txt 1)
	      (IF (not (= (|XmTextGetCursorPosition txt) 1)) (snd-display ";XmTextGetCursorPosition: ~A" (|XmTextGetCursorPosition txt)))
	      (|XmTextFieldSetCursorPosition txtf 1)
	      (IF (not (= (|XmTextFieldGetCursorPosition txtf) 1)) (snd-display ";XmTextFieldGetCursorPosition: ~A" (|XmTextFieldGetCursorPosition txtf)))
	      
	      (|XmTextReplace txt 0 2 "ab")
	      (let ((val (|XmTextGetString txt)))
		(IF (not (string=? val "ab234567189")) (snd-display ";XmTextReplace: ~A" val)))
	      (|XmTextFieldReplace txtf 0 2 "ab")
	      (let ((val (|XmTextFieldGetString txtf)))
		(IF (not (string=? val "ab234567189")) (snd-display ";XmTextFieldReplace: ~A" val)))
	      
	      (|XmTextDisableRedisplay txt)
	      (let ((pos (|XmTextFindString txt 0 "67" |XmTEXT_FORWARD)))
		(IF (or (not pos)
			(not (= pos 6)))
		    (snd-display ";XmTextFindString ~A" pos)))
	      (|XmTextEnableRedisplay txt)
	      (let ((base (|XmTextGetBaseline txt))
		    (center (|XmTextGetCenterline txt)))
		(IF (or (< base 0) (not (= center 0))) (snd-display ";XmTextGetCenter|Baseline: ~A ~A" base center)))
	      
	      (let ((pos (|XmTextGetLastPosition txt)))
		(IF (not (= pos 11)) (snd-display ";XmTextGetLastPosition: ~A" pos)))
	      (let ((pos (|XmTextFieldGetLastPosition txtf)))
		(IF (not (= pos 11)) (snd-display ";XmTextFieldGetLastPosition: ~A" pos)))
	      (let ((pos (|XmTextGetTopCharacter txt)))
		(IF (not (= pos 0)) (snd-display ";XmTextGetTopCharacter: ~A" pos)))
	      (let ((pos (|XmTextPosToXY txt 0)))
		(IF (not (number? (cadr pos))) (snd-display ";XmTextPosToXY: ~A" pos)))
	      (let ((pos (|XmTextFieldPosToXY txtf 0)))
		(IF (not (number? (cadr pos))) (snd-display ";XmTextFieldPosToXY: ~A" pos)))
	      
	      (|XmTextSetSelection txt 0 2 current-time)
	      (|XmTextRemove txt)
	      (let ((val (|XmTextGetString txt)))
		(IF (not (string=? val "234567189")) (snd-display ";XmTextRemove: ~A" val)))
	      (|XmTextFieldSetSelection txtf 0 2 current-time)
	      (|XmTextFieldRemove txtf)
	      (let ((val (|XmTextFieldGetString txtf)))
		(IF (not (string=? val "234567189")) (snd-display ";XmTextFieldRemove: ~A" val)))

	      (|XmTextInsert txt 0 "hi")
	      (let ((val (|XmTextGetString txt)))
		(IF (not (string=? val "hi234567189")) (snd-display ";XmTextInsert: ~A" val)))
	      (|XmTextFieldInsert txtf 0 "hi")
	      (let ((val (|XmTextFieldGetString txtf)))
		(IF (not (string=? val "hi234567189")) (snd-display ";XmTextFieldInsert: ~A" val)))
	      
	      (|XmTextScroll txt 1)
	      (|XmTextScroll txt -1)
	      (let ((pos (|XmTextGetTopCharacter txt)))
		(IF (not (= pos 0)) (snd-display ";XmTextGetTopCharacter after scroll: ~A" pos)))
	      (|XmTextShowPosition txt 0)
	      (|XmTextFieldShowPosition txtf 0)
	      (|XmTextSetTopCharacter txt 0)
	      (|XmTextXYToPos txt 10 10)
	      (|XmTextFieldXYToPos txtf 10 10)
	      
	      (|XmTextSetHighlight txt 3 6 |XmHIGHLIGHT_SELECTED)
	      (|XmTextFieldSetHighlight txtf 3 6 |XmHIGHLIGHT_SELECTED)
	      (|XmTextSetAddMode txt #t)
	      (IF (not (|XmTextGetAddMode txt)) (snd-display ";XmTextSetAddMode?"))
	      (|XmTextFieldSetAddMode txtf #t)
	      (IF (not (|XmTextFieldGetAddMode txtf)) (snd-display ";XmTextFieldSetAddMode?"))
	      
	      (IF (not (string=? (vector-ref calls 1) "dest")) (snd-display ";destination callback: ~A" (vector-ref calls 1)))
	      ;(IF (not (string=? (vector-ref calls 3) "focus")) (snd-display ";focus callback: ~A" (vector-ref calls 3)))
	      ;(IF (not (string=? (vector-ref calls 4) "losingfocus")) (snd-display ";losingfocus callback: ~A" (vector-ref calls 4)))
	      (IF (not (string=? (vector-ref calls 5) "gain")) (snd-display ";gain callback: ~A" (vector-ref calls 5)))
	      (IF (not (string=? (vector-ref calls 6) "lose")) (snd-display ";lose callback: ~A" (vector-ref calls 6)))
	      (IF (not (string=? (vector-ref calls 7) "modify")) (snd-display ";modify callback: ~A" (vector-ref calls 7)))
	      (IF (not (string=? (vector-ref calls 8) "motion")) (snd-display ";motion callback: ~A" (vector-ref calls 8)))
	      (IF (not (string=? (vector-ref calls 9) "value")) (snd-display ";value callback: ~A" (vector-ref calls 9)))

	      (let ((txtf1 (|XtVaCreateManagedWidget "textfield" |xmTextFieldWidgetClass frm
						       (list |XmNeditable #t
							     |XmNleftAttachment      |XmATTACH_FORM
							     |XmNrightAttachment     |XmATTACH_FORM
							     |XmNtopAttachment       |XmATTACH_WIDGET
							     |XmNtopWidget           txt
							     |XmNbottomAttachment    |XmATTACH_FORM
							     |XmNdestinationCallback
							      (list (lambda (w c info)
								      (let* ((dpy (|XtDisplay w))
									     (TARGETS (|XmInternAtom dpy "TARGETS" #f)))
									(|XmTransferValue (|transfer_id info) 
											  TARGETS 
											  transfer-proc
											  #f
											  (|XtLastTimestampProcessed dpy))))
								    #f)))))
		(focus-widget txtf1)
		(|XmTextFieldPaste txtf1)
		(IF (not (|Widget? (|XmGetTabGroup txtf1))) (snd-display ";XmGetTabGroup: ~A " (|XmGetTabGroup txtf1)))
		(let ((fw (|XmGetFocusWidget (cadr (main-widgets)))))
		  (IF (not (equal? fw txtf1))
		      (snd-display ";XmGetFocusWidget: ~A" fw))))

	      (|XtAppAddActions (car (main-widgets)) (list (list "hiho" (lambda args (snd-print "hiho")))))
	      (|XtAugmentTranslations txt (|XtParseTranslationTable "Ctrl <Key>i: hiho()\n"))
	      (|XtCallActionProc txt "hiho" (|XEvent) "" 0)
	      (|XtUninstallTranslations txt)

	      (|XtUnmanageChild frm)))

	    (let* ((shell (cadr (main-widgets)))
		   (dpy (|XtDisplay shell))
		   (win (|XtWindow shell))
		   (err (|XmClipboardRegisterFormat dpy "SND_DATA" 8)))
	      (if (not (= err |ClipboardSuccess)) 
		  (snd-display "XmClipboardRegisterFormat: ~A" err)
		  (let ((vals (|XmClipboardStartCopy dpy win
						     (|XmStringCreateLocalized "SND_DATA") 
						     (list 'Time |CurrentTime) 
						     shell
						     (lambda (w id pid reason)
						       (let ((status (|XmClipboardCopyByName dpy win id "copy this" 10 123))))))))
		    (IF (not (= (car vals) |ClipboardSuccess))
			(snd-display ";XmClipboardStartCopy: ~A" vals)
			(let ((data-id (cadr vals)))
			  (set! err (|XmClipboardCopy dpy win data-id "SND_DATA" "copy this" 10 0))
			  (IF (not (= (car err) |ClipboardSuccess)) (snd-display ";XmClipboardCopy: ~A" err))
			  (let ((item-id (cadr err)))
			    (set! err (|XmClipboardEndCopy dpy win data-id))
			    (IF (not (= err |ClipboardSuccess)) (snd-display (format "copy ~A" err)))
			    (IF (not (= (cadr (|XmClipboardInquireLength dpy win "SND_DATA")) 10))
				(snd-display "clip len: ~A" (|XmClipboardInquireLength dpy win "SND_DATA")))
			    (let ((pend (|XmClipboardInquirePendingItems dpy win "SND_DATA")))
			      (IF (not (= (car pend) |ClipboardSuccess)) (snd-display ";XmClipboardInquirePendingItems: ~A" pend)))
			    (let ((formats (|XmClipboardInquireCount dpy win)))
			      (IF (= (cadr formats) 0) (snd-display ";XmClipboardInquireCount: ~A" formats))
			      (let ((data (|XmClipboardInquireFormat dpy win 1 10)))
				(let ((clip (|XmClipboardRetrieve dpy win "SND_DATA" 10)))
				  (IF (not (string=? (cadr clip) "copy this")) (snd-display ";XmClipboardRetrieve: ~A" clip))
				  (|XmClipboardWithdrawFormat dpy win item-id))))))))))

	    (let* ((frm (add-main-pane "hi" |xmFormWidgetClass (list |XmNpaneMinimum 120)))
		   (current-time (list 'Time |CurrentTime))
		   (box (|XtCreateManagedWidget "box" |xmContainerWidgetClass frm '()))
		   (tgl (|XtCreateManagedWidget "tgl" |xmToggleButtonWidgetClass frm
						(list |XmNleftAttachment      |XmATTACH_FORM
						      |XmNrightAttachment     |XmATTACH_FORM
						      |XmNtopAttachment       |XmATTACH_FORM
						      |XmNbottomAttachment    |XmATTACH_NONE)))
		   (tgg (|XtCreateManagedWidget "tgg" |xmToggleButtonGadgetClass frm
						(list |XmNleftAttachment      |XmATTACH_FORM
						      |XmNrightAttachment     |XmATTACH_FORM
						      |XmNtopAttachment       |XmATTACH_WIDGET
						      |XmNtopWidget           tgl
						      |XmNbottomAttachment    |XmATTACH_NONE)))
		   (mnw (|XtCreateManagedWidget "mnw" |xmMainWindowWidgetClass frm
						(list |XmNcommandWindow       box
						      |XmNleftAttachment      |XmATTACH_FORM
						      |XmNrightAttachment     |XmATTACH_FORM
						      |XmNtopAttachment       |XmATTACH_WIDGET
						      |XmNtopWidget           tgg
						      |XmNbottomAttachment    |XmATTACH_NONE)))
		   (spn (|XtCreateManagedWidget "spn" |xmSimpleSpinBoxWidgetClass frm
						(list |XmNleftAttachment      |XmATTACH_FORM
						      |XmNrightAttachment     |XmATTACH_FORM
						      |XmNtopAttachment       |XmATTACH_WIDGET
						      |XmNtopWidget           mnw
						      |XmNbottomAttachment    |XmATTACH_NONE)))
		   (cmd (|XtCreateManagedWidget "cmd" |xmCommandWidgetClass frm
						(list |XmNleftAttachment      |XmATTACH_FORM
						      |XmNrightAttachment     |XmATTACH_FORM
						      |XmNtopAttachment       |XmATTACH_WIDGET
						      |XmNtopWidget           spn
						      |XmNbottomAttachment    |XmATTACH_NONE)))
		   (scl (|XtCreateManagedWidget "scl" |xmScaleWidgetClass frm
						(list |XmNleftAttachment      |XmATTACH_FORM
						      |XmNrightAttachment     |XmATTACH_FORM
						      |XmNtopAttachment       |XmATTACH_WIDGET
						      |XmNtopWidget           cmd
						      |XmNbottomAttachment    |XmATTACH_NONE)))
		   (notes (|XtCreateManagedWidget "notes" |xmNotebookWidgetClass frm
						(list |XmNleftAttachment      |XmATTACH_FORM
						      |XmNrightAttachment     |XmATTACH_FORM
						      |XmNtopAttachment       |XmATTACH_WIDGET
						      |XmNtopWidget           scl
						      |XmNbottomAttachment    |XmATTACH_NONE)))

		   (cmb (|XtCreateManagedWidget "cmb" |xmComboBoxWidgetClass frm
						(list |XmNleftAttachment      |XmATTACH_FORM
						      |XmNrightAttachment     |XmATTACH_FORM
						      |XmNtopAttachment       |XmATTACH_WIDGET
						      |XmNtopWidget           notes
						      |XmNbottomAttachment    |XmATTACH_FORM)))
		   (toggled 0))
	      (|XtCreateManagedWidget "one" |xmPushButtonWidgetClass notes '())
	      (|XtCreateManagedWidget "two" |xmPushButtonWidgetClass notes '())
	      (let ((info (cadr (|XmNotebookGetPageInfo notes 1))))
		(IF (not (= (|page_number info) 1)) (snd-display "page_number: ~A" (|page_number info)))
		(IF (|page_widget info) (snd-display "page_widget: ~A" (|page_widget info)))
		(IF (|status_area_widget info) (snd-display "status_area_widget: ~A" (|status_area_widget info)))
		(IF (not (|Widget? (|major_tab_widget info))) (snd-display "major_tab_widget: ~A" (|major_tab_widget info)))
		(IF (|minor_tab_widget info) (snd-display "minor_tab_widget: ~A" (|minor_tab_widget info))))

	      (|XmMainWindowSetAreas mnw #f box #f #f spn)
	      (IF (not (|Widget? (|XmMainWindowSep1 mnw))) (snd-display ";XmMainWindowSep1: ~A" (|XmMainWindowSep1 mnw)))
	      (IF (not (|Widget? (|XmMainWindowSep2 mnw))) (snd-display ";XmMainWindowSep2: ~A" (|XmMainWindowSep2 mnw)))
	      (IF (not (|Widget? (|XmMainWindowSep3 mnw))) (snd-display ";XmMainWindowSep3: ~A" (|XmMainWindowSep3 mnw)))
	      
	      (|XmSimpleSpinBoxAddItem spn (|XmStringCreateLocalized "hiho") 0)
	      (|XmSimpleSpinBoxAddItem spn (|XmStringCreateLocalized "away") 0)
	      (|XmSimpleSpinBoxDeletePos spn 0)
	      (let ((vals (|XtVaGetValues spn (list |XmNvalues 0))))
		(|XmSimpleSpinBoxSetItem spn (car (cadr vals))))
	      (|XmSimpleSpinBoxAddItem spn (|XmStringCreateLocalized "another") 0)
	      (let ((vals (|XtGetValues spn (list |XmNeditable 0 |XmNtextField 0))))
		(IF (not (list-ref vals 1)) (snd-display ";XmNeditable spin box"))
		(IF (not (|Widget? (list-ref vals 3))) (snd-display ";XmNtextField: ~A" (list-ref vals 3))))
	      
	      (|XtAddCallback tgl |XmNvalueChangedCallback (lambda (w c i) (set! toggled 123)) #f)
	      (|XmToggleButtonSetState tgl #f #f)
	      (|XmToggleButtonGadgetSetState tgg #f #f)
	      (IF (not (= toggled 0)) (snd-display ";toggle calledback: ~A?" toggled))
	      (IF (|XmToggleButtonGetState tgl) (snd-display ";XmToggleButtonSetState #f"))
	      (IF (|XmToggleButtonGadgetGetState tgg) (snd-display ";XmToggleButtonGadgetSetState #f"))
	      (|XtVaSetValues tgl (list |XmNtoggleMode |XmTOGGLE_INDETERMINATE))
	      (|XmToggleButtonSetValue tgl |XmINDETERMINATE #t)
	      (|XmToggleButtonGadgetSetValue tgg |XmINDETERMINATE #t)
	      (IF (not (= toggled 123)) (snd-display ";toggle not calledback: ~A?" toggled))
	      
	      (|XmCommandAppendValue cmd (|XmStringCreateLocalized "hiho"))
	      (|XmCommandError cmd (|XmStringCreateLocalized "hiho"))
	      (IF (not (|Widget? (|XmCommandGetChild cmd |XmDIALOG_COMMAND_TEXT)))
		  (snd-display ";XmCommandGetChild: ~A" (|XmCommandGetChild cmd |XmDIALOG_COMMAND_TEXT)))
	      (|XmCommandSetValue cmd (|XmStringCreateLocalized "hiho"))
	      
	      (let ((one (|XmStringCreateLocalized "one"))
		    (two (|XmStringCreateLocalized "two"))
		    (three (|XmStringCreateLocalized "three")))
		(|XmComboBoxAddItem cmb one 0 #f)
		(|XmComboBoxAddItem cmb two 0 #f)
		(|XmComboBoxAddItem cmb three 0 #f)
		(|XmComboBoxDeletePos cmb 1)
		(|XmComboBoxSelectItem cmb three)
		(|XmComboBoxSetItem cmb three) ; hunh??
		(|XmComboBoxUpdate cmb)
		(let ((vals (cadr (|XtGetValues cmb (list |XmNitems 0)))))
		  (IF (not (equal? vals (list two three))) (snd-display ";XmComboBox: ~A" vals))))

	      (|XmContainerCut box current-time)
	      (|XmContainerCopy box current-time)
	      (|XmContainerPaste box)
	      
	      (|XmScaleSetValue scl 25)
	      (IF (not (= (|XmScaleGetValue scl) 25)) (snd-display ";XmScaleSetValue: ~A" (|XmScaleGetValue scl)))
	      (IF (|XmGetTearOffControl (car (menu-widgets))) (snd-display ";XmGetTearOffControl: ~A" (|XmGetTearOffControl (car (menu-widgets)))))
	      (let ((children (cadr (|XtGetValues scl (list |XmNchildren 0)))))
		(for-each 
		 (lambda (w)
		   (let ((name (|XtName w)))
		     (if (and (|XmIsSeparatorGadget w)
			      (or (string=? name "BigTic")
				  (string=? name "MedTic")
				  (string=? name "SmallTic")))
			 (|XtDestroyWidget w))))
		 children))
	      (|XmScaleSetTicks scl 5 2 0 10 5 0)
	      )
	    
	    (let* ((shell (cadr (main-widgets)))
		   (dpy (|XtDisplay shell))
		   (screen (|XDefaultScreenOfDisplay dpy))
		   (vals (|XtGetValues shell 
				       (list |XmNscreen 0 |XmNtitleEncoding 0 |XmNbuttonFontList 0 |XmNaudibleWarning 0
					     |XmNpreeditType 0 |XmNtextRenderTable 0 |XmNtitle 0 |XmNwindowGroup 0 
					     |XmNargv 0 |XmNcolormap 0))))
	      (IF (not (equal? screen (list-ref vals 1))) (snd-display ";XmNscreen: ~A ~A" (list-ref vals 1) screen))
	      (IF (not (|Atom? (list-ref vals 3))) (snd-display ";XmNtitleEncoding: ~A" (list-ref vals 3)))
	      (IF (not (|XmFontList? (list-ref vals 5))) (snd-display ";XmNbuttonFontList: ~A" (list-ref vals 5)))
	      (IF (not (list-ref vals 7)) (snd-display ";XmNaudibleWarning: ~A" (list-ref vals 7)))
	      (IF (or (not (string? (list-ref vals 9)))
		      (not (string=? (list-ref vals 9) "OverTheSpot,OffTheSpot,Root,OnTheSpot")))
		  (snd-display ";XmNpreeditType: ~A" (list-ref vals 9)))
	      (IF (not (|XmRenderTable? (list-ref vals 11))) (snd-display ";XmNtextRenderTable: ~A" (list-ref vals 11)))
	      (IF (not (string=? (list-ref vals 13) "snd")) (snd-display ";XmNtitle: ~A" (list-ref vals 13)))
	      (IF (not (|Window? (list-ref vals 15))) (snd-display ";XmNwindowgroup: ~A" (list-ref vals 15)))
	      (IF (or (not (list? (list-ref vals 17)))
		      (not (string=? (car (list-ref vals 17)) "./snd")))
		  (snd-display ";XmNargv: ~A" (list-ref vals 17)))
	      (IF (not (|Colormap? (list-ref vals 19))) (snd-display ";XmNcolormap: ~A" (list-ref vals 19)))
	      )

	    (|XmSetColorCalculation #f)
	    (let* ((dpy (|XtDisplay (cadr (main-widgets))))
		   (scr1 (|DefaultScreen dpy))
		   (cmap (|DefaultColormap dpy scr1))
		   (screen (|XDefaultScreenOfDisplay dpy))
		   (scr (|XmGetXmScreen (|XDefaultScreenOfDisplay dpy)))
		   (old-h (cadr (|XtVaGetValues scr (list |XmNhorizontalFontUnit 0))))
		   (old-v (cadr (|XtVaGetValues scr (list |XmNverticalFontUnit 0)))))
	      (IF (not (|XmIsScreen scr)) (snd-display ";XmIsScreen: ~A" scr))
	      (let ((colors (|XmGetColors screen cmap (snd-pixel (basic-color)))))
		(IF (not (|Pixel? (car colors)))
		    (snd-display "colors: ~A " colors))
		(let ((color-proc (lambda (bg)
				    (list (white-pixel) (black-pixel) (white-pixel) (black-pixel)))))
		  (|XmSetColorCalculation color-proc)
		  (IF (not (equal? (|XmGetColorCalculation) color-proc))
		      (snd-display ";XmSetColorcalulcation ~A" (|XmGetColorCalculation)))))
	      (|XmSetFontUnits dpy 8 10)
	      (IF (or (not (= (cadr (|XtVaGetValues scr (list |XmNhorizontalFontUnit 0))) 8))
		      (not (= (cadr (|XtVaGetValues scr (list |XmNverticalFontUnit 0))) 10)))
		  (snd-display ";XmSetFontUnits: ~A" (|XtVaGetValues scr (list |XmNhorizontalFontUnit 0 |XmNverticalFontUnit 0))))
	      (let ((vals (|XtVaGetValues scr 
					  (list |XmNbitmapConversionModel 0 |XmNdarkThreshold 0 |XmNfont 0 |XmNunpostBehavior 0))))
		(IF (not (= (list-ref vals 1) |XmMATCH_DEPTH)) (snd-display ";XmNbitmapConversionModel: ~A" (list-ref vals 1)))
		(IF (not (= (list-ref vals 3) 0)) (snd-display ";XmNdarkThreshold: ~A" (list-ref vals 3)))
		(IF (not (|XFontStruct? (list-ref vals 5))) (snd-display ";XmNfont: ~A" (list-ref vals 5)))
		(IF (not (= (list-ref vals 7) |XmUNPOST_AND_REPLAY)) (snd-display ";XmNunpostBehavior: ~A" (list-ref vals 7)))
		))
	    (let ((dpy (|XtDisplay (cadr (main-widgets)))))
	      (let* ((dp (|XmGetXmDisplay dpy))
		     (vals (|XtVaGetValues dp
					   (list |XmNdragInitiatorProtocolStyle 0 |XmNenableThinThickness 0))))
		(IF (not (|XmIsDisplay dp)) (snd-display ";XmIsDisplay: ~A" dp))
		(IF (not (= (list-ref vals 1) |XmDRAG_PREFER_RECEIVER)) (snd-display ";XmNdragInitiatorProtocolStyle: ~A" (list-ref vals 1)))
		(IF (not (list-ref vals 3)) (snd-display ";XmNenableThinThickness?"))
		(|XtAddCallback dp |XmNdragStartCallback (lambda (w c i) #f)))
	      
	      (IF (not (string=? (|XmCvtXmStringToCT (|XmStringCreateLocalized "hiho")) "hiho"))
		  (snd-display "XmCvtXmStringToCT: ~A" (|XmCvtXmStringToCT (|XmStringCreateLocalized "hiho"))))
	      (let ((val (|XmConvertStringToUnits (|XDefaultScreenOfDisplay dpy) "3.14 in" |XmHORIZONTAL |XmINCHES)))
		(IF (not (= val 3)) (snd-display ";XmConvertStringToUnits in->in ~A" val)))
	      (let ((val (|XmConvertStringToUnits (|XDefaultScreenOfDisplay dpy) "3.14 in" |XmHORIZONTAL |XmPOINTS)))
		(IF (not (= val 225)) (snd-display ";XmConvertStringToUnits in->pts ~A" val)))
	      (let ((val (|XmConvertStringToUnits (|XDefaultScreenOfDisplay dpy) "3.14 in" |XmHORIZONTAL |XmCENTIMETERS)))
		(IF (not (= val 7)) (snd-display ";XmConvertStringToUnits in->cm ~A" val)))
	      (let ((val (|XmConvertUnits (cadr (main-widgets)) |XmHORIZONTAL |XmCENTIMETERS 7 |XmMILLIMETERS)))
		(IF (not (= val 70)) (snd-display ";XmConvertUnits cm->mm ~A" val)))
	      (let ((val (|XmConvertUnits (cadr (main-widgets)) |XmHORIZONTAL |XmCENTIMETERS 7 |XmPIXELS)))
		(IF (not (= val 278)) (snd-display ";XmConvertUnits cm->pix ~A" val)))
	      (|XmVaCreateSimpleRadioBox (caddr (main-widgets)) "hiho" 0 (lambda (w c i) #f) '())
	      (|XmVaCreateSimpleCheckBox (caddr (main-widgets)) "hiho" (lambda (w c i) #f) '())
	      (|XmVaCreateSimplePulldownMenu (caddr (main-widgets)) "hiho" 0 (lambda (w c i) #f) '())
	      (|XmVaCreateSimplePopupMenu (caddr (main-widgets)) "hiho" (lambda (w c i) #f) '())
	      (|XmVaCreateSimpleMenuBar (caddr (main-widgets)) "hiho" '())
	      (|XmVaCreateSimpleOptionMenu (caddr (main-widgets)) "hiho" 
					   (|XmStringCreateLocalized "away") 
					   (|XKeycodeToKeysym dpy |XK_b 0)
					   0  (lambda (w c i) #f) '())
	      
	      (IF (not (|XmIsMotifWMRunning (cadr (main-widgets)))) (snd-display ";XmIsMotifWMRunning?"))
	      (install-searcher (lambda (file) (= (mus-sound-srate file) 44100)))
	      (zync)
	      (make-hidden-controls-dialog)
	      (make-pixmap (cadr (main-widgets)) arrow-strs)
	      (display-scanned-synthesis)
	      (add-mark-pane)
	      (let ((ind (open-sound "oboe.snd")))
		(make-channel-drop-site ind 0))
	      (add-mark 123)
	      (add-selection-popup)
	      (let ((container
		     (make-sound-box "sounds"
				     (list-ref (main-widgets) 3)
				     (lambda (file) 
				       (mix file))
				     (lambda (file chn)
				       (define (without-directories filename)
					 (call-with-current-continuation
					  (lambda (return)
					    (do ((i (- (string-length filename) 1) (1- i)))
						((= 0 i) filename)
					      (if (char=? (string-ref filename i) #\/)
						  (return (substring filename (+ i 1))))))))
				       (format #f "~~/peaks/~A-peaks-~D" 
					       (without-directories (mus-expand-filename file)) 
					       chn))
				     (list "oboe.snd" "pistol.snd" "cardinal.snd" "storm.snd")
				     '())))
		(|XmContainerRelayout container)
		(let ((vals (|XtVaGetValues container 
			      (list |XmNlargeCellHeight 0 |XmNcollapsedStatePixmap 0 |XmNdetailOrder 0 |XmNdetailTabList 0
				    |XmNselectedObjects 0 |XmNconvertCallback 0 |XmNdestinationCallback 0 |XmNselectionCallback 0))))
		  (IF (not (= (list-ref vals 1) 0)) (snd-display ";XmNlargeCellHeight: ~A" (list-ref vals 1)))
		  (IF (not (|Pixmap? (list-ref vals 3))) (snd-display ";XmNcollapsedStatePixmap: ~A" (list-ref vals 3)))
		  (let ((func (lambda (w) 0)))
		    (|XtSetValues container (list |XmNinsertPosition func))
		    (let ((func1 (cadr (|XtGetValues container (list |XmNinsertPosition 0)))))
		      (IF (not (equal? func func1)) (snd-display ";XmNinsertPosition: ~A ~A" func func1))))))
	      
	      (show-smpte-label)
	      (with-level-meters 4)
	      (play)
	      (close-sound))

	    (let* ((shell (cadr (main-widgets)))
		   (dpy (|XtDisplay shell))
		   (prop (|XmInternAtom dpy "TESTING" #f))
		   (proto1 (|XmInternAtom dpy "TEST1" #f))
		   (proto2 (|XmInternAtom dpy "TEST2" #f))
		   (val 0))
	      (IF (not (|Atom? prop)) (snd-display ";XmInternAtom: ~A" prop))
	      (IF (not (string=? (|XmGetAtomName dpy prop) "TESTING")) (snd-display ";XmGetAtomName: ~A" (|XmGetAtomName dpy prop)))
	      (|XmAddProtocols shell prop (list proto1 proto2))
	      (|XmDeactivateProtocol shell prop proto2)
	      (|XmRemoveProtocols shell prop (list proto2))
	      (|XmAddProtocolCallback shell prop proto1 (lambda (w c i) (set! val c)) 123)
	      (|XmActivateProtocol shell prop proto1)
	      (let ((e (|XEvent |ClientMessage))
		    (window (|XtWindow shell)))
		(set! (|window e) window)
		(set! (|display e) dpy)
		(set! (|format e) 8)
		(set! (|message_type e) |XA_STRING)
		(set! (|data e) "hiho")
		(|XSendEvent dpy window #f 0 e))
	      (|XmRemoveProtocols shell prop (list proto1)))

	    (let* ((create-procs (list
			            |XmCreateMenuShell |XmCreateSimpleCheckBox |XmCreateSimpleRadioBox
			            |XmCreateSimpleOptionMenu |XmCreateSimplePulldownMenu |XmCreateSimplePopupMenu
			            |XmCreateSimpleMenuBar |XmCreateMainWindow |XmCreateScrolledList |XmCreateList
			            |XmCreateLabel |XmCreateLabelGadget |XmCreateToggleButton |XmCreateToggleButtonGadget
			            |XmCreateGrabShell |XmCreateFrame |XmCreateFormDialog |XmCreateForm |XmCreateText
			            |XmCreateScrolledText |XmCreateFileSelectionDialog |XmCreateFileSelectionBox
			            |XmCreateTextField |XmCreateSimpleSpinBox |XmCreateDrawnButton |XmCreateSpinBox
			            |XmCreateDrawingArea |XmCreateSeparator |XmCreateDragIcon |XmCreateSeparatorGadget
			            |XmCreatePromptDialog |XmCreateSelectionDialog |XmCreateSelectionBox
			            |XmCreateScrolledWindow |XmCreateDialogShell |XmCreateScrollBar |XmCreateScale
			            |XmCreateContainer |XmCreatePulldownMenu |XmCreatePopupMenu |XmCreateMenuBar
			            |XmCreateOptionMenu |XmCreateRadioBox |XmCreateWorkArea |XmCreateRowColumn
			            |XmCreateCommandDialog |XmCreateCommand |XmCreateDropDownList |XmCreateDropDownComboBox
			            |XmCreateComboBox |XmCreatePushButton |XmCreatePushButtonGadget |XmCreateCascadeButton
			            |XmCreateCascadeButtonGadget |XmCreateBulletinBoardDialog |XmCreateBulletinBoard
			            |XmCreatePanedWindow |XmCreateNotebook |XmCreateArrowButton |XmCreateArrowButtonGadget
			            |XmCreateTemplateDialog |XmCreateWorkingDialog |XmCreateWarningDialog
			            |XmCreateQuestionDialog |XmCreateInformationDialog |XmCreateErrorDialog
			            |XmCreateMessageDialog |XmCreateMessageBox |XmCreateIconGadget))
		   (parent (list-ref (main-widgets) 3))
		   (str (|XmStringCreateLocalized "yow"))
		   (args (list |XmNheight 100 |XmNwidth 100 |XmNlabelString str))
		   (ques (list   |XmMenuShell? #f #f #f #f
			         #f #f |XmMainWindow? #f |XmList?
			         |XmLabel? |XmLabelGadget? |XmToggleButton?
			         |XmToggleButtonGadget? |XmGrabShell? |XmFrame? #f |XmForm?
			         |XmText? #f #f |XmFileSelectionBox?
			         |XmTextField? #f |XmDrawnButton? #f |XmDrawingArea?
			         |XmSeparator? #f |XmSeparatorGadget? #f #f
			         |XmSelectionBox? |XmScrolledWindow? |XmDialogShell? |XmScrollBar?
			         |XmScale? |XmContainer? #f #f #f
			         #f #f #f |XmRowColumn? #f
			         |XmCommand? #f #f |XmComboBox? |XmPushButton?
			         |XmPushButtonGadget? |XmCascadeButton? |XmCascadeButtonGadget? #f
			         |XmBulletinBoard? |XmPanedWindow? |XmNotebook? |XmArrowButton? |XmArrowButtonGadget?
			         #f #f #f #f #f #f #f #f |XmIconGadget?))
		   (is (list   |XmIsMenuShell #f #f #f #f
		               #f #f |XmIsMainWindow #f |XmIsList
		               |XmIsLabel |XmIsLabelGadget |XmIsToggleButton
		               |XmIsToggleButtonGadget |XmIsGrabShell |XmIsFrame #f |XmIsForm
		               |XmIsText #f #f |XmIsFileSelectionBox
		               |XmIsTextField #f |XmIsDrawnButton #f |XmIsDrawingArea
		               |XmIsSeparator #f |XmIsSeparatorGadget #f #f
		               |XmIsSelectionBox |XmIsScrolledWindow |XmIsDialogShell |XmIsScrollBar
		               |XmIsScale |XmIsContainer #f #f #f
		               #f #f #f |XmIsRowColumn #f
		               |XmIsCommand #f #f |XmIsComboBox |XmIsPushButton
		               |XmIsPushButtonGadget |XmIsCascadeButton |XmIsCascadeButtonGadget #f
		               |XmIsBulletinBoard |XmIsPanedWindow |XmIsNotebook |XmIsArrowButton |XmIsArrowButtonGadget
		               #f #f #f #f #f #f #f #f |XmIsIconGadget)))
	      (for-each 
	       (lambda (n q qq)
		 (let ((wid (n parent "hiho" args)))
		   (IF (not (string=? (|XtName wid) "hiho"))
		       (snd-display ";~A name: ~A" wid (|XtName wid)))
		   (IF (not (|Widget? wid))
		       (snd-display ";~A not a widget?" wid))
		   (IF (and q (not (q wid)))
		       (snd-display ";~A is not ~A?" wid q))
		   (IF (and qq (not (qq wid)))
		       (snd-display ";~A is not ~A" wid qq))
		   ))
	       create-procs ques is))
      
	    (IF (not (|XEvent? (|XEvent)))
		(snd-display ";xevent type trouble! ~A -> ~A" (|XEvent) (|XEvent? (|XEvent))))
	    (IF (not (|XGCValues? (|XGCValues)))
		(snd-display ";xgcvalues type trouble! ~A -> ~A" (|XGCValues) (|XGCValues? (|XGCValues))))
      
	    (let* ((xm-procs 
		    ;; these can't be called in this context:
		    ;;   |XtProcessEvent |XtAppProcessEvent |XtMainLoop |XtAppMainLoop |XtAppAddActions |XtAddActions 
		    ;;   |XtNextEvent |XtAppNextEvent |XtPeekEvent |XtAppPeekEvent |XtMalloc |XtCalloc |XtRealloc |XtFree |XFree 
		    ;;   |freeXPoints |moveXPoints |vector->XPoints |XNextEvent |XPutBackEvent |XmParseMappingCreate |XmParseMappingSetValues 
		    ;;   |XReadBitmapFile |XReadBitmapFileData |XmTransferStartRequest |XmTransferSendRequest |XmTransferDone 
		    (list
		         |XpStartPage |XpEndPage |XpCancelPage |XpStartJob |XpEndJob |XpCancelJob |XpStartDoc |XpEndDoc
		         |XpCancelDoc |XpRehashPrinterList |XpCreateContext |XpSetContext |XpGetContext |XpDestroyContext
		         |XpGetLocaleNetString |XpNotifyPdm |XpSendAuth |XpGetImageResolution |XpGetAttributes |XpSetAttributes
		         |XpGetOneAttribute |XpGetScreenOfContext |XpFreePrinterList |XpQueryVersion |XpQueryExtension
		         |XpQueryScreens |XpGetPdmStartParams |XpGetAuthParams |XpSendOneTicket |XpGetPageDimensions
		         |XpSetImageResolution |XpGetPrinterList |XpSelectInput |XpInputSelected |XpPutDocumentData
		         |XpGetDocumentData |XtSetArg |XtManageChildren |XtManageChild |XtUnmanageChildren |XtUnmanageChild
		         |XtDispatchEvent |XtCallAcceptFocus |XtIsSubclass |XtIsObject |XtIsManaged |XtIsRealized
		         |XtIsSensitive |XtOwnSelection |XtOwnSelectionIncremental |XtMakeResizeRequest |XtTranslateCoords
		         |XtKeysymToKeycodeList |XtParseTranslationTable |XtParseAcceleratorTable |XtOverrideTranslations |XtAugmentTranslations
		         |XtInstallAccelerators |XtInstallAllAccelerators |XtUninstallTranslations |XtAppAddActionHook
		         |XtRemoveActionHook |XtGetActionList |XtCallActionProc |XtRegisterGrabAction |XtSetMultiClickTime
		         |XtGetMultiClickTime |XtGetActionKeysym |XtTranslateKeycode |XtTranslateKey |XtSetKeyTranslator
		         |XtRegisterCaseConverter |XtConvertCase |XtAddEventHandler |XtRemoveEventHandler |XtAddRawEventHandler
		         |XtRemoveRawEventHandler |XtInsertEventHandler |XtInsertRawEventHandler |XtDispatchEventToWidget
		         |XtBuildEventMask |XtAddGrab |XtRemoveGrab |XtAddExposureToRegion |XtSetKeyboardFocus
		         |XtGetKeyboardFocusWidget |XtLastEventProcessed |XtLastTimestampProcessed |XtAddTimeOut
		         |XtAppAddTimeOut |XtRemoveTimeOut |XtAddInput |XtAppAddInput |XtRemoveInput |XtPending |XtAppPending
		         |XtRealizeWidget |XtUnrealizeWidget |XtDestroyWidget |XtSetSensitive |XtNameToWidget |XtWindowToWidget
		         |XtMergeArgLists |XtVaCreateArgsList |XtDisplay |XtDisplayOfObject |XtScreen |XtScreenOfObject
		         |XtWindow |XtWindowOfObject |XtName |XtSuperclass |XtClass |XtParent |XtAddCallback |XtRemoveCallback
		         |XtAddCallbacks |XtRemoveCallbacks |XtRemoveAllCallbacks |XtCallCallbacks |XtCallCallbackList
		         |XtHasCallbacks |XtCreatePopupShell |XtVaCreatePopupShell |XtPopup |XtPopupSpringLoaded
		         |XtCallbackNone |XtCallbackNonexclusive |XtCallbackExclusive |XtPopdown |XtCallbackPopdown
		         |XtCreateWidget |XtCreateManagedWidget |XtVaCreateWidget |XtVaCreateManagedWidget
		         |XtCreateApplicationShell |XtAppCreateShell |XtVaAppCreateShell |XtToolkitInitialize
		         |XtSetLanguageProc |XtDisplayInitialize |XtOpenApplication |XtVaOpenApplication |XtAppInitialize
		         |XtVaAppInitialize |XtInitialize |XtOpenDisplay |XtCreateApplicationContext
		         |XtDestroyApplicationContext |XtInitializeWidgetClass |XtWidgetToApplicationContext
		         |XtDisplayToApplicationContext |XtCloseDisplay |XtSetValues |XtVaSetValues |XtGetValues |XtVaGetValues
		         |XtAppSetErrorMsgHandler |XtSetErrorMsgHandler |XtAppSetWarningMsgHandler |XtSetWarningMsgHandler
		         |XtAppErrorMsg |XtErrorMsg |XtAppWarningMsg |XtWarningMsg |XtAppSetErrorHandler |XtSetErrorHandler
		         |XtAppSetWarningHandler |XtSetWarningHandler |XtAppError |XtError |XtAppWarning |XtWarning
		         |XtAddWorkProc |XtAppAddWorkProc |XtRemoveWorkProc |XtGetGC |XtAllocateGC |XtDestroyGC |XtReleaseGC
		         |XtSetWMColormapWindows |XtFindFile |XtResolvePathname |XtDisownSelection |XtGetSelectionValue
		         |XtGetSelectionValues |XtAppSetSelectionTimeout |XtSetSelectionTimeout |XtAppGetSelectionTimeout
		         |XtGetSelectionTimeout |XtGetSelectionRequest |XtGetSelectionValueIncremental
		         |XtGetSelectionValuesIncremental |XtCreateSelectionRequest |XtSendSelectionRequest
		         |XtCancelSelectionRequest |XtGrabKey |XtUngrabKey
		         |XtGrabKeyboard |XtUngrabKeyboard |XtGrabButton |XtUngrabButton |XtGrabPointer |XtUngrabPointer
		         |XtGetApplicationNameAndClass |XtGetDisplays |XtToolkitThreadInitialize |XtAppLock |XtAppUnlock |XtIsRectObj |XtIsWidget
		         |XtIsComposite |XtIsConstraint |XtIsShell |XtIsOverrideShell |XtIsWMShell |XtIsVendorShell
		         |XtIsTransientShell |XtIsTopLevelShell |XtIsApplicationShell |XtIsSessionShell |XtMapWidget
		         |XtUnmapWidget |XLoadQueryFont |XQueryFont |XGetMotionEvents |XDeleteModifiermapEntry
		         |XGetModifierMapping |XInsertModifiermapEntry |XNewModifiermap |XCreateImage |XGetImage
		         |XGetSubImage |XOpenDisplay |XFetchBytes |XFetchBuffer |XGetAtomName |XDisplayName |XUniqueContext
		         |XKeysymToString |XSynchronize |XSetAfterFunction |XInternAtom |XCopyColormapAndFree |XCreateColormap
		         |XCreatePixmapCursor |XCreateGlyphCursor |XCreateFontCursor |XLoadFont |XCreateGC |XFlushGC
		         |XCreatePixmap |XCreateBitmapFromData |XCreatePixmapFromBitmapData |XCreateSimpleWindow
		         |XGetSelectionOwner |XCreateWindow |XListInstalledColormaps |XListFonts |XListFontsWithInfo
		         |XGetFontPath |XListExtensions |XListProperties |XKeycodeToKeysym |XLookupKeysym
		         |XGetKeyboardMapping |XStringToKeysym |XMaxRequestSize |XExtendedMaxRequestSize
		         |XDisplayMotionBufferSize |XVisualIDFromVisual
		         |XInitThreads |XLockDisplay |XUnlockDisplay |XRootWindow |XDefaultRootWindow |XRootWindowOfScreen
		         |XDefaultVisual |XDefaultVisualOfScreen |XDefaultGC |XDefaultGCOfScreen |XBlackPixel |XWhitePixel
		         |XAllPlanes |XBlackPixelOfScreen |XWhitePixelOfScreen |XNextRequest |XLastKnownRequestProcessed
		         |XServerVendor |XDisplayString |XDefaultColormap |XDefaultColormapOfScreen |XDisplayOfScreen
		         |XScreenOfDisplay |XDefaultScreenOfDisplay |XEventMaskOfScreen |XScreenNumberOfScreen
		         |XSetErrorHandler |XSetIOErrorHandler |XListPixmapFormats |XListDepths |XReconfigureWMWindow
		         |XGetWMProtocols |XSetWMProtocols |XIconifyWindow |XWithdrawWindow |XGetCommand |XGetWMColormapWindows
		         |XSetWMColormapWindows |XFreeStringList |XSetTransientForHint |XActivateScreenSaver
		         |XAllocColor |XAllocColorCells |XAllocColorPlanes |XAllocNamedColor
		         |XAllowEvents |XAutoRepeatOff |XAutoRepeatOn |XBell |XBitmapBitOrder |XBitmapPad |XBitmapUnit
		         |XCellsOfScreen |XChangeActivePointerGrab |XChangeGC |XChangeKeyboardControl |XChangeKeyboardMapping
		         |XChangePointerControl |XChangeProperty |XChangeWindowAttributes |XCheckIfEvent
		         |XCheckMaskEvent |XCheckTypedEvent |XCheckTypedWindowEvent |XCheckWindowEvent |XCirculateSubwindows
		         |XCirculateSubwindowsDown |XCirculateSubwindowsUp |XClearArea |XClearWindow |XCloseDisplay
		         |XConfigureWindow |XConnectionNumber |XConvertSelection |XCopyArea |XCopyGC |XCopyPlane |XDefaultDepth
		         |XDefaultDepthOfScreen |XDefaultScreen |XDefineCursor |XDeleteProperty |XDestroyWindow
		         |XDestroySubwindows |XDoesBackingStore |XDoesSaveUnders |XDisableAccessControl |XDisplayCells
		         |XDisplayHeight |XDisplayHeightMM |XDisplayKeycodes |XDisplayPlanes |XDisplayWidth |XDisplayWidthMM
		         |XDrawArc |XDrawArcs |XDrawImageString |XDrawLine |XDrawLines |XDrawLinesDirect |XDrawPoint
		         |XDrawPoints |XDrawRectangle |XDrawRectangles |XDrawSegments |XDrawString |XDrawText
		         |XEnableAccessControl |XEventsQueued |XFetchName |XFillArc |XFillArcs |XFillPolygon |XFillRectangle
		         |XFillRectangles |XFlush |XForceScreenSaver |XFreeColormap |XFreeColors |XFreeCursor
		         |XFreeExtensionList |XFreeFont |XFreeFontInfo |XFreeFontNames |XFreeFontPath |XFreeGC
		         |XFreeModifiermap |XFreePixmap |XGeometry |XGetErrorText |XGetFontProperty
		         |XGetGCValues |XGCValues |XEvent |XGetGeometry |XGetIconName |XGetInputFocus |XGetKeyboardControl
		         |XGetPointerControl |XGetPointerMapping |XGetScreenSaver |XGetTransientForHint |XGetWindowProperty
		         |XGetWindowAttributes |XGrabButton |XGrabKey |XGrabKeyboard |XGrabPointer |XGrabServer
		         |XHeightMMOfScreen |XHeightOfScreen |XIfEvent |XImageByteOrder |XInstallColormap |XKeysymToKeycode
		         |XKillClient |XLookupColor |XLowerWindow |XMapRaised |XMapSubwindows |XMapWindow |XMaskEvent
		         |XMaxCmapsOfScreen |XMinCmapsOfScreen |XMoveResizeWindow |XMoveWindow |XNoOp |XParseColor
		         |XParseGeometry |XPeekEvent |XPeekIfEvent |XPending |XPlanesOfScreen |XProtocolRevision
		         |XProtocolVersion |XPutImage |XQLength |XQueryBestCursor |XQueryBestSize |XQueryBestStipple
		         |XQueryBestTile |XQueryColor |XQueryColors |XQueryExtension |XQueryKeymap |XQueryPointer
		         |XQueryTextExtents |XQueryTree |XRaiseWindow |XRebindKeysym |XRecolorCursor |XRefreshKeyboardMapping
		         |XReparentWindow |XResetScreenSaver |XResizeWindow
		         |XRestackWindows |XRotateBuffers |XRotateWindowProperties |XScreenCount |XSelectInput |XSendEvent
		         |XSetAccessControl |XSetArcMode |XSetBackground |XSetClipMask |XSetClipOrigin |XSetClipRectangles
		         |XSetCloseDownMode |XSetCommand |XSetDashes |XSetFillRule |XSetFillStyle |XSetFont |XSetFontPath
		         |XSetForeground |XSetFunction |XSetGraphicsExposures |XSetIconName |XSetInputFocus |XSetLineAttributes
		         |XSetModifierMapping |XSetPlaneMask |XSetPointerMapping |XSetScreenSaver |XSetSelectionOwner
		         |XSetState |XSetStipple |XSetSubwindowMode |XSetTSOrigin |XSetTile |XSetWindowBackground
		         |XSetWindowBackgroundPixmap |XSetWindowBorder |XSetWindowBorderPixmap |XSetWindowBorderWidth
		         |XSetWindowColormap |XStoreBuffer |XStoreBytes |XStoreColor |XStoreColors |XStoreName
		         |XStoreNamedColor |XSync |XTextExtents |XTextWidth |XTranslateCoordinates |XUndefineCursor
		         |XUngrabButton |XUngrabKey |XUngrabKeyboard |XUngrabPointer |XUngrabServer |XUninstallColormap
		         |XUnloadFont |XUnmapSubwindows |XUnmapWindow |XVendorRelease |XWarpPointer |XWidthMMOfScreen
		         |XWidthOfScreen |XWindowEvent |XWriteBitmapFile |XSupportsLocale |XSetLocaleModifiers |XCreateFontSet
		         |XFreeFontSet |XFontsOfFontSet |XBaseFontNameListOfFontSet |XLocaleOfFontSet |XContextDependentDrawing
		         |XDirectionalDependentDrawing |XContextualDrawing |XFilterEvent |XAllocIconSize
		         |XAllocStandardColormap |XAllocWMHints |XClipBox |XCreateRegion |XDefaultString |XDeleteContext
		         |XDestroyRegion |XEmptyRegion |XEqualRegion |XFindContext |XGetIconSizes |XGetRGBColormaps
		         |XGetStandardColormap |XGetVisualInfo |XGetWMHints |XIntersectRegion |XConvertCase |XLookupString
		         |XMatchVisualInfo |XOffsetRegion |XPointInRegion |XPolygonRegion |XRectInRegion |XSaveContext
		         |XSetRGBColormaps |XSetWMHints |XSetRegion |XSetStandardColormap |XShrinkRegion |XSubtractRegion
		         |XUnionRectWithRegion |XUnionRegion |XXorRegion |DefaultScreen |DefaultRootWindow |QLength
		         |ScreenCount |ServerVendor |ProtocolVersion |ProtocolRevision |VendorRelease |DisplayString
		         |BitmapUnit |BitmapBitOrder |BitmapPad |ImageByteOrder |NextRequest |LastKnownRequestProcessed
		         |DefaultScreenOfDisplay |DisplayOfScreen |RootWindowOfScreen |BlackPixelOfScreen |WhitePixelOfScreen
		         |DefaultColormapOfScreen |DefaultDepthOfScreen |DefaultGCOfScreen |DefaultVisualOfScreen
		         |WidthOfScreen |HeightOfScreen |WidthMMOfScreen |HeightMMOfScreen |PlanesOfScreen |CellsOfScreen
		         |MinCmapsOfScreen |MaxCmapsOfScreen |DoesSaveUnders |DoesBackingStore |EventMaskOfScreen |RootWindow
		         |DefaultVisual |DefaultGC |BlackPixel |WhitePixel |DisplayWidth |DisplayHeight |DisplayWidthMM
		         |DisplayHeightMM |DisplayPlanes |DisplayCells |DefaultColormap |ScreenOfDisplay |DefaultDepth
		         |IsKeypadKey |IsPrivateKeypadKey |IsCursorKey |IsPFKey |IsFunctionKey |IsMiscFunctionKey
		         |IsModifierKey |XmCreateMessageBox |XmCreateMessageDialog |XmCreateErrorDialog
		         |XmCreateInformationDialog |XmCreateQuestionDialog |XmCreateWarningDialog |XmCreateWorkingDialog
		         |XmCreateTemplateDialog |XmMessageBoxGetChild |XmCreateArrowButtonGadget |XmCreateArrowButton
		         |XmCreateNotebook |XmNotebookGetPageInfo |XmPrintSetup |XmPrintToFile |XmPrintPopupPDM
		         |XmRedisplayWidget |XmTransferSetParameters |XmTransferValue |XmCreateComboBox
		         |XmCreateDropDownComboBox |XmCreateDropDownList |XmComboBoxAddItem |XmComboBoxDeletePos
		         |XmComboBoxSelectItem |XmComboBoxSetItem |XmComboBoxUpdate |XmCreateContainer
		         |XmContainerGetItemChildren |XmContainerRelayout |XmContainerReorder |XmContainerCut |XmContainerCopy
		         |XmContainerPaste |XmContainerCopyLink |XmContainerPasteLink |XmCreateSpinBox
		         |XmSpinBoxValidatePosition |XmCreateSimpleSpinBox |XmSimpleSpinBoxAddItem |XmSimpleSpinBoxDeletePos
		         |XmSimpleSpinBoxSetItem |XmDropSiteRegistered |XmTextFieldCopyLink |XmTextFieldPasteLink
		         |XmTextGetCenterline |XmToggleButtonGadgetSetValue |XmCreateIconGadget
		         |XmCreateIconHeader |XmObjectAtPoint |XmConvertStringToUnits |XmCreateGrabShell
		         |XmToggleButtonSetValue |XmTextPasteLink |XmTextCopyLink |XmScaleSetTicks |XmInternAtom |XmGetAtomName
		         |XmCreatePanedWindow |XmCreateBulletinBoard |XmCreateBulletinBoardDialog |XmCreateCascadeButtonGadget
		         |XmCascadeButtonGadgetHighlight |XmAddProtocols |XmRemoveProtocols |XmAddProtocolCallback
		         |XmRemoveProtocolCallback |XmActivateProtocol |XmDeactivateProtocol |XmSetProtocolHooks
		         |XmCreateCascadeButton |XmCascadeButtonHighlight |XmCreatePushButtonGadget |XmCreatePushButton
		         |XmCreateCommand |XmCommandGetChild |XmCommandSetValue |XmCommandAppendValue |XmCommandError
		         |XmCreateCommandDialog |XmMenuPosition |XmCreateRowColumn |XmCreateWorkArea |XmCreateRadioBox
		         |XmCreateOptionMenu |XmOptionLabelGadget |XmOptionButtonGadget |XmCreateMenuBar |XmCreatePopupMenu
		         |XmCreatePulldownMenu |XmGetPostedFromWidget |XmGetTearOffControl |XmAddToPostFromList
		         |XmRemoveFromPostFromList |XmScaleSetValue |XmScaleGetValue |XmCreateScale
		         |XmClipboardStartCopy |XmClipboardCopy |XmClipboardEndCopy |XmClipboardCancelCopy
		         |XmClipboardWithdrawFormat |XmClipboardCopyByName |XmClipboardUndoCopy |XmClipboardLock
		         |XmClipboardUnlock |XmClipboardStartRetrieve |XmClipboardEndRetrieve |XmClipboardRetrieve
		         |XmClipboardInquireCount |XmClipboardInquireFormat |XmClipboardInquireLength
		         |XmClipboardInquirePendingItems |XmClipboardRegisterFormat |XmGetXmScreen |XmCreateScrollBar
		         |XmScrollBarGetValues |XmScrollBarSetValues |XmCreateDialogShell |XmScrolledWindowSetAreas
		         |XmCreateScrolledWindow |XmScrollVisible |XmGetDragContext |XmGetXmDisplay |XmSelectionBoxGetChild
		         |XmCreateSelectionBox |XmCreateSelectionDialog |XmCreatePromptDialog |XmDragStart |XmDragCancel
		         |XmTargetsAreCompatible |XmCreateSeparatorGadget |XmCreateDragIcon |XmCreateSeparator
		         |XmCreateDrawingArea |XmCreateDrawnButton |XmDropSiteRegister |XmDropSiteUnregister
		         |XmDropSiteStartUpdate |XmDropSiteUpdate |XmDropSiteEndUpdate |XmDropSiteRetrieve
		         |XmDropSiteQueryStackingOrder |XmDropSiteConfigureStackingOrder |XmDropTransferStart
		         |XmDropTransferAdd |XmTextFieldGetString |XmTextFieldGetSubstring |XmTextFieldGetLastPosition
		         |XmTextFieldSetString |XmTextFieldReplace |XmTextFieldInsert |XmTextFieldSetAddMode
		         |XmTextFieldGetAddMode |XmTextFieldGetEditable |XmTextFieldSetEditable |XmTextFieldGetMaxLength
		         |XmTextFieldSetMaxLength |XmTextFieldGetCursorPosition |XmTextFieldGetInsertionPosition
		         |XmTextFieldSetCursorPosition |XmTextFieldSetInsertionPosition |XmTextFieldGetSelectionPosition
		         |XmTextFieldGetSelection |XmTextFieldRemove |XmTextFieldCopy |XmTextFieldCut |XmTextFieldPaste
		         |XmTextFieldClearSelection |XmTextFieldSetSelection |XmTextFieldXYToPos |XmTextFieldPosToXY
		         |XmTextFieldShowPosition |XmTextFieldSetHighlight |XmTextFieldGetBaseline |XmCreateTextField
		         |XmFileSelectionBoxGetChild |XmFileSelectionDoSearch |XmCreateFileSelectionBox
		         |XmCreateFileSelectionDialog |XmTextSetHighlight |XmCreateScrolledText |XmCreateText
		         |XmTextGetSubstring |XmTextGetString |XmTextGetLastPosition |XmTextSetString |XmTextReplace
		         |XmTextInsert |XmTextSetAddMode |XmTextGetAddMode |XmTextGetEditable |XmTextSetEditable
		         |XmTextGetMaxLength |XmTextSetMaxLength |XmTextGetTopCharacter |XmTextSetTopCharacter
		         |XmTextGetCursorPosition |XmTextGetInsertionPosition |XmTextSetInsertionPosition
		         |XmTextSetCursorPosition |XmTextRemove |XmTextCopy |XmTextCut |XmTextPaste |XmTextGetSelection
		         |XmTextSetSelection |XmTextClearSelection |XmTextGetSelectionPosition |XmTextXYToPos |XmTextPosToXY
		         |XmTextGetSource |XmTextSetSource |XmTextShowPosition |XmTextScroll |XmTextGetBaseline
		         |XmTextDisableRedisplay |XmTextEnableRedisplay |XmTextFindString |XmCreateForm |XmCreateFormDialog
		         |XmCreateFrame |XmToggleButtonGadgetGetState |XmToggleButtonGadgetSetState |XmCreateToggleButtonGadget
		         |XmToggleButtonGetState |XmToggleButtonSetState |XmCreateToggleButton |XmCreateLabelGadget
		         |XmCreateLabel |XmIsMotifWMRunning |XmListAddItem |XmListAddItems |XmListAddItemsUnselected
		         |XmListAddItemUnselected |XmListDeleteItem |XmListDeleteItems |XmListDeletePositions |XmListDeletePos
		         |XmListDeleteItemsPos |XmListDeleteAllItems |XmListReplaceItems |XmListReplaceItemsPos
		         |XmListReplaceItemsUnselected |XmListReplaceItemsPosUnselected |XmListReplacePositions
		         |XmListSelectItem |XmListSelectPos |XmListDeselectItem |XmListDeselectPos |XmListDeselectAllItems
		         |XmListSetPos |XmListSetBottomPos |XmListSetItem |XmListSetBottomItem |XmListSetAddMode
		         |XmListItemExists |XmListItemPos |XmListGetKbdItemPos |XmListSetKbdItemPos |XmListYToPos
		         |XmListPosToBounds |XmListGetMatchPos |XmListGetSelectedPos |XmListSetHorizPos
		         |XmListUpdateSelectedList |XmListPosSelected |XmCreateList |XmCreateScrolledList |XmTranslateKey
		         |XmMainWindowSetAreas |XmMainWindowSep1 |XmMainWindowSep2 |XmMainWindowSep3 |XmCreateMainWindow
		         |XmInstallImage |XmUninstallImage |XmGetPixmap |XmGetPixmapByDepth |XmDestroyPixmap |XmUpdateDisplay
		         |XmWidgetGetBaselines |XmRegisterSegmentEncoding |XmMapSegmentEncoding
		         |XmCvtCTToXmString |XmCvtXmStringToCT |XmConvertUnits |XmSetFontUnits |XmSetFontUnit |XmSetMenuCursor
		         |XmGetMenuCursor |XmCreateSimpleMenuBar |XmCreateSimplePopupMenu |XmCreateSimplePulldownMenu
		         |XmCreateSimpleOptionMenu |XmCreateSimpleRadioBox |XmCreateSimpleCheckBox |XmVaCreateSimpleMenuBar
		         |XmVaCreateSimplePopupMenu |XmVaCreateSimplePulldownMenu |XmVaCreateSimpleOptionMenu
		         |XmVaCreateSimpleRadioBox |XmVaCreateSimpleCheckBox |XmTrackingEvent |XmTrackingLocate
		         |XmSetColorCalculation |XmGetColorCalculation |XmGetColors |XmChangeColor |XmStringCreate
		         |XmStringCreateSimple |XmStringCreateLocalized |XmStringDirectionCreate |XmStringSeparatorCreate
		         |XmStringSegmentCreate |XmStringCreateLtoR |XmStringInitContext
		         |XmStringFreeContext |XmStringGetNextComponent |XmStringPeekNextComponent |XmStringGetNextSegment
		         |XmStringGetLtoR |XmFontListEntryCreate |XmFontListEntryCreate_r |XmFontListCreate_r
		         |XmStringConcatAndFree |XmStringIsVoid |XmStringPeekNextTriple |XmStringGetNextTriple
		         |XmStringComponentCreate |XmStringUnparse |XmStringParseText |XmStringToXmStringTable
		         |XmStringTableToXmString |XmStringTableUnparse |XmStringTableParseStringArray
		         |XmDirectionToStringDirection |XmStringDirectionToDirection |XmStringGenerate |XmStringPutRendition
		         |XmParseMappingGetValues |XmParseMappingFree |XmParseTableFree |XmStringTableProposeTablist
		         |XmTabSetValue |XmTabGetValues |XmTabFree |XmTabCreate |XmTabListTabCount |XmTabListRemoveTabs
		         |XmTabListReplacePositions |XmTabListGetTab |XmTabListCopy |XmTabListInsertTabs
		         |XmRenderTableCvtFromProp |XmRenderTableCvtToProp |XmRenditionUpdate |XmRenditionRetrieve
		         |XmRenditionFree |XmRenditionCreate |XmRenderTableGetRenditions |XmRenderTableGetRendition
		         |XmRenderTableGetTags |XmRenderTableFree |XmRenderTableCopy |XmRenderTableRemoveRenditions
		         |XmRenderTableAddRenditions |XmFontListEntryFree |XmFontListEntryGetFont |XmFontListEntryGetTag
		         |XmFontListAppendEntry |XmFontListNextEntry |XmFontListRemoveEntry |XmFontListEntryLoad
		         |XmFontListCreate |XmFontListFree |XmFontListAdd |XmFontListCopy
		         |XmFontListInitFontContext |XmFontListGetNextFont |XmFontListFreeFontContext |XmStringConcat
		         |XmStringNConcat |XmStringCopy |XmStringNCopy |XmStringByteCompare |XmStringCompare |XmStringLength
		         |XmStringEmpty |XmStringHasSubstring |XmStringFree |XmStringBaseline |XmStringWidth |XmStringHeight
		         |XmStringExtent |XmStringLineCount |XmStringDraw |XmStringDrawImage |XmStringDrawUnderline
		         |XmGetDestination |XmIsTraversable |XmGetVisibility |XmGetTabGroup |XmGetFocusWidget
		         |XmProcessTraversal |XmCreateMenuShell |XmIsMessageBox
		         |XmIsArrowButtonGadget |XmIsArrowButton |XmIsNotebook |XmIsPrintShell |XmIsComboBox |XmIsContainer
		         |XmIsGrabShell |XmIsIconGadget |XmIsIconHeader |XmIsPanedWindow |XmIsBulletinBoard |XmIsPrimitive
		         |XmIsCascadeButtonGadget |XmIsCascadeButton |XmIsPushButtonGadget |XmIsPushButton |XmIsCommand
		         |XmIsRowColumn |XmIsScale |XmIsScreen |XmIsScrollBar |XmIsDialogShell |XmIsScrolledWindow |XmIsDisplay
		         |XmIsSelectionBox |XmIsDragContext |XmIsSeparatorGadget |XmIsDragIconObjectClass
		         |XmIsSeparator |XmIsDrawingArea |XmIsDrawnButton |XmIsDropSiteManager |XmIsDropTransfer |XmIsTextField
		         |XmIsFileSelectionBox |XmIsText |XmIsForm |XmIsFrame |XmIsGadget |XmIsToggleButtonGadget
		         |XmIsToggleButton |XmIsLabelGadget |XmIsLabel |XmIsVendorShell |XmIsList |XmIsMainWindow |XmIsManager
		         |XmIsMenuShell |XpmCreatePixmapFromData |XpmCreateDataFromPixmap |XpmReadFileToPixmap
		         |XpmReadPixmapFile |XpmWriteFileFromPixmap |XpmWritePixmapFile |XpmCreatePixmapFromBuffer
		         |XpmCreateBufferFromImage |XpmCreateBufferFromPixmap |XpmCreatePixmapFromXpmImage
		         |XpmCreateXpmImageFromPixmap |XGetPixel |XDestroyImage |XPutPixel |XSubImage |XAddPixel
		         |XtAppContext? |XtRequestId?  |XtWorkProcId? |XtInputId?  |XtIntervalId? |Screen?  |XEvent?
		         |XRectangle? |XArc? |XPoint?  |XSegment?  |XColor? |Atom? |Colormap?
		         |XModifierKeymap? |Depth?  |Display? |Drawable?  |Font? |GC?  |KeySym? |Pixel?  |Pixmap? |Region?
		         |Time? |Visual? |Window?  |XFontProp? |XFontSet?  |XFontStruct? |XGCValues?  |XImage?  |XVisualInfo?
		         |XWMHints? |XWindowAttributes? |XWindowChanges?  |KeyCode? |XContext?  |XCharStruct? |XTextItem?
		         |XStandardColormap?  |Substitution?  |XPContext?  |Widget?  |XmStringContext? |WidgetClass? |XmString?
		         |XmToggleButton?  |XmDrawingArea? |XmPushButton?  |XmTextField?  |XmFileSelectionBox?  |XmText?
		         |XmFrame? |XmLabel? |XmList?  |XmArrowButton?  |XmScrollBar? |XmCommand? |XmScale?  |XmRowColumn?
		         |XmTab? |XmNotebook?  |XmPrintShell?  |XmComboBox? |XmContainer? |XmIconHeader?
		         |XmGrabShell? |XmRendition? |XmRenderTable?  |XmIconGadget?  |XmTabList? |XmParseMapping?
		         |XmPanedWindow?  |XmScrolledWindow? |XmCascadeButton?  |XmForm?  |XmBulletinBoard? |XmScreen?
		         |XmDialogShell? |XmDisplay?  |XmSelectionBox?  |XmDragContext?  |XmDragIconObjectClass?  |XmSeparator?
		         |XmDropSiteManager? |XmDropTransfer?  |XmVendorShell?  |XmMainWindow? |XmMessageBox?  |XmManager?
		         |XmMenuShell?  |XmLabelGadget?  |XmPushButtonGadget?  |XmSeparatorGadget?  |XmArrowButtonGadget?
		         |XmCascadeButtonGadget?  |XmToggleButtonGadget?  |XmDrawnButton?  |XmPrimitive? |XmFontList?
		         |XmFontContext?  |XmFontListEntry? |XmTextSource?  |XpmAttributes?  |XpmImage?  |XpmColorSymbol?
			  ))
		   (xm-procs0 (remove-if (lambda (n) (not (arity-ok n 0))) xm-procs))
		   (xm-procs1 (remove-if (lambda (n) (not (arity-ok n 1))) xm-procs))
		   (xm-procs2 (remove-if (lambda (n) (not (arity-ok n 2))) xm-procs))
		   (xm-procs3 (remove-if (lambda (n) (not (arity-ok n 3))) xm-procs))
		   (xm-procs4 (remove-if (lambda (n) (not (arity-ok n 4))) xm-procs))
		   )

	      ;; ---------------- 0 Args
	      (for-each 
	       (lambda (n)
		 (catch #t
			(lambda () 
			  (n))
			(lambda args (car args))))
	       xm-procs0)
	      
	      ;; ---------------- 1 Arg
	      (for-each 
	       (lambda (arg)
		 (for-each 
		  (lambda (n)
		    (catch #t
			   (lambda () (n arg))
			   (lambda args (car args))))
		  xm-procs1))
	       (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) (make-color .95 .95 .95)  '#(0 1) 3/4 'mus-error (sqrt -1.0) (make-delay 32)
		     (lambda () #t) (current-module) (make-sound-data 2 3) :order 0 1 -1 (make-hook 2) #f #t '() 12345678901234567890))
	      
	      ;; ---------------- 2 Args
	      (for-each 
	       (lambda (arg1)
		 (for-each 
		  (lambda (arg2)
		    (for-each 
		     (lambda (n)
		       (catch #t
			      (lambda () (n arg1 arg2))
			      (lambda args (car args))))
		     xm-procs2))
		  (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) (make-color .95 .95 .95) '#(0 1) 3/4 
			(sqrt -1.0) (make-delay 32) :feedback -1 0 #f #t '() 12345678901234567890)))
	       (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) (make-color .95 .95 .95) '#(0 1) 3/4 
		     (sqrt -1.0) (make-delay 32) :frequency -1 0 #f #t '() 12345678901234567890))
	      
	      (if all-args
		  (begin
		    
		    ;; ---------------- 3 Args
		    (for-each 
		     (lambda (arg1)
		       (for-each 
			(lambda (arg2)
			  (for-each 
			   (lambda (arg3)
			     (for-each 
			      (lambda (n)
				(catch #t
				       (lambda () (n arg1 arg2 arg3))
				       (lambda args (car args))))
			      xm-procs3))
			   (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) '#(0 1) (sqrt -1.0) (make-delay 32) :start -1 0 #f #t '() 12345678901234567890)))
			(list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) '#(0 1) (sqrt -1.0) (make-delay 32) :phase -1 0 #f #t '() 12345678901234567890)))
		     (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) '#(0 1) (sqrt -1.0) (make-delay 32) :channels -1 0 #f #t '() 12345678901234567890))
		    
		    ;; ---------------- 4 Args
		    (for-each 
		     (lambda (arg1)
		       (for-each 
			(lambda (arg2)
			  (for-each 
			   (lambda (arg3)
			     (for-each 
			      (lambda (arg4)
				(for-each 
				 (lambda (n)
				   (catch #t
					  (lambda () (n arg1 arg2 arg3 arg4))
					  (lambda args (car args))))
				 xm-procs4))
			      (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) '#(0 1) (sqrt -1.0) (make-delay 32) :start -1 0 #f #t '() 12345678901234567890)))
			   (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) '#(0 1) (sqrt -1.0) (make-delay 32) :phase -1 0 #f #t '() 12345678901234567890)))
			(list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) '#(0 1) (sqrt -1.0) (make-delay 32) :channels -1 0 #f #t '() 12345678901234567890)))
		     (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) '#(0 1) (sqrt -1.0) (make-delay 32) :channels -1 0 #f #t '() 12345678901234567890))
		    ))
	      
	      (let ((struct-accessors (list  |pixel |red |green |blue |flags |pad |x |y |width |height |angle1 |angle2
				|x1 |y1 |x2 |y2 |dashes |dash_offset |clip_mask |clip_y_origin |clip_x_origin |graphics_exposures
				|subwindow_mode |font |ts_y_origin |ts_x_origin |stipple |tile |arc_mode |fill_rule |fill_style
				|join_style |cap_style |line_style |line_width |background |foreground |plane_mask |function |delta
				|nchars |chars |name |depth |visual |mwidth |mheight |ndepths |depths |root_depth |root_visual
				|default_gc |cmap |white_pixel |black_pixel |max_maps |min_maps |backing_store |save_unders |root_input_mask
				|lbearing |rbearing |ascent |descent |attributes |card32 |fid |properties |min_bounds |max_bounds |per_char
				|input |initial_state |icon_pixmap |icon_window |icon_x |icon_y |icon_mask |window_group |visualid
				|class  |red_mask |green_mask |blue_mask |bits_per_rgb |map_entries |nvisuals |visuals |bits_per_pixel
				|background_pixmap |background_pixel |border_pixmap |border_pixel |bit_gravity |win_gravity |backing_planes
				|backing_pixel |save_under |event_mask |do_not_propagate_mask |cursor |map_installed |map_state |all_event_masks
				|your_event_mask |screen |xoffset |byte_order |bitmap_unit |bitmap_bit_order |bitmap_pad |bytes_per_line
				|obdata |sibling |stack_mode |red_max |red_mult |green_max |green_mult |blue_max |blue_mult |base_pixel
				|killid |data |min_height |max_height |min_width |max_width |height_inc |width_inc |page_number
				|page_widget |status_area_widget |major_tab_widget |minor_tab_widget |source_data |location_data |parm
				|parm_format |parm_length |parm_type |transfer_id |destination_data |remaining |item_or_text |auto_selection_type
				|new_outline_state |prev_page_number |prev_page_widget |rendition |render_table |last_page |crossed_boundary
				|client_data |status |font_name |tag |traversal_destination |dragProtocolStyle |direction |reason
				|timeStamp |operation |operations |dropSiteStatus |dropAction |iccHandle |completionStatus |dragContext
				|animate |length |click_count |widget |item_position |callbackstruct
				|set |item |item_length |selected_items |selected_item_count |selected_item_positions |selection_type
				|mask |mask_length |dir |dir_length |pattern |pattern_length |position |currInsert |newInsert |startPos
				|endPos |text |request_code |error_code |first_keycode |request |resourceid |format |message_type |new
				|property |display |target |requestor |owner |selection |atom |place |value_mask |above |from_configure
				|event |override_redirect |border_width |parent |minor_code |major_code |drawable |count |key_vector |focus
				|detail |mode |is_hint |button |same_screen |keycode |state |y_root |x_root |root |time |subwindow |window
				|send_event |serial |type |value |doit |colormap |menuToPost |postIt |valuemask |ncolors |cpp
				|numsymbols |colorsymbols |npixels |y_hotspot |x_hotspot))

		    (struct-accessor-names (list  '|pixel '|red '|green '|blue '|flags '|pad '|x '|y '|width '|height '|angle1 '|angle2
				'|x1 '|y1 '|x2 '|y2 '|dashes '|dash_offset '|clip_mask '|clip_y_origin '|clip_x_origin '|graphics_exposures
				'|subwindow_mode '|font '|ts_y_origin '|ts_x_origin '|stipple '|tile '|arc_mode '|fill_rule '|fill_style
				'|join_style '|cap_style '|line_style '|line_width '|background '|foreground '|plane_mask '|function '|delta
				'|nchars '|chars '|name '|depth '|visual '|mwidth '|mheight '|ndepths '|depths '|root_depth '|root_visual
				'|default_gc '|cmap '|white_pixel '|black_pixel '|max_maps '|min_maps '|backing_store '|save_unders '|root_input_mask
				'|lbearing '|rbearing '|ascent '|descent '|attributes '|card32 '|fid '|properties '|min_bounds '|max_bounds '|per_char
				'|input '|initial_state '|icon_pixmap '|icon_window '|icon_x '|icon_y '|icon_mask '|window_group '|visualid
				'|class  '|red_mask '|green_mask '|blue_mask '|bits_per_rgb '|map_entries '|nvisuals '|visuals '|bits_per_pixel
				'|background_pixmap '|background_pixel '|border_pixmap '|border_pixel '|bit_gravity '|win_gravity '|backing_planes
				'|backing_pixel '|save_under '|event_mask '|do_not_propagate_mask '|cursor '|map_installed '|map_state '|all_event_masks
				'|your_event_mask '|screen '|xoffset '|byte_order '|bitmap_unit '|bitmap_bit_order '|bitmap_pad '|bytes_per_line
				'|obdata '|sibling '|stack_mode '|red_max '|red_mult '|green_max '|green_mult '|blue_max '|blue_mult '|base_pixel
				'|killid '|data '|min_height '|max_height '|min_width '|max_width '|height_inc '|width_inc '|page_number
				'|page_widget '|status_area_widget '|major_tab_widget '|minor_tab_widget '|source_data '|location_data '|parm
				'|parm_format '|parm_length '|parm_type '|transfer_id '|destination_data '|remaining '|item_or_text '|auto_selection_type
				'|new_outline_state '|prev_page_number '|prev_page_widget '|rendition '|render_table '|last_page '|crossed_boundary
				'|client_data '|status '|font_name '|tag '|traversal_destination '|dragProtocolStyle '|direction '|reason
				'|timeStamp '|operation '|operations '|dropSiteStatus '|dropAction '|iccHandle '|completionStatus '|dragContext
				'|animate '|length '|click_count '|widget '|item_position '|callbackstruct
				'|set '|item '|item_length '|selected_items '|selected_item_count '|selected_item_positions '|selection_type
				'|mask '|mask_length '|dir '|dir_length '|pattern '|pattern_length '|position '|currInsert '|newInsert '|startPos
				'|endPos '|text '|request_code '|error_code '|first_keycode '|request '|resourceid '|format '|message_type '|new
				'|property '|display '|target '|requestor '|owner '|selection '|atom '|place '|value_mask '|above '|from_configure
				'|event '|override_redirect '|border_width '|parent '|minor_code '|major_code '|drawable '|count '|key_vector '|focus
				'|detail '|mode '|is_hint '|button '|same_screen '|keycode '|state '|y_root '|x_root '|root '|time '|subwindow '|window
				'|send_event '|serial '|type '|value '|doit '|colormap '|menuToPost '|postIt '|valuemask '|ncolors '|cpp
				'|numsymbols '|colorsymbols '|npixels '|y_hotspot '|x_hotspot)))

		;; ---------------- 0 Args
		(for-each 
		 (lambda (n name)
		   (let ((tag
			  (catch #t
				 (lambda () 
				   (n))
				 (lambda args (car args)))))
		     (if (not (eq? tag 'wrong-number-of-args))
			 (snd-display ";(~A) -> ~A" name tag)))
		   (if (procedure-with-setter? n)
		       (let ((tag
			      (catch #t
				     (lambda () 
				       (set! (n) 0))
				     (lambda args (car args)))))
			 (IF (not (eq? tag 'wrong-number-of-args))
			     (snd-display ";(~A) -> ~A" name tag)))))
		 struct-accessors
		 struct-accessor-names)
		
		;; ---------------- 1 Arg
		(for-each 
		 (lambda (arg)
		   (for-each 
		    (lambda (n name)
		      (let ((tag 
			     (catch #t
				    (lambda () (n arg))
				    (lambda args (car args)))))
			(if (not (eq? tag 'wrong-type-arg))
			    (snd-display ";(~A ~A) -> ~A" name arg tag)))
		      (if (procedure-with-setter? n)
			  (let ((tag 
				 (catch #t
					(lambda () (set! (n arg) 0))
					(lambda args (car args)))))
			    (if (not (eq? tag 'wrong-type-arg))
				(snd-display ";(~A ~A) -> ~A" name arg tag)))))
		    struct-accessors
		    struct-accessor-names))
		 (list 1.5 "/hiho" (list 0 1) 1234 #f #t '())))
	      (gc))
	      ))))


;;; -------------------- test 24: Gtk --------------------

(if (or full-test (= snd-test 24) (and keep-going (<= snd-test 24)))
    (begin
      (if (procedure? test-hook) (test-hook 24))
      (if (and (provided? 'snd-gtk)
	       (provided? 'xg))
	  (begin
	    (IF (not (|GTK_IS_WIDGET (cadr (main-widgets)))) (snd-display ";GTK_IS_WIDGET?"))
	    ))))


;;; ---------------- test 25: errors ----------------

(mem-report)
(if (file-exists? "memlog")
    (system "mv memlog memlog.22")) ; save pre-error version

(define (check-error-tag expected-tag thunk)
  (let ((tag
	 (catch #t 
		thunk
		(lambda args (car args)))))
    (IF (not (eq? tag expected-tag))
	(snd-display "check-error-tag ~A from ~A: ~A" 
			   expected-tag (procedure-source thunk) tag))))

(defvar env3 '(0 0 1 1))
(set! (with-background-processes) #t)

(define procs (list 
	       add-mark add-player add-sound-file-extension add-to-main-menu add-to-menu add-transform amp-control
	       append-to-minibuffer as-one-edit ask-before-overwrite audio-input-device audio-output-device
	       audio-state-file auto-resize auto-update autocorrelate axis-info axis-label-font axis-numbers-font
	       backward-graph backward-mark backward-mix backward-sample basic-color bind-key bold-button-font bomb
	       button-font c-g?  apply-controls change-menu-label change-samples-with-origin channel-style
	       channel-widgets channels chans clear-audio-inputs close-sound close-sound-file color-cutoff color-dialog
	       color-inverted color-scale color->list colormap color?  comment contrast-control contrast-control-amp
	       contrast-control?  convolve-arrays convolve-selection-with convolve-with channel-properties
	       auto-update-interval count-matches current-font cursor cursor-color cursor-follows-play cursor-size
	       cursor-style dac-combines-channels dac-size data-clipped data-color data-format data-location
	       default-output-chans default-output-format default-output-srate default-output-type define-envelope
	       delete-mark delete-marks forget-region delete-sample delete-samples delete-samples-with-origin
	       delete-selection dialog-widgets dismiss-all-dialogs display-edits dot-size draw-dot draw-dots draw-line
	       draw-lines draw-string edit-header-dialog edit-fragment edit-position edit-tree edits env-selection
	       env-sound enved-active-env enved-base enved-clip? enved-in-dB enved-dialog enved-exp? enved-power
	       enved-selected-env enved-target enved-waveform-color enved-wave? eps-file eps-left-margin emacs-style-save-as
	       eps-bottom-margin eps-size expand-control expand-control-hop expand-control-length expand-control-ramp
	       expand-control? fft fft-window-beta fft-log-frequency fft-log-magnitude transform-size disk-kspace
	       transform-graph-type fft-window graph-transform?  fht file-dialog mix-file-dialog file-name fill-polygon
	       fill-rectangle filter-sound filter-control-in-dB filter-control-env enved-filter-order enved-filter
	       filter-env-in-hz filter-control-order filter-selection filter-waveform-color filter-control? find
	       find-mark find-sound finish-progress-report foreground-color forward-graph forward-mark forward-mix
	       forward-sample frames free-mix-sample-reader free-sample-reader free-track-sample-reader graph
	       graph-color graph-cursor graph-data graph->ps graph-style graph-lisp?  graphs-horizontal header-type
	       help-dialog help-text-font highlight-color in insert-region insert-sample insert-samples
	       insert-samples-with-origin insert-selection insert-silence insert-sound just-sounds key key-binding
	       left-sample listener-color listener-font listener-prompt listener-selection listener-text-color load-font
	       loop-samples main-widgets make-color make-graph-data make-mix-sample-reader make-player make-region
	       make-region-sample-reader make-sample-reader make-track-sample-reader map-chan mark-color mark-name
	       mark-sample mark-sync mark-sync-max mark-home marks mark?  max-transform-peaks max-regions max-sounds
	       maxamp menu-sensitive menu-widgets minibuffer-history-length min-dB mix mixes mix-amp mix-amp-env
	       mix-anchor mix-chans mix-color mix-track mix-length mix-locked mix-name mix? mix-panel mix-position
	       mix-region mix-sample-reader?  mix-selection mix-sound mix-home mix-speed mix-tag-height mix-tag-width
	       mix-tag-y mix-vct mix-waveform-height movies new-sound next-mix-sample next-sample next-track-sample
	       transform-normalization equalize-panes open-raw-sound open-sound open-sound-file orientation-dialog
	       peak-env-info peaks play play-and-wait play-mix play-region play-selection play-track player?
	       position-color position->x position->y preload-directory preload-file previous-files-sort previous-sample
	       print-length progress-report prompt-in-minibuffer protect-region pushed-button-color read-only
	       recorder-in-device read-peak-env-info-file recorder-autoload recorder-buffer-size recorder-dialog
	       recorder-file recorder-gain recorder-in-amp recorder-in-format recorder-max-duration recorder-out-amp
	       recorder-out-chans recorder-out-format recorder-srate recorder-trigger redo region-chans region-dialog
	       region-graph-style region-length region-maxamp region-sample region-samples region-samples->vct
	       region-srate regions region?  remove-from-menu report-in-minibuffer reset-controls restore-controls
	       restore-marks restore-region reverb-control-decay reverb-control-feedback 
	       reverb-control-length reverb-control-lowpass reverb-control-scale reverb-control?  reverse-sound
	       reverse-selection revert-sound right-sample sample sample-reader-at-end?  sample-reader? samples
	       samples->vct samples->sound-data sash-color save-controls ladspa-dir save-dir save-edit-history save-envelopes
	       save-listener save-macros save-marks save-options save-region save-selection save-sound save-sound-as
	       save-state save-state-file scale-by scale-selection-by scale-selection-to scale-to scale-sound-by
	       scale-sound-to scan-chan search-procedure select-all select-channel select-mix select-sound
	       selected-channel selected-data-color selected-graph-color selected-mix selected-mix-color selected-sound
	       selection-position selection-color selection-creates-region selection-length selection-member? selection?
	       short-file-name show-axes show-backtrace show-controls show-transform-peaks show-indices show-listener
	       show-marks show-mix-waveforms show-selection-transform show-y-zero sinc-width
	       smooth-sound smooth-selection snd-print snd-spectrum snd-tempnam snd-version sound-files-in-directory
	       sound-loop-info sound-widgets soundfont-info sound? sounds spectro-cutoff spectro-hop spectro-start
	       spectro-x-angle spectro-x-scale spectro-y-angle spectro-y-scale spectro-z-angle spectro-z-scale
	       speed-control speed-control-style speed-control-tones squelch-update srate src-sound src-selection
	       start-playing start-progress-report stop-player stop-playing swap-channels syncd-marks sync sound-properties temp-dir
	       text-focus-color tiny-font track-sample-reader?  transform-dialog transform-sample transform-samples
	       transform-samples->vct transform-samples-size transform-type trap-segfault unbind-key undo
	       update-transform update-time-graph update-lisp-graph update-sound use-sinc-interp
	       vct->samples vct->sound-file verbose-cursor view-sound vu-font vu-font-size vu-size wavelet-type
	       graph-time?  time-graph-type wavo-hop wavo-trace window-height window-width window-x window-y
	       with-mix-tags write-peak-env-info-file x-axis-style beats-per-minute x-bounds x-position-slider x->position x-zoom-slider
	       y-bounds y-position-slider y->position y-zoom-slider zero-pad zoom-color zoom-focus-style
	       mus-sound-samples mus-sound-frames mus-sound-duration mus-sound-datum-size mus-sound-data-location
	       mus-sound-chans mus-sound-srate mus-sound-header-type mus-sound-data-format mus-sound-length
	       mus-sound-type-specifier mus-header-type-name mus-data-format-name mus-sound-comment mus-sound-write-date
	       mus-data-format-bytes-per-sample mus-sound-loop-info mus-audio-report mus-audio-sun-outputs
	       mus-sound-maxamp mus-sound-maxamp-exists? mus-sound-open-input mus-sound-open-output
	       mus-sound-reopen-output mus-sound-close-input mus-sound-close-output mus-sound-read mus-sound-write
	       mus-sound-seek mus-sound-seek-frame mus-file-set-data-clipped mus-file-prescaler mus-file-set-prescaler
	       mus-expand-filename make-sound-data sound-data-ref sound-data-set!  sound-data? sound-data-length
	       sound-data-maxamp sound-data-chans sound-data->vct vct->sound-data all-pass all-pass? amplitude-modulate
	       array->file array-interp asymmetric-fm asymmetric-fm?  buffer->frame buffer->sample buffer-empty? buffer?
	       clear-array comb comb? contrast-enhancement convolution convolve convolve? db->linear degrees->radians
	       delay delay? dot-product env env-interp env? file->array file->frame file->frame?  file->sample
	       file->sample?  filter filter? fir-filter fir-filter? formant formant-bank formant? frame* frame+
	       frame->buffer frame->file frame->file? frame->frame frame->list frame->sample frame-ref frame-set! frame?
	       granulate granulate? hz->radians iir-filter iir-filter?  in-any in-hz ina inb linear->db locsig
	       locsig-ref locsig-reverb-ref locsig-reverb-set! locsig-set!  locsig? make-all-pass make-asymmetric-fm
	       make-buffer make-comb make-convolve make-delay make-env make-fft-window make-file->frame
	       make-file->sample make-filter make-fir-filter make-formant make-frame make-frame->file make-granulate
	       make-iir-filter make-locsig make-mixer make-notch make-one-pole make-one-zero make-oscil make-ppolar
	       make-pulse-train make-rand make-rand-interp make-readin make-sample->file make-sawtooth-wave
	       make-sine-summation make-square-wave make-src make-sum-of-cosines make-table-lookup make-triangle-wave
	       make-two-pole make-two-zero make-wave-train make-waveshape make-zpolar mixer* mixer-ref mixer-set! mixer?
	       multiply-arrays mus-a0 mus-a1 mus-a2 mus-array-print-length mus-b1 mus-b2 mus-channel mus-channels
	       mus-close mus-cosines mus-data mus-feedback mus-feedforward mus-fft mus-formant-radius mus-frequency
	       mus-hop mus-increment mus-input?  mus-length mus-location mus-mix mus-order mus-output?  mus-phase
	       mus-ramp mus-random mus-scaler mus-srate mus-xcoeffs mus-ycoeffs notch notch? one-pole one-pole?
	       one-zero one-zero? oscil oscil-bank oscil? out-any outa outb outc outd partials->polynomial
	       partials->wave partials->waveshape phase-partials->wave polynomial pulse-train pulse-train?
	       radians->degrees radians->hz rand rand-interp rand-interp?  rand? readin readin?  rectangular->polar
	       restart-env ring-modulate sample->buffer sample->file sample->file? sample->frame sawtooth-wave
	       sawtooth-wave? sine-summation sine-summation? spectrum square-wave square-wave? src src? sum-of-cosines
	       sum-of-cosines? table-lookup table-lookup? tap triangle-wave triangle-wave? two-pole two-pole? two-zero
	       two-zero? wave-train wave-train?  waveshape waveshape?  make-vct vct-add! vct-subtract!  vct-copy
	       vct-length vct-multiply! vct-offset! vct-ref vct-scale! vct-fill! vct-set! mus-audio-describe vct-peak
	       vct? list->vct vct->list vector->vct vct-move!  vct-subseq vct little-endian?
	       clm-channel env-channel map-channel scan-channel play-channel reverse-channel 
	       smooth-channel vct->channel channel->vct src-channel scale-channel pad-channel
	       cursor-position
	       ))

(define set-procs (list 
		   amp-control ask-before-overwrite audio-input-device audio-output-device audio-state-file auto-resize
		   auto-update axis-label-font axis-numbers-font basic-color bold-button-font button-font channel-style
		   color-cutoff color-inverted color-scale contrast-control contrast-control-amp
		   contrast-control? auto-update-interval current-font cursor cursor-color channel-properties
		   cursor-follows-play cursor-size cursor-style dac-combines-channels dac-size data-clipped data-color
		   default-output-chans default-output-format default-output-srate default-output-type dot-size
		   enved-active-env enved-base enved-clip? enved-in-dB enved-exp? enved-power enved-selected-env
		   enved-target enved-waveform-color enved-wave? eps-file eps-left-margin eps-bottom-margin eps-size
		   expand-control expand-control-hop expand-control-length expand-control-ramp expand-control?
		   fft-window-beta fft-log-frequency fft-log-magnitude transform-size transform-graph-type fft-window
		   graph-transform? filter-control-in-dB filter-control-env enved-filter-order enved-filter emacs-style-save-as
		   filter-env-in-hz filter-control-order filter-waveform-color filter-control?  foreground-color
		   graph-color graph-cursor graph-style graph-lisp? graphs-horizontal help-text-font highlight-color
		   just-sounds left-sample listener-color listener-font listener-prompt listener-text-color mark-color
		   mark-name mark-sample mark-sync max-transform-peaks max-regions menu-sensitive min-dB mix-amp
		   mix-amp-env mix-anchor mix-chans mix-color mix-track mix-length mix-locked mix-name mix-position
		   mix-speed mix-tag-height mix-tag-width mix-tag-y mix-waveform-height movies transform-normalization
		   equalize-panes position-color recorder-in-device previous-files-sort print-length pushed-button-color
		   recorder-autoload recorder-buffer-size recorder-dialog recorder-file recorder-gain recorder-in-amp
		   recorder-in-format recorder-max-duration recorder-out-amp recorder-out-chans recorder-out-format
		   recorder-srate region-graph-style recorder-trigger reverb-control-decay reverb-control-feedback
		   reverb-control-length reverb-control-lowpass reverb-control-scale
		   reverb-control? sash-color ladspa-dir save-dir save-state-file selected-data-color selected-graph-color
		   selected-mix-color selection-color selection-creates-region show-axes show-backtrace show-controls
		   show-transform-peaks show-indices show-marks show-mix-waveforms show-selection-transform show-listener
		   show-y-zero sinc-width spectro-cutoff spectro-hop spectro-start spectro-x-angle
		   spectro-x-scale spectro-y-angle spectro-y-scale spectro-z-angle spectro-z-scale speed-control
		   speed-control-style speed-control-tones squelch-update sync sound-properties temp-dir text-focus-color tiny-font y-bounds
		   transform-type trap-segfault use-sinc-interp verbose-cursor vu-font vu-font-size vu-size wavelet-type x-bounds
		   graph-time? wavo-hop wavo-trace with-mix-tags x-axis-style beats-per-minute zero-pad zoom-color zoom-focus-style 

		   window-x window-y window-width window-height
		   channels chans colormap comment data-format data-location edit-position frames header-type maxamp
		   minibuffer-history-length read-only right-sample sample samples selected-channel
		   selected-mix selected-sound selection-position selection-length selection-member? sound-loop-info
		   srate time-graph-type x-position-slider x-zoom-slider
		   y-position-slider y-zoom-slider sound-data-ref mus-a0 mus-a1 mus-a2 mus-array-print-length 
		   mus-b1 mus-b2 mus-data mus-feedback mus-feedforward mus-formant-radius mus-frequency mus-hop
		   mus-increment mus-length mus-location mus-phase mus-ramp mus-scaler vct-ref
		   ))

(define procs0 (remove-if (lambda (n) (not (arity-ok n 0))) procs))
(define set-procs0 (remove-if (lambda (n) (not (arity-ok n 0))) set-procs))
(define procs1 (remove-if (lambda (n) (not (arity-ok n 1))) procs))
(define set-procs1 (remove-if (lambda (n) (not (arity-ok n 1))) set-procs))
(define procs2 (remove-if (lambda (n) (not (arity-ok n 2))) procs))
(define set-procs2 (remove-if (lambda (n) (not (arity-ok n 2))) set-procs))
(define procs3 (remove-if (lambda (n) (not (arity-ok n 3))) procs))
(define set-procs3 (remove-if (lambda (n) (not (arity-ok n 3))) set-procs))
(define procs4 (remove-if (lambda (n) (not (arity-ok n 4))) procs))
(define set-procs4 (remove-if (lambda (n) (not (arity-ok n 4))) set-procs))
(define procs5 (remove-if (lambda (n) (not (arity-ok n 5))) procs))

(define make-procs (list
               make-all-pass make-asymmetric-fm
	       make-buffer make-comb make-convolve make-delay make-env make-fft-window make-file->frame
	       make-file->sample make-filter make-fir-filter make-formant make-frame make-frame->file make-granulate
	       make-iir-filter make-locsig make-mixer make-notch make-one-pole make-one-zero make-oscil make-ppolar
	       make-pulse-train make-rand make-rand-interp make-readin make-sample->file make-sawtooth-wave
	       make-sine-summation make-square-wave make-src make-sum-of-cosines make-table-lookup make-triangle-wave
	       make-two-pole make-two-zero make-wave-train make-waveshape make-zpolar))

(define keyargs
	 (list 
	  :frequency :initial-phase :wave :cosines :amplitude :ratio :size :a0 :a1 :a2 :b1 :b2 :input 
	  :srate :file :channel :start :initial-contents :initial-element :scaler :feedforward :feedback 
	  :max-size :radius :gain :partials :r :a :n :fill-time :order :xcoeffs :ycoeffs :envelope 
	  :base :duration :offset :end :direction :degree :distance :reverb :output :fft-size :expansion 
	  :length :hop :ramp :jitter :type :format :comment :channels :filter :revout :width :edit 
	  :synthesize :analyze :interp :overlap :pitch))

(reset-all-hooks)

(if (or full-test (= snd-test 25) (and keep-going (<= snd-test 25)))
    (begin
      (if (procedure? test-hook)  (test-hook 25))

      (for-each (lambda (n)
		  (let ((tag
			 (catch #t
				(lambda ()
				  (n 123))
				(lambda args (car args)))))
		    (IF (not (eq? tag 'no-such-sound))
			(snd-display ";snd no-such-sound ~A: ~A" n tag))))
		(list amp-control bomb apply-controls channels chans close-sound comment contrast-control
		      contrast-control-amp contrast-control? data-format data-location expand-control expand-control-hop
		      expand-control-length expand-control-ramp expand-control? file-name filter-control-in-dB
		      filter-control-env filter-control-order filter-control?  finish-progress-report frames header-type
		      progress-report read-only reset-controls restore-controls reverb-control-decay reverb-control-feedback
		      reverb-control-length reverb-control-lowpass reverb-control-scale reverb-control? save-controls
		      select-sound short-file-name sound-loop-info soundfont-info speed-control speed-control-style
		      speed-control-tones srate channel-style start-progress-report sync sound-properties swap-channels))
      
      (for-each (lambda (arg)
		  (for-each (lambda (n)
			      (let ((tag
				     (catch #t
					    (lambda ()
					      (n arg))
					    (lambda args (car args)))))
				(IF (not (eq? tag 'wrong-type-arg))
				    (snd-display ";snd wrong-type-arg ~A: ~A ~A" n tag arg))))
			    (list amp-control bomb apply-controls channels chans close-sound comment contrast-control
				  contrast-control-amp contrast-control? data-format data-location expand-control
				  expand-control-hop expand-control-length expand-control-ramp expand-control? file-name
				  filter-control-in-dB filter-control-env filter-control-order filter-control?
				  finish-progress-report frames header-type read-only reset-controls restore-controls
				  reverb-control-decay reverb-control-feedback reverb-control-length reverb-control-lowpass
				  reverb-control-scale reverb-control? save-controls select-sound short-file-name
				  sound-loop-info soundfont-info speed-control speed-control-style speed-control-tones srate
				  channel-style start-progress-report sync sound-properties swap-channels)))
		(list (current-module) (sqrt -1.0) 1.5 "hiho"))

      (for-each (lambda (arg)
		  (let ((ctr 0))
		    (for-each (lambda (n)
				(let ((tag
				       (catch #t
					      (lambda ()
						(set! (n arg) 0))
					      (lambda args (car args)))))
				  (IF (not (eq? tag 'wrong-type-arg))
				      (snd-display ";snd set wrong-type-arg ~D: ~A: ~A ~A" ctr n tag arg))
				  (set! ctr (+ ctr 1))))
			      (list amp-control channels chans comment contrast-control contrast-control-amp
				    contrast-control? data-format data-location expand-control expand-control-hop
				    expand-control-length expand-control-ramp expand-control? filter-control-in-dB
				    filter-control-env filter-control-order filter-control? frames header-type read-only
				    reverb-control-decay reverb-control-feedback reverb-control-length reverb-control-lowpass
				    reverb-control-scale reverb-control? sound-loop-info soundfont-info speed-control
				    speed-control-style speed-control-tones srate channel-style sync))))
		(list (current-module) (sqrt -1.0) 1.5 "hiho"))

      (let ((index (open-sound "obtest.snd")))
	(for-each (lambda (arg)
		    (let ((ctr 0))
		      (for-each (lambda (n)
				  (let ((tag
					 (catch #t
						(lambda ()
						  (set! (n index) arg))
						(lambda args (car args)))))
				    (IF (not (eq? tag 'wrong-type-arg))
					(snd-display ";snd safe set wrong-type-arg ~A: ~A ~A ~A" ctr n tag arg))
				    (set! ctr (+ ctr 1))))
			      (list amp-control contrast-control contrast-control-amp contrast-control?  expand-control
				    expand-control-hop expand-control-length expand-control-ramp expand-control?
				    filter-control-in-dB filter-control-env filter-control-order filter-control?
				    reverb-control-decay reverb-control-feedback reverb-control-length reverb-control-lowpass
				    reverb-control-scale reverb-control? speed-control speed-control-style speed-control-tones
				    channel-style sync))))
		  (list (current-module) (sqrt -1.0) "hiho"))
	(close-sound index))

      (for-each (lambda (arg)
		  (for-each (lambda (n)
			      (let ((tag
				     (catch #t
					    (lambda ()
					      (n arg))
					    (lambda args (car args)))))
				(IF (not (eq? tag 'wrong-type-arg))
				    (snd-display ";vct 0 wrong-type-arg ~A: ~A ~A" n tag arg))))
			    (list make-vct vct-copy vct-length vct->list vct-peak)))
		(list (current-module) "hiho" (sqrt -1.0) 1.5 (list 1 0) '#(0 1)))

      (for-each (lambda (arg1)
		  (for-each (lambda (arg2)
			      (for-each (lambda (n)
					  (let ((tag
						 (catch #t
							(lambda ()
							  (n arg1 arg2))
							(lambda args (car args)))))
					    (IF (not (or (eq? tag 'wrong-type-arg)
							 (eq? tag 'wrong-number-of-args)
							 (eq? tag 'mus-error)))
						(snd-display ";vct 1 wrong-whatever ~A: ~A ~A ~A" n tag arg1 arg2))))
					(list vct-add! vct-subtract! vct-multiply! vct-ref vct-scale! vct-fill! vct-do! vcts-do! vct-map! vcts-map!)))
			    (list (current-module) "hiho" (sqrt -1.0) 1.5 (list 1 0) '#(0 1))))
		  (list (current-module) "hiho" (sqrt -1.0) 1.5 (list 1 0) '#(0 1)))

      (for-each (lambda (arg)
		  (for-each (lambda (n)
			      (let ((tag
				     (catch #t
					    (lambda ()
					      (n (make-vct 3) arg))
					    (lambda args (car args)))))
				(IF (not (eq? tag 'wrong-type-arg))
				    (snd-display ";vct 2 wrong-type-arg ~A: ~A" n tag))))
			    (list vct-add! vct-subtract! vct-multiply! vct-ref vct-scale! vct-fill! vct-do! vct-map!)))
		(list (current-module) "hiho" (sqrt -1.0) (list 1 0) '#(0 1)))

        (let ((tag
	       (catch #t
		      (lambda ()
			(make-vct -23))
		      (lambda args (car args)))))
	  (IF (not (eq? tag 'mus-error))
	      (snd-display ";make-vct -23: ~A" tag)))

        (let* ((v (make-vct 3)))
	  (let ((tag
		 (catch #t
			(lambda ()
			  (vct-ref v 12))
			(lambda args (car args)))))
	    (IF (not (eq? tag 'mus-error))
		     (snd-display ";vct[12]: ~A" tag))))

	(for-each (lambda (arg)
		    (for-each (lambda (n)
				(let ((tag
				       (catch #t
					      (lambda ()
						(n arg))
					      (lambda args (car args)))))
				  (IF tag
				      (snd-display ";?proc ~A: ~A" n tag))))
			      (list all-pass? asymmetric-fm? buffer? comb? convolve? delay? env? file->frame? file->sample? 
				    filter? fir-filter? formant? frame->file? frame? granulate? iir-filter? locsig? mixer? mus-input? 
				    mus-output? notch? one-pole? one-zero? oscil? phase-vocoder? pulse-train? rand-interp? rand? readin? 
				    sample->file? sawtooth-wave? sine-summation? square-wave? src? sum-of-cosines? table-lookup? 
				    triangle-wave? two-pole? two-zero? wave-train? waveshape? color? mix-sample-reader? 
				    sample-reader? track-sample-reader? vct? )))
		(list (current-module) "hiho" (sqrt -1.0) 1.5 (list 1 0) '#(0 1)))
	(gc)

	(for-each (lambda (n)
		    (let ((tag
			   (catch #t
				  (lambda ()
				    (n (make-oscil 440)))
				  (lambda args (car args)))))
		      (IF tag
			  (snd-display ";oscil?proc ~A: ~A" n tag))))
		  (list all-pass? asymmetric-fm? buffer? comb? convolve? delay? env? file->frame? file->sample? 
			filter? fir-filter? formant? frame->file? frame? granulate? iir-filter? locsig? mixer? mus-input? 
			mus-output? notch? one-pole? one-zero? phase-vocoder? pulse-train? rand-interp? rand? readin? 
			sample->file? sawtooth-wave? sine-summation? square-wave? src? sum-of-cosines? table-lookup? 
			triangle-wave? two-pole? two-zero? wave-train? waveshape? sound? color? mix-sample-reader? 
			sample-reader? track-sample-reader? vct?))

	(for-each (lambda (n)
		    (let ((tag
			   (catch #t
				  (lambda ()
				    (n))
				  (lambda args (car args)))))
		      (IF (not (eq? tag 'no-active-selection))
			  (snd-display ";selection ~A: ~A" n tag))))
		  (list reverse-selection selection-position selection-length smooth-selection
			scale-selection-by scale-selection-to play-selection insert-selection delete-selection mix-selection))

	(for-each (lambda (n)
		    (let ((tag
			   (catch #t
				  (lambda ()
				    (n 0.0))
				  (lambda args (car args)))))
		      (IF (not (eq? tag 'no-active-selection))
			  (snd-display ";selection ~A: ~A" n tag))))
		  (list src-selection filter-selection env-selection))

	(for-each (lambda (arg)
		    (for-each (lambda (n)
				(let ((tag
				       (catch #t
					      (lambda ()
						(n arg))
					      (lambda args (car args)))))
				  (IF (not (eq? tag 'wrong-type-arg))
				      (snd-display ";clm ~A: ~A ~A" n tag arg))))
			      (list all-pass asymmetric-fm buffer->sample clear-array comb convolve db->linear
				    degrees->radians delay env formant frame->list granulate hz->radians in-hz linear->db
				    make-all-pass make-asymmetric-fm make-buffer make-comb make-convolve make-delay make-env
				    make-file->frame make-file->sample make-filter make-fir-filter make-formant make-frame
				    make-granulate make-iir-filter make-locsig make-notch make-one-pole make-one-zero
				    make-oscil make-ppolar make-pulse-train make-rand make-rand-interp make-readin
				    make-sawtooth-wave make-sine-summation make-square-wave make-src make-sum-of-cosines
				    make-table-lookup make-triangle-wave make-two-pole make-two-zero make-wave-train
				    make-waveshape make-zpolar mus-a0 mus-a1 mus-a2 mus-b1 mus-b2 mus-channel mus-channels
				    mus-cosines mus-data mus-feedback mus-feedforward mus-formant-radius mus-frequency mus-hop
				    mus-increment mus-length mus-location mus-order mus-phase mus-ramp mus-random mus-run
				    mus-scaler mus-set-rand-seed mus-set-srate mus-xcoeffs mus-ycoeffs notch one-pole one-zero
				    oscil partials->polynomial partials->wave partials->waveshape phase-partials->wave
				    phase-vocoder pulse-train radians->degrees radians->hz rand rand-interp readin restart-env
				    sawtooth-wave sine-summation square-wave src sum-of-cosines table-lookup tap triangle-wave
				    two-pole two-zero wave-train waveshape)))
		(list (current-module) (sqrt -1.0)))
	(gc)

	(for-each (lambda (n)
		    (let ((tag
			   (catch #t
				  (lambda ()
				    (n (make-oscil) (current-module)))
				  (lambda args (car args)))))
		      (IF (not (or (eq? tag 'wrong-type-arg)
				   (eq? tag 'mus-error)))
			  (snd-display ";clm ~A: ~A" n tag))))
		  (list all-pass array-interp asymmetric-fm comb contrast-enhancement convolution convolve
			convolve-files delay dot-product env-interp file->frame file->sample filter fir-filter formant
			formant-bank frame* frame+ frame->buffer frame->frame frame-ref frame->sample granulate iir-filter ina
			inb locsig-ref locsig-reverb-ref make-all-pass make-asymmetric-fm make-buffer make-comb make-convolve
			make-delay make-env make-fft-window make-filter make-fir-filter make-formant make-frame make-granulate
			make-iir-filter make-locsig make-notch make-one-pole make-one-zero make-oscil make-phase-vocoder
			make-ppolar make-pulse-train make-rand make-rand-interp make-readin make-sawtooth-wave
			make-sine-summation make-square-wave make-src make-sum-of-cosines make-table-lookup make-triangle-wave
			make-two-pole make-two-zero make-wave-train make-waveshape make-zpolar mixer* multiply-arrays mus-bank
			notch one-pole one-zero oscil oscil-bank partials->polynomial partials->wave partials->waveshape
			phase-partials->wave phase-vocoder polynomial pulse-train rand rand-interp rectangular->polar
			ring-modulate sample->buffer sample->frame sawtooth-wave sine-summation square-wave src sum-of-cosines
			sum-of-sines table-lookup tap triangle-wave two-pole two-zero wave-train waveshape ))

	(for-each (lambda (n)
		    (let ((tag
			   (catch #t
				  (lambda ()
				    (set! (n (make-oscil)) (current-module)))
				  (lambda args (car args)))))
		      (IF (not (eq? tag 'wrong-type-arg))
			  (snd-display ";mus-gen ~A: ~A" n tag))))
		  (list mus-a0 mus-a1 mus-a2 mus-b1 mus-b2 mus-bank mus-channel mus-channels mus-cosines mus-data
			mus-feedback mus-feedforward mus-formant-radius mus-frequency mus-hop mus-increment mus-length
			mus-location mus-mix mus-order mus-phase mus-ramp mus-random mus-run mus-scaler mus-xcoeffs
			mus-ycoeffs))
	(gc)

	(for-each (lambda (n)
		    (let ((tag
			   (catch #t
				  (lambda ()
				    (n (current-module)))
				  (lambda args (car args)))))
		      (IF (not (eq? tag 'wrong-type-arg))
			  (snd-display ";mus-sound ~A: ~A" n tag))))
		  (list mus-sound-samples mus-sound-frames mus-sound-duration mus-sound-datum-size
			mus-sound-data-location mus-sound-chans mus-sound-srate mus-sound-header-type mus-sound-data-format
			mus-sound-length mus-sound-type-specifier mus-header-type-name mus-data-format-name mus-sound-comment
			mus-sound-write-date mus-data-format-bytes-per-sample mus-sound-loop-info mus-sound-maxamp
			mus-sound-maxamp-exists?))

	(for-each (lambda (n)
		    (let ((tag
			   (catch #t
				  (lambda ()
				    (n))
				  (lambda args (car args)))))
		      (IF (not (eq? tag 'wrong-number-of-args))
			  (snd-display ";no arg mus-sound ~A: ~A" n tag))))
		  (list mus-sound-samples mus-sound-frames mus-sound-duration mus-sound-datum-size
			mus-sound-data-location mus-sound-chans mus-sound-srate mus-sound-header-type mus-sound-data-format
			mus-sound-length mus-sound-type-specifier mus-header-type-name mus-data-format-name mus-sound-comment
			mus-sound-write-date mus-data-format-bytes-per-sample mus-sound-loop-info mus-sound-maxamp
			mus-sound-maxamp-exists?))

	(for-each (lambda (n)
		    (let ((tag
			   (catch #t
				  (lambda ()
				    (n "/bad/baddy"))
				  (lambda args (car args)))))
		      (IF (not (eq? tag 'mus-error))
			  (snd-display ";bad file mus-sound ~A: ~A" n tag))))
		  (list mus-sound-samples mus-sound-frames mus-sound-duration mus-sound-datum-size
			mus-sound-data-location mus-sound-chans mus-sound-srate mus-sound-header-type mus-sound-data-format
			mus-sound-length mus-sound-type-specifier mus-sound-comment mus-sound-write-date mus-sound-maxamp
			mus-sound-maxamp-exists?))

	(let ((ctr 0))
	  (for-each (lambda (n)
		      (let ((tag
			     (catch #t
				    (lambda ()
				      (n (current-module)))
				    (lambda args (car args)))))
			(IF (not (eq? tag 'wrong-type-arg))
			    (snd-display ";~D: chn (no snd) procs ~A: ~A" ctr n tag))
			(set! ctr (+ ctr 1))))
		    (list backward-graph backward-sample channel-widgets count-matches cursor channel-properties
			  cursor-follows-play cursor-position cursor-size cursor-style delete-sample display-edits dot-size
			  draw-dots draw-lines edit-fragment edit-position edit-tree edits fft-window-beta fft-log-frequency
			  fft-log-magnitude transform-size transform-graph-type fft-window graph-transform? find forward-graph
			  forward-mark forward-mix forward-sample graph graph-style graph-lisp? insert-region insert-sound
			  left-sample make-graph-data map-chan max-transform-peaks maxamp min-dB mix-region
			  transform-normalization peak-env-info peaks play play-and-wait position->x position->y reverse-sound
			  revert-sound right-sample sample samples->vct samples->sound-data save-sound save-sound-as scan-chan
			  select-channel show-axes show-transform-peaks show-marks show-mix-waveforms show-y-zero
			  spectro-cutoff spectro-hop spectro-start spectro-x-angle spectro-x-scale spectro-y-angle
			  spectro-y-scale spectro-z-angle spectro-z-scale squelch-update transform-sample transform-samples
			  transform-samples->vct transform-samples-size transform-type update-transform update-time-graph
			  update-lisp-graph update-sound wavelet-type graph-time? time-graph-type wavo-hop wavo-trace x-bounds
			  x-position-slider x-zoom-slider y-bounds y-position-slider y-zoom-slider zero-pad))
	  (gc))

	(let ((ctr 0))
	  (for-each (lambda (n)
		      (let ((tag
			     (catch #t
				    (lambda ()
				      (n 0 (current-module)))
				    (lambda args (car args)))))
			(IF (not (eq? tag 'wrong-type-arg))
			    (snd-display ";~D: chn (no chn) procs ~A: ~A" ctr n tag))
			(set! ctr (+ ctr 1))))
		    (list backward-graph backward-sample channel-widgets count-matches cursor channel-properties
			  cursor-position cursor-size cursor-style delete-sample display-edits dot-size draw-dots draw-lines
			  edit-fragment edit-position edit-tree edits fft-window-beta fft-log-frequency fft-log-magnitude
			  transform-size transform-graph-type fft-window graph-transform? find forward-graph forward-mark
			  forward-mix forward-sample graph graph-style graph-lisp? insert-region insert-sound left-sample
			  make-graph-data map-chan max-transform-peaks maxamp min-dB mix-region transform-normalization
			  peak-env-info peaks play play-and-wait position->x position->y reverse-sound right-sample sample
			  samples->vct samples->sound-data save-sound-as scan-chan show-axes show-transform-peaks show-marks
			  show-mix-waveforms show-y-zero spectro-cutoff spectro-hop spectro-start spectro-x-angle
			  spectro-x-scale spectro-y-angle spectro-y-scale spectro-z-angle spectro-z-scale squelch-update
			  transform-sample transform-samples transform-samples->vct transform-samples-size transform-type
			  update-transform update-time-graph update-lisp-graph wavelet-type graph-time? time-graph-type
			  wavo-hop wavo-trace x-bounds x-position-slider x-zoom-slider y-bounds y-position-slider
			  y-zoom-slider zero-pad)))

        (let ((ctr 0))
	  (for-each (lambda (n)
		      (let ((tag
			     (catch #t
				    (lambda ()
				      (n 1234))
				    (lambda args (car args)))))
			(IF (not (eq? tag 'no-such-sound))
			    (snd-display ";~D: chn procs ~A: ~A" ctr n tag))
			(set! ctr (+ ctr 1))))
		    (list backward-graph backward-sample channel-widgets cursor cursor-follows-play channel-properties
			  cursor-position cursor-size cursor-style delete-sample display-edits dot-size edit-fragment
			  edit-position edit-tree edits env-sound fft-window-beta fft-log-frequency fft-log-magnitude
			  transform-size transform-graph-type fft-window graph-transform? filter-sound forward-graph
			  forward-mark forward-mix forward-sample graph-data graph-style graph-lisp? insert-region left-sample
			  make-graph-data max-transform-peaks maxamp min-dB transform-normalization peak-env-info play
			  play-and-wait position->x position->y redo reverse-sound revert-sound right-sample sample
			  samples->vct samples->sound-data save-sound scale-by scale-to show-axes show-transform-peaks
			  show-marks show-mix-waveforms show-y-zero spectro-cutoff spectro-hop spectro-start spectro-x-angle
			  spectro-x-scale spectro-y-angle spectro-y-scale spectro-z-angle spectro-z-scale squelch-update
			  src-sound transform-sample transform-samples transform-samples->vct scale-sound-by scale-sound-to
			  transform-samples-size transform-type undo update-transform update-time-graph update-lisp-graph
			  update-sound wavelet-type graph-time? time-graph-type wavo-hop wavo-trace x-bounds x-position-slider
			  x->position x-zoom-slider y-bounds y-position-slider y->position y-zoom-slider zero-pad )))

        (let ((ctr 0))
	  (for-each (lambda (n)
		      (let ((tag
			     (catch #t
				    (lambda ()
				      (n 0 1234))
				    (lambda args (car args)))))
			(IF (not (eq? tag 'no-such-sound))
			    (snd-display ";~D: snd(1) chn procs ~A: ~A" ctr n tag))
			(set! ctr (+ ctr 1))))
		    (list backward-graph backward-sample delete-sample edit-fragment forward-graph forward-mark
			  forward-mix forward-sample graph-data graph-style play play-and-wait position->x position->y redo
			  scale-sound-by scale-sound-to scale-by scale-to undo x->position y->position)))

        (let ((ctr 0)
	      (index (open-sound "oboe.snd")))
	  (for-each (lambda (n)
		      (let ((tag
			     (catch #t
				    (lambda ()
				      (n 0 index 1234))
				    (lambda args (car args)))))
			(IF (not (eq? tag 'no-such-channel))
			    (snd-display ";~D: snd(1 1234) chn procs ~A: ~A" ctr n tag))
			(set! ctr (+ ctr 1))))
		    (list backward-graph backward-sample delete-sample edit-fragment forward-graph forward-mark
			  forward-mix forward-sample graph-data play play-and-wait position->x position->y redo scale-by
			  scale-to undo x->position y->position))
	  (close-sound index))

        (let ((ctr 0)
	      (index (open-sound "oboe.snd")))
	  (for-each (lambda (n)
		      (let ((tag
			     (catch #t
				    (lambda ()
				      (n index 1234))
				    (lambda args (car args)))))
			(IF (not (eq? tag 'no-such-channel))
			    (snd-display ";~D: chn procs ~A: ~A" ctr n tag))
			(set! ctr (+ ctr 1))))
		    (list channel-widgets cursor cursor-position cursor-size cursor-style display-edits
			  dot-size edit-position edit-tree edits fft-window-beta fft-log-frequency fft-log-magnitude
			  transform-size transform-graph-type fft-window graph-transform? graph-style graph-lisp? left-sample
			  make-graph-data max-transform-peaks maxamp min-dB transform-normalization peak-env-info
			  reverse-sound right-sample show-axes show-transform-peaks show-marks show-mix-waveforms show-y-zero
			  spectro-cutoff spectro-hop spectro-start spectro-x-angle spectro-x-scale spectro-y-angle
			  spectro-y-scale spectro-z-angle spectro-z-scale squelch-update transform-samples->vct
			  transform-samples-size transform-type update-transform update-time-graph update-lisp-graph
			  wavelet-type graph-time?  time-graph-type wavo-hop wavo-trace x-bounds x-position-slider
			  x-zoom-slider y-bounds y-position-slider y-zoom-slider zero-pad channel-properties))
	  (close-sound index))

        (let ((ctr 0)
	      (index (open-sound "oboe.snd")))
	  (for-each (lambda (n)
		      (let ((tag
			     (catch #t
				    (lambda ()
				      (set! (n index 0) (current-module)))
				    (lambda args (car args)))))
			(IF (not (eq? tag 'wrong-type-arg))
			    (snd-display ";~D: set chn procs ~A: ~A" ctr n tag))
			(set! ctr (+ ctr 1))))
		    (list channel-widgets cursor cursor-position display-edits dot-size edit-tree edits
			  fft-window-beta fft-log-frequency fft-log-magnitude transform-size transform-graph-type fft-window
			  graph-transform? graph-style graph-lisp? left-sample make-graph-data max-transform-peaks maxamp
			  min-dB transform-normalization peak-env-info reverse-sound right-sample show-axes channel-properties
			  show-transform-peaks show-marks show-mix-waveforms show-y-zero spectro-cutoff spectro-hop
			  spectro-start spectro-x-angle spectro-x-scale spectro-y-angle spectro-y-scale spectro-z-angle
			  spectro-z-scale squelch-update transform-samples->vct transform-samples-size transform-type
			  update-transform update-time-graph update-lisp-graph wavelet-type graph-time? time-graph-type
			  wavo-hop wavo-trace x-bounds x-position-slider x-zoom-slider y-bounds y-position-slider
			  y-zoom-slider zero-pad
			  ))
	  (gc)
	  (close-sound index))

        (let ((ctr 0))
	  (for-each (lambda (n)
		      (let ((tag
			     (catch #t
				    (lambda ()
				      (n (current-module)))
				    (lambda args (car args)))))
			(IF (not (eq? tag 'wrong-type-arg))
			    (snd-display ";~D: mix procs ~A: ~A" ctr n tag))
			(set! ctr (+ ctr 1))))
		    (list backward-mix mix-amp mix-amp-env mix-anchor mix-chans mix-track mix-length mix-locked mix-name
			  mix-position mix-home mix-speed mix-tag-y))) 

        (let ((ctr 0))
	  (for-each (lambda (n)
		      (let ((tag
			     (catch #t
				    (lambda ()
				      (n 1234))
				    (lambda args (car args)))))
			(IF (not (eq? tag 'no-such-mix))
			    (snd-display ";~D: mix procs ~A: ~A" ctr n tag))
			(set! ctr (+ ctr 1))))
		    (list mix-amp mix-anchor mix-chans mix-track mix-length mix-locked mix-name
			  mix-position mix-home mix-speed mix-tag-y)))

        (let ((ctr 0))
	  (for-each (lambda (n)
		      (let ((tag
			     (catch #t
				    (lambda ()
				      (set! (n 1234) (current-module)))
				    (lambda args (car args)))))
			(IF (not (eq? tag 'wrong-type-arg))
			    (snd-display ";~D: mix procs ~A: ~A" ctr n tag))
			(set! ctr (+ ctr 1))))
		    (list mix-anchor mix-chans mix-track mix-length mix-locked mix-name
			  mix-position mix-home mix-speed mix-tag-y))) 

        (let* ((ctr 0)
	       (index (open-sound "oboe.snd"))
	       (id (mix-sound "oboe.snd" 10)))
	  (for-each (lambda (n)
		      (let ((tag
			     (catch #t
				    (lambda ()
				      (set! (n id) (current-module)))
				    (lambda args (car args)))))
			(IF (not (eq? tag 'wrong-type-arg))
			    (snd-display ";~D: mix procs ~A: ~A" ctr n tag))
			(set! ctr (+ ctr 1))))
		    (list mix-anchor mix-chans mix-track mix-length mix-locked mix-name
			  mix-position mix-home mix-speed mix-tag-y))
	  (close-sound index))

        (let ((ctr 0))
	  (for-each (lambda (n)
		      (let ((tag
			     (catch #t
				    (lambda ()
				      (n (current-module)))
				    (lambda args (car args)))))
			(IF (not (eq? tag 'wrong-type-arg))
			    (snd-display ";~D: mark procs ~A: ~A" ctr n tag))
			(set! ctr (+ ctr 1))))
		    (list add-mark backward-mark mark-name mark-sample mark-sync mark-home delete-mark delete-marks find-mark))) 

        (let ((ctr 0))
	  (for-each (lambda (n)
		      (let ((tag
			     (catch #t
				    (lambda ()
				      (n 1234))
				    (lambda args (car args)))))
			(IF (not (eq? tag 'no-such-mark))
			    (snd-display ";~D: no mark procs ~A: ~A" ctr n tag))
			(set! ctr (+ ctr 1))))
		    (list mark-name mark-sample mark-sync mark-home delete-mark))) 

        (let* ((ctr 0)
	       (index (open-sound "oboe.snd"))
	       (id (add-mark 0 index 0)))
	  (for-each (lambda (n)
		      (let ((tag
			     (catch #t
				    (lambda ()
				      (set! (n id) (current-module)))
				    (lambda args (car args)))))
			(IF (not (eq? tag 'wrong-type-arg))
			    (snd-display ";~D: set mark procs ~A: ~A" ctr n tag))
			(set! ctr (+ ctr 1))))
		    (list mark-name mark-sample mark-sync))
	  (close-sound index)
	  (gc))

	(for-each (lambda (arg)
		    (let ((ctr 0))
		      (for-each (lambda (n)
				  (let ((tag
					 (catch #t
						(lambda ()
						  (n arg))
						(lambda args (car args)))))
				    (IF (not (eq? tag 'wrong-type-arg))
					(snd-display ";~D: region procs ~A: ~A ~A" ctr n tag arg))
				    (set! ctr (+ ctr 1))))
				(list play-region region-chans region-length region-maxamp region-sample 
				      region-samples region-samples->vct region-srate forget-region))))
		  (list (current-module) '#(0 1) (sqrt -1.0) "hiho" (list 0 1)))

        (let ((ctr 0))
	  (for-each (lambda (n)
		      (let ((tag
			     (catch #t
				    (lambda ()
				      (n 1234))
				    (lambda args (car args)))))
			(IF (not (eq? tag 'no-such-region))
			    (snd-display ";~D: (no) region procs ~A: ~A" ctr n tag))
			(set! ctr (+ ctr 1))))
		    (list play-region region-chans region-length region-maxamp region-srate forget-region))) 

        (let ((ctr 0))
	  (for-each (lambda (n)
		      (let ((tag
			     (catch #t
				    (lambda ()
				      (set! (n) (current-module)))
				    (lambda args (car args)))))
			(IF (not (eq? tag 'wrong-type-arg))
			    (snd-display ";~D: misc procs ~A: ~A" ctr n tag))
			(set! ctr (+ ctr 1))))
		    (list enved-filter-order enved-filter filter-env-in-hz filter-waveform-color ask-before-overwrite
			  audio-state-file auto-resize auto-update axis-label-font axis-numbers-font basic-color bind-key
			  bold-button-font button-font channel-style color-cutoff color-dialog color-inverted color-scale
			  cursor-color dac-combines-channels dac-size data-clipped data-color default-output-chans emacs-style-save-as
			  default-output-format default-output-srate default-output-type enved-active-env enved-base
			  enved-clip? enved-in-dB enved-dialog enved-exp?  enved-power enved-selected-env enved-target
			  enved-waveform-color enved-wave? eps-file eps-left-margin eps-bottom-margin eps-size
			  foreground-color graph-color graph-cursor help-text-font highlight-color just-sounds key-binding
			  listener-color listener-font listener-prompt listener-text-color max-regions max-sounds
			  minibuffer-history-length mix-waveform-height region-graph-style movies position-color
			  previous-files-sort print-length pushed-button-color recorder-in-device recorder-autoload
			  recorder-buffer-size recorder-file recorder-in-format recorder-max-duration recorder-out-chans
			  recorder-out-format recorder-srate recorder-trigger sash-color ladspa-dir save-dir save-state-file
			  selected-channel selected-data-color selected-graph-color selected-mix selected-mix-color
			  selected-sound selection-creates-region show-backtrace show-controls show-indices show-listener
			  show-selection-transform sinc-width temp-dir text-focus-color tiny-font
			  trap-segfault unbind-key use-sinc-interp verbose-cursor vu-font vu-font-size vu-size window-height
			  window-width window-x window-y with-mix-tags x-axis-style beats-per-minute zoom-color zoom-focus-style mix-tag-height
			  mix-tag-width ))
	  (gc))

	(for-each (lambda (n)
		    (let* ((hook (car n))
			   (hook-name (cadr n))
			   (tag
			    (catch #t
				   (lambda () (add-hook! hook (lambda () (+ 1 2))))
				   (lambda args (car args)))))
		      (IF (not (eq? tag 'wrong-type-arg))
			  (snd-display ";hooks ~A: ~A" hook-name tag))))
		  (list (list after-graph-hook 'after-graph-hook)
			(list lisp-graph-hook 'lisp-graph-hook)
			(list before-transform-hook 'before-transform-hook)
			(list mix-position-changed-hook 'mix-position-changed-hook)
			(list stop-playing-channel-hook 'stop-playing-channel-hook)
			(list save-hook 'save-hook)
			(list mus-error-hook 'mus-error-hook)
			(list mouse-enter-graph-hook 'mouse-enter-graph-hook)
			(list mouse-leave-graph-hook 'mouse-leave-graph-hook)
			(list open-raw-sound-hook 'open-raw-sound-hook)
			(list select-channel-hook 'select-channel-hook)
			(list after-open-hook 'after-open-hook)
			(list close-hook 'close-hook)
			(list draw-mark-hook 'draw-mark-hook)
			(list just-sounds-hook 'just-sounds-hook)
			(list mark-click-hook 'mark-click-hook)
			(list mark-hook 'mark-hook)
			(list mark-drag-hook 'mark-drag-hook)
			(list mix-amp-changed-hook 'mix-amp-changed-hook)
			(list mix-speed-changed-hook 'mix-speed-changed-hook)
			(list name-click-hook 'name-click-hook)
			(list before-apply-hook 'before-apply-hook)
			(list after-apply-hook 'after-apply-hook)
			(list open-hook 'open-hook)
			(list output-comment-hook 'output-comment-hook)
			(list multichannel-mix-hook 'multichannel-mix-hook)
			(list play-hook 'play-hook)
			(list dac-hook 'dac-hook)
			(list new-widget-hook 'new-widget-hook)
			(list read-hook 'read-hook)
			(list snd-error-hook 'snd-error-hook)
			(list snd-warning-hook 'snd-warning-hook)
			(list start-hook 'start-hook)
			(list start-playing-hook 'start-playing-hook)
			(list stop-playing-hook 'stop-playing-hook)
			(list stop-playing-region-hook 'stop-playing-region-hook)
			(list mouse-enter-listener-hook 'mouse-enter-listener-hook)
			(list mouse-leave-listener-hook 'mouse-leave-listener-hook)
			(list property-changed-hook 'property-changed-hook)
			(list select-sound-hook 'select-sound-hook)
			(list select-mix-hook 'select-mix-hook)
			(list previous-files-select-hook 'previous-files-select-hook)
			(list during-open-hook 'during-open-hook)
			(list transform-hook 'transform-hook)
			(list mouse-enter-label-hook 'mouse-enter-label-hook)
			(list mouse-leave-label-hook 'mouse-leave-label-hook)
			(list initial-graph-hook 'initial-graph-hook)
			(list graph-hook 'graph-hook)
			(list key-press-hook 'key-press-hook)
			(list mouse-drag-hook 'mouse-drag-hook)
			(list mouse-press-hook 'mouse-press-hook)
			(list mouse-click-hook 'mouse-click-hook)
			(list mouse-release-hook 'mouse-release-hook)
			(list enved-hook 'enved-hook)))

	(check-error-tag 'no-such-envelope (lambda () (set! (enved-active-env) "not-an-env")))
	(check-error-tag 'cannot-save (lambda () (save-envelopes "/bad/baddy")))
	(check-error-tag 'bad-arity (lambda () (set! (search-procedure) (lambda (a b c) a))))
	(check-error-tag 'no-such-sound (lambda () (set! (search-procedure 1234) (lambda (a) a))))
	(check-error-tag 'no-such-channel (lambda () (make-sample-reader 0 "oboe.snd" 1)))
	(check-error-tag 'no-such-channel (lambda () (make-sample-reader 0 "oboe.snd" -1)))
	(check-error-tag 'bad-arity (lambda () (bind-key (char->integer #\p) 0 (lambda (a b) (play-often (max 1 a))))))
	(check-error-tag 'no-such-sound (lambda () (set! (sound-loop-info 123) '(0 0 1 1))))
	(check-error-tag 'mus-error (lambda () (new-sound "fmv.snd" mus-nist mus-bfloat 22050 2 "this is a comment")))
	(check-error-tag 'no-such-player (lambda () (player-home 123)))
	(let ((ind (open-sound "oboe.snd"))) 
	  (select-all)
	  (check-error-tag 'mus-error (lambda () (mix-vct (vct 0.1 0.2 0.3) -1 ind 0 #t)))
	  (check-error-tag 'mus-error (lambda () (snd-spectrum (make-vct 8) 0 -123)))
	  (check-error-tag 'mus-error (lambda () (snd-spectrum (make-vct 8) 0 0)))
	  (check-error-tag 'no-such-file (lambda () (insert-sound (string-append sf-dir "mus10.snd"))))
	  (check-error-tag 'no-such-file (lambda () (mix "/baddy/hiho")))
	  (check-error-tag 'no-such-file (lambda () (mix-sound "/baddy/hiho" 0)))
	  (check-error-tag 'mus-error (lambda () (set! (filter-control-env ind) '())))
	  (check-error-tag 'mus-error (lambda () (set! (data-format ind) 123)))
	  (check-error-tag 'mus-error (lambda () (set! (header-type ind) 123)))
	  (check-error-tag 'no-such-channel (lambda () (set! (selected-channel ind) 123)))
	  (check-error-tag 'bad-arity (lambda () (set! (search-procedure ind) (lambda (a b c) #t))))
	  (check-error-tag 'bad-arity (lambda () (map-chan (lambda (a b c) 1.0))))
	  (check-error-tag 'bad-arity (lambda () (scan-chan (lambda (a b c) 1.0))))
	  (check-error-tag 'bad-arity (lambda () (set! (cursor-style ind 0) (lambda (a) 32))))
	  (check-error-tag 'bad-arity (lambda () (find (lambda () 1.0))))
	  (check-error-tag 'bad-arity (lambda () (count-matches (lambda () 1.0))))
	  (check-error-tag 'no-such-graphics-context (lambda () (draw-line 0 0 1 1 ind 0 1234)))
	  (check-error-tag 'no-such-graphics-context (lambda () (foreground-color ind 0 1234)))
	  (check-error-tag 'no-such-graphics-context (lambda () (current-font ind 0 1234)))
	  (check-error-tag 'no-such-graphics-context (lambda () (graph-data (list (make-vct 3) (make-vct 3)) ind 0 1234 0 1 0)))
	  (check-error-tag 'no-such-axis (lambda () (position->x 100 ind 0 1234)))
	  (check-error-tag 'no-such-axis (lambda () (position->y 100 ind 0 1234)))
	  (check-error-tag 'no-such-axis (lambda () (x->position 100 ind 0 1234)))
	  (check-error-tag 'no-such-axis (lambda () (y->position 100 ind 0 1234)))
	  (check-error-tag 'no-such-axis (lambda () (axis-info ind 0 1234)))
	  (check-error-tag 'no-such-channel (lambda () (axis-info ind 1234)))
	  (check-error-tag 'no-such-sound (lambda () (axis-info 1234)))
	  (check-error-tag 'impossible-bounds (lambda () (set! (x-bounds) (list 0 0))))
	  (check-error-tag 'impossible-bounds (lambda () (set! (x-bounds) (list .1 -.1))))
	  (check-error-tag 'impossible-bounds (lambda () (set! (y-bounds) (list .2 .1))))
	  (check-error-tag 'impossible-bounds (lambda () (make-region 100 0)))
	  (check-error-tag 'no-such-file (lambda () (play "/bad/baddy.snd")))
	  (check-error-tag 'no-such-sound (lambda () (play 0 1234)))
	  (check-error-tag 'no-such-channel (lambda () (play 0 ind 1234)))
	  (check-error-tag 'no-such-channel (lambda () (region-sample 0 (car (regions)) 1234)))
	  (check-error-tag 'no-such-region (lambda () (region-samples 0 1 (+ 1234 (apply max (regions))))))
	  (check-error-tag 'no-such-region (lambda () (region-samples->vct 0 1 -1)))
	  (check-error-tag 'no-such-channel (lambda () (region-samples 0 1 (car (regions)) 1234)))
	  (check-error-tag 'no-such-channel (lambda () (region-samples->vct 0 1 (car (regions)) 1234)))
	  (check-error-tag 'cannot-save (lambda () (save-sound-as "/bad/baddy.snd")))
	  (check-error-tag 'no-such-sound (lambda () (transform-sample 0 1 1234)))
	  (check-error-tag 'no-such-channel (lambda () (transform-sample 0 1 ind 1234)))
	  (check-error-tag 'no-such-sound (lambda () (samples->vct 0 100 1234)))
	  (check-error-tag 'no-such-channel (lambda () (samples->vct 0 100 ind 1234)))
	  (check-error-tag 'no-such-sound (lambda () (samples->sound-data 0 100 1234)))
	  (check-error-tag 'no-such-channel (lambda () (samples->sound-data 0 100 ind 1234)))
	  (check-error-tag 'no-such-sound (lambda () (graph '#(0 1) "hi" 0 1 0 1 1234)))
	  (check-error-tag 'no-such-channel (lambda () (graph '#(0 1) "hi" 0 1 0 1 ind 1234)))
	  (set! (selection-member? #t) #f)
	  (check-error-tag 'no-active-selection (lambda () (save-selection "/bad/baddy.snd")))
	  (check-error-tag 'no-such-region (lambda () (save-region 1234 "/bad/baddy.snd")))
	  (make-region 0 100 ind 0)
	  (check-error-tag 'mus-error (lambda () (save-selection "/bad/baddy.snd")))
	  (check-error-tag 'mus-error (lambda () (save-region (car (regions)) "/bad/baddy.snd")))
	  (check-error-tag 'no-such-sound (lambda () (make-track-sample-reader 0 0 1234 0)))
	  (check-error-tag 'no-such-track (lambda () (make-track-sample-reader 0 0 ind 0)))
	  (check-error-tag 'no-such-mix (lambda () (make-mix-sample-reader 1234)))
	  (set! (read-only ind) #t)
	  (check-error-tag 'cannot-save (lambda () (set! (sound-loop-info ind) '(0 0 1 1))))
	  (check-error-tag 'no-such-direction (lambda () (make-sample-reader 0 ind 0 123)))
	  (check-error-tag 'no-such-direction (lambda () (make-sample-reader 0 ind 0 0)))
	  (check-error-tag 'no-such-direction (lambda () (make-sample-reader 0 ind 0 -2)))
	  (close-sound ind))
	(check-error-tag 'bad-arity (lambda () (add-transform "hiho" "time" 0 1 (lambda () 1.0))))
	(check-error-tag 'cannot-save (lambda () (save-options "/bad/baddy")))
	(check-error-tag 'cannot-save (lambda () (save-state "/bad/baddy")))
	(check-error-tag 'no-such-menu (lambda () (add-to-menu 1234 "hi" (lambda () #f))))
	(check-error-tag 'bad-arity (lambda () (add-to-main-menu "hi" (lambda (a b) #f))))
	(check-error-tag 'bad-arity (lambda () (add-to-menu 1 "hi" (lambda (a b) #f))))
	(check-error-tag 'no-such-file (lambda () (open-sound-file "/bad/baddy.snd")))
	(check-error-tag 'no-such-file (lambda () (close-sound-file 1234 0)))
	(check-error-tag 'wrong-type-arg (lambda () (help-dialog (list 0 1) "hiho")))
	(check-error-tag 'no-such-sound (lambda () (edit-header-dialog 1234)))
	(check-error-tag 'no-such-sound (lambda () (make-track-sample-reader 0 0)))
	(check-error-tag 'wrong-type-arg (lambda () (yes-or-no? (list 0 1))))
	(check-error-tag 'no-such-file (lambda () (open-sound "/bad/baddy.snd")))
	(check-error-tag 'no-such-file (lambda () (open-raw-sound "/bad/baddy.snd" 1 22050 mus-lshort)))
	(check-error-tag 'no-such-file (lambda () (view-sound "/bad/baddy.snd")))
	(check-error-tag 'no-such-file (lambda () (make-sample-reader 0 "/bad/baddy.snd")))
	(check-error-tag 'no-such-region (lambda () (make-region-sample-reader 0 1234567)))

	(for-each
	 (lambda (n name)
	   (let ((tag (catch #t
			     (lambda () (n (list 'Widget 0)))
			     (lambda args (car args)))))
	     (IF (not (eq? tag 'no-such-widget))
		 (snd-display ";~A of null widget -> ~A" name tag))))
	 (list widget-position widget-size widget-text hide-widget show-widget focus-widget)
	 (list 'widget-position 'widget-size 'widget-text 'hide-widget 'show-widget 'focus-widget))


	;; now try everything! (all we care about here is that Snd keeps running)

	;; ---------------- key args
	(for-each
	 (lambda (arg1)
	   (for-each 
	    (lambda (arg2)
	      (for-each 
	       (lambda (n)
		 (catch #t
			(lambda () (n arg1 arg2))
			(lambda args (car args))))
	       make-procs))
	    (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) :wave -1 0 1 #f #t '() 12345678901234567890)))
	 keyargs)

	(if all-args
	    (begin
	      (for-each
	       (lambda (arg1)
		 (for-each 
		  (lambda (arg2)
		    (for-each 
		     (lambda (arg3)
		       (for-each 
			(lambda (n)
			  (catch #t
				 (lambda () (n arg1 arg2 arg3))
				 (lambda args (car args))))
			make-procs))
		     (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) :wave -1 0 1 #f #t '() 12345678901234567890)))
		  keyargs))
	       (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) :wave -1 0 1 #f #t '() 12345678901234567890))
	      
	      (for-each
	       (lambda (arg1)
		 (for-each 
		  (lambda (arg2)
		    (for-each 
		     (lambda (arg3)
		       (for-each 
			(lambda (arg4)
			  (for-each 
			   (lambda (n)
			     (catch #t
				    (lambda () (n arg1 arg2 arg3))
				    (lambda args (car args))))
			   make-procs))
			(list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) :wave -1 0 1 #f #t '() 12345678901234567890)))
		     keyargs))
		  (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) :wave -1 0 1 #f #t '() 12345678901234567890)))
	       keyargs)))
	(gc)

	;; ---------------- 0 Args
	(for-each 
	 (lambda (n)
	   (catch #t
		  (lambda () 
		    (n))
		  (lambda args (car args))))
	 procs0)
	(dismiss-all-dialogs)
	(gc)

	;; ---------------- 1 Arg
	(for-each 
	 (lambda (arg)
	   (for-each 
	    (lambda (n)
	      (catch #t
		     (lambda () (n arg))
		     (lambda args (car args))))
	    procs1))
	 (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) (make-color .95 .95 .95)  '#(0 1) 3/4 'mus-error (sqrt -1.0) (make-delay 32)
	       (lambda () #t) (current-module) (make-sound-data 2 3) :order 0 1 -1 (make-hook 2) #f #t '() 12345678901234567890))
	(gc)

	;; ---------------- 2 Args
	(for-each 
	 (lambda (arg1)
	   (for-each 
	    (lambda (arg2)
	      (for-each 
	       (lambda (n)
		 (catch #t
			(lambda () (n arg1 arg2))
			(lambda args (car args)))
		 ;(gc)
		 )
	       procs2))
	    (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) (make-color .95 .95 .95) '#(0 1) 3/4 
		  (sqrt -1.0) (make-delay 32) :feedback -1 0 #f #t '() 12345678901234567890)))
	 (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) (make-color .95 .95 .95) '#(0 1) 3/4 
	       (sqrt -1.0) (make-delay 32) :frequency -1 0 #f #t '() 12345678901234567890))
	(gc)

	;; ---------------- set! no Args
	(for-each 
	 (lambda (arg)
	   (for-each 
	    (lambda (n)
	      (catch #t
		     (lambda () (set! (n) arg))
		     (lambda args (car args))))
	    set-procs0))
	 (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) (make-color .95 .95 .95)  '#(0 1) 3/4 'mus-error (sqrt -1.0) (make-delay 32)
	       (lambda () #t) (current-module) (make-sound-data 2 3) :order 0 1 -1 (make-hook 2) #f #t '() 12345678901234567890))
	(gc)

	;; ---------------- set! 1 Arg
	(for-each 
	 (lambda (arg1)
	   (for-each 
	    (lambda (arg2)
	      (for-each 
	       (lambda (n)
		 (catch #t
			(lambda () (set! (n arg1) arg2))
			(lambda args (car args))))
	       set-procs1))
	    (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) (make-color .95 .95 .95) '#(0 1) 3/4 
		  (sqrt -1.0) (make-delay 32) :feedback -1 0 #f #t '() 12345678901234567890)))
	 (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) (make-color .95 .95 .95) '#(0 1) 3/4 
	       (sqrt -1.0) (make-delay 32) :frequency -1 0 #f #t '() 12345678901234567890))
	(gc)

	;; ---------------- set! 2 Args
	(for-each 
	 (lambda (arg1)
	   (for-each 
	    (lambda (arg2)
	      (for-each 
	       (lambda (arg3)
		 (for-each 
		  (lambda (n)
		    (catch #t
			   (lambda () (set! (n arg1 arg2) arg3))
			   (lambda args (car args))))
		  set-procs2))
	       (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) (make-color .95 .95 .95) '#(0 1) 3/4 
		     (sqrt -1.0) (make-delay 32) :feedback -1 0 #f #t '() 12345678901234567890)))
	    (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) (make-color .95 .95 .95) '#(0 1) 3/4 
		  (sqrt -1.0) (make-delay 32) :frequency -1 0 #f #t '() 12345678901234567890)))
	 (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) (make-color .95 .95 .95) '#(0 1) 3/4 
	       (sqrt -1.0) (make-delay 32) :frequency -1 0 #f #t '() 12345678901234567890))
	(gc)

	(if all-args
	    ;; these can take awhile...
	    (begin
	      ;; ---------------- 3 Args
	      (for-each 
	       (lambda (arg1)
		 (begin
		   (for-each
		    (lambda (arg2)
		      (for-each 
		       (lambda (arg3)
			 (for-each
			  (lambda (n)
			    (catch #t
				   (lambda () (n arg1 arg2 arg3))
				   (lambda args (car args))))
			  procs3))
		       (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) '#(0 1) (sqrt -1.0) (make-delay 32) :start -1 0 #f #t '() 12345678901234567890)))
		    (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) '#(0 1) (sqrt -1.0) (make-delay 32) :phase -1 0 #f #t '() 12345678901234567890))))
	       (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) '#(0 1) (sqrt -1.0) (make-delay 32) :channels -1 0 #f #t '() 12345678901234567890))
	      (gc)

	      ;; ---------------- set! 3 Args
	      (for-each 
	       (lambda (arg1)
		 (for-each 
		  (lambda (arg2)
		    (for-each 
		     (lambda (arg3)
		       (for-each 
			(lambda (arg4)
			  (for-each 
			   (lambda (n)
			     (catch #t
				    (lambda () (set! (n arg1 arg2 arg3) arg4))
				    (lambda args (car args))))
			   set-procs3))
			(list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) (sqrt -1.0) (make-delay 32) :wave -1 0 #f #t '() 12345678901234567890)))
		     (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) (sqrt -1.0) (make-delay 32) :initial-contents -1 0 #f #t '() 12345678901234567890)))
		  (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) (sqrt -1.0) (make-delay 32) :srate -1 0 #f #t '() 12345678901234567890)))
	      (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) (sqrt -1.0) (make-delay 32) :input -1 0 #f #t '() 12345678901234567890))


	      ;; ---------------- 4 Args
	      (for-each 
	       (lambda (arg1)
		 (begin
		   (for-each 
		    (lambda (arg2)
		      (for-each 
		       (lambda (arg3)
			 (for-each 
			  (lambda (arg4)
			    (for-each
			     (lambda (n)
			       (catch #t
				      (lambda () (n arg1 arg2 arg3 arg4))
				      (lambda args (car args))))
			     procs4))
			  (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) (sqrt -1.0) (make-delay 32) :wave -1 0 #f #t '() 12345678901234567890)))
		       (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) (sqrt -1.0) (make-delay 32) :initial-contents -1 0 #f #t '() 12345678901234567890)))
		    (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) (sqrt -1.0) (make-delay 32) :srate -1 0 #f #t '() 12345678901234567890))))
	       (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) (sqrt -1.0) (make-delay 32) :input -1 0 #f #t '() 12345678901234567890))

	      ;; ---------------- set! 4 Args
	      (for-each 
	       (lambda (arg1)
		 (for-each 
		  (lambda (arg2)
		    (for-each 
		     (lambda (arg3)
		       (for-each 
			(lambda (arg4)
			  (for-each 
			   (lambda (arg5)
			     (for-each 
			      (lambda (n)
				(catch #t
				       (lambda () (set! (n arg1 arg2 arg3 arg4) arg5))
				       (lambda args (car args))))
			      set-procs4))
			   (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) (sqrt -1.0) (make-delay 32) :wave -1 0 #f #t '() 12345678901234567890)))
			(list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) (sqrt -1.0) (make-delay 32) :initial-contents -1 0 #f #t '() 12345678901234567890)))
		     (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) (sqrt -1.0) (make-delay 32) :srate -1 0 #f #t '() 12345678901234567890)))
		  (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) (sqrt -1.0) (make-delay 32) :input -1 0 #f #t '() 12345678901234567890)))
		 (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) (sqrt -1.0) (make-delay 32) :input -1 0 #f #t '() 12345678901234567890))

	      ;; ---------------- 5 Args
	      (for-each 
	       (lambda (arg1)
		 (for-each 
		  (lambda (arg2)
		    (for-each 
		     (lambda (arg3)
		       (for-each 
			(lambda (arg4)
			  (for-each
			   (lambda (arg5)
			     (for-each 
			      (lambda (n)
				(catch #t
				       (lambda () (n arg1 arg2 arg3 arg4 arg5))
				       (lambda args (car args))))
			      procs5))
			   (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) (sqrt -1.0) (make-delay 32) :wave -1 0 1 #f #t '() 12345678901234567890)))
			(list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) (sqrt -1.0) (make-delay 32) :initial-contents -1 0 1 #f #t '() 12345678901234567890)))
		     (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) (sqrt -1.0) (make-delay 32) :srate -1 0 1 #f #t '() 12345678901234567890)))
		  (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) (sqrt -1.0) (make-delay 32) :input -1 0 1 #f #t '() 12345678901234567890)))
	       (list 1.5 "/hiho" (list 0 1) 1234 (make-vct 3) (sqrt -1.0) (make-delay 32) :order -1 0 1 #f #t '() 12345678901234567890))

	      (gc)))
	))

(set! (window-y) 10)
;(set! (basic-color) (make-color 0.96 0.96 0.86))
(dismiss-all-dialogs)



;;; -------------------------------- clean up and quit -------------------------------- 

;(set! (max-regions) 2)
(let ((regs (regions)))
  (for-each
   (lambda (n)
     (forget-region n))
   regs))
(set! (previous-files-sort) 0)

(if (file-exists? "saved-snd.scm") (delete-file "saved-snd.scm"))
(gc)
(clear-sincs)
(reset-all-hooks)

(save-listener "test.output")
(set! (listener-prompt) original-prompt)

(snd-display ";all done!~%~A" original-prompt)

(let ((gc-lst (gc-stats)))
  (snd-display "timings:~%  ~A: total~%  GC: ~A~%~{    ~A~%~})" 
	       (/ (- (get-internal-real-time) overall-start-time) internal-time-units-per-second) 
	       (/ (cdr (list-ref gc-lst 0)) 1000)
	       (list (list-ref gc-lst 1) 
		     (list-ref gc-lst 5) 
		     (list-ref gc-lst 9))))

(if (not (null? times))
    (for-each (lambda (n)
 		(snd-display "  ~A: ~A" (cadr n) (car n)))
 	      times))

(if (number? (vector-ref timings total-tests)) 
    (vector-set! timings total-tests (- (get-internal-real-time) (vector-ref timings total-tests))))
(do ((i 0 (1+ i)))
    ((= i (+ total-tests 1)))
  (if (number? (vector-ref timings i))
      (display (format #f " [~D: ~A]" i (/ (vector-ref timings i) internal-time-units-per-second)))))
	
(if (string? test14-file)
    (snd-display "~%~A(~D)" test14-file (mus-sound-samples test14-file)))

(show-listener)
(snd-display "~%")
(if (file-exists? original-save-dir)
    (begin
      (snd-display (format #f "ls ~A/snd_* | wc~%" original-save-dir))
      (system (format #f "ls ~A/snd_* | wc" original-save-dir))
      (system (format #f "rm ~A/snd_*" original-save-dir))))

(if (file-exists? original-temp-dir)
    (begin
      (snd-display (format #f "ls ~A/snd_* | wc~%" original-temp-dir))
      (system (format #f "ls ~A/snd_* | wc" original-temp-dir))
      (system (format #f "rm ~A/snd_*" original-temp-dir))))

(if (file-exists? "/tmp")
    (begin ; -noinit possibly
      (snd-display (format #f "ls /tmp/snd_* | wc~%"))
      (system "ls /tmp/snd_* | wc")
      (system "rm /tmp/snd_*")))

(system "cp /home/bil/dot-snd /home/bil/.snd")

(if with-exit (exit))

;;; need to know before calling this if libguile.so was loaded
;;; (system "cc gsl-ex.c -c")
;;; (system "ld -shared gsl-ex.o -o gsl-ex.so -lguile")
;;; (define handle (dlopen "/home/bil/snd-4/gsl-ex.so"))
;;; (dlinit handle "init_gsl_j0")
;;; (fneq (j0 1.0) 0.765)

