<?php
/*  
 * Analysis Console for Intrusion Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000, 2001 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose:   
 *
 */

define("UDP", 17);
define("TCP", 6);
define("ICMP", 1);

function GetSensorIDs($db)
{
   $result = $db->acidExecute("SELECT sid FROM sensor;");

   while( $myrow = $result->acidFetchRow() ) {
	$sensor_ids[] = $myrow[0];
   }

   $result->acidFreeRows();

   return $sensor_ids;
}

function GetSensorName($sid, $db)
{
    $name = "";

    $temp_sql = "SELECT sid, hostname, interface, filter FROM sensor WHERE sid=".$sid;
    $tmp_result = $db->acidExecute($temp_sql);
    if ( $tmp_result )
    {
       $myrow = $tmp_result->acidFetchRow();
       $name = $myrow[1].':'.$myrow[2];
       if ( $myrow[3] != "" )
          $name = $name.':'.$myrow[3];
    }
    $tmp_result->acidFreeRows();

    return $name;
}

function InitArray(&$a, $dim1, $dim2, $value)
{
   $a = "";
   /* determine the number of dimensions in the array */
   if ( $dim2 == 0 )   /* 1-dim */
      for ( $i = 0; $i < $dim2; $i++ ) 
         $a[$i] = $value;
   else                /* 2-dim */
      for ( $i = 0; $i < $dim1; $i++ )
         for ( $j = 0; $j < $dim2; $j++ )
            $a[$i][$j] = $value;
}

function InitGlobalState()
{
  GLOBAL $time, $time_cnt, $sig, $sensor, $ag,
         $ip_addr, $ip_addr_cnt, $ip_field, $ip_field_cnt,
         $tcp_port, $tcp_port_cnt, $tcp_flags, $tcp_field, $tcp_field_cnt,
         $udp_port, $udp_port_cnt, $udp_field, $udp_field_cnt,
         $icmp_field, $icmp_field_cnt,
         $have_meta, $have_ip, $have_tcp, $have_udp, $have_icmp, $have_data,
         $layer4, $data, $data_cnt, $data_encode, $save_criteria,
         $join_sql, $where_sql, $criteria_sql, $sql, $debug_mode;
   GLOBAL $MAX_ROWS;

   $caller = "";
   $layer4 = "";

   $ag = "";
   $sensor = "";
   InitArray($sig, 2, 0, ""); 
   InitArray($time, $MAX_ROWS, 10, "");
   $time_cnt = 0;

   InitArray($ip_addr, $MAX_ROWS, 10, "");
   $ip_addr_cnt = 0;
   InitArray($ip_field, $MAX_ROWS, 6, "");  
   $ip_field_cnt = 0;

   InitArray($tcp_port, $MAX_ROWS, 6, "");
   $tcp_port_cnt = 0;
   InitArray($tcp_flags, $MAX_ROWS, 7, "");
   InitArray($tcp_field, $MAX_ROWS, 6, "");
   $tcp_field_cnt = 0;

   InitArray($udp_port, $MAX_ROWS, 6, "");
   $udp_port_cnt = 0;
   InitArray($udp_field, $MAX_ROWS, 6, "");
   $udp_field_cnt = 0;

   InitArray($icmp_field, $MAX_ROWS, 6, "");
   $icmp_field_cnt = 0;

   InitArray($data_encode, 2, 0, "");
   InitArray($data, $MAX_ROWS, 5, "");
   $data_cnt = 0;
}

function RegisterGlobalState()
{
  GLOBAL $time, $time_cnt, $sig, $sensor, $ag,
         $ip_addr, $ip_addr_cnt, $ip_field, $ip_field_cnt,
         $tcp_port, $tcp_port_cnt, $tcp_flags, $tcp_field, $tcp_field_cnt,
         $udp_port, $udp_port_cnt, $udp_field, $udp_field_cnt,
         $icmp_field, $icmp_field_cnt,
         $have_meta, $have_ip, $have_tcp, $have_udp, $have_icmp, $have_data,
         $layer4, $data, $data_cnt, $data_encode, $save_criteria,
         $join_sql, $where_sql, $criteria_sql, $sql, $debug_mode;

   GLOBAL $MAX_ROWS;

   session_start();

   //session_register('caller');
   session_register('layer4');
   // session_register('save_sql');       /* ?? */
   // session_register('save_criteria');  /*  ?? */

   //   session_register('num_result_rows');
   //   session_register('current_view');
   //   session_register('sort_order');

   session_register('ag');
   session_register('sig_type');
   session_register('sig');
   session_register('sensor');
   session_register('time');
   session_register('time_cnt');

   session_register('ip_addr');
   session_register('ip_addr_cnt');
   session_register('ip_field');
   session_register('ip_field_cnt');

   session_register('tcp_port');
   session_register('tcp_port_cnt');
   session_register('tcp_flags');
   session_register('tcp_field');
   session_register('tcp_field_cnt');

   session_register('udp_port');
   session_register('udp_port_cnt');
   session_register('udp_field');
   session_register('udp_field_cnt');

   session_register('icmp_field');
   session_register('icmp_field_cnt');

   session_register('data_encode');
   session_register('data');
   session_register('data_cnt');

   if ( $debug_mode > 0 )
      echo '<FONT COLOR="#FF0000">Session Registered</FONT><BR>';
}

function ImportGlobalState()
{
  GLOBAL $time, $time_cnt, $sig, $sig_type, $sensor, $ag,
         $ip_addr, $ip_addr_cnt, $ip_field, $ip_field_cnt,
         $tcp_port, $tcp_port_cnt, $tcp_flags, $tcp_field, $tcp_field_cnt,
         $udp_port, $udp_port_cnt, $udp_field, $udp_field_cnt,
         $icmp_field, $icmp_field_cnt,
         $have_meta, $have_ip, $have_tcp, $have_udp, $have_icmp, $have_data,
         $layer4, $data, $data_cnt, $data_encode, $save_criteria,
         $join_sql, $where_sql, $criteria_sql, $sql, $debug_mode,
         $caller, $layer4;

      $ip_addr = SetSessionVar('ip_addr', $ip_addr);
      $ip_addr_cnt = SetSessionVar('ip_addr_cnt', $ip_addr_cnt);

      $ag = SetSessionVar("ag", $ag);
      $sig = SetSessionVar("sig", $sig);
      $sig_type = SetSessionVar("sig_type", $sig_type);
      $sensor = SetSessionVar('sensor', $sensor);
      $time = SetSessionVar('time', $time);
      $time_cnt = SetSessionVar('time_cnt', $time_cnt);

      $ip_field = SetSessionVar('ip_field', $ip_field);
      $ip_field_cnt = SetSessionVar('ip_field_cnt', $ip_field_cnt);

      $tcp_port = SetSessionVar('tcp_port', $tcp_port);
      $tcp_port_cnt = SetSessionVar('tcp_port_cnt', $tcp_port_cnt);
      $tcp_flags = SetSessionVar('tcp_flags', $tcp_flags);
      $tcp_field = SetSessionVar('tcp_field', $tcp_field);
      $tcp_field_cnt = SetSessionVar('tcp_field_cnt', $tcp_field_cnt);

      $udp_port = SetSessionVar('udp_port', $udp_port);
      $udp_port_cnt = SetSessionVar('udp_port_cnt', $udp_port_cnt);
      $udp_field = SetSessionVar('udp_field', $udp_field);
      $udp_field_cnt = SetSessionVar('udp_field_cnt', $udp_field_cnt);

      $icmp_field = SetSessionVar('icmp_field', $icmp_field);
      $icmp_field_cnt = SetSessionVar('icmp_field_cnt', $icmp_field_cnt);

      $data_encode = SetSessionVar('data_encode', $data_encode);
      $data = SetSessionVar('data', $data);
      $data_cnt = SetSessionVar('data_cnt', $data_cnt);

      $layer4 = SetSessionVar('layer4', $layer4);
      //$caller = SetSessionVar('caller', $caller);
      // $sort_order = SetSessionVar('sort_order', $sort_order);
}

function SanitizeVariable($item, $validchars)
{
   $len = strlen($item);

   for ( $i = 0; $i < $len; $i++ );
      
}

function CleanVariable($item, $method)
{
   return $item;
   switch ($method)
   {
      case 0:     /* only numbers */
         return ereg_replace ("^0123456789", "", $item);

      case 1:     /* IP address */
         return ereg_replace ("^0123456789\.", "", $item);
   }

}

function SetSessionVar($var_name, $old_value)
{
   GLOBAL $HTTP_POST_VARS, $HTTP_GET_VARS, $debug_mode;

   if ( isset($HTTP_POST_VARS[$var_name]) ) 
   {
      if ( $debug_mode > 0 )  echo "importing POST var '$var_name'<BR>";
      return $HTTP_POST_VARS[$var_name];
   }
   else if ( isset($HTTP_GET_VARS[$var_name]) )
   { 
      if ( $debug_mode > 0 )  echo "importing GET var '$var_name'<BR>";
      return $HTTP_GET_VARS[$var_name];
   }
   else
      return $old_value;  
}

function ImportHTTPVar($var_name)
{
   GLOBAL $HTTP_POST_VARS, $HTTP_GET_VARS, $debug_mode;

   if ( isset($HTTP_POST_VARS[$var_name]) ) 
   {
      //if ( $debug_mode > 0 )  echo "importing POST var '$var_name'<BR>";
      return $HTTP_POST_VARS[$var_name];
   }
   else if ( isset($HTTP_GET_VARS[$var_name]) )
   { 
      //if ( $debug_mode > 0 )  echo "importing GET var '$var_name'<BR>";
      return $HTTP_GET_VARS[$var_name];
   }
   else
      return "";  
}

function ErrorMessage ($message)
{
   echo '<FONT COLOR="#FF0000">'.$message.'</FONT><P>';
}

function FatalError ($message)
{
   echo '<FONT COLOR="#FF0000"><B>ACID FATAL ERROR:</B> '.$message.'</FONT>';
   die();  
}

function PrintServerInformation()
{
   echo '';
}

function PrintPageHeader()
{
     GLOBAL $PHP_SELF, $HTTP_REFERER, $QUERY_STRING,
            $HTTP_USER_AGENT, $SERVER_SOFTWARE, $DBtype, $ADODB_vers;

     echo "<PRE>
         <B>URL:</B> '$PHP_SELF' (<B>refered by:</B> '$HTTP_REFERER')
         <B>PARAMETERS:</B> '$QUERY_STRING'
         <B>CLIENT:</B> $HTTP_USER_AGENT
         <B>SERVER:</B> $SERVER_SOFTWARE 
         <B>SERVER HW:</B> ".php_uname()."
         <B>DATABASE TYPE:</B> $DBtype  <B>DB ABSTRACTION VERSION:</B> $ADODB_vers
         <B>PHP VERSION:</B> ".phpversion()."  <B>PHP API:</B> ".php_sapi_name()."
         </PRE>";
}

function InputSafeSQL (&$SQLstr)
/* Removes the escape sequence of \' => ' which arise when a variable containing a '-character is passed
   through a POST query.  This is needed since otherwise the MySQL parser complains */
{
   $SQLstr = str_replace("\'", "'", $SQLstr);
   $SQLstr = str_replace("\\\"", "\"", $SQLstr);
}


function PrintProtocolProfileGraphs ($db)
{
   $tcp_cnt = TCPPktCnt($db);
   $udp_cnt = UDPPktCnt($db);
   $icmp_cnt = ICMPPktCnt($db);
   $portscan_cnt = PortscanPktCnt($db);
   $layer4_cnt = $tcp_cnt + $udp_cnt + $icmp_cnt + $portscan_cnt;

   if ( $tcp_cnt > 0 )
   {  
      $tcp_percent = round($tcp_cnt/$layer4_cnt*100);
      if ( $tcp_percent == 0 )  
         $tcp_percent_show = "&lt; 1";
      else
         $tcp_percent_show = $tcp_percent; 
   }  
   else 
   {
      $tcp_percent = 0;
      $tcp_percent_show = "0";
   }

   if ( $udp_cnt > 0 )
   {  
      $udp_percent = round($udp_cnt/$layer4_cnt*100);
      if ( $udp_percent == 0 )  
         $udp_percent_show = "&lt; 1";  
      else 
         $udp_percent_show = $udp_percent;
   }   
   else
   { 
      $udp_percent = 0;
      $udp_percent_show = "0";
   }

   if ( $icmp_cnt > 0 ) 
   {
      $icmp_percent = round($icmp_cnt/$layer4_cnt*100); 
      if ( $icmp_percent == 0 )  
         $icmp_percent_show = "&lt; 1";
       else
         $icmp_percent_show = $icmp_percent;
   }
   else
   { 
      $icmp_percent = 0;
      $icmp_percent_show = 0;
   }

   if ( $portscan_cnt > 0 )
   {  
      $portscan_percent = round($portscan_cnt/$layer4_cnt*100);
      if ( $portscan_percent == 0 )  
         $portscan_percent_show = "&lt; 1";
      else
         $portscan_percent_show = $portscan_percent; 
   }  
   else 
   {
      $portscan_percent = 0;
      $portscan_percent_show = "0";
   }

   if ( $tcp_percent > 0 )   $color = "#FF0000";  else  $color="#CCCCCC";
   $rem_percent=100-$tcp_percent;
   echo '<TABLE WIDTH="100%" BORDER=0>
         <TR><TD>TCP<A HREF="acid_pkt_main.php?new=1'.
                           '&layer4=TCP&num_result_rows=-1&sort_order=time_d&submit=Query+DB">
                           ('.$tcp_percent_show.'%)</A></TD><TD></TD></TR></TABLE>
                  <TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=0>
                  <TR><TD ALIGN=CENTER BGCOLOR="'.$color.'" WIDTH="'.$tcp_percent.'%">&nbsp;</TD>
                      <TD BGCOLOR="#CCCCCC" WIDTH="'.$rem_percent.'%">&nbsp;</TD></TR>
                  </TABLE>';

    if ( $udp_percent > 0 )   $color = "#FF0000";  else  $color="#CCCCCC";
    $rem_percent=100-$udp_percent;
    echo '<TABLE WIDTH="100%" BORDER=0>
          <TR><TD>UDP<A HREF="acid_pkt_main.php?new=1'.
                            '&layer4=UDP&num_result_rows=-1&sort_order=time_d&submit=Query+DB">
                            ('.$udp_percent_show.'%)</A></TD><TD></TD></TR></TABLE>
                  <TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=0>
                  <TR><TD ALIGN=CENTER BGCOLOR="'.$color.'" WIDTH="'.$udp_percent.'%">&nbsp;</TD>
                      <TD BGCOLOR="#CCCCCC" WIDTH="'.$rem_percent.'%">&nbsp;</TD></TR>
                  </TABLE>';

     if ( $icmp_percent > 0 )   $color = "#FF0000";  else  $color="#CCCCCC";
     $rem_percent=100-$icmp_percent;
     echo '<TABLE WIDTH="100%" BORDER=0>
           <TR><TD>ICMP<A HREF="acid_pkt_main.php?new=1'.
                              '&layer4=ICMP&num_result_rows=-1&sort_order=time_d&submit=Query+DB">
                              ('.$icmp_percent_show.'%)</A></TD><TD></TD></TR></TABLE>
                  <TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=0>
                  <TR><TD ALIGN=CENTER BGCOLOR="'.$color.'" WIDTH="'.$icmp_percent.'%">&nbsp;</TD>
                      <TD BGCOLOR="#CCCCCC" WIDTH="'.$rem_percent.'%">&nbsp;</TD></TR>
                  </TABLE>';
    
     echo '<CENTER><HR NOSHADE WIDTH="70%"></CENTER>';

     if ( $portscan_percent > 0 )   $color = "#FF0000";  else  $color="#CCCCCC";
     $rem_percent=100-$portscan_percent;
     echo '<TABLE WIDTH="100%" BORDER=0>
           <TR><TD>Portscan Traffic
               <A HREF="acid_pkt_main.php?new=1&sig_type=0&sig%5B0%5D=LIKE&sig%5B1%5D='.
                              (rawurlencode("spp_portscan")).'&caller=stat_alerts'.
                              '&submit=Query+DB&num_result_rows=-1">('.$portscan_percent_show.'%)</A>
                    </TD><TD></TD></TR></TABLE>
                  <TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=0>
                  <TR><TD ALIGN=CENTER BGCOLOR="'.$color.'" WIDTH="'.$portscan_percent.'%">&nbsp;</TD>
                      <TD BGCOLOR="#CCCCCC" WIDTH="'.$rem_percent.'%">&nbsp;</TD></TR>
                  </TABLE>';
    //echo "portscan_cnt = $portscan_cnt<BR> layer4_cnt = $layer4_cnt<BR>";

}

function chk_select($stored_value, $current_value)
{
     if ( $stored_value == $current_value )
          return " SELECTED";
     else
          return " ";
}

function chk_check($stored_value, $current_value)
{
     if ( $stored_value == $current_value )
          return " CHECKED";
     else
          return " ";
}

function BuildIPFormVars($ipaddr)
{
    return ''.
    '&ip_addr%5B0%5D%5B0%5D=+&ip_addr%5B0%5D%5B1%5D=ip_src&ip_addr%5B0%5D%5B2%5D=%3D'.
    '&ip_addrs%5B0%5D='.$ipaddr.
    '&ip_addr%5B0%5D%5B8%5D=+&ip_addr%5B0%5D%5B9%5D=OR'.
    '&ip_addr%5B1%5D%5B0%5D=+&ip_addr%5B1%5D%5B1%5D=ip_dst&ip_addr%5B1%5D%5B2%5D=%3D'.
    '&ip_addrs%5B1%5D='.$ipaddr.
    '&ip_addr%5B1%5D%5B8%5D=+&ip_addr%5B1%5D%5B9%5D=+'.
    '&ip_address_input2=2'; 
}

function BuildSrcIPFormVars($ipaddr)
{
    return ''.
    '&ip_addr%5B0%5D%5B0%5D=+&ip_addr%5B0%5D%5B1%5D=ip_src&ip_addr%5B0%5D%5B2%5D=%3D'.
    '&ip_addrs%5B0%5D='.$ipaddr.
    '&ip_addr%5B0%5D%5B8%5D=+&ip_addr%5B0%5D%5B9%5D=+'.
    '&ip_address_input2=2';
}

function BuildDstIPFormVars($ipaddr)
{
    return ''.
    '&ip_addr%5B0%5D%5B0%5D=+&ip_addr%5B0%5D%5B1%5D=ip_dst&ip_addr%5B0%5D%5B2%5D=%3D'.
    '&ip_addrs%5B0%5D='.$ipaddr.
    '&ip_addr%5B0%5D%5B8%5D=+&ip_addr%5B0%5D%5B9%5D=+'.
    '&ip_address_input2=2'; 
}

function BuildUniqueAddressLink($addr_type, $raw = "" )
{
   return '<A HREF="acid_stat_uaddr.php?addr_type='.$addr_type.$raw.'">';
}

function BuildUniqueAlertLink($raw)
{
   return '<A HREF="acid_stat_alerts.php'.$raw.'">';
}

function BuildAddressLink($ipaddr, $netmask)
{
   return '<A HREF="acid_stat_ipaddr.php?ip='.rawurlencode($ipaddr).
                                       '&netmask='.$netmask.'">';
}

function AddCriteriaFormRow ( &$submit, $submit_value, &$cnt, &$current_boolean )
{
   $submit = $submit_value;

   ++$cnt;

   /* if ( $current_boolean == ' ' || $current_boolean == '' )
      $current_boolean = "OR"; */
}

function PrintBrowseButtons($num_result_rows, $show_rows, $max_scroll_buttons, $current_view)
{
  if ( $num_result_rows > 0 && $num_result_rows > $show_rows )
  {
     echo '
          <P><CENTER>
             <TABLE BORDER=1>
               <TR><TD ALIGN=CENTER>Query Results<BR>&nbsp'."\n";

     $tmp_num_views = ($num_result_rows / $show_rows);
     $tmp_top = $tmp_bottom = $max_scroll_buttons / 2;

     if ( ($current_view - ($max_scroll_buttons/2)) >= 0 )
        $tmp_bottom = $current_view - $max_scroll_buttons/2;
     else
        $tmp_bottom = 0;

     if ( ($current_view + ($max_scroll_buttons/2)) <= $tmp_num_views )
        $tmp_top = $current_view + $max_scroll_buttons/2;
     else
        $tmp_top = $tmp_num_views;

     /* Show a '<<' symbol of have scrolled beyond the 0 view */
     if ( $tmp_bottom != 0 )
        echo ' << ';

     for ( $i = $tmp_bottom; $i < $tmp_top; $i++)
     {
         if ( $i != $current_view )
            echo '<INPUT TYPE="submit" NAME="submit" VALUE="'.$i.'">'."\n";
         else
            echo '['.$i.'] '."\n";
     }  
     
     /* Show a '>>' symbol if last view is not visible */
     if ( ($tmp_top) < $tmp_num_views )
        echo ' >> ';

     echo '</TD></TR></TABLE></CENTER>';
  }
}


function IPProto2str($ipproto_code)
{
   switch($ipproto_code)
   {
      case 0:
          return "IP";
      case 1:
          return "ICMP";
      case 2:
          return "IGMP";
      case 4:
          return "IPIP tunnels";
      case 6:
          return "TCP";
      case 8:
          return "EGP";
      case 12:
          return "PUP";
      case  17:
          return "UDP";
      case 22:
          return "XNS UDP";
      case 29:
          return "SO TP Class 4";
      case 41:
          return "IPv6 header";
      case 43:
          return "IPv6 routing header";
      case 44:
          return "IPv6 fragmentation header";
      case 46: 
          return "RSVP";
      case 47:
          return "GRE";
      case 50: 
          return "IPSec ESP";
      case 51: 
          return "IPSec AH";
      case 58: 
          return "ICMPv6";
      case 59: 
          return "IPv6 no next header";
      case 60:
          return "IPv6 destination options";
      case 92:
          return "MTP";
      case 98:
          return "Encapsulation header";
      case 103: 
          return "PIM";
      case 108:
          return "COMP";
      case 255: 
          return "Raw IP";
      default:
          return $ipproto_code;
   }
} 

function TCPOption2str($tcpopt_code)
/* per RFC 1072, 1323, 1644 */
{
   switch($tcpopt_code)
   {
      case 2:                  /* TCPOPT_MAXSEG - maximum segment*/ 
          return "MSS";
      case 0:                  /* TCPOPT_EOL */
          return "EOL";
      case 1:                  /* TCPOPT_NOP */
          return "NOP";
      case 3:                  /* TCPOPT_WSCALE (rfc1072)- window scale factor */
          return "WS";
      case 5:                  /* TCPOPT_SACK (rfc1072)- selective ACK */
          return "SACK";
      case 4:                  /* TCPOPT_SACKOK (rfc1072)- selective ACK OK */
          return "SACKOK";
      case 6:                  /* TCPOPT_ECHO (rfc1072)- echo */
          return "Echo";
      case 7:                  /* TCPOPT_ECHOREPLY (rfc1072)- echo reply */
          return "Echo Reply";
      case 8:                  /* TCPOPT_TIMESTAMP (rfc1323)- timestamps */
          return "TS";
      case 11:                 /* TCPOPT_CC (rfc1644)- CC options */
          return "CC";
      case 12:                 /* TCPOPT_CCNEW (rfc1644)- CC options */
          return "CCNEW";
      case 13:                 /* TCPOPT_CCECHO (rfc1644)- CC options */
          return "CCECHO";
      default:
          return $tcpopt_code;
   }
}

function IPOption2str($ipopt_code)
{
   switch($ipopt_code)
   {
      case 7:              /* IPOPT_RR */
          return "RR";
      case 0:              /* IPOPT_EOL */
          return "EOL";
      case 1:              /* IPOPT_NOP */
          return "NOP";
      case 0x44:           /* IPOPT_TS */
          return "TS";
      case 0x82:           /* IPOPT_SECURITY */
          return "SEC";
      case 0x83:           /* IPOPT_LSRR */
          return "LSRR";
      case 0x84:           /* IPOPT_LSRR_E */
          return "LSRR_E";
      case 0x88:           /* IPOPT_SATID */
          return "SID";
      case 0x89:           /* IPOPT_SSRR */
          return "SSRR";
  }
}

function ICMPType2str($icmp_type)
{
  switch ($icmp_type)
  {
      case 0:                             /* ICMP_ECHOREPLY */
          return "Echo Reply";
      case 3:                             /* ICMP_DEST_UNREACH */
          return "Destination Unreachable";
      case 4:                             /* ICMP_SOURCE_QUENCH */
          return "Source Quench";
      case 5:                             /* ICMP_REDIRECT */
          return "Redirect";
      case 8:                             /* ICMP_ECHO */
          return "Echo Request";
      case 9:
          return "Router Advertisement";
      case 10:
          return "Router Solicitation"; 
      case 11:                            /* ICMP_TIME_EXCEEDED */
          return "Time Exceeded";
      case 12:                            /* ICMP_PARAMETERPROB */
          return "Parameter Problem";
      case 13:                            /* ICMP_TIMESTAMP */
          return "Timestamp Request";
      case 14:                            /* ICMP_TIMESTAMPREPLY */
          return "Timestamp Reply";
      case 15:                            /* ICMP_INFO_REQUEST */
          return "Information Request";
      case 16:                            /* ICMP_INFO_REPLY */
          return "Information Reply";
      case 17:                            /* ICMP_ADDRESS */
          return "Address Mask Request";
      case 18:                            /* ICMP_ADDRESSREPLY */
          return "Address Mask Reply";
      default:
          return $icmp_type;
  }
}

function ICMPCode2str($icmp_type, $icmp_code)
{
  if ( $icmp_type == 3 )
  {
     switch ($icmp_code)
     {
        case 0:                                    /* ICMP_NET_UNREACH */
            return "Network Unreachable";
        case 1:                                    /* ICMP_HOST_UNREACH */
            return "Host Unreachable";
        case 2:                                    /* ICMP_PROT_UNREACH */
            return "Protocol Unreachable";
        case 3:                                    /* ICMP_PORT_UNREACH */
            return "Port Unreachable";
        case 4:                                    /* ICMP_FRAG_NEEDED */
            return "Fragmentation Needed/DF set";
        case 5:                                    /* ICMP_SR_FAILED */
            return "Source Route failed";
        case 6:                                    /* ICMP_NET_UNKNOWN */
            return "Network Unknown";
        case 7:                                    /* ICMP_HOST_UNKNOWN */
            return "Host Unknown";
        case 8:                                    /* ICMP_HOST_ISOLATED */
            return "Host Isolated";
        case 9:                                    /* ICMP_NET_ANO */
            return "Network ANO";
        case 10:                                   /* ICMP_HOST_ANO */
            return "Host ANO";
        case 11:                                   /* ICMP_NET_UNR_TOS */
            return "Network Unreach TOS";
        case 12:                                   /* ICMP_HOST_UNR_TOS */
            return "Host Unreach TOS";
        case 13:                                   /* ICMP_PKT_FILTERED */
            return "Packet Filtered";
        case 14:                                   /* ICMP_PREC_VIOLATION */
            return "Precedence violation";
        case 15:                                   /* ICMP_PREC_CUTOFF */
            return "Precedence cut off";
        default:
            return $icmp_code;
     }
  }
  else
     return $icmp_code;
}

function PrintPayloadChar( $char )
{
   if ( $char >= 32 && $char <= 127 )
      return htmlspecialchars(chr($char));
   else
      return '.';
}

function PrintBase64PacketPayload ( $encoded_payload )
{
     /* strip out the <CR> at the end of each block */
     $encoded_payload = str_replace("\n", "", $encoded_payload);
     //printf(" len = %d\n", strlen($encoded_payload));
     //printf("%s \n", $encoded_payload);

     $payload = base64_decode($encoded_payload);
     $len = strlen($payload);
     $s = " length = ".strlen($payload)."\n";

     for ($i = 0; $i < strlen($payload); $i++ )
     {
          if ( $i % 16 == 0 )
          {
             /* dump the ASCII characters */
             if ( $i != 0 )
             {
                $s = $s.'  ';
                for ($j = $i-16; $j < $i; $j++ )
                   $s = $s.PrintPayloadChar($payload[$j]);
             }
             $s = $s.sprintf("\n%03x : ", $i);
          }

          $s = $s.sprintf("%s ", bin2hex($payload[$i]) );
     }

     /* print the remained of any ASCII chars */
     if ( ($i % 16) != 0 )
     {
        for ( $j = 0; $j < 16 - ($i % 16); $j++)
            $s = $s.'   ';

        $s = $s.'  ';
        
        for ( $j = $len - ($i % 16); $j < $len; $j++ )
           $s = $s.PrintPayloadChar($payload[$j]);
     }

     return $s;
}

function PrintAsciiPacketPayload ( $encoded_payload )
{
   return wordwrap($encoded_payload, 70);
}

function PrintHexPacketPayload ( $encoded_payload )
{
     /* strip out the <CR> at the end of each block */
     $encoded_payload = str_replace("\n", "", $encoded_payload);
     $payload = $encoded_payload;

     $len = strlen($payload);
     $s = " length = ".(strlen($payload)/2)."\n";

     for ($i = 0; $i < strlen($payload); $i += 2 )
     {
          if ( $i % 32 == 0 )
          {
             /* dump the ASCII characters */
             if ( $i != 0 )
             {
                $s = $s.'  ';
                for ($j = $i-32; $j < $i; $j+=2 )
                {
                    $t = hexdec($payload[$j].$payload[$j+1]);
                    $s = $s.PrintPayloadChar($t);
                }
             }
             $s = $s.sprintf("\n%03x : ", $i/2);
          }
          $s = $s.sprintf("%s%s ", $payload[$i], $payload[$i+1] );
     }

     /* space through to align end of hex dump */
     if ( $i % 32 )
        for ( $j = 0; $j < 32 - ($i % 32); $j+=2)
           $s = $s.'   ';

     $s = $s.'  ';

     /* print the ASCII decode */
     if ( $i % 32 )
        $start = $len - ($i % 32);
     else
        $start = $len - 32;

     for ( $j = $start; $j < $i; $j+=2 )
     {
        $t = hexdec($payload[$j].$payload[$j+1]);
        $s = $s.PrintPayloadChar($t);
     } 

     return $s;
}

function PrintPacketPayload($data, $encode_type, $output_type)
{
     if ( $output_type == 1 )
        printf("\n<PRE>\n");

     /* print the packet based on encoding type */;
     if ( $encode_type == "1" )
         $payload = PrintBase64PacketPayload($data);
     else if ($encode_type == "2" )
         $payload = PrintAsciiPacketPayload($data);  
     else if ($encode_type == "0" )
         $payload = PrintHexPacketPayload($data); 
   
     if ( $output_type == 1 )
        echo "$payload\n</PRE>\n";
     
     return $payload;
}

function PrintPacketLookupBrowseButtons($seq, $save_sql, $db, &$previous_button, &$next_button)
{
  $result2 = $db->acidExecute($save_sql);

  if ( $seq == 0 )
     $previous_button = '[ First ]';

  $i = 0;
  while ($i <= $seq+1 )
  {
     $myrow2 = $result2->acidFetchRow();

     if ( $myrow2 == "" )
        $next_button = '[ Last ]'; 
     else if ( $i == $seq-1 )
        $previous_button = '<INPUT TYPE="submit" NAME="submit" VALUE="<< Previous #'.($seq-1).'-('.$myrow2[0].'-'.$myrow2[1].')">';

     else if ( $i == $seq+1 )
        $next_button = '<INPUT TYPE="submit" NAME="submit" VALUE=">> Next #'.($seq+1).'-('.$myrow2[0].'-'.$myrow2[1].')">';
     $i++;
  }

  $result2->acidFreeRows();
}

function GetQueryResultID($submit, &$seq, &$sid, &$cid)
{
  /* extract the sid and cid from the $submit variable of the form
     #XX-(XX-XX) 
      |   |  |
      |   |  |--- cid
      |   |------ sid
      |---------- sequence number of DB lookup
  */
  strtok($submit, "#");
  $seq = strtok("-");
         strtok("(");
  $sid = strtok("-");
  $cid = strtok(")");
}

function PacketLookup($submit, $db, $save_sql, $mod_snort_config)
{
  GLOBAL $action, $action_arg, $resolve_IP, $debug_mode;

  GetQueryResultID($submit, $seq, $sid, $cid);

  if ( $debug_mode > 0 )
     echo "====== Alert Lookup =======<BR>
           sid = $sid<BR>
           cid = $cid<BR>
           seq = $seq<BR>
           ===========================<BR>";

  PrintPacketLookupBrowseButtons($seq, $save_sql, $db, $previous, $next);
  echo "<CENTER><B>Alert #".($seq+1)."</B><BR>$previous &nbsp&nbsp&nbsp $next</CENTER>";
  echo '<HR>';

  /* Event */
  $sql2 = "SELECT signature, timestamp FROM event WHERE sid='".$sid."' AND cid='".$cid."'";
  $result2 = $db->acidExecute($sql2);
  $myrow2 = $result2->acidFetchRow();

  if ( $myrow2[0] == "" )
  {
     echo '<CENTER><B>';
     ErrorMessage("Alert DELETED");
     echo '</CENTER></B>';
  }

  echo '
       <TABLE BORDER=1>
          <TR><TD CLASS="metatitle" WIDTH=50 ALIGN=CENTER ROWSPAN=3>Meta
              <TD>
                  <TABLE BORDER=1 CELLPADDING=4>
                    <TR><TD CLASS="plfieldhdr" >ID #</TD>
                        <TD CLASS="plfieldhdr">Time</TD>
                        <TD CLASS="plfieldhdr">Triggered Signature</TD></TR>
                    <TR><TD CLASS="plfield">'.($sid." - ".$cid).'</TD>
                        <TD CLASS="plfield">'.$myrow2[1].'</TD>
                        <TD CLASS="plfield">'.BuildSigByID($myrow2[0], $db).'</TD></TR>      
                  </TABLE>
              </TD>
           </TR>';

  $sql4 = "SELECT hostname, interface, filter FROM sensor  WHERE sid='".$sid."'";
  $result4 = $db->acidExecute($sql4);
  $myrow4 = $result4->acidFetchRow();

  echo '  <TR>
             <TD>
                <TABLE BORDER=1 CELLPADDING=4>
                  <TR><TD CLASS="metatitle" ALIGN=CENTER ROWSPAN=2>Sensor</TD>
                       <TD class="plfieldhdr">name</TD>
                       <TD class="plfieldhdr">interface</TD>
                       <TD class="plfieldhdr">filter</TD>
                  </TR>
                  <TR><TD class="plfield">'.$myrow4[0].'</TD>
                      <TD class="plfield">'.$myrow4[1].'</TD>
                      <TD class="plfield">'.
                      ( ($myrow4[2] == "") ? "&nbsp;<I>none</I>&nbsp;" : $myrow4[2] ).'</TD>
                  </TR>
                 </TABLE>     
          </TR>';
  $result4->acidFreeRows();

  $sql4 = "SELECT DISTINCT acid_ag_alert.ag_id, ag_name, ag_desc ".
          "FROM acid_ag_alert LEFT JOIN acid_ag ON acid_ag_alert.ag_id = acid_ag.ag_id ".
          "WHERE ag_sid=".$sid." AND ag_cid=".$cid;
  $result4 = $db->acidExecute($sql4);
  $num = $result4->acidRecordCount();

  echo ' <TR>
           <TD>
             <TABLE BORDER=1 CELLPADDING=4>
               <TR><TD CLASS="metatitle" ALIGN=CENTER ROWSPAN='.($num+1).'>Alert<BR>Group</TD>';
  
  if ( $num > 0 )
     echo '        <TD class="plfieldhdr">ID #</TD>
                   <TD class="plfieldhdr">Name</TD>
                   <TD class="plfieldhdr">Description</TD></TR>';  
  else
     echo '        <TD>&nbsp;&nbsp;<I>none</I>&nbsp;</TD></TR>';

  for ($i = 0; $i < $num; $i++)
  {
     $myrow4 = $result4->acidFetchRow();

     echo '    <TR><TD class="plfield">'.$myrow4[0].'</TD>
                   <TD class="plfield">'.$myrow4[1].'</TD>
                   <TD class="plfield">'.$myrow4[2].'</TD>
               </TR>';
  }
  echo '      </TABLE>';
  $result4->acidFreeRows();

  echo '   </TR>
        </TABLE>';
  $result2->acidFreeRows();

  /* IP */
  $sql2 = "SELECT ip_src, ip_dst, ".
          "ip_ver, ip_hlen, ip_tos, ip_len, ip_id, ip_flags, ip_off, ip_ttl, ip_csum, ip_proto". 
          " FROM iphdr  WHERE sid='".$sid."' AND cid='".$cid."'";

  $result2 = $db->acidExecute($sql2);
  $myrow2 = $result2->acidFetchRow();

  if ( $myrow2[0] != "" )
  {
  $sql3 = "SELECT * FROM opt  WHERE sid='".$sid."' AND cid='".$cid."' AND opt_proto='0'";
  $result3 = $db->acidExecute($sql3);
  $num_opt = $result3->acidRecordCount();

  echo '
       <TABLE BORDER=1>
          <TR><TD CLASS="iptitle" WIDTH=50 ROWSPAN=3 ALIGN=CENTER>IP';
  echo '      <TD>';
  echo '         <TABLE BORDER=1 CELLPADDING=2>';
  echo '            <TR><TD class="plfieldhdr">source addr</TD>
                        <TD class="plfieldhdr">&nbsp dest addr &nbsp</TD>
                        <TD class="plfieldhdr">Ver</TD>
                        <TD class="plfieldhdr">Hdr Len</TD>
                        <TD class="plfieldhdr">TOS</TD>
                        <TD class="plfieldhdr">length</TD>
                        <TD class="plfieldhdr">ID</TD>
                        <TD class="plfieldhdr">flags</TD>
                        <TD class="plfieldhdr">offset</TD>
                        <TD class="plfieldhdr">TTL</TD>
                        <TD class="plfieldhdr">chksum</TD></TR>';
  echo '             <TR><TD class="plfield">
                       <A HREF="acid_stat_ipaddr.php?ip='.acidLong2IP($myrow2[0]).'&netmask=32">'.
                            acidLong2IP($myrow2[0]).'</A></TD>';
  echo '                 <TD class="plfield">
                         <A HREF="acid_stat_ipaddr.php?ip='.acidLong2IP($myrow2[1]).'&netmask=32">'.
                            acidLong2IP($myrow2[1]).'</A></TD>';
  echo '                 <TD class="plfield">'.$myrow2[2].'</TD>';
  echo '                 <TD class="plfield">'.$myrow2[3].'</TD>';
  echo '                 <TD class="plfield">'.$myrow2[4].'</TD>';
  echo '                 <TD class="plfield">'.$myrow2[5].'</TD>';
  echo '                 <TD class="plfield">'.$myrow2[6].'</TD>';
  echo '                 <TD class="plfield">'.$myrow2[7].'</TD>';
  echo '                 <TD class="plfield">'.$myrow2[8].'</TD>';
  echo '                 <TD class="plfield">'.$myrow2[9].'</TD>';
  echo '                 <TD class="plfield">'.$myrow2[10].'</TD></TR>';
  echo '         </TABLE>';

  if ( $resolve_IP == 1 )
  {
     echo '  <TR>
              <TD>
                <TABLE BORDER=1 CELLPADDING=4>
                  <TR><TD CLASS="iptitle" ALIGN=CENTER ROWSPAN=2>FQDN</TD>
                       <TD class="plfieldhdr">Source Name</TD>
                       <TD class="plfieldhdr">Dest. Name</TD>
                  </TR>
                  <TR><TD class="plfield">'.
                      (acidGetHostByAddr(acidLong2IP($myrow2[0]),
                                        $db, $dns_cache_lifetime)).'</TD>
                      <TD class="plfield">'.
                      (acidGetHostByAddr(acidLong2IP($myrow2[1]),
                                         $db, $dns_cache_lifetime)).'</TD>
                  </TR>
                 </TABLE>     
            </TR>';
  }

  echo '  <TR>';
  echo '      <TD>';
  echo '         <TABLE BORDER=1 CELLPADDING=4>';
  echo '           <TR><TD CLASS="iptitle" ALIGN=CENTER ROWSPAN='.(($num_opt != 0) ? ($num_opt+1) : 1).'>Options</TD>';

  $layer4_proto = $myrow2[11];

  if ( $num_opt > 0 )
  {
     echo '            <TD></TD>
                       <TD class="plfieldhdr">code</TD>
                       <TD class="plfieldhdr">length</TD>
                       <TD class="plfieldhdr" ALIGN=CENTER>data</TD>';

     for ( $i = 0; $i < $num_opt; $i++)
     {
         $myrow3 = $result3->acidFetchRow();
         echo '    <TR><TD>#'.($i+1).'</TD>';
         echo '        <TD class="plfield">'.IPOption2str($myrow3[4]).'</TD>';
         echo '        <TD class="plfield">'.$myrow3[5].'</TD>';
         echo '        <TD class="plfield">'.$myrow3[6].'</TD></TR>';             
     }
   }
   else
   {
     echo '             <TD> &nbsp&nbsp&nbsp <I>none </I></TD></TR>';
   }
      echo '         </TABLE></TD></TR>';  
                       

  echo '</TABLE>';
  $result3->acidFreeRows();
  }
  $result2->acidFreeRows();

  /* TCP */
  if ( $layer4_proto == "6" )  
  {
     $sql2 = "SELECT tcp_sport, tcp_dport, tcp_seq, tcp_ack, tcp_off, tcp_res, tcp_flags, tcp_win, ".
             "       tcp_csum, tcp_urp FROM tcphdr  WHERE sid='".$sid."' AND cid='".$cid."'";
     $result2 = $db->acidExecute($sql2);
     $myrow2 = $result2->acidFetchRow();

     $sql3 = "SELECT * FROM opt  WHERE sid='".$sid."' AND cid='".$cid."' AND opt_proto='6'";
     $result3 = $db->acidExecute($sql3);
     $num_opt = $result3->acidRecordCount();

      echo '
           <TABLE BORDER=1>
              <TR><TD CLASS="layer4title" WIDTH=50 ROWSPAN=2 ALIGN=CENTER>TCP';
      echo '      <TD>';
      echo '         <TABLE BORDER=1 CELLPADDING=2>';
      echo '            <TR><TD class="plfieldhdr">source<BR> port</TD>
                            <TD class="plfieldhdr"> dest<BR> &nbsp port &nbsp</TD>
                            <TD class="plfieldhdr">R<BR>1</TD>
                            <TD class="plfieldhdr">R<BR>0</TD>
                            <TD class="plfieldhdr">U<BR>R<BR>G</TD>
                            <TD class="plfieldhdr">A<BR>C<BR>K</TD>
                            <TD class="plfieldhdr">P<BR>S<BR>H</TD>
                            <TD class="plfieldhdr">R<BR>S<BR>T</TD>
                            <TD class="plfieldhdr">S<BR>Y<BR>N</TD>
                            <TD class="plfieldhdr">F<BR>I<BR>N</TD>
                            <TD class="plfieldhdr">seq #</TD>
                            <TD class="plfieldhdr">ack</TD>
                            <TD class="plfieldhdr">offset</TD>
                            <TD class="plfieldhdr">res</TD>
                            <TD class="plfieldhdr">window</TD>
                            <TD class="plfieldhdr">urp</TD>
                            <TD class="plfieldhdr">chksum</TD></TR>';
      $src_port = "http://www.snort.org/Database/portsearch.asp?number=".$myrow2[0];
      $dst_port = "http://www.snort.org/Database/portsearch.asp?number=".$myrow2[1]; 
      echo '            <TR><TD class="plfield"><A HREF="'.$src_port.'" TARGET="_ACID_PORT_">'.$myrow2[0].'</A></TD>';
      echo '                <TD class="plfield"><A HREF="'.$dst_port.'" TARGET="_ACID_PORT_">'.$myrow2[1].'</A></TD>';
      echo '                <TD class="plfield">';
      if ( ($myrow2[6] & 128) != 0 )
           echo 'X';
      echo '                    </TD><TD class="plfield">';
      if ( ($myrow2[6] & 64 ) != 0 )
           echo 'X';
      echo '                    </TD><TD class="plfield">';
      if ( ($myrow2[6] & 32) != 0 )
           echo 'X';
      echo '                    </TD><TD class="plfield">';
      if ( ($myrow2[6] & 16 ) != 0 )
           echo 'X';
      echo '                    </TD><TD class="plfield">';
      if ( ($myrow2[6] & 8) != 0 )
           echo 'X';
      echo '                    </TD><TD class="plfield">';
      if ( ($myrow2[6] & 4 ) != 0 )
           echo 'X';
      echo '                    </TD><TD class="plfield">';
      if ( ($myrow2[6] & 2 ) != 0 )
           echo 'X';
      echo '                    </TD><TD class="plfield">';
      if ( ($myrow2[6] & 1 ) != 0 )
           echo 'X';
      echo '                    </TD>';
     
      echo '                <TD class="plfield">'.$myrow2[2].'</TD>';    
      echo '                <TD class="plfield">'.$myrow2[3].'</TD>';
      echo '                <TD class="plfield">'.$myrow2[4].'</TD>';
      echo '                <TD class="plfield">'.$myrow2[5].'</TD>';
      echo '                <TD class="plfield">'.$myrow2[7].'</TD>';
      echo '                <TD class="plfield">'.$myrow2[9].'</TD>';
      echo '                <TD class="plfield">'.$myrow2[8].'</TD></TR>';
      echo '         </TABLE></TR></TR>';
      echo '  <TR>';
      echo '      <TD>';
      echo '         <TABLE BORDER=1 CELLPADDING=4>';
      echo '           <TR><TD CLASS="layer4title" ALIGN=CENTER ROWSPAN='.(($num_opt != 0) ? ($num_opt+1) : 1).'>Options</TD>';

      if ( $num_opt != 0)
      {
         echo '            <TD></TD>
                           <TD class="plfieldhdr">code</TD>
                           <TD class="plfieldhdr">length</TD>
                           <TD class="plfieldhdr">data</TD>';

         for ( $i = 0; $i < $num_opt; $i++)
         {
             $myrow3 = $result3->acidFetchRow();
             echo '    <TR><TD class="plfield">#'.($i+1).'</TD>';
             echo '        <TD class="plfield">'.TCPOption2str($myrow3[4]).'</TD>';
             echo '        <TD class="plfield">'.$myrow3[5].'</TD>';
             echo '        <TD class="plfield">'.$myrow3[6].'</TD></TR>';             
         }
      }
      else
      {
         echo '             <TD class="plfield"> &nbsp&nbsp&nbsp <I>none </I></TD></TR>';
      }
      echo '         </TABLE></TD></TR>';                       

      echo '</TABLE>';

      $result2->acidFreeRows();
      $result3->acidFreeRows();
  }

  /* UDP */
  if ( $layer4_proto == "17" )
  {

     $sql2 = "SELECT * FROM udphdr  WHERE sid='".$sid."' AND cid='".$cid."'";
     $result2 = $db->acidExecute($sql2);
     $myrow2 = $result2->acidFetchRow();

     echo '
           <TABLE BORDER=1>
              <TR><TD CLASS="layer4title" WIDTH=50 ROWSPAN=2 ALIGN=CENTER>UDP</TD>';
     echo '      <TD>';
     echo '         <TABLE BORDER=1 CELLPADDING=2>';
     echo '            <TR><TD class="plfieldhdr">source port</TD>
                            <TD class="plfieldhdr">dest port</TD>
                            <TD class="plfieldhdr">length</TD></TR>';

    $src_port = "http://www.snort.org/Database/portsearch.asp?number=".$myrow2[2];
    $dst_port = "http://www.snort.org/Database/portsearch.asp?number=".$myrow2[3]; 

     echo '            <TR><TD class="plfield"><A HREF="'.$src_port.'" TARGET="_ACID_PORT_">'.$myrow2[2].'</A></TD>';
     echo '                <TD class="plfield"><A HREF="'.$dst_port.'" TARGET="_ACID_PORT_">'.$myrow2[3].'</A></TD>';
     echo '                <TD class="plfield">'.$myrow2[4].'</TD></TR>';
     echo '         </TABLE></TD></TR>';
     echo '</TABLE>';

     $result2->acidFreeRows();
  }

  /* ICMP */
  if ( $layer4_proto == "1" )
  {
     $sql2 = "SELECT icmp_type, icmp_code, icmp_csum, icmp_id, icmp_seq FROM icmphdr ".
             "WHERE sid='".$sid."' AND cid='".$cid."'";
     $result2 = $db->acidExecute($sql2);
     $myrow2 = $result2->acidFetchRow();

     echo '
           <TABLE BORDER=1>
              <TR><TD class="layer4title" WIDTH=50 ROWSPAN=2 ALIGN=CENTER>ICMP';
     echo '      <TD>';
     echo '         <TABLE BORDER=1 CELLPADDING=2>';
     echo '            <TR><TD class="plfieldhdr">type</TD>
                           <TD class="plfieldhdr">code</TD>
                           <TD class="plfieldhdr">checksum</TD>
                           <TD class="plfieldhdr">id</TD>
                           <TD class="plfieldhdr">seq #</TR>';
     echo '            <TR><TD class="plfield">'.ICMPType2str($myrow2[0]).'</TD>';
     echo '                <TD class="plfield">'.ICMPCode2str($myrow2[0],$myrow2[1]).'</TD>';
     echo '                <TD class="plfield">'.$myrow2[2].'</TD>';
     echo '                <TD class="plfield">'.$myrow2[3].'</TD>';
     echo '                <TD class="plfield">'.$myrow2[4].'</TD></TR>';
     echo '         </TABLE>';
     echo '</TABLE>';

     $result2->acidFreeRows();
  }

  /* Print the Payload */
  $sql2 = "SELECT data_payload FROM data WHERE sid='".$sid."' AND cid='".$cid."'";
  $result2 = $db->acidExecute($sql2);

  /* get encoding information and detail_level on the payload */
  $sql3 = 'SELECT encoding, detail FROM sensor WHERE sid='.$sid;
  $result3 = $db->acidExecute($sql3);
  $myrow3 = $result3->acidFetchRow();  
  
  echo '
        <TABLE BORDER=1>
           <TR><TD class="payloadtitle" WIDTH=50 ROWSPAN=2 ALIGN=CENTER>Payload';
  echo '       <TD>';

  $myrow2 = $result2->acidFetchRow();
  if ( $myrow2 )
  {
     /* print the packet based on encoding type */
     PrintPacketPayload($myrow2[0], $myrow3[0], 1);

     $result3->acidFreeRows();     
  }
  else
  {
     /* Don't have payload so lets print out why by checking the detail level */

     /* if have fast detail level */
     if ( $myrow[1] == "0" )
        echo '<BR> &nbsp <I>Fast logging used so payload was discarded </I><BR>';
     else
        echo '<BR> &nbsp <I>none </I><BR>';
  }
  echo '</TABLE><P>';

  $result2->acidFreeRows();

  echo "<CENTER>$previous &nbsp&nbsp&nbsp $next</CENTER>";

  PrintQueryResultAction($action, $action_arg, 1);  
}

function ExportPacket($sid, $cid, $db)
{
  GLOBAL $action, $action_arg;

  /* Event */
  $sql2 = "SELECT signature, timestamp FROM event WHERE sid='".$sid."' AND cid='".$cid."'";
  $result2 = $db->acidExecute($sql2);
  $myrow2 = $result2->acidFetchRow();

  $s = "------------------------------------------------------------------------------\n";
  $s = $s."#($sid - $cid) [$myrow2[1]] ".BuildSigByID($myrow2[0], $db, 2)."\r\n";

  $sql4 = "SELECT hostname, interface, filter FROM sensor  WHERE sid='".$sid."'";
  $result4 = $db->acidExecute($sql4);
  $myrow4 = $result4->acidFetchRow();

  /*
  $s = $s."Sensor: $myrow4[0]:$myrow4[1]";
  if ( $myrow4[2] != "")  $s = $s.$myrow4[2];
  $s = $s." \r\n";
  */

  $result4->acidFreeRows();
  $result2->acidFreeRows();

  /* IP */
  $sql2 = "SELECT ip_src, ip_dst, ".
          "ip_ver, ip_hlen, ip_tos, ip_len, ip_id, ip_flags, ip_off, ip_ttl, ip_csum, ip_proto". 
          " FROM iphdr  WHERE sid='".$sid."' AND cid='".$cid."'";

  $result2 = $db->acidExecute($sql2);
  $myrow2 = $result2->acidFetchRow();
  $layer4_proto = $myrow2[11];

  if ( $myrow2[0] != "" )
  {
    $sql3 = "SELECT * FROM opt  WHERE sid='".$sid."' AND cid='".$cid."' AND opt_proto='0'";
    $result3 = $db->acidExecute($sql3);
    $num_opt = $result3->acidRecordCount();

    $s = $s."IPv$myrow2[2]: ".
          acidLong2IP($myrow2[0])." -> ".
          acidLong2IP($myrow2[1])."\n".
          "      hlen=$myrow2[3] TOS=$myrow2[4] dlen=$myrow2[5] ID=$myrow2[6]".
          " flags=$myrow2[7] offset=$myrow2[8] TTL=$myrow2[9] chksum=$myrow2[10]\n";

    if ( $num_opt > 0 )
    {
      $s = $s."    Options\n";
      for ( $i = 0; $i < $num_opt; $i++)
      {
         $myrow3 = $result3->acidFetchRow();
         $s = $s."      #".($i+1)." - ".IPOption2str($myrow3[4])." len=$myrow3[5]";
         if ( $myrow3[5] != 0 )
            $s = $s." data=$myrow3[6]";
         $s = $s."\n";  
       }
    }
                       
    $result3->acidFreeRows();
  }
  $result2->acidFreeRows();

  /* TCP */
  if ( $layer4_proto == "6" )  
  {
     $sql2 = "SELECT tcp_sport, tcp_dport, tcp_seq, tcp_ack, tcp_off, tcp_res, tcp_flags, tcp_win, ".
             "       tcp_csum, tcp_urp FROM tcphdr  WHERE sid='".$sid."' AND cid='".$cid."'";
     $result2 = $db->acidExecute($sql2);
     $myrow2 = $result2->acidFetchRow();

     $sql3 = "SELECT * FROM opt  WHERE sid='".$sid."' AND cid='".$cid."' AND opt_proto='6'";
     $result3 = $db->acidExecute($sql3);
     $num_opt = $result3->acidRecordCount();

     $s = $s."TCP:  port=$myrow2[0] -> dport: $myrow2[1]  flags=";

      if ( ($myrow2[6] & 128) != 0 )  $s = $s.'2';  else $s = $s.'*';
      if ( ($myrow2[6] & 64 ) != 0 )  $s = $s.'1';  else $s = $s.'*';
      if ( ($myrow2[6] & 32) != 0  )  $s = $s.'U';  else $s = $s.'*';
      if ( ($myrow2[6] & 16 ) != 0 )  $s = $s.'A';  else $s = $s.'*';
      if ( ($myrow2[6] & 8) != 0   )  $s = $s.'P';  else $s = $s.'*';
      if ( ($myrow2[6] & 4 ) != 0  )  $s = $s.'R';  else $s = $s.'*';
      if ( ($myrow2[6] & 2 ) != 0  )  $s = $s.'S';  else $s = $s.'*';
      if ( ($myrow2[6] & 1 ) != 0  )  $s = $s.'F';  else $s = $s.'*';

      $s = $s." seq=$myrow2[2]\n".
              "      ack=$myrow2[3] off=$myrow2[4] res=$myrow2[5] win=$myrow2[7] urp=$myrow2[9] ".
              "chksum=$myrow2[8]\n";

      if ( $num_opt != 0)
      {
         $s = $s."      Options:\n";
         for ( $i = 0; $i < $num_opt; $i++)
         {
             $myrow3 = $result3->acidFetchRow();
             $s = $s."       #".($i+1)." - ".TCPOption2str($myrow3[4])." len=$myrow3[5]";
             if ( $myrow3[5] != 0 )
                $s = $s." data=".$myrow3[6];
            $s = $s."\n";           
         }
      }

      $result2->acidFreeRows();
      $result3->acidFreeRows();
  }

  /* UDP */
  if ( $layer4_proto == "17" )
  {

     $sql2 = "SELECT * FROM udphdr  WHERE sid='".$sid."' AND cid='".$cid."'";
     $result2 = $db->acidExecute($sql2);
     $myrow2 = $result2->acidFetchRow();

     $s = $s."UDP:  port=$myrow2[2] -> dport: $myrow2[3] len=$myrow2[4]\n";

     $result2->acidFreeRows();
  }

  /* ICMP */
  if ( $layer4_proto == "1" )
  {
     $sql2 = "SELECT icmp_type, icmp_code, icmp_csum, icmp_id, icmp_seq FROM icmphdr ".
             "WHERE sid='".$sid."' AND cid='".$cid."'";
     $result2 = $db->acidExecute($sql2);
     $myrow2 = $result2->acidFetchRow();

     $s = $s."ICMP: type=".ICMPType2str($myrow2[0])." code=".ICMPCode2str($myrow2[0],$myrow2[1])."\n".
             "      checksum=$myrow2[2] id=$myrow2[3] seq=$myrow2[4]\n";

     $result2->acidFreeRows();
  }

  /* Print the Payload */
  $sql2 = "SELECT data_payload FROM data WHERE sid='".$sid."' AND cid='".$cid."'";
  $result2 = $db->acidExecute($sql2);

  /* get encoding information and detail_level on the payload */
  $sql3 = 'SELECT encoding, detail FROM sensor WHERE sid='.$sid;
  $result3 = $db->acidExecute($sql3);
  $myrow3 = $result3->acidFetchRow();  
  
  $s = $s."Payload: ";

  $myrow2 = $result2->acidFetchRow();
  if ( $myrow2 )
  {
     /* print the packet based on encoding type */
     $s = $s.PrintPacketPayload($myrow2[0], $myrow3[0], 2)."\n";

     $result3->acidFreeRows();     
  }
  else
  {
     /* Don't have payload so lets print out why by checking the detail level */

     /* if have fast detail level */
     if ( $myrow3[1] == "0" )
        $s = $s."Fast logging used so payload was discarded\n";
     else
        $s = $s."none\n";
  }

  $result2->acidFreeRows();
 
  return $s; 
}

function ExportPacket_summary($sid, $cid, $db)
{
  GLOBAL $action, $action_arg;

  /* Event */
  $sql2 = "SELECT signature, timestamp FROM event WHERE sid='".$sid."' AND cid='".$cid."'";
  $result2 = $db->acidExecute($sql2);
  $myrow2 = $result2->acidFetchRow();

  $alert_timestamp = $myrow2[1];
  $alert_sig = BuildSigByID($myrow2[0], $db, 2);

  $result2->acidFreeRows();

  /* IP */
  $sql2 = "SELECT ip_src, ip_dst, ip_proto". 
          " FROM iphdr  WHERE sid='".$sid."' AND cid='".$cid."'";

  $result2 = $db->acidExecute($sql2);
  $myrow2 = $result2->acidFetchRow();

  $layer4_proto = "";
  if ( $myrow2[0] != "" )
  {
     $src_ip = acidLong2IP($myrow2[0]);
     $dst_ip = acidLong2IP($myrow2[1]);
     $layer4_proto = $myrow2[2];
  }
  $result2->acidFreeRows();

  /* TCP */
  if ( $layer4_proto == "6" )  
  {
     $sql2 = "SELECT tcp_sport, tcp_dport FROM tcphdr  WHERE sid='".$sid."' AND cid='".$cid."'";
     $result2 = $db->acidExecute($sql2);
     $myrow2 = $result2->acidFetchRow();

     $src_port = ":".$myrow2[0]." -> ";
     $dst_port = ":".$myrow2[1];
     
     $result2->acidFreeRows();
  }

  /* UDP */
  if ( $layer4_proto == "17" )
  {

     $sql2 = "SELECT * FROM udphdr  WHERE sid='".$sid."' AND cid='".$cid."'";
     $result2 = $db->acidExecute($sql2);
     $myrow2 = $result2->acidFetchRow();

     $src_port = ":".$myrow2[2]." -> ";
     $dst_port = ":".$myrow2[3];

     $result2->acidFreeRows();
  }

  /* ICMP */
  if ( $layer4_proto == "1" )
  {
     $src_ip = $src_ip." -> ";
     $src_port = $dst_port = "";
  }

  $s = sprintf("#%d-%d| [%s] %s%s%s%s %s\r\n",
               $sid, $cid, $alert_timestamp, 
               $src_ip, $src_port, $dst_ip, $dst_port,
               $alert_sig); 

  return $s; 
}

function PrintFreshPage($refresh_stat_page, $stat_page_refresh_time)
{
   if ( $refresh_stat_page )
      echo '<META HTTP-EQUIV="REFRESH" CONTENT="'.$stat_page_refresh_time.';">';
}
?>
