#
# Template for Sofia SIP UA RPM spec file
#
# Options:
# --with doxygen   - Generate documents using doxygen and dot
# --with check     - Run tests
# --with openssl   - Always use OpenSSL (TLS)
# --with glib      - Always use glib-2.0 (>= 2.2)
# --with gobject   - Always use gobject (>= 2.4)
# --with sctp      - with SCTP
#

Summary: Sofia SIP User-Agent library 
Name: sofia-sip
Version: 1.12.4
Release: 1%{?dist}
License: Lesser GNU Public License 2.1
Group: System Environment/Libraries
URL: http://sf.net/projects/sofia-sip
Source0: %{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
Packager: Pekka.Pessi@Nokia.com

%define have_doxygen %{?_with_doxygen:1}%{?!_with_doxygen:0}
%define have_openssl %(%{?!_with_openssl:pkg-config 'openssl >= 0.9.7'&&}echo 1||echo 0)
%define have_glib %(%{?!_with_glib:pkg-config 'glib-2.0 >= 2.2'&&}echo 1||echo 0)
%define have_gobject %(%{?!_with_gobject:pkg-config 'gobject >= 2.4'&&}echo 1||echo 0)

%if %{have_doxygen}
BuildRequires: doxygen >= 1.3
%endif
%if %{have_openssl}
BuildRequires: openssl-devel >= 0.9.7
%endif
%if %{have_gobject}
BuildRequires: glib2-devel >= 2.4
%endif
%if %{have_glib}
BuildRequires: glib2-devel >= 2.2
%endif

%description
Sofia SIP is a RFC-3261-compliant library for SIP user agents and other
network elements.

%prep
%setup -q -n sofia-sip-%{version}

%build
options="--with-aclocal=aclocal --disable-dependency-tracking"
options="$options --with-pic --enable-shared"
%if !%{have_glib}
options="$options --without-glib"
%endif
%{?_with_sctp:options="$options --enable-sctp"}
%configure $options CFLAGS="-Os -DNDEBUG -g"

make %{_smp_mflags}
%{?_with_check:make check}
%if %{have_doxygen}
make doxygen
%endif

%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT
%if %{have_doxygen}
cp -p -r libsofia-sip-ua/docs/html manual
%endif

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,-)
%{_prefix}/%{_lib}/libsofia-sip-ua.so.*
%doc AUTHORS COPYING COPYRIGHTS README

# note: soname in pkgname allows install of multiple library versions
%package	glib0
Summary:        GLIB bindings for Sofia-SIP 
Group: System Environment/Libraries
Requires:       sofia-sip
Provides:       sofia-sip-glib = %{version}-%{release}
Obsoletes:	sofia-sip-glib

%description	glib0
GLib interface to Sofia SIP User Agent library.

%if %{have_glib}

%files 		glib0
%defattr(-,root,root,-)
%{_prefix}/%{_lib}/libsofia-sip-ua-glib.so.*

%endif

%package	devel
Summary:        Sofia-SIP Development Package
Group:     	Development/Libraries
Requires:	sofia-sip = %{version}-%{release}
Obsoletes:	sofia-devel
%description	devel
Development package for Sofia SIP UA library. This package includes 
static libraries and include files.

%files 		devel
%defattr(-,root,root,-)
%{_prefix}/include/sofia-sip*/sofia-sip/*.h
%{_prefix}/include/sofia-sip*/sofia-resolv/*.h
%{_prefix}/include/sofia-sip*/sofia-sip/*.h.in
%{_prefix}/share/sofia-sip/tag_dll.awk
%{_prefix}/share/sofia-sip/msg_parser.awk
%{_prefix}/%{_lib}/libsofia-sip-ua.la
%{_prefix}/%{_lib}/libsofia-sip-ua.a
%{_prefix}/%{_lib}/libsofia-sip-ua.so
%{_prefix}/%{_lib}/pkgconfig/sofia-sip-ua.pc
%doc TODO README.developers

# note: no soname here as files installed to the same place
%package	glib-devel
Summary:        GLIB bindings for Sofia SIP development files
Group: 		Development/Libraries
Requires:       sofia-sip-glib0 = %{version}-%{release}
Requires:	sofia-sip-devel >= 1.12

%description	glib-devel
Development package for Sofia SIP UA Glib library. This package includes
pstatic libraries and include files for developing glib programs using Sofia
SIP.
%if !%{have_gobject}
Note that this version does not support gobject interface.
%endif

%if %{have_glib}
%files 		glib-devel
%defattr(-,root,root,-)
%if %{have_gobject}
%{_prefix}/include/sofia-sip*/sofia-sip/nua_glib.h
%endif
%{_prefix}/include/sofia-sip*/sofia-sip/su_source.h
%{_prefix}/%{_lib}/libsofia-sip-ua-glib.la
%{_prefix}/%{_lib}/libsofia-sip-ua-glib.a
%{_prefix}/%{_lib}/libsofia-sip-ua-glib.so
%{_prefix}/%{_lib}/pkgconfig/sofia-sip-ua-glib.pc
%endif

%package	docs
Summary:        Sofia-SIP Development Manual Package
Group:     	Development/Libraries
%description	docs
HTML reference documentation for Sofia SIP UA library.

%if %{have_doxygen}
%files docs
%defattr(-,root,root,-)
%doc manual
%endif

%package	utils
Summary:        Sofia-SIP Command Line Utilities
Group:     	Development/Libraries
Requires:	sofia-sip = %{version}-%{release}
Obsoletes:	sofia-utils
%description	utils
Command line utilities for Sofia SIP UA library.

%files utils
%defattr(-,root,root,-)
%{_prefix}/bin/localinfo
%{_prefix}/bin/addrinfo
%{_prefix}/bin/sip-options
%{_prefix}/bin/sip-date
%{_prefix}/bin/sip-dig
%{_prefix}/bin/stunc
%{_mandir}/man?/*

%changelog
* Fri Oct  6 2006 Pekka Pessi
- Autodetecting openssl, glib and gobject support with pkg-config
  (use --with openssl --with glib and --with gobject to force them)

* Mon Sep 18 2006 Kai Vehmanen <kai.vehmanen@nokia.com>
- Removed *.m4 files from the distribution package.

* Fri Aug 11 2006 Kai Vehmanen <kai.vehmanen@nokia.com>
- Modified the install location of the awk scripts.

* Thu Jun 15 2006 Kai Vehmanen <kai.vehmanen@nokia.com>
- Added library soname to sofia-sip-glib package name.
- Modified dependencies - the glib subpackages do not depend
  on a specific version of sofia-sip anymore.

* Wed Mar 08 2006 Kai Vehmanen <kai.vehmanen@nokia.com>
- Added libsofia-sip-ua-glib to the package.

* Tue Nov 15 2005 Kai Vehmanen <kai.vehmanen@nokia.com>
- Removed the --includedir parameter. The public headers are
  now installed under includedir/sofia-sip-MAJOR.MINOR/

* Thu Oct 20 2005 Pekka Pessi <Pekka.Pessi@nokia.com>
- Using %{_lib} instead of lib

* Thu Oct  6 2005 Pekka Pessi <Pekka.Pessi@iki.fi>
- Added sub-package utils

* Thu Oct  6 2005 Pekka Pessi <Pekka.Pessi@nokia.com> - 1.11.0
- Added %%{?dist} to release

* Sat Jul 23 2005 Pekka Pessi <Pekka.Pessi@nokia.com> - 1.10.1
- Initial build.
