/*
 * ----------------------------------------------------
 *
 * Byteorder Conversion Macros
 *
 * (C) 2004  Lightmaze Solutions AG
 *   Author: Jochen Karrer
 *
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * ----------------------------------------------------
 */

#ifndef BYTEORDER_H
#define BYTEORDER_H
#include <byteswap.h>

#define swap64(x)		__bswap_64(x)
#define swap32(x)		__bswap_32(x)
#define swap16(x)		__bswap_16(x)

enum en_endianness {
	en_LITTLE_ENDIAN = 0,
	en_BIG_ENDIAN = 1,
};

#if __BYTE_ORDER == __BIG_ENDIAN 
#define HOST_BYTEORDER en_BIG_ENDIAN

#define host32_to_be(x)		(x)	
#define be32_to_host(x)		(x)

#define host32_to_le(x)		__bswap_32(x)	
#define le32_to_host(x)		__bswap_32(x)

/*
 * ------------------------------------------
 * Big Endian Host with big Endian Target
 * ------------------------------------------
 */
#if TARGET_BIG_ENDIAN
#define TARGET_BYTEORDER en_BIG_ENDIAN
#define NON_TARGET_BYTEORDER en_LITTLE_ENDIAN
#define	target64_to_host(x) 	(x)
#define	target64_to_le(x)   	__bswap_64(x)
#define	le64_to_target(x)   	__bswap_64(x)
#define host64_to_target(x)	(x)	

#define	target32_to_host(x) 	(x)
#define	target32_to_le(x)   	__bswap_32(x)
#define	le32_to_target(x)   	__bswap_32(x)
#define host32_to_target(x)	(x)	

#define	target16_to_host(x) 	(x)
#define	target16_to_le(x)   	__bswap_16(x)
#define	le16_to_target(x)   	__bswap_16(x)
#define host16_to_target(x)	(x)	

/*
 * ----------------------------------------------
 * Big Endian Host with little Endian Target
 * ----------------------------------------------
 */
#else
#define TARGET_BYTEORDER en_LITTLE_ENDIAN
#define NON_TARGET_BYTEORDER en_BIG_ENDIAN
#define		target64_to_host(x) __bswap_64(x)
#define		host64_to_target(x) __bswap_64(x)

#define 	target32_to_host(x) __bswap_32(x)
#define 	target32_to_le(x)   (x)
#define		le32_to_target(x)   (x)
#define		host32_to_target(x) __bswap_32(x)

#define 	target16_to_host(x) __bswap_16(x)
#define 	target16_to_le(x)   (x)
#define		le16_to_target(x)   (x)
#define		host16_to_target(x) __bswap_16(x)


#endif /* TARGET_BIG_ENDIAN */

#else 
#define HOST_BYTEORDER en_LITTLE_ENDIAN
/*
 * ----------------------------------
 * Little Endian Host
 * ----------------------------------
 */

#define host32_to_le(x)		(x)	
#define le32_to_host(x)		(x)

#define host32_to_be(x)		__bswap_32(x)	
#define be32_to_host(x)		__bswap_32(x)

/*
 * ------------------------------------------
 * Little Endian Host with big Endian Target
 * ------------------------------------------
 */
#if TARGET_BIG_ENDIAN
#define TARGET_BYTEORDER en_BIG_ENDIAN
#define NON_TARGET_BYTEORDER en_LITTLE_ENDIAN
#define	target64_to_host(x) 	__bswap_64(x)
#define	target64_to_le(x)   	__bswap_64(x)
#define	le64_to_target(x)   	__bswap_64(x)
#define host64_to_target(x)	__bswap_64(x)	

#define	target32_to_host(x) 	__bswap_32(x)
#define	target32_to_le(x)   	__bswap_32(x)
#define	le32_to_target(x)   	__bswap_32(x)
#define host32_to_target(x)	__bswap_32(x)	

#define	target16_to_host(x) 	__bswap_16(x)
#define	target16_to_le(x)   	__bswap_16(x)
#define	le16_to_target(x)   	__bswap_16(x)
#define host16_to_target(x)	__bswap_16(x)	

/*
 * ----------------------------------------------
 * Little Endian Host with little Endian Target
 * ----------------------------------------------
 */
#else
#define TARGET_BYTEORDER en_LITTLE_ENDIAN
#define NON_TARGET_BYTEORDER en_BIG_ENDIAN
#define		target64_to_host(x) (x)
#define		host64_to_target(x) (x)

#define 	target32_to_host(x) (x)
#define 	target32_to_le(x)   (x)
#define 	host32_to_le(x)     (x)
#define		host32_to_target(x) (x)

#define 	target16_to_host(x) (x)
#define 	target16_to_le(x)   (x)
#define		host16_to_target(x) (x)
#define		le16_to_target(x)   (x)


#define		le32_to_target(x)   (x)
#define 	le32_to_host(x)     (x)
#endif

#endif
#endif /* BYTEORDER_H */
