#ifndef CAN_SOCKET_H
#define CAN_SOCKET_H

#include <stdint.h>
#include <fio.h>

/*****************************************************************/
/*   CAN message types                                           */
/*****************************************************************/
#define CAN_MSG_T_11        (1)
#define CAN_MSG_T_11_RTR    (2)
#define CAN_MSG_T_29        (3)
#define CAN_MSG_T_29_RTR    (4)
#define CAN_MSG_T_ASCII   (0x3a)


/* The TCP-to-CAN Gateway uses this message because SO_KEEPALIVE  */
/* timeout is 2 hours. Should be swallowed by the forwarder,      */
/* driver ignores it.                                             */
#define CAN_MSG_T_KEEPALIVE (0xff)
#define CAN_MSG_T_ERROR     (0xfe)


/*****************************************************************/
/*   Data structure for a CAN message                            */
/*****************************************************************/

typedef struct CAN_MSG
{
   uint8_t  typ;
   uint8_t  len;            /* Data length (0-8)  */
   uint16_t pad;               /* avoid padding by compiler */
   uint32_t id;                /* Message Identifier Network Byteorder !  */ 
   uint8_t  data[8];           /* Data buffer */
} CAN_MSG;

typedef struct CanChipOperations {
	void (*receive) (void *clientData,CAN_MSG *msg);
} CanChipOperations;

struct CanController;

typedef struct Connection {
        int sockfd;
        FIO_FileHandler rfh;    // read event file Handler
	int rfh_is_active;
        FIO_FileHandler wfh;    // write event file Handler
        int wfh_is_active;
        struct CanController *canController;
        struct Connection *next;
        CAN_MSG imsg;
        int ibuf_wp;
} Connection;

typedef struct CanController {
        CanChipOperations *cops;
        void *clientData;
        int listen_fd;
        FIO_TcpServer tserv;
        struct Connection *con_list;
} CanController;

/*
 * Exported Functions for the Chip emulator
 */
CanController * CanSocketInterface_New(CanChipOperations *cops,const char *name,void *clientData);
void CanSend(CanController *contr,CAN_MSG *msg);
void CanStopRx(CanController *contr);
void CanStartRx(CanController *contr);
#endif

