/*
 * -------------------------------------------------------------
 * MainLoopSignals
 *	Signal events to the (CPU-) mainloop 
 *	using global variables
 *
 * (C) 2005  Lightmaze Solutions AG
 *   Author: Jochen Karrer
 *
 * Status:
 *	Used by ARM9 CPU and MMU and by Infineon C161 emulation
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * -------------------------------------------------------------
 */

#include <stdint.h>
#include "mainloop_events.h"

/*
 * ----------------------------------------------------
 * mainloop_job_pending
 *	Set this whenever you want that the mainloop  
 *	checks for events. Can be set from
 *	other than main-thread. May only be cleared
 *	from the thread which handles the events.
 *	Every CPU implementation is required to check
 *	this variable regularly.
 *
 *	Normaly this variable will be set after 
 *	mainloop_job_io is set or after an unmasked 
 *      interrupt is signaled to the cpu.
 * ----------------------------------------------------
 */
uint32_t mainloop_event_pending=0;

/*
 * ---------------------------------------------------
 * mainloop_job_io
 *	Set this whenever you want the mainloop
 *	to process some IO.
 * ---------------------------------------------------
 */
uint32_t mainloop_event_io=0;
