#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <arm9cpu.h>
#include <thumb_instructions.h>

void th_adc() {
  fprintf(stderr,"Thumb adc not implemented\n");
}

void th_add_1() {
  fprintf(stderr,"Thumb add_1 not implemented\n");
}

void th_add_2() {
  fprintf(stderr,"Thumb add_2 not implemented\n");
}

void th_add_3() {
  fprintf(stderr,"Thumb add_3 not implemented\n");
}

void th_add_4() {
  fprintf(stderr,"Thumb add_4 not implemented\n");
}

void th_add_5() {
  fprintf(stderr,"Thumb add_5 not implemented\n");
}

void th_add_6() {
  fprintf(stderr,"Thumb add_6 not implemented\n");
}

void th_add_7() {
  fprintf(stderr,"Thumb add_7 not implemented\n");
}

void th_and() {
  fprintf(stderr,"Thumb and not implemented\n");
}

void th_asr_1() {
  fprintf(stderr,"Thumb asr_1 not implemented\n");
}

void th_asr_2() {
  fprintf(stderr,"Thumb asr_2 not implemented\n");
}

void th_b_1() {
  fprintf(stderr,"Thumb b_1 not implemented\n");
}

void th_b_2() {
  fprintf(stderr,"Thumb b_2 not implemented\n");
}

void th_bic() {
  fprintf(stderr,"Thumb bic not implemented\n");
}

void th_bkpt() {
  fprintf(stderr,"Thumb bkpt not implemented\n");
}

void th_bl_blx() {
	uint32_t icode = ICODE;
	int h = (icode >> 11) & 3;
	int32_t offset;
	uint32_t lr;
	switch(h) {
		case 2:
			if(icode & (1<< 10)) {
				offset = (icode & 0x7ff) | ~0x7ff;	
			} else {
				offset = (icode & 0x7ff);
			}
  			REG_LR = GET_REG_PC_THUMB + (offset << 12);
			break;

		case 3:
			lr = REG_LR;
			offset = (icode & 0x7ff);
			REG_LR = (GET_REG_PC_THUMB - 2) | 1;
			SET_REG_PC(lr + (offset << 1)); 
			break;

		case 1:
			lr = REG_LR;
			offset = (icode & 0x7ff);
			REG_LR = (GET_REG_PC_THUMB - 2) | 1;
			SET_REG_PC((lr + (offset << 1)) & 0xfffffffc); 
			REG_CPSR &= ~FLAG_T;
			ARM_RestartLoop();
			break;
	}
  	fprintf(stderr,"Thumb bl_blx\n");
}

void th_blx_2() {
  int rm;
  uint32_t Rm;
  uint32_t icode = ICODE;
  rm = (icode >> 3) & 0xf;
  Rm = Thumb_ReadReg(rm);
  REG_LR=GET_REG_PC_THUMB-2; 
  SET_REG_PC(Rm & ~1);
  if(!(Rm & 1)) {
	/* Leave Thumb mode */
	REG_CPSR &= ~FLAG_T;
	ARM_RestartLoop();
  }
  fprintf(stderr,"Thumb blx_2\n");
}

void th_bx() {
  int rm;
  uint32_t Rm;
  uint32_t icode = ICODE;
  rm = (icode >> 3) & 0xf;
  Rm=Thumb_ReadReg(rm);
  SET_REG_PC(Rm & ~1);
  if(!(Rm & 1)) {
	/* Leave Thumb mode */
	REG_CPSR &= ~FLAG_T;
	ARM_RestartLoop();
  }
  fprintf(stderr,"Thumb bx\n");
}

void th_cmn() {
  fprintf(stderr,"Thumb cmn not implemented\n");
}

void th_cmp_1() {
  fprintf(stderr,"Thumb cmp_1 not implemented\n");
}

void th_cmp_2() {
  fprintf(stderr,"Thumb cmp_2 not implemented\n");
}

void th_cmp_3() {
  fprintf(stderr,"Thumb cmp_3 not implemented\n");
}

void th_eor() {
  fprintf(stderr,"Thumb eor not implemented\n");
}

void th_ldmia() {
  fprintf(stderr,"Thumb ldmia not implemented\n");
}

void th_ldr_1() {
  fprintf(stderr,"Thumb ldr_1 not implemented\n");
}

void th_ldr_2() {
  fprintf(stderr,"Thumb ldr_2 not implemented\n");
}

void th_ldr_3() {
  fprintf(stderr,"Thumb ldr_3 not implemented\n");
}

void th_ldr_4() {
  fprintf(stderr,"Thumb ldr_4 not implemented\n");
}

void th_ldrb_1() {
  fprintf(stderr,"Thumb ldrb_1 not implemented\n");
}

void th_ldrb_2() {
  fprintf(stderr,"Thumb ldrb_2 not implemented\n");
}

void th_ldrh_1() {
  fprintf(stderr,"Thumb ldrh_1 not implemented\n");
}

void th_ldrh_2() {
  fprintf(stderr,"Thumb ldrh_2 not implemented\n");
}

void th_ldrsb() {
  fprintf(stderr,"Thumb ldrsb not implemented\n");
}

void th_ldrsh() {
  fprintf(stderr,"Thumb ldrsh not implemented\n");
}

void th_lsl_1() {
  fprintf(stderr,"Thumb lsl_1 not implemented\n");
}

void th_lsl_2() {
  fprintf(stderr,"Thumb lsl_2 not implemented\n");
}

void th_lsr_1() {
  fprintf(stderr,"Thumb lsr_1 not implemented\n");
}

void th_lsr_2() {
  fprintf(stderr,"Thumb lsr_2 not implemented\n");
}

void th_mov_1() {
  fprintf(stderr,"Thumb mov_1 not implemented\n");
}

void th_mov_2() {
  fprintf(stderr,"Thumb mov_2 not implemented\n");
}

void th_mov_3() {
  fprintf(stderr,"Thumb mov_3 not implemented\n");
}

void th_mul() {
  fprintf(stderr,"Thumb mul not implemented\n");
}

void th_mvn() {
  fprintf(stderr,"Thumb mvn not implemented\n");
}

void th_neg() {
  fprintf(stderr,"Thumb neg not implemented\n");
}

void th_orr() {
  fprintf(stderr,"Thumb orr not implemented\n");
}

void th_pop() {
  fprintf(stderr,"Thumb pop not implemented\n");
}

void th_push() {
  fprintf(stderr,"Thumb push not implemented\n");
}

void th_ror() {
  fprintf(stderr,"Thumb ror not implemented\n");
}

void th_sbc() {
  fprintf(stderr,"Thumb sbc not implemented\n");
}

void th_stmia() {
  fprintf(stderr,"Thumb stmia not implemented\n");
}

void th_str_1() {
  fprintf(stderr,"Thumb str_1 not implemented\n");
}

void th_str_2() {
  fprintf(stderr,"Thumb str_2 not implemented\n");
}

void th_str_3() {
  fprintf(stderr,"Thumb str_3 not implemented\n");
}

void th_strb_1() {
  fprintf(stderr,"Thumb strb_1 not implemented\n");
}

void th_strb_2() {
  fprintf(stderr,"Thumb strb_2 not implemented\n");
}

void th_strh_1() {
  fprintf(stderr,"Thumb strh_1 not implemented\n");
}

void th_strh_2() {
  fprintf(stderr,"Thumb strh_2 not implemented\n");
}

void th_sub_1() {
  fprintf(stderr,"Thumb sub_1 not implemented\n");
}

void th_sub_2() {
  fprintf(stderr,"Thumb sub_2 not implemented\n");
}

void th_sub_3() {
  fprintf(stderr,"Thumb sub_3 not implemented\n");
}

void th_sub_4() {
  fprintf(stderr,"Thumb sub_4 not implemented\n");
}

void th_swi() {
  fprintf(stderr,"Thumb swi not implemented\n");
}

void th_tst() {
  fprintf(stderr,"Thumb tst not implemented\n");
}

void th_undefined() {
  fprintf(stderr,"Thumb undefined not implemented\n");
}
