2.1 初めての音

# 初めての音

下記のコードをみてください:

```
play 70
```

ここからすべてが始まります。アプリの上部のコードウィンドウ（実行ボタンの下に大きな空白）にコピーして貼り付けます。そして、左上のRunボタンを押してみましょう。

## ビープ音がなった!

ビックリした？もう一回、押してみましょう。*そしてもう一回..。*

わお！すごい！一日中楽しんで入られそうだけど、でも待って。
ビープ音の無限の流れに夢中になる前に、数値を変えてみましょう。

```
play 75
```

違いが分かりますか？より低い値も試してみましょう。

```
play 60

```

つまり、より低い値は低い音程（ピッチ）の音を、より高い値は高い音程（ピッチ）の音を鳴らします。
ちょうどピアノのように、低い部分の鍵盤（左手側）が低い音階を演奏し、高い部分の鍵盤（右手
側）が高い音階を奏でます。実は、数値は実際にピアノの鍵盤と関係しています。`play 47`は、実はピアノの47番目の鍵盤を演奏することを意味しています。`play 48`は一音上がる（右隣りの鍵盤）ということです。第４オクターブはCの60ということになります。
続いて、`play 60`を鳴らしてみましょう。

もし、これがあたなにとって何の意味かわからなくても*心配しない*でください。
わたしも始めた時は同じでした。いま重要なことは、*低い数値は低い音*を、*高い数値は高い音*を生み出す、ということを知っておくことです。

## 和音

音符を奏でることはとても楽しいですが、同時にたくさんの音符を鳴らすとさらに楽しくなります。
これを試してみましょう。

```
play 72
play 75
play 79
```

華やかです！複数の`play`を書くと、全て同時に演奏されます。自分で試してみましょう.
どの数値がいい組み合わせでしょうか？どれがひどい音？経験、探求しながら、自分自身で
見つけていきましょう。

## メロディー

音符と和音を演奏するのは楽しいですね。でも、メロディーの演奏はどうすればよいでしょうか？
一音ずつ、同時ではなく演奏したい場合は？それは簡単です。音符の間に`sleep`を入れば可能です。

```
play 72
sleep 1
play 75
sleep 1
play 79
```

なんて素敵なアルペジオ（和音を続けて弾くこと）！では、`sleep 1`の`1`は何を意味するのでしょうか？これは一拍休む、という意味ですが、とりあえず今は、一秒休む、と考えま
しょう。では、アルペジオをもう少し早くしたいと思ったら？それは、短い値を使えばよいのです。
例えば半分の値`0.5`ではどうでしょう？

```
play 72
sleep 0.5
play 75
sleep 0.5
play 79
```

早くなりましたね。では、自分で時間を変えてみましょう。違う時間と音符を使ってみましょう。
たとえば`play 52.3`や` play 52.63`のような中間的な値でも演奏してみてください。
通常の全音符で演奏し続ける必要は、まったくありません。遊んで、楽しみましょう。

## 伝統的な音の名前

![Traditional Note Names](:/images/tutorial/keyboard.png)

みなさんの中で、すでにいくつかの音楽記号を知っている人は、たとえば C とか F# などを使って
メロディーを書きたいかも知れません（もしそうでなければ心配無用です、それを楽しむ必要はあり
ません）。Sonic Piはそれをカバーしてくれます。以下のことをやってみましょう。

```
play :C
sleep 0.5
play :D
sleep 0.5
play :E
```

演奏する音階の前にコロン':'を入れることを忘れないでください。コロンを置くと、Cが`:C`のように色が変わります。
また、音名のあとに数値を追加してオクターヴを指定することもできます。

```
play :C3
sleep 0.5
play :D3
sleep 0.5
play :E4
```

半音♯(シャープ)にしたい場合は、’play :Fs3'のように音名の後に's'を追加します。 
半音♭(フラット)にしたい場合は、'play :Eb3'のように'b'を追加します。

*夢中*になって、自分の曲を作って楽しみましょう。
