/*  Sonicmail - POP3 email notifier
 *  Copyright (C) 2000  Cameron Edwards
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* net.c - socket abstraction functions */

#include "net.h"

/* Initiates an active (as opposed to passsive) TCP open: */
int socket_connect(char *ipname, int port)
{
   int connect_sock;
   struct hostent *he;
   struct sockaddr_in their_addr; /* connector's address information */
   
   /* Get the host details from the hostname: */
   if ((he=gethostbyname(ipname)) == NULL) {  /* get the host info */
      return(-1);
   }
   
   /* Create a socket: */ 
   if ((connect_sock = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
      return(-1);
   }
   
   /* Enter conection details: */
   their_addr.sin_family = AF_INET;  /* host byte order */
   their_addr.sin_port = htons(port);/* short, network byte order */
   their_addr.sin_addr = *((struct in_addr *)he->h_addr);
   bzero(&(their_addr.sin_zero), 8); /* zero the rest of the struct */

   /* Connect socket to the host: */
   if (connect(connect_sock, (struct sockaddr *)&their_addr, sizeof(struct sockaddr)) == -1) {
      return(-1);
   }
   
   /* Return the connected socket: */
   return(connect_sock);
}


int socket_send(int connect_sock, void *message, unsigned int length)
{
   int octets;
   
   if ( (octets = send(connect_sock, message, length, 0) ) == -1) {
      perror("send");
      return(-1);
   }
   
   return(octets);
}


int socket_receive(int sock, void *buff, unsigned int length)
{
   int octets;
   
   if( (octets = recv(sock, buff, length, 0)) == -1 ) {
      perror("recv");
      return(-1);
   }
   
   return(octets); 
}


int socket_close(int connect_sock)
{
   return(close(connect_sock));
}


