<?php
/**
 * $Horde: accounts/lib/Driver.php,v 1.9.2.1 2003/01/19 06:53:19 ericr Exp $
 *
 * Copyright 2001-2003 Eric Rostetter <eric.rostetter@physics.utexas.edu>
 *
 * See the enclosed file LICENSE for license information (BSD). If you
 * did not receive this file, see http://www.horde.org/bsdl.php.
 *
 * Accounts_Driver:: defines an API for getting/displaying account information
 * for a user for the accounts module.
 *
 * @author   Eric Rostetter <eric.rostetter@physics.utexas.edu>
 * @version  $Revision: 1.9.2.1 $
 * @since    Accounts 2.1
 * @package  accounts
 */
class Accounts_Driver {

    /** error string returned to user if an eror occurs. */
    var $err_str;

    /**
     * Attempts to return a concrete Accounts_Driver instance based on $driver.
     *
     * @param string    $driver     The type of concrete Accounts_Driver
     *                              subclass to return.  The is based on the
     *                              accounts driver ($driver).  The code is
     *                              dynamically included.
     *
     * @param array     $params     (optional) A hash containing any additional
     *                              configuration or connection parameters a
     *                              subclass might need.
     *
     * @return mixed    The newly created concrete Accounts_Driver instance, or
     *                  false on an error.
     */
    function &factory($driver, $params = array())
    {
        $driver = strtolower(basename($driver));
        include_once dirname(__FILE__) . '/Driver/' . $driver . '.php';
        $class = 'Accounts_Driver_' . $driver;
        if (class_exists($class)) {
            return new $class($params);
        } else {
            return false;
        }
    }

    /**
     * Attempts to return a reference to a concrete Accounts_Driver instance
     * based on $driver.  It will only create a new instance if no
     * Accounts_Driver instance with the same parameters currently exists.
     *
     * This should be used if multiple storage sources are required.
     *
     * This method must be invoked as: $var = &Accounts_Driver::singleton()
     *
     * @param string    $driver     Type of concrete Accounts_Driver subclass
     *                              to return.  The is based on the accounts
     *                              driver ($driver).  The code is dynamically
     *                              included.
     *
     * @param array     $params     (optional) A hash containing any additional
     *                              configuration or connection parameters a
     *                              subclass might need.
     *
     * @return mixed    The created concrete Accounts_Driver instance, or false
     *                  on error.
     */
    function &singleton($driver, $params = array())
    {
        static $instances;

        if (!isset($instances)) {
            $instances = array();
        }

        $signature = serialize(array($driver, $params));
        if (!isset($instances[$signature])) {
            $instances[$signature] = &Accounts_Driver::factory($driver, $params);
        }

        return $instances[$signature];
    }

    /**
     * Get the user's quota if available
     *
     * @param   $username     The user for which to get the quota.
     * @param   $realm        The realm (domain) for the user.
     *
     * @return  mixed         A quota array, elements are used bytes and
     *                        limit bytes on success, false on failure.
     */
    function getQuota($username, $realm)
    {
        return false;
    }

    /**
     * Get the user's fullname.
     *
     * @param   $username     The user for which to get the full name.
     * @param   $realm        The realm (domain) for the user.
     *
     * @return  mixed         The user's full name (string), or false (error).
     */
    function getFullname($username, $realm)
    {
        return false;
    }

    /**
     * Get the user's Home (Login) Directory.
     *
     * @param   $username     The user for which to get the directory.
     * @param   $realm        The realm (domain) for the user.
     *
     * @return  mixed         The user's directory (string), or false (error).
     */
    function getHome($username, $realm)
    {
        return false;
    }

    /**
     * Get the user's default shell.
     *
     * @param   $username     The user for which to get the default shell.
     * @param   $realm        The realm (domain) for the user.
     *
     * @return  mixed         The user's shell (string), or false (error).
     */
    function getShell($username, $realm)
    {
        return false;
    }

}
