

#include <stdio.h>
#include <varargs.h>
#include <errno.h>
#include <alloca.h>
#include <sys/param.h>		/* defines MAXPATHLEN */

#include "sortmail.h"
#include "regex.h"	/* use gnu regex */

	FILE	*logfile ;

static	int
ReCompile(pat)
  char *pat ;
{
  char *err ;
  if( (err = re_comp(pat)) != NULL ) {
    fprintf(logfile, "sortmail: pattern %s: %s\n", pat, err) ;
    return 1 ;
  }
  return 0 ;
}

extern	int	sys_nerr ;
extern	char	*sys_errlist[] ;



	char	*user = NULL ;
	char	*home = NULL ;
	char	*mailbox = NULL ;
	char	*mailrc = NULL ;
	char	*sortmailrc = NULL ;
	char	*mbox = NULL ;
	char	*deflt = NULL ;
	char	*vacation = NULL ;
	char	*folder = NULL ;
	char	*logfilename = NULL ;
	int	verbose = 0 ;

	PatInfo	*patterns = NULL, *lastpat = NULL ;

static	char	tmpfilename[256] ;

static	void	dispose() ;
static	void	append() ;
static	void	put_pipe() ;
static	void	forward() ;

static int
argcheck(str, argv, nargs, argc)
	char	*str, *argv ;
	int	nargs ;
	int	*argc ;
{
	if( strcmp(str, argv) != 0 )
	  return 0 ;
	if( (*argc -= nargs) <= 0 )
	  die("sortmail: %s option requires %d arguments\n", str, nargs) ;
	return 1 ;
}



main(argc,argv)
	int	argc ;
	char	**argv ;
{
	FILE	*tmpfile ;
	char	line[1024] ;
	int	n ;
	int	header ;
	PatInfo	*pat ;
	char	*err ;
	int	firstline ;
	int	cont = 0 ;
	int	foundit = 0 ;

	logfile = fopen("/dev/console","w") ;
	if( logfile == NULL )
	  logfile = stderr ;

	while( --argc > 0 )
	{
	  ++argv ;
	  if( argcheck("-v", *argv, 0, &argc) )
	    ++verbose ;
	  else if( argcheck("-home", *argv, 1, &argc) )
	    home = *++argv ;
	  else if( argcheck("-mailbox", *argv, 1, &argc) )
	    mailbox = *++argv ;
	  else if( argcheck("-mailrc", *argv, 1, &argc) )
	    mailrc = *++argv ;
	  else if( argcheck("-sortmailrc", *argv, 1, &argc) )
	    sortmailrc = *++argv ;
	  else
	    user = *argv ;
	}

#ifdef	DEBUG
	verbose = 1 ;
#endif	/* DEBUG */

	read_initfiles() ;

	sprintf(tmpfilename, "/tmp/sortmail%d", getpid()) ;
	if( (tmpfile = fopen(tmpfilename, "w+")) == NULL )
	{
	  fprintf(stderr, "sortmail: can't open %s, mail to %s may be lost\n",
		tmpfile, user) ;
	  fprintf(logfile, "sortmail: can't open %s, %s\n",
		tmpfile, sys_errlist[errno]) ;
	  append(stdin, mailbox) ;		/* try to rescue situtation */
	  exit(1) ;
	}

	firstline = 1 ;
	while( fgets(line, sizeof(line), stdin) != NULL ) {
	  if( !firstline && strmatch(line, "From ") )
	    putc('>', tmpfile) ;
	  fputs(line, tmpfile) ;
	  firstline = 0 ;
	}
#ifdef	DEBUG
	fprintf(logfile, "got a message in %s\n", tmpfilename) ;
#endif	/* DEBUG */

	for( pat = patterns; pat != NULL && !foundit ; pat = pat->next )
	{
	  if( !ReCompile(pat->pattern) )
	  {
	    rewind(tmpfile) ;
	    while( fgets(line, sizeof(line), tmpfile) != NULL ) {
	      if( line[0] == '\n'  &&  pat->flags != P_ALL )
		break ;
	      if( pat->flags == P_HEADER  ||
		  pat->flags == P_SUBJECT && strmatch(line, "Subject: ") ||
		  pat->flags == P_FROM && strmatch(line, "From: ") ||
		  pat->flags == P_TO &&
			(strmatch(line, "To: ") || strmatch(line, "Cc: ") ||
			strmatch(line, "Apparently-To: ") ) ||
		  isspace(line[0]) && cont ||
		  pat->flags == P_ALL )
	      {
		if( re_exec(line) )
		{
		  dispose(pat,tmpfile) ;
		  foundit = 1 ;
		  break ;
		}
		else
		  /* if next line is a continuation line, test it too */
		  cont = 1 ;
	      }
	      else
		cont = 0 ;
	    }
	  }
	}

	if( vacation != NULL )
	{
	  rewind(tmpfile) ;
	  if( !ReCompile(user) )
	  {
	    while( fgets(line, sizeof(line), tmpfile) != NULL ) {
	      if( line[0] == '\n' )
		break ;
	      if( strmatch(line, "To: ") || strmatch(line, "Cc: ") ||
			strmatch(line, "Apparently-To: ") )
	      {
		if( re_exec(line) )
		{
		  sprintf(line, "/usr/ucb/vacation %s", user) ;
		  put_pipe(tmpfile, line) ;
		  if( verbose )
		    fprintf(logfile, "message piped through %s\n", line) ;
		  break ;
		}
	      }
	    }
	  }
	}

	unlink(tmpfilename) ;

	if( !foundit )
	  append(tmpfile, deflt != NULL ? deflt : mailbox) ;
	exit(0) ;
}


/*VARARGS0*/
die(va_alist)
	va_dcl
{
	va_list	args ;
	char	*fmt ;

	va_start(args) ;
	fprintf(logfile, "sortmail: ") ;
	fmt = va_arg(args, char *);
	vfprintf(logfile, fmt, args);
	va_end(args) ;
	exit(1) ;
}


	/* This function deals with the file described by 'file' in
	 * the manner described by "pat".
	 */

static	void
dispose(pat, file)
register PatInfo *pat ;
register FILE	*file ;
{
	char	outfile[MAXPATHLEN] ;
	char	*ptr ;
	struct passwd	*passwd ;

	switch( pat->command ) {
	  case C_MAIL:		/* append to user's mail file */
	    if( pat->dest == NULL || pat->dest[0] == '\0' )
	      append(file, mailbox) ;
	    else
	      forward(file, pat->dest) ;
	    break ;

	  case C_FILE:		/* append to named file. */
	    append(file, pat->dest) ;
	    break ;

	  case C_PIPE:		/* pipe through named command */
	    put_pipe(file, pat->dest) ;
	    if( verbose )
	      fprintf(logfile, "message piped through %s\n", pat->dest) ;
	    break ;

	  case C_JUNK:		/* throw it away */
	    if( verbose )
	      fprintf(logfile, "message deleted\n") ;
	    break ;
	}
}


static	void
append(file, outfile)
	FILE	*file ;
	char	*outfile ;
{
	FILE	*ofile ;
	char	line[1024] ;
	int	i ;

	filename_expand(line, outfile) ;
	if( verbose )
	  fprintf(logfile, "message filed to %s\n", line) ;

	rewind(file) ;

	if( (ofile = fopen(line, "a")) == NULL )
	{
	  fprintf(logfile, "sortmail: can't open %s, %s\n",
		line,sys_errlist[errno]);
	  if( strcmp(outfile, mailbox) == 0 )
	    fprintf(stderr,
	      "sortmail: Cannot open %s, %s.  Mail to %s may be lost\n",
		mailbox, sys_errlist[errno], user) ;
	  else
	    append(file, mailbox) ;
	}
	else
	{
	  while( fgets(line, sizeof(line), file) != NULL )
	    fputs(line, ofile) ;
	  fputs("\n", ofile) ;
	  fclose(ofile) ;
	}
}


static	void
put_pipe(file, dest)
	FILE	*file ;
	char	*dest ;
{
	FILE	*ofile ;
	char	line[1024] ;

	if( (ofile = popen(dest, "w")) == NULL )
	{
	  fprintf(logfile, "sortmail: cannot open pipe to command %s\n",
		dest ) ;
	  append(file, mailbox) ;
	}
	else
	{
	  rewind(file) ;
	  while( fgets(line, sizeof(line), file) != NULL )
	    fputs(line, ofile) ;
	  pclose(ofile) ;
	}
}


static	void
forward(file, dest)
	FILE	*file ;
	char	*dest ;
{
	char	cmd[1024] ;

	sprintf(cmd, "/usr/lib/sendmail %s", dest) ;
	put_pipe(file, cmd) ;
	if( verbose )
	  fprintf(logfile, "message mailed to %s\n", dest) ;
}
