/* Copyright (C) 2000  Britton Leo Kerin, see copyright. */

/* Returns the block size used by the kernel sound driver.  The big
   buffer will be partitioned into chunks of this size. */

#include <stdio.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <linux/soundcard.h>

#include "rawrec.h"

int get_au_blksz(int audio_fd)
{
  long blocksize;

  if ( ioctl(audio_fd, SNDCTL_DSP_GETBLKSIZE, &blocksize) == -1 ) {
    fprintf(stderr, "%s: SNDCTL_DSP_GETBLKSIZE ioctl failed: ", progname);
    perror("");
    exit(EXIT_FAILURE);
  }

  return blocksize;
} 
