<?php
//
// SourceForge: Breaking Down the Barriers to Open Source Development
// Copyright 1999-2000 (c) The SourceForge Crew
// http://sourceforge.net
//
// $Id: privacy.php,v 1.2 2000/08/31 06:11:36 gherteg Exp $

require "pre.php";    // Initial db and session library, opens session
$HTML->header(array(title=>"Terms of Service Agreement"));
?>

<p>
<h2>SourceForge Privacy Policy</h2>
</p>

<p>
At SourceForge, we intend to give you as much control as possible over your
personal information, including the Registration Data.   We will let each
user know how we will use the personal information derived from each user's
access to and use of SourceForge and/or the Services.
</p>

<p>
NOTICE
</p>

<p>
SourceForge will track the domains from which people visit SourceForge and
analyze this data for trends and statistics.  Subject to the provisions of
this Privacy Policy, different SourceForge sites may use accumulated data
for different purposes, including but not limited to marketing analysis,
service evaluation and planning.
</p>

<p>
SourceForge contains links to other Websites, whether owned or controlled by
SourceForge affiliates or unrelated third parties.  SourceForge is not
responsible for the privacy policies and practices of any linked Website.
</p>

<p>
Currently, SourceForge uses personal information as a basis for
notifications to users, "opt-in" emails, and in order to implement the terms
of the Terms of Service governing the website (the "TOS").    User names and
email addresses (as well as any additional information that a user may
choose to post) are publicly available on the SourceForge site, unless a
user elects to "opt-out" of such display of personal information.  However,
in cases where users voluntarily and publicly disclose personal information
which may contain Registration Data, or otherwise post personal information
in conjunction with content subject to an open source license, such personal
information necessarily will be disclosed subject to the terms of the
applicable license.
</p>

<p>
Subject to the foregoing, SourceForge may conduct surveys of other studies
of its customer base and usage for marketing and planning purposes.  With
respect to information collected from such surveys or studies, and in the
event that responses are to be publicly disclosed, users will be notified at
the time they take the survey and SourceForge will disclose only aggregate
information regarding its users and not personal information identifying any
specific individual.  Notwithstanding the foregoing, in cases where surveys
allow users to submit written comments, and where SourceForge advises users
of the possibility of such disclosure at the time they take the survey,
SourceForge reserves the right to disclose text information provided by any
user through such a survey, provided that no personal information
identifying that user is disclosed.
</p>

<p>
<b>CHOICE</b>
</p>

<p>
Cookies:  SourceForge employs "cookies" to provide a user with tailored
information.  A "cookie" is an element of data which a Service or site, when
visited by a user, sends to that user's browser which, in turn, may store
that element on the user's hard drive or memory.  SourceForge uses cookies
to better serve users who use our Services; any cookies sent by SourceForge
will be marked so that they will only be accessible by websites subject to
this Privacy Policy.  However, at his or her option and at his or her sole
expense and responsibility, any user may block or delete our cookies from
his or her hard drive.  However, by disabling cookies, certain site features
and functionality may no longer work properly, or at all.
</p>

<p>
"Opt-in" Emails:  Users may "opt-in" to receive site notifications,
newsletters or other information via email.  Users may remove themselves
from such services at their discretion.  Any email sent to an "opt-in" list
will include directions for how a user may remove him or herself from the
list, or a URL where the user may find such directions.
</p>

<p>
Other Notification: In order to implement or enforce the Terms of Service of
the relevant SourceForge site, SourceForge may use personal information to
contact users on an individual basis.
</p>

<p>
Profile Display: In some cases, users' personal information may be publicly
available through a user's profile display. In such cases, users have the
option to opt out of publicly displaying their real names. In cases where
site profiles allow users to display optional information publicly, such
entry and display is at the user's discretion and may be changed at any time
by the user.
</p>

<p>
Email Display: In some cases, users may have the opportunity to use a
Service to send electronic mail to another user or email list. In such
cases, a user's valid email address and real name will be included with such
messages.  In order to prevent abuse, users may not opt-out of such a
display, but may choose to refrain from using said Service to transmit an
email message.
</p>

<p>
General:  In cases where users voluntarily and publicly disclose personal
information which may contain Registration Data, or otherwise post personal
information, in conjunction with content subject to an open source license
such personal information necessarily will be disclosed subject to the terms
of the applicable license. An example of such a disclosure includes, but is
not limited to, a user's disclosure of personal information as part of a
message posted to a public message forum, or a publicly-released software
application.
</p>

<p>
At no time, unless such disclosure is required by law or a user specifically
authorizes such disclosure, will SourceForge disclose individual user
personal information that is not publicly available to unrelated third
parties.
</p>

<p>
Surveys and Resulting Information:  Subject to the foregoing, SourceForge
may conduct surveys or other studies of its customer base and usage for
marketing and planning purposes.  Participation in such surveys is at the
user's option;  SourceForge does not conduct mandatory surveys.
</p>

<p>
With respect to information collected from such surveys or studies, and in
the event that responses are to be publicly disclosed, users will be
notified at the time they take the survey and SourceForge will disclose
only aggregate information regarding its users and not personal information
identifying any specific individual.  Circumstances under which SourceForge
would publicly disclose such aggregate information include, but are not
limited to, sharing survey results with the site population, providing data
to SourceForge advertisers on user preferences and/or demographics, and
publicizing overall usage data in press communications.
</p>

<p>
Notwithstanding the foregoing, in cases where surveys allow users to submit
written comments, and where SourceForge advises users of the possibility of
such disclosure at the time they take the survey, SourceForge reserves the
right to disclose text information provided by any user through such a
survey, provided that no personal information identifying that user is
disclosed.
</p>

<p>
<b>ACCESS</b>
</p>

<p>
With regard to personal information, users can view their data on their
personal profile page.  When technically feasible, users are permitted to
update their personal information directly through SourceForge Service.
When such updating service is not technically feasible, SourceForge will
make reasonable efforts to assist users in updating their personal
information.
</p>

<p>
<b>SECURITY</b>
</p>

<p>
To secure site integrity, SourceForge employs measures including but not
limited to security audits, use of encryption tools and software, and other
reasonable security measures and procedures.
</p>

<p>
Internal access to users' private and nonpublic personal  information is
restricted to site administrators and individuals on a need-to-know basis.
</p>

<p>
<b>ENFORCEMENT</b>
</p>

<p>
In the event that SourceForge becomes aware that site security is
compromised or user nonpublic information has been disclosed to unrelated
third parties as a result of external activity, including but not limited to
external security attacks, SourceForge shall take reasonable measures which
it deems appropriate, including but not limited to internal investigation
and reporting, and notification to and cooperation with law enforcement
authorities.
</p>

<p>
If SourceForge becomes aware that a user's personal information provided to
SourceForge has been disclosed in a manner not permitted by this Privacy
Policy, SourceForge shall make reasonable efforts to notify the affected
user, as soon as reasonably possible and as permitted by law, of what
information has been disclosed, to the extent that SourceForge knows this
information.
</p>

<p>
<b>UPDATES TO THE PRIVACY POLICY</b>
</p>

<p>
To update the privacy policy, we will both post the changed version and its
effective date at <a href="http://sourceforge.net/tos/privacy.php">http://sourceforge.net/tos/privacy.php</a>.  Concurrently with
any change to the core privacy policy, we will email notice of the change to
known users at least 15 days (or such shorter or longer time as mandated by
law or any judicial or government body ) in advance.
</p>

<?php
$HTML->footer(array());

?>

