/* 
 * tclInitScript.h --
 *
 *	This file contains Unix & Windows common init script
 *      It is not used on the Mac. (the mac init script is in tclMacInit.c)
 *
 * Copyright (c) 1998 Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * RCS: @(#) $Id: tclInitScript.h,v 1.11 2000/09/13 17:22:49 spolk Exp $
 */

/*
 * The following string is the startup script executed in new
 * interpreters.  It looks on disk in several different directories
 * for a script "init.tcl" that is compatible with this version
 * of Tcl.  The init.tcl script does all of the real work of
 * initialization.
 *
 * Note that the CYGNUS version overflows the Microsoft C compiler. Bleah.
 * SN uses the original tcl version.
 */

#ifdef _MSC_VER

static char initScript[] = "if {[info proc tclInit]==\"\"} {\n\
  proc tclInit {} {\n\
    global tcl_libPath tcl_library errorInfo\n\
    rename tclInit {}\n\
    set errors {}\n\
    foreach i $tcl_libPath {\n\
	set tcl_library $i\n\
	set tclfile [file join $i init.tcl]\n\
	if {[file exists $tclfile]} {\n\
	    if {[catch {uplevel #0 [list source $tclfile]} msg] != 1} {\n\
		return\n\
	    } else {\n\
		append errors \"$tclfile: $msg\n$errorInfo\n\"\n\
	    }\n\
	}\n\
    }\n\
    set msg \"Can't find a usable init.tcl in the following directories: \n\"\n\
    append msg \"    $tcl_libPath\n\n\"\n\
    append msg \"$errors\n\n\"\n\
    append msg \"This probably means that Tcl wasn't installed properly.\n\"\n\
    error $msg\n\
  }\n\
}\n\
tclInit";

#else

static char initScript[] = "if {[info proc tclInit]==\"\"} {\n\
  proc tclInit {} {\n\
    global tcl_library tcl_version tcl_patchLevel errorInfo\n\
    global tcl_pkgPath env tclDefaultLibrary\n\
    global tcl_platform\n\
    rename tclInit {}\n\
    set errors {}\n\
    set dirs {}\n\
    if {[info exists tcl_library]} {\n\
	lappend dirs $tcl_library\n\
    } \n\
    if {[info exists env(TCL_LIBRARY)]} {\n\
        lappend dirs $env(TCL_LIBRARY)\n\
    }\n\
    # CYGNUS LOCAL: I've changed this alot.  Basically we only care about two cases,\n\
    # if we are installed, and if we are in the devo tree...\n\
    # The next few are for if we are installed:\n\
    # This is bogus - on Solaris, when running UNDER gdb, info nameofexecutible returns /root/./prog\n\
    # So we have to find the absolute dir name this way:\n\
    set execDir [file dirname [info nameofexecutable]]\n\
    set curDir [pwd]\n\
    cd $execDir\n\
    set execDir [pwd]\n\
    cd $curDir\n\
    set parentDir [file dirname $execDir]\n\
    lappend dirs [file join $parentDir share tcl$tcl_version]\n\
    lappend dirs [file join [file dirname $parentDir] share tcl$tcl_version]\n\
    # NOW, let's try to find it in the build tree...\n\
    # Rather than play all the games Scriptics does, if we are in the build\n\
    # tree there will be a tclConfig.sh relative to the executable's directory, and we \n\
    # can read it and get the source dir from there...\n\
    #\n\
    # We duplicate all the directories in the search, one w/o the version and one with.\n\
    # Most modules use ../../tcl/{unix,win}\n\
    lappend configDirs [file join [file dirname $parentDir] tcl$tcl_version $tcl_platform(platform)]\n\
    lappend configDirs [file join [file dirname $parentDir] tcl             $tcl_platform(platform)]\n\
    # This one gets tclsh...\n\
    lappend configDirs $execDir\n\
    # This one is for gdb, and any other app which has its executible in the top directory.\n\
    lappend configDirs [file join $parentDir tcl$tcl_version $tcl_platform(platform)]\n\
    lappend configDirs [file join $parentDir tcl             $tcl_platform(platform)]\n\
    # This last will handle itclsh & itkwish and tixwish (../../../tcl/{unix,win}):\n\
    lappend configDirs [file join [file dirname [file dirname $parentDir]] \\\n\
                                    tcl$tcl_version $tcl_platform(platform)]\n\
    lappend configDirs [file join [file dirname [file dirname $parentDir]] tcl \\\n\
                                    $tcl_platform(platform)]\n\
    \n\
    foreach i $configDirs {\n\
        set configFile [file join $i tclConfig.sh]\n\
        if {[file exists $configFile]} {\n\
            if {![catch {open $configFile r} fileH]} {\n\
                set srcDir {}\n\
                while {[gets $fileH line] >= 0} {\n\
                    if {[regexp {^TCL_SRC_DIR='([^']*)'} $line dummy srcDir]} {\n\
                        break\n\
                    }\n\
                }\n\
                close $fileH\n\
                if {$srcDir != \"\"} {\n\
                    lappend dirs [file join $srcDir library]\n\
                    break\n\
                }\n\
            }\n\
        }\n\
    }\n\
    # I also moved this from just after TCL_LIBRARY to last.\n\
    # I only want to use the compiled in library if I am really lost, because\n\
    # otherwise if I have installed once, but am working in the build directory,\n\
    # I will always pick up the installed files, which will be very confusing...\n\
    if {[info exists tclDefaultLibrary]} {\n\
        lappend dirs $tclDefaultLibrary\n\
        unset tclDefaultLibrary\n\
    }
    foreach i $dirs {\n\
	set tcl_library $i\n\
	set tclfile [file join $i init.tcl]\n\
	if {[file exists $tclfile]} {\n\
	    if {![catch {uplevel #0 [list source $tclfile]} msg]} {\n\
	        return\n\
	    } else {\n\
		append errors \"$tclfile: $msg\n$errorInfo\n\"\n\
	    }\n\
            set tcl_pkgPath [lreplace $tcl_pkgPath end end]\n\
	}\n\
    }\n\
    set msg \"Can't find a usable init.tcl in the following directories: \n\"\n\
    append msg \"    $dirs\n\n\"\n\
    append msg \"$errors\n\n\"\n\
    append msg \"This probably means that Tcl wasn't installed properly.\n\"\n\
    error $msg\n\
  }\n\
}\n\
tclInit";

#endif
