-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.CompUnit)
procedure CheckProtectedModifierConsistency
  (The_Type              : in     Dictionary.Symbol;
   Modifier_Is_Protected : in     Boolean;
   Error_Node            : in     STree.SyntaxNode;
   Consistent            :    out Boolean) is
begin
   Consistent := True;
   if Dictionary.IsDeclared (The_Type) or else Dictionary.IsPredefined (The_Type) then
      if (Dictionary.TypeIsProtected (The_Type) or else Dictionary.IsPredefinedSuspensionObjectType (The_Type))
        and then not Modifier_Is_Protected then
         -- If the announced type is a PO or SO then the protected modifier
         -- should be present.
         Consistent := False;
      elsif Modifier_Is_Protected and then not Dictionary.IsAtomic (The_Type) then
         -- If the announced type is not atomic then the protected modifier
         -- should be not be present.
         Consistent := False;
      end if;
   end if;
   if not Consistent then
      ErrorHandler.Semantic_Error
        (Err_Num   => 855,
         Reference => ErrorHandler.No_Reference,
         Position  => Node_Position (Node => Error_Node),
         Id_Str    => Node_Lex_String (Node => Error_Node));
   end if;
end CheckProtectedModifierConsistency;
