-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem)
package body Walk_Expression_P is

   --# inherit CommandLineData,
   --#         ExaminerConstants,
   --#         Sem,
   --#         SystemErrors;
   package Exp_Stack is

      type Exp_Stack_Type is private;

      procedure Init (Stack : out Exp_Stack_Type);
      --# derives Stack from ;

      procedure Push (X     : in     Sem.Exp_Record;
                      Stack : in out Exp_Stack_Type);
      --# global in CommandLineData.Content;
      --# derives Stack from *,
      --#                    X &
      --#         null  from CommandLineData.Content;

      procedure Pop (Item  :    out Sem.Exp_Record;
                     Stack : in out Exp_Stack_Type);
      --# global in CommandLineData.Content;
      --# derives Item,
      --#         Stack from Stack &
      --#         null  from CommandLineData.Content;

      function Top (Stack : Exp_Stack_Type) return Sem.Exp_Record;

      function Has_One_Entry (Stack : Exp_Stack_Type) return Boolean;

      function Is_Empty (Stack : Exp_Stack_Type) return Boolean;

   private

      subtype Index_Range is Integer range 1 .. ExaminerConstants.WalkExpStackMax;
      type Stack_Array is array (Index_Range) of Sem.Exp_Record;
      subtype Top_Range is Integer range 0 .. ExaminerConstants.WalkExpStackMax;

      type Exp_Stack_Type is record
         S       : Stack_Array;
         Top_Ptr : Top_Range;
      end record;

   end Exp_Stack;

   -----------------------------------------------------------------

   --# inherit Dictionary,
   --#         ExaminerConstants,
   --#         SPARK_IO,
   --#         SystemErrors;
   package Type_Context_Stack is

      type T_Stack_Type is private;

      procedure Init (Stack : out T_Stack_Type);
      --# derives Stack from ;

      procedure Push (X     : in     Dictionary.Symbol;
                      Stack : in out T_Stack_Type);
      --# derives Stack from *,
      --#                    X;

      procedure Pop (Stack : in out T_Stack_Type);
      --# derives Stack from *;

      function Top (Stack : T_Stack_Type) return Dictionary.Symbol;

      function Has_One_Entry (Stack : T_Stack_Type) return Boolean;

   private

      subtype Index_Range is Integer range 1 .. ExaminerConstants.WalkExpStackMax;
      type Stack_Array is array (Index_Range) of Dictionary.Symbol;
      subtype Top_Range is Integer range 0 .. ExaminerConstants.WalkExpStackMax;

      type T_Stack_Type is record
         S       : Stack_Array;
         Top_Ptr : Top_Range;
      end record;

   end Type_Context_Stack;

   -------------- Package bodies ------------------------------

   package body Exp_Stack is separate;

   package body Type_Context_Stack is separate;

   --------------------------------------------

   procedure Check_Binary_Operator
     (Operator      : in     SP_Symbols.SP_Symbol;
      Left          : in     Sem.Exp_Record;
      Right         : in     Sem.Exp_Record;
      Scope         : in     Dictionary.Scopes;
      T_Stack       : in     Type_Context_Stack.T_Stack_Type;
      Op_Pos        : in     LexTokenManager.Token_Position;
      Left_Pos      : in     LexTokenManager.Token_Position;
      Right_Pos     : in     LexTokenManager.Token_Position;
      Convert       : in     Boolean;
      Is_Annotation : in     Boolean;
      Result        : in out Sem.Exp_Record)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Convert,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         Is_Annotation,
   --#                                         Left,
   --#                                         Left_Pos,
   --#                                         LexTokenManager.State,
   --#                                         Operator,
   --#                                         Op_Pos,
   --#                                         Right,
   --#                                         Right_Pos,
   --#                                         Scope,
   --#                                         SPARK_IO.File_Sys,
   --#                                         T_Stack &
   --#         Result                     from *,
   --#                                         CommandLineData.Content,
   --#                                         Convert,
   --#                                         Dictionary.Dict,
   --#                                         Is_Annotation,
   --#                                         Left,
   --#                                         Operator,
   --#                                         Right,
   --#                                         Scope,
   --#                                         T_Stack;
      is separate;

   -----------------------------------------------------------------

   procedure Calc_Binary_Operator
     (Node_Pos            : in     LexTokenManager.Token_Position;
      Operator            : in     SP_Symbols.SP_Symbol;
      Left_Val, Right_Val : in     Maths.Value;
      Is_Annotation       : in     Boolean;
      Result              : in out Sem.Exp_Record)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         Is_Annotation,
   --#                                         Left_Val,
   --#                                         LexTokenManager.State,
   --#                                         Node_Pos,
   --#                                         Operator,
   --#                                         Result,
   --#                                         Right_Val,
   --#                                         SPARK_IO.File_Sys &
   --#         Result                     from *,
   --#                                         Dictionary.Dict,
   --#                                         Left_Val,
   --#                                         LexTokenManager.State,
   --#                                         Operator,
   --#                                         Right_Val;
      is separate;

   -------------------------------------------------------------------

   -----------------------------------------
   -- Routines for handling list of names --
   -----------------------------------------

   procedure Add_Name
     (Name       : in     LexTokenManager.Lex_String;
      List       : in     Lists.List;
      Heap_Param : in out Lists.List_Heap;
      Present    :    out Boolean)
   --# global in LexTokenManager.State;
   --# derives Heap_Param,
   --#         Present    from Heap_Param,
   --#                         LexTokenManager.State,
   --#                         List,
   --#                         Name;
      is separate;

   procedure Dispose_Of_Name_List (List       : in out Lists.List;
                                   Heap_Param : in out Lists.List_Heap)
   --# global in LexTokenManager.State;
   --# derives Heap_Param from *,
   --#                         LexTokenManager.State,
   --#                         List &
   --#         List       from ;
      is separate;

   ----------------------------------------------------------------------

   -- This procedure is used in wf_named_argument_association and
   -- expression_type_from_context to find a named argument association
   -- parameter.  If Name_Is_Parameter_Name returns True, then the
   -- identifier simple_name (below Node) is a legal parameter name
   -- for the given subprogram, and Param_Sym denotes that parameter name.
   -- If Name_Is_Parameter_Name return False, then the identifier is not
   -- a legal parameter names, and Param_Sym is NullSymbol.

   procedure Find_Named_Argument_Association_Parameter
     (Node                   : in     STree.SyntaxNode;
      Subprog_Sym            : in     Dictionary.Symbol;
      Name_Is_Parameter_Name :    out Boolean;
      Param_Sym              :    out Dictionary.Symbol)
   --# global in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in out STree.Table;
   --# derives Name_Is_Parameter_Name,
   --#         Param_Sym,
   --#         STree.Table            from Dictionary.Dict,
   --#                                     LexTokenManager.State,
   --#                                     Node,
   --#                                     STree.Table,
   --#                                     Subprog_Sym;
   --# pre STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.named_argument_association or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_named_argument_association;
   --# post STree.Table = STree.Table~;
      is separate;

   ----------------------------------------------------------------------

   procedure Wf_Tilde
     (Node_Pos : in     LexTokenManager.Token_Position;
      Scope    : in     Dictionary.Scopes;
      E_Stack  : in out Exp_Stack.Exp_Stack_Type;
      Context  : in     Sem.Anno_Tilde_Context)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Context,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node_Pos,
   --#                                         Scope,
   --#                                         SPARK_IO.File_Sys &
   --#         E_Stack                    from *,
   --#                                         Context,
   --#                                         Dictionary.Dict,
   --#                                         Scope;
      is separate;

   --------------------------------------------

   procedure Wf_Percent
     (Node_Pos : in     LexTokenManager.Token_Position;
      Scope    : in     Dictionary.Scopes;
      E_Stack  : in out Exp_Stack.Exp_Stack_Type)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node_Pos,
   --#                                         Scope,
   --#                                         SPARK_IO.File_Sys &
   --#         E_Stack                    from *,
   --#                                         Dictionary.Dict,
   --#                                         Scope;
      is separate;

   --------------------------------------------

   procedure Tagged_Actual_Must_Be_Object_Check
     (Node_Pos         : in     LexTokenManager.Token_Position;
      Formal_Type      : in     Dictionary.Symbol;
      Actual_Type      : in     Dictionary.Symbol;
      Controlling_Type : in     Dictionary.Symbol;
      Is_A_Variable    : in     Boolean;
      Is_A_Constant    : in     Boolean;
      Error_Found      : in out Boolean)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from Actual_Type,
   --#                                         CommandLineData.Content,
   --#                                         Controlling_Type,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         Formal_Type,
   --#                                         Is_A_Constant,
   --#                                         Is_A_Variable,
   --#                                         LexTokenManager.State,
   --#                                         Node_Pos,
   --#                                         SPARK_IO.File_Sys &
   --#         Error_Found                from *,
   --#                                         Actual_Type,
   --#                                         Controlling_Type,
   --#                                         Formal_Type,
   --#                                         Is_A_Constant,
   --#                                         Is_A_Variable;
      is separate;

   ---------------------------------------------------------------

   procedure Create_Name_List (List       :    out Lists.List;
                               Heap_Param : in out Lists.List_Heap)
   --# derives Heap_Param,
   --#         List       from Heap_Param;
      is separate;

   --------------------------------------------------------------------

   function Unknown_Symbol_Record return  Sem.Exp_Record
   --# global in Dictionary.Dict;
      is separate;

   --------------------------------------------

   procedure Stack_Identifier
     (Sym           : in     Dictionary.Symbol;
      Id_Str        : in     LexTokenManager.Lex_String;
      Node          : in     STree.SyntaxNode;
      Prefix        : in     Dictionary.Symbol;
      Scope         : in     Dictionary.Scopes;
      E_Stack       : in out Exp_Stack.Exp_Stack_Type;
      The_Heap      : in out Heap.HeapRecord;
      Ref_Var       : in     SeqAlgebra.Seq;
      Dotted        : in     Boolean;
      Context       : in     Sem.Tilde_Context;
      Is_Annotation : in     Boolean)
   --# global in     CommandLineData.Content;
   --#        in     LexTokenManager.State;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --#        in out Statistics.TableUsage;
   --#        in out STree.Table;
   --# derives Dictionary.Dict,
   --#         E_Stack                    from *,
   --#                                         CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         Dotted,
   --#                                         Id_Str,
   --#                                         Is_Annotation,
   --#                                         LexTokenManager.State,
   --#                                         Prefix,
   --#                                         Scope,
   --#                                         Sym &
   --#         ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Context,
   --#                                         Dictionary.Dict,
   --#                                         Dotted,
   --#                                         ErrorHandler.Error_Context,
   --#                                         Id_Str,
   --#                                         Is_Annotation,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Prefix,
   --#                                         Scope,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table,
   --#                                         Sym &
   --#         Statistics.TableUsage,
   --#         The_Heap                   from *,
   --#                                         CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         Dotted,
   --#                                         Id_Str,
   --#                                         Is_Annotation,
   --#                                         LexTokenManager.State,
   --#                                         Prefix,
   --#                                         Ref_Var,
   --#                                         Scope,
   --#                                         Sym,
   --#                                         The_Heap &
   --#         STree.Table                from *,
   --#                                         CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         Id_Str,
   --#                                         Is_Annotation,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Prefix,
   --#                                         Scope,
   --#                                         Sym;
   --# pre STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.identifier or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.selected_component or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_selected_component;
   --# post STree.Table = STree.Table~;
      is separate;

   -----------------------------------------------------------------

   function Ops_Are_Same_And_Commutative (Op1, Op2 : SP_Symbols.SP_Symbol) return Boolean is separate;

   -----------------------------------------------------------------

   function Null_Type_Record return  Sem.Exp_Record
   --# global in Dictionary.Dict;
      is separate;

   -----------------------------------------------------------------

   function Null_Parameter_Record return  Sem.Exp_Record
   --# global in Dictionary.Dict;
      is separate;

   ------------------------------------------------------------------------
   -- Subprograms used by Walk_Expression and Walk_Annotation_Expression --
   ------------------------------------------------------------------------

   -- Put_Exp_Record is handy for debugging expression walking, but
   -- is uncalled in production builds.
   procedure Put_Exp_Record (R : in Sem.Exp_Record)
   --# global in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Dictionary.Dict,
   --#                                LexTokenManager.State,
   --#                                R;
      is separate;

   ---------------------------------------------------------------------

   function Get_Character_Literal (Node : STree.SyntaxNode) return Maths.Value
   --# global in LexTokenManager.State;
   --#        in STree.Table;
   --# pre STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.character_literal;
      is separate;

   --------------------------------------------

   function Get_String_Literal_Length (Str : LexTokenManager.Lex_String) return Maths.Value
   --# global in LexTokenManager.State;
      is separate;

   --------------------------------------------

   procedure Wf_Identifier
     (Node     : in     STree.SyntaxNode;
      Scope    : in     Dictionary.Scopes;
      E_Stack  : in out Exp_Stack.Exp_Stack_Type;
      The_Heap : in out Heap.HeapRecord;
      Ref_Var  : in     SeqAlgebra.Seq;
      Context  : in     Sem.Tilde_Context)
   --# global in     CommandLineData.Content;
   --#        in     ContextManager.Ops.File_Heap;
   --#        in     ContextManager.Ops.Unit_Heap;
   --#        in     ContextManager.Ops.Unit_Stack;
   --#        in     LexTokenManager.State;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SLI.State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out Statistics.TableUsage;
   --#        in out STree.Table;
   --# derives Dictionary.Dict,
   --#         E_Stack,
   --#         STree.Table                from *,
   --#                                         CommandLineData.Content,
   --#                                         Context,
   --#                                         Dictionary.Dict,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table &
   --#         ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Context,
   --#                                         ContextManager.Ops.File_Heap,
   --#                                         ContextManager.Ops.Unit_Heap,
   --#                                         ContextManager.Ops.Unit_Stack,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         SLI.State,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table &
   --#         SLI.State                  from *,
   --#                                         CommandLineData.Content,
   --#                                         Context,
   --#                                         ContextManager.Ops.Unit_Heap,
   --#                                         ContextManager.Ops.Unit_Stack,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table &
   --#         Statistics.TableUsage,
   --#         The_Heap                   from *,
   --#                                         CommandLineData.Content,
   --#                                         Context,
   --#                                         Dictionary.Dict,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Ref_Var,
   --#                                         Scope,
   --#                                         STree.Table,
   --#                                         The_Heap;
   --# pre STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.identifier;
   --# post STree.Table = STree.Table~;
      is separate;

   --------------------------------------

   procedure Down_Wf_Name_Argument_List
     (Node       : in     STree.SyntaxNode;
      Scope      : in     Dictionary.Scopes;
      E_Stack    : in out Exp_Stack.Exp_Stack_Type;
      Heap_Param : in out Lists.List_Heap;
      Next_Node  :    out STree.SyntaxNode)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in     STree.Table;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table &
   --#         E_Stack                    from *,
   --#                                         Dictionary.Dict,
   --#                                         Heap_Param,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table &
   --#         Heap_Param                 from *,
   --#                                         E_Stack,
   --#                                         Node,
   --#                                         STree.Table &
   --#         Next_Node                  from Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table;
   --# pre STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.name_argument_list or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_name_argument_list;
   --# post STree.Syntax_Node_Type (Next_Node, STree.Table) = SP_Symbols.named_argument_association or
   --#   STree.Syntax_Node_Type (Next_Node, STree.Table) = SP_Symbols.positional_argument_association or
   --#   STree.Syntax_Node_Type (Next_Node, STree.Table) = SP_Symbols.annotation_named_argument_association or
   --#   STree.Syntax_Node_Type (Next_Node, STree.Table) = SP_Symbols.annotation_positional_argument_association or
   --#   Next_Node = STree.NullNode;
      is separate;

   -----------------------------------------------------------------------

   procedure Up_Wf_Name_Argument_List
     (Node       : in     STree.SyntaxNode;
      E_Stack    : in out Exp_Stack.Exp_Stack_Type;
      Heap_Param : in out Lists.List_Heap)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in     STree.Table;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         E_Stack,
   --#                                         Heap_Param,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table &
   --#         E_Stack                    from *,
   --#                                         Dictionary.Dict,
   --#                                         Heap_Param,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         STree.Table &
   --#         Heap_Param                 from *,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         STree.Table;
   --# pre STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.name_argument_list or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_name_argument_list;
      is separate;

   ----------------------------------------------------------------------

   procedure Down_Wf_Aggregate
     (Node       : in     STree.SyntaxNode;
      Scope      : in     Dictionary.Scopes;
      Next_Node  :    out STree.SyntaxNode;
      E_Stack    : in out Exp_Stack.Exp_Stack_Type;
      Heap_Param : in out Lists.List_Heap)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in     STree.Table;
   --#        in out Aggregate_Stack.State;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --# derives Aggregate_Stack.State      from *,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table &
   --#         ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table &
   --#         E_Stack,
   --#         Heap_Param                 from Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         Heap_Param,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table &
   --#         Next_Node                  from Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table;
   --# pre (STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.aggregate or
   --#        STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_aggregate) and
   --#   Aggregate_Stack.Stack_Is_Valid (Aggregate_Stack.State);
   --# post (STree.Syntax_Node_Type (Next_Node, STree.Table) = SP_Symbols.component_association or
   --#         STree.Syntax_Node_Type (Next_Node, STree.Table) = SP_Symbols.annotation_component_association or
   --#         Next_Node = STree.NullNode) and
   --#   Aggregate_Stack.Stack_Is_Valid (Aggregate_Stack.State);
      is separate;

   -----------------------------------------------------------------

   procedure Up_Wf_Aggregate
     (Node    : in     STree.SyntaxNode;
      Scope   : in     Dictionary.Scopes;
      E_Stack : in out Exp_Stack.Exp_Stack_Type)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in     STree.Table;
   --#        in out Aggregate_Stack.State;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --# derives Aggregate_Stack.State,
   --#         E_Stack                    from Aggregate_Stack.State,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table &
   --#         ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from Aggregate_Stack.State,
   --#                                         CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table;
   --# pre (STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.aggregate or
   --#        STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.extension_aggregate or
   --#        STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_aggregate or
   --#        STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_extension_aggregate) and
   --#   Aggregate_Stack.Stack_Is_Valid (Aggregate_Stack.State);
   --# post Aggregate_Stack.Stack_Is_Valid (Aggregate_Stack.State);
      is separate;

   -----------------------------------------------------------------

   procedure Wf_Aggregate_Choice_Rep
     (Node       : in     STree.SyntaxNode;
      Scope      : in     Dictionary.Scopes;
      E_Stack    : in out Exp_Stack.Exp_Stack_Type;
      Heap_Param : in out Lists.List_Heap;
      Next_Node  :    out STree.SyntaxNode)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --#        in out STree.Table;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         E_Stack,
   --#                                         Heap_Param,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table &
   --#         E_Stack,
   --#         Heap_Param,
   --#         STree.Table                from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         Heap_Param,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table &
   --#         Next_Node                  from Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         Node,
   --#                                         STree.Table;
   --# pre STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.aggregate_choice_rep or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_aggregate_choice_rep;
   --# post (STree.Syntax_Node_Type (Next_Node, STree.Table) = SP_Symbols.aggregate_choice_rep or
   --#         STree.Syntax_Node_Type (Next_Node, STree.Table) = SP_Symbols.aggregate_choice or
   --#         STree.Syntax_Node_Type (Next_Node, STree.Table) = SP_Symbols.annotation_aggregate_choice_rep or
   --#         STree.Syntax_Node_Type (Next_Node, STree.Table) = SP_Symbols.annotation_aggregate_choice or
   --#         Next_Node = STree.NullNode) and
   --#   STree.Table = STree.Table~;
      is separate;

   -----------------------------------------------------------------

   procedure Wf_Record_Component_Selector_Name
     (Node       : in     STree.SyntaxNode;
      Scope      : in     Dictionary.Scopes;
      E_Stack    : in out Exp_Stack.Exp_Stack_Type;
      Heap_Param : in out Lists.List_Heap)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --#        in out STree.Table;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         E_Stack,
   --#                                         Heap_Param,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table &
   --#         E_Stack,
   --#         Heap_Param                 from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         Heap_Param,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table &
   --#         STree.Table                from *,
   --#                                         CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope;
   --# pre STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.record_component_selector_name;
   --# post STree.Table = STree.Table~;
      is separate;

   -----------------------------------------------------------------

   procedure Down_Wf_Aggregate_Or_Expression
     (Node      : in     STree.SyntaxNode;
      E_Stack   : in out Exp_Stack.Exp_Stack_Type;
      Next_Node :    out STree.SyntaxNode)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in     STree.Table;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table &
   --#         E_Stack,
   --#         Next_Node                  from Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         Node,
   --#                                         STree.Table;
   --# pre STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.aggregate_or_expression or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_aggregate_or_expression;
   --# post STree.Syntax_Node_Type (Next_Node, STree.Table) = SP_Symbols.aggregate or
   --#   STree.Syntax_Node_Type (Next_Node, STree.Table) = SP_Symbols.expression or
   --#   STree.Syntax_Node_Type (Next_Node, STree.Table) = SP_Symbols.annotation_aggregate or
   --#   STree.Syntax_Node_Type (Next_Node, STree.Table) = SP_Symbols.annotation_expression  or
   --#   Next_Node = STree.NullNode;
      is separate;

   -------------------------------------------------------------------

   procedure Up_Wf_Aggregate_Or_Expression
     (Node    : in out STree.SyntaxNode;
      Scope   : in     Dictionary.Scopes;
      E_Stack : in out Exp_Stack.Exp_Stack_Type)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in out Aggregate_Stack.State;
   --#        in out ErrorHandler.Error_Context;
   --#        in out LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out STree.Table;
   --# derives Aggregate_Stack.State,
   --#         LexTokenManager.State,
   --#         Node,
   --#         STree.Table                from *,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         Node,
   --#                                         STree.Table &
   --#         ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table &
   --#         E_Stack                    from *,
   --#                                         Dictionary.Dict,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table;
   --# pre (STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.aggregate_or_expression or
   --#        STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_aggregate_or_expression) and
   --#   Aggregate_Stack.Stack_Is_Valid (Aggregate_Stack.State);
   --# post STree.Table = STree.Table~ and
   --#   Aggregate_Stack.Stack_Is_Valid (Aggregate_Stack.State);
      is separate;

   ---------------------------------------------------------------------------------
   -- The type context needed for an attribute with arguments (i.e. 'Val, 'Max etc)
   -- depends on the Prefix and the attribute identifier.  Some attributes have two
   -- arguments, so we need a special handler here, since an attribute_designator
   -- node is the closent common parent node of one or both arguments.
   ---------------------------------------------------------------------------------

   function Attribute_Designator_Type_From_Context
     (Exp_Node : STree.SyntaxNode;
      E_Stack  : Exp_Stack.Exp_Stack_Type;
      T_Stack  : Type_Context_Stack.T_Stack_Type)
     return     Dictionary.Symbol
   --# global in Dictionary.Dict;
   --#        in LexTokenManager.State;
   --#        in STree.Table;
   --# pre STree.Syntax_Node_Type (Exp_Node, STree.Table) = SP_Symbols.attribute_designator or
   --#   STree.Syntax_Node_Type (Exp_Node, STree.Table) = SP_Symbols.annotation_attribute_designator;
      is separate;

   ---------------------------------------------------------------------------------
   -- range constraints appear below aggregate_choice, case_choice, and below
   -- relational operators, and so can have a chage of type context.
   ---------------------------------------------------------------------------------

   function Range_Constraint_Type_From_Context
     (Exp_Node : STree.SyntaxNode;
      E_Stack  : Exp_Stack.Exp_Stack_Type;
      T_Stack  : Type_Context_Stack.T_Stack_Type)
     return     Dictionary.Symbol
   --# global in STree.Table;
   --# pre STree.Syntax_Node_Type (Exp_Node, STree.Table) = SP_Symbols.range_constraint or
   --#   STree.Syntax_Node_Type (Exp_Node, STree.Table) = SP_Symbols.annotation_range_constraint;
      is separate;

   ---------------------------------------------------------------------------------
   -- Simple expressions appear below aggregate_choice, case_choice, and below
   -- relational operators, and so can have a chage of type context.
   ---------------------------------------------------------------------------------

   function Simple_Expression_Type_From_Context
     (Exp_Node : STree.SyntaxNode;
      T_Stack  : Type_Context_Stack.T_Stack_Type)
     return     Dictionary.Symbol
   --# global in Aggregate_Stack.State;
   --#        in Dictionary.Dict;
   --#        in STree.Table;
   --# pre STree.Syntax_Node_Type (Exp_Node, STree.Table) = SP_Symbols.simple_expression or
   --#   STree.Syntax_Node_Type (Exp_Node, STree.Table) = SP_Symbols.annotation_simple_expression;
      is separate;

   ---------------------------------------------------------------------------------
   -- Returns the type needed for an expression from its context
   ---------------------------------------------------------------------------------

   procedure Expression_Type_From_Context
     (Exp_Node         : in     STree.SyntaxNode;
      E_Stack          : in     Exp_Stack.Exp_Stack_Type;
      T_Stack          : in     Type_Context_Stack.T_Stack_Type;
      New_Context_Type :    out Dictionary.Symbol)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in out STree.Table;
   --# derives New_Context_Type from CommandLineData.Content,
   --#                               Dictionary.Dict,
   --#                               Exp_Node,
   --#                               E_Stack,
   --#                               LexTokenManager.State,
   --#                               STree.Table,
   --#                               T_Stack &
   --#         STree.Table      from *,
   --#                               CommandLineData.Content,
   --#                               Dictionary.Dict,
   --#                               Exp_Node,
   --#                               E_Stack,
   --#                               LexTokenManager.State;
   --# pre STree.Syntax_Node_Type (Exp_Node, STree.Table) = SP_Symbols.expression or
   --#   STree.Syntax_Node_Type (Exp_Node, STree.Table) = SP_Symbols.annotation_expression;
   --# post STree.Table = STree.Table~;
      is separate;

   ---------------------------------------------------------------------------------
   -- Primary grammer productions nearly always have the same type context
   -- as their parent nodes, but there is a single exception - when a primary
   -- node is the right-hand operand of an exponentiation operator, where the
   -- context is always Integer.
   ---------------------------------------------------------------------------------

   function Primary_Type_From_Context
     (Node    : STree.SyntaxNode;
      T_Stack : Type_Context_Stack.T_Stack_Type)
     return    Dictionary.Symbol
   --# global in Dictionary.Dict;
   --#        in STree.Table;
   --# pre STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.primary or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_primary;
      is separate;

   -----------------------------------------------------------------

   procedure Wf_Expression
     (Node    : in     STree.SyntaxNode;
      Scope   : in     Dictionary.Scopes;
      E_Stack : in out Exp_Stack.Exp_Stack_Type;
      T_Stack : in     Type_Context_Stack.T_Stack_Type)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --#        in out STree.Table;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table,
   --#                                         T_Stack &
   --#         E_Stack,
   --#         STree.Table                from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table,
   --#                                         T_Stack;
   --# pre STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.expression or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.expression_rep1 or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.expression_rep2 or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.expression_rep3 or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.expression_rep4 or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.expression_rep5 or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_expression or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_expression_rep1 or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_expression_rep2 or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_expression_rep3 or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_expression_rep4 or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_expression_rep5 or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_expression_rep6 or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_expression_rep7;
   --# post STree.Table = STree.Table~;
      is separate;

   -----------------------------------------------------------------

   procedure Wf_Simple_Expression
     (Node                    : in     STree.SyntaxNode;
      Scope                   : in     Dictionary.Scopes;
      E_Stack                 : in out Exp_Stack.Exp_Stack_Type;
      T_Stack                 : in     Type_Context_Stack.T_Stack_Type;
      Context_Requires_Static : in     Boolean)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in out ErrorHandler.Error_Context;
   --#        in out LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out STree.Table;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Context_Requires_Static,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table,
   --#                                         T_Stack &
   --#         E_Stack                    from *,
   --#                                         CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table,
   --#                                         T_Stack &
   --#         LexTokenManager.State      from *,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         Node,
   --#                                         STree.Table &
   --#         STree.Table                from *,
   --#                                         CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         Node,
   --#                                         Scope,
   --#                                         T_Stack;
   --# pre STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.simple_expression or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_simple_expression;
   --# post STree.Table = STree.Table~;
      is separate;

   -----------------------------------------------------------------

   procedure Wf_Simple_Expression_Opt
     (Node    : in     STree.SyntaxNode;
      Scope   : in     Dictionary.Scopes;
      E_Stack : in out Exp_Stack.Exp_Stack_Type;
      T_Stack : in     Type_Context_Stack.T_Stack_Type)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --#        in out STree.Table;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table,
   --#                                         T_Stack &
   --#         E_Stack                    from *,
   --#                                         CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table,
   --#                                         T_Stack &
   --#         STree.Table                from *,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         Node,
   --#                                         T_Stack;
   --# pre STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.simple_expression_opt or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_simple_expression_opt;
   --# post STree.Table = STree.Table~;
      is separate;

   -----------------------------------------------------------------

   procedure Wf_Term
     (Node                    : in     STree.SyntaxNode;
      Scope                   : in     Dictionary.Scopes;
      E_Stack                 : in out Exp_Stack.Exp_Stack_Type;
      T_Stack                 : in     Type_Context_Stack.T_Stack_Type;
      Context_Requires_Static : in     Boolean)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --#        in out STree.Table;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Context_Requires_Static,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table,
   --#                                         T_Stack &
   --#         E_Stack                    from *,
   --#                                         CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table,
   --#                                         T_Stack &
   --#         STree.Table                from *,
   --#                                         CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         Node,
   --#                                         Scope,
   --#                                         T_Stack;
   --# pre STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.term or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_term;
   --# post STree.Table = STree.Table~;
      is separate;

   -----------------------------------------------------------------

   procedure Wf_Factor
     (Node    : in     STree.SyntaxNode;
      Scope   : in     Dictionary.Scopes;
      E_Stack : in out Exp_Stack.Exp_Stack_Type;
      T_Stack : in     Type_Context_Stack.T_Stack_Type)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --#        in out STree.Table;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table,
   --#                                         T_Stack &
   --#         E_Stack                    from *,
   --#                                         CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table,
   --#                                         T_Stack &
   --#         STree.Table                from *,
   --#                                         CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         Node,
   --#                                         Scope,
   --#                                         T_Stack;
   --# pre STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.factor or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_factor;
   --# post STree.Table = STree.Table~;
      is separate;

   -----------------------------------------------------------------

   procedure Wf_Relation
     (Node    : in     STree.SyntaxNode;
      Scope   : in     Dictionary.Scopes;
      E_Stack : in out Exp_Stack.Exp_Stack_Type;
      T_Stack : in     Type_Context_Stack.T_Stack_Type)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --#        in out STree.Table;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table,
   --#                                         T_Stack &
   --#         E_Stack                    from *,
   --#                                         CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table,
   --#                                         T_Stack &
   --#         STree.Table                from *,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope;
   --# pre STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.relation or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_relation;
   --# post STree.Table = STree.Table~;
      is separate;

   -----------------------------------------------------------------

   procedure Wf_Arange
     (Node    : in     STree.SyntaxNode;
      Scope   : in     Dictionary.Scopes;
      E_Stack : in out Exp_Stack.Exp_Stack_Type)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in     STree.Table;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table &
   --#         E_Stack                    from *,
   --#                                         Dictionary.Dict,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table;
   --# pre STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.arange or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_arange;
      is separate;

   -----------------------------------------------------------------

   procedure Wf_Selected_Component
     (Node           : in     STree.SyntaxNode;
      Scope          : in     Dictionary.Scopes;
      Ref_Var        : in     SeqAlgebra.Seq;
      E_Stack        : in out Exp_Stack.Exp_Stack_Type;
      Component_Data : in out ComponentManager.ComponentData;
      The_Heap       : in out Heap.HeapRecord;
      Context        : in     Sem.Tilde_Context)
   --# global in     CommandLineData.Content;
   --#        in     ContextManager.Ops.File_Heap;
   --#        in     ContextManager.Ops.Unit_Heap;
   --#        in     ContextManager.Ops.Unit_Stack;
   --#        in     LexTokenManager.State;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SLI.State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out Statistics.TableUsage;
   --#        in out STree.Table;
   --# derives Component_Data             from *,
   --#                                         ContextManager.Ops.Unit_Stack,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table,
   --#                                         The_Heap &
   --#         Dictionary.Dict,
   --#         STree.Table                from CommandLineData.Content,
   --#                                         Component_Data,
   --#                                         ContextManager.Ops.Unit_Stack,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table,
   --#                                         The_Heap &
   --#         ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Component_Data,
   --#                                         Context,
   --#                                         ContextManager.Ops.File_Heap,
   --#                                         ContextManager.Ops.Unit_Heap,
   --#                                         ContextManager.Ops.Unit_Stack,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         SLI.State,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table,
   --#                                         The_Heap &
   --#         E_Stack                    from *,
   --#                                         CommandLineData.Content,
   --#                                         Component_Data,
   --#                                         Context,
   --#                                         ContextManager.Ops.Unit_Stack,
   --#                                         Dictionary.Dict,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table,
   --#                                         The_Heap &
   --#         SLI.State                  from *,
   --#                                         CommandLineData.Content,
   --#                                         Component_Data,
   --#                                         ContextManager.Ops.Unit_Heap,
   --#                                         ContextManager.Ops.Unit_Stack,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table,
   --#                                         The_Heap &
   --#         Statistics.TableUsage,
   --#         The_Heap                   from *,
   --#                                         CommandLineData.Content,
   --#                                         Component_Data,
   --#                                         ContextManager.Ops.Unit_Stack,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Ref_Var,
   --#                                         Scope,
   --#                                         STree.Table,
   --#                                         The_Heap;
   --# pre (STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.selected_component or
   --#        STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_selected_component) and
   --#   ((STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_selected_component) ->
   --#      (Context in Sem.Anno_Tilde_Context));
   --# post STree.Table = STree.Table~;
      is separate;

   -----------------------------------------------------------------------

   procedure Wf_Attribute (E_Stack : in out Exp_Stack.Exp_Stack_Type)
   --# global in CommandLineData.Content;
   --#        in Dictionary.Dict;
   --# derives E_Stack from *,
   --#                      Dictionary.Dict &
   --#         null    from CommandLineData.Content;
      is separate;

   -----------------------------------------------------------------------

   procedure Wf_Attribute_Designator
     (Node     : in     STree.SyntaxNode;
      Scope    : in     Dictionary.Scopes;
      E_Stack  : in out Exp_Stack.Exp_Stack_Type;
      The_Heap : in out Heap.HeapRecord;
      Ref_Var  : in     SeqAlgebra.Seq)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --#        in out Statistics.TableUsage;
   --#        in out STree.Table;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table &
   --#         E_Stack,
   --#         STree.Table                from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table &
   --#         Statistics.TableUsage,
   --#         The_Heap                   from *,
   --#                                         CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Ref_Var,
   --#                                         Scope,
   --#                                         STree.Table,
   --#                                         The_Heap;
   --# pre STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.attribute_designator or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_attribute_designator;
   --# post STree.Table = STree.Table~;
      is separate;

   -----------------------------------------------------------------------

   procedure Wf_Primary
     (Node           : in     STree.SyntaxNode;
      Scope          : in     Dictionary.Scopes;
      Ref_Var        : in     SeqAlgebra.Seq;
      E_Stack        : in out Exp_Stack.Exp_Stack_Type;
      Component_Data : in out ComponentManager.ComponentData;
      The_Heap       : in out Heap.HeapRecord)
   --# global in     CommandLineData.Content;
   --#        in     ContextManager.Ops.Unit_Stack;
   --#        in     LexTokenManager.State;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --#        in out Statistics.TableUsage;
   --#        in out STree.Table;
   --# derives Component_Data,
   --#         Dictionary.Dict            from Component_Data,
   --#                                         ContextManager.Ops.Unit_Stack,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         Node,
   --#                                         STree.Table,
   --#                                         The_Heap &
   --#         ErrorHandler.Error_Context from *,
   --#                                         CommandLineData.Content,
   --#                                         Component_Data,
   --#                                         ContextManager.Ops.Unit_Stack,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table &
   --#         E_Stack                    from *,
   --#                                         ContextManager.Ops.Unit_Stack,
   --#                                         Dictionary.Dict,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table &
   --#         SPARK_IO.File_Sys          from *,
   --#                                         CommandLineData.Content,
   --#                                         Component_Data,
   --#                                         ContextManager.Ops.Unit_Stack,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table,
   --#                                         The_Heap &
   --#         Statistics.TableUsage,
   --#         The_Heap                   from *,
   --#                                         Component_Data,
   --#                                         ContextManager.Ops.Unit_Stack,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         Node,
   --#                                         Ref_Var,
   --#                                         STree.Table,
   --#                                         The_Heap &
   --#         STree.Table                from *,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         Node,
   --#                                         Scope;
   --# pre STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.primary or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_primary;
   --# post STree.Table = STree.Table~;
      is separate;

   -----------------------------------------------------------------------

   procedure Wf_Positional_Argument_Association
     (Node           : in out STree.SyntaxNode;
      Scope          : in     Dictionary.Scopes;
      Ref_Var        : in     SeqAlgebra.Seq;
      E_Stack        : in out Exp_Stack.Exp_Stack_Type;
      Component_Data : in out ComponentManager.ComponentData;
      The_Heap       : in out Heap.HeapRecord)
   --# global in     CommandLineData.Content;
   --#        in     ContextManager.Ops.Unit_Stack;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.Error_Context;
   --#        in out LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out Statistics.TableUsage;
   --#        in out STree.Table;
   --# derives Component_Data             from *,
   --#                                         ContextManager.Ops.Unit_Stack,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         Node,
   --#                                         STree.Table,
   --#                                         The_Heap &
   --#         Dictionary.Dict            from *,
   --#                                         Component_Data,
   --#                                         ContextManager.Ops.Unit_Stack,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table,
   --#                                         The_Heap &
   --#         ErrorHandler.Error_Context from *,
   --#                                         CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table &
   --#         E_Stack                    from *,
   --#                                         CommandLineData.Content,
   --#                                         Component_Data,
   --#                                         ContextManager.Ops.Unit_Stack,
   --#                                         Dictionary.Dict,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table,
   --#                                         The_Heap &
   --#         LexTokenManager.State      from *,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table &
   --#         Node                       from *,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         STree.Table &
   --#         SPARK_IO.File_Sys          from *,
   --#                                         CommandLineData.Content,
   --#                                         ContextManager.Ops.Unit_Stack,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table &
   --#         Statistics.TableUsage,
   --#         The_Heap                   from *,
   --#                                         Component_Data,
   --#                                         ContextManager.Ops.Unit_Stack,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         Node,
   --#                                         Ref_Var,
   --#                                         STree.Table,
   --#                                         The_Heap &
   --#         STree.Table                from *,
   --#                                         ContextManager.Ops.Unit_Stack,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope;
   --# pre STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.positional_argument_association or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_positional_argument_association;
   --# post (STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.positional_argument_association or
   --#         STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_positional_argument_association or
   --#         STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.name_argument_list or
   --#         STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_name_argument_list) and
   --#   STree.Table = STree.Table~;
      is separate;

   ----------------------------------------------------------------------

   procedure Wf_Named_Argument_Association
     (Node       : in     STree.SyntaxNode;
      Scope      : in     Dictionary.Scopes;
      E_Stack    : in out Exp_Stack.Exp_Stack_Type;
      Heap_Param : in out Lists.List_Heap)
   --# global in     CommandLineData.Content;
   --#        in     ContextManager.Ops.Unit_Stack;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.Error_Context;
   --#        in out LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out STree.Table;
   --# derives Dictionary.Dict,
   --#         STree.Table                from ContextManager.Ops.Unit_Stack,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         Heap_Param,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table &
   --#         ErrorHandler.Error_Context from *,
   --#                                         CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         Heap_Param,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table &
   --#         E_Stack,
   --#         LexTokenManager.State      from Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         Heap_Param,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table &
   --#         Heap_Param                 from *,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         STree.Table &
   --#         SPARK_IO.File_Sys          from *,
   --#                                         CommandLineData.Content,
   --#                                         ContextManager.Ops.Unit_Stack,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         E_Stack,
   --#                                         Heap_Param,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table;
   --# pre STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.named_argument_association or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_named_argument_association;
   --# post STree.Table = STree.Table~;
      is separate;

   -----------------------------------------------------------------

   procedure Wf_Ancestor_Part
     (Node       : in out STree.SyntaxNode;
      Scope      : in     Dictionary.Scopes;
      E_Stack    : in out Exp_Stack.Exp_Stack_Type;
      Heap_Param : in out Lists.List_Heap)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --#        in out STree.Table;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table &
   --#         E_Stack,
   --#         Heap_Param                 from Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         Heap_Param,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table &
   --#         Node                       from *,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         Scope,
   --#                                         STree.Table &
   --#         STree.Table                from *,
   --#                                         E_Stack,
   --#                                         Node;
   --# pre STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.ancestor_part or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_ancestor_part;
   --# post STree.Table = STree.Table~ and
   --#   (STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.ancestor_part or
   --#      STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_ancestor_part or
   --#      STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.extension_aggregate or
   --#      STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_extension_aggregate or
   --#      STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.qualified_expression or
   --#      STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_qualified_expression);
      is separate;

   -----------------------------------------------------------------

   procedure Wf_Aggregate_Choice
     (Node    : in     STree.SyntaxNode;
      Scope   : in     Dictionary.Scopes;
      E_Stack : in out Exp_Stack.Exp_Stack_Type)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in     STree.Table;
   --#        in out Aggregate_Stack.State;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --# derives Aggregate_Stack.State      from *,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table &
   --#         ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from Aggregate_Stack.State,
   --#                                         CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table &
   --#         E_Stack                    from *,
   --#                                         Dictionary.Dict,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table;
   --# pre (STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.aggregate_choice or
   --#        STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_aggregate_choice) and
   --#   Aggregate_Stack.Stack_Is_Valid (Aggregate_Stack.State);
   --# post Aggregate_Stack.Stack_Is_Valid (Aggregate_Stack.State);
      is separate;

   -----------------------------------------------------------------

   procedure Wf_Named_Association_Rep
     (Node       : in     STree.SyntaxNode;
      Scope      : in     Dictionary.Scopes;
      E_Stack    : in out Exp_Stack.Exp_Stack_Type;
      Heap_Param : in out Lists.List_Heap)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in out ErrorHandler.Error_Context;
   --#        in out LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out STree.Table;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         E_Stack,
   --#                                         Heap_Param,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table &
   --#         E_Stack,
   --#         Heap_Param                 from Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         Heap_Param,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table &
   --#         LexTokenManager.State,
   --#         STree.Table                from *,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         Node,
   --#                                         STree.Table;
   --# pre STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.named_association_rep or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_named_association_rep;
   --# post STree.Table = STree.Table~;
      is separate;

   -----------------------------------------------------------------

   procedure Wf_Named_Record_Component_Association
     (Node       : in     STree.SyntaxNode;
      Scope      : in     Dictionary.Scopes;
      E_Stack    : in out Exp_Stack.Exp_Stack_Type;
      Heap_Param : in out Lists.List_Heap)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in out ErrorHandler.Error_Context;
   --#        in out LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out STree.Table;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         E_Stack,
   --#                                         Heap_Param,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table &
   --#         E_Stack,
   --#         Heap_Param                 from Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         Heap_Param,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table &
   --#         LexTokenManager.State      from *,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack &
   --#         STree.Table                from *,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         Node;
   --# pre STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.named_record_component_association or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_named_record_component_association;
   --# post STree.Table = STree.Table~;
      is separate;

   -----------------------------------------------------------------

   procedure Wf_Positional_Association (Node    : in     STree.SyntaxNode;
                                        E_Stack : in out Exp_Stack.Exp_Stack_Type)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in     STree.Table;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table &
   --#         E_Stack                    from *,
   --#                                         Dictionary.Dict,
   --#                                         Node,
   --#                                         STree.Table;
   --# pre STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.positional_association or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.record_component_association or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_positional_association or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_record_component_association;
      is separate;

   -----------------------------------------------------------------

   procedure Wf_Positional_Record_Component_Association
     (Node    : in out STree.SyntaxNode;
      Scope   : in     Dictionary.Scopes;
      E_Stack : in out Exp_Stack.Exp_Stack_Type)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in out ErrorHandler.Error_Context;
   --#        in out LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out STree.Table;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table &
   --#         E_Stack                    from *,
   --#                                         Dictionary.Dict,
   --#                                         LexTokenManager.State,
   --#                                         Scope &
   --#         LexTokenManager.State      from *,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack &
   --#         Node,
   --#         STree.Table                from Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         Node,
   --#                                         STree.Table;
   --# pre STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.positional_record_component_association or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_positional_record_component_association;
   --# post (STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.positional_record_component_association or
   --#         STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_positional_record_component_association or
   --#         STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_record_component_association or
   --#         STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.record_component_association) and
   --#   STree.Table = STree.Table~;
      is separate;

   -----------------------------------------------------------------

   procedure Wf_Component_Association
     (Node    : in     STree.SyntaxNode;
      Scope   : in     Dictionary.Scopes;
      E_Stack : in out Exp_Stack.Exp_Stack_Type)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in out ErrorHandler.Error_Context;
   --#        in out LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out STree.Table;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table &
   --#         E_Stack                    from *,
   --#                                         Dictionary.Dict,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table &
   --#         LexTokenManager.State,
   --#         STree.Table                from *,
   --#                                         Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         Node,
   --#                                         STree.Table;
   --# pre STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.component_association or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_component_association;
   --# post STree.Table = STree.Table~;
      is separate;

   -----------------------------------------------------------------

   procedure Wf_Qualified_Expression
     (Node    : in     STree.SyntaxNode;
      Scope   : in     Dictionary.Scopes;
      E_Stack : in out Exp_Stack.Exp_Stack_Type)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     STree.Table;
   --#        in out ErrorHandler.Error_Context;
   --#        in out LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         SPARK_IO.File_Sys,
   --#                                         STree.Table &
   --#         E_Stack,
   --#         LexTokenManager.State      from Dictionary.Dict,
   --#                                         E_Stack,
   --#                                         LexTokenManager.State,
   --#                                         Node,
   --#                                         Scope,
   --#                                         STree.Table;
   --# pre STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.qualified_expression or
   --#   STree.Syntax_Node_Type (Node, STree.Table) = SP_Symbols.annotation_qualified_expression;
      is separate;

   -------------------------------------------------------------------

   procedure Walk_Expression
     (Exp_Node                : in     STree.SyntaxNode;
      Scope                   : in     Dictionary.Scopes;
      Type_Context            : in     Dictionary.Symbol;
      Context_Requires_Static : in     Boolean;
      Ref_Var                 : in     SeqAlgebra.Seq;
      Result                  :    out Sem.Exp_Record;
      Component_Data          : in out ComponentManager.ComponentData;
      The_Heap                : in out Heap.HeapRecord) is separate;

   -----------------------------------------------------------------

   procedure Walk_Annotation_Expression
     (Exp_Node       : in     STree.SyntaxNode;
      Scope          : in     Dictionary.Scopes;
      Type_Context   : in     Dictionary.Symbol;
      Context        : in     Sem.Anno_Tilde_Context;
      Result         :    out Sem.Exp_Record;
      Component_Data : in out ComponentManager.ComponentData;
      The_Heap       : in out Heap.HeapRecord) is separate;

end Walk_Expression_P;
