-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Dictionary)
procedure WriteName (File : in SPARK_IO.File_Type;
                     Item : in Symbol) is
   Local_Item : Symbol;

   procedure Write_Prefix (File : in SPARK_IO.File_Type;
                           Item : in Symbol)
   --# global in     Dict;
   --#        in     LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Dict,
   --#                                File,
   --#                                Item,
   --#                                LexTokenManager.State;
   is

      Prefix, Name : E_Strings.T;
      Region       : Symbol;
      Scope        : Scopes;

      function Append_Name (Prefix, Suffix : E_Strings.T) return E_Strings.T is
         Name : E_Strings.T;
      begin
         Name := Prefix;
         E_Strings.Append_String (E_Str => Name,
                                  Str   => ".");
         E_Strings.Append_Examiner_String (E_Str1 => Name,
                                           E_Str2 => Suffix);
         return Name;
      end Append_Name;

   begin
      Prefix := E_Strings.Empty_String;
      if Item /= GetPredefinedPackageStandard then -- don't try and get a prefix for this!
         Scope := GetScope (Item);
         loop
            Region := GetRegion (Scope);
            exit when Region = GetPredefinedPackageStandard;
            GenerateSimpleName (Region, ".", Name);
            Prefix := Append_Name (Prefix => Name,
                                   Suffix => Prefix);
            Scope  := GetEnclosingScope (Scope);
         end loop;
      end if;
      E_Strings.Put_String (File  => File,
                            E_Str => Prefix);
   end Write_Prefix; -- Init of Prefix is partial but effective.

begin
   Local_Item := Item;

   if IsType (Local_Item) and then TypeIsAccess (Local_Item) then
      SPARK_IO.Put_String (File, "access ", 0);
      Local_Item := DeReference (Local_Item);
   end if;

   if not IsUnknownTypeMark (Item) then
      Write_Prefix (File => File,
                    Item => Local_Item);
   end if;
   Write_Simple_Name (File => File,
                      Item => Local_Item);
end WriteName;
