-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with E_Strings;

--# inherit E_Strings,
--#         SparkMakeDebug,
--#         SPARK_IO,
--#         SystemErrors,
--#         Version;

package SparkMakeErrors is

   type Fault is (
                  Duplicate_Errors,
                  Invalid_Switch,
                  Duplicate_Switch,
                  Invalid_Argument,
                  Cannot_Find_File,
                  Cannot_Open_File,
                  Cannot_Close_File,
                  -- Items above this line are errors, items below are warnings.
                  -- See subtypes in package body.
                  Multiple_Main_Programs,
                  Duplicate_Okay,
                  Invalid_Unit);

   procedure Report
     (The_Fault : in Fault;
      E_Str1    : in E_Strings.T;
      E_Str2    : in E_Strings.T;
      E_Str3    : in E_Strings.T);
   --# global in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                E_Str1,
   --#                                E_Str2,
   --#                                E_Str3,
   --#                                The_Fault;

   procedure Fatal (Text : in String);
   --# global in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Text;

end SparkMakeErrors;
