/*
 * This is the DECtalk PC register constants (from DEC's DOS driver)
 *
 * Original code:
 *      Copyright (c) by Digital Equipment Corp.
 *
 * 386BSD DECtalk PC driver:
 *      Copyright (c) 1996 Brian Buhrow <buhrow@lothlorien.nfbcal.org>
 *
 * Linux DECtalk PC driver:
 *      Copyright (c) 1997 Nicolas Pitre <nico@cam.org>
 *
 * speakup DECtalk PC driver:
 *      Copyright (c) 2003 David Borowski <david575@golden.net>
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 *  port interface defs ... used by dtpc.c
 */

#define	MODULE_init		0x0dec		/* module in boot code */			
#define	MODULE_self_test	0x8800		/* module in self-test */
#define	MODULE_reset		0xffff		/* reinit the whole module */

#define	MODE_mask		0xf000		/* mode bits in high nibble */
#define	MODE_null		0x0000
#define	MODE_test		0x2000		/* in testing mode */
#define	MODE_status		0x8000
#define	STAT_int		0x0001		/* running in interrupt mode */
#define	STAT_tr_char	0x0002		/* character data to transmit */
#define	STAT_rr_char	0x0004		/* ready to receive char data */
#define	STAT_cmd_ready	0x0008		/* ready to accept commands */
#define	STAT_dma_ready	0x0010		/* dma command ready */
#define	STAT_digitized	0x0020		/* spc in digitized mode */
#define	STAT_new_index	0x0040		/* new last index ready */
#define	STAT_new_status	0x0080		/* new status posted */
#define	STAT_dma_state	0x0100		/* dma state toggle */
#define	STAT_index_valid	0x0200		/* indexs are valid */
#define	STAT_flushing	0x0400		/* flush in progress */
#define	STAT_self_test	0x0800		/* module in self test */
#define	MODE_ready		0xc000		/* module ready for next phase */
#define	READY_boot		0x0000				
#define	READY_kernel	0x0001		
#define	MODE_error		0xf000

#define	CMD_mask			0xf000		/* mask for command nibble */
#define	CMD_null			0x0000		/* post status */
#define	CMD_control		0x1000		/* hard control command */
#define	CTRL_mask		0x0F00	/*   mask off control nibble */
#define	CTRL_data		0x00FF	/*   madk to get data byte */
#define	CTRL_null		0x0000	/*   null control */
#define	CTRL_vol_up		0x0100	/*   increase volume */
#define	CTRL_vol_down		0x0200	/*   decrease volume */
#define	CTRL_vol_set		0x0300	/*   set volume */
#define	CTRL_pause		0x0400	/*   pause spc */
#define	CTRL_resume		0x0500	/*   resume spc clock */
#define	CTRL_resume_spc		0x0001	/*   resume spc soft pause */
#define	CTRL_flush		0x0600	/*   flush all buffers */
#define	CTRL_int_enable	0x0700	/*   enable status change ints */
#define	CTRL_buff_free		0x0800	/*   buffer remain count */
#define	CTRL_buff_used		0x0900	/*   buffer in use */
#define	CTRL_speech		0x0a00	/*   immediate speech change */
#define		CTRL_SP_voice		0x0001	/*      voice change */
#define		CTRL_SP_rate		0x0002	/*      rate change */
#define		CTRL_SP_comma		0x0003	/*      comma pause change */
#define		CTRL_SP_period		0x0004	/*      period pause change */
#define		CTRL_SP_rate_delta	0x0005	/*	  delta rate change */
#define		CTRL_SP_get_param	0x0006	/*      return the desired parameter */
#define	CTRL_last_index	0x0b00	/*   get last index spoken */
#define	CTRL_io_priority	0x0c00	/*   change i/o priority */
#define	CTRL_free_mem		0x0d00	/*   get free paragraphs on module */
#define	CTRL_get_lang		0x0e00	/*   return bit mask of loaded languages */
#define	CMD_test			0x2000		/* self-test request */
#define	TEST_mask		0x0F00	/* isolate test field */
#define	TEST_null		0x0000	/* no test requested */
#define	TEST_isa_int		0x0100	/* assert isa irq */
#define	TEST_echo		0x0200	/* make data in == data out */
#define	TEST_seg			0x0300	/* set peek/poke segment */
#define	TEST_off			0x0400	/* set peek/poke offset */
#define	TEST_peek		0x0500	/* data out == *peek */
#define	TEST_poke		0x0600	/* *peek == data in */
#define	TEST_sub_code		0x00FF	/* user defined test sub codes */
#define	CMD_id			0x3000		/* return software id */
#define	ID_null			0x0000	/* null id */
#define	ID_kernel		0x0100	/* kernel code executing */
#define	ID_boot			0x0200	/* boot code executing */
#define	CMD_dma			0x4000		/* force a dma start */
#define	CMD_reset		0x5000		/* reset module status */
#define	CMD_sync			0x6000		/* kernel sync command */
#define	CMD_char_in		0x7000		/* single character send */
#define	CMD_char_out		0x8000		/* single character get */
#define	CHAR_count_1		0x0100	/*    one char in cmd_low */
#define	CHAR_count_2		0x0200	/*	the second in data_low */
#define	CHAR_count_3		0x0300	/*	the third in data_high */
#define	CMD_spc_mode		0x9000		/* change spc mode */
#define	CMD_spc_to_text	0x0100	/*   set to text mode */
#define	CMD_spc_to_digit	0x0200	/*   set to digital mode */
#define	CMD_spc_rate		0x0400	/*   change spc data rate */
#define	CMD_error		0xf000		/* severe error */

enum {	PRIMARY_DIC	= 0, USER_DIC, COMMAND_DIC, ABBREV_DIC };

#define	DMA_single_in		0x01
#define	DMA_single_out		0x02
#define	DMA_buff_in		0x03
#define	DMA_buff_out		0x04
#define	DMA_control		0x05
#define	DT_MEM_ALLOC		0x03
#define	DT_SET_DIC		0x04
#define	DT_START_TASK		0x05
#define	DT_LOAD_MEM		0x06
#define	DT_READ_MEM		0x07
#define	DT_DIGITAL_IN		0x08
#define	DMA_sync		0x06
#define	DMA_sync_char		0x07
