#ifndef __PATCH_LIST__
#define __PATCH_LIST__

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define PATCH_LIST_TYPE (patch_list_get_type())
#define PATCH_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PATCH_LIST_TYPE, PatchList))
#define PATCH_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PATCH_LIST_TYPE, PatchListClass))
#define IS_PATCH_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PATCH_LIST_TYPE))
#define IS_PATCH_LIST_CLASS(klass) (G_TYPE_CHECK_INSTANCE_TYPE ((klass), PATCH_LIST_TYPE))

typedef struct _PatchListClass PatchListClass;
typedef struct _PatchList PatchList;

struct _PatchList
{
    GtkHBox parent;

    /*< private >*/
    GtkWidget* patch_tree;
    GtkListStore* patch_store;
    GtkWidget* vscroll;
    GtkTreeSelection* select;
    int patch;
};

struct _PatchListClass
{
    GtkHBoxClass parent_class;

    /*< private >*/
    void (*changed)(PatchList* self);
};

GType patch_list_get_type(void);
GtkWidget* patch_list_new(void);

/* refresh the list of patches */
void patch_list_update(PatchList* self, int index);

/* returns which patch we are currently looking at */
int patch_list_get_current_patch(PatchList* self);
    
G_END_DECLS

#endif /* __PATCH_LIST__ */
