.TH SPLAT! 1 "02 March 2006" "KD2BD Software" "KD2BD Software"
.SH NAME
splat \- An RF \fBS\fPignal \fBP\fPropagation, \fBL\fPoss, \fBA\fPnd \fBT\fPerrain analysis tool
.SH SYNOPSIS
splat [-t  \fItransmitter_site.qth\fP]
[-r  \fIreceiver_site.qth\fP]
[-c  \fIrx_antenna_height_for_los_coverage_analysis (feet) (float)\fP]
[-L  \fIrx_antenna_height_for_Longley-Rice_coverage_analysis (feet) (float)\fP]
[-p  \fIterrain_profile.ext\fP]
[-e  \fIelevation_profile.ext\fP]
[-h  \fIheight_profile.ext\fP]
[-l  \fILongley-Rice_profile.ext\fP]
[-o  \fItopographic_map_filename.ppm\fP]
[-b  \fIcartographic_boundary_filename.dat\fP]
[-s  \fIsite/city_database.dat\fP]
[-d  \fIsdf_directory_path\fP]
[-m  \fIearth_radius_multiplier (float)\fP]
[-R  \fImaximum_coverage_range (for -c or -L) (miles) (float)\fP]
[-dB \fImaximum attenuation contour to display on path loss maps (80-230 dB)\fP]
[-n]
[-N]
.SH DESCRIPTION
\fBSPLAT!\fP is a powerful terrestrial RF propagation and terrain
analysis tool covering the spectrum between 20 MHz and 20 GHz.  It
is designed for operation on Unix and Linux-based workstations.
\fBSPLAT!\fP is free software.  Redistribution and/or modification
is permitted under the terms of the GNU General Public License as
published by the Free Software Foundation, either version 2 of the
License or any later version.  Adoption of \fBSPLAT!\fP source code
in proprietary or closed-source applications is a violation of this
license, and is \fBstrictly\fP forbidden. 

\fBSPLAT!\fP is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY, without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
for more details.
.SH INTRODUCTION
Applications of \fBSPLAT!\fP include the visualization, design, and
link budget analysis of wireless Wide Area Networks (WANs), commercial
and amateur radio communication systems above 20 MHz, microwave links,
frequency coordination, and the determination of analog and digital
terrestrial radio and television contour regions.

\fBSPLAT!\fP provides RF site engineering data such as great circle
distances and bearings between sites, antenna elevation angles (uptilt),
depression angles (downtilt), antenna height above mean sea level,
antenna height above average terrain, bearings and distances to known
obstructions, Longley-Rice path attenuation, and minimum antenna height
requirements needed to establish line-of-sight communication paths absent
of obstructions due to terrain.  \fBSPLAT!\fP produces reports, graphs,
and highly detailed and carefully annotated topographic maps depicting
line-of-sight paths, path loss, and expected coverage areas of
transmitters and repeater systems.  When performing line-of-sight
analysis in situations where multiple transmitter or repeater sites
are employed, \fBSPLAT!\fP determines individual and mutual areas
of coverage within the network specified.

\fBSPLAT!\fP operates in two distinct modes: \fIpoint-to-point mode\fP,
and \fIarea prediction mode\fP, and may be invoked using either
line-of-sight (LOS) or Irregular Terrain (ITM) propagation models.
True Earth, four-thirds Earth, or any other Earth radius may be
specified by the user when performing line-of-sight analysis.
.SH INPUT FILES
\fBSPLAT!\fP is a command-line driven application, and reads input
data through a number of data files.  Some files are mandatory for
successful execution of the program, while others are optional.
Mandatory files include SPLAT Data Files (SDF files), site location
files (QTH files), and Longley-Rice model parameter files (LRP files).
Optional files include city/site location files, and cartographic
boundary files.
.SH SPLAT DATA FILES
\fBSPLAT!\fP imports topographic data in the form of SPLAT Data Files
(SDFs).  These files may be generated from a number of information sources.
In the United States, SPLAT Data Files can be generated through U.S.
Geological Survey Digital Elevation Models (DEMs) using the \fBusgs2sdf\fP
utility included with \fBSPLAT!\fP.  USGS Digital Elevation Models
compatible with this utility may be downloaded from:
\fIhttp://edcftp.cr.usgs.gov/pub/data/DEM/250/\fP.

Significantly better resolution can be obtained through the use
of SRTM-3 Version 2 digital elevation models.  These models are the
result of the STS-99 Space Shuttle Radar Topography Mission, and are
available for most populated regions of the Earth.  SPLAT Data Files
may be generated from SRTM data using the included \fBsrtm2sdf\fP utility.
SRTM-3 Version 2 data may be obtained through anonymous FTP from:
\fIftp://e0srp01u.ecs.nasa.gov:21/srtm/version2/\fP

Despite the higher accuracy that SRTM data has to offer, some voids
in the data sets exist.  When voids are detected, the \fBsrtm2sdf\fP
utility replaces them with corresponding data found in existing SDF
files (that were presumably created from earlier USGS data through the
\fBusgs2sdf\fP utility).  If USGS-derived SDF data is not available, voids
are handled through adjacent pixel averaging, or direct replacement.

SPLAT Data Files contain integer value topographic elevations (in meters)
referenced to mean sea level for 1-degree by 1-degree regions of the
earth with a resolution of 3-arc seconds.  SDF files can be read in
either standard format (\fI.sdf\fP) as generated by the \fBusgs2sdf\fP
and \fBsrtm2sdf\fP utilities, or in bzip2 compressed format
(\fI.sdf.bz2\fP).  Since uncompressed files can be processed slightly
faster than files that have been compressed, \fBSPLAT!\fP searches for
the needed SDF data in uncompressed format first.  If uncompressed data
cannot located, \fBSPLAT!\fP then searches for data in bzip2 compressed
format.  If no compressed SDF files can be found for the region requested,
\fBSPLAT!\fP assumes the region is over water, and will assign an
elevation of sea-level to these areas.

This feature of \fBSPLAT!\fP makes it possible to perform path analysis
not only over land, but also between coastal areas not represented by
Digital Elevation Model data.  This behavior of \fBSPLAT!\fP underscores
the importance of having all the SDF files required for the region being
analyzed if meaningful results are to be expected.
.SH SITE LOCATION (QTH) FILES
\fBSPLAT!\fP imports site location information of transmitter and receiver
sites analyzed by the program from ASCII files having a \fI.qth\fP extension.
QTH files contain the site's name, the site's latitude (positive if North
of the equator, negative if South), the site's longitude (in degrees West,
0 to 360 degrees), and the site's antenna height above ground level (AGL).
A single line-feed character separates each field.  The antenna height is
assumed to be specified in feet unless followed by the letter \fIm\fP or
the word \fImeters\fP in either upper or lower case.  Latitude and
longitude information may be expressed in either decimal format (74.6889)
or degree, minute, second (DMS) format (74 41 20.0).

For example, a site location file describing television station WNJT,
Trenton, NJ (\fIwnjt.qth\fP) might read as follows:
\fC
        WNJT
        40.2833
        74.6889
        990.00
\fR
Each transmitter and receiver site analyzed by \fBSPLAT!\fP must be
represented by its own site location (QTH) file.
.SH LONGLEY-RICE PARAMETER (LRP) FILES
\fBSPLAT!\fP imports Longley-Rice model parameter data from files having
the same base name as the transmitter site QTH file, but with a \fI.lrp\fP
extension, thus providing simple and accurate correlation between these
associated data sets.  The format for the Longley-Rice model parameter
files is as follows (\fIwnjt.lrp\fP):
\fC
        15.000  ; Earth Dielectric Constant (Relative permittivity)
        0.005   ; Earth Conductivity (Siemens per meter)
        301.000 ; Atmospheric Bending Constant (N-units)
        700.000 ; Frequency in MHz (20 MHz to 20 GHz)
        5       ; Radio Climate (5 = Continental Temperate)
        0       ; Polarization (0 = Horizontal, 1 = Vertical)
        0.5     ; Fraction of situations (50% of locations)
        0.5     ; Fraction of time (50% of the time)
\fR
If an LRP file corresponding to the tx_site QTH file cannot
be found, \fBSPLAT!\fP scans the current working directory for
the file "splat.lrp".  If this file cannot be found, then the default
parameters listed above will be assigned by \fBSPLAT!\fP and a
corresponding "splat.lrp" file containing this data will be written
to the current working directory.  "splat.lrp" can then be edited
by the user as needed.

Typical Earth dielectric constants and conductivity values are as
follows:
\fC
                           Dielectric Constant  Conductivity
        Salt water       :        80                5.000
        Good ground      :        25                0.020
        Fresh water      :        80                0.010
        Marshy land      :        12                0.007
        Farmland, forest :        15                0.005
        Average ground   :        15                0.005
        Mountain, sand   :        13                0.002
        City             :         5                0.001
        Poor ground      :         4                0.001
\fR
Radio climate codes used by \fBSPLAT!\fP are as follows:
\fC
        1: Equatorial (Congo)
        2: Continental Subtropical (Sudan)
        3: Maritime Subtropical (West coast of Africa)
        4: Desert (Sahara)
        5: Continental Temperate
        6: Maritime Temperate, over land (UK and west coasts of US & EU)
        7: Maritime Temperate, over sea
\fR
The Continental Temperate climate is common to large land masses in
the temperate zone, such as the United States.  For paths shorter than
100 km, there is little difference between Continental and Maritime
Temperate climates.

The final two parameters in the \fI.lrp\fP file correspond to the statistical
analysis provided by the Longley-Rice model.  In this example, \fBSPLAT!\fP
will return the maximum path loss occurring 50% of the time (fraction
of time) in 50% of situations (fraction of situations).  Use a fraction
of time parameter of 0.97 for digital television, 0.50 for analog in the
United States.  Isotropic antennas are assumed.

For further information on these parameters, see:
\fIhttp://flattop.its.bldrdoc.gov/itm.html\fP and
\fIhttp://www.softwright.com/faq/engineering/prop_longley_rice.html\fP
.SH CITY LOCATION FILES
The names and locations of cities, tower sites, or other points of interest
may be imported and plotted on topographic maps generated by \fBSPLAT!\fP.
\fBSPLAT!\fP imports the names of cities and locations from ASCII files
containing the location's name, the location's latitude, and the location's
longitude.  Each field is separated by a comma.  Each record is separated
by a single line feed character.  As was the case with the \fI.qth\fP
files, latitude and longitude information may be entered in either
decimal or degree, minute, second (DMS) format.

For example (\fIcities.dat\fP):
\fC
        Teaneck, 40.891973, 74.014506
        Tenafly, 40.919212, 73.955892
        Teterboro, 40.859511, 74.058908
        Tinton Falls, 40.279966, 74.093924
        Toms River, 39.977777, 74.183580
        Totowa, 40.906160, 74.223310
        Trenton, 40.219922, 74.754665
\fR
A total of five separate city data files may be imported at a time,
and there is no limit to the size of these files.  \fBSPLAT!\fP reads
city data on a "first come/first served" basis, and plots only those
locations whose annotations do not conflict with annotations of
locations plotted earlier during \fBSPLAT\fP's execution.  This behavior
minimizes clutter in \fBSPLAT!\fP generated topographic maps, but also
mandates that important locations be placed toward the beginning of
the first city data file, and disposable locations be positioned
further down the list or in subsequent data files.

City data files may be generated manually using any text editor,
imported from other sources, or derived from data available from the
U.S. Census Bureau using the \fBcitydecoder\fP utility included with
\fBSPLAT!\fP.  Such data is available free of charge via the Internet
at: \fIhttp://www.census.gov/geo/www/cob/bdy_files.html\fP, and must
be in ASCII format.
.SH CARTOGRAPHIC BOUNDARY DATA FILES
Cartographic boundary data may also be imported to plot the boundaries of
cities, counties, or states on topographic maps generated by \fBSPLAT!\fP.
Such data must be of the form of ARC/INFO Ungenerate (ASCII Format)
Metadata Cartographic Boundary Files, and are available from the U.S.
Census Bureau via the Internet at:
\fIhttp://www.census.gov/geo/www/cob/co2000.html#ascii\fP and
\fIhttp://www.census.gov/geo/www/cob/pl2000.html#ascii\fP.  A total of
five separate cartographic boundary files may be imported at a time.
It is not necessary to import state boundaries if county boundaries
have already been imported.
.SH PROGRAM OPERATION
\fBSPLAT!\fP is invoked via the command-line using a series of switches
and arguments.  Since \fBSPLAT!\fP is a CPU and memory intensive application,
this type of interface minimizes overhead and lends itself well to
scripted (batch) operations.  \fBSPLAT!\fP's CPU and memory scheduling
priority may be modified through the use of the Unix \fBnice\fP command.

The number and type of switches passed to \fBSPLAT!\fP determine its
mode of operation and method of output data generation.  Nearly all
of \fBSPLAT!\fP's switches may be cascaded in any order on the command
line when invoking the program.
.SH POINT-TO-POINT ANALYSIS
\fBSPLAT!\fP may be used to perform line-of-sight terrain analysis
between two specified site locations.  For example:

\fCsplat -t tx_site.qth -r rx_site.qth\fR

invokes a terrain analysis between the transmitter specified
in \fItx_site.qth\fP and receiver specified in \fIrx_site.qth\fP,
and writes a \fBSPLAT!\fP Obstruction Report to the current working
directory.  The report contains details of the transmitter and
receiver sites, and identifies the location of any obstructions
detected during the analysis.  If an obstruction can be cleared
by raising the receive antenna to a greater altitude, \fBSPLAT!\fP
will indicate the minimum antenna height required for a line-of-sight
path to exist between the transmitter and receiver locations specified.
If the antenna must be raised a significant amount, this determination
may take some time.  Note that the results provided are the \fIminimum\fP
necessary for a line-of-sight path to exist, and do not take Fresnel
zone clearance requirements into consideration.

\fIqth\fP extensions are assumed by \fBSPLAT!\fP for QTH files, and
are optional when invoking the program.  \fBSPLAT!\fP automatically
reads all SPLAT Data Files necessary to conduct the terrain analysis
between the sites specified.  \fBSPLAT!\fP searches for the needed
SDF files in the current working directory first.  If the needed
files are not found, \fBSPLAT!\fP then searches in the path specified
by the \fI-d\fP command-line switch:

\fCsplat -t tx_site -r rx_site -d /cdrom/sdf/\fR

An external directory path may be specified by placing a ".splat_path"
file under the user's home directory.  This file must contain the full
directory path to the last resort location of all the SDF files.  The
path in the \fI$HOME/.splat_path\fP file must be of the form of a
single line of ASCII text:

\fC/opt/splat/sdf/\fR

and can be generated using any text editor.

A graph of the terrain profile between the receiver and transmitter
locations as a function of distance from the receiver can be generated
by adding the \fI-p\fP switch:

\fCsplat -t tx_site -r rx_site -p terrain_profile.gif\fR

\fBSPLAT!\fP invokes \fBgnuplot\fP when generating graphs.  The filename
extension specified to \fBSPLAT!\fP determines the format of the graph
produced.  \fI.gif\fP will produce a 640x480 color GIF graphic file,
while \fI.ps\fP or \fI.postscript\fP will produce postscript output.
Output in formats such as PNG, Adobe Illustrator, AutoCAD dxf, LaTeX,
and many others are available.  Please consult \fBgnuplot\fP, and
\fBgnuplot\fP's documentation for details on all the supported
output formats.

A graph of elevations subtended by the terrain between the receiver and
transmitter as a function of distance from the receiver can be generated
by using the \fI-e\fP switch:

\fCsplat -t tx_site -r rx_site -e elevation_profile.gif\fR

The graph produced using this switch illustrates the elevation and
depression angles resulting from the terrain between the receiver's
location and the transmitter site from the perspective of the receiver's
location.  A second trace is plotted between the left side of the graph
(receiver's location) and the location of the transmitting antenna on
the right.  This trace illustrates the elevation angle required for a
line-of-sight path to exist between the receiver and transmitter
locations.  If the trace intersects the elevation profile at any point
on the graph, then this is an indication that a line-of-sight path
does not exist under the conditions given, and the obstructions can
be clearly identified on the graph at the point(s) of intersection.

A graph illustrating terrain height referenced to a line-of-sight
path between the transmitter and receiver may be generated using
the \fI-h\fP switch:

\fCsplat -t tx_site -r rx_site -h height_profile.gif\fR

The Earth's curvature is clearly evident when plotting height profiles.

A graph showing Longley-Rice path loss may be plotted using the
\fI-l\fP switch:

\fCsplat -t tx_site -r rx_site -l path_loss_profile.gif\fR

When performing path loss profiles, a Longley-Rice Model Path Loss
Report is generated by \fBSPLAT!\fP in the form of a text file with
a \fI.lro\fP filename extension.  The report contains bearings and
distances between the transmitter and receiver, as well as the
Longley-Rice path loss for various distances between the transmitter
and receiver locations.  The mode of propagation for points along the
path are given as \fILine-of-Sight\fP, \fISingle Horizon\fP, \fIDouble
Horizon\fP, \fIDiffraction Dominant\fP, and \fITroposcatter Dominant\fP.

To determine the signal-to-noise (SNR) ratio at remote location
where random Johnson (thermal) noise is the primary limiting
factor in reception:

.EQ
SNR = T - NJ - L + G - NF
.EN

where \fBT\fP is the ERP of the transmitter in dBW, \fBNJ\fP is
Johnson Noise in dBW (-136 dBW for a 6 MHz TV channel), \fBL\fP
is the path loss provided by \fBSPLAT!\fP in dB (as a \fIpositive\fP
number), \fBG\fP is the receive antenna gain in dB over isotropic,
and \fBNF\fP is the receiver noise figure in dB.

\fBT\fP may be computed as follows:

.EQ
T = TI + GT
.EN

where \fBTI\fP is actual amount of RF power delivered to the transmitting
antenna in dBW, \fBGT\fP is the transmitting antenna gain (over isotropic)
in the direction of the receiver (or the horizon if the receiver is over
the horizon).

To compute how much more signal is available over the minimum to
necessary to achieve a specific signal-to-noise ratio:

.EQ
Signal_Margin = SNR - S
.EN

where \fBS\fP is the minimum desired SNR ratio (15.5 dB for
ATSC DTV, 42 dB for analog NTSC television).

A topographic map may be generated by \fBSPLAT!\fP to visualize the
path between the transmitter and receiver sites from yet another
perspective.  Topographic maps generated by \fBSPLAT!\fP display
elevations using a logarithmic grayscale, with higher elevations
represented through brighter shades of gray.  The dynamic range of
the image is scaled between the highest and lowest elevations present
in the map.  The only exception to this is sea-level, which is
represented using the color blue.

\fBSPLAT!\fP generated topographic maps are 24-bit TrueColor Portable
PixMap (PPM) images.  They may be viewed, edited, or converted to other
graphic formats by popular image viewing applications such as \fBxv\fP,
\fBThe GIMP\fP, \fBImageMagick\fP, and \fBXPaint\fP.  PNG format is
highly recommended for lossless compressed storage of \fBSPLAT!\fP
generated topographic output files.  An excellent command-line utility
capable of converting \fBSPLAT!\fP PPM graphic files to PNG files is
\fBwpng\fP, and is available
at: \fIhttp://www.libpng.org/pub/png/book/sources.html\fP.  As a last
resort, PPM files may be compressed using the bzip2 utility, and read
directly by \fBThe GIMP\fP in this format.  Topographic output
is specified using the \fI-o\fP switch:

\fCsplat -t tx_site -r rx_site -o topo_map.ppm\fR

The \fI.ppm\fP extension on the output filename is assumed by
\fBSPLAT!\fP, and is optional.

In this example, \fItopo_map.ppm\fP will illustrate the locations of the
transmitter and receiver sites specified.  In addition, the great circle
path between the two sites will be drawn over locations for which an
unobstructed path exists to the transmitter at a receiving antenna
height equal to that of the receiver site (specified in \fIrx_site.qth\fP).

It may desirable to populate the topographic map with names and locations
of cities, tower sites, or other important locations.  A city file may be
passed to \fBSPLAT!\fP using the \fI-s\fP switch:

\fCsplat -t tx_site -r rx_site -s cities.dat -o topo_map\fR

Up to five separate city files may be passed to \fBSPLAT!\fP at a time
following the \fI-s\fP switch.

County and state boundaries may be added to the map by specifying up
to five U.S. Census Bureau cartographic boundary files using the \fI-b\fP
switch:

\fCsplat -t tx_site -r rx_site -b co34_d00.dat -o topo_map\fR

In situations where multiple transmitter sites are in use, as many as
four site locations may be passed to \fBSPLAT!\fP at a time for analysis:

\fCsplat -t tx_site1 tx_site2 tx_site3 tx_site4 -r rx_site -p profile.gif\fR

In this example, four separate terrain profiles and obstruction reports
will be generated by \fBSPLAT!\fP.  A single topographic map can be
specified using the \fI-o\fP switch, and line-of-sight paths between
each transmitter and the receiver site indicated will be produced on
the map, each in its own color.  The path between the first transmitter
specified to the receiver will be in green, the path between the
second transmitter and the receiver will be in cyan, the path between
the third transmitter and the receiver will be in violet, and the
path between the fourth transmitter and the receiver will be in sienna. 
.SH DETERMINING REGIONAL COVERAGE
\fBSPLAT!\fP can analyze a transmitter or repeater site, or network
of sites, and predict the regional coverage for each site specified.
In this mode, \fBSPLAT!\fP can generate a topographic map displaying
the geometric line-of-sight coverage area of the sites based on the
location of each site and the height of receive antenna wishing to
communicate with the site in question.  \fBSPLAT!\fP switches from
point-to-point analysis mode to area prediction mode when the \fI-c\fP
switch is invoked as follows:

\fCsplat -t tx_site -c 30.0 -s cities.dat -b co34_d00.dat -o tx_coverage\fR

In this example, \fBSPLAT!\fP generates a topographic map called
\fItx_coverage.ppm\fP that illustrates the predicted line-of-sight
regional coverage of \fItx_site\fP to receiving locations having
antennas 30.0 feet above ground level (AGL).  The contents of
\fIcities.dat\fP are plotted on the map, as are the cartographic
boundaries contained in the file \fIco34_d00.dat\fP.

When plotting line-of-sight paths and areas of regional coverage,
\fBSPLAT!\fP by default does not account for the effects of
atmospheric bending.  However, this behavior may be modified
by using the Earth radius multiplier (\fI-m\fP) switch:

\fCsplat -t wnjt -c 30.0 -m 1.333 -s cities.dat -b counties.dat -o map.ppm\fR

An earth radius multiplier of 1.333 instructs \fBSPLAT!\fP to use
the "four-thirds earth" model for line-of-sight propagation analysis.
Any appropriate earth radius multiplier may be selected by the user.
 
When invoked in area prediction mode, \fBSPLAT!\fP generates a
site report for each station analyzed.  \fBSPLAT!\fP site reports
contain details of the site's geographic location, its height above
mean sea level, the antenna's height above mean sea level, the
antenna's height above average terrain, and the height of the
average terrain calculated in the directions of 0, 45, 90, 135,
180, 225, 270, and 315 degrees azimuth.

If the \fI-c\fP switch is replaced by a \fI-L\fP switch, a
Longley-Rice path loss map for a transmitter site may be generated:

\fCsplat -t wnjt -L 30.0 -s cities.dat -b co34_d00.dat -o path_loss_map\fR

In this mode, \fBSPLAT!\fP generates a multi-color map illustrating
expected signal levels (path loss) in areas surrounding the transmitter
site.  A legend at the bottom of the map correlates each color with a
specific path loss level in decibels.  Since Longley-Rice area
prediction map generation is very CPU intensive, provision for
limiting the analysis range is provided by the \fI-R\fP switch.
The argument must be given in miles.  If a range wider than the
generated topographic map is specified, \fBSPLAT!\fP will perform
Longley-Rice path loss calculations between all four corners of
the area prediction map.

The \fI-db\fP switch allows a constraint to be placed on the maximum
path loss region plotted on the map.  A path loss between 80 and
230 dB may be specified using this switch.  For example, if a path
loss beyond -140 dB is irrelevant to the survey being conducted,
\fBSPLAT!\fP's path loss plot can be constrained to the region
bounded by the 140 dB attenuation contour as follows:

\fCsplat -t wnjt -L 30.0 -s cities.dat -b co34_d00.dat -db 140 -o plot.ppm\fR

.SH DETERMINING MULTIPLE REGIONS OF COVERAGE
\fBSPLAT!\fP can also display line-of-sight coverage areas for as
many as four separate transmitter sites on a common topographic map.
For example:

\fCsplat -t site1 site2 site3 site4 -c 30.0 -o network.ppm\fR

plots the regional line-of-sight coverage of site1, site2, site3,
and site4 based on a receive antenna located 30.0 feet above ground
level.  A topographic map is then written to the file \fInetwork.ppm\fP.
The line-of-sight coverage area of the transmitters are plotted as
follows in the colors indicated (along with their corresponding RGB
values in decimal):
\fC
    site1: Green (0,255,0)
    site2: Cyan (0,255,255)
    site3: Medium Violet (147,112,219)
    site4: Sienna 1 (255,130,71)

    site1 + site2: Yellow (255,255,0)
    site1 + site3: Pink (255,192,203)
    site1 + site4: Green Yellow (173,255,47)
    site2 + site3: Orange (255,165,0)
    site2 + site4: Dark Sea Green 1 (193,255,193)
    site3 + site4: Dark Turquoise (0,206,209)

    site1 + site2 + site3: Dark Green (0,100,0)
    site1 + site2 + site4: Blanched Almond (255,235,205)
    site1 + site3 + site4: Medium Spring Green (0,250,154)
    site2 + site3 + site4: Tan (210,180,140)

    site1 + site2 + site3 + site4: Gold2 (238,201,0)
\fR
If separate \fI.qth\fP files are generated, each representing a common
site location but a different antenna height, a single topographic map
illustrating the regional coverage from as many as four separate locations
on a single tower may be generated by \fBSPLAT!\fP. 
.SH TOPOGRAPHIC MAP GENERATION
In certain situations, it may be desirable to generate a topographic map
of a region without plotting coverage areas, line-of-sight paths, or
generating obstruction reports.  There are several ways of doing this.
If one wishes to generate a topographic map illustrating the location
of a transmitter and receiver site along with a brief text report
describing the locations and distances between the sites, the \fI-n\fP
switch should be invoked as follows:

\fCsplat -t tx_site -r rx_site -n -o topo_map.ppm\fR

If no text report is desired, then the \fI-N\fP switch is used:

\fCsplat -t tx_site -r rx_site -N -o topo_map.ppm\fR

If the \fI-o\fP switch and output filename are omitted when using
either the \fI-n\fP or \fI-N\fP switches, output is written to a
file named \fImap.ppm\fP in the current working directory by default.
.SH DETERMINATION OF ANTENNA HEIGHT ABOVE AVERAGE TERRAIN
\fBSPLAT!\fP determines antenna height above average terrain (HAAT)
according to the procedure defined by Federal Communications Commission
Part 73.313(d).  According to this definition, terrain elevations along
eight radials between 2 and 10 miles (3 and 16 kilometers) from the site
being analyzed are sampled and averaged for each 45 degrees of azimuth
starting with True North.  If one or more radials lie entirely over water
or over land outside the United States (areas for which no USGS topography
data is available), then those radials are omitted from the calculation
of average terrain.  If part of a radial extends over a body of water or
over land outside the United States, then only that part of the radial
lying over United States land is used in the determination of average
terrain.

Note that SRTM elevation data, unlike older 3-arc second USGS data,
extends beyond the borders of the United States.  Therefore, HAAT
results may not be in full compliance with FCC Part 73.313(d)
in areas along the borders of the United States if the SDF files
used by \fBSPLAT!\fP are SRTM-derived. 

When performing point-to-point terrain analysis, \fBSPLAT!\fP determines
the antenna height above average terrain only if enough topographic
data has already been loaded by the program to perform the point-to-point
analysis.  In most cases, this will be true, unless the site in question
does not lie within 10 miles of the boundary of the topography data in
memory.

When performing area prediction analysis, enough topography data is
normally loaded by \fBSPLAT!\fP to perform average terrain calculations.
Under such conditions, \fBSPLAT!\fP will provide the antenna height
above average terrain as well as the average terrain above mean sea
level for azimuths of 0, 45, 90, 135, 180, 225, 270, and 315 degrees,
and include such information in the site report generated.  If one or
more of the eight radials surveyed fall over water, or over regions
for which no SDF data is available, \fBSPLAT!\fP reports \fINo Terrain\fP
for the radial paths affected.
.SH RESTRICTING THE MAXIMUM SIZE OF AN ANALYSIS REGION
\fBSPLAT!\fP reads SDF files as needed into a series of memory "slots"
within the structure of the program.  Each "slot" holds one SDF file
representing a one degree by one degree region of terrain.
A \fI#define MAXSLOTS\fP statement in the first several lines of
\fIsplat.cpp\fP sets the maximum number of "slots" available for topography
data.  It also sets the maximum size of the topographic maps generated by
\fBSPLAT!\fP.  MAXSLOTS is set to 9 by default.  If \fBSPLAT!\fP produces
a segmentation fault on start-up with this default, it is an indication
that not enough RAM and/or virtual memory (swap space) is available to
run \fBSPLAT!\fP with this number of MAXSLOTS.  In situations where
available memory is low, MAXSLOTS may be reduced to 4 with the understanding
that this will greatly limit the maximum region \fBSPLAT!\fP will be able
to analyze.  If 118 megabytes or more of total memory (swap space plus
RAM) is available, then MAXSLOTS may be increased to 16.  This will
permit operation over a 4-degree by 4-degree region, which is sufficient
for single antenna heights in excess of 10,000 feet above mean sea
level, or point-to-point distances of over 1000 miles.
.SH ADDITIONAL INFORMATION
Invoking \fBSPLAT!\fP without any arguments will display all the
command-line options available with the program along with a brief
summary of each.

The latest news and information regarding \fBSPLAT!\fP software is
available through the official \fBSPLAT!\fP software web page located
at: \fIhttp://www.qsl.net/kd2bd/splat.html\fP.
.SH AUTHORS
.TP
John A. Magliacane, KD2BD <\fIkd2bd@amsat.org\fP>
Creator, Lead Developer
.TP
Doug McDonald <\fImcdonald@scs.uiuc.edu\fP>
Longley-Rice Model integration
