package Templates::Admin::BoardsBlock;

use SmallPigVars qw($config);

use Templates::Admin::Boards;
use Templates::Admin::Block;
use Templates::Admin::OptBlock;
use Templates::Admin::Caution;

use strict;
use vars qw(@ISA $DBH);

@ISA = qw(Templates::Admin::Block);

my $theme;

my $lang;

sub new{
  # --- expire threads   (1)
  # --- open threads     (1)
  # --- close threads    (1)
  # --- approve threads  (1)
  # --- move copy threads(1)
  # --- index.cgi        (1)
  my ($class, $op) = @_;
  
  my $self = Templates::Admin::Block->new("boardsblock");
  $self->{'op'} = "";
  $self->{'op'} = $op;

  return bless $self, $class;
}

sub get{
  my ($self, $STATE) = @_;
  my $op = $STATE->{'op'} = $self->{'op'};
  
  $theme = $STATE->{'theme'};
  
  $lang = $STATE->{'langptr'};

  my $boardlist = Templates::Admin::Boards->new($STATE);
  my $standardindex = Templates::Admin::StandardIndex->new($STATE);

  my ($ret, $showlink) = ("",1);
  $ret = $standardindex->get();
  # --- not from index.cgi
  if($op ne "boardindex"){
    my $caution = Templates::Admin::Caution->new($theme);
    $ret .= $caution->get($lang->{'threads_msg1'});
    $showlink = 0;
  }
  my $boards = $boardlist->get_boards(\&btitle, \&bcontent, undef, $showlink, 4);
  return "" if !$boards;
  return $ret.$boards;
}

sub btitle{
  my $ret = qq| 
<TR BGCOLOR=$theme->{'dhdrcolor'} CELLPADDING=2>
  <TD WIDTH=$theme->{'empty_w'}>&nbsp;</TD>
  <TD CLASS=bheader2 WIDTH=$theme->{'forums_w'}>$lang->{'forums'}</TD>
  <TD WIDTH=$theme->{'posts_w'} CLASS=bheader2>$lang->{'posts'}</TD>
  <TD WIDTH=$theme->{'lastpost_w'} CLASS=bheader2>$lang->{'lastpost'}</TD>
</TR>
    |;
  return $ret;
}

sub bcontent{
  my ($title, $cnt, $np, $lastmod, $intro) = @_;
  my $ret .= qq!
<TR BGCOLOR=$theme->{'boxbgcolor'}>
  <TD WIDTH=$theme->{'empty_w'} BGCOLOR=$theme->{'lhdrcolor'}>&nbsp;</TD>
  <TD WIDTH=$theme->{'forums_w'}>$title</TD>
  <TD WIDTH=$theme->{'posts_w'}>$cnt $np</TD>
  <TD WIDTH=$theme->{'lastpost_w'}>$lastmod</TD></TR>
<TR BGCOLOR=$theme->{'boxbgcolor'}>
  <TD WIDTH=$theme->{'empty_w'} BGCOLOR=$theme->{'lhdrcolor'}>&nbsp;</TD>
  <TD WIDTH=$theme->{'forums_w'}>$intro</TD>
  <TD WIDTH=$theme->{'posts_w'}>&nbsp;</TD>
  <TD WIDTH=$theme->{'lastpost_w'}>&nbsp;</TD>
</TR>
<TR BGCOLOR=$theme->{'dhdrcolor'}><TD WIDTH=10></TD>
  <TD COLSPAN=3>
</TD></TR>
  !;	
  return $ret;
}

sub display{
  my ($self, $STATE) = @_;
  print get($self, $STATE);
}  


return 1;
