package Templates::Admin::OptBlock;

use SmallPigVars qw($config);
use SmallPig;

use CGI qw(:standard :cgi-lib);
use strict;

my %params =
(
 'title' => "",
 'content' => "",
 'width' => "",
 'space' => "",
 'restrshow' => "",
 'bdrcolor' => "",
 'bgcolor' => ""
);

sub new{
  # --- block constructor...
  my ($class, $classvars, $theme) = @_;
  my %self = ();

  $self{width} = $theme->{'intblwidth'};
  $self{bdrcolor} = $theme->{'dhdrcolor'};
  $self{bgcolor} = $theme->{'boxbgcolor'};
  $self{theme} = $theme;
  
  foreach (keys(%params)){
    $self{$_} = $classvars->{$_} if $classvars->{$_};
  }

  return bless \%self, $class;
}

sub get{
  my $self = shift;
  my ($space, $width, $title, $bdrcolor, $bgcolor, $content, $theme) = 
    map { $self->{$_} } 
  qw(space width title bdrcolor bgcolor content theme);

  my $ret = qq|
$space<!--opt_block--><div align=$theme->{'intblalign'}>
<TABLE BORDER="0" CELLSPACING="$theme->{'tblcellspacing'}" 
	      CELLPADDING="$theme->{'tblcellpadding'}" BGCOLOR="$bdrcolor" 
		  WIDTH="$width">
		      <tr><td>
			  <table border="0" cellspacing="$theme->{'intblcsp'}" cellpadding="$theme->{'intblcp'}" width="100%" bgcolor="$bgcolor">
			      <tr>
				  <td bgcolor="$bdrcolor" align="center" class="bheader1">
				      $title
					  </td></tr>
    $content
    </TABLE>
    </TD>
   </TR>
</TABLE></div>
  |;

  return $ret;
}

sub display{
  my $self = shift;
  print get($self);
}
