package Templates::Admin::ThreadsBlock;

use SmallPigVars qw($config);
use Templates::Admin::SmallPig;

use CGI qw(:standard :cgi-lib);

use Templates::Admin::Boards;
use Templates::Admin::TopicsList;
use Templates::Admin::PageIndex;
use Templates::Admin::Block;
use Templates::Admin::OptBlock;
use Templates::Admin::Caution;

use strict;
use vars qw(@ISA $DBH $lang);

@ISA = qw(Templates::Admin::Block);

my %CACHE;

sub new{
  # --- expire threads (2)
  # --- open threads   (2)
  # --- close threads  (2)
  # --- approve threads(2)
  # --- move copy threads(2)
  # --- list the threads information for above operations
  my ($class) = @_;
  my $self = Templates::Admin::Block->new("boardblock");
  
  my $id = join '', sort values %$self, "closethreadsblock";
  return $CACHE{$id} if $CACHE{$id};

  return $CACHE{$id} = bless $self, $class;
}

sub get{
  my ($self, $STATE) = @_;
  my ($op, $sid, $userstatus, $tuserstatus, $mostparent) = 
      map{ $STATE->{$_} } qw(op sid userstatus tuserstatus mostparent);
  my ($ret, $msg);
  
  $lang = $STATE->{'langptr'};

  my $standardindex = Templates::Admin::StandardIndex->new($STATE);

  $msg = 
    ($op eq "closethreads")?$lang->{'close_threads_msg2'}:
      ($op eq "expirethreads")?$lang->{'expire_threads_msg2'}:
	($op eq "openthreads")?$lang->{'open_threads_msg2'}:
          ($op eq "movecopythreads")?$lang->{'move_copy_threads_msg2'}:
	      ($op eq "umovethreads")?$lang->{'move_copy_threads_msg2'}:
		  $lang->{'approve_threads_msg2'};

  my $theme = $STATE->{'theme'};
  my $caution = Templates::Admin::Caution->new($theme);
  
  # --- make sure it is in collapsed view
  $STATE->{'view'} = "collapsed";
  my $topicslist = Templates::Admin::TopicsList->new("", "", $STATE);
  
  my $name = ($op eq "closethreads")?"closethreads":
    ($op eq "expirethreads")?"expirethreads":
      ($op eq "openthreads")?"openthreads":
	  ($op eq "movecopythreads")?"movecopythreads":
	      ($op eq "umovethreads")?"umovethreads":
		  "approvethreads";
  my $submit = ($op eq "closethreads")?$lang->{'CloseThreads'}:
    ($op eq "expirethreads")?$lang->{'ExpireThreads'}:
      ($op eq "openthreads")?$lang->{'OpenThreads'}:
	  $lang->{'ApproveThreads'};
  
  $ret = Templates::Admin::SmallPig::check_all_script($name);
  my ($tmp) = $topicslist->get($STATE);
  $ret .= "<!--ThreadsBlock-->\n";
  my $script = ($op eq "umovethreads")?"user.cgi":"admin.cgi";
  $ret .= start_form(-action=>"$config->{'cgidir'}/$script", 
		     -name=>$name, -method=>"post");
  $ret .= $standardindex->get();
  $ret .= $caution->get($msg);
  $ret .= $tmp;
  $ret .= hidden(-name=>"sid", -value=>"$sid");
  $ret .= "<font size=1>";
  if($op eq "movecopythreads" || $op eq "umovethreads"){
      $ret .= 
Templates::Admin::SmallPig::select_forums_w_cats($sid, $userstatus, 
						 $tuserstatus, $lang);
      $ret .= submit(-name=>"op", -value=>$lang->{'MoveThreads'});
#      $ret .= submit(-name=>"op", -value=>$lang->{'CopyThreads'});
  }
  else{
      $ret .= submit(-name=>"op", -value=>"$submit");
  }

  $ret .= "<input type=hidden name=mostparent value=1>" if $mostparent;

  $ret .= "</font>";
  $ret .= end_form()."</TD>";
  $ret .= "<!--end ThreadsBlock-->\n";
  
  return $ret;
}

sub display{
  my ($self, $STATE) = @_;
  print get($self, $STATE);
}

sub save{
  my ($self, $STATE) = @_;
  my $content = get($self, $STATE);
  $self->save1($content);
}



return 1;
