package Templates::Search;

use SmallPigVars qw($config);
use Templates::Default;

use strict;
use vars qw(@ISA $template $lang);

@ISA = qw(Templates::Default);

sub new{
  my ($class, $spcgi, $spdb) = @_;

  $template = Templates::Default->new($spcgi, $spdb, "index");

  $template->{'STATE'} = $spcgi->{'STATE'};
  $template->{'spdb'} = $spdb || SPDB->new;
  
  bless $template, $class;

  $template->initialize();
  
  return $template;
}

#########################################################################
# --- Sun Dec 19 23:06:10 PST 1999
# ---
sub initialize{
  my ($template) = @_;
  my ($STATE, $spdb) = map{ $template->{$_} } qw(STATE spdb);
  my $words = $STATE->{'words'};
  my $forums = $STATE->{'forum'};

  my $pagefiles = {};
  $pagefiles->{'index'} = "default.temp";
  
  $template->{'pagefiles'} = $pagefiles;

  my $pagesubs = {};
  $pagesubs->{'index'} = \&whole;
  
  $template->{'pagesubs'} = $pagesubs;

  $words =~ s/^\s+$//;
  if(!$words || $forums eq "all_forums"){
      # --- find out the accessible forums
      my ($sids) = $spdb->db_select_many_new(1, "sid", "Boards");
      
      my @asids;

      if($sids){

	  while (my $sid = $sids->fetchrow_array){
	      if($template->can_read($sid)){
		  push @asids, $sid;
	      }
	  }
	
	  $spdb->db_handler_done($sids);
  
	  $template->{'asids'} = \@asids;

      }
  }

  $lang = $template->{'lang'};
}

#########################################################################
# --- pagesubs
# ---
sub whole{
  my $STATE = $template->STATE;

  my $words = $STATE->{'words'};
  $template->SUPER::print_standard_index();
  print_search_form();

  $words =~ s/^\s+$//;
  if($words){
      print "<P>";
      $template->print_search_results();
      $template->print_page_index($template->{'totalnums'});
  }
  $template->print_adjust_font();
}

sub print_search_results{
  my ($self, $searchblock) = @_;
  my $theme = $template->{'theme'};

  $template->SUPER::print_block_start();

  my $STATE = $self->{'STATE'};
  my $spdb = $self->{'spdb'};
  my $asids = $self->{'asids'};
  my $DBH = $spdb->{'dbh'};
  my $sid = $STATE->{'forum'} || "all_forums";
  my $words = $STATE->{'words'};

  $words =~ s/^\s*//;
  $words =~ s/\s*$//;

  my $match = $STATE->{'match'} || "entire_phrase";
  my $page = $STATE->{'page'} || 1;
  my $postsper = $STATE->{'postsper'} || 30;
  my $sort = $STATE->{'sort'} || "date desc";
  my $view = $STATE->{'view'};
  my $mode = $STATE->{'mode'};

  my $select = "cid, B.sid, subject,
           date_format(P.date, \"$config->{date_format}\"),
           title";
  my $from = "Posts AS P, Boards AS B ";

  my $where;
  if($match eq "entire_phrase"){
    $where = " (bodytext LIKE '%$words%' OR subject LIKE '%$words%')";
  }
  elsif($match eq "or"){
    my @arr = split(/ +/, $words); 
    for(my $i=0; $i<@arr; $i++){
      $arr[$i] = $DBH->quote("%".$arr[$i]."%");
    }
    my $tmpwords = join(" OR bodytext LIKE ", @arr);
    $where = " (bodytext LIKE $tmpwords OR
                 subject LIKE $tmpwords) ";
  }
  elsif($match eq "and"){
    my @arr = split(/ +/, $words);
    for(my $i; $i<@arr; $i++){
      $arr[$i] = $DBH->quote("%".$arr[$i]."%");
    }
    my $tmpwords = join(" AND bodytext LIKE ", @arr);
    $where .= " (bodytext LIKE $tmpwords OR
                 subject LIKE $tmpwords) ";
  }
  $where   .= "AND B.sid = P.sid ";
  $where   .= "AND P.sid='$sid' " unless $sid eq "all_forums";

  if(defined($asids)){
      my $where1;
      foreach (@$asids){
	  $where1 .= "P.sid='$_' OR ";
      }
      $where1 =~ s/OR $//;
      $where .= "AND ($where1) " if $where1;
  }

  $where   .= "ORDER BY P.sid, P.$sort ";

  $template->{'totalnums'} = $spdb->db_count($from, $where);

  my $others;
  my $tmplimit = $postsper;
  if($page == 1){
    $others = "LIMIT $tmplimit";
  }
  else{ 
    my $tmpstart;
    $tmpstart = ($page-1)*$tmplimit; 
    $others = "LIMIT $tmpstart, $tmplimit";
  }
  
  my ($results) = $spdb->db_select_many_new(1, $select, $from, $where, $others);
  
  if($results){
      my $curr_sid = "";
      
        print qq!
<TR BGCOLOR=$theme->{'dhdrcolor'} CELLPADDING=2>
  <TD CLASS=bheader2><B>$lang->{'subject'}</B></TD>
  <TD CLASS=bheader2 WIDTH=25%><B>$lang->{'date'}</B></TD>
</TR>
    !;

      my $color = 1;
      while (my ($cid, $sid, $subject, $date, $title) = $results->fetchrow_array){
	  
  $date =~ s/(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)/$lang->{$1}/ig;

	  if($curr_sid ne $sid){
	      print "<TR BGCOLOR=$theme->{'lhdrcolor'}>
<TD CLASS=lbheader2 COLSPAN=2 ALIGN=center><B>$title</B></TD></TR>";
	      $curr_sid = $sid;
	      $color = 1;
	  }
	  # --- encode sid
	  $sid = $template->url_encode($sid);
	  
	  my $bgcolor = ($color==0)?$theme->{'lhdrcolor'}:$theme->{'llhdrcolor'};

	  print qq!
	<TR BGCOLOR="$bgcolor"><TD>&nbsp;
        <A HREF=$config->{'cgidir'}/comments.cgi?op=threadlist&sid=$sid&cid=$cid&display=$STATE->{'display'}&words=$words&match=$match&ssid=$sid>
	  $subject</A></TD><TD WIDTH=25%>$date</TD></TR>	  
	      !;
	  
	  $color = ($color==0)?1:0;
      }

      $spdb->db_handler_done($results);

  }
  else{
      print "<TR BGCOLOR=$theme->{'lhdrcolor'}><TD CLASS=header1 COLSPAN=2 ALIGN=center>$lang->{'no_match'} <B>$words</B>.</TD></TR>";
  }

  $STATE->{'totalmatches'} = "$lang->{'found'} $template->{'totalnums'} $lang->{'matches'}";
  
  $template->SUPER::print_block_end();
}

sub print_search_form{
  my ($STATE, $spdb) = map{ $template->{$_} } qw(STATE spdb);
  my $theme = $template->{'theme'};
  my $DBH = $spdb->{'dbh'};

  $template->SUPER::print_block_start("","",$lang->{'search_opts'});

  $STATE->{'forum'} = $STATE->{'sid'} if $STATE->{'sid'};
  my $forum = $template->select_forums($STATE->{'forum'});
  my $match = $template->select_option({($lang->{'or'}=>'or', 
				   $lang->{'entire_phrase'}=>'entire_phrase',
				   $lang->{'and'}=>'and')}, 
				      'match', $STATE->{'match'});
  my $limit = $template->select_option({('10'=>'10', 
					 '20'=>'20',
					 '30'=>'30', 
					 '40'=>'40',
					 '50'=>'50')}, 'postsper', $STATE->{'postsper'});
  my $words = $STATE->{'words'};
  print qq!
    <tr><td>
    <table border=0 width=100%  align=center>
    <tr><td align=center><font size="1">
	<form method=post action=$config->{'cgidir'}/search.cgi><B>$lang->{'words'}</B>
	<input type=text name=words size=20 value="$words">
	<input type=submit value=$lang->{'Submit'}> </font>
	</TD></TR>
      </TABLE>
      <TABLE BORDER=0 COLS=3 WIDTH=100%  ALIGN=center>
	<TR><TD ALIGN=right WIDTH=33%><B>$lang->{'forum_search'}:</B>&nbsp;&nbsp;</TD>
            <TD ALIGN=center><B>$lang->{'search_opts'}:</B></TD>
            <TD ALIGN=left WIDTH=33%><B>$lang->{'search_limit'}:</B></TD></TR>
	<TR><TD ALIGN=right WIDTH=33%><FONT SIZE="1">$forum</FONT></TD>
            <TD ALIGN=center><FONT SIZE="1">$match</FONT></TD>
            <TD ALIGN=left WIDTH=33%><FONT SIZE="1">$limit</FONT></TD></TR></TABLE>
    </TD></TR>
	  !;

  $template->SUPER::print_block_end();
}

sub select_forums{
  my ($template, $forum) = @_;
  my ($STATE, $spdb) = map{ $template->{$_} } qw(STATE spdb);
  my $DBH = $spdb->{'dbh'};
  my $ret;

  $ret = "<SELECT NAME=\"forum\"><FONT SIZE=-1>";
  $ret .= "<OPTION VALUE=\"all_forums\">$lang->{'all_forums'}";
  my ($value, $text);
  if($forum){
    my ($title) = $spdb->db_select_cols("title", "Boards", 
                                      "sid=".$DBH->quote($forum));
    $ret .= "<OPTION SELECTED VALUE=\"$forum\" SELECTED>$title" 
      if $title;
  }
  
  my ($foruma) = $spdb->db_select_many_new(1, "sid, title", "Boards");
  
  if($foruma){

      while (my ($forum1, $title) = $foruma->fetchrow_array){
	  
	  my $tmp = grep { $forum1 eq $_ } @{$template->{'asids'}} if defined($template->{'asids'});
	  if(!$tmp){
	      next;
	  }
    
	  $ret .= "<OPTION VALUE=\"$forum1\">$title" unless $forum eq $forum1;
      }

      $spdb->db_handler_done($foruma);

  }
  
  $ret .= "</FONT></SELECT>";
  return $ret;
}

sub can_read{
  my ($template, $sid) = @_;
  my ($spdb, $STATE) = map { $template->{$_} } qw(spdb STATE);
  my $DBH = $spdb->{'dbh'};

  my ($username, $uid, $user_status, $tuserstatus) = 
    map{ $STATE->{$_} } qw(username uid userstatus tuserstatus);
  my $sidq = $DBH->quote($sid);
  my ($level, $active);
  ($level, $active) = $spdb->db_select_cols("level, active", "Boards", 
					    "sid=$sidq");
  return 0 if(($user_status ne "admin" && $user_status ne "mod") &&
	      $active==0);
  my $status = get_board_status($level);

  # --- sid from mod userstatus --> ptr to arr
  my $sfmus = $tuserstatus->{mod};
  my $sfgmus = $tuserstatus->{gmem};

  return 1 if($user_status eq "admin" || 
	      ($sfmus && grep { $_ eq $sid } @$sfmus) || 
	      ($sfgmus && grep { $_ eq $sid } @$sfgmus) ||
	      (($user_status =~ /gmem/ || $user_status eq "ruser" ||
		$user_status =~ /mod/) && $status !~ /group private/) || 
	      ($user_status eq "anon" && $status =~ /public/));
  return 0;
}

sub get_board_status{
  my $level = shift;
  my $status = "public" unless 63^$level;
  $status = "public protected" unless 62^$level;
  $status = "user public" unless 60^$level;
  $status = "user private" unless 56^$level;
  $status = "user private protected" unless 48^$level;
  $status = "group private" unless 32^$level;
  return $status;
}

return 1;


