package Themes::default::theme;

require Exporter;
@ISA = qw(Exporter);
@EXPORT = qw(&get_stylesheet &get_theme);

use strict;
use vars qw($theme);

$theme = 
{(
  # --- images url: the location where the themes images are placed
  'imagesdir'           => "http://smallpig.net/my/default/images",

  # --- template path: the location of the templates
  'temp_path'           => "/usr/local/apache/cgi-bin/sporum/Themes/default/templates",
  
  # --- --- --- board layout
  # --- --- table properties
  # --- box width
  'tblwidth'            => "100%",
  # --- box alignment
  'tblalign'            => "right",
  # --- box cellspacing
  'tblcellspacing'      => "0",
  # --- box cellpadding
  'tblcellpadding'      => "1",
  # --- inner box width
  'intblwidth'          => "100%",
  # --- inner box alignment
  'intblalign'          => "right",
  # --- inner box cellspacing
  'intblcsp'            => "0",
  # --- inner box cellpadding
  'intblcp'             => "0",
  # --- --- layout colors
  # --- inner background color
  'inbgcolor'           => "#f7e8c6",
  # --- table border color
  'bdrcolor'            => "#ffcc00",
  # --- dark header and box border color
  'dhdrcolor'           => "#ffcc00",
  # --- light header 
  'lhdrcolor'           => "#f7e8c6",
  'llhdrcolor'          => "#ffffff",
  # --- box background color
  'boxbgcolor'          => "#ffffff",
  # --- caution dark header and box border color
  'cdhdrcolor'          => "#ff9900",
  # --- light header 
  'clhdrcolor'          => "#ffcc00",
  'cllhdrcolor'         => "#ffcc00",
  
  # --- icon images
  'post_image'          => "post.png",
  'prev_image'          => "prev.png",
  'all_image'           => "all.png",
  'next_image'          => "next.png",
  'print_image'         => "print.png",
  'expanded_image'      => "expanded.png",
  'collapsed_image'     => "collapsed.png",
  'flat_image'          => "flat.png",
  'threaded_image'      => "threaded.png",

  # --- Sun Sep 19 22:45:14 PDT 1999
  'markallposts_image'        => "mark_all_posts.png",
  'showallposts_image'        => "show_all_posts.png",
  'shownewposts_image'        => "show_new_posts.png",
  'threadallread_image'       => "thread_all_read.gif",
  'threadsomeread_image'      => "thread_some_read.gif",
  'threadwattachment_image'   => "thread_w_attachment.gif",
  'minus_image'               => "minus.gif",
  'plus_image'                => "plus.gif",
  'empty_image'               => "empty.gif",
  'readthread_image'          => "read_thread.gif",
  'unreadthread_image'        => "unread_thread.gif",
  'new_image'                 => "new.gif",
  'search_image'              => "search.png",

  'priv_msg_image'            => "priv_msg.gif",
  'add_msg_fav_image'         => "add_msg_fav.png",
  'reply_image'               => "reply.png",
  'edit_post_image'           => "edit_post.png",
  'parent_image'              => "parent.png",
  'send_to_friends_image'     => "send_to_friends.png",

  # --- --- column width
  # --- boards index
  'empty_w'             => "2%",
  'forums_w'            => "55%",
  'posts_w'             => "20%",
  'lastpost_w'          => "20%",
  # --- topics list
  # --- subject 
  'csubject_w'          => "50%",
  # --- poster
  'cuser_w'             => "20%",
  # --- replies
  'creplies_w'          => "10%",
  # --- lastmod
  'clastmod_w'          => "20%",
  # --- date
  'edate_w'             => "20%"
)};

sub get_theme{
    return $theme;
}

sub get_stylesheet{
   my ($template) = @_;
   my $STATE = $template->{'STATE'};    

   my $fontsize = $STATE->{'fontsize'};
   
   my ($cookie, $fontsize1);
   if(!$fontsize){
       $cookie = $template->{'spcgi'}->cookie('font_cookie');
       $fontsize1 = $cookie->[0] if $cookie;
   }

   my $curr = $fontsize || $fontsize1 || 9;
   
   my ($a, $as, $body, $td, $tdhdr1, $tdhdr2, $tdhdr3, $abhdr, 
       $tdbhdr1, $tdbhdrnb1, $tdbhdr2, $tdbhdrnb2, $tdlbhdr1, $tdlbhdr2,
       $input, $caution);
   $a = $curr;
   $as = $curr - 1;
   $body = $curr;
   $td = $curr;
   $tdhdr1 = $curr + 1;
   $tdhdr2 = $curr;
   $tdhdr3 = $curr - 1;
   $abhdr = $curr ;
   $tdbhdr1 = $curr + 1;
   $tdbhdrnb1 = $curr + 1;
   $tdbhdr2 = $curr;
   $tdbhdrnb2 = $curr;
   $tdlbhdr1 = $curr + 1;
   $tdlbhdr2 = $curr;
   $input = $curr;
   $caution = $curr;
   
   $template->{'css'} = qq~
<style type="text/css">

  a:link, a:hover { font-size: $a\pt; font-weight: bold; color: #000000; }
  a:visited { font-weight: bold; color: #000000; }
  a:active { font-weight: bold; color: #ffffff; }

  a.small:link, a:hover { font-size: $as\pt; font-weight: bold; color: #000000; }
  a.small:visited { font-weight: bold; color: #000000; }
  a.small:active { font-weight: bold; color: #ffffff; }
 
  body { font-size: $body\pt; font-family: helvetica,arial; color: #000066; }  

  td { font-size: $td\pt; font-family: helvetica,arial; }

  td.header1 { font-size: $tdhdr1\pt; font-family: helvetica,arial; font-weight: bold;
    color: #000000; }
  td.header2 { font-size: $tdhdr2\pt; font-family: helvetica,arial; font-weight: bold;
    color: #000000; }
  td.header3 { font-size: $tdhdr3\pt; font-family: helvetica,arial; font-weight: bold;
    color: #000000; }

  a.bheader:link, a.bheader:hover { font-size: $abhdr\pt; font-weight: bold; color: #ffffff; }
  a.bheader:visited { font-weight: bold; color: #ffffff; }
  a.bheader:active { font-weight: bold; color: #000000; }

  td.bheader1 { font-size: $tdhdr1\pt; font-family: helvetica,arial; font-weight: bold;
    color: #ffffff; }
  td.bheader1nb { font-size: $tdbhdrnb1\pt; font-family: helvetica,arial; color: #ffffff; }
  td.bheader2 { font-size: $tdbhdr2\pt; font-family: helvetica,arial; font-weight: bold;
    color: #ffffff; }
  td.bheader2nb { font-size: $tdbhdrnb2\pt; font-family: helvetica,arial; color: #ffffff; }
  td.lbheader1 { font-size: $tdlbhdr1\pt; font-family: helvetica,arial; font-weight: bold;
    color: #ffffff; }
  td.lbheader2 { font-size: $tdlbhdr2\pt; font-family: helvetica,arial; font-weight: bold;
    color: #ffffff; }
 
  input { font-size: $input\pt; font-family: helvetica,arial; }

  p.caution { font-size: $caution\pt; font-family: helvetica,arial; font-weight: bold;
    color: #ff6600; }

  font.caution { font-size: $caution\pt; font-family: helvetica,arial; color: #ff6600; }
</style>	
    ~;
  
}
