#!/usr/local/bin/perl
BEGIN {
  unshift(@INC, "/usr/local/apache/cgi-bin/sporum");
}

use SPDB;
use SmallPigVars qw($config);

sub main{
    my $spdb = SPDB->new();
    
    my $query = qq|
CREATE TABLE $config->{'rest_tbl'}Cats(
# --- Fri Sep  3 14:06:33 PDT 1999
# --- VARCHAR(20) -> VARCHAR(50)
catid         VARCHAR(50)  NOT NULL,	# --- category id
cattitle      VARCHAR(100) NOT NULL,	# --- category title
catorder      INT(11)      NOT NULL,	# --- category order
#isserver      INT(1)       NOT NULL     # --- is it a news server?
#DEFAULT 0, 

PRIMARY KEY (catid),
INDEX index1 (catorder)
)
    |;
    $spdb->db_do_query($query);

    $query = qq|
CREATE TABLE $config->{'rest_tbl'}Boards(
# --- Fri Sep  3 14:06:33 PDT 1999
# --- VARCHAR(20) -> VARCHAR(50)
sid           VARCHAR(50)  NOT NULL,	# --- board id
title         VARCHAR(100) NOT NULL,	# --- board title
introtext     TEXT,			# --- board description 
commentcount  INT(10)      NOT NULL 	# --- number of comments in board	
DEFAULT 0,                              
hits          INT(11)      NOT NULL,	# --- number of hits
       	
html          INT(1)       NOT NULL 	# --- allow html in board
DEFAULT 0,		
markup 	      INT(1) 	   NOT NULL 
DEFAULT 0,				# --- allow markup in board
expire        INT(11)      NOT NULL 
DEFAULT 0,				# --- expire period 
level         INT(3)       NOT NULL 
DEFAULT 510,				# --- level of board
active        INT(1)       NOT NULL 
DEFAULT 1,				# --- active bool
approved      INT(1)       NOT NULL 
DEFAULT 1,				# --- threads need to be approved 
lastmod       DATETIME     NOT NULL 	# --- last modified
DEFAULT '0000-00-00-00 00:00:00',

subscription  INT(1)       NOT NULL     # --- allow subcription
DEFAULT 0,
fileattach    INT(1)       NOT NULL     # --- allow file attachment
DEFAULT 0,				
	
PRIMARY KEY (sid)
)
    |;

    $spdb->db_do_query($query);

    $query = qq|
# --- relation between Boards and Cats
CREATE TABLE $config->{'rest_tbl'}BoardBelongToCat(
# --- Fri Sep  3 14:06:33 PDT 1999
# --- VARCHAR(20) -> VARCHAR(50)
catid         VARCHAR(50)  NOT NULL,	# --- category id
sid           VARCHAR(50)  NOT NULL,	# --- board id
sorder        INT(11)      NOT NULL,	# --- board order
date          DATETIME     NOT NULL 	# --- created on
DEFAULT '0000-00-00-00 00:00:00',

PRIMARY KEY (catid, sid),
UNIQUE index4 (catid, sorder),
INDEX index1 (catid),
INDEX index2 (sid),
INDEX index3 (sorder)
)
    |;
    
    $spdb->db_do_query($query);
    
    $query = qq|
CREATE TABLE $config->{'rest_tbl'}Posts(
cid 	      INT(11)      NOT NULL,    # --- comment id
# --- Fri Sep  3 14:06:33 PDT 1999
# --- VARCHAR(20) -> VARCHAR(50)
sid           VARCHAR(50)  NOT NULL,	# --- board id
uid           INT(11)      NOT NULL,	# --- user id
pid           INT(11)      NOT NULL,    # --- parent id
subject       VARCHAR(100) NOT NULL,   	# --- comment subject
bodytext      TEXT,			# --- comment body
hits          INT(11)      NOT NULL 
DEFAULT 0,				# --- hits on this comment
ip            VARCHAR(50),		# --- user ip
closed        INT(1)       NOT NULL 
DEFAULT 0,			       	# --- closed bool
approved      INT(1)       NOT NULL 
DEFAULT 1, 				# --- approved bool
# --- new emailreply row added in Sporum 1.1+
emailreply    INT(1)       NOT NULL,   	# --- email reply to user
date          DATETIME     NOT NULL 	# --- posted on 
DEFAULT '0000-00-00-00 00:00:00',	

# --- Mon Jan 17 18:58:29 PST 2000
hasatt        INT(1)       NOT NULL
DEFAULT 0,				# --- has file attachments
	
PRIMARY KEY (cid),
INDEX index1 (sid)
)
    |;

    $spdb->db_do_query($query);

    $query = qq|
# --- relation between Comments and Comments
CREATE TABLE $config->{'rest_tbl'}ParentAndChild(
parentid      INT(11)      NOT NULL,    # --- parent id
childid       INT(11)      NOT NULL,    # --- children id

PRIMARY KEY (parentid, childid),
INDEX index1 (parentid),
INDEX index2 (childid)
)
    |;
    
    $spdb->db_do_query($query);

    $query = qq|
CREATE TABLE $config->{'rest_tbl'}MostParents(
cid 	      INT(11)      NOT NULL,    # --- comment id
# --- Fri Sep  3 14:06:33 PDT 1999
# --- VARCHAR(20) -> VARCHAR(50)
sid           VARCHAR(50)  NOT NULL,	# --- board id
lastmod       DATETIME     NOT NULL 	# --- last modified
DEFAULT '0000-00-00-00 00:00:00',
replies       INT(11)      DEFAULT 0,   # --- number of reply

PRIMARY KEY (cid),
INDEX index1 (sid)
)
    |;

     $spdb->db_do_query($query);

    $query = qq|
CREATE TABLE $config->{'user_tbl'}Users(	
uid           INT(11)      NOT NULL,	# --- user id
username      CHAR(30)     NOT NULL,	# --- username
passwd        CHAR(50) 	   NOT NULL,	# --- password
nickname      CHAR(50)     NOT NULL,	# --- nickname
realname      CHAR(50),			# --- real name
realemail     CHAR(50),			# --- real email
fakeemail     CHAR(50),			# --- fake email
homepage      CHAR(100),		# --- homepage
bio           TEXT,			# --- bio
icq           VARCHAR(50),		# --- icq
cookieexpire  CHAR(5)      NOT NULL 	# --- login cookie expire
DEFAULT '+1d',
lastlogon     DATETIME     NOT NULL,	# --- last logon
active        INT(1)       NOT NULL 	# --- status - 0, 1, 2
DEFAULT 0,
peek          INT(11) UNSIGNED NOT NULL,# --- hits on the user profile
registered    DATETIME     NOT NULL,	# --- registered on
isadmin       INT(1)       NOT NULL     # --- is user a admin?   
DEFAULT 0,

# --- 8/27/99
location      VARCHAR(150),             # --- user location
photourl      VARCHAR(150),             # --- location of photo
privlev       INT(1)       NOT NULL,    # --- privacy level

# --- 9/12/99
lastresp      DATETIME     NOT NULL,    # --- last response

PRIMARY KEY (uid, username),
INDEX index1 (uid),
INDEX index2 (username)
)
    |;

    $spdb->db_do_query($query);

    $query = qq|
# --- Sun Jan 23 12:17:10 PST 2000
CREATE TABLE $config->{'user_tbl'}BoardPrefs(
uid           INT(11)      NOT NULL,	# --- user id

sort          VARCHAR(20)  
DEFAULT "date desc", 			# --- sort
display       CHAR(11)    
DEFAULT "threaded",			# --- display mode
view          CHAR(10)    
DEFAULT "collapsed",			# --- view mode
postsper      INT(11)      DEFAULT 10,	# --- posts per page
sig           TEXT,			# --- sig
cookieexpire  CHAR(5)      NOT NULL 	# --- login cookie expire
DEFAULT '+1d',

# --- 8/30/99
theme         VARCHAR(100) NOT NULL     # --- theme
DEFAULT "default",

# --- Sun Jan 23 12:20:21 PST 2000
lang    	VARCHAR(100) 	NOT NULL	# --- language
DEFAULT "default",

PRIMARY KEY (uid)
)
    |;
    
    $spdb->db_do_query($query);

    $query = qq|
# --- relation between Boards and Users
CREATE TABLE $config->{'user_tbl'}Moderators(
# --- Fri Sep  3 14:06:33 PDT 1999
# --- VARCHAR(20) -> VARCHAR(50)
sid           VARCHAR(50)  NOT NULL,	# --- board id
uid           INT(11)      NOT NULL,	# --- user id
assigned      DATETIME     NOT NULL,	# --- assigned on

PRIMARY KEY (sid, uid),
INDEX index1 (sid),
INDEX index2 (uid)
)
    |;

    $spdb->db_do_query($query);

    $query = qq|
# --- relation between Boards and Users
CREATE TABLE $config->{'user_tbl'}GroupMems(
# --- Fri Sep  3 14:06:33 PDT 1999
# --- VARCHAR(20) -> VARCHAR(50)
sid           VARCHAR(50)  NOT NULL,	# --- board id
uid           INT(11)      NOT NULL,	# --- user id
assigned      DATETIME     NOT NULL,	# --- assigned on
	
# --- Sun Sep 12 20:56:41 PDT 1999
allowwrite    INT(1)       NOT NULL     # --- allow write?
DEFAULT 1,

PRIMARY KEY (sid, uid),
INDEX index1 (sid),
INDEX index2 (uid)
)
    |;

    $spdb->db_do_query($query);

    $query = qq|
CREATE TABLE $config->{'user_tbl'}SubscribeBoard(
# --- Fri Sep  3 14:06:33 PDT 1999
# --- VARCHAR(20) -> VARCHAR(50)
sid           VARCHAR(50)  NOT NULL,	# --- board id
uid           INT(11)      NOT NULL,	# --- user id
eformat       INT(1)       NOT NULL
DEFAULT 1,                              # --- email options
date          DATETIME     NOT NULL,	# --- subscribed on

PRIMARY KEY (sid, uid),
INDEX index1 (sid),
INDEX index2 (uid)
)
    |;
    
    $spdb->db_do_query($query);

    $query = qq|
CREATE TABLE $config->{'rest_tbl'}FileAttach(
fid 	     INT(11)	   NOT NULL,	# --- file attachment id
# --- Fri Sep  3 14:06:33 PDT 1999
# --- VARCHAR(20) -> VARCHAR(50)
sid          VARCHAR(50)   NOT NULL	# --- board id
DEFAULT "null",
# --- Fri Sep  3 14:06:33 PDT 1999
# --- VARCHAR(20) -> INT(11)
cid          INT(11)       NOT NULL 	# --- board id
DEFAULT "null",		
fname        VARCHAR(100)  NOT NULL,	# --- file name
fdesc        TEXT,			# --- file description
fsize        INT(11)       NOT NULL, 	# --- file size
date         DATETIME     NOT NULL 	# --- file time stamp
DEFAULT '0000-00-00-00 00:00:00',	

# --- Sun Jan 16 00:05:45 PST 2000
fcontenttype    VARCHAR(30),                    # --- content type

PRIMARY KEY (fid),
INDEX index1 (sid),
INDEX index2 (cid)
)
    |;

    $spdb->db_do_query($query);

    $query = qq|
CREATE TABLE SymLock(
slid		INT(11)		NOT NULL,
sym		VARCHAR(50)	NOT NULL,
uid		INT(11)		NOT NULL,
date		DATETIME  	NOT NULL 	
DEFAULT '0000-00-00-00 00:00:00',	

PRIMARY KEY (slid),
UNIQUE index1 (sym, uid) 
)
    |;
    
    $spdb->db_do_query($query);
    
    $query = qq|
# --- Fri Sep 17 18:35:17 PDT 1999
CREATE TABLE $config->{'rest_tbl'}AnonPosts(
cid           INT(11)      NOT NULL,    # --- comment id
sid           VARCHAR(50)  NOT NULL,    # --- board id
anon          CHAR(30)     NOT NULL     # --- username
DEFAULT "anon",
email         CHAR(50),                 # --- email 

PRIMARY KEY (cid)
)
    |;
    
    $spdb->db_do_query($query);

}

print main();


