#!/usr/local/bin/perl
BEGIN {
  unshift(@INC, "/usr/local/apache/cgi-bin/sporum");
}

use SPDB;

sub main{
    my $spdb = SPDB->new();

    # --- add file hasatt
    my ($cids) = $spdb->db_select_many(1, "cid", "Posts");
    
    my ($succ, $err) = (1);
    foreach (@$cids){
	my ($cid) = @$_;
	my $data = {('hasatt'=>1)};
	($succ, $err) = $spdb->db_update("Posts", $data, "cid=$cid") 
	    if $spdb->db_count("FileAttach", "cid=$cid") > 0;

	return $err if !$succ;
    }

    my $query = qq|
# --- Sun Jan 23 12:17:10 PST 2000
CREATE TABLE BoardPrefs(
uid           INT(11)      NOT NULL,	# --- user id

sort          VARCHAR(20)  
DEFAULT "date desc", 			# --- sort
display       CHAR(11)    
DEFAULT "threaded",			# --- display mode
view          CHAR(10)    
DEFAULT "collapsed",			# --- view mode
postsper      INT(11)      DEFAULT 10,	# --- posts per page
sig           TEXT,			# --- sig

# --- 8/30/99
theme         VARCHAR(100) NOT NULL     # --- theme
DEFAULT "default",

# --- Sun Jan 23 12:20:21 PST 2000
lang    	VARCHAR(100) 	NOT NULL	# --- language
DEFAULT "default",

PRIMARY KEY (uid)
)
    |;
    
    $spdb->db_do_query($query);

    my ($users) = $spdb->db_select_many(1, "uid, sort, display, view, postsper, sig, theme", "Users");

    foreach (@$users){
	my ($uid, $sort, $display, $view, $postsper, $sig, $theme, $cookieexpire) = @$_;
	
	my $data = {('uid'=>$uid,
		     'sort'=>$sort,
		     'display'=>$display,
		     'view'=>$view,
		     'postsper'=>$postsper,
		     'sig'=>$sig,
		     'theme'=>$theme)};
        ($succ, $err) = $spdb->db_insert("BoardPrefs", $data);

	return $err if !$succ;
    }

    
    $query = qq|
ALTER 	TABLE  	Users	DROP COLUMN sort, 
			DROP COLUMN display,
			DROP COLUMN view,
			DROP COLUMN postsper,
			DROP COLUMN sig,
			DROP COLUMN theme
	|;

    $spdb->db_do_query($query);

     $query = qq|
 ALTER 	TABLE   FileAttach ADD fcontenttype    VARCHAR(30)
     |;
    
    $spdb->db_do_query($query);

    return "Update succeed!\n";
}

print main();


