package Templates::Admin::AssignUsersList;

use strict;
use vars qw(@ISA);

@ISA = qw(Templates::Admin::OptBlock);

my %CACHE;

my $lang;

sub new{
  # --- assign moderator
  # --- assign group 
  # --- revoke modertor
  # --- revoke group
  my ($class, $STATE, $spdb) = @_;
  my $title;
  my ($op, $prev_op) = map{ $STATE->{$_} } qw(op prev_op);

  $lang = $STATE->{'langptr'};

  if($op eq "assignmod" || $prev_op =~ "assignmod"){
    $title = $lang->{'assign_mod1'};
  }
  elsif($op eq "revokemod" || $prev_op =~ "revokemod"){
    $title = $lang->{'revoke_mod1'};
  }
  elsif($op eq "grantgroup" || $prev_op =~ "grantgroup"){
    $title = $lang->{'grant_group1'};
  }
  else{
    $title = $lang->{'revoke_group1'};
  }
  
  my $theme = $STATE->{'theme'};
  
  my $classvars = {('title' => $title)};
  my $self = Templates::Admin::OptBlock->new($classvars, $theme);
  $self->{'spdb'} = $spdb || SPDB->new();
  $self->{'STATE'} = $STATE;
  my $id = join '', sort values %$self, "assignuserslist";
  return $CACHE{$id} if $CACHE{$id};
  return $CACHE{$id} = bless $self, $class;
}

sub get{
  my $self = shift;
  $self->{'content'} = $self->_get_assignmodorgrouplist();
  $self->SUPER::get();
}

sub _get_assignmodorgrouplist{
  my ($self) = @_;
  my $STATE = $self->{'STATE'};
  my $op = $STATE->{'op'};
  my $ret;
  if(($op eq "assignmod" || $op eq $lang->{'PreviewModerator'}) ||
     ($op eq "revokemod")){
    $ret = $self->assignmodlist($STATE);
  }
  else{
    $ret = $self->assigngrouplist($STATE);
  }

  return $ret;
}

sub assigngrouplist{
  my ($self, $STATE) = @_;
  my $spdb = $self->{'spdb'};
      
  $lang = $STATE->{'langptr'};

  my ($uid, $tboards, $tusers, $user_status, $allowwrite, $op, $prev_op) = 
    map { $STATE->{$_} } qw(uid boards users userstatus allowwrite op prev_op);
  my (@tboards, @tusers);
  if($tboards && $tusers) {
    @tboards = split("#", $tboards); #sids
    @tusers = split("#", $tusers);   #uids
  }
  
  my $from  = "Boards AS B";
  my $where .= "(level=32) ";

  # --- if user is moderator
  if($user_status =~ /mod/){
    $from    .= ", Moderators AS M";
    $where    .= "AND B.sid=M.sid AND M.uid=$uid";
  }
  my ($boards) = $spdb->db_select_many(1, "B.sid, title, level", 
				      $from, $where);
  
  my $ret;
  
  $ret .= "<TR><TD VALIGN=top ALIGN=right WIDTH=25%>
$lang->{'amblocks'}:</TD>
<TD WIDTH=25%><SELECT NAME=boards SIZE=6 multiple>";
  foreach (@$boards){
    my ($sid, $title) = @$_; my $cnt = 0; my $flag = 1;
    foreach (@tboards){
      if($sid eq $_){
	$ret .= "<OPTION VALUE=\"$sid\" SELECTED>$title\n";
	splice @tboards, $cnt, 1;
	$cnt++; $flag=0;
      }
    }
    if($flag){ $ret .= "<OPTION VALUE=\"$sid\">$title\n"; }
  }
  
  my ($users) = $spdb->db_select_many(1, "uid, username, isadmin", 
				      "Users", "active=1",
				      "ORDER BY username");
  
  $ret .= "</SELECT></TD><TD VALIGN=top ALIGN=right WIDTH=25%>
$lang->{'amuser'}:</TD>
<TD WIDTH=25%><SELECT NAME=users SIZE=6 multiple>";
  
 GO:
  foreach (sort {$b <=> $a }@$users){
    my ($uid, $username, $isadmin) = @$_; my $cnt = 0; my $flag = 1;
    
    if($isadmin){
      next GO;
    }

    foreach (sort {$b <=> $a }@tusers){
      # find all the user except default user and admin and mod
      if($uid == $_){
	$ret .= "<OPTION VALUE=$uid SELECTED>$username\n";
	splice @tboards, $cnt, 1;
	$cnt++; $flag=0;
      }
    }
    if($flag && $uid != 0){ 
      $ret .= "<OPTION VALUE=$uid>$username\n"; 
    }   
  }

  my $checkbox;
  if($op eq "grantgroup" || $prev_op =~ /grantgroup/){
      my $check = ($allowwrite eq "yes")?"checked":"";
      $checkbox = qq!<BR><input type="checkbox" name="allowwrite" value="yes" $check>
	  $lang->{'allow_write'}!;
  }

  $ret .= "</SELECT>$checkbox</TD></TR>";
  
  return $ret;
}

sub assignmodlist{
  my ($self, $STATE) = @_;
  my $spdb = $self->{'spdb'};
  
  $lang = $STATE->{'langptr'};

  my ($tboards, $tusers) = map { $STATE->{$_} } qw(boards users);
  my (@tboards, @tusers);
  if($tboards && $tusers) {
    @tboards = split("#", $tboards); #sids
    @tusers = split("#", $tusers);   #uids
  }
  
  my ($boards) = $spdb->db_select_many(1, "sid, title", "Boards");
  
  my $ret;
  
  $ret .= "<TR><TD VALIGN=top ALIGN=right WIDTH=25%>
$lang->{'amblocks'}:</TD>
<TD WIDTH=25%><SELECT NAME=boards SIZE=6 multiple><font size=1>";
  foreach (@$boards){
    my ($sid, $title) = @$_; my $cnt = 0; my $flag = 1;
    foreach (@tboards){
      if($sid eq $_){
	$ret .= "<OPTION VALUE=\"$sid\" SELECTED>$title\n";
	splice @tboards, $cnt, 1;
	$cnt++; $flag=0;
      }
    }
    if($flag){ $ret .= "<OPTION VALUE=\"$sid\">$title\n"; }
  }
  
  my ($users) = $spdb->db_select_many(1, "uid, username", "Users",
				      "isadmin=0 AND active=1",
				      "ORDER BY username");
  
  $ret .= "</font></SELECT></TD><TD VALIGN=top ALIGN=right WIDTH=25%>
$lang->{'amuser'}:</TD>
<TD WIDTH=25%><SELECT NAME=users SIZE=6 multiple><font size=1>";
  
 GO:
  foreach (sort {$b <=> $a } @$users){
    my ($uid, $username) = @$_; my $cnt = 0; my $flag = 1;
    
    foreach (sort {$b <=> $a } @tusers){
      if($uid == $_){
	$ret .= "<OPTION VALUE=$uid SELECTED>$username\n";
	splice @tboards, $cnt, 1;
	$cnt++; $flag=0;
      }
    }
    if($flag && $uid != 0){ 
      $ret .= "<OPTION VALUE=$uid>$username\n"; 
    }   
  }
  $ret .= "</font></SELECT></TD></TR>";
  
  return $ret;

}

return 1;
