package Templates::Admin::Boards;

use SmallPigVars qw($config);
use Templates::Admin::SmallPig;
use SPDB;

use CGI qw(:standard *table :cgi-lib);
use CGI::Cookie ();

use strict;
use vars qw(@ISA);

@ISA = qw(Templates::Admin::OptBlock);

my $lang;

sub new{
  # --- expire threads   (1)
  # --- open threads     (1)
  # --- close threads    (1)
  # --- approve threads  (1)
  # --- move copy threads(1)
  # --- index.cgi        (1)
  # --- list the boards information for above operations
  my ($class, $STATE, $spdb) = @_;
  my $theme = $STATE->{'theme'};

  $lang = $STATE->{'langptr'};

  my $self = Templates::Admin::OptBlock->new({}, $theme);
  $self->{'STATE'} = $STATE;
  $self->{'spdb'} = $spdb || SPDB->new();
  
  return bless $self, $class;
}

sub DESTROY{
    my $self = shift;
    my $spdb = $self->{'spdb'};
    $spdb->db_disconnect($spdb->{'dbh'});
}

sub get_boards {
  my ($self, 
      $btitle, $bcontent1, $bcontent2,
      $showlink, $numoffield) = @_;
  my ($STATE, $spdb) = map{ $self->{$_} } qw(STATE spdb);
  my $DBH = $spdb->{'dbh'};
  my $theme = $STATE->{'theme'};

  my ($view, $lastlogon, $uid, $username, $userstatus, $op, $nps, $mostparent);
  ($view, $lastlogon, $uid, $username, $userstatus, $op, $nps, $mostparent) = 
      map{ $STATE->{$_} } 
  qw(view lastlogon uid username userstatus op nps mostparent);
  my $lastlogonq = $DBH->quote($lastlogon);

  my ($cats) = $spdb->db_select_many(1, "catid, cattitle",
				    "Cats",
				    "", "ORDER BY catorder");
  
  my $ret;
  $ret .= &{$btitle}();  
  # --- if there is no categories
  unless($cats){
    $ret .= CGI::Tr({}, 
		    [CGI::td({-colspan=>$numoffield},
			     [$lang->{'no_categories'}])]);
  }

  # --- loop through all the categories
  my $has_board = 0;
  foreach (@$cats){
    my ($catid, $cattitle) = @$_;
    my $catidq = $DBH->quote($catid);

    my $select = "B.sid, title, commentcount,  
                  date_format(lastmod, \"$config->{date_format}\"),
                  introtext, active, sorder";
    my $where = " B.sid=BC.sid AND BC.catid=$catidq ";
    
    # --- only public forum visible for anon
    $where .= "AND level>=60 AND active=1 "
      if($userstatus eq "anon");
    
    # --- user forum visible for ruser, gmem, mod
    $where .= "AND level>=48 AND active=1 "
      if($userstatus eq "ruser" ||
	 $userstatus =~ /gmem/ ||
	 $userstatus =~ /mod/);

    my ($boards, $from);
    if($op eq "boardindex" || $userstatus eq "admin" || 
       $op eq "subscribe" || $op eq "umovethreads"){}
    # --- from admin page
    else{
      $where .= "AND B.sid=M.sid AND uid=$uid";
      $from = "Moderators AS M, ";
    }
    $from .= " Boards AS B, BoardBelongToCat AS BC";

    # --- select public and user forums
    ($boards) = $spdb->db_select_many(1, $select, 
				     $from, 
				     $where);

    # --- if user is a moderator in group private forums
    if($userstatus =~ /mod/){
      $where = "BC.sid=M.sid AND uid=$uid AND active=1 AND
                (level=32) AND B.sid=M.sid AND
                BC.catid=$catidq ";
      $from = "Boards AS B, BoardBelongToCat AS BC, Moderators AS M";
      my ($boards1) = 
	$spdb->db_select_many(1, $select, $from, $where);
      unshift @$boards, @$boards1 if $boards1;      
    }
  
    # --- if user is a group mem in group private forums
    if($userstatus =~ /gmem/){
      $where = "BC.sid=M.sid AND uid=$uid AND active=1 AND
                (level=32) AND B.sid=M.sid AND
                BC.catid=$catidq ";
      $from = "Boards AS B, BoardBelongToCat AS BC, GroupMems AS M";
      my ($boards1) = 
	$spdb->db_select_many(1, $select, $from, $where);
      unshift @$boards, @$boards1 if $boards1;      
    }    

    # --- sort the boards by sorder
    @$boards = sort { $a->[6] <=> $b->[6]; } @$boards if $boards;

    # --- no forums
    if(!$boards){
	$ret .= qq| 
<TR BGCOLOR=$theme->{'lhdrcolor'}>
  <TD COLSPAN=$numoffield>
    <B>$cattitle</B>
  </TD>
</TR>  
<TR BGCOLOR=$theme->{'boxbgcolor'}>
  <TD WIDTH=10 BGCOLOR=$theme->{'lhdrcolor'}>&nbsp;
</TD><TD COLSPAN=3>
  $lang->{'no_forums'}</TD>
</TR>
<TR BGCOLOR=$theme->{'dhdrcolor'}><TD WIDTH=10></TD>
  <TD COLSPAN=3></TD></TR>
      | if $config->{'display_no_forums'} eq "yes";

    }
    # --- has forums
    else {
	$has_board = 1;
    # --- display cattitle
	$ret .= qq!
<TR BGCOLOR=$theme->{'lhdrcolor'}>
  <TD CLASS=lbheader2 COLSPAN=$numoffield>
    <B>$cattitle</B>
  </TD>
</TR>  
    !;

      my $cnt = 0;
      
      foreach (@$boards) {
	my ($sid, $title, $commentcount, $lastmod, $introtext) = @$_;

 $lastmod =~ s/(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)/$lang->{$1}/ig;

	my $sidq = $DBH->quote($sid);
	$cnt++;
	$lastmod = $lang->{'no_posts'} unless $lastmod;
	
	my $newpost;
	
	# --- deal with the cookie
	if($userstatus ne "anon" && $lastlogon) {

	    my $cnt1 = $self->count_new_posts($sid, $nps);

	    $newpost = "<b><FONT class=\"caution\">($cnt1 $lang->{'new'})</FONT></B>" 
		if($cnt1);
	}# --- end dealing with cookie
	
	# --- encode sid
	my $sid1 = Templates::Admin::SmallPig::url_encode($sid);
	# --- deal with url and posts
	$newpost = "" if($op ne "boardindex");

	my ($url, $tmp);
	if($op eq "expirethreads"){
	    if($mostparent){
		$url = "admin.cgi?op=expirethreads&sid=$sid1&mostparent=$mostparent";
		$commentcount = 
		    $spdb->db_count("MostParents AS MP, Posts AS P",
				    "MP.sid=$sidq AND MP.cid=P.cid ");
	    }
	    else{
		$url = "admin.cgi?op=expirethreads&sid=$sid1&";
		$commentcount = $spdb->db_count("Posts", "sid=$sidq");
	    }
	}
	elsif($op eq "closethreads"){
	  $url = "admin.cgi?op=closethreads&sid=$sid1";
	  $commentcount = 
	    $spdb->db_count("MostParents AS MP, Posts AS P",
			    "MP.sid=$sidq AND MP.cid=P.cid AND
                              closed=0 AND approved=1");
	}
	elsif($op eq "openthreads"){
	  $url = "admin.cgi?op=openthreads&sid=$sid1";
	  $commentcount = 
	    $spdb->db_count("MostParents AS MP, Posts AS P",
			   "MP.sid=$sidq AND MP.cid=P.cid AND
                              closed=1 AND approved=1");
	}
	elsif($op eq "approvethreads"){
	  $url = "admin.cgi?op=approvethreads&sid=$sid1";
	  $commentcount = 
	    $spdb->db_count("Posts", "sid=$sidq AND approved=0");
	}
	elsif($op eq "movecopythreads"){
	  $url = "admin.cgi?op=movecopythreads&sid=$sid1";
	  $commentcount = 
	      $spdb->db_count("Posts", "sid=$sidq AND approved=1");
	}
	elsif($op eq "umovethreads"){
	  $url = "user.cgi?op=umovethreads&sid=$sid1&uid=$uid";
	  $commentcount = 
	      $spdb->db_count("Posts", "sid=$sidq AND approved=1 
                                        AND uid=$uid");
	}
	else{
	  $url = "comments.cgi?op=topicslist&page=1&sid=$sid1&view=$view";
	}
	$tmp = "<B>$title</B>";
	$tmp = CGI::a({-href=>"$config->{'cgidir'}/$url"},$tmp)
	  if($commentcount || (!$commentcount && $showlink));
	$ret .= &{$bcontent1}($tmp, $commentcount, $newpost, 
			      $lastmod, $introtext, $sid, $uid);
      }
      unless($cnt){
	$ret .= qq| 
<TR><TD WIDTH=10>&nbsp;</TD><TD COLSPAN=3>$lang->{'no_forums'}</TD></TR> 
  |;
      }
    }
  } # --- end cats
  return "" if !$has_board;
  $ret .= &{$bcontent2}() if $bcontent2;
  $self->{'content'} = $ret;
  $self->SUPER::get();  
}

sub count_new_posts{
  my ($self, $sid, $nps) = @_;
  my $spdb = $self->{'spdb'};
  my $DBH = $spdb->{'dbh'};
  my @nps = split(/\,/, $nps);
 
  # --- make sure the posts are in database
  my ($cnt, $where);
  foreach (@nps){
      $where .= "cid=$_ OR ";
  }
  $where =~ s/OR $//;
  if ($where){
      my $sidq = $DBH->quote($sid);
      $where = "($where) AND sid=$sidq";
      $cnt = $spdb->db_count("Posts", $where) if $where;
  }

  return $cnt;
}

return 1;




