package Templates::Admin::CreateBoard;

use SmallPigVars qw($config);
use Templates::Admin::SmallPig;
use SPDB;
use CGI qw(:standard :cgi-lib);
use CGI::Cookie ();

use Templates::Admin::Block;
use Templates::Admin::OptBlock;

use strict;

my @ISA = qw(Templates::Admin::Block);

my $lang;

sub new{
  my ($class) = @_;
  my $self = Templates::Admin::Block->new();
  $self->{'spdb'} = SPDB->new;

  return bless $self, $class;
}

sub DESTROY{
    my $self = shift;
    my $spdb = $self->{'spdb'};
    $spdb->db_disconnect($spdb->{'dbh'});
}

sub display{
    my ($self, $STATE) = @_;
    my $op = "";
    $op = $STATE->{'op'};

    $lang = $STATE->{'langptr'};

    my $theme = $STATE->{'theme'};
    my $standardindex = Templates::Admin::StandardIndex->new($STATE);

    my $content;
    $content = "<TR><TD>".$self->_get_createboard($STATE)."</TR></TD>";
    my $classvars = {('title' => $lang->{'create_board1'},
		      'content' => $content)};
    my $createboard = Templates::Admin::OptBlock->new($classvars, $theme);

    my $ret;
    $ret = qq|<form method="post" action="$config->{'cgidir'}/admin.cgi">|;
    $ret .= $standardindex->get();
    $ret .= $createboard->get()."<font size=1>";
    $ret .= qq|<input type="submit" name="op" value="$lang->{'SaveBoard'}">|;
    $ret .= "</font></form></td>";
    
    return $ret;
}

sub _get_createboard{
  my ($self, $STATE) = @_;
  my $spdb = $self->{'spdb'};
  my $DBH = $spdb->{'dbh'};

  my $ret = "";
  my ($selectedboard, $op);
  ($selectedboard, $op) = map{ $STATE->{$_} } qw(selectedboard op);
  my $sidq = $DBH->quote($selectedboard);

  my $select = "sid, title, introtext, html, level, markup,
                active, expire, approved, fileattach, subscription";
  my ($sidv, $titlev, $introtextv, $htmlv, $levelv, $markupv,
      $activev, $expirev, $approvedv, $fileattachv, $subscriptionv);
  ($sidv, $titlev, $introtextv, $htmlv, $levelv, $markupv,
      $activev, $expirev, $approvedv, $fileattachv, $subscriptionv) = 
    $spdb->db_select_cols($select, "Boards", "sid=$sidq") if $selectedboard;
  
  my ($sorderv, $catid) = $spdb->db_select_cols("sorder, catid", 
					       "BoardBelongToCat", 
					       "sid=$sidq") if $selectedboard;

  my $sid = qq|<input type=text name='boardsid' size=30 value="$sidv">|;
  my $title = qq|<input type=text name='boardtitle' size=30 value="$titlev">|;
  my $introtext = qq|<textarea name='boardintrotext' rows=3 columns=50 size=127 wrap='virtual'>$introtextv</textarea>|;
  my ($check1, $check2, $check3, $check4, $check5, $check6);
  if($htmlv == 1){ $check1 = "checked"; }
  else{ $check2 = "checked"; }
  my $html = qq!
    <input type=radio name=boardhtml value=1 $check1>$lang->{'yes'}
    <input type=radio name=boardhtml value=0 $check2>$lang->{'no'}
      !;

  ($check1, $check2) = ("","");
  if($markupv == 1){ $check1 = "checked"; }
  else{ $check2 = "checked"; }
  my $markup = qq!
    <input type=radio name=boardmarkup value=1 $check1>$lang->{'yes'}
    <input type=radio name=boardmarkup value=0 $check2>$lang->{'no'}
      !;

  ($check1, $check2) = ("","");
  if($fileattachv == 1){ $check1 = "checked"; }
  else{ $check2 = "checked"; }
  my $file_attach = qq|
    <input type=radio name=boardfa value=1 $check1>$lang->{'yes'}
    <input type=radio name=boardfa value=0 $check2>$lang->{'no'}
    |;

  ($check1, $check2) = ("","");
  if($fileattachv == 1){ $check1 = "checked"; }
  else{ $check2 = "checked"; }
  my $sub = qq|
    <input type=radio name=boardsub value=1 $check1>$lang->{'yes'}
    <input type=radio name=boardsub value=0 $check2>$lang->{'no'}
    |;

  ($check1, $check2, $check3) = ("","","");
  if($levelv == 63){ $check1 = "checked"; }
  elsif($levelv == 62){ $check2 = "checked"; }
  elsif($levelv == 60){ $check3 = "checked"; }
  elsif($levelv == 56){ $check4 = "checked"; }
  elsif($levelv == 48){ $check5 = "checked"; }
  elsif($levelv == 32){ $check6 = "checked"; }
  else{ $check1 = "checked"; }
  my $level = qq!
<input type=radio name=boardlevel value=63 $check1>$lang->{'public'}
<input type=radio name=boardlevel value=62 $check2>$lang->{'public_prot'}
<input type=radio name=boardlevel value=60 $check3>$lang->{'user_public'}<BR>
<input type=radio name=boardlevel value=56 $check4>$lang->{'user_priv'}
<input type=radio name=boardlevel value=48 $check5>$lang->{'user_priv_prot'}
<input type=radio name=boardlevel value=32 $check6>$lang->{'group_priv'} 
      !;
  
  ($check1, $check2, $check3) = ("","","");
  if($activev == 1){ $check1 = "checked"; }
  else{ $check2 = "checked"; }
  my $active = qq!
    <input type=radio name=boardactive value=1 $check1>$lang->{'active'}
    <input type=radio name=boardactive value=0 $check2>$lang->{'non_active'}
      !;
  
  ($check1, $check2, $check3) = ("","","");
  if($approvedv == 1){ $check1 = "checked"; }
  else{ $check2 = "checked"; }
  my $approved = qq!
    <input type=radio name=boardapproved value=1 $check1>$lang->{'yes'}
    <input type=radio name=boardapproved value=0 $check2>$lang->{'no'}
      !;
  
  if($expirev == 0){}
  elsif($expirev%30 == 0){
    $expirev = ($expirev/30)."M";
  }
  elsif($expirev%365 == 0){
    $expirev = ($expirev/365)."y";
  }
  
  my $expire = qq|<input type=text name='boardexpire'  size=3 value="$expirev">|;
  my $catopt = Templates::Admin::SmallPig::select_categories($selectedboard, $op);

  $ret .= qq!
      <TR><TD><TABLE BORDER=0 CELLPADDING=10><TR><TD><font size=1>
	<B>$lang->{'board_title'}:</B><BR>$title<BR><BR>
	<B>$lang->{'keyword'}:</B> ($lang->{'must_gt_chs'})<BR>$sid<BR><BR>
	<B>$lang->{'description'}:</B><BR>$introtext<BR><BR>
	<B>$lang->{'cat_belong_to'}:</B><BR>$catopt<BR><BR>
	<B>$lang->{'forum_type'}:</B><BR>$level<BR><BR>
	<B>$lang->{'allow_html'}:</B> ($lang->{'remove_all_html'})<BR>$html<BR><BR>
	<B>$lang->{'allow_markup'}:</B><BR>$markup<BR><BR>
	<B>$lang->{'allow_file_attach'}:</B><BR>$file_attach<BR><BR>
        <B>$lang->{'allow_sub'}:</B><BR>$sub<BR><BR>
	<B>$lang->{'forum_status'}:</B> <BR>$active<BR><BR>
	<B>$lang->{'need_mod_app'}:</B><BR>$approved<BR><BR>
	<B>$lang->{'expire_threads5'}</B>
           $lang->{'expire_threads6'}<BR>
	$expire<BR><BR></font>
	<INPUT TYPE=hidden NAME=prev_sid VALUE="$sidv">
	<INPUT TYPE=hidden NAME=prev_sorder VALUE="$sorderv">
	<INPUT TYPE=hidden NAME=prev_catid VALUE="$catid">
      </TD></TR></TABLE></TD><TR>
    !;
  $ret .= "<INPUT TYPE=hidden NAME=prev_op VALUE=\"$STATE->{'op'}\">";
  return $ret;
}

return 1;
