package Templates::Admin::PageIndex;

use SmallPigVars qw($config);
use SmallPig;

use strict;
use vars qw(@ISA);

@ISA = qw(Templates::Admin::OptBlock);

my %CACHE;

sub new{
  my ($class, $totalnums, $postsper, $page, $mode, $theme) = @_; 

  my $classvars = {('bdrcolor' => $theme->{'inbgcolor'},
		    'bgcolor' => $theme->{'inbgcolor'})};

  my $self = Templates::Admin::OptBlock->new($classvars, $theme);
  $self->{'totalnums'} = $totalnums;
  $self->{'postsper'} = $postsper;
  $self->{'page'} = $page;
  $self->{'mode'} = $mode;
  
  my $id = join '', sort values %$self, "pageindex";
  
  return $CACHE{$id} if $CACHE{$id};
  return $CACHE{$id} = bless $self, $class;
}

sub get{
  my $self = shift;
  $self->{'content'} = $self->_get_index(@_);
  $self->SUPER::get();
}

sub _get_index{
  my ($self, $op, $url) = @_;
  my ($totalnums, $postsper, $page, $mode) =   
    map{ $self->{$_} } 
  qw(totalnums postsper page mode);

  return if $totalnums==0;

  $page ||= 1;
  
  my $ret = "";
  $ret .= "<TR><TD ALIGN=center valign=middle CLASS=header3><B>Pages: ";
  if($postsper <= 0){
    return " ";
  }
  my $totalpages = int $totalnums/$postsper;
  my $remain = $totalnums % $postsper;
  $totalpages++ if $remain > 0;
  my $pagelimit = 20;

  my ($start, $end, $larrow, $rarrow) = 
      (1, ($pagelimit < $totalpages)?$pagelimit:$totalpages, 0, 0);
  if($totalpages > $pagelimit && $page + 1< $totalpages){
      $rarrow = $pagelimit + 1; 
  }
  if($page >= $pagelimit){
      $start = ($page >= $totalpages)?
	  $page - $pagelimit + 1:$page - $pagelimit + 2;
      $end = ($start + $pagelimit> $totalpages)?
	  $totalpages:$start + $pagelimit - 1;
      $larrow = $page - 1;
      $rarrow = $page + 1 if $page + 1< $totalpages;
  }
  
  my $cgi = $ENV{SCRIPT_NAME};

  $ret .= qq!<A HREF=$config->{'basewwwdir'}$cgi?op=$op$url&page=$larrow&mode=$mode>&lt;&lt;</A>! 
      if $larrow;
  for(my $i=$start; $i<=$end; $i++){
      if($i == $page){
	  $ret .= "<B> $i </B>";
      }
      else{
	  my $opts = "$url&page=$i&mode=$mode";
	  $ret .= qq!
<A HREF=$config->{'basewwwdir'}$cgi?op=$op$opts>$i</A>
    !;
      }
  }
  $ret .= qq!<A HREF=$config->{'basewwwdir'}$cgi?op=$op$url&page=$rarrow&mode=$mode>&gt;&gt;</A>! 
      if $rarrow;
  $ret .= "<\TR><\TD>";
  
  return $ret;
}

return 1;
