#! /usr/bin/tclsh

# Copyright (c) 2001  David Muse
# See the file COPYING for more information.

load /usr/lib/sqlrelay/sqlrelay.so sqlrelay


proc checkUndef {value} {

	switch $value "" {
		puts "success "
	} default {
		puts "failure "
		exit
	}
}

proc checkSuccess {value success} {

	if {$value==$success} {
		puts "success "
	} else {
		puts "failure "
		exit
	}
}

# usage...
if {$argc<5} {
	puts "usage: firebird.tcl host port socket user password"
	exit
}

# instantiation
set con [sqlrcon -server [lindex $argv 0] -port [lindex $argv 1] -socket [lindex $argv 2] -user [lindex $argv 3] -password [lindex $argv 4] -retrytime 0 -tries 1]
set cur [$con sqlrcur]

# get database type
puts "IDENTIFY: "
checkSuccess [$con identify] "firebird"
puts ""

# ping
puts "PING: "
checkSuccess [$con ping] 1
puts ""

# clear table
catch {$cur sendQuery "delete from testtable"}
$con commit

puts "INSERT: "
checkSuccess [$cur sendQuery "insert into testtable values (1,1,1.1,1.1,1.1,1.1,'01-JAN-2001','01:00:00','testchar1','testvarchar1',NULL)"] 1
puts ""


puts "BIND BY POSITION: "
$cur prepareQuery "insert into testtable values (?,?,?,?,?,?,?,?,?,?,NULL)"
checkSuccess [$cur countBindVariables] 10
$cur inputBind "1" 2
$cur inputBind "2" 2
$cur inputBind "3" 2.2 2 1
$cur inputBind "4" 2.2 2 1
$cur inputBind "5" 2.2 2 1
$cur inputBind "6" 2.2 2 1
$cur inputBind "7" "01-JAN-2002"
$cur inputBind "8" "02:00:00"
$cur inputBind "9" "testchar2"
$cur inputBind "10" "testvarchar2"
checkSuccess [$cur executeQuery] 1
$cur clearBinds
$cur inputBind "1" 3
$cur inputBind "2" 3
$cur inputBind "3" 3.3 2 1
$cur inputBind "4" 3.3 2 1
$cur inputBind "5" 3.3 2 1
$cur inputBind "6" 3.3 2 1
$cur inputBind "7" "01-JAN-2003"
$cur inputBind "8" "03:00:00"
$cur inputBind "9" "testchar3"
$cur inputBind "10" "testvarchar3"
checkSuccess [$cur executeQuery] 1
puts ""

puts "ARRAY OF BINDS BY POSITION: "
$cur clearBinds
$cur inputBinds {{"1" 4} {"2" 4} {"3" 4.4 2 1} {"4" 4.4 2 1} {"5" 4.4 2 1} {"6" 4.4 2 1} {"7" "01-JAN-2004"} {"8" "04:00:00"} {"9" "testchar4"} {"10" "testvarchar4"}}
checkSuccess [$cur executeQuery] 1
puts ""

puts "INSERT: "
checkSuccess [$cur sendQuery "insert into testtable values (5,5,5.5,5.5,5.5,5.5,'01-JAN-2005','05:00:00','testchar5','testvarchar5',NULL)"] 1
checkSuccess [$cur sendQuery "insert into testtable values (6,6,6.6,6.6,6.6,6.6,'01-JAN-2006','06:00:00','testchar6','testvarchar6',NULL)"] 1
checkSuccess [$cur sendQuery "insert into testtable values (7,7,7.7,7.7,7.7,7.7,'01-JAN-2007','07:00:00','testchar7','testvarchar7',NULL)"] 1
checkSuccess [$cur sendQuery "insert into testtable values (8,8,8.8,8.8,8.8,8.8,'01-JAN-2008','08:00:00','testchar8','testvarchar8',NULL)"] 1
puts ""

puts "AFFECTED ROWS: "
checkSuccess [$cur affectedRows] 0
puts ""

puts "STORED PROCEDURE: "
checkSuccess [$cur sendQuery "create procedure testproc(invar integer) returns (outvar integer) as begin outvar = invar; suspend; end"] 1
$cur prepareQuery "select * from testproc(?)"
$cur inputBind "1" 5
checkSuccess [$cur executeQuery] 1
checkSuccess [$cur getFieldByIndex 0 0] "5"
checkSuccess [$cur sendQuery "drop procedure testproc"] 1
puts ""

puts "SELECT: "
checkSuccess [$cur sendQuery "select * from testtable order by testinteger"] 1
puts ""

puts "COLUMN COUNT: "
checkSuccess [$cur colCount] 11
puts ""

puts "COLUMN NAMES: "
checkSuccess [$cur getColumnName 0] "TESTINTEGER"
checkSuccess [$cur getColumnName 1] "TESTSMALLINT"
checkSuccess [$cur getColumnName 2] "TESTDECIMAL"
checkSuccess [$cur getColumnName 3] "TESTNUMERIC"
checkSuccess [$cur getColumnName 4] "TESTFLOAT"
checkSuccess [$cur getColumnName 5] "TESTDOUBLE"
checkSuccess [$cur getColumnName 6] "TESTDATE"
checkSuccess [$cur getColumnName 7] "TESTTIME"
checkSuccess [$cur getColumnName 8] "TESTCHAR"
checkSuccess [$cur getColumnName 9] "TESTVARCHAR"
checkSuccess [$cur getColumnName 10] "TESTTIMESTAMP"
set cols [$cur getColumnNames]
checkSuccess [lindex $cols 0] "TESTINTEGER"
checkSuccess [lindex $cols 1] "TESTSMALLINT"
checkSuccess [lindex $cols 2] "TESTDECIMAL"
checkSuccess [lindex $cols 3] "TESTNUMERIC"
checkSuccess [lindex $cols 4] "TESTFLOAT"
checkSuccess [lindex $cols 5] "TESTDOUBLE"
checkSuccess [lindex $cols 6] "TESTDATE"
checkSuccess [lindex $cols 7] "TESTTIME"
checkSuccess [lindex $cols 8] "TESTCHAR"
checkSuccess [lindex $cols 9] "TESTVARCHAR"
checkSuccess [lindex $cols 10] "TESTTIMESTAMP"
puts ""

puts "COLUMN TYPES: "
checkSuccess [$cur getColumnTypeByIndex 0] "INTEGER"
checkSuccess [$cur getColumnTypeByName "TESTINTEGER"] "INTEGER"
checkSuccess [$cur getColumnTypeByIndex 1] "SMALLINT"
checkSuccess [$cur getColumnTypeByName "TESTSMALLINT"] "SMALLINT"
checkSuccess [$cur getColumnTypeByIndex 2] "DECIMAL"
checkSuccess [$cur getColumnTypeByName "TESTDECIMAL"] "DECIMAL"
checkSuccess [$cur getColumnTypeByIndex 3] "NUMERIC"
checkSuccess [$cur getColumnTypeByName "TESTNUMERIC"] "NUMERIC"
checkSuccess [$cur getColumnTypeByIndex 4] "FLOAT"
checkSuccess [$cur getColumnTypeByName "TESTFLOAT"] "FLOAT"
checkSuccess [$cur getColumnTypeByIndex 5] "DOUBLE PRECISION"
checkSuccess [$cur getColumnTypeByName "TESTDOUBLE"] "DOUBLE PRECISION"
checkSuccess [$cur getColumnTypeByIndex 6] "DATE"
checkSuccess [$cur getColumnTypeByName "TESTDATE"] "DATE"
checkSuccess [$cur getColumnTypeByIndex 7] "TIME"
checkSuccess [$cur getColumnTypeByName "TESTTIME"] "TIME"
checkSuccess [$cur getColumnTypeByIndex 8] "CHAR"
checkSuccess [$cur getColumnTypeByName "TESTCHAR"] "CHAR"
checkSuccess [$cur getColumnTypeByIndex 9] "VARCHAR"
checkSuccess [$cur getColumnTypeByName "TESTVARCHAR"] "VARCHAR"
checkSuccess [$cur getColumnTypeByIndex 10] "TIMESTAMP"
checkSuccess [$cur getColumnTypeByName "TESTTIMESTAMP"] "TIMESTAMP"
puts ""

puts "COLUMN LENGTH: "
checkSuccess [$cur getColumnLengthByIndex 0] 4
checkSuccess [$cur getColumnLengthByName "TESTINTEGER"] 4
checkSuccess [$cur getColumnLengthByIndex 1] 2
checkSuccess [$cur getColumnLengthByName "TESTSMALLINT"] 2
checkSuccess [$cur getColumnLengthByIndex 2] 8
checkSuccess [$cur getColumnLengthByName "TESTDECIMAL"] 8
checkSuccess [$cur getColumnLengthByIndex 3] 8
checkSuccess [$cur getColumnLengthByName "TESTNUMERIC"] 8
checkSuccess [$cur getColumnLengthByIndex 4] 4
checkSuccess [$cur getColumnLengthByName "TESTFLOAT"] 4
checkSuccess [$cur getColumnLengthByIndex 5] 8
checkSuccess [$cur getColumnLengthByName "TESTDOUBLE"] 8
checkSuccess [$cur getColumnLengthByIndex 6] 4
checkSuccess [$cur getColumnLengthByName "TESTDATE"] 4
checkSuccess [$cur getColumnLengthByIndex 7] 4
checkSuccess [$cur getColumnLengthByName "TESTTIME"] 4
checkSuccess [$cur getColumnLengthByIndex 8] 50
checkSuccess [$cur getColumnLengthByName "TESTCHAR"] 50
checkSuccess [$cur getColumnLengthByIndex 9] 50
checkSuccess [$cur getColumnLengthByName "TESTVARCHAR"] 50
checkSuccess [$cur getColumnLengthByIndex 10] 8
checkSuccess [$cur getColumnLengthByName "TESTTIMESTAMP"] 8
puts ""

puts "LONGEST COLUMN: "
checkSuccess [$cur getLongestByIndex 0] 1
checkSuccess [$cur getLongestByName "TESTINTEGER"] 1
checkSuccess [$cur getLongestByIndex 1] 1
checkSuccess [$cur getLongestByName "TESTSMALLINT"] 1
checkSuccess [$cur getLongestByIndex 2] 4
checkSuccess [$cur getLongestByName "TESTDECIMAL"] 4
checkSuccess [$cur getLongestByIndex 3] 4
checkSuccess [$cur getLongestByName "TESTNUMERIC"] 4
checkSuccess [$cur getLongestByIndex 4] 6
checkSuccess [$cur getLongestByName "TESTFLOAT"] 6
checkSuccess [$cur getLongestByIndex 5] 6
checkSuccess [$cur getLongestByName "TESTDOUBLE"] 6
checkSuccess [$cur getLongestByIndex 6] 10
checkSuccess [$cur getLongestByName "TESTDATE"] 10
checkSuccess [$cur getLongestByIndex 7] 8
checkSuccess [$cur getLongestByName "TESTTIME"] 8
checkSuccess [$cur getLongestByIndex 8] 50
checkSuccess [$cur getLongestByName "TESTCHAR"] 50
checkSuccess [$cur getLongestByIndex 9] 12
checkSuccess [$cur getLongestByName "TESTVARCHAR"] 12
checkSuccess [$cur getLongestByIndex 10] 0
checkSuccess [$cur getLongestByName "TESTTIMESTAMP"] 0
puts ""

puts "ROW COUNT: "
checkSuccess [$cur rowCount] 8
puts ""

puts "TOTAL ROWS: "
checkSuccess [$cur totalRows] 0
puts ""

puts "FIRST ROW INDEX: "
checkSuccess [$cur firstRowIndex] 0
puts ""

puts "END OF RESULT SET: "
checkSuccess [$cur endOfResultSet] 1
puts ""

puts "FIELDS BY INDEX: "
checkSuccess [$cur getFieldByIndex 0 0] "1"
checkSuccess [$cur getFieldByIndex 0 1] "1"
checkSuccess [$cur getFieldByIndex 0 2] "1.10"
checkSuccess [$cur getFieldByIndex 0 3] "1.10"
checkSuccess [$cur getFieldByIndex 0 4] "1.1000"
checkSuccess [$cur getFieldByIndex 0 5] "1.1000"
checkSuccess [$cur getFieldByIndex 0 6] "2001:01:01"
checkSuccess [$cur getFieldByIndex 0 7] "01:00:00"
checkSuccess [$cur getFieldByIndex 0 8] "testchar1                                         "
checkSuccess [$cur getFieldByIndex 0 9] "testvarchar1"
puts ""
checkSuccess [$cur getFieldByIndex 7 0] "8"
checkSuccess [$cur getFieldByIndex 7 1] "8"
checkSuccess [$cur getFieldByIndex 7 2] "8.80"
checkSuccess [$cur getFieldByIndex 7 3] "8.80"
checkSuccess [$cur getFieldByIndex 7 4] "8.8000"
checkSuccess [$cur getFieldByIndex 7 5] "8.8000"
checkSuccess [$cur getFieldByIndex 7 6] "2008:01:01"
checkSuccess [$cur getFieldByIndex 7 7] "08:00:00"
checkSuccess [$cur getFieldByIndex 7 8] "testchar8                                         "
checkSuccess [$cur getFieldByIndex 7 9] "testvarchar8"
puts ""

puts "FIELD LENGTHS BY INDEX: "
checkSuccess [$cur getFieldLengthByIndex 0 0] 1
checkSuccess [$cur getFieldLengthByIndex 0 1] 1
checkSuccess [$cur getFieldLengthByIndex 0 2] 4
checkSuccess [$cur getFieldLengthByIndex 0 3] 4
checkSuccess [$cur getFieldLengthByIndex 0 4] 6
checkSuccess [$cur getFieldLengthByIndex 0 5] 6
checkSuccess [$cur getFieldLengthByIndex 0 6] 10
checkSuccess [$cur getFieldLengthByIndex 0 7] 8
checkSuccess [$cur getFieldLengthByIndex 0 8] 50
checkSuccess [$cur getFieldLengthByIndex 0 9] 12
puts ""
checkSuccess [$cur getFieldLengthByIndex 7 0] 1
checkSuccess [$cur getFieldLengthByIndex 7 1] 1
checkSuccess [$cur getFieldLengthByIndex 7 2] 4
checkSuccess [$cur getFieldLengthByIndex 7 3] 4
checkSuccess [$cur getFieldLengthByIndex 7 4] 6
checkSuccess [$cur getFieldLengthByIndex 7 5] 6
checkSuccess [$cur getFieldLengthByIndex 7 6] 10
checkSuccess [$cur getFieldLengthByIndex 7 7] 8
checkSuccess [$cur getFieldLengthByIndex 7 8] 50
checkSuccess [$cur getFieldLengthByIndex 7 9] 12
puts ""

puts "FIELDS BY NAME: "
checkSuccess [$cur getFieldByName 0 "TESTINTEGER"] "1"
checkSuccess [$cur getFieldByName 0 "TESTSMALLINT"] "1"
checkSuccess [$cur getFieldByName 0 "TESTDECIMAL"] "1.10"
checkSuccess [$cur getFieldByName 0 "TESTNUMERIC"] "1.10"
checkSuccess [$cur getFieldByName 0 "TESTFLOAT"] "1.1000"
checkSuccess [$cur getFieldByName 0 "TESTDOUBLE"] "1.1000"
checkSuccess [$cur getFieldByName 0 "TESTDATE"] "2001:01:01"
checkSuccess [$cur getFieldByName 0 "TESTTIME"] "01:00:00"
checkSuccess [$cur getFieldByName 0 "TESTCHAR"] "testchar1                                         "
checkSuccess [$cur getFieldByName 0 "TESTVARCHAR"] "testvarchar1"
puts ""
checkSuccess [$cur getFieldByName 7 "TESTINTEGER"] "8"
checkSuccess [$cur getFieldByName 7 "TESTSMALLINT"] "8"
checkSuccess [$cur getFieldByName 7 "TESTDECIMAL"] "8.80"
checkSuccess [$cur getFieldByName 7 "TESTNUMERIC"] "8.80"
checkSuccess [$cur getFieldByName 7 "TESTFLOAT"] "8.8000"
checkSuccess [$cur getFieldByName 7 "TESTDOUBLE"] "8.8000"
checkSuccess [$cur getFieldByName 7 "TESTDATE"] "2008:01:01"
checkSuccess [$cur getFieldByName 7 "TESTTIME"] "08:00:00"
checkSuccess [$cur getFieldByName 7 "TESTCHAR"] "testchar8                                         "
checkSuccess [$cur getFieldByName 7 "TESTVARCHAR"] "testvarchar8"
puts ""

puts "FIELD LENGTHS BY NAME: "
checkSuccess [$cur getFieldLengthByName 0 "TESTINTEGER"] 1
checkSuccess [$cur getFieldLengthByName 0 "TESTSMALLINT"] 1
checkSuccess [$cur getFieldLengthByName 0 "TESTDECIMAL"] 4
checkSuccess [$cur getFieldLengthByName 0 "TESTNUMERIC"] 4
checkSuccess [$cur getFieldLengthByName 0 "TESTFLOAT"] 6
checkSuccess [$cur getFieldLengthByName 0 "TESTDOUBLE"] 6
checkSuccess [$cur getFieldLengthByName 0 "TESTDATE"] 10
checkSuccess [$cur getFieldLengthByName 0 "TESTTIME"] 8
checkSuccess [$cur getFieldLengthByName 0 "TESTCHAR"] 50
checkSuccess [$cur getFieldLengthByName 0 "TESTVARCHAR"] 12
puts ""
checkSuccess [$cur getFieldLengthByName 7 "TESTINTEGER"] 1
checkSuccess [$cur getFieldLengthByName 7 "TESTSMALLINT"] 1
checkSuccess [$cur getFieldLengthByName 7 "TESTDECIMAL"] 4
checkSuccess [$cur getFieldLengthByName 7 "TESTNUMERIC"] 4
checkSuccess [$cur getFieldLengthByName 7 "TESTFLOAT"] 6
checkSuccess [$cur getFieldLengthByName 7 "TESTDOUBLE"] 6
checkSuccess [$cur getFieldLengthByName 7 "TESTDATE"] 10
checkSuccess [$cur getFieldLengthByName 7 "TESTTIME"] 8
checkSuccess [$cur getFieldLengthByName 7 "TESTCHAR"] 50
checkSuccess [$cur getFieldLengthByName 7 "TESTVARCHAR"] 12
puts ""

puts "FIELDS BY ARRAY: "
set fields [$cur getRow 0]
checkSuccess [lindex $fields 0] 1
checkSuccess [lindex $fields 1] 1
checkSuccess [lindex $fields 2] 1.1
checkSuccess [lindex $fields 3] 1.1
checkSuccess [lindex $fields 4] 1.1
checkSuccess [lindex $fields 5] 1.1
checkSuccess [lindex $fields 6] "2001:01:01"
checkSuccess [lindex $fields 7] "01:00:00"
checkSuccess [lindex $fields 8] "testchar1                                         "
checkSuccess [lindex $fields 9] "testvarchar1"
puts ""

puts "FIELD LENGTHS BY ARRAY: "
set fieldlens [$cur getRowLengths 0]
checkSuccess [lindex $fieldlens 0] 1
checkSuccess [lindex $fieldlens 1] 1
checkSuccess [lindex $fieldlens 2] 4
checkSuccess [lindex $fieldlens 3] 4
checkSuccess [lindex $fieldlens 4] 6
checkSuccess [lindex $fieldlens 5] 6
checkSuccess [lindex $fieldlens 6] 10
checkSuccess [lindex $fieldlens 7] 8
checkSuccess [lindex $fieldlens 8] 50
checkSuccess [lindex $fieldlens 9] 12
puts ""

puts "INDIVIDUAL SUBSTITUTIONS: "
$cur prepareQuery "select \$(var1),'\$(var2)','\$(var3)' from rdb\$database"
$cur substitution "var1" 1
$cur substitution "var2" "hello"
$cur substitution "var3" 10.5556 6 4
checkSuccess [$cur executeQuery] 1
puts ""

puts "FIELDS: "
checkSuccess [$cur getFieldByIndex 0 0] "1"
checkSuccess [$cur getFieldByIndex 0 1] "hello"
checkSuccess [$cur getFieldByIndex 0 2] "10.5556"
puts ""

puts "ARRAY SUBSTITUTIONS: "
$cur prepareQuery "select \$(var1),'\$(var2)','\$(var3)' from rdb\$database"
$cur substitutions {{"var1" 1} {"var2" "hello"} {"var3" 10.5556 6 4}}
checkSuccess [$cur executeQuery] 1
puts ""

puts "FIELDS: "
checkSuccess [$cur getFieldByIndex 0 0] "1"
checkSuccess [$cur getFieldByIndex 0 1] "hello"
checkSuccess [$cur getFieldByIndex 0 2] "10.5556"
puts ""

puts "RESULT SET BUFFER SIZE: "
checkSuccess [$cur getResultSetBufferSize] 0
$cur setResultSetBufferSize 2
checkSuccess [$cur sendQuery "select * from testtable"] 1
checkSuccess [$cur getResultSetBufferSize] 2
puts ""
checkSuccess [$cur firstRowIndex] 0
checkSuccess [$cur endOfResultSet] 0
checkSuccess [$cur rowCount] 2
checkSuccess [$cur getFieldByIndex 0 0] "1"
checkSuccess [$cur getFieldByIndex 1 0] "2"
checkSuccess [$cur getFieldByIndex 2 0] "3"
puts ""
checkSuccess [$cur firstRowIndex] 2
checkSuccess [$cur endOfResultSet] 0
checkSuccess [$cur rowCount] 4
checkSuccess [$cur getFieldByIndex 6 0] "7"
checkSuccess [$cur getFieldByIndex 7 0] "8"
puts ""
checkSuccess [$cur firstRowIndex] 6
checkSuccess [$cur endOfResultSet] 0
checkSuccess [$cur rowCount] 8
checkUndef [$cur getFieldByIndex 8 0]
puts ""
checkSuccess [$cur firstRowIndex] 8
checkSuccess [$cur endOfResultSet] 1
checkSuccess [$cur rowCount] 8
puts ""

puts "DONT GET COLUMN INFO: "
$cur dontGetColumnInfo
checkSuccess [$cur sendQuery "select * from testtable order by testinteger"] 1
checkUndef [$cur getColumnName 0]
checkSuccess [$cur getColumnLengthByIndex 0] 0
checkUndef [$cur getColumnTypeByIndex 0]
$cur getColumnInfo
checkSuccess [$cur sendQuery "select * from testtable order by testinteger"] 1
checkSuccess [$cur getColumnName 0] "TESTINTEGER"
checkSuccess [$cur getColumnLengthByIndex 0] 4
checkSuccess [$cur getColumnTypeByIndex 0] "INTEGER"
puts ""

puts "SUSPENDED SESSION: "
checkSuccess [$cur sendQuery "select * from testtable order by testinteger"] 1
$cur suspendResultSet
checkSuccess [$con suspendSession] 1
set port [$con getConnectionPort]
set socket [$con getConnectionSocket]
checkSuccess [$con resumeSession $port $socket] 1
puts ""
checkSuccess [$cur getFieldByIndex 0 0] "1"
checkSuccess [$cur getFieldByIndex 1 0] "2"
checkSuccess [$cur getFieldByIndex 2 0] "3"
checkSuccess [$cur getFieldByIndex 3 0] "4"
checkSuccess [$cur getFieldByIndex 4 0] "5"
checkSuccess [$cur getFieldByIndex 5 0] "6"
checkSuccess [$cur getFieldByIndex 6 0] "7"
checkSuccess [$cur getFieldByIndex 7 0] "8"
puts ""
checkSuccess [$cur sendQuery "select * from testtable order by testinteger"] 1
$cur suspendResultSet
checkSuccess [$con suspendSession] 1
set port [$con getConnectionPort]
set socket [$con getConnectionSocket]
checkSuccess [$con resumeSession $port $socket] 1
puts ""
checkSuccess [$cur getFieldByIndex 0 0] "1"
checkSuccess [$cur getFieldByIndex 1 0] "2"
checkSuccess [$cur getFieldByIndex 2 0] "3"
checkSuccess [$cur getFieldByIndex 3 0] "4"
checkSuccess [$cur getFieldByIndex 4 0] "5"
checkSuccess [$cur getFieldByIndex 5 0] "6"
checkSuccess [$cur getFieldByIndex 6 0] "7"
checkSuccess [$cur getFieldByIndex 7 0] "8"
puts ""
checkSuccess [$cur sendQuery "select * from testtable order by testinteger"] 1
$cur suspendResultSet
checkSuccess [$con suspendSession] 1
set port [$con getConnectionPort]
set socket [$con getConnectionSocket]
checkSuccess [$con resumeSession $port $socket] 1
puts ""
checkSuccess [$cur getFieldByIndex 0 0] "1"
checkSuccess [$cur getFieldByIndex 1 0] "2"
checkSuccess [$cur getFieldByIndex 2 0] "3"
checkSuccess [$cur getFieldByIndex 3 0] "4"
checkSuccess [$cur getFieldByIndex 4 0] "5"
checkSuccess [$cur getFieldByIndex 5 0] "6"
checkSuccess [$cur getFieldByIndex 6 0] "7"
checkSuccess [$cur getFieldByIndex 7 0] "8"
puts ""

puts "SUSPENDED RESULT SET: "
$cur setResultSetBufferSize 2
checkSuccess [$cur sendQuery "select * from testtable order by testinteger"] 1
checkSuccess [$cur getFieldByIndex 2 0] "3"
set id [$cur getResultSetId]
$cur suspendResultSet
checkSuccess [$con suspendSession] 1
set port [$con getConnectionPort]
set socket [$con getConnectionSocket]
checkSuccess [$con resumeSession $port $socket] 1
checkSuccess [$cur resumeResultSet $id] 1
puts ""
checkSuccess [$cur firstRowIndex] 4
checkSuccess [$cur endOfResultSet] 0
checkSuccess [$cur rowCount] 6
checkSuccess [$cur getFieldByIndex 7 0] "8"
puts ""
checkSuccess [$cur firstRowIndex] 6
checkSuccess [$cur endOfResultSet] 0
checkSuccess [$cur rowCount] 8
checkUndef [$cur getFieldByIndex 8 0]
puts ""
checkSuccess [$cur firstRowIndex] 8
checkSuccess [$cur endOfResultSet] 1
checkSuccess [$cur rowCount] 8
$cur setResultSetBufferSize 0
puts ""

puts "CACHED RESULT SET: "
$cur cacheToFile "cachefile1"
$cur setCacheTtl 200
checkSuccess [$cur sendQuery "select * from testtable order by testinteger"] 1
set filename [$cur getCacheFileName]
checkSuccess $filename "cachefile1"
$cur cacheOff
checkSuccess [$cur openCachedResultSet $filename] 1
checkSuccess [$cur getFieldByIndex 7 0] "8"
puts ""

puts "COLUMN COUNT FOR CACHED RESULT SET: "
checkSuccess [$cur colCount] 11
puts ""

puts "COLUMN NAMES FOR CACHED RESULT SET: "
checkSuccess [$cur getColumnName 0] "TESTINTEGER"
checkSuccess [$cur getColumnName 1] "TESTSMALLINT"
checkSuccess [$cur getColumnName 2] "TESTDECIMAL"
checkSuccess [$cur getColumnName 3] "TESTNUMERIC"
checkSuccess [$cur getColumnName 4] "TESTFLOAT"
checkSuccess [$cur getColumnName 5] "TESTDOUBLE"
checkSuccess [$cur getColumnName 6] "TESTDATE"
checkSuccess [$cur getColumnName 7] "TESTTIME"
checkSuccess [$cur getColumnName 8] "TESTCHAR"
checkSuccess [$cur getColumnName 9] "TESTVARCHAR"
checkSuccess [$cur getColumnName 10] "TESTTIMESTAMP"
set cols [$cur getColumnNames]
checkSuccess [lindex $cols 0] "TESTINTEGER"
checkSuccess [lindex $cols 1] "TESTSMALLINT"
checkSuccess [lindex $cols 2] "TESTDECIMAL"
checkSuccess [lindex $cols 3] "TESTNUMERIC"
checkSuccess [lindex $cols 4] "TESTFLOAT"
checkSuccess [lindex $cols 5] "TESTDOUBLE"
checkSuccess [lindex $cols 6] "TESTDATE"
checkSuccess [lindex $cols 7] "TESTTIME"
checkSuccess [lindex $cols 8] "TESTCHAR"
checkSuccess [lindex $cols 9] "TESTVARCHAR"
checkSuccess [lindex $cols 10] "TESTTIMESTAMP"
puts ""

puts "CACHED RESULT SET WITH RESULT SET BUFFER SIZE: "
$cur setResultSetBufferSize 2
$cur cacheToFile "cachefile1"
$cur setCacheTtl 200
checkSuccess [$cur sendQuery "select * from testtable order by testinteger"] 1
set filename [$cur getCacheFileName]
checkSuccess $filename "cachefile1"
$cur cacheOff
checkSuccess [$cur openCachedResultSet $filename] 1
checkSuccess [$cur getFieldByIndex 7 0] "8"
checkUndef [$cur getFieldByIndex 8 0]
$cur setResultSetBufferSize 0
puts ""

puts "FROM ONE CACHE FILE TO ANOTHER: "
$cur cacheToFile "cachefile2"
checkSuccess [$cur openCachedResultSet "cachefile1"] 1
$cur cacheOff
checkSuccess [$cur openCachedResultSet "cachefile2"] 1
checkSuccess [$cur getFieldByIndex 7 0] "8"
checkUndef [$cur getFieldByIndex 8 0]
puts ""

puts "FROM ONE CACHE FILE TO ANOTHER WITH RESULT SET BUFFER SIZE: "
$cur setResultSetBufferSize 2
$cur cacheToFile "cachefile2"
checkSuccess [$cur openCachedResultSet "cachefile1"] 1
$cur cacheOff
checkSuccess [$cur openCachedResultSet "cachefile2"] 1
checkSuccess [$cur getFieldByIndex 7 0] "8"
checkUndef [$cur getFieldByIndex 8 0]
$cur setResultSetBufferSize 0
puts ""

puts "CACHED RESULT SET WITH SUSPEND AND RESULT SET BUFFER SIZE: "
$cur setResultSetBufferSize 2
$cur cacheToFile "cachefile1"
$cur setCacheTtl 200
checkSuccess [$cur sendQuery "select * from testtable order by testinteger"] 1
checkSuccess [$cur getFieldByIndex 2 0] "3"
set filename [$cur getCacheFileName]
checkSuccess $filename "cachefile1"
set id [$cur getResultSetId]
$cur suspendResultSet
checkSuccess [$con suspendSession] 1
set port [$con getConnectionPort]
set socket [$con getConnectionSocket]
puts ""
checkSuccess [$con resumeSession $port $socket] 1
checkSuccess [$cur resumeCachedResultSet $id $filename] 1
puts ""
checkSuccess [$cur firstRowIndex] 4
checkSuccess [$cur endOfResultSet] 0
checkSuccess [$cur rowCount] 6
checkSuccess [$cur getFieldByIndex 7 0] "8"
puts ""
checkSuccess [$cur firstRowIndex] 6
checkSuccess [$cur endOfResultSet] 0
checkSuccess [$cur rowCount] 8
checkUndef [$cur getFieldByIndex 8 0]
puts ""
checkSuccess [$cur firstRowIndex] 8
checkSuccess [$cur endOfResultSet] 1
checkSuccess [$cur rowCount] 8
$cur cacheOff
puts ""
checkSuccess [$cur openCachedResultSet $filename] 1
checkSuccess [$cur getFieldByIndex 7 0] "8"
checkUndef [$cur getFieldByIndex 8 0]
$cur setResultSetBufferSize 0
puts ""

puts "COMMIT AND ROLLBACK: "
set secondcon [sqlrcon -server [lindex $argv 0] -port [lindex $argv 1] -socket [lindex $argv 2] -user [lindex $argv 3] -password [lindex $argv 4] -retrytime 0 -tries 1]
set secondcur [$secondcon sqlrcur]
checkSuccess [$secondcur sendQuery "select count(*) from testtable"] 1
checkSuccess [$secondcur getFieldByIndex 0 0] "0"
checkSuccess [$con commit] 1
checkSuccess [$secondcur sendQuery "select count(*) from testtable"] 1
checkSuccess [$secondcur getFieldByIndex 0 0] "8"
checkSuccess [$con autoCommit 1] 1
checkSuccess [$cur sendQuery "insert into testtable values (10,10,10.1,10.1,10.1,10.1,'01-JAN-2010','10:00:00','testchar10','testvarchar10',NULL)"] 1
checkSuccess [$secondcur sendQuery "select count(*) from testtable"] 1
checkSuccess [$secondcur getFieldByIndex 0 0] "9"
checkSuccess [$con autoCommit 0] 1
puts ""

puts "FINISHED SUSPENDED SESSION: "
checkSuccess [$cur sendQuery "select * from testtable order by testinteger"] 1
checkSuccess [$cur getFieldByIndex 4 0] "5"
checkSuccess [$cur getFieldByIndex 5 0] "6"
checkSuccess [$cur getFieldByIndex 6 0] "7"
checkSuccess [$cur getFieldByIndex 7 0] "8"
set id [$cur getResultSetId]
$cur suspendResultSet
checkSuccess [$con suspendSession] 1
set $port [$con getConnectionPort]
set $socket [$con getConnectionSocket]
checkSuccess [$con resumeSession $port $socket] 1
checkSuccess [$cur resumeResultSet $id] 1
checkUndef [$cur getFieldByIndex 4 0]
checkUndef [$cur getFieldByIndex 5 0]
checkUndef [$cur getFieldByIndex 6 0]
checkUndef [$cur getFieldByIndex 7 0]
puts ""

# drop existing table
$con commit
catch {$cur sendQuery "delete from testtable"}
$con commit
puts ""

# invalid queries...
puts "INVALID QUERIES: "
catch {checkSuccess [$cur sendQuery "select * from testtable1 order by testinteger"] 0}
catch {checkSuccess [$cur sendQuery "select * from testtable1 order by testinteger"] 0}
catch {checkSuccess [$cur sendQuery "select * from testtable1 order by testinteger"] 0}
catch {checkSuccess [$cur sendQuery "select * from testtable1 order by testinteger"] 0}
puts ""
catch {checkSuccess [$cur sendQuery "insert into testtable1 values (1,2,3,4)"] 0}
catch {checkSuccess [$cur sendQuery "insert into testtable1 values (1,2,3,4)"] 0}
catch {checkSuccess [$cur sendQuery "insert into testtable1 values (1,2,3,4)"] 0}
catch {checkSuccess [$cur sendQuery "insert into testtable1 values (1,2,3,4)"] 0}
puts ""
catch {checkSuccess [$cur sendQuery "create table testtable"] 0}
catch {checkSuccess [$cur sendQuery "create table testtable"] 0}
catch {checkSuccess [$cur sendQuery "create table testtable"] 0}
catch {checkSuccess [$cur sendQuery "create table testtable"] 0}
puts ""
