<?php
/**
 * decode/cp949.php
 *
 * This file contains cp949 decoding function that is needed to read
 * cp949 encoded mails in non-cp949 locale. I think microsoft uses cp949 for
 * emails marked with ks_c_5601_1987 charset. Fix me if I wrong.
 *
 * cp949 array is not aligned correctly in order to preserve space.
 *
 * Special thanks to Korean flower shop spammer that have sent some Korean
 * texts to person, that does not understand a word in that language.
 * 
 * Original data taken from:
 *  ftp://ftp.unicode.org/Public/MAPPINGS/VENDORS/MICSFT/WINDOWS/CP949.TXT
 *
 * Name:     cp949 to Unicode table
 * Unicode version: 2.0
 * Table version: 2.01
 * Table format:  Format A
 * Date:          1/7/2000
 * Contact:       cpxlate@microsoft.com
 *
 * Possible charset names:
 * <ul>
 *  <li>x-windows-949 (Mozilla)
 *  <li>ks_c_5601_1987 (OE ?)
 *  <li>uhc
 *  <li>johab ?
 * </ul>
 * 
 * @copyright (c) 2004-2005 The SquirrelMail Project Team
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @version $Id: cp949.php,v 1.3 2005/11/17 21:10:27 tokul Exp $
 * @package decode
 * @subpackage eastasia
 */

/**
 * Decode cp949 encoded string
 * @param string $string cp949 string
 * @param boolean $save_html don't html encode special characters if true
 * @return string $string decoded string
 */
function charset_decode_cp949 ($string,$save_html=false) {
    global $aggressive_decoding;

    // this is CPU intensive task. Use recode functions if they are available.
    if (function_exists('recode_string')) {
        // if string is already sanitized, undo htmlspecial chars
        if (! $save_html)
            $string=str_replace(array('&amp;','&quot;','&lt;','&gt;'),array('&','"','<','>'),$string);

        $string = recode_string("cp949..html",$string);

        // if string sanitizing is not needed, undo htmlspecialchars applied by recode.
        if ($save_html)
            $string=str_replace(array('&amp;','&quot;','&lt;','&gt;'),array('&','"','<','>'),$string);

        return $string;
    }

    /*
     * iconv does not support html target, but internal utf-8 decoding is faster 
     * than pure php implementation. 
     */
    if (function_exists('iconv') && file_exists(SM_PATH . 'functions/decode/utf_8.php') ) {
        include_once(SM_PATH . 'functions/decode/utf_8.php');
        $string = iconv('cp949','utf-8',$string);
        return charset_decode_utf_8($string);
    }

    // try mbstring
    if (function_exists('mb_convert_encoding') && 
        function_exists('sq_mb_list_encodings') &&
        check_php_version(4,3,0) &&
        in_array('uhc',sq_mb_list_encodings())) {
        return mb_convert_encoding($string,'HTML-ENTITIES','UHC');
    }

    if (!$aggressive_decoding) return $string;

    // don't do decoding when there are no 8bit symbols
    if (! sq_is8bit($string,'ks_c_5601_1987'))
        return $string;

$cp949=array("\x81\x41" => '&#44034;',
 "\x81\x42" => '&#44035;',
 "\x81\x43" => '&#44037;',
 "\x81\x44" => '&#44038;',
 "\x81\x45" => '&#44043;',
 "\x81\x46" => '&#44044;',
 "\x81\x47" => '&#44045;',
 "\x81\x48" => '&#44046;',
 "\x81\x49" => '&#44047;',
 "\x81\x4A" => '&#44056;',
 "\x81\x4B" => '&#44062;',
 "\x81\x4C" => '&#44063;',
 "\x81\x4D" => '&#44065;',
 "\x81\x4E" => '&#44066;',
 "\x81\x4F" => '&#44067;',
 "\x81\x50" => '&#44069;',
 "\x81\x51" => '&#44070;',
 "\x81\x52" => '&#44071;',
 "\x81\x53" => '&#44072;',
 "\x81\x54" => '&#44073;',
 "\x81\x55" => '&#44074;',
 "\x81\x56" => '&#44075;',
 "\x81\x57" => '&#44078;',
 "\x81\x58" => '&#44082;',
 "\x81\x59" => '&#44083;',
 "\x81\x5A" => '&#44084;',
 "\x81\x61" => '&#44085;',
 "\x81\x62" => '&#44086;',
 "\x81\x63" => '&#44087;',
 "\x81\x64" => '&#44090;',
 "\x81\x65" => '&#44091;',
 "\x81\x66" => '&#44093;',
 "\x81\x67" => '&#44094;',
 "\x81\x68" => '&#44095;',
 "\x81\x69" => '&#44097;',
 "\x81\x6A" => '&#44098;',
 "\x81\x6B" => '&#44099;',
 "\x81\x6C" => '&#44100;',
 "\x81\x6D" => '&#44101;',
 "\x81\x6E" => '&#44102;',
 "\x81\x6F" => '&#44103;',
 "\x81\x70" => '&#44104;',
 "\x81\x71" => '&#44105;',
 "\x81\x72" => '&#44106;',
 "\x81\x73" => '&#44108;',
 "\x81\x74" => '&#44110;',
 "\x81\x75" => '&#44111;',
 "\x81\x76" => '&#44112;',
 "\x81\x77" => '&#44113;',
 "\x81\x78" => '&#44114;',
 "\x81\x79" => '&#44115;',
 "\x81\x7A" => '&#44117;',
 "\x81\x81" => '&#44118;',
 "\x81\x82" => '&#44119;',
 "\x81\x83" => '&#44121;',
 "\x81\x84" => '&#44122;',
 "\x81\x85" => '&#44123;',
 "\x81\x86" => '&#44125;',
 "\x81\x87" => '&#44126;',
 "\x81\x88" => '&#44127;',
 "\x81\x89" => '&#44128;',
 "\x81\x8A" => '&#44129;',
 "\x81\x8B" => '&#44130;',
 "\x81\x8C" => '&#44131;',
 "\x81\x8D" => '&#44132;',
 "\x81\x8E" => '&#44133;',
 "\x81\x8F" => '&#44134;',
 "\x81\x90" => '&#44135;',
 "\x81\x91" => '&#44136;',
 "\x81\x92" => '&#44137;',
 "\x81\x93" => '&#44138;',
 "\x81\x94" => '&#44139;',
 "\x81\x95" => '&#44140;',
 "\x81\x96" => '&#44141;',
 "\x81\x97" => '&#44142;',
 "\x81\x98" => '&#44143;',
 "\x81\x99" => '&#44146;',
 "\x81\x9A" => '&#44147;',
 "\x81\x9B" => '&#44149;',
 "\x81\x9C" => '&#44150;',
 "\x81\x9D" => '&#44153;',
 "\x81\x9E" => '&#44155;',
 "\x81\x9F" => '&#44156;',
 "\x81\xA0" => '&#44157;',
 "\x81\xA1" => '&#44158;',
 "\x81\xA2" => '&#44159;',
 "\x81\xA3" => '&#44162;',
 "\x81\xA4" => '&#44167;',
 "\x81\xA5" => '&#44168;',
 "\x81\xA6" => '&#44173;',
 "\x81\xA7" => '&#44174;',
 "\x81\xA8" => '&#44175;',
 "\x81\xA9" => '&#44177;',
 "\x81\xAA" => '&#44178;',
 "\x81\xAB" => '&#44179;',
 "\x81\xAC" => '&#44181;',
 "\x81\xAD" => '&#44182;',
 "\x81\xAE" => '&#44183;',
 "\x81\xAF" => '&#44184;',
 "\x81\xB0" => '&#44185;',
 "\x81\xB1" => '&#44186;',
 "\x81\xB2" => '&#44187;',
 "\x81\xB3" => '&#44190;',
 "\x81\xB4" => '&#44194;',
 "\x81\xB5" => '&#44195;',
 "\x81\xB6" => '&#44196;',
 "\x81\xB7" => '&#44197;',
 "\x81\xB8" => '&#44198;',
 "\x81\xB9" => '&#44199;',
 "\x81\xBA" => '&#44203;',
 "\x81\xBB" => '&#44205;',
 "\x81\xBC" => '&#44206;',
 "\x81\xBD" => '&#44209;',
 "\x81\xBE" => '&#44210;',
 "\x81\xBF" => '&#44211;',
 "\x81\xC0" => '&#44212;',
 "\x81\xC1" => '&#44213;',
 "\x81\xC2" => '&#44214;',
 "\x81\xC3" => '&#44215;',
 "\x81\xC4" => '&#44218;',
 "\x81\xC5" => '&#44222;',
 "\x81\xC6" => '&#44223;',
 "\x81\xC7" => '&#44224;',
 "\x81\xC8" => '&#44226;',
 "\x81\xC9" => '&#44227;',
 "\x81\xCA" => '&#44229;',
 "\x81\xCB" => '&#44230;',
 "\x81\xCC" => '&#44231;',
 "\x81\xCD" => '&#44233;',
 "\x81\xCE" => '&#44234;',
 "\x81\xCF" => '&#44235;',
 "\x81\xD0" => '&#44237;',
 "\x81\xD1" => '&#44238;',
 "\x81\xD2" => '&#44239;',
 "\x81\xD3" => '&#44240;',
 "\x81\xD4" => '&#44241;',
 "\x81\xD5" => '&#44242;',
 "\x81\xD6" => '&#44243;',
 "\x81\xD7" => '&#44244;',
 "\x81\xD8" => '&#44246;',
 "\x81\xD9" => '&#44248;',
 "\x81\xDA" => '&#44249;',
 "\x81\xDB" => '&#44250;',
 "\x81\xDC" => '&#44251;',
 "\x81\xDD" => '&#44252;',
 "\x81\xDE" => '&#44253;',
 "\x81\xDF" => '&#44254;',
 "\x81\xE0" => '&#44255;',
 "\x81\xE1" => '&#44258;',
 "\x81\xE2" => '&#44259;',
 "\x81\xE3" => '&#44261;',
 "\x81\xE4" => '&#44262;',
 "\x81\xE5" => '&#44265;',
 "\x81\xE6" => '&#44267;',
 "\x81\xE7" => '&#44269;',
 "\x81\xE8" => '&#44270;',
 "\x81\xE9" => '&#44274;',
 "\x81\xEA" => '&#44276;',
 "\x81\xEB" => '&#44279;',
 "\x81\xEC" => '&#44280;',
 "\x81\xED" => '&#44281;',
 "\x81\xEE" => '&#44282;',
 "\x81\xEF" => '&#44283;',
 "\x81\xF0" => '&#44286;',
 "\x81\xF1" => '&#44287;',
 "\x81\xF2" => '&#44289;',
 "\x81\xF3" => '&#44290;',
 "\x81\xF4" => '&#44291;',
 "\x81\xF5" => '&#44293;',
 "\x81\xF6" => '&#44295;',
 "\x81\xF7" => '&#44296;',
 "\x81\xF8" => '&#44297;',
 "\x81\xF9" => '&#44298;',
 "\x81\xFA" => '&#44299;',
 "\x81\xFB" => '&#44302;',
 "\x81\xFC" => '&#44304;',
 "\x81\xFD" => '&#44306;',
 "\x81\xFE" => '&#44307;',
 "\x82\x41" => '&#44308;',
 "\x82\x42" => '&#44309;',
 "\x82\x43" => '&#44310;',
 "\x82\x44" => '&#44311;',
 "\x82\x45" => '&#44313;',
 "\x82\x46" => '&#44314;',
 "\x82\x47" => '&#44315;',
 "\x82\x48" => '&#44317;',
 "\x82\x49" => '&#44318;',
 "\x82\x4A" => '&#44319;',
 "\x82\x4B" => '&#44321;',
 "\x82\x4C" => '&#44322;',
 "\x82\x4D" => '&#44323;',
 "\x82\x4E" => '&#44324;',
 "\x82\x4F" => '&#44325;',
 "\x82\x50" => '&#44326;',
 "\x82\x51" => '&#44327;',
 "\x82\x52" => '&#44328;',
 "\x82\x53" => '&#44330;',
 "\x82\x54" => '&#44331;',
 "\x82\x55" => '&#44334;',
 "\x82\x56" => '&#44335;',
 "\x82\x57" => '&#44336;',
 "\x82\x58" => '&#44337;',
 "\x82\x59" => '&#44338;',
 "\x82\x5A" => '&#44339;',
 "\x82\x61" => '&#44342;',
 "\x82\x62" => '&#44343;',
 "\x82\x63" => '&#44345;',
 "\x82\x64" => '&#44346;',
 "\x82\x65" => '&#44347;',
 "\x82\x66" => '&#44349;',
 "\x82\x67" => '&#44350;',
 "\x82\x68" => '&#44351;',
 "\x82\x69" => '&#44352;',
 "\x82\x6A" => '&#44353;',
 "\x82\x6B" => '&#44354;',
 "\x82\x6C" => '&#44355;',
 "\x82\x6D" => '&#44358;',
 "\x82\x6E" => '&#44360;',
 "\x82\x6F" => '&#44362;',
 "\x82\x70" => '&#44363;',
 "\x82\x71" => '&#44364;',
 "\x82\x72" => '&#44365;',
 "\x82\x73" => '&#44366;',
 "\x82\x74" => '&#44367;',
 "\x82\x75" => '&#44369;',
 "\x82\x76" => '&#44370;',
 "\x82\x77" => '&#44371;',
 "\x82\x78" => '&#44373;',
 "\x82\x79" => '&#44374;',
 "\x82\x7A" => '&#44375;',
 "\x82\x81" => '&#44377;',
 "\x82\x82" => '&#44378;',
 "\x82\x83" => '&#44379;',
 "\x82\x84" => '&#44380;',
 "\x82\x85" => '&#44381;',
 "\x82\x86" => '&#44382;',
 "\x82\x87" => '&#44383;',
 "\x82\x88" => '&#44384;',
 "\x82\x89" => '&#44386;',
 "\x82\x8A" => '&#44388;',
 "\x82\x8B" => '&#44389;',
 "\x82\x8C" => '&#44390;',
 "\x82\x8D" => '&#44391;',
 "\x82\x8E" => '&#44392;',
 "\x82\x8F" => '&#44393;',
 "\x82\x90" => '&#44394;',
 "\x82\x91" => '&#44395;',
 "\x82\x92" => '&#44398;',
 "\x82\x93" => '&#44399;',
 "\x82\x94" => '&#44401;',
 "\x82\x95" => '&#44402;',
 "\x82\x96" => '&#44407;',
 "\x82\x97" => '&#44408;',
 "\x82\x98" => '&#44409;',
 "\x82\x99" => '&#44410;',
 "\x82\x9A" => '&#44414;',
 "\x82\x9B" => '&#44416;',
 "\x82\x9C" => '&#44419;',
 "\x82\x9D" => '&#44420;',
 "\x82\x9E" => '&#44421;',
 "\x82\x9F" => '&#44422;',
 "\x82\xA0" => '&#44423;',
 "\x82\xA1" => '&#44426;',
 "\x82\xA2" => '&#44427;',
 "\x82\xA3" => '&#44429;',
 "\x82\xA4" => '&#44430;',
 "\x82\xA5" => '&#44431;',
 "\x82\xA6" => '&#44433;',
 "\x82\xA7" => '&#44434;',
 "\x82\xA8" => '&#44435;',
 "\x82\xA9" => '&#44436;',
 "\x82\xAA" => '&#44437;',
 "\x82\xAB" => '&#44438;',
 "\x82\xAC" => '&#44439;',
 "\x82\xAD" => '&#44440;',
 "\x82\xAE" => '&#44441;',
 "\x82\xAF" => '&#44442;',
 "\x82\xB0" => '&#44443;',
 "\x82\xB1" => '&#44446;',
 "\x82\xB2" => '&#44447;',
 "\x82\xB3" => '&#44448;',
 "\x82\xB4" => '&#44449;',
 "\x82\xB5" => '&#44450;',
 "\x82\xB6" => '&#44451;',
 "\x82\xB7" => '&#44453;',
 "\x82\xB8" => '&#44454;',
 "\x82\xB9" => '&#44455;',
 "\x82\xBA" => '&#44456;',
 "\x82\xBB" => '&#44457;',
 "\x82\xBC" => '&#44458;',
 "\x82\xBD" => '&#44459;',
 "\x82\xBE" => '&#44460;',
 "\x82\xBF" => '&#44461;',
 "\x82\xC0" => '&#44462;',
 "\x82\xC1" => '&#44463;',
 "\x82\xC2" => '&#44464;',
 "\x82\xC3" => '&#44465;',
 "\x82\xC4" => '&#44466;',
 "\x82\xC5" => '&#44467;',
 "\x82\xC6" => '&#44468;',
 "\x82\xC7" => '&#44469;',
 "\x82\xC8" => '&#44470;',
 "\x82\xC9" => '&#44472;',
 "\x82\xCA" => '&#44473;',
 "\x82\xCB" => '&#44474;',
 "\x82\xCC" => '&#44475;',
 "\x82\xCD" => '&#44476;',
 "\x82\xCE" => '&#44477;',
 "\x82\xCF" => '&#44478;',
 "\x82\xD0" => '&#44479;',
 "\x82\xD1" => '&#44482;',
 "\x82\xD2" => '&#44483;',
 "\x82\xD3" => '&#44485;',
 "\x82\xD4" => '&#44486;',
 "\x82\xD5" => '&#44487;',
 "\x82\xD6" => '&#44489;',
 "\x82\xD7" => '&#44490;',
 "\x82\xD8" => '&#44491;',
 "\x82\xD9" => '&#44492;',
 "\x82\xDA" => '&#44493;',
 "\x82\xDB" => '&#44494;',
 "\x82\xDC" => '&#44495;',
 "\x82\xDD" => '&#44498;',
 "\x82\xDE" => '&#44500;',
 "\x82\xDF" => '&#44501;',
 "\x82\xE0" => '&#44502;',
 "\x82\xE1" => '&#44503;',
 "\x82\xE2" => '&#44504;',
 "\x82\xE3" => '&#44505;',
 "\x82\xE4" => '&#44506;',
 "\x82\xE5" => '&#44507;',
 "\x82\xE6" => '&#44509;',
 "\x82\xE7" => '&#44510;',
 "\x82\xE8" => '&#44511;',
 "\x82\xE9" => '&#44513;',
 "\x82\xEA" => '&#44514;',
 "\x82\xEB" => '&#44515;',
 "\x82\xEC" => '&#44517;',
 "\x82\xED" => '&#44518;',
 "\x82\xEE" => '&#44519;',
 "\x82\xEF" => '&#44520;',
 "\x82\xF0" => '&#44521;',
 "\x82\xF1" => '&#44522;',
 "\x82\xF2" => '&#44523;',
 "\x82\xF3" => '&#44524;',
 "\x82\xF4" => '&#44525;',
 "\x82\xF5" => '&#44526;',
 "\x82\xF6" => '&#44527;',
 "\x82\xF7" => '&#44528;',
 "\x82\xF8" => '&#44529;',
 "\x82\xF9" => '&#44530;',
 "\x82\xFA" => '&#44531;',
 "\x82\xFB" => '&#44532;',
 "\x82\xFC" => '&#44533;',
 "\x82\xFD" => '&#44534;',
 "\x82\xFE" => '&#44535;',
 "\x83\x41" => '&#44538;',
 "\x83\x42" => '&#44539;',
 "\x83\x43" => '&#44541;',
 "\x83\x44" => '&#44542;',
 "\x83\x45" => '&#44546;',
 "\x83\x46" => '&#44547;',
 "\x83\x47" => '&#44548;',
 "\x83\x48" => '&#44549;',
 "\x83\x49" => '&#44550;',
 "\x83\x4A" => '&#44551;',
 "\x83\x4B" => '&#44554;',
 "\x83\x4C" => '&#44556;',
 "\x83\x4D" => '&#44558;',
 "\x83\x4E" => '&#44559;',
 "\x83\x4F" => '&#44560;',
 "\x83\x50" => '&#44561;',
 "\x83\x51" => '&#44562;',
 "\x83\x52" => '&#44563;',
 "\x83\x53" => '&#44565;',
 "\x83\x54" => '&#44566;',
 "\x83\x55" => '&#44567;',
 "\x83\x56" => '&#44568;',
 "\x83\x57" => '&#44569;',
 "\x83\x58" => '&#44570;',
 "\x83\x59" => '&#44571;',
 "\x83\x5A" => '&#44572;',
 "\x83\x61" => '&#44573;',
 "\x83\x62" => '&#44574;',
 "\x83\x63" => '&#44575;',
 "\x83\x64" => '&#44576;',
 "\x83\x65" => '&#44577;',
 "\x83\x66" => '&#44578;',
 "\x83\x67" => '&#44579;',
 "\x83\x68" => '&#44580;',
 "\x83\x69" => '&#44581;',
 "\x83\x6A" => '&#44582;',
 "\x83\x6B" => '&#44583;',
 "\x83\x6C" => '&#44584;',
 "\x83\x6D" => '&#44585;',
 "\x83\x6E" => '&#44586;',
 "\x83\x6F" => '&#44587;',
 "\x83\x70" => '&#44588;',
 "\x83\x71" => '&#44589;',
 "\x83\x72" => '&#44590;',
 "\x83\x73" => '&#44591;',
 "\x83\x74" => '&#44594;',
 "\x83\x75" => '&#44595;',
 "\x83\x76" => '&#44597;',
 "\x83\x77" => '&#44598;',
 "\x83\x78" => '&#44601;',
 "\x83\x79" => '&#44603;',
 "\x83\x7A" => '&#44604;',
 "\x83\x81" => '&#44605;',
 "\x83\x82" => '&#44606;',
 "\x83\x83" => '&#44607;',
 "\x83\x84" => '&#44610;',
 "\x83\x85" => '&#44612;',
 "\x83\x86" => '&#44615;',
 "\x83\x87" => '&#44616;',
 "\x83\x88" => '&#44617;',
 "\x83\x89" => '&#44619;',
 "\x83\x8A" => '&#44623;',
 "\x83\x8B" => '&#44625;',
 "\x83\x8C" => '&#44626;',
 "\x83\x8D" => '&#44627;',
 "\x83\x8E" => '&#44629;',
 "\x83\x8F" => '&#44631;',
 "\x83\x90" => '&#44632;',
 "\x83\x91" => '&#44633;',
 "\x83\x92" => '&#44634;',
 "\x83\x93" => '&#44635;',
 "\x83\x94" => '&#44638;',
 "\x83\x95" => '&#44642;',
 "\x83\x96" => '&#44643;',
 "\x83\x97" => '&#44644;',
 "\x83\x98" => '&#44646;',
 "\x83\x99" => '&#44647;',
 "\x83\x9A" => '&#44650;',
 "\x83\x9B" => '&#44651;',
 "\x83\x9C" => '&#44653;',
 "\x83\x9D" => '&#44654;',
 "\x83\x9E" => '&#44655;',
 "\x83\x9F" => '&#44657;',
 "\x83\xA0" => '&#44658;',
 "\x83\xA1" => '&#44659;',
 "\x83\xA2" => '&#44660;',
 "\x83\xA3" => '&#44661;',
 "\x83\xA4" => '&#44662;',
 "\x83\xA5" => '&#44663;',
 "\x83\xA6" => '&#44666;',
 "\x83\xA7" => '&#44670;',
 "\x83\xA8" => '&#44671;',
 "\x83\xA9" => '&#44672;',
 "\x83\xAA" => '&#44673;',
 "\x83\xAB" => '&#44674;',
 "\x83\xAC" => '&#44675;',
 "\x83\xAD" => '&#44678;',
 "\x83\xAE" => '&#44679;',
 "\x83\xAF" => '&#44680;',
 "\x83\xB0" => '&#44681;',
 "\x83\xB1" => '&#44682;',
 "\x83\xB2" => '&#44683;',
 "\x83\xB3" => '&#44685;',
 "\x83\xB4" => '&#44686;',
 "\x83\xB5" => '&#44687;',
 "\x83\xB6" => '&#44688;',
 "\x83\xB7" => '&#44689;',
 "\x83\xB8" => '&#44690;',
 "\x83\xB9" => '&#44691;',
 "\x83\xBA" => '&#44692;',
 "\x83\xBB" => '&#44693;',
 "\x83\xBC" => '&#44694;',
 "\x83\xBD" => '&#44695;',
 "\x83\xBE" => '&#44696;',
 "\x83\xBF" => '&#44697;',
 "\x83\xC0" => '&#44698;',
 "\x83\xC1" => '&#44699;',
 "\x83\xC2" => '&#44700;',
 "\x83\xC3" => '&#44701;',
 "\x83\xC4" => '&#44702;',
 "\x83\xC5" => '&#44703;',
 "\x83\xC6" => '&#44704;',
 "\x83\xC7" => '&#44705;',
 "\x83\xC8" => '&#44706;',
 "\x83\xC9" => '&#44707;',
 "\x83\xCA" => '&#44708;',
 "\x83\xCB" => '&#44709;',
 "\x83\xCC" => '&#44710;',
 "\x83\xCD" => '&#44711;',
 "\x83\xCE" => '&#44712;',
 "\x83\xCF" => '&#44713;',
 "\x83\xD0" => '&#44714;',
 "\x83\xD1" => '&#44715;',
 "\x83\xD2" => '&#44716;',
 "\x83\xD3" => '&#44717;',
 "\x83\xD4" => '&#44718;',
 "\x83\xD5" => '&#44719;',
 "\x83\xD6" => '&#44720;',
 "\x83\xD7" => '&#44721;',
 "\x83\xD8" => '&#44722;',
 "\x83\xD9" => '&#44723;',
 "\x83\xDA" => '&#44724;',
 "\x83\xDB" => '&#44725;',
 "\x83\xDC" => '&#44726;',
 "\x83\xDD" => '&#44727;',
 "\x83\xDE" => '&#44728;',
 "\x83\xDF" => '&#44729;',
 "\x83\xE0" => '&#44730;',
 "\x83\xE1" => '&#44731;',
 "\x83\xE2" => '&#44735;',
 "\x83\xE3" => '&#44737;',
 "\x83\xE4" => '&#44738;',
 "\x83\xE5" => '&#44739;',
 "\x83\xE6" => '&#44741;',
 "\x83\xE7" => '&#44742;',
 "\x83\xE8" => '&#44743;',
 "\x83\xE9" => '&#44744;',
 "\x83\xEA" => '&#44745;',
 "\x83\xEB" => '&#44746;',
 "\x83\xEC" => '&#44747;',
 "\x83\xED" => '&#44750;',
 "\x83\xEE" => '&#44754;',
 "\x83\xEF" => '&#44755;',
 "\x83\xF0" => '&#44756;',
 "\x83\xF1" => '&#44757;',
 "\x83\xF2" => '&#44758;',
 "\x83\xF3" => '&#44759;',
 "\x83\xF4" => '&#44762;',
 "\x83\xF5" => '&#44763;',
 "\x83\xF6" => '&#44765;',
 "\x83\xF7" => '&#44766;',
 "\x83\xF8" => '&#44767;',
 "\x83\xF9" => '&#44768;',
 "\x83\xFA" => '&#44769;',
 "\x83\xFB" => '&#44770;',
 "\x83\xFC" => '&#44771;',
 "\x83\xFD" => '&#44772;',
 "\x83\xFE" => '&#44773;',
 "\x84\x41" => '&#44774;',
 "\x84\x42" => '&#44775;',
 "\x84\x43" => '&#44777;',
 "\x84\x44" => '&#44778;',
 "\x84\x45" => '&#44780;',
 "\x84\x46" => '&#44782;',
 "\x84\x47" => '&#44783;',
 "\x84\x48" => '&#44784;',
 "\x84\x49" => '&#44785;',
 "\x84\x4A" => '&#44786;',
 "\x84\x4B" => '&#44787;',
 "\x84\x4C" => '&#44789;',
 "\x84\x4D" => '&#44790;',
 "\x84\x4E" => '&#44791;',
 "\x84\x4F" => '&#44793;',
 "\x84\x50" => '&#44794;',
 "\x84\x51" => '&#44795;',
 "\x84\x52" => '&#44797;',
 "\x84\x53" => '&#44798;',
 "\x84\x54" => '&#44799;',
 "\x84\x55" => '&#44800;',
 "\x84\x56" => '&#44801;',
 "\x84\x57" => '&#44802;',
 "\x84\x58" => '&#44803;',
 "\x84\x59" => '&#44804;',
 "\x84\x5A" => '&#44805;',
 "\x84\x61" => '&#44806;',
 "\x84\x62" => '&#44809;',
 "\x84\x63" => '&#44810;',
 "\x84\x64" => '&#44811;',
 "\x84\x65" => '&#44812;',
 "\x84\x66" => '&#44814;',
 "\x84\x67" => '&#44815;',
 "\x84\x68" => '&#44817;',
 "\x84\x69" => '&#44818;',
 "\x84\x6A" => '&#44819;',
 "\x84\x6B" => '&#44820;',
 "\x84\x6C" => '&#44821;',
 "\x84\x6D" => '&#44822;',
 "\x84\x6E" => '&#44823;',
 "\x84\x6F" => '&#44824;',
 "\x84\x70" => '&#44825;',
 "\x84\x71" => '&#44826;',
 "\x84\x72" => '&#44827;',
 "\x84\x73" => '&#44828;',
 "\x84\x74" => '&#44829;',
 "\x84\x75" => '&#44830;',
 "\x84\x76" => '&#44831;',
 "\x84\x77" => '&#44832;',
 "\x84\x78" => '&#44833;',
 "\x84\x79" => '&#44834;',
 "\x84\x7A" => '&#44835;',
 "\x84\x81" => '&#44836;',
 "\x84\x82" => '&#44837;',
 "\x84\x83" => '&#44838;',
 "\x84\x84" => '&#44839;',
 "\x84\x85" => '&#44840;',
 "\x84\x86" => '&#44841;',
 "\x84\x87" => '&#44842;',
 "\x84\x88" => '&#44843;',
 "\x84\x89" => '&#44846;',
 "\x84\x8A" => '&#44847;',
 "\x84\x8B" => '&#44849;',
 "\x84\x8C" => '&#44851;',
 "\x84\x8D" => '&#44853;',
 "\x84\x8E" => '&#44854;',
 "\x84\x8F" => '&#44855;',
 "\x84\x90" => '&#44856;',
 "\x84\x91" => '&#44857;',
 "\x84\x92" => '&#44858;',
 "\x84\x93" => '&#44859;',
 "\x84\x94" => '&#44862;',
 "\x84\x95" => '&#44864;',
 "\x84\x96" => '&#44868;',
 "\x84\x97" => '&#44869;',
 "\x84\x98" => '&#44870;',
 "\x84\x99" => '&#44871;',
 "\x84\x9A" => '&#44874;',
 "\x84\x9B" => '&#44875;',
 "\x84\x9C" => '&#44876;',
 "\x84\x9D" => '&#44877;',
 "\x84\x9E" => '&#44878;',
 "\x84\x9F" => '&#44879;',
 "\x84\xA0" => '&#44881;',
 "\x84\xA1" => '&#44882;',
 "\x84\xA2" => '&#44883;',
 "\x84\xA3" => '&#44884;',
 "\x84\xA4" => '&#44885;',
 "\x84\xA5" => '&#44886;',
 "\x84\xA6" => '&#44887;',
 "\x84\xA7" => '&#44888;',
 "\x84\xA8" => '&#44889;',
 "\x84\xA9" => '&#44890;',
 "\x84\xAA" => '&#44891;',
 "\x84\xAB" => '&#44894;',
 "\x84\xAC" => '&#44895;',
 "\x84\xAD" => '&#44896;',
 "\x84\xAE" => '&#44897;',
 "\x84\xAF" => '&#44898;',
 "\x84\xB0" => '&#44899;',
 "\x84\xB1" => '&#44902;',
 "\x84\xB2" => '&#44903;',
 "\x84\xB3" => '&#44904;',
 "\x84\xB4" => '&#44905;',
 "\x84\xB5" => '&#44906;',
 "\x84\xB6" => '&#44907;',
 "\x84\xB7" => '&#44908;',
 "\x84\xB8" => '&#44909;',
 "\x84\xB9" => '&#44910;',
 "\x84\xBA" => '&#44911;',
 "\x84\xBB" => '&#44912;',
 "\x84\xBC" => '&#44913;',
 "\x84\xBD" => '&#44914;',
 "\x84\xBE" => '&#44915;',
 "\x84\xBF" => '&#44916;',
 "\x84\xC0" => '&#44917;',
 "\x84\xC1" => '&#44918;',
 "\x84\xC2" => '&#44919;',
 "\x84\xC3" => '&#44920;',
 "\x84\xC4" => '&#44922;',
 "\x84\xC5" => '&#44923;',
 "\x84\xC6" => '&#44924;',
 "\x84\xC7" => '&#44925;',
 "\x84\xC8" => '&#44926;',
 "\x84\xC9" => '&#44927;',
 "\x84\xCA" => '&#44929;',
 "\x84\xCB" => '&#44930;',
 "\x84\xCC" => '&#44931;',
 "\x84\xCD" => '&#44933;',
 "\x84\xCE" => '&#44934;',
 "\x84\xCF" => '&#44935;',
 "\x84\xD0" => '&#44937;',
 "\x84\xD1" => '&#44938;',
 "\x84\xD2" => '&#44939;',
 "\x84\xD3" => '&#44940;',
 "\x84\xD4" => '&#44941;',
 "\x84\xD5" => '&#44942;',
 "\x84\xD6" => '&#44943;',
 "\x84\xD7" => '&#44946;',
 "\x84\xD8" => '&#44947;',
 "\x84\xD9" => '&#44948;',
 "\x84\xDA" => '&#44950;',
 "\x84\xDB" => '&#44951;',
 "\x84\xDC" => '&#44952;',
 "\x84\xDD" => '&#44953;',
 "\x84\xDE" => '&#44954;',
 "\x84\xDF" => '&#44955;',
 "\x84\xE0" => '&#44957;',
 "\x84\xE1" => '&#44958;',
 "\x84\xE2" => '&#44959;',
 "\x84\xE3" => '&#44960;',
 "\x84\xE4" => '&#44961;',
 "\x84\xE5" => '&#44962;',
 "\x84\xE6" => '&#44963;',
 "\x84\xE7" => '&#44964;',
 "\x84\xE8" => '&#44965;',
 "\x84\xE9" => '&#44966;',
 "\x84\xEA" => '&#44967;',
 "\x84\xEB" => '&#44968;',
 "\x84\xEC" => '&#44969;',
 "\x84\xED" => '&#44970;',
 "\x84\xEE" => '&#44971;',
 "\x84\xEF" => '&#44972;',
 "\x84\xF0" => '&#44973;',
 "\x84\xF1" => '&#44974;',
 "\x84\xF2" => '&#44975;',
 "\x84\xF3" => '&#44976;',
 "\x84\xF4" => '&#44977;',
 "\x84\xF5" => '&#44978;',
 "\x84\xF6" => '&#44979;',
 "\x84\xF7" => '&#44980;',
 "\x84\xF8" => '&#44981;',
 "\x84\xF9" => '&#44982;',
 "\x84\xFA" => '&#44983;',
 "\x84\xFB" => '&#44986;',
 "\x84\xFC" => '&#44987;',
 "\x84\xFD" => '&#44989;',
 "\x84\xFE" => '&#44990;',
 "\x85\x41" => '&#44991;',
 "\x85\x42" => '&#44993;',
 "\x85\x43" => '&#44994;',
 "\x85\x44" => '&#44995;',
 "\x85\x45" => '&#44996;',
 "\x85\x46" => '&#44997;',
 "\x85\x47" => '&#44998;',
 "\x85\x48" => '&#45002;',
 "\x85\x49" => '&#45004;',
 "\x85\x4A" => '&#45007;',
 "\x85\x4B" => '&#45008;',
 "\x85\x4C" => '&#45009;',
 "\x85\x4D" => '&#45010;',
 "\x85\x4E" => '&#45011;',
 "\x85\x4F" => '&#45013;',
 "\x85\x50" => '&#45014;',
 "\x85\x51" => '&#45015;',
 "\x85\x52" => '&#45016;',
 "\x85\x53" => '&#45017;',
 "\x85\x54" => '&#45018;',
 "\x85\x55" => '&#45019;',
 "\x85\x56" => '&#45021;',
 "\x85\x57" => '&#45022;',
 "\x85\x58" => '&#45023;',
 "\x85\x59" => '&#45024;',
 "\x85\x5A" => '&#45025;',
 "\x85\x61" => '&#45026;',
 "\x85\x62" => '&#45027;',
 "\x85\x63" => '&#45028;',
 "\x85\x64" => '&#45029;',
 "\x85\x65" => '&#45030;',
 "\x85\x66" => '&#45031;',
 "\x85\x67" => '&#45034;',
 "\x85\x68" => '&#45035;',
 "\x85\x69" => '&#45036;',
 "\x85\x6A" => '&#45037;',
 "\x85\x6B" => '&#45038;',
 "\x85\x6C" => '&#45039;',
 "\x85\x6D" => '&#45042;',
 "\x85\x6E" => '&#45043;',
 "\x85\x6F" => '&#45045;',
 "\x85\x70" => '&#45046;',
 "\x85\x71" => '&#45047;',
 "\x85\x72" => '&#45049;',
 "\x85\x73" => '&#45050;',
 "\x85\x74" => '&#45051;',
 "\x85\x75" => '&#45052;',
 "\x85\x76" => '&#45053;',
 "\x85\x77" => '&#45054;',
 "\x85\x78" => '&#45055;',
 "\x85\x79" => '&#45058;',
 "\x85\x7A" => '&#45059;',
 "\x85\x81" => '&#45061;',
 "\x85\x82" => '&#45062;',
 "\x85\x83" => '&#45063;',
 "\x85\x84" => '&#45064;',
 "\x85\x85" => '&#45065;',
 "\x85\x86" => '&#45066;',
 "\x85\x87" => '&#45067;',
 "\x85\x88" => '&#45069;',
 "\x85\x89" => '&#45070;',
 "\x85\x8A" => '&#45071;',
 "\x85\x8B" => '&#45073;',
 "\x85\x8C" => '&#45074;',
 "\x85\x8D" => '&#45075;',
 "\x85\x8E" => '&#45077;',
 "\x85\x8F" => '&#45078;',
 "\x85\x90" => '&#45079;',
 "\x85\x91" => '&#45080;',
 "\x85\x92" => '&#45081;',
 "\x85\x93" => '&#45082;',
 "\x85\x94" => '&#45083;',
 "\x85\x95" => '&#45086;',
 "\x85\x96" => '&#45087;',
 "\x85\x97" => '&#45088;',
 "\x85\x98" => '&#45089;',
 "\x85\x99" => '&#45090;',
 "\x85\x9A" => '&#45091;',
 "\x85\x9B" => '&#45092;',
 "\x85\x9C" => '&#45093;',
 "\x85\x9D" => '&#45094;',
 "\x85\x9E" => '&#45095;',
 "\x85\x9F" => '&#45097;',
 "\x85\xA0" => '&#45098;',
 "\x85\xA1" => '&#45099;',
 "\x85\xA2" => '&#45100;',
 "\x85\xA3" => '&#45101;',
 "\x85\xA4" => '&#45102;',
 "\x85\xA5" => '&#45103;',
 "\x85\xA6" => '&#45104;',
 "\x85\xA7" => '&#45105;',
 "\x85\xA8" => '&#45106;',
 "\x85\xA9" => '&#45107;',
 "\x85\xAA" => '&#45108;',
 "\x85\xAB" => '&#45109;',
 "\x85\xAC" => '&#45110;',
 "\x85\xAD" => '&#45111;',
 "\x85\xAE" => '&#45112;',
 "\x85\xAF" => '&#45113;',
 "\x85\xB0" => '&#45114;',
 "\x85\xB1" => '&#45115;',
 "\x85\xB2" => '&#45116;',
 "\x85\xB3" => '&#45117;',
 "\x85\xB4" => '&#45118;',
 "\x85\xB5" => '&#45119;',
 "\x85\xB6" => '&#45120;',
 "\x85\xB7" => '&#45121;',
 "\x85\xB8" => '&#45122;',
 "\x85\xB9" => '&#45123;',
 "\x85\xBA" => '&#45126;',
 "\x85\xBB" => '&#45127;',
 "\x85\xBC" => '&#45129;',
 "\x85\xBD" => '&#45131;',
 "\x85\xBE" => '&#45133;',
 "\x85\xBF" => '&#45135;',
 "\x85\xC0" => '&#45136;',
 "\x85\xC1" => '&#45137;',
 "\x85\xC2" => '&#45138;',
 "\x85\xC3" => '&#45142;',
 "\x85\xC4" => '&#45144;',
 "\x85\xC5" => '&#45146;',
 "\x85\xC6" => '&#45147;',
 "\x85\xC7" => '&#45148;',
 "\x85\xC8" => '&#45150;',
 "\x85\xC9" => '&#45151;',
 "\x85\xCA" => '&#45152;',
 "\x85\xCB" => '&#45153;',
 "\x85\xCC" => '&#45154;',
 "\x85\xCD" => '&#45155;',
 "\x85\xCE" => '&#45156;',
 "\x85\xCF" => '&#45157;',
 "\x85\xD0" => '&#45158;',
 "\x85\xD1" => '&#45159;',
 "\x85\xD2" => '&#45160;',
 "\x85\xD3" => '&#45161;',
 "\x85\xD4" => '&#45162;',
 "\x85\xD5" => '&#45163;',
 "\x85\xD6" => '&#45164;',
 "\x85\xD7" => '&#45165;',
 "\x85\xD8" => '&#45166;',
 "\x85\xD9" => '&#45167;',
 "\x85\xDA" => '&#45168;',
 "\x85\xDB" => '&#45169;',
 "\x85\xDC" => '&#45170;',
 "\x85\xDD" => '&#45171;',
 "\x85\xDE" => '&#45172;',
 "\x85\xDF" => '&#45173;',
 "\x85\xE0" => '&#45174;',
 "\x85\xE1" => '&#45175;',
 "\x85\xE2" => '&#45176;',
 "\x85\xE3" => '&#45177;',
 "\x85\xE4" => '&#45178;',
 "\x85\xE5" => '&#45179;',
 "\x85\xE6" => '&#45182;',
 "\x85\xE7" => '&#45183;',
 "\x85\xE8" => '&#45185;',
 "\x85\xE9" => '&#45186;',
 "\x85\xEA" => '&#45187;',
 "\x85\xEB" => '&#45189;',
 "\x85\xEC" => '&#45190;',
 "\x85\xED" => '&#45191;',
 "\x85\xEE" => '&#45192;',
 "\x85\xEF" => '&#45193;',
 "\x85\xF0" => '&#45194;',
 "\x85\xF1" => '&#45195;',
 "\x85\xF2" => '&#45198;',
 "\x85\xF3" => '&#45200;',
 "\x85\xF4" => '&#45202;',
 "\x85\xF5" => '&#45203;',
 "\x85\xF6" => '&#45204;',
 "\x85\xF7" => '&#45205;',
 "\x85\xF8" => '&#45206;',
 "\x85\xF9" => '&#45207;',
 "\x85\xFA" => '&#45211;',
 "\x85\xFB" => '&#45213;',
 "\x85\xFC" => '&#45214;',
 "\x85\xFD" => '&#45219;',
 "\x85\xFE" => '&#45220;',
 "\x86\x41" => '&#45221;',
 "\x86\x42" => '&#45222;',
 "\x86\x43" => '&#45223;',
 "\x86\x44" => '&#45226;',
 "\x86\x45" => '&#45232;',
 "\x86\x46" => '&#45234;',
 "\x86\x47" => '&#45238;',
 "\x86\x48" => '&#45239;',
 "\x86\x49" => '&#45241;',
 "\x86\x4A" => '&#45242;',
 "\x86\x4B" => '&#45243;',
 "\x86\x4C" => '&#45245;',
 "\x86\x4D" => '&#45246;',
 "\x86\x4E" => '&#45247;',
 "\x86\x4F" => '&#45248;',
 "\x86\x50" => '&#45249;',
 "\x86\x51" => '&#45250;',
 "\x86\x52" => '&#45251;',
 "\x86\x53" => '&#45254;',
 "\x86\x54" => '&#45258;',
 "\x86\x55" => '&#45259;',
 "\x86\x56" => '&#45260;',
 "\x86\x57" => '&#45261;',
 "\x86\x58" => '&#45262;',
 "\x86\x59" => '&#45263;',
 "\x86\x5A" => '&#45266;',
 "\x86\x61" => '&#45267;',
 "\x86\x62" => '&#45269;',
 "\x86\x63" => '&#45270;',
 "\x86\x64" => '&#45271;',
 "\x86\x65" => '&#45273;',
 "\x86\x66" => '&#45274;',
 "\x86\x67" => '&#45275;',
 "\x86\x68" => '&#45276;',
 "\x86\x69" => '&#45277;',
 "\x86\x6A" => '&#45278;',
 "\x86\x6B" => '&#45279;',
 "\x86\x6C" => '&#45281;',
 "\x86\x6D" => '&#45282;',
 "\x86\x6E" => '&#45283;',
 "\x86\x6F" => '&#45284;',
 "\x86\x70" => '&#45286;',
 "\x86\x71" => '&#45287;',
 "\x86\x72" => '&#45288;',
 "\x86\x73" => '&#45289;',
 "\x86\x74" => '&#45290;',
 "\x86\x75" => '&#45291;',
 "\x86\x76" => '&#45292;',
 "\x86\x77" => '&#45293;',
 "\x86\x78" => '&#45294;',
 "\x86\x79" => '&#45295;',
 "\x86\x7A" => '&#45296;',
 "\x86\x81" => '&#45297;',
 "\x86\x82" => '&#45298;',
 "\x86\x83" => '&#45299;',
 "\x86\x84" => '&#45300;',
 "\x86\x85" => '&#45301;',
 "\x86\x86" => '&#45302;',
 "\x86\x87" => '&#45303;',
 "\x86\x88" => '&#45304;',
 "\x86\x89" => '&#45305;',
 "\x86\x8A" => '&#45306;',
 "\x86\x8B" => '&#45307;',
 "\x86\x8C" => '&#45308;',
 "\x86\x8D" => '&#45309;',
 "\x86\x8E" => '&#45310;',
 "\x86\x8F" => '&#45311;',
 "\x86\x90" => '&#45312;',
 "\x86\x91" => '&#45313;',
 "\x86\x92" => '&#45314;',
 "\x86\x93" => '&#45315;',
 "\x86\x94" => '&#45316;',
 "\x86\x95" => '&#45317;',
 "\x86\x96" => '&#45318;',
 "\x86\x97" => '&#45319;',
 "\x86\x98" => '&#45322;',
 "\x86\x99" => '&#45325;',
 "\x86\x9A" => '&#45326;',
 "\x86\x9B" => '&#45327;',
 "\x86\x9C" => '&#45329;',
 "\x86\x9D" => '&#45332;',
 "\x86\x9E" => '&#45333;',
 "\x86\x9F" => '&#45334;',
 "\x86\xA0" => '&#45335;',
 "\x86\xA1" => '&#45338;',
 "\x86\xA2" => '&#45342;',
 "\x86\xA3" => '&#45343;',
 "\x86\xA4" => '&#45344;',
 "\x86\xA5" => '&#45345;',
 "\x86\xA6" => '&#45346;',
 "\x86\xA7" => '&#45350;',
 "\x86\xA8" => '&#45351;',
 "\x86\xA9" => '&#45353;',
 "\x86\xAA" => '&#45354;',
 "\x86\xAB" => '&#45355;',
 "\x86\xAC" => '&#45357;',
 "\x86\xAD" => '&#45358;',
 "\x86\xAE" => '&#45359;',
 "\x86\xAF" => '&#45360;',
 "\x86\xB0" => '&#45361;',
 "\x86\xB1" => '&#45362;',
 "\x86\xB2" => '&#45363;',
 "\x86\xB3" => '&#45366;',
 "\x86\xB4" => '&#45370;',
 "\x86\xB5" => '&#45371;',
 "\x86\xB6" => '&#45372;',
 "\x86\xB7" => '&#45373;',
 "\x86\xB8" => '&#45374;',
 "\x86\xB9" => '&#45375;',
 "\x86\xBA" => '&#45378;',
 "\x86\xBB" => '&#45379;',
 "\x86\xBC" => '&#45381;',
 "\x86\xBD" => '&#45382;',
 "\x86\xBE" => '&#45383;',
 "\x86\xBF" => '&#45385;',
 "\x86\xC0" => '&#45386;',
 "\x86\xC1" => '&#45387;',
 "\x86\xC2" => '&#45388;',
 "\x86\xC3" => '&#45389;',
 "\x86\xC4" => '&#45390;',
 "\x86\xC5" => '&#45391;',
 "\x86\xC6" => '&#45394;',
 "\x86\xC7" => '&#45395;',
 "\x86\xC8" => '&#45398;',
 "\x86\xC9" => '&#45399;',
 "\x86\xCA" => '&#45401;',
 "\x86\xCB" => '&#45402;',
 "\x86\xCC" => '&#45403;',
 "\x86\xCD" => '&#45405;',
 "\x86\xCE" => '&#45406;',
 "\x86\xCF" => '&#45407;',
 "\x86\xD0" => '&#45409;',
 "\x86\xD1" => '&#45410;',
 "\x86\xD2" => '&#45411;',
 "\x86\xD3" => '&#45412;',
 "\x86\xD4" => '&#45413;',
 "\x86\xD5" => '&#45414;',
 "\x86\xD6" => '&#45415;',
 "\x86\xD7" => '&#45416;',
 "\x86\xD8" => '&#45417;',
 "\x86\xD9" => '&#45418;',
 "\x86\xDA" => '&#45419;',
 "\x86\xDB" => '&#45420;',
 "\x86\xDC" => '&#45421;',
 "\x86\xDD" => '&#45422;',
 "\x86\xDE" => '&#45423;',
 "\x86\xDF" => '&#45424;',
 "\x86\xE0" => '&#45425;',
 "\x86\xE1" => '&#45426;',
 "\x86\xE2" => '&#45427;',
 "\x86\xE3" => '&#45428;',
 "\x86\xE4" => '&#45429;',
 "\x86\xE5" => '&#45430;',
 "\x86\xE6" => '&#45431;',
 "\x86\xE7" => '&#45434;',
 "\x86\xE8" => '&#45435;',
 "\x86\xE9" => '&#45437;',
 "\x86\xEA" => '&#45438;',
 "\x86\xEB" => '&#45439;',
 "\x86\xEC" => '&#45441;',
 "\x86\xED" => '&#45443;',
 "\x86\xEE" => '&#45444;',
 "\x86\xEF" => '&#45445;',
 "\x86\xF0" => '&#45446;',
 "\x86\xF1" => '&#45447;',
 "\x86\xF2" => '&#45450;',
 "\x86\xF3" => '&#45452;',
 "\x86\xF4" => '&#45454;',
 "\x86\xF5" => '&#45455;',
 "\x86\xF6" => '&#45456;',
 "\x86\xF7" => '&#45457;',
 "\x86\xF8" => '&#45461;',
 "\x86\xF9" => '&#45462;',
 "\x86\xFA" => '&#45463;',
 "\x86\xFB" => '&#45465;',
 "\x86\xFC" => '&#45466;',
 "\x86\xFD" => '&#45467;',
 "\x86\xFE" => '&#45469;',
 "\x87\x41" => '&#45470;',
 "\x87\x42" => '&#45471;',
 "\x87\x43" => '&#45472;',
 "\x87\x44" => '&#45473;',
 "\x87\x45" => '&#45474;',
 "\x87\x46" => '&#45475;',
 "\x87\x47" => '&#45476;',
 "\x87\x48" => '&#45477;',
 "\x87\x49" => '&#45478;',
 "\x87\x4A" => '&#45479;',
 "\x87\x4B" => '&#45481;',
 "\x87\x4C" => '&#45482;',
 "\x87\x4D" => '&#45483;',
 "\x87\x4E" => '&#45484;',
 "\x87\x4F" => '&#45485;',
 "\x87\x50" => '&#45486;',
 "\x87\x51" => '&#45487;',
 "\x87\x52" => '&#45488;',
 "\x87\x53" => '&#45489;',
 "\x87\x54" => '&#45490;',
 "\x87\x55" => '&#45491;',
 "\x87\x56" => '&#45492;',
 "\x87\x57" => '&#45493;',
 "\x87\x58" => '&#45494;',
 "\x87\x59" => '&#45495;',
 "\x87\x5A" => '&#45496;',
 "\x87\x61" => '&#45497;',
 "\x87\x62" => '&#45498;',
 "\x87\x63" => '&#45499;',
 "\x87\x64" => '&#45500;',
 "\x87\x65" => '&#45501;',
 "\x87\x66" => '&#45502;',
 "\x87\x67" => '&#45503;',
 "\x87\x68" => '&#45504;',
 "\x87\x69" => '&#45505;',
 "\x87\x6A" => '&#45506;',
 "\x87\x6B" => '&#45507;',
 "\x87\x6C" => '&#45508;',
 "\x87\x6D" => '&#45509;',
 "\x87\x6E" => '&#45510;',
 "\x87\x6F" => '&#45511;',
 "\x87\x70" => '&#45512;',
 "\x87\x71" => '&#45513;',
 "\x87\x72" => '&#45514;',
 "\x87\x73" => '&#45515;',
 "\x87\x74" => '&#45517;',
 "\x87\x75" => '&#45518;',
 "\x87\x76" => '&#45519;',
 "\x87\x77" => '&#45521;',
 "\x87\x78" => '&#45522;',
 "\x87\x79" => '&#45523;',
 "\x87\x7A" => '&#45525;',
 "\x87\x81" => '&#45526;',
 "\x87\x82" => '&#45527;',
 "\x87\x83" => '&#45528;',
 "\x87\x84" => '&#45529;',
 "\x87\x85" => '&#45530;',
 "\x87\x86" => '&#45531;',
 "\x87\x87" => '&#45534;',
 "\x87\x88" => '&#45536;',
 "\x87\x89" => '&#45537;',
 "\x87\x8A" => '&#45538;',
 "\x87\x8B" => '&#45539;',
 "\x87\x8C" => '&#45540;',
 "\x87\x8D" => '&#45541;',
 "\x87\x8E" => '&#45542;',
 "\x87\x8F" => '&#45543;',
 "\x87\x90" => '&#45546;',
 "\x87\x91" => '&#45547;',
 "\x87\x92" => '&#45549;',
 "\x87\x93" => '&#45550;',
 "\x87\x94" => '&#45551;',
 "\x87\x95" => '&#45553;',
 "\x87\x96" => '&#45554;',
 "\x87\x97" => '&#45555;',
 "\x87\x98" => '&#45556;',
 "\x87\x99" => '&#45557;',
 "\x87\x9A" => '&#45558;',
 "\x87\x9B" => '&#45559;',
 "\x87\x9C" => '&#45560;',
 "\x87\x9D" => '&#45562;',
 "\x87\x9E" => '&#45564;',
 "\x87\x9F" => '&#45566;',
 "\x87\xA0" => '&#45567;',
 "\x87\xA1" => '&#45568;',
 "\x87\xA2" => '&#45569;',
 "\x87\xA3" => '&#45570;',
 "\x87\xA4" => '&#45571;',
 "\x87\xA5" => '&#45574;',
 "\x87\xA6" => '&#45575;',
 "\x87\xA7" => '&#45577;',
 "\x87\xA8" => '&#45578;',
 "\x87\xA9" => '&#45581;',
 "\x87\xAA" => '&#45582;',
 "\x87\xAB" => '&#45583;',
 "\x87\xAC" => '&#45584;',
 "\x87\xAD" => '&#45585;',
 "\x87\xAE" => '&#45586;',
 "\x87\xAF" => '&#45587;',
 "\x87\xB0" => '&#45590;',
 "\x87\xB1" => '&#45592;',
 "\x87\xB2" => '&#45594;',
 "\x87\xB3" => '&#45595;',
 "\x87\xB4" => '&#45596;',
 "\x87\xB5" => '&#45597;',
 "\x87\xB6" => '&#45598;',
 "\x87\xB7" => '&#45599;',
 "\x87\xB8" => '&#45601;',
 "\x87\xB9" => '&#45602;',
 "\x87\xBA" => '&#45603;',
 "\x87\xBB" => '&#45604;',
 "\x87\xBC" => '&#45605;',
 "\x87\xBD" => '&#45606;',
 "\x87\xBE" => '&#45607;',
 "\x87\xBF" => '&#45608;',
 "\x87\xC0" => '&#45609;',
 "\x87\xC1" => '&#45610;',
 "\x87\xC2" => '&#45611;',
 "\x87\xC3" => '&#45612;',
 "\x87\xC4" => '&#45613;',
 "\x87\xC5" => '&#45614;',
 "\x87\xC6" => '&#45615;',
 "\x87\xC7" => '&#45616;',
 "\x87\xC8" => '&#45617;',
 "\x87\xC9" => '&#45618;',
 "\x87\xCA" => '&#45619;',
 "\x87\xCB" => '&#45621;',
 "\x87\xCC" => '&#45622;',
 "\x87\xCD" => '&#45623;',
 "\x87\xCE" => '&#45624;',
 "\x87\xCF" => '&#45625;',
 "\x87\xD0" => '&#45626;',
 "\x87\xD1" => '&#45627;',
 "\x87\xD2" => '&#45629;',
 "\x87\xD3" => '&#45630;',
 "\x87\xD4" => '&#45631;',
 "\x87\xD5" => '&#45632;',
 "\x87\xD6" => '&#45633;',
 "\x87\xD7" => '&#45634;',
 "\x87\xD8" => '&#45635;',
 "\x87\xD9" => '&#45636;',
 "\x87\xDA" => '&#45637;',
 "\x87\xDB" => '&#45638;',
 "\x87\xDC" => '&#45639;',
 "\x87\xDD" => '&#45640;',
 "\x87\xDE" => '&#45641;',
 "\x87\xDF" => '&#45642;',
 "\x87\xE0" => '&#45643;',
 "\x87\xE1" => '&#45644;',
 "\x87\xE2" => '&#45645;',
 "\x87\xE3" => '&#45646;',
 "\x87\xE4" => '&#45647;',
 "\x87\xE5" => '&#45648;',
 "\x87\xE6" => '&#45649;',
 "\x87\xE7" => '&#45650;',
 "\x87\xE8" => '&#45651;',
 "\x87\xE9" => '&#45652;',
 "\x87\xEA" => '&#45653;',
 "\x87\xEB" => '&#45654;',
 "\x87\xEC" => '&#45655;',
 "\x87\xED" => '&#45657;',
 "\x87\xEE" => '&#45658;',
 "\x87\xEF" => '&#45659;',
 "\x87\xF0" => '&#45661;',
 "\x87\xF1" => '&#45662;',
 "\x87\xF2" => '&#45663;',
 "\x87\xF3" => '&#45665;',
 "\x87\xF4" => '&#45666;',
 "\x87\xF5" => '&#45667;',
 "\x87\xF6" => '&#45668;',
 "\x87\xF7" => '&#45669;',
 "\x87\xF8" => '&#45670;',
 "\x87\xF9" => '&#45671;',
 "\x87\xFA" => '&#45674;',
 "\x87\xFB" => '&#45675;',
 "\x87\xFC" => '&#45676;',
 "\x87\xFD" => '&#45677;',
 "\x87\xFE" => '&#45678;',
 "\x88\x41" => '&#45679;',
 "\x88\x42" => '&#45680;',
 "\x88\x43" => '&#45681;',
 "\x88\x44" => '&#45682;',
 "\x88\x45" => '&#45683;',
 "\x88\x46" => '&#45686;',
 "\x88\x47" => '&#45687;',
 "\x88\x48" => '&#45688;',
 "\x88\x49" => '&#45689;',
 "\x88\x4A" => '&#45690;',
 "\x88\x4B" => '&#45691;',
 "\x88\x4C" => '&#45693;',
 "\x88\x4D" => '&#45694;',
 "\x88\x4E" => '&#45695;',
 "\x88\x4F" => '&#45696;',
 "\x88\x50" => '&#45697;',
 "\x88\x51" => '&#45698;',
 "\x88\x52" => '&#45699;',
 "\x88\x53" => '&#45702;',
 "\x88\x54" => '&#45703;',
 "\x88\x55" => '&#45704;',
 "\x88\x56" => '&#45706;',
 "\x88\x57" => '&#45707;',
 "\x88\x58" => '&#45708;',
 "\x88\x59" => '&#45709;',
 "\x88\x5A" => '&#45710;',
 "\x88\x61" => '&#45711;',
 "\x88\x62" => '&#45714;',
 "\x88\x63" => '&#45715;',
 "\x88\x64" => '&#45717;',
 "\x88\x65" => '&#45718;',
 "\x88\x66" => '&#45719;',
 "\x88\x67" => '&#45723;',
 "\x88\x68" => '&#45724;',
 "\x88\x69" => '&#45725;',
 "\x88\x6A" => '&#45726;',
 "\x88\x6B" => '&#45727;',
 "\x88\x6C" => '&#45730;',
 "\x88\x6D" => '&#45732;',
 "\x88\x6E" => '&#45735;',
 "\x88\x6F" => '&#45736;',
 "\x88\x70" => '&#45737;',
 "\x88\x71" => '&#45739;',
 "\x88\x72" => '&#45741;',
 "\x88\x73" => '&#45742;',
 "\x88\x74" => '&#45743;',
 "\x88\x75" => '&#45745;',
 "\x88\x76" => '&#45746;',
 "\x88\x77" => '&#45747;',
 "\x88\x78" => '&#45749;',
 "\x88\x79" => '&#45750;',
 "\x88\x7A" => '&#45751;',
 "\x88\x81" => '&#45752;',
 "\x88\x82" => '&#45753;',
 "\x88\x83" => '&#45754;',
 "\x88\x84" => '&#45755;',
 "\x88\x85" => '&#45756;',
 "\x88\x86" => '&#45757;',
 "\x88\x87" => '&#45758;',
 "\x88\x88" => '&#45759;',
 "\x88\x89" => '&#45760;',
 "\x88\x8A" => '&#45761;',
 "\x88\x8B" => '&#45762;',
 "\x88\x8C" => '&#45763;',
 "\x88\x8D" => '&#45764;',
 "\x88\x8E" => '&#45765;',
 "\x88\x8F" => '&#45766;',
 "\x88\x90" => '&#45767;',
 "\x88\x91" => '&#45770;',
 "\x88\x92" => '&#45771;',
 "\x88\x93" => '&#45773;',
 "\x88\x94" => '&#45774;',
 "\x88\x95" => '&#45775;',
 "\x88\x96" => '&#45777;',
 "\x88\x97" => '&#45779;',
 "\x88\x98" => '&#45780;',
 "\x88\x99" => '&#45781;',
 "\x88\x9A" => '&#45782;',
 "\x88\x9B" => '&#45783;',
 "\x88\x9C" => '&#45786;',
 "\x88\x9D" => '&#45788;',
 "\x88\x9E" => '&#45790;',
 "\x88\x9F" => '&#45791;',
 "\x88\xA0" => '&#45792;',
 "\x88\xA1" => '&#45793;',
 "\x88\xA2" => '&#45795;',
 "\x88\xA3" => '&#45799;',
 "\x88\xA4" => '&#45801;',
 "\x88\xA5" => '&#45802;',
 "\x88\xA6" => '&#45808;',
 "\x88\xA7" => '&#45809;',
 "\x88\xA8" => '&#45810;',
 "\x88\xA9" => '&#45814;',
 "\x88\xAA" => '&#45820;',
 "\x88\xAB" => '&#45821;',
 "\x88\xAC" => '&#45822;',
 "\x88\xAD" => '&#45826;',
 "\x88\xAE" => '&#45827;',
 "\x88\xAF" => '&#45829;',
 "\x88\xB0" => '&#45830;',
 "\x88\xB1" => '&#45831;',
 "\x88\xB2" => '&#45833;',
 "\x88\xB3" => '&#45834;',
 "\x88\xB4" => '&#45835;',
 "\x88\xB5" => '&#45836;',
 "\x88\xB6" => '&#45837;',
 "\x88\xB7" => '&#45838;',
 "\x88\xB8" => '&#45839;',
 "\x88\xB9" => '&#45842;',
 "\x88\xBA" => '&#45846;',
 "\x88\xBB" => '&#45847;',
 "\x88\xBC" => '&#45848;',
 "\x88\xBD" => '&#45849;',
 "\x88\xBE" => '&#45850;',
 "\x88\xBF" => '&#45851;',
 "\x88\xC0" => '&#45853;',
 "\x88\xC1" => '&#45854;',
 "\x88\xC2" => '&#45855;',
 "\x88\xC3" => '&#45856;',
 "\x88\xC4" => '&#45857;',
 "\x88\xC5" => '&#45858;',
 "\x88\xC6" => '&#45859;',
 "\x88\xC7" => '&#45860;',
 "\x88\xC8" => '&#45861;',
 "\x88\xC9" => '&#45862;',
 "\x88\xCA" => '&#45863;',
 "\x88\xCB" => '&#45864;',
 "\x88\xCC" => '&#45865;',
 "\x88\xCD" => '&#45866;',
 "\x88\xCE" => '&#45867;',
 "\x88\xCF" => '&#45868;',
 "\x88\xD0" => '&#45869;',
 "\x88\xD1" => '&#45870;',
 "\x88\xD2" => '&#45871;',
 "\x88\xD3" => '&#45872;',
 "\x88\xD4" => '&#45873;',
 "\x88\xD5" => '&#45874;',
 "\x88\xD6" => '&#45875;',
 "\x88\xD7" => '&#45876;',
 "\x88\xD8" => '&#45877;',
 "\x88\xD9" => '&#45878;',
 "\x88\xDA" => '&#45879;',
 "\x88\xDB" => '&#45880;',
 "\x88\xDC" => '&#45881;',
 "\x88\xDD" => '&#45882;',
 "\x88\xDE" => '&#45883;',
 "\x88\xDF" => '&#45884;',
 "\x88\xE0" => '&#45885;',
 "\x88\xE1" => '&#45886;',
 "\x88\xE2" => '&#45887;',
 "\x88\xE3" => '&#45888;',
 "\x88\xE4" => '&#45889;',
 "\x88\xE5" => '&#45890;',
 "\x88\xE6" => '&#45891;',
 "\x88\xE7" => '&#45892;',
 "\x88\xE8" => '&#45893;',
 "\x88\xE9" => '&#45894;',
 "\x88\xEA" => '&#45895;',
 "\x88\xEB" => '&#45896;',
 "\x88\xEC" => '&#45897;',
 "\x88\xED" => '&#45898;',
 "\x88\xEE" => '&#45899;',
 "\x88\xEF" => '&#45900;',
 "\x88\xF0" => '&#45901;',
 "\x88\xF1" => '&#45902;',
 "\x88\xF2" => '&#45903;',
 "\x88\xF3" => '&#45904;',
 "\x88\xF4" => '&#45905;',
 "\x88\xF5" => '&#45906;',
 "\x88\xF6" => '&#45907;',
 "\x88\xF7" => '&#45911;',
 "\x88\xF8" => '&#45913;',
 "\x88\xF9" => '&#45914;',
 "\x88\xFA" => '&#45917;',
 "\x88\xFB" => '&#45920;',
 "\x88\xFC" => '&#45921;',
 "\x88\xFD" => '&#45922;',
 "\x88\xFE" => '&#45923;',
 "\x89\x41" => '&#45926;',
 "\x89\x42" => '&#45928;',
 "\x89\x43" => '&#45930;',
 "\x89\x44" => '&#45932;',
 "\x89\x45" => '&#45933;',
 "\x89\x46" => '&#45935;',
 "\x89\x47" => '&#45938;',
 "\x89\x48" => '&#45939;',
 "\x89\x49" => '&#45941;',
 "\x89\x4A" => '&#45942;',
 "\x89\x4B" => '&#45943;',
 "\x89\x4C" => '&#45945;',
 "\x89\x4D" => '&#45946;',
 "\x89\x4E" => '&#45947;',
 "\x89\x4F" => '&#45948;',
 "\x89\x50" => '&#45949;',
 "\x89\x51" => '&#45950;',
 "\x89\x52" => '&#45951;',
 "\x89\x53" => '&#45954;',
 "\x89\x54" => '&#45958;',
 "\x89\x55" => '&#45959;',
 "\x89\x56" => '&#45960;',
 "\x89\x57" => '&#45961;',
 "\x89\x58" => '&#45962;',
 "\x89\x59" => '&#45963;',
 "\x89\x5A" => '&#45965;',
 "\x89\x61" => '&#45966;',
 "\x89\x62" => '&#45967;',
 "\x89\x63" => '&#45969;',
 "\x89\x64" => '&#45970;',
 "\x89\x65" => '&#45971;',
 "\x89\x66" => '&#45973;',
 "\x89\x67" => '&#45974;',
 "\x89\x68" => '&#45975;',
 "\x89\x69" => '&#45976;',
 "\x89\x6A" => '&#45977;',
 "\x89\x6B" => '&#45978;',
 "\x89\x6C" => '&#45979;',
 "\x89\x6D" => '&#45980;',
 "\x89\x6E" => '&#45981;',
 "\x89\x6F" => '&#45982;',
 "\x89\x70" => '&#45983;',
 "\x89\x71" => '&#45986;',
 "\x89\x72" => '&#45987;',
 "\x89\x73" => '&#45988;',
 "\x89\x74" => '&#45989;',
 "\x89\x75" => '&#45990;',
 "\x89\x76" => '&#45991;',
 "\x89\x77" => '&#45993;',
 "\x89\x78" => '&#45994;',
 "\x89\x79" => '&#45995;',
 "\x89\x7A" => '&#45997;',
 "\x89\x81" => '&#45998;',
 "\x89\x82" => '&#45999;',
 "\x89\x83" => '&#46000;',
 "\x89\x84" => '&#46001;',
 "\x89\x85" => '&#46002;',
 "\x89\x86" => '&#46003;',
 "\x89\x87" => '&#46004;',
 "\x89\x88" => '&#46005;',
 "\x89\x89" => '&#46006;',
 "\x89\x8A" => '&#46007;',
 "\x89\x8B" => '&#46008;',
 "\x89\x8C" => '&#46009;',
 "\x89\x8D" => '&#46010;',
 "\x89\x8E" => '&#46011;',
 "\x89\x8F" => '&#46012;',
 "\x89\x90" => '&#46013;',
 "\x89\x91" => '&#46014;',
 "\x89\x92" => '&#46015;',
 "\x89\x93" => '&#46016;',
 "\x89\x94" => '&#46017;',
 "\x89\x95" => '&#46018;',
 "\x89\x96" => '&#46019;',
 "\x89\x97" => '&#46022;',
 "\x89\x98" => '&#46023;',
 "\x89\x99" => '&#46025;',
 "\x89\x9A" => '&#46026;',
 "\x89\x9B" => '&#46029;',
 "\x89\x9C" => '&#46031;',
 "\x89\x9D" => '&#46033;',
 "\x89\x9E" => '&#46034;',
 "\x89\x9F" => '&#46035;',
 "\x89\xA0" => '&#46038;',
 "\x89\xA1" => '&#46040;',
 "\x89\xA2" => '&#46042;',
 "\x89\xA3" => '&#46044;',
 "\x89\xA4" => '&#46046;',
 "\x89\xA5" => '&#46047;',
 "\x89\xA6" => '&#46049;',
 "\x89\xA7" => '&#46050;',
 "\x89\xA8" => '&#46051;',
 "\x89\xA9" => '&#46053;',
 "\x89\xAA" => '&#46054;',
 "\x89\xAB" => '&#46055;',
 "\x89\xAC" => '&#46057;',
 "\x89\xAD" => '&#46058;',
 "\x89\xAE" => '&#46059;',
 "\x89\xAF" => '&#46060;',
 "\x89\xB0" => '&#46061;',
 "\x89\xB1" => '&#46062;',
 "\x89\xB2" => '&#46063;',
 "\x89\xB3" => '&#46064;',
 "\x89\xB4" => '&#46065;',
 "\x89\xB5" => '&#46066;',
 "\x89\xB6" => '&#46067;',
 "\x89\xB7" => '&#46068;',
 "\x89\xB8" => '&#46069;',
 "\x89\xB9" => '&#46070;',
 "\x89\xBA" => '&#46071;',
 "\x89\xBB" => '&#46072;',
 "\x89\xBC" => '&#46073;',
 "\x89\xBD" => '&#46074;',
 "\x89\xBE" => '&#46075;',
 "\x89\xBF" => '&#46077;',
 "\x89\xC0" => '&#46078;',
 "\x89\xC1" => '&#46079;',
 "\x89\xC2" => '&#46080;',
 "\x89\xC3" => '&#46081;',
 "\x89\xC4" => '&#46082;',
 "\x89\xC5" => '&#46083;',
 "\x89\xC6" => '&#46084;',
 "\x89\xC7" => '&#46085;',
 "\x89\xC8" => '&#46086;',
 "\x89\xC9" => '&#46087;',
 "\x89\xCA" => '&#46088;',
 "\x89\xCB" => '&#46089;',
 "\x89\xCC" => '&#46090;',
 "\x89\xCD" => '&#46091;',
 "\x89\xCE" => '&#46092;',
 "\x89\xCF" => '&#46093;',
 "\x89\xD0" => '&#46094;',
 "\x89\xD1" => '&#46095;',
 "\x89\xD2" => '&#46097;',
 "\x89\xD3" => '&#46098;',
 "\x89\xD4" => '&#46099;',
 "\x89\xD5" => '&#46100;',
 "\x89\xD6" => '&#46101;',
 "\x89\xD7" => '&#46102;',
 "\x89\xD8" => '&#46103;',
 "\x89\xD9" => '&#46105;',
 "\x89\xDA" => '&#46106;',
 "\x89\xDB" => '&#46107;',
 "\x89\xDC" => '&#46109;',
 "\x89\xDD" => '&#46110;',
 "\x89\xDE" => '&#46111;',
 "\x89\xDF" => '&#46113;',
 "\x89\xE0" => '&#46114;',
 "\x89\xE1" => '&#46115;',
 "\x89\xE2" => '&#46116;',
 "\x89\xE3" => '&#46117;',
 "\x89\xE4" => '&#46118;',
 "\x89\xE5" => '&#46119;',
 "\x89\xE6" => '&#46122;',
 "\x89\xE7" => '&#46124;',
 "\x89\xE8" => '&#46125;',
 "\x89\xE9" => '&#46126;',
 "\x89\xEA" => '&#46127;',
 "\x89\xEB" => '&#46128;',
 "\x89\xEC" => '&#46129;',
 "\x89\xED" => '&#46130;',
 "\x89\xEE" => '&#46131;',
 "\x89\xEF" => '&#46133;',
 "\x89\xF0" => '&#46134;',
 "\x89\xF1" => '&#46135;',
 "\x89\xF2" => '&#46136;',
 "\x89\xF3" => '&#46137;',
 "\x89\xF4" => '&#46138;',
 "\x89\xF5" => '&#46139;',
 "\x89\xF6" => '&#46140;',
 "\x89\xF7" => '&#46141;',
 "\x89\xF8" => '&#46142;',
 "\x89\xF9" => '&#46143;',
 "\x89\xFA" => '&#46144;',
 "\x89\xFB" => '&#46145;',
 "\x89\xFC" => '&#46146;',
 "\x89\xFD" => '&#46147;',
 "\x89\xFE" => '&#46148;',
 "\x8A\x41" => '&#46149;',
 "\x8A\x42" => '&#46150;',
 "\x8A\x43" => '&#46151;',
 "\x8A\x44" => '&#46152;',
 "\x8A\x45" => '&#46153;',
 "\x8A\x46" => '&#46154;',
 "\x8A\x47" => '&#46155;',
 "\x8A\x48" => '&#46156;',
 "\x8A\x49" => '&#46157;',
 "\x8A\x4A" => '&#46158;',
 "\x8A\x4B" => '&#46159;',
 "\x8A\x4C" => '&#46162;',
 "\x8A\x4D" => '&#46163;',
 "\x8A\x4E" => '&#46165;',
 "\x8A\x4F" => '&#46166;',
 "\x8A\x50" => '&#46167;',
 "\x8A\x51" => '&#46169;',
 "\x8A\x52" => '&#46170;',
 "\x8A\x53" => '&#46171;',
 "\x8A\x54" => '&#46172;',
 "\x8A\x55" => '&#46173;',
 "\x8A\x56" => '&#46174;',
 "\x8A\x57" => '&#46175;',
 "\x8A\x58" => '&#46178;',
 "\x8A\x59" => '&#46180;',
 "\x8A\x5A" => '&#46182;',
 "\x8A\x61" => '&#46183;',
 "\x8A\x62" => '&#46184;',
 "\x8A\x63" => '&#46185;',
 "\x8A\x64" => '&#46186;',
 "\x8A\x65" => '&#46187;',
 "\x8A\x66" => '&#46189;',
 "\x8A\x67" => '&#46190;',
 "\x8A\x68" => '&#46191;',
 "\x8A\x69" => '&#46192;',
 "\x8A\x6A" => '&#46193;',
 "\x8A\x6B" => '&#46194;',
 "\x8A\x6C" => '&#46195;',
 "\x8A\x6D" => '&#46196;',
 "\x8A\x6E" => '&#46197;',
 "\x8A\x6F" => '&#46198;',
 "\x8A\x70" => '&#46199;',
 "\x8A\x71" => '&#46200;',
 "\x8A\x72" => '&#46201;',
 "\x8A\x73" => '&#46202;',
 "\x8A\x74" => '&#46203;',
 "\x8A\x75" => '&#46204;',
 "\x8A\x76" => '&#46205;',
 "\x8A\x77" => '&#46206;',
 "\x8A\x78" => '&#46207;',
 "\x8A\x79" => '&#46209;',
 "\x8A\x7A" => '&#46210;',
 "\x8A\x81" => '&#46211;',
 "\x8A\x82" => '&#46212;',
 "\x8A\x83" => '&#46213;',
 "\x8A\x84" => '&#46214;',
 "\x8A\x85" => '&#46215;',
 "\x8A\x86" => '&#46217;',
 "\x8A\x87" => '&#46218;',
 "\x8A\x88" => '&#46219;',
 "\x8A\x89" => '&#46220;',
 "\x8A\x8A" => '&#46221;',
 "\x8A\x8B" => '&#46222;',
 "\x8A\x8C" => '&#46223;',
 "\x8A\x8D" => '&#46224;',
 "\x8A\x8E" => '&#46225;',
 "\x8A\x8F" => '&#46226;',
 "\x8A\x90" => '&#46227;',
 "\x8A\x91" => '&#46228;',
 "\x8A\x92" => '&#46229;',
 "\x8A\x93" => '&#46230;',
 "\x8A\x94" => '&#46231;',
 "\x8A\x95" => '&#46232;',
 "\x8A\x96" => '&#46233;',
 "\x8A\x97" => '&#46234;',
 "\x8A\x98" => '&#46235;',
 "\x8A\x99" => '&#46236;',
 "\x8A\x9A" => '&#46238;',
 "\x8A\x9B" => '&#46239;',
 "\x8A\x9C" => '&#46240;',
 "\x8A\x9D" => '&#46241;',
 "\x8A\x9E" => '&#46242;',
 "\x8A\x9F" => '&#46243;',
 "\x8A\xA0" => '&#46245;',
 "\x8A\xA1" => '&#46246;',
 "\x8A\xA2" => '&#46247;',
 "\x8A\xA3" => '&#46249;',
 "\x8A\xA4" => '&#46250;',
 "\x8A\xA5" => '&#46251;',
 "\x8A\xA6" => '&#46253;',
 "\x8A\xA7" => '&#46254;',
 "\x8A\xA8" => '&#46255;',
 "\x8A\xA9" => '&#46256;',
 "\x8A\xAA" => '&#46257;',
 "\x8A\xAB" => '&#46258;',
 "\x8A\xAC" => '&#46259;',
 "\x8A\xAD" => '&#46260;',
 "\x8A\xAE" => '&#46262;',
 "\x8A\xAF" => '&#46264;',
 "\x8A\xB0" => '&#46266;',
 "\x8A\xB1" => '&#46267;',
 "\x8A\xB2" => '&#46268;',
 "\x8A\xB3" => '&#46269;',
 "\x8A\xB4" => '&#46270;',
 "\x8A\xB5" => '&#46271;',
 "\x8A\xB6" => '&#46273;',
 "\x8A\xB7" => '&#46274;',
 "\x8A\xB8" => '&#46275;',
 "\x8A\xB9" => '&#46277;',
 "\x8A\xBA" => '&#46278;',
 "\x8A\xBB" => '&#46279;',
 "\x8A\xBC" => '&#46281;',
 "\x8A\xBD" => '&#46282;',
 "\x8A\xBE" => '&#46283;',
 "\x8A\xBF" => '&#46284;',
 "\x8A\xC0" => '&#46285;',
 "\x8A\xC1" => '&#46286;',
 "\x8A\xC2" => '&#46287;',
 "\x8A\xC3" => '&#46289;',
 "\x8A\xC4" => '&#46290;',
 "\x8A\xC5" => '&#46291;',
 "\x8A\xC6" => '&#46292;',
 "\x8A\xC7" => '&#46294;',
 "\x8A\xC8" => '&#46295;',
 "\x8A\xC9" => '&#46296;',
 "\x8A\xCA" => '&#46297;',
 "\x8A\xCB" => '&#46298;',
 "\x8A\xCC" => '&#46299;',
 "\x8A\xCD" => '&#46302;',
 "\x8A\xCE" => '&#46303;',
 "\x8A\xCF" => '&#46305;',
 "\x8A\xD0" => '&#46306;',
 "\x8A\xD1" => '&#46309;',
 "\x8A\xD2" => '&#46311;',
 "\x8A\xD3" => '&#46312;',
 "\x8A\xD4" => '&#46313;',
 "\x8A\xD5" => '&#46314;',
 "\x8A\xD6" => '&#46315;',
 "\x8A\xD7" => '&#46318;',
 "\x8A\xD8" => '&#46320;',
 "\x8A\xD9" => '&#46322;',
 "\x8A\xDA" => '&#46323;',
 "\x8A\xDB" => '&#46324;',
 "\x8A\xDC" => '&#46325;',
 "\x8A\xDD" => '&#46326;',
 "\x8A\xDE" => '&#46327;',
 "\x8A\xDF" => '&#46329;',
 "\x8A\xE0" => '&#46330;',
 "\x8A\xE1" => '&#46331;',
 "\x8A\xE2" => '&#46332;',
 "\x8A\xE3" => '&#46333;',
 "\x8A\xE4" => '&#46334;',
 "\x8A\xE5" => '&#46335;',
 "\x8A\xE6" => '&#46336;',
 "\x8A\xE7" => '&#46337;',
 "\x8A\xE8" => '&#46338;',
 "\x8A\xE9" => '&#46339;',
 "\x8A\xEA" => '&#46340;',
 "\x8A\xEB" => '&#46341;',
 "\x8A\xEC" => '&#46342;',
 "\x8A\xED" => '&#46343;',
 "\x8A\xEE" => '&#46344;',
 "\x8A\xEF" => '&#46345;',
 "\x8A\xF0" => '&#46346;',
 "\x8A\xF1" => '&#46347;',
 "\x8A\xF2" => '&#46348;',
 "\x8A\xF3" => '&#46349;',
 "\x8A\xF4" => '&#46350;',
 "\x8A\xF5" => '&#46351;',
 "\x8A\xF6" => '&#46352;',
 "\x8A\xF7" => '&#46353;',
 "\x8A\xF8" => '&#46354;',
 "\x8A\xF9" => '&#46355;',
 "\x8A\xFA" => '&#46358;',
 "\x8A\xFB" => '&#46359;',
 "\x8A\xFC" => '&#46361;',
 "\x8A\xFD" => '&#46362;',
 "\x8A\xFE" => '&#46365;',
 "\x8B\x41" => '&#46366;',
 "\x8B\x42" => '&#46367;',
 "\x8B\x43" => '&#46368;',
 "\x8B\x44" => '&#46369;',
 "\x8B\x45" => '&#46370;',
 "\x8B\x46" => '&#46371;',
 "\x8B\x47" => '&#46374;',
 "\x8B\x48" => '&#46379;',
 "\x8B\x49" => '&#46380;',
 "\x8B\x4A" => '&#46381;',
 "\x8B\x4B" => '&#46382;',
 "\x8B\x4C" => '&#46383;',
 "\x8B\x4D" => '&#46386;',
 "\x8B\x4E" => '&#46387;',
 "\x8B\x4F" => '&#46389;',
 "\x8B\x50" => '&#46390;',
 "\x8B\x51" => '&#46391;',
 "\x8B\x52" => '&#46393;',
 "\x8B\x53" => '&#46394;',
 "\x8B\x54" => '&#46395;',
 "\x8B\x55" => '&#46396;',
 "\x8B\x56" => '&#46397;',
 "\x8B\x57" => '&#46398;',
 "\x8B\x58" => '&#46399;',
 "\x8B\x59" => '&#46402;',
 "\x8B\x5A" => '&#46406;',
 "\x8B\x61" => '&#46407;',
 "\x8B\x62" => '&#46408;',
 "\x8B\x63" => '&#46409;',
 "\x8B\x64" => '&#46410;',
 "\x8B\x65" => '&#46414;',
 "\x8B\x66" => '&#46415;',
 "\x8B\x67" => '&#46417;',
 "\x8B\x68" => '&#46418;',
 "\x8B\x69" => '&#46419;',
 "\x8B\x6A" => '&#46421;',
 "\x8B\x6B" => '&#46422;',
 "\x8B\x6C" => '&#46423;',
 "\x8B\x6D" => '&#46424;',
 "\x8B\x6E" => '&#46425;',
 "\x8B\x6F" => '&#46426;',
 "\x8B\x70" => '&#46427;',
 "\x8B\x71" => '&#46430;',
 "\x8B\x72" => '&#46434;',
 "\x8B\x73" => '&#46435;',
 "\x8B\x74" => '&#46436;',
 "\x8B\x75" => '&#46437;',
 "\x8B\x76" => '&#46438;',
 "\x8B\x77" => '&#46439;',
 "\x8B\x78" => '&#46440;',
 "\x8B\x79" => '&#46441;',
 "\x8B\x7A" => '&#46442;',
 "\x8B\x81" => '&#46443;',
 "\x8B\x82" => '&#46444;',
 "\x8B\x83" => '&#46445;',
 "\x8B\x84" => '&#46446;',
 "\x8B\x85" => '&#46447;',
 "\x8B\x86" => '&#46448;',
 "\x8B\x87" => '&#46449;',
 "\x8B\x88" => '&#46450;',
 "\x8B\x89" => '&#46451;',
 "\x8B\x8A" => '&#46452;',
 "\x8B\x8B" => '&#46453;',
 "\x8B\x8C" => '&#46454;',
 "\x8B\x8D" => '&#46455;',
 "\x8B\x8E" => '&#46456;',
 "\x8B\x8F" => '&#46457;',
 "\x8B\x90" => '&#46458;',
 "\x8B\x91" => '&#46459;',
 "\x8B\x92" => '&#46460;',
 "\x8B\x93" => '&#46461;',
 "\x8B\x94" => '&#46462;',
 "\x8B\x95" => '&#46463;',
 "\x8B\x96" => '&#46464;',
 "\x8B\x97" => '&#46465;',
 "\x8B\x98" => '&#46466;',
 "\x8B\x99" => '&#46467;',
 "\x8B\x9A" => '&#46468;',
 "\x8B\x9B" => '&#46469;',
 "\x8B\x9C" => '&#46470;',
 "\x8B\x9D" => '&#46471;',
 "\x8B\x9E" => '&#46472;',
 "\x8B\x9F" => '&#46473;',
 "\x8B\xA0" => '&#46474;',
 "\x8B\xA1" => '&#46475;',
 "\x8B\xA2" => '&#46476;',
 "\x8B\xA3" => '&#46477;',
 "\x8B\xA4" => '&#46478;',
 "\x8B\xA5" => '&#46479;',
 "\x8B\xA6" => '&#46480;',
 "\x8B\xA7" => '&#46481;',
 "\x8B\xA8" => '&#46482;',
 "\x8B\xA9" => '&#46483;',
 "\x8B\xAA" => '&#46484;',
 "\x8B\xAB" => '&#46485;',
 "\x8B\xAC" => '&#46486;',
 "\x8B\xAD" => '&#46487;',
 "\x8B\xAE" => '&#46488;',
 "\x8B\xAF" => '&#46489;',
 "\x8B\xB0" => '&#46490;',
 "\x8B\xB1" => '&#46491;',
 "\x8B\xB2" => '&#46492;',
 "\x8B\xB3" => '&#46493;',
 "\x8B\xB4" => '&#46494;',
 "\x8B\xB5" => '&#46495;',
 "\x8B\xB6" => '&#46498;',
 "\x8B\xB7" => '&#46499;',
 "\x8B\xB8" => '&#46501;',
 "\x8B\xB9" => '&#46502;',
 "\x8B\xBA" => '&#46503;',
 "\x8B\xBB" => '&#46505;',
 "\x8B\xBC" => '&#46508;',
 "\x8B\xBD" => '&#46509;',
 "\x8B\xBE" => '&#46510;',
 "\x8B\xBF" => '&#46511;',
 "\x8B\xC0" => '&#46514;',
 "\x8B\xC1" => '&#46518;',
 "\x8B\xC2" => '&#46519;',
 "\x8B\xC3" => '&#46520;',
 "\x8B\xC4" => '&#46521;',
 "\x8B\xC5" => '&#46522;',
 "\x8B\xC6" => '&#46526;',
 "\x8B\xC7" => '&#46527;',
 "\x8B\xC8" => '&#46529;',
 "\x8B\xC9" => '&#46530;',
 "\x8B\xCA" => '&#46531;',
 "\x8B\xCB" => '&#46533;',
 "\x8B\xCC" => '&#46534;',
 "\x8B\xCD" => '&#46535;',
 "\x8B\xCE" => '&#46536;',
 "\x8B\xCF" => '&#46537;',
 "\x8B\xD0" => '&#46538;',
 "\x8B\xD1" => '&#46539;',
 "\x8B\xD2" => '&#46542;',
 "\x8B\xD3" => '&#46546;',
 "\x8B\xD4" => '&#46547;',
 "\x8B\xD5" => '&#46548;',
 "\x8B\xD6" => '&#46549;',
 "\x8B\xD7" => '&#46550;',
 "\x8B\xD8" => '&#46551;',
 "\x8B\xD9" => '&#46553;',
 "\x8B\xDA" => '&#46554;',
 "\x8B\xDB" => '&#46555;',
 "\x8B\xDC" => '&#46556;',
 "\x8B\xDD" => '&#46557;',
 "\x8B\xDE" => '&#46558;',
 "\x8B\xDF" => '&#46559;',
 "\x8B\xE0" => '&#46560;',
 "\x8B\xE1" => '&#46561;',
 "\x8B\xE2" => '&#46562;',
 "\x8B\xE3" => '&#46563;',
 "\x8B\xE4" => '&#46564;',
 "\x8B\xE5" => '&#46565;',
 "\x8B\xE6" => '&#46566;',
 "\x8B\xE7" => '&#46567;',
 "\x8B\xE8" => '&#46568;',
 "\x8B\xE9" => '&#46569;',
 "\x8B\xEA" => '&#46570;',
 "\x8B\xEB" => '&#46571;',
 "\x8B\xEC" => '&#46573;',
 "\x8B\xED" => '&#46574;',
 "\x8B\xEE" => '&#46575;',
 "\x8B\xEF" => '&#46576;',
 "\x8B\xF0" => '&#46577;',
 "\x8B\xF1" => '&#46578;',
 "\x8B\xF2" => '&#46579;',
 "\x8B\xF3" => '&#46580;',
 "\x8B\xF4" => '&#46581;',
 "\x8B\xF5" => '&#46582;',
 "\x8B\xF6" => '&#46583;',
 "\x8B\xF7" => '&#46584;',
 "\x8B\xF8" => '&#46585;',
 "\x8B\xF9" => '&#46586;',
 "\x8B\xFA" => '&#46587;',
 "\x8B\xFB" => '&#46588;',
 "\x8B\xFC" => '&#46589;',
 "\x8B\xFD" => '&#46590;',
 "\x8B\xFE" => '&#46591;',
 "\x8C\x41" => '&#46592;',
 "\x8C\x42" => '&#46593;',
 "\x8C\x43" => '&#46594;',
 "\x8C\x44" => '&#46595;',
 "\x8C\x45" => '&#46596;',
 "\x8C\x46" => '&#46597;',
 "\x8C\x47" => '&#46598;',
 "\x8C\x48" => '&#46599;',
 "\x8C\x49" => '&#46600;',
 "\x8C\x4A" => '&#46601;',
 "\x8C\x4B" => '&#46602;',
 "\x8C\x4C" => '&#46603;',
 "\x8C\x4D" => '&#46604;',
 "\x8C\x4E" => '&#46605;',
 "\x8C\x4F" => '&#46606;',
 "\x8C\x50" => '&#46607;',
 "\x8C\x51" => '&#46610;',
 "\x8C\x52" => '&#46611;',
 "\x8C\x53" => '&#46613;',
 "\x8C\x54" => '&#46614;',
 "\x8C\x55" => '&#46615;',
 "\x8C\x56" => '&#46617;',
 "\x8C\x57" => '&#46618;',
 "\x8C\x58" => '&#46619;',
 "\x8C\x59" => '&#46620;',
 "\x8C\x5A" => '&#46621;',
 "\x8C\x61" => '&#46622;',
 "\x8C\x62" => '&#46623;',
 "\x8C\x63" => '&#46624;',
 "\x8C\x64" => '&#46625;',
 "\x8C\x65" => '&#46626;',
 "\x8C\x66" => '&#46627;',
 "\x8C\x67" => '&#46628;',
 "\x8C\x68" => '&#46630;',
 "\x8C\x69" => '&#46631;',
 "\x8C\x6A" => '&#46632;',
 "\x8C\x6B" => '&#46633;',
 "\x8C\x6C" => '&#46634;',
 "\x8C\x6D" => '&#46635;',
 "\x8C\x6E" => '&#46637;',
 "\x8C\x6F" => '&#46638;',
 "\x8C\x70" => '&#46639;',
 "\x8C\x71" => '&#46640;',
 "\x8C\x72" => '&#46641;',
 "\x8C\x73" => '&#46642;',
 "\x8C\x74" => '&#46643;',
 "\x8C\x75" => '&#46645;',
 "\x8C\x76" => '&#46646;',
 "\x8C\x77" => '&#46647;',
 "\x8C\x78" => '&#46648;',
 "\x8C\x79" => '&#46649;',
 "\x8C\x7A" => '&#46650;',
 "\x8C\x81" => '&#46651;',
 "\x8C\x82" => '&#46652;',
 "\x8C\x83" => '&#46653;',
 "\x8C\x84" => '&#46654;',
 "\x8C\x85" => '&#46655;',
 "\x8C\x86" => '&#46656;',
 "\x8C\x87" => '&#46657;',
 "\x8C\x88" => '&#46658;',
 "\x8C\x89" => '&#46659;',
 "\x8C\x8A" => '&#46660;',
 "\x8C\x8B" => '&#46661;',
 "\x8C\x8C" => '&#46662;',
 "\x8C\x8D" => '&#46663;',
 "\x8C\x8E" => '&#46665;',
 "\x8C\x8F" => '&#46666;',
 "\x8C\x90" => '&#46667;',
 "\x8C\x91" => '&#46668;',
 "\x8C\x92" => '&#46669;',
 "\x8C\x93" => '&#46670;',
 "\x8C\x94" => '&#46671;',
 "\x8C\x95" => '&#46672;',
 "\x8C\x96" => '&#46673;',
 "\x8C\x97" => '&#46674;',
 "\x8C\x98" => '&#46675;',
 "\x8C\x99" => '&#46676;',
 "\x8C\x9A" => '&#46677;',
 "\x8C\x9B" => '&#46678;',
 "\x8C\x9C" => '&#46679;',
 "\x8C\x9D" => '&#46680;',
 "\x8C\x9E" => '&#46681;',
 "\x8C\x9F" => '&#46682;',
 "\x8C\xA0" => '&#46683;',
 "\x8C\xA1" => '&#46684;',
 "\x8C\xA2" => '&#46685;',
 "\x8C\xA3" => '&#46686;',
 "\x8C\xA4" => '&#46687;',
 "\x8C\xA5" => '&#46688;',
 "\x8C\xA6" => '&#46689;',
 "\x8C\xA7" => '&#46690;',
 "\x8C\xA8" => '&#46691;',
 "\x8C\xA9" => '&#46693;',
 "\x8C\xAA" => '&#46694;',
 "\x8C\xAB" => '&#46695;',
 "\x8C\xAC" => '&#46697;',
 "\x8C\xAD" => '&#46698;',
 "\x8C\xAE" => '&#46699;',
 "\x8C\xAF" => '&#46700;',
 "\x8C\xB0" => '&#46701;',
 "\x8C\xB1" => '&#46702;',
 "\x8C\xB2" => '&#46703;',
 "\x8C\xB3" => '&#46704;',
 "\x8C\xB4" => '&#46705;',
 "\x8C\xB5" => '&#46706;',
 "\x8C\xB6" => '&#46707;',
 "\x8C\xB7" => '&#46708;',
 "\x8C\xB8" => '&#46709;',
 "\x8C\xB9" => '&#46710;',
 "\x8C\xBA" => '&#46711;',
 "\x8C\xBB" => '&#46712;',
 "\x8C\xBC" => '&#46713;',
 "\x8C\xBD" => '&#46714;',
 "\x8C\xBE" => '&#46715;',
 "\x8C\xBF" => '&#46716;',
 "\x8C\xC0" => '&#46717;',
 "\x8C\xC1" => '&#46718;',
 "\x8C\xC2" => '&#46719;',
 "\x8C\xC3" => '&#46720;',
 "\x8C\xC4" => '&#46721;',
 "\x8C\xC5" => '&#46722;',
 "\x8C\xC6" => '&#46723;',
 "\x8C\xC7" => '&#46724;',
 "\x8C\xC8" => '&#46725;',
 "\x8C\xC9" => '&#46726;',
 "\x8C\xCA" => '&#46727;',
 "\x8C\xCB" => '&#46728;',
 "\x8C\xCC" => '&#46729;',
 "\x8C\xCD" => '&#46730;',
 "\x8C\xCE" => '&#46731;',
 "\x8C\xCF" => '&#46732;',
 "\x8C\xD0" => '&#46733;',
 "\x8C\xD1" => '&#46734;',
 "\x8C\xD2" => '&#46735;',
 "\x8C\xD3" => '&#46736;',
 "\x8C\xD4" => '&#46737;',
 "\x8C\xD5" => '&#46738;',
 "\x8C\xD6" => '&#46739;',
 "\x8C\xD7" => '&#46740;',
 "\x8C\xD8" => '&#46741;',
 "\x8C\xD9" => '&#46742;',
 "\x8C\xDA" => '&#46743;',
 "\x8C\xDB" => '&#46744;',
 "\x8C\xDC" => '&#46745;',
 "\x8C\xDD" => '&#46746;',
 "\x8C\xDE" => '&#46747;',
 "\x8C\xDF" => '&#46750;',
 "\x8C\xE0" => '&#46751;',
 "\x8C\xE1" => '&#46753;',
 "\x8C\xE2" => '&#46754;',
 "\x8C\xE3" => '&#46755;',
 "\x8C\xE4" => '&#46757;',
 "\x8C\xE5" => '&#46758;',
 "\x8C\xE6" => '&#46759;',
 "\x8C\xE7" => '&#46760;',
 "\x8C\xE8" => '&#46761;',
 "\x8C\xE9" => '&#46762;',
 "\x8C\xEA" => '&#46765;',
 "\x8C\xEB" => '&#46766;',
 "\x8C\xEC" => '&#46767;',
 "\x8C\xED" => '&#46768;',
 "\x8C\xEE" => '&#46770;',
 "\x8C\xEF" => '&#46771;',
 "\x8C\xF0" => '&#46772;',
 "\x8C\xF1" => '&#46773;',
 "\x8C\xF2" => '&#46774;',
 "\x8C\xF3" => '&#46775;',
 "\x8C\xF4" => '&#46776;',
 "\x8C\xF5" => '&#46777;',
 "\x8C\xF6" => '&#46778;',
 "\x8C\xF7" => '&#46779;',
 "\x8C\xF8" => '&#46780;',
 "\x8C\xF9" => '&#46781;',
 "\x8C\xFA" => '&#46782;',
 "\x8C\xFB" => '&#46783;',
 "\x8C\xFC" => '&#46784;',
 "\x8C\xFD" => '&#46785;',
 "\x8C\xFE" => '&#46786;',
 "\x8D\x41" => '&#46787;',
 "\x8D\x42" => '&#46788;',
 "\x8D\x43" => '&#46789;',
 "\x8D\x44" => '&#46790;',
 "\x8D\x45" => '&#46791;',
 "\x8D\x46" => '&#46792;',
 "\x8D\x47" => '&#46793;',
 "\x8D\x48" => '&#46794;',
 "\x8D\x49" => '&#46795;',
 "\x8D\x4A" => '&#46796;',
 "\x8D\x4B" => '&#46797;',
 "\x8D\x4C" => '&#46798;',
 "\x8D\x4D" => '&#46799;',
 "\x8D\x4E" => '&#46800;',
 "\x8D\x4F" => '&#46801;',
 "\x8D\x50" => '&#46802;',
 "\x8D\x51" => '&#46803;',
 "\x8D\x52" => '&#46805;',
 "\x8D\x53" => '&#46806;',
 "\x8D\x54" => '&#46807;',
 "\x8D\x55" => '&#46808;',
 "\x8D\x56" => '&#46809;',
 "\x8D\x57" => '&#46810;',
 "\x8D\x58" => '&#46811;',
 "\x8D\x59" => '&#46812;',
 "\x8D\x5A" => '&#46813;',
 "\x8D\x61" => '&#46814;',
 "\x8D\x62" => '&#46815;',
 "\x8D\x63" => '&#46816;',
 "\x8D\x64" => '&#46817;',
 "\x8D\x65" => '&#46818;',
 "\x8D\x66" => '&#46819;',
 "\x8D\x67" => '&#46820;',
 "\x8D\x68" => '&#46821;',
 "\x8D\x69" => '&#46822;',
 "\x8D\x6A" => '&#46823;',
 "\x8D\x6B" => '&#46824;',
 "\x8D\x6C" => '&#46825;',
 "\x8D\x6D" => '&#46826;',
 "\x8D\x6E" => '&#46827;',
 "\x8D\x6F" => '&#46828;',
 "\x8D\x70" => '&#46829;',
 "\x8D\x71" => '&#46830;',
 "\x8D\x72" => '&#46831;',
 "\x8D\x73" => '&#46833;',
 "\x8D\x74" => '&#46834;',
 "\x8D\x75" => '&#46835;',
 "\x8D\x76" => '&#46837;',
 "\x8D\x77" => '&#46838;',
 "\x8D\x78" => '&#46839;',
 "\x8D\x79" => '&#46841;',
 "\x8D\x7A" => '&#46842;',
 "\x8D\x81" => '&#46843;',
 "\x8D\x82" => '&#46844;',
 "\x8D\x83" => '&#46845;',
 "\x8D\x84" => '&#46846;',
 "\x8D\x85" => '&#46847;',
 "\x8D\x86" => '&#46850;',
 "\x8D\x87" => '&#46851;',
 "\x8D\x88" => '&#46852;',
 "\x8D\x89" => '&#46854;',
 "\x8D\x8A" => '&#46855;',
 "\x8D\x8B" => '&#46856;',
 "\x8D\x8C" => '&#46857;',
 "\x8D\x8D" => '&#46858;',
 "\x8D\x8E" => '&#46859;',
 "\x8D\x8F" => '&#46860;',
 "\x8D\x90" => '&#46861;',
 "\x8D\x91" => '&#46862;',
 "\x8D\x92" => '&#46863;',
 "\x8D\x93" => '&#46864;',
 "\x8D\x94" => '&#46865;',
 "\x8D\x95" => '&#46866;',
 "\x8D\x96" => '&#46867;',
 "\x8D\x97" => '&#46868;',
 "\x8D\x98" => '&#46869;',
 "\x8D\x99" => '&#46870;',
 "\x8D\x9A" => '&#46871;',
 "\x8D\x9B" => '&#46872;',
 "\x8D\x9C" => '&#46873;',
 "\x8D\x9D" => '&#46874;',
 "\x8D\x9E" => '&#46875;',
 "\x8D\x9F" => '&#46876;',
 "\x8D\xA0" => '&#46877;',
 "\x8D\xA1" => '&#46878;',
 "\x8D\xA2" => '&#46879;',
 "\x8D\xA3" => '&#46880;',
 "\x8D\xA4" => '&#46881;',
 "\x8D\xA5" => '&#46882;',
 "\x8D\xA6" => '&#46883;',
 "\x8D\xA7" => '&#46884;',
 "\x8D\xA8" => '&#46885;',
 "\x8D\xA9" => '&#46886;',
 "\x8D\xAA" => '&#46887;',
 "\x8D\xAB" => '&#46890;',
 "\x8D\xAC" => '&#46891;',
 "\x8D\xAD" => '&#46893;',
 "\x8D\xAE" => '&#46894;',
 "\x8D\xAF" => '&#46897;',
 "\x8D\xB0" => '&#46898;',
 "\x8D\xB1" => '&#46899;',
 "\x8D\xB2" => '&#46900;',
 "\x8D\xB3" => '&#46901;',
 "\x8D\xB4" => '&#46902;',
 "\x8D\xB5" => '&#46903;',
 "\x8D\xB6" => '&#46906;',
 "\x8D\xB7" => '&#46908;',
 "\x8D\xB8" => '&#46909;',
 "\x8D\xB9" => '&#46910;',
 "\x8D\xBA" => '&#46911;',
 "\x8D\xBB" => '&#46912;',
 "\x8D\xBC" => '&#46913;',
 "\x8D\xBD" => '&#46914;',
 "\x8D\xBE" => '&#46915;',
 "\x8D\xBF" => '&#46917;',
 "\x8D\xC0" => '&#46918;',
 "\x8D\xC1" => '&#46919;',
 "\x8D\xC2" => '&#46921;',
 "\x8D\xC3" => '&#46922;',
 "\x8D\xC4" => '&#46923;',
 "\x8D\xC5" => '&#46925;',
 "\x8D\xC6" => '&#46926;',
 "\x8D\xC7" => '&#46927;',
 "\x8D\xC8" => '&#46928;',
 "\x8D\xC9" => '&#46929;',
 "\x8D\xCA" => '&#46930;',
 "\x8D\xCB" => '&#46931;',
 "\x8D\xCC" => '&#46934;',
 "\x8D\xCD" => '&#46935;',
 "\x8D\xCE" => '&#46936;',
 "\x8D\xCF" => '&#46937;',
 "\x8D\xD0" => '&#46938;',
 "\x8D\xD1" => '&#46939;',
 "\x8D\xD2" => '&#46940;',
 "\x8D\xD3" => '&#46941;',
 "\x8D\xD4" => '&#46942;',
 "\x8D\xD5" => '&#46943;',
 "\x8D\xD6" => '&#46945;',
 "\x8D\xD7" => '&#46946;',
 "\x8D\xD8" => '&#46947;',
 "\x8D\xD9" => '&#46949;',
 "\x8D\xDA" => '&#46950;',
 "\x8D\xDB" => '&#46951;',
 "\x8D\xDC" => '&#46953;',
 "\x8D\xDD" => '&#46954;',
 "\x8D\xDE" => '&#46955;',
 "\x8D\xDF" => '&#46956;',
 "\x8D\xE0" => '&#46957;',
 "\x8D\xE1" => '&#46958;',
 "\x8D\xE2" => '&#46959;',
 "\x8D\xE3" => '&#46962;',
 "\x8D\xE4" => '&#46964;',
 "\x8D\xE5" => '&#46966;',
 "\x8D\xE6" => '&#46967;',
 "\x8D\xE7" => '&#46968;',
 "\x8D\xE8" => '&#46969;',
 "\x8D\xE9" => '&#46970;',
 "\x8D\xEA" => '&#46971;',
 "\x8D\xEB" => '&#46974;',
 "\x8D\xEC" => '&#46975;',
 "\x8D\xED" => '&#46977;',
 "\x8D\xEE" => '&#46978;',
 "\x8D\xEF" => '&#46979;',
 "\x8D\xF0" => '&#46981;',
 "\x8D\xF1" => '&#46982;',
 "\x8D\xF2" => '&#46983;',
 "\x8D\xF3" => '&#46984;',
 "\x8D\xF4" => '&#46985;',
 "\x8D\xF5" => '&#46986;',
 "\x8D\xF6" => '&#46987;',
 "\x8D\xF7" => '&#46990;',
 "\x8D\xF8" => '&#46995;',
 "\x8D\xF9" => '&#46996;',
 "\x8D\xFA" => '&#46997;',
 "\x8D\xFB" => '&#47002;',
 "\x8D\xFC" => '&#47003;',
 "\x8D\xFD" => '&#47005;',
 "\x8D\xFE" => '&#47006;',
 "\x8E\x41" => '&#47007;',
 "\x8E\x42" => '&#47009;',
 "\x8E\x43" => '&#47010;',
 "\x8E\x44" => '&#47011;',
 "\x8E\x45" => '&#47012;',
 "\x8E\x46" => '&#47013;',
 "\x8E\x47" => '&#47014;',
 "\x8E\x48" => '&#47015;',
 "\x8E\x49" => '&#47018;',
 "\x8E\x4A" => '&#47022;',
 "\x8E\x4B" => '&#47023;',
 "\x8E\x4C" => '&#47024;',
 "\x8E\x4D" => '&#47025;',
 "\x8E\x4E" => '&#47026;',
 "\x8E\x4F" => '&#47027;',
 "\x8E\x50" => '&#47030;',
 "\x8E\x51" => '&#47031;',
 "\x8E\x52" => '&#47033;',
 "\x8E\x53" => '&#47034;',
 "\x8E\x54" => '&#47035;',
 "\x8E\x55" => '&#47036;',
 "\x8E\x56" => '&#47037;',
 "\x8E\x57" => '&#47038;',
 "\x8E\x58" => '&#47039;',
 "\x8E\x59" => '&#47040;',
 "\x8E\x5A" => '&#47041;',
 "\x8E\x61" => '&#47042;',
 "\x8E\x62" => '&#47043;',
 "\x8E\x63" => '&#47044;',
 "\x8E\x64" => '&#47045;',
 "\x8E\x65" => '&#47046;',
 "\x8E\x66" => '&#47048;',
 "\x8E\x67" => '&#47050;',
 "\x8E\x68" => '&#47051;',
 "\x8E\x69" => '&#47052;',
 "\x8E\x6A" => '&#47053;',
 "\x8E\x6B" => '&#47054;',
 "\x8E\x6C" => '&#47055;',
 "\x8E\x6D" => '&#47056;',
 "\x8E\x6E" => '&#47057;',
 "\x8E\x6F" => '&#47058;',
 "\x8E\x70" => '&#47059;',
 "\x8E\x71" => '&#47060;',
 "\x8E\x72" => '&#47061;',
 "\x8E\x73" => '&#47062;',
 "\x8E\x74" => '&#47063;',
 "\x8E\x75" => '&#47064;',
 "\x8E\x76" => '&#47065;',
 "\x8E\x77" => '&#47066;',
 "\x8E\x78" => '&#47067;',
 "\x8E\x79" => '&#47068;',
 "\x8E\x7A" => '&#47069;',
 "\x8E\x81" => '&#47070;',
 "\x8E\x82" => '&#47071;',
 "\x8E\x83" => '&#47072;',
 "\x8E\x84" => '&#47073;',
 "\x8E\x85" => '&#47074;',
 "\x8E\x86" => '&#47075;',
 "\x8E\x87" => '&#47076;',
 "\x8E\x88" => '&#47077;',
 "\x8E\x89" => '&#47078;',
 "\x8E\x8A" => '&#47079;',
 "\x8E\x8B" => '&#47080;',
 "\x8E\x8C" => '&#47081;',
 "\x8E\x8D" => '&#47082;',
 "\x8E\x8E" => '&#47083;',
 "\x8E\x8F" => '&#47086;',
 "\x8E\x90" => '&#47087;',
 "\x8E\x91" => '&#47089;',
 "\x8E\x92" => '&#47090;',
 "\x8E\x93" => '&#47091;',
 "\x8E\x94" => '&#47093;',
 "\x8E\x95" => '&#47094;',
 "\x8E\x96" => '&#47095;',
 "\x8E\x97" => '&#47096;',
 "\x8E\x98" => '&#47097;',
 "\x8E\x99" => '&#47098;',
 "\x8E\x9A" => '&#47099;',
 "\x8E\x9B" => '&#47102;',
 "\x8E\x9C" => '&#47106;',
 "\x8E\x9D" => '&#47107;',
 "\x8E\x9E" => '&#47108;',
 "\x8E\x9F" => '&#47109;',
 "\x8E\xA0" => '&#47110;',
 "\x8E\xA1" => '&#47114;',
 "\x8E\xA2" => '&#47115;',
 "\x8E\xA3" => '&#47117;',
 "\x8E\xA4" => '&#47118;',
 "\x8E\xA5" => '&#47119;',
 "\x8E\xA6" => '&#47121;',
 "\x8E\xA7" => '&#47122;',
 "\x8E\xA8" => '&#47123;',
 "\x8E\xA9" => '&#47124;',
 "\x8E\xAA" => '&#47125;',
 "\x8E\xAB" => '&#47126;',
 "\x8E\xAC" => '&#47127;',
 "\x8E\xAD" => '&#47130;',
 "\x8E\xAE" => '&#47132;',
 "\x8E\xAF" => '&#47134;',
 "\x8E\xB0" => '&#47135;',
 "\x8E\xB1" => '&#47136;',
 "\x8E\xB2" => '&#47137;',
 "\x8E\xB3" => '&#47138;',
 "\x8E\xB4" => '&#47139;',
 "\x8E\xB5" => '&#47142;',
 "\x8E\xB6" => '&#47143;',
 "\x8E\xB7" => '&#47145;',
 "\x8E\xB8" => '&#47146;',
 "\x8E\xB9" => '&#47147;',
 "\x8E\xBA" => '&#47149;',
 "\x8E\xBB" => '&#47150;',
 "\x8E\xBC" => '&#47151;',
 "\x8E\xBD" => '&#47152;',
 "\x8E\xBE" => '&#47153;',
 "\x8E\xBF" => '&#47154;',
 "\x8E\xC0" => '&#47155;',
 "\x8E\xC1" => '&#47158;',
 "\x8E\xC2" => '&#47162;',
 "\x8E\xC3" => '&#47163;',
 "\x8E\xC4" => '&#47164;',
 "\x8E\xC5" => '&#47165;',
 "\x8E\xC6" => '&#47166;',
 "\x8E\xC7" => '&#47167;',
 "\x8E\xC8" => '&#47169;',
 "\x8E\xC9" => '&#47170;',
 "\x8E\xCA" => '&#47171;',
 "\x8E\xCB" => '&#47173;',
 "\x8E\xCC" => '&#47174;',
 "\x8E\xCD" => '&#47175;',
 "\x8E\xCE" => '&#47176;',
 "\x8E\xCF" => '&#47177;',
 "\x8E\xD0" => '&#47178;',
 "\x8E\xD1" => '&#47179;',
 "\x8E\xD2" => '&#47180;',
 "\x8E\xD3" => '&#47181;',
 "\x8E\xD4" => '&#47182;',
 "\x8E\xD5" => '&#47183;',
 "\x8E\xD6" => '&#47184;',
 "\x8E\xD7" => '&#47186;',
 "\x8E\xD8" => '&#47188;',
 "\x8E\xD9" => '&#47189;',
 "\x8E\xDA" => '&#47190;',
 "\x8E\xDB" => '&#47191;',
 "\x8E\xDC" => '&#47192;',
 "\x8E\xDD" => '&#47193;',
 "\x8E\xDE" => '&#47194;',
 "\x8E\xDF" => '&#47195;',
 "\x8E\xE0" => '&#47198;',
 "\x8E\xE1" => '&#47199;',
 "\x8E\xE2" => '&#47201;',
 "\x8E\xE3" => '&#47202;',
 "\x8E\xE4" => '&#47203;',
 "\x8E\xE5" => '&#47205;',
 "\x8E\xE6" => '&#47206;',
 "\x8E\xE7" => '&#47207;',
 "\x8E\xE8" => '&#47208;',
 "\x8E\xE9" => '&#47209;',
 "\x8E\xEA" => '&#47210;',
 "\x8E\xEB" => '&#47211;',
 "\x8E\xEC" => '&#47214;',
 "\x8E\xED" => '&#47216;',
 "\x8E\xEE" => '&#47218;',
 "\x8E\xEF" => '&#47219;',
 "\x8E\xF0" => '&#47220;',
 "\x8E\xF1" => '&#47221;',
 "\x8E\xF2" => '&#47222;',
 "\x8E\xF3" => '&#47223;',
 "\x8E\xF4" => '&#47225;',
 "\x8E\xF5" => '&#47226;',
 "\x8E\xF6" => '&#47227;',
 "\x8E\xF7" => '&#47229;',
 "\x8E\xF8" => '&#47230;',
 "\x8E\xF9" => '&#47231;',
 "\x8E\xFA" => '&#47232;',
 "\x8E\xFB" => '&#47233;',
 "\x8E\xFC" => '&#47234;',
 "\x8E\xFD" => '&#47235;',
 "\x8E\xFE" => '&#47236;',
 "\x8F\x41" => '&#47237;',
 "\x8F\x42" => '&#47238;',
 "\x8F\x43" => '&#47239;',
 "\x8F\x44" => '&#47240;',
 "\x8F\x45" => '&#47241;',
 "\x8F\x46" => '&#47242;',
 "\x8F\x47" => '&#47243;',
 "\x8F\x48" => '&#47244;',
 "\x8F\x49" => '&#47246;',
 "\x8F\x4A" => '&#47247;',
 "\x8F\x4B" => '&#47248;',
 "\x8F\x4C" => '&#47249;',
 "\x8F\x4D" => '&#47250;',
 "\x8F\x4E" => '&#47251;',
 "\x8F\x4F" => '&#47252;',
 "\x8F\x50" => '&#47253;',
 "\x8F\x51" => '&#47254;',
 "\x8F\x52" => '&#47255;',
 "\x8F\x53" => '&#47256;',
 "\x8F\x54" => '&#47257;',
 "\x8F\x55" => '&#47258;',
 "\x8F\x56" => '&#47259;',
 "\x8F\x57" => '&#47260;',
 "\x8F\x58" => '&#47261;',
 "\x8F\x59" => '&#47262;',
 "\x8F\x5A" => '&#47263;',
 "\x8F\x61" => '&#47264;',
 "\x8F\x62" => '&#47265;',
 "\x8F\x63" => '&#47266;',
 "\x8F\x64" => '&#47267;',
 "\x8F\x65" => '&#47268;',
 "\x8F\x66" => '&#47269;',
 "\x8F\x67" => '&#47270;',
 "\x8F\x68" => '&#47271;',
 "\x8F\x69" => '&#47273;',
 "\x8F\x6A" => '&#47274;',
 "\x8F\x6B" => '&#47275;',
 "\x8F\x6C" => '&#47276;',
 "\x8F\x6D" => '&#47277;',
 "\x8F\x6E" => '&#47278;',
 "\x8F\x6F" => '&#47279;',
 "\x8F\x70" => '&#47281;',
 "\x8F\x71" => '&#47282;',
 "\x8F\x72" => '&#47283;',
 "\x8F\x73" => '&#47285;',
 "\x8F\x74" => '&#47286;',
 "\x8F\x75" => '&#47287;',
 "\x8F\x76" => '&#47289;',
 "\x8F\x77" => '&#47290;',
 "\x8F\x78" => '&#47291;',
 "\x8F\x79" => '&#47292;',
 "\x8F\x7A" => '&#47293;',
 "\x8F\x81" => '&#47294;',
 "\x8F\x82" => '&#47295;',
 "\x8F\x83" => '&#47298;',
 "\x8F\x84" => '&#47300;',
 "\x8F\x85" => '&#47302;',
 "\x8F\x86" => '&#47303;',
 "\x8F\x87" => '&#47304;',
 "\x8F\x88" => '&#47305;',
 "\x8F\x89" => '&#47306;',
 "\x8F\x8A" => '&#47307;',
 "\x8F\x8B" => '&#47309;',
 "\x8F\x8C" => '&#47310;',
 "\x8F\x8D" => '&#47311;',
 "\x8F\x8E" => '&#47313;',
 "\x8F\x8F" => '&#47314;',
 "\x8F\x90" => '&#47315;',
 "\x8F\x91" => '&#47317;',
 "\x8F\x92" => '&#47318;',
 "\x8F\x93" => '&#47319;',
 "\x8F\x94" => '&#47320;',
 "\x8F\x95" => '&#47321;',
 "\x8F\x96" => '&#47322;',
 "\x8F\x97" => '&#47323;',
 "\x8F\x98" => '&#47324;',
 "\x8F\x99" => '&#47326;',
 "\x8F\x9A" => '&#47328;',
 "\x8F\x9B" => '&#47330;',
 "\x8F\x9C" => '&#47331;',
 "\x8F\x9D" => '&#47332;',
 "\x8F\x9E" => '&#47333;',
 "\x8F\x9F" => '&#47334;',
 "\x8F\xA0" => '&#47335;',
 "\x8F\xA1" => '&#47338;',
 "\x8F\xA2" => '&#47339;',
 "\x8F\xA3" => '&#47341;',
 "\x8F\xA4" => '&#47342;',
 "\x8F\xA5" => '&#47343;',
 "\x8F\xA6" => '&#47345;',
 "\x8F\xA7" => '&#47346;',
 "\x8F\xA8" => '&#47347;',
 "\x8F\xA9" => '&#47348;',
 "\x8F\xAA" => '&#47349;',
 "\x8F\xAB" => '&#47350;',
 "\x8F\xAC" => '&#47351;',
 "\x8F\xAD" => '&#47354;',
 "\x8F\xAE" => '&#47356;',
 "\x8F\xAF" => '&#47358;',
 "\x8F\xB0" => '&#47359;',
 "\x8F\xB1" => '&#47360;',
 "\x8F\xB2" => '&#47361;',
 "\x8F\xB3" => '&#47362;',
 "\x8F\xB4" => '&#47363;',
 "\x8F\xB5" => '&#47365;',
 "\x8F\xB6" => '&#47366;',
 "\x8F\xB7" => '&#47367;',
 "\x8F\xB8" => '&#47368;',
 "\x8F\xB9" => '&#47369;',
 "\x8F\xBA" => '&#47370;',
 "\x8F\xBB" => '&#47371;',
 "\x8F\xBC" => '&#47372;',
 "\x8F\xBD" => '&#47373;',
 "\x8F\xBE" => '&#47374;',
 "\x8F\xBF" => '&#47375;',
 "\x8F\xC0" => '&#47376;',
 "\x8F\xC1" => '&#47377;',
 "\x8F\xC2" => '&#47378;',
 "\x8F\xC3" => '&#47379;',
 "\x8F\xC4" => '&#47380;',
 "\x8F\xC5" => '&#47381;',
 "\x8F\xC6" => '&#47382;',
 "\x8F\xC7" => '&#47383;',
 "\x8F\xC8" => '&#47385;',
 "\x8F\xC9" => '&#47386;',
 "\x8F\xCA" => '&#47387;',
 "\x8F\xCB" => '&#47388;',
 "\x8F\xCC" => '&#47389;',
 "\x8F\xCD" => '&#47390;',
 "\x8F\xCE" => '&#47391;',
 "\x8F\xCF" => '&#47393;',
 "\x8F\xD0" => '&#47394;',
 "\x8F\xD1" => '&#47395;',
 "\x8F\xD2" => '&#47396;',
 "\x8F\xD3" => '&#47397;',
 "\x8F\xD4" => '&#47398;',
 "\x8F\xD5" => '&#47399;',
 "\x8F\xD6" => '&#47400;',
 "\x8F\xD7" => '&#47401;',
 "\x8F\xD8" => '&#47402;',
 "\x8F\xD9" => '&#47403;',
 "\x8F\xDA" => '&#47404;',
 "\x8F\xDB" => '&#47405;',
 "\x8F\xDC" => '&#47406;',
 "\x8F\xDD" => '&#47407;',
 "\x8F\xDE" => '&#47408;',
 "\x8F\xDF" => '&#47409;',
 "\x8F\xE0" => '&#47410;',
 "\x8F\xE1" => '&#47411;',
 "\x8F\xE2" => '&#47412;',
 "\x8F\xE3" => '&#47413;',
 "\x8F\xE4" => '&#47414;',
 "\x8F\xE5" => '&#47415;',
 "\x8F\xE6" => '&#47416;',
 "\x8F\xE7" => '&#47417;',
 "\x8F\xE8" => '&#47418;',
 "\x8F\xE9" => '&#47419;',
 "\x8F\xEA" => '&#47422;',
 "\x8F\xEB" => '&#47423;',
 "\x8F\xEC" => '&#47425;',
 "\x8F\xED" => '&#47426;',
 "\x8F\xEE" => '&#47427;',
 "\x8F\xEF" => '&#47429;',
 "\x8F\xF0" => '&#47430;',
 "\x8F\xF1" => '&#47431;',
 "\x8F\xF2" => '&#47432;',
 "\x8F\xF3" => '&#47433;',
 "\x8F\xF4" => '&#47434;',
 "\x8F\xF5" => '&#47435;',
 "\x8F\xF6" => '&#47437;',
 "\x8F\xF7" => '&#47438;',
 "\x8F\xF8" => '&#47440;',
 "\x8F\xF9" => '&#47442;',
 "\x8F\xFA" => '&#47443;',
 "\x8F\xFB" => '&#47444;',
 "\x8F\xFC" => '&#47445;',
 "\x8F\xFD" => '&#47446;',
 "\x8F\xFE" => '&#47447;',
 "\x90\x41" => '&#47450;',
 "\x90\x42" => '&#47451;',
 "\x90\x43" => '&#47453;',
 "\x90\x44" => '&#47454;',
 "\x90\x45" => '&#47455;',
 "\x90\x46" => '&#47457;',
 "\x90\x47" => '&#47458;',
 "\x90\x48" => '&#47459;',
 "\x90\x49" => '&#47460;',
 "\x90\x4A" => '&#47461;',
 "\x90\x4B" => '&#47462;',
 "\x90\x4C" => '&#47463;',
 "\x90\x4D" => '&#47466;',
 "\x90\x4E" => '&#47468;',
 "\x90\x4F" => '&#47470;',
 "\x90\x50" => '&#47471;',
 "\x90\x51" => '&#47472;',
 "\x90\x52" => '&#47473;',
 "\x90\x53" => '&#47474;',
 "\x90\x54" => '&#47475;',
 "\x90\x55" => '&#47478;',
 "\x90\x56" => '&#47479;',
 "\x90\x57" => '&#47481;',
 "\x90\x58" => '&#47482;',
 "\x90\x59" => '&#47483;',
 "\x90\x5A" => '&#47485;',
 "\x90\x61" => '&#47486;',
 "\x90\x62" => '&#47487;',
 "\x90\x63" => '&#47488;',
 "\x90\x64" => '&#47489;',
 "\x90\x65" => '&#47490;',
 "\x90\x66" => '&#47491;',
 "\x90\x67" => '&#47494;',
 "\x90\x68" => '&#47496;',
 "\x90\x69" => '&#47499;',
 "\x90\x6A" => '&#47500;',
 "\x90\x6B" => '&#47503;',
 "\x90\x6C" => '&#47504;',
 "\x90\x6D" => '&#47505;',
 "\x90\x6E" => '&#47506;',
 "\x90\x6F" => '&#47507;',
 "\x90\x70" => '&#47508;',
 "\x90\x71" => '&#47509;',
 "\x90\x72" => '&#47510;',
 "\x90\x73" => '&#47511;',
 "\x90\x74" => '&#47512;',
 "\x90\x75" => '&#47513;',
 "\x90\x76" => '&#47514;',
 "\x90\x77" => '&#47515;',
 "\x90\x78" => '&#47516;',
 "\x90\x79" => '&#47517;',
 "\x90\x7A" => '&#47518;',
 "\x90\x81" => '&#47519;',
 "\x90\x82" => '&#47520;',
 "\x90\x83" => '&#47521;',
 "\x90\x84" => '&#47522;',
 "\x90\x85" => '&#47523;',
 "\x90\x86" => '&#47524;',
 "\x90\x87" => '&#47525;',
 "\x90\x88" => '&#47526;',
 "\x90\x89" => '&#47527;',
 "\x90\x8A" => '&#47528;',
 "\x90\x8B" => '&#47529;',
 "\x90\x8C" => '&#47530;',
 "\x90\x8D" => '&#47531;',
 "\x90\x8E" => '&#47534;',
 "\x90\x8F" => '&#47535;',
 "\x90\x90" => '&#47537;',
 "\x90\x91" => '&#47538;',
 "\x90\x92" => '&#47539;',
 "\x90\x93" => '&#47541;',
 "\x90\x94" => '&#47542;',
 "\x90\x95" => '&#47543;',
 "\x90\x96" => '&#47544;',
 "\x90\x97" => '&#47545;',
 "\x90\x98" => '&#47546;',
 "\x90\x99" => '&#47547;',
 "\x90\x9A" => '&#47550;',
 "\x90\x9B" => '&#47552;',
 "\x90\x9C" => '&#47554;',
 "\x90\x9D" => '&#47555;',
 "\x90\x9E" => '&#47556;',
 "\x90\x9F" => '&#47557;',
 "\x90\xA0" => '&#47558;',
 "\x90\xA1" => '&#47559;',
 "\x90\xA2" => '&#47562;',
 "\x90\xA3" => '&#47563;',
 "\x90\xA4" => '&#47565;',
 "\x90\xA5" => '&#47571;',
 "\x90\xA6" => '&#47572;',
 "\x90\xA7" => '&#47573;',
 "\x90\xA8" => '&#47574;',
 "\x90\xA9" => '&#47575;',
 "\x90\xAA" => '&#47578;',
 "\x90\xAB" => '&#47580;',
 "\x90\xAC" => '&#47583;',
 "\x90\xAD" => '&#47584;',
 "\x90\xAE" => '&#47586;',
 "\x90\xAF" => '&#47590;',
 "\x90\xB0" => '&#47591;',
 "\x90\xB1" => '&#47593;',
 "\x90\xB2" => '&#47594;',
 "\x90\xB3" => '&#47595;',
 "\x90\xB4" => '&#47597;',
 "\x90\xB5" => '&#47598;',
 "\x90\xB6" => '&#47599;',
 "\x90\xB7" => '&#47600;',
 "\x90\xB8" => '&#47601;',
 "\x90\xB9" => '&#47602;',
 "\x90\xBA" => '&#47603;',
 "\x90\xBB" => '&#47606;',
 "\x90\xBC" => '&#47611;',
 "\x90\xBD" => '&#47612;',
 "\x90\xBE" => '&#47613;',
 "\x90\xBF" => '&#47614;',
 "\x90\xC0" => '&#47615;',
 "\x90\xC1" => '&#47618;',
 "\x90\xC2" => '&#47619;',
 "\x90\xC3" => '&#47620;',
 "\x90\xC4" => '&#47621;',
 "\x90\xC5" => '&#47622;',
 "\x90\xC6" => '&#47623;',
 "\x90\xC7" => '&#47625;',
 "\x90\xC8" => '&#47626;',
 "\x90\xC9" => '&#47627;',
 "\x90\xCA" => '&#47628;',
 "\x90\xCB" => '&#47629;',
 "\x90\xCC" => '&#47630;',
 "\x90\xCD" => '&#47631;',
 "\x90\xCE" => '&#47632;',
 "\x90\xCF" => '&#47633;',
 "\x90\xD0" => '&#47634;',
 "\x90\xD1" => '&#47635;',
 "\x90\xD2" => '&#47636;',
 "\x90\xD3" => '&#47638;',
 "\x90\xD4" => '&#47639;',
 "\x90\xD5" => '&#47640;',
 "\x90\xD6" => '&#47641;',
 "\x90\xD7" => '&#47642;',
 "\x90\xD8" => '&#47643;',
 "\x90\xD9" => '&#47644;',
 "\x90\xDA" => '&#47645;',
 "\x90\xDB" => '&#47646;',
 "\x90\xDC" => '&#47647;',
 "\x90\xDD" => '&#47648;',
 "\x90\xDE" => '&#47649;',
 "\x90\xDF" => '&#47650;',
 "\x90\xE0" => '&#47651;',
 "\x90\xE1" => '&#47652;',
 "\x90\xE2" => '&#47653;',
 "\x90\xE3" => '&#47654;',
 "\x90\xE4" => '&#47655;',
 "\x90\xE5" => '&#47656;',
 "\x90\xE6" => '&#47657;',
 "\x90\xE7" => '&#47658;',
 "\x90\xE8" => '&#47659;',
 "\x90\xE9" => '&#47660;',
 "\x90\xEA" => '&#47661;',
 "\x90\xEB" => '&#47662;',
 "\x90\xEC" => '&#47663;',
 "\x90\xED" => '&#47664;',
 "\x90\xEE" => '&#47665;',
 "\x90\xEF" => '&#47666;',
 "\x90\xF0" => '&#47667;',
 "\x90\xF1" => '&#47668;',
 "\x90\xF2" => '&#47669;',
 "\x90\xF3" => '&#47670;',
 "\x90\xF4" => '&#47671;',
 "\x90\xF5" => '&#47674;',
 "\x90\xF6" => '&#47675;',
 "\x90\xF7" => '&#47677;',
 "\x90\xF8" => '&#47678;',
 "\x90\xF9" => '&#47679;',
 "\x90\xFA" => '&#47681;',
 "\x90\xFB" => '&#47683;',
 "\x90\xFC" => '&#47684;',
 "\x90\xFD" => '&#47685;',
 "\x90\xFE" => '&#47686;',
 "\x91\x41" => '&#47687;',
 "\x91\x42" => '&#47690;',
 "\x91\x43" => '&#47692;',
 "\x91\x44" => '&#47695;',
 "\x91\x45" => '&#47696;',
 "\x91\x46" => '&#47697;',
 "\x91\x47" => '&#47698;',
 "\x91\x48" => '&#47702;',
 "\x91\x49" => '&#47703;',
 "\x91\x4A" => '&#47705;',
 "\x91\x4B" => '&#47706;',
 "\x91\x4C" => '&#47707;',
 "\x91\x4D" => '&#47709;',
 "\x91\x4E" => '&#47710;',
 "\x91\x4F" => '&#47711;',
 "\x91\x50" => '&#47712;',
 "\x91\x51" => '&#47713;',
 "\x91\x52" => '&#47714;',
 "\x91\x53" => '&#47715;',
 "\x91\x54" => '&#47718;',
 "\x91\x55" => '&#47722;',
 "\x91\x56" => '&#47723;',
 "\x91\x57" => '&#47724;',
 "\x91\x58" => '&#47725;',
 "\x91\x59" => '&#47726;',
 "\x91\x5A" => '&#47727;',
 "\x91\x61" => '&#47730;',
 "\x91\x62" => '&#47731;',
 "\x91\x63" => '&#47733;',
 "\x91\x64" => '&#47734;',
 "\x91\x65" => '&#47735;',
 "\x91\x66" => '&#47737;',
 "\x91\x67" => '&#47738;',
 "\x91\x68" => '&#47739;',
 "\x91\x69" => '&#47740;',
 "\x91\x6A" => '&#47741;',
 "\x91\x6B" => '&#47742;',
 "\x91\x6C" => '&#47743;',
 "\x91\x6D" => '&#47744;',
 "\x91\x6E" => '&#47745;',
 "\x91\x6F" => '&#47746;',
 "\x91\x70" => '&#47750;',
 "\x91\x71" => '&#47752;',
 "\x91\x72" => '&#47753;',
 "\x91\x73" => '&#47754;',
 "\x91\x74" => '&#47755;',
 "\x91\x75" => '&#47757;',
 "\x91\x76" => '&#47758;',
 "\x91\x77" => '&#47759;',
 "\x91\x78" => '&#47760;',
 "\x91\x79" => '&#47761;',
 "\x91\x7A" => '&#47762;',
 "\x91\x81" => '&#47763;',
 "\x91\x82" => '&#47764;',
 "\x91\x83" => '&#47765;',
 "\x91\x84" => '&#47766;',
 "\x91\x85" => '&#47767;',
 "\x91\x86" => '&#47768;',
 "\x91\x87" => '&#47769;',
 "\x91\x88" => '&#47770;',
 "\x91\x89" => '&#47771;',
 "\x91\x8A" => '&#47772;',
 "\x91\x8B" => '&#47773;',
 "\x91\x8C" => '&#47774;',
 "\x91\x8D" => '&#47775;',
 "\x91\x8E" => '&#47776;',
 "\x91\x8F" => '&#47777;',
 "\x91\x90" => '&#47778;',
 "\x91\x91" => '&#47779;',
 "\x91\x92" => '&#47780;',
 "\x91\x93" => '&#47781;',
 "\x91\x94" => '&#47782;',
 "\x91\x95" => '&#47783;',
 "\x91\x96" => '&#47786;',
 "\x91\x97" => '&#47789;',
 "\x91\x98" => '&#47790;',
 "\x91\x99" => '&#47791;',
 "\x91\x9A" => '&#47793;',
 "\x91\x9B" => '&#47795;',
 "\x91\x9C" => '&#47796;',
 "\x91\x9D" => '&#47797;',
 "\x91\x9E" => '&#47798;',
 "\x91\x9F" => '&#47799;',
 "\x91\xA0" => '&#47802;',
 "\x91\xA1" => '&#47804;',
 "\x91\xA2" => '&#47806;',
 "\x91\xA3" => '&#47807;',
 "\x91\xA4" => '&#47808;',
 "\x91\xA5" => '&#47809;',
 "\x91\xA6" => '&#47810;',
 "\x91\xA7" => '&#47811;',
 "\x91\xA8" => '&#47813;',
 "\x91\xA9" => '&#47814;',
 "\x91\xAA" => '&#47815;',
 "\x91\xAB" => '&#47817;',
 "\x91\xAC" => '&#47818;',
 "\x91\xAD" => '&#47819;',
 "\x91\xAE" => '&#47820;',
 "\x91\xAF" => '&#47821;',
 "\x91\xB0" => '&#47822;',
 "\x91\xB1" => '&#47823;',
 "\x91\xB2" => '&#47824;',
 "\x91\xB3" => '&#47825;',
 "\x91\xB4" => '&#47826;',
 "\x91\xB5" => '&#47827;',
 "\x91\xB6" => '&#47828;',
 "\x91\xB7" => '&#47829;',
 "\x91\xB8" => '&#47830;',
 "\x91\xB9" => '&#47831;',
 "\x91\xBA" => '&#47834;',
 "\x91\xBB" => '&#47835;',
 "\x91\xBC" => '&#47836;',
 "\x91\xBD" => '&#47837;',
 "\x91\xBE" => '&#47838;',
 "\x91\xBF" => '&#47839;',
 "\x91\xC0" => '&#47840;',
 "\x91\xC1" => '&#47841;',
 "\x91\xC2" => '&#47842;',
 "\x91\xC3" => '&#47843;',
 "\x91\xC4" => '&#47844;',
 "\x91\xC5" => '&#47845;',
 "\x91\xC6" => '&#47846;',
 "\x91\xC7" => '&#47847;',
 "\x91\xC8" => '&#47848;',
 "\x91\xC9" => '&#47849;',
 "\x91\xCA" => '&#47850;',
 "\x91\xCB" => '&#47851;',
 "\x91\xCC" => '&#47852;',
 "\x91\xCD" => '&#47853;',
 "\x91\xCE" => '&#47854;',
 "\x91\xCF" => '&#47855;',
 "\x91\xD0" => '&#47856;',
 "\x91\xD1" => '&#47857;',
 "\x91\xD2" => '&#47858;',
 "\x91\xD3" => '&#47859;',
 "\x91\xD4" => '&#47860;',
 "\x91\xD5" => '&#47861;',
 "\x91\xD6" => '&#47862;',
 "\x91\xD7" => '&#47863;',
 "\x91\xD8" => '&#47864;',
 "\x91\xD9" => '&#47865;',
 "\x91\xDA" => '&#47866;',
 "\x91\xDB" => '&#47867;',
 "\x91\xDC" => '&#47869;',
 "\x91\xDD" => '&#47870;',
 "\x91\xDE" => '&#47871;',
 "\x91\xDF" => '&#47873;',
 "\x91\xE0" => '&#47874;',
 "\x91\xE1" => '&#47875;',
 "\x91\xE2" => '&#47877;',
 "\x91\xE3" => '&#47878;',
 "\x91\xE4" => '&#47879;',
 "\x91\xE5" => '&#47880;',
 "\x91\xE6" => '&#47881;',
 "\x91\xE7" => '&#47882;',
 "\x91\xE8" => '&#47883;',
 "\x91\xE9" => '&#47884;',
 "\x91\xEA" => '&#47886;',
 "\x91\xEB" => '&#47888;',
 "\x91\xEC" => '&#47890;',
 "\x91\xED" => '&#47891;',
 "\x91\xEE" => '&#47892;',
 "\x91\xEF" => '&#47893;',
 "\x91\xF0" => '&#47894;',
 "\x91\xF1" => '&#47895;',
 "\x91\xF2" => '&#47897;',
 "\x91\xF3" => '&#47898;',
 "\x91\xF4" => '&#47899;',
 "\x91\xF5" => '&#47901;',
 "\x91\xF6" => '&#47902;',
 "\x91\xF7" => '&#47903;',
 "\x91\xF8" => '&#47905;',
 "\x91\xF9" => '&#47906;',
 "\x91\xFA" => '&#47907;',
 "\x91\xFB" => '&#47908;',
 "\x91\xFC" => '&#47909;',
 "\x91\xFD" => '&#47910;',
 "\x91\xFE" => '&#47911;',
 "\x92\x41" => '&#47912;',
 "\x92\x42" => '&#47914;',
 "\x92\x43" => '&#47916;',
 "\x92\x44" => '&#47917;',
 "\x92\x45" => '&#47918;',
 "\x92\x46" => '&#47919;',
 "\x92\x47" => '&#47920;',
 "\x92\x48" => '&#47921;',
 "\x92\x49" => '&#47922;',
 "\x92\x4A" => '&#47923;',
 "\x92\x4B" => '&#47927;',
 "\x92\x4C" => '&#47929;',
 "\x92\x4D" => '&#47930;',
 "\x92\x4E" => '&#47935;',
 "\x92\x4F" => '&#47936;',
 "\x92\x50" => '&#47937;',
 "\x92\x51" => '&#47938;',
 "\x92\x52" => '&#47939;',
 "\x92\x53" => '&#47942;',
 "\x92\x54" => '&#47944;',
 "\x92\x55" => '&#47946;',
 "\x92\x56" => '&#47947;',
 "\x92\x57" => '&#47948;',
 "\x92\x58" => '&#47950;',
 "\x92\x59" => '&#47953;',
 "\x92\x5A" => '&#47954;',
 "\x92\x61" => '&#47955;',
 "\x92\x62" => '&#47957;',
 "\x92\x63" => '&#47958;',
 "\x92\x64" => '&#47959;',
 "\x92\x65" => '&#47961;',
 "\x92\x66" => '&#47962;',
 "\x92\x67" => '&#47963;',
 "\x92\x68" => '&#47964;',
 "\x92\x69" => '&#47965;',
 "\x92\x6A" => '&#47966;',
 "\x92\x6B" => '&#47967;',
 "\x92\x6C" => '&#47968;',
 "\x92\x6D" => '&#47970;',
 "\x92\x6E" => '&#47972;',
 "\x92\x6F" => '&#47973;',
 "\x92\x70" => '&#47974;',
 "\x92\x71" => '&#47975;',
 "\x92\x72" => '&#47976;',
 "\x92\x73" => '&#47977;',
 "\x92\x74" => '&#47978;',
 "\x92\x75" => '&#47979;',
 "\x92\x76" => '&#47981;',
 "\x92\x77" => '&#47982;',
 "\x92\x78" => '&#47983;',
 "\x92\x79" => '&#47984;',
 "\x92\x7A" => '&#47985;',
 "\x92\x81" => '&#47986;',
 "\x92\x82" => '&#47987;',
 "\x92\x83" => '&#47988;',
 "\x92\x84" => '&#47989;',
 "\x92\x85" => '&#47990;',
 "\x92\x86" => '&#47991;',
 "\x92\x87" => '&#47992;',
 "\x92\x88" => '&#47993;',
 "\x92\x89" => '&#47994;',
 "\x92\x8A" => '&#47995;',
 "\x92\x8B" => '&#47996;',
 "\x92\x8C" => '&#47997;',
 "\x92\x8D" => '&#47998;',
 "\x92\x8E" => '&#47999;',
 "\x92\x8F" => '&#48000;',
 "\x92\x90" => '&#48001;',
 "\x92\x91" => '&#48002;',
 "\x92\x92" => '&#48003;',
 "\x92\x93" => '&#48004;',
 "\x92\x94" => '&#48005;',
 "\x92\x95" => '&#48006;',
 "\x92\x96" => '&#48007;',
 "\x92\x97" => '&#48009;',
 "\x92\x98" => '&#48010;',
 "\x92\x99" => '&#48011;',
 "\x92\x9A" => '&#48013;',
 "\x92\x9B" => '&#48014;',
 "\x92\x9C" => '&#48015;',
 "\x92\x9D" => '&#48017;',
 "\x92\x9E" => '&#48018;',
 "\x92\x9F" => '&#48019;',
 "\x92\xA0" => '&#48020;',
 "\x92\xA1" => '&#48021;',
 "\x92\xA2" => '&#48022;',
 "\x92\xA3" => '&#48023;',
 "\x92\xA4" => '&#48024;',
 "\x92\xA5" => '&#48025;',
 "\x92\xA6" => '&#48026;',
 "\x92\xA7" => '&#48027;',
 "\x92\xA8" => '&#48028;',
 "\x92\xA9" => '&#48029;',
 "\x92\xAA" => '&#48030;',
 "\x92\xAB" => '&#48031;',
 "\x92\xAC" => '&#48032;',
 "\x92\xAD" => '&#48033;',
 "\x92\xAE" => '&#48034;',
 "\x92\xAF" => '&#48035;',
 "\x92\xB0" => '&#48037;',
 "\x92\xB1" => '&#48038;',
 "\x92\xB2" => '&#48039;',
 "\x92\xB3" => '&#48041;',
 "\x92\xB4" => '&#48042;',
 "\x92\xB5" => '&#48043;',
 "\x92\xB6" => '&#48045;',
 "\x92\xB7" => '&#48046;',
 "\x92\xB8" => '&#48047;',
 "\x92\xB9" => '&#48048;',
 "\x92\xBA" => '&#48049;',
 "\x92\xBB" => '&#48050;',
 "\x92\xBC" => '&#48051;',
 "\x92\xBD" => '&#48053;',
 "\x92\xBE" => '&#48054;',
 "\x92\xBF" => '&#48056;',
 "\x92\xC0" => '&#48057;',
 "\x92\xC1" => '&#48058;',
 "\x92\xC2" => '&#48059;',
 "\x92\xC3" => '&#48060;',
 "\x92\xC4" => '&#48061;',
 "\x92\xC5" => '&#48062;',
 "\x92\xC6" => '&#48063;',
 "\x92\xC7" => '&#48065;',
 "\x92\xC8" => '&#48066;',
 "\x92\xC9" => '&#48067;',
 "\x92\xCA" => '&#48069;',
 "\x92\xCB" => '&#48070;',
 "\x92\xCC" => '&#48071;',
 "\x92\xCD" => '&#48073;',
 "\x92\xCE" => '&#48074;',
 "\x92\xCF" => '&#48075;',
 "\x92\xD0" => '&#48076;',
 "\x92\xD1" => '&#48077;',
 "\x92\xD2" => '&#48078;',
 "\x92\xD3" => '&#48079;',
 "\x92\xD4" => '&#48081;',
 "\x92\xD5" => '&#48082;',
 "\x92\xD6" => '&#48084;',
 "\x92\xD7" => '&#48085;',
 "\x92\xD8" => '&#48086;',
 "\x92\xD9" => '&#48087;',
 "\x92\xDA" => '&#48088;',
 "\x92\xDB" => '&#48089;',
 "\x92\xDC" => '&#48090;',
 "\x92\xDD" => '&#48091;',
 "\x92\xDE" => '&#48092;',
 "\x92\xDF" => '&#48093;',
 "\x92\xE0" => '&#48094;',
 "\x92\xE1" => '&#48095;',
 "\x92\xE2" => '&#48096;',
 "\x92\xE3" => '&#48097;',
 "\x92\xE4" => '&#48098;',
 "\x92\xE5" => '&#48099;',
 "\x92\xE6" => '&#48100;',
 "\x92\xE7" => '&#48101;',
 "\x92\xE8" => '&#48102;',
 "\x92\xE9" => '&#48103;',
 "\x92\xEA" => '&#48104;',
 "\x92\xEB" => '&#48105;',
 "\x92\xEC" => '&#48106;',
 "\x92\xED" => '&#48107;',
 "\x92\xEE" => '&#48108;',
 "\x92\xEF" => '&#48109;',
 "\x92\xF0" => '&#48110;',
 "\x92\xF1" => '&#48111;',
 "\x92\xF2" => '&#48112;',
 "\x92\xF3" => '&#48113;',
 "\x92\xF4" => '&#48114;',
 "\x92\xF5" => '&#48115;',
 "\x92\xF6" => '&#48116;',
 "\x92\xF7" => '&#48117;',
 "\x92\xF8" => '&#48118;',
 "\x92\xF9" => '&#48119;',
 "\x92\xFA" => '&#48122;',
 "\x92\xFB" => '&#48123;',
 "\x92\xFC" => '&#48125;',
 "\x92\xFD" => '&#48126;',
 "\x92\xFE" => '&#48129;',
 "\x93\x41" => '&#48131;',
 "\x93\x42" => '&#48132;',
 "\x93\x43" => '&#48133;',
 "\x93\x44" => '&#48134;',
 "\x93\x45" => '&#48135;',
 "\x93\x46" => '&#48138;',
 "\x93\x47" => '&#48142;',
 "\x93\x48" => '&#48144;',
 "\x93\x49" => '&#48146;',
 "\x93\x4A" => '&#48147;',
 "\x93\x4B" => '&#48153;',
 "\x93\x4C" => '&#48154;',
 "\x93\x4D" => '&#48160;',
 "\x93\x4E" => '&#48161;',
 "\x93\x4F" => '&#48162;',
 "\x93\x50" => '&#48163;',
 "\x93\x51" => '&#48166;',
 "\x93\x52" => '&#48168;',
 "\x93\x53" => '&#48170;',
 "\x93\x54" => '&#48171;',
 "\x93\x55" => '&#48172;',
 "\x93\x56" => '&#48174;',
 "\x93\x57" => '&#48175;',
 "\x93\x58" => '&#48178;',
 "\x93\x59" => '&#48179;',
 "\x93\x5A" => '&#48181;',
 "\x93\x61" => '&#48182;',
 "\x93\x62" => '&#48183;',
 "\x93\x63" => '&#48185;',
 "\x93\x64" => '&#48186;',
 "\x93\x65" => '&#48187;',
 "\x93\x66" => '&#48188;',
 "\x93\x67" => '&#48189;',
 "\x93\x68" => '&#48190;',
 "\x93\x69" => '&#48191;',
 "\x93\x6A" => '&#48194;',
 "\x93\x6B" => '&#48198;',
 "\x93\x6C" => '&#48199;',
 "\x93\x6D" => '&#48200;',
 "\x93\x6E" => '&#48202;',
 "\x93\x6F" => '&#48203;',
 "\x93\x70" => '&#48206;',
 "\x93\x71" => '&#48207;',
 "\x93\x72" => '&#48209;',
 "\x93\x73" => '&#48210;',
 "\x93\x74" => '&#48211;',
 "\x93\x75" => '&#48212;',
 "\x93\x76" => '&#48213;',
 "\x93\x77" => '&#48214;',
 "\x93\x78" => '&#48215;',
 "\x93\x79" => '&#48216;',
 "\x93\x7A" => '&#48217;',
 "\x93\x81" => '&#48218;',
 "\x93\x82" => '&#48219;',
 "\x93\x83" => '&#48220;',
 "\x93\x84" => '&#48222;',
 "\x93\x85" => '&#48223;',
 "\x93\x86" => '&#48224;',
 "\x93\x87" => '&#48225;',
 "\x93\x88" => '&#48226;',
 "\x93\x89" => '&#48227;',
 "\x93\x8A" => '&#48228;',
 "\x93\x8B" => '&#48229;',
 "\x93\x8C" => '&#48230;',
 "\x93\x8D" => '&#48231;',
 "\x93\x8E" => '&#48232;',
 "\x93\x8F" => '&#48233;',
 "\x93\x90" => '&#48234;',
 "\x93\x91" => '&#48235;',
 "\x93\x92" => '&#48236;',
 "\x93\x93" => '&#48237;',
 "\x93\x94" => '&#48238;',
 "\x93\x95" => '&#48239;',
 "\x93\x96" => '&#48240;',
 "\x93\x97" => '&#48241;',
 "\x93\x98" => '&#48242;',
 "\x93\x99" => '&#48243;',
 "\x93\x9A" => '&#48244;',
 "\x93\x9B" => '&#48245;',
 "\x93\x9C" => '&#48246;',
 "\x93\x9D" => '&#48247;',
 "\x93\x9E" => '&#48248;',
 "\x93\x9F" => '&#48249;',
 "\x93\xA0" => '&#48250;',
 "\x93\xA1" => '&#48251;',
 "\x93\xA2" => '&#48252;',
 "\x93\xA3" => '&#48253;',
 "\x93\xA4" => '&#48254;',
 "\x93\xA5" => '&#48255;',
 "\x93\xA6" => '&#48256;',
 "\x93\xA7" => '&#48257;',
 "\x93\xA8" => '&#48258;',
 "\x93\xA9" => '&#48259;',
 "\x93\xAA" => '&#48262;',
 "\x93\xAB" => '&#48263;',
 "\x93\xAC" => '&#48265;',
 "\x93\xAD" => '&#48266;',
 "\x93\xAE" => '&#48269;',
 "\x93\xAF" => '&#48271;',
 "\x93\xB0" => '&#48272;',
 "\x93\xB1" => '&#48273;',
 "\x93\xB2" => '&#48274;',
 "\x93\xB3" => '&#48275;',
 "\x93\xB4" => '&#48278;',
 "\x93\xB5" => '&#48280;',
 "\x93\xB6" => '&#48283;',
 "\x93\xB7" => '&#48284;',
 "\x93\xB8" => '&#48285;',
 "\x93\xB9" => '&#48286;',
 "\x93\xBA" => '&#48287;',
 "\x93\xBB" => '&#48290;',
 "\x93\xBC" => '&#48291;',
 "\x93\xBD" => '&#48293;',
 "\x93\xBE" => '&#48294;',
 "\x93\xBF" => '&#48297;',
 "\x93\xC0" => '&#48298;',
 "\x93\xC1" => '&#48299;',
 "\x93\xC2" => '&#48300;',
 "\x93\xC3" => '&#48301;',
 "\x93\xC4" => '&#48302;',
 "\x93\xC5" => '&#48303;',
 "\x93\xC6" => '&#48306;',
 "\x93\xC7" => '&#48310;',
 "\x93\xC8" => '&#48311;',
 "\x93\xC9" => '&#48312;',
 "\x93\xCA" => '&#48313;',
 "\x93\xCB" => '&#48314;',
 "\x93\xCC" => '&#48315;',
 "\x93\xCD" => '&#48318;',
 "\x93\xCE" => '&#48319;',
 "\x93\xCF" => '&#48321;',
 "\x93\xD0" => '&#48322;',
 "\x93\xD1" => '&#48323;',
 "\x93\xD2" => '&#48325;',
 "\x93\xD3" => '&#48326;',
 "\x93\xD4" => '&#48327;',
 "\x93\xD5" => '&#48328;',
 "\x93\xD6" => '&#48329;',
 "\x93\xD7" => '&#48330;',
 "\x93\xD8" => '&#48331;',
 "\x93\xD9" => '&#48332;',
 "\x93\xDA" => '&#48334;',
 "\x93\xDB" => '&#48338;',
 "\x93\xDC" => '&#48339;',
 "\x93\xDD" => '&#48340;',
 "\x93\xDE" => '&#48342;',
 "\x93\xDF" => '&#48343;',
 "\x93\xE0" => '&#48345;',
 "\x93\xE1" => '&#48346;',
 "\x93\xE2" => '&#48347;',
 "\x93\xE3" => '&#48349;',
 "\x93\xE4" => '&#48350;',
 "\x93\xE5" => '&#48351;',
 "\x93\xE6" => '&#48352;',
 "\x93\xE7" => '&#48353;',
 "\x93\xE8" => '&#48354;',
 "\x93\xE9" => '&#48355;',
 "\x93\xEA" => '&#48356;',
 "\x93\xEB" => '&#48357;',
 "\x93\xEC" => '&#48358;',
 "\x93\xED" => '&#48359;',
 "\x93\xEE" => '&#48360;',
 "\x93\xEF" => '&#48361;',
 "\x93\xF0" => '&#48362;',
 "\x93\xF1" => '&#48363;',
 "\x93\xF2" => '&#48364;',
 "\x93\xF3" => '&#48365;',
 "\x93\xF4" => '&#48366;',
 "\x93\xF5" => '&#48367;',
 "\x93\xF6" => '&#48368;',
 "\x93\xF7" => '&#48369;',
 "\x93\xF8" => '&#48370;',
 "\x93\xF9" => '&#48371;',
 "\x93\xFA" => '&#48375;',
 "\x93\xFB" => '&#48377;',
 "\x93\xFC" => '&#48378;',
 "\x93\xFD" => '&#48379;',
 "\x93\xFE" => '&#48381;',
 "\x94\x41" => '&#48382;',
 "\x94\x42" => '&#48383;',
 "\x94\x43" => '&#48384;',
 "\x94\x44" => '&#48385;',
 "\x94\x45" => '&#48386;',
 "\x94\x46" => '&#48387;',
 "\x94\x47" => '&#48390;',
 "\x94\x48" => '&#48392;',
 "\x94\x49" => '&#48394;',
 "\x94\x4A" => '&#48395;',
 "\x94\x4B" => '&#48396;',
 "\x94\x4C" => '&#48397;',
 "\x94\x4D" => '&#48398;',
 "\x94\x4E" => '&#48399;',
 "\x94\x4F" => '&#48401;',
 "\x94\x50" => '&#48402;',
 "\x94\x51" => '&#48403;',
 "\x94\x52" => '&#48405;',
 "\x94\x53" => '&#48406;',
 "\x94\x54" => '&#48407;',
 "\x94\x55" => '&#48408;',
 "\x94\x56" => '&#48409;',
 "\x94\x57" => '&#48410;',
 "\x94\x58" => '&#48411;',
 "\x94\x59" => '&#48412;',
 "\x94\x5A" => '&#48413;',
 "\x94\x61" => '&#48414;',
 "\x94\x62" => '&#48415;',
 "\x94\x63" => '&#48416;',
 "\x94\x64" => '&#48417;',
 "\x94\x65" => '&#48418;',
 "\x94\x66" => '&#48419;',
 "\x94\x67" => '&#48421;',
 "\x94\x68" => '&#48422;',
 "\x94\x69" => '&#48423;',
 "\x94\x6A" => '&#48424;',
 "\x94\x6B" => '&#48425;',
 "\x94\x6C" => '&#48426;',
 "\x94\x6D" => '&#48427;',
 "\x94\x6E" => '&#48429;',
 "\x94\x6F" => '&#48430;',
 "\x94\x70" => '&#48431;',
 "\x94\x71" => '&#48432;',
 "\x94\x72" => '&#48433;',
 "\x94\x73" => '&#48434;',
 "\x94\x74" => '&#48435;',
 "\x94\x75" => '&#48436;',
 "\x94\x76" => '&#48437;',
 "\x94\x77" => '&#48438;',
 "\x94\x78" => '&#48439;',
 "\x94\x79" => '&#48440;',
 "\x94\x7A" => '&#48441;',
 "\x94\x81" => '&#48442;',
 "\x94\x82" => '&#48443;',
 "\x94\x83" => '&#48444;',
 "\x94\x84" => '&#48445;',
 "\x94\x85" => '&#48446;',
 "\x94\x86" => '&#48447;',
 "\x94\x87" => '&#48449;',
 "\x94\x88" => '&#48450;',
 "\x94\x89" => '&#48451;',
 "\x94\x8A" => '&#48452;',
 "\x94\x8B" => '&#48453;',
 "\x94\x8C" => '&#48454;',
 "\x94\x8D" => '&#48455;',
 "\x94\x8E" => '&#48458;',
 "\x94\x8F" => '&#48459;',
 "\x94\x90" => '&#48461;',
 "\x94\x91" => '&#48462;',
 "\x94\x92" => '&#48463;',
 "\x94\x93" => '&#48465;',
 "\x94\x94" => '&#48466;',
 "\x94\x95" => '&#48467;',
 "\x94\x96" => '&#48468;',
 "\x94\x97" => '&#48469;',
 "\x94\x98" => '&#48470;',
 "\x94\x99" => '&#48471;',
 "\x94\x9A" => '&#48474;',
 "\x94\x9B" => '&#48475;',
 "\x94\x9C" => '&#48476;',
 "\x94\x9D" => '&#48477;',
 "\x94\x9E" => '&#48478;',
 "\x94\x9F" => '&#48479;',
 "\x94\xA0" => '&#48480;',
 "\x94\xA1" => '&#48481;',
 "\x94\xA2" => '&#48482;',
 "\x94\xA3" => '&#48483;',
 "\x94\xA4" => '&#48485;',
 "\x94\xA5" => '&#48486;',
 "\x94\xA6" => '&#48487;',
 "\x94\xA7" => '&#48489;',
 "\x94\xA8" => '&#48490;',
 "\x94\xA9" => '&#48491;',
 "\x94\xAA" => '&#48492;',
 "\x94\xAB" => '&#48493;',
 "\x94\xAC" => '&#48494;',
 "\x94\xAD" => '&#48495;',
 "\x94\xAE" => '&#48496;',
 "\x94\xAF" => '&#48497;',
 "\x94\xB0" => '&#48498;',
 "\x94\xB1" => '&#48499;',
 "\x94\xB2" => '&#48500;',
 "\x94\xB3" => '&#48501;',
 "\x94\xB4" => '&#48502;',
 "\x94\xB5" => '&#48503;',
 "\x94\xB6" => '&#48504;',
 "\x94\xB7" => '&#48505;',
 "\x94\xB8" => '&#48506;',
 "\x94\xB9" => '&#48507;',
 "\x94\xBA" => '&#48508;',
 "\x94\xBB" => '&#48509;',
 "\x94\xBC" => '&#48510;',
 "\x94\xBD" => '&#48511;',
 "\x94\xBE" => '&#48514;',
 "\x94\xBF" => '&#48515;',
 "\x94\xC0" => '&#48517;',
 "\x94\xC1" => '&#48518;',
 "\x94\xC2" => '&#48523;',
 "\x94\xC3" => '&#48524;',
 "\x94\xC4" => '&#48525;',
 "\x94\xC5" => '&#48526;',
 "\x94\xC6" => '&#48527;',
 "\x94\xC7" => '&#48530;',
 "\x94\xC8" => '&#48532;',
 "\x94\xC9" => '&#48534;',
 "\x94\xCA" => '&#48535;',
 "\x94\xCB" => '&#48536;',
 "\x94\xCC" => '&#48539;',
 "\x94\xCD" => '&#48541;',
 "\x94\xCE" => '&#48542;',
 "\x94\xCF" => '&#48543;',
 "\x94\xD0" => '&#48544;',
 "\x94\xD1" => '&#48545;',
 "\x94\xD2" => '&#48546;',
 "\x94\xD3" => '&#48547;',
 "\x94\xD4" => '&#48549;',
 "\x94\xD5" => '&#48550;',
 "\x94\xD6" => '&#48551;',
 "\x94\xD7" => '&#48552;',
 "\x94\xD8" => '&#48553;',
 "\x94\xD9" => '&#48554;',
 "\x94\xDA" => '&#48555;',
 "\x94\xDB" => '&#48556;',
 "\x94\xDC" => '&#48557;',
 "\x94\xDD" => '&#48558;',
 "\x94\xDE" => '&#48559;',
 "\x94\xDF" => '&#48561;',
 "\x94\xE0" => '&#48562;',
 "\x94\xE1" => '&#48563;',
 "\x94\xE2" => '&#48564;',
 "\x94\xE3" => '&#48565;',
 "\x94\xE4" => '&#48566;',
 "\x94\xE5" => '&#48567;',
 "\x94\xE6" => '&#48569;',
 "\x94\xE7" => '&#48570;',
 "\x94\xE8" => '&#48571;',
 "\x94\xE9" => '&#48572;',
 "\x94\xEA" => '&#48573;',
 "\x94\xEB" => '&#48574;',
 "\x94\xEC" => '&#48575;',
 "\x94\xED" => '&#48576;',
 "\x94\xEE" => '&#48577;',
 "\x94\xEF" => '&#48578;',
 "\x94\xF0" => '&#48579;',
 "\x94\xF1" => '&#48580;',
 "\x94\xF2" => '&#48581;',
 "\x94\xF3" => '&#48582;',
 "\x94\xF4" => '&#48583;',
 "\x94\xF5" => '&#48584;',
 "\x94\xF6" => '&#48585;',
 "\x94\xF7" => '&#48586;',
 "\x94\xF8" => '&#48587;',
 "\x94\xF9" => '&#48588;',
 "\x94\xFA" => '&#48589;',
 "\x94\xFB" => '&#48590;',
 "\x94\xFC" => '&#48591;',
 "\x94\xFD" => '&#48592;',
 "\x94\xFE" => '&#48593;',
 "\x95\x41" => '&#48594;',
 "\x95\x42" => '&#48595;',
 "\x95\x43" => '&#48598;',
 "\x95\x44" => '&#48599;',
 "\x95\x45" => '&#48601;',
 "\x95\x46" => '&#48602;',
 "\x95\x47" => '&#48603;',
 "\x95\x48" => '&#48605;',
 "\x95\x49" => '&#48606;',
 "\x95\x4A" => '&#48607;',
 "\x95\x4B" => '&#48608;',
 "\x95\x4C" => '&#48609;',
 "\x95\x4D" => '&#48610;',
 "\x95\x4E" => '&#48611;',
 "\x95\x4F" => '&#48612;',
 "\x95\x50" => '&#48613;',
 "\x95\x51" => '&#48614;',
 "\x95\x52" => '&#48615;',
 "\x95\x53" => '&#48616;',
 "\x95\x54" => '&#48618;',
 "\x95\x55" => '&#48619;',
 "\x95\x56" => '&#48620;',
 "\x95\x57" => '&#48621;',
 "\x95\x58" => '&#48622;',
 "\x95\x59" => '&#48623;',
 "\x95\x5A" => '&#48625;',
 "\x95\x61" => '&#48626;',
 "\x95\x62" => '&#48627;',
 "\x95\x63" => '&#48629;',
 "\x95\x64" => '&#48630;',
 "\x95\x65" => '&#48631;',
 "\x95\x66" => '&#48633;',
 "\x95\x67" => '&#48634;',
 "\x95\x68" => '&#48635;',
 "\x95\x69" => '&#48636;',
 "\x95\x6A" => '&#48637;',
 "\x95\x6B" => '&#48638;',
 "\x95\x6C" => '&#48639;',
 "\x95\x6D" => '&#48641;',
 "\x95\x6E" => '&#48642;',
 "\x95\x6F" => '&#48644;',
 "\x95\x70" => '&#48646;',
 "\x95\x71" => '&#48647;',
 "\x95\x72" => '&#48648;',
 "\x95\x73" => '&#48649;',
 "\x95\x74" => '&#48650;',
 "\x95\x75" => '&#48651;',
 "\x95\x76" => '&#48654;',
 "\x95\x77" => '&#48655;',
 "\x95\x78" => '&#48657;',
 "\x95\x79" => '&#48658;',
 "\x95\x7A" => '&#48659;',
 "\x95\x81" => '&#48661;',
 "\x95\x82" => '&#48662;',
 "\x95\x83" => '&#48663;',
 "\x95\x84" => '&#48664;',
 "\x95\x85" => '&#48665;',
 "\x95\x86" => '&#48666;',
 "\x95\x87" => '&#48667;',
 "\x95\x88" => '&#48670;',
 "\x95\x89" => '&#48672;',
 "\x95\x8A" => '&#48673;',
 "\x95\x8B" => '&#48674;',
 "\x95\x8C" => '&#48675;',
 "\x95\x8D" => '&#48676;',
 "\x95\x8E" => '&#48677;',
 "\x95\x8F" => '&#48678;',
 "\x95\x90" => '&#48679;',
 "\x95\x91" => '&#48680;',
 "\x95\x92" => '&#48681;',
 "\x95\x93" => '&#48682;',
 "\x95\x94" => '&#48683;',
 "\x95\x95" => '&#48684;',
 "\x95\x96" => '&#48685;',
 "\x95\x97" => '&#48686;',
 "\x95\x98" => '&#48687;',
 "\x95\x99" => '&#48688;',
 "\x95\x9A" => '&#48689;',
 "\x95\x9B" => '&#48690;',
 "\x95\x9C" => '&#48691;',
 "\x95\x9D" => '&#48692;',
 "\x95\x9E" => '&#48693;',
 "\x95\x9F" => '&#48694;',
 "\x95\xA0" => '&#48695;',
 "\x95\xA1" => '&#48696;',
 "\x95\xA2" => '&#48697;',
 "\x95\xA3" => '&#48698;',
 "\x95\xA4" => '&#48699;',
 "\x95\xA5" => '&#48700;',
 "\x95\xA6" => '&#48701;',
 "\x95\xA7" => '&#48702;',
 "\x95\xA8" => '&#48703;',
 "\x95\xA9" => '&#48704;',
 "\x95\xAA" => '&#48705;',
 "\x95\xAB" => '&#48706;',
 "\x95\xAC" => '&#48707;',
 "\x95\xAD" => '&#48710;',
 "\x95\xAE" => '&#48711;',
 "\x95\xAF" => '&#48713;',
 "\x95\xB0" => '&#48714;',
 "\x95\xB1" => '&#48715;',
 "\x95\xB2" => '&#48717;',
 "\x95\xB3" => '&#48719;',
 "\x95\xB4" => '&#48720;',
 "\x95\xB5" => '&#48721;',
 "\x95\xB6" => '&#48722;',
 "\x95\xB7" => '&#48723;',
 "\x95\xB8" => '&#48726;',
 "\x95\xB9" => '&#48728;',
 "\x95\xBA" => '&#48732;',
 "\x95\xBB" => '&#48733;',
 "\x95\xBC" => '&#48734;',
 "\x95\xBD" => '&#48735;',
 "\x95\xBE" => '&#48738;',
 "\x95\xBF" => '&#48739;',
 "\x95\xC0" => '&#48741;',
 "\x95\xC1" => '&#48742;',
 "\x95\xC2" => '&#48743;',
 "\x95\xC3" => '&#48745;',
 "\x95\xC4" => '&#48747;',
 "\x95\xC5" => '&#48748;',
 "\x95\xC6" => '&#48749;',
 "\x95\xC7" => '&#48750;',
 "\x95\xC8" => '&#48751;',
 "\x95\xC9" => '&#48754;',
 "\x95\xCA" => '&#48758;',
 "\x95\xCB" => '&#48759;',
 "\x95\xCC" => '&#48760;',
 "\x95\xCD" => '&#48761;',
 "\x95\xCE" => '&#48762;',
 "\x95\xCF" => '&#48766;',
 "\x95\xD0" => '&#48767;',
 "\x95\xD1" => '&#48769;',
 "\x95\xD2" => '&#48770;',
 "\x95\xD3" => '&#48771;',
 "\x95\xD4" => '&#48773;',
 "\x95\xD5" => '&#48774;',
 "\x95\xD6" => '&#48775;',
 "\x95\xD7" => '&#48776;',
 "\x95\xD8" => '&#48777;',
 "\x95\xD9" => '&#48778;',
 "\x95\xDA" => '&#48779;',
 "\x95\xDB" => '&#48782;',
 "\x95\xDC" => '&#48786;',
 "\x95\xDD" => '&#48787;',
 "\x95\xDE" => '&#48788;',
 "\x95\xDF" => '&#48789;',
 "\x95\xE0" => '&#48790;',
 "\x95\xE1" => '&#48791;',
 "\x95\xE2" => '&#48794;',
 "\x95\xE3" => '&#48795;',
 "\x95\xE4" => '&#48796;',
 "\x95\xE5" => '&#48797;',
 "\x95\xE6" => '&#48798;',
 "\x95\xE7" => '&#48799;',
 "\x95\xE8" => '&#48800;',
 "\x95\xE9" => '&#48801;',
 "\x95\xEA" => '&#48802;',
 "\x95\xEB" => '&#48803;',
 "\x95\xEC" => '&#48804;',
 "\x95\xED" => '&#48805;',
 "\x95\xEE" => '&#48806;',
 "\x95\xEF" => '&#48807;',
 "\x95\xF0" => '&#48809;',
 "\x95\xF1" => '&#48810;',
 "\x95\xF2" => '&#48811;',
 "\x95\xF3" => '&#48812;',
 "\x95\xF4" => '&#48813;',
 "\x95\xF5" => '&#48814;',
 "\x95\xF6" => '&#48815;',
 "\x95\xF7" => '&#48816;',
 "\x95\xF8" => '&#48817;',
 "\x95\xF9" => '&#48818;',
 "\x95\xFA" => '&#48819;',
 "\x95\xFB" => '&#48820;',
 "\x95\xFC" => '&#48821;',
 "\x95\xFD" => '&#48822;',
 "\x95\xFE" => '&#48823;',
 "\x96\x41" => '&#48824;',
 "\x96\x42" => '&#48825;',
 "\x96\x43" => '&#48826;',
 "\x96\x44" => '&#48827;',
 "\x96\x45" => '&#48828;',
 "\x96\x46" => '&#48829;',
 "\x96\x47" => '&#48830;',
 "\x96\x48" => '&#48831;',
 "\x96\x49" => '&#48832;',
 "\x96\x4A" => '&#48833;',
 "\x96\x4B" => '&#48834;',
 "\x96\x4C" => '&#48835;',
 "\x96\x4D" => '&#48836;',
 "\x96\x4E" => '&#48837;',
 "\x96\x4F" => '&#48838;',
 "\x96\x50" => '&#48839;',
 "\x96\x51" => '&#48840;',
 "\x96\x52" => '&#48841;',
 "\x96\x53" => '&#48842;',
 "\x96\x54" => '&#48843;',
 "\x96\x55" => '&#48844;',
 "\x96\x56" => '&#48845;',
 "\x96\x57" => '&#48846;',
 "\x96\x58" => '&#48847;',
 "\x96\x59" => '&#48850;',
 "\x96\x5A" => '&#48851;',
 "\x96\x61" => '&#48853;',
 "\x96\x62" => '&#48854;',
 "\x96\x63" => '&#48857;',
 "\x96\x64" => '&#48858;',
 "\x96\x65" => '&#48859;',
 "\x96\x66" => '&#48860;',
 "\x96\x67" => '&#48861;',
 "\x96\x68" => '&#48862;',
 "\x96\x69" => '&#48863;',
 "\x96\x6A" => '&#48865;',
 "\x96\x6B" => '&#48866;',
 "\x96\x6C" => '&#48870;',
 "\x96\x6D" => '&#48871;',
 "\x96\x6E" => '&#48872;',
 "\x96\x6F" => '&#48873;',
 "\x96\x70" => '&#48874;',
 "\x96\x71" => '&#48875;',
 "\x96\x72" => '&#48877;',
 "\x96\x73" => '&#48878;',
 "\x96\x74" => '&#48879;',
 "\x96\x75" => '&#48880;',
 "\x96\x76" => '&#48881;',
 "\x96\x77" => '&#48882;',
 "\x96\x78" => '&#48883;',
 "\x96\x79" => '&#48884;',
 "\x96\x7A" => '&#48885;',
 "\x96\x81" => '&#48886;',
 "\x96\x82" => '&#48887;',
 "\x96\x83" => '&#48888;',
 "\x96\x84" => '&#48889;',
 "\x96\x85" => '&#48890;',
 "\x96\x86" => '&#48891;',
 "\x96\x87" => '&#48892;',
 "\x96\x88" => '&#48893;',
 "\x96\x89" => '&#48894;',
 "\x96\x8A" => '&#48895;',
 "\x96\x8B" => '&#48896;',
 "\x96\x8C" => '&#48898;',
 "\x96\x8D" => '&#48899;',
 "\x96\x8E" => '&#48900;',
 "\x96\x8F" => '&#48901;',
 "\x96\x90" => '&#48902;',
 "\x96\x91" => '&#48903;',
 "\x96\x92" => '&#48906;',
 "\x96\x93" => '&#48907;',
 "\x96\x94" => '&#48908;',
 "\x96\x95" => '&#48909;',
 "\x96\x96" => '&#48910;',
 "\x96\x97" => '&#48911;',
 "\x96\x98" => '&#48912;',
 "\x96\x99" => '&#48913;',
 "\x96\x9A" => '&#48914;',
 "\x96\x9B" => '&#48915;',
 "\x96\x9C" => '&#48916;',
 "\x96\x9D" => '&#48917;',
 "\x96\x9E" => '&#48918;',
 "\x96\x9F" => '&#48919;',
 "\x96\xA0" => '&#48922;',
 "\x96\xA1" => '&#48926;',
 "\x96\xA2" => '&#48927;',
 "\x96\xA3" => '&#48928;',
 "\x96\xA4" => '&#48929;',
 "\x96\xA5" => '&#48930;',
 "\x96\xA6" => '&#48931;',
 "\x96\xA7" => '&#48932;',
 "\x96\xA8" => '&#48933;',
 "\x96\xA9" => '&#48934;',
 "\x96\xAA" => '&#48935;',
 "\x96\xAB" => '&#48936;',
 "\x96\xAC" => '&#48937;',
 "\x96\xAD" => '&#48938;',
 "\x96\xAE" => '&#48939;',
 "\x96\xAF" => '&#48940;',
 "\x96\xB0" => '&#48941;',
 "\x96\xB1" => '&#48942;',
 "\x96\xB2" => '&#48943;',
 "\x96\xB3" => '&#48944;',
 "\x96\xB4" => '&#48945;',
 "\x96\xB5" => '&#48946;',
 "\x96\xB6" => '&#48947;',
 "\x96\xB7" => '&#48948;',
 "\x96\xB8" => '&#48949;',
 "\x96\xB9" => '&#48950;',
 "\x96\xBA" => '&#48951;',
 "\x96\xBB" => '&#48952;',
 "\x96\xBC" => '&#48953;',
 "\x96\xBD" => '&#48954;',
 "\x96\xBE" => '&#48955;',
 "\x96\xBF" => '&#48956;',
 "\x96\xC0" => '&#48957;',
 "\x96\xC1" => '&#48958;',
 "\x96\xC2" => '&#48959;',
 "\x96\xC3" => '&#48962;',
 "\x96\xC4" => '&#48963;',
 "\x96\xC5" => '&#48965;',
 "\x96\xC6" => '&#48966;',
 "\x96\xC7" => '&#48967;',
 "\x96\xC8" => '&#48969;',
 "\x96\xC9" => '&#48970;',
 "\x96\xCA" => '&#48971;',
 "\x96\xCB" => '&#48972;',
 "\x96\xCC" => '&#48973;',
 "\x96\xCD" => '&#48974;',
 "\x96\xCE" => '&#48975;',
 "\x96\xCF" => '&#48978;',
 "\x96\xD0" => '&#48979;',
 "\x96\xD1" => '&#48980;',
 "\x96\xD2" => '&#48982;',
 "\x96\xD3" => '&#48983;',
 "\x96\xD4" => '&#48984;',
 "\x96\xD5" => '&#48985;',
 "\x96\xD6" => '&#48986;',
 "\x96\xD7" => '&#48987;',
 "\x96\xD8" => '&#48988;',
 "\x96\xD9" => '&#48989;',
 "\x96\xDA" => '&#48990;',
 "\x96\xDB" => '&#48991;',
 "\x96\xDC" => '&#48992;',
 "\x96\xDD" => '&#48993;',
 "\x96\xDE" => '&#48994;',
 "\x96\xDF" => '&#48995;',
 "\x96\xE0" => '&#48996;',
 "\x96\xE1" => '&#48997;',
 "\x96\xE2" => '&#48998;',
 "\x96\xE3" => '&#48999;',
 "\x96\xE4" => '&#49000;',
 "\x96\xE5" => '&#49001;',
 "\x96\xE6" => '&#49002;',
 "\x96\xE7" => '&#49003;',
 "\x96\xE8" => '&#49004;',
 "\x96\xE9" => '&#49005;',
 "\x96\xEA" => '&#49006;',
 "\x96\xEB" => '&#49007;',
 "\x96\xEC" => '&#49008;',
 "\x96\xED" => '&#49009;',
 "\x96\xEE" => '&#49010;',
 "\x96\xEF" => '&#49011;',
 "\x96\xF0" => '&#49012;',
 "\x96\xF1" => '&#49013;',
 "\x96\xF2" => '&#49014;',
 "\x96\xF3" => '&#49015;',
 "\x96\xF4" => '&#49016;',
 "\x96\xF5" => '&#49017;',
 "\x96\xF6" => '&#49018;',
 "\x96\xF7" => '&#49019;',
 "\x96\xF8" => '&#49020;',
 "\x96\xF9" => '&#49021;',
 "\x96\xFA" => '&#49022;',
 "\x96\xFB" => '&#49023;',
 "\x96\xFC" => '&#49024;',
 "\x96\xFD" => '&#49025;',
 "\x96\xFE" => '&#49026;',
 "\x97\x41" => '&#49027;',
 "\x97\x42" => '&#49028;',
 "\x97\x43" => '&#49029;',
 "\x97\x44" => '&#49030;',
 "\x97\x45" => '&#49031;',
 "\x97\x46" => '&#49032;',
 "\x97\x47" => '&#49033;',
 "\x97\x48" => '&#49034;',
 "\x97\x49" => '&#49035;',
 "\x97\x4A" => '&#49036;',
 "\x97\x4B" => '&#49037;',
 "\x97\x4C" => '&#49038;',
 "\x97\x4D" => '&#49039;',
 "\x97\x4E" => '&#49040;',
 "\x97\x4F" => '&#49041;',
 "\x97\x50" => '&#49042;',
 "\x97\x51" => '&#49043;',
 "\x97\x52" => '&#49045;',
 "\x97\x53" => '&#49046;',
 "\x97\x54" => '&#49047;',
 "\x97\x55" => '&#49048;',
 "\x97\x56" => '&#49049;',
 "\x97\x57" => '&#49050;',
 "\x97\x58" => '&#49051;',
 "\x97\x59" => '&#49052;',
 "\x97\x5A" => '&#49053;',
 "\x97\x61" => '&#49054;',
 "\x97\x62" => '&#49055;',
 "\x97\x63" => '&#49056;',
 "\x97\x64" => '&#49057;',
 "\x97\x65" => '&#49058;',
 "\x97\x66" => '&#49059;',
 "\x97\x67" => '&#49060;',
 "\x97\x68" => '&#49061;',
 "\x97\x69" => '&#49062;',
 "\x97\x6A" => '&#49063;',
 "\x97\x6B" => '&#49064;',
 "\x97\x6C" => '&#49065;',
 "\x97\x6D" => '&#49066;',
 "\x97\x6E" => '&#49067;',
 "\x97\x6F" => '&#49068;',
 "\x97\x70" => '&#49069;',
 "\x97\x71" => '&#49070;',
 "\x97\x72" => '&#49071;',
 "\x97\x73" => '&#49073;',
 "\x97\x74" => '&#49074;',
 "\x97\x75" => '&#49075;',
 "\x97\x76" => '&#49076;',
 "\x97\x77" => '&#49077;',
 "\x97\x78" => '&#49078;',
 "\x97\x79" => '&#49079;',
 "\x97\x7A" => '&#49080;',
 "\x97\x81" => '&#49081;',
 "\x97\x82" => '&#49082;',
 "\x97\x83" => '&#49083;',
 "\x97\x84" => '&#49084;',
 "\x97\x85" => '&#49085;',
 "\x97\x86" => '&#49086;',
 "\x97\x87" => '&#49087;',
 "\x97\x88" => '&#49088;',
 "\x97\x89" => '&#49089;',
 "\x97\x8A" => '&#49090;',
 "\x97\x8B" => '&#49091;',
 "\x97\x8C" => '&#49092;',
 "\x97\x8D" => '&#49094;',
 "\x97\x8E" => '&#49095;',
 "\x97\x8F" => '&#49096;',
 "\x97\x90" => '&#49097;',
 "\x97\x91" => '&#49098;',
 "\x97\x92" => '&#49099;',
 "\x97\x93" => '&#49102;',
 "\x97\x94" => '&#49103;',
 "\x97\x95" => '&#49105;',
 "\x97\x96" => '&#49106;',
 "\x97\x97" => '&#49107;',
 "\x97\x98" => '&#49109;',
 "\x97\x99" => '&#49110;',
 "\x97\x9A" => '&#49111;',
 "\x97\x9B" => '&#49112;',
 "\x97\x9C" => '&#49113;',
 "\x97\x9D" => '&#49114;',
 "\x97\x9E" => '&#49115;',
 "\x97\x9F" => '&#49117;',
 "\x97\xA0" => '&#49118;',
 "\x97\xA1" => '&#49120;',
 "\x97\xA2" => '&#49122;',
 "\x97\xA3" => '&#49123;',
 "\x97\xA4" => '&#49124;',
 "\x97\xA5" => '&#49125;',
 "\x97\xA6" => '&#49126;',
 "\x97\xA7" => '&#49127;',
 "\x97\xA8" => '&#49128;',
 "\x97\xA9" => '&#49129;',
 "\x97\xAA" => '&#49130;',
 "\x97\xAB" => '&#49131;',
 "\x97\xAC" => '&#49132;',
 "\x97\xAD" => '&#49133;',
 "\x97\xAE" => '&#49134;',
 "\x97\xAF" => '&#49135;',
 "\x97\xB0" => '&#49136;',
 "\x97\xB1" => '&#49137;',
 "\x97\xB2" => '&#49138;',
 "\x97\xB3" => '&#49139;',
 "\x97\xB4" => '&#49140;',
 "\x97\xB5" => '&#49141;',
 "\x97\xB6" => '&#49142;',
 "\x97\xB7" => '&#49143;',
 "\x97\xB8" => '&#49144;',
 "\x97\xB9" => '&#49145;',
 "\x97\xBA" => '&#49146;',
 "\x97\xBB" => '&#49147;',
 "\x97\xBC" => '&#49148;',
 "\x97\xBD" => '&#49149;',
 "\x97\xBE" => '&#49150;',
 "\x97\xBF" => '&#49151;',
 "\x97\xC0" => '&#49152;',
 "\x97\xC1" => '&#49153;',
 "\x97\xC2" => '&#49154;',
 "\x97\xC3" => '&#49155;',
 "\x97\xC4" => '&#49156;',
 "\x97\xC5" => '&#49157;',
 "\x97\xC6" => '&#49158;',
 "\x97\xC7" => '&#49159;',
 "\x97\xC8" => '&#49160;',
 "\x97\xC9" => '&#49161;',
 "\x97\xCA" => '&#49162;',
 "\x97\xCB" => '&#49163;',
 "\x97\xCC" => '&#49164;',
 "\x97\xCD" => '&#49165;',
 "\x97\xCE" => '&#49166;',
 "\x97\xCF" => '&#49167;',
 "\x97\xD0" => '&#49168;',
 "\x97\xD1" => '&#49169;',
 "\x97\xD2" => '&#49170;',
 "\x97\xD3" => '&#49171;',
 "\x97\xD4" => '&#49172;',
 "\x97\xD5" => '&#49173;',
 "\x97\xD6" => '&#49174;',
 "\x97\xD7" => '&#49175;',
 "\x97\xD8" => '&#49176;',
 "\x97\xD9" => '&#49177;',
 "\x97\xDA" => '&#49178;',
 "\x97\xDB" => '&#49179;',
 "\x97\xDC" => '&#49180;',
 "\x97\xDD" => '&#49181;',
 "\x97\xDE" => '&#49182;',
 "\x97\xDF" => '&#49183;',
 "\x97\xE0" => '&#49184;',
 "\x97\xE1" => '&#49185;',
 "\x97\xE2" => '&#49186;',
 "\x97\xE3" => '&#49187;',
 "\x97\xE4" => '&#49188;',
 "\x97\xE5" => '&#49189;',
 "\x97\xE6" => '&#49190;',
 "\x97\xE7" => '&#49191;',
 "\x97\xE8" => '&#49192;',
 "\x97\xE9" => '&#49193;',
 "\x97\xEA" => '&#49194;',
 "\x97\xEB" => '&#49195;',
 "\x97\xEC" => '&#49196;',
 "\x97\xED" => '&#49197;',
 "\x97\xEE" => '&#49198;',
 "\x97\xEF" => '&#49199;',
 "\x97\xF0" => '&#49200;',
 "\x97\xF1" => '&#49201;',
 "\x97\xF2" => '&#49202;',
 "\x97\xF3" => '&#49203;',
 "\x97\xF4" => '&#49204;',
 "\x97\xF5" => '&#49205;',
 "\x97\xF6" => '&#49206;',
 "\x97\xF7" => '&#49207;',
 "\x97\xF8" => '&#49208;',
 "\x97\xF9" => '&#49209;',
 "\x97\xFA" => '&#49210;',
 "\x97\xFB" => '&#49211;',
 "\x97\xFC" => '&#49213;',
 "\x97\xFD" => '&#49214;',
 "\x97\xFE" => '&#49215;',
 "\x98\x41" => '&#49216;',
 "\x98\x42" => '&#49217;',
 "\x98\x43" => '&#49218;',
 "\x98\x44" => '&#49219;',
 "\x98\x45" => '&#49220;',
 "\x98\x46" => '&#49221;',
 "\x98\x47" => '&#49222;',
 "\x98\x48" => '&#49223;',
 "\x98\x49" => '&#49224;',
 "\x98\x4A" => '&#49225;',
 "\x98\x4B" => '&#49226;',
 "\x98\x4C" => '&#49227;',
 "\x98\x4D" => '&#49228;',
 "\x98\x4E" => '&#49229;',
 "\x98\x4F" => '&#49230;',
 "\x98\x50" => '&#49231;',
 "\x98\x51" => '&#49232;',
 "\x98\x52" => '&#49234;',
 "\x98\x53" => '&#49235;',
 "\x98\x54" => '&#49236;',
 "\x98\x55" => '&#49237;',
 "\x98\x56" => '&#49238;',
 "\x98\x57" => '&#49239;',
 "\x98\x58" => '&#49241;',
 "\x98\x59" => '&#49242;',
 "\x98\x5A" => '&#49243;',
 "\x98\x61" => '&#49245;',
 "\x98\x62" => '&#49246;',
 "\x98\x63" => '&#49247;',
 "\x98\x64" => '&#49249;',
 "\x98\x65" => '&#49250;',
 "\x98\x66" => '&#49251;',
 "\x98\x67" => '&#49252;',
 "\x98\x68" => '&#49253;',
 "\x98\x69" => '&#49254;',
 "\x98\x6A" => '&#49255;',
 "\x98\x6B" => '&#49258;',
 "\x98\x6C" => '&#49259;',
 "\x98\x6D" => '&#49260;',
 "\x98\x6E" => '&#49261;',
 "\x98\x6F" => '&#49262;',
 "\x98\x70" => '&#49263;',
 "\x98\x71" => '&#49264;',
 "\x98\x72" => '&#49265;',
 "\x98\x73" => '&#49266;',
 "\x98\x74" => '&#49267;',
 "\x98\x75" => '&#49268;',
 "\x98\x76" => '&#49269;',
 "\x98\x77" => '&#49270;',
 "\x98\x78" => '&#49271;',
 "\x98\x79" => '&#49272;',
 "\x98\x7A" => '&#49273;',
 "\x98\x81" => '&#49274;',
 "\x98\x82" => '&#49275;',
 "\x98\x83" => '&#49276;',
 "\x98\x84" => '&#49277;',
 "\x98\x85" => '&#49278;',
 "\x98\x86" => '&#49279;',
 "\x98\x87" => '&#49280;',
 "\x98\x88" => '&#49281;',
 "\x98\x89" => '&#49282;',
 "\x98\x8A" => '&#49283;',
 "\x98\x8B" => '&#49284;',
 "\x98\x8C" => '&#49285;',
 "\x98\x8D" => '&#49286;',
 "\x98\x8E" => '&#49287;',
 "\x98\x8F" => '&#49288;',
 "\x98\x90" => '&#49289;',
 "\x98\x91" => '&#49290;',
 "\x98\x92" => '&#49291;',
 "\x98\x93" => '&#49292;',
 "\x98\x94" => '&#49293;',
 "\x98\x95" => '&#49294;',
 "\x98\x96" => '&#49295;',
 "\x98\x97" => '&#49298;',
 "\x98\x98" => '&#49299;',
 "\x98\x99" => '&#49301;',
 "\x98\x9A" => '&#49302;',
 "\x98\x9B" => '&#49303;',
 "\x98\x9C" => '&#49305;',
 "\x98\x9D" => '&#49306;',
 "\x98\x9E" => '&#49307;',
 "\x98\x9F" => '&#49308;',
 "\x98\xA0" => '&#49309;',
 "\x98\xA1" => '&#49310;',
 "\x98\xA2" => '&#49311;',
 "\x98\xA3" => '&#49314;',
 "\x98\xA4" => '&#49316;',
 "\x98\xA5" => '&#49318;',
 "\x98\xA6" => '&#49319;',
 "\x98\xA7" => '&#49320;',
 "\x98\xA8" => '&#49321;',
 "\x98\xA9" => '&#49322;',
 "\x98\xAA" => '&#49323;',
 "\x98\xAB" => '&#49326;',
 "\x98\xAC" => '&#49329;',
 "\x98\xAD" => '&#49330;',
 "\x98\xAE" => '&#49335;',
 "\x98\xAF" => '&#49336;',
 "\x98\xB0" => '&#49337;',
 "\x98\xB1" => '&#49338;',
 "\x98\xB2" => '&#49339;',
 "\x98\xB3" => '&#49342;',
 "\x98\xB4" => '&#49346;',
 "\x98\xB5" => '&#49347;',
 "\x98\xB6" => '&#49348;',
 "\x98\xB7" => '&#49350;',
 "\x98\xB8" => '&#49351;',
 "\x98\xB9" => '&#49354;',
 "\x98\xBA" => '&#49355;',
 "\x98\xBB" => '&#49357;',
 "\x98\xBC" => '&#49358;',
 "\x98\xBD" => '&#49359;',
 "\x98\xBE" => '&#49361;',
 "\x98\xBF" => '&#49362;',
 "\x98\xC0" => '&#49363;',
 "\x98\xC1" => '&#49364;',
 "\x98\xC2" => '&#49365;',
 "\x98\xC3" => '&#49366;',
 "\x98\xC4" => '&#49367;',
 "\x98\xC5" => '&#49370;',
 "\x98\xC6" => '&#49374;',
 "\x98\xC7" => '&#49375;',
 "\x98\xC8" => '&#49376;',
 "\x98\xC9" => '&#49377;',
 "\x98\xCA" => '&#49378;',
 "\x98\xCB" => '&#49379;',
 "\x98\xCC" => '&#49382;',
 "\x98\xCD" => '&#49383;',
 "\x98\xCE" => '&#49385;',
 "\x98\xCF" => '&#49386;',
 "\x98\xD0" => '&#49387;',
 "\x98\xD1" => '&#49389;',
 "\x98\xD2" => '&#49390;',
 "\x98\xD3" => '&#49391;',
 "\x98\xD4" => '&#49392;',
 "\x98\xD5" => '&#49393;',
 "\x98\xD6" => '&#49394;',
 "\x98\xD7" => '&#49395;',
 "\x98\xD8" => '&#49398;',
 "\x98\xD9" => '&#49400;',
 "\x98\xDA" => '&#49402;',
 "\x98\xDB" => '&#49403;',
 "\x98\xDC" => '&#49404;',
 "\x98\xDD" => '&#49405;',
 "\x98\xDE" => '&#49406;',
 "\x98\xDF" => '&#49407;',
 "\x98\xE0" => '&#49409;',
 "\x98\xE1" => '&#49410;',
 "\x98\xE2" => '&#49411;',
 "\x98\xE3" => '&#49413;',
 "\x98\xE4" => '&#49414;',
 "\x98\xE5" => '&#49415;',
 "\x98\xE6" => '&#49417;',
 "\x98\xE7" => '&#49418;',
 "\x98\xE8" => '&#49419;',
 "\x98\xE9" => '&#49420;',
 "\x98\xEA" => '&#49421;',
 "\x98\xEB" => '&#49422;',
 "\x98\xEC" => '&#49423;',
 "\x98\xED" => '&#49425;',
 "\x98\xEE" => '&#49426;',
 "\x98\xEF" => '&#49427;',
 "\x98\xF0" => '&#49428;',
 "\x98\xF1" => '&#49430;',
 "\x98\xF2" => '&#49431;',
 "\x98\xF3" => '&#49432;',
 "\x98\xF4" => '&#49433;',
 "\x98\xF5" => '&#49434;',
 "\x98\xF6" => '&#49435;',
 "\x98\xF7" => '&#49441;',
 "\x98\xF8" => '&#49442;',
 "\x98\xF9" => '&#49445;',
 "\x98\xFA" => '&#49448;',
 "\x98\xFB" => '&#49449;',
 "\x98\xFC" => '&#49450;',
 "\x98\xFD" => '&#49451;',
 "\x98\xFE" => '&#49454;',
 "\x99\x41" => '&#49458;',
 "\x99\x42" => '&#49459;',
 "\x99\x43" => '&#49460;',
 "\x99\x44" => '&#49461;',
 "\x99\x45" => '&#49463;',
 "\x99\x46" => '&#49466;',
 "\x99\x47" => '&#49467;',
 "\x99\x48" => '&#49469;',
 "\x99\x49" => '&#49470;',
 "\x99\x4A" => '&#49471;',
 "\x99\x4B" => '&#49473;',
 "\x99\x4C" => '&#49474;',
 "\x99\x4D" => '&#49475;',
 "\x99\x4E" => '&#49476;',
 "\x99\x4F" => '&#49477;',
 "\x99\x50" => '&#49478;',
 "\x99\x51" => '&#49479;',
 "\x99\x52" => '&#49482;',
 "\x99\x53" => '&#49486;',
 "\x99\x54" => '&#49487;',
 "\x99\x55" => '&#49488;',
 "\x99\x56" => '&#49489;',
 "\x99\x57" => '&#49490;',
 "\x99\x58" => '&#49491;',
 "\x99\x59" => '&#49494;',
 "\x99\x5A" => '&#49495;',
 "\x99\x61" => '&#49497;',
 "\x99\x62" => '&#49498;',
 "\x99\x63" => '&#49499;',
 "\x99\x64" => '&#49501;',
 "\x99\x65" => '&#49502;',
 "\x99\x66" => '&#49503;',
 "\x99\x67" => '&#49504;',
 "\x99\x68" => '&#49505;',
 "\x99\x69" => '&#49506;',
 "\x99\x6A" => '&#49507;',
 "\x99\x6B" => '&#49510;',
 "\x99\x6C" => '&#49514;',
 "\x99\x6D" => '&#49515;',
 "\x99\x6E" => '&#49516;',
 "\x99\x6F" => '&#49517;',
 "\x99\x70" => '&#49518;',
 "\x99\x71" => '&#49519;',
 "\x99\x72" => '&#49521;',
 "\x99\x73" => '&#49522;',
 "\x99\x74" => '&#49523;',
 "\x99\x75" => '&#49525;',
 "\x99\x76" => '&#49526;',
 "\x99\x77" => '&#49527;',
 "\x99\x78" => '&#49529;',
 "\x99\x79" => '&#49530;',
 "\x99\x7A" => '&#49531;',
 "\x99\x81" => '&#49532;',
 "\x99\x82" => '&#49533;',
 "\x99\x83" => '&#49534;',
 "\x99\x84" => '&#49535;',
 "\x99\x85" => '&#49536;',
 "\x99\x86" => '&#49537;',
 "\x99\x87" => '&#49538;',
 "\x99\x88" => '&#49539;',
 "\x99\x89" => '&#49540;',
 "\x99\x8A" => '&#49542;',
 "\x99\x8B" => '&#49543;',
 "\x99\x8C" => '&#49544;',
 "\x99\x8D" => '&#49545;',
 "\x99\x8E" => '&#49546;',
 "\x99\x8F" => '&#49547;',
 "\x99\x90" => '&#49551;',
 "\x99\x91" => '&#49553;',
 "\x99\x92" => '&#49554;',
 "\x99\x93" => '&#49555;',
 "\x99\x94" => '&#49557;',
 "\x99\x95" => '&#49559;',
 "\x99\x96" => '&#49560;',
 "\x99\x97" => '&#49561;',
 "\x99\x98" => '&#49562;',
 "\x99\x99" => '&#49563;',
 "\x99\x9A" => '&#49566;',
 "\x99\x9B" => '&#49568;',
 "\x99\x9C" => '&#49570;',
 "\x99\x9D" => '&#49571;',
 "\x99\x9E" => '&#49572;',
 "\x99\x9F" => '&#49574;',
 "\x99\xA0" => '&#49575;',
 "\x99\xA1" => '&#49578;',
 "\x99\xA2" => '&#49579;',
 "\x99\xA3" => '&#49581;',
 "\x99\xA4" => '&#49582;',
 "\x99\xA5" => '&#49583;',
 "\x99\xA6" => '&#49585;',
 "\x99\xA7" => '&#49586;',
 "\x99\xA8" => '&#49587;',
 "\x99\xA9" => '&#49588;',
 "\x99\xAA" => '&#49589;',
 "\x99\xAB" => '&#49590;',
 "\x99\xAC" => '&#49591;',
 "\x99\xAD" => '&#49592;',
 "\x99\xAE" => '&#49593;',
 "\x99\xAF" => '&#49594;',
 "\x99\xB0" => '&#49595;',
 "\x99\xB1" => '&#49596;',
 "\x99\xB2" => '&#49598;',
 "\x99\xB3" => '&#49599;',
 "\x99\xB4" => '&#49600;',
 "\x99\xB5" => '&#49601;',
 "\x99\xB6" => '&#49602;',
 "\x99\xB7" => '&#49603;',
 "\x99\xB8" => '&#49605;',
 "\x99\xB9" => '&#49606;',
 "\x99\xBA" => '&#49607;',
 "\x99\xBB" => '&#49609;',
 "\x99\xBC" => '&#49610;',
 "\x99\xBD" => '&#49611;',
 "\x99\xBE" => '&#49613;',
 "\x99\xBF" => '&#49614;',
 "\x99\xC0" => '&#49615;',
 "\x99\xC1" => '&#49616;',
 "\x99\xC2" => '&#49617;',
 "\x99\xC3" => '&#49618;',
 "\x99\xC4" => '&#49619;',
 "\x99\xC5" => '&#49621;',
 "\x99\xC6" => '&#49622;',
 "\x99\xC7" => '&#49625;',
 "\x99\xC8" => '&#49626;',
 "\x99\xC9" => '&#49627;',
 "\x99\xCA" => '&#49628;',
 "\x99\xCB" => '&#49629;',
 "\x99\xCC" => '&#49630;',
 "\x99\xCD" => '&#49631;',
 "\x99\xCE" => '&#49633;',
 "\x99\xCF" => '&#49634;',
 "\x99\xD0" => '&#49635;',
 "\x99\xD1" => '&#49637;',
 "\x99\xD2" => '&#49638;',
 "\x99\xD3" => '&#49639;',
 "\x99\xD4" => '&#49641;',
 "\x99\xD5" => '&#49642;',
 "\x99\xD6" => '&#49643;',
 "\x99\xD7" => '&#49644;',
 "\x99\xD8" => '&#49645;',
 "\x99\xD9" => '&#49646;',
 "\x99\xDA" => '&#49647;',
 "\x99\xDB" => '&#49650;',
 "\x99\xDC" => '&#49652;',
 "\x99\xDD" => '&#49653;',
 "\x99\xDE" => '&#49654;',
 "\x99\xDF" => '&#49655;',
 "\x99\xE0" => '&#49656;',
 "\x99\xE1" => '&#49657;',
 "\x99\xE2" => '&#49658;',
 "\x99\xE3" => '&#49659;',
 "\x99\xE4" => '&#49662;',
 "\x99\xE5" => '&#49663;',
 "\x99\xE6" => '&#49665;',
 "\x99\xE7" => '&#49666;',
 "\x99\xE8" => '&#49667;',
 "\x99\xE9" => '&#49669;',
 "\x99\xEA" => '&#49670;',
 "\x99\xEB" => '&#49671;',
 "\x99\xEC" => '&#49672;',
 "\x99\xED" => '&#49673;',
 "\x99\xEE" => '&#49674;',
 "\x99\xEF" => '&#49675;',
 "\x99\xF0" => '&#49678;',
 "\x99\xF1" => '&#49680;',
 "\x99\xF2" => '&#49682;',
 "\x99\xF3" => '&#49683;',
 "\x99\xF4" => '&#49684;',
 "\x99\xF5" => '&#49685;',
 "\x99\xF6" => '&#49686;',
 "\x99\xF7" => '&#49687;',
 "\x99\xF8" => '&#49690;',
 "\x99\xF9" => '&#49691;',
 "\x99\xFA" => '&#49693;',
 "\x99\xFB" => '&#49694;',
 "\x99\xFC" => '&#49697;',
 "\x99\xFD" => '&#49698;',
 "\x99\xFE" => '&#49699;',
 "\x9A\x41" => '&#49700;',
 "\x9A\x42" => '&#49701;',
 "\x9A\x43" => '&#49702;',
 "\x9A\x44" => '&#49703;',
 "\x9A\x45" => '&#49706;',
 "\x9A\x46" => '&#49708;',
 "\x9A\x47" => '&#49710;',
 "\x9A\x48" => '&#49712;',
 "\x9A\x49" => '&#49715;',
 "\x9A\x4A" => '&#49717;',
 "\x9A\x4B" => '&#49718;',
 "\x9A\x4C" => '&#49719;',
 "\x9A\x4D" => '&#49720;',
 "\x9A\x4E" => '&#49721;',
 "\x9A\x4F" => '&#49722;',
 "\x9A\x50" => '&#49723;',
 "\x9A\x51" => '&#49724;',
 "\x9A\x52" => '&#49725;',
 "\x9A\x53" => '&#49726;',
 "\x9A\x54" => '&#49727;',
 "\x9A\x55" => '&#49728;',
 "\x9A\x56" => '&#49729;',
 "\x9A\x57" => '&#49730;',
 "\x9A\x58" => '&#49731;',
 "\x9A\x59" => '&#49732;',
 "\x9A\x5A" => '&#49733;',
 "\x9A\x61" => '&#49734;',
 "\x9A\x62" => '&#49735;',
 "\x9A\x63" => '&#49737;',
 "\x9A\x64" => '&#49738;',
 "\x9A\x65" => '&#49739;',
 "\x9A\x66" => '&#49740;',
 "\x9A\x67" => '&#49741;',
 "\x9A\x68" => '&#49742;',
 "\x9A\x69" => '&#49743;',
 "\x9A\x6A" => '&#49746;',
 "\x9A\x6B" => '&#49747;',
 "\x9A\x6C" => '&#49749;',
 "\x9A\x6D" => '&#49750;',
 "\x9A\x6E" => '&#49751;',
 "\x9A\x6F" => '&#49753;',
 "\x9A\x70" => '&#49754;',
 "\x9A\x71" => '&#49755;',
 "\x9A\x72" => '&#49756;',
 "\x9A\x73" => '&#49757;',
 "\x9A\x74" => '&#49758;',
 "\x9A\x75" => '&#49759;',
 "\x9A\x76" => '&#49761;',
 "\x9A\x77" => '&#49762;',
 "\x9A\x78" => '&#49763;',
 "\x9A\x79" => '&#49764;',
 "\x9A\x7A" => '&#49766;',
 "\x9A\x81" => '&#49767;',
 "\x9A\x82" => '&#49768;',
 "\x9A\x83" => '&#49769;',
 "\x9A\x84" => '&#49770;',
 "\x9A\x85" => '&#49771;',
 "\x9A\x86" => '&#49774;',
 "\x9A\x87" => '&#49775;',
 "\x9A\x88" => '&#49777;',
 "\x9A\x89" => '&#49778;',
 "\x9A\x8A" => '&#49779;',
 "\x9A\x8B" => '&#49781;',
 "\x9A\x8C" => '&#49782;',
 "\x9A\x8D" => '&#49783;',
 "\x9A\x8E" => '&#49784;',
 "\x9A\x8F" => '&#49785;',
 "\x9A\x90" => '&#49786;',
 "\x9A\x91" => '&#49787;',
 "\x9A\x92" => '&#49790;',
 "\x9A\x93" => '&#49792;',
 "\x9A\x94" => '&#49794;',
 "\x9A\x95" => '&#49795;',
 "\x9A\x96" => '&#49796;',
 "\x9A\x97" => '&#49797;',
 "\x9A\x98" => '&#49798;',
 "\x9A\x99" => '&#49799;',
 "\x9A\x9A" => '&#49802;',
 "\x9A\x9B" => '&#49803;',
 "\x9A\x9C" => '&#49804;',
 "\x9A\x9D" => '&#49805;',
 "\x9A\x9E" => '&#49806;',
 "\x9A\x9F" => '&#49807;',
 "\x9A\xA0" => '&#49809;',
 "\x9A\xA1" => '&#49810;',
 "\x9A\xA2" => '&#49811;',
 "\x9A\xA3" => '&#49812;',
 "\x9A\xA4" => '&#49813;',
 "\x9A\xA5" => '&#49814;',
 "\x9A\xA6" => '&#49815;',
 "\x9A\xA7" => '&#49817;',
 "\x9A\xA8" => '&#49818;',
 "\x9A\xA9" => '&#49820;',
 "\x9A\xAA" => '&#49822;',
 "\x9A\xAB" => '&#49823;',
 "\x9A\xAC" => '&#49824;',
 "\x9A\xAD" => '&#49825;',
 "\x9A\xAE" => '&#49826;',
 "\x9A\xAF" => '&#49827;',
 "\x9A\xB0" => '&#49830;',
 "\x9A\xB1" => '&#49831;',
 "\x9A\xB2" => '&#49833;',
 "\x9A\xB3" => '&#49834;',
 "\x9A\xB4" => '&#49835;',
 "\x9A\xB5" => '&#49838;',
 "\x9A\xB6" => '&#49839;',
 "\x9A\xB7" => '&#49840;',
 "\x9A\xB8" => '&#49841;',
 "\x9A\xB9" => '&#49842;',
 "\x9A\xBA" => '&#49843;',
 "\x9A\xBB" => '&#49846;',
 "\x9A\xBC" => '&#49848;',
 "\x9A\xBD" => '&#49850;',
 "\x9A\xBE" => '&#49851;',
 "\x9A\xBF" => '&#49852;',
 "\x9A\xC0" => '&#49853;',
 "\x9A\xC1" => '&#49854;',
 "\x9A\xC2" => '&#49855;',
 "\x9A\xC3" => '&#49856;',
 "\x9A\xC4" => '&#49857;',
 "\x9A\xC5" => '&#49858;',
 "\x9A\xC6" => '&#49859;',
 "\x9A\xC7" => '&#49860;',
 "\x9A\xC8" => '&#49861;',
 "\x9A\xC9" => '&#49862;',
 "\x9A\xCA" => '&#49863;',
 "\x9A\xCB" => '&#49864;',
 "\x9A\xCC" => '&#49865;',
 "\x9A\xCD" => '&#49866;',
 "\x9A\xCE" => '&#49867;',
 "\x9A\xCF" => '&#49868;',
 "\x9A\xD0" => '&#49869;',
 "\x9A\xD1" => '&#49870;',
 "\x9A\xD2" => '&#49871;',
 "\x9A\xD3" => '&#49872;',
 "\x9A\xD4" => '&#49873;',
 "\x9A\xD5" => '&#49874;',
 "\x9A\xD6" => '&#49875;',
 "\x9A\xD7" => '&#49876;',
 "\x9A\xD8" => '&#49877;',
 "\x9A\xD9" => '&#49878;',
 "\x9A\xDA" => '&#49879;',
 "\x9A\xDB" => '&#49880;',
 "\x9A\xDC" => '&#49881;',
 "\x9A\xDD" => '&#49882;',
 "\x9A\xDE" => '&#49883;',
 "\x9A\xDF" => '&#49886;',
 "\x9A\xE0" => '&#49887;',
 "\x9A\xE1" => '&#49889;',
 "\x9A\xE2" => '&#49890;',
 "\x9A\xE3" => '&#49893;',
 "\x9A\xE4" => '&#49894;',
 "\x9A\xE5" => '&#49895;',
 "\x9A\xE6" => '&#49896;',
 "\x9A\xE7" => '&#49897;',
 "\x9A\xE8" => '&#49898;',
 "\x9A\xE9" => '&#49902;',
 "\x9A\xEA" => '&#49904;',
 "\x9A\xEB" => '&#49906;',
 "\x9A\xEC" => '&#49907;',
 "\x9A\xED" => '&#49908;',
 "\x9A\xEE" => '&#49909;',
 "\x9A\xEF" => '&#49911;',
 "\x9A\xF0" => '&#49914;',
 "\x9A\xF1" => '&#49917;',
 "\x9A\xF2" => '&#49918;',
 "\x9A\xF3" => '&#49919;',
 "\x9A\xF4" => '&#49921;',
 "\x9A\xF5" => '&#49922;',
 "\x9A\xF6" => '&#49923;',
 "\x9A\xF7" => '&#49924;',
 "\x9A\xF8" => '&#49925;',
 "\x9A\xF9" => '&#49926;',
 "\x9A\xFA" => '&#49927;',
 "\x9A\xFB" => '&#49930;',
 "\x9A\xFC" => '&#49931;',
 "\x9A\xFD" => '&#49934;',
 "\x9A\xFE" => '&#49935;',
 "\x9B\x41" => '&#49936;',
 "\x9B\x42" => '&#49937;',
 "\x9B\x43" => '&#49938;',
 "\x9B\x44" => '&#49942;',
 "\x9B\x45" => '&#49943;',
 "\x9B\x46" => '&#49945;',
 "\x9B\x47" => '&#49946;',
 "\x9B\x48" => '&#49947;',
 "\x9B\x49" => '&#49949;',
 "\x9B\x4A" => '&#49950;',
 "\x9B\x4B" => '&#49951;',
 "\x9B\x4C" => '&#49952;',
 "\x9B\x4D" => '&#49953;',
 "\x9B\x4E" => '&#49954;',
 "\x9B\x4F" => '&#49955;',
 "\x9B\x50" => '&#49958;',
 "\x9B\x51" => '&#49959;',
 "\x9B\x52" => '&#49962;',
 "\x9B\x53" => '&#49963;',
 "\x9B\x54" => '&#49964;',
 "\x9B\x55" => '&#49965;',
 "\x9B\x56" => '&#49966;',
 "\x9B\x57" => '&#49967;',
 "\x9B\x58" => '&#49968;',
 "\x9B\x59" => '&#49969;',
 "\x9B\x5A" => '&#49970;',
 "\x9B\x61" => '&#49971;',
 "\x9B\x62" => '&#49972;',
 "\x9B\x63" => '&#49973;',
 "\x9B\x64" => '&#49974;',
 "\x9B\x65" => '&#49975;',
 "\x9B\x66" => '&#49976;',
 "\x9B\x67" => '&#49977;',
 "\x9B\x68" => '&#49978;',
 "\x9B\x69" => '&#49979;',
 "\x9B\x6A" => '&#49980;',
 "\x9B\x6B" => '&#49981;',
 "\x9B\x6C" => '&#49982;',
 "\x9B\x6D" => '&#49983;',
 "\x9B\x6E" => '&#49984;',
 "\x9B\x6F" => '&#49985;',
 "\x9B\x70" => '&#49986;',
 "\x9B\x71" => '&#49987;',
 "\x9B\x72" => '&#49988;',
 "\x9B\x73" => '&#49990;',
 "\x9B\x74" => '&#49991;',
 "\x9B\x75" => '&#49992;',
 "\x9B\x76" => '&#49993;',
 "\x9B\x77" => '&#49994;',
 "\x9B\x78" => '&#49995;',
 "\x9B\x79" => '&#49996;',
 "\x9B\x7A" => '&#49997;',
 "\x9B\x81" => '&#49998;',
 "\x9B\x82" => '&#49999;',
 "\x9B\x83" => '&#50000;',
 "\x9B\x84" => '&#50001;',
 "\x9B\x85" => '&#50002;',
 "\x9B\x86" => '&#50003;',
 "\x9B\x87" => '&#50004;',
 "\x9B\x88" => '&#50005;',
 "\x9B\x89" => '&#50006;',
 "\x9B\x8A" => '&#50007;',
 "\x9B\x8B" => '&#50008;',
 "\x9B\x8C" => '&#50009;',
 "\x9B\x8D" => '&#50010;',
 "\x9B\x8E" => '&#50011;',
 "\x9B\x8F" => '&#50012;',
 "\x9B\x90" => '&#50013;',
 "\x9B\x91" => '&#50014;',
 "\x9B\x92" => '&#50015;',
 "\x9B\x93" => '&#50016;',
 "\x9B\x94" => '&#50017;',
 "\x9B\x95" => '&#50018;',
 "\x9B\x96" => '&#50019;',
 "\x9B\x97" => '&#50020;',
 "\x9B\x98" => '&#50021;',
 "\x9B\x99" => '&#50022;',
 "\x9B\x9A" => '&#50023;',
 "\x9B\x9B" => '&#50026;',
 "\x9B\x9C" => '&#50027;',
 "\x9B\x9D" => '&#50029;',
 "\x9B\x9E" => '&#50030;',
 "\x9B\x9F" => '&#50031;',
 "\x9B\xA0" => '&#50033;',
 "\x9B\xA1" => '&#50035;',
 "\x9B\xA2" => '&#50036;',
 "\x9B\xA3" => '&#50037;',
 "\x9B\xA4" => '&#50038;',
 "\x9B\xA5" => '&#50039;',
 "\x9B\xA6" => '&#50042;',
 "\x9B\xA7" => '&#50043;',
 "\x9B\xA8" => '&#50046;',
 "\x9B\xA9" => '&#50047;',
 "\x9B\xAA" => '&#50048;',
 "\x9B\xAB" => '&#50049;',
 "\x9B\xAC" => '&#50050;',
 "\x9B\xAD" => '&#50051;',
 "\x9B\xAE" => '&#50053;',
 "\x9B\xAF" => '&#50054;',
 "\x9B\xB0" => '&#50055;',
 "\x9B\xB1" => '&#50057;',
 "\x9B\xB2" => '&#50058;',
 "\x9B\xB3" => '&#50059;',
 "\x9B\xB4" => '&#50061;',
 "\x9B\xB5" => '&#50062;',
 "\x9B\xB6" => '&#50063;',
 "\x9B\xB7" => '&#50064;',
 "\x9B\xB8" => '&#50065;',
 "\x9B\xB9" => '&#50066;',
 "\x9B\xBA" => '&#50067;',
 "\x9B\xBB" => '&#50068;',
 "\x9B\xBC" => '&#50069;',
 "\x9B\xBD" => '&#50070;',
 "\x9B\xBE" => '&#50071;',
 "\x9B\xBF" => '&#50072;',
 "\x9B\xC0" => '&#50073;',
 "\x9B\xC1" => '&#50074;',
 "\x9B\xC2" => '&#50075;',
 "\x9B\xC3" => '&#50076;',
 "\x9B\xC4" => '&#50077;',
 "\x9B\xC5" => '&#50078;',
 "\x9B\xC6" => '&#50079;',
 "\x9B\xC7" => '&#50080;',
 "\x9B\xC8" => '&#50081;',
 "\x9B\xC9" => '&#50082;',
 "\x9B\xCA" => '&#50083;',
 "\x9B\xCB" => '&#50084;',
 "\x9B\xCC" => '&#50085;',
 "\x9B\xCD" => '&#50086;',
 "\x9B\xCE" => '&#50087;',
 "\x9B\xCF" => '&#50088;',
 "\x9B\xD0" => '&#50089;',
 "\x9B\xD1" => '&#50090;',
 "\x9B\xD2" => '&#50091;',
 "\x9B\xD3" => '&#50092;',
 "\x9B\xD4" => '&#50093;',
 "\x9B\xD5" => '&#50094;',
 "\x9B\xD6" => '&#50095;',
 "\x9B\xD7" => '&#50096;',
 "\x9B\xD8" => '&#50097;',
 "\x9B\xD9" => '&#50098;',
 "\x9B\xDA" => '&#50099;',
 "\x9B\xDB" => '&#50100;',
 "\x9B\xDC" => '&#50101;',
 "\x9B\xDD" => '&#50102;',
 "\x9B\xDE" => '&#50103;',
 "\x9B\xDF" => '&#50104;',
 "\x9B\xE0" => '&#50105;',
 "\x9B\xE1" => '&#50106;',
 "\x9B\xE2" => '&#50107;',
 "\x9B\xE3" => '&#50108;',
 "\x9B\xE4" => '&#50109;',
 "\x9B\xE5" => '&#50110;',
 "\x9B\xE6" => '&#50111;',
 "\x9B\xE7" => '&#50113;',
 "\x9B\xE8" => '&#50114;',
 "\x9B\xE9" => '&#50115;',
 "\x9B\xEA" => '&#50116;',
 "\x9B\xEB" => '&#50117;',
 "\x9B\xEC" => '&#50118;',
 "\x9B\xED" => '&#50119;',
 "\x9B\xEE" => '&#50120;',
 "\x9B\xEF" => '&#50121;',
 "\x9B\xF0" => '&#50122;',
 "\x9B\xF1" => '&#50123;',
 "\x9B\xF2" => '&#50124;',
 "\x9B\xF3" => '&#50125;',
 "\x9B\xF4" => '&#50126;',
 "\x9B\xF5" => '&#50127;',
 "\x9B\xF6" => '&#50128;',
 "\x9B\xF7" => '&#50129;',
 "\x9B\xF8" => '&#50130;',
 "\x9B\xF9" => '&#50131;',
 "\x9B\xFA" => '&#50132;',
 "\x9B\xFB" => '&#50133;',
 "\x9B\xFC" => '&#50134;',
 "\x9B\xFD" => '&#50135;',
 "\x9B\xFE" => '&#50138;',
 "\x9C\x41" => '&#50139;',
 "\x9C\x42" => '&#50141;',
 "\x9C\x43" => '&#50142;',
 "\x9C\x44" => '&#50145;',
 "\x9C\x45" => '&#50147;',
 "\x9C\x46" => '&#50148;',
 "\x9C\x47" => '&#50149;',
 "\x9C\x48" => '&#50150;',
 "\x9C\x49" => '&#50151;',
 "\x9C\x4A" => '&#50154;',
 "\x9C\x4B" => '&#50155;',
 "\x9C\x4C" => '&#50156;',
 "\x9C\x4D" => '&#50158;',
 "\x9C\x4E" => '&#50159;',
 "\x9C\x4F" => '&#50160;',
 "\x9C\x50" => '&#50161;',
 "\x9C\x51" => '&#50162;',
 "\x9C\x52" => '&#50163;',
 "\x9C\x53" => '&#50166;',
 "\x9C\x54" => '&#50167;',
 "\x9C\x55" => '&#50169;',
 "\x9C\x56" => '&#50170;',
 "\x9C\x57" => '&#50171;',
 "\x9C\x58" => '&#50172;',
 "\x9C\x59" => '&#50173;',
 "\x9C\x5A" => '&#50174;',
 "\x9C\x61" => '&#50175;',
 "\x9C\x62" => '&#50176;',
 "\x9C\x63" => '&#50177;',
 "\x9C\x64" => '&#50178;',
 "\x9C\x65" => '&#50179;',
 "\x9C\x66" => '&#50180;',
 "\x9C\x67" => '&#50181;',
 "\x9C\x68" => '&#50182;',
 "\x9C\x69" => '&#50183;',
 "\x9C\x6A" => '&#50185;',
 "\x9C\x6B" => '&#50186;',
 "\x9C\x6C" => '&#50187;',
 "\x9C\x6D" => '&#50188;',
 "\x9C\x6E" => '&#50189;',
 "\x9C\x6F" => '&#50190;',
 "\x9C\x70" => '&#50191;',
 "\x9C\x71" => '&#50193;',
 "\x9C\x72" => '&#50194;',
 "\x9C\x73" => '&#50195;',
 "\x9C\x74" => '&#50196;',
 "\x9C\x75" => '&#50197;',
 "\x9C\x76" => '&#50198;',
 "\x9C\x77" => '&#50199;',
 "\x9C\x78" => '&#50200;',
 "\x9C\x79" => '&#50201;',
 "\x9C\x7A" => '&#50202;',
 "\x9C\x81" => '&#50203;',
 "\x9C\x82" => '&#50204;',
 "\x9C\x83" => '&#50205;',
 "\x9C\x84" => '&#50206;',
 "\x9C\x85" => '&#50207;',
 "\x9C\x86" => '&#50208;',
 "\x9C\x87" => '&#50209;',
 "\x9C\x88" => '&#50210;',
 "\x9C\x89" => '&#50211;',
 "\x9C\x8A" => '&#50213;',
 "\x9C\x8B" => '&#50214;',
 "\x9C\x8C" => '&#50215;',
 "\x9C\x8D" => '&#50216;',
 "\x9C\x8E" => '&#50217;',
 "\x9C\x8F" => '&#50218;',
 "\x9C\x90" => '&#50219;',
 "\x9C\x91" => '&#50221;',
 "\x9C\x92" => '&#50222;',
 "\x9C\x93" => '&#50223;',
 "\x9C\x94" => '&#50225;',
 "\x9C\x95" => '&#50226;',
 "\x9C\x96" => '&#50227;',
 "\x9C\x97" => '&#50229;',
 "\x9C\x98" => '&#50230;',
 "\x9C\x99" => '&#50231;',
 "\x9C\x9A" => '&#50232;',
 "\x9C\x9B" => '&#50233;',
 "\x9C\x9C" => '&#50234;',
 "\x9C\x9D" => '&#50235;',
 "\x9C\x9E" => '&#50238;',
 "\x9C\x9F" => '&#50239;',
 "\x9C\xA0" => '&#50240;',
 "\x9C\xA1" => '&#50241;',
 "\x9C\xA2" => '&#50242;',
 "\x9C\xA3" => '&#50243;',
 "\x9C\xA4" => '&#50244;',
 "\x9C\xA5" => '&#50245;',
 "\x9C\xA6" => '&#50246;',
 "\x9C\xA7" => '&#50247;',
 "\x9C\xA8" => '&#50249;',
 "\x9C\xA9" => '&#50250;',
 "\x9C\xAA" => '&#50251;',
 "\x9C\xAB" => '&#50252;',
 "\x9C\xAC" => '&#50253;',
 "\x9C\xAD" => '&#50254;',
 "\x9C\xAE" => '&#50255;',
 "\x9C\xAF" => '&#50256;',
 "\x9C\xB0" => '&#50257;',
 "\x9C\xB1" => '&#50258;',
 "\x9C\xB2" => '&#50259;',
 "\x9C\xB3" => '&#50260;',
 "\x9C\xB4" => '&#50261;',
 "\x9C\xB5" => '&#50262;',
 "\x9C\xB6" => '&#50263;',
 "\x9C\xB7" => '&#50264;',
 "\x9C\xB8" => '&#50265;',
 "\x9C\xB9" => '&#50266;',
 "\x9C\xBA" => '&#50267;',
 "\x9C\xBB" => '&#50268;',
 "\x9C\xBC" => '&#50269;',
 "\x9C\xBD" => '&#50270;',
 "\x9C\xBE" => '&#50271;',
 "\x9C\xBF" => '&#50272;',
 "\x9C\xC0" => '&#50273;',
 "\x9C\xC1" => '&#50274;',
 "\x9C\xC2" => '&#50275;',
 "\x9C\xC3" => '&#50278;',
 "\x9C\xC4" => '&#50279;',
 "\x9C\xC5" => '&#50281;',
 "\x9C\xC6" => '&#50282;',
 "\x9C\xC7" => '&#50283;',
 "\x9C\xC8" => '&#50285;',
 "\x9C\xC9" => '&#50286;',
 "\x9C\xCA" => '&#50287;',
 "\x9C\xCB" => '&#50288;',
 "\x9C\xCC" => '&#50289;',
 "\x9C\xCD" => '&#50290;',
 "\x9C\xCE" => '&#50291;',
 "\x9C\xCF" => '&#50294;',
 "\x9C\xD0" => '&#50295;',
 "\x9C\xD1" => '&#50296;',
 "\x9C\xD2" => '&#50298;',
 "\x9C\xD3" => '&#50299;',
 "\x9C\xD4" => '&#50300;',
 "\x9C\xD5" => '&#50301;',
 "\x9C\xD6" => '&#50302;',
 "\x9C\xD7" => '&#50303;',
 "\x9C\xD8" => '&#50305;',
 "\x9C\xD9" => '&#50306;',
 "\x9C\xDA" => '&#50307;',
 "\x9C\xDB" => '&#50308;',
 "\x9C\xDC" => '&#50309;',
 "\x9C\xDD" => '&#50310;',
 "\x9C\xDE" => '&#50311;',
 "\x9C\xDF" => '&#50312;',
 "\x9C\xE0" => '&#50313;',
 "\x9C\xE1" => '&#50314;',
 "\x9C\xE2" => '&#50315;',
 "\x9C\xE3" => '&#50316;',
 "\x9C\xE4" => '&#50317;',
 "\x9C\xE5" => '&#50318;',
 "\x9C\xE6" => '&#50319;',
 "\x9C\xE7" => '&#50320;',
 "\x9C\xE8" => '&#50321;',
 "\x9C\xE9" => '&#50322;',
 "\x9C\xEA" => '&#50323;',
 "\x9C\xEB" => '&#50325;',
 "\x9C\xEC" => '&#50326;',
 "\x9C\xED" => '&#50327;',
 "\x9C\xEE" => '&#50328;',
 "\x9C\xEF" => '&#50329;',
 "\x9C\xF0" => '&#50330;',
 "\x9C\xF1" => '&#50331;',
 "\x9C\xF2" => '&#50333;',
 "\x9C\xF3" => '&#50334;',
 "\x9C\xF4" => '&#50335;',
 "\x9C\xF5" => '&#50336;',
 "\x9C\xF6" => '&#50337;',
 "\x9C\xF7" => '&#50338;',
 "\x9C\xF8" => '&#50339;',
 "\x9C\xF9" => '&#50340;',
 "\x9C\xFA" => '&#50341;',
 "\x9C\xFB" => '&#50342;',
 "\x9C\xFC" => '&#50343;',
 "\x9C\xFD" => '&#50344;',
 "\x9C\xFE" => '&#50345;',
 "\x9D\x41" => '&#50346;',
 "\x9D\x42" => '&#50347;',
 "\x9D\x43" => '&#50348;',
 "\x9D\x44" => '&#50349;',
 "\x9D\x45" => '&#50350;',
 "\x9D\x46" => '&#50351;',
 "\x9D\x47" => '&#50352;',
 "\x9D\x48" => '&#50353;',
 "\x9D\x49" => '&#50354;',
 "\x9D\x4A" => '&#50355;',
 "\x9D\x4B" => '&#50356;',
 "\x9D\x4C" => '&#50357;',
 "\x9D\x4D" => '&#50358;',
 "\x9D\x4E" => '&#50359;',
 "\x9D\x4F" => '&#50361;',
 "\x9D\x50" => '&#50362;',
 "\x9D\x51" => '&#50363;',
 "\x9D\x52" => '&#50365;',
 "\x9D\x53" => '&#50366;',
 "\x9D\x54" => '&#50367;',
 "\x9D\x55" => '&#50368;',
 "\x9D\x56" => '&#50369;',
 "\x9D\x57" => '&#50370;',
 "\x9D\x58" => '&#50371;',
 "\x9D\x59" => '&#50372;',
 "\x9D\x5A" => '&#50373;',
 "\x9D\x61" => '&#50374;',
 "\x9D\x62" => '&#50375;',
 "\x9D\x63" => '&#50376;',
 "\x9D\x64" => '&#50377;',
 "\x9D\x65" => '&#50378;',
 "\x9D\x66" => '&#50379;',
 "\x9D\x67" => '&#50380;',
 "\x9D\x68" => '&#50381;',
 "\x9D\x69" => '&#50382;',
 "\x9D\x6A" => '&#50383;',
 "\x9D\x6B" => '&#50384;',
 "\x9D\x6C" => '&#50385;',
 "\x9D\x6D" => '&#50386;',
 "\x9D\x6E" => '&#50387;',
 "\x9D\x6F" => '&#50388;',
 "\x9D\x70" => '&#50389;',
 "\x9D\x71" => '&#50390;',
 "\x9D\x72" => '&#50391;',
 "\x9D\x73" => '&#50392;',
 "\x9D\x74" => '&#50393;',
 "\x9D\x75" => '&#50394;',
 "\x9D\x76" => '&#50395;',
 "\x9D\x77" => '&#50396;',
 "\x9D\x78" => '&#50397;',
 "\x9D\x79" => '&#50398;',
 "\x9D\x7A" => '&#50399;',
 "\x9D\x81" => '&#50400;',
 "\x9D\x82" => '&#50401;',
 "\x9D\x83" => '&#50402;',
 "\x9D\x84" => '&#50403;',
 "\x9D\x85" => '&#50404;',
 "\x9D\x86" => '&#50405;',
 "\x9D\x87" => '&#50406;',
 "\x9D\x88" => '&#50407;',
 "\x9D\x89" => '&#50408;',
 "\x9D\x8A" => '&#50410;',
 "\x9D\x8B" => '&#50411;',
 "\x9D\x8C" => '&#50412;',
 "\x9D\x8D" => '&#50413;',
 "\x9D\x8E" => '&#50414;',
 "\x9D\x8F" => '&#50415;',
 "\x9D\x90" => '&#50418;',
 "\x9D\x91" => '&#50419;',
 "\x9D\x92" => '&#50421;',
 "\x9D\x93" => '&#50422;',
 "\x9D\x94" => '&#50423;',
 "\x9D\x95" => '&#50425;',
 "\x9D\x96" => '&#50427;',
 "\x9D\x97" => '&#50428;',
 "\x9D\x98" => '&#50429;',
 "\x9D\x99" => '&#50430;',
 "\x9D\x9A" => '&#50434;',
 "\x9D\x9B" => '&#50435;',
 "\x9D\x9C" => '&#50436;',
 "\x9D\x9D" => '&#50437;',
 "\x9D\x9E" => '&#50438;',
 "\x9D\x9F" => '&#50439;',
 "\x9D\xA0" => '&#50440;',
 "\x9D\xA1" => '&#50441;',
 "\x9D\xA2" => '&#50442;',
 "\x9D\xA3" => '&#50443;',
 "\x9D\xA4" => '&#50445;',
 "\x9D\xA5" => '&#50446;',
 "\x9D\xA6" => '&#50447;',
 "\x9D\xA7" => '&#50449;',
 "\x9D\xA8" => '&#50450;',
 "\x9D\xA9" => '&#50451;',
 "\x9D\xAA" => '&#50453;',
 "\x9D\xAB" => '&#50454;',
 "\x9D\xAC" => '&#50455;',
 "\x9D\xAD" => '&#50456;',
 "\x9D\xAE" => '&#50457;',
 "\x9D\xAF" => '&#50458;',
 "\x9D\xB0" => '&#50459;',
 "\x9D\xB1" => '&#50461;',
 "\x9D\xB2" => '&#50462;',
 "\x9D\xB3" => '&#50463;',
 "\x9D\xB4" => '&#50464;',
 "\x9D\xB5" => '&#50465;',
 "\x9D\xB6" => '&#50466;',
 "\x9D\xB7" => '&#50467;',
 "\x9D\xB8" => '&#50468;',
 "\x9D\xB9" => '&#50469;',
 "\x9D\xBA" => '&#50470;',
 "\x9D\xBB" => '&#50471;',
 "\x9D\xBC" => '&#50474;',
 "\x9D\xBD" => '&#50475;',
 "\x9D\xBE" => '&#50477;',
 "\x9D\xBF" => '&#50478;',
 "\x9D\xC0" => '&#50479;',
 "\x9D\xC1" => '&#50481;',
 "\x9D\xC2" => '&#50482;',
 "\x9D\xC3" => '&#50483;',
 "\x9D\xC4" => '&#50484;',
 "\x9D\xC5" => '&#50485;',
 "\x9D\xC6" => '&#50486;',
 "\x9D\xC7" => '&#50487;',
 "\x9D\xC8" => '&#50490;',
 "\x9D\xC9" => '&#50492;',
 "\x9D\xCA" => '&#50494;',
 "\x9D\xCB" => '&#50495;',
 "\x9D\xCC" => '&#50496;',
 "\x9D\xCD" => '&#50497;',
 "\x9D\xCE" => '&#50498;',
 "\x9D\xCF" => '&#50499;',
 "\x9D\xD0" => '&#50502;',
 "\x9D\xD1" => '&#50503;',
 "\x9D\xD2" => '&#50507;',
 "\x9D\xD3" => '&#50511;',
 "\x9D\xD4" => '&#50512;',
 "\x9D\xD5" => '&#50513;',
 "\x9D\xD6" => '&#50514;',
 "\x9D\xD7" => '&#50518;',
 "\x9D\xD8" => '&#50522;',
 "\x9D\xD9" => '&#50523;',
 "\x9D\xDA" => '&#50524;',
 "\x9D\xDB" => '&#50527;',
 "\x9D\xDC" => '&#50530;',
 "\x9D\xDD" => '&#50531;',
 "\x9D\xDE" => '&#50533;',
 "\x9D\xDF" => '&#50534;',
 "\x9D\xE0" => '&#50535;',
 "\x9D\xE1" => '&#50537;',
 "\x9D\xE2" => '&#50538;',
 "\x9D\xE3" => '&#50539;',
 "\x9D\xE4" => '&#50540;',
 "\x9D\xE5" => '&#50541;',
 "\x9D\xE6" => '&#50542;',
 "\x9D\xE7" => '&#50543;',
 "\x9D\xE8" => '&#50546;',
 "\x9D\xE9" => '&#50550;',
 "\x9D\xEA" => '&#50551;',
 "\x9D\xEB" => '&#50552;',
 "\x9D\xEC" => '&#50553;',
 "\x9D\xED" => '&#50554;',
 "\x9D\xEE" => '&#50555;',
 "\x9D\xEF" => '&#50558;',
 "\x9D\xF0" => '&#50559;',
 "\x9D\xF1" => '&#50561;',
 "\x9D\xF2" => '&#50562;',
 "\x9D\xF3" => '&#50563;',
 "\x9D\xF4" => '&#50565;',
 "\x9D\xF5" => '&#50566;',
 "\x9D\xF6" => '&#50568;',
 "\x9D\xF7" => '&#50569;',
 "\x9D\xF8" => '&#50570;',
 "\x9D\xF9" => '&#50571;',
 "\x9D\xFA" => '&#50574;',
 "\x9D\xFB" => '&#50576;',
 "\x9D\xFC" => '&#50578;',
 "\x9D\xFD" => '&#50579;',
 "\x9D\xFE" => '&#50580;',
 "\x9E\x41" => '&#50582;',
 "\x9E\x42" => '&#50585;',
 "\x9E\x43" => '&#50586;',
 "\x9E\x44" => '&#50587;',
 "\x9E\x45" => '&#50589;',
 "\x9E\x46" => '&#50590;',
 "\x9E\x47" => '&#50591;',
 "\x9E\x48" => '&#50593;',
 "\x9E\x49" => '&#50594;',
 "\x9E\x4A" => '&#50595;',
 "\x9E\x4B" => '&#50596;',
 "\x9E\x4C" => '&#50597;',
 "\x9E\x4D" => '&#50598;',
 "\x9E\x4E" => '&#50599;',
 "\x9E\x4F" => '&#50600;',
 "\x9E\x50" => '&#50602;',
 "\x9E\x51" => '&#50603;',
 "\x9E\x52" => '&#50604;',
 "\x9E\x53" => '&#50605;',
 "\x9E\x54" => '&#50606;',
 "\x9E\x55" => '&#50607;',
 "\x9E\x56" => '&#50608;',
 "\x9E\x57" => '&#50609;',
 "\x9E\x58" => '&#50610;',
 "\x9E\x59" => '&#50611;',
 "\x9E\x5A" => '&#50614;',
 "\x9E\x61" => '&#50615;',
 "\x9E\x62" => '&#50618;',
 "\x9E\x63" => '&#50623;',
 "\x9E\x64" => '&#50624;',
 "\x9E\x65" => '&#50625;',
 "\x9E\x66" => '&#50626;',
 "\x9E\x67" => '&#50627;',
 "\x9E\x68" => '&#50635;',
 "\x9E\x69" => '&#50637;',
 "\x9E\x6A" => '&#50639;',
 "\x9E\x6B" => '&#50642;',
 "\x9E\x6C" => '&#50643;',
 "\x9E\x6D" => '&#50645;',
 "\x9E\x6E" => '&#50646;',
 "\x9E\x6F" => '&#50647;',
 "\x9E\x70" => '&#50649;',
 "\x9E\x71" => '&#50650;',
 "\x9E\x72" => '&#50651;',
 "\x9E\x73" => '&#50652;',
 "\x9E\x74" => '&#50653;',
 "\x9E\x75" => '&#50654;',
 "\x9E\x76" => '&#50655;',
 "\x9E\x77" => '&#50658;',
 "\x9E\x78" => '&#50660;',
 "\x9E\x79" => '&#50662;',
 "\x9E\x7A" => '&#50663;',
 "\x9E\x81" => '&#50664;',
 "\x9E\x82" => '&#50665;',
 "\x9E\x83" => '&#50666;',
 "\x9E\x84" => '&#50667;',
 "\x9E\x85" => '&#50671;',
 "\x9E\x86" => '&#50673;',
 "\x9E\x87" => '&#50674;',
 "\x9E\x88" => '&#50675;',
 "\x9E\x89" => '&#50677;',
 "\x9E\x8A" => '&#50680;',
 "\x9E\x8B" => '&#50681;',
 "\x9E\x8C" => '&#50682;',
 "\x9E\x8D" => '&#50683;',
 "\x9E\x8E" => '&#50690;',
 "\x9E\x8F" => '&#50691;',
 "\x9E\x90" => '&#50692;',
 "\x9E\x91" => '&#50697;',
 "\x9E\x92" => '&#50698;',
 "\x9E\x93" => '&#50699;',
 "\x9E\x94" => '&#50701;',
 "\x9E\x95" => '&#50702;',
 "\x9E\x96" => '&#50703;',
 "\x9E\x97" => '&#50705;',
 "\x9E\x98" => '&#50706;',
 "\x9E\x99" => '&#50707;',
 "\x9E\x9A" => '&#50708;',
 "\x9E\x9B" => '&#50709;',
 "\x9E\x9C" => '&#50710;',
 "\x9E\x9D" => '&#50711;',
 "\x9E\x9E" => '&#50714;',
 "\x9E\x9F" => '&#50717;',
 "\x9E\xA0" => '&#50718;',
 "\x9E\xA1" => '&#50719;',
 "\x9E\xA2" => '&#50720;',
 "\x9E\xA3" => '&#50721;',
 "\x9E\xA4" => '&#50722;',
 "\x9E\xA5" => '&#50723;',
 "\x9E\xA6" => '&#50726;',
 "\x9E\xA7" => '&#50727;',
 "\x9E\xA8" => '&#50729;',
 "\x9E\xA9" => '&#50730;',
 "\x9E\xAA" => '&#50731;',
 "\x9E\xAB" => '&#50735;',
 "\x9E\xAC" => '&#50737;',
 "\x9E\xAD" => '&#50738;',
 "\x9E\xAE" => '&#50742;',
 "\x9E\xAF" => '&#50744;',
 "\x9E\xB0" => '&#50746;',
 "\x9E\xB1" => '&#50748;',
 "\x9E\xB2" => '&#50749;',
 "\x9E\xB3" => '&#50750;',
 "\x9E\xB4" => '&#50751;',
 "\x9E\xB5" => '&#50754;',
 "\x9E\xB6" => '&#50755;',
 "\x9E\xB7" => '&#50757;',
 "\x9E\xB8" => '&#50758;',
 "\x9E\xB9" => '&#50759;',
 "\x9E\xBA" => '&#50761;',
 "\x9E\xBB" => '&#50762;',
 "\x9E\xBC" => '&#50763;',
 "\x9E\xBD" => '&#50764;',
 "\x9E\xBE" => '&#50765;',
 "\x9E\xBF" => '&#50766;',
 "\x9E\xC0" => '&#50767;',
 "\x9E\xC1" => '&#50770;',
 "\x9E\xC2" => '&#50774;',
 "\x9E\xC3" => '&#50775;',
 "\x9E\xC4" => '&#50776;',
 "\x9E\xC5" => '&#50777;',
 "\x9E\xC6" => '&#50778;',
 "\x9E\xC7" => '&#50779;',
 "\x9E\xC8" => '&#50782;',
 "\x9E\xC9" => '&#50783;',
 "\x9E\xCA" => '&#50785;',
 "\x9E\xCB" => '&#50786;',
 "\x9E\xCC" => '&#50787;',
 "\x9E\xCD" => '&#50788;',
 "\x9E\xCE" => '&#50789;',
 "\x9E\xCF" => '&#50790;',
 "\x9E\xD0" => '&#50791;',
 "\x9E\xD1" => '&#50792;',
 "\x9E\xD2" => '&#50793;',
 "\x9E\xD3" => '&#50794;',
 "\x9E\xD4" => '&#50795;',
 "\x9E\xD5" => '&#50797;',
 "\x9E\xD6" => '&#50798;',
 "\x9E\xD7" => '&#50800;',
 "\x9E\xD8" => '&#50802;',
 "\x9E\xD9" => '&#50803;',
 "\x9E\xDA" => '&#50804;',
 "\x9E\xDB" => '&#50805;',
 "\x9E\xDC" => '&#50806;',
 "\x9E\xDD" => '&#50807;',
 "\x9E\xDE" => '&#50810;',
 "\x9E\xDF" => '&#50811;',
 "\x9E\xE0" => '&#50813;',
 "\x9E\xE1" => '&#50814;',
 "\x9E\xE2" => '&#50815;',
 "\x9E\xE3" => '&#50817;',
 "\x9E\xE4" => '&#50818;',
 "\x9E\xE5" => '&#50819;',
 "\x9E\xE6" => '&#50820;',
 "\x9E\xE7" => '&#50821;',
 "\x9E\xE8" => '&#50822;',
 "\x9E\xE9" => '&#50823;',
 "\x9E\xEA" => '&#50826;',
 "\x9E\xEB" => '&#50828;',
 "\x9E\xEC" => '&#50830;',
 "\x9E\xED" => '&#50831;',
 "\x9E\xEE" => '&#50832;',
 "\x9E\xEF" => '&#50833;',
 "\x9E\xF0" => '&#50834;',
 "\x9E\xF1" => '&#50835;',
 "\x9E\xF2" => '&#50838;',
 "\x9E\xF3" => '&#50839;',
 "\x9E\xF4" => '&#50841;',
 "\x9E\xF5" => '&#50842;',
 "\x9E\xF6" => '&#50843;',
 "\x9E\xF7" => '&#50845;',
 "\x9E\xF8" => '&#50846;',
 "\x9E\xF9" => '&#50847;',
 "\x9E\xFA" => '&#50848;',
 "\x9E\xFB" => '&#50849;',
 "\x9E\xFC" => '&#50850;',
 "\x9E\xFD" => '&#50851;',
 "\x9E\xFE" => '&#50854;',
 "\x9F\x41" => '&#50856;',
 "\x9F\x42" => '&#50858;',
 "\x9F\x43" => '&#50859;',
 "\x9F\x44" => '&#50860;',
 "\x9F\x45" => '&#50861;',
 "\x9F\x46" => '&#50862;',
 "\x9F\x47" => '&#50863;',
 "\x9F\x48" => '&#50866;',
 "\x9F\x49" => '&#50867;',
 "\x9F\x4A" => '&#50869;',
 "\x9F\x4B" => '&#50870;',
 "\x9F\x4C" => '&#50871;',
 "\x9F\x4D" => '&#50875;',
 "\x9F\x4E" => '&#50876;',
 "\x9F\x4F" => '&#50877;',
 "\x9F\x50" => '&#50878;',
 "\x9F\x51" => '&#50879;',
 "\x9F\x52" => '&#50882;',
 "\x9F\x53" => '&#50884;',
 "\x9F\x54" => '&#50886;',
 "\x9F\x55" => '&#50887;',
 "\x9F\x56" => '&#50888;',
 "\x9F\x57" => '&#50889;',
 "\x9F\x58" => '&#50890;',
 "\x9F\x59" => '&#50891;',
 "\x9F\x5A" => '&#50894;',
 "\x9F\x61" => '&#50895;',
 "\x9F\x62" => '&#50897;',
 "\x9F\x63" => '&#50898;',
 "\x9F\x64" => '&#50899;',
 "\x9F\x65" => '&#50901;',
 "\x9F\x66" => '&#50902;',
 "\x9F\x67" => '&#50903;',
 "\x9F\x68" => '&#50904;',
 "\x9F\x69" => '&#50905;',
 "\x9F\x6A" => '&#50906;',
 "\x9F\x6B" => '&#50907;',
 "\x9F\x6C" => '&#50910;',
 "\x9F\x6D" => '&#50911;',
 "\x9F\x6E" => '&#50914;',
 "\x9F\x6F" => '&#50915;',
 "\x9F\x70" => '&#50916;',
 "\x9F\x71" => '&#50917;',
 "\x9F\x72" => '&#50918;',
 "\x9F\x73" => '&#50919;',
 "\x9F\x74" => '&#50922;',
 "\x9F\x75" => '&#50923;',
 "\x9F\x76" => '&#50925;',
 "\x9F\x77" => '&#50926;',
 "\x9F\x78" => '&#50927;',
 "\x9F\x79" => '&#50929;',
 "\x9F\x7A" => '&#50930;',
 "\x9F\x81" => '&#50931;',
 "\x9F\x82" => '&#50932;',
 "\x9F\x83" => '&#50933;',
 "\x9F\x84" => '&#50934;',
 "\x9F\x85" => '&#50935;',
 "\x9F\x86" => '&#50938;',
 "\x9F\x87" => '&#50939;',
 "\x9F\x88" => '&#50940;',
 "\x9F\x89" => '&#50942;',
 "\x9F\x8A" => '&#50943;',
 "\x9F\x8B" => '&#50944;',
 "\x9F\x8C" => '&#50945;',
 "\x9F\x8D" => '&#50946;',
 "\x9F\x8E" => '&#50947;',
 "\x9F\x8F" => '&#50950;',
 "\x9F\x90" => '&#50951;',
 "\x9F\x91" => '&#50953;',
 "\x9F\x92" => '&#50954;',
 "\x9F\x93" => '&#50955;',
 "\x9F\x94" => '&#50957;',
 "\x9F\x95" => '&#50958;',
 "\x9F\x96" => '&#50959;',
 "\x9F\x97" => '&#50960;',
 "\x9F\x98" => '&#50961;',
 "\x9F\x99" => '&#50962;',
 "\x9F\x9A" => '&#50963;',
 "\x9F\x9B" => '&#50966;',
 "\x9F\x9C" => '&#50968;',
 "\x9F\x9D" => '&#50970;',
 "\x9F\x9E" => '&#50971;',
 "\x9F\x9F" => '&#50972;',
 "\x9F\xA0" => '&#50973;',
 "\x9F\xA1" => '&#50974;',
 "\x9F\xA2" => '&#50975;',
 "\x9F\xA3" => '&#50978;',
 "\x9F\xA4" => '&#50979;',
 "\x9F\xA5" => '&#50981;',
 "\x9F\xA6" => '&#50982;',
 "\x9F\xA7" => '&#50983;',
 "\x9F\xA8" => '&#50985;',
 "\x9F\xA9" => '&#50986;',
 "\x9F\xAA" => '&#50987;',
 "\x9F\xAB" => '&#50988;',
 "\x9F\xAC" => '&#50989;',
 "\x9F\xAD" => '&#50990;',
 "\x9F\xAE" => '&#50991;',
 "\x9F\xAF" => '&#50994;',
 "\x9F\xB0" => '&#50996;',
 "\x9F\xB1" => '&#50998;',
 "\x9F\xB2" => '&#51000;',
 "\x9F\xB3" => '&#51001;',
 "\x9F\xB4" => '&#51002;',
 "\x9F\xB5" => '&#51003;',
 "\x9F\xB6" => '&#51006;',
 "\x9F\xB7" => '&#51007;',
 "\x9F\xB8" => '&#51009;',
 "\x9F\xB9" => '&#51010;',
 "\x9F\xBA" => '&#51011;',
 "\x9F\xBB" => '&#51013;',
 "\x9F\xBC" => '&#51014;',
 "\x9F\xBD" => '&#51015;',
 "\x9F\xBE" => '&#51016;',
 "\x9F\xBF" => '&#51017;',
 "\x9F\xC0" => '&#51019;',
 "\x9F\xC1" => '&#51022;',
 "\x9F\xC2" => '&#51024;',
 "\x9F\xC3" => '&#51033;',
 "\x9F\xC4" => '&#51034;',
 "\x9F\xC5" => '&#51035;',
 "\x9F\xC6" => '&#51037;',
 "\x9F\xC7" => '&#51038;',
 "\x9F\xC8" => '&#51039;',
 "\x9F\xC9" => '&#51041;',
 "\x9F\xCA" => '&#51042;',
 "\x9F\xCB" => '&#51043;',
 "\x9F\xCC" => '&#51044;',
 "\x9F\xCD" => '&#51045;',
 "\x9F\xCE" => '&#51046;',
 "\x9F\xCF" => '&#51047;',
 "\x9F\xD0" => '&#51049;',
 "\x9F\xD1" => '&#51050;',
 "\x9F\xD2" => '&#51052;',
 "\x9F\xD3" => '&#51053;',
 "\x9F\xD4" => '&#51054;',
 "\x9F\xD5" => '&#51055;',
 "\x9F\xD6" => '&#51056;',
 "\x9F\xD7" => '&#51057;',
 "\x9F\xD8" => '&#51058;',
 "\x9F\xD9" => '&#51059;',
 "\x9F\xDA" => '&#51062;',
 "\x9F\xDB" => '&#51063;',
 "\x9F\xDC" => '&#51065;',
 "\x9F\xDD" => '&#51066;',
 "\x9F\xDE" => '&#51067;',
 "\x9F\xDF" => '&#51071;',
 "\x9F\xE0" => '&#51072;',
 "\x9F\xE1" => '&#51073;',
 "\x9F\xE2" => '&#51074;',
 "\x9F\xE3" => '&#51078;',
 "\x9F\xE4" => '&#51083;',
 "\x9F\xE5" => '&#51084;',
 "\x9F\xE6" => '&#51085;',
 "\x9F\xE7" => '&#51087;',
 "\x9F\xE8" => '&#51090;',
 "\x9F\xE9" => '&#51091;',
 "\x9F\xEA" => '&#51093;',
 "\x9F\xEB" => '&#51097;',
 "\x9F\xEC" => '&#51099;',
 "\x9F\xED" => '&#51100;',
 "\x9F\xEE" => '&#51101;',
 "\x9F\xEF" => '&#51102;',
 "\x9F\xF0" => '&#51103;',
 "\x9F\xF1" => '&#51106;',
 "\x9F\xF2" => '&#51111;',
 "\x9F\xF3" => '&#51112;',
 "\x9F\xF4" => '&#51113;',
 "\x9F\xF5" => '&#51114;',
 "\x9F\xF6" => '&#51115;',
 "\x9F\xF7" => '&#51118;',
 "\x9F\xF8" => '&#51119;',
 "\x9F\xF9" => '&#51121;',
 "\x9F\xFA" => '&#51122;',
 "\x9F\xFB" => '&#51123;',
 "\x9F\xFC" => '&#51125;',
 "\x9F\xFD" => '&#51126;',
 "\x9F\xFE" => '&#51127;',
 "\xA0\x41" => '&#51128;',
 "\xA0\x42" => '&#51129;',
 "\xA0\x43" => '&#51130;',
 "\xA0\x44" => '&#51131;',
 "\xA0\x45" => '&#51134;',
 "\xA0\x46" => '&#51138;',
 "\xA0\x47" => '&#51139;',
 "\xA0\x48" => '&#51140;',
 "\xA0\x49" => '&#51141;',
 "\xA0\x4A" => '&#51142;',
 "\xA0\x4B" => '&#51143;',
 "\xA0\x4C" => '&#51146;',
 "\xA0\x4D" => '&#51147;',
 "\xA0\x4E" => '&#51149;',
 "\xA0\x4F" => '&#51151;',
 "\xA0\x50" => '&#51153;',
 "\xA0\x51" => '&#51154;',
 "\xA0\x52" => '&#51155;',
 "\xA0\x53" => '&#51156;',
 "\xA0\x54" => '&#51157;',
 "\xA0\x55" => '&#51158;',
 "\xA0\x56" => '&#51159;',
 "\xA0\x57" => '&#51161;',
 "\xA0\x58" => '&#51162;',
 "\xA0\x59" => '&#51163;',
 "\xA0\x5A" => '&#51164;',
 "\xA0\x61" => '&#51166;',
 "\xA0\x62" => '&#51167;',
 "\xA0\x63" => '&#51168;',
 "\xA0\x64" => '&#51169;',
 "\xA0\x65" => '&#51170;',
 "\xA0\x66" => '&#51171;',
 "\xA0\x67" => '&#51173;',
 "\xA0\x68" => '&#51174;',
 "\xA0\x69" => '&#51175;',
 "\xA0\x6A" => '&#51177;',
 "\xA0\x6B" => '&#51178;',
 "\xA0\x6C" => '&#51179;',
 "\xA0\x6D" => '&#51181;',
 "\xA0\x6E" => '&#51182;',
 "\xA0\x6F" => '&#51183;',
 "\xA0\x70" => '&#51184;',
 "\xA0\x71" => '&#51185;',
 "\xA0\x72" => '&#51186;',
 "\xA0\x73" => '&#51187;',
 "\xA0\x74" => '&#51188;',
 "\xA0\x75" => '&#51189;',
 "\xA0\x76" => '&#51190;',
 "\xA0\x77" => '&#51191;',
 "\xA0\x78" => '&#51192;',
 "\xA0\x79" => '&#51193;',
 "\xA0\x7A" => '&#51194;',
 "\xA0\x81" => '&#51195;',
 "\xA0\x82" => '&#51196;',
 "\xA0\x83" => '&#51197;',
 "\xA0\x84" => '&#51198;',
 "\xA0\x85" => '&#51199;',
 "\xA0\x86" => '&#51202;',
 "\xA0\x87" => '&#51203;',
 "\xA0\x88" => '&#51205;',
 "\xA0\x89" => '&#51206;',
 "\xA0\x8A" => '&#51207;',
 "\xA0\x8B" => '&#51209;',
 "\xA0\x8C" => '&#51211;',
 "\xA0\x8D" => '&#51212;',
 "\xA0\x8E" => '&#51213;',
 "\xA0\x8F" => '&#51214;',
 "\xA0\x90" => '&#51215;',
 "\xA0\x91" => '&#51218;',
 "\xA0\x92" => '&#51220;',
 "\xA0\x93" => '&#51223;',
 "\xA0\x94" => '&#51224;',
 "\xA0\x95" => '&#51225;',
 "\xA0\x96" => '&#51226;',
 "\xA0\x97" => '&#51227;',
 "\xA0\x98" => '&#51230;',
 "\xA0\x99" => '&#51231;',
 "\xA0\x9A" => '&#51233;',
 "\xA0\x9B" => '&#51234;',
 "\xA0\x9C" => '&#51235;',
 "\xA0\x9D" => '&#51237;',
 "\xA0\x9E" => '&#51238;',
 "\xA0\x9F" => '&#51239;',
 "\xA0\xA0" => '&#51240;',
 "\xA0\xA1" => '&#51241;',
 "\xA0\xA2" => '&#51242;',
 "\xA0\xA3" => '&#51243;',
 "\xA0\xA4" => '&#51246;',
 "\xA0\xA5" => '&#51248;',
 "\xA0\xA6" => '&#51250;',
 "\xA0\xA7" => '&#51251;',
 "\xA0\xA8" => '&#51252;',
 "\xA0\xA9" => '&#51253;',
 "\xA0\xAA" => '&#51254;',
 "\xA0\xAB" => '&#51255;',
 "\xA0\xAC" => '&#51257;',
 "\xA0\xAD" => '&#51258;',
 "\xA0\xAE" => '&#51259;',
 "\xA0\xAF" => '&#51261;',
 "\xA0\xB0" => '&#51262;',
 "\xA0\xB1" => '&#51263;',
 "\xA0\xB2" => '&#51265;',
 "\xA0\xB3" => '&#51266;',
 "\xA0\xB4" => '&#51267;',
 "\xA0\xB5" => '&#51268;',
 "\xA0\xB6" => '&#51269;',
 "\xA0\xB7" => '&#51270;',
 "\xA0\xB8" => '&#51271;',
 "\xA0\xB9" => '&#51274;',
 "\xA0\xBA" => '&#51275;',
 "\xA0\xBB" => '&#51278;',
 "\xA0\xBC" => '&#51279;',
 "\xA0\xBD" => '&#51280;',
 "\xA0\xBE" => '&#51281;',
 "\xA0\xBF" => '&#51282;',
 "\xA0\xC0" => '&#51283;',
 "\xA0\xC1" => '&#51285;',
 "\xA0\xC2" => '&#51286;',
 "\xA0\xC3" => '&#51287;',
 "\xA0\xC4" => '&#51288;',
 "\xA0\xC5" => '&#51289;',
 "\xA0\xC6" => '&#51290;',
 "\xA0\xC7" => '&#51291;',
 "\xA0\xC8" => '&#51292;',
 "\xA0\xC9" => '&#51293;',
 "\xA0\xCA" => '&#51294;',
 "\xA0\xCB" => '&#51295;',
 "\xA0\xCC" => '&#51296;',
 "\xA0\xCD" => '&#51297;',
 "\xA0\xCE" => '&#51298;',
 "\xA0\xCF" => '&#51299;',
 "\xA0\xD0" => '&#51300;',
 "\xA0\xD1" => '&#51301;',
 "\xA0\xD2" => '&#51302;',
 "\xA0\xD3" => '&#51303;',
 "\xA0\xD4" => '&#51304;',
 "\xA0\xD5" => '&#51305;',
 "\xA0\xD6" => '&#51306;',
 "\xA0\xD7" => '&#51307;',
 "\xA0\xD8" => '&#51308;',
 "\xA0\xD9" => '&#51309;',
 "\xA0\xDA" => '&#51310;',
 "\xA0\xDB" => '&#51311;',
 "\xA0\xDC" => '&#51314;',
 "\xA0\xDD" => '&#51315;',
 "\xA0\xDE" => '&#51317;',
 "\xA0\xDF" => '&#51318;',
 "\xA0\xE0" => '&#51319;',
 "\xA0\xE1" => '&#51321;',
 "\xA0\xE2" => '&#51323;',
 "\xA0\xE3" => '&#51324;',
 "\xA0\xE4" => '&#51325;',
 "\xA0\xE5" => '&#51326;',
 "\xA0\xE6" => '&#51327;',
 "\xA0\xE7" => '&#51330;',
 "\xA0\xE8" => '&#51332;',
 "\xA0\xE9" => '&#51336;',
 "\xA0\xEA" => '&#51337;',
 "\xA0\xEB" => '&#51338;',
 "\xA0\xEC" => '&#51342;',
 "\xA0\xED" => '&#51343;',
 "\xA0\xEE" => '&#51344;',
 "\xA0\xEF" => '&#51345;',
 "\xA0\xF0" => '&#51346;',
 "\xA0\xF1" => '&#51347;',
 "\xA0\xF2" => '&#51349;',
 "\xA0\xF3" => '&#51350;',
 "\xA0\xF4" => '&#51351;',
 "\xA0\xF5" => '&#51352;',
 "\xA0\xF6" => '&#51353;',
 "\xA0\xF7" => '&#51354;',
 "\xA0\xF8" => '&#51355;',
 "\xA0\xF9" => '&#51356;',
 "\xA0\xFA" => '&#51358;',
 "\xA0\xFB" => '&#51360;',
 "\xA0\xFC" => '&#51362;',
 "\xA0\xFD" => '&#51363;',
 "\xA0\xFE" => '&#51364;',
 "\xA1\x41" => '&#51365;',
 "\xA1\x42" => '&#51366;',
 "\xA1\x43" => '&#51367;',
 "\xA1\x44" => '&#51369;',
 "\xA1\x45" => '&#51370;',
 "\xA1\x46" => '&#51371;',
 "\xA1\x47" => '&#51372;',
 "\xA1\x48" => '&#51373;',
 "\xA1\x49" => '&#51374;',
 "\xA1\x4A" => '&#51375;',
 "\xA1\x4B" => '&#51376;',
 "\xA1\x4C" => '&#51377;',
 "\xA1\x4D" => '&#51378;',
 "\xA1\x4E" => '&#51379;',
 "\xA1\x4F" => '&#51380;',
 "\xA1\x50" => '&#51381;',
 "\xA1\x51" => '&#51382;',
 "\xA1\x52" => '&#51383;',
 "\xA1\x53" => '&#51384;',
 "\xA1\x54" => '&#51385;',
 "\xA1\x55" => '&#51386;',
 "\xA1\x56" => '&#51387;',
 "\xA1\x57" => '&#51390;',
 "\xA1\x58" => '&#51391;',
 "\xA1\x59" => '&#51392;',
 "\xA1\x5A" => '&#51393;',
 "\xA1\x61" => '&#51394;',
 "\xA1\x62" => '&#51395;',
 "\xA1\x63" => '&#51397;',
 "\xA1\x64" => '&#51398;',
 "\xA1\x65" => '&#51399;',
 "\xA1\x66" => '&#51401;',
 "\xA1\x67" => '&#51402;',
 "\xA1\x68" => '&#51403;',
 "\xA1\x69" => '&#51405;',
 "\xA1\x6A" => '&#51406;',
 "\xA1\x6B" => '&#51407;',
 "\xA1\x6C" => '&#51408;',
 "\xA1\x6D" => '&#51409;',
 "\xA1\x6E" => '&#51410;',
 "\xA1\x6F" => '&#51411;',
 "\xA1\x70" => '&#51414;',
 "\xA1\x71" => '&#51416;',
 "\xA1\x72" => '&#51418;',
 "\xA1\x73" => '&#51419;',
 "\xA1\x74" => '&#51420;',
 "\xA1\x75" => '&#51421;',
 "\xA1\x76" => '&#51422;',
 "\xA1\x77" => '&#51423;',
 "\xA1\x78" => '&#51426;',
 "\xA1\x79" => '&#51427;',
 "\xA1\x7A" => '&#51429;',
 "\xA1\x81" => '&#51430;',
 "\xA1\x82" => '&#51431;',
 "\xA1\x83" => '&#51432;',
 "\xA1\x84" => '&#51433;',
 "\xA1\x85" => '&#51434;',
 "\xA1\x86" => '&#51435;',
 "\xA1\x87" => '&#51436;',
 "\xA1\x88" => '&#51437;',
 "\xA1\x89" => '&#51438;',
 "\xA1\x8A" => '&#51439;',
 "\xA1\x8B" => '&#51440;',
 "\xA1\x8C" => '&#51441;',
 "\xA1\x8D" => '&#51442;',
 "\xA1\x8E" => '&#51443;',
 "\xA1\x8F" => '&#51444;',
 "\xA1\x90" => '&#51446;',
 "\xA1\x91" => '&#51447;',
 "\xA1\x92" => '&#51448;',
 "\xA1\x93" => '&#51449;',
 "\xA1\x94" => '&#51450;',
 "\xA1\x95" => '&#51451;',
 "\xA1\x96" => '&#51454;',
 "\xA1\x97" => '&#51455;',
 "\xA1\x98" => '&#51457;',
 "\xA1\x99" => '&#51458;',
 "\xA1\x9A" => '&#51459;',
 "\xA1\x9B" => '&#51463;',
 "\xA1\x9C" => '&#51464;',
 "\xA1\x9D" => '&#51465;',
 "\xA1\x9E" => '&#51466;',
 "\xA1\x9F" => '&#51467;',
 "\xA1\xA0" => '&#51470;',
 "\xA1\xA1" => '&#12288;',
 "\xA1\xA2" => '&#12289;',
 "\xA1\xA3" => '&#12290;',
 "\xA1\xA4" => '&#183;',
 "\xA1\xA5" => '&#8229;',
 "\xA1\xA6" => '&#8230;',
 "\xA1\xA7" => '&#168;',
 "\xA1\xA8" => '&#12291;',
 "\xA1\xA9" => '&#173;',
 "\xA1\xAA" => '&#8213;',
 "\xA1\xAB" => '&#8741;',
 "\xA1\xAC" => '&#65340;',
 "\xA1\xAD" => '&#8764;',
 "\xA1\xAE" => '&#8216;',
 "\xA1\xAF" => '&#8217;',
 "\xA1\xB0" => '&#8220;',
 "\xA1\xB1" => '&#8221;',
 "\xA1\xB2" => '&#12308;',
 "\xA1\xB3" => '&#12309;',
 "\xA1\xB4" => '&#12296;',
 "\xA1\xB5" => '&#12297;',
 "\xA1\xB6" => '&#12298;',
 "\xA1\xB7" => '&#12299;',
 "\xA1\xB8" => '&#12300;',
 "\xA1\xB9" => '&#12301;',
 "\xA1\xBA" => '&#12302;',
 "\xA1\xBB" => '&#12303;',
 "\xA1\xBC" => '&#12304;',
 "\xA1\xBD" => '&#12305;',
 "\xA1\xBE" => '&#177;',
 "\xA1\xBF" => '&#215;',
 "\xA1\xC0" => '&#247;',
 "\xA1\xC1" => '&#8800;',
 "\xA1\xC2" => '&#8804;',
 "\xA1\xC3" => '&#8805;',
 "\xA1\xC4" => '&#8734;',
 "\xA1\xC5" => '&#8756;',
 "\xA1\xC6" => '&#176;',
 "\xA1\xC7" => '&#8242;',
 "\xA1\xC8" => '&#8243;',
 "\xA1\xC9" => '&#8451;',
 "\xA1\xCA" => '&#8491;',
 "\xA1\xCB" => '&#65504;',
 "\xA1\xCC" => '&#65505;',
 "\xA1\xCD" => '&#65509;',
 "\xA1\xCE" => '&#9794;',
 "\xA1\xCF" => '&#9792;',
 "\xA1\xD0" => '&#8736;',
 "\xA1\xD1" => '&#8869;',
 "\xA1\xD2" => '&#8978;',
 "\xA1\xD3" => '&#8706;',
 "\xA1\xD4" => '&#8711;',
 "\xA1\xD5" => '&#8801;',
 "\xA1\xD6" => '&#8786;',
 "\xA1\xD7" => '&#167;',
 "\xA1\xD8" => '&#8251;',
 "\xA1\xD9" => '&#9734;',
 "\xA1\xDA" => '&#9733;',
 "\xA1\xDB" => '&#9675;',
 "\xA1\xDC" => '&#9679;',
 "\xA1\xDD" => '&#9678;',
 "\xA1\xDE" => '&#9671;',
 "\xA1\xDF" => '&#9670;',
 "\xA1\xE0" => '&#9633;',
 "\xA1\xE1" => '&#9632;',
 "\xA1\xE2" => '&#9651;',
 "\xA1\xE3" => '&#9650;',
 "\xA1\xE4" => '&#9661;',
 "\xA1\xE5" => '&#9660;',
 "\xA1\xE6" => '&#8594;',
 "\xA1\xE7" => '&#8592;',
 "\xA1\xE8" => '&#8593;',
 "\xA1\xE9" => '&#8595;',
 "\xA1\xEA" => '&#8596;',
 "\xA1\xEB" => '&#12307;',
 "\xA1\xEC" => '&#8810;',
 "\xA1\xED" => '&#8811;',
 "\xA1\xEE" => '&#8730;',
 "\xA1\xEF" => '&#8765;',
 "\xA1\xF0" => '&#8733;',
 "\xA1\xF1" => '&#8757;',
 "\xA1\xF2" => '&#8747;',
 "\xA1\xF3" => '&#8748;',
 "\xA1\xF4" => '&#8712;',
 "\xA1\xF5" => '&#8715;',
 "\xA1\xF6" => '&#8838;',
 "\xA1\xF7" => '&#8839;',
 "\xA1\xF8" => '&#8834;',
 "\xA1\xF9" => '&#8835;',
 "\xA1\xFA" => '&#8746;',
 "\xA1\xFB" => '&#8745;',
 "\xA1\xFC" => '&#8743;',
 "\xA1\xFD" => '&#8744;',
 "\xA1\xFE" => '&#65506;',
 "\xA2\x41" => '&#51472;',
 "\xA2\x42" => '&#51474;',
 "\xA2\x43" => '&#51475;',
 "\xA2\x44" => '&#51476;',
 "\xA2\x45" => '&#51477;',
 "\xA2\x46" => '&#51478;',
 "\xA2\x47" => '&#51479;',
 "\xA2\x48" => '&#51481;',
 "\xA2\x49" => '&#51482;',
 "\xA2\x4A" => '&#51483;',
 "\xA2\x4B" => '&#51484;',
 "\xA2\x4C" => '&#51485;',
 "\xA2\x4D" => '&#51486;',
 "\xA2\x4E" => '&#51487;',
 "\xA2\x4F" => '&#51488;',
 "\xA2\x50" => '&#51489;',
 "\xA2\x51" => '&#51490;',
 "\xA2\x52" => '&#51491;',
 "\xA2\x53" => '&#51492;',
 "\xA2\x54" => '&#51493;',
 "\xA2\x55" => '&#51494;',
 "\xA2\x56" => '&#51495;',
 "\xA2\x57" => '&#51496;',
 "\xA2\x58" => '&#51497;',
 "\xA2\x59" => '&#51498;',
 "\xA2\x5A" => '&#51499;',
 "\xA2\x61" => '&#51501;',
 "\xA2\x62" => '&#51502;',
 "\xA2\x63" => '&#51503;',
 "\xA2\x64" => '&#51504;',
 "\xA2\x65" => '&#51505;',
 "\xA2\x66" => '&#51506;',
 "\xA2\x67" => '&#51507;',
 "\xA2\x68" => '&#51509;',
 "\xA2\x69" => '&#51510;',
 "\xA2\x6A" => '&#51511;',
 "\xA2\x6B" => '&#51512;',
 "\xA2\x6C" => '&#51513;',
 "\xA2\x6D" => '&#51514;',
 "\xA2\x6E" => '&#51515;',
 "\xA2\x6F" => '&#51516;',
 "\xA2\x70" => '&#51517;',
 "\xA2\x71" => '&#51518;',
 "\xA2\x72" => '&#51519;',
 "\xA2\x73" => '&#51520;',
 "\xA2\x74" => '&#51521;',
 "\xA2\x75" => '&#51522;',
 "\xA2\x76" => '&#51523;',
 "\xA2\x77" => '&#51524;',
 "\xA2\x78" => '&#51525;',
 "\xA2\x79" => '&#51526;',
 "\xA2\x7A" => '&#51527;',
 "\xA2\x81" => '&#51528;',
 "\xA2\x82" => '&#51529;',
 "\xA2\x83" => '&#51530;',
 "\xA2\x84" => '&#51531;',
 "\xA2\x85" => '&#51532;',
 "\xA2\x86" => '&#51533;',
 "\xA2\x87" => '&#51534;',
 "\xA2\x88" => '&#51535;',
 "\xA2\x89" => '&#51538;',
 "\xA2\x8A" => '&#51539;',
 "\xA2\x8B" => '&#51541;',
 "\xA2\x8C" => '&#51542;',
 "\xA2\x8D" => '&#51543;',
 "\xA2\x8E" => '&#51545;',
 "\xA2\x8F" => '&#51546;',
 "\xA2\x90" => '&#51547;',
 "\xA2\x91" => '&#51548;',
 "\xA2\x92" => '&#51549;',
 "\xA2\x93" => '&#51550;',
 "\xA2\x94" => '&#51551;',
 "\xA2\x95" => '&#51554;',
 "\xA2\x96" => '&#51556;',
 "\xA2\x97" => '&#51557;',
 "\xA2\x98" => '&#51558;',
 "\xA2\x99" => '&#51559;',
 "\xA2\x9A" => '&#51560;',
 "\xA2\x9B" => '&#51561;',
 "\xA2\x9C" => '&#51562;',
 "\xA2\x9D" => '&#51563;',
 "\xA2\x9E" => '&#51565;',
 "\xA2\x9F" => '&#51566;',
 "\xA2\xA0" => '&#51567;',
 "\xA2\xA1" => '&#8658;',
 "\xA2\xA2" => '&#8660;',
 "\xA2\xA3" => '&#8704;',
 "\xA2\xA4" => '&#8707;',
 "\xA2\xA5" => '&#180;',
 "\xA2\xA6" => '&#65374;',
 "\xA2\xA7" => '&#711;',
 "\xA2\xA8" => '&#728;',
 "\xA2\xA9" => '&#733;',
 "\xA2\xAA" => '&#730;',
 "\xA2\xAB" => '&#729;',
 "\xA2\xAC" => '&#184;',
 "\xA2\xAD" => '&#731;',
 "\xA2\xAE" => '&#161;',
 "\xA2\xAF" => '&#191;',
 "\xA2\xB0" => '&#720;',
 "\xA2\xB1" => '&#8750;',
 "\xA2\xB2" => '&#8721;',
 "\xA2\xB3" => '&#8719;',
 "\xA2\xB4" => '&#164;',
 "\xA2\xB5" => '&#8457;',
 "\xA2\xB6" => '&#8240;',
 "\xA2\xB7" => '&#9665;',
 "\xA2\xB8" => '&#9664;',
 "\xA2\xB9" => '&#9655;',
 "\xA2\xBA" => '&#9654;',
 "\xA2\xBB" => '&#9828;',
 "\xA2\xBC" => '&#9824;',
 "\xA2\xBD" => '&#9825;',
 "\xA2\xBE" => '&#9829;',
 "\xA2\xBF" => '&#9831;',
 "\xA2\xC0" => '&#9827;',
 "\xA2\xC1" => '&#8857;',
 "\xA2\xC2" => '&#9672;',
 "\xA2\xC3" => '&#9635;',
 "\xA2\xC4" => '&#9680;',
 "\xA2\xC5" => '&#9681;',
 "\xA2\xC6" => '&#9618;',
 "\xA2\xC7" => '&#9636;',
 "\xA2\xC8" => '&#9637;',
 "\xA2\xC9" => '&#9640;',
 "\xA2\xCA" => '&#9639;',
 "\xA2\xCB" => '&#9638;',
 "\xA2\xCC" => '&#9641;',
 "\xA2\xCD" => '&#9832;',
 "\xA2\xCE" => '&#9743;',
 "\xA2\xCF" => '&#9742;',
 "\xA2\xD0" => '&#9756;',
 "\xA2\xD1" => '&#9758;',
 "\xA2\xD2" => '&#182;',
 "\xA2\xD3" => '&#8224;',
 "\xA2\xD4" => '&#8225;',
 "\xA2\xD5" => '&#8597;',
 "\xA2\xD6" => '&#8599;',
 "\xA2\xD7" => '&#8601;',
 "\xA2\xD8" => '&#8598;',
 "\xA2\xD9" => '&#8600;',
 "\xA2\xDA" => '&#9837;',
 "\xA2\xDB" => '&#9833;',
 "\xA2\xDC" => '&#9834;',
 "\xA2\xDD" => '&#9836;',
 "\xA2\xDE" => '&#12927;',
 "\xA2\xDF" => '&#12828;',
 "\xA2\xE0" => '&#8470;',
 "\xA2\xE1" => '&#13255;',
 "\xA2\xE2" => '&#8482;',
 "\xA2\xE3" => '&#13250;',
 "\xA2\xE4" => '&#13272;',
 "\xA2\xE5" => '&#8481;',
 "\xA2\xE6" => '&#8364;',
 "\xA2\xE7" => '&#174;',
 "\xA3\x41" => '&#51569;',
 "\xA3\x42" => '&#51570;',
 "\xA3\x43" => '&#51571;',
 "\xA3\x44" => '&#51573;',
 "\xA3\x45" => '&#51574;',
 "\xA3\x46" => '&#51575;',
 "\xA3\x47" => '&#51576;',
 "\xA3\x48" => '&#51577;',
 "\xA3\x49" => '&#51578;',
 "\xA3\x4A" => '&#51579;',
 "\xA3\x4B" => '&#51581;',
 "\xA3\x4C" => '&#51582;',
 "\xA3\x4D" => '&#51583;',
 "\xA3\x4E" => '&#51584;',
 "\xA3\x4F" => '&#51585;',
 "\xA3\x50" => '&#51586;',
 "\xA3\x51" => '&#51587;',
 "\xA3\x52" => '&#51588;',
 "\xA3\x53" => '&#51589;',
 "\xA3\x54" => '&#51590;',
 "\xA3\x55" => '&#51591;',
 "\xA3\x56" => '&#51594;',
 "\xA3\x57" => '&#51595;',
 "\xA3\x58" => '&#51597;',
 "\xA3\x59" => '&#51598;',
 "\xA3\x5A" => '&#51599;',
 "\xA3\x61" => '&#51601;',
 "\xA3\x62" => '&#51602;',
 "\xA3\x63" => '&#51603;',
 "\xA3\x64" => '&#51604;',
 "\xA3\x65" => '&#51605;',
 "\xA3\x66" => '&#51606;',
 "\xA3\x67" => '&#51607;',
 "\xA3\x68" => '&#51610;',
 "\xA3\x69" => '&#51612;',
 "\xA3\x6A" => '&#51614;',
 "\xA3\x6B" => '&#51615;',
 "\xA3\x6C" => '&#51616;',
 "\xA3\x6D" => '&#51617;',
 "\xA3\x6E" => '&#51618;',
 "\xA3\x6F" => '&#51619;',
 "\xA3\x70" => '&#51620;',
 "\xA3\x71" => '&#51621;',
 "\xA3\x72" => '&#51622;',
 "\xA3\x73" => '&#51623;',
 "\xA3\x74" => '&#51624;',
 "\xA3\x75" => '&#51625;',
 "\xA3\x76" => '&#51626;',
 "\xA3\x77" => '&#51627;',
 "\xA3\x78" => '&#51628;',
 "\xA3\x79" => '&#51629;',
 "\xA3\x7A" => '&#51630;',
 "\xA3\x81" => '&#51631;',
 "\xA3\x82" => '&#51632;',
 "\xA3\x83" => '&#51633;',
 "\xA3\x84" => '&#51634;',
 "\xA3\x85" => '&#51635;',
 "\xA3\x86" => '&#51636;',
 "\xA3\x87" => '&#51637;',
 "\xA3\x88" => '&#51638;',
 "\xA3\x89" => '&#51639;',
 "\xA3\x8A" => '&#51640;',
 "\xA3\x8B" => '&#51641;',
 "\xA3\x8C" => '&#51642;',
 "\xA3\x8D" => '&#51643;',
 "\xA3\x8E" => '&#51644;',
 "\xA3\x8F" => '&#51645;',
 "\xA3\x90" => '&#51646;',
 "\xA3\x91" => '&#51647;',
 "\xA3\x92" => '&#51650;',
 "\xA3\x93" => '&#51651;',
 "\xA3\x94" => '&#51653;',
 "\xA3\x95" => '&#51654;',
 "\xA3\x96" => '&#51657;',
 "\xA3\x97" => '&#51659;',
 "\xA3\x98" => '&#51660;',
 "\xA3\x99" => '&#51661;',
 "\xA3\x9A" => '&#51662;',
 "\xA3\x9B" => '&#51663;',
 "\xA3\x9C" => '&#51666;',
 "\xA3\x9D" => '&#51668;',
 "\xA3\x9E" => '&#51671;',
 "\xA3\x9F" => '&#51672;',
 "\xA3\xA0" => '&#51675;',
 "\xA3\xA1" => '&#65281;',
 "\xA3\xA2" => '&#65282;',
 "\xA3\xA3" => '&#65283;',
 "\xA3\xA4" => '&#65284;',
 "\xA3\xA5" => '&#65285;',
 "\xA3\xA6" => '&#65286;',
 "\xA3\xA7" => '&#65287;',
 "\xA3\xA8" => '&#65288;',
 "\xA3\xA9" => '&#65289;',
 "\xA3\xAA" => '&#65290;',
 "\xA3\xAB" => '&#65291;',
 "\xA3\xAC" => '&#65292;',
 "\xA3\xAD" => '&#65293;',
 "\xA3\xAE" => '&#65294;',
 "\xA3\xAF" => '&#65295;',
 "\xA3\xB0" => '&#65296;',
 "\xA3\xB1" => '&#65297;',
 "\xA3\xB2" => '&#65298;',
 "\xA3\xB3" => '&#65299;',
 "\xA3\xB4" => '&#65300;',
 "\xA3\xB5" => '&#65301;',
 "\xA3\xB6" => '&#65302;',
 "\xA3\xB7" => '&#65303;',
 "\xA3\xB8" => '&#65304;',
 "\xA3\xB9" => '&#65305;',
 "\xA3\xBA" => '&#65306;',
 "\xA3\xBB" => '&#65307;',
 "\xA3\xBC" => '&#65308;',
 "\xA3\xBD" => '&#65309;',
 "\xA3\xBE" => '&#65310;',
 "\xA3\xBF" => '&#65311;',
 "\xA3\xC0" => '&#65312;',
 "\xA3\xC1" => '&#65313;',
 "\xA3\xC2" => '&#65314;',
 "\xA3\xC3" => '&#65315;',
 "\xA3\xC4" => '&#65316;',
 "\xA3\xC5" => '&#65317;',
 "\xA3\xC6" => '&#65318;',
 "\xA3\xC7" => '&#65319;',
 "\xA3\xC8" => '&#65320;',
 "\xA3\xC9" => '&#65321;',
 "\xA3\xCA" => '&#65322;',
 "\xA3\xCB" => '&#65323;',
 "\xA3\xCC" => '&#65324;',
 "\xA3\xCD" => '&#65325;',
 "\xA3\xCE" => '&#65326;',
 "\xA3\xCF" => '&#65327;',
 "\xA3\xD0" => '&#65328;',
 "\xA3\xD1" => '&#65329;',
 "\xA3\xD2" => '&#65330;',
 "\xA3\xD3" => '&#65331;',
 "\xA3\xD4" => '&#65332;',
 "\xA3\xD5" => '&#65333;',
 "\xA3\xD6" => '&#65334;',
 "\xA3\xD7" => '&#65335;',
 "\xA3\xD8" => '&#65336;',
 "\xA3\xD9" => '&#65337;',
 "\xA3\xDA" => '&#65338;',
 "\xA3\xDB" => '&#65339;',
 "\xA3\xDC" => '&#65510;',
 "\xA3\xDD" => '&#65341;',
 "\xA3\xDE" => '&#65342;',
 "\xA3\xDF" => '&#65343;',
 "\xA3\xE0" => '&#65344;',
 "\xA3\xE1" => '&#65345;',
 "\xA3\xE2" => '&#65346;',
 "\xA3\xE3" => '&#65347;',
 "\xA3\xE4" => '&#65348;',
 "\xA3\xE5" => '&#65349;',
 "\xA3\xE6" => '&#65350;',
 "\xA3\xE7" => '&#65351;',
 "\xA3\xE8" => '&#65352;',
 "\xA3\xE9" => '&#65353;',
 "\xA3\xEA" => '&#65354;',
 "\xA3\xEB" => '&#65355;',
 "\xA3\xEC" => '&#65356;',
 "\xA3\xED" => '&#65357;',
 "\xA3\xEE" => '&#65358;',
 "\xA3\xEF" => '&#65359;',
 "\xA3\xF0" => '&#65360;',
 "\xA3\xF1" => '&#65361;',
 "\xA3\xF2" => '&#65362;',
 "\xA3\xF3" => '&#65363;',
 "\xA3\xF4" => '&#65364;',
 "\xA3\xF5" => '&#65365;',
 "\xA3\xF6" => '&#65366;',
 "\xA3\xF7" => '&#65367;',
 "\xA3\xF8" => '&#65368;',
 "\xA3\xF9" => '&#65369;',
 "\xA3\xFA" => '&#65370;',
 "\xA3\xFB" => '&#65371;',
 "\xA3\xFC" => '&#65372;',
 "\xA3\xFD" => '&#65373;',
 "\xA3\xFE" => '&#65507;',
 "\xA4\x41" => '&#51678;',
 "\xA4\x42" => '&#51679;',
 "\xA4\x43" => '&#51681;',
 "\xA4\x44" => '&#51683;',
 "\xA4\x45" => '&#51685;',
 "\xA4\x46" => '&#51686;',
 "\xA4\x47" => '&#51688;',
 "\xA4\x48" => '&#51689;',
 "\xA4\x49" => '&#51690;',
 "\xA4\x4A" => '&#51691;',
 "\xA4\x4B" => '&#51694;',
 "\xA4\x4C" => '&#51698;',
 "\xA4\x4D" => '&#51699;',
 "\xA4\x4E" => '&#51700;',
 "\xA4\x4F" => '&#51701;',
 "\xA4\x50" => '&#51702;',
 "\xA4\x51" => '&#51703;',
 "\xA4\x52" => '&#51706;',
 "\xA4\x53" => '&#51707;',
 "\xA4\x54" => '&#51709;',
 "\xA4\x55" => '&#51710;',
 "\xA4\x56" => '&#51711;',
 "\xA4\x57" => '&#51713;',
 "\xA4\x58" => '&#51714;',
 "\xA4\x59" => '&#51715;',
 "\xA4\x5A" => '&#51716;',
 "\xA4\x61" => '&#51717;',
 "\xA4\x62" => '&#51718;',
 "\xA4\x63" => '&#51719;',
 "\xA4\x64" => '&#51722;',
 "\xA4\x65" => '&#51726;',
 "\xA4\x66" => '&#51727;',
 "\xA4\x67" => '&#51728;',
 "\xA4\x68" => '&#51729;',
 "\xA4\x69" => '&#51730;',
 "\xA4\x6A" => '&#51731;',
 "\xA4\x6B" => '&#51733;',
 "\xA4\x6C" => '&#51734;',
 "\xA4\x6D" => '&#51735;',
 "\xA4\x6E" => '&#51737;',
 "\xA4\x6F" => '&#51738;',
 "\xA4\x70" => '&#51739;',
 "\xA4\x71" => '&#51740;',
 "\xA4\x72" => '&#51741;',
 "\xA4\x73" => '&#51742;',
 "\xA4\x74" => '&#51743;',
 "\xA4\x75" => '&#51744;',
 "\xA4\x76" => '&#51745;',
 "\xA4\x77" => '&#51746;',
 "\xA4\x78" => '&#51747;',
 "\xA4\x79" => '&#51748;',
 "\xA4\x7A" => '&#51749;',
 "\xA4\x81" => '&#51750;',
 "\xA4\x82" => '&#51751;',
 "\xA4\x83" => '&#51752;',
 "\xA4\x84" => '&#51754;',
 "\xA4\x85" => '&#51755;',
 "\xA4\x86" => '&#51756;',
 "\xA4\x87" => '&#51757;',
 "\xA4\x88" => '&#51758;',
 "\xA4\x89" => '&#51759;',
 "\xA4\x8A" => '&#51760;',
 "\xA4\x8B" => '&#51761;',
 "\xA4\x8C" => '&#51762;',
 "\xA4\x8D" => '&#51763;',
 "\xA4\x8E" => '&#51764;',
 "\xA4\x8F" => '&#51765;',
 "\xA4\x90" => '&#51766;',
 "\xA4\x91" => '&#51767;',
 "\xA4\x92" => '&#51768;',
 "\xA4\x93" => '&#51769;',
 "\xA4\x94" => '&#51770;',
 "\xA4\x95" => '&#51771;',
 "\xA4\x96" => '&#51772;',
 "\xA4\x97" => '&#51773;',
 "\xA4\x98" => '&#51774;',
 "\xA4\x99" => '&#51775;',
 "\xA4\x9A" => '&#51776;',
 "\xA4\x9B" => '&#51777;',
 "\xA4\x9C" => '&#51778;',
 "\xA4\x9D" => '&#51779;',
 "\xA4\x9E" => '&#51780;',
 "\xA4\x9F" => '&#51781;',
 "\xA4\xA0" => '&#51782;',
 "\xA4\xA1" => '&#12593;',
 "\xA4\xA2" => '&#12594;',
 "\xA4\xA3" => '&#12595;',
 "\xA4\xA4" => '&#12596;',
 "\xA4\xA5" => '&#12597;',
 "\xA4\xA6" => '&#12598;',
 "\xA4\xA7" => '&#12599;',
 "\xA4\xA8" => '&#12600;',
 "\xA4\xA9" => '&#12601;',
 "\xA4\xAA" => '&#12602;',
 "\xA4\xAB" => '&#12603;',
 "\xA4\xAC" => '&#12604;',
 "\xA4\xAD" => '&#12605;',
 "\xA4\xAE" => '&#12606;',
 "\xA4\xAF" => '&#12607;',
 "\xA4\xB0" => '&#12608;',
 "\xA4\xB1" => '&#12609;',
 "\xA4\xB2" => '&#12610;',
 "\xA4\xB3" => '&#12611;',
 "\xA4\xB4" => '&#12612;',
 "\xA4\xB5" => '&#12613;',
 "\xA4\xB6" => '&#12614;',
 "\xA4\xB7" => '&#12615;',
 "\xA4\xB8" => '&#12616;',
 "\xA4\xB9" => '&#12617;',
 "\xA4\xBA" => '&#12618;',
 "\xA4\xBB" => '&#12619;',
 "\xA4\xBC" => '&#12620;',
 "\xA4\xBD" => '&#12621;',
 "\xA4\xBE" => '&#12622;',
 "\xA4\xBF" => '&#12623;',
 "\xA4\xC0" => '&#12624;',
 "\xA4\xC1" => '&#12625;',
 "\xA4\xC2" => '&#12626;',
 "\xA4\xC3" => '&#12627;',
 "\xA4\xC4" => '&#12628;',
 "\xA4\xC5" => '&#12629;',
 "\xA4\xC6" => '&#12630;',
 "\xA4\xC7" => '&#12631;',
 "\xA4\xC8" => '&#12632;',
 "\xA4\xC9" => '&#12633;',
 "\xA4\xCA" => '&#12634;',
 "\xA4\xCB" => '&#12635;',
 "\xA4\xCC" => '&#12636;',
 "\xA4\xCD" => '&#12637;',
 "\xA4\xCE" => '&#12638;',
 "\xA4\xCF" => '&#12639;',
 "\xA4\xD0" => '&#12640;',
 "\xA4\xD1" => '&#12641;',
 "\xA4\xD2" => '&#12642;',
 "\xA4\xD3" => '&#12643;',
 "\xA4\xD4" => '&#12644;',
 "\xA4\xD5" => '&#12645;',
 "\xA4\xD6" => '&#12646;',
 "\xA4\xD7" => '&#12647;',
 "\xA4\xD8" => '&#12648;',
 "\xA4\xD9" => '&#12649;',
 "\xA4\xDA" => '&#12650;',
 "\xA4\xDB" => '&#12651;',
 "\xA4\xDC" => '&#12652;',
 "\xA4\xDD" => '&#12653;',
 "\xA4\xDE" => '&#12654;',
 "\xA4\xDF" => '&#12655;',
 "\xA4\xE0" => '&#12656;',
 "\xA4\xE1" => '&#12657;',
 "\xA4\xE2" => '&#12658;',
 "\xA4\xE3" => '&#12659;',
 "\xA4\xE4" => '&#12660;',
 "\xA4\xE5" => '&#12661;',
 "\xA4\xE6" => '&#12662;',
 "\xA4\xE7" => '&#12663;',
 "\xA4\xE8" => '&#12664;',
 "\xA4\xE9" => '&#12665;',
 "\xA4\xEA" => '&#12666;',
 "\xA4\xEB" => '&#12667;',
 "\xA4\xEC" => '&#12668;',
 "\xA4\xED" => '&#12669;',
 "\xA4\xEE" => '&#12670;',
 "\xA4\xEF" => '&#12671;',
 "\xA4\xF0" => '&#12672;',
 "\xA4\xF1" => '&#12673;',
 "\xA4\xF2" => '&#12674;',
 "\xA4\xF3" => '&#12675;',
 "\xA4\xF4" => '&#12676;',
 "\xA4\xF5" => '&#12677;',
 "\xA4\xF6" => '&#12678;',
 "\xA4\xF7" => '&#12679;',
 "\xA4\xF8" => '&#12680;',
 "\xA4\xF9" => '&#12681;',
 "\xA4\xFA" => '&#12682;',
 "\xA4\xFB" => '&#12683;',
 "\xA4\xFC" => '&#12684;',
 "\xA4\xFD" => '&#12685;',
 "\xA4\xFE" => '&#12686;',
 "\xA5\x41" => '&#51783;',
 "\xA5\x42" => '&#51784;',
 "\xA5\x43" => '&#51785;',
 "\xA5\x44" => '&#51786;',
 "\xA5\x45" => '&#51787;',
 "\xA5\x46" => '&#51790;',
 "\xA5\x47" => '&#51791;',
 "\xA5\x48" => '&#51793;',
 "\xA5\x49" => '&#51794;',
 "\xA5\x4A" => '&#51795;',
 "\xA5\x4B" => '&#51797;',
 "\xA5\x4C" => '&#51798;',
 "\xA5\x4D" => '&#51799;',
 "\xA5\x4E" => '&#51800;',
 "\xA5\x4F" => '&#51801;',
 "\xA5\x50" => '&#51802;',
 "\xA5\x51" => '&#51803;',
 "\xA5\x52" => '&#51806;',
 "\xA5\x53" => '&#51810;',
 "\xA5\x54" => '&#51811;',
 "\xA5\x55" => '&#51812;',
 "\xA5\x56" => '&#51813;',
 "\xA5\x57" => '&#51814;',
 "\xA5\x58" => '&#51815;',
 "\xA5\x59" => '&#51817;',
 "\xA5\x5A" => '&#51818;',
 "\xA5\x61" => '&#51819;',
 "\xA5\x62" => '&#51820;',
 "\xA5\x63" => '&#51821;',
 "\xA5\x64" => '&#51822;',
 "\xA5\x65" => '&#51823;',
 "\xA5\x66" => '&#51824;',
 "\xA5\x67" => '&#51825;',
 "\xA5\x68" => '&#51826;',
 "\xA5\x69" => '&#51827;',
 "\xA5\x6A" => '&#51828;',
 "\xA5\x6B" => '&#51829;',
 "\xA5\x6C" => '&#51830;',
 "\xA5\x6D" => '&#51831;',
 "\xA5\x6E" => '&#51832;',
 "\xA5\x6F" => '&#51833;',
 "\xA5\x70" => '&#51834;',
 "\xA5\x71" => '&#51835;',
 "\xA5\x72" => '&#51836;',
 "\xA5\x73" => '&#51838;',
 "\xA5\x74" => '&#51839;',
 "\xA5\x75" => '&#51840;',
 "\xA5\x76" => '&#51841;',
 "\xA5\x77" => '&#51842;',
 "\xA5\x78" => '&#51843;',
 "\xA5\x79" => '&#51845;',
 "\xA5\x7A" => '&#51846;',
 "\xA5\x81" => '&#51847;',
 "\xA5\x82" => '&#51848;',
 "\xA5\x83" => '&#51849;',
 "\xA5\x84" => '&#51850;',
 "\xA5\x85" => '&#51851;',
 "\xA5\x86" => '&#51852;',
 "\xA5\x87" => '&#51853;',
 "\xA5\x88" => '&#51854;',
 "\xA5\x89" => '&#51855;',
 "\xA5\x8A" => '&#51856;',
 "\xA5\x8B" => '&#51857;',
 "\xA5\x8C" => '&#51858;',
 "\xA5\x8D" => '&#51859;',
 "\xA5\x8E" => '&#51860;',
 "\xA5\x8F" => '&#51861;',
 "\xA5\x90" => '&#51862;',
 "\xA5\x91" => '&#51863;',
 "\xA5\x92" => '&#51865;',
 "\xA5\x93" => '&#51866;',
 "\xA5\x94" => '&#51867;',
 "\xA5\x95" => '&#51868;',
 "\xA5\x96" => '&#51869;',
 "\xA5\x97" => '&#51870;',
 "\xA5\x98" => '&#51871;',
 "\xA5\x99" => '&#51872;',
 "\xA5\x9A" => '&#51873;',
 "\xA5\x9B" => '&#51874;',
 "\xA5\x9C" => '&#51875;',
 "\xA5\x9D" => '&#51876;',
 "\xA5\x9E" => '&#51877;',
 "\xA5\x9F" => '&#51878;',
 "\xA5\xA0" => '&#51879;',
 "\xA5\xA1" => '&#8560;',
 "\xA5\xA2" => '&#8561;',
 "\xA5\xA3" => '&#8562;',
 "\xA5\xA4" => '&#8563;',
 "\xA5\xA5" => '&#8564;',
 "\xA5\xA6" => '&#8565;',
 "\xA5\xA7" => '&#8566;',
 "\xA5\xA8" => '&#8567;',
 "\xA5\xA9" => '&#8568;',
 "\xA5\xAA" => '&#8569;',
 "\xA5\xB0" => '&#8544;',
 "\xA5\xB1" => '&#8545;',
 "\xA5\xB2" => '&#8546;',
 "\xA5\xB3" => '&#8547;',
 "\xA5\xB4" => '&#8548;',
 "\xA5\xB5" => '&#8549;',
 "\xA5\xB6" => '&#8550;',
 "\xA5\xB7" => '&#8551;',
 "\xA5\xB8" => '&#8552;',
 "\xA5\xB9" => '&#8553;',
 "\xA5\xC1" => '&#913;',
 "\xA5\xC2" => '&#914;',
 "\xA5\xC3" => '&#915;',
 "\xA5\xC4" => '&#916;',
 "\xA5\xC5" => '&#917;',
 "\xA5\xC6" => '&#918;',
 "\xA5\xC7" => '&#919;',
 "\xA5\xC8" => '&#920;',
 "\xA5\xC9" => '&#921;',
 "\xA5\xCA" => '&#922;',
 "\xA5\xCB" => '&#923;',
 "\xA5\xCC" => '&#924;',
 "\xA5\xCD" => '&#925;',
 "\xA5\xCE" => '&#926;',
 "\xA5\xCF" => '&#927;',
 "\xA5\xD0" => '&#928;',
 "\xA5\xD1" => '&#929;',
 "\xA5\xD2" => '&#931;',
 "\xA5\xD3" => '&#932;',
 "\xA5\xD4" => '&#933;',
 "\xA5\xD5" => '&#934;',
 "\xA5\xD6" => '&#935;',
 "\xA5\xD7" => '&#936;',
 "\xA5\xD8" => '&#937;',
 "\xA5\xE1" => '&#945;',
 "\xA5\xE2" => '&#946;',
 "\xA5\xE3" => '&#947;',
 "\xA5\xE4" => '&#948;',
 "\xA5\xE5" => '&#949;',
 "\xA5\xE6" => '&#950;',
 "\xA5\xE7" => '&#951;',
 "\xA5\xE8" => '&#952;',
 "\xA5\xE9" => '&#953;',
 "\xA5\xEA" => '&#954;',
 "\xA5\xEB" => '&#955;',
 "\xA5\xEC" => '&#956;',
 "\xA5\xED" => '&#957;',
 "\xA5\xEE" => '&#958;',
 "\xA5\xEF" => '&#959;',
 "\xA5\xF0" => '&#960;',
 "\xA5\xF1" => '&#961;',
 "\xA5\xF2" => '&#963;',
 "\xA5\xF3" => '&#964;',
 "\xA5\xF4" => '&#965;',
 "\xA5\xF5" => '&#966;',
 "\xA5\xF6" => '&#967;',
 "\xA5\xF7" => '&#968;',
 "\xA5\xF8" => '&#969;',
 "\xA6\x41" => '&#51880;',
 "\xA6\x42" => '&#51881;',
 "\xA6\x43" => '&#51882;',
 "\xA6\x44" => '&#51883;',
 "\xA6\x45" => '&#51884;',
 "\xA6\x46" => '&#51885;',
 "\xA6\x47" => '&#51886;',
 "\xA6\x48" => '&#51887;',
 "\xA6\x49" => '&#51888;',
 "\xA6\x4A" => '&#51889;',
 "\xA6\x4B" => '&#51890;',
 "\xA6\x4C" => '&#51891;',
 "\xA6\x4D" => '&#51892;',
 "\xA6\x4E" => '&#51893;',
 "\xA6\x4F" => '&#51894;',
 "\xA6\x50" => '&#51895;',
 "\xA6\x51" => '&#51896;',
 "\xA6\x52" => '&#51897;',
 "\xA6\x53" => '&#51898;',
 "\xA6\x54" => '&#51899;',
 "\xA6\x55" => '&#51902;',
 "\xA6\x56" => '&#51903;',
 "\xA6\x57" => '&#51905;',
 "\xA6\x58" => '&#51906;',
 "\xA6\x59" => '&#51907;',
 "\xA6\x5A" => '&#51909;',
 "\xA6\x61" => '&#51910;',
 "\xA6\x62" => '&#51911;',
 "\xA6\x63" => '&#51912;',
 "\xA6\x64" => '&#51913;',
 "\xA6\x65" => '&#51914;',
 "\xA6\x66" => '&#51915;',
 "\xA6\x67" => '&#51918;',
 "\xA6\x68" => '&#51920;',
 "\xA6\x69" => '&#51922;',
 "\xA6\x6A" => '&#51924;',
 "\xA6\x6B" => '&#51925;',
 "\xA6\x6C" => '&#51926;',
 "\xA6\x6D" => '&#51927;',
 "\xA6\x6E" => '&#51930;',
 "\xA6\x6F" => '&#51931;',
 "\xA6\x70" => '&#51932;',
 "\xA6\x71" => '&#51933;',
 "\xA6\x72" => '&#51934;',
 "\xA6\x73" => '&#51935;',
 "\xA6\x74" => '&#51937;',
 "\xA6\x75" => '&#51938;',
 "\xA6\x76" => '&#51939;',
 "\xA6\x77" => '&#51940;',
 "\xA6\x78" => '&#51941;',
 "\xA6\x79" => '&#51942;',
 "\xA6\x7A" => '&#51943;',
 "\xA6\x81" => '&#51944;',
 "\xA6\x82" => '&#51945;',
 "\xA6\x83" => '&#51946;',
 "\xA6\x84" => '&#51947;',
 "\xA6\x85" => '&#51949;',
 "\xA6\x86" => '&#51950;',
 "\xA6\x87" => '&#51951;',
 "\xA6\x88" => '&#51952;',
 "\xA6\x89" => '&#51953;',
 "\xA6\x8A" => '&#51954;',
 "\xA6\x8B" => '&#51955;',
 "\xA6\x8C" => '&#51957;',
 "\xA6\x8D" => '&#51958;',
 "\xA6\x8E" => '&#51959;',
 "\xA6\x8F" => '&#51960;',
 "\xA6\x90" => '&#51961;',
 "\xA6\x91" => '&#51962;',
 "\xA6\x92" => '&#51963;',
 "\xA6\x93" => '&#51964;',
 "\xA6\x94" => '&#51965;',
 "\xA6\x95" => '&#51966;',
 "\xA6\x96" => '&#51967;',
 "\xA6\x97" => '&#51968;',
 "\xA6\x98" => '&#51969;',
 "\xA6\x99" => '&#51970;',
 "\xA6\x9A" => '&#51971;',
 "\xA6\x9B" => '&#51972;',
 "\xA6\x9C" => '&#51973;',
 "\xA6\x9D" => '&#51974;',
 "\xA6\x9E" => '&#51975;',
 "\xA6\x9F" => '&#51977;',
 "\xA6\xA0" => '&#51978;',
 "\xA6\xA1" => '&#9472;',
 "\xA6\xA2" => '&#9474;',
 "\xA6\xA3" => '&#9484;',
 "\xA6\xA4" => '&#9488;',
 "\xA6\xA5" => '&#9496;',
 "\xA6\xA6" => '&#9492;',
 "\xA6\xA7" => '&#9500;',
 "\xA6\xA8" => '&#9516;',
 "\xA6\xA9" => '&#9508;',
 "\xA6\xAA" => '&#9524;',
 "\xA6\xAB" => '&#9532;',
 "\xA6\xAC" => '&#9473;',
 "\xA6\xAD" => '&#9475;',
 "\xA6\xAE" => '&#9487;',
 "\xA6\xAF" => '&#9491;',
 "\xA6\xB0" => '&#9499;',
 "\xA6\xB1" => '&#9495;',
 "\xA6\xB2" => '&#9507;',
 "\xA6\xB3" => '&#9523;',
 "\xA6\xB4" => '&#9515;',
 "\xA6\xB5" => '&#9531;',
 "\xA6\xB6" => '&#9547;',
 "\xA6\xB7" => '&#9504;',
 "\xA6\xB8" => '&#9519;',
 "\xA6\xB9" => '&#9512;',
 "\xA6\xBA" => '&#9527;',
 "\xA6\xBB" => '&#9535;',
 "\xA6\xBC" => '&#9501;',
 "\xA6\xBD" => '&#9520;',
 "\xA6\xBE" => '&#9509;',
 "\xA6\xBF" => '&#9528;',
 "\xA6\xC0" => '&#9538;',
 "\xA6\xC1" => '&#9490;',
 "\xA6\xC2" => '&#9489;',
 "\xA6\xC3" => '&#9498;',
 "\xA6\xC4" => '&#9497;',
 "\xA6\xC5" => '&#9494;',
 "\xA6\xC6" => '&#9493;',
 "\xA6\xC7" => '&#9486;',
 "\xA6\xC8" => '&#9485;',
 "\xA6\xC9" => '&#9502;',
 "\xA6\xCA" => '&#9503;',
 "\xA6\xCB" => '&#9505;',
 "\xA6\xCC" => '&#9506;',
 "\xA6\xCD" => '&#9510;',
 "\xA6\xCE" => '&#9511;',
 "\xA6\xCF" => '&#9513;',
 "\xA6\xD0" => '&#9514;',
 "\xA6\xD1" => '&#9517;',
 "\xA6\xD2" => '&#9518;',
 "\xA6\xD3" => '&#9521;',
 "\xA6\xD4" => '&#9522;',
 "\xA6\xD5" => '&#9525;',
 "\xA6\xD6" => '&#9526;',
 "\xA6\xD7" => '&#9529;',
 "\xA6\xD8" => '&#9530;',
 "\xA6\xD9" => '&#9533;',
 "\xA6\xDA" => '&#9534;',
 "\xA6\xDB" => '&#9536;',
 "\xA6\xDC" => '&#9537;',
 "\xA6\xDD" => '&#9539;',
 "\xA6\xDE" => '&#9540;',
 "\xA6\xDF" => '&#9541;',
 "\xA6\xE0" => '&#9542;',
 "\xA6\xE1" => '&#9543;',
 "\xA6\xE2" => '&#9544;',
 "\xA6\xE3" => '&#9545;',
 "\xA6\xE4" => '&#9546;',
 "\xA7\x41" => '&#51979;',
 "\xA7\x42" => '&#51980;',
 "\xA7\x43" => '&#51981;',
 "\xA7\x44" => '&#51982;',
 "\xA7\x45" => '&#51983;',
 "\xA7\x46" => '&#51985;',
 "\xA7\x47" => '&#51986;',
 "\xA7\x48" => '&#51987;',
 "\xA7\x49" => '&#51989;',
 "\xA7\x4A" => '&#51990;',
 "\xA7\x4B" => '&#51991;',
 "\xA7\x4C" => '&#51993;',
 "\xA7\x4D" => '&#51994;',
 "\xA7\x4E" => '&#51995;',
 "\xA7\x4F" => '&#51996;',
 "\xA7\x50" => '&#51997;',
 "\xA7\x51" => '&#51998;',
 "\xA7\x52" => '&#51999;',
 "\xA7\x53" => '&#52002;',
 "\xA7\x54" => '&#52003;',
 "\xA7\x55" => '&#52004;',
 "\xA7\x56" => '&#52005;',
 "\xA7\x57" => '&#52006;',
 "\xA7\x58" => '&#52007;',
 "\xA7\x59" => '&#52008;',
 "\xA7\x5A" => '&#52009;',
 "\xA7\x61" => '&#52010;',
 "\xA7\x62" => '&#52011;',
 "\xA7\x63" => '&#52012;',
 "\xA7\x64" => '&#52013;',
 "\xA7\x65" => '&#52014;',
 "\xA7\x66" => '&#52015;',
 "\xA7\x67" => '&#52016;',
 "\xA7\x68" => '&#52017;',
 "\xA7\x69" => '&#52018;',
 "\xA7\x6A" => '&#52019;',
 "\xA7\x6B" => '&#52020;',
 "\xA7\x6C" => '&#52021;',
 "\xA7\x6D" => '&#52022;',
 "\xA7\x6E" => '&#52023;',
 "\xA7\x6F" => '&#52024;',
 "\xA7\x70" => '&#52025;',
 "\xA7\x71" => '&#52026;',
 "\xA7\x72" => '&#52027;',
 "\xA7\x73" => '&#52028;',
 "\xA7\x74" => '&#52029;',
 "\xA7\x75" => '&#52030;',
 "\xA7\x76" => '&#52031;',
 "\xA7\x77" => '&#52032;',
 "\xA7\x78" => '&#52034;',
 "\xA7\x79" => '&#52035;',
 "\xA7\x7A" => '&#52036;',
 "\xA7\x81" => '&#52037;',
 "\xA7\x82" => '&#52038;',
 "\xA7\x83" => '&#52039;',
 "\xA7\x84" => '&#52042;',
 "\xA7\x85" => '&#52043;',
 "\xA7\x86" => '&#52045;',
 "\xA7\x87" => '&#52046;',
 "\xA7\x88" => '&#52047;',
 "\xA7\x89" => '&#52049;',
 "\xA7\x8A" => '&#52050;',
 "\xA7\x8B" => '&#52051;',
 "\xA7\x8C" => '&#52052;',
 "\xA7\x8D" => '&#52053;',
 "\xA7\x8E" => '&#52054;',
 "\xA7\x8F" => '&#52055;',
 "\xA7\x90" => '&#52058;',
 "\xA7\x91" => '&#52059;',
 "\xA7\x92" => '&#52060;',
 "\xA7\x93" => '&#52062;',
 "\xA7\x94" => '&#52063;',
 "\xA7\x95" => '&#52064;',
 "\xA7\x96" => '&#52065;',
 "\xA7\x97" => '&#52066;',
 "\xA7\x98" => '&#52067;',
 "\xA7\x99" => '&#52069;',
 "\xA7\x9A" => '&#52070;',
 "\xA7\x9B" => '&#52071;',
 "\xA7\x9C" => '&#52072;',
 "\xA7\x9D" => '&#52073;',
 "\xA7\x9E" => '&#52074;',
 "\xA7\x9F" => '&#52075;',
 "\xA7\xA0" => '&#52076;',
 "\xA7\xA1" => '&#13205;',
 "\xA7\xA2" => '&#13206;',
 "\xA7\xA3" => '&#13207;',
 "\xA7\xA4" => '&#8467;',
 "\xA7\xA5" => '&#13208;',
 "\xA7\xA6" => '&#13252;',
 "\xA7\xA7" => '&#13219;',
 "\xA7\xA8" => '&#13220;',
 "\xA7\xA9" => '&#13221;',
 "\xA7\xAA" => '&#13222;',
 "\xA7\xAB" => '&#13209;',
 "\xA7\xAC" => '&#13210;',
 "\xA7\xAD" => '&#13211;',
 "\xA7\xAE" => '&#13212;',
 "\xA7\xAF" => '&#13213;',
 "\xA7\xB0" => '&#13214;',
 "\xA7\xB1" => '&#13215;',
 "\xA7\xB2" => '&#13216;',
 "\xA7\xB3" => '&#13217;',
 "\xA7\xB4" => '&#13218;',
 "\xA7\xB5" => '&#13258;',
 "\xA7\xB6" => '&#13197;',
 "\xA7\xB7" => '&#13198;',
 "\xA7\xB8" => '&#13199;',
 "\xA7\xB9" => '&#13263;',
 "\xA7\xBA" => '&#13192;',
 "\xA7\xBB" => '&#13193;',
 "\xA7\xBC" => '&#13256;',
 "\xA7\xBD" => '&#13223;',
 "\xA7\xBE" => '&#13224;',
 "\xA7\xBF" => '&#13232;',
 "\xA7\xC0" => '&#13233;',
 "\xA7\xC1" => '&#13234;',
 "\xA7\xC2" => '&#13235;',
 "\xA7\xC3" => '&#13236;',
 "\xA7\xC4" => '&#13237;',
 "\xA7\xC5" => '&#13238;',
 "\xA7\xC6" => '&#13239;',
 "\xA7\xC7" => '&#13240;',
 "\xA7\xC8" => '&#13241;',
 "\xA7\xC9" => '&#13184;',
 "\xA7\xCA" => '&#13185;',
 "\xA7\xCB" => '&#13186;',
 "\xA7\xCC" => '&#13187;',
 "\xA7\xCD" => '&#13188;',
 "\xA7\xCE" => '&#13242;',
 "\xA7\xCF" => '&#13243;',
 "\xA7\xD0" => '&#13244;',
 "\xA7\xD1" => '&#13245;',
 "\xA7\xD2" => '&#13246;',
 "\xA7\xD3" => '&#13247;',
 "\xA7\xD4" => '&#13200;',
 "\xA7\xD5" => '&#13201;',
 "\xA7\xD6" => '&#13202;',
 "\xA7\xD7" => '&#13203;',
 "\xA7\xD8" => '&#13204;',
 "\xA7\xD9" => '&#8486;',
 "\xA7\xDA" => '&#13248;',
 "\xA7\xDB" => '&#13249;',
 "\xA7\xDC" => '&#13194;',
 "\xA7\xDD" => '&#13195;',
 "\xA7\xDE" => '&#13196;',
 "\xA7\xDF" => '&#13270;',
 "\xA7\xE0" => '&#13253;',
 "\xA7\xE1" => '&#13229;',
 "\xA7\xE2" => '&#13230;',
 "\xA7\xE3" => '&#13231;',
 "\xA7\xE4" => '&#13275;',
 "\xA7\xE5" => '&#13225;',
 "\xA7\xE6" => '&#13226;',
 "\xA7\xE7" => '&#13227;',
 "\xA7\xE8" => '&#13228;',
 "\xA7\xE9" => '&#13277;',
 "\xA7\xEA" => '&#13264;',
 "\xA7\xEB" => '&#13267;',
 "\xA7\xEC" => '&#13251;',
 "\xA7\xED" => '&#13257;',
 "\xA7\xEE" => '&#13276;',
 "\xA7\xEF" => '&#13254;',
 "\xA8\x41" => '&#52077;',
 "\xA8\x42" => '&#52078;',
 "\xA8\x43" => '&#52079;',
 "\xA8\x44" => '&#52080;',
 "\xA8\x45" => '&#52081;',
 "\xA8\x46" => '&#52082;',
 "\xA8\x47" => '&#52083;',
 "\xA8\x48" => '&#52084;',
 "\xA8\x49" => '&#52085;',
 "\xA8\x4A" => '&#52086;',
 "\xA8\x4B" => '&#52087;',
 "\xA8\x4C" => '&#52090;',
 "\xA8\x4D" => '&#52091;',
 "\xA8\x4E" => '&#52092;',
 "\xA8\x4F" => '&#52093;',
 "\xA8\x50" => '&#52094;',
 "\xA8\x51" => '&#52095;',
 "\xA8\x52" => '&#52096;',
 "\xA8\x53" => '&#52097;',
 "\xA8\x54" => '&#52098;',
 "\xA8\x55" => '&#52099;',
 "\xA8\x56" => '&#52100;',
 "\xA8\x57" => '&#52101;',
 "\xA8\x58" => '&#52102;',
 "\xA8\x59" => '&#52103;',
 "\xA8\x5A" => '&#52104;',
 "\xA8\x61" => '&#52105;',
 "\xA8\x62" => '&#52106;',
 "\xA8\x63" => '&#52107;',
 "\xA8\x64" => '&#52108;',
 "\xA8\x65" => '&#52109;',
 "\xA8\x66" => '&#52110;',
 "\xA8\x67" => '&#52111;',
 "\xA8\x68" => '&#52112;',
 "\xA8\x69" => '&#52113;',
 "\xA8\x6A" => '&#52114;',
 "\xA8\x6B" => '&#52115;',
 "\xA8\x6C" => '&#52116;',
 "\xA8\x6D" => '&#52117;',
 "\xA8\x6E" => '&#52118;',
 "\xA8\x6F" => '&#52119;',
 "\xA8\x70" => '&#52120;',
 "\xA8\x71" => '&#52121;',
 "\xA8\x72" => '&#52122;',
 "\xA8\x73" => '&#52123;',
 "\xA8\x74" => '&#52125;',
 "\xA8\x75" => '&#52126;',
 "\xA8\x76" => '&#52127;',
 "\xA8\x77" => '&#52128;',
 "\xA8\x78" => '&#52129;',
 "\xA8\x79" => '&#52130;',
 "\xA8\x7A" => '&#52131;',
 "\xA8\x81" => '&#52132;',
 "\xA8\x82" => '&#52133;',
 "\xA8\x83" => '&#52134;',
 "\xA8\x84" => '&#52135;',
 "\xA8\x85" => '&#52136;',
 "\xA8\x86" => '&#52137;',
 "\xA8\x87" => '&#52138;',
 "\xA8\x88" => '&#52139;',
 "\xA8\x89" => '&#52140;',
 "\xA8\x8A" => '&#52141;',
 "\xA8\x8B" => '&#52142;',
 "\xA8\x8C" => '&#52143;',
 "\xA8\x8D" => '&#52144;',
 "\xA8\x8E" => '&#52145;',
 "\xA8\x8F" => '&#52146;',
 "\xA8\x90" => '&#52147;',
 "\xA8\x91" => '&#52148;',
 "\xA8\x92" => '&#52149;',
 "\xA8\x93" => '&#52150;',
 "\xA8\x94" => '&#52151;',
 "\xA8\x95" => '&#52153;',
 "\xA8\x96" => '&#52154;',
 "\xA8\x97" => '&#52155;',
 "\xA8\x98" => '&#52156;',
 "\xA8\x99" => '&#52157;',
 "\xA8\x9A" => '&#52158;',
 "\xA8\x9B" => '&#52159;',
 "\xA8\x9C" => '&#52160;',
 "\xA8\x9D" => '&#52161;',
 "\xA8\x9E" => '&#52162;',
 "\xA8\x9F" => '&#52163;',
 "\xA8\xA0" => '&#52164;',
 "\xA8\xA1" => '&#198;',
 "\xA8\xA2" => '&#208;',
 "\xA8\xA3" => '&#170;',
 "\xA8\xA4" => '&#294;',
 "\xA8\xA6" => '&#306;',
 "\xA8\xA8" => '&#319;',
 "\xA8\xA9" => '&#321;',
 "\xA8\xAA" => '&#216;',
 "\xA8\xAB" => '&#338;',
 "\xA8\xAC" => '&#186;',
 "\xA8\xAD" => '&#222;',
 "\xA8\xAE" => '&#358;',
 "\xA8\xAF" => '&#330;',
 "\xA8\xB1" => '&#12896;',
 "\xA8\xB2" => '&#12897;',
 "\xA8\xB3" => '&#12898;',
 "\xA8\xB4" => '&#12899;',
 "\xA8\xB5" => '&#12900;',
 "\xA8\xB6" => '&#12901;',
 "\xA8\xB7" => '&#12902;',
 "\xA8\xB8" => '&#12903;',
 "\xA8\xB9" => '&#12904;',
 "\xA8\xBA" => '&#12905;',
 "\xA8\xBB" => '&#12906;',
 "\xA8\xBC" => '&#12907;',
 "\xA8\xBD" => '&#12908;',
 "\xA8\xBE" => '&#12909;',
 "\xA8\xBF" => '&#12910;',
 "\xA8\xC0" => '&#12911;',
 "\xA8\xC1" => '&#12912;',
 "\xA8\xC2" => '&#12913;',
 "\xA8\xC3" => '&#12914;',
 "\xA8\xC4" => '&#12915;',
 "\xA8\xC5" => '&#12916;',
 "\xA8\xC6" => '&#12917;',
 "\xA8\xC7" => '&#12918;',
 "\xA8\xC8" => '&#12919;',
 "\xA8\xC9" => '&#12920;',
 "\xA8\xCA" => '&#12921;',
 "\xA8\xCB" => '&#12922;',
 "\xA8\xCC" => '&#12923;',
 "\xA8\xCD" => '&#9424;',
 "\xA8\xCE" => '&#9425;',
 "\xA8\xCF" => '&#9426;',
 "\xA8\xD0" => '&#9427;',
 "\xA8\xD1" => '&#9428;',
 "\xA8\xD2" => '&#9429;',
 "\xA8\xD3" => '&#9430;',
 "\xA8\xD4" => '&#9431;',
 "\xA8\xD5" => '&#9432;',
 "\xA8\xD6" => '&#9433;',
 "\xA8\xD7" => '&#9434;',
 "\xA8\xD8" => '&#9435;',
 "\xA8\xD9" => '&#9436;',
 "\xA8\xDA" => '&#9437;',
 "\xA8\xDB" => '&#9438;',
 "\xA8\xDC" => '&#9439;',
 "\xA8\xDD" => '&#9440;',
 "\xA8\xDE" => '&#9441;',
 "\xA8\xDF" => '&#9442;',
 "\xA8\xE0" => '&#9443;',
 "\xA8\xE1" => '&#9444;',
 "\xA8\xE2" => '&#9445;',
 "\xA8\xE3" => '&#9446;',
 "\xA8\xE4" => '&#9447;',
 "\xA8\xE5" => '&#9448;',
 "\xA8\xE6" => '&#9449;',
 "\xA8\xE7" => '&#9312;',
 "\xA8\xE8" => '&#9313;',
 "\xA8\xE9" => '&#9314;',
 "\xA8\xEA" => '&#9315;',
 "\xA8\xEB" => '&#9316;',
 "\xA8\xEC" => '&#9317;',
 "\xA8\xED" => '&#9318;',
 "\xA8\xEE" => '&#9319;',
 "\xA8\xEF" => '&#9320;',
 "\xA8\xF0" => '&#9321;',
 "\xA8\xF1" => '&#9322;',
 "\xA8\xF2" => '&#9323;',
 "\xA8\xF3" => '&#9324;',
 "\xA8\xF4" => '&#9325;',
 "\xA8\xF5" => '&#9326;',
 "\xA8\xF6" => '&#189;',
 "\xA8\xF7" => '&#8531;',
 "\xA8\xF8" => '&#8532;',
 "\xA8\xF9" => '&#188;',
 "\xA8\xFA" => '&#190;',
 "\xA8\xFB" => '&#8539;',
 "\xA8\xFC" => '&#8540;',
 "\xA8\xFD" => '&#8541;',
 "\xA8\xFE" => '&#8542;',
 "\xA9\x41" => '&#52165;',
 "\xA9\x42" => '&#52166;',
 "\xA9\x43" => '&#52167;',
 "\xA9\x44" => '&#52168;',
 "\xA9\x45" => '&#52169;',
 "\xA9\x46" => '&#52170;',
 "\xA9\x47" => '&#52171;',
 "\xA9\x48" => '&#52172;',
 "\xA9\x49" => '&#52173;',
 "\xA9\x4A" => '&#52174;',
 "\xA9\x4B" => '&#52175;',
 "\xA9\x4C" => '&#52176;',
 "\xA9\x4D" => '&#52177;',
 "\xA9\x4E" => '&#52178;',
 "\xA9\x4F" => '&#52179;',
 "\xA9\x50" => '&#52181;',
 "\xA9\x51" => '&#52182;',
 "\xA9\x52" => '&#52183;',
 "\xA9\x53" => '&#52184;',
 "\xA9\x54" => '&#52185;',
 "\xA9\x55" => '&#52186;',
 "\xA9\x56" => '&#52187;',
 "\xA9\x57" => '&#52188;',
 "\xA9\x58" => '&#52189;',
 "\xA9\x59" => '&#52190;',
 "\xA9\x5A" => '&#52191;',
 "\xA9\x61" => '&#52192;',
 "\xA9\x62" => '&#52193;',
 "\xA9\x63" => '&#52194;',
 "\xA9\x64" => '&#52195;',
 "\xA9\x65" => '&#52197;',
 "\xA9\x66" => '&#52198;',
 "\xA9\x67" => '&#52200;',
 "\xA9\x68" => '&#52202;',
 "\xA9\x69" => '&#52203;',
 "\xA9\x6A" => '&#52204;',
 "\xA9\x6B" => '&#52205;',
 "\xA9\x6C" => '&#52206;',
 "\xA9\x6D" => '&#52207;',
 "\xA9\x6E" => '&#52208;',
 "\xA9\x6F" => '&#52209;',
 "\xA9\x70" => '&#52210;',
 "\xA9\x71" => '&#52211;',
 "\xA9\x72" => '&#52212;',
 "\xA9\x73" => '&#52213;',
 "\xA9\x74" => '&#52214;',
 "\xA9\x75" => '&#52215;',
 "\xA9\x76" => '&#52216;',
 "\xA9\x77" => '&#52217;',
 "\xA9\x78" => '&#52218;',
 "\xA9\x79" => '&#52219;',
 "\xA9\x7A" => '&#52220;',
 "\xA9\x81" => '&#52221;',
 "\xA9\x82" => '&#52222;',
 "\xA9\x83" => '&#52223;',
 "\xA9\x84" => '&#52224;',
 "\xA9\x85" => '&#52225;',
 "\xA9\x86" => '&#52226;',
 "\xA9\x87" => '&#52227;',
 "\xA9\x88" => '&#52228;',
 "\xA9\x89" => '&#52229;',
 "\xA9\x8A" => '&#52230;',
 "\xA9\x8B" => '&#52231;',
 "\xA9\x8C" => '&#52232;',
 "\xA9\x8D" => '&#52233;',
 "\xA9\x8E" => '&#52234;',
 "\xA9\x8F" => '&#52235;',
 "\xA9\x90" => '&#52238;',
 "\xA9\x91" => '&#52239;',
 "\xA9\x92" => '&#52241;',
 "\xA9\x93" => '&#52242;',
 "\xA9\x94" => '&#52243;',
 "\xA9\x95" => '&#52245;',
 "\xA9\x96" => '&#52246;',
 "\xA9\x97" => '&#52247;',
 "\xA9\x98" => '&#52248;',
 "\xA9\x99" => '&#52249;',
 "\xA9\x9A" => '&#52250;',
 "\xA9\x9B" => '&#52251;',
 "\xA9\x9C" => '&#52254;',
 "\xA9\x9D" => '&#52255;',
 "\xA9\x9E" => '&#52256;',
 "\xA9\x9F" => '&#52259;',
 "\xA9\xA0" => '&#52260;',
 "\xA9\xA1" => '&#230;',
 "\xA9\xA2" => '&#273;',
 "\xA9\xA3" => '&#240;',
 "\xA9\xA4" => '&#295;',
 "\xA9\xA5" => '&#305;',
 "\xA9\xA6" => '&#307;',
 "\xA9\xA7" => '&#312;',
 "\xA9\xA8" => '&#320;',
 "\xA9\xA9" => '&#322;',
 "\xA9\xAA" => '&#248;',
 "\xA9\xAB" => '&#339;',
 "\xA9\xAC" => '&#223;',
 "\xA9\xAD" => '&#254;',
 "\xA9\xAE" => '&#359;',
 "\xA9\xAF" => '&#331;',
 "\xA9\xB0" => '&#329;',
 "\xA9\xB1" => '&#12800;',
 "\xA9\xB2" => '&#12801;',
 "\xA9\xB3" => '&#12802;',
 "\xA9\xB4" => '&#12803;',
 "\xA9\xB5" => '&#12804;',
 "\xA9\xB6" => '&#12805;',
 "\xA9\xB7" => '&#12806;',
 "\xA9\xB8" => '&#12807;',
 "\xA9\xB9" => '&#12808;',
 "\xA9\xBA" => '&#12809;',
 "\xA9\xBB" => '&#12810;',
 "\xA9\xBC" => '&#12811;',
 "\xA9\xBD" => '&#12812;',
 "\xA9\xBE" => '&#12813;',
 "\xA9\xBF" => '&#12814;',
 "\xA9\xC0" => '&#12815;',
 "\xA9\xC1" => '&#12816;',
 "\xA9\xC2" => '&#12817;',
 "\xA9\xC3" => '&#12818;',
 "\xA9\xC4" => '&#12819;',
 "\xA9\xC5" => '&#12820;',
 "\xA9\xC6" => '&#12821;',
 "\xA9\xC7" => '&#12822;',
 "\xA9\xC8" => '&#12823;',
 "\xA9\xC9" => '&#12824;',
 "\xA9\xCA" => '&#12825;',
 "\xA9\xCB" => '&#12826;',
 "\xA9\xCC" => '&#12827;',
 "\xA9\xCD" => '&#9372;',
 "\xA9\xCE" => '&#9373;',
 "\xA9\xCF" => '&#9374;',
 "\xA9\xD0" => '&#9375;',
 "\xA9\xD1" => '&#9376;',
 "\xA9\xD2" => '&#9377;',
 "\xA9\xD3" => '&#9378;',
 "\xA9\xD4" => '&#9379;',
 "\xA9\xD5" => '&#9380;',
 "\xA9\xD6" => '&#9381;',
 "\xA9\xD7" => '&#9382;',
 "\xA9\xD8" => '&#9383;',
 "\xA9\xD9" => '&#9384;',
 "\xA9\xDA" => '&#9385;',
 "\xA9\xDB" => '&#9386;',
 "\xA9\xDC" => '&#9387;',
 "\xA9\xDD" => '&#9388;',
 "\xA9\xDE" => '&#9389;',
 "\xA9\xDF" => '&#9390;',
 "\xA9\xE0" => '&#9391;',
 "\xA9\xE1" => '&#9392;',
 "\xA9\xE2" => '&#9393;',
 "\xA9\xE3" => '&#9394;',
 "\xA9\xE4" => '&#9395;',
 "\xA9\xE5" => '&#9396;',
 "\xA9\xE6" => '&#9397;',
 "\xA9\xE7" => '&#9332;',
 "\xA9\xE8" => '&#9333;',
 "\xA9\xE9" => '&#9334;',
 "\xA9\xEA" => '&#9335;',
 "\xA9\xEB" => '&#9336;',
 "\xA9\xEC" => '&#9337;',
 "\xA9\xED" => '&#9338;',
 "\xA9\xEE" => '&#9339;',
 "\xA9\xEF" => '&#9340;',
 "\xA9\xF0" => '&#9341;',
 "\xA9\xF1" => '&#9342;',
 "\xA9\xF2" => '&#9343;',
 "\xA9\xF3" => '&#9344;',
 "\xA9\xF4" => '&#9345;',
 "\xA9\xF5" => '&#9346;',
 "\xA9\xF6" => '&#185;',
 "\xA9\xF7" => '&#178;',
 "\xA9\xF8" => '&#179;',
 "\xA9\xF9" => '&#8308;',
 "\xA9\xFA" => '&#8319;',
 "\xA9\xFB" => '&#8321;',
 "\xA9\xFC" => '&#8322;',
 "\xA9\xFD" => '&#8323;',
 "\xA9\xFE" => '&#8324;',
 "\xAA\x41" => '&#52261;',
 "\xAA\x42" => '&#52262;',
 "\xAA\x43" => '&#52266;',
 "\xAA\x44" => '&#52267;',
 "\xAA\x45" => '&#52269;',
 "\xAA\x46" => '&#52271;',
 "\xAA\x47" => '&#52273;',
 "\xAA\x48" => '&#52274;',
 "\xAA\x49" => '&#52275;',
 "\xAA\x4A" => '&#52276;',
 "\xAA\x4B" => '&#52277;',
 "\xAA\x4C" => '&#52278;',
 "\xAA\x4D" => '&#52279;',
 "\xAA\x4E" => '&#52282;',
 "\xAA\x4F" => '&#52287;',
 "\xAA\x50" => '&#52288;',
 "\xAA\x51" => '&#52289;',
 "\xAA\x52" => '&#52290;',
 "\xAA\x53" => '&#52291;',
 "\xAA\x54" => '&#52294;',
 "\xAA\x55" => '&#52295;',
 "\xAA\x56" => '&#52297;',
 "\xAA\x57" => '&#52298;',
 "\xAA\x58" => '&#52299;',
 "\xAA\x59" => '&#52301;',
 "\xAA\x5A" => '&#52302;',
 "\xAA\x61" => '&#52303;',
 "\xAA\x62" => '&#52304;',
 "\xAA\x63" => '&#52305;',
 "\xAA\x64" => '&#52306;',
 "\xAA\x65" => '&#52307;',
 "\xAA\x66" => '&#52310;',
 "\xAA\x67" => '&#52314;',
 "\xAA\x68" => '&#52315;',
 "\xAA\x69" => '&#52316;',
 "\xAA\x6A" => '&#52317;',
 "\xAA\x6B" => '&#52318;',
 "\xAA\x6C" => '&#52319;',
 "\xAA\x6D" => '&#52321;',
 "\xAA\x6E" => '&#52322;',
 "\xAA\x6F" => '&#52323;',
 "\xAA\x70" => '&#52325;',
 "\xAA\x71" => '&#52327;',
 "\xAA\x72" => '&#52329;',
 "\xAA\x73" => '&#52330;',
 "\xAA\x74" => '&#52331;',
 "\xAA\x75" => '&#52332;',
 "\xAA\x76" => '&#52333;',
 "\xAA\x77" => '&#52334;',
 "\xAA\x78" => '&#52335;',
 "\xAA\x79" => '&#52337;',
 "\xAA\x7A" => '&#52338;',
 "\xAA\x81" => '&#52339;',
 "\xAA\x82" => '&#52340;',
 "\xAA\x83" => '&#52342;',
 "\xAA\x84" => '&#52343;',
 "\xAA\x85" => '&#52344;',
 "\xAA\x86" => '&#52345;',
 "\xAA\x87" => '&#52346;',
 "\xAA\x88" => '&#52347;',
 "\xAA\x89" => '&#52348;',
 "\xAA\x8A" => '&#52349;',
 "\xAA\x8B" => '&#52350;',
 "\xAA\x8C" => '&#52351;',
 "\xAA\x8D" => '&#52352;',
 "\xAA\x8E" => '&#52353;',
 "\xAA\x8F" => '&#52354;',
 "\xAA\x90" => '&#52355;',
 "\xAA\x91" => '&#52356;',
 "\xAA\x92" => '&#52357;',
 "\xAA\x93" => '&#52358;',
 "\xAA\x94" => '&#52359;',
 "\xAA\x95" => '&#52360;',
 "\xAA\x96" => '&#52361;',
 "\xAA\x97" => '&#52362;',
 "\xAA\x98" => '&#52363;',
 "\xAA\x99" => '&#52364;',
 "\xAA\x9A" => '&#52365;',
 "\xAA\x9B" => '&#52366;',
 "\xAA\x9C" => '&#52367;',
 "\xAA\x9D" => '&#52368;',
 "\xAA\x9E" => '&#52369;',
 "\xAA\x9F" => '&#52370;',
 "\xAA\xA0" => '&#52371;',
 "\xAA\xA1" => '&#12353;',
 "\xAA\xA2" => '&#12354;',
 "\xAA\xA3" => '&#12355;',
 "\xAA\xA4" => '&#12356;',
 "\xAA\xA5" => '&#12357;',
 "\xAA\xA6" => '&#12358;',
 "\xAA\xA7" => '&#12359;',
 "\xAA\xA8" => '&#12360;',
 "\xAA\xA9" => '&#12361;',
 "\xAA\xAA" => '&#12362;',
 "\xAA\xAB" => '&#12363;',
 "\xAA\xAC" => '&#12364;',
 "\xAA\xAD" => '&#12365;',
 "\xAA\xAE" => '&#12366;',
 "\xAA\xAF" => '&#12367;',
 "\xAA\xB0" => '&#12368;',
 "\xAA\xB1" => '&#12369;',
 "\xAA\xB2" => '&#12370;',
 "\xAA\xB3" => '&#12371;',
 "\xAA\xB4" => '&#12372;',
 "\xAA\xB5" => '&#12373;',
 "\xAA\xB6" => '&#12374;',
 "\xAA\xB7" => '&#12375;',
 "\xAA\xB8" => '&#12376;',
 "\xAA\xB9" => '&#12377;',
 "\xAA\xBA" => '&#12378;',
 "\xAA\xBB" => '&#12379;',
 "\xAA\xBC" => '&#12380;',
 "\xAA\xBD" => '&#12381;',
 "\xAA\xBE" => '&#12382;',
 "\xAA\xBF" => '&#12383;',
 "\xAA\xC0" => '&#12384;',
 "\xAA\xC1" => '&#12385;',
 "\xAA\xC2" => '&#12386;',
 "\xAA\xC3" => '&#12387;',
 "\xAA\xC4" => '&#12388;',
 "\xAA\xC5" => '&#12389;',
 "\xAA\xC6" => '&#12390;',
 "\xAA\xC7" => '&#12391;',
 "\xAA\xC8" => '&#12392;',
 "\xAA\xC9" => '&#12393;',
 "\xAA\xCA" => '&#12394;',
 "\xAA\xCB" => '&#12395;',
 "\xAA\xCC" => '&#12396;',
 "\xAA\xCD" => '&#12397;',
 "\xAA\xCE" => '&#12398;',
 "\xAA\xCF" => '&#12399;',
 "\xAA\xD0" => '&#12400;',
 "\xAA\xD1" => '&#12401;',
 "\xAA\xD2" => '&#12402;',
 "\xAA\xD3" => '&#12403;',
 "\xAA\xD4" => '&#12404;',
 "\xAA\xD5" => '&#12405;',
 "\xAA\xD6" => '&#12406;',
 "\xAA\xD7" => '&#12407;',
 "\xAA\xD8" => '&#12408;',
 "\xAA\xD9" => '&#12409;',
 "\xAA\xDA" => '&#12410;',
 "\xAA\xDB" => '&#12411;',
 "\xAA\xDC" => '&#12412;',
 "\xAA\xDD" => '&#12413;',
 "\xAA\xDE" => '&#12414;',
 "\xAA\xDF" => '&#12415;',
 "\xAA\xE0" => '&#12416;',
 "\xAA\xE1" => '&#12417;',
 "\xAA\xE2" => '&#12418;',
 "\xAA\xE3" => '&#12419;',
 "\xAA\xE4" => '&#12420;',
 "\xAA\xE5" => '&#12421;',
 "\xAA\xE6" => '&#12422;',
 "\xAA\xE7" => '&#12423;',
 "\xAA\xE8" => '&#12424;',
 "\xAA\xE9" => '&#12425;',
 "\xAA\xEA" => '&#12426;',
 "\xAA\xEB" => '&#12427;',
 "\xAA\xEC" => '&#12428;',
 "\xAA\xED" => '&#12429;',
 "\xAA\xEE" => '&#12430;',
 "\xAA\xEF" => '&#12431;',
 "\xAA\xF0" => '&#12432;',
 "\xAA\xF1" => '&#12433;',
 "\xAA\xF2" => '&#12434;',
 "\xAA\xF3" => '&#12435;',
 "\xAB\x41" => '&#52372;',
 "\xAB\x42" => '&#52373;',
 "\xAB\x43" => '&#52374;',
 "\xAB\x44" => '&#52375;',
 "\xAB\x45" => '&#52378;',
 "\xAB\x46" => '&#52379;',
 "\xAB\x47" => '&#52381;',
 "\xAB\x48" => '&#52382;',
 "\xAB\x49" => '&#52383;',
 "\xAB\x4A" => '&#52385;',
 "\xAB\x4B" => '&#52386;',
 "\xAB\x4C" => '&#52387;',
 "\xAB\x4D" => '&#52388;',
 "\xAB\x4E" => '&#52389;',
 "\xAB\x4F" => '&#52390;',
 "\xAB\x50" => '&#52391;',
 "\xAB\x51" => '&#52394;',
 "\xAB\x52" => '&#52398;',
 "\xAB\x53" => '&#52399;',
 "\xAB\x54" => '&#52400;',
 "\xAB\x55" => '&#52401;',
 "\xAB\x56" => '&#52402;',
 "\xAB\x57" => '&#52403;',
 "\xAB\x58" => '&#52406;',
 "\xAB\x59" => '&#52407;',
 "\xAB\x5A" => '&#52409;',
 "\xAB\x61" => '&#52410;',
 "\xAB\x62" => '&#52411;',
 "\xAB\x63" => '&#52413;',
 "\xAB\x64" => '&#52414;',
 "\xAB\x65" => '&#52415;',
 "\xAB\x66" => '&#52416;',
 "\xAB\x67" => '&#52417;',
 "\xAB\x68" => '&#52418;',
 "\xAB\x69" => '&#52419;',
 "\xAB\x6A" => '&#52422;',
 "\xAB\x6B" => '&#52424;',
 "\xAB\x6C" => '&#52426;',
 "\xAB\x6D" => '&#52427;',
 "\xAB\x6E" => '&#52428;',
 "\xAB\x6F" => '&#52429;',
 "\xAB\x70" => '&#52430;',
 "\xAB\x71" => '&#52431;',
 "\xAB\x72" => '&#52433;',
 "\xAB\x73" => '&#52434;',
 "\xAB\x74" => '&#52435;',
 "\xAB\x75" => '&#52437;',
 "\xAB\x76" => '&#52438;',
 "\xAB\x77" => '&#52439;',
 "\xAB\x78" => '&#52440;',
 "\xAB\x79" => '&#52441;',
 "\xAB\x7A" => '&#52442;',
 "\xAB\x81" => '&#52443;',
 "\xAB\x82" => '&#52444;',
 "\xAB\x83" => '&#52445;',
 "\xAB\x84" => '&#52446;',
 "\xAB\x85" => '&#52447;',
 "\xAB\x86" => '&#52448;',
 "\xAB\x87" => '&#52449;',
 "\xAB\x88" => '&#52450;',
 "\xAB\x89" => '&#52451;',
 "\xAB\x8A" => '&#52453;',
 "\xAB\x8B" => '&#52454;',
 "\xAB\x8C" => '&#52455;',
 "\xAB\x8D" => '&#52456;',
 "\xAB\x8E" => '&#52457;',
 "\xAB\x8F" => '&#52458;',
 "\xAB\x90" => '&#52459;',
 "\xAB\x91" => '&#52461;',
 "\xAB\x92" => '&#52462;',
 "\xAB\x93" => '&#52463;',
 "\xAB\x94" => '&#52465;',
 "\xAB\x95" => '&#52466;',
 "\xAB\x96" => '&#52467;',
 "\xAB\x97" => '&#52468;',
 "\xAB\x98" => '&#52469;',
 "\xAB\x99" => '&#52470;',
 "\xAB\x9A" => '&#52471;',
 "\xAB\x9B" => '&#52472;',
 "\xAB\x9C" => '&#52473;',
 "\xAB\x9D" => '&#52474;',
 "\xAB\x9E" => '&#52475;',
 "\xAB\x9F" => '&#52476;',
 "\xAB\xA0" => '&#52477;',
 "\xAB\xA1" => '&#12449;',
 "\xAB\xA2" => '&#12450;',
 "\xAB\xA3" => '&#12451;',
 "\xAB\xA4" => '&#12452;',
 "\xAB\xA5" => '&#12453;',
 "\xAB\xA6" => '&#12454;',
 "\xAB\xA7" => '&#12455;',
 "\xAB\xA8" => '&#12456;',
 "\xAB\xA9" => '&#12457;',
 "\xAB\xAA" => '&#12458;',
 "\xAB\xAB" => '&#12459;',
 "\xAB\xAC" => '&#12460;',
 "\xAB\xAD" => '&#12461;',
 "\xAB\xAE" => '&#12462;',
 "\xAB\xAF" => '&#12463;',
 "\xAB\xB0" => '&#12464;',
 "\xAB\xB1" => '&#12465;',
 "\xAB\xB2" => '&#12466;',
 "\xAB\xB3" => '&#12467;',
 "\xAB\xB4" => '&#12468;',
 "\xAB\xB5" => '&#12469;',
 "\xAB\xB6" => '&#12470;',
 "\xAB\xB7" => '&#12471;',
 "\xAB\xB8" => '&#12472;',
 "\xAB\xB9" => '&#12473;',
 "\xAB\xBA" => '&#12474;',
 "\xAB\xBB" => '&#12475;',
 "\xAB\xBC" => '&#12476;',
 "\xAB\xBD" => '&#12477;',
 "\xAB\xBE" => '&#12478;',
 "\xAB\xBF" => '&#12479;',
 "\xAB\xC0" => '&#12480;',
 "\xAB\xC1" => '&#12481;',
 "\xAB\xC2" => '&#12482;',
 "\xAB\xC3" => '&#12483;',
 "\xAB\xC4" => '&#12484;',
 "\xAB\xC5" => '&#12485;',
 "\xAB\xC6" => '&#12486;',
 "\xAB\xC7" => '&#12487;',
 "\xAB\xC8" => '&#12488;',
 "\xAB\xC9" => '&#12489;',
 "\xAB\xCA" => '&#12490;',
 "\xAB\xCB" => '&#12491;',
 "\xAB\xCC" => '&#12492;',
 "\xAB\xCD" => '&#12493;',
 "\xAB\xCE" => '&#12494;',
 "\xAB\xCF" => '&#12495;',
 "\xAB\xD0" => '&#12496;',
 "\xAB\xD1" => '&#12497;',
 "\xAB\xD2" => '&#12498;',
 "\xAB\xD3" => '&#12499;',
 "\xAB\xD4" => '&#12500;',
 "\xAB\xD5" => '&#12501;',
 "\xAB\xD6" => '&#12502;',
 "\xAB\xD7" => '&#12503;',
 "\xAB\xD8" => '&#12504;',
 "\xAB\xD9" => '&#12505;',
 "\xAB\xDA" => '&#12506;',
 "\xAB\xDB" => '&#12507;',
 "\xAB\xDC" => '&#12508;',
 "\xAB\xDD" => '&#12509;',
 "\xAB\xDE" => '&#12510;',
 "\xAB\xDF" => '&#12511;',
 "\xAB\xE0" => '&#12512;',
 "\xAB\xE1" => '&#12513;',
 "\xAB\xE2" => '&#12514;',
 "\xAB\xE3" => '&#12515;',
 "\xAB\xE4" => '&#12516;',
 "\xAB\xE5" => '&#12517;',
 "\xAB\xE6" => '&#12518;',
 "\xAB\xE7" => '&#12519;',
 "\xAB\xE8" => '&#12520;',
 "\xAB\xE9" => '&#12521;',
 "\xAB\xEA" => '&#12522;',
 "\xAB\xEB" => '&#12523;',
 "\xAB\xEC" => '&#12524;',
 "\xAB\xED" => '&#12525;',
 "\xAB\xEE" => '&#12526;',
 "\xAB\xEF" => '&#12527;',
 "\xAB\xF0" => '&#12528;',
 "\xAB\xF1" => '&#12529;',
 "\xAB\xF2" => '&#12530;',
 "\xAB\xF3" => '&#12531;',
 "\xAB\xF4" => '&#12532;',
 "\xAB\xF5" => '&#12533;',
 "\xAB\xF6" => '&#12534;',
 "\xAC\x41" => '&#52478;',
 "\xAC\x42" => '&#52479;',
 "\xAC\x43" => '&#52480;',
 "\xAC\x44" => '&#52482;',
 "\xAC\x45" => '&#52483;',
 "\xAC\x46" => '&#52484;',
 "\xAC\x47" => '&#52485;',
 "\xAC\x48" => '&#52486;',
 "\xAC\x49" => '&#52487;',
 "\xAC\x4A" => '&#52490;',
 "\xAC\x4B" => '&#52491;',
 "\xAC\x4C" => '&#52493;',
 "\xAC\x4D" => '&#52494;',
 "\xAC\x4E" => '&#52495;',
 "\xAC\x4F" => '&#52497;',
 "\xAC\x50" => '&#52498;',
 "\xAC\x51" => '&#52499;',
 "\xAC\x52" => '&#52500;',
 "\xAC\x53" => '&#52501;',
 "\xAC\x54" => '&#52502;',
 "\xAC\x55" => '&#52503;',
 "\xAC\x56" => '&#52506;',
 "\xAC\x57" => '&#52508;',
 "\xAC\x58" => '&#52510;',
 "\xAC\x59" => '&#52511;',
 "\xAC\x5A" => '&#52512;',
 "\xAC\x61" => '&#52513;',
 "\xAC\x62" => '&#52514;',
 "\xAC\x63" => '&#52515;',
 "\xAC\x64" => '&#52517;',
 "\xAC\x65" => '&#52518;',
 "\xAC\x66" => '&#52519;',
 "\xAC\x67" => '&#52521;',
 "\xAC\x68" => '&#52522;',
 "\xAC\x69" => '&#52523;',
 "\xAC\x6A" => '&#52525;',
 "\xAC\x6B" => '&#52526;',
 "\xAC\x6C" => '&#52527;',
 "\xAC\x6D" => '&#52528;',
 "\xAC\x6E" => '&#52529;',
 "\xAC\x6F" => '&#52530;',
 "\xAC\x70" => '&#52531;',
 "\xAC\x71" => '&#52532;',
 "\xAC\x72" => '&#52533;',
 "\xAC\x73" => '&#52534;',
 "\xAC\x74" => '&#52535;',
 "\xAC\x75" => '&#52536;',
 "\xAC\x76" => '&#52538;',
 "\xAC\x77" => '&#52539;',
 "\xAC\x78" => '&#52540;',
 "\xAC\x79" => '&#52541;',
 "\xAC\x7A" => '&#52542;',
 "\xAC\x81" => '&#52543;',
 "\xAC\x82" => '&#52544;',
 "\xAC\x83" => '&#52545;',
 "\xAC\x84" => '&#52546;',
 "\xAC\x85" => '&#52547;',
 "\xAC\x86" => '&#52548;',
 "\xAC\x87" => '&#52549;',
 "\xAC\x88" => '&#52550;',
 "\xAC\x89" => '&#52551;',
 "\xAC\x8A" => '&#52552;',
 "\xAC\x8B" => '&#52553;',
 "\xAC\x8C" => '&#52554;',
 "\xAC\x8D" => '&#52555;',
 "\xAC\x8E" => '&#52556;',
 "\xAC\x8F" => '&#52557;',
 "\xAC\x90" => '&#52558;',
 "\xAC\x91" => '&#52559;',
 "\xAC\x92" => '&#52560;',
 "\xAC\x93" => '&#52561;',
 "\xAC\x94" => '&#52562;',
 "\xAC\x95" => '&#52563;',
 "\xAC\x96" => '&#52564;',
 "\xAC\x97" => '&#52565;',
 "\xAC\x98" => '&#52566;',
 "\xAC\x99" => '&#52567;',
 "\xAC\x9A" => '&#52568;',
 "\xAC\x9B" => '&#52569;',
 "\xAC\x9C" => '&#52570;',
 "\xAC\x9D" => '&#52571;',
 "\xAC\x9E" => '&#52573;',
 "\xAC\x9F" => '&#52574;',
 "\xAC\xA0" => '&#52575;',
 "\xAC\xA1" => '&#1040;',
 "\xAC\xA2" => '&#1041;',
 "\xAC\xA3" => '&#1042;',
 "\xAC\xA4" => '&#1043;',
 "\xAC\xA5" => '&#1044;',
 "\xAC\xA6" => '&#1045;',
 "\xAC\xA7" => '&#1025;',
 "\xAC\xA8" => '&#1046;',
 "\xAC\xA9" => '&#1047;',
 "\xAC\xAA" => '&#1048;',
 "\xAC\xAB" => '&#1049;',
 "\xAC\xAC" => '&#1050;',
 "\xAC\xAD" => '&#1051;',
 "\xAC\xAE" => '&#1052;',
 "\xAC\xAF" => '&#1053;',
 "\xAC\xB0" => '&#1054;',
 "\xAC\xB1" => '&#1055;',
 "\xAC\xB2" => '&#1056;',
 "\xAC\xB3" => '&#1057;',
 "\xAC\xB4" => '&#1058;',
 "\xAC\xB5" => '&#1059;',
 "\xAC\xB6" => '&#1060;',
 "\xAC\xB7" => '&#1061;',
 "\xAC\xB8" => '&#1062;',
 "\xAC\xB9" => '&#1063;',
 "\xAC\xBA" => '&#1064;',
 "\xAC\xBB" => '&#1065;',
 "\xAC\xBC" => '&#1066;',
 "\xAC\xBD" => '&#1067;',
 "\xAC\xBE" => '&#1068;',
 "\xAC\xBF" => '&#1069;',
 "\xAC\xC0" => '&#1070;',
 "\xAC\xC1" => '&#1071;',
 "\xAC\xD1" => '&#1072;',
 "\xAC\xD2" => '&#1073;',
 "\xAC\xD3" => '&#1074;',
 "\xAC\xD4" => '&#1075;',
 "\xAC\xD5" => '&#1076;',
 "\xAC\xD6" => '&#1077;',
 "\xAC\xD7" => '&#1105;',
 "\xAC\xD8" => '&#1078;',
 "\xAC\xD9" => '&#1079;',
 "\xAC\xDA" => '&#1080;',
 "\xAC\xDB" => '&#1081;',
 "\xAC\xDC" => '&#1082;',
 "\xAC\xDD" => '&#1083;',
 "\xAC\xDE" => '&#1084;',
 "\xAC\xDF" => '&#1085;',
 "\xAC\xE0" => '&#1086;',
 "\xAC\xE1" => '&#1087;',
 "\xAC\xE2" => '&#1088;',
 "\xAC\xE3" => '&#1089;',
 "\xAC\xE4" => '&#1090;',
 "\xAC\xE5" => '&#1091;',
 "\xAC\xE6" => '&#1092;',
 "\xAC\xE7" => '&#1093;',
 "\xAC\xE8" => '&#1094;',
 "\xAC\xE9" => '&#1095;',
 "\xAC\xEA" => '&#1096;',
 "\xAC\xEB" => '&#1097;',
 "\xAC\xEC" => '&#1098;',
 "\xAC\xED" => '&#1099;',
 "\xAC\xEE" => '&#1100;',
 "\xAC\xEF" => '&#1101;',
 "\xAC\xF0" => '&#1102;',
 "\xAC\xF1" => '&#1103;',
 "\xAD\x41" => '&#52577;',
 "\xAD\x42" => '&#52578;',
 "\xAD\x43" => '&#52579;',
 "\xAD\x44" => '&#52581;',
 "\xAD\x45" => '&#52582;',
 "\xAD\x46" => '&#52583;',
 "\xAD\x47" => '&#52584;',
 "\xAD\x48" => '&#52585;',
 "\xAD\x49" => '&#52586;',
 "\xAD\x4A" => '&#52587;',
 "\xAD\x4B" => '&#52590;',
 "\xAD\x4C" => '&#52592;',
 "\xAD\x4D" => '&#52594;',
 "\xAD\x4E" => '&#52595;',
 "\xAD\x4F" => '&#52596;',
 "\xAD\x50" => '&#52597;',
 "\xAD\x51" => '&#52598;',
 "\xAD\x52" => '&#52599;',
 "\xAD\x53" => '&#52601;',
 "\xAD\x54" => '&#52602;',
 "\xAD\x55" => '&#52603;',
 "\xAD\x56" => '&#52604;',
 "\xAD\x57" => '&#52605;',
 "\xAD\x58" => '&#52606;',
 "\xAD\x59" => '&#52607;',
 "\xAD\x5A" => '&#52608;',
 "\xAD\x61" => '&#52609;',
 "\xAD\x62" => '&#52610;',
 "\xAD\x63" => '&#52611;',
 "\xAD\x64" => '&#52612;',
 "\xAD\x65" => '&#52613;',
 "\xAD\x66" => '&#52614;',
 "\xAD\x67" => '&#52615;',
 "\xAD\x68" => '&#52617;',
 "\xAD\x69" => '&#52618;',
 "\xAD\x6A" => '&#52619;',
 "\xAD\x6B" => '&#52620;',
 "\xAD\x6C" => '&#52621;',
 "\xAD\x6D" => '&#52622;',
 "\xAD\x6E" => '&#52623;',
 "\xAD\x6F" => '&#52624;',
 "\xAD\x70" => '&#52625;',
 "\xAD\x71" => '&#52626;',
 "\xAD\x72" => '&#52627;',
 "\xAD\x73" => '&#52630;',
 "\xAD\x74" => '&#52631;',
 "\xAD\x75" => '&#52633;',
 "\xAD\x76" => '&#52634;',
 "\xAD\x77" => '&#52635;',
 "\xAD\x78" => '&#52637;',
 "\xAD\x79" => '&#52638;',
 "\xAD\x7A" => '&#52639;',
 "\xAD\x81" => '&#52640;',
 "\xAD\x82" => '&#52641;',
 "\xAD\x83" => '&#52642;',
 "\xAD\x84" => '&#52643;',
 "\xAD\x85" => '&#52646;',
 "\xAD\x86" => '&#52648;',
 "\xAD\x87" => '&#52650;',
 "\xAD\x88" => '&#52651;',
 "\xAD\x89" => '&#52652;',
 "\xAD\x8A" => '&#52653;',
 "\xAD\x8B" => '&#52654;',
 "\xAD\x8C" => '&#52655;',
 "\xAD\x8D" => '&#52657;',
 "\xAD\x8E" => '&#52658;',
 "\xAD\x8F" => '&#52659;',
 "\xAD\x90" => '&#52660;',
 "\xAD\x91" => '&#52661;',
 "\xAD\x92" => '&#52662;',
 "\xAD\x93" => '&#52663;',
 "\xAD\x94" => '&#52664;',
 "\xAD\x95" => '&#52665;',
 "\xAD\x96" => '&#52666;',
 "\xAD\x97" => '&#52667;',
 "\xAD\x98" => '&#52668;',
 "\xAD\x99" => '&#52669;',
 "\xAD\x9A" => '&#52670;',
 "\xAD\x9B" => '&#52671;',
 "\xAD\x9C" => '&#52672;',
 "\xAD\x9D" => '&#52673;',
 "\xAD\x9E" => '&#52674;',
 "\xAD\x9F" => '&#52675;',
 "\xAD\xA0" => '&#52677;',
 "\xAE\x41" => '&#52678;',
 "\xAE\x42" => '&#52679;',
 "\xAE\x43" => '&#52680;',
 "\xAE\x44" => '&#52681;',
 "\xAE\x45" => '&#52682;',
 "\xAE\x46" => '&#52683;',
 "\xAE\x47" => '&#52685;',
 "\xAE\x48" => '&#52686;',
 "\xAE\x49" => '&#52687;',
 "\xAE\x4A" => '&#52689;',
 "\xAE\x4B" => '&#52690;',
 "\xAE\x4C" => '&#52691;',
 "\xAE\x4D" => '&#52692;',
 "\xAE\x4E" => '&#52693;',
 "\xAE\x4F" => '&#52694;',
 "\xAE\x50" => '&#52695;',
 "\xAE\x51" => '&#52696;',
 "\xAE\x52" => '&#52697;',
 "\xAE\x53" => '&#52698;',
 "\xAE\x54" => '&#52699;',
 "\xAE\x55" => '&#52700;',
 "\xAE\x56" => '&#52701;',
 "\xAE\x57" => '&#52702;',
 "\xAE\x58" => '&#52703;',
 "\xAE\x59" => '&#52704;',
 "\xAE\x5A" => '&#52705;',
 "\xAE\x61" => '&#52706;',
 "\xAE\x62" => '&#52707;',
 "\xAE\x63" => '&#52708;',
 "\xAE\x64" => '&#52709;',
 "\xAE\x65" => '&#52710;',
 "\xAE\x66" => '&#52711;',
 "\xAE\x67" => '&#52713;',
 "\xAE\x68" => '&#52714;',
 "\xAE\x69" => '&#52715;',
 "\xAE\x6A" => '&#52717;',
 "\xAE\x6B" => '&#52718;',
 "\xAE\x6C" => '&#52719;',
 "\xAE\x6D" => '&#52721;',
 "\xAE\x6E" => '&#52722;',
 "\xAE\x6F" => '&#52723;',
 "\xAE\x70" => '&#52724;',
 "\xAE\x71" => '&#52725;',
 "\xAE\x72" => '&#52726;',
 "\xAE\x73" => '&#52727;',
 "\xAE\x74" => '&#52730;',
 "\xAE\x75" => '&#52732;',
 "\xAE\x76" => '&#52734;',
 "\xAE\x77" => '&#52735;',
 "\xAE\x78" => '&#52736;',
 "\xAE\x79" => '&#52737;',
 "\xAE\x7A" => '&#52738;',
 "\xAE\x81" => '&#52739;',
 "\xAE\x82" => '&#52741;',
 "\xAE\x83" => '&#52742;',
 "\xAE\x84" => '&#52743;',
 "\xAE\x85" => '&#52745;',
 "\xAE\x86" => '&#52746;',
 "\xAE\x87" => '&#52747;',
 "\xAE\x88" => '&#52749;',
 "\xAE\x89" => '&#52750;',
 "\xAE\x8A" => '&#52751;',
 "\xAE\x8B" => '&#52752;',
 "\xAE\x8C" => '&#52753;',
 "\xAE\x8D" => '&#52754;',
 "\xAE\x8E" => '&#52755;',
 "\xAE\x8F" => '&#52757;',
 "\xAE\x90" => '&#52758;',
 "\xAE\x91" => '&#52759;',
 "\xAE\x92" => '&#52760;',
 "\xAE\x93" => '&#52762;',
 "\xAE\x94" => '&#52763;',
 "\xAE\x95" => '&#52764;',
 "\xAE\x96" => '&#52765;',
 "\xAE\x97" => '&#52766;',
 "\xAE\x98" => '&#52767;',
 "\xAE\x99" => '&#52770;',
 "\xAE\x9A" => '&#52771;',
 "\xAE\x9B" => '&#52773;',
 "\xAE\x9C" => '&#52774;',
 "\xAE\x9D" => '&#52775;',
 "\xAE\x9E" => '&#52777;',
 "\xAE\x9F" => '&#52778;',
 "\xAE\xA0" => '&#52779;',
 "\xAF\x41" => '&#52780;',
 "\xAF\x42" => '&#52781;',
 "\xAF\x43" => '&#52782;',
 "\xAF\x44" => '&#52783;',
 "\xAF\x45" => '&#52786;',
 "\xAF\x46" => '&#52788;',
 "\xAF\x47" => '&#52790;',
 "\xAF\x48" => '&#52791;',
 "\xAF\x49" => '&#52792;',
 "\xAF\x4A" => '&#52793;',
 "\xAF\x4B" => '&#52794;',
 "\xAF\x4C" => '&#52795;',
 "\xAF\x4D" => '&#52796;',
 "\xAF\x4E" => '&#52797;',
 "\xAF\x4F" => '&#52798;',
 "\xAF\x50" => '&#52799;',
 "\xAF\x51" => '&#52800;',
 "\xAF\x52" => '&#52801;',
 "\xAF\x53" => '&#52802;',
 "\xAF\x54" => '&#52803;',
 "\xAF\x55" => '&#52804;',
 "\xAF\x56" => '&#52805;',
 "\xAF\x57" => '&#52806;',
 "\xAF\x58" => '&#52807;',
 "\xAF\x59" => '&#52808;',
 "\xAF\x5A" => '&#52809;',
 "\xAF\x61" => '&#52810;',
 "\xAF\x62" => '&#52811;',
 "\xAF\x63" => '&#52812;',
 "\xAF\x64" => '&#52813;',
 "\xAF\x65" => '&#52814;',
 "\xAF\x66" => '&#52815;',
 "\xAF\x67" => '&#52816;',
 "\xAF\x68" => '&#52817;',
 "\xAF\x69" => '&#52818;',
 "\xAF\x6A" => '&#52819;',
 "\xAF\x6B" => '&#52820;',
 "\xAF\x6C" => '&#52821;',
 "\xAF\x6D" => '&#52822;',
 "\xAF\x6E" => '&#52823;',
 "\xAF\x6F" => '&#52826;',
 "\xAF\x70" => '&#52827;',
 "\xAF\x71" => '&#52829;',
 "\xAF\x72" => '&#52830;',
 "\xAF\x73" => '&#52834;',
 "\xAF\x74" => '&#52835;',
 "\xAF\x75" => '&#52836;',
 "\xAF\x76" => '&#52837;',
 "\xAF\x77" => '&#52838;',
 "\xAF\x78" => '&#52839;',
 "\xAF\x79" => '&#52842;',
 "\xAF\x7A" => '&#52844;',
 "\xAF\x81" => '&#52846;',
 "\xAF\x82" => '&#52847;',
 "\xAF\x83" => '&#52848;',
 "\xAF\x84" => '&#52849;',
 "\xAF\x85" => '&#52850;',
 "\xAF\x86" => '&#52851;',
 "\xAF\x87" => '&#52854;',
 "\xAF\x88" => '&#52855;',
 "\xAF\x89" => '&#52857;',
 "\xAF\x8A" => '&#52858;',
 "\xAF\x8B" => '&#52859;',
 "\xAF\x8C" => '&#52861;',
 "\xAF\x8D" => '&#52862;',
 "\xAF\x8E" => '&#52863;',
 "\xAF\x8F" => '&#52864;',
 "\xAF\x90" => '&#52865;',
 "\xAF\x91" => '&#52866;',
 "\xAF\x92" => '&#52867;',
 "\xAF\x93" => '&#52870;',
 "\xAF\x94" => '&#52872;',
 "\xAF\x95" => '&#52874;',
 "\xAF\x96" => '&#52875;',
 "\xAF\x97" => '&#52876;',
 "\xAF\x98" => '&#52877;',
 "\xAF\x99" => '&#52878;',
 "\xAF\x9A" => '&#52879;',
 "\xAF\x9B" => '&#52882;',
 "\xAF\x9C" => '&#52883;',
 "\xAF\x9D" => '&#52885;',
 "\xAF\x9E" => '&#52886;',
 "\xAF\x9F" => '&#52887;',
 "\xAF\xA0" => '&#52889;',
 "\xB0\x41" => '&#52890;',
 "\xB0\x42" => '&#52891;',
 "\xB0\x43" => '&#52892;',
 "\xB0\x44" => '&#52893;',
 "\xB0\x45" => '&#52894;',
 "\xB0\x46" => '&#52895;',
 "\xB0\x47" => '&#52898;',
 "\xB0\x48" => '&#52902;',
 "\xB0\x49" => '&#52903;',
 "\xB0\x4A" => '&#52904;',
 "\xB0\x4B" => '&#52905;',
 "\xB0\x4C" => '&#52906;',
 "\xB0\x4D" => '&#52907;',
 "\xB0\x4E" => '&#52910;',
 "\xB0\x4F" => '&#52911;',
 "\xB0\x50" => '&#52912;',
 "\xB0\x51" => '&#52913;',
 "\xB0\x52" => '&#52914;',
 "\xB0\x53" => '&#52915;',
 "\xB0\x54" => '&#52916;',
 "\xB0\x55" => '&#52917;',
 "\xB0\x56" => '&#52918;',
 "\xB0\x57" => '&#52919;',
 "\xB0\x58" => '&#52920;',
 "\xB0\x59" => '&#52921;',
 "\xB0\x5A" => '&#52922;',
 "\xB0\x61" => '&#52923;',
 "\xB0\x62" => '&#52924;',
 "\xB0\x63" => '&#52925;',
 "\xB0\x64" => '&#52926;',
 "\xB0\x65" => '&#52927;',
 "\xB0\x66" => '&#52928;',
 "\xB0\x67" => '&#52930;',
 "\xB0\x68" => '&#52931;',
 "\xB0\x69" => '&#52932;',
 "\xB0\x6A" => '&#52933;',
 "\xB0\x6B" => '&#52934;',
 "\xB0\x6C" => '&#52935;',
 "\xB0\x6D" => '&#52936;',
 "\xB0\x6E" => '&#52937;',
 "\xB0\x6F" => '&#52938;',
 "\xB0\x70" => '&#52939;',
 "\xB0\x71" => '&#52940;',
 "\xB0\x72" => '&#52941;',
 "\xB0\x73" => '&#52942;',
 "\xB0\x74" => '&#52943;',
 "\xB0\x75" => '&#52944;',
 "\xB0\x76" => '&#52945;',
 "\xB0\x77" => '&#52946;',
 "\xB0\x78" => '&#52947;',
 "\xB0\x79" => '&#52948;',
 "\xB0\x7A" => '&#52949;',
 "\xB0\x81" => '&#52950;',
 "\xB0\x82" => '&#52951;',
 "\xB0\x83" => '&#52952;',
 "\xB0\x84" => '&#52953;',
 "\xB0\x85" => '&#52954;',
 "\xB0\x86" => '&#52955;',
 "\xB0\x87" => '&#52956;',
 "\xB0\x88" => '&#52957;',
 "\xB0\x89" => '&#52958;',
 "\xB0\x8A" => '&#52959;',
 "\xB0\x8B" => '&#52960;',
 "\xB0\x8C" => '&#52961;',
 "\xB0\x8D" => '&#52962;',
 "\xB0\x8E" => '&#52963;',
 "\xB0\x8F" => '&#52966;',
 "\xB0\x90" => '&#52967;',
 "\xB0\x91" => '&#52969;',
 "\xB0\x92" => '&#52970;',
 "\xB0\x93" => '&#52973;',
 "\xB0\x94" => '&#52974;',
 "\xB0\x95" => '&#52975;',
 "\xB0\x96" => '&#52976;',
 "\xB0\x97" => '&#52977;',
 "\xB0\x98" => '&#52978;',
 "\xB0\x99" => '&#52979;',
 "\xB0\x9A" => '&#52982;',
 "\xB0\x9B" => '&#52986;',
 "\xB0\x9C" => '&#52987;',
 "\xB0\x9D" => '&#52988;',
 "\xB0\x9E" => '&#52989;',
 "\xB0\x9F" => '&#52990;',
 "\xB0\xA0" => '&#52991;',
 "\xB0\xA1" => '&#44032;',
 "\xB0\xA2" => '&#44033;',
 "\xB0\xA3" => '&#44036;',
 "\xB0\xA4" => '&#44039;',
 "\xB0\xA5" => '&#44040;',
 "\xB0\xA6" => '&#44041;',
 "\xB0\xA7" => '&#44042;',
 "\xB0\xA8" => '&#44048;',
 "\xB0\xA9" => '&#44049;',
 "\xB0\xAA" => '&#44050;',
 "\xB0\xAB" => '&#44051;',
 "\xB0\xAC" => '&#44052;',
 "\xB0\xAD" => '&#44053;',
 "\xB0\xAE" => '&#44054;',
 "\xB0\xAF" => '&#44055;',
 "\xB0\xB0" => '&#44057;',
 "\xB0\xB1" => '&#44058;',
 "\xB0\xB2" => '&#44059;',
 "\xB0\xB3" => '&#44060;',
 "\xB0\xB4" => '&#44061;',
 "\xB0\xB5" => '&#44064;',
 "\xB0\xB6" => '&#44068;',
 "\xB0\xB7" => '&#44076;',
 "\xB0\xB8" => '&#44077;',
 "\xB0\xB9" => '&#44079;',
 "\xB0\xBA" => '&#44080;',
 "\xB0\xBB" => '&#44081;',
 "\xB0\xBC" => '&#44088;',
 "\xB0\xBD" => '&#44089;',
 "\xB0\xBE" => '&#44092;',
 "\xB0\xBF" => '&#44096;',
 "\xB0\xC0" => '&#44107;',
 "\xB0\xC1" => '&#44109;',
 "\xB0\xC2" => '&#44116;',
 "\xB0\xC3" => '&#44120;',
 "\xB0\xC4" => '&#44124;',
 "\xB0\xC5" => '&#44144;',
 "\xB0\xC6" => '&#44145;',
 "\xB0\xC7" => '&#44148;',
 "\xB0\xC8" => '&#44151;',
 "\xB0\xC9" => '&#44152;',
 "\xB0\xCA" => '&#44154;',
 "\xB0\xCB" => '&#44160;',
 "\xB0\xCC" => '&#44161;',
 "\xB0\xCD" => '&#44163;',
 "\xB0\xCE" => '&#44164;',
 "\xB0\xCF" => '&#44165;',
 "\xB0\xD0" => '&#44166;',
 "\xB0\xD1" => '&#44169;',
 "\xB0\xD2" => '&#44170;',
 "\xB0\xD3" => '&#44171;',
 "\xB0\xD4" => '&#44172;',
 "\xB0\xD5" => '&#44176;',
 "\xB0\xD6" => '&#44180;',
 "\xB0\xD7" => '&#44188;',
 "\xB0\xD8" => '&#44189;',
 "\xB0\xD9" => '&#44191;',
 "\xB0\xDA" => '&#44192;',
 "\xB0\xDB" => '&#44193;',
 "\xB0\xDC" => '&#44200;',
 "\xB0\xDD" => '&#44201;',
 "\xB0\xDE" => '&#44202;',
 "\xB0\xDF" => '&#44204;',
 "\xB0\xE0" => '&#44207;',
 "\xB0\xE1" => '&#44208;',
 "\xB0\xE2" => '&#44216;',
 "\xB0\xE3" => '&#44217;',
 "\xB0\xE4" => '&#44219;',
 "\xB0\xE5" => '&#44220;',
 "\xB0\xE6" => '&#44221;',
 "\xB0\xE7" => '&#44225;',
 "\xB0\xE8" => '&#44228;',
 "\xB0\xE9" => '&#44232;',
 "\xB0\xEA" => '&#44236;',
 "\xB0\xEB" => '&#44245;',
 "\xB0\xEC" => '&#44247;',
 "\xB0\xED" => '&#44256;',
 "\xB0\xEE" => '&#44257;',
 "\xB0\xEF" => '&#44260;',
 "\xB0\xF0" => '&#44263;',
 "\xB0\xF1" => '&#44264;',
 "\xB0\xF2" => '&#44266;',
 "\xB0\xF3" => '&#44268;',
 "\xB0\xF4" => '&#44271;',
 "\xB0\xF5" => '&#44272;',
 "\xB0\xF6" => '&#44273;',
 "\xB0\xF7" => '&#44275;',
 "\xB0\xF8" => '&#44277;',
 "\xB0\xF9" => '&#44278;',
 "\xB0\xFA" => '&#44284;',
 "\xB0\xFB" => '&#44285;',
 "\xB0\xFC" => '&#44288;',
 "\xB0\xFD" => '&#44292;',
 "\xB0\xFE" => '&#44294;',
 "\xB1\x41" => '&#52994;',
 "\xB1\x42" => '&#52995;',
 "\xB1\x43" => '&#52997;',
 "\xB1\x44" => '&#52998;',
 "\xB1\x45" => '&#52999;',
 "\xB1\x46" => '&#53001;',
 "\xB1\x47" => '&#53002;',
 "\xB1\x48" => '&#53003;',
 "\xB1\x49" => '&#53004;',
 "\xB1\x4A" => '&#53005;',
 "\xB1\x4B" => '&#53006;',
 "\xB1\x4C" => '&#53007;',
 "\xB1\x4D" => '&#53010;',
 "\xB1\x4E" => '&#53012;',
 "\xB1\x4F" => '&#53014;',
 "\xB1\x50" => '&#53015;',
 "\xB1\x51" => '&#53016;',
 "\xB1\x52" => '&#53017;',
 "\xB1\x53" => '&#53018;',
 "\xB1\x54" => '&#53019;',
 "\xB1\x55" => '&#53021;',
 "\xB1\x56" => '&#53022;',
 "\xB1\x57" => '&#53023;',
 "\xB1\x58" => '&#53025;',
 "\xB1\x59" => '&#53026;',
 "\xB1\x5A" => '&#53027;',
 "\xB1\x61" => '&#53029;',
 "\xB1\x62" => '&#53030;',
 "\xB1\x63" => '&#53031;',
 "\xB1\x64" => '&#53032;',
 "\xB1\x65" => '&#53033;',
 "\xB1\x66" => '&#53034;',
 "\xB1\x67" => '&#53035;',
 "\xB1\x68" => '&#53038;',
 "\xB1\x69" => '&#53042;',
 "\xB1\x6A" => '&#53043;',
 "\xB1\x6B" => '&#53044;',
 "\xB1\x6C" => '&#53045;',
 "\xB1\x6D" => '&#53046;',
 "\xB1\x6E" => '&#53047;',
 "\xB1\x6F" => '&#53049;',
 "\xB1\x70" => '&#53050;',
 "\xB1\x71" => '&#53051;',
 "\xB1\x72" => '&#53052;',
 "\xB1\x73" => '&#53053;',
 "\xB1\x74" => '&#53054;',
 "\xB1\x75" => '&#53055;',
 "\xB1\x76" => '&#53056;',
 "\xB1\x77" => '&#53057;',
 "\xB1\x78" => '&#53058;',
 "\xB1\x79" => '&#53059;',
 "\xB1\x7A" => '&#53060;',
 "\xB1\x81" => '&#53061;',
 "\xB1\x82" => '&#53062;',
 "\xB1\x83" => '&#53063;',
 "\xB1\x84" => '&#53064;',
 "\xB1\x85" => '&#53065;',
 "\xB1\x86" => '&#53066;',
 "\xB1\x87" => '&#53067;',
 "\xB1\x88" => '&#53068;',
 "\xB1\x89" => '&#53069;',
 "\xB1\x8A" => '&#53070;',
 "\xB1\x8B" => '&#53071;',
 "\xB1\x8C" => '&#53072;',
 "\xB1\x8D" => '&#53073;',
 "\xB1\x8E" => '&#53074;',
 "\xB1\x8F" => '&#53075;',
 "\xB1\x90" => '&#53078;',
 "\xB1\x91" => '&#53079;',
 "\xB1\x92" => '&#53081;',
 "\xB1\x93" => '&#53082;',
 "\xB1\x94" => '&#53083;',
 "\xB1\x95" => '&#53085;',
 "\xB1\x96" => '&#53086;',
 "\xB1\x97" => '&#53087;',
 "\xB1\x98" => '&#53088;',
 "\xB1\x99" => '&#53089;',
 "\xB1\x9A" => '&#53090;',
 "\xB1\x9B" => '&#53091;',
 "\xB1\x9C" => '&#53094;',
 "\xB1\x9D" => '&#53096;',
 "\xB1\x9E" => '&#53098;',
 "\xB1\x9F" => '&#53099;',
 "\xB1\xA0" => '&#53100;',
 "\xB1\xA1" => '&#44300;',
 "\xB1\xA2" => '&#44301;',
 "\xB1\xA3" => '&#44303;',
 "\xB1\xA4" => '&#44305;',
 "\xB1\xA5" => '&#44312;',
 "\xB1\xA6" => '&#44316;',
 "\xB1\xA7" => '&#44320;',
 "\xB1\xA8" => '&#44329;',
 "\xB1\xA9" => '&#44332;',
 "\xB1\xAA" => '&#44333;',
 "\xB1\xAB" => '&#44340;',
 "\xB1\xAC" => '&#44341;',
 "\xB1\xAD" => '&#44344;',
 "\xB1\xAE" => '&#44348;',
 "\xB1\xAF" => '&#44356;',
 "\xB1\xB0" => '&#44357;',
 "\xB1\xB1" => '&#44359;',
 "\xB1\xB2" => '&#44361;',
 "\xB1\xB3" => '&#44368;',
 "\xB1\xB4" => '&#44372;',
 "\xB1\xB5" => '&#44376;',
 "\xB1\xB6" => '&#44385;',
 "\xB1\xB7" => '&#44387;',
 "\xB1\xB8" => '&#44396;',
 "\xB1\xB9" => '&#44397;',
 "\xB1\xBA" => '&#44400;',
 "\xB1\xBB" => '&#44403;',
 "\xB1\xBC" => '&#44404;',
 "\xB1\xBD" => '&#44405;',
 "\xB1\xBE" => '&#44406;',
 "\xB1\xBF" => '&#44411;',
 "\xB1\xC0" => '&#44412;',
 "\xB1\xC1" => '&#44413;',
 "\xB1\xC2" => '&#44415;',
 "\xB1\xC3" => '&#44417;',
 "\xB1\xC4" => '&#44418;',
 "\xB1\xC5" => '&#44424;',
 "\xB1\xC6" => '&#44425;',
 "\xB1\xC7" => '&#44428;',
 "\xB1\xC8" => '&#44432;',
 "\xB1\xC9" => '&#44444;',
 "\xB1\xCA" => '&#44445;',
 "\xB1\xCB" => '&#44452;',
 "\xB1\xCC" => '&#44471;',
 "\xB1\xCD" => '&#44480;',
 "\xB1\xCE" => '&#44481;',
 "\xB1\xCF" => '&#44484;',
 "\xB1\xD0" => '&#44488;',
 "\xB1\xD1" => '&#44496;',
 "\xB1\xD2" => '&#44497;',
 "\xB1\xD3" => '&#44499;',
 "\xB1\xD4" => '&#44508;',
 "\xB1\xD5" => '&#44512;',
 "\xB1\xD6" => '&#44516;',
 "\xB1\xD7" => '&#44536;',
 "\xB1\xD8" => '&#44537;',
 "\xB1\xD9" => '&#44540;',
 "\xB1\xDA" => '&#44543;',
 "\xB1\xDB" => '&#44544;',
 "\xB1\xDC" => '&#44545;',
 "\xB1\xDD" => '&#44552;',
 "\xB1\xDE" => '&#44553;',
 "\xB1\xDF" => '&#44555;',
 "\xB1\xE0" => '&#44557;',
 "\xB1\xE1" => '&#44564;',
 "\xB1\xE2" => '&#44592;',
 "\xB1\xE3" => '&#44593;',
 "\xB1\xE4" => '&#44596;',
 "\xB1\xE5" => '&#44599;',
 "\xB1\xE6" => '&#44600;',
 "\xB1\xE7" => '&#44602;',
 "\xB1\xE8" => '&#44608;',
 "\xB1\xE9" => '&#44609;',
 "\xB1\xEA" => '&#44611;',
 "\xB1\xEB" => '&#44613;',
 "\xB1\xEC" => '&#44614;',
 "\xB1\xED" => '&#44618;',
 "\xB1\xEE" => '&#44620;',
 "\xB1\xEF" => '&#44621;',
 "\xB1\xF0" => '&#44622;',
 "\xB1\xF1" => '&#44624;',
 "\xB1\xF2" => '&#44628;',
 "\xB1\xF3" => '&#44630;',
 "\xB1\xF4" => '&#44636;',
 "\xB1\xF5" => '&#44637;',
 "\xB1\xF6" => '&#44639;',
 "\xB1\xF7" => '&#44640;',
 "\xB1\xF8" => '&#44641;',
 "\xB1\xF9" => '&#44645;',
 "\xB1\xFA" => '&#44648;',
 "\xB1\xFB" => '&#44649;',
 "\xB1\xFC" => '&#44652;',
 "\xB1\xFD" => '&#44656;',
 "\xB1\xFE" => '&#44664;',
 "\xB2\x41" => '&#53101;',
 "\xB2\x42" => '&#53102;',
 "\xB2\x43" => '&#53103;',
 "\xB2\x44" => '&#53106;',
 "\xB2\x45" => '&#53107;',
 "\xB2\x46" => '&#53109;',
 "\xB2\x47" => '&#53110;',
 "\xB2\x48" => '&#53111;',
 "\xB2\x49" => '&#53113;',
 "\xB2\x4A" => '&#53114;',
 "\xB2\x4B" => '&#53115;',
 "\xB2\x4C" => '&#53116;',
 "\xB2\x4D" => '&#53117;',
 "\xB2\x4E" => '&#53118;',
 "\xB2\x4F" => '&#53119;',
 "\xB2\x50" => '&#53121;',
 "\xB2\x51" => '&#53122;',
 "\xB2\x52" => '&#53123;',
 "\xB2\x53" => '&#53124;',
 "\xB2\x54" => '&#53126;',
 "\xB2\x55" => '&#53127;',
 "\xB2\x56" => '&#53128;',
 "\xB2\x57" => '&#53129;',
 "\xB2\x58" => '&#53130;',
 "\xB2\x59" => '&#53131;',
 "\xB2\x5A" => '&#53133;',
 "\xB2\x61" => '&#53134;',
 "\xB2\x62" => '&#53135;',
 "\xB2\x63" => '&#53136;',
 "\xB2\x64" => '&#53137;',
 "\xB2\x65" => '&#53138;',
 "\xB2\x66" => '&#53139;',
 "\xB2\x67" => '&#53140;',
 "\xB2\x68" => '&#53141;',
 "\xB2\x69" => '&#53142;',
 "\xB2\x6A" => '&#53143;',
 "\xB2\x6B" => '&#53144;',
 "\xB2\x6C" => '&#53145;',
 "\xB2\x6D" => '&#53146;',
 "\xB2\x6E" => '&#53147;',
 "\xB2\x6F" => '&#53148;',
 "\xB2\x70" => '&#53149;',
 "\xB2\x71" => '&#53150;',
 "\xB2\x72" => '&#53151;',
 "\xB2\x73" => '&#53152;',
 "\xB2\x74" => '&#53154;',
 "\xB2\x75" => '&#53155;',
 "\xB2\x76" => '&#53156;',
 "\xB2\x77" => '&#53157;',
 "\xB2\x78" => '&#53158;',
 "\xB2\x79" => '&#53159;',
 "\xB2\x7A" => '&#53161;',
 "\xB2\x81" => '&#53162;',
 "\xB2\x82" => '&#53163;',
 "\xB2\x83" => '&#53164;',
 "\xB2\x84" => '&#53165;',
 "\xB2\x85" => '&#53166;',
 "\xB2\x86" => '&#53167;',
 "\xB2\x87" => '&#53169;',
 "\xB2\x88" => '&#53170;',
 "\xB2\x89" => '&#53171;',
 "\xB2\x8A" => '&#53172;',
 "\xB2\x8B" => '&#53173;',
 "\xB2\x8C" => '&#53174;',
 "\xB2\x8D" => '&#53175;',
 "\xB2\x8E" => '&#53176;',
 "\xB2\x8F" => '&#53177;',
 "\xB2\x90" => '&#53178;',
 "\xB2\x91" => '&#53179;',
 "\xB2\x92" => '&#53180;',
 "\xB2\x93" => '&#53181;',
 "\xB2\x94" => '&#53182;',
 "\xB2\x95" => '&#53183;',
 "\xB2\x96" => '&#53184;',
 "\xB2\x97" => '&#53185;',
 "\xB2\x98" => '&#53186;',
 "\xB2\x99" => '&#53187;',
 "\xB2\x9A" => '&#53189;',
 "\xB2\x9B" => '&#53190;',
 "\xB2\x9C" => '&#53191;',
 "\xB2\x9D" => '&#53192;',
 "\xB2\x9E" => '&#53193;',
 "\xB2\x9F" => '&#53194;',
 "\xB2\xA0" => '&#53195;',
 "\xB2\xA1" => '&#44665;',
 "\xB2\xA2" => '&#44667;',
 "\xB2\xA3" => '&#44668;',
 "\xB2\xA4" => '&#44669;',
 "\xB2\xA5" => '&#44676;',
 "\xB2\xA6" => '&#44677;',
 "\xB2\xA7" => '&#44684;',
 "\xB2\xA8" => '&#44732;',
 "\xB2\xA9" => '&#44733;',
 "\xB2\xAA" => '&#44734;',
 "\xB2\xAB" => '&#44736;',
 "\xB2\xAC" => '&#44740;',
 "\xB2\xAD" => '&#44748;',
 "\xB2\xAE" => '&#44749;',
 "\xB2\xAF" => '&#44751;',
 "\xB2\xB0" => '&#44752;',
 "\xB2\xB1" => '&#44753;',
 "\xB2\xB2" => '&#44760;',
 "\xB2\xB3" => '&#44761;',
 "\xB2\xB4" => '&#44764;',
 "\xB2\xB5" => '&#44776;',
 "\xB2\xB6" => '&#44779;',
 "\xB2\xB7" => '&#44781;',
 "\xB2\xB8" => '&#44788;',
 "\xB2\xB9" => '&#44792;',
 "\xB2\xBA" => '&#44796;',
 "\xB2\xBB" => '&#44807;',
 "\xB2\xBC" => '&#44808;',
 "\xB2\xBD" => '&#44813;',
 "\xB2\xBE" => '&#44816;',
 "\xB2\xBF" => '&#44844;',
 "\xB2\xC0" => '&#44845;',
 "\xB2\xC1" => '&#44848;',
 "\xB2\xC2" => '&#44850;',
 "\xB2\xC3" => '&#44852;',
 "\xB2\xC4" => '&#44860;',
 "\xB2\xC5" => '&#44861;',
 "\xB2\xC6" => '&#44863;',
 "\xB2\xC7" => '&#44865;',
 "\xB2\xC8" => '&#44866;',
 "\xB2\xC9" => '&#44867;',
 "\xB2\xCA" => '&#44872;',
 "\xB2\xCB" => '&#44873;',
 "\xB2\xCC" => '&#44880;',
 "\xB2\xCD" => '&#44892;',
 "\xB2\xCE" => '&#44893;',
 "\xB2\xCF" => '&#44900;',
 "\xB2\xD0" => '&#44901;',
 "\xB2\xD1" => '&#44921;',
 "\xB2\xD2" => '&#44928;',
 "\xB2\xD3" => '&#44932;',
 "\xB2\xD4" => '&#44936;',
 "\xB2\xD5" => '&#44944;',
 "\xB2\xD6" => '&#44945;',
 "\xB2\xD7" => '&#44949;',
 "\xB2\xD8" => '&#44956;',
 "\xB2\xD9" => '&#44984;',
 "\xB2\xDA" => '&#44985;',
 "\xB2\xDB" => '&#44988;',
 "\xB2\xDC" => '&#44992;',
 "\xB2\xDD" => '&#44999;',
 "\xB2\xDE" => '&#45000;',
 "\xB2\xDF" => '&#45001;',
 "\xB2\xE0" => '&#45003;',
 "\xB2\xE1" => '&#45005;',
 "\xB2\xE2" => '&#45006;',
 "\xB2\xE3" => '&#45012;',
 "\xB2\xE4" => '&#45020;',
 "\xB2\xE5" => '&#45032;',
 "\xB2\xE6" => '&#45033;',
 "\xB2\xE7" => '&#45040;',
 "\xB2\xE8" => '&#45041;',
 "\xB2\xE9" => '&#45044;',
 "\xB2\xEA" => '&#45048;',
 "\xB2\xEB" => '&#45056;',
 "\xB2\xEC" => '&#45057;',
 "\xB2\xED" => '&#45060;',
 "\xB2\xEE" => '&#45068;',
 "\xB2\xEF" => '&#45072;',
 "\xB2\xF0" => '&#45076;',
 "\xB2\xF1" => '&#45084;',
 "\xB2\xF2" => '&#45085;',
 "\xB2\xF3" => '&#45096;',
 "\xB2\xF4" => '&#45124;',
 "\xB2\xF5" => '&#45125;',
 "\xB2\xF6" => '&#45128;',
 "\xB2\xF7" => '&#45130;',
 "\xB2\xF8" => '&#45132;',
 "\xB2\xF9" => '&#45134;',
 "\xB2\xFA" => '&#45139;',
 "\xB2\xFB" => '&#45140;',
 "\xB2\xFC" => '&#45141;',
 "\xB2\xFD" => '&#45143;',
 "\xB2\xFE" => '&#45145;',
 "\xB3\x41" => '&#53196;',
 "\xB3\x42" => '&#53197;',
 "\xB3\x43" => '&#53198;',
 "\xB3\x44" => '&#53199;',
 "\xB3\x45" => '&#53200;',
 "\xB3\x46" => '&#53201;',
 "\xB3\x47" => '&#53202;',
 "\xB3\x48" => '&#53203;',
 "\xB3\x49" => '&#53204;',
 "\xB3\x4A" => '&#53205;',
 "\xB3\x4B" => '&#53206;',
 "\xB3\x4C" => '&#53207;',
 "\xB3\x4D" => '&#53208;',
 "\xB3\x4E" => '&#53209;',
 "\xB3\x4F" => '&#53210;',
 "\xB3\x50" => '&#53211;',
 "\xB3\x51" => '&#53212;',
 "\xB3\x52" => '&#53213;',
 "\xB3\x53" => '&#53214;',
 "\xB3\x54" => '&#53215;',
 "\xB3\x55" => '&#53218;',
 "\xB3\x56" => '&#53219;',
 "\xB3\x57" => '&#53221;',
 "\xB3\x58" => '&#53222;',
 "\xB3\x59" => '&#53223;',
 "\xB3\x5A" => '&#53225;',
 "\xB3\x61" => '&#53226;',
 "\xB3\x62" => '&#53227;',
 "\xB3\x63" => '&#53228;',
 "\xB3\x64" => '&#53229;',
 "\xB3\x65" => '&#53230;',
 "\xB3\x66" => '&#53231;',
 "\xB3\x67" => '&#53234;',
 "\xB3\x68" => '&#53236;',
 "\xB3\x69" => '&#53238;',
 "\xB3\x6A" => '&#53239;',
 "\xB3\x6B" => '&#53240;',
 "\xB3\x6C" => '&#53241;',
 "\xB3\x6D" => '&#53242;',
 "\xB3\x6E" => '&#53243;',
 "\xB3\x6F" => '&#53245;',
 "\xB3\x70" => '&#53246;',
 "\xB3\x71" => '&#53247;',
 "\xB3\x72" => '&#53249;',
 "\xB3\x73" => '&#53250;',
 "\xB3\x74" => '&#53251;',
 "\xB3\x75" => '&#53253;',
 "\xB3\x76" => '&#53254;',
 "\xB3\x77" => '&#53255;',
 "\xB3\x78" => '&#53256;',
 "\xB3\x79" => '&#53257;',
 "\xB3\x7A" => '&#53258;',
 "\xB3\x81" => '&#53259;',
 "\xB3\x82" => '&#53260;',
 "\xB3\x83" => '&#53261;',
 "\xB3\x84" => '&#53262;',
 "\xB3\x85" => '&#53263;',
 "\xB3\x86" => '&#53264;',
 "\xB3\x87" => '&#53266;',
 "\xB3\x88" => '&#53267;',
 "\xB3\x89" => '&#53268;',
 "\xB3\x8A" => '&#53269;',
 "\xB3\x8B" => '&#53270;',
 "\xB3\x8C" => '&#53271;',
 "\xB3\x8D" => '&#53273;',
 "\xB3\x8E" => '&#53274;',
 "\xB3\x8F" => '&#53275;',
 "\xB3\x90" => '&#53276;',
 "\xB3\x91" => '&#53277;',
 "\xB3\x92" => '&#53278;',
 "\xB3\x93" => '&#53279;',
 "\xB3\x94" => '&#53280;',
 "\xB3\x95" => '&#53281;',
 "\xB3\x96" => '&#53282;',
 "\xB3\x97" => '&#53283;',
 "\xB3\x98" => '&#53284;',
 "\xB3\x99" => '&#53285;',
 "\xB3\x9A" => '&#53286;',
 "\xB3\x9B" => '&#53287;',
 "\xB3\x9C" => '&#53288;',
 "\xB3\x9D" => '&#53289;',
 "\xB3\x9E" => '&#53290;',
 "\xB3\x9F" => '&#53291;',
 "\xB3\xA0" => '&#53292;',
 "\xB3\xA1" => '&#45149;',
 "\xB3\xA2" => '&#45180;',
 "\xB3\xA3" => '&#45181;',
 "\xB3\xA4" => '&#45184;',
 "\xB3\xA5" => '&#45188;',
 "\xB3\xA6" => '&#45196;',
 "\xB3\xA7" => '&#45197;',
 "\xB3\xA8" => '&#45199;',
 "\xB3\xA9" => '&#45201;',
 "\xB3\xAA" => '&#45208;',
 "\xB3\xAB" => '&#45209;',
 "\xB3\xAC" => '&#45210;',
 "\xB3\xAD" => '&#45212;',
 "\xB3\xAE" => '&#45215;',
 "\xB3\xAF" => '&#45216;',
 "\xB3\xB0" => '&#45217;',
 "\xB3\xB1" => '&#45218;',
 "\xB3\xB2" => '&#45224;',
 "\xB3\xB3" => '&#45225;',
 "\xB3\xB4" => '&#45227;',
 "\xB3\xB5" => '&#45228;',
 "\xB3\xB6" => '&#45229;',
 "\xB3\xB7" => '&#45230;',
 "\xB3\xB8" => '&#45231;',
 "\xB3\xB9" => '&#45233;',
 "\xB3\xBA" => '&#45235;',
 "\xB3\xBB" => '&#45236;',
 "\xB3\xBC" => '&#45237;',
 "\xB3\xBD" => '&#45240;',
 "\xB3\xBE" => '&#45244;',
 "\xB3\xBF" => '&#45252;',
 "\xB3\xC0" => '&#45253;',
 "\xB3\xC1" => '&#45255;',
 "\xB3\xC2" => '&#45256;',
 "\xB3\xC3" => '&#45257;',
 "\xB3\xC4" => '&#45264;',
 "\xB3\xC5" => '&#45265;',
 "\xB3\xC6" => '&#45268;',
 "\xB3\xC7" => '&#45272;',
 "\xB3\xC8" => '&#45280;',
 "\xB3\xC9" => '&#45285;',
 "\xB3\xCA" => '&#45320;',
 "\xB3\xCB" => '&#45321;',
 "\xB3\xCC" => '&#45323;',
 "\xB3\xCD" => '&#45324;',
 "\xB3\xCE" => '&#45328;',
 "\xB3\xCF" => '&#45330;',
 "\xB3\xD0" => '&#45331;',
 "\xB3\xD1" => '&#45336;',
 "\xB3\xD2" => '&#45337;',
 "\xB3\xD3" => '&#45339;',
 "\xB3\xD4" => '&#45340;',
 "\xB3\xD5" => '&#45341;',
 "\xB3\xD6" => '&#45347;',
 "\xB3\xD7" => '&#45348;',
 "\xB3\xD8" => '&#45349;',
 "\xB3\xD9" => '&#45352;',
 "\xB3\xDA" => '&#45356;',
 "\xB3\xDB" => '&#45364;',
 "\xB3\xDC" => '&#45365;',
 "\xB3\xDD" => '&#45367;',
 "\xB3\xDE" => '&#45368;',
 "\xB3\xDF" => '&#45369;',
 "\xB3\xE0" => '&#45376;',
 "\xB3\xE1" => '&#45377;',
 "\xB3\xE2" => '&#45380;',
 "\xB3\xE3" => '&#45384;',
 "\xB3\xE4" => '&#45392;',
 "\xB3\xE5" => '&#45393;',
 "\xB3\xE6" => '&#45396;',
 "\xB3\xE7" => '&#45397;',
 "\xB3\xE8" => '&#45400;',
 "\xB3\xE9" => '&#45404;',
 "\xB3\xEA" => '&#45408;',
 "\xB3\xEB" => '&#45432;',
 "\xB3\xEC" => '&#45433;',
 "\xB3\xED" => '&#45436;',
 "\xB3\xEE" => '&#45440;',
 "\xB3\xEF" => '&#45442;',
 "\xB3\xF0" => '&#45448;',
 "\xB3\xF1" => '&#45449;',
 "\xB3\xF2" => '&#45451;',
 "\xB3\xF3" => '&#45453;',
 "\xB3\xF4" => '&#45458;',
 "\xB3\xF5" => '&#45459;',
 "\xB3\xF6" => '&#45460;',
 "\xB3\xF7" => '&#45464;',
 "\xB3\xF8" => '&#45468;',
 "\xB3\xF9" => '&#45480;',
 "\xB3\xFA" => '&#45516;',
 "\xB3\xFB" => '&#45520;',
 "\xB3\xFC" => '&#45524;',
 "\xB3\xFD" => '&#45532;',
 "\xB3\xFE" => '&#45533;',
 "\xB4\x41" => '&#53294;',
 "\xB4\x42" => '&#53295;',
 "\xB4\x43" => '&#53296;',
 "\xB4\x44" => '&#53297;',
 "\xB4\x45" => '&#53298;',
 "\xB4\x46" => '&#53299;',
 "\xB4\x47" => '&#53302;',
 "\xB4\x48" => '&#53303;',
 "\xB4\x49" => '&#53305;',
 "\xB4\x4A" => '&#53306;',
 "\xB4\x4B" => '&#53307;',
 "\xB4\x4C" => '&#53309;',
 "\xB4\x4D" => '&#53310;',
 "\xB4\x4E" => '&#53311;',
 "\xB4\x4F" => '&#53312;',
 "\xB4\x50" => '&#53313;',
 "\xB4\x51" => '&#53314;',
 "\xB4\x52" => '&#53315;',
 "\xB4\x53" => '&#53318;',
 "\xB4\x54" => '&#53320;',
 "\xB4\x55" => '&#53322;',
 "\xB4\x56" => '&#53323;',
 "\xB4\x57" => '&#53324;',
 "\xB4\x58" => '&#53325;',
 "\xB4\x59" => '&#53326;',
 "\xB4\x5A" => '&#53327;',
 "\xB4\x61" => '&#53329;',
 "\xB4\x62" => '&#53330;',
 "\xB4\x63" => '&#53331;',
 "\xB4\x64" => '&#53333;',
 "\xB4\x65" => '&#53334;',
 "\xB4\x66" => '&#53335;',
 "\xB4\x67" => '&#53337;',
 "\xB4\x68" => '&#53338;',
 "\xB4\x69" => '&#53339;',
 "\xB4\x6A" => '&#53340;',
 "\xB4\x6B" => '&#53341;',
 "\xB4\x6C" => '&#53342;',
 "\xB4\x6D" => '&#53343;',
 "\xB4\x6E" => '&#53345;',
 "\xB4\x6F" => '&#53346;',
 "\xB4\x70" => '&#53347;',
 "\xB4\x71" => '&#53348;',
 "\xB4\x72" => '&#53349;',
 "\xB4\x73" => '&#53350;',
 "\xB4\x74" => '&#53351;',
 "\xB4\x75" => '&#53352;',
 "\xB4\x76" => '&#53353;',
 "\xB4\x77" => '&#53354;',
 "\xB4\x78" => '&#53355;',
 "\xB4\x79" => '&#53358;',
 "\xB4\x7A" => '&#53359;',
 "\xB4\x81" => '&#53361;',
 "\xB4\x82" => '&#53362;',
 "\xB4\x83" => '&#53363;',
 "\xB4\x84" => '&#53365;',
 "\xB4\x85" => '&#53366;',
 "\xB4\x86" => '&#53367;',
 "\xB4\x87" => '&#53368;',
 "\xB4\x88" => '&#53369;',
 "\xB4\x89" => '&#53370;',
 "\xB4\x8A" => '&#53371;',
 "\xB4\x8B" => '&#53374;',
 "\xB4\x8C" => '&#53375;',
 "\xB4\x8D" => '&#53376;',
 "\xB4\x8E" => '&#53378;',
 "\xB4\x8F" => '&#53379;',
 "\xB4\x90" => '&#53380;',
 "\xB4\x91" => '&#53381;',
 "\xB4\x92" => '&#53382;',
 "\xB4\x93" => '&#53383;',
 "\xB4\x94" => '&#53384;',
 "\xB4\x95" => '&#53385;',
 "\xB4\x96" => '&#53386;',
 "\xB4\x97" => '&#53387;',
 "\xB4\x98" => '&#53388;',
 "\xB4\x99" => '&#53389;',
 "\xB4\x9A" => '&#53390;',
 "\xB4\x9B" => '&#53391;',
 "\xB4\x9C" => '&#53392;',
 "\xB4\x9D" => '&#53393;',
 "\xB4\x9E" => '&#53394;',
 "\xB4\x9F" => '&#53395;',
 "\xB4\xA0" => '&#53396;',
 "\xB4\xA1" => '&#45535;',
 "\xB4\xA2" => '&#45544;',
 "\xB4\xA3" => '&#45545;',
 "\xB4\xA4" => '&#45548;',
 "\xB4\xA5" => '&#45552;',
 "\xB4\xA6" => '&#45561;',
 "\xB4\xA7" => '&#45563;',
 "\xB4\xA8" => '&#45565;',
 "\xB4\xA9" => '&#45572;',
 "\xB4\xAA" => '&#45573;',
 "\xB4\xAB" => '&#45576;',
 "\xB4\xAC" => '&#45579;',
 "\xB4\xAD" => '&#45580;',
 "\xB4\xAE" => '&#45588;',
 "\xB4\xAF" => '&#45589;',
 "\xB4\xB0" => '&#45591;',
 "\xB4\xB1" => '&#45593;',
 "\xB4\xB2" => '&#45600;',
 "\xB4\xB3" => '&#45620;',
 "\xB4\xB4" => '&#45628;',
 "\xB4\xB5" => '&#45656;',
 "\xB4\xB6" => '&#45660;',
 "\xB4\xB7" => '&#45664;',
 "\xB4\xB8" => '&#45672;',
 "\xB4\xB9" => '&#45673;',
 "\xB4\xBA" => '&#45684;',
 "\xB4\xBB" => '&#45685;',
 "\xB4\xBC" => '&#45692;',
 "\xB4\xBD" => '&#45700;',
 "\xB4\xBE" => '&#45701;',
 "\xB4\xBF" => '&#45705;',
 "\xB4\xC0" => '&#45712;',
 "\xB4\xC1" => '&#45713;',
 "\xB4\xC2" => '&#45716;',
 "\xB4\xC3" => '&#45720;',
 "\xB4\xC4" => '&#45721;',
 "\xB4\xC5" => '&#45722;',
 "\xB4\xC6" => '&#45728;',
 "\xB4\xC7" => '&#45729;',
 "\xB4\xC8" => '&#45731;',
 "\xB4\xC9" => '&#45733;',
 "\xB4\xCA" => '&#45734;',
 "\xB4\xCB" => '&#45738;',
 "\xB4\xCC" => '&#45740;',
 "\xB4\xCD" => '&#45744;',
 "\xB4\xCE" => '&#45748;',
 "\xB4\xCF" => '&#45768;',
 "\xB4\xD0" => '&#45769;',
 "\xB4\xD1" => '&#45772;',
 "\xB4\xD2" => '&#45776;',
 "\xB4\xD3" => '&#45778;',
 "\xB4\xD4" => '&#45784;',
 "\xB4\xD5" => '&#45785;',
 "\xB4\xD6" => '&#45787;',
 "\xB4\xD7" => '&#45789;',
 "\xB4\xD8" => '&#45794;',
 "\xB4\xD9" => '&#45796;',
 "\xB4\xDA" => '&#45797;',
 "\xB4\xDB" => '&#45798;',
 "\xB4\xDC" => '&#45800;',
 "\xB4\xDD" => '&#45803;',
 "\xB4\xDE" => '&#45804;',
 "\xB4\xDF" => '&#45805;',
 "\xB4\xE0" => '&#45806;',
 "\xB4\xE1" => '&#45807;',
 "\xB4\xE2" => '&#45811;',
 "\xB4\xE3" => '&#45812;',
 "\xB4\xE4" => '&#45813;',
 "\xB4\xE5" => '&#45815;',
 "\xB4\xE6" => '&#45816;',
 "\xB4\xE7" => '&#45817;',
 "\xB4\xE8" => '&#45818;',
 "\xB4\xE9" => '&#45819;',
 "\xB4\xEA" => '&#45823;',
 "\xB4\xEB" => '&#45824;',
 "\xB4\xEC" => '&#45825;',
 "\xB4\xED" => '&#45828;',
 "\xB4\xEE" => '&#45832;',
 "\xB4\xEF" => '&#45840;',
 "\xB4\xF0" => '&#45841;',
 "\xB4\xF1" => '&#45843;',
 "\xB4\xF2" => '&#45844;',
 "\xB4\xF3" => '&#45845;',
 "\xB4\xF4" => '&#45852;',
 "\xB4\xF5" => '&#45908;',
 "\xB4\xF6" => '&#45909;',
 "\xB4\xF7" => '&#45910;',
 "\xB4\xF8" => '&#45912;',
 "\xB4\xF9" => '&#45915;',
 "\xB4\xFA" => '&#45916;',
 "\xB4\xFB" => '&#45918;',
 "\xB4\xFC" => '&#45919;',
 "\xB4\xFD" => '&#45924;',
 "\xB4\xFE" => '&#45925;',
 "\xB5\x41" => '&#53397;',
 "\xB5\x42" => '&#53398;',
 "\xB5\x43" => '&#53399;',
 "\xB5\x44" => '&#53400;',
 "\xB5\x45" => '&#53401;',
 "\xB5\x46" => '&#53402;',
 "\xB5\x47" => '&#53403;',
 "\xB5\x48" => '&#53404;',
 "\xB5\x49" => '&#53405;',
 "\xB5\x4A" => '&#53406;',
 "\xB5\x4B" => '&#53407;',
 "\xB5\x4C" => '&#53408;',
 "\xB5\x4D" => '&#53409;',
 "\xB5\x4E" => '&#53410;',
 "\xB5\x4F" => '&#53411;',
 "\xB5\x50" => '&#53414;',
 "\xB5\x51" => '&#53415;',
 "\xB5\x52" => '&#53417;',
 "\xB5\x53" => '&#53418;',
 "\xB5\x54" => '&#53419;',
 "\xB5\x55" => '&#53421;',
 "\xB5\x56" => '&#53422;',
 "\xB5\x57" => '&#53423;',
 "\xB5\x58" => '&#53424;',
 "\xB5\x59" => '&#53425;',
 "\xB5\x5A" => '&#53426;',
 "\xB5\x61" => '&#53427;',
 "\xB5\x62" => '&#53430;',
 "\xB5\x63" => '&#53432;',
 "\xB5\x64" => '&#53434;',
 "\xB5\x65" => '&#53435;',
 "\xB5\x66" => '&#53436;',
 "\xB5\x67" => '&#53437;',
 "\xB5\x68" => '&#53438;',
 "\xB5\x69" => '&#53439;',
 "\xB5\x6A" => '&#53442;',
 "\xB5\x6B" => '&#53443;',
 "\xB5\x6C" => '&#53445;',
 "\xB5\x6D" => '&#53446;',
 "\xB5\x6E" => '&#53447;',
 "\xB5\x6F" => '&#53450;',
 "\xB5\x70" => '&#53451;',
 "\xB5\x71" => '&#53452;',
 "\xB5\x72" => '&#53453;',
 "\xB5\x73" => '&#53454;',
 "\xB5\x74" => '&#53455;',
 "\xB5\x75" => '&#53458;',
 "\xB5\x76" => '&#53462;',
 "\xB5\x77" => '&#53463;',
 "\xB5\x78" => '&#53464;',
 "\xB5\x79" => '&#53465;',
 "\xB5\x7A" => '&#53466;',
 "\xB5\x81" => '&#53467;',
 "\xB5\x82" => '&#53470;',
 "\xB5\x83" => '&#53471;',
 "\xB5\x84" => '&#53473;',
 "\xB5\x85" => '&#53474;',
 "\xB5\x86" => '&#53475;',
 "\xB5\x87" => '&#53477;',
 "\xB5\x88" => '&#53478;',
 "\xB5\x89" => '&#53479;',
 "\xB5\x8A" => '&#53480;',
 "\xB5\x8B" => '&#53481;',
 "\xB5\x8C" => '&#53482;',
 "\xB5\x8D" => '&#53483;',
 "\xB5\x8E" => '&#53486;',
 "\xB5\x8F" => '&#53490;',
 "\xB5\x90" => '&#53491;',
 "\xB5\x91" => '&#53492;',
 "\xB5\x92" => '&#53493;',
 "\xB5\x93" => '&#53494;',
 "\xB5\x94" => '&#53495;',
 "\xB5\x95" => '&#53497;',
 "\xB5\x96" => '&#53498;',
 "\xB5\x97" => '&#53499;',
 "\xB5\x98" => '&#53500;',
 "\xB5\x99" => '&#53501;',
 "\xB5\x9A" => '&#53502;',
 "\xB5\x9B" => '&#53503;',
 "\xB5\x9C" => '&#53504;',
 "\xB5\x9D" => '&#53505;',
 "\xB5\x9E" => '&#53506;',
 "\xB5\x9F" => '&#53507;',
 "\xB5\xA0" => '&#53508;',
 "\xB5\xA1" => '&#45927;',
 "\xB5\xA2" => '&#45929;',
 "\xB5\xA3" => '&#45931;',
 "\xB5\xA4" => '&#45934;',
 "\xB5\xA5" => '&#45936;',
 "\xB5\xA6" => '&#45937;',
 "\xB5\xA7" => '&#45940;',
 "\xB5\xA8" => '&#45944;',
 "\xB5\xA9" => '&#45952;',
 "\xB5\xAA" => '&#45953;',
 "\xB5\xAB" => '&#45955;',
 "\xB5\xAC" => '&#45956;',
 "\xB5\xAD" => '&#45957;',
 "\xB5\xAE" => '&#45964;',
 "\xB5\xAF" => '&#45968;',
 "\xB5\xB0" => '&#45972;',
 "\xB5\xB1" => '&#45984;',
 "\xB5\xB2" => '&#45985;',
 "\xB5\xB3" => '&#45992;',
 "\xB5\xB4" => '&#45996;',
 "\xB5\xB5" => '&#46020;',
 "\xB5\xB6" => '&#46021;',
 "\xB5\xB7" => '&#46024;',
 "\xB5\xB8" => '&#46027;',
 "\xB5\xB9" => '&#46028;',
 "\xB5\xBA" => '&#46030;',
 "\xB5\xBB" => '&#46032;',
 "\xB5\xBC" => '&#46036;',
 "\xB5\xBD" => '&#46037;',
 "\xB5\xBE" => '&#46039;',
 "\xB5\xBF" => '&#46041;',
 "\xB5\xC0" => '&#46043;',
 "\xB5\xC1" => '&#46045;',
 "\xB5\xC2" => '&#46048;',
 "\xB5\xC3" => '&#46052;',
 "\xB5\xC4" => '&#46056;',
 "\xB5\xC5" => '&#46076;',
 "\xB5\xC6" => '&#46096;',
 "\xB5\xC7" => '&#46104;',
 "\xB5\xC8" => '&#46108;',
 "\xB5\xC9" => '&#46112;',
 "\xB5\xCA" => '&#46120;',
 "\xB5\xCB" => '&#46121;',
 "\xB5\xCC" => '&#46123;',
 "\xB5\xCD" => '&#46132;',
 "\xB5\xCE" => '&#46160;',
 "\xB5\xCF" => '&#46161;',
 "\xB5\xD0" => '&#46164;',
 "\xB5\xD1" => '&#46168;',
 "\xB5\xD2" => '&#46176;',
 "\xB5\xD3" => '&#46177;',
 "\xB5\xD4" => '&#46179;',
 "\xB5\xD5" => '&#46181;',
 "\xB5\xD6" => '&#46188;',
 "\xB5\xD7" => '&#46208;',
 "\xB5\xD8" => '&#46216;',
 "\xB5\xD9" => '&#46237;',
 "\xB5\xDA" => '&#46244;',
 "\xB5\xDB" => '&#46248;',
 "\xB5\xDC" => '&#46252;',
 "\xB5\xDD" => '&#46261;',
 "\xB5\xDE" => '&#46263;',
 "\xB5\xDF" => '&#46265;',
 "\xB5\xE0" => '&#46272;',
 "\xB5\xE1" => '&#46276;',
 "\xB5\xE2" => '&#46280;',
 "\xB5\xE3" => '&#46288;',
 "\xB5\xE4" => '&#46293;',
 "\xB5\xE5" => '&#46300;',
 "\xB5\xE6" => '&#46301;',
 "\xB5\xE7" => '&#46304;',
 "\xB5\xE8" => '&#46307;',
 "\xB5\xE9" => '&#46308;',
 "\xB5\xEA" => '&#46310;',
 "\xB5\xEB" => '&#46316;',
 "\xB5\xEC" => '&#46317;',
 "\xB5\xED" => '&#46319;',
 "\xB5\xEE" => '&#46321;',
 "\xB5\xEF" => '&#46328;',
 "\xB5\xF0" => '&#46356;',
 "\xB5\xF1" => '&#46357;',
 "\xB5\xF2" => '&#46360;',
 "\xB5\xF3" => '&#46363;',
 "\xB5\xF4" => '&#46364;',
 "\xB5\xF5" => '&#46372;',
 "\xB5\xF6" => '&#46373;',
 "\xB5\xF7" => '&#46375;',
 "\xB5\xF8" => '&#46376;',
 "\xB5\xF9" => '&#46377;',
 "\xB5\xFA" => '&#46378;',
 "\xB5\xFB" => '&#46384;',
 "\xB5\xFC" => '&#46385;',
 "\xB5\xFD" => '&#46388;',
 "\xB5\xFE" => '&#46392;',
 "\xB6\x41" => '&#53509;',
 "\xB6\x42" => '&#53510;',
 "\xB6\x43" => '&#53511;',
 "\xB6\x44" => '&#53512;',
 "\xB6\x45" => '&#53513;',
 "\xB6\x46" => '&#53514;',
 "\xB6\x47" => '&#53515;',
 "\xB6\x48" => '&#53516;',
 "\xB6\x49" => '&#53518;',
 "\xB6\x4A" => '&#53519;',
 "\xB6\x4B" => '&#53520;',
 "\xB6\x4C" => '&#53521;',
 "\xB6\x4D" => '&#53522;',
 "\xB6\x4E" => '&#53523;',
 "\xB6\x4F" => '&#53524;',
 "\xB6\x50" => '&#53525;',
 "\xB6\x51" => '&#53526;',
 "\xB6\x52" => '&#53527;',
 "\xB6\x53" => '&#53528;',
 "\xB6\x54" => '&#53529;',
 "\xB6\x55" => '&#53530;',
 "\xB6\x56" => '&#53531;',
 "\xB6\x57" => '&#53532;',
 "\xB6\x58" => '&#53533;',
 "\xB6\x59" => '&#53534;',
 "\xB6\x5A" => '&#53535;',
 "\xB6\x61" => '&#53536;',
 "\xB6\x62" => '&#53537;',
 "\xB6\x63" => '&#53538;',
 "\xB6\x64" => '&#53539;',
 "\xB6\x65" => '&#53540;',
 "\xB6\x66" => '&#53541;',
 "\xB6\x67" => '&#53542;',
 "\xB6\x68" => '&#53543;',
 "\xB6\x69" => '&#53544;',
 "\xB6\x6A" => '&#53545;',
 "\xB6\x6B" => '&#53546;',
 "\xB6\x6C" => '&#53547;',
 "\xB6\x6D" => '&#53548;',
 "\xB6\x6E" => '&#53549;',
 "\xB6\x6F" => '&#53550;',
 "\xB6\x70" => '&#53551;',
 "\xB6\x71" => '&#53554;',
 "\xB6\x72" => '&#53555;',
 "\xB6\x73" => '&#53557;',
 "\xB6\x74" => '&#53558;',
 "\xB6\x75" => '&#53559;',
 "\xB6\x76" => '&#53561;',
 "\xB6\x77" => '&#53563;',
 "\xB6\x78" => '&#53564;',
 "\xB6\x79" => '&#53565;',
 "\xB6\x7A" => '&#53566;',
 "\xB6\x81" => '&#53567;',
 "\xB6\x82" => '&#53570;',
 "\xB6\x83" => '&#53574;',
 "\xB6\x84" => '&#53575;',
 "\xB6\x85" => '&#53576;',
 "\xB6\x86" => '&#53577;',
 "\xB6\x87" => '&#53578;',
 "\xB6\x88" => '&#53579;',
 "\xB6\x89" => '&#53582;',
 "\xB6\x8A" => '&#53583;',
 "\xB6\x8B" => '&#53585;',
 "\xB6\x8C" => '&#53586;',
 "\xB6\x8D" => '&#53587;',
 "\xB6\x8E" => '&#53589;',
 "\xB6\x8F" => '&#53590;',
 "\xB6\x90" => '&#53591;',
 "\xB6\x91" => '&#53592;',
 "\xB6\x92" => '&#53593;',
 "\xB6\x93" => '&#53594;',
 "\xB6\x94" => '&#53595;',
 "\xB6\x95" => '&#53598;',
 "\xB6\x96" => '&#53600;',
 "\xB6\x97" => '&#53602;',
 "\xB6\x98" => '&#53603;',
 "\xB6\x99" => '&#53604;',
 "\xB6\x9A" => '&#53605;',
 "\xB6\x9B" => '&#53606;',
 "\xB6\x9C" => '&#53607;',
 "\xB6\x9D" => '&#53609;',
 "\xB6\x9E" => '&#53610;',
 "\xB6\x9F" => '&#53611;',
 "\xB6\xA0" => '&#53613;',
 "\xB6\xA1" => '&#46400;',
 "\xB6\xA2" => '&#46401;',
 "\xB6\xA3" => '&#46403;',
 "\xB6\xA4" => '&#46404;',
 "\xB6\xA5" => '&#46405;',
 "\xB6\xA6" => '&#46411;',
 "\xB6\xA7" => '&#46412;',
 "\xB6\xA8" => '&#46413;',
 "\xB6\xA9" => '&#46416;',
 "\xB6\xAA" => '&#46420;',
 "\xB6\xAB" => '&#46428;',
 "\xB6\xAC" => '&#46429;',
 "\xB6\xAD" => '&#46431;',
 "\xB6\xAE" => '&#46432;',
 "\xB6\xAF" => '&#46433;',
 "\xB6\xB0" => '&#46496;',
 "\xB6\xB1" => '&#46497;',
 "\xB6\xB2" => '&#46500;',
 "\xB6\xB3" => '&#46504;',
 "\xB6\xB4" => '&#46506;',
 "\xB6\xB5" => '&#46507;',
 "\xB6\xB6" => '&#46512;',
 "\xB6\xB7" => '&#46513;',
 "\xB6\xB8" => '&#46515;',
 "\xB6\xB9" => '&#46516;',
 "\xB6\xBA" => '&#46517;',
 "\xB6\xBB" => '&#46523;',
 "\xB6\xBC" => '&#46524;',
 "\xB6\xBD" => '&#46525;',
 "\xB6\xBE" => '&#46528;',
 "\xB6\xBF" => '&#46532;',
 "\xB6\xC0" => '&#46540;',
 "\xB6\xC1" => '&#46541;',
 "\xB6\xC2" => '&#46543;',
 "\xB6\xC3" => '&#46544;',
 "\xB6\xC4" => '&#46545;',
 "\xB6\xC5" => '&#46552;',
 "\xB6\xC6" => '&#46572;',
 "\xB6\xC7" => '&#46608;',
 "\xB6\xC8" => '&#46609;',
 "\xB6\xC9" => '&#46612;',
 "\xB6\xCA" => '&#46616;',
 "\xB6\xCB" => '&#46629;',
 "\xB6\xCC" => '&#46636;',
 "\xB6\xCD" => '&#46644;',
 "\xB6\xCE" => '&#46664;',
 "\xB6\xCF" => '&#46692;',
 "\xB6\xD0" => '&#46696;',
 "\xB6\xD1" => '&#46748;',
 "\xB6\xD2" => '&#46749;',
 "\xB6\xD3" => '&#46752;',
 "\xB6\xD4" => '&#46756;',
 "\xB6\xD5" => '&#46763;',
 "\xB6\xD6" => '&#46764;',
 "\xB6\xD7" => '&#46769;',
 "\xB6\xD8" => '&#46804;',
 "\xB6\xD9" => '&#46832;',
 "\xB6\xDA" => '&#46836;',
 "\xB6\xDB" => '&#46840;',
 "\xB6\xDC" => '&#46848;',
 "\xB6\xDD" => '&#46849;',
 "\xB6\xDE" => '&#46853;',
 "\xB6\xDF" => '&#46888;',
 "\xB6\xE0" => '&#46889;',
 "\xB6\xE1" => '&#46892;',
 "\xB6\xE2" => '&#46895;',
 "\xB6\xE3" => '&#46896;',
 "\xB6\xE4" => '&#46904;',
 "\xB6\xE5" => '&#46905;',
 "\xB6\xE6" => '&#46907;',
 "\xB6\xE7" => '&#46916;',
 "\xB6\xE8" => '&#46920;',
 "\xB6\xE9" => '&#46924;',
 "\xB6\xEA" => '&#46932;',
 "\xB6\xEB" => '&#46933;',
 "\xB6\xEC" => '&#46944;',
 "\xB6\xED" => '&#46948;',
 "\xB6\xEE" => '&#46952;',
 "\xB6\xEF" => '&#46960;',
 "\xB6\xF0" => '&#46961;',
 "\xB6\xF1" => '&#46963;',
 "\xB6\xF2" => '&#46965;',
 "\xB6\xF3" => '&#46972;',
 "\xB6\xF4" => '&#46973;',
 "\xB6\xF5" => '&#46976;',
 "\xB6\xF6" => '&#46980;',
 "\xB6\xF7" => '&#46988;',
 "\xB6\xF8" => '&#46989;',
 "\xB6\xF9" => '&#46991;',
 "\xB6\xFA" => '&#46992;',
 "\xB6\xFB" => '&#46993;',
 "\xB6\xFC" => '&#46994;',
 "\xB6\xFD" => '&#46998;',
 "\xB6\xFE" => '&#46999;',
 "\xB7\x41" => '&#53614;',
 "\xB7\x42" => '&#53615;',
 "\xB7\x43" => '&#53616;',
 "\xB7\x44" => '&#53617;',
 "\xB7\x45" => '&#53618;',
 "\xB7\x46" => '&#53619;',
 "\xB7\x47" => '&#53620;',
 "\xB7\x48" => '&#53621;',
 "\xB7\x49" => '&#53622;',
 "\xB7\x4A" => '&#53623;',
 "\xB7\x4B" => '&#53624;',
 "\xB7\x4C" => '&#53625;',
 "\xB7\x4D" => '&#53626;',
 "\xB7\x4E" => '&#53627;',
 "\xB7\x4F" => '&#53629;',
 "\xB7\x50" => '&#53630;',
 "\xB7\x51" => '&#53631;',
 "\xB7\x52" => '&#53632;',
 "\xB7\x53" => '&#53633;',
 "\xB7\x54" => '&#53634;',
 "\xB7\x55" => '&#53635;',
 "\xB7\x56" => '&#53637;',
 "\xB7\x57" => '&#53638;',
 "\xB7\x58" => '&#53639;',
 "\xB7\x59" => '&#53641;',
 "\xB7\x5A" => '&#53642;',
 "\xB7\x61" => '&#53643;',
 "\xB7\x62" => '&#53644;',
 "\xB7\x63" => '&#53645;',
 "\xB7\x64" => '&#53646;',
 "\xB7\x65" => '&#53647;',
 "\xB7\x66" => '&#53648;',
 "\xB7\x67" => '&#53649;',
 "\xB7\x68" => '&#53650;',
 "\xB7\x69" => '&#53651;',
 "\xB7\x6A" => '&#53652;',
 "\xB7\x6B" => '&#53653;',
 "\xB7\x6C" => '&#53654;',
 "\xB7\x6D" => '&#53655;',
 "\xB7\x6E" => '&#53656;',
 "\xB7\x6F" => '&#53657;',
 "\xB7\x70" => '&#53658;',
 "\xB7\x71" => '&#53659;',
 "\xB7\x72" => '&#53660;',
 "\xB7\x73" => '&#53661;',
 "\xB7\x74" => '&#53662;',
 "\xB7\x75" => '&#53663;',
 "\xB7\x76" => '&#53666;',
 "\xB7\x77" => '&#53667;',
 "\xB7\x78" => '&#53669;',
 "\xB7\x79" => '&#53670;',
 "\xB7\x7A" => '&#53671;',
 "\xB7\x81" => '&#53673;',
 "\xB7\x82" => '&#53674;',
 "\xB7\x83" => '&#53675;',
 "\xB7\x84" => '&#53676;',
 "\xB7\x85" => '&#53677;',
 "\xB7\x86" => '&#53678;',
 "\xB7\x87" => '&#53679;',
 "\xB7\x88" => '&#53682;',
 "\xB7\x89" => '&#53684;',
 "\xB7\x8A" => '&#53686;',
 "\xB7\x8B" => '&#53687;',
 "\xB7\x8C" => '&#53688;',
 "\xB7\x8D" => '&#53689;',
 "\xB7\x8E" => '&#53691;',
 "\xB7\x8F" => '&#53693;',
 "\xB7\x90" => '&#53694;',
 "\xB7\x91" => '&#53695;',
 "\xB7\x92" => '&#53697;',
 "\xB7\x93" => '&#53698;',
 "\xB7\x94" => '&#53699;',
 "\xB7\x95" => '&#53700;',
 "\xB7\x96" => '&#53701;',
 "\xB7\x97" => '&#53702;',
 "\xB7\x98" => '&#53703;',
 "\xB7\x99" => '&#53704;',
 "\xB7\x9A" => '&#53705;',
 "\xB7\x9B" => '&#53706;',
 "\xB7\x9C" => '&#53707;',
 "\xB7\x9D" => '&#53708;',
 "\xB7\x9E" => '&#53709;',
 "\xB7\x9F" => '&#53710;',
 "\xB7\xA0" => '&#53711;',
 "\xB7\xA1" => '&#47000;',
 "\xB7\xA2" => '&#47001;',
 "\xB7\xA3" => '&#47004;',
 "\xB7\xA4" => '&#47008;',
 "\xB7\xA5" => '&#47016;',
 "\xB7\xA6" => '&#47017;',
 "\xB7\xA7" => '&#47019;',
 "\xB7\xA8" => '&#47020;',
 "\xB7\xA9" => '&#47021;',
 "\xB7\xAA" => '&#47028;',
 "\xB7\xAB" => '&#47029;',
 "\xB7\xAC" => '&#47032;',
 "\xB7\xAD" => '&#47047;',
 "\xB7\xAE" => '&#47049;',
 "\xB7\xAF" => '&#47084;',
 "\xB7\xB0" => '&#47085;',
 "\xB7\xB1" => '&#47088;',
 "\xB7\xB2" => '&#47092;',
 "\xB7\xB3" => '&#47100;',
 "\xB7\xB4" => '&#47101;',
 "\xB7\xB5" => '&#47103;',
 "\xB7\xB6" => '&#47104;',
 "\xB7\xB7" => '&#47105;',
 "\xB7\xB8" => '&#47111;',
 "\xB7\xB9" => '&#47112;',
 "\xB7\xBA" => '&#47113;',
 "\xB7\xBB" => '&#47116;',
 "\xB7\xBC" => '&#47120;',
 "\xB7\xBD" => '&#47128;',
 "\xB7\xBE" => '&#47129;',
 "\xB7\xBF" => '&#47131;',
 "\xB7\xC0" => '&#47133;',
 "\xB7\xC1" => '&#47140;',
 "\xB7\xC2" => '&#47141;',
 "\xB7\xC3" => '&#47144;',
 "\xB7\xC4" => '&#47148;',
 "\xB7\xC5" => '&#47156;',
 "\xB7\xC6" => '&#47157;',
 "\xB7\xC7" => '&#47159;',
 "\xB7\xC8" => '&#47160;',
 "\xB7\xC9" => '&#47161;',
 "\xB7\xCA" => '&#47168;',
 "\xB7\xCB" => '&#47172;',
 "\xB7\xCC" => '&#47185;',
 "\xB7\xCD" => '&#47187;',
 "\xB7\xCE" => '&#47196;',
 "\xB7\xCF" => '&#47197;',
 "\xB7\xD0" => '&#47200;',
 "\xB7\xD1" => '&#47204;',
 "\xB7\xD2" => '&#47212;',
 "\xB7\xD3" => '&#47213;',
 "\xB7\xD4" => '&#47215;',
 "\xB7\xD5" => '&#47217;',
 "\xB7\xD6" => '&#47224;',
 "\xB7\xD7" => '&#47228;',
 "\xB7\xD8" => '&#47245;',
 "\xB7\xD9" => '&#47272;',
 "\xB7\xDA" => '&#47280;',
 "\xB7\xDB" => '&#47284;',
 "\xB7\xDC" => '&#47288;',
 "\xB7\xDD" => '&#47296;',
 "\xB7\xDE" => '&#47297;',
 "\xB7\xDF" => '&#47299;',
 "\xB7\xE0" => '&#47301;',
 "\xB7\xE1" => '&#47308;',
 "\xB7\xE2" => '&#47312;',
 "\xB7\xE3" => '&#47316;',
 "\xB7\xE4" => '&#47325;',
 "\xB7\xE5" => '&#47327;',
 "\xB7\xE6" => '&#47329;',
 "\xB7\xE7" => '&#47336;',
 "\xB7\xE8" => '&#47337;',
 "\xB7\xE9" => '&#47340;',
 "\xB7\xEA" => '&#47344;',
 "\xB7\xEB" => '&#47352;',
 "\xB7\xEC" => '&#47353;',
 "\xB7\xED" => '&#47355;',
 "\xB7\xEE" => '&#47357;',
 "\xB7\xEF" => '&#47364;',
 "\xB7\xF0" => '&#47384;',
 "\xB7\xF1" => '&#47392;',
 "\xB7\xF2" => '&#47420;',
 "\xB7\xF3" => '&#47421;',
 "\xB7\xF4" => '&#47424;',
 "\xB7\xF5" => '&#47428;',
 "\xB7\xF6" => '&#47436;',
 "\xB7\xF7" => '&#47439;',
 "\xB7\xF8" => '&#47441;',
 "\xB7\xF9" => '&#47448;',
 "\xB7\xFA" => '&#47449;',
 "\xB7\xFB" => '&#47452;',
 "\xB7\xFC" => '&#47456;',
 "\xB7\xFD" => '&#47464;',
 "\xB7\xFE" => '&#47465;',
 "\xB8\x41" => '&#53712;',
 "\xB8\x42" => '&#53713;',
 "\xB8\x43" => '&#53714;',
 "\xB8\x44" => '&#53715;',
 "\xB8\x45" => '&#53716;',
 "\xB8\x46" => '&#53717;',
 "\xB8\x47" => '&#53718;',
 "\xB8\x48" => '&#53719;',
 "\xB8\x49" => '&#53721;',
 "\xB8\x4A" => '&#53722;',
 "\xB8\x4B" => '&#53723;',
 "\xB8\x4C" => '&#53724;',
 "\xB8\x4D" => '&#53725;',
 "\xB8\x4E" => '&#53726;',
 "\xB8\x4F" => '&#53727;',
 "\xB8\x50" => '&#53728;',
 "\xB8\x51" => '&#53729;',
 "\xB8\x52" => '&#53730;',
 "\xB8\x53" => '&#53731;',
 "\xB8\x54" => '&#53732;',
 "\xB8\x55" => '&#53733;',
 "\xB8\x56" => '&#53734;',
 "\xB8\x57" => '&#53735;',
 "\xB8\x58" => '&#53736;',
 "\xB8\x59" => '&#53737;',
 "\xB8\x5A" => '&#53738;',
 "\xB8\x61" => '&#53739;',
 "\xB8\x62" => '&#53740;',
 "\xB8\x63" => '&#53741;',
 "\xB8\x64" => '&#53742;',
 "\xB8\x65" => '&#53743;',
 "\xB8\x66" => '&#53744;',
 "\xB8\x67" => '&#53745;',
 "\xB8\x68" => '&#53746;',
 "\xB8\x69" => '&#53747;',
 "\xB8\x6A" => '&#53749;',
 "\xB8\x6B" => '&#53750;',
 "\xB8\x6C" => '&#53751;',
 "\xB8\x6D" => '&#53753;',
 "\xB8\x6E" => '&#53754;',
 "\xB8\x6F" => '&#53755;',
 "\xB8\x70" => '&#53756;',
 "\xB8\x71" => '&#53757;',
 "\xB8\x72" => '&#53758;',
 "\xB8\x73" => '&#53759;',
 "\xB8\x74" => '&#53760;',
 "\xB8\x75" => '&#53761;',
 "\xB8\x76" => '&#53762;',
 "\xB8\x77" => '&#53763;',
 "\xB8\x78" => '&#53764;',
 "\xB8\x79" => '&#53765;',
 "\xB8\x7A" => '&#53766;',
 "\xB8\x81" => '&#53768;',
 "\xB8\x82" => '&#53770;',
 "\xB8\x83" => '&#53771;',
 "\xB8\x84" => '&#53772;',
 "\xB8\x85" => '&#53773;',
 "\xB8\x86" => '&#53774;',
 "\xB8\x87" => '&#53775;',
 "\xB8\x88" => '&#53777;',
 "\xB8\x89" => '&#53778;',
 "\xB8\x8A" => '&#53779;',
 "\xB8\x8B" => '&#53780;',
 "\xB8\x8C" => '&#53781;',
 "\xB8\x8D" => '&#53782;',
 "\xB8\x8E" => '&#53783;',
 "\xB8\x8F" => '&#53784;',
 "\xB8\x90" => '&#53785;',
 "\xB8\x91" => '&#53786;',
 "\xB8\x92" => '&#53787;',
 "\xB8\x93" => '&#53788;',
 "\xB8\x94" => '&#53789;',
 "\xB8\x95" => '&#53790;',
 "\xB8\x96" => '&#53791;',
 "\xB8\x97" => '&#53792;',
 "\xB8\x98" => '&#53793;',
 "\xB8\x99" => '&#53794;',
 "\xB8\x9A" => '&#53795;',
 "\xB8\x9B" => '&#53796;',
 "\xB8\x9C" => '&#53797;',
 "\xB8\x9D" => '&#53798;',
 "\xB8\x9E" => '&#53799;',
 "\xB8\x9F" => '&#53800;',
 "\xB8\xA0" => '&#53801;',
 "\xB8\xA1" => '&#47467;',
 "\xB8\xA2" => '&#47469;',
 "\xB8\xA3" => '&#47476;',
 "\xB8\xA4" => '&#47477;',
 "\xB8\xA5" => '&#47480;',
 "\xB8\xA6" => '&#47484;',
 "\xB8\xA7" => '&#47492;',
 "\xB8\xA8" => '&#47493;',
 "\xB8\xA9" => '&#47495;',
 "\xB8\xAA" => '&#47497;',
 "\xB8\xAB" => '&#47498;',
 "\xB8\xAC" => '&#47501;',
 "\xB8\xAD" => '&#47502;',
 "\xB8\xAE" => '&#47532;',
 "\xB8\xAF" => '&#47533;',
 "\xB8\xB0" => '&#47536;',
 "\xB8\xB1" => '&#47540;',
 "\xB8\xB2" => '&#47548;',
 "\xB8\xB3" => '&#47549;',
 "\xB8\xB4" => '&#47551;',
 "\xB8\xB5" => '&#47553;',
 "\xB8\xB6" => '&#47560;',
 "\xB8\xB7" => '&#47561;',
 "\xB8\xB8" => '&#47564;',
 "\xB8\xB9" => '&#47566;',
 "\xB8\xBA" => '&#47567;',
 "\xB8\xBB" => '&#47568;',
 "\xB8\xBC" => '&#47569;',
 "\xB8\xBD" => '&#47570;',
 "\xB8\xBE" => '&#47576;',
 "\xB8\xBF" => '&#47577;',
 "\xB8\xC0" => '&#47579;',
 "\xB8\xC1" => '&#47581;',
 "\xB8\xC2" => '&#47582;',
 "\xB8\xC3" => '&#47585;',
 "\xB8\xC4" => '&#47587;',
 "\xB8\xC5" => '&#47588;',
 "\xB8\xC6" => '&#47589;',
 "\xB8\xC7" => '&#47592;',
 "\xB8\xC8" => '&#47596;',
 "\xB8\xC9" => '&#47604;',
 "\xB8\xCA" => '&#47605;',
 "\xB8\xCB" => '&#47607;',
 "\xB8\xCC" => '&#47608;',
 "\xB8\xCD" => '&#47609;',
 "\xB8\xCE" => '&#47610;',
 "\xB8\xCF" => '&#47616;',
 "\xB8\xD0" => '&#47617;',
 "\xB8\xD1" => '&#47624;',
 "\xB8\xD2" => '&#47637;',
 "\xB8\xD3" => '&#47672;',
 "\xB8\xD4" => '&#47673;',
 "\xB8\xD5" => '&#47676;',
 "\xB8\xD6" => '&#47680;',
 "\xB8\xD7" => '&#47682;',
 "\xB8\xD8" => '&#47688;',
 "\xB8\xD9" => '&#47689;',
 "\xB8\xDA" => '&#47691;',
 "\xB8\xDB" => '&#47693;',
 "\xB8\xDC" => '&#47694;',
 "\xB8\xDD" => '&#47699;',
 "\xB8\xDE" => '&#47700;',
 "\xB8\xDF" => '&#47701;',
 "\xB8\xE0" => '&#47704;',
 "\xB8\xE1" => '&#47708;',
 "\xB8\xE2" => '&#47716;',
 "\xB8\xE3" => '&#47717;',
 "\xB8\xE4" => '&#47719;',
 "\xB8\xE5" => '&#47720;',
 "\xB8\xE6" => '&#47721;',
 "\xB8\xE7" => '&#47728;',
 "\xB8\xE8" => '&#47729;',
 "\xB8\xE9" => '&#47732;',
 "\xB8\xEA" => '&#47736;',
 "\xB8\xEB" => '&#47747;',
 "\xB8\xEC" => '&#47748;',
 "\xB8\xED" => '&#47749;',
 "\xB8\xEE" => '&#47751;',
 "\xB8\xEF" => '&#47756;',
 "\xB8\xF0" => '&#47784;',
 "\xB8\xF1" => '&#47785;',
 "\xB8\xF2" => '&#47787;',
 "\xB8\xF3" => '&#47788;',
 "\xB8\xF4" => '&#47792;',
 "\xB8\xF5" => '&#47794;',
 "\xB8\xF6" => '&#47800;',
 "\xB8\xF7" => '&#47801;',
 "\xB8\xF8" => '&#47803;',
 "\xB8\xF9" => '&#47805;',
 "\xB8\xFA" => '&#47812;',
 "\xB8\xFB" => '&#47816;',
 "\xB8\xFC" => '&#47832;',
 "\xB8\xFD" => '&#47833;',
 "\xB8\xFE" => '&#47868;',
 "\xB9\x41" => '&#53802;',
 "\xB9\x42" => '&#53803;',
 "\xB9\x43" => '&#53806;',
 "\xB9\x44" => '&#53807;',
 "\xB9\x45" => '&#53809;',
 "\xB9\x46" => '&#53810;',
 "\xB9\x47" => '&#53811;',
 "\xB9\x48" => '&#53813;',
 "\xB9\x49" => '&#53814;',
 "\xB9\x4A" => '&#53815;',
 "\xB9\x4B" => '&#53816;',
 "\xB9\x4C" => '&#53817;',
 "\xB9\x4D" => '&#53818;',
 "\xB9\x4E" => '&#53819;',
 "\xB9\x4F" => '&#53822;',
 "\xB9\x50" => '&#53824;',
 "\xB9\x51" => '&#53826;',
 "\xB9\x52" => '&#53827;',
 "\xB9\x53" => '&#53828;',
 "\xB9\x54" => '&#53829;',
 "\xB9\x55" => '&#53830;',
 "\xB9\x56" => '&#53831;',
 "\xB9\x57" => '&#53833;',
 "\xB9\x58" => '&#53834;',
 "\xB9\x59" => '&#53835;',
 "\xB9\x5A" => '&#53836;',
 "\xB9\x61" => '&#53837;',
 "\xB9\x62" => '&#53838;',
 "\xB9\x63" => '&#53839;',
 "\xB9\x64" => '&#53840;',
 "\xB9\x65" => '&#53841;',
 "\xB9\x66" => '&#53842;',
 "\xB9\x67" => '&#53843;',
 "\xB9\x68" => '&#53844;',
 "\xB9\x69" => '&#53845;',
 "\xB9\x6A" => '&#53846;',
 "\xB9\x6B" => '&#53847;',
 "\xB9\x6C" => '&#53848;',
 "\xB9\x6D" => '&#53849;',
 "\xB9\x6E" => '&#53850;',
 "\xB9\x6F" => '&#53851;',
 "\xB9\x70" => '&#53853;',
 "\xB9\x71" => '&#53854;',
 "\xB9\x72" => '&#53855;',
 "\xB9\x73" => '&#53856;',
 "\xB9\x74" => '&#53857;',
 "\xB9\x75" => '&#53858;',
 "\xB9\x76" => '&#53859;',
 "\xB9\x77" => '&#53861;',
 "\xB9\x78" => '&#53862;',
 "\xB9\x79" => '&#53863;',
 "\xB9\x7A" => '&#53864;',
 "\xB9\x81" => '&#53865;',
 "\xB9\x82" => '&#53866;',
 "\xB9\x83" => '&#53867;',
 "\xB9\x84" => '&#53868;',
 "\xB9\x85" => '&#53869;',
 "\xB9\x86" => '&#53870;',
 "\xB9\x87" => '&#53871;',
 "\xB9\x88" => '&#53872;',
 "\xB9\x89" => '&#53873;',
 "\xB9\x8A" => '&#53874;',
 "\xB9\x8B" => '&#53875;',
 "\xB9\x8C" => '&#53876;',
 "\xB9\x8D" => '&#53877;',
 "\xB9\x8E" => '&#53878;',
 "\xB9\x8F" => '&#53879;',
 "\xB9\x90" => '&#53880;',
 "\xB9\x91" => '&#53881;',
 "\xB9\x92" => '&#53882;',
 "\xB9\x93" => '&#53883;',
 "\xB9\x94" => '&#53884;',
 "\xB9\x95" => '&#53885;',
 "\xB9\x96" => '&#53886;',
 "\xB9\x97" => '&#53887;',
 "\xB9\x98" => '&#53890;',
 "\xB9\x99" => '&#53891;',
 "\xB9\x9A" => '&#53893;',
 "\xB9\x9B" => '&#53894;',
 "\xB9\x9C" => '&#53895;',
 "\xB9\x9D" => '&#53897;',
 "\xB9\x9E" => '&#53898;',
 "\xB9\x9F" => '&#53899;',
 "\xB9\xA0" => '&#53900;',
 "\xB9\xA1" => '&#47872;',
 "\xB9\xA2" => '&#47876;',
 "\xB9\xA3" => '&#47885;',
 "\xB9\xA4" => '&#47887;',
 "\xB9\xA5" => '&#47889;',
 "\xB9\xA6" => '&#47896;',
 "\xB9\xA7" => '&#47900;',
 "\xB9\xA8" => '&#47904;',
 "\xB9\xA9" => '&#47913;',
 "\xB9\xAA" => '&#47915;',
 "\xB9\xAB" => '&#47924;',
 "\xB9\xAC" => '&#47925;',
 "\xB9\xAD" => '&#47926;',
 "\xB9\xAE" => '&#47928;',
 "\xB9\xAF" => '&#47931;',
 "\xB9\xB0" => '&#47932;',
 "\xB9\xB1" => '&#47933;',
 "\xB9\xB2" => '&#47934;',
 "\xB9\xB3" => '&#47940;',
 "\xB9\xB4" => '&#47941;',
 "\xB9\xB5" => '&#47943;',
 "\xB9\xB6" => '&#47945;',
 "\xB9\xB7" => '&#47949;',
 "\xB9\xB8" => '&#47951;',
 "\xB9\xB9" => '&#47952;',
 "\xB9\xBA" => '&#47956;',
 "\xB9\xBB" => '&#47960;',
 "\xB9\xBC" => '&#47969;',
 "\xB9\xBD" => '&#47971;',
 "\xB9\xBE" => '&#47980;',
 "\xB9\xBF" => '&#48008;',
 "\xB9\xC0" => '&#48012;',
 "\xB9\xC1" => '&#48016;',
 "\xB9\xC2" => '&#48036;',
 "\xB9\xC3" => '&#48040;',
 "\xB9\xC4" => '&#48044;',
 "\xB9\xC5" => '&#48052;',
 "\xB9\xC6" => '&#48055;',
 "\xB9\xC7" => '&#48064;',
 "\xB9\xC8" => '&#48068;',
 "\xB9\xC9" => '&#48072;',
 "\xB9\xCA" => '&#48080;',
 "\xB9\xCB" => '&#48083;',
 "\xB9\xCC" => '&#48120;',
 "\xB9\xCD" => '&#48121;',
 "\xB9\xCE" => '&#48124;',
 "\xB9\xCF" => '&#48127;',
 "\xB9\xD0" => '&#48128;',
 "\xB9\xD1" => '&#48130;',
 "\xB9\xD2" => '&#48136;',
 "\xB9\xD3" => '&#48137;',
 "\xB9\xD4" => '&#48139;',
 "\xB9\xD5" => '&#48140;',
 "\xB9\xD6" => '&#48141;',
 "\xB9\xD7" => '&#48143;',
 "\xB9\xD8" => '&#48145;',
 "\xB9\xD9" => '&#48148;',
 "\xB9\xDA" => '&#48149;',
 "\xB9\xDB" => '&#48150;',
 "\xB9\xDC" => '&#48151;',
 "\xB9\xDD" => '&#48152;',
 "\xB9\xDE" => '&#48155;',
 "\xB9\xDF" => '&#48156;',
 "\xB9\xE0" => '&#48157;',
 "\xB9\xE1" => '&#48158;',
 "\xB9\xE2" => '&#48159;',
 "\xB9\xE3" => '&#48164;',
 "\xB9\xE4" => '&#48165;',
 "\xB9\xE5" => '&#48167;',
 "\xB9\xE6" => '&#48169;',
 "\xB9\xE7" => '&#48173;',
 "\xB9\xE8" => '&#48176;',
 "\xB9\xE9" => '&#48177;',
 "\xB9\xEA" => '&#48180;',
 "\xB9\xEB" => '&#48184;',
 "\xB9\xEC" => '&#48192;',
 "\xB9\xED" => '&#48193;',
 "\xB9\xEE" => '&#48195;',
 "\xB9\xEF" => '&#48196;',
 "\xB9\xF0" => '&#48197;',
 "\xB9\xF1" => '&#48201;',
 "\xB9\xF2" => '&#48204;',
 "\xB9\xF3" => '&#48205;',
 "\xB9\xF4" => '&#48208;',
 "\xB9\xF5" => '&#48221;',
 "\xB9\xF6" => '&#48260;',
 "\xB9\xF7" => '&#48261;',
 "\xB9\xF8" => '&#48264;',
 "\xB9\xF9" => '&#48267;',
 "\xB9\xFA" => '&#48268;',
 "\xB9\xFB" => '&#48270;',
 "\xB9\xFC" => '&#48276;',
 "\xB9\xFD" => '&#48277;',
 "\xB9\xFE" => '&#48279;',
 "\xBA\x41" => '&#53901;',
 "\xBA\x42" => '&#53902;',
 "\xBA\x43" => '&#53903;',
 "\xBA\x44" => '&#53906;',
 "\xBA\x45" => '&#53907;',
 "\xBA\x46" => '&#53908;',
 "\xBA\x47" => '&#53910;',
 "\xBA\x48" => '&#53911;',
 "\xBA\x49" => '&#53912;',
 "\xBA\x4A" => '&#53913;',
 "\xBA\x4B" => '&#53914;',
 "\xBA\x4C" => '&#53915;',
 "\xBA\x4D" => '&#53917;',
 "\xBA\x4E" => '&#53918;',
 "\xBA\x4F" => '&#53919;',
 "\xBA\x50" => '&#53921;',
 "\xBA\x51" => '&#53922;',
 "\xBA\x52" => '&#53923;',
 "\xBA\x53" => '&#53925;',
 "\xBA\x54" => '&#53926;',
 "\xBA\x55" => '&#53927;',
 "\xBA\x56" => '&#53928;',
 "\xBA\x57" => '&#53929;',
 "\xBA\x58" => '&#53930;',
 "\xBA\x59" => '&#53931;',
 "\xBA\x5A" => '&#53933;',
 "\xBA\x61" => '&#53934;',
 "\xBA\x62" => '&#53935;',
 "\xBA\x63" => '&#53936;',
 "\xBA\x64" => '&#53938;',
 "\xBA\x65" => '&#53939;',
 "\xBA\x66" => '&#53940;',
 "\xBA\x67" => '&#53941;',
 "\xBA\x68" => '&#53942;',
 "\xBA\x69" => '&#53943;',
 "\xBA\x6A" => '&#53946;',
 "\xBA\x6B" => '&#53947;',
 "\xBA\x6C" => '&#53949;',
 "\xBA\x6D" => '&#53950;',
 "\xBA\x6E" => '&#53953;',
 "\xBA\x6F" => '&#53955;',
 "\xBA\x70" => '&#53956;',
 "\xBA\x71" => '&#53957;',
 "\xBA\x72" => '&#53958;',
 "\xBA\x73" => '&#53959;',
 "\xBA\x74" => '&#53962;',
 "\xBA\x75" => '&#53964;',
 "\xBA\x76" => '&#53965;',
 "\xBA\x77" => '&#53966;',
 "\xBA\x78" => '&#53967;',
 "\xBA\x79" => '&#53968;',
 "\xBA\x7A" => '&#53969;',
 "\xBA\x81" => '&#53970;',
 "\xBA\x82" => '&#53971;',
 "\xBA\x83" => '&#53973;',
 "\xBA\x84" => '&#53974;',
 "\xBA\x85" => '&#53975;',
 "\xBA\x86" => '&#53977;',
 "\xBA\x87" => '&#53978;',
 "\xBA\x88" => '&#53979;',
 "\xBA\x89" => '&#53981;',
 "\xBA\x8A" => '&#53982;',
 "\xBA\x8B" => '&#53983;',
 "\xBA\x8C" => '&#53984;',
 "\xBA\x8D" => '&#53985;',
 "\xBA\x8E" => '&#53986;',
 "\xBA\x8F" => '&#53987;',
 "\xBA\x90" => '&#53990;',
 "\xBA\x91" => '&#53991;',
 "\xBA\x92" => '&#53992;',
 "\xBA\x93" => '&#53993;',
 "\xBA\x94" => '&#53994;',
 "\xBA\x95" => '&#53995;',
 "\xBA\x96" => '&#53996;',
 "\xBA\x97" => '&#53997;',
 "\xBA\x98" => '&#53998;',
 "\xBA\x99" => '&#53999;',
 "\xBA\x9A" => '&#54002;',
 "\xBA\x9B" => '&#54003;',
 "\xBA\x9C" => '&#54005;',
 "\xBA\x9D" => '&#54006;',
 "\xBA\x9E" => '&#54007;',
 "\xBA\x9F" => '&#54009;',
 "\xBA\xA0" => '&#54010;',
 "\xBA\xA1" => '&#48281;',
 "\xBA\xA2" => '&#48282;',
 "\xBA\xA3" => '&#48288;',
 "\xBA\xA4" => '&#48289;',
 "\xBA\xA5" => '&#48292;',
 "\xBA\xA6" => '&#48295;',
 "\xBA\xA7" => '&#48296;',
 "\xBA\xA8" => '&#48304;',
 "\xBA\xA9" => '&#48305;',
 "\xBA\xAA" => '&#48307;',
 "\xBA\xAB" => '&#48308;',
 "\xBA\xAC" => '&#48309;',
 "\xBA\xAD" => '&#48316;',
 "\xBA\xAE" => '&#48317;',
 "\xBA\xAF" => '&#48320;',
 "\xBA\xB0" => '&#48324;',
 "\xBA\xB1" => '&#48333;',
 "\xBA\xB2" => '&#48335;',
 "\xBA\xB3" => '&#48336;',
 "\xBA\xB4" => '&#48337;',
 "\xBA\xB5" => '&#48341;',
 "\xBA\xB6" => '&#48344;',
 "\xBA\xB7" => '&#48348;',
 "\xBA\xB8" => '&#48372;',
 "\xBA\xB9" => '&#48373;',
 "\xBA\xBA" => '&#48374;',
 "\xBA\xBB" => '&#48376;',
 "\xBA\xBC" => '&#48380;',
 "\xBA\xBD" => '&#48388;',
 "\xBA\xBE" => '&#48389;',
 "\xBA\xBF" => '&#48391;',
 "\xBA\xC0" => '&#48393;',
 "\xBA\xC1" => '&#48400;',
 "\xBA\xC2" => '&#48404;',
 "\xBA\xC3" => '&#48420;',
 "\xBA\xC4" => '&#48428;',
 "\xBA\xC5" => '&#48448;',
 "\xBA\xC6" => '&#48456;',
 "\xBA\xC7" => '&#48457;',
 "\xBA\xC8" => '&#48460;',
 "\xBA\xC9" => '&#48464;',
 "\xBA\xCA" => '&#48472;',
 "\xBA\xCB" => '&#48473;',
 "\xBA\xCC" => '&#48484;',
 "\xBA\xCD" => '&#48488;',
 "\xBA\xCE" => '&#48512;',
 "\xBA\xCF" => '&#48513;',
 "\xBA\xD0" => '&#48516;',
 "\xBA\xD1" => '&#48519;',
 "\xBA\xD2" => '&#48520;',
 "\xBA\xD3" => '&#48521;',
 "\xBA\xD4" => '&#48522;',
 "\xBA\xD5" => '&#48528;',
 "\xBA\xD6" => '&#48529;',
 "\xBA\xD7" => '&#48531;',
 "\xBA\xD8" => '&#48533;',
 "\xBA\xD9" => '&#48537;',
 "\xBA\xDA" => '&#48538;',
 "\xBA\xDB" => '&#48540;',
 "\xBA\xDC" => '&#48548;',
 "\xBA\xDD" => '&#48560;',
 "\xBA\xDE" => '&#48568;',
 "\xBA\xDF" => '&#48596;',
 "\xBA\xE0" => '&#48597;',
 "\xBA\xE1" => '&#48600;',
 "\xBA\xE2" => '&#48604;',
 "\xBA\xE3" => '&#48617;',
 "\xBA\xE4" => '&#48624;',
 "\xBA\xE5" => '&#48628;',
 "\xBA\xE6" => '&#48632;',
 "\xBA\xE7" => '&#48640;',
 "\xBA\xE8" => '&#48643;',
 "\xBA\xE9" => '&#48645;',
 "\xBA\xEA" => '&#48652;',
 "\xBA\xEB" => '&#48653;',
 "\xBA\xEC" => '&#48656;',
 "\xBA\xED" => '&#48660;',
 "\xBA\xEE" => '&#48668;',
 "\xBA\xEF" => '&#48669;',
 "\xBA\xF0" => '&#48671;',
 "\xBA\xF1" => '&#48708;',
 "\xBA\xF2" => '&#48709;',
 "\xBA\xF3" => '&#48712;',
 "\xBA\xF4" => '&#48716;',
 "\xBA\xF5" => '&#48718;',
 "\xBA\xF6" => '&#48724;',
 "\xBA\xF7" => '&#48725;',
 "\xBA\xF8" => '&#48727;',
 "\xBA\xF9" => '&#48729;',
 "\xBA\xFA" => '&#48730;',
 "\xBA\xFB" => '&#48731;',
 "\xBA\xFC" => '&#48736;',
 "\xBA\xFD" => '&#48737;',
 "\xBA\xFE" => '&#48740;',
 "\xBB\x41" => '&#54011;',
 "\xBB\x42" => '&#54012;',
 "\xBB\x43" => '&#54013;',
 "\xBB\x44" => '&#54014;',
 "\xBB\x45" => '&#54015;',
 "\xBB\x46" => '&#54018;',
 "\xBB\x47" => '&#54020;',
 "\xBB\x48" => '&#54022;',
 "\xBB\x49" => '&#54023;',
 "\xBB\x4A" => '&#54024;',
 "\xBB\x4B" => '&#54025;',
 "\xBB\x4C" => '&#54026;',
 "\xBB\x4D" => '&#54027;',
 "\xBB\x4E" => '&#54031;',
 "\xBB\x4F" => '&#54033;',
 "\xBB\x50" => '&#54034;',
 "\xBB\x51" => '&#54035;',
 "\xBB\x52" => '&#54037;',
 "\xBB\x53" => '&#54039;',
 "\xBB\x54" => '&#54040;',
 "\xBB\x55" => '&#54041;',
 "\xBB\x56" => '&#54042;',
 "\xBB\x57" => '&#54043;',
 "\xBB\x58" => '&#54046;',
 "\xBB\x59" => '&#54050;',
 "\xBB\x5A" => '&#54051;',
 "\xBB\x61" => '&#54052;',
 "\xBB\x62" => '&#54054;',
 "\xBB\x63" => '&#54055;',
 "\xBB\x64" => '&#54058;',
 "\xBB\x65" => '&#54059;',
 "\xBB\x66" => '&#54061;',
 "\xBB\x67" => '&#54062;',
 "\xBB\x68" => '&#54063;',
 "\xBB\x69" => '&#54065;',
 "\xBB\x6A" => '&#54066;',
 "\xBB\x6B" => '&#54067;',
 "\xBB\x6C" => '&#54068;',
 "\xBB\x6D" => '&#54069;',
 "\xBB\x6E" => '&#54070;',
 "\xBB\x6F" => '&#54071;',
 "\xBB\x70" => '&#54074;',
 "\xBB\x71" => '&#54078;',
 "\xBB\x72" => '&#54079;',
 "\xBB\x73" => '&#54080;',
 "\xBB\x74" => '&#54081;',
 "\xBB\x75" => '&#54082;',
 "\xBB\x76" => '&#54083;',
 "\xBB\x77" => '&#54086;',
 "\xBB\x78" => '&#54087;',
 "\xBB\x79" => '&#54088;',
 "\xBB\x7A" => '&#54089;',
 "\xBB\x81" => '&#54090;',
 "\xBB\x82" => '&#54091;',
 "\xBB\x83" => '&#54092;',
 "\xBB\x84" => '&#54093;',
 "\xBB\x85" => '&#54094;',
 "\xBB\x86" => '&#54095;',
 "\xBB\x87" => '&#54096;',
 "\xBB\x88" => '&#54097;',
 "\xBB\x89" => '&#54098;',
 "\xBB\x8A" => '&#54099;',
 "\xBB\x8B" => '&#54100;',
 "\xBB\x8C" => '&#54101;',
 "\xBB\x8D" => '&#54102;',
 "\xBB\x8E" => '&#54103;',
 "\xBB\x8F" => '&#54104;',
 "\xBB\x90" => '&#54105;',
 "\xBB\x91" => '&#54106;',
 "\xBB\x92" => '&#54107;',
 "\xBB\x93" => '&#54108;',
 "\xBB\x94" => '&#54109;',
 "\xBB\x95" => '&#54110;',
 "\xBB\x96" => '&#54111;',
 "\xBB\x97" => '&#54112;',
 "\xBB\x98" => '&#54113;',
 "\xBB\x99" => '&#54114;',
 "\xBB\x9A" => '&#54115;',
 "\xBB\x9B" => '&#54116;',
 "\xBB\x9C" => '&#54117;',
 "\xBB\x9D" => '&#54118;',
 "\xBB\x9E" => '&#54119;',
 "\xBB\x9F" => '&#54120;',
 "\xBB\xA0" => '&#54121;',
 "\xBB\xA1" => '&#48744;',
 "\xBB\xA2" => '&#48746;',
 "\xBB\xA3" => '&#48752;',
 "\xBB\xA4" => '&#48753;',
 "\xBB\xA5" => '&#48755;',
 "\xBB\xA6" => '&#48756;',
 "\xBB\xA7" => '&#48757;',
 "\xBB\xA8" => '&#48763;',
 "\xBB\xA9" => '&#48764;',
 "\xBB\xAA" => '&#48765;',
 "\xBB\xAB" => '&#48768;',
 "\xBB\xAC" => '&#48772;',
 "\xBB\xAD" => '&#48780;',
 "\xBB\xAE" => '&#48781;',
 "\xBB\xAF" => '&#48783;',
 "\xBB\xB0" => '&#48784;',
 "\xBB\xB1" => '&#48785;',
 "\xBB\xB2" => '&#48792;',
 "\xBB\xB3" => '&#48793;',
 "\xBB\xB4" => '&#48808;',
 "\xBB\xB5" => '&#48848;',
 "\xBB\xB6" => '&#48849;',
 "\xBB\xB7" => '&#48852;',
 "\xBB\xB8" => '&#48855;',
 "\xBB\xB9" => '&#48856;',
 "\xBB\xBA" => '&#48864;',
 "\xBB\xBB" => '&#48867;',
 "\xBB\xBC" => '&#48868;',
 "\xBB\xBD" => '&#48869;',
 "\xBB\xBE" => '&#48876;',
 "\xBB\xBF" => '&#48897;',
 "\xBB\xC0" => '&#48904;',
 "\xBB\xC1" => '&#48905;',
 "\xBB\xC2" => '&#48920;',
 "\xBB\xC3" => '&#48921;',
 "\xBB\xC4" => '&#48923;',
 "\xBB\xC5" => '&#48924;',
 "\xBB\xC6" => '&#48925;',
 "\xBB\xC7" => '&#48960;',
 "\xBB\xC8" => '&#48961;',
 "\xBB\xC9" => '&#48964;',
 "\xBB\xCA" => '&#48968;',
 "\xBB\xCB" => '&#48976;',
 "\xBB\xCC" => '&#48977;',
 "\xBB\xCD" => '&#48981;',
 "\xBB\xCE" => '&#49044;',
 "\xBB\xCF" => '&#49072;',
 "\xBB\xD0" => '&#49093;',
 "\xBB\xD1" => '&#49100;',
 "\xBB\xD2" => '&#49101;',
 "\xBB\xD3" => '&#49104;',
 "\xBB\xD4" => '&#49108;',
 "\xBB\xD5" => '&#49116;',
 "\xBB\xD6" => '&#49119;',
 "\xBB\xD7" => '&#49121;',
 "\xBB\xD8" => '&#49212;',
 "\xBB\xD9" => '&#49233;',
 "\xBB\xDA" => '&#49240;',
 "\xBB\xDB" => '&#49244;',
 "\xBB\xDC" => '&#49248;',
 "\xBB\xDD" => '&#49256;',
 "\xBB\xDE" => '&#49257;',
 "\xBB\xDF" => '&#49296;',
 "\xBB\xE0" => '&#49297;',
 "\xBB\xE1" => '&#49300;',
 "\xBB\xE2" => '&#49304;',
 "\xBB\xE3" => '&#49312;',
 "\xBB\xE4" => '&#49313;',
 "\xBB\xE5" => '&#49315;',
 "\xBB\xE6" => '&#49317;',
 "\xBB\xE7" => '&#49324;',
 "\xBB\xE8" => '&#49325;',
 "\xBB\xE9" => '&#49327;',
 "\xBB\xEA" => '&#49328;',
 "\xBB\xEB" => '&#49331;',
 "\xBB\xEC" => '&#49332;',
 "\xBB\xED" => '&#49333;',
 "\xBB\xEE" => '&#49334;',
 "\xBB\xEF" => '&#49340;',
 "\xBB\xF0" => '&#49341;',
 "\xBB\xF1" => '&#49343;',
 "\xBB\xF2" => '&#49344;',
 "\xBB\xF3" => '&#49345;',
 "\xBB\xF4" => '&#49349;',
 "\xBB\xF5" => '&#49352;',
 "\xBB\xF6" => '&#49353;',
 "\xBB\xF7" => '&#49356;',
 "\xBB\xF8" => '&#49360;',
 "\xBB\xF9" => '&#49368;',
 "\xBB\xFA" => '&#49369;',
 "\xBB\xFB" => '&#49371;',
 "\xBB\xFC" => '&#49372;',
 "\xBB\xFD" => '&#49373;',
 "\xBB\xFE" => '&#49380;',
 "\xBC\x41" => '&#54122;',
 "\xBC\x42" => '&#54123;',
 "\xBC\x43" => '&#54124;',
 "\xBC\x44" => '&#54125;',
 "\xBC\x45" => '&#54126;',
 "\xBC\x46" => '&#54127;',
 "\xBC\x47" => '&#54128;',
 "\xBC\x48" => '&#54129;',
 "\xBC\x49" => '&#54130;',
 "\xBC\x4A" => '&#54131;',
 "\xBC\x4B" => '&#54132;',
 "\xBC\x4C" => '&#54133;',
 "\xBC\x4D" => '&#54134;',
 "\xBC\x4E" => '&#54135;',
 "\xBC\x4F" => '&#54136;',
 "\xBC\x50" => '&#54137;',
 "\xBC\x51" => '&#54138;',
 "\xBC\x52" => '&#54139;',
 "\xBC\x53" => '&#54142;',
 "\xBC\x54" => '&#54143;',
 "\xBC\x55" => '&#54145;',
 "\xBC\x56" => '&#54146;',
 "\xBC\x57" => '&#54147;',
 "\xBC\x58" => '&#54149;',
 "\xBC\x59" => '&#54150;',
 "\xBC\x5A" => '&#54151;',
 "\xBC\x61" => '&#54152;',
 "\xBC\x62" => '&#54153;',
 "\xBC\x63" => '&#54154;',
 "\xBC\x64" => '&#54155;',
 "\xBC\x65" => '&#54158;',
 "\xBC\x66" => '&#54162;',
 "\xBC\x67" => '&#54163;',
 "\xBC\x68" => '&#54164;',
 "\xBC\x69" => '&#54165;',
 "\xBC\x6A" => '&#54166;',
 "\xBC\x6B" => '&#54167;',
 "\xBC\x6C" => '&#54170;',
 "\xBC\x6D" => '&#54171;',
 "\xBC\x6E" => '&#54173;',
 "\xBC\x6F" => '&#54174;',
 "\xBC\x70" => '&#54175;',
 "\xBC\x71" => '&#54177;',
 "\xBC\x72" => '&#54178;',
 "\xBC\x73" => '&#54179;',
 "\xBC\x74" => '&#54180;',
 "\xBC\x75" => '&#54181;',
 "\xBC\x76" => '&#54182;',
 "\xBC\x77" => '&#54183;',
 "\xBC\x78" => '&#54186;',
 "\xBC\x79" => '&#54188;',
 "\xBC\x7A" => '&#54190;',
 "\xBC\x81" => '&#54191;',
 "\xBC\x82" => '&#54192;',
 "\xBC\x83" => '&#54193;',
 "\xBC\x84" => '&#54194;',
 "\xBC\x85" => '&#54195;',
 "\xBC\x86" => '&#54197;',
 "\xBC\x87" => '&#54198;',
 "\xBC\x88" => '&#54199;',
 "\xBC\x89" => '&#54201;',
 "\xBC\x8A" => '&#54202;',
 "\xBC\x8B" => '&#54203;',
 "\xBC\x8C" => '&#54205;',
 "\xBC\x8D" => '&#54206;',
 "\xBC\x8E" => '&#54207;',
 "\xBC\x8F" => '&#54208;',
 "\xBC\x90" => '&#54209;',
 "\xBC\x91" => '&#54210;',
 "\xBC\x92" => '&#54211;',
 "\xBC\x93" => '&#54214;',
 "\xBC\x94" => '&#54215;',
 "\xBC\x95" => '&#54218;',
 "\xBC\x96" => '&#54219;',
 "\xBC\x97" => '&#54220;',
 "\xBC\x98" => '&#54221;',
 "\xBC\x99" => '&#54222;',
 "\xBC\x9A" => '&#54223;',
 "\xBC\x9B" => '&#54225;',
 "\xBC\x9C" => '&#54226;',
 "\xBC\x9D" => '&#54227;',
 "\xBC\x9E" => '&#54228;',
 "\xBC\x9F" => '&#54229;',
 "\xBC\xA0" => '&#54230;',
 "\xBC\xA1" => '&#49381;',
 "\xBC\xA2" => '&#49384;',
 "\xBC\xA3" => '&#49388;',
 "\xBC\xA4" => '&#49396;',
 "\xBC\xA5" => '&#49397;',
 "\xBC\xA6" => '&#49399;',
 "\xBC\xA7" => '&#49401;',
 "\xBC\xA8" => '&#49408;',
 "\xBC\xA9" => '&#49412;',
 "\xBC\xAA" => '&#49416;',
 "\xBC\xAB" => '&#49424;',
 "\xBC\xAC" => '&#49429;',
 "\xBC\xAD" => '&#49436;',
 "\xBC\xAE" => '&#49437;',
 "\xBC\xAF" => '&#49438;',
 "\xBC\xB0" => '&#49439;',
 "\xBC\xB1" => '&#49440;',
 "\xBC\xB2" => '&#49443;',
 "\xBC\xB3" => '&#49444;',
 "\xBC\xB4" => '&#49446;',
 "\xBC\xB5" => '&#49447;',
 "\xBC\xB6" => '&#49452;',
 "\xBC\xB7" => '&#49453;',
 "\xBC\xB8" => '&#49455;',
 "\xBC\xB9" => '&#49456;',
 "\xBC\xBA" => '&#49457;',
 "\xBC\xBB" => '&#49462;',
 "\xBC\xBC" => '&#49464;',
 "\xBC\xBD" => '&#49465;',
 "\xBC\xBE" => '&#49468;',
 "\xBC\xBF" => '&#49472;',
 "\xBC\xC0" => '&#49480;',
 "\xBC\xC1" => '&#49481;',
 "\xBC\xC2" => '&#49483;',
 "\xBC\xC3" => '&#49484;',
 "\xBC\xC4" => '&#49485;',
 "\xBC\xC5" => '&#49492;',
 "\xBC\xC6" => '&#49493;',
 "\xBC\xC7" => '&#49496;',
 "\xBC\xC8" => '&#49500;',
 "\xBC\xC9" => '&#49508;',
 "\xBC\xCA" => '&#49509;',
 "\xBC\xCB" => '&#49511;',
 "\xBC\xCC" => '&#49512;',
 "\xBC\xCD" => '&#49513;',
 "\xBC\xCE" => '&#49520;',
 "\xBC\xCF" => '&#49524;',
 "\xBC\xD0" => '&#49528;',
 "\xBC\xD1" => '&#49541;',
 "\xBC\xD2" => '&#49548;',
 "\xBC\xD3" => '&#49549;',
 "\xBC\xD4" => '&#49550;',
 "\xBC\xD5" => '&#49552;',
 "\xBC\xD6" => '&#49556;',
 "\xBC\xD7" => '&#49558;',
 "\xBC\xD8" => '&#49564;',
 "\xBC\xD9" => '&#49565;',
 "\xBC\xDA" => '&#49567;',
 "\xBC\xDB" => '&#49569;',
 "\xBC\xDC" => '&#49573;',
 "\xBC\xDD" => '&#49576;',
 "\xBC\xDE" => '&#49577;',
 "\xBC\xDF" => '&#49580;',
 "\xBC\xE0" => '&#49584;',
 "\xBC\xE1" => '&#49597;',
 "\xBC\xE2" => '&#49604;',
 "\xBC\xE3" => '&#49608;',
 "\xBC\xE4" => '&#49612;',
 "\xBC\xE5" => '&#49620;',
 "\xBC\xE6" => '&#49623;',
 "\xBC\xE7" => '&#49624;',
 "\xBC\xE8" => '&#49632;',
 "\xBC\xE9" => '&#49636;',
 "\xBC\xEA" => '&#49640;',
 "\xBC\xEB" => '&#49648;',
 "\xBC\xEC" => '&#49649;',
 "\xBC\xED" => '&#49651;',
 "\xBC\xEE" => '&#49660;',
 "\xBC\xEF" => '&#49661;',
 "\xBC\xF0" => '&#49664;',
 "\xBC\xF1" => '&#49668;',
 "\xBC\xF2" => '&#49676;',
 "\xBC\xF3" => '&#49677;',
 "\xBC\xF4" => '&#49679;',
 "\xBC\xF5" => '&#49681;',
 "\xBC\xF6" => '&#49688;',
 "\xBC\xF7" => '&#49689;',
 "\xBC\xF8" => '&#49692;',
 "\xBC\xF9" => '&#49695;',
 "\xBC\xFA" => '&#49696;',
 "\xBC\xFB" => '&#49704;',
 "\xBC\xFC" => '&#49705;',
 "\xBC\xFD" => '&#49707;',
 "\xBC\xFE" => '&#49709;',
 "\xBD\x41" => '&#54231;',
 "\xBD\x42" => '&#54233;',
 "\xBD\x43" => '&#54234;',
 "\xBD\x44" => '&#54235;',
 "\xBD\x45" => '&#54236;',
 "\xBD\x46" => '&#54237;',
 "\xBD\x47" => '&#54238;',
 "\xBD\x48" => '&#54239;',
 "\xBD\x49" => '&#54240;',
 "\xBD\x4A" => '&#54242;',
 "\xBD\x4B" => '&#54244;',
 "\xBD\x4C" => '&#54245;',
 "\xBD\x4D" => '&#54246;',
 "\xBD\x4E" => '&#54247;',
 "\xBD\x4F" => '&#54248;',
 "\xBD\x50" => '&#54249;',
 "\xBD\x51" => '&#54250;',
 "\xBD\x52" => '&#54251;',
 "\xBD\x53" => '&#54254;',
 "\xBD\x54" => '&#54255;',
 "\xBD\x55" => '&#54257;',
 "\xBD\x56" => '&#54258;',
 "\xBD\x57" => '&#54259;',
 "\xBD\x58" => '&#54261;',
 "\xBD\x59" => '&#54262;',
 "\xBD\x5A" => '&#54263;',
 "\xBD\x61" => '&#54264;',
 "\xBD\x62" => '&#54265;',
 "\xBD\x63" => '&#54266;',
 "\xBD\x64" => '&#54267;',
 "\xBD\x65" => '&#54270;',
 "\xBD\x66" => '&#54272;',
 "\xBD\x67" => '&#54274;',
 "\xBD\x68" => '&#54275;',
 "\xBD\x69" => '&#54276;',
 "\xBD\x6A" => '&#54277;',
 "\xBD\x6B" => '&#54278;',
 "\xBD\x6C" => '&#54279;',
 "\xBD\x6D" => '&#54281;',
 "\xBD\x6E" => '&#54282;',
 "\xBD\x6F" => '&#54283;',
 "\xBD\x70" => '&#54284;',
 "\xBD\x71" => '&#54285;',
 "\xBD\x72" => '&#54286;',
 "\xBD\x73" => '&#54287;',
 "\xBD\x74" => '&#54288;',
 "\xBD\x75" => '&#54289;',
 "\xBD\x76" => '&#54290;',
 "\xBD\x77" => '&#54291;',
 "\xBD\x78" => '&#54292;',
 "\xBD\x79" => '&#54293;',
 "\xBD\x7A" => '&#54294;',
 "\xBD\x81" => '&#54295;',
 "\xBD\x82" => '&#54296;',
 "\xBD\x83" => '&#54297;',
 "\xBD\x84" => '&#54298;',
 "\xBD\x85" => '&#54299;',
 "\xBD\x86" => '&#54300;',
 "\xBD\x87" => '&#54302;',
 "\xBD\x88" => '&#54303;',
 "\xBD\x89" => '&#54304;',
 "\xBD\x8A" => '&#54305;',
 "\xBD\x8B" => '&#54306;',
 "\xBD\x8C" => '&#54307;',
 "\xBD\x8D" => '&#54308;',
 "\xBD\x8E" => '&#54309;',
 "\xBD\x8F" => '&#54310;',
 "\xBD\x90" => '&#54311;',
 "\xBD\x91" => '&#54312;',
 "\xBD\x92" => '&#54313;',
 "\xBD\x93" => '&#54314;',
 "\xBD\x94" => '&#54315;',
 "\xBD\x95" => '&#54316;',
 "\xBD\x96" => '&#54317;',
 "\xBD\x97" => '&#54318;',
 "\xBD\x98" => '&#54319;',
 "\xBD\x99" => '&#54320;',
 "\xBD\x9A" => '&#54321;',
 "\xBD\x9B" => '&#54322;',
 "\xBD\x9C" => '&#54323;',
 "\xBD\x9D" => '&#54324;',
 "\xBD\x9E" => '&#54325;',
 "\xBD\x9F" => '&#54326;',
 "\xBD\xA0" => '&#54327;',
 "\xBD\xA1" => '&#49711;',
 "\xBD\xA2" => '&#49713;',
 "\xBD\xA3" => '&#49714;',
 "\xBD\xA4" => '&#49716;',
 "\xBD\xA5" => '&#49736;',
 "\xBD\xA6" => '&#49744;',
 "\xBD\xA7" => '&#49745;',
 "\xBD\xA8" => '&#49748;',
 "\xBD\xA9" => '&#49752;',
 "\xBD\xAA" => '&#49760;',
 "\xBD\xAB" => '&#49765;',
 "\xBD\xAC" => '&#49772;',
 "\xBD\xAD" => '&#49773;',
 "\xBD\xAE" => '&#49776;',
 "\xBD\xAF" => '&#49780;',
 "\xBD\xB0" => '&#49788;',
 "\xBD\xB1" => '&#49789;',
 "\xBD\xB2" => '&#49791;',
 "\xBD\xB3" => '&#49793;',
 "\xBD\xB4" => '&#49800;',
 "\xBD\xB5" => '&#49801;',
 "\xBD\xB6" => '&#49808;',
 "\xBD\xB7" => '&#49816;',
 "\xBD\xB8" => '&#49819;',
 "\xBD\xB9" => '&#49821;',
 "\xBD\xBA" => '&#49828;',
 "\xBD\xBB" => '&#49829;',
 "\xBD\xBC" => '&#49832;',
 "\xBD\xBD" => '&#49836;',
 "\xBD\xBE" => '&#49837;',
 "\xBD\xBF" => '&#49844;',
 "\xBD\xC0" => '&#49845;',
 "\xBD\xC1" => '&#49847;',
 "\xBD\xC2" => '&#49849;',
 "\xBD\xC3" => '&#49884;',
 "\xBD\xC4" => '&#49885;',
 "\xBD\xC5" => '&#49888;',
 "\xBD\xC6" => '&#49891;',
 "\xBD\xC7" => '&#49892;',
 "\xBD\xC8" => '&#49899;',
 "\xBD\xC9" => '&#49900;',
 "\xBD\xCA" => '&#49901;',
 "\xBD\xCB" => '&#49903;',
 "\xBD\xCC" => '&#49905;',
 "\xBD\xCD" => '&#49910;',
 "\xBD\xCE" => '&#49912;',
 "\xBD\xCF" => '&#49913;',
 "\xBD\xD0" => '&#49915;',
 "\xBD\xD1" => '&#49916;',
 "\xBD\xD2" => '&#49920;',
 "\xBD\xD3" => '&#49928;',
 "\xBD\xD4" => '&#49929;',
 "\xBD\xD5" => '&#49932;',
 "\xBD\xD6" => '&#49933;',
 "\xBD\xD7" => '&#49939;',
 "\xBD\xD8" => '&#49940;',
 "\xBD\xD9" => '&#49941;',
 "\xBD\xDA" => '&#49944;',
 "\xBD\xDB" => '&#49948;',
 "\xBD\xDC" => '&#49956;',
 "\xBD\xDD" => '&#49957;',
 "\xBD\xDE" => '&#49960;',
 "\xBD\xDF" => '&#49961;',
 "\xBD\xE0" => '&#49989;',
 "\xBD\xE1" => '&#50024;',
 "\xBD\xE2" => '&#50025;',
 "\xBD\xE3" => '&#50028;',
 "\xBD\xE4" => '&#50032;',
 "\xBD\xE5" => '&#50034;',
 "\xBD\xE6" => '&#50040;',
 "\xBD\xE7" => '&#50041;',
 "\xBD\xE8" => '&#50044;',
 "\xBD\xE9" => '&#50045;',
 "\xBD\xEA" => '&#50052;',
 "\xBD\xEB" => '&#50056;',
 "\xBD\xEC" => '&#50060;',
 "\xBD\xED" => '&#50112;',
 "\xBD\xEE" => '&#50136;',
 "\xBD\xEF" => '&#50137;',
 "\xBD\xF0" => '&#50140;',
 "\xBD\xF1" => '&#50143;',
 "\xBD\xF2" => '&#50144;',
 "\xBD\xF3" => '&#50146;',
 "\xBD\xF4" => '&#50152;',
 "\xBD\xF5" => '&#50153;',
 "\xBD\xF6" => '&#50157;',
 "\xBD\xF7" => '&#50164;',
 "\xBD\xF8" => '&#50165;',
 "\xBD\xF9" => '&#50168;',
 "\xBD\xFA" => '&#50184;',
 "\xBD\xFB" => '&#50192;',
 "\xBD\xFC" => '&#50212;',
 "\xBD\xFD" => '&#50220;',
 "\xBD\xFE" => '&#50224;',
 "\xBE\x41" => '&#54328;',
 "\xBE\x42" => '&#54329;',
 "\xBE\x43" => '&#54330;',
 "\xBE\x44" => '&#54331;',
 "\xBE\x45" => '&#54332;',
 "\xBE\x46" => '&#54333;',
 "\xBE\x47" => '&#54334;',
 "\xBE\x48" => '&#54335;',
 "\xBE\x49" => '&#54337;',
 "\xBE\x4A" => '&#54338;',
 "\xBE\x4B" => '&#54339;',
 "\xBE\x4C" => '&#54341;',
 "\xBE\x4D" => '&#54342;',
 "\xBE\x4E" => '&#54343;',
 "\xBE\x4F" => '&#54344;',
 "\xBE\x50" => '&#54345;',
 "\xBE\x51" => '&#54346;',
 "\xBE\x52" => '&#54347;',
 "\xBE\x53" => '&#54348;',
 "\xBE\x54" => '&#54349;',
 "\xBE\x55" => '&#54350;',
 "\xBE\x56" => '&#54351;',
 "\xBE\x57" => '&#54352;',
 "\xBE\x58" => '&#54353;',
 "\xBE\x59" => '&#54354;',
 "\xBE\x5A" => '&#54355;',
 "\xBE\x61" => '&#54356;',
 "\xBE\x62" => '&#54357;',
 "\xBE\x63" => '&#54358;',
 "\xBE\x64" => '&#54359;',
 "\xBE\x65" => '&#54360;',
 "\xBE\x66" => '&#54361;',
 "\xBE\x67" => '&#54362;',
 "\xBE\x68" => '&#54363;',
 "\xBE\x69" => '&#54365;',
 "\xBE\x6A" => '&#54366;',
 "\xBE\x6B" => '&#54367;',
 "\xBE\x6C" => '&#54369;',
 "\xBE\x6D" => '&#54370;',
 "\xBE\x6E" => '&#54371;',
 "\xBE\x6F" => '&#54373;',
 "\xBE\x70" => '&#54374;',
 "\xBE\x71" => '&#54375;',
 "\xBE\x72" => '&#54376;',
 "\xBE\x73" => '&#54377;',
 "\xBE\x74" => '&#54378;',
 "\xBE\x75" => '&#54379;',
 "\xBE\x76" => '&#54380;',
 "\xBE\x77" => '&#54382;',
 "\xBE\x78" => '&#54384;',
 "\xBE\x79" => '&#54385;',
 "\xBE\x7A" => '&#54386;',
 "\xBE\x81" => '&#54387;',
 "\xBE\x82" => '&#54388;',
 "\xBE\x83" => '&#54389;',
 "\xBE\x84" => '&#54390;',
 "\xBE\x85" => '&#54391;',
 "\xBE\x86" => '&#54394;',
 "\xBE\x87" => '&#54395;',
 "\xBE\x88" => '&#54397;',
 "\xBE\x89" => '&#54398;',
 "\xBE\x8A" => '&#54401;',
 "\xBE\x8B" => '&#54403;',
 "\xBE\x8C" => '&#54404;',
 "\xBE\x8D" => '&#54405;',
 "\xBE\x8E" => '&#54406;',
 "\xBE\x8F" => '&#54407;',
 "\xBE\x90" => '&#54410;',
 "\xBE\x91" => '&#54412;',
 "\xBE\x92" => '&#54414;',
 "\xBE\x93" => '&#54415;',
 "\xBE\x94" => '&#54416;',
 "\xBE\x95" => '&#54417;',
 "\xBE\x96" => '&#54418;',
 "\xBE\x97" => '&#54419;',
 "\xBE\x98" => '&#54421;',
 "\xBE\x99" => '&#54422;',
 "\xBE\x9A" => '&#54423;',
 "\xBE\x9B" => '&#54424;',
 "\xBE\x9C" => '&#54425;',
 "\xBE\x9D" => '&#54426;',
 "\xBE\x9E" => '&#54427;',
 "\xBE\x9F" => '&#54428;',
 "\xBE\xA0" => '&#54429;',
 "\xBE\xA1" => '&#50228;',
 "\xBE\xA2" => '&#50236;',
 "\xBE\xA3" => '&#50237;',
 "\xBE\xA4" => '&#50248;',
 "\xBE\xA5" => '&#50276;',
 "\xBE\xA6" => '&#50277;',
 "\xBE\xA7" => '&#50280;',
 "\xBE\xA8" => '&#50284;',
 "\xBE\xA9" => '&#50292;',
 "\xBE\xAA" => '&#50293;',
 "\xBE\xAB" => '&#50297;',
 "\xBE\xAC" => '&#50304;',
 "\xBE\xAD" => '&#50324;',
 "\xBE\xAE" => '&#50332;',
 "\xBE\xAF" => '&#50360;',
 "\xBE\xB0" => '&#50364;',
 "\xBE\xB1" => '&#50409;',
 "\xBE\xB2" => '&#50416;',
 "\xBE\xB3" => '&#50417;',
 "\xBE\xB4" => '&#50420;',
 "\xBE\xB5" => '&#50424;',
 "\xBE\xB6" => '&#50426;',
 "\xBE\xB7" => '&#50431;',
 "\xBE\xB8" => '&#50432;',
 "\xBE\xB9" => '&#50433;',
 "\xBE\xBA" => '&#50444;',
 "\xBE\xBB" => '&#50448;',
 "\xBE\xBC" => '&#50452;',
 "\xBE\xBD" => '&#50460;',
 "\xBE\xBE" => '&#50472;',
 "\xBE\xBF" => '&#50473;',
 "\xBE\xC0" => '&#50476;',
 "\xBE\xC1" => '&#50480;',
 "\xBE\xC2" => '&#50488;',
 "\xBE\xC3" => '&#50489;',
 "\xBE\xC4" => '&#50491;',
 "\xBE\xC5" => '&#50493;',
 "\xBE\xC6" => '&#50500;',
 "\xBE\xC7" => '&#50501;',
 "\xBE\xC8" => '&#50504;',
 "\xBE\xC9" => '&#50505;',
 "\xBE\xCA" => '&#50506;',
 "\xBE\xCB" => '&#50508;',
 "\xBE\xCC" => '&#50509;',
 "\xBE\xCD" => '&#50510;',
 "\xBE\xCE" => '&#50515;',
 "\xBE\xCF" => '&#50516;',
 "\xBE\xD0" => '&#50517;',
 "\xBE\xD1" => '&#50519;',
 "\xBE\xD2" => '&#50520;',
 "\xBE\xD3" => '&#50521;',
 "\xBE\xD4" => '&#50525;',
 "\xBE\xD5" => '&#50526;',
 "\xBE\xD6" => '&#50528;',
 "\xBE\xD7" => '&#50529;',
 "\xBE\xD8" => '&#50532;',
 "\xBE\xD9" => '&#50536;',
 "\xBE\xDA" => '&#50544;',
 "\xBE\xDB" => '&#50545;',
 "\xBE\xDC" => '&#50547;',
 "\xBE\xDD" => '&#50548;',
 "\xBE\xDE" => '&#50549;',
 "\xBE\xDF" => '&#50556;',
 "\xBE\xE0" => '&#50557;',
 "\xBE\xE1" => '&#50560;',
 "\xBE\xE2" => '&#50564;',
 "\xBE\xE3" => '&#50567;',
 "\xBE\xE4" => '&#50572;',
 "\xBE\xE5" => '&#50573;',
 "\xBE\xE6" => '&#50575;',
 "\xBE\xE7" => '&#50577;',
 "\xBE\xE8" => '&#50581;',
 "\xBE\xE9" => '&#50583;',
 "\xBE\xEA" => '&#50584;',
 "\xBE\xEB" => '&#50588;',
 "\xBE\xEC" => '&#50592;',
 "\xBE\xED" => '&#50601;',
 "\xBE\xEE" => '&#50612;',
 "\xBE\xEF" => '&#50613;',
 "\xBE\xF0" => '&#50616;',
 "\xBE\xF1" => '&#50617;',
 "\xBE\xF2" => '&#50619;',
 "\xBE\xF3" => '&#50620;',
 "\xBE\xF4" => '&#50621;',
 "\xBE\xF5" => '&#50622;',
 "\xBE\xF6" => '&#50628;',
 "\xBE\xF7" => '&#50629;',
 "\xBE\xF8" => '&#50630;',
 "\xBE\xF9" => '&#50631;',
 "\xBE\xFA" => '&#50632;',
 "\xBE\xFB" => '&#50633;',
 "\xBE\xFC" => '&#50634;',
 "\xBE\xFD" => '&#50636;',
 "\xBE\xFE" => '&#50638;',
 "\xBF\x41" => '&#54430;',
 "\xBF\x42" => '&#54431;',
 "\xBF\x43" => '&#54432;',
 "\xBF\x44" => '&#54433;',
 "\xBF\x45" => '&#54434;',
 "\xBF\x46" => '&#54435;',
 "\xBF\x47" => '&#54436;',
 "\xBF\x48" => '&#54437;',
 "\xBF\x49" => '&#54438;',
 "\xBF\x4A" => '&#54439;',
 "\xBF\x4B" => '&#54440;',
 "\xBF\x4C" => '&#54442;',
 "\xBF\x4D" => '&#54443;',
 "\xBF\x4E" => '&#54444;',
 "\xBF\x4F" => '&#54445;',
 "\xBF\x50" => '&#54446;',
 "\xBF\x51" => '&#54447;',
 "\xBF\x52" => '&#54448;',
 "\xBF\x53" => '&#54449;',
 "\xBF\x54" => '&#54450;',
 "\xBF\x55" => '&#54451;',
 "\xBF\x56" => '&#54452;',
 "\xBF\x57" => '&#54453;',
 "\xBF\x58" => '&#54454;',
 "\xBF\x59" => '&#54455;',
 "\xBF\x5A" => '&#54456;',
 "\xBF\x61" => '&#54457;',
 "\xBF\x62" => '&#54458;',
 "\xBF\x63" => '&#54459;',
 "\xBF\x64" => '&#54460;',
 "\xBF\x65" => '&#54461;',
 "\xBF\x66" => '&#54462;',
 "\xBF\x67" => '&#54463;',
 "\xBF\x68" => '&#54464;',
 "\xBF\x69" => '&#54465;',
 "\xBF\x6A" => '&#54466;',
 "\xBF\x6B" => '&#54467;',
 "\xBF\x6C" => '&#54468;',
 "\xBF\x6D" => '&#54469;',
 "\xBF\x6E" => '&#54470;',
 "\xBF\x6F" => '&#54471;',
 "\xBF\x70" => '&#54472;',
 "\xBF\x71" => '&#54473;',
 "\xBF\x72" => '&#54474;',
 "\xBF\x73" => '&#54475;',
 "\xBF\x74" => '&#54477;',
 "\xBF\x75" => '&#54478;',
 "\xBF\x76" => '&#54479;',
 "\xBF\x77" => '&#54481;',
 "\xBF\x78" => '&#54482;',
 "\xBF\x79" => '&#54483;',
 "\xBF\x7A" => '&#54485;',
 "\xBF\x81" => '&#54486;',
 "\xBF\x82" => '&#54487;',
 "\xBF\x83" => '&#54488;',
 "\xBF\x84" => '&#54489;',
 "\xBF\x85" => '&#54490;',
 "\xBF\x86" => '&#54491;',
 "\xBF\x87" => '&#54493;',
 "\xBF\x88" => '&#54494;',
 "\xBF\x89" => '&#54496;',
 "\xBF\x8A" => '&#54497;',
 "\xBF\x8B" => '&#54498;',
 "\xBF\x8C" => '&#54499;',
 "\xBF\x8D" => '&#54500;',
 "\xBF\x8E" => '&#54501;',
 "\xBF\x8F" => '&#54502;',
 "\xBF\x90" => '&#54503;',
 "\xBF\x91" => '&#54505;',
 "\xBF\x92" => '&#54506;',
 "\xBF\x93" => '&#54507;',
 "\xBF\x94" => '&#54509;',
 "\xBF\x95" => '&#54510;',
 "\xBF\x96" => '&#54511;',
 "\xBF\x97" => '&#54513;',
 "\xBF\x98" => '&#54514;',
 "\xBF\x99" => '&#54515;',
 "\xBF\x9A" => '&#54516;',
 "\xBF\x9B" => '&#54517;',
 "\xBF\x9C" => '&#54518;',
 "\xBF\x9D" => '&#54519;',
 "\xBF\x9E" => '&#54521;',
 "\xBF\x9F" => '&#54522;',
 "\xBF\xA0" => '&#54524;',
 "\xBF\xA1" => '&#50640;',
 "\xBF\xA2" => '&#50641;',
 "\xBF\xA3" => '&#50644;',
 "\xBF\xA4" => '&#50648;',
 "\xBF\xA5" => '&#50656;',
 "\xBF\xA6" => '&#50657;',
 "\xBF\xA7" => '&#50659;',
 "\xBF\xA8" => '&#50661;',
 "\xBF\xA9" => '&#50668;',
 "\xBF\xAA" => '&#50669;',
 "\xBF\xAB" => '&#50670;',
 "\xBF\xAC" => '&#50672;',
 "\xBF\xAD" => '&#50676;',
 "\xBF\xAE" => '&#50678;',
 "\xBF\xAF" => '&#50679;',
 "\xBF\xB0" => '&#50684;',
 "\xBF\xB1" => '&#50685;',
 "\xBF\xB2" => '&#50686;',
 "\xBF\xB3" => '&#50687;',
 "\xBF\xB4" => '&#50688;',
 "\xBF\xB5" => '&#50689;',
 "\xBF\xB6" => '&#50693;',
 "\xBF\xB7" => '&#50694;',
 "\xBF\xB8" => '&#50695;',
 "\xBF\xB9" => '&#50696;',
 "\xBF\xBA" => '&#50700;',
 "\xBF\xBB" => '&#50704;',
 "\xBF\xBC" => '&#50712;',
 "\xBF\xBD" => '&#50713;',
 "\xBF\xBE" => '&#50715;',
 "\xBF\xBF" => '&#50716;',
 "\xBF\xC0" => '&#50724;',
 "\xBF\xC1" => '&#50725;',
 "\xBF\xC2" => '&#50728;',
 "\xBF\xC3" => '&#50732;',
 "\xBF\xC4" => '&#50733;',
 "\xBF\xC5" => '&#50734;',
 "\xBF\xC6" => '&#50736;',
 "\xBF\xC7" => '&#50739;',
 "\xBF\xC8" => '&#50740;',
 "\xBF\xC9" => '&#50741;',
 "\xBF\xCA" => '&#50743;',
 "\xBF\xCB" => '&#50745;',
 "\xBF\xCC" => '&#50747;',
 "\xBF\xCD" => '&#50752;',
 "\xBF\xCE" => '&#50753;',
 "\xBF\xCF" => '&#50756;',
 "\xBF\xD0" => '&#50760;',
 "\xBF\xD1" => '&#50768;',
 "\xBF\xD2" => '&#50769;',
 "\xBF\xD3" => '&#50771;',
 "\xBF\xD4" => '&#50772;',
 "\xBF\xD5" => '&#50773;',
 "\xBF\xD6" => '&#50780;',
 "\xBF\xD7" => '&#50781;',
 "\xBF\xD8" => '&#50784;',
 "\xBF\xD9" => '&#50796;',
 "\xBF\xDA" => '&#50799;',
 "\xBF\xDB" => '&#50801;',
 "\xBF\xDC" => '&#50808;',
 "\xBF\xDD" => '&#50809;',
 "\xBF\xDE" => '&#50812;',
 "\xBF\xDF" => '&#50816;',
 "\xBF\xE0" => '&#50824;',
 "\xBF\xE1" => '&#50825;',
 "\xBF\xE2" => '&#50827;',
 "\xBF\xE3" => '&#50829;',
 "\xBF\xE4" => '&#50836;',
 "\xBF\xE5" => '&#50837;',
 "\xBF\xE6" => '&#50840;',
 "\xBF\xE7" => '&#50844;',
 "\xBF\xE8" => '&#50852;',
 "\xBF\xE9" => '&#50853;',
 "\xBF\xEA" => '&#50855;',
 "\xBF\xEB" => '&#50857;',
 "\xBF\xEC" => '&#50864;',
 "\xBF\xED" => '&#50865;',
 "\xBF\xEE" => '&#50868;',
 "\xBF\xEF" => '&#50872;',
 "\xBF\xF0" => '&#50873;',
 "\xBF\xF1" => '&#50874;',
 "\xBF\xF2" => '&#50880;',
 "\xBF\xF3" => '&#50881;',
 "\xBF\xF4" => '&#50883;',
 "\xBF\xF5" => '&#50885;',
 "\xBF\xF6" => '&#50892;',
 "\xBF\xF7" => '&#50893;',
 "\xBF\xF8" => '&#50896;',
 "\xBF\xF9" => '&#50900;',
 "\xBF\xFA" => '&#50908;',
 "\xBF\xFB" => '&#50909;',
 "\xBF\xFC" => '&#50912;',
 "\xBF\xFD" => '&#50913;',
 "\xBF\xFE" => '&#50920;',
 "\xC0\x41" => '&#54526;',
 "\xC0\x42" => '&#54527;',
 "\xC0\x43" => '&#54528;',
 "\xC0\x44" => '&#54529;',
 "\xC0\x45" => '&#54530;',
 "\xC0\x46" => '&#54531;',
 "\xC0\x47" => '&#54533;',
 "\xC0\x48" => '&#54534;',
 "\xC0\x49" => '&#54535;',
 "\xC0\x4A" => '&#54537;',
 "\xC0\x4B" => '&#54538;',
 "\xC0\x4C" => '&#54539;',
 "\xC0\x4D" => '&#54541;',
 "\xC0\x4E" => '&#54542;',
 "\xC0\x4F" => '&#54543;',
 "\xC0\x50" => '&#54544;',
 "\xC0\x51" => '&#54545;',
 "\xC0\x52" => '&#54546;',
 "\xC0\x53" => '&#54547;',
 "\xC0\x54" => '&#54550;',
 "\xC0\x55" => '&#54552;',
 "\xC0\x56" => '&#54553;',
 "\xC0\x57" => '&#54554;',
 "\xC0\x58" => '&#54555;',
 "\xC0\x59" => '&#54556;',
 "\xC0\x5A" => '&#54557;',
 "\xC0\x61" => '&#54558;',
 "\xC0\x62" => '&#54559;',
 "\xC0\x63" => '&#54560;',
 "\xC0\x64" => '&#54561;',
 "\xC0\x65" => '&#54562;',
 "\xC0\x66" => '&#54563;',
 "\xC0\x67" => '&#54564;',
 "\xC0\x68" => '&#54565;',
 "\xC0\x69" => '&#54566;',
 "\xC0\x6A" => '&#54567;',
 "\xC0\x6B" => '&#54568;',
 "\xC0\x6C" => '&#54569;',
 "\xC0\x6D" => '&#54570;',
 "\xC0\x6E" => '&#54571;',
 "\xC0\x6F" => '&#54572;',
 "\xC0\x70" => '&#54573;',
 "\xC0\x71" => '&#54574;',
 "\xC0\x72" => '&#54575;',
 "\xC0\x73" => '&#54576;',
 "\xC0\x74" => '&#54577;',
 "\xC0\x75" => '&#54578;',
 "\xC0\x76" => '&#54579;',
 "\xC0\x77" => '&#54580;',
 "\xC0\x78" => '&#54581;',
 "\xC0\x79" => '&#54582;',
 "\xC0\x7A" => '&#54583;',
 "\xC0\x81" => '&#54584;',
 "\xC0\x82" => '&#54585;',
 "\xC0\x83" => '&#54586;',
 "\xC0\x84" => '&#54587;',
 "\xC0\x85" => '&#54590;',
 "\xC0\x86" => '&#54591;',
 "\xC0\x87" => '&#54593;',
 "\xC0\x88" => '&#54594;',
 "\xC0\x89" => '&#54595;',
 "\xC0\x8A" => '&#54597;',
 "\xC0\x8B" => '&#54598;',
 "\xC0\x8C" => '&#54599;',
 "\xC0\x8D" => '&#54600;',
 "\xC0\x8E" => '&#54601;',
 "\xC0\x8F" => '&#54602;',
 "\xC0\x90" => '&#54603;',
 "\xC0\x91" => '&#54606;',
 "\xC0\x92" => '&#54608;',
 "\xC0\x93" => '&#54610;',
 "\xC0\x94" => '&#54611;',
 "\xC0\x95" => '&#54612;',
 "\xC0\x96" => '&#54613;',
 "\xC0\x97" => '&#54614;',
 "\xC0\x98" => '&#54615;',
 "\xC0\x99" => '&#54618;',
 "\xC0\x9A" => '&#54619;',
 "\xC0\x9B" => '&#54621;',
 "\xC0\x9C" => '&#54622;',
 "\xC0\x9D" => '&#54623;',
 "\xC0\x9E" => '&#54625;',
 "\xC0\x9F" => '&#54626;',
 "\xC0\xA0" => '&#54627;',
 "\xC0\xA1" => '&#50921;',
 "\xC0\xA2" => '&#50924;',
 "\xC0\xA3" => '&#50928;',
 "\xC0\xA4" => '&#50936;',
 "\xC0\xA5" => '&#50937;',
 "\xC0\xA6" => '&#50941;',
 "\xC0\xA7" => '&#50948;',
 "\xC0\xA8" => '&#50949;',
 "\xC0\xA9" => '&#50952;',
 "\xC0\xAA" => '&#50956;',
 "\xC0\xAB" => '&#50964;',
 "\xC0\xAC" => '&#50965;',
 "\xC0\xAD" => '&#50967;',
 "\xC0\xAE" => '&#50969;',
 "\xC0\xAF" => '&#50976;',
 "\xC0\xB0" => '&#50977;',
 "\xC0\xB1" => '&#50980;',
 "\xC0\xB2" => '&#50984;',
 "\xC0\xB3" => '&#50992;',
 "\xC0\xB4" => '&#50993;',
 "\xC0\xB5" => '&#50995;',
 "\xC0\xB6" => '&#50997;',
 "\xC0\xB7" => '&#50999;',
 "\xC0\xB8" => '&#51004;',
 "\xC0\xB9" => '&#51005;',
 "\xC0\xBA" => '&#51008;',
 "\xC0\xBB" => '&#51012;',
 "\xC0\xBC" => '&#51018;',
 "\xC0\xBD" => '&#51020;',
 "\xC0\xBE" => '&#51021;',
 "\xC0\xBF" => '&#51023;',
 "\xC0\xC0" => '&#51025;',
 "\xC0\xC1" => '&#51026;',
 "\xC0\xC2" => '&#51027;',
 "\xC0\xC3" => '&#51028;',
 "\xC0\xC4" => '&#51029;',
 "\xC0\xC5" => '&#51030;',
 "\xC0\xC6" => '&#51031;',
 "\xC0\xC7" => '&#51032;',
 "\xC0\xC8" => '&#51036;',
 "\xC0\xC9" => '&#51040;',
 "\xC0\xCA" => '&#51048;',
 "\xC0\xCB" => '&#51051;',
 "\xC0\xCC" => '&#51060;',
 "\xC0\xCD" => '&#51061;',
 "\xC0\xCE" => '&#51064;',
 "\xC0\xCF" => '&#51068;',
 "\xC0\xD0" => '&#51069;',
 "\xC0\xD1" => '&#51070;',
 "\xC0\xD2" => '&#51075;',
 "\xC0\xD3" => '&#51076;',
 "\xC0\xD4" => '&#51077;',
 "\xC0\xD5" => '&#51079;',
 "\xC0\xD6" => '&#51080;',
 "\xC0\xD7" => '&#51081;',
 "\xC0\xD8" => '&#51082;',
 "\xC0\xD9" => '&#51086;',
 "\xC0\xDA" => '&#51088;',
 "\xC0\xDB" => '&#51089;',
 "\xC0\xDC" => '&#51092;',
 "\xC0\xDD" => '&#51094;',
 "\xC0\xDE" => '&#51095;',
 "\xC0\xDF" => '&#51096;',
 "\xC0\xE0" => '&#51098;',
 "\xC0\xE1" => '&#51104;',
 "\xC0\xE2" => '&#51105;',
 "\xC0\xE3" => '&#51107;',
 "\xC0\xE4" => '&#51108;',
 "\xC0\xE5" => '&#51109;',
 "\xC0\xE6" => '&#51110;',
 "\xC0\xE7" => '&#51116;',
 "\xC0\xE8" => '&#51117;',
 "\xC0\xE9" => '&#51120;',
 "\xC0\xEA" => '&#51124;',
 "\xC0\xEB" => '&#51132;',
 "\xC0\xEC" => '&#51133;',
 "\xC0\xED" => '&#51135;',
 "\xC0\xEE" => '&#51136;',
 "\xC0\xEF" => '&#51137;',
 "\xC0\xF0" => '&#51144;',
 "\xC0\xF1" => '&#51145;',
 "\xC0\xF2" => '&#51148;',
 "\xC0\xF3" => '&#51150;',
 "\xC0\xF4" => '&#51152;',
 "\xC0\xF5" => '&#51160;',
 "\xC0\xF6" => '&#51165;',
 "\xC0\xF7" => '&#51172;',
 "\xC0\xF8" => '&#51176;',
 "\xC0\xF9" => '&#51180;',
 "\xC0\xFA" => '&#51200;',
 "\xC0\xFB" => '&#51201;',
 "\xC0\xFC" => '&#51204;',
 "\xC0\xFD" => '&#51208;',
 "\xC0\xFE" => '&#51210;',
 "\xC1\x41" => '&#54628;',
 "\xC1\x42" => '&#54630;',
 "\xC1\x43" => '&#54631;',
 "\xC1\x44" => '&#54634;',
 "\xC1\x45" => '&#54636;',
 "\xC1\x46" => '&#54638;',
 "\xC1\x47" => '&#54639;',
 "\xC1\x48" => '&#54640;',
 "\xC1\x49" => '&#54641;',
 "\xC1\x4A" => '&#54642;',
 "\xC1\x4B" => '&#54643;',
 "\xC1\x4C" => '&#54646;',
 "\xC1\x4D" => '&#54647;',
 "\xC1\x4E" => '&#54649;',
 "\xC1\x4F" => '&#54650;',
 "\xC1\x50" => '&#54651;',
 "\xC1\x51" => '&#54653;',
 "\xC1\x52" => '&#54654;',
 "\xC1\x53" => '&#54655;',
 "\xC1\x54" => '&#54656;',
 "\xC1\x55" => '&#54657;',
 "\xC1\x56" => '&#54658;',
 "\xC1\x57" => '&#54659;',
 "\xC1\x58" => '&#54662;',
 "\xC1\x59" => '&#54666;',
 "\xC1\x5A" => '&#54667;',
 "\xC1\x61" => '&#54668;',
 "\xC1\x62" => '&#54669;',
 "\xC1\x63" => '&#54670;',
 "\xC1\x64" => '&#54671;',
 "\xC1\x65" => '&#54673;',
 "\xC1\x66" => '&#54674;',
 "\xC1\x67" => '&#54675;',
 "\xC1\x68" => '&#54676;',
 "\xC1\x69" => '&#54677;',
 "\xC1\x6A" => '&#54678;',
 "\xC1\x6B" => '&#54679;',
 "\xC1\x6C" => '&#54680;',
 "\xC1\x6D" => '&#54681;',
 "\xC1\x6E" => '&#54682;',
 "\xC1\x6F" => '&#54683;',
 "\xC1\x70" => '&#54684;',
 "\xC1\x71" => '&#54685;',
 "\xC1\x72" => '&#54686;',
 "\xC1\x73" => '&#54687;',
 "\xC1\x74" => '&#54688;',
 "\xC1\x75" => '&#54689;',
 "\xC1\x76" => '&#54690;',
 "\xC1\x77" => '&#54691;',
 "\xC1\x78" => '&#54692;',
 "\xC1\x79" => '&#54694;',
 "\xC1\x7A" => '&#54695;',
 "\xC1\x81" => '&#54696;',
 "\xC1\x82" => '&#54697;',
 "\xC1\x83" => '&#54698;',
 "\xC1\x84" => '&#54699;',
 "\xC1\x85" => '&#54700;',
 "\xC1\x86" => '&#54701;',
 "\xC1\x87" => '&#54702;',
 "\xC1\x88" => '&#54703;',
 "\xC1\x89" => '&#54704;',
 "\xC1\x8A" => '&#54705;',
 "\xC1\x8B" => '&#54706;',
 "\xC1\x8C" => '&#54707;',
 "\xC1\x8D" => '&#54708;',
 "\xC1\x8E" => '&#54709;',
 "\xC1\x8F" => '&#54710;',
 "\xC1\x90" => '&#54711;',
 "\xC1\x91" => '&#54712;',
 "\xC1\x92" => '&#54713;',
 "\xC1\x93" => '&#54714;',
 "\xC1\x94" => '&#54715;',
 "\xC1\x95" => '&#54716;',
 "\xC1\x96" => '&#54717;',
 "\xC1\x97" => '&#54718;',
 "\xC1\x98" => '&#54719;',
 "\xC1\x99" => '&#54720;',
 "\xC1\x9A" => '&#54721;',
 "\xC1\x9B" => '&#54722;',
 "\xC1\x9C" => '&#54723;',
 "\xC1\x9D" => '&#54724;',
 "\xC1\x9E" => '&#54725;',
 "\xC1\x9F" => '&#54726;',
 "\xC1\xA0" => '&#54727;',
 "\xC1\xA1" => '&#51216;',
 "\xC1\xA2" => '&#51217;',
 "\xC1\xA3" => '&#51219;',
 "\xC1\xA4" => '&#51221;',
 "\xC1\xA5" => '&#51222;',
 "\xC1\xA6" => '&#51228;',
 "\xC1\xA7" => '&#51229;',
 "\xC1\xA8" => '&#51232;',
 "\xC1\xA9" => '&#51236;',
 "\xC1\xAA" => '&#51244;',
 "\xC1\xAB" => '&#51245;',
 "\xC1\xAC" => '&#51247;',
 "\xC1\xAD" => '&#51249;',
 "\xC1\xAE" => '&#51256;',
 "\xC1\xAF" => '&#51260;',
 "\xC1\xB0" => '&#51264;',
 "\xC1\xB1" => '&#51272;',
 "\xC1\xB2" => '&#51273;',
 "\xC1\xB3" => '&#51276;',
 "\xC1\xB4" => '&#51277;',
 "\xC1\xB5" => '&#51284;',
 "\xC1\xB6" => '&#51312;',
 "\xC1\xB7" => '&#51313;',
 "\xC1\xB8" => '&#51316;',
 "\xC1\xB9" => '&#51320;',
 "\xC1\xBA" => '&#51322;',
 "\xC1\xBB" => '&#51328;',
 "\xC1\xBC" => '&#51329;',
 "\xC1\xBD" => '&#51331;',
 "\xC1\xBE" => '&#51333;',
 "\xC1\xBF" => '&#51334;',
 "\xC1\xC0" => '&#51335;',
 "\xC1\xC1" => '&#51339;',
 "\xC1\xC2" => '&#51340;',
 "\xC1\xC3" => '&#51341;',
 "\xC1\xC4" => '&#51348;',
 "\xC1\xC5" => '&#51357;',
 "\xC1\xC6" => '&#51359;',
 "\xC1\xC7" => '&#51361;',
 "\xC1\xC8" => '&#51368;',
 "\xC1\xC9" => '&#51388;',
 "\xC1\xCA" => '&#51389;',
 "\xC1\xCB" => '&#51396;',
 "\xC1\xCC" => '&#51400;',
 "\xC1\xCD" => '&#51404;',
 "\xC1\xCE" => '&#51412;',
 "\xC1\xCF" => '&#51413;',
 "\xC1\xD0" => '&#51415;',
 "\xC1\xD1" => '&#51417;',
 "\xC1\xD2" => '&#51424;',
 "\xC1\xD3" => '&#51425;',
 "\xC1\xD4" => '&#51428;',
 "\xC1\xD5" => '&#51445;',
 "\xC1\xD6" => '&#51452;',
 "\xC1\xD7" => '&#51453;',
 "\xC1\xD8" => '&#51456;',
 "\xC1\xD9" => '&#51460;',
 "\xC1\xDA" => '&#51461;',
 "\xC1\xDB" => '&#51462;',
 "\xC1\xDC" => '&#51468;',
 "\xC1\xDD" => '&#51469;',
 "\xC1\xDE" => '&#51471;',
 "\xC1\xDF" => '&#51473;',
 "\xC1\xE0" => '&#51480;',
 "\xC1\xE1" => '&#51500;',
 "\xC1\xE2" => '&#51508;',
 "\xC1\xE3" => '&#51536;',
 "\xC1\xE4" => '&#51537;',
 "\xC1\xE5" => '&#51540;',
 "\xC1\xE6" => '&#51544;',
 "\xC1\xE7" => '&#51552;',
 "\xC1\xE8" => '&#51553;',
 "\xC1\xE9" => '&#51555;',
 "\xC1\xEA" => '&#51564;',
 "\xC1\xEB" => '&#51568;',
 "\xC1\xEC" => '&#51572;',
 "\xC1\xED" => '&#51580;',
 "\xC1\xEE" => '&#51592;',
 "\xC1\xEF" => '&#51593;',
 "\xC1\xF0" => '&#51596;',
 "\xC1\xF1" => '&#51600;',
 "\xC1\xF2" => '&#51608;',
 "\xC1\xF3" => '&#51609;',
 "\xC1\xF4" => '&#51611;',
 "\xC1\xF5" => '&#51613;',
 "\xC1\xF6" => '&#51648;',
 "\xC1\xF7" => '&#51649;',
 "\xC1\xF8" => '&#51652;',
 "\xC1\xF9" => '&#51655;',
 "\xC1\xFA" => '&#51656;',
 "\xC1\xFB" => '&#51658;',
 "\xC1\xFC" => '&#51664;',
 "\xC1\xFD" => '&#51665;',
 "\xC1\xFE" => '&#51667;',
 "\xC2\x41" => '&#54730;',
 "\xC2\x42" => '&#54731;',
 "\xC2\x43" => '&#54733;',
 "\xC2\x44" => '&#54734;',
 "\xC2\x45" => '&#54735;',
 "\xC2\x46" => '&#54737;',
 "\xC2\x47" => '&#54739;',
 "\xC2\x48" => '&#54740;',
 "\xC2\x49" => '&#54741;',
 "\xC2\x4A" => '&#54742;',
 "\xC2\x4B" => '&#54743;',
 "\xC2\x4C" => '&#54746;',
 "\xC2\x4D" => '&#54748;',
 "\xC2\x4E" => '&#54750;',
 "\xC2\x4F" => '&#54751;',
 "\xC2\x50" => '&#54752;',
 "\xC2\x51" => '&#54753;',
 "\xC2\x52" => '&#54754;',
 "\xC2\x53" => '&#54755;',
 "\xC2\x54" => '&#54758;',
 "\xC2\x55" => '&#54759;',
 "\xC2\x56" => '&#54761;',
 "\xC2\x57" => '&#54762;',
 "\xC2\x58" => '&#54763;',
 "\xC2\x59" => '&#54765;',
 "\xC2\x5A" => '&#54766;',
 "\xC2\x61" => '&#54767;',
 "\xC2\x62" => '&#54768;',
 "\xC2\x63" => '&#54769;',
 "\xC2\x64" => '&#54770;',
 "\xC2\x65" => '&#54771;',
 "\xC2\x66" => '&#54774;',
 "\xC2\x67" => '&#54776;',
 "\xC2\x68" => '&#54778;',
 "\xC2\x69" => '&#54779;',
 "\xC2\x6A" => '&#54780;',
 "\xC2\x6B" => '&#54781;',
 "\xC2\x6C" => '&#54782;',
 "\xC2\x6D" => '&#54783;',
 "\xC2\x6E" => '&#54786;',
 "\xC2\x6F" => '&#54787;',
 "\xC2\x70" => '&#54789;',
 "\xC2\x71" => '&#54790;',
 "\xC2\x72" => '&#54791;',
 "\xC2\x73" => '&#54793;',
 "\xC2\x74" => '&#54794;',
 "\xC2\x75" => '&#54795;',
 "\xC2\x76" => '&#54796;',
 "\xC2\x77" => '&#54797;',
 "\xC2\x78" => '&#54798;',
 "\xC2\x79" => '&#54799;',
 "\xC2\x7A" => '&#54802;',
 "\xC2\x81" => '&#54806;',
 "\xC2\x82" => '&#54807;',
 "\xC2\x83" => '&#54808;',
 "\xC2\x84" => '&#54809;',
 "\xC2\x85" => '&#54810;',
 "\xC2\x86" => '&#54811;',
 "\xC2\x87" => '&#54813;',
 "\xC2\x88" => '&#54814;',
 "\xC2\x89" => '&#54815;',
 "\xC2\x8A" => '&#54817;',
 "\xC2\x8B" => '&#54818;',
 "\xC2\x8C" => '&#54819;',
 "\xC2\x8D" => '&#54821;',
 "\xC2\x8E" => '&#54822;',
 "\xC2\x8F" => '&#54823;',
 "\xC2\x90" => '&#54824;',
 "\xC2\x91" => '&#54825;',
 "\xC2\x92" => '&#54826;',
 "\xC2\x93" => '&#54827;',
 "\xC2\x94" => '&#54828;',
 "\xC2\x95" => '&#54830;',
 "\xC2\x96" => '&#54831;',
 "\xC2\x97" => '&#54832;',
 "\xC2\x98" => '&#54833;',
 "\xC2\x99" => '&#54834;',
 "\xC2\x9A" => '&#54835;',
 "\xC2\x9B" => '&#54836;',
 "\xC2\x9C" => '&#54837;',
 "\xC2\x9D" => '&#54838;',
 "\xC2\x9E" => '&#54839;',
 "\xC2\x9F" => '&#54842;',
 "\xC2\xA0" => '&#54843;',
 "\xC2\xA1" => '&#51669;',
 "\xC2\xA2" => '&#51670;',
 "\xC2\xA3" => '&#51673;',
 "\xC2\xA4" => '&#51674;',
 "\xC2\xA5" => '&#51676;',
 "\xC2\xA6" => '&#51677;',
 "\xC2\xA7" => '&#51680;',
 "\xC2\xA8" => '&#51682;',
 "\xC2\xA9" => '&#51684;',
 "\xC2\xAA" => '&#51687;',
 "\xC2\xAB" => '&#51692;',
 "\xC2\xAC" => '&#51693;',
 "\xC2\xAD" => '&#51695;',
 "\xC2\xAE" => '&#51696;',
 "\xC2\xAF" => '&#51697;',
 "\xC2\xB0" => '&#51704;',
 "\xC2\xB1" => '&#51705;',
 "\xC2\xB2" => '&#51708;',
 "\xC2\xB3" => '&#51712;',
 "\xC2\xB4" => '&#51720;',
 "\xC2\xB5" => '&#51721;',
 "\xC2\xB6" => '&#51723;',
 "\xC2\xB7" => '&#51724;',
 "\xC2\xB8" => '&#51725;',
 "\xC2\xB9" => '&#51732;',
 "\xC2\xBA" => '&#51736;',
 "\xC2\xBB" => '&#51753;',
 "\xC2\xBC" => '&#51788;',
 "\xC2\xBD" => '&#51789;',
 "\xC2\xBE" => '&#51792;',
 "\xC2\xBF" => '&#51796;',
 "\xC2\xC0" => '&#51804;',
 "\xC2\xC1" => '&#51805;',
 "\xC2\xC2" => '&#51807;',
 "\xC2\xC3" => '&#51808;',
 "\xC2\xC4" => '&#51809;',
 "\xC2\xC5" => '&#51816;',
 "\xC2\xC6" => '&#51837;',
 "\xC2\xC7" => '&#51844;',
 "\xC2\xC8" => '&#51864;',
 "\xC2\xC9" => '&#51900;',
 "\xC2\xCA" => '&#51901;',
 "\xC2\xCB" => '&#51904;',
 "\xC2\xCC" => '&#51908;',
 "\xC2\xCD" => '&#51916;',
 "\xC2\xCE" => '&#51917;',
 "\xC2\xCF" => '&#51919;',
 "\xC2\xD0" => '&#51921;',
 "\xC2\xD1" => '&#51923;',
 "\xC2\xD2" => '&#51928;',
 "\xC2\xD3" => '&#51929;',
 "\xC2\xD4" => '&#51936;',
 "\xC2\xD5" => '&#51948;',
 "\xC2\xD6" => '&#51956;',
 "\xC2\xD7" => '&#51976;',
 "\xC2\xD8" => '&#51984;',
 "\xC2\xD9" => '&#51988;',
 "\xC2\xDA" => '&#51992;',
 "\xC2\xDB" => '&#52000;',
 "\xC2\xDC" => '&#52001;',
 "\xC2\xDD" => '&#52033;',
 "\xC2\xDE" => '&#52040;',
 "\xC2\xDF" => '&#52041;',
 "\xC2\xE0" => '&#52044;',
 "\xC2\xE1" => '&#52048;',
 "\xC2\xE2" => '&#52056;',
 "\xC2\xE3" => '&#52057;',
 "\xC2\xE4" => '&#52061;',
 "\xC2\xE5" => '&#52068;',
 "\xC2\xE6" => '&#52088;',
 "\xC2\xE7" => '&#52089;',
 "\xC2\xE8" => '&#52124;',
 "\xC2\xE9" => '&#52152;',
 "\xC2\xEA" => '&#52180;',
 "\xC2\xEB" => '&#52196;',
 "\xC2\xEC" => '&#52199;',
 "\xC2\xED" => '&#52201;',
 "\xC2\xEE" => '&#52236;',
 "\xC2\xEF" => '&#52237;',
 "\xC2\xF0" => '&#52240;',
 "\xC2\xF1" => '&#52244;',
 "\xC2\xF2" => '&#52252;',
 "\xC2\xF3" => '&#52253;',
 "\xC2\xF4" => '&#52257;',
 "\xC2\xF5" => '&#52258;',
 "\xC2\xF6" => '&#52263;',
 "\xC2\xF7" => '&#52264;',
 "\xC2\xF8" => '&#52265;',
 "\xC2\xF9" => '&#52268;',
 "\xC2\xFA" => '&#52270;',
 "\xC2\xFB" => '&#52272;',
 "\xC2\xFC" => '&#52280;',
 "\xC2\xFD" => '&#52281;',
 "\xC2\xFE" => '&#52283;',
 "\xC3\x41" => '&#54845;',
 "\xC3\x42" => '&#54846;',
 "\xC3\x43" => '&#54847;',
 "\xC3\x44" => '&#54849;',
 "\xC3\x45" => '&#54850;',
 "\xC3\x46" => '&#54851;',
 "\xC3\x47" => '&#54852;',
 "\xC3\x48" => '&#54854;',
 "\xC3\x49" => '&#54855;',
 "\xC3\x4A" => '&#54858;',
 "\xC3\x4B" => '&#54860;',
 "\xC3\x4C" => '&#54862;',
 "\xC3\x4D" => '&#54863;',
 "\xC3\x4E" => '&#54864;',
 "\xC3\x4F" => '&#54866;',
 "\xC3\x50" => '&#54867;',
 "\xC3\x51" => '&#54870;',
 "\xC3\x52" => '&#54871;',
 "\xC3\x53" => '&#54873;',
 "\xC3\x54" => '&#54874;',
 "\xC3\x55" => '&#54875;',
 "\xC3\x56" => '&#54877;',
 "\xC3\x57" => '&#54878;',
 "\xC3\x58" => '&#54879;',
 "\xC3\x59" => '&#54880;',
 "\xC3\x5A" => '&#54881;',
 "\xC3\x61" => '&#54882;',
 "\xC3\x62" => '&#54883;',
 "\xC3\x63" => '&#54884;',
 "\xC3\x64" => '&#54885;',
 "\xC3\x65" => '&#54886;',
 "\xC3\x66" => '&#54888;',
 "\xC3\x67" => '&#54890;',
 "\xC3\x68" => '&#54891;',
 "\xC3\x69" => '&#54892;',
 "\xC3\x6A" => '&#54893;',
 "\xC3\x6B" => '&#54894;',
 "\xC3\x6C" => '&#54895;',
 "\xC3\x6D" => '&#54898;',
 "\xC3\x6E" => '&#54899;',
 "\xC3\x6F" => '&#54901;',
 "\xC3\x70" => '&#54902;',
 "\xC3\x71" => '&#54903;',
 "\xC3\x72" => '&#54904;',
 "\xC3\x73" => '&#54905;',
 "\xC3\x74" => '&#54906;',
 "\xC3\x75" => '&#54907;',
 "\xC3\x76" => '&#54908;',
 "\xC3\x77" => '&#54909;',
 "\xC3\x78" => '&#54910;',
 "\xC3\x79" => '&#54911;',
 "\xC3\x7A" => '&#54912;',
 "\xC3\x81" => '&#54913;',
 "\xC3\x82" => '&#54914;',
 "\xC3\x83" => '&#54916;',
 "\xC3\x84" => '&#54918;',
 "\xC3\x85" => '&#54919;',
 "\xC3\x86" => '&#54920;',
 "\xC3\x87" => '&#54921;',
 "\xC3\x88" => '&#54922;',
 "\xC3\x89" => '&#54923;',
 "\xC3\x8A" => '&#54926;',
 "\xC3\x8B" => '&#54927;',
 "\xC3\x8C" => '&#54929;',
 "\xC3\x8D" => '&#54930;',
 "\xC3\x8E" => '&#54931;',
 "\xC3\x8F" => '&#54933;',
 "\xC3\x90" => '&#54934;',
 "\xC3\x91" => '&#54935;',
 "\xC3\x92" => '&#54936;',
 "\xC3\x93" => '&#54937;',
 "\xC3\x94" => '&#54938;',
 "\xC3\x95" => '&#54939;',
 "\xC3\x96" => '&#54940;',
 "\xC3\x97" => '&#54942;',
 "\xC3\x98" => '&#54944;',
 "\xC3\x99" => '&#54946;',
 "\xC3\x9A" => '&#54947;',
 "\xC3\x9B" => '&#54948;',
 "\xC3\x9C" => '&#54949;',
 "\xC3\x9D" => '&#54950;',
 "\xC3\x9E" => '&#54951;',
 "\xC3\x9F" => '&#54953;',
 "\xC3\xA0" => '&#54954;',
 "\xC3\xA1" => '&#52284;',
 "\xC3\xA2" => '&#52285;',
 "\xC3\xA3" => '&#52286;',
 "\xC3\xA4" => '&#52292;',
 "\xC3\xA5" => '&#52293;',
 "\xC3\xA6" => '&#52296;',
 "\xC3\xA7" => '&#52300;',
 "\xC3\xA8" => '&#52308;',
 "\xC3\xA9" => '&#52309;',
 "\xC3\xAA" => '&#52311;',
 "\xC3\xAB" => '&#52312;',
 "\xC3\xAC" => '&#52313;',
 "\xC3\xAD" => '&#52320;',
 "\xC3\xAE" => '&#52324;',
 "\xC3\xAF" => '&#52326;',
 "\xC3\xB0" => '&#52328;',
 "\xC3\xB1" => '&#52336;',
 "\xC3\xB2" => '&#52341;',
 "\xC3\xB3" => '&#52376;',
 "\xC3\xB4" => '&#52377;',
 "\xC3\xB5" => '&#52380;',
 "\xC3\xB6" => '&#52384;',
 "\xC3\xB7" => '&#52392;',
 "\xC3\xB8" => '&#52393;',
 "\xC3\xB9" => '&#52395;',
 "\xC3\xBA" => '&#52396;',
 "\xC3\xBB" => '&#52397;',
 "\xC3\xBC" => '&#52404;',
 "\xC3\xBD" => '&#52405;',
 "\xC3\xBE" => '&#52408;',
 "\xC3\xBF" => '&#52412;',
 "\xC3\xC0" => '&#52420;',
 "\xC3\xC1" => '&#52421;',
 "\xC3\xC2" => '&#52423;',
 "\xC3\xC3" => '&#52425;',
 "\xC3\xC4" => '&#52432;',
 "\xC3\xC5" => '&#52436;',
 "\xC3\xC6" => '&#52452;',
 "\xC3\xC7" => '&#52460;',
 "\xC3\xC8" => '&#52464;',
 "\xC3\xC9" => '&#52481;',
 "\xC3\xCA" => '&#52488;',
 "\xC3\xCB" => '&#52489;',
 "\xC3\xCC" => '&#52492;',
 "\xC3\xCD" => '&#52496;',
 "\xC3\xCE" => '&#52504;',
 "\xC3\xCF" => '&#52505;',
 "\xC3\xD0" => '&#52507;',
 "\xC3\xD1" => '&#52509;',
 "\xC3\xD2" => '&#52516;',
 "\xC3\xD3" => '&#52520;',
 "\xC3\xD4" => '&#52524;',
 "\xC3\xD5" => '&#52537;',
 "\xC3\xD6" => '&#52572;',
 "\xC3\xD7" => '&#52576;',
 "\xC3\xD8" => '&#52580;',
 "\xC3\xD9" => '&#52588;',
 "\xC3\xDA" => '&#52589;',
 "\xC3\xDB" => '&#52591;',
 "\xC3\xDC" => '&#52593;',
 "\xC3\xDD" => '&#52600;',
 "\xC3\xDE" => '&#52616;',
 "\xC3\xDF" => '&#52628;',
 "\xC3\xE0" => '&#52629;',
 "\xC3\xE1" => '&#52632;',
 "\xC3\xE2" => '&#52636;',
 "\xC3\xE3" => '&#52644;',
 "\xC3\xE4" => '&#52645;',
 "\xC3\xE5" => '&#52647;',
 "\xC3\xE6" => '&#52649;',
 "\xC3\xE7" => '&#52656;',
 "\xC3\xE8" => '&#52676;',
 "\xC3\xE9" => '&#52684;',
 "\xC3\xEA" => '&#52688;',
 "\xC3\xEB" => '&#52712;',
 "\xC3\xEC" => '&#52716;',
 "\xC3\xED" => '&#52720;',
 "\xC3\xEE" => '&#52728;',
 "\xC3\xEF" => '&#52729;',
 "\xC3\xF0" => '&#52731;',
 "\xC3\xF1" => '&#52733;',
 "\xC3\xF2" => '&#52740;',
 "\xC3\xF3" => '&#52744;',
 "\xC3\xF4" => '&#52748;',
 "\xC3\xF5" => '&#52756;',
 "\xC3\xF6" => '&#52761;',
 "\xC3\xF7" => '&#52768;',
 "\xC3\xF8" => '&#52769;',
 "\xC3\xF9" => '&#52772;',
 "\xC3\xFA" => '&#52776;',
 "\xC3\xFB" => '&#52784;',
 "\xC3\xFC" => '&#52785;',
 "\xC3\xFD" => '&#52787;',
 "\xC3\xFE" => '&#52789;',
 "\xC4\x41" => '&#54955;',
 "\xC4\x42" => '&#54957;',
 "\xC4\x43" => '&#54958;',
 "\xC4\x44" => '&#54959;',
 "\xC4\x45" => '&#54961;',
 "\xC4\x46" => '&#54962;',
 "\xC4\x47" => '&#54963;',
 "\xC4\x48" => '&#54964;',
 "\xC4\x49" => '&#54965;',
 "\xC4\x4A" => '&#54966;',
 "\xC4\x4B" => '&#54967;',
 "\xC4\x4C" => '&#54968;',
 "\xC4\x4D" => '&#54970;',
 "\xC4\x4E" => '&#54972;',
 "\xC4\x4F" => '&#54973;',
 "\xC4\x50" => '&#54974;',
 "\xC4\x51" => '&#54975;',
 "\xC4\x52" => '&#54976;',
 "\xC4\x53" => '&#54977;',
 "\xC4\x54" => '&#54978;',
 "\xC4\x55" => '&#54979;',
 "\xC4\x56" => '&#54982;',
 "\xC4\x57" => '&#54983;',
 "\xC4\x58" => '&#54985;',
 "\xC4\x59" => '&#54986;',
 "\xC4\x5A" => '&#54987;',
 "\xC4\x61" => '&#54989;',
 "\xC4\x62" => '&#54990;',
 "\xC4\x63" => '&#54991;',
 "\xC4\x64" => '&#54992;',
 "\xC4\x65" => '&#54994;',
 "\xC4\x66" => '&#54995;',
 "\xC4\x67" => '&#54997;',
 "\xC4\x68" => '&#54998;',
 "\xC4\x69" => '&#55000;',
 "\xC4\x6A" => '&#55002;',
 "\xC4\x6B" => '&#55003;',
 "\xC4\x6C" => '&#55004;',
 "\xC4\x6D" => '&#55005;',
 "\xC4\x6E" => '&#55006;',
 "\xC4\x6F" => '&#55007;',
 "\xC4\x70" => '&#55009;',
 "\xC4\x71" => '&#55010;',
 "\xC4\x72" => '&#55011;',
 "\xC4\x73" => '&#55013;',
 "\xC4\x74" => '&#55014;',
 "\xC4\x75" => '&#55015;',
 "\xC4\x76" => '&#55017;',
 "\xC4\x77" => '&#55018;',
 "\xC4\x78" => '&#55019;',
 "\xC4\x79" => '&#55020;',
 "\xC4\x7A" => '&#55021;',
 "\xC4\x81" => '&#55022;',
 "\xC4\x82" => '&#55023;',
 "\xC4\x83" => '&#55025;',
 "\xC4\x84" => '&#55026;',
 "\xC4\x85" => '&#55027;',
 "\xC4\x86" => '&#55028;',
 "\xC4\x87" => '&#55030;',
 "\xC4\x88" => '&#55031;',
 "\xC4\x89" => '&#55032;',
 "\xC4\x8A" => '&#55033;',
 "\xC4\x8B" => '&#55034;',
 "\xC4\x8C" => '&#55035;',
 "\xC4\x8D" => '&#55038;',
 "\xC4\x8E" => '&#55039;',
 "\xC4\x8F" => '&#55041;',
 "\xC4\x90" => '&#55042;',
 "\xC4\x91" => '&#55043;',
 "\xC4\x92" => '&#55045;',
 "\xC4\x93" => '&#55046;',
 "\xC4\x94" => '&#55047;',
 "\xC4\x95" => '&#55048;',
 "\xC4\x96" => '&#55049;',
 "\xC4\x97" => '&#55050;',
 "\xC4\x98" => '&#55051;',
 "\xC4\x99" => '&#55052;',
 "\xC4\x9A" => '&#55053;',
 "\xC4\x9B" => '&#55054;',
 "\xC4\x9C" => '&#55055;',
 "\xC4\x9D" => '&#55056;',
 "\xC4\x9E" => '&#55058;',
 "\xC4\x9F" => '&#55059;',
 "\xC4\xA0" => '&#55060;',
 "\xC4\xA1" => '&#52824;',
 "\xC4\xA2" => '&#52825;',
 "\xC4\xA3" => '&#52828;',
 "\xC4\xA4" => '&#52831;',
 "\xC4\xA5" => '&#52832;',
 "\xC4\xA6" => '&#52833;',
 "\xC4\xA7" => '&#52840;',
 "\xC4\xA8" => '&#52841;',
 "\xC4\xA9" => '&#52843;',
 "\xC4\xAA" => '&#52845;',
 "\xC4\xAB" => '&#52852;',
 "\xC4\xAC" => '&#52853;',
 "\xC4\xAD" => '&#52856;',
 "\xC4\xAE" => '&#52860;',
 "\xC4\xAF" => '&#52868;',
 "\xC4\xB0" => '&#52869;',
 "\xC4\xB1" => '&#52871;',
 "\xC4\xB2" => '&#52873;',
 "\xC4\xB3" => '&#52880;',
 "\xC4\xB4" => '&#52881;',
 "\xC4\xB5" => '&#52884;',
 "\xC4\xB6" => '&#52888;',
 "\xC4\xB7" => '&#52896;',
 "\xC4\xB8" => '&#52897;',
 "\xC4\xB9" => '&#52899;',
 "\xC4\xBA" => '&#52900;',
 "\xC4\xBB" => '&#52901;',
 "\xC4\xBC" => '&#52908;',
 "\xC4\xBD" => '&#52909;',
 "\xC4\xBE" => '&#52929;',
 "\xC4\xBF" => '&#52964;',
 "\xC4\xC0" => '&#52965;',
 "\xC4\xC1" => '&#52968;',
 "\xC4\xC2" => '&#52971;',
 "\xC4\xC3" => '&#52972;',
 "\xC4\xC4" => '&#52980;',
 "\xC4\xC5" => '&#52981;',
 "\xC4\xC6" => '&#52983;',
 "\xC4\xC7" => '&#52984;',
 "\xC4\xC8" => '&#52985;',
 "\xC4\xC9" => '&#52992;',
 "\xC4\xCA" => '&#52993;',
 "\xC4\xCB" => '&#52996;',
 "\xC4\xCC" => '&#53000;',
 "\xC4\xCD" => '&#53008;',
 "\xC4\xCE" => '&#53009;',
 "\xC4\xCF" => '&#53011;',
 "\xC4\xD0" => '&#53013;',
 "\xC4\xD1" => '&#53020;',
 "\xC4\xD2" => '&#53024;',
 "\xC4\xD3" => '&#53028;',
 "\xC4\xD4" => '&#53036;',
 "\xC4\xD5" => '&#53037;',
 "\xC4\xD6" => '&#53039;',
 "\xC4\xD7" => '&#53040;',
 "\xC4\xD8" => '&#53041;',
 "\xC4\xD9" => '&#53048;',
 "\xC4\xDA" => '&#53076;',
 "\xC4\xDB" => '&#53077;',
 "\xC4\xDC" => '&#53080;',
 "\xC4\xDD" => '&#53084;',
 "\xC4\xDE" => '&#53092;',
 "\xC4\xDF" => '&#53093;',
 "\xC4\xE0" => '&#53095;',
 "\xC4\xE1" => '&#53097;',
 "\xC4\xE2" => '&#53104;',
 "\xC4\xE3" => '&#53105;',
 "\xC4\xE4" => '&#53108;',
 "\xC4\xE5" => '&#53112;',
 "\xC4\xE6" => '&#53120;',
 "\xC4\xE7" => '&#53125;',
 "\xC4\xE8" => '&#53132;',
 "\xC4\xE9" => '&#53153;',
 "\xC4\xEA" => '&#53160;',
 "\xC4\xEB" => '&#53168;',
 "\xC4\xEC" => '&#53188;',
 "\xC4\xED" => '&#53216;',
 "\xC4\xEE" => '&#53217;',
 "\xC4\xEF" => '&#53220;',
 "\xC4\xF0" => '&#53224;',
 "\xC4\xF1" => '&#53232;',
 "\xC4\xF2" => '&#53233;',
 "\xC4\xF3" => '&#53235;',
 "\xC4\xF4" => '&#53237;',
 "\xC4\xF5" => '&#53244;',
 "\xC4\xF6" => '&#53248;',
 "\xC4\xF7" => '&#53252;',
 "\xC4\xF8" => '&#53265;',
 "\xC4\xF9" => '&#53272;',
 "\xC4\xFA" => '&#53293;',
 "\xC4\xFB" => '&#53300;',
 "\xC4\xFC" => '&#53301;',
 "\xC4\xFD" => '&#53304;',
 "\xC4\xFE" => '&#53308;',
 "\xC5\x41" => '&#55061;',
 "\xC5\x42" => '&#55062;',
 "\xC5\x43" => '&#55063;',
 "\xC5\x44" => '&#55066;',
 "\xC5\x45" => '&#55067;',
 "\xC5\x46" => '&#55069;',
 "\xC5\x47" => '&#55070;',
 "\xC5\x48" => '&#55071;',
 "\xC5\x49" => '&#55073;',
 "\xC5\x4A" => '&#55074;',
 "\xC5\x4B" => '&#55075;',
 "\xC5\x4C" => '&#55076;',
 "\xC5\x4D" => '&#55077;',
 "\xC5\x4E" => '&#55078;',
 "\xC5\x4F" => '&#55079;',
 "\xC5\x50" => '&#55082;',
 "\xC5\x51" => '&#55084;',
 "\xC5\x52" => '&#55086;',
 "\xC5\x53" => '&#55087;',
 "\xC5\x54" => '&#55088;',
 "\xC5\x55" => '&#55089;',
 "\xC5\x56" => '&#55090;',
 "\xC5\x57" => '&#55091;',
 "\xC5\x58" => '&#55094;',
 "\xC5\x59" => '&#55095;',
 "\xC5\x5A" => '&#55097;',
 "\xC5\x61" => '&#55098;',
 "\xC5\x62" => '&#55099;',
 "\xC5\x63" => '&#55101;',
 "\xC5\x64" => '&#55102;',
 "\xC5\x65" => '&#55103;',
 "\xC5\x66" => '&#55104;',
 "\xC5\x67" => '&#55105;',
 "\xC5\x68" => '&#55106;',
 "\xC5\x69" => '&#55107;',
 "\xC5\x6A" => '&#55109;',
 "\xC5\x6B" => '&#55110;',
 "\xC5\x6C" => '&#55112;',
 "\xC5\x6D" => '&#55114;',
 "\xC5\x6E" => '&#55115;',
 "\xC5\x6F" => '&#55116;',
 "\xC5\x70" => '&#55117;',
 "\xC5\x71" => '&#55118;',
 "\xC5\x72" => '&#55119;',
 "\xC5\x73" => '&#55122;',
 "\xC5\x74" => '&#55123;',
 "\xC5\x75" => '&#55125;',
 "\xC5\x76" => '&#55130;',
 "\xC5\x77" => '&#55131;',
 "\xC5\x78" => '&#55132;',
 "\xC5\x79" => '&#55133;',
 "\xC5\x7A" => '&#55134;',
 "\xC5\x81" => '&#55135;',
 "\xC5\x82" => '&#55138;',
 "\xC5\x83" => '&#55140;',
 "\xC5\x84" => '&#55142;',
 "\xC5\x85" => '&#55143;',
 "\xC5\x86" => '&#55144;',
 "\xC5\x87" => '&#55146;',
 "\xC5\x88" => '&#55147;',
 "\xC5\x89" => '&#55149;',
 "\xC5\x8A" => '&#55150;',
 "\xC5\x8B" => '&#55151;',
 "\xC5\x8C" => '&#55153;',
 "\xC5\x8D" => '&#55154;',
 "\xC5\x8E" => '&#55155;',
 "\xC5\x8F" => '&#55157;',
 "\xC5\x90" => '&#55158;',
 "\xC5\x91" => '&#55159;',
 "\xC5\x92" => '&#55160;',
 "\xC5\x93" => '&#55161;',
 "\xC5\x94" => '&#55162;',
 "\xC5\x95" => '&#55163;',
 "\xC5\x96" => '&#55166;',
 "\xC5\x97" => '&#55167;',
 "\xC5\x98" => '&#55168;',
 "\xC5\x99" => '&#55170;',
 "\xC5\x9A" => '&#55171;',
 "\xC5\x9B" => '&#55172;',
 "\xC5\x9C" => '&#55173;',
 "\xC5\x9D" => '&#55174;',
 "\xC5\x9E" => '&#55175;',
 "\xC5\x9F" => '&#55178;',
 "\xC5\xA0" => '&#55179;',
 "\xC5\xA1" => '&#53316;',
 "\xC5\xA2" => '&#53317;',
 "\xC5\xA3" => '&#53319;',
 "\xC5\xA4" => '&#53321;',
 "\xC5\xA5" => '&#53328;',
 "\xC5\xA6" => '&#53332;',
 "\xC5\xA7" => '&#53336;',
 "\xC5\xA8" => '&#53344;',
 "\xC5\xA9" => '&#53356;',
 "\xC5\xAA" => '&#53357;',
 "\xC5\xAB" => '&#53360;',
 "\xC5\xAC" => '&#53364;',
 "\xC5\xAD" => '&#53372;',
 "\xC5\xAE" => '&#53373;',
 "\xC5\xAF" => '&#53377;',
 "\xC5\xB0" => '&#53412;',
 "\xC5\xB1" => '&#53413;',
 "\xC5\xB2" => '&#53416;',
 "\xC5\xB3" => '&#53420;',
 "\xC5\xB4" => '&#53428;',
 "\xC5\xB5" => '&#53429;',
 "\xC5\xB6" => '&#53431;',
 "\xC5\xB7" => '&#53433;',
 "\xC5\xB8" => '&#53440;',
 "\xC5\xB9" => '&#53441;',
 "\xC5\xBA" => '&#53444;',
 "\xC5\xBB" => '&#53448;',
 "\xC5\xBC" => '&#53449;',
 "\xC5\xBD" => '&#53456;',
 "\xC5\xBE" => '&#53457;',
 "\xC5\xBF" => '&#53459;',
 "\xC5\xC0" => '&#53460;',
 "\xC5\xC1" => '&#53461;',
 "\xC5\xC2" => '&#53468;',
 "\xC5\xC3" => '&#53469;',
 "\xC5\xC4" => '&#53472;',
 "\xC5\xC5" => '&#53476;',
 "\xC5\xC6" => '&#53484;',
 "\xC5\xC7" => '&#53485;',
 "\xC5\xC8" => '&#53487;',
 "\xC5\xC9" => '&#53488;',
 "\xC5\xCA" => '&#53489;',
 "\xC5\xCB" => '&#53496;',
 "\xC5\xCC" => '&#53517;',
 "\xC5\xCD" => '&#53552;',
 "\xC5\xCE" => '&#53553;',
 "\xC5\xCF" => '&#53556;',
 "\xC5\xD0" => '&#53560;',
 "\xC5\xD1" => '&#53562;',
 "\xC5\xD2" => '&#53568;',
 "\xC5\xD3" => '&#53569;',
 "\xC5\xD4" => '&#53571;',
 "\xC5\xD5" => '&#53572;',
 "\xC5\xD6" => '&#53573;',
 "\xC5\xD7" => '&#53580;',
 "\xC5\xD8" => '&#53581;',
 "\xC5\xD9" => '&#53584;',
 "\xC5\xDA" => '&#53588;',
 "\xC5\xDB" => '&#53596;',
 "\xC5\xDC" => '&#53597;',
 "\xC5\xDD" => '&#53599;',
 "\xC5\xDE" => '&#53601;',
 "\xC5\xDF" => '&#53608;',
 "\xC5\xE0" => '&#53612;',
 "\xC5\xE1" => '&#53628;',
 "\xC5\xE2" => '&#53636;',
 "\xC5\xE3" => '&#53640;',
 "\xC5\xE4" => '&#53664;',
 "\xC5\xE5" => '&#53665;',
 "\xC5\xE6" => '&#53668;',
 "\xC5\xE7" => '&#53672;',
 "\xC5\xE8" => '&#53680;',
 "\xC5\xE9" => '&#53681;',
 "\xC5\xEA" => '&#53683;',
 "\xC5\xEB" => '&#53685;',
 "\xC5\xEC" => '&#53690;',
 "\xC5\xED" => '&#53692;',
 "\xC5\xEE" => '&#53696;',
 "\xC5\xEF" => '&#53720;',
 "\xC5\xF0" => '&#53748;',
 "\xC5\xF1" => '&#53752;',
 "\xC5\xF2" => '&#53767;',
 "\xC5\xF3" => '&#53769;',
 "\xC5\xF4" => '&#53776;',
 "\xC5\xF5" => '&#53804;',
 "\xC5\xF6" => '&#53805;',
 "\xC5\xF7" => '&#53808;',
 "\xC5\xF8" => '&#53812;',
 "\xC5\xF9" => '&#53820;',
 "\xC5\xFA" => '&#53821;',
 "\xC5\xFB" => '&#53823;',
 "\xC5\xFC" => '&#53825;',
 "\xC5\xFD" => '&#53832;',
 "\xC5\xFE" => '&#53852;',
 "\xC6\x41" => '&#55181;',
 "\xC6\x42" => '&#55182;',
 "\xC6\x43" => '&#55183;',
 "\xC6\x44" => '&#55185;',
 "\xC6\x45" => '&#55186;',
 "\xC6\x46" => '&#55187;',
 "\xC6\x47" => '&#55188;',
 "\xC6\x48" => '&#55189;',
 "\xC6\x49" => '&#55190;',
 "\xC6\x4A" => '&#55191;',
 "\xC6\x4B" => '&#55194;',
 "\xC6\x4C" => '&#55196;',
 "\xC6\x4D" => '&#55198;',
 "\xC6\x4E" => '&#55199;',
 "\xC6\x4F" => '&#55200;',
 "\xC6\x50" => '&#55201;',
 "\xC6\x51" => '&#55202;',
 "\xC6\x52" => '&#55203;',
 "\xC6\xA1" => '&#53860;',
 "\xC6\xA2" => '&#53888;',
 "\xC6\xA3" => '&#53889;',
 "\xC6\xA4" => '&#53892;',
 "\xC6\xA5" => '&#53896;',
 "\xC6\xA6" => '&#53904;',
 "\xC6\xA7" => '&#53905;',
 "\xC6\xA8" => '&#53909;',
 "\xC6\xA9" => '&#53916;',
 "\xC6\xAA" => '&#53920;',
 "\xC6\xAB" => '&#53924;',
 "\xC6\xAC" => '&#53932;',
 "\xC6\xAD" => '&#53937;',
 "\xC6\xAE" => '&#53944;',
 "\xC6\xAF" => '&#53945;',
 "\xC6\xB0" => '&#53948;',
 "\xC6\xB1" => '&#53951;',
 "\xC6\xB2" => '&#53952;',
 "\xC6\xB3" => '&#53954;',
 "\xC6\xB4" => '&#53960;',
 "\xC6\xB5" => '&#53961;',
 "\xC6\xB6" => '&#53963;',
 "\xC6\xB7" => '&#53972;',
 "\xC6\xB8" => '&#53976;',
 "\xC6\xB9" => '&#53980;',
 "\xC6\xBA" => '&#53988;',
 "\xC6\xBB" => '&#53989;',
 "\xC6\xBC" => '&#54000;',
 "\xC6\xBD" => '&#54001;',
 "\xC6\xBE" => '&#54004;',
 "\xC6\xBF" => '&#54008;',
 "\xC6\xC0" => '&#54016;',
 "\xC6\xC1" => '&#54017;',
 "\xC6\xC2" => '&#54019;',
 "\xC6\xC3" => '&#54021;',
 "\xC6\xC4" => '&#54028;',
 "\xC6\xC5" => '&#54029;',
 "\xC6\xC6" => '&#54030;',
 "\xC6\xC7" => '&#54032;',
 "\xC6\xC8" => '&#54036;',
 "\xC6\xC9" => '&#54038;',
 "\xC6\xCA" => '&#54044;',
 "\xC6\xCB" => '&#54045;',
 "\xC6\xCC" => '&#54047;',
 "\xC6\xCD" => '&#54048;',
 "\xC6\xCE" => '&#54049;',
 "\xC6\xCF" => '&#54053;',
 "\xC6\xD0" => '&#54056;',
 "\xC6\xD1" => '&#54057;',
 "\xC6\xD2" => '&#54060;',
 "\xC6\xD3" => '&#54064;',
 "\xC6\xD4" => '&#54072;',
 "\xC6\xD5" => '&#54073;',
 "\xC6\xD6" => '&#54075;',
 "\xC6\xD7" => '&#54076;',
 "\xC6\xD8" => '&#54077;',
 "\xC6\xD9" => '&#54084;',
 "\xC6\xDA" => '&#54085;',
 "\xC6\xDB" => '&#54140;',
 "\xC6\xDC" => '&#54141;',
 "\xC6\xDD" => '&#54144;',
 "\xC6\xDE" => '&#54148;',
 "\xC6\xDF" => '&#54156;',
 "\xC6\xE0" => '&#54157;',
 "\xC6\xE1" => '&#54159;',
 "\xC6\xE2" => '&#54160;',
 "\xC6\xE3" => '&#54161;',
 "\xC6\xE4" => '&#54168;',
 "\xC6\xE5" => '&#54169;',
 "\xC6\xE6" => '&#54172;',
 "\xC6\xE7" => '&#54176;',
 "\xC6\xE8" => '&#54184;',
 "\xC6\xE9" => '&#54185;',
 "\xC6\xEA" => '&#54187;',
 "\xC6\xEB" => '&#54189;',
 "\xC6\xEC" => '&#54196;',
 "\xC6\xED" => '&#54200;',
 "\xC6\xEE" => '&#54204;',
 "\xC6\xEF" => '&#54212;',
 "\xC6\xF0" => '&#54213;',
 "\xC6\xF1" => '&#54216;',
 "\xC6\xF2" => '&#54217;',
 "\xC6\xF3" => '&#54224;',
 "\xC6\xF4" => '&#54232;',
 "\xC6\xF5" => '&#54241;',
 "\xC6\xF6" => '&#54243;',
 "\xC6\xF7" => '&#54252;',
 "\xC6\xF8" => '&#54253;',
 "\xC6\xF9" => '&#54256;',
 "\xC6\xFA" => '&#54260;',
 "\xC6\xFB" => '&#54268;',
 "\xC6\xFC" => '&#54269;',
 "\xC6\xFD" => '&#54271;',
 "\xC6\xFE" => '&#54273;',
 "\xC7\xA1" => '&#54280;',
 "\xC7\xA2" => '&#54301;',
 "\xC7\xA3" => '&#54336;',
 "\xC7\xA4" => '&#54340;',
 "\xC7\xA5" => '&#54364;',
 "\xC7\xA6" => '&#54368;',
 "\xC7\xA7" => '&#54372;',
 "\xC7\xA8" => '&#54381;',
 "\xC7\xA9" => '&#54383;',
 "\xC7\xAA" => '&#54392;',
 "\xC7\xAB" => '&#54393;',
 "\xC7\xAC" => '&#54396;',
 "\xC7\xAD" => '&#54399;',
 "\xC7\xAE" => '&#54400;',
 "\xC7\xAF" => '&#54402;',
 "\xC7\xB0" => '&#54408;',
 "\xC7\xB1" => '&#54409;',
 "\xC7\xB2" => '&#54411;',
 "\xC7\xB3" => '&#54413;',
 "\xC7\xB4" => '&#54420;',
 "\xC7\xB5" => '&#54441;',
 "\xC7\xB6" => '&#54476;',
 "\xC7\xB7" => '&#54480;',
 "\xC7\xB8" => '&#54484;',
 "\xC7\xB9" => '&#54492;',
 "\xC7\xBA" => '&#54495;',
 "\xC7\xBB" => '&#54504;',
 "\xC7\xBC" => '&#54508;',
 "\xC7\xBD" => '&#54512;',
 "\xC7\xBE" => '&#54520;',
 "\xC7\xBF" => '&#54523;',
 "\xC7\xC0" => '&#54525;',
 "\xC7\xC1" => '&#54532;',
 "\xC7\xC2" => '&#54536;',
 "\xC7\xC3" => '&#54540;',
 "\xC7\xC4" => '&#54548;',
 "\xC7\xC5" => '&#54549;',
 "\xC7\xC6" => '&#54551;',
 "\xC7\xC7" => '&#54588;',
 "\xC7\xC8" => '&#54589;',
 "\xC7\xC9" => '&#54592;',
 "\xC7\xCA" => '&#54596;',
 "\xC7\xCB" => '&#54604;',
 "\xC7\xCC" => '&#54605;',
 "\xC7\xCD" => '&#54607;',
 "\xC7\xCE" => '&#54609;',
 "\xC7\xCF" => '&#54616;',
 "\xC7\xD0" => '&#54617;',
 "\xC7\xD1" => '&#54620;',
 "\xC7\xD2" => '&#54624;',
 "\xC7\xD3" => '&#54629;',
 "\xC7\xD4" => '&#54632;',
 "\xC7\xD5" => '&#54633;',
 "\xC7\xD6" => '&#54635;',
 "\xC7\xD7" => '&#54637;',
 "\xC7\xD8" => '&#54644;',
 "\xC7\xD9" => '&#54645;',
 "\xC7\xDA" => '&#54648;',
 "\xC7\xDB" => '&#54652;',
 "\xC7\xDC" => '&#54660;',
 "\xC7\xDD" => '&#54661;',
 "\xC7\xDE" => '&#54663;',
 "\xC7\xDF" => '&#54664;',
 "\xC7\xE0" => '&#54665;',
 "\xC7\xE1" => '&#54672;',
 "\xC7\xE2" => '&#54693;',
 "\xC7\xE3" => '&#54728;',
 "\xC7\xE4" => '&#54729;',
 "\xC7\xE5" => '&#54732;',
 "\xC7\xE6" => '&#54736;',
 "\xC7\xE7" => '&#54738;',
 "\xC7\xE8" => '&#54744;',
 "\xC7\xE9" => '&#54745;',
 "\xC7\xEA" => '&#54747;',
 "\xC7\xEB" => '&#54749;',
 "\xC7\xEC" => '&#54756;',
 "\xC7\xED" => '&#54757;',
 "\xC7\xEE" => '&#54760;',
 "\xC7\xEF" => '&#54764;',
 "\xC7\xF0" => '&#54772;',
 "\xC7\xF1" => '&#54773;',
 "\xC7\xF2" => '&#54775;',
 "\xC7\xF3" => '&#54777;',
 "\xC7\xF4" => '&#54784;',
 "\xC7\xF5" => '&#54785;',
 "\xC7\xF6" => '&#54788;',
 "\xC7\xF7" => '&#54792;',
 "\xC7\xF8" => '&#54800;',
 "\xC7\xF9" => '&#54801;',
 "\xC7\xFA" => '&#54803;',
 "\xC7\xFB" => '&#54804;',
 "\xC7\xFC" => '&#54805;',
 "\xC7\xFD" => '&#54812;',
 "\xC7\xFE" => '&#54816;',
 "\xC8\xA1" => '&#54820;',
 "\xC8\xA2" => '&#54829;',
 "\xC8\xA3" => '&#54840;',
 "\xC8\xA4" => '&#54841;',
 "\xC8\xA5" => '&#54844;',
 "\xC8\xA6" => '&#54848;',
 "\xC8\xA7" => '&#54853;',
 "\xC8\xA8" => '&#54856;',
 "\xC8\xA9" => '&#54857;',
 "\xC8\xAA" => '&#54859;',
 "\xC8\xAB" => '&#54861;',
 "\xC8\xAC" => '&#54865;',
 "\xC8\xAD" => '&#54868;',
 "\xC8\xAE" => '&#54869;',
 "\xC8\xAF" => '&#54872;',
 "\xC8\xB0" => '&#54876;',
 "\xC8\xB1" => '&#54887;',
 "\xC8\xB2" => '&#54889;',
 "\xC8\xB3" => '&#54896;',
 "\xC8\xB4" => '&#54897;',
 "\xC8\xB5" => '&#54900;',
 "\xC8\xB6" => '&#54915;',
 "\xC8\xB7" => '&#54917;',
 "\xC8\xB8" => '&#54924;',
 "\xC8\xB9" => '&#54925;',
 "\xC8\xBA" => '&#54928;',
 "\xC8\xBB" => '&#54932;',
 "\xC8\xBC" => '&#54941;',
 "\xC8\xBD" => '&#54943;',
 "\xC8\xBE" => '&#54945;',
 "\xC8\xBF" => '&#54952;',
 "\xC8\xC0" => '&#54956;',
 "\xC8\xC1" => '&#54960;',
 "\xC8\xC2" => '&#54969;',
 "\xC8\xC3" => '&#54971;',
 "\xC8\xC4" => '&#54980;',
 "\xC8\xC5" => '&#54981;',
 "\xC8\xC6" => '&#54984;',
 "\xC8\xC7" => '&#54988;',
 "\xC8\xC8" => '&#54993;',
 "\xC8\xC9" => '&#54996;',
 "\xC8\xCA" => '&#54999;',
 "\xC8\xCB" => '&#55001;',
 "\xC8\xCC" => '&#55008;',
 "\xC8\xCD" => '&#55012;',
 "\xC8\xCE" => '&#55016;',
 "\xC8\xCF" => '&#55024;',
 "\xC8\xD0" => '&#55029;',
 "\xC8\xD1" => '&#55036;',
 "\xC8\xD2" => '&#55037;',
 "\xC8\xD3" => '&#55040;',
 "\xC8\xD4" => '&#55044;',
 "\xC8\xD5" => '&#55057;',
 "\xC8\xD6" => '&#55064;',
 "\xC8\xD7" => '&#55065;',
 "\xC8\xD8" => '&#55068;',
 "\xC8\xD9" => '&#55072;',
 "\xC8\xDA" => '&#55080;',
 "\xC8\xDB" => '&#55081;',
 "\xC8\xDC" => '&#55083;',
 "\xC8\xDD" => '&#55085;',
 "\xC8\xDE" => '&#55092;',
 "\xC8\xDF" => '&#55093;',
 "\xC8\xE0" => '&#55096;',
 "\xC8\xE1" => '&#55100;',
 "\xC8\xE2" => '&#55108;',
 "\xC8\xE3" => '&#55111;',
 "\xC8\xE4" => '&#55113;',
 "\xC8\xE5" => '&#55120;',
 "\xC8\xE6" => '&#55121;',
 "\xC8\xE7" => '&#55124;',
 "\xC8\xE8" => '&#55126;',
 "\xC8\xE9" => '&#55127;',
 "\xC8\xEA" => '&#55128;',
 "\xC8\xEB" => '&#55129;',
 "\xC8\xEC" => '&#55136;',
 "\xC8\xED" => '&#55137;',
 "\xC8\xEE" => '&#55139;',
 "\xC8\xEF" => '&#55141;',
 "\xC8\xF0" => '&#55145;',
 "\xC8\xF1" => '&#55148;',
 "\xC8\xF2" => '&#55152;',
 "\xC8\xF3" => '&#55156;',
 "\xC8\xF4" => '&#55164;',
 "\xC8\xF5" => '&#55165;',
 "\xC8\xF6" => '&#55169;',
 "\xC8\xF7" => '&#55176;',
 "\xC8\xF8" => '&#55177;',
 "\xC8\xF9" => '&#55180;',
 "\xC8\xFA" => '&#55184;',
 "\xC8\xFB" => '&#55192;',
 "\xC8\xFC" => '&#55193;',
 "\xC8\xFD" => '&#55195;',
 "\xC8\xFE" => '&#55197;',
 "\xCA\xA1" => '&#20285;',
 "\xCA\xA2" => '&#20339;',
 "\xCA\xA3" => '&#20551;',
 "\xCA\xA4" => '&#20729;',
 "\xCA\xA5" => '&#21152;',
 "\xCA\xA6" => '&#21487;',
 "\xCA\xA7" => '&#21621;',
 "\xCA\xA8" => '&#21733;',
 "\xCA\xA9" => '&#22025;',
 "\xCA\xAA" => '&#23233;',
 "\xCA\xAB" => '&#23478;',
 "\xCA\xAC" => '&#26247;',
 "\xCA\xAD" => '&#26550;',
 "\xCA\xAE" => '&#26551;',
 "\xCA\xAF" => '&#26607;',
 "\xCA\xB0" => '&#27468;',
 "\xCA\xB1" => '&#29634;',
 "\xCA\xB2" => '&#30146;',
 "\xCA\xB3" => '&#31292;',
 "\xCA\xB4" => '&#33499;',
 "\xCA\xB5" => '&#33540;',
 "\xCA\xB6" => '&#34903;',
 "\xCA\xB7" => '&#34952;',
 "\xCA\xB8" => '&#35382;',
 "\xCA\xB9" => '&#36040;',
 "\xCA\xBA" => '&#36303;',
 "\xCA\xBB" => '&#36603;',
 "\xCA\xBC" => '&#36838;',
 "\xCA\xBD" => '&#39381;',
 "\xCA\xBE" => '&#21051;',
 "\xCA\xBF" => '&#21364;',
 "\xCA\xC0" => '&#21508;',
 "\xCA\xC1" => '&#24682;',
 "\xCA\xC2" => '&#24932;',
 "\xCA\xC3" => '&#27580;',
 "\xCA\xC4" => '&#29647;',
 "\xCA\xC5" => '&#33050;',
 "\xCA\xC6" => '&#35258;',
 "\xCA\xC7" => '&#35282;',
 "\xCA\xC8" => '&#38307;',
 "\xCA\xC9" => '&#20355;',
 "\xCA\xCA" => '&#21002;',
 "\xCA\xCB" => '&#22718;',
 "\xCA\xCC" => '&#22904;',
 "\xCA\xCD" => '&#23014;',
 "\xCA\xCE" => '&#24178;',
 "\xCA\xCF" => '&#24185;',
 "\xCA\xD0" => '&#25031;',
 "\xCA\xD1" => '&#25536;',
 "\xCA\xD2" => '&#26438;',
 "\xCA\xD3" => '&#26604;',
 "\xCA\xD4" => '&#26751;',
 "\xCA\xD5" => '&#28567;',
 "\xCA\xD6" => '&#30286;',
 "\xCA\xD7" => '&#30475;',
 "\xCA\xD8" => '&#30965;',
 "\xCA\xD9" => '&#31240;',
 "\xCA\xDA" => '&#31487;',
 "\xCA\xDB" => '&#31777;',
 "\xCA\xDC" => '&#32925;',
 "\xCA\xDD" => '&#33390;',
 "\xCA\xDE" => '&#33393;',
 "\xCA\xDF" => '&#35563;',
 "\xCA\xE0" => '&#38291;',
 "\xCA\xE1" => '&#20075;',
 "\xCA\xE2" => '&#21917;',
 "\xCA\xE3" => '&#26359;',
 "\xCA\xE4" => '&#28212;',
 "\xCA\xE5" => '&#30883;',
 "\xCA\xE6" => '&#31469;',
 "\xCA\xE7" => '&#33883;',
 "\xCA\xE8" => '&#35088;',
 "\xCA\xE9" => '&#34638;',
 "\xCA\xEA" => '&#38824;',
 "\xCA\xEB" => '&#21208;',
 "\xCA\xEC" => '&#22350;',
 "\xCA\xED" => '&#22570;',
 "\xCA\xEE" => '&#23884;',
 "\xCA\xEF" => '&#24863;',
 "\xCA\xF0" => '&#25022;',
 "\xCA\xF1" => '&#25121;',
 "\xCA\xF2" => '&#25954;',
 "\xCA\xF3" => '&#26577;',
 "\xCA\xF4" => '&#27204;',
 "\xCA\xF5" => '&#28187;',
 "\xCA\xF6" => '&#29976;',
 "\xCA\xF7" => '&#30131;',
 "\xCA\xF8" => '&#30435;',
 "\xCA\xF9" => '&#30640;',
 "\xCA\xFA" => '&#32058;',
 "\xCA\xFB" => '&#37039;',
 "\xCA\xFC" => '&#37969;',
 "\xCA\xFD" => '&#37970;',
 "\xCA\xFE" => '&#40853;',
 "\xCB\xA1" => '&#21283;',
 "\xCB\xA2" => '&#23724;',
 "\xCB\xA3" => '&#30002;',
 "\xCB\xA4" => '&#32987;',
 "\xCB\xA5" => '&#37440;',
 "\xCB\xA6" => '&#38296;',
 "\xCB\xA7" => '&#21083;',
 "\xCB\xA8" => '&#22536;',
 "\xCB\xA9" => '&#23004;',
 "\xCB\xAA" => '&#23713;',
 "\xCB\xAB" => '&#23831;',
 "\xCB\xAC" => '&#24247;',
 "\xCB\xAD" => '&#24378;',
 "\xCB\xAE" => '&#24394;',
 "\xCB\xAF" => '&#24951;',
 "\xCB\xB0" => '&#27743;',
 "\xCB\xB1" => '&#30074;',
 "\xCB\xB2" => '&#30086;',
 "\xCB\xB3" => '&#31968;',
 "\xCB\xB4" => '&#32115;',
 "\xCB\xB5" => '&#32177;',
 "\xCB\xB6" => '&#32652;',
 "\xCB\xB7" => '&#33108;',
 "\xCB\xB8" => '&#33313;',
 "\xCB\xB9" => '&#34193;',
 "\xCB\xBA" => '&#35137;',
 "\xCB\xBB" => '&#35611;',
 "\xCB\xBC" => '&#37628;',
 "\xCB\xBD" => '&#38477;',
 "\xCB\xBE" => '&#40007;',
 "\xCB\xBF" => '&#20171;',
 "\xCB\xC0" => '&#20215;',
 "\xCB\xC1" => '&#20491;',
 "\xCB\xC2" => '&#20977;',
 "\xCB\xC3" => '&#22607;',
 "\xCB\xC4" => '&#24887;',
 "\xCB\xC5" => '&#24894;',
 "\xCB\xC6" => '&#24936;',
 "\xCB\xC7" => '&#25913;',
 "\xCB\xC8" => '&#27114;',
 "\xCB\xC9" => '&#28433;',
 "\xCB\xCA" => '&#30117;',
 "\xCB\xCB" => '&#30342;',
 "\xCB\xCC" => '&#30422;',
 "\xCB\xCD" => '&#31623;',
 "\xCB\xCE" => '&#33445;',
 "\xCB\xCF" => '&#33995;',
 "\xCB\xD0" => '&#63744;',
 "\xCB\xD1" => '&#37799;',
 "\xCB\xD2" => '&#38283;',
 "\xCB\xD3" => '&#21888;',
 "\xCB\xD4" => '&#23458;',
 "\xCB\xD5" => '&#22353;',
 "\xCB\xD6" => '&#63745;',
 "\xCB\xD7" => '&#31923;',
 "\xCB\xD8" => '&#32697;',
 "\xCB\xD9" => '&#37301;',
 "\xCB\xDA" => '&#20520;',
 "\xCB\xDB" => '&#21435;',
 "\xCB\xDC" => '&#23621;',
 "\xCB\xDD" => '&#24040;',
 "\xCB\xDE" => '&#25298;',
 "\xCB\xDF" => '&#25454;',
 "\xCB\xE0" => '&#25818;',
 "\xCB\xE1" => '&#25831;',
 "\xCB\xE2" => '&#28192;',
 "\xCB\xE3" => '&#28844;',
 "\xCB\xE4" => '&#31067;',
 "\xCB\xE5" => '&#36317;',
 "\xCB\xE6" => '&#36382;',
 "\xCB\xE7" => '&#63746;',
 "\xCB\xE8" => '&#36989;',
 "\xCB\xE9" => '&#37445;',
 "\xCB\xEA" => '&#37624;',
 "\xCB\xEB" => '&#20094;',
 "\xCB\xEC" => '&#20214;',
 "\xCB\xED" => '&#20581;',
 "\xCB\xEE" => '&#24062;',
 "\xCB\xEF" => '&#24314;',
 "\xCB\xF0" => '&#24838;',
 "\xCB\xF1" => '&#26967;',
 "\xCB\xF2" => '&#33137;',
 "\xCB\xF3" => '&#34388;',
 "\xCB\xF4" => '&#36423;',
 "\xCB\xF5" => '&#37749;',
 "\xCB\xF6" => '&#39467;',
 "\xCB\xF7" => '&#20062;',
 "\xCB\xF8" => '&#20625;',
 "\xCB\xF9" => '&#26480;',
 "\xCB\xFA" => '&#26688;',
 "\xCB\xFB" => '&#20745;',
 "\xCB\xFC" => '&#21133;',
 "\xCB\xFD" => '&#21138;',
 "\xCB\xFE" => '&#27298;',
 "\xCC\xA1" => '&#30652;',
 "\xCC\xA2" => '&#37392;',
 "\xCC\xA3" => '&#40660;',
 "\xCC\xA4" => '&#21163;',
 "\xCC\xA5" => '&#24623;',
 "\xCC\xA6" => '&#36850;',
 "\xCC\xA7" => '&#20552;',
 "\xCC\xA8" => '&#25001;',
 "\xCC\xA9" => '&#25581;',
 "\xCC\xAA" => '&#25802;',
 "\xCC\xAB" => '&#26684;',
 "\xCC\xAC" => '&#27268;',
 "\xCC\xAD" => '&#28608;',
 "\xCC\xAE" => '&#33160;',
 "\xCC\xAF" => '&#35233;',
 "\xCC\xB0" => '&#38548;',
 "\xCC\xB1" => '&#22533;',
 "\xCC\xB2" => '&#29309;',
 "\xCC\xB3" => '&#29356;',
 "\xCC\xB4" => '&#29956;',
 "\xCC\xB5" => '&#32121;',
 "\xCC\xB6" => '&#32365;',
 "\xCC\xB7" => '&#32937;',
 "\xCC\xB8" => '&#35211;',
 "\xCC\xB9" => '&#35700;',
 "\xCC\xBA" => '&#36963;',
 "\xCC\xBB" => '&#40273;',
 "\xCC\xBC" => '&#25225;',
 "\xCC\xBD" => '&#27770;',
 "\xCC\xBE" => '&#28500;',
 "\xCC\xBF" => '&#32080;',
 "\xCC\xC0" => '&#32570;',
 "\xCC\xC1" => '&#35363;',
 "\xCC\xC2" => '&#20860;',
 "\xCC\xC3" => '&#24906;',
 "\xCC\xC4" => '&#31645;',
 "\xCC\xC5" => '&#35609;',
 "\xCC\xC6" => '&#37463;',
 "\xCC\xC7" => '&#37772;',
 "\xCC\xC8" => '&#20140;',
 "\xCC\xC9" => '&#20435;',
 "\xCC\xCA" => '&#20510;',
 "\xCC\xCB" => '&#20670;',
 "\xCC\xCC" => '&#20742;',
 "\xCC\xCD" => '&#21185;',
 "\xCC\xCE" => '&#21197;',
 "\xCC\xCF" => '&#21375;',
 "\xCC\xD0" => '&#22384;',
 "\xCC\xD1" => '&#22659;',
 "\xCC\xD2" => '&#24218;',
 "\xCC\xD3" => '&#24465;',
 "\xCC\xD4" => '&#24950;',
 "\xCC\xD5" => '&#25004;',
 "\xCC\xD6" => '&#25806;',
 "\xCC\xD7" => '&#25964;',
 "\xCC\xD8" => '&#26223;',
 "\xCC\xD9" => '&#26299;',
 "\xCC\xDA" => '&#26356;',
 "\xCC\xDB" => '&#26775;',
 "\xCC\xDC" => '&#28039;',
 "\xCC\xDD" => '&#28805;',
 "\xCC\xDE" => '&#28913;',
 "\xCC\xDF" => '&#29855;',
 "\xCC\xE0" => '&#29861;',
 "\xCC\xE1" => '&#29898;',
 "\xCC\xE2" => '&#30169;',
 "\xCC\xE3" => '&#30828;',
 "\xCC\xE4" => '&#30956;',
 "\xCC\xE5" => '&#31455;',
 "\xCC\xE6" => '&#31478;',
 "\xCC\xE7" => '&#32069;',
 "\xCC\xE8" => '&#32147;',
 "\xCC\xE9" => '&#32789;',
 "\xCC\xEA" => '&#32831;',
 "\xCC\xEB" => '&#33051;',
 "\xCC\xEC" => '&#33686;',
 "\xCC\xED" => '&#35686;',
 "\xCC\xEE" => '&#36629;',
 "\xCC\xEF" => '&#36885;',
 "\xCC\xF0" => '&#37857;',
 "\xCC\xF1" => '&#38915;',
 "\xCC\xF2" => '&#38968;',
 "\xCC\xF3" => '&#39514;',
 "\xCC\xF4" => '&#39912;',
 "\xCC\xF5" => '&#20418;',
 "\xCC\xF6" => '&#21843;',
 "\xCC\xF7" => '&#22586;',
 "\xCC\xF8" => '&#22865;',
 "\xCC\xF9" => '&#23395;',
 "\xCC\xFA" => '&#23622;',
 "\xCC\xFB" => '&#24760;',
 "\xCC\xFC" => '&#25106;',
 "\xCC\xFD" => '&#26690;',
 "\xCC\xFE" => '&#26800;',
 "\xCD\xA1" => '&#26856;',
 "\xCD\xA2" => '&#28330;',
 "\xCD\xA3" => '&#30028;',
 "\xCD\xA4" => '&#30328;',
 "\xCD\xA5" => '&#30926;',
 "\xCD\xA6" => '&#31293;',
 "\xCD\xA7" => '&#31995;',
 "\xCD\xA8" => '&#32363;',
 "\xCD\xA9" => '&#32380;',
 "\xCD\xAA" => '&#35336;',
 "\xCD\xAB" => '&#35489;',
 "\xCD\xAC" => '&#35903;',
 "\xCD\xAD" => '&#38542;',
 "\xCD\xAE" => '&#40388;',
 "\xCD\xAF" => '&#21476;',
 "\xCD\xB0" => '&#21481;',
 "\xCD\xB1" => '&#21578;',
 "\xCD\xB2" => '&#21617;',
 "\xCD\xB3" => '&#22266;',
 "\xCD\xB4" => '&#22993;',
 "\xCD\xB5" => '&#23396;',
 "\xCD\xB6" => '&#23611;',
 "\xCD\xB7" => '&#24235;',
 "\xCD\xB8" => '&#25335;',
 "\xCD\xB9" => '&#25911;',
 "\xCD\xBA" => '&#25925;',
 "\xCD\xBB" => '&#25970;',
 "\xCD\xBC" => '&#26272;',
 "\xCD\xBD" => '&#26543;',
 "\xCD\xBE" => '&#27073;',
 "\xCD\xBF" => '&#27837;',
 "\xCD\xC0" => '&#30204;',
 "\xCD\xC1" => '&#30352;',
 "\xCD\xC2" => '&#30590;',
 "\xCD\xC3" => '&#31295;',
 "\xCD\xC4" => '&#32660;',
 "\xCD\xC5" => '&#32771;',
 "\xCD\xC6" => '&#32929;',
 "\xCD\xC7" => '&#33167;',
 "\xCD\xC8" => '&#33510;',
 "\xCD\xC9" => '&#33533;',
 "\xCD\xCA" => '&#33776;',
 "\xCD\xCB" => '&#34241;',
 "\xCD\xCC" => '&#34865;',
 "\xCD\xCD" => '&#34996;',
 "\xCD\xCE" => '&#35493;',
 "\xCD\xCF" => '&#63747;',
 "\xCD\xD0" => '&#36764;',
 "\xCD\xD1" => '&#37678;',
 "\xCD\xD2" => '&#38599;',
 "\xCD\xD3" => '&#39015;',
 "\xCD\xD4" => '&#39640;',
 "\xCD\xD5" => '&#40723;',
 "\xCD\xD6" => '&#21741;',
 "\xCD\xD7" => '&#26011;',
 "\xCD\xD8" => '&#26354;',
 "\xCD\xD9" => '&#26767;',
 "\xCD\xDA" => '&#31296;',
 "\xCD\xDB" => '&#35895;',
 "\xCD\xDC" => '&#40288;',
 "\xCD\xDD" => '&#22256;',
 "\xCD\xDE" => '&#22372;',
 "\xCD\xDF" => '&#23825;',
 "\xCD\xE0" => '&#26118;',
 "\xCD\xE1" => '&#26801;',
 "\xCD\xE2" => '&#26829;',
 "\xCD\xE3" => '&#28414;',
 "\xCD\xE4" => '&#29736;',
 "\xCD\xE5" => '&#34974;',
 "\xCD\xE6" => '&#39908;',
 "\xCD\xE7" => '&#27752;',
 "\xCD\xE8" => '&#63748;',
 "\xCD\xE9" => '&#39592;',
 "\xCD\xEA" => '&#20379;',
 "\xCD\xEB" => '&#20844;',
 "\xCD\xEC" => '&#20849;',
 "\xCD\xED" => '&#21151;',
 "\xCD\xEE" => '&#23380;',
 "\xCD\xEF" => '&#24037;',
 "\xCD\xF0" => '&#24656;',
 "\xCD\xF1" => '&#24685;',
 "\xCD\xF2" => '&#25329;',
 "\xCD\xF3" => '&#25511;',
 "\xCD\xF4" => '&#25915;',
 "\xCD\xF5" => '&#29657;',
 "\xCD\xF6" => '&#31354;',
 "\xCD\xF7" => '&#34467;',
 "\xCD\xF8" => '&#36002;',
 "\xCD\xF9" => '&#38799;',
 "\xCD\xFA" => '&#20018;',
 "\xCD\xFB" => '&#23521;',
 "\xCD\xFC" => '&#25096;',
 "\xCD\xFD" => '&#26524;',
 "\xCD\xFE" => '&#29916;',
 "\xCE\xA1" => '&#31185;',
 "\xCE\xA2" => '&#33747;',
 "\xCE\xA3" => '&#35463;',
 "\xCE\xA4" => '&#35506;',
 "\xCE\xA5" => '&#36328;',
 "\xCE\xA6" => '&#36942;',
 "\xCE\xA7" => '&#37707;',
 "\xCE\xA8" => '&#38982;',
 "\xCE\xA9" => '&#24275;',
 "\xCE\xAA" => '&#27112;',
 "\xCE\xAB" => '&#34303;',
 "\xCE\xAC" => '&#37101;',
 "\xCE\xAD" => '&#63749;',
 "\xCE\xAE" => '&#20896;',
 "\xCE\xAF" => '&#23448;',
 "\xCE\xB0" => '&#23532;',
 "\xCE\xB1" => '&#24931;',
 "\xCE\xB2" => '&#26874;',
 "\xCE\xB3" => '&#27454;',
 "\xCE\xB4" => '&#28748;',
 "\xCE\xB5" => '&#29743;',
 "\xCE\xB6" => '&#29912;',
 "\xCE\xB7" => '&#31649;',
 "\xCE\xB8" => '&#32592;',
 "\xCE\xB9" => '&#33733;',
 "\xCE\xBA" => '&#35264;',
 "\xCE\xBB" => '&#36011;',
 "\xCE\xBC" => '&#38364;',
 "\xCE\xBD" => '&#39208;',
 "\xCE\xBE" => '&#21038;',
 "\xCE\xBF" => '&#24669;',
 "\xCE\xC0" => '&#25324;',
 "\xCE\xC1" => '&#36866;',
 "\xCE\xC2" => '&#20362;',
 "\xCE\xC3" => '&#20809;',
 "\xCE\xC4" => '&#21281;',
 "\xCE\xC5" => '&#22745;',
 "\xCE\xC6" => '&#24291;',
 "\xCE\xC7" => '&#26336;',
 "\xCE\xC8" => '&#27960;',
 "\xCE\xC9" => '&#28826;',
 "\xCE\xCA" => '&#29378;',
 "\xCE\xCB" => '&#29654;',
 "\xCE\xCC" => '&#31568;',
 "\xCE\xCD" => '&#33009;',
 "\xCE\xCE" => '&#37979;',
 "\xCE\xCF" => '&#21350;',
 "\xCE\xD0" => '&#25499;',
 "\xCE\xD1" => '&#32619;',
 "\xCE\xD2" => '&#20054;',
 "\xCE\xD3" => '&#20608;',
 "\xCE\xD4" => '&#22602;',
 "\xCE\xD5" => '&#22750;',
 "\xCE\xD6" => '&#24618;',
 "\xCE\xD7" => '&#24871;',
 "\xCE\xD8" => '&#25296;',
 "\xCE\xD9" => '&#27088;',
 "\xCE\xDA" => '&#39745;',
 "\xCE\xDB" => '&#23439;',
 "\xCE\xDC" => '&#32024;',
 "\xCE\xDD" => '&#32945;',
 "\xCE\xDE" => '&#36703;',
 "\xCE\xDF" => '&#20132;',
 "\xCE\xE0" => '&#20689;',
 "\xCE\xE1" => '&#21676;',
 "\xCE\xE2" => '&#21932;',
 "\xCE\xE3" => '&#23308;',
 "\xCE\xE4" => '&#23968;',
 "\xCE\xE5" => '&#24039;',
 "\xCE\xE6" => '&#25898;',
 "\xCE\xE7" => '&#25934;',
 "\xCE\xE8" => '&#26657;',
 "\xCE\xE9" => '&#27211;',
 "\xCE\xEA" => '&#29409;',
 "\xCE\xEB" => '&#30350;',
 "\xCE\xEC" => '&#30703;',
 "\xCE\xED" => '&#32094;',
 "\xCE\xEE" => '&#32761;',
 "\xCE\xEF" => '&#33184;',
 "\xCE\xF0" => '&#34126;',
 "\xCE\xF1" => '&#34527;',
 "\xCE\xF2" => '&#36611;',
 "\xCE\xF3" => '&#36686;',
 "\xCE\xF4" => '&#37066;',
 "\xCE\xF5" => '&#39171;',
 "\xCE\xF6" => '&#39509;',
 "\xCE\xF7" => '&#39851;',
 "\xCE\xF8" => '&#19992;',
 "\xCE\xF9" => '&#20037;',
 "\xCE\xFA" => '&#20061;',
 "\xCE\xFB" => '&#20167;',
 "\xCE\xFC" => '&#20465;',
 "\xCE\xFD" => '&#20855;',
 "\xCE\xFE" => '&#21246;',
 "\xCF\xA1" => '&#21312;',
 "\xCF\xA2" => '&#21475;',
 "\xCF\xA3" => '&#21477;',
 "\xCF\xA4" => '&#21646;',
 "\xCF\xA5" => '&#22036;',
 "\xCF\xA6" => '&#22389;',
 "\xCF\xA7" => '&#22434;',
 "\xCF\xA8" => '&#23495;',
 "\xCF\xA9" => '&#23943;',
 "\xCF\xAA" => '&#24272;',
 "\xCF\xAB" => '&#25084;',
 "\xCF\xAC" => '&#25304;',
 "\xCF\xAD" => '&#25937;',
 "\xCF\xAE" => '&#26552;',
 "\xCF\xAF" => '&#26601;',
 "\xCF\xB0" => '&#27083;',
 "\xCF\xB1" => '&#27472;',
 "\xCF\xB2" => '&#27590;',
 "\xCF\xB3" => '&#27628;',
 "\xCF\xB4" => '&#27714;',
 "\xCF\xB5" => '&#28317;',
 "\xCF\xB6" => '&#28792;',
 "\xCF\xB7" => '&#29399;',
 "\xCF\xB8" => '&#29590;',
 "\xCF\xB9" => '&#29699;',
 "\xCF\xBA" => '&#30655;',
 "\xCF\xBB" => '&#30697;',
 "\xCF\xBC" => '&#31350;',
 "\xCF\xBD" => '&#32127;',
 "\xCF\xBE" => '&#32777;',
 "\xCF\xBF" => '&#33276;',
 "\xCF\xC0" => '&#33285;',
 "\xCF\xC1" => '&#33290;',
 "\xCF\xC2" => '&#33503;',
 "\xCF\xC3" => '&#34914;',
 "\xCF\xC4" => '&#35635;',
 "\xCF\xC5" => '&#36092;',
 "\xCF\xC6" => '&#36544;',
 "\xCF\xC7" => '&#36881;',
 "\xCF\xC8" => '&#37041;',
 "\xCF\xC9" => '&#37476;',
 "\xCF\xCA" => '&#37558;',
 "\xCF\xCB" => '&#39378;',
 "\xCF\xCC" => '&#39493;',
 "\xCF\xCD" => '&#40169;',
 "\xCF\xCE" => '&#40407;',
 "\xCF\xCF" => '&#40860;',
 "\xCF\xD0" => '&#22283;',
 "\xCF\xD1" => '&#23616;',
 "\xCF\xD2" => '&#33738;',
 "\xCF\xD3" => '&#38816;',
 "\xCF\xD4" => '&#38827;',
 "\xCF\xD5" => '&#40628;',
 "\xCF\xD6" => '&#21531;',
 "\xCF\xD7" => '&#31384;',
 "\xCF\xD8" => '&#32676;',
 "\xCF\xD9" => '&#35033;',
 "\xCF\xDA" => '&#36557;',
 "\xCF\xDB" => '&#37089;',
 "\xCF\xDC" => '&#22528;',
 "\xCF\xDD" => '&#23624;',
 "\xCF\xDE" => '&#25496;',
 "\xCF\xDF" => '&#31391;',
 "\xCF\xE0" => '&#23470;',
 "\xCF\xE1" => '&#24339;',
 "\xCF\xE2" => '&#31353;',
 "\xCF\xE3" => '&#31406;',
 "\xCF\xE4" => '&#33422;',
 "\xCF\xE5" => '&#36524;',
 "\xCF\xE6" => '&#20518;',
 "\xCF\xE7" => '&#21048;',
 "\xCF\xE8" => '&#21240;',
 "\xCF\xE9" => '&#21367;',
 "\xCF\xEA" => '&#22280;',
 "\xCF\xEB" => '&#25331;',
 "\xCF\xEC" => '&#25458;',
 "\xCF\xED" => '&#27402;',
 "\xCF\xEE" => '&#28099;',
 "\xCF\xEF" => '&#30519;',
 "\xCF\xF0" => '&#21413;',
 "\xCF\xF1" => '&#29527;',
 "\xCF\xF2" => '&#34152;',
 "\xCF\xF3" => '&#36470;',
 "\xCF\xF4" => '&#38357;',
 "\xCF\xF5" => '&#26426;',
 "\xCF\xF6" => '&#27331;',
 "\xCF\xF7" => '&#28528;',
 "\xCF\xF8" => '&#35437;',
 "\xCF\xF9" => '&#36556;',
 "\xCF\xFA" => '&#39243;',
 "\xCF\xFB" => '&#63750;',
 "\xCF\xFC" => '&#26231;',
 "\xCF\xFD" => '&#27512;',
 "\xCF\xFE" => '&#36020;',
 "\xD0\xA1" => '&#39740;',
 "\xD0\xA2" => '&#63751;',
 "\xD0\xA3" => '&#21483;',
 "\xD0\xA4" => '&#22317;',
 "\xD0\xA5" => '&#22862;',
 "\xD0\xA6" => '&#25542;',
 "\xD0\xA7" => '&#27131;',
 "\xD0\xA8" => '&#29674;',
 "\xD0\xA9" => '&#30789;',
 "\xD0\xAA" => '&#31418;',
 "\xD0\xAB" => '&#31429;',
 "\xD0\xAC" => '&#31998;',
 "\xD0\xAD" => '&#33909;',
 "\xD0\xAE" => '&#35215;',
 "\xD0\xAF" => '&#36211;',
 "\xD0\xB0" => '&#36917;',
 "\xD0\xB1" => '&#38312;',
 "\xD0\xB2" => '&#21243;',
 "\xD0\xB3" => '&#22343;',
 "\xD0\xB4" => '&#30023;',
 "\xD0\xB5" => '&#31584;',
 "\xD0\xB6" => '&#33740;',
 "\xD0\xB7" => '&#37406;',
 "\xD0\xB8" => '&#63752;',
 "\xD0\xB9" => '&#27224;',
 "\xD0\xBA" => '&#20811;',
 "\xD0\xBB" => '&#21067;',
 "\xD0\xBC" => '&#21127;',
 "\xD0\xBD" => '&#25119;',
 "\xD0\xBE" => '&#26840;',
 "\xD0\xBF" => '&#26997;',
 "\xD0\xC0" => '&#38553;',
 "\xD0\xC1" => '&#20677;',
 "\xD0\xC2" => '&#21156;',
 "\xD0\xC3" => '&#21220;',
 "\xD0\xC4" => '&#25027;',
 "\xD0\xC5" => '&#26020;',
 "\xD0\xC6" => '&#26681;',
 "\xD0\xC7" => '&#27135;',
 "\xD0\xC8" => '&#29822;',
 "\xD0\xC9" => '&#31563;',
 "\xD0\xCA" => '&#33465;',
 "\xD0\xCB" => '&#33771;',
 "\xD0\xCC" => '&#35250;',
 "\xD0\xCD" => '&#35641;',
 "\xD0\xCE" => '&#36817;',
 "\xD0\xCF" => '&#39241;',
 "\xD0\xD0" => '&#63753;',
 "\xD0\xD1" => '&#20170;',
 "\xD0\xD2" => '&#22935;',
 "\xD0\xD3" => '&#25810;',
 "\xD0\xD4" => '&#26129;',
 "\xD0\xD5" => '&#27278;',
 "\xD0\xD6" => '&#29748;',
 "\xD0\xD7" => '&#31105;',
 "\xD0\xD8" => '&#31165;',
 "\xD0\xD9" => '&#33449;',
 "\xD0\xDA" => '&#34942;',
 "\xD0\xDB" => '&#34943;',
 "\xD0\xDC" => '&#35167;',
 "\xD0\xDD" => '&#63754;',
 "\xD0\xDE" => '&#37670;',
 "\xD0\xDF" => '&#20235;',
 "\xD0\xE0" => '&#21450;',
 "\xD0\xE1" => '&#24613;',
 "\xD0\xE2" => '&#25201;',
 "\xD0\xE3" => '&#27762;',
 "\xD0\xE4" => '&#32026;',
 "\xD0\xE5" => '&#32102;',
 "\xD0\xE6" => '&#20120;',
 "\xD0\xE7" => '&#20834;',
 "\xD0\xE8" => '&#30684;',
 "\xD0\xE9" => '&#32943;',
 "\xD0\xEA" => '&#20225;',
 "\xD0\xEB" => '&#20238;',
 "\xD0\xEC" => '&#20854;',
 "\xD0\xED" => '&#20864;',
 "\xD0\xEE" => '&#21980;',
 "\xD0\xEF" => '&#22120;',
 "\xD0\xF0" => '&#22331;',
 "\xD0\xF1" => '&#22522;',
 "\xD0\xF2" => '&#22524;',
 "\xD0\xF3" => '&#22804;',
 "\xD0\xF4" => '&#22855;',
 "\xD0\xF5" => '&#22931;',
 "\xD0\xF6" => '&#23492;',
 "\xD0\xF7" => '&#23696;',
 "\xD0\xF8" => '&#23822;',
 "\xD0\xF9" => '&#24049;',
 "\xD0\xFA" => '&#24190;',
 "\xD0\xFB" => '&#24524;',
 "\xD0\xFC" => '&#25216;',
 "\xD0\xFD" => '&#26071;',
 "\xD0\xFE" => '&#26083;',
 "\xD1\xA1" => '&#26398;',
 "\xD1\xA2" => '&#26399;',
 "\xD1\xA3" => '&#26462;',
 "\xD1\xA4" => '&#26827;',
 "\xD1\xA5" => '&#26820;',
 "\xD1\xA6" => '&#27231;',
 "\xD1\xA7" => '&#27450;',
 "\xD1\xA8" => '&#27683;',
 "\xD1\xA9" => '&#27773;',
 "\xD1\xAA" => '&#27778;',
 "\xD1\xAB" => '&#28103;',
 "\xD1\xAC" => '&#29592;',
 "\xD1\xAD" => '&#29734;',
 "\xD1\xAE" => '&#29738;',
 "\xD1\xAF" => '&#29826;',
 "\xD1\xB0" => '&#29859;',
 "\xD1\xB1" => '&#30072;',
 "\xD1\xB2" => '&#30079;',
 "\xD1\xB3" => '&#30849;',
 "\xD1\xB4" => '&#30959;',
 "\xD1\xB5" => '&#31041;',
 "\xD1\xB6" => '&#31047;',
 "\xD1\xB7" => '&#31048;',
 "\xD1\xB8" => '&#31098;',
 "\xD1\xB9" => '&#31637;',
 "\xD1\xBA" => '&#32000;',
 "\xD1\xBB" => '&#32186;',
 "\xD1\xBC" => '&#32648;',
 "\xD1\xBD" => '&#32774;',
 "\xD1\xBE" => '&#32813;',
 "\xD1\xBF" => '&#32908;',
 "\xD1\xC0" => '&#35352;',
 "\xD1\xC1" => '&#35663;',
 "\xD1\xC2" => '&#35912;',
 "\xD1\xC3" => '&#36215;',
 "\xD1\xC4" => '&#37665;',
 "\xD1\xC5" => '&#37668;',
 "\xD1\xC6" => '&#39138;',
 "\xD1\xC7" => '&#39249;',
 "\xD1\xC8" => '&#39438;',
 "\xD1\xC9" => '&#39439;',
 "\xD1\xCA" => '&#39525;',
 "\xD1\xCB" => '&#40594;',
 "\xD1\xCC" => '&#32202;',
 "\xD1\xCD" => '&#20342;',
 "\xD1\xCE" => '&#21513;',
 "\xD1\xCF" => '&#25326;',
 "\xD1\xD0" => '&#26708;',
 "\xD1\xD1" => '&#37329;',
 "\xD1\xD2" => '&#21931;',
 "\xD1\xD3" => '&#20794;',
 "\xD1\xD4" => '&#63755;',
 "\xD1\xD5" => '&#63756;',
 "\xD1\xD6" => '&#23068;',
 "\xD1\xD7" => '&#25062;',
 "\xD1\xD8" => '&#63757;',
 "\xD1\xD9" => '&#25295;',
 "\xD1\xDA" => '&#25343;',
 "\xD1\xDB" => '&#63758;',
 "\xD1\xDC" => '&#63759;',
 "\xD1\xDD" => '&#63760;',
 "\xD1\xDE" => '&#63761;',
 "\xD1\xDF" => '&#63762;',
 "\xD1\xE0" => '&#63763;',
 "\xD1\xE1" => '&#37027;',
 "\xD1\xE2" => '&#63764;',
 "\xD1\xE3" => '&#63765;',
 "\xD1\xE4" => '&#63766;',
 "\xD1\xE5" => '&#63767;',
 "\xD1\xE6" => '&#63768;',
 "\xD1\xE7" => '&#35582;',
 "\xD1\xE8" => '&#63769;',
 "\xD1\xE9" => '&#63770;',
 "\xD1\xEA" => '&#63771;',
 "\xD1\xEB" => '&#63772;',
 "\xD1\xEC" => '&#26262;',
 "\xD1\xED" => '&#63773;',
 "\xD1\xEE" => '&#29014;',
 "\xD1\xEF" => '&#63774;',
 "\xD1\xF0" => '&#63775;',
 "\xD1\xF1" => '&#38627;',
 "\xD1\xF2" => '&#63776;',
 "\xD1\xF3" => '&#25423;',
 "\xD1\xF4" => '&#25466;',
 "\xD1\xF5" => '&#21335;',
 "\xD1\xF6" => '&#63777;',
 "\xD1\xF7" => '&#26511;',
 "\xD1\xF8" => '&#26976;',
 "\xD1\xF9" => '&#28275;',
 "\xD1\xFA" => '&#63778;',
 "\xD1\xFB" => '&#30007;',
 "\xD1\xFC" => '&#63779;',
 "\xD1\xFD" => '&#63780;',
 "\xD1\xFE" => '&#63781;',
 "\xD2\xA1" => '&#32013;',
 "\xD2\xA2" => '&#63782;',
 "\xD2\xA3" => '&#63783;',
 "\xD2\xA4" => '&#34930;',
 "\xD2\xA5" => '&#22218;',
 "\xD2\xA6" => '&#23064;',
 "\xD2\xA7" => '&#63784;',
 "\xD2\xA8" => '&#63785;',
 "\xD2\xA9" => '&#63786;',
 "\xD2\xAA" => '&#63787;',
 "\xD2\xAB" => '&#63788;',
 "\xD2\xAC" => '&#20035;',
 "\xD2\xAD" => '&#63789;',
 "\xD2\xAE" => '&#20839;',
 "\xD2\xAF" => '&#22856;',
 "\xD2\xB0" => '&#26608;',
 "\xD2\xB1" => '&#32784;',
 "\xD2\xB2" => '&#63790;',
 "\xD2\xB3" => '&#22899;',
 "\xD2\xB4" => '&#24180;',
 "\xD2\xB5" => '&#25754;',
 "\xD2\xB6" => '&#31178;',
 "\xD2\xB7" => '&#24565;',
 "\xD2\xB8" => '&#24684;',
 "\xD2\xB9" => '&#25288;',
 "\xD2\xBA" => '&#25467;',
 "\xD2\xBB" => '&#23527;',
 "\xD2\xBC" => '&#23511;',
 "\xD2\xBD" => '&#21162;',
 "\xD2\xBE" => '&#63791;',
 "\xD2\xBF" => '&#22900;',
 "\xD2\xC0" => '&#24361;',
 "\xD2\xC1" => '&#24594;',
 "\xD2\xC2" => '&#63792;',
 "\xD2\xC3" => '&#63793;',
 "\xD2\xC4" => '&#63794;',
 "\xD2\xC5" => '&#29785;',
 "\xD2\xC6" => '&#63795;',
 "\xD2\xC7" => '&#63796;',
 "\xD2\xC8" => '&#63797;',
 "\xD2\xC9" => '&#63798;',
 "\xD2\xCA" => '&#63799;',
 "\xD2\xCB" => '&#63800;',
 "\xD2\xCC" => '&#39377;',
 "\xD2\xCD" => '&#63801;',
 "\xD2\xCE" => '&#63802;',
 "\xD2\xCF" => '&#63803;',
 "\xD2\xD0" => '&#63804;',
 "\xD2\xD1" => '&#63805;',
 "\xD2\xD2" => '&#63806;',
 "\xD2\xD3" => '&#63807;',
 "\xD2\xD4" => '&#63808;',
 "\xD2\xD5" => '&#63809;',
 "\xD2\xD6" => '&#63810;',
 "\xD2\xD7" => '&#63811;',
 "\xD2\xD8" => '&#28611;',
 "\xD2\xD9" => '&#63812;',
 "\xD2\xDA" => '&#63813;',
 "\xD2\xDB" => '&#33215;',
 "\xD2\xDC" => '&#36786;',
 "\xD2\xDD" => '&#24817;',
 "\xD2\xDE" => '&#63814;',
 "\xD2\xDF" => '&#63815;',
 "\xD2\xE0" => '&#33126;',
 "\xD2\xE1" => '&#63816;',
 "\xD2\xE2" => '&#63817;',
 "\xD2\xE3" => '&#23615;',
 "\xD2\xE4" => '&#63818;',
 "\xD2\xE5" => '&#63819;',
 "\xD2\xE6" => '&#63820;',
 "\xD2\xE7" => '&#63821;',
 "\xD2\xE8" => '&#63822;',
 "\xD2\xE9" => '&#63823;',
 "\xD2\xEA" => '&#63824;',
 "\xD2\xEB" => '&#63825;',
 "\xD2\xEC" => '&#23273;',
 "\xD2\xED" => '&#35365;',
 "\xD2\xEE" => '&#26491;',
 "\xD2\xEF" => '&#32016;',
 "\xD2\xF0" => '&#63826;',
 "\xD2\xF1" => '&#63827;',
 "\xD2\xF2" => '&#63828;',
 "\xD2\xF3" => '&#63829;',
 "\xD2\xF4" => '&#63830;',
 "\xD2\xF5" => '&#63831;',
 "\xD2\xF6" => '&#33021;',
 "\xD2\xF7" => '&#63832;',
 "\xD2\xF8" => '&#63833;',
 "\xD2\xF9" => '&#23612;',
 "\xD2\xFA" => '&#27877;',
 "\xD2\xFB" => '&#21311;',
 "\xD2\xFC" => '&#28346;',
 "\xD2\xFD" => '&#22810;',
 "\xD2\xFE" => '&#33590;',
 "\xD3\xA1" => '&#20025;',
 "\xD3\xA2" => '&#20150;',
 "\xD3\xA3" => '&#20294;',
 "\xD3\xA4" => '&#21934;',
 "\xD3\xA5" => '&#22296;',
 "\xD3\xA6" => '&#22727;',
 "\xD3\xA7" => '&#24406;',
 "\xD3\xA8" => '&#26039;',
 "\xD3\xA9" => '&#26086;',
 "\xD3\xAA" => '&#27264;',
 "\xD3\xAB" => '&#27573;',
 "\xD3\xAC" => '&#28237;',
 "\xD3\xAD" => '&#30701;',
 "\xD3\xAE" => '&#31471;',
 "\xD3\xAF" => '&#31774;',
 "\xD3\xB0" => '&#32222;',
 "\xD3\xB1" => '&#34507;',
 "\xD3\xB2" => '&#34962;',
 "\xD3\xB3" => '&#37170;',
 "\xD3\xB4" => '&#37723;',
 "\xD3\xB5" => '&#25787;',
 "\xD3\xB6" => '&#28606;',
 "\xD3\xB7" => '&#29562;',
 "\xD3\xB8" => '&#30136;',
 "\xD3\xB9" => '&#36948;',
 "\xD3\xBA" => '&#21846;',
 "\xD3\xBB" => '&#22349;',
 "\xD3\xBC" => '&#25018;',
 "\xD3\xBD" => '&#25812;',
 "\xD3\xBE" => '&#26311;',
 "\xD3\xBF" => '&#28129;',
 "\xD3\xC0" => '&#28251;',
 "\xD3\xC1" => '&#28525;',
 "\xD3\xC2" => '&#28601;',
 "\xD3\xC3" => '&#30192;',
 "\xD3\xC4" => '&#32835;',
 "\xD3\xC5" => '&#33213;',
 "\xD3\xC6" => '&#34113;',
 "\xD3\xC7" => '&#35203;',
 "\xD3\xC8" => '&#35527;',
 "\xD3\xC9" => '&#35674;',
 "\xD3\xCA" => '&#37663;',
 "\xD3\xCB" => '&#27795;',
 "\xD3\xCC" => '&#30035;',
 "\xD3\xCD" => '&#31572;',
 "\xD3\xCE" => '&#36367;',
 "\xD3\xCF" => '&#36957;',
 "\xD3\xD0" => '&#21776;',
 "\xD3\xD1" => '&#22530;',
 "\xD3\xD2" => '&#22616;',
 "\xD3\xD3" => '&#24162;',
 "\xD3\xD4" => '&#25095;',
 "\xD3\xD5" => '&#25758;',
 "\xD3\xD6" => '&#26848;',
 "\xD3\xD7" => '&#30070;',
 "\xD3\xD8" => '&#31958;',
 "\xD3\xD9" => '&#34739;',
 "\xD3\xDA" => '&#40680;',
 "\xD3\xDB" => '&#20195;',
 "\xD3\xDC" => '&#22408;',
 "\xD3\xDD" => '&#22382;',
 "\xD3\xDE" => '&#22823;',
 "\xD3\xDF" => '&#23565;',
 "\xD3\xE0" => '&#23729;',
 "\xD3\xE1" => '&#24118;',
 "\xD3\xE2" => '&#24453;',
 "\xD3\xE3" => '&#25140;',
 "\xD3\xE4" => '&#25825;',
 "\xD3\xE5" => '&#29619;',
 "\xD3\xE6" => '&#33274;',
 "\xD3\xE7" => '&#34955;',
 "\xD3\xE8" => '&#36024;',
 "\xD3\xE9" => '&#38538;',
 "\xD3\xEA" => '&#40667;',
 "\xD3\xEB" => '&#23429;',
 "\xD3\xEC" => '&#24503;',
 "\xD3\xED" => '&#24755;',
 "\xD3\xEE" => '&#20498;',
 "\xD3\xEF" => '&#20992;',
 "\xD3\xF0" => '&#21040;',
 "\xD3\xF1" => '&#22294;',
 "\xD3\xF2" => '&#22581;',
 "\xD3\xF3" => '&#22615;',
 "\xD3\xF4" => '&#23566;',
 "\xD3\xF5" => '&#23648;',
 "\xD3\xF6" => '&#23798;',
 "\xD3\xF7" => '&#23947;',
 "\xD3\xF8" => '&#24230;',
 "\xD3\xF9" => '&#24466;',
 "\xD3\xFA" => '&#24764;',
 "\xD3\xFB" => '&#25361;',
 "\xD3\xFC" => '&#25481;',
 "\xD3\xFD" => '&#25623;',
 "\xD3\xFE" => '&#26691;',
 "\xD4\xA1" => '&#26873;',
 "\xD4\xA2" => '&#27330;',
 "\xD4\xA3" => '&#28120;',
 "\xD4\xA4" => '&#28193;',
 "\xD4\xA5" => '&#28372;',
 "\xD4\xA6" => '&#28644;',
 "\xD4\xA7" => '&#29182;',
 "\xD4\xA8" => '&#30428;',
 "\xD4\xA9" => '&#30585;',
 "\xD4\xAA" => '&#31153;',
 "\xD4\xAB" => '&#31291;',
 "\xD4\xAC" => '&#33796;',
 "\xD4\xAD" => '&#35241;',
 "\xD4\xAE" => '&#36077;',
 "\xD4\xAF" => '&#36339;',
 "\xD4\xB0" => '&#36424;',
 "\xD4\xB1" => '&#36867;',
 "\xD4\xB2" => '&#36884;',
 "\xD4\xB3" => '&#36947;',
 "\xD4\xB4" => '&#37117;',
 "\xD4\xB5" => '&#37709;',
 "\xD4\xB6" => '&#38518;',
 "\xD4\xB7" => '&#38876;',
 "\xD4\xB8" => '&#27602;',
 "\xD4\xB9" => '&#28678;',
 "\xD4\xBA" => '&#29272;',
 "\xD4\xBB" => '&#29346;',
 "\xD4\xBC" => '&#29544;',
 "\xD4\xBD" => '&#30563;',
 "\xD4\xBE" => '&#31167;',
 "\xD4\xBF" => '&#31716;',
 "\xD4\xC0" => '&#32411;',
 "\xD4\xC1" => '&#35712;',
 "\xD4\xC2" => '&#22697;',
 "\xD4\xC3" => '&#24775;',
 "\xD4\xC4" => '&#25958;',
 "\xD4\xC5" => '&#26109;',
 "\xD4\xC6" => '&#26302;',
 "\xD4\xC7" => '&#27788;',
 "\xD4\xC8" => '&#28958;',
 "\xD4\xC9" => '&#29129;',
 "\xD4\xCA" => '&#35930;',
 "\xD4\xCB" => '&#38931;',
 "\xD4\xCC" => '&#20077;',
 "\xD4\xCD" => '&#31361;',
 "\xD4\xCE" => '&#20189;',
 "\xD4\xCF" => '&#20908;',
 "\xD4\xD0" => '&#20941;',
 "\xD4\xD1" => '&#21205;',
 "\xD4\xD2" => '&#21516;',
 "\xD4\xD3" => '&#24999;',
 "\xD4\xD4" => '&#26481;',
 "\xD4\xD5" => '&#26704;',
 "\xD4\xD6" => '&#26847;',
 "\xD4\xD7" => '&#27934;',
 "\xD4\xD8" => '&#28540;',
 "\xD4\xD9" => '&#30140;',
 "\xD4\xDA" => '&#30643;',
 "\xD4\xDB" => '&#31461;',
 "\xD4\xDC" => '&#33012;',
 "\xD4\xDD" => '&#33891;',
 "\xD4\xDE" => '&#37509;',
 "\xD4\xDF" => '&#20828;',
 "\xD4\xE0" => '&#26007;',
 "\xD4\xE1" => '&#26460;',
 "\xD4\xE2" => '&#26515;',
 "\xD4\xE3" => '&#30168;',
 "\xD4\xE4" => '&#31431;',
 "\xD4\xE5" => '&#33651;',
 "\xD4\xE6" => '&#63834;',
 "\xD4\xE7" => '&#35910;',
 "\xD4\xE8" => '&#36887;',
 "\xD4\xE9" => '&#38957;',
 "\xD4\xEA" => '&#23663;',
 "\xD4\xEB" => '&#33216;',
 "\xD4\xEC" => '&#33434;',
 "\xD4\xED" => '&#36929;',
 "\xD4\xEE" => '&#36975;',
 "\xD4\xEF" => '&#37389;',
 "\xD4\xF0" => '&#24471;',
 "\xD4\xF1" => '&#23965;',
 "\xD4\xF2" => '&#27225;',
 "\xD4\xF3" => '&#29128;',
 "\xD4\xF4" => '&#30331;',
 "\xD4\xF5" => '&#31561;',
 "\xD4\xF6" => '&#34276;',
 "\xD4\xF7" => '&#35588;',
 "\xD4\xF8" => '&#37159;',
 "\xD4\xF9" => '&#39472;',
 "\xD4\xFA" => '&#21895;',
 "\xD4\xFB" => '&#25078;',
 "\xD4\xFC" => '&#63835;',
 "\xD4\xFD" => '&#30313;',
 "\xD4\xFE" => '&#32645;',
 "\xD5\xA1" => '&#34367;',
 "\xD5\xA2" => '&#34746;',
 "\xD5\xA3" => '&#35064;',
 "\xD5\xA4" => '&#37007;',
 "\xD5\xA5" => '&#63836;',
 "\xD5\xA6" => '&#27931;',
 "\xD5\xA7" => '&#28889;',
 "\xD5\xA8" => '&#29662;',
 "\xD5\xA9" => '&#32097;',
 "\xD5\xAA" => '&#33853;',
 "\xD5\xAB" => '&#63837;',
 "\xD5\xAC" => '&#37226;',
 "\xD5\xAD" => '&#39409;',
 "\xD5\xAE" => '&#63838;',
 "\xD5\xAF" => '&#20098;',
 "\xD5\xB0" => '&#21365;',
 "\xD5\xB1" => '&#27396;',
 "\xD5\xB2" => '&#27410;',
 "\xD5\xB3" => '&#28734;',
 "\xD5\xB4" => '&#29211;',
 "\xD5\xB5" => '&#34349;',
 "\xD5\xB6" => '&#40478;',
 "\xD5\xB7" => '&#21068;',
 "\xD5\xB8" => '&#36771;',
 "\xD5\xB9" => '&#23888;',
 "\xD5\xBA" => '&#25829;',
 "\xD5\xBB" => '&#25900;',
 "\xD5\xBC" => '&#27414;',
 "\xD5\xBD" => '&#28651;',
 "\xD5\xBE" => '&#31811;',
 "\xD5\xBF" => '&#32412;',
 "\xD5\xC0" => '&#34253;',
 "\xD5\xC1" => '&#35172;',
 "\xD5\xC2" => '&#35261;',
 "\xD5\xC3" => '&#25289;',
 "\xD5\xC4" => '&#33240;',
 "\xD5\xC5" => '&#34847;',
 "\xD5\xC6" => '&#24266;',
 "\xD5\xC7" => '&#26391;',
 "\xD5\xC8" => '&#28010;',
 "\xD5\xC9" => '&#29436;',
 "\xD5\xCA" => '&#29701;',
 "\xD5\xCB" => '&#29807;',
 "\xD5\xCC" => '&#34690;',
 "\xD5\xCD" => '&#37086;',
 "\xD5\xCE" => '&#20358;',
 "\xD5\xCF" => '&#23821;',
 "\xD5\xD0" => '&#24480;',
 "\xD5\xD1" => '&#33802;',
 "\xD5\xD2" => '&#20919;',
 "\xD5\xD3" => '&#25504;',
 "\xD5\xD4" => '&#30053;',
 "\xD5\xD5" => '&#20142;',
 "\xD5\xD6" => '&#20486;',
 "\xD5\xD7" => '&#20841;',
 "\xD5\xD8" => '&#20937;',
 "\xD5\xD9" => '&#26753;',
 "\xD5\xDA" => '&#27153;',
 "\xD5\xDB" => '&#31918;',
 "\xD5\xDC" => '&#31921;',
 "\xD5\xDD" => '&#31975;',
 "\xD5\xDE" => '&#33391;',
 "\xD5\xDF" => '&#35538;',
 "\xD5\xE0" => '&#36635;',
 "\xD5\xE1" => '&#37327;',
 "\xD5\xE2" => '&#20406;',
 "\xD5\xE3" => '&#20791;',
 "\xD5\xE4" => '&#21237;',
 "\xD5\xE5" => '&#21570;',
 "\xD5\xE6" => '&#24300;',
 "\xD5\xE7" => '&#24942;',
 "\xD5\xE8" => '&#25150;',
 "\xD5\xE9" => '&#26053;',
 "\xD5\xEA" => '&#27354;',
 "\xD5\xEB" => '&#28670;',
 "\xD5\xEC" => '&#31018;',
 "\xD5\xED" => '&#34268;',
 "\xD5\xEE" => '&#34851;',
 "\xD5\xEF" => '&#38317;',
 "\xD5\xF0" => '&#39522;',
 "\xD5\xF1" => '&#39530;',
 "\xD5\xF2" => '&#40599;',
 "\xD5\xF3" => '&#40654;',
 "\xD5\xF4" => '&#21147;',
 "\xD5\xF5" => '&#26310;',
 "\xD5\xF6" => '&#27511;',
 "\xD5\xF7" => '&#28701;',
 "\xD5\xF8" => '&#31019;',
 "\xD5\xF9" => '&#36706;',
 "\xD5\xFA" => '&#38722;',
 "\xD5\xFB" => '&#24976;',
 "\xD5\xFC" => '&#25088;',
 "\xD5\xFD" => '&#25891;',
 "\xD5\xFE" => '&#28451;',
 "\xD6\xA1" => '&#29001;',
 "\xD6\xA2" => '&#29833;',
 "\xD6\xA3" => '&#32244;',
 "\xD6\xA4" => '&#32879;',
 "\xD6\xA5" => '&#34030;',
 "\xD6\xA6" => '&#36646;',
 "\xD6\xA7" => '&#36899;',
 "\xD6\xA8" => '&#37706;',
 "\xD6\xA9" => '&#20925;',
 "\xD6\xAA" => '&#21015;',
 "\xD6\xAB" => '&#21155;',
 "\xD6\xAC" => '&#27916;',
 "\xD6\xAD" => '&#28872;',
 "\xD6\xAE" => '&#35010;',
 "\xD6\xAF" => '&#24265;',
 "\xD6\xB0" => '&#25986;',
 "\xD6\xB1" => '&#27566;',
 "\xD6\xB2" => '&#28610;',
 "\xD6\xB3" => '&#31806;',
 "\xD6\xB4" => '&#29557;',
 "\xD6\xB5" => '&#20196;',
 "\xD6\xB6" => '&#20278;',
 "\xD6\xB7" => '&#22265;',
 "\xD6\xB8" => '&#63839;',
 "\xD6\xB9" => '&#23738;',
 "\xD6\xBA" => '&#23994;',
 "\xD6\xBB" => '&#24604;',
 "\xD6\xBC" => '&#29618;',
 "\xD6\xBD" => '&#31533;',
 "\xD6\xBE" => '&#32666;',
 "\xD6\xBF" => '&#32718;',
 "\xD6\xC0" => '&#32838;',
 "\xD6\xC1" => '&#36894;',
 "\xD6\xC2" => '&#37428;',
 "\xD6\xC3" => '&#38646;',
 "\xD6\xC4" => '&#38728;',
 "\xD6\xC5" => '&#38936;',
 "\xD6\xC6" => '&#40801;',
 "\xD6\xC7" => '&#20363;',
 "\xD6\xC8" => '&#28583;',
 "\xD6\xC9" => '&#31150;',
 "\xD6\xCA" => '&#37300;',
 "\xD6\xCB" => '&#38583;',
 "\xD6\xCC" => '&#21214;',
 "\xD6\xCD" => '&#63840;',
 "\xD6\xCE" => '&#25736;',
 "\xD6\xCF" => '&#25796;',
 "\xD6\xD0" => '&#27347;',
 "\xD6\xD1" => '&#28510;',
 "\xD6\xD2" => '&#28696;',
 "\xD6\xD3" => '&#29200;',
 "\xD6\xD4" => '&#30439;',
 "\xD6\xD5" => '&#32769;',
 "\xD6\xD6" => '&#34310;',
 "\xD6\xD7" => '&#34396;',
 "\xD6\xD8" => '&#36335;',
 "\xD6\xD9" => '&#36613;',
 "\xD6\xDA" => '&#38706;',
 "\xD6\xDB" => '&#39791;',
 "\xD6\xDC" => '&#40442;',
 "\xD6\xDD" => '&#40565;',
 "\xD6\xDE" => '&#30860;',
 "\xD6\xDF" => '&#31103;',
 "\xD6\xE0" => '&#32160;',
 "\xD6\xE1" => '&#33737;',
 "\xD6\xE2" => '&#37636;',
 "\xD6\xE3" => '&#40575;',
 "\xD6\xE4" => '&#40595;',
 "\xD6\xE5" => '&#35542;',
 "\xD6\xE6" => '&#22751;',
 "\xD6\xE7" => '&#24324;',
 "\xD6\xE8" => '&#26407;',
 "\xD6\xE9" => '&#28711;',
 "\xD6\xEA" => '&#29903;',
 "\xD6\xEB" => '&#31840;',
 "\xD6\xEC" => '&#32894;',
 "\xD6\xED" => '&#20769;',
 "\xD6\xEE" => '&#28712;',
 "\xD6\xEF" => '&#29282;',
 "\xD6\xF0" => '&#30922;',
 "\xD6\xF1" => '&#36034;',
 "\xD6\xF2" => '&#36058;',
 "\xD6\xF3" => '&#36084;',
 "\xD6\xF4" => '&#38647;',
 "\xD6\xF5" => '&#20102;',
 "\xD6\xF6" => '&#20698;',
 "\xD6\xF7" => '&#23534;',
 "\xD6\xF8" => '&#24278;',
 "\xD6\xF9" => '&#26009;',
 "\xD6\xFA" => '&#29134;',
 "\xD6\xFB" => '&#30274;',
 "\xD6\xFC" => '&#30637;',
 "\xD6\xFD" => '&#32842;',
 "\xD6\xFE" => '&#34044;',
 "\xD7\xA1" => '&#36988;',
 "\xD7\xA2" => '&#39719;',
 "\xD7\xA3" => '&#40845;',
 "\xD7\xA4" => '&#22744;',
 "\xD7\xA5" => '&#23105;',
 "\xD7\xA6" => '&#23650;',
 "\xD7\xA7" => '&#27155;',
 "\xD7\xA8" => '&#28122;',
 "\xD7\xA9" => '&#28431;',
 "\xD7\xAA" => '&#30267;',
 "\xD7\xAB" => '&#32047;',
 "\xD7\xAC" => '&#32311;',
 "\xD7\xAD" => '&#34078;',
 "\xD7\xAE" => '&#35128;',
 "\xD7\xAF" => '&#37860;',
 "\xD7\xB0" => '&#38475;',
 "\xD7\xB1" => '&#21129;',
 "\xD7\xB2" => '&#26066;',
 "\xD7\xB3" => '&#26611;',
 "\xD7\xB4" => '&#27060;',
 "\xD7\xB5" => '&#27969;',
 "\xD7\xB6" => '&#28316;',
 "\xD7\xB7" => '&#28687;',
 "\xD7\xB8" => '&#29705;',
 "\xD7\xB9" => '&#29792;',
 "\xD7\xBA" => '&#30041;',
 "\xD7\xBB" => '&#30244;',
 "\xD7\xBC" => '&#30827;',
 "\xD7\xBD" => '&#35628;',
 "\xD7\xBE" => '&#39006;',
 "\xD7\xBF" => '&#20845;',
 "\xD7\xC0" => '&#25134;',
 "\xD7\xC1" => '&#38520;',
 "\xD7\xC2" => '&#20374;',
 "\xD7\xC3" => '&#20523;',
 "\xD7\xC4" => '&#23833;',
 "\xD7\xC5" => '&#28138;',
 "\xD7\xC6" => '&#32184;',
 "\xD7\xC7" => '&#36650;',
 "\xD7\xC8" => '&#24459;',
 "\xD7\xC9" => '&#24900;',
 "\xD7\xCA" => '&#26647;',
 "\xD7\xCB" => '&#63841;',
 "\xD7\xCC" => '&#38534;',
 "\xD7\xCD" => '&#21202;',
 "\xD7\xCE" => '&#32907;',
 "\xD7\xCF" => '&#20956;',
 "\xD7\xD0" => '&#20940;',
 "\xD7\xD1" => '&#26974;',
 "\xD7\xD2" => '&#31260;',
 "\xD7\xD3" => '&#32190;',
 "\xD7\xD4" => '&#33777;',
 "\xD7\xD5" => '&#38517;',
 "\xD7\xD6" => '&#20442;',
 "\xD7\xD7" => '&#21033;',
 "\xD7\xD8" => '&#21400;',
 "\xD7\xD9" => '&#21519;',
 "\xD7\xDA" => '&#21774;',
 "\xD7\xDB" => '&#23653;',
 "\xD7\xDC" => '&#24743;',
 "\xD7\xDD" => '&#26446;',
 "\xD7\xDE" => '&#26792;',
 "\xD7\xDF" => '&#28012;',
 "\xD7\xE0" => '&#29313;',
 "\xD7\xE1" => '&#29432;',
 "\xD7\xE2" => '&#29702;',
 "\xD7\xE3" => '&#29827;',
 "\xD7\xE4" => '&#63842;',
 "\xD7\xE5" => '&#30178;',
 "\xD7\xE6" => '&#31852;',
 "\xD7\xE7" => '&#32633;',
 "\xD7\xE8" => '&#32696;',
 "\xD7\xE9" => '&#33673;',
 "\xD7\xEA" => '&#35023;',
 "\xD7\xEB" => '&#35041;',
 "\xD7\xEC" => '&#37324;',
 "\xD7\xED" => '&#37328;',
 "\xD7\xEE" => '&#38626;',
 "\xD7\xEF" => '&#39881;',
 "\xD7\xF0" => '&#21533;',
 "\xD7\xF1" => '&#28542;',
 "\xD7\xF2" => '&#29136;',
 "\xD7\xF3" => '&#29848;',
 "\xD7\xF4" => '&#34298;',
 "\xD7\xF5" => '&#36522;',
 "\xD7\xF6" => '&#38563;',
 "\xD7\xF7" => '&#40023;',
 "\xD7\xF8" => '&#40607;',
 "\xD7\xF9" => '&#26519;',
 "\xD7\xFA" => '&#28107;',
 "\xD7\xFB" => '&#29747;',
 "\xD7\xFC" => '&#33256;',
 "\xD7\xFD" => '&#38678;',
 "\xD7\xFE" => '&#30764;',
 "\xD8\xA1" => '&#31435;',
 "\xD8\xA2" => '&#31520;',
 "\xD8\xA3" => '&#31890;',
 "\xD8\xA4" => '&#25705;',
 "\xD8\xA5" => '&#29802;',
 "\xD8\xA6" => '&#30194;',
 "\xD8\xA7" => '&#30908;',
 "\xD8\xA8" => '&#30952;',
 "\xD8\xA9" => '&#39340;',
 "\xD8\xAA" => '&#39764;',
 "\xD8\xAB" => '&#40635;',
 "\xD8\xAC" => '&#23518;',
 "\xD8\xAD" => '&#24149;',
 "\xD8\xAE" => '&#28448;',
 "\xD8\xAF" => '&#33180;',
 "\xD8\xB0" => '&#33707;',
 "\xD8\xB1" => '&#37000;',
 "\xD8\xB2" => '&#19975;',
 "\xD8\xB3" => '&#21325;',
 "\xD8\xB4" => '&#23081;',
 "\xD8\xB5" => '&#24018;',
 "\xD8\xB6" => '&#24398;',
 "\xD8\xB7" => '&#24930;',
 "\xD8\xB8" => '&#25405;',
 "\xD8\xB9" => '&#26217;',
 "\xD8\xBA" => '&#26364;',
 "\xD8\xBB" => '&#28415;',
 "\xD8\xBC" => '&#28459;',
 "\xD8\xBD" => '&#28771;',
 "\xD8\xBE" => '&#30622;',
 "\xD8\xBF" => '&#33836;',
 "\xD8\xC0" => '&#34067;',
 "\xD8\xC1" => '&#34875;',
 "\xD8\xC2" => '&#36627;',
 "\xD8\xC3" => '&#39237;',
 "\xD8\xC4" => '&#39995;',
 "\xD8\xC5" => '&#21788;',
 "\xD8\xC6" => '&#25273;',
 "\xD8\xC7" => '&#26411;',
 "\xD8\xC8" => '&#27819;',
 "\xD8\xC9" => '&#33545;',
 "\xD8\xCA" => '&#35178;',
 "\xD8\xCB" => '&#38778;',
 "\xD8\xCC" => '&#20129;',
 "\xD8\xCD" => '&#22916;',
 "\xD8\xCE" => '&#24536;',
 "\xD8\xCF" => '&#24537;',
 "\xD8\xD0" => '&#26395;',
 "\xD8\xD1" => '&#32178;',
 "\xD8\xD2" => '&#32596;',
 "\xD8\xD3" => '&#33426;',
 "\xD8\xD4" => '&#33579;',
 "\xD8\xD5" => '&#33725;',
 "\xD8\xD6" => '&#36638;',
 "\xD8\xD7" => '&#37017;',
 "\xD8\xD8" => '&#22475;',
 "\xD8\xD9" => '&#22969;',
 "\xD8\xDA" => '&#23186;',
 "\xD8\xDB" => '&#23504;',
 "\xD8\xDC" => '&#26151;',
 "\xD8\xDD" => '&#26522;',
 "\xD8\xDE" => '&#26757;',
 "\xD8\xDF" => '&#27599;',
 "\xD8\xE0" => '&#29028;',
 "\xD8\xE1" => '&#32629;',
 "\xD8\xE2" => '&#36023;',
 "\xD8\xE3" => '&#36067;',
 "\xD8\xE4" => '&#36993;',
 "\xD8\xE5" => '&#39749;',
 "\xD8\xE6" => '&#33032;',
 "\xD8\xE7" => '&#35978;',
 "\xD8\xE8" => '&#38476;',
 "\xD8\xE9" => '&#39488;',
 "\xD8\xEA" => '&#40613;',
 "\xD8\xEB" => '&#23391;',
 "\xD8\xEC" => '&#27667;',
 "\xD8\xED" => '&#29467;',
 "\xD8\xEE" => '&#30450;',
 "\xD8\xEF" => '&#30431;',
 "\xD8\xF0" => '&#33804;',
 "\xD8\xF1" => '&#20906;',
 "\xD8\xF2" => '&#35219;',
 "\xD8\xF3" => '&#20813;',
 "\xD8\xF4" => '&#20885;',
 "\xD8\xF5" => '&#21193;',
 "\xD8\xF6" => '&#26825;',
 "\xD8\xF7" => '&#27796;',
 "\xD8\xF8" => '&#30468;',
 "\xD8\xF9" => '&#30496;',
 "\xD8\xFA" => '&#32191;',
 "\xD8\xFB" => '&#32236;',
 "\xD8\xFC" => '&#38754;',
 "\xD8\xFD" => '&#40629;',
 "\xD8\xFE" => '&#28357;',
 "\xD9\xA1" => '&#34065;',
 "\xD9\xA2" => '&#20901;',
 "\xD9\xA3" => '&#21517;',
 "\xD9\xA4" => '&#21629;',
 "\xD9\xA5" => '&#26126;',
 "\xD9\xA6" => '&#26269;',
 "\xD9\xA7" => '&#26919;',
 "\xD9\xA8" => '&#28319;',
 "\xD9\xA9" => '&#30399;',
 "\xD9\xAA" => '&#30609;',
 "\xD9\xAB" => '&#33559;',
 "\xD9\xAC" => '&#33986;',
 "\xD9\xAD" => '&#34719;',
 "\xD9\xAE" => '&#37225;',
 "\xD9\xAF" => '&#37528;',
 "\xD9\xB0" => '&#40180;',
 "\xD9\xB1" => '&#34946;',
 "\xD9\xB2" => '&#20398;',
 "\xD9\xB3" => '&#20882;',
 "\xD9\xB4" => '&#21215;',
 "\xD9\xB5" => '&#22982;',
 "\xD9\xB6" => '&#24125;',
 "\xD9\xB7" => '&#24917;',
 "\xD9\xB8" => '&#25720;',
 "\xD9\xB9" => '&#25721;',
 "\xD9\xBA" => '&#26286;',
 "\xD9\xBB" => '&#26576;',
 "\xD9\xBC" => '&#27169;',
 "\xD9\xBD" => '&#27597;',
 "\xD9\xBE" => '&#27611;',
 "\xD9\xBF" => '&#29279;',
 "\xD9\xC0" => '&#29281;',
 "\xD9\xC1" => '&#29761;',
 "\xD9\xC2" => '&#30520;',
 "\xD9\xC3" => '&#30683;',
 "\xD9\xC4" => '&#32791;',
 "\xD9\xC5" => '&#33468;',
 "\xD9\xC6" => '&#33541;',
 "\xD9\xC7" => '&#35584;',
 "\xD9\xC8" => '&#35624;',
 "\xD9\xC9" => '&#35980;',
 "\xD9\xCA" => '&#26408;',
 "\xD9\xCB" => '&#27792;',
 "\xD9\xCC" => '&#29287;',
 "\xD9\xCD" => '&#30446;',
 "\xD9\xCE" => '&#30566;',
 "\xD9\xCF" => '&#31302;',
 "\xD9\xD0" => '&#40361;',
 "\xD9\xD1" => '&#27519;',
 "\xD9\xD2" => '&#27794;',
 "\xD9\xD3" => '&#22818;',
 "\xD9\xD4" => '&#26406;',
 "\xD9\xD5" => '&#33945;',
 "\xD9\xD6" => '&#21359;',
 "\xD9\xD7" => '&#22675;',
 "\xD9\xD8" => '&#22937;',
 "\xD9\xD9" => '&#24287;',
 "\xD9\xDA" => '&#25551;',
 "\xD9\xDB" => '&#26164;',
 "\xD9\xDC" => '&#26483;',
 "\xD9\xDD" => '&#28218;',
 "\xD9\xDE" => '&#29483;',
 "\xD9\xDF" => '&#31447;',
 "\xD9\xE0" => '&#33495;',
 "\xD9\xE1" => '&#37672;',
 "\xD9\xE2" => '&#21209;',
 "\xD9\xE3" => '&#24043;',
 "\xD9\xE4" => '&#25006;',
 "\xD9\xE5" => '&#25035;',
 "\xD9\xE6" => '&#25098;',
 "\xD9\xE7" => '&#25287;',
 "\xD9\xE8" => '&#25771;',
 "\xD9\xE9" => '&#26080;',
 "\xD9\xEA" => '&#26969;',
 "\xD9\xEB" => '&#27494;',
 "\xD9\xEC" => '&#27595;',
 "\xD9\xED" => '&#28961;',
 "\xD9\xEE" => '&#29687;',
 "\xD9\xEF" => '&#30045;',
 "\xD9\xF0" => '&#32326;',
 "\xD9\xF1" => '&#33310;',
 "\xD9\xF2" => '&#33538;',
 "\xD9\xF3" => '&#34154;',
 "\xD9\xF4" => '&#35491;',
 "\xD9\xF5" => '&#36031;',
 "\xD9\xF6" => '&#38695;',
 "\xD9\xF7" => '&#40289;',
 "\xD9\xF8" => '&#22696;',
 "\xD9\xF9" => '&#40664;',
 "\xD9\xFA" => '&#20497;',
 "\xD9\xFB" => '&#21006;',
 "\xD9\xFC" => '&#21563;',
 "\xD9\xFD" => '&#21839;',
 "\xD9\xFE" => '&#25991;',
 "\xDA\xA1" => '&#27766;',
 "\xDA\xA2" => '&#32010;',
 "\xDA\xA3" => '&#32011;',
 "\xDA\xA4" => '&#32862;',
 "\xDA\xA5" => '&#34442;',
 "\xDA\xA6" => '&#38272;',
 "\xDA\xA7" => '&#38639;',
 "\xDA\xA8" => '&#21247;',
 "\xDA\xA9" => '&#27797;',
 "\xDA\xAA" => '&#29289;',
 "\xDA\xAB" => '&#21619;',
 "\xDA\xAC" => '&#23194;',
 "\xDA\xAD" => '&#23614;',
 "\xDA\xAE" => '&#23883;',
 "\xDA\xAF" => '&#24396;',
 "\xDA\xB0" => '&#24494;',
 "\xDA\xB1" => '&#26410;',
 "\xDA\xB2" => '&#26806;',
 "\xDA\xB3" => '&#26979;',
 "\xDA\xB4" => '&#28220;',
 "\xDA\xB5" => '&#28228;',
 "\xDA\xB6" => '&#30473;',
 "\xDA\xB7" => '&#31859;',
 "\xDA\xB8" => '&#32654;',
 "\xDA\xB9" => '&#34183;',
 "\xDA\xBA" => '&#35598;',
 "\xDA\xBB" => '&#36855;',
 "\xDA\xBC" => '&#38753;',
 "\xDA\xBD" => '&#40692;',
 "\xDA\xBE" => '&#23735;',
 "\xDA\xBF" => '&#24758;',
 "\xDA\xC0" => '&#24845;',
 "\xDA\xC1" => '&#25003;',
 "\xDA\xC2" => '&#25935;',
 "\xDA\xC3" => '&#26107;',
 "\xDA\xC4" => '&#26108;',
 "\xDA\xC5" => '&#27665;',
 "\xDA\xC6" => '&#27887;',
 "\xDA\xC7" => '&#29599;',
 "\xDA\xC8" => '&#29641;',
 "\xDA\xC9" => '&#32225;',
 "\xDA\xCA" => '&#38292;',
 "\xDA\xCB" => '&#23494;',
 "\xDA\xCC" => '&#34588;',
 "\xDA\xCD" => '&#35600;',
 "\xDA\xCE" => '&#21085;',
 "\xDA\xCF" => '&#21338;',
 "\xDA\xD0" => '&#25293;',
 "\xDA\xD1" => '&#25615;',
 "\xDA\xD2" => '&#25778;',
 "\xDA\xD3" => '&#26420;',
 "\xDA\xD4" => '&#27192;',
 "\xDA\xD5" => '&#27850;',
 "\xDA\xD6" => '&#29632;',
 "\xDA\xD7" => '&#29854;',
 "\xDA\xD8" => '&#31636;',
 "\xDA\xD9" => '&#31893;',
 "\xDA\xDA" => '&#32283;',
 "\xDA\xDB" => '&#33162;',
 "\xDA\xDC" => '&#33334;',
 "\xDA\xDD" => '&#34180;',
 "\xDA\xDE" => '&#36843;',
 "\xDA\xDF" => '&#38649;',
 "\xDA\xE0" => '&#39361;',
 "\xDA\xE1" => '&#20276;',
 "\xDA\xE2" => '&#21322;',
 "\xDA\xE3" => '&#21453;',
 "\xDA\xE4" => '&#21467;',
 "\xDA\xE5" => '&#25292;',
 "\xDA\xE6" => '&#25644;',
 "\xDA\xE7" => '&#25856;',
 "\xDA\xE8" => '&#26001;',
 "\xDA\xE9" => '&#27075;',
 "\xDA\xEA" => '&#27886;',
 "\xDA\xEB" => '&#28504;',
 "\xDA\xEC" => '&#29677;',
 "\xDA\xED" => '&#30036;',
 "\xDA\xEE" => '&#30242;',
 "\xDA\xEF" => '&#30436;',
 "\xDA\xF0" => '&#30460;',
 "\xDA\xF1" => '&#30928;',
 "\xDA\xF2" => '&#30971;',
 "\xDA\xF3" => '&#31020;',
 "\xDA\xF4" => '&#32070;',
 "\xDA\xF5" => '&#33324;',
 "\xDA\xF6" => '&#34784;',
 "\xDA\xF7" => '&#36820;',
 "\xDA\xF8" => '&#38930;',
 "\xDA\xF9" => '&#39151;',
 "\xDA\xFA" => '&#21187;',
 "\xDA\xFB" => '&#25300;',
 "\xDA\xFC" => '&#25765;',
 "\xDA\xFD" => '&#28196;',
 "\xDA\xFE" => '&#28497;',
 "\xDB\xA1" => '&#30332;',
 "\xDB\xA2" => '&#36299;',
 "\xDB\xA3" => '&#37297;',
 "\xDB\xA4" => '&#37474;',
 "\xDB\xA5" => '&#39662;',
 "\xDB\xA6" => '&#39747;',
 "\xDB\xA7" => '&#20515;',
 "\xDB\xA8" => '&#20621;',
 "\xDB\xA9" => '&#22346;',
 "\xDB\xAA" => '&#22952;',
 "\xDB\xAB" => '&#23592;',
 "\xDB\xAC" => '&#24135;',
 "\xDB\xAD" => '&#24439;',
 "\xDB\xAE" => '&#25151;',
 "\xDB\xAF" => '&#25918;',
 "\xDB\xB0" => '&#26041;',
 "\xDB\xB1" => '&#26049;',
 "\xDB\xB2" => '&#26121;',
 "\xDB\xB3" => '&#26507;',
 "\xDB\xB4" => '&#27036;',
 "\xDB\xB5" => '&#28354;',
 "\xDB\xB6" => '&#30917;',
 "\xDB\xB7" => '&#32033;',
 "\xDB\xB8" => '&#32938;',
 "\xDB\xB9" => '&#33152;',
 "\xDB\xBA" => '&#33323;',
 "\xDB\xBB" => '&#33459;',
 "\xDB\xBC" => '&#33953;',
 "\xDB\xBD" => '&#34444;',
 "\xDB\xBE" => '&#35370;',
 "\xDB\xBF" => '&#35607;',
 "\xDB\xC0" => '&#37030;',
 "\xDB\xC1" => '&#38450;',
 "\xDB\xC2" => '&#40848;',
 "\xDB\xC3" => '&#20493;',
 "\xDB\xC4" => '&#20467;',
 "\xDB\xC5" => '&#63843;',
 "\xDB\xC6" => '&#22521;',
 "\xDB\xC7" => '&#24472;',
 "\xDB\xC8" => '&#25308;',
 "\xDB\xC9" => '&#25490;',
 "\xDB\xCA" => '&#26479;',
 "\xDB\xCB" => '&#28227;',
 "\xDB\xCC" => '&#28953;',
 "\xDB\xCD" => '&#30403;',
 "\xDB\xCE" => '&#32972;',
 "\xDB\xCF" => '&#32986;',
 "\xDB\xD0" => '&#35060;',
 "\xDB\xD1" => '&#35061;',
 "\xDB\xD2" => '&#35097;',
 "\xDB\xD3" => '&#36064;',
 "\xDB\xD4" => '&#36649;',
 "\xDB\xD5" => '&#37197;',
 "\xDB\xD6" => '&#38506;',
 "\xDB\xD7" => '&#20271;',
 "\xDB\xD8" => '&#20336;',
 "\xDB\xD9" => '&#24091;',
 "\xDB\xDA" => '&#26575;',
 "\xDB\xDB" => '&#26658;',
 "\xDB\xDC" => '&#30333;',
 "\xDB\xDD" => '&#30334;',
 "\xDB\xDE" => '&#39748;',
 "\xDB\xDF" => '&#24161;',
 "\xDB\xE0" => '&#27146;',
 "\xDB\xE1" => '&#29033;',
 "\xDB\xE2" => '&#29140;',
 "\xDB\xE3" => '&#30058;',
 "\xDB\xE4" => '&#63844;',
 "\xDB\xE5" => '&#32321;',
 "\xDB\xE6" => '&#34115;',
 "\xDB\xE7" => '&#34281;',
 "\xDB\xE8" => '&#39132;',
 "\xDB\xE9" => '&#20240;',
 "\xDB\xEA" => '&#31567;',
 "\xDB\xEB" => '&#32624;',
 "\xDB\xEC" => '&#38309;',
 "\xDB\xED" => '&#20961;',
 "\xDB\xEE" => '&#24070;',
 "\xDB\xEF" => '&#26805;',
 "\xDB\xF0" => '&#27710;',
 "\xDB\xF1" => '&#27726;',
 "\xDB\xF2" => '&#27867;',
 "\xDB\xF3" => '&#29359;',
 "\xDB\xF4" => '&#31684;',
 "\xDB\xF5" => '&#33539;',
 "\xDB\xF6" => '&#27861;',
 "\xDB\xF7" => '&#29754;',
 "\xDB\xF8" => '&#20731;',
 "\xDB\xF9" => '&#21128;',
 "\xDB\xFA" => '&#22721;',
 "\xDB\xFB" => '&#25816;',
 "\xDB\xFC" => '&#27287;',
 "\xDB\xFD" => '&#29863;',
 "\xDB\xFE" => '&#30294;',
 "\xDC\xA1" => '&#30887;',
 "\xDC\xA2" => '&#34327;',
 "\xDC\xA3" => '&#38370;',
 "\xDC\xA4" => '&#38713;',
 "\xDC\xA5" => '&#63845;',
 "\xDC\xA6" => '&#21342;',
 "\xDC\xA7" => '&#24321;',
 "\xDC\xA8" => '&#35722;',
 "\xDC\xA9" => '&#36776;',
 "\xDC\xAA" => '&#36783;',
 "\xDC\xAB" => '&#37002;',
 "\xDC\xAC" => '&#21029;',
 "\xDC\xAD" => '&#30629;',
 "\xDC\xAE" => '&#40009;',
 "\xDC\xAF" => '&#40712;',
 "\xDC\xB0" => '&#19993;',
 "\xDC\xB1" => '&#20482;',
 "\xDC\xB2" => '&#20853;',
 "\xDC\xB3" => '&#23643;',
 "\xDC\xB4" => '&#24183;',
 "\xDC\xB5" => '&#26142;',
 "\xDC\xB6" => '&#26170;',
 "\xDC\xB7" => '&#26564;',
 "\xDC\xB8" => '&#26821;',
 "\xDC\xB9" => '&#28851;',
 "\xDC\xBA" => '&#29953;',
 "\xDC\xBB" => '&#30149;',
 "\xDC\xBC" => '&#31177;',
 "\xDC\xBD" => '&#31453;',
 "\xDC\xBE" => '&#36647;',
 "\xDC\xBF" => '&#39200;',
 "\xDC\xC0" => '&#39432;',
 "\xDC\xC1" => '&#20445;',
 "\xDC\xC2" => '&#22561;',
 "\xDC\xC3" => '&#22577;',
 "\xDC\xC4" => '&#23542;',
 "\xDC\xC5" => '&#26222;',
 "\xDC\xC6" => '&#27493;',
 "\xDC\xC7" => '&#27921;',
 "\xDC\xC8" => '&#28282;',
 "\xDC\xC9" => '&#28541;',
 "\xDC\xCA" => '&#29668;',
 "\xDC\xCB" => '&#29995;',
 "\xDC\xCC" => '&#33769;',
 "\xDC\xCD" => '&#35036;',
 "\xDC\xCE" => '&#35091;',
 "\xDC\xCF" => '&#35676;',
 "\xDC\xD0" => '&#36628;',
 "\xDC\xD1" => '&#20239;',
 "\xDC\xD2" => '&#20693;',
 "\xDC\xD3" => '&#21264;',
 "\xDC\xD4" => '&#21340;',
 "\xDC\xD5" => '&#23443;',
 "\xDC\xD6" => '&#24489;',
 "\xDC\xD7" => '&#26381;',
 "\xDC\xD8" => '&#31119;',
 "\xDC\xD9" => '&#33145;',
 "\xDC\xDA" => '&#33583;',
 "\xDC\xDB" => '&#34068;',
 "\xDC\xDC" => '&#35079;',
 "\xDC\xDD" => '&#35206;',
 "\xDC\xDE" => '&#36665;',
 "\xDC\xDF" => '&#36667;',
 "\xDC\xE0" => '&#39333;',
 "\xDC\xE1" => '&#39954;',
 "\xDC\xE2" => '&#26412;',
 "\xDC\xE3" => '&#20086;',
 "\xDC\xE4" => '&#20472;',
 "\xDC\xE5" => '&#22857;',
 "\xDC\xE6" => '&#23553;',
 "\xDC\xE7" => '&#23791;',
 "\xDC\xE8" => '&#23792;',
 "\xDC\xE9" => '&#25447;',
 "\xDC\xEA" => '&#26834;',
 "\xDC\xEB" => '&#28925;',
 "\xDC\xEC" => '&#29090;',
 "\xDC\xED" => '&#29739;',
 "\xDC\xEE" => '&#32299;',
 "\xDC\xEF" => '&#34028;',
 "\xDC\xF0" => '&#34562;',
 "\xDC\xF1" => '&#36898;',
 "\xDC\xF2" => '&#37586;',
 "\xDC\xF3" => '&#40179;',
 "\xDC\xF4" => '&#19981;',
 "\xDC\xF5" => '&#20184;',
 "\xDC\xF6" => '&#20463;',
 "\xDC\xF7" => '&#20613;',
 "\xDC\xF8" => '&#21078;',
 "\xDC\xF9" => '&#21103;',
 "\xDC\xFA" => '&#21542;',
 "\xDC\xFB" => '&#21648;',
 "\xDC\xFC" => '&#22496;',
 "\xDC\xFD" => '&#22827;',
 "\xDC\xFE" => '&#23142;',
 "\xDD\xA1" => '&#23386;',
 "\xDD\xA2" => '&#23413;',
 "\xDD\xA3" => '&#23500;',
 "\xDD\xA4" => '&#24220;',
 "\xDD\xA5" => '&#63846;',
 "\xDD\xA6" => '&#25206;',
 "\xDD\xA7" => '&#25975;',
 "\xDD\xA8" => '&#26023;',
 "\xDD\xA9" => '&#28014;',
 "\xDD\xAA" => '&#28325;',
 "\xDD\xAB" => '&#29238;',
 "\xDD\xAC" => '&#31526;',
 "\xDD\xAD" => '&#31807;',
 "\xDD\xAE" => '&#32566;',
 "\xDD\xAF" => '&#33104;',
 "\xDD\xB0" => '&#33105;',
 "\xDD\xB1" => '&#33178;',
 "\xDD\xB2" => '&#33344;',
 "\xDD\xB3" => '&#33433;',
 "\xDD\xB4" => '&#33705;',
 "\xDD\xB5" => '&#35331;',
 "\xDD\xB6" => '&#36000;',
 "\xDD\xB7" => '&#36070;',
 "\xDD\xB8" => '&#36091;',
 "\xDD\xB9" => '&#36212;',
 "\xDD\xBA" => '&#36282;',
 "\xDD\xBB" => '&#37096;',
 "\xDD\xBC" => '&#37340;',
 "\xDD\xBD" => '&#38428;',
 "\xDD\xBE" => '&#38468;',
 "\xDD\xBF" => '&#39385;',
 "\xDD\xC0" => '&#40167;',
 "\xDD\xC1" => '&#21271;',
 "\xDD\xC2" => '&#20998;',
 "\xDD\xC3" => '&#21545;',
 "\xDD\xC4" => '&#22132;',
 "\xDD\xC5" => '&#22707;',
 "\xDD\xC6" => '&#22868;',
 "\xDD\xC7" => '&#22894;',
 "\xDD\xC8" => '&#24575;',
 "\xDD\xC9" => '&#24996;',
 "\xDD\xCA" => '&#25198;',
 "\xDD\xCB" => '&#26128;',
 "\xDD\xCC" => '&#27774;',
 "\xDD\xCD" => '&#28954;',
 "\xDD\xCE" => '&#30406;',
 "\xDD\xCF" => '&#31881;',
 "\xDD\xD0" => '&#31966;',
 "\xDD\xD1" => '&#32027;',
 "\xDD\xD2" => '&#33452;',
 "\xDD\xD3" => '&#36033;',
 "\xDD\xD4" => '&#38640;',
 "\xDD\xD5" => '&#63847;',
 "\xDD\xD6" => '&#20315;',
 "\xDD\xD7" => '&#24343;',
 "\xDD\xD8" => '&#24447;',
 "\xDD\xD9" => '&#25282;',
 "\xDD\xDA" => '&#23849;',
 "\xDD\xDB" => '&#26379;',
 "\xDD\xDC" => '&#26842;',
 "\xDD\xDD" => '&#30844;',
 "\xDD\xDE" => '&#32323;',
 "\xDD\xDF" => '&#40300;',
 "\xDD\xE0" => '&#19989;',
 "\xDD\xE1" => '&#20633;',
 "\xDD\xE2" => '&#21269;',
 "\xDD\xE3" => '&#21290;',
 "\xDD\xE4" => '&#21329;',
 "\xDD\xE5" => '&#22915;',
 "\xDD\xE6" => '&#23138;',
 "\xDD\xE7" => '&#24199;',
 "\xDD\xE8" => '&#24754;',
 "\xDD\xE9" => '&#24970;',
 "\xDD\xEA" => '&#25161;',
 "\xDD\xEB" => '&#25209;',
 "\xDD\xEC" => '&#26000;',
 "\xDD\xED" => '&#26503;',
 "\xDD\xEE" => '&#27047;',
 "\xDD\xEF" => '&#27604;',
 "\xDD\xF0" => '&#27606;',
 "\xDD\xF1" => '&#27607;',
 "\xDD\xF2" => '&#27608;',
 "\xDD\xF3" => '&#27832;',
 "\xDD\xF4" => '&#63848;',
 "\xDD\xF5" => '&#29749;',
 "\xDD\xF6" => '&#30202;',
 "\xDD\xF7" => '&#30738;',
 "\xDD\xF8" => '&#30865;',
 "\xDD\xF9" => '&#31189;',
 "\xDD\xFA" => '&#31192;',
 "\xDD\xFB" => '&#31875;',
 "\xDD\xFC" => '&#32203;',
 "\xDD\xFD" => '&#32737;',
 "\xDD\xFE" => '&#32933;',
 "\xDE\xA1" => '&#33086;',
 "\xDE\xA2" => '&#33218;',
 "\xDE\xA3" => '&#33778;',
 "\xDE\xA4" => '&#34586;',
 "\xDE\xA5" => '&#35048;',
 "\xDE\xA6" => '&#35513;',
 "\xDE\xA7" => '&#35692;',
 "\xDE\xA8" => '&#36027;',
 "\xDE\xA9" => '&#37145;',
 "\xDE\xAA" => '&#38750;',
 "\xDE\xAB" => '&#39131;',
 "\xDE\xAC" => '&#40763;',
 "\xDE\xAD" => '&#22188;',
 "\xDE\xAE" => '&#23338;',
 "\xDE\xAF" => '&#24428;',
 "\xDE\xB0" => '&#25996;',
 "\xDE\xB1" => '&#27315;',
 "\xDE\xB2" => '&#27567;',
 "\xDE\xB3" => '&#27996;',
 "\xDE\xB4" => '&#28657;',
 "\xDE\xB5" => '&#28693;',
 "\xDE\xB6" => '&#29277;',
 "\xDE\xB7" => '&#29613;',
 "\xDE\xB8" => '&#36007;',
 "\xDE\xB9" => '&#36051;',
 "\xDE\xBA" => '&#38971;',
 "\xDE\xBB" => '&#24977;',
 "\xDE\xBC" => '&#27703;',
 "\xDE\xBD" => '&#32856;',
 "\xDE\xBE" => '&#39425;',
 "\xDE\xBF" => '&#20045;',
 "\xDE\xC0" => '&#20107;',
 "\xDE\xC1" => '&#20123;',
 "\xDE\xC2" => '&#20181;',
 "\xDE\xC3" => '&#20282;',
 "\xDE\xC4" => '&#20284;',
 "\xDE\xC5" => '&#20351;',
 "\xDE\xC6" => '&#20447;',
 "\xDE\xC7" => '&#20735;',
 "\xDE\xC8" => '&#21490;',
 "\xDE\xC9" => '&#21496;',
 "\xDE\xCA" => '&#21766;',
 "\xDE\xCB" => '&#21987;',
 "\xDE\xCC" => '&#22235;',
 "\xDE\xCD" => '&#22763;',
 "\xDE\xCE" => '&#22882;',
 "\xDE\xCF" => '&#23057;',
 "\xDE\xD0" => '&#23531;',
 "\xDE\xD1" => '&#23546;',
 "\xDE\xD2" => '&#23556;',
 "\xDE\xD3" => '&#24051;',
 "\xDE\xD4" => '&#24107;',
 "\xDE\xD5" => '&#24473;',
 "\xDE\xD6" => '&#24605;',
 "\xDE\xD7" => '&#25448;',
 "\xDE\xD8" => '&#26012;',
 "\xDE\xD9" => '&#26031;',
 "\xDE\xDA" => '&#26614;',
 "\xDE\xDB" => '&#26619;',
 "\xDE\xDC" => '&#26797;',
 "\xDE\xDD" => '&#27515;',
 "\xDE\xDE" => '&#27801;',
 "\xDE\xDF" => '&#27863;',
 "\xDE\xE0" => '&#28195;',
 "\xDE\xE1" => '&#28681;',
 "\xDE\xE2" => '&#29509;',
 "\xDE\xE3" => '&#30722;',
 "\xDE\xE4" => '&#31038;',
 "\xDE\xE5" => '&#31040;',
 "\xDE\xE6" => '&#31072;',
 "\xDE\xE7" => '&#31169;',
 "\xDE\xE8" => '&#31721;',
 "\xDE\xE9" => '&#32023;',
 "\xDE\xEA" => '&#32114;',
 "\xDE\xEB" => '&#32902;',
 "\xDE\xEC" => '&#33293;',
 "\xDE\xED" => '&#33678;',
 "\xDE\xEE" => '&#34001;',
 "\xDE\xEF" => '&#34503;',
 "\xDE\xF0" => '&#35039;',
 "\xDE\xF1" => '&#35408;',
 "\xDE\xF2" => '&#35422;',
 "\xDE\xF3" => '&#35613;',
 "\xDE\xF4" => '&#36060;',
 "\xDE\xF5" => '&#36198;',
 "\xDE\xF6" => '&#36781;',
 "\xDE\xF7" => '&#37034;',
 "\xDE\xF8" => '&#39164;',
 "\xDE\xF9" => '&#39391;',
 "\xDE\xFA" => '&#40605;',
 "\xDE\xFB" => '&#21066;',
 "\xDE\xFC" => '&#63849;',
 "\xDE\xFD" => '&#26388;',
 "\xDE\xFE" => '&#63850;',
 "\xDF\xA1" => '&#20632;',
 "\xDF\xA2" => '&#21034;',
 "\xDF\xA3" => '&#23665;',
 "\xDF\xA4" => '&#25955;',
 "\xDF\xA5" => '&#27733;',
 "\xDF\xA6" => '&#29642;',
 "\xDF\xA7" => '&#29987;',
 "\xDF\xA8" => '&#30109;',
 "\xDF\xA9" => '&#31639;',
 "\xDF\xAA" => '&#33948;',
 "\xDF\xAB" => '&#37240;',
 "\xDF\xAC" => '&#38704;',
 "\xDF\xAD" => '&#20087;',
 "\xDF\xAE" => '&#25746;',
 "\xDF\xAF" => '&#27578;',
 "\xDF\xB0" => '&#29022;',
 "\xDF\xB1" => '&#34217;',
 "\xDF\xB2" => '&#19977;',
 "\xDF\xB3" => '&#63851;',
 "\xDF\xB4" => '&#26441;',
 "\xDF\xB5" => '&#26862;',
 "\xDF\xB6" => '&#28183;',
 "\xDF\xB7" => '&#33439;',
 "\xDF\xB8" => '&#34072;',
 "\xDF\xB9" => '&#34923;',
 "\xDF\xBA" => '&#25591;',
 "\xDF\xBB" => '&#28545;',
 "\xDF\xBC" => '&#37394;',
 "\xDF\xBD" => '&#39087;',
 "\xDF\xBE" => '&#19978;',
 "\xDF\xBF" => '&#20663;',
 "\xDF\xC0" => '&#20687;',
 "\xDF\xC1" => '&#20767;',
 "\xDF\xC2" => '&#21830;',
 "\xDF\xC3" => '&#21930;',
 "\xDF\xC4" => '&#22039;',
 "\xDF\xC5" => '&#23360;',
 "\xDF\xC6" => '&#23577;',
 "\xDF\xC7" => '&#23776;',
 "\xDF\xC8" => '&#24120;',
 "\xDF\xC9" => '&#24202;',
 "\xDF\xCA" => '&#24224;',
 "\xDF\xCB" => '&#24258;',
 "\xDF\xCC" => '&#24819;',
 "\xDF\xCD" => '&#26705;',
 "\xDF\xCE" => '&#27233;',
 "\xDF\xCF" => '&#28248;',
 "\xDF\xD0" => '&#29245;',
 "\xDF\xD1" => '&#29248;',
 "\xDF\xD2" => '&#29376;',
 "\xDF\xD3" => '&#30456;',
 "\xDF\xD4" => '&#31077;',
 "\xDF\xD5" => '&#31665;',
 "\xDF\xD6" => '&#32724;',
 "\xDF\xD7" => '&#35059;',
 "\xDF\xD8" => '&#35316;',
 "\xDF\xD9" => '&#35443;',
 "\xDF\xDA" => '&#35937;',
 "\xDF\xDB" => '&#36062;',
 "\xDF\xDC" => '&#38684;',
 "\xDF\xDD" => '&#22622;',
 "\xDF\xDE" => '&#29885;',
 "\xDF\xDF" => '&#36093;',
 "\xDF\xE0" => '&#21959;',
 "\xDF\xE1" => '&#63852;',
 "\xDF\xE2" => '&#31329;',
 "\xDF\xE3" => '&#32034;',
 "\xDF\xE4" => '&#33394;',
 "\xDF\xE5" => '&#29298;',
 "\xDF\xE6" => '&#29983;',
 "\xDF\xE7" => '&#29989;',
 "\xDF\xE8" => '&#63853;',
 "\xDF\xE9" => '&#31513;',
 "\xDF\xEA" => '&#22661;',
 "\xDF\xEB" => '&#22779;',
 "\xDF\xEC" => '&#23996;',
 "\xDF\xED" => '&#24207;',
 "\xDF\xEE" => '&#24246;',
 "\xDF\xEF" => '&#24464;',
 "\xDF\xF0" => '&#24661;',
 "\xDF\xF1" => '&#25234;',
 "\xDF\xF2" => '&#25471;',
 "\xDF\xF3" => '&#25933;',
 "\xDF\xF4" => '&#26257;',
 "\xDF\xF5" => '&#26329;',
 "\xDF\xF6" => '&#26360;',
 "\xDF\xF7" => '&#26646;',
 "\xDF\xF8" => '&#26866;',
 "\xDF\xF9" => '&#29312;',
 "\xDF\xFA" => '&#29790;',
 "\xDF\xFB" => '&#31598;',
 "\xDF\xFC" => '&#32110;',
 "\xDF\xFD" => '&#32214;',
 "\xDF\xFE" => '&#32626;',
 "\xE0\xA1" => '&#32997;',
 "\xE0\xA2" => '&#33298;',
 "\xE0\xA3" => '&#34223;',
 "\xE0\xA4" => '&#35199;',
 "\xE0\xA5" => '&#35475;',
 "\xE0\xA6" => '&#36893;',
 "\xE0\xA7" => '&#37604;',
 "\xE0\xA8" => '&#40653;',
 "\xE0\xA9" => '&#40736;',
 "\xE0\xAA" => '&#22805;',
 "\xE0\xAB" => '&#22893;',
 "\xE0\xAC" => '&#24109;',
 "\xE0\xAD" => '&#24796;',
 "\xE0\xAE" => '&#26132;',
 "\xE0\xAF" => '&#26227;',
 "\xE0\xB0" => '&#26512;',
 "\xE0\xB1" => '&#27728;',
 "\xE0\xB2" => '&#28101;',
 "\xE0\xB3" => '&#28511;',
 "\xE0\xB4" => '&#30707;',
 "\xE0\xB5" => '&#30889;',
 "\xE0\xB6" => '&#33990;',
 "\xE0\xB7" => '&#37323;',
 "\xE0\xB8" => '&#37675;',
 "\xE0\xB9" => '&#20185;',
 "\xE0\xBA" => '&#20682;',
 "\xE0\xBB" => '&#20808;',
 "\xE0\xBC" => '&#21892;',
 "\xE0\xBD" => '&#23307;',
 "\xE0\xBE" => '&#23459;',
 "\xE0\xBF" => '&#25159;',
 "\xE0\xC0" => '&#25982;',
 "\xE0\xC1" => '&#26059;',
 "\xE0\xC2" => '&#28210;',
 "\xE0\xC3" => '&#29053;',
 "\xE0\xC4" => '&#29697;',
 "\xE0\xC5" => '&#29764;',
 "\xE0\xC6" => '&#29831;',
 "\xE0\xC7" => '&#29887;',
 "\xE0\xC8" => '&#30316;',
 "\xE0\xC9" => '&#31146;',
 "\xE0\xCA" => '&#32218;',
 "\xE0\xCB" => '&#32341;',
 "\xE0\xCC" => '&#32680;',
 "\xE0\xCD" => '&#33146;',
 "\xE0\xCE" => '&#33203;',
 "\xE0\xCF" => '&#33337;',
 "\xE0\xD0" => '&#34330;',
 "\xE0\xD1" => '&#34796;',
 "\xE0\xD2" => '&#35445;',
 "\xE0\xD3" => '&#36323;',
 "\xE0\xD4" => '&#36984;',
 "\xE0\xD5" => '&#37521;',
 "\xE0\xD6" => '&#37925;',
 "\xE0\xD7" => '&#39245;',
 "\xE0\xD8" => '&#39854;',
 "\xE0\xD9" => '&#21352;',
 "\xE0\xDA" => '&#23633;',
 "\xE0\xDB" => '&#26964;',
 "\xE0\xDC" => '&#27844;',
 "\xE0\xDD" => '&#27945;',
 "\xE0\xDE" => '&#28203;',
 "\xE0\xDF" => '&#33292;',
 "\xE0\xE0" => '&#34203;',
 "\xE0\xE1" => '&#35131;',
 "\xE0\xE2" => '&#35373;',
 "\xE0\xE3" => '&#35498;',
 "\xE0\xE4" => '&#38634;',
 "\xE0\xE5" => '&#40807;',
 "\xE0\xE6" => '&#21089;',
 "\xE0\xE7" => '&#26297;',
 "\xE0\xE8" => '&#27570;',
 "\xE0\xE9" => '&#32406;',
 "\xE0\xEA" => '&#34814;',
 "\xE0\xEB" => '&#36109;',
 "\xE0\xEC" => '&#38275;',
 "\xE0\xED" => '&#38493;',
 "\xE0\xEE" => '&#25885;',
 "\xE0\xEF" => '&#28041;',
 "\xE0\xF0" => '&#29166;',
 "\xE0\xF1" => '&#63854;',
 "\xE0\xF2" => '&#22478;',
 "\xE0\xF3" => '&#22995;',
 "\xE0\xF4" => '&#23468;',
 "\xE0\xF5" => '&#24615;',
 "\xE0\xF6" => '&#24826;',
 "\xE0\xF7" => '&#25104;',
 "\xE0\xF8" => '&#26143;',
 "\xE0\xF9" => '&#26207;',
 "\xE0\xFA" => '&#29481;',
 "\xE0\xFB" => '&#29689;',
 "\xE0\xFC" => '&#30427;',
 "\xE0\xFD" => '&#30465;',
 "\xE0\xFE" => '&#31596;',
 "\xE1\xA1" => '&#32854;',
 "\xE1\xA2" => '&#32882;',
 "\xE1\xA3" => '&#33125;',
 "\xE1\xA4" => '&#35488;',
 "\xE1\xA5" => '&#37266;',
 "\xE1\xA6" => '&#19990;',
 "\xE1\xA7" => '&#21218;',
 "\xE1\xA8" => '&#27506;',
 "\xE1\xA9" => '&#27927;',
 "\xE1\xAA" => '&#31237;',
 "\xE1\xAB" => '&#31545;',
 "\xE1\xAC" => '&#32048;',
 "\xE1\xAD" => '&#63855;',
 "\xE1\xAE" => '&#36016;',
 "\xE1\xAF" => '&#21484;',
 "\xE1\xB0" => '&#22063;',
 "\xE1\xB1" => '&#22609;',
 "\xE1\xB2" => '&#23477;',
 "\xE1\xB3" => '&#23567;',
 "\xE1\xB4" => '&#23569;',
 "\xE1\xB5" => '&#24034;',
 "\xE1\xB6" => '&#25152;',
 "\xE1\xB7" => '&#25475;',
 "\xE1\xB8" => '&#25620;',
 "\xE1\xB9" => '&#26157;',
 "\xE1\xBA" => '&#26803;',
 "\xE1\xBB" => '&#27836;',
 "\xE1\xBC" => '&#28040;',
 "\xE1\xBD" => '&#28335;',
 "\xE1\xBE" => '&#28703;',
 "\xE1\xBF" => '&#28836;',
 "\xE1\xC0" => '&#29138;',
 "\xE1\xC1" => '&#29990;',
 "\xE1\xC2" => '&#30095;',
 "\xE1\xC3" => '&#30094;',
 "\xE1\xC4" => '&#30233;',
 "\xE1\xC5" => '&#31505;',
 "\xE1\xC6" => '&#31712;',
 "\xE1\xC7" => '&#31787;',
 "\xE1\xC8" => '&#32032;',
 "\xE1\xC9" => '&#32057;',
 "\xE1\xCA" => '&#34092;',
 "\xE1\xCB" => '&#34157;',
 "\xE1\xCC" => '&#34311;',
 "\xE1\xCD" => '&#35380;',
 "\xE1\xCE" => '&#36877;',
 "\xE1\xCF" => '&#36961;',
 "\xE1\xD0" => '&#37045;',
 "\xE1\xD1" => '&#37559;',
 "\xE1\xD2" => '&#38902;',
 "\xE1\xD3" => '&#39479;',
 "\xE1\xD4" => '&#20439;',
 "\xE1\xD5" => '&#23660;',
 "\xE1\xD6" => '&#26463;',
 "\xE1\xD7" => '&#28049;',
 "\xE1\xD8" => '&#31903;',
 "\xE1\xD9" => '&#32396;',
 "\xE1\xDA" => '&#35606;',
 "\xE1\xDB" => '&#36118;',
 "\xE1\xDC" => '&#36895;',
 "\xE1\xDD" => '&#23403;',
 "\xE1\xDE" => '&#24061;',
 "\xE1\xDF" => '&#25613;',
 "\xE1\xE0" => '&#33984;',
 "\xE1\xE1" => '&#36956;',
 "\xE1\xE2" => '&#39137;',
 "\xE1\xE3" => '&#29575;',
 "\xE1\xE4" => '&#23435;',
 "\xE1\xE5" => '&#24730;',
 "\xE1\xE6" => '&#26494;',
 "\xE1\xE7" => '&#28126;',
 "\xE1\xE8" => '&#35359;',
 "\xE1\xE9" => '&#35494;',
 "\xE1\xEA" => '&#36865;',
 "\xE1\xEB" => '&#38924;',
 "\xE1\xEC" => '&#21047;',
 "\xE1\xED" => '&#63856;',
 "\xE1\xEE" => '&#28753;',
 "\xE1\xEF" => '&#30862;',
 "\xE1\xF0" => '&#37782;',
 "\xE1\xF1" => '&#34928;',
 "\xE1\xF2" => '&#37335;',
 "\xE1\xF3" => '&#20462;',
 "\xE1\xF4" => '&#21463;',
 "\xE1\xF5" => '&#22013;',
 "\xE1\xF6" => '&#22234;',
 "\xE1\xF7" => '&#22402;',
 "\xE1\xF8" => '&#22781;',
 "\xE1\xF9" => '&#23234;',
 "\xE1\xFA" => '&#23432;',
 "\xE1\xFB" => '&#23723;',
 "\xE1\xFC" => '&#23744;',
 "\xE1\xFD" => '&#24101;',
 "\xE1\xFE" => '&#24833;',
 "\xE2\xA1" => '&#25101;',
 "\xE2\xA2" => '&#25163;',
 "\xE2\xA3" => '&#25480;',
 "\xE2\xA4" => '&#25628;',
 "\xE2\xA5" => '&#25910;',
 "\xE2\xA6" => '&#25976;',
 "\xE2\xA7" => '&#27193;',
 "\xE2\xA8" => '&#27530;',
 "\xE2\xA9" => '&#27700;',
 "\xE2\xAA" => '&#27929;',
 "\xE2\xAB" => '&#28465;',
 "\xE2\xAC" => '&#29159;',
 "\xE2\xAD" => '&#29417;',
 "\xE2\xAE" => '&#29560;',
 "\xE2\xAF" => '&#29703;',
 "\xE2\xB0" => '&#29874;',
 "\xE2\xB1" => '&#30246;',
 "\xE2\xB2" => '&#30561;',
 "\xE2\xB3" => '&#31168;',
 "\xE2\xB4" => '&#31319;',
 "\xE2\xB5" => '&#31466;',
 "\xE2\xB6" => '&#31929;',
 "\xE2\xB7" => '&#32143;',
 "\xE2\xB8" => '&#32172;',
 "\xE2\xB9" => '&#32353;',
 "\xE2\xBA" => '&#32670;',
 "\xE2\xBB" => '&#33065;',
 "\xE2\xBC" => '&#33585;',
 "\xE2\xBD" => '&#33936;',
 "\xE2\xBE" => '&#34010;',
 "\xE2\xBF" => '&#34282;',
 "\xE2\xC0" => '&#34966;',
 "\xE2\xC1" => '&#35504;',
 "\xE2\xC2" => '&#35728;',
 "\xE2\xC3" => '&#36664;',
 "\xE2\xC4" => '&#36930;',
 "\xE2\xC5" => '&#36995;',
 "\xE2\xC6" => '&#37228;',
 "\xE2\xC7" => '&#37526;',
 "\xE2\xC8" => '&#37561;',
 "\xE2\xC9" => '&#38539;',
 "\xE2\xCA" => '&#38567;',
 "\xE2\xCB" => '&#38568;',
 "\xE2\xCC" => '&#38614;',
 "\xE2\xCD" => '&#38656;',
 "\xE2\xCE" => '&#38920;',
 "\xE2\xCF" => '&#39318;',
 "\xE2\xD0" => '&#39635;',
 "\xE2\xD1" => '&#39706;',
 "\xE2\xD2" => '&#21460;',
 "\xE2\xD3" => '&#22654;',
 "\xE2\xD4" => '&#22809;',
 "\xE2\xD5" => '&#23408;',
 "\xE2\xD6" => '&#23487;',
 "\xE2\xD7" => '&#28113;',
 "\xE2\xD8" => '&#28506;',
 "\xE2\xD9" => '&#29087;',
 "\xE2\xDA" => '&#29729;',
 "\xE2\xDB" => '&#29881;',
 "\xE2\xDC" => '&#32901;',
 "\xE2\xDD" => '&#33789;',
 "\xE2\xDE" => '&#24033;',
 "\xE2\xDF" => '&#24455;',
 "\xE2\xE0" => '&#24490;',
 "\xE2\xE1" => '&#24642;',
 "\xE2\xE2" => '&#26092;',
 "\xE2\xE3" => '&#26642;',
 "\xE2\xE4" => '&#26991;',
 "\xE2\xE5" => '&#27219;',
 "\xE2\xE6" => '&#27529;',
 "\xE2\xE7" => '&#27957;',
 "\xE2\xE8" => '&#28147;',
 "\xE2\xE9" => '&#29667;',
 "\xE2\xEA" => '&#30462;',
 "\xE2\xEB" => '&#30636;',
 "\xE2\xEC" => '&#31565;',
 "\xE2\xED" => '&#32020;',
 "\xE2\xEE" => '&#33059;',
 "\xE2\xEF" => '&#33308;',
 "\xE2\xF0" => '&#33600;',
 "\xE2\xF1" => '&#34036;',
 "\xE2\xF2" => '&#34147;',
 "\xE2\xF3" => '&#35426;',
 "\xE2\xF4" => '&#35524;',
 "\xE2\xF5" => '&#37255;',
 "\xE2\xF6" => '&#37662;',
 "\xE2\xF7" => '&#38918;',
 "\xE2\xF8" => '&#39348;',
 "\xE2\xF9" => '&#25100;',
 "\xE2\xFA" => '&#34899;',
 "\xE2\xFB" => '&#36848;',
 "\xE2\xFC" => '&#37477;',
 "\xE2\xFD" => '&#23815;',
 "\xE2\xFE" => '&#23847;',
 "\xE3\xA1" => '&#23913;',
 "\xE3\xA2" => '&#29791;',
 "\xE3\xA3" => '&#33181;',
 "\xE3\xA4" => '&#34664;',
 "\xE3\xA5" => '&#28629;',
 "\xE3\xA6" => '&#25342;',
 "\xE3\xA7" => '&#32722;',
 "\xE3\xA8" => '&#35126;',
 "\xE3\xA9" => '&#35186;',
 "\xE3\xAA" => '&#19998;',
 "\xE3\xAB" => '&#20056;',
 "\xE3\xAC" => '&#20711;',
 "\xE3\xAD" => '&#21213;',
 "\xE3\xAE" => '&#21319;',
 "\xE3\xAF" => '&#25215;',
 "\xE3\xB0" => '&#26119;',
 "\xE3\xB1" => '&#32361;',
 "\xE3\xB2" => '&#34821;',
 "\xE3\xB3" => '&#38494;',
 "\xE3\xB4" => '&#20365;',
 "\xE3\xB5" => '&#21273;',
 "\xE3\xB6" => '&#22070;',
 "\xE3\xB7" => '&#22987;',
 "\xE3\xB8" => '&#23204;',
 "\xE3\xB9" => '&#23608;',
 "\xE3\xBA" => '&#23630;',
 "\xE3\xBB" => '&#23629;',
 "\xE3\xBC" => '&#24066;',
 "\xE3\xBD" => '&#24337;',
 "\xE3\xBE" => '&#24643;',
 "\xE3\xBF" => '&#26045;',
 "\xE3\xC0" => '&#26159;',
 "\xE3\xC1" => '&#26178;',
 "\xE3\xC2" => '&#26558;',
 "\xE3\xC3" => '&#26612;',
 "\xE3\xC4" => '&#29468;',
 "\xE3\xC5" => '&#30690;',
 "\xE3\xC6" => '&#31034;',
 "\xE3\xC7" => '&#32709;',
 "\xE3\xC8" => '&#33940;',
 "\xE3\xC9" => '&#33997;',
 "\xE3\xCA" => '&#35222;',
 "\xE3\xCB" => '&#35430;',
 "\xE3\xCC" => '&#35433;',
 "\xE3\xCD" => '&#35553;',
 "\xE3\xCE" => '&#35925;',
 "\xE3\xCF" => '&#35962;',
 "\xE3\xD0" => '&#22516;',
 "\xE3\xD1" => '&#23508;',
 "\xE3\xD2" => '&#24335;',
 "\xE3\xD3" => '&#24687;',
 "\xE3\xD4" => '&#25325;',
 "\xE3\xD5" => '&#26893;',
 "\xE3\xD6" => '&#27542;',
 "\xE3\xD7" => '&#28252;',
 "\xE3\xD8" => '&#29060;',
 "\xE3\xD9" => '&#31698;',
 "\xE3\xDA" => '&#34645;',
 "\xE3\xDB" => '&#35672;',
 "\xE3\xDC" => '&#36606;',
 "\xE3\xDD" => '&#39135;',
 "\xE3\xDE" => '&#39166;',
 "\xE3\xDF" => '&#20280;',
 "\xE3\xE0" => '&#20353;',
 "\xE3\xE1" => '&#20449;',
 "\xE3\xE2" => '&#21627;',
 "\xE3\xE3" => '&#23072;',
 "\xE3\xE4" => '&#23480;',
 "\xE3\xE5" => '&#24892;',
 "\xE3\xE6" => '&#26032;',
 "\xE3\xE7" => '&#26216;',
 "\xE3\xE8" => '&#29180;',
 "\xE3\xE9" => '&#30003;',
 "\xE3\xEA" => '&#31070;',
 "\xE3\xEB" => '&#32051;',
 "\xE3\xEC" => '&#33102;',
 "\xE3\xED" => '&#33251;',
 "\xE3\xEE" => '&#33688;',
 "\xE3\xEF" => '&#34218;',
 "\xE3\xF0" => '&#34254;',
 "\xE3\xF1" => '&#34563;',
 "\xE3\xF2" => '&#35338;',
 "\xE3\xF3" => '&#36523;',
 "\xE3\xF4" => '&#36763;',
 "\xE3\xF5" => '&#63857;',
 "\xE3\xF6" => '&#36805;',
 "\xE3\xF7" => '&#22833;',
 "\xE3\xF8" => '&#23460;',
 "\xE3\xF9" => '&#23526;',
 "\xE3\xFA" => '&#24713;',
 "\xE3\xFB" => '&#23529;',
 "\xE3\xFC" => '&#23563;',
 "\xE3\xFD" => '&#24515;',
 "\xE3\xFE" => '&#27777;',
 "\xE4\xA1" => '&#63858;',
 "\xE4\xA2" => '&#28145;',
 "\xE4\xA3" => '&#28683;',
 "\xE4\xA4" => '&#29978;',
 "\xE4\xA5" => '&#33455;',
 "\xE4\xA6" => '&#35574;',
 "\xE4\xA7" => '&#20160;',
 "\xE4\xA8" => '&#21313;',
 "\xE4\xA9" => '&#63859;',
 "\xE4\xAA" => '&#38617;',
 "\xE4\xAB" => '&#27663;',
 "\xE4\xAC" => '&#20126;',
 "\xE4\xAD" => '&#20420;',
 "\xE4\xAE" => '&#20818;',
 "\xE4\xAF" => '&#21854;',
 "\xE4\xB0" => '&#23077;',
 "\xE4\xB1" => '&#23784;',
 "\xE4\xB2" => '&#25105;',
 "\xE4\xB3" => '&#29273;',
 "\xE4\xB4" => '&#33469;',
 "\xE4\xB5" => '&#33706;',
 "\xE4\xB6" => '&#34558;',
 "\xE4\xB7" => '&#34905;',
 "\xE4\xB8" => '&#35357;',
 "\xE4\xB9" => '&#38463;',
 "\xE4\xBA" => '&#38597;',
 "\xE4\xBB" => '&#39187;',
 "\xE4\xBC" => '&#40201;',
 "\xE4\xBD" => '&#40285;',
 "\xE4\xBE" => '&#22538;',
 "\xE4\xBF" => '&#23731;',
 "\xE4\xC0" => '&#23997;',
 "\xE4\xC1" => '&#24132;',
 "\xE4\xC2" => '&#24801;',
 "\xE4\xC3" => '&#24853;',
 "\xE4\xC4" => '&#25569;',
 "\xE4\xC5" => '&#27138;',
 "\xE4\xC6" => '&#28197;',
 "\xE4\xC7" => '&#37122;',
 "\xE4\xC8" => '&#37716;',
 "\xE4\xC9" => '&#38990;',
 "\xE4\xCA" => '&#39952;',
 "\xE4\xCB" => '&#40823;',
 "\xE4\xCC" => '&#23433;',
 "\xE4\xCD" => '&#23736;',
 "\xE4\xCE" => '&#25353;',
 "\xE4\xCF" => '&#26191;',
 "\xE4\xD0" => '&#26696;',
 "\xE4\xD1" => '&#30524;',
 "\xE4\xD2" => '&#38593;',
 "\xE4\xD3" => '&#38797;',
 "\xE4\xD4" => '&#38996;',
 "\xE4\xD5" => '&#39839;',
 "\xE4\xD6" => '&#26017;',
 "\xE4\xD7" => '&#35585;',
 "\xE4\xD8" => '&#36555;',
 "\xE4\xD9" => '&#38332;',
 "\xE4\xDA" => '&#21813;',
 "\xE4\xDB" => '&#23721;',
 "\xE4\xDC" => '&#24022;',
 "\xE4\xDD" => '&#24245;',
 "\xE4\xDE" => '&#26263;',
 "\xE4\xDF" => '&#30284;',
 "\xE4\xE0" => '&#33780;',
 "\xE4\xE1" => '&#38343;',
 "\xE4\xE2" => '&#22739;',
 "\xE4\xE3" => '&#25276;',
 "\xE4\xE4" => '&#29390;',
 "\xE4\xE5" => '&#40232;',
 "\xE4\xE6" => '&#20208;',
 "\xE4\xE7" => '&#22830;',
 "\xE4\xE8" => '&#24591;',
 "\xE4\xE9" => '&#26171;',
 "\xE4\xEA" => '&#27523;',
 "\xE4\xEB" => '&#31207;',
 "\xE4\xEC" => '&#40230;',
 "\xE4\xED" => '&#21395;',
 "\xE4\xEE" => '&#21696;',
 "\xE4\xEF" => '&#22467;',
 "\xE4\xF0" => '&#23830;',
 "\xE4\xF1" => '&#24859;',
 "\xE4\xF2" => '&#26326;',
 "\xE4\xF3" => '&#28079;',
 "\xE4\xF4" => '&#30861;',
 "\xE4\xF5" => '&#33406;',
 "\xE4\xF6" => '&#38552;',
 "\xE4\xF7" => '&#38724;',
 "\xE4\xF8" => '&#21380;',
 "\xE4\xF9" => '&#25212;',
 "\xE4\xFA" => '&#25494;',
 "\xE4\xFB" => '&#28082;',
 "\xE4\xFC" => '&#32266;',
 "\xE4\xFD" => '&#33099;',
 "\xE4\xFE" => '&#38989;',
 "\xE5\xA1" => '&#27387;',
 "\xE5\xA2" => '&#32588;',
 "\xE5\xA3" => '&#40367;',
 "\xE5\xA4" => '&#40474;',
 "\xE5\xA5" => '&#20063;',
 "\xE5\xA6" => '&#20539;',
 "\xE5\xA7" => '&#20918;',
 "\xE5\xA8" => '&#22812;',
 "\xE5\xA9" => '&#24825;',
 "\xE5\xAA" => '&#25590;',
 "\xE5\xAB" => '&#26928;',
 "\xE5\xAC" => '&#29242;',
 "\xE5\xAD" => '&#32822;',
 "\xE5\xAE" => '&#63860;',
 "\xE5\xAF" => '&#37326;',
 "\xE5\xB0" => '&#24369;',
 "\xE5\xB1" => '&#63861;',
 "\xE5\xB2" => '&#63862;',
 "\xE5\xB3" => '&#32004;',
 "\xE5\xB4" => '&#33509;',
 "\xE5\xB5" => '&#33903;',
 "\xE5\xB6" => '&#33979;',
 "\xE5\xB7" => '&#34277;',
 "\xE5\xB8" => '&#36493;',
 "\xE5\xB9" => '&#63863;',
 "\xE5\xBA" => '&#20335;',
 "\xE5\xBB" => '&#63864;',
 "\xE5\xBC" => '&#63865;',
 "\xE5\xBD" => '&#22756;',
 "\xE5\xBE" => '&#23363;',
 "\xE5\xBF" => '&#24665;',
 "\xE5\xC0" => '&#25562;',
 "\xE5\xC1" => '&#25880;',
 "\xE5\xC2" => '&#25965;',
 "\xE5\xC3" => '&#26264;',
 "\xE5\xC4" => '&#63866;',
 "\xE5\xC5" => '&#26954;',
 "\xE5\xC6" => '&#27171;',
 "\xE5\xC7" => '&#27915;',
 "\xE5\xC8" => '&#28673;',
 "\xE5\xC9" => '&#29036;',
 "\xE5\xCA" => '&#30162;',
 "\xE5\xCB" => '&#30221;',
 "\xE5\xCC" => '&#31155;',
 "\xE5\xCD" => '&#31344;',
 "\xE5\xCE" => '&#63867;',
 "\xE5\xCF" => '&#32650;',
 "\xE5\xD0" => '&#63868;',
 "\xE5\xD1" => '&#35140;',
 "\xE5\xD2" => '&#63869;',
 "\xE5\xD3" => '&#35731;',
 "\xE5\xD4" => '&#37312;',
 "\xE5\xD5" => '&#38525;',
 "\xE5\xD6" => '&#63870;',
 "\xE5\xD7" => '&#39178;',
 "\xE5\xD8" => '&#22276;',
 "\xE5\xD9" => '&#24481;',
 "\xE5\xDA" => '&#26044;',
 "\xE5\xDB" => '&#28417;',
 "\xE5\xDC" => '&#30208;',
 "\xE5\xDD" => '&#31142;',
 "\xE5\xDE" => '&#35486;',
 "\xE5\xDF" => '&#39341;',
 "\xE5\xE0" => '&#39770;',
 "\xE5\xE1" => '&#40812;',
 "\xE5\xE2" => '&#20740;',
 "\xE5\xE3" => '&#25014;',
 "\xE5\xE4" => '&#25233;',
 "\xE5\xE5" => '&#27277;',
 "\xE5\xE6" => '&#33222;',
 "\xE5\xE7" => '&#20547;',
 "\xE5\xE8" => '&#22576;',
 "\xE5\xE9" => '&#24422;',
 "\xE5\xEA" => '&#28937;',
 "\xE5\xEB" => '&#35328;',
 "\xE5\xEC" => '&#35578;',
 "\xE5\xED" => '&#23420;',
 "\xE5\xEE" => '&#34326;',
 "\xE5\xEF" => '&#20474;',
 "\xE5\xF0" => '&#20796;',
 "\xE5\xF1" => '&#22196;',
 "\xE5\xF2" => '&#22852;',
 "\xE5\xF3" => '&#25513;',
 "\xE5\xF4" => '&#28153;',
 "\xE5\xF5" => '&#23978;',
 "\xE5\xF6" => '&#26989;',
 "\xE5\xF7" => '&#20870;',
 "\xE5\xF8" => '&#20104;',
 "\xE5\xF9" => '&#20313;',
 "\xE5\xFA" => '&#63871;',
 "\xE5\xFB" => '&#63872;',
 "\xE5\xFC" => '&#63873;',
 "\xE5\xFD" => '&#22914;',
 "\xE5\xFE" => '&#63874;',
 "\xE6\xA1" => '&#63875;',
 "\xE6\xA2" => '&#27487;',
 "\xE6\xA3" => '&#27741;',
 "\xE6\xA4" => '&#63876;',
 "\xE6\xA5" => '&#29877;',
 "\xE6\xA6" => '&#30998;',
 "\xE6\xA7" => '&#63877;',
 "\xE6\xA8" => '&#33287;',
 "\xE6\xA9" => '&#33349;',
 "\xE6\xAA" => '&#33593;',
 "\xE6\xAB" => '&#36671;',
 "\xE6\xAC" => '&#36701;',
 "\xE6\xAD" => '&#63878;',
 "\xE6\xAE" => '&#39192;',
 "\xE6\xAF" => '&#63879;',
 "\xE6\xB0" => '&#63880;',
 "\xE6\xB1" => '&#63881;',
 "\xE6\xB2" => '&#20134;',
 "\xE6\xB3" => '&#63882;',
 "\xE6\xB4" => '&#22495;',
 "\xE6\xB5" => '&#24441;',
 "\xE6\xB6" => '&#26131;',
 "\xE6\xB7" => '&#63883;',
 "\xE6\xB8" => '&#63884;',
 "\xE6\xB9" => '&#30123;',
 "\xE6\xBA" => '&#32377;',
 "\xE6\xBB" => '&#35695;',
 "\xE6\xBC" => '&#63885;',
 "\xE6\xBD" => '&#36870;',
 "\xE6\xBE" => '&#39515;',
 "\xE6\xBF" => '&#22181;',
 "\xE6\xC0" => '&#22567;',
 "\xE6\xC1" => '&#23032;',
 "\xE6\xC2" => '&#23071;',
 "\xE6\xC3" => '&#23476;',
 "\xE6\xC4" => '&#63886;',
 "\xE6\xC5" => '&#24310;',
 "\xE6\xC6" => '&#63887;',
 "\xE6\xC7" => '&#63888;',
 "\xE6\xC8" => '&#25424;',
 "\xE6\xC9" => '&#25403;',
 "\xE6\xCA" => '&#63889;',
 "\xE6\xCB" => '&#26941;',
 "\xE6\xCC" => '&#27783;',
 "\xE6\xCD" => '&#27839;',
 "\xE6\xCE" => '&#28046;',
 "\xE6\xCF" => '&#28051;',
 "\xE6\xD0" => '&#28149;',
 "\xE6\xD1" => '&#28436;',
 "\xE6\xD2" => '&#63890;',
 "\xE6\xD3" => '&#28895;',
 "\xE6\xD4" => '&#28982;',
 "\xE6\xD5" => '&#29017;',
 "\xE6\xD6" => '&#63891;',
 "\xE6\xD7" => '&#29123;',
 "\xE6\xD8" => '&#29141;',
 "\xE6\xD9" => '&#63892;',
 "\xE6\xDA" => '&#30799;',
 "\xE6\xDB" => '&#30831;',
 "\xE6\xDC" => '&#63893;',
 "\xE6\xDD" => '&#31605;',
 "\xE6\xDE" => '&#32227;',
 "\xE6\xDF" => '&#63894;',
 "\xE6\xE0" => '&#32303;',
 "\xE6\xE1" => '&#63895;',
 "\xE6\xE2" => '&#34893;',
 "\xE6\xE3" => '&#36575;',
 "\xE6\xE4" => '&#63896;',
 "\xE6\xE5" => '&#63897;',
 "\xE6\xE6" => '&#63898;',
 "\xE6\xE7" => '&#37467;',
 "\xE6\xE8" => '&#63899;',
 "\xE6\xE9" => '&#40182;',
 "\xE6\xEA" => '&#63900;',
 "\xE6\xEB" => '&#63901;',
 "\xE6\xEC" => '&#63902;',
 "\xE6\xED" => '&#24709;',
 "\xE6\xEE" => '&#28037;',
 "\xE6\xEF" => '&#63903;',
 "\xE6\xF0" => '&#29105;',
 "\xE6\xF1" => '&#63904;',
 "\xE6\xF2" => '&#63905;',
 "\xE6\xF3" => '&#38321;',
 "\xE6\xF4" => '&#21421;',
 "\xE6\xF5" => '&#63906;',
 "\xE6\xF6" => '&#63907;',
 "\xE6\xF7" => '&#63908;',
 "\xE6\xF8" => '&#26579;',
 "\xE6\xF9" => '&#63909;',
 "\xE6\xFA" => '&#28814;',
 "\xE6\xFB" => '&#28976;',
 "\xE6\xFC" => '&#29744;',
 "\xE6\xFD" => '&#33398;',
 "\xE6\xFE" => '&#33490;',
 "\xE7\xA1" => '&#63910;',
 "\xE7\xA2" => '&#38331;',
 "\xE7\xA3" => '&#39653;',
 "\xE7\xA4" => '&#40573;',
 "\xE7\xA5" => '&#26308;',
 "\xE7\xA6" => '&#63911;',
 "\xE7\xA7" => '&#29121;',
 "\xE7\xA8" => '&#33865;',
 "\xE7\xA9" => '&#63912;',
 "\xE7\xAA" => '&#63913;',
 "\xE7\xAB" => '&#22603;',
 "\xE7\xAC" => '&#63914;',
 "\xE7\xAD" => '&#63915;',
 "\xE7\xAE" => '&#23992;',
 "\xE7\xAF" => '&#24433;',
 "\xE7\xB0" => '&#63916;',
 "\xE7\xB1" => '&#26144;',
 "\xE7\xB2" => '&#26254;',
 "\xE7\xB3" => '&#27001;',
 "\xE7\xB4" => '&#27054;',
 "\xE7\xB5" => '&#27704;',
 "\xE7\xB6" => '&#27891;',
 "\xE7\xB7" => '&#28214;',
 "\xE7\xB8" => '&#28481;',
 "\xE7\xB9" => '&#28634;',
 "\xE7\xBA" => '&#28699;',
 "\xE7\xBB" => '&#28719;',
 "\xE7\xBC" => '&#29008;',
 "\xE7\xBD" => '&#29151;',
 "\xE7\xBE" => '&#29552;',
 "\xE7\xBF" => '&#63917;',
 "\xE7\xC0" => '&#29787;',
 "\xE7\xC1" => '&#63918;',
 "\xE7\xC2" => '&#29908;',
 "\xE7\xC3" => '&#30408;',
 "\xE7\xC4" => '&#31310;',
 "\xE7\xC5" => '&#32403;',
 "\xE7\xC6" => '&#63919;',
 "\xE7\xC7" => '&#63920;',
 "\xE7\xC8" => '&#33521;',
 "\xE7\xC9" => '&#35424;',
 "\xE7\xCA" => '&#36814;',
 "\xE7\xCB" => '&#63921;',
 "\xE7\xCC" => '&#37704;',
 "\xE7\xCD" => '&#63922;',
 "\xE7\xCE" => '&#38681;',
 "\xE7\xCF" => '&#63923;',
 "\xE7\xD0" => '&#63924;',
 "\xE7\xD1" => '&#20034;',
 "\xE7\xD2" => '&#20522;',
 "\xE7\xD3" => '&#63925;',
 "\xE7\xD4" => '&#21000;',
 "\xE7\xD5" => '&#21473;',
 "\xE7\xD6" => '&#26355;',
 "\xE7\xD7" => '&#27757;',
 "\xE7\xD8" => '&#28618;',
 "\xE7\xD9" => '&#29450;',
 "\xE7\xDA" => '&#30591;',
 "\xE7\xDB" => '&#31330;',
 "\xE7\xDC" => '&#33454;',
 "\xE7\xDD" => '&#34269;',
 "\xE7\xDE" => '&#34306;',
 "\xE7\xDF" => '&#63926;',
 "\xE7\xE0" => '&#35028;',
 "\xE7\xE1" => '&#35427;',
 "\xE7\xE2" => '&#35709;',
 "\xE7\xE3" => '&#35947;',
 "\xE7\xE4" => '&#63927;',
 "\xE7\xE5" => '&#37555;',
 "\xE7\xE6" => '&#63928;',
 "\xE7\xE7" => '&#38675;',
 "\xE7\xE8" => '&#38928;',
 "\xE7\xE9" => '&#20116;',
 "\xE7\xEA" => '&#20237;',
 "\xE7\xEB" => '&#20425;',
 "\xE7\xEC" => '&#20658;',
 "\xE7\xED" => '&#21320;',
 "\xE7\xEE" => '&#21566;',
 "\xE7\xEF" => '&#21555;',
 "\xE7\xF0" => '&#21978;',
 "\xE7\xF1" => '&#22626;',
 "\xE7\xF2" => '&#22714;',
 "\xE7\xF3" => '&#22887;',
 "\xE7\xF4" => '&#23067;',
 "\xE7\xF5" => '&#23524;',
 "\xE7\xF6" => '&#24735;',
 "\xE7\xF7" => '&#63929;',
 "\xE7\xF8" => '&#25034;',
 "\xE7\xF9" => '&#25942;',
 "\xE7\xFA" => '&#26111;',
 "\xE7\xFB" => '&#26212;',
 "\xE7\xFC" => '&#26791;',
 "\xE7\xFD" => '&#27738;',
 "\xE7\xFE" => '&#28595;',
 "\xE8\xA1" => '&#28879;',
 "\xE8\xA2" => '&#29100;',
 "\xE8\xA3" => '&#29522;',
 "\xE8\xA4" => '&#31613;',
 "\xE8\xA5" => '&#34568;',
 "\xE8\xA6" => '&#35492;',
 "\xE8\xA7" => '&#39986;',
 "\xE8\xA8" => '&#40711;',
 "\xE8\xA9" => '&#23627;',
 "\xE8\xAA" => '&#27779;',
 "\xE8\xAB" => '&#29508;',
 "\xE8\xAC" => '&#29577;',
 "\xE8\xAD" => '&#37434;',
 "\xE8\xAE" => '&#28331;',
 "\xE8\xAF" => '&#29797;',
 "\xE8\xB0" => '&#30239;',
 "\xE8\xB1" => '&#31337;',
 "\xE8\xB2" => '&#32277;',
 "\xE8\xB3" => '&#34314;',
 "\xE8\xB4" => '&#20800;',
 "\xE8\xB5" => '&#22725;',
 "\xE8\xB6" => '&#25793;',
 "\xE8\xB7" => '&#29934;',
 "\xE8\xB8" => '&#29973;',
 "\xE8\xB9" => '&#30320;',
 "\xE8\xBA" => '&#32705;',
 "\xE8\xBB" => '&#37013;',
 "\xE8\xBC" => '&#38605;',
 "\xE8\xBD" => '&#39252;',
 "\xE8\xBE" => '&#28198;',
 "\xE8\xBF" => '&#29926;',
 "\xE8\xC0" => '&#31401;',
 "\xE8\xC1" => '&#31402;',
 "\xE8\xC2" => '&#33253;',
 "\xE8\xC3" => '&#34521;',
 "\xE8\xC4" => '&#34680;',
 "\xE8\xC5" => '&#35355;',
 "\xE8\xC6" => '&#23113;',
 "\xE8\xC7" => '&#23436;',
 "\xE8\xC8" => '&#23451;',
 "\xE8\xC9" => '&#26785;',
 "\xE8\xCA" => '&#26880;',
 "\xE8\xCB" => '&#28003;',
 "\xE8\xCC" => '&#29609;',
 "\xE8\xCD" => '&#29715;',
 "\xE8\xCE" => '&#29740;',
 "\xE8\xCF" => '&#30871;',
 "\xE8\xD0" => '&#32233;',
 "\xE8\xD1" => '&#32747;',
 "\xE8\xD2" => '&#33048;',
 "\xE8\xD3" => '&#33109;',
 "\xE8\xD4" => '&#33694;',
 "\xE8\xD5" => '&#35916;',
 "\xE8\xD6" => '&#38446;',
 "\xE8\xD7" => '&#38929;',
 "\xE8\xD8" => '&#26352;',
 "\xE8\xD9" => '&#24448;',
 "\xE8\xDA" => '&#26106;',
 "\xE8\xDB" => '&#26505;',
 "\xE8\xDC" => '&#27754;',
 "\xE8\xDD" => '&#29579;',
 "\xE8\xDE" => '&#20525;',
 "\xE8\xDF" => '&#23043;',
 "\xE8\xE0" => '&#27498;',
 "\xE8\xE1" => '&#30702;',
 "\xE8\xE2" => '&#22806;',
 "\xE8\xE3" => '&#23916;',
 "\xE8\xE4" => '&#24013;',
 "\xE8\xE5" => '&#29477;',
 "\xE8\xE6" => '&#30031;',
 "\xE8\xE7" => '&#63930;',
 "\xE8\xE8" => '&#63931;',
 "\xE8\xE9" => '&#20709;',
 "\xE8\xEA" => '&#20985;',
 "\xE8\xEB" => '&#22575;',
 "\xE8\xEC" => '&#22829;',
 "\xE8\xED" => '&#22934;',
 "\xE8\xEE" => '&#23002;',
 "\xE8\xEF" => '&#23525;',
 "\xE8\xF0" => '&#63932;',
 "\xE8\xF1" => '&#63933;',
 "\xE8\xF2" => '&#23970;',
 "\xE8\xF3" => '&#25303;',
 "\xE8\xF4" => '&#25622;',
 "\xE8\xF5" => '&#25747;',
 "\xE8\xF6" => '&#25854;',
 "\xE8\xF7" => '&#63934;',
 "\xE8\xF8" => '&#26332;',
 "\xE8\xF9" => '&#63935;',
 "\xE8\xFA" => '&#27208;',
 "\xE8\xFB" => '&#63936;',
 "\xE8\xFC" => '&#29183;',
 "\xE8\xFD" => '&#29796;',
 "\xE8\xFE" => '&#63937;',
 "\xE9\xA1" => '&#31368;',
 "\xE9\xA2" => '&#31407;',
 "\xE9\xA3" => '&#32327;',
 "\xE9\xA4" => '&#32350;',
 "\xE9\xA5" => '&#32768;',
 "\xE9\xA6" => '&#33136;',
 "\xE9\xA7" => '&#63938;',
 "\xE9\xA8" => '&#34799;',
 "\xE9\xA9" => '&#35201;',
 "\xE9\xAA" => '&#35616;',
 "\xE9\xAB" => '&#36953;',
 "\xE9\xAC" => '&#63939;',
 "\xE9\xAD" => '&#36992;',
 "\xE9\xAE" => '&#39250;',
 "\xE9\xAF" => '&#24958;',
 "\xE9\xB0" => '&#27442;',
 "\xE9\xB1" => '&#28020;',
 "\xE9\xB2" => '&#32287;',
 "\xE9\xB3" => '&#35109;',
 "\xE9\xB4" => '&#36785;',
 "\xE9\xB5" => '&#20433;',
 "\xE9\xB6" => '&#20653;',
 "\xE9\xB7" => '&#20887;',
 "\xE9\xB8" => '&#21191;',
 "\xE9\xB9" => '&#22471;',
 "\xE9\xBA" => '&#22665;',
 "\xE9\xBB" => '&#23481;',
 "\xE9\xBC" => '&#24248;',
 "\xE9\xBD" => '&#24898;',
 "\xE9\xBE" => '&#27029;',
 "\xE9\xBF" => '&#28044;',
 "\xE9\xC0" => '&#28263;',
 "\xE9\xC1" => '&#28342;',
 "\xE9\xC2" => '&#29076;',
 "\xE9\xC3" => '&#29794;',
 "\xE9\xC4" => '&#29992;',
 "\xE9\xC5" => '&#29996;',
 "\xE9\xC6" => '&#32883;',
 "\xE9\xC7" => '&#33592;',
 "\xE9\xC8" => '&#33993;',
 "\xE9\xC9" => '&#36362;',
 "\xE9\xCA" => '&#37780;',
 "\xE9\xCB" => '&#37854;',
 "\xE9\xCC" => '&#63940;',
 "\xE9\xCD" => '&#20110;',
 "\xE9\xCE" => '&#20305;',
 "\xE9\xCF" => '&#20598;',
 "\xE9\xD0" => '&#20778;',
 "\xE9\xD1" => '&#21448;',
 "\xE9\xD2" => '&#21451;',
 "\xE9\xD3" => '&#21491;',
 "\xE9\xD4" => '&#23431;',
 "\xE9\xD5" => '&#23507;',
 "\xE9\xD6" => '&#23588;',
 "\xE9\xD7" => '&#24858;',
 "\xE9\xD8" => '&#24962;',
 "\xE9\xD9" => '&#26100;',
 "\xE9\xDA" => '&#29275;',
 "\xE9\xDB" => '&#29591;',
 "\xE9\xDC" => '&#29760;',
 "\xE9\xDD" => '&#30402;',
 "\xE9\xDE" => '&#31056;',
 "\xE9\xDF" => '&#31121;',
 "\xE9\xE0" => '&#31161;',
 "\xE9\xE1" => '&#32006;',
 "\xE9\xE2" => '&#32701;',
 "\xE9\xE3" => '&#33419;',
 "\xE9\xE4" => '&#34261;',
 "\xE9\xE5" => '&#34398;',
 "\xE9\xE6" => '&#36802;',
 "\xE9\xE7" => '&#36935;',
 "\xE9\xE8" => '&#37109;',
 "\xE9\xE9" => '&#37354;',
 "\xE9\xEA" => '&#38533;',
 "\xE9\xEB" => '&#38632;',
 "\xE9\xEC" => '&#38633;',
 "\xE9\xED" => '&#21206;',
 "\xE9\xEE" => '&#24423;',
 "\xE9\xEF" => '&#26093;',
 "\xE9\xF0" => '&#26161;',
 "\xE9\xF1" => '&#26671;',
 "\xE9\xF2" => '&#29020;',
 "\xE9\xF3" => '&#31286;',
 "\xE9\xF4" => '&#37057;',
 "\xE9\xF5" => '&#38922;',
 "\xE9\xF6" => '&#20113;',
 "\xE9\xF7" => '&#63941;',
 "\xE9\xF8" => '&#27218;',
 "\xE9\xF9" => '&#27550;',
 "\xE9\xFA" => '&#28560;',
 "\xE9\xFB" => '&#29065;',
 "\xE9\xFC" => '&#32792;',
 "\xE9\xFD" => '&#33464;',
 "\xE9\xFE" => '&#34131;',
 "\xEA\xA1" => '&#36939;',
 "\xEA\xA2" => '&#38549;',
 "\xEA\xA3" => '&#38642;',
 "\xEA\xA4" => '&#38907;',
 "\xEA\xA5" => '&#34074;',
 "\xEA\xA6" => '&#39729;',
 "\xEA\xA7" => '&#20112;',
 "\xEA\xA8" => '&#29066;',
 "\xEA\xA9" => '&#38596;',
 "\xEA\xAA" => '&#20803;',
 "\xEA\xAB" => '&#21407;',
 "\xEA\xAC" => '&#21729;',
 "\xEA\xAD" => '&#22291;',
 "\xEA\xAE" => '&#22290;',
 "\xEA\xAF" => '&#22435;',
 "\xEA\xB0" => '&#23195;',
 "\xEA\xB1" => '&#23236;',
 "\xEA\xB2" => '&#23491;',
 "\xEA\xB3" => '&#24616;',
 "\xEA\xB4" => '&#24895;',
 "\xEA\xB5" => '&#25588;',
 "\xEA\xB6" => '&#27781;',
 "\xEA\xB7" => '&#27961;',
 "\xEA\xB8" => '&#28274;',
 "\xEA\xB9" => '&#28304;',
 "\xEA\xBA" => '&#29232;',
 "\xEA\xBB" => '&#29503;',
 "\xEA\xBC" => '&#29783;',
 "\xEA\xBD" => '&#33489;',
 "\xEA\xBE" => '&#34945;',
 "\xEA\xBF" => '&#36677;',
 "\xEA\xC0" => '&#36960;',
 "\xEA\xC1" => '&#63942;',
 "\xEA\xC2" => '&#38498;',
 "\xEA\xC3" => '&#39000;',
 "\xEA\xC4" => '&#40219;',
 "\xEA\xC5" => '&#26376;',
 "\xEA\xC6" => '&#36234;',
 "\xEA\xC7" => '&#37470;',
 "\xEA\xC8" => '&#20301;',
 "\xEA\xC9" => '&#20553;',
 "\xEA\xCA" => '&#20702;',
 "\xEA\xCB" => '&#21361;',
 "\xEA\xCC" => '&#22285;',
 "\xEA\xCD" => '&#22996;',
 "\xEA\xCE" => '&#23041;',
 "\xEA\xCF" => '&#23561;',
 "\xEA\xD0" => '&#24944;',
 "\xEA\xD1" => '&#26256;',
 "\xEA\xD2" => '&#28205;',
 "\xEA\xD3" => '&#29234;',
 "\xEA\xD4" => '&#29771;',
 "\xEA\xD5" => '&#32239;',
 "\xEA\xD6" => '&#32963;',
 "\xEA\xD7" => '&#33806;',
 "\xEA\xD8" => '&#33894;',
 "\xEA\xD9" => '&#34111;',
 "\xEA\xDA" => '&#34655;',
 "\xEA\xDB" => '&#34907;',
 "\xEA\xDC" => '&#35096;',
 "\xEA\xDD" => '&#35586;',
 "\xEA\xDE" => '&#36949;',
 "\xEA\xDF" => '&#38859;',
 "\xEA\xE0" => '&#39759;',
 "\xEA\xE1" => '&#20083;',
 "\xEA\xE2" => '&#20369;',
 "\xEA\xE3" => '&#20754;',
 "\xEA\xE4" => '&#20842;',
 "\xEA\xE5" => '&#63943;',
 "\xEA\xE6" => '&#21807;',
 "\xEA\xE7" => '&#21929;',
 "\xEA\xE8" => '&#23418;',
 "\xEA\xE9" => '&#23461;',
 "\xEA\xEA" => '&#24188;',
 "\xEA\xEB" => '&#24189;',
 "\xEA\xEC" => '&#24254;',
 "\xEA\xED" => '&#24736;',
 "\xEA\xEE" => '&#24799;',
 "\xEA\xEF" => '&#24840;',
 "\xEA\xF0" => '&#24841;',
 "\xEA\xF1" => '&#25540;',
 "\xEA\xF2" => '&#25912;',
 "\xEA\xF3" => '&#26377;',
 "\xEA\xF4" => '&#63944;',
 "\xEA\xF5" => '&#26580;',
 "\xEA\xF6" => '&#26586;',
 "\xEA\xF7" => '&#63945;',
 "\xEA\xF8" => '&#26977;',
 "\xEA\xF9" => '&#26978;',
 "\xEA\xFA" => '&#27833;',
 "\xEA\xFB" => '&#27943;',
 "\xEA\xFC" => '&#63946;',
 "\xEA\xFD" => '&#28216;',
 "\xEA\xFE" => '&#63947;',
 "\xEB\xA1" => '&#28641;',
 "\xEB\xA2" => '&#29494;',
 "\xEB\xA3" => '&#29495;',
 "\xEB\xA4" => '&#63948;',
 "\xEB\xA5" => '&#29788;',
 "\xEB\xA6" => '&#30001;',
 "\xEB\xA7" => '&#63949;',
 "\xEB\xA8" => '&#30290;',
 "\xEB\xA9" => '&#63950;',
 "\xEB\xAA" => '&#63951;',
 "\xEB\xAB" => '&#32173;',
 "\xEB\xAC" => '&#33278;',
 "\xEB\xAD" => '&#33848;',
 "\xEB\xAE" => '&#35029;',
 "\xEB\xAF" => '&#35480;',
 "\xEB\xB0" => '&#35547;',
 "\xEB\xB1" => '&#35565;',
 "\xEB\xB2" => '&#36400;',
 "\xEB\xB3" => '&#36418;',
 "\xEB\xB4" => '&#36938;',
 "\xEB\xB5" => '&#36926;',
 "\xEB\xB6" => '&#36986;',
 "\xEB\xB7" => '&#37193;',
 "\xEB\xB8" => '&#37321;',
 "\xEB\xB9" => '&#37742;',
 "\xEB\xBA" => '&#63952;',
 "\xEB\xBB" => '&#63953;',
 "\xEB\xBC" => '&#22537;',
 "\xEB\xBD" => '&#63954;',
 "\xEB\xBE" => '&#27603;',
 "\xEB\xBF" => '&#32905;',
 "\xEB\xC0" => '&#32946;',
 "\xEB\xC1" => '&#63955;',
 "\xEB\xC2" => '&#63956;',
 "\xEB\xC3" => '&#20801;',
 "\xEB\xC4" => '&#22891;',
 "\xEB\xC5" => '&#23609;',
 "\xEB\xC6" => '&#63957;',
 "\xEB\xC7" => '&#63958;',
 "\xEB\xC8" => '&#28516;',
 "\xEB\xC9" => '&#29607;',
 "\xEB\xCA" => '&#32996;',
 "\xEB\xCB" => '&#36103;',
 "\xEB\xCC" => '&#63959;',
 "\xEB\xCD" => '&#37399;',
 "\xEB\xCE" => '&#38287;',
 "\xEB\xCF" => '&#63960;',
 "\xEB\xD0" => '&#63961;',
 "\xEB\xD1" => '&#63962;',
 "\xEB\xD2" => '&#63963;',
 "\xEB\xD3" => '&#32895;',
 "\xEB\xD4" => '&#25102;',
 "\xEB\xD5" => '&#28700;',
 "\xEB\xD6" => '&#32104;',
 "\xEB\xD7" => '&#34701;',
 "\xEB\xD8" => '&#63964;',
 "\xEB\xD9" => '&#22432;',
 "\xEB\xDA" => '&#24681;',
 "\xEB\xDB" => '&#24903;',
 "\xEB\xDC" => '&#27575;',
 "\xEB\xDD" => '&#35518;',
 "\xEB\xDE" => '&#37504;',
 "\xEB\xDF" => '&#38577;',
 "\xEB\xE0" => '&#20057;',
 "\xEB\xE1" => '&#21535;',
 "\xEB\xE2" => '&#28139;',
 "\xEB\xE3" => '&#34093;',
 "\xEB\xE4" => '&#38512;',
 "\xEB\xE5" => '&#38899;',
 "\xEB\xE6" => '&#39150;',
 "\xEB\xE7" => '&#25558;',
 "\xEB\xE8" => '&#27875;',
 "\xEB\xE9" => '&#37009;',
 "\xEB\xEA" => '&#20957;',
 "\xEB\xEB" => '&#25033;',
 "\xEB\xEC" => '&#33210;',
 "\xEB\xED" => '&#40441;',
 "\xEB\xEE" => '&#20381;',
 "\xEB\xEF" => '&#20506;',
 "\xEB\xF0" => '&#20736;',
 "\xEB\xF1" => '&#23452;',
 "\xEB\xF2" => '&#24847;',
 "\xEB\xF3" => '&#25087;',
 "\xEB\xF4" => '&#25836;',
 "\xEB\xF5" => '&#26885;',
 "\xEB\xF6" => '&#27589;',
 "\xEB\xF7" => '&#30097;',
 "\xEB\xF8" => '&#30691;',
 "\xEB\xF9" => '&#32681;',
 "\xEB\xFA" => '&#33380;',
 "\xEB\xFB" => '&#34191;',
 "\xEB\xFC" => '&#34811;',
 "\xEB\xFD" => '&#34915;',
 "\xEB\xFE" => '&#35516;',
 "\xEC\xA1" => '&#35696;',
 "\xEC\xA2" => '&#37291;',
 "\xEC\xA3" => '&#20108;',
 "\xEC\xA4" => '&#20197;',
 "\xEC\xA5" => '&#20234;',
 "\xEC\xA6" => '&#63965;',
 "\xEC\xA7" => '&#63966;',
 "\xEC\xA8" => '&#22839;',
 "\xEC\xA9" => '&#23016;',
 "\xEC\xAA" => '&#63967;',
 "\xEC\xAB" => '&#24050;',
 "\xEC\xAC" => '&#24347;',
 "\xEC\xAD" => '&#24411;',
 "\xEC\xAE" => '&#24609;',
 "\xEC\xAF" => '&#63968;',
 "\xEC\xB0" => '&#63969;',
 "\xEC\xB1" => '&#63970;',
 "\xEC\xB2" => '&#63971;',
 "\xEC\xB3" => '&#29246;',
 "\xEC\xB4" => '&#29669;',
 "\xEC\xB5" => '&#63972;',
 "\xEC\xB6" => '&#30064;',
 "\xEC\xB7" => '&#30157;',
 "\xEC\xB8" => '&#63973;',
 "\xEC\xB9" => '&#31227;',
 "\xEC\xBA" => '&#63974;',
 "\xEC\xBB" => '&#32780;',
 "\xEC\xBC" => '&#32819;',
 "\xEC\xBD" => '&#32900;',
 "\xEC\xBE" => '&#33505;',
 "\xEC\xBF" => '&#33617;',
 "\xEC\xC0" => '&#63975;',
 "\xEC\xC1" => '&#63976;',
 "\xEC\xC2" => '&#36029;',
 "\xEC\xC3" => '&#36019;',
 "\xEC\xC4" => '&#36999;',
 "\xEC\xC5" => '&#63977;',
 "\xEC\xC6" => '&#63978;',
 "\xEC\xC7" => '&#39156;',
 "\xEC\xC8" => '&#39180;',
 "\xEC\xC9" => '&#63979;',
 "\xEC\xCA" => '&#63980;',
 "\xEC\xCB" => '&#28727;',
 "\xEC\xCC" => '&#30410;',
 "\xEC\xCD" => '&#32714;',
 "\xEC\xCE" => '&#32716;',
 "\xEC\xCF" => '&#32764;',
 "\xEC\xD0" => '&#35610;',
 "\xEC\xD1" => '&#20154;',
 "\xEC\xD2" => '&#20161;',
 "\xEC\xD3" => '&#20995;',
 "\xEC\xD4" => '&#21360;',
 "\xEC\xD5" => '&#63981;',
 "\xEC\xD6" => '&#21693;',
 "\xEC\xD7" => '&#22240;',
 "\xEC\xD8" => '&#23035;',
 "\xEC\xD9" => '&#23493;',
 "\xEC\xDA" => '&#24341;',
 "\xEC\xDB" => '&#24525;',
 "\xEC\xDC" => '&#28270;',
 "\xEC\xDD" => '&#63982;',
 "\xEC\xDE" => '&#63983;',
 "\xEC\xDF" => '&#32106;',
 "\xEC\xE0" => '&#33589;',
 "\xEC\xE1" => '&#63984;',
 "\xEC\xE2" => '&#34451;',
 "\xEC\xE3" => '&#35469;',
 "\xEC\xE4" => '&#63985;',
 "\xEC\xE5" => '&#38765;',
 "\xEC\xE6" => '&#38775;',
 "\xEC\xE7" => '&#63986;',
 "\xEC\xE8" => '&#63987;',
 "\xEC\xE9" => '&#19968;',
 "\xEC\xEA" => '&#20314;',
 "\xEC\xEB" => '&#20350;',
 "\xEC\xEC" => '&#22777;',
 "\xEC\xED" => '&#26085;',
 "\xEC\xEE" => '&#28322;',
 "\xEC\xEF" => '&#36920;',
 "\xEC\xF0" => '&#37808;',
 "\xEC\xF1" => '&#39353;',
 "\xEC\xF2" => '&#20219;',
 "\xEC\xF3" => '&#22764;',
 "\xEC\xF4" => '&#22922;',
 "\xEC\xF5" => '&#23001;',
 "\xEC\xF6" => '&#24641;',
 "\xEC\xF7" => '&#63988;',
 "\xEC\xF8" => '&#63989;',
 "\xEC\xF9" => '&#31252;',
 "\xEC\xFA" => '&#63990;',
 "\xEC\xFB" => '&#33615;',
 "\xEC\xFC" => '&#36035;',
 "\xEC\xFD" => '&#20837;',
 "\xEC\xFE" => '&#21316;',
 "\xED\xA1" => '&#63991;',
 "\xED\xA2" => '&#63992;',
 "\xED\xA3" => '&#63993;',
 "\xED\xA4" => '&#20173;',
 "\xED\xA5" => '&#21097;',
 "\xED\xA6" => '&#23381;',
 "\xED\xA7" => '&#33471;',
 "\xED\xA8" => '&#20180;',
 "\xED\xA9" => '&#21050;',
 "\xED\xAA" => '&#21672;',
 "\xED\xAB" => '&#22985;',
 "\xED\xAC" => '&#23039;',
 "\xED\xAD" => '&#23376;',
 "\xED\xAE" => '&#23383;',
 "\xED\xAF" => '&#23388;',
 "\xED\xB0" => '&#24675;',
 "\xED\xB1" => '&#24904;',
 "\xED\xB2" => '&#28363;',
 "\xED\xB3" => '&#28825;',
 "\xED\xB4" => '&#29038;',
 "\xED\xB5" => '&#29574;',
 "\xED\xB6" => '&#29943;',
 "\xED\xB7" => '&#30133;',
 "\xED\xB8" => '&#30913;',
 "\xED\xB9" => '&#32043;',
 "\xED\xBA" => '&#32773;',
 "\xED\xBB" => '&#33258;',
 "\xED\xBC" => '&#33576;',
 "\xED\xBD" => '&#34071;',
 "\xED\xBE" => '&#34249;',
 "\xED\xBF" => '&#35566;',
 "\xED\xC0" => '&#36039;',
 "\xED\xC1" => '&#38604;',
 "\xED\xC2" => '&#20316;',
 "\xED\xC3" => '&#21242;',
 "\xED\xC4" => '&#22204;',
 "\xED\xC5" => '&#26027;',
 "\xED\xC6" => '&#26152;',
 "\xED\xC7" => '&#28796;',
 "\xED\xC8" => '&#28856;',
 "\xED\xC9" => '&#29237;',
 "\xED\xCA" => '&#32189;',
 "\xED\xCB" => '&#33421;',
 "\xED\xCC" => '&#37196;',
 "\xED\xCD" => '&#38592;',
 "\xED\xCE" => '&#40306;',
 "\xED\xCF" => '&#23409;',
 "\xED\xD0" => '&#26855;',
 "\xED\xD1" => '&#27544;',
 "\xED\xD2" => '&#28538;',
 "\xED\xD3" => '&#30430;',
 "\xED\xD4" => '&#23697;',
 "\xED\xD5" => '&#26283;',
 "\xED\xD6" => '&#28507;',
 "\xED\xD7" => '&#31668;',
 "\xED\xD8" => '&#31786;',
 "\xED\xD9" => '&#34870;',
 "\xED\xDA" => '&#38620;',
 "\xED\xDB" => '&#19976;',
 "\xED\xDC" => '&#20183;',
 "\xED\xDD" => '&#21280;',
 "\xED\xDE" => '&#22580;',
 "\xED\xDF" => '&#22715;',
 "\xED\xE0" => '&#22767;',
 "\xED\xE1" => '&#22892;',
 "\xED\xE2" => '&#23559;',
 "\xED\xE3" => '&#24115;',
 "\xED\xE4" => '&#24196;',
 "\xED\xE5" => '&#24373;',
 "\xED\xE6" => '&#25484;',
 "\xED\xE7" => '&#26290;',
 "\xED\xE8" => '&#26454;',
 "\xED\xE9" => '&#27167;',
 "\xED\xEA" => '&#27299;',
 "\xED\xEB" => '&#27404;',
 "\xED\xEC" => '&#28479;',
 "\xED\xED" => '&#29254;',
 "\xED\xEE" => '&#63994;',
 "\xED\xEF" => '&#29520;',
 "\xED\xF0" => '&#29835;',
 "\xED\xF1" => '&#31456;',
 "\xED\xF2" => '&#31911;',
 "\xED\xF3" => '&#33144;',
 "\xED\xF4" => '&#33247;',
 "\xED\xF5" => '&#33255;',
 "\xED\xF6" => '&#33674;',
 "\xED\xF7" => '&#33900;',
 "\xED\xF8" => '&#34083;',
 "\xED\xF9" => '&#34196;',
 "\xED\xFA" => '&#34255;',
 "\xED\xFB" => '&#35037;',
 "\xED\xFC" => '&#36115;',
 "\xED\xFD" => '&#37292;',
 "\xED\xFE" => '&#38263;',
 "\xEE\xA1" => '&#38556;',
 "\xEE\xA2" => '&#20877;',
 "\xEE\xA3" => '&#21705;',
 "\xEE\xA4" => '&#22312;',
 "\xEE\xA5" => '&#23472;',
 "\xEE\xA6" => '&#25165;',
 "\xEE\xA7" => '&#26448;',
 "\xEE\xA8" => '&#26685;',
 "\xEE\xA9" => '&#26771;',
 "\xEE\xAA" => '&#28221;',
 "\xEE\xAB" => '&#28371;',
 "\xEE\xAC" => '&#28797;',
 "\xEE\xAD" => '&#32289;',
 "\xEE\xAE" => '&#35009;',
 "\xEE\xAF" => '&#36001;',
 "\xEE\xB0" => '&#36617;',
 "\xEE\xB1" => '&#40779;',
 "\xEE\xB2" => '&#40782;',
 "\xEE\xB3" => '&#29229;',
 "\xEE\xB4" => '&#31631;',
 "\xEE\xB5" => '&#35533;',
 "\xEE\xB6" => '&#37658;',
 "\xEE\xB7" => '&#20295;',
 "\xEE\xB8" => '&#20302;',
 "\xEE\xB9" => '&#20786;',
 "\xEE\xBA" => '&#21632;',
 "\xEE\xBB" => '&#22992;',
 "\xEE\xBC" => '&#24213;',
 "\xEE\xBD" => '&#25269;',
 "\xEE\xBE" => '&#26485;',
 "\xEE\xBF" => '&#26990;',
 "\xEE\xC0" => '&#27159;',
 "\xEE\xC1" => '&#27822;',
 "\xEE\xC2" => '&#28186;',
 "\xEE\xC3" => '&#29401;',
 "\xEE\xC4" => '&#29482;',
 "\xEE\xC5" => '&#30141;',
 "\xEE\xC6" => '&#31672;',
 "\xEE\xC7" => '&#32053;',
 "\xEE\xC8" => '&#33511;',
 "\xEE\xC9" => '&#33785;',
 "\xEE\xCA" => '&#33879;',
 "\xEE\xCB" => '&#34295;',
 "\xEE\xCC" => '&#35419;',
 "\xEE\xCD" => '&#36015;',
 "\xEE\xCE" => '&#36487;',
 "\xEE\xCF" => '&#36889;',
 "\xEE\xD0" => '&#37048;',
 "\xEE\xD1" => '&#38606;',
 "\xEE\xD2" => '&#40799;',
 "\xEE\xD3" => '&#21219;',
 "\xEE\xD4" => '&#21514;',
 "\xEE\xD5" => '&#23265;',
 "\xEE\xD6" => '&#23490;',
 "\xEE\xD7" => '&#25688;',
 "\xEE\xD8" => '&#25973;',
 "\xEE\xD9" => '&#28404;',
 "\xEE\xDA" => '&#29380;',
 "\xEE\xDB" => '&#63995;',
 "\xEE\xDC" => '&#30340;',
 "\xEE\xDD" => '&#31309;',
 "\xEE\xDE" => '&#31515;',
 "\xEE\xDF" => '&#31821;',
 "\xEE\xE0" => '&#32318;',
 "\xEE\xE1" => '&#32735;',
 "\xEE\xE2" => '&#33659;',
 "\xEE\xE3" => '&#35627;',
 "\xEE\xE4" => '&#36042;',
 "\xEE\xE5" => '&#36196;',
 "\xEE\xE6" => '&#36321;',
 "\xEE\xE7" => '&#36447;',
 "\xEE\xE8" => '&#36842;',
 "\xEE\xE9" => '&#36857;',
 "\xEE\xEA" => '&#36969;',
 "\xEE\xEB" => '&#37841;',
 "\xEE\xEC" => '&#20291;',
 "\xEE\xED" => '&#20346;',
 "\xEE\xEE" => '&#20659;',
 "\xEE\xEF" => '&#20840;',
 "\xEE\xF0" => '&#20856;',
 "\xEE\xF1" => '&#21069;',
 "\xEE\xF2" => '&#21098;',
 "\xEE\xF3" => '&#22625;',
 "\xEE\xF4" => '&#22652;',
 "\xEE\xF5" => '&#22880;',
 "\xEE\xF6" => '&#23560;',
 "\xEE\xF7" => '&#23637;',
 "\xEE\xF8" => '&#24283;',
 "\xEE\xF9" => '&#24731;',
 "\xEE\xFA" => '&#25136;',
 "\xEE\xFB" => '&#26643;',
 "\xEE\xFC" => '&#27583;',
 "\xEE\xFD" => '&#27656;',
 "\xEE\xFE" => '&#28593;',
 "\xEF\xA1" => '&#29006;',
 "\xEF\xA2" => '&#29728;',
 "\xEF\xA3" => '&#30000;',
 "\xEF\xA4" => '&#30008;',
 "\xEF\xA5" => '&#30033;',
 "\xEF\xA6" => '&#30322;',
 "\xEF\xA7" => '&#31564;',
 "\xEF\xA8" => '&#31627;',
 "\xEF\xA9" => '&#31661;',
 "\xEF\xAA" => '&#31686;',
 "\xEF\xAB" => '&#32399;',
 "\xEF\xAC" => '&#35438;',
 "\xEF\xAD" => '&#36670;',
 "\xEF\xAE" => '&#36681;',
 "\xEF\xAF" => '&#37439;',
 "\xEF\xB0" => '&#37523;',
 "\xEF\xB1" => '&#37666;',
 "\xEF\xB2" => '&#37931;',
 "\xEF\xB3" => '&#38651;',
 "\xEF\xB4" => '&#39002;',
 "\xEF\xB5" => '&#39019;',
 "\xEF\xB6" => '&#39198;',
 "\xEF\xB7" => '&#20999;',
 "\xEF\xB8" => '&#25130;',
 "\xEF\xB9" => '&#25240;',
 "\xEF\xBA" => '&#27993;',
 "\xEF\xBB" => '&#30308;',
 "\xEF\xBC" => '&#31434;',
 "\xEF\xBD" => '&#31680;',
 "\xEF\xBE" => '&#32118;',
 "\xEF\xBF" => '&#21344;',
 "\xEF\xC0" => '&#23742;',
 "\xEF\xC1" => '&#24215;',
 "\xEF\xC2" => '&#28472;',
 "\xEF\xC3" => '&#28857;',
 "\xEF\xC4" => '&#31896;',
 "\xEF\xC5" => '&#38673;',
 "\xEF\xC6" => '&#39822;',
 "\xEF\xC7" => '&#40670;',
 "\xEF\xC8" => '&#25509;',
 "\xEF\xC9" => '&#25722;',
 "\xEF\xCA" => '&#34678;',
 "\xEF\xCB" => '&#19969;',
 "\xEF\xCC" => '&#20117;',
 "\xEF\xCD" => '&#20141;',
 "\xEF\xCE" => '&#20572;',
 "\xEF\xCF" => '&#20597;',
 "\xEF\xD0" => '&#21576;',
 "\xEF\xD1" => '&#22979;',
 "\xEF\xD2" => '&#23450;',
 "\xEF\xD3" => '&#24128;',
 "\xEF\xD4" => '&#24237;',
 "\xEF\xD5" => '&#24311;',
 "\xEF\xD6" => '&#24449;',
 "\xEF\xD7" => '&#24773;',
 "\xEF\xD8" => '&#25402;',
 "\xEF\xD9" => '&#25919;',
 "\xEF\xDA" => '&#25972;',
 "\xEF\xDB" => '&#26060;',
 "\xEF\xDC" => '&#26230;',
 "\xEF\xDD" => '&#26232;',
 "\xEF\xDE" => '&#26622;',
 "\xEF\xDF" => '&#26984;',
 "\xEF\xE0" => '&#27273;',
 "\xEF\xE1" => '&#27491;',
 "\xEF\xE2" => '&#27712;',
 "\xEF\xE3" => '&#28096;',
 "\xEF\xE4" => '&#28136;',
 "\xEF\xE5" => '&#28191;',
 "\xEF\xE6" => '&#28254;',
 "\xEF\xE7" => '&#28702;',
 "\xEF\xE8" => '&#28833;',
 "\xEF\xE9" => '&#29582;',
 "\xEF\xEA" => '&#29693;',
 "\xEF\xEB" => '&#30010;',
 "\xEF\xEC" => '&#30555;',
 "\xEF\xED" => '&#30855;',
 "\xEF\xEE" => '&#31118;',
 "\xEF\xEF" => '&#31243;',
 "\xEF\xF0" => '&#31357;',
 "\xEF\xF1" => '&#31934;',
 "\xEF\xF2" => '&#32142;',
 "\xEF\xF3" => '&#33351;',
 "\xEF\xF4" => '&#35330;',
 "\xEF\xF5" => '&#35562;',
 "\xEF\xF6" => '&#35998;',
 "\xEF\xF7" => '&#37165;',
 "\xEF\xF8" => '&#37194;',
 "\xEF\xF9" => '&#37336;',
 "\xEF\xFA" => '&#37478;',
 "\xEF\xFB" => '&#37580;',
 "\xEF\xFC" => '&#37664;',
 "\xEF\xFD" => '&#38662;',
 "\xEF\xFE" => '&#38742;',
 "\xF0\xA1" => '&#38748;',
 "\xF0\xA2" => '&#38914;',
 "\xF0\xA3" => '&#40718;',
 "\xF0\xA4" => '&#21046;',
 "\xF0\xA5" => '&#21137;',
 "\xF0\xA6" => '&#21884;',
 "\xF0\xA7" => '&#22564;',
 "\xF0\xA8" => '&#24093;',
 "\xF0\xA9" => '&#24351;',
 "\xF0\xAA" => '&#24716;',
 "\xF0\xAB" => '&#25552;',
 "\xF0\xAC" => '&#26799;',
 "\xF0\xAD" => '&#28639;',
 "\xF0\xAE" => '&#31085;',
 "\xF0\xAF" => '&#31532;',
 "\xF0\xB0" => '&#33229;',
 "\xF0\xB1" => '&#34234;',
 "\xF0\xB2" => '&#35069;',
 "\xF0\xB3" => '&#35576;',
 "\xF0\xB4" => '&#36420;',
 "\xF0\xB5" => '&#37261;',
 "\xF0\xB6" => '&#38500;',
 "\xF0\xB7" => '&#38555;',
 "\xF0\xB8" => '&#38717;',
 "\xF0\xB9" => '&#38988;',
 "\xF0\xBA" => '&#40778;',
 "\xF0\xBB" => '&#20430;',
 "\xF0\xBC" => '&#20806;',
 "\xF0\xBD" => '&#20939;',
 "\xF0\xBE" => '&#21161;',
 "\xF0\xBF" => '&#22066;',
 "\xF0\xC0" => '&#24340;',
 "\xF0\xC1" => '&#24427;',
 "\xF0\xC2" => '&#25514;',
 "\xF0\xC3" => '&#25805;',
 "\xF0\xC4" => '&#26089;',
 "\xF0\xC5" => '&#26177;',
 "\xF0\xC6" => '&#26362;',
 "\xF0\xC7" => '&#26361;',
 "\xF0\xC8" => '&#26397;',
 "\xF0\xC9" => '&#26781;',
 "\xF0\xCA" => '&#26839;',
 "\xF0\xCB" => '&#27133;',
 "\xF0\xCC" => '&#28437;',
 "\xF0\xCD" => '&#28526;',
 "\xF0\xCE" => '&#29031;',
 "\xF0\xCF" => '&#29157;',
 "\xF0\xD0" => '&#29226;',
 "\xF0\xD1" => '&#29866;',
 "\xF0\xD2" => '&#30522;',
 "\xF0\xD3" => '&#31062;',
 "\xF0\xD4" => '&#31066;',
 "\xF0\xD5" => '&#31199;',
 "\xF0\xD6" => '&#31264;',
 "\xF0\xD7" => '&#31381;',
 "\xF0\xD8" => '&#31895;',
 "\xF0\xD9" => '&#31967;',
 "\xF0\xDA" => '&#32068;',
 "\xF0\xDB" => '&#32368;',
 "\xF0\xDC" => '&#32903;',
 "\xF0\xDD" => '&#34299;',
 "\xF0\xDE" => '&#34468;',
 "\xF0\xDF" => '&#35412;',
 "\xF0\xE0" => '&#35519;',
 "\xF0\xE1" => '&#36249;',
 "\xF0\xE2" => '&#36481;',
 "\xF0\xE3" => '&#36896;',
 "\xF0\xE4" => '&#36973;',
 "\xF0\xE5" => '&#37347;',
 "\xF0\xE6" => '&#38459;',
 "\xF0\xE7" => '&#38613;',
 "\xF0\xE8" => '&#40165;',
 "\xF0\xE9" => '&#26063;',
 "\xF0\xEA" => '&#31751;',
 "\xF0\xEB" => '&#36275;',
 "\xF0\xEC" => '&#37827;',
 "\xF0\xED" => '&#23384;',
 "\xF0\xEE" => '&#23562;',
 "\xF0\xEF" => '&#21330;',
 "\xF0\xF0" => '&#25305;',
 "\xF0\xF1" => '&#29469;',
 "\xF0\xF2" => '&#20519;',
 "\xF0\xF3" => '&#23447;',
 "\xF0\xF4" => '&#24478;',
 "\xF0\xF5" => '&#24752;',
 "\xF0\xF6" => '&#24939;',
 "\xF0\xF7" => '&#26837;',
 "\xF0\xF8" => '&#28121;',
 "\xF0\xF9" => '&#29742;',
 "\xF0\xFA" => '&#31278;',
 "\xF0\xFB" => '&#32066;',
 "\xF0\xFC" => '&#32156;',
 "\xF0\xFD" => '&#32305;',
 "\xF0\xFE" => '&#33131;',
 "\xF1\xA1" => '&#36394;',
 "\xF1\xA2" => '&#36405;',
 "\xF1\xA3" => '&#37758;',
 "\xF1\xA4" => '&#37912;',
 "\xF1\xA5" => '&#20304;',
 "\xF1\xA6" => '&#22352;',
 "\xF1\xA7" => '&#24038;',
 "\xF1\xA8" => '&#24231;',
 "\xF1\xA9" => '&#25387;',
 "\xF1\xAA" => '&#32618;',
 "\xF1\xAB" => '&#20027;',
 "\xF1\xAC" => '&#20303;',
 "\xF1\xAD" => '&#20367;',
 "\xF1\xAE" => '&#20570;',
 "\xF1\xAF" => '&#23005;',
 "\xF1\xB0" => '&#32964;',
 "\xF1\xB1" => '&#21610;',
 "\xF1\xB2" => '&#21608;',
 "\xF1\xB3" => '&#22014;',
 "\xF1\xB4" => '&#22863;',
 "\xF1\xB5" => '&#23449;',
 "\xF1\xB6" => '&#24030;',
 "\xF1\xB7" => '&#24282;',
 "\xF1\xB8" => '&#26205;',
 "\xF1\xB9" => '&#26417;',
 "\xF1\xBA" => '&#26609;',
 "\xF1\xBB" => '&#26666;',
 "\xF1\xBC" => '&#27880;',
 "\xF1\xBD" => '&#27954;',
 "\xF1\xBE" => '&#28234;',
 "\xF1\xBF" => '&#28557;',
 "\xF1\xC0" => '&#28855;',
 "\xF1\xC1" => '&#29664;',
 "\xF1\xC2" => '&#30087;',
 "\xF1\xC3" => '&#31820;',
 "\xF1\xC4" => '&#32002;',
 "\xF1\xC5" => '&#32044;',
 "\xF1\xC6" => '&#32162;',
 "\xF1\xC7" => '&#33311;',
 "\xF1\xC8" => '&#34523;',
 "\xF1\xC9" => '&#35387;',
 "\xF1\xCA" => '&#35461;',
 "\xF1\xCB" => '&#36208;',
 "\xF1\xCC" => '&#36490;',
 "\xF1\xCD" => '&#36659;',
 "\xF1\xCE" => '&#36913;',
 "\xF1\xCF" => '&#37198;',
 "\xF1\xD0" => '&#37202;',
 "\xF1\xD1" => '&#37956;',
 "\xF1\xD2" => '&#39376;',
 "\xF1\xD3" => '&#31481;',
 "\xF1\xD4" => '&#31909;',
 "\xF1\xD5" => '&#20426;',
 "\xF1\xD6" => '&#20737;',
 "\xF1\xD7" => '&#20934;',
 "\xF1\xD8" => '&#22472;',
 "\xF1\xD9" => '&#23535;',
 "\xF1\xDA" => '&#23803;',
 "\xF1\xDB" => '&#26201;',
 "\xF1\xDC" => '&#27197;',
 "\xF1\xDD" => '&#27994;',
 "\xF1\xDE" => '&#28310;',
 "\xF1\xDF" => '&#28652;',
 "\xF1\xE0" => '&#28940;',
 "\xF1\xE1" => '&#30063;',
 "\xF1\xE2" => '&#31459;',
 "\xF1\xE3" => '&#34850;',
 "\xF1\xE4" => '&#36897;',
 "\xF1\xE5" => '&#36981;',
 "\xF1\xE6" => '&#38603;',
 "\xF1\xE7" => '&#39423;',
 "\xF1\xE8" => '&#33537;',
 "\xF1\xE9" => '&#20013;',
 "\xF1\xEA" => '&#20210;',
 "\xF1\xEB" => '&#34886;',
 "\xF1\xEC" => '&#37325;',
 "\xF1\xED" => '&#21373;',
 "\xF1\xEE" => '&#27355;',
 "\xF1\xEF" => '&#26987;',
 "\xF1\xF0" => '&#27713;',
 "\xF1\xF1" => '&#33914;',
 "\xF1\xF2" => '&#22686;',
 "\xF1\xF3" => '&#24974;',
 "\xF1\xF4" => '&#26366;',
 "\xF1\xF5" => '&#25327;',
 "\xF1\xF6" => '&#28893;',
 "\xF1\xF7" => '&#29969;',
 "\xF1\xF8" => '&#30151;',
 "\xF1\xF9" => '&#32338;',
 "\xF1\xFA" => '&#33976;',
 "\xF1\xFB" => '&#35657;',
 "\xF1\xFC" => '&#36104;',
 "\xF1\xFD" => '&#20043;',
 "\xF1\xFE" => '&#21482;',
 "\xF2\xA1" => '&#21675;',
 "\xF2\xA2" => '&#22320;',
 "\xF2\xA3" => '&#22336;',
 "\xF2\xA4" => '&#24535;',
 "\xF2\xA5" => '&#25345;',
 "\xF2\xA6" => '&#25351;',
 "\xF2\xA7" => '&#25711;',
 "\xF2\xA8" => '&#25903;',
 "\xF2\xA9" => '&#26088;',
 "\xF2\xAA" => '&#26234;',
 "\xF2\xAB" => '&#26525;',
 "\xF2\xAC" => '&#26547;',
 "\xF2\xAD" => '&#27490;',
 "\xF2\xAE" => '&#27744;',
 "\xF2\xAF" => '&#27802;',
 "\xF2\xB0" => '&#28460;',
 "\xF2\xB1" => '&#30693;',
 "\xF2\xB2" => '&#30757;',
 "\xF2\xB3" => '&#31049;',
 "\xF2\xB4" => '&#31063;',
 "\xF2\xB5" => '&#32025;',
 "\xF2\xB6" => '&#32930;',
 "\xF2\xB7" => '&#33026;',
 "\xF2\xB8" => '&#33267;',
 "\xF2\xB9" => '&#33437;',
 "\xF2\xBA" => '&#33463;',
 "\xF2\xBB" => '&#34584;',
 "\xF2\xBC" => '&#35468;',
 "\xF2\xBD" => '&#63996;',
 "\xF2\xBE" => '&#36100;',
 "\xF2\xBF" => '&#36286;',
 "\xF2\xC0" => '&#36978;',
 "\xF2\xC1" => '&#30452;',
 "\xF2\xC2" => '&#31257;',
 "\xF2\xC3" => '&#31287;',
 "\xF2\xC4" => '&#32340;',
 "\xF2\xC5" => '&#32887;',
 "\xF2\xC6" => '&#21767;',
 "\xF2\xC7" => '&#21972;',
 "\xF2\xC8" => '&#22645;',
 "\xF2\xC9" => '&#25391;',
 "\xF2\xCA" => '&#25634;',
 "\xF2\xCB" => '&#26185;',
 "\xF2\xCC" => '&#26187;',
 "\xF2\xCD" => '&#26733;',
 "\xF2\xCE" => '&#27035;',
 "\xF2\xCF" => '&#27524;',
 "\xF2\xD0" => '&#27941;',
 "\xF2\xD1" => '&#28337;',
 "\xF2\xD2" => '&#29645;',
 "\xF2\xD3" => '&#29800;',
 "\xF2\xD4" => '&#29857;',
 "\xF2\xD5" => '&#30043;',
 "\xF2\xD6" => '&#30137;',
 "\xF2\xD7" => '&#30433;',
 "\xF2\xD8" => '&#30494;',
 "\xF2\xD9" => '&#30603;',
 "\xF2\xDA" => '&#31206;',
 "\xF2\xDB" => '&#32265;',
 "\xF2\xDC" => '&#32285;',
 "\xF2\xDD" => '&#33275;',
 "\xF2\xDE" => '&#34095;',
 "\xF2\xDF" => '&#34967;',
 "\xF2\xE0" => '&#35386;',
 "\xF2\xE1" => '&#36049;',
 "\xF2\xE2" => '&#36587;',
 "\xF2\xE3" => '&#36784;',
 "\xF2\xE4" => '&#36914;',
 "\xF2\xE5" => '&#37805;',
 "\xF2\xE6" => '&#38499;',
 "\xF2\xE7" => '&#38515;',
 "\xF2\xE8" => '&#38663;',
 "\xF2\xE9" => '&#20356;',
 "\xF2\xEA" => '&#21489;',
 "\xF2\xEB" => '&#23018;',
 "\xF2\xEC" => '&#23241;',
 "\xF2\xED" => '&#24089;',
 "\xF2\xEE" => '&#26702;',
 "\xF2\xEF" => '&#29894;',
 "\xF2\xF0" => '&#30142;',
 "\xF2\xF1" => '&#31209;',
 "\xF2\xF2" => '&#31378;',
 "\xF2\xF3" => '&#33187;',
 "\xF2\xF4" => '&#34541;',
 "\xF2\xF5" => '&#36074;',
 "\xF2\xF6" => '&#36300;',
 "\xF2\xF7" => '&#36845;',
 "\xF2\xF8" => '&#26015;',
 "\xF2\xF9" => '&#26389;',
 "\xF2\xFA" => '&#63997;',
 "\xF2\xFB" => '&#22519;',
 "\xF2\xFC" => '&#28503;',
 "\xF2\xFD" => '&#32221;',
 "\xF2\xFE" => '&#36655;',
 "\xF3\xA1" => '&#37878;',
 "\xF3\xA2" => '&#38598;',
 "\xF3\xA3" => '&#24501;',
 "\xF3\xA4" => '&#25074;',
 "\xF3\xA5" => '&#28548;',
 "\xF3\xA6" => '&#19988;',
 "\xF3\xA7" => '&#20376;',
 "\xF3\xA8" => '&#20511;',
 "\xF3\xA9" => '&#21449;',
 "\xF3\xAA" => '&#21983;',
 "\xF3\xAB" => '&#23919;',
 "\xF3\xAC" => '&#24046;',
 "\xF3\xAD" => '&#27425;',
 "\xF3\xAE" => '&#27492;',
 "\xF3\xAF" => '&#30923;',
 "\xF3\xB0" => '&#31642;',
 "\xF3\xB1" => '&#63998;',
 "\xF3\xB2" => '&#36425;',
 "\xF3\xB3" => '&#36554;',
 "\xF3\xB4" => '&#36974;',
 "\xF3\xB5" => '&#25417;',
 "\xF3\xB6" => '&#25662;',
 "\xF3\xB7" => '&#30528;',
 "\xF3\xB8" => '&#31364;',
 "\xF3\xB9" => '&#37679;',
 "\xF3\xBA" => '&#38015;',
 "\xF3\xBB" => '&#40810;',
 "\xF3\xBC" => '&#25776;',
 "\xF3\xBD" => '&#28591;',
 "\xF3\xBE" => '&#29158;',
 "\xF3\xBF" => '&#29864;',
 "\xF3\xC0" => '&#29914;',
 "\xF3\xC1" => '&#31428;',
 "\xF3\xC2" => '&#31762;',
 "\xF3\xC3" => '&#32386;',
 "\xF3\xC4" => '&#31922;',
 "\xF3\xC5" => '&#32408;',
 "\xF3\xC6" => '&#35738;',
 "\xF3\xC7" => '&#36106;',
 "\xF3\xC8" => '&#38013;',
 "\xF3\xC9" => '&#39184;',
 "\xF3\xCA" => '&#39244;',
 "\xF3\xCB" => '&#21049;',
 "\xF3\xCC" => '&#23519;',
 "\xF3\xCD" => '&#25830;',
 "\xF3\xCE" => '&#26413;',
 "\xF3\xCF" => '&#32046;',
 "\xF3\xD0" => '&#20717;',
 "\xF3\xD1" => '&#21443;',
 "\xF3\xD2" => '&#22649;',
 "\xF3\xD3" => '&#24920;',
 "\xF3\xD4" => '&#24921;',
 "\xF3\xD5" => '&#25082;',
 "\xF3\xD6" => '&#26028;',
 "\xF3\xD7" => '&#31449;',
 "\xF3\xD8" => '&#35730;',
 "\xF3\xD9" => '&#35734;',
 "\xF3\xDA" => '&#20489;',
 "\xF3\xDB" => '&#20513;',
 "\xF3\xDC" => '&#21109;',
 "\xF3\xDD" => '&#21809;',
 "\xF3\xDE" => '&#23100;',
 "\xF3\xDF" => '&#24288;',
 "\xF3\xE0" => '&#24432;',
 "\xF3\xE1" => '&#24884;',
 "\xF3\xE2" => '&#25950;',
 "\xF3\xE3" => '&#26124;',
 "\xF3\xE4" => '&#26166;',
 "\xF3\xE5" => '&#26274;',
 "\xF3\xE6" => '&#27085;',
 "\xF3\xE7" => '&#28356;',
 "\xF3\xE8" => '&#28466;',
 "\xF3\xE9" => '&#29462;',
 "\xF3\xEA" => '&#30241;',
 "\xF3\xEB" => '&#31379;',
 "\xF3\xEC" => '&#33081;',
 "\xF3\xED" => '&#33369;',
 "\xF3\xEE" => '&#33750;',
 "\xF3\xEF" => '&#33980;',
 "\xF3\xF0" => '&#20661;',
 "\xF3\xF1" => '&#22512;',
 "\xF3\xF2" => '&#23488;',
 "\xF3\xF3" => '&#23528;',
 "\xF3\xF4" => '&#24425;',
 "\xF3\xF5" => '&#25505;',
 "\xF3\xF6" => '&#30758;',
 "\xF3\xF7" => '&#32181;',
 "\xF3\xF8" => '&#33756;',
 "\xF3\xF9" => '&#34081;',
 "\xF3\xFA" => '&#37319;',
 "\xF3\xFB" => '&#37365;',
 "\xF3\xFC" => '&#20874;',
 "\xF3\xFD" => '&#26613;',
 "\xF3\xFE" => '&#31574;',
 "\xF4\xA1" => '&#36012;',
 "\xF4\xA2" => '&#20932;',
 "\xF4\xA3" => '&#22971;',
 "\xF4\xA4" => '&#24765;',
 "\xF4\xA5" => '&#34389;',
 "\xF4\xA6" => '&#20508;',
 "\xF4\xA7" => '&#63999;',
 "\xF4\xA8" => '&#21076;',
 "\xF4\xA9" => '&#23610;',
 "\xF4\xAA" => '&#24957;',
 "\xF4\xAB" => '&#25114;',
 "\xF4\xAC" => '&#25299;',
 "\xF4\xAD" => '&#25842;',
 "\xF4\xAE" => '&#26021;',
 "\xF4\xAF" => '&#28364;',
 "\xF4\xB0" => '&#30240;',
 "\xF4\xB1" => '&#33034;',
 "\xF4\xB2" => '&#36448;',
 "\xF4\xB3" => '&#38495;',
 "\xF4\xB4" => '&#38587;',
 "\xF4\xB5" => '&#20191;',
 "\xF4\xB6" => '&#21315;',
 "\xF4\xB7" => '&#21912;',
 "\xF4\xB8" => '&#22825;',
 "\xF4\xB9" => '&#24029;',
 "\xF4\xBA" => '&#25797;',
 "\xF4\xBB" => '&#27849;',
 "\xF4\xBC" => '&#28154;',
 "\xF4\xBD" => '&#29588;',
 "\xF4\xBE" => '&#31359;',
 "\xF4\xBF" => '&#33307;',
 "\xF4\xC0" => '&#34214;',
 "\xF4\xC1" => '&#36068;',
 "\xF4\xC2" => '&#36368;',
 "\xF4\xC3" => '&#36983;',
 "\xF4\xC4" => '&#37351;',
 "\xF4\xC5" => '&#38369;',
 "\xF4\xC6" => '&#38433;',
 "\xF4\xC7" => '&#38854;',
 "\xF4\xC8" => '&#20984;',
 "\xF4\xC9" => '&#21746;',
 "\xF4\xCA" => '&#21894;',
 "\xF4\xCB" => '&#24505;',
 "\xF4\xCC" => '&#25764;',
 "\xF4\xCD" => '&#28552;',
 "\xF4\xCE" => '&#32180;',
 "\xF4\xCF" => '&#36639;',
 "\xF4\xD0" => '&#36685;',
 "\xF4\xD1" => '&#37941;',
 "\xF4\xD2" => '&#20681;',
 "\xF4\xD3" => '&#23574;',
 "\xF4\xD4" => '&#27838;',
 "\xF4\xD5" => '&#28155;',
 "\xF4\xD6" => '&#29979;',
 "\xF4\xD7" => '&#30651;',
 "\xF4\xD8" => '&#31805;',
 "\xF4\xD9" => '&#31844;',
 "\xF4\xDA" => '&#35449;',
 "\xF4\xDB" => '&#35522;',
 "\xF4\xDC" => '&#22558;',
 "\xF4\xDD" => '&#22974;',
 "\xF4\xDE" => '&#24086;',
 "\xF4\xDF" => '&#25463;',
 "\xF4\xE0" => '&#29266;',
 "\xF4\xE1" => '&#30090;',
 "\xF4\xE2" => '&#30571;',
 "\xF4\xE3" => '&#35548;',
 "\xF4\xE4" => '&#36028;',
 "\xF4\xE5" => '&#36626;',
 "\xF4\xE6" => '&#24307;',
 "\xF4\xE7" => '&#26228;',
 "\xF4\xE8" => '&#28152;',
 "\xF4\xE9" => '&#32893;',
 "\xF4\xEA" => '&#33729;',
 "\xF4\xEB" => '&#35531;',
 "\xF4\xEC" => '&#38737;',
 "\xF4\xED" => '&#39894;',
 "\xF4\xEE" => '&#64000;',
 "\xF4\xEF" => '&#21059;',
 "\xF4\xF0" => '&#26367;',
 "\xF4\xF1" => '&#28053;',
 "\xF4\xF2" => '&#28399;',
 "\xF4\xF3" => '&#32224;',
 "\xF4\xF4" => '&#35558;',
 "\xF4\xF5" => '&#36910;',
 "\xF4\xF6" => '&#36958;',
 "\xF4\xF7" => '&#39636;',
 "\xF4\xF8" => '&#21021;',
 "\xF4\xF9" => '&#21119;',
 "\xF4\xFA" => '&#21736;',
 "\xF4\xFB" => '&#24980;',
 "\xF4\xFC" => '&#25220;',
 "\xF4\xFD" => '&#25307;',
 "\xF4\xFE" => '&#26786;',
 "\xF5\xA1" => '&#26898;',
 "\xF5\xA2" => '&#26970;',
 "\xF5\xA3" => '&#27189;',
 "\xF5\xA4" => '&#28818;',
 "\xF5\xA5" => '&#28966;',
 "\xF5\xA6" => '&#30813;',
 "\xF5\xA7" => '&#30977;',
 "\xF5\xA8" => '&#30990;',
 "\xF5\xA9" => '&#31186;',
 "\xF5\xAA" => '&#31245;',
 "\xF5\xAB" => '&#32918;',
 "\xF5\xAC" => '&#33400;',
 "\xF5\xAD" => '&#33493;',
 "\xF5\xAE" => '&#33609;',
 "\xF5\xAF" => '&#34121;',
 "\xF5\xB0" => '&#35970;',
 "\xF5\xB1" => '&#36229;',
 "\xF5\xB2" => '&#37218;',
 "\xF5\xB3" => '&#37259;',
 "\xF5\xB4" => '&#37294;',
 "\xF5\xB5" => '&#20419;',
 "\xF5\xB6" => '&#22225;',
 "\xF5\xB7" => '&#29165;',
 "\xF5\xB8" => '&#30679;',
 "\xF5\xB9" => '&#34560;',
 "\xF5\xBA" => '&#35320;',
 "\xF5\xBB" => '&#23544;',
 "\xF5\xBC" => '&#24534;',
 "\xF5\xBD" => '&#26449;',
 "\xF5\xBE" => '&#37032;',
 "\xF5\xBF" => '&#21474;',
 "\xF5\xC0" => '&#22618;',
 "\xF5\xC1" => '&#23541;',
 "\xF5\xC2" => '&#24740;',
 "\xF5\xC3" => '&#24961;',
 "\xF5\xC4" => '&#25696;',
 "\xF5\xC5" => '&#32317;',
 "\xF5\xC6" => '&#32880;',
 "\xF5\xC7" => '&#34085;',
 "\xF5\xC8" => '&#37507;',
 "\xF5\xC9" => '&#25774;',
 "\xF5\xCA" => '&#20652;',
 "\xF5\xCB" => '&#23828;',
 "\xF5\xCC" => '&#26368;',
 "\xF5\xCD" => '&#22684;',
 "\xF5\xCE" => '&#25277;',
 "\xF5\xCF" => '&#25512;',
 "\xF5\xD0" => '&#26894;',
 "\xF5\xD1" => '&#27000;',
 "\xF5\xD2" => '&#27166;',
 "\xF5\xD3" => '&#28267;',
 "\xF5\xD4" => '&#30394;',
 "\xF5\xD5" => '&#31179;',
 "\xF5\xD6" => '&#33467;',
 "\xF5\xD7" => '&#33833;',
 "\xF5\xD8" => '&#35535;',
 "\xF5\xD9" => '&#36264;',
 "\xF5\xDA" => '&#36861;',
 "\xF5\xDB" => '&#37138;',
 "\xF5\xDC" => '&#37195;',
 "\xF5\xDD" => '&#37276;',
 "\xF5\xDE" => '&#37648;',
 "\xF5\xDF" => '&#37656;',
 "\xF5\xE0" => '&#37786;',
 "\xF5\xE1" => '&#38619;',
 "\xF5\xE2" => '&#39478;',
 "\xF5\xE3" => '&#39949;',
 "\xF5\xE4" => '&#19985;',
 "\xF5\xE5" => '&#30044;',
 "\xF5\xE6" => '&#31069;',
 "\xF5\xE7" => '&#31482;',
 "\xF5\xE8" => '&#31569;',
 "\xF5\xE9" => '&#31689;',
 "\xF5\xEA" => '&#32302;',
 "\xF5\xEB" => '&#33988;',
 "\xF5\xEC" => '&#36441;',
 "\xF5\xED" => '&#36468;',
 "\xF5\xEE" => '&#36600;',
 "\xF5\xEF" => '&#36880;',
 "\xF5\xF0" => '&#26149;',
 "\xF5\xF1" => '&#26943;',
 "\xF5\xF2" => '&#29763;',
 "\xF5\xF3" => '&#20986;',
 "\xF5\xF4" => '&#26414;',
 "\xF5\xF5" => '&#40668;',
 "\xF5\xF6" => '&#20805;',
 "\xF5\xF7" => '&#24544;',
 "\xF5\xF8" => '&#27798;',
 "\xF5\xF9" => '&#34802;',
 "\xF5\xFA" => '&#34909;',
 "\xF5\xFB" => '&#34935;',
 "\xF5\xFC" => '&#24756;',
 "\xF5\xFD" => '&#33205;',
 "\xF5\xFE" => '&#33795;',
 "\xF6\xA1" => '&#36101;',
 "\xF6\xA2" => '&#21462;',
 "\xF6\xA3" => '&#21561;',
 "\xF6\xA4" => '&#22068;',
 "\xF6\xA5" => '&#23094;',
 "\xF6\xA6" => '&#23601;',
 "\xF6\xA7" => '&#28810;',
 "\xF6\xA8" => '&#32736;',
 "\xF6\xA9" => '&#32858;',
 "\xF6\xAA" => '&#33030;',
 "\xF6\xAB" => '&#33261;',
 "\xF6\xAC" => '&#36259;',
 "\xF6\xAD" => '&#37257;',
 "\xF6\xAE" => '&#39519;',
 "\xF6\xAF" => '&#40434;',
 "\xF6\xB0" => '&#20596;',
 "\xF6\xB1" => '&#20164;',
 "\xF6\xB2" => '&#21408;',
 "\xF6\xB3" => '&#24827;',
 "\xF6\xB4" => '&#28204;',
 "\xF6\xB5" => '&#23652;',
 "\xF6\xB6" => '&#20360;',
 "\xF6\xB7" => '&#20516;',
 "\xF6\xB8" => '&#21988;',
 "\xF6\xB9" => '&#23769;',
 "\xF6\xBA" => '&#24159;',
 "\xF6\xBB" => '&#24677;',
 "\xF6\xBC" => '&#26772;',
 "\xF6\xBD" => '&#27835;',
 "\xF6\xBE" => '&#28100;',
 "\xF6\xBF" => '&#29118;',
 "\xF6\xC0" => '&#30164;',
 "\xF6\xC1" => '&#30196;',
 "\xF6\xC2" => '&#30305;',
 "\xF6\xC3" => '&#31258;',
 "\xF6\xC4" => '&#31305;',
 "\xF6\xC5" => '&#32199;',
 "\xF6\xC6" => '&#32251;',
 "\xF6\xC7" => '&#32622;',
 "\xF6\xC8" => '&#33268;',
 "\xF6\xC9" => '&#34473;',
 "\xF6\xCA" => '&#36636;',
 "\xF6\xCB" => '&#38601;',
 "\xF6\xCC" => '&#39347;',
 "\xF6\xCD" => '&#40786;',
 "\xF6\xCE" => '&#21063;',
 "\xF6\xCF" => '&#21189;',
 "\xF6\xD0" => '&#39149;',
 "\xF6\xD1" => '&#35242;',
 "\xF6\xD2" => '&#19971;',
 "\xF6\xD3" => '&#26578;',
 "\xF6\xD4" => '&#28422;',
 "\xF6\xD5" => '&#20405;',
 "\xF6\xD6" => '&#23522;',
 "\xF6\xD7" => '&#26517;',
 "\xF6\xD8" => '&#27784;',
 "\xF6\xD9" => '&#28024;',
 "\xF6\xDA" => '&#29723;',
 "\xF6\xDB" => '&#30759;',
 "\xF6\xDC" => '&#37341;',
 "\xF6\xDD" => '&#37756;',
 "\xF6\xDE" => '&#34756;',
 "\xF6\xDF" => '&#31204;',
 "\xF6\xE0" => '&#31281;',
 "\xF6\xE1" => '&#24555;',
 "\xF6\xE2" => '&#20182;',
 "\xF6\xE3" => '&#21668;',
 "\xF6\xE4" => '&#21822;',
 "\xF6\xE5" => '&#22702;',
 "\xF6\xE6" => '&#22949;',
 "\xF6\xE7" => '&#24816;',
 "\xF6\xE8" => '&#25171;',
 "\xF6\xE9" => '&#25302;',
 "\xF6\xEA" => '&#26422;',
 "\xF6\xEB" => '&#26965;',
 "\xF6\xEC" => '&#33333;',
 "\xF6\xED" => '&#38464;',
 "\xF6\xEE" => '&#39345;',
 "\xF6\xEF" => '&#39389;',
 "\xF6\xF0" => '&#20524;',
 "\xF6\xF1" => '&#21331;',
 "\xF6\xF2" => '&#21828;',
 "\xF6\xF3" => '&#22396;',
 "\xF6\xF4" => '&#64001;',
 "\xF6\xF5" => '&#25176;',
 "\xF6\xF6" => '&#64002;',
 "\xF6\xF7" => '&#25826;',
 "\xF6\xF8" => '&#26219;',
 "\xF6\xF9" => '&#26589;',
 "\xF6\xFA" => '&#28609;',
 "\xF6\xFB" => '&#28655;',
 "\xF6\xFC" => '&#29730;',
 "\xF6\xFD" => '&#29752;',
 "\xF6\xFE" => '&#35351;',
 "\xF7\xA1" => '&#37944;',
 "\xF7\xA2" => '&#21585;',
 "\xF7\xA3" => '&#22022;',
 "\xF7\xA4" => '&#22374;',
 "\xF7\xA5" => '&#24392;',
 "\xF7\xA6" => '&#24986;',
 "\xF7\xA7" => '&#27470;',
 "\xF7\xA8" => '&#28760;',
 "\xF7\xA9" => '&#28845;',
 "\xF7\xAA" => '&#32187;',
 "\xF7\xAB" => '&#35477;',
 "\xF7\xAC" => '&#22890;',
 "\xF7\xAD" => '&#33067;',
 "\xF7\xAE" => '&#25506;',
 "\xF7\xAF" => '&#30472;',
 "\xF7\xB0" => '&#32829;',
 "\xF7\xB1" => '&#36010;',
 "\xF7\xB2" => '&#22612;',
 "\xF7\xB3" => '&#25645;',
 "\xF7\xB4" => '&#27067;',
 "\xF7\xB5" => '&#23445;',
 "\xF7\xB6" => '&#24081;',
 "\xF7\xB7" => '&#28271;',
 "\xF7\xB8" => '&#64003;',
 "\xF7\xB9" => '&#34153;',
 "\xF7\xBA" => '&#20812;',
 "\xF7\xBB" => '&#21488;',
 "\xF7\xBC" => '&#22826;',
 "\xF7\xBD" => '&#24608;',
 "\xF7\xBE" => '&#24907;',
 "\xF7\xBF" => '&#27526;',
 "\xF7\xC0" => '&#27760;',
 "\xF7\xC1" => '&#27888;',
 "\xF7\xC2" => '&#31518;',
 "\xF7\xC3" => '&#32974;',
 "\xF7\xC4" => '&#33492;',
 "\xF7\xC5" => '&#36294;',
 "\xF7\xC6" => '&#37040;',
 "\xF7\xC7" => '&#39089;',
 "\xF7\xC8" => '&#64004;',
 "\xF7\xC9" => '&#25799;',
 "\xF7\xCA" => '&#28580;',
 "\xF7\xCB" => '&#25745;',
 "\xF7\xCC" => '&#25860;',
 "\xF7\xCD" => '&#20814;',
 "\xF7\xCE" => '&#21520;',
 "\xF7\xCF" => '&#22303;',
 "\xF7\xD0" => '&#35342;',
 "\xF7\xD1" => '&#24927;',
 "\xF7\xD2" => '&#26742;',
 "\xF7\xD3" => '&#64005;',
 "\xF7\xD4" => '&#30171;',
 "\xF7\xD5" => '&#31570;',
 "\xF7\xD6" => '&#32113;',
 "\xF7\xD7" => '&#36890;',
 "\xF7\xD8" => '&#22534;',
 "\xF7\xD9" => '&#27084;',
 "\xF7\xDA" => '&#33151;',
 "\xF7\xDB" => '&#35114;',
 "\xF7\xDC" => '&#36864;',
 "\xF7\xDD" => '&#38969;',
 "\xF7\xDE" => '&#20600;',
 "\xF7\xDF" => '&#22871;',
 "\xF7\xE0" => '&#22956;',
 "\xF7\xE1" => '&#25237;',
 "\xF7\xE2" => '&#36879;',
 "\xF7\xE3" => '&#39722;',
 "\xF7\xE4" => '&#24925;',
 "\xF7\xE5" => '&#29305;',
 "\xF7\xE6" => '&#38358;',
 "\xF7\xE7" => '&#22369;',
 "\xF7\xE8" => '&#23110;',
 "\xF7\xE9" => '&#24052;',
 "\xF7\xEA" => '&#25226;',
 "\xF7\xEB" => '&#25773;',
 "\xF7\xEC" => '&#25850;',
 "\xF7\xED" => '&#26487;',
 "\xF7\xEE" => '&#27874;',
 "\xF7\xEF" => '&#27966;',
 "\xF7\xF0" => '&#29228;',
 "\xF7\xF1" => '&#29750;',
 "\xF7\xF2" => '&#30772;',
 "\xF7\xF3" => '&#32631;',
 "\xF7\xF4" => '&#33453;',
 "\xF7\xF5" => '&#36315;',
 "\xF7\xF6" => '&#38935;',
 "\xF7\xF7" => '&#21028;',
 "\xF7\xF8" => '&#22338;',
 "\xF7\xF9" => '&#26495;',
 "\xF7\xFA" => '&#29256;',
 "\xF7\xFB" => '&#29923;',
 "\xF7\xFC" => '&#36009;',
 "\xF7\xFD" => '&#36774;',
 "\xF7\xFE" => '&#37393;',
 "\xF8\xA1" => '&#38442;',
 "\xF8\xA2" => '&#20843;',
 "\xF8\xA3" => '&#21485;',
 "\xF8\xA4" => '&#25420;',
 "\xF8\xA5" => '&#20329;',
 "\xF8\xA6" => '&#21764;',
 "\xF8\xA7" => '&#24726;',
 "\xF8\xA8" => '&#25943;',
 "\xF8\xA9" => '&#27803;',
 "\xF8\xAA" => '&#28031;',
 "\xF8\xAB" => '&#29260;',
 "\xF8\xAC" => '&#29437;',
 "\xF8\xAD" => '&#31255;',
 "\xF8\xAE" => '&#35207;',
 "\xF8\xAF" => '&#35997;',
 "\xF8\xB0" => '&#24429;',
 "\xF8\xB1" => '&#28558;',
 "\xF8\xB2" => '&#28921;',
 "\xF8\xB3" => '&#33192;',
 "\xF8\xB4" => '&#24846;',
 "\xF8\xB5" => '&#20415;',
 "\xF8\xB6" => '&#20559;',
 "\xF8\xB7" => '&#25153;',
 "\xF8\xB8" => '&#29255;',
 "\xF8\xB9" => '&#31687;',
 "\xF8\xBA" => '&#32232;',
 "\xF8\xBB" => '&#32745;',
 "\xF8\xBC" => '&#36941;',
 "\xF8\xBD" => '&#38829;',
 "\xF8\xBE" => '&#39449;',
 "\xF8\xBF" => '&#36022;',
 "\xF8\xC0" => '&#22378;',
 "\xF8\xC1" => '&#24179;',
 "\xF8\xC2" => '&#26544;',
 "\xF8\xC3" => '&#33805;',
 "\xF8\xC4" => '&#35413;',
 "\xF8\xC5" => '&#21536;',
 "\xF8\xC6" => '&#23318;',
 "\xF8\xC7" => '&#24163;',
 "\xF8\xC8" => '&#24290;',
 "\xF8\xC9" => '&#24330;',
 "\xF8\xCA" => '&#25987;',
 "\xF8\xCB" => '&#32954;',
 "\xF8\xCC" => '&#34109;',
 "\xF8\xCD" => '&#38281;',
 "\xF8\xCE" => '&#38491;',
 "\xF8\xCF" => '&#20296;',
 "\xF8\xD0" => '&#21253;',
 "\xF8\xD1" => '&#21261;',
 "\xF8\xD2" => '&#21263;',
 "\xF8\xD3" => '&#21638;',
 "\xF8\xD4" => '&#21754;',
 "\xF8\xD5" => '&#22275;',
 "\xF8\xD6" => '&#24067;',
 "\xF8\xD7" => '&#24598;',
 "\xF8\xD8" => '&#25243;',
 "\xF8\xD9" => '&#25265;',
 "\xF8\xDA" => '&#25429;',
 "\xF8\xDB" => '&#64006;',
 "\xF8\xDC" => '&#27873;',
 "\xF8\xDD" => '&#28006;',
 "\xF8\xDE" => '&#30129;',
 "\xF8\xDF" => '&#30770;',
 "\xF8\xE0" => '&#32990;',
 "\xF8\xE1" => '&#33071;',
 "\xF8\xE2" => '&#33502;',
 "\xF8\xE3" => '&#33889;',
 "\xF8\xE4" => '&#33970;',
 "\xF8\xE5" => '&#34957;',
 "\xF8\xE6" => '&#35090;',
 "\xF8\xE7" => '&#36875;',
 "\xF8\xE8" => '&#37610;',
 "\xF8\xE9" => '&#39165;',
 "\xF8\xEA" => '&#39825;',
 "\xF8\xEB" => '&#24133;',
 "\xF8\xEC" => '&#26292;',
 "\xF8\xED" => '&#26333;',
 "\xF8\xEE" => '&#28689;',
 "\xF8\xEF" => '&#29190;',
 "\xF8\xF0" => '&#64007;',
 "\xF8\xF1" => '&#20469;',
 "\xF8\xF2" => '&#21117;',
 "\xF8\xF3" => '&#24426;',
 "\xF8\xF4" => '&#24915;',
 "\xF8\xF5" => '&#26451;',
 "\xF8\xF6" => '&#27161;',
 "\xF8\xF7" => '&#28418;',
 "\xF8\xF8" => '&#29922;',
 "\xF8\xF9" => '&#31080;',
 "\xF8\xFA" => '&#34920;',
 "\xF8\xFB" => '&#35961;',
 "\xF8\xFC" => '&#39111;',
 "\xF8\xFD" => '&#39108;',
 "\xF8\xFE" => '&#39491;',
 "\xF9\xA1" => '&#21697;',
 "\xF9\xA2" => '&#31263;',
 "\xF9\xA3" => '&#26963;',
 "\xF9\xA4" => '&#35575;',
 "\xF9\xA5" => '&#35914;',
 "\xF9\xA6" => '&#39080;',
 "\xF9\xA7" => '&#39342;',
 "\xF9\xA8" => '&#24444;',
 "\xF9\xA9" => '&#25259;',
 "\xF9\xAA" => '&#30130;',
 "\xF9\xAB" => '&#30382;',
 "\xF9\xAC" => '&#34987;',
 "\xF9\xAD" => '&#36991;',
 "\xF9\xAE" => '&#38466;',
 "\xF9\xAF" => '&#21305;',
 "\xF9\xB0" => '&#24380;',
 "\xF9\xB1" => '&#24517;',
 "\xF9\xB2" => '&#27852;',
 "\xF9\xB3" => '&#29644;',
 "\xF9\xB4" => '&#30050;',
 "\xF9\xB5" => '&#30091;',
 "\xF9\xB6" => '&#31558;',
 "\xF9\xB7" => '&#33534;',
 "\xF9\xB8" => '&#39325;',
 "\xF9\xB9" => '&#20047;',
 "\xF9\xBA" => '&#36924;',
 "\xF9\xBB" => '&#19979;',
 "\xF9\xBC" => '&#20309;',
 "\xF9\xBD" => '&#21414;',
 "\xF9\xBE" => '&#22799;',
 "\xF9\xBF" => '&#24264;',
 "\xF9\xC0" => '&#26160;',
 "\xF9\xC1" => '&#27827;',
 "\xF9\xC2" => '&#29781;',
 "\xF9\xC3" => '&#33655;',
 "\xF9\xC4" => '&#34662;',
 "\xF9\xC5" => '&#36032;',
 "\xF9\xC6" => '&#36944;',
 "\xF9\xC7" => '&#38686;',
 "\xF9\xC8" => '&#39957;',
 "\xF9\xC9" => '&#22737;',
 "\xF9\xCA" => '&#23416;',
 "\xF9\xCB" => '&#34384;',
 "\xF9\xCC" => '&#35604;',
 "\xF9\xCD" => '&#40372;',
 "\xF9\xCE" => '&#23506;',
 "\xF9\xCF" => '&#24680;',
 "\xF9\xD0" => '&#24717;',
 "\xF9\xD1" => '&#26097;',
 "\xF9\xD2" => '&#27735;',
 "\xF9\xD3" => '&#28450;',
 "\xF9\xD4" => '&#28579;',
 "\xF9\xD5" => '&#28698;',
 "\xF9\xD6" => '&#32597;',
 "\xF9\xD7" => '&#32752;',
 "\xF9\xD8" => '&#38289;',
 "\xF9\xD9" => '&#38290;',
 "\xF9\xDA" => '&#38480;',
 "\xF9\xDB" => '&#38867;',
 "\xF9\xDC" => '&#21106;',
 "\xF9\xDD" => '&#36676;',
 "\xF9\xDE" => '&#20989;',
 "\xF9\xDF" => '&#21547;',
 "\xF9\xE0" => '&#21688;',
 "\xF9\xE1" => '&#21859;',
 "\xF9\xE2" => '&#21898;',
 "\xF9\xE3" => '&#27323;',
 "\xF9\xE4" => '&#28085;',
 "\xF9\xE5" => '&#32216;',
 "\xF9\xE6" => '&#33382;',
 "\xF9\xE7" => '&#37532;',
 "\xF9\xE8" => '&#38519;',
 "\xF9\xE9" => '&#40569;',
 "\xF9\xEA" => '&#21512;',
 "\xF9\xEB" => '&#21704;',
 "\xF9\xEC" => '&#30418;',
 "\xF9\xED" => '&#34532;',
 "\xF9\xEE" => '&#38308;',
 "\xF9\xEF" => '&#38356;',
 "\xF9\xF0" => '&#38492;',
 "\xF9\xF1" => '&#20130;',
 "\xF9\xF2" => '&#20233;',
 "\xF9\xF3" => '&#23022;',
 "\xF9\xF4" => '&#23270;',
 "\xF9\xF5" => '&#24055;',
 "\xF9\xF6" => '&#24658;',
 "\xF9\xF7" => '&#25239;',
 "\xF9\xF8" => '&#26477;',
 "\xF9\xF9" => '&#26689;',
 "\xF9\xFA" => '&#27782;',
 "\xF9\xFB" => '&#28207;',
 "\xF9\xFC" => '&#32568;',
 "\xF9\xFD" => '&#32923;',
 "\xF9\xFE" => '&#33322;',
 "\xFA\xA1" => '&#64008;',
 "\xFA\xA2" => '&#64009;',
 "\xFA\xA3" => '&#38917;',
 "\xFA\xA4" => '&#20133;',
 "\xFA\xA5" => '&#20565;',
 "\xFA\xA6" => '&#21683;',
 "\xFA\xA7" => '&#22419;',
 "\xFA\xA8" => '&#22874;',
 "\xFA\xA9" => '&#23401;',
 "\xFA\xAA" => '&#23475;',
 "\xFA\xAB" => '&#25032;',
 "\xFA\xAC" => '&#26999;',
 "\xFA\xAD" => '&#28023;',
 "\xFA\xAE" => '&#28707;',
 "\xFA\xAF" => '&#34809;',
 "\xFA\xB0" => '&#35299;',
 "\xFA\xB1" => '&#35442;',
 "\xFA\xB2" => '&#35559;',
 "\xFA\xB3" => '&#36994;',
 "\xFA\xB4" => '&#39405;',
 "\xFA\xB5" => '&#39608;',
 "\xFA\xB6" => '&#21182;',
 "\xFA\xB7" => '&#26680;',
 "\xFA\xB8" => '&#20502;',
 "\xFA\xB9" => '&#24184;',
 "\xFA\xBA" => '&#26447;',
 "\xFA\xBB" => '&#33607;',
 "\xFA\xBC" => '&#34892;',
 "\xFA\xBD" => '&#20139;',
 "\xFA\xBE" => '&#21521;',
 "\xFA\xBF" => '&#22190;',
 "\xFA\xC0" => '&#29670;',
 "\xFA\xC1" => '&#37141;',
 "\xFA\xC2" => '&#38911;',
 "\xFA\xC3" => '&#39177;',
 "\xFA\xC4" => '&#39255;',
 "\xFA\xC5" => '&#39321;',
 "\xFA\xC6" => '&#22099;',
 "\xFA\xC7" => '&#22687;',
 "\xFA\xC8" => '&#34395;',
 "\xFA\xC9" => '&#35377;',
 "\xFA\xCA" => '&#25010;',
 "\xFA\xCB" => '&#27382;',
 "\xFA\xCC" => '&#29563;',
 "\xFA\xCD" => '&#36562;',
 "\xFA\xCE" => '&#27463;',
 "\xFA\xCF" => '&#38570;',
 "\xFA\xD0" => '&#39511;',
 "\xFA\xD1" => '&#22869;',
 "\xFA\xD2" => '&#29184;',
 "\xFA\xD3" => '&#36203;',
 "\xFA\xD4" => '&#38761;',
 "\xFA\xD5" => '&#20436;',
 "\xFA\xD6" => '&#23796;',
 "\xFA\xD7" => '&#24358;',
 "\xFA\xD8" => '&#25080;',
 "\xFA\xD9" => '&#26203;',
 "\xFA\xDA" => '&#27883;',
 "\xFA\xDB" => '&#28843;',
 "\xFA\xDC" => '&#29572;',
 "\xFA\xDD" => '&#29625;',
 "\xFA\xDE" => '&#29694;',
 "\xFA\xDF" => '&#30505;',
 "\xFA\xE0" => '&#30541;',
 "\xFA\xE1" => '&#32067;',
 "\xFA\xE2" => '&#32098;',
 "\xFA\xE3" => '&#32291;',
 "\xFA\xE4" => '&#33335;',
 "\xFA\xE5" => '&#34898;',
 "\xFA\xE6" => '&#64010;',
 "\xFA\xE7" => '&#36066;',
 "\xFA\xE8" => '&#37449;',
 "\xFA\xE9" => '&#39023;',
 "\xFA\xEA" => '&#23377;',
 "\xFA\xEB" => '&#31348;',
 "\xFA\xEC" => '&#34880;',
 "\xFA\xED" => '&#38913;',
 "\xFA\xEE" => '&#23244;',
 "\xFA\xEF" => '&#20448;',
 "\xFA\xF0" => '&#21332;',
 "\xFA\xF1" => '&#22846;',
 "\xFA\xF2" => '&#23805;',
 "\xFA\xF3" => '&#25406;',
 "\xFA\xF4" => '&#28025;',
 "\xFA\xF5" => '&#29433;',
 "\xFA\xF6" => '&#33029;',
 "\xFA\xF7" => '&#33031;',
 "\xFA\xF8" => '&#33698;',
 "\xFA\xF9" => '&#37583;',
 "\xFA\xFA" => '&#38960;',
 "\xFA\xFB" => '&#20136;',
 "\xFA\xFC" => '&#20804;',
 "\xFA\xFD" => '&#21009;',
 "\xFA\xFE" => '&#22411;',
 "\xFB\xA1" => '&#24418;',
 "\xFB\xA2" => '&#27842;',
 "\xFB\xA3" => '&#28366;',
 "\xFB\xA4" => '&#28677;',
 "\xFB\xA5" => '&#28752;',
 "\xFB\xA6" => '&#28847;',
 "\xFB\xA7" => '&#29074;',
 "\xFB\xA8" => '&#29673;',
 "\xFB\xA9" => '&#29801;',
 "\xFB\xAA" => '&#33610;',
 "\xFB\xAB" => '&#34722;',
 "\xFB\xAC" => '&#34913;',
 "\xFB\xAD" => '&#36872;',
 "\xFB\xAE" => '&#37026;',
 "\xFB\xAF" => '&#37795;',
 "\xFB\xB0" => '&#39336;',
 "\xFB\xB1" => '&#20846;',
 "\xFB\xB2" => '&#24407;',
 "\xFB\xB3" => '&#24800;',
 "\xFB\xB4" => '&#24935;',
 "\xFB\xB5" => '&#26291;',
 "\xFB\xB6" => '&#34137;',
 "\xFB\xB7" => '&#36426;',
 "\xFB\xB8" => '&#37295;',
 "\xFB\xB9" => '&#38795;',
 "\xFB\xBA" => '&#20046;',
 "\xFB\xBB" => '&#20114;',
 "\xFB\xBC" => '&#21628;',
 "\xFB\xBD" => '&#22741;',
 "\xFB\xBE" => '&#22778;',
 "\xFB\xBF" => '&#22909;',
 "\xFB\xC0" => '&#23733;',
 "\xFB\xC1" => '&#24359;',
 "\xFB\xC2" => '&#25142;',
 "\xFB\xC3" => '&#25160;',
 "\xFB\xC4" => '&#26122;',
 "\xFB\xC5" => '&#26215;',
 "\xFB\xC6" => '&#27627;',
 "\xFB\xC7" => '&#28009;',
 "\xFB\xC8" => '&#28111;',
 "\xFB\xC9" => '&#28246;',
 "\xFB\xCA" => '&#28408;',
 "\xFB\xCB" => '&#28564;',
 "\xFB\xCC" => '&#28640;',
 "\xFB\xCD" => '&#28649;',
 "\xFB\xCE" => '&#28765;',
 "\xFB\xCF" => '&#29392;',
 "\xFB\xD0" => '&#29733;',
 "\xFB\xD1" => '&#29786;',
 "\xFB\xD2" => '&#29920;',
 "\xFB\xD3" => '&#30355;',
 "\xFB\xD4" => '&#31068;',
 "\xFB\xD5" => '&#31946;',
 "\xFB\xD6" => '&#32286;',
 "\xFB\xD7" => '&#32993;',
 "\xFB\xD8" => '&#33446;',
 "\xFB\xD9" => '&#33899;',
 "\xFB\xDA" => '&#33983;',
 "\xFB\xDB" => '&#34382;',
 "\xFB\xDC" => '&#34399;',
 "\xFB\xDD" => '&#34676;',
 "\xFB\xDE" => '&#35703;',
 "\xFB\xDF" => '&#35946;',
 "\xFB\xE0" => '&#37804;',
 "\xFB\xE1" => '&#38912;',
 "\xFB\xE2" => '&#39013;',
 "\xFB\xE3" => '&#24785;',
 "\xFB\xE4" => '&#25110;',
 "\xFB\xE5" => '&#37239;',
 "\xFB\xE6" => '&#23130;',
 "\xFB\xE7" => '&#26127;',
 "\xFB\xE8" => '&#28151;',
 "\xFB\xE9" => '&#28222;',
 "\xFB\xEA" => '&#29759;',
 "\xFB\xEB" => '&#39746;',
 "\xFB\xEC" => '&#24573;',
 "\xFB\xED" => '&#24794;',
 "\xFB\xEE" => '&#31503;',
 "\xFB\xEF" => '&#21700;',
 "\xFB\xF0" => '&#24344;',
 "\xFB\xF1" => '&#27742;',
 "\xFB\xF2" => '&#27859;',
 "\xFB\xF3" => '&#27946;',
 "\xFB\xF4" => '&#28888;',
 "\xFB\xF5" => '&#32005;',
 "\xFB\xF6" => '&#34425;',
 "\xFB\xF7" => '&#35340;',
 "\xFB\xF8" => '&#40251;',
 "\xFB\xF9" => '&#21270;',
 "\xFB\xFA" => '&#21644;',
 "\xFB\xFB" => '&#23301;',
 "\xFB\xFC" => '&#27194;',
 "\xFB\xFD" => '&#28779;',
 "\xFB\xFE" => '&#30069;',
 "\xFC\xA1" => '&#31117;',
 "\xFC\xA2" => '&#31166;',
 "\xFC\xA3" => '&#33457;',
 "\xFC\xA4" => '&#33775;',
 "\xFC\xA5" => '&#35441;',
 "\xFC\xA6" => '&#35649;',
 "\xFC\xA7" => '&#36008;',
 "\xFC\xA8" => '&#38772;',
 "\xFC\xA9" => '&#64011;',
 "\xFC\xAA" => '&#25844;',
 "\xFC\xAB" => '&#25899;',
 "\xFC\xAC" => '&#30906;',
 "\xFC\xAD" => '&#30907;',
 "\xFC\xAE" => '&#31339;',
 "\xFC\xAF" => '&#20024;',
 "\xFC\xB0" => '&#21914;',
 "\xFC\xB1" => '&#22864;',
 "\xFC\xB2" => '&#23462;',
 "\xFC\xB3" => '&#24187;',
 "\xFC\xB4" => '&#24739;',
 "\xFC\xB5" => '&#25563;',
 "\xFC\xB6" => '&#27489;',
 "\xFC\xB7" => '&#26213;',
 "\xFC\xB8" => '&#26707;',
 "\xFC\xB9" => '&#28185;',
 "\xFC\xBA" => '&#29029;',
 "\xFC\xBB" => '&#29872;',
 "\xFC\xBC" => '&#32008;',
 "\xFC\xBD" => '&#36996;',
 "\xFC\xBE" => '&#39529;',
 "\xFC\xBF" => '&#39973;',
 "\xFC\xC0" => '&#27963;',
 "\xFC\xC1" => '&#28369;',
 "\xFC\xC2" => '&#29502;',
 "\xFC\xC3" => '&#35905;',
 "\xFC\xC4" => '&#38346;',
 "\xFC\xC5" => '&#20976;',
 "\xFC\xC6" => '&#24140;',
 "\xFC\xC7" => '&#24488;',
 "\xFC\xC8" => '&#24653;',
 "\xFC\xC9" => '&#24822;',
 "\xFC\xCA" => '&#24880;',
 "\xFC\xCB" => '&#24908;',
 "\xFC\xCC" => '&#26179;',
 "\xFC\xCD" => '&#26180;',
 "\xFC\xCE" => '&#27045;',
 "\xFC\xCF" => '&#27841;',
 "\xFC\xD0" => '&#28255;',
 "\xFC\xD1" => '&#28361;',
 "\xFC\xD2" => '&#28514;',
 "\xFC\xD3" => '&#29004;',
 "\xFC\xD4" => '&#29852;',
 "\xFC\xD5" => '&#30343;',
 "\xFC\xD6" => '&#31681;',
 "\xFC\xD7" => '&#31783;',
 "\xFC\xD8" => '&#33618;',
 "\xFC\xD9" => '&#34647;',
 "\xFC\xDA" => '&#36945;',
 "\xFC\xDB" => '&#38541;',
 "\xFC\xDC" => '&#40643;',
 "\xFC\xDD" => '&#21295;',
 "\xFC\xDE" => '&#22238;',
 "\xFC\xDF" => '&#24315;',
 "\xFC\xE0" => '&#24458;',
 "\xFC\xE1" => '&#24674;',
 "\xFC\xE2" => '&#24724;',
 "\xFC\xE3" => '&#25079;',
 "\xFC\xE4" => '&#26214;',
 "\xFC\xE5" => '&#26371;',
 "\xFC\xE6" => '&#27292;',
 "\xFC\xE7" => '&#28142;',
 "\xFC\xE8" => '&#28590;',
 "\xFC\xE9" => '&#28784;',
 "\xFC\xEA" => '&#29546;',
 "\xFC\xEB" => '&#32362;',
 "\xFC\xEC" => '&#33214;',
 "\xFC\xED" => '&#33588;',
 "\xFC\xEE" => '&#34516;',
 "\xFC\xEF" => '&#35496;',
 "\xFC\xF0" => '&#36036;',
 "\xFC\xF1" => '&#21123;',
 "\xFC\xF2" => '&#29554;',
 "\xFC\xF3" => '&#23446;',
 "\xFC\xF4" => '&#27243;',
 "\xFC\xF5" => '&#37892;',
 "\xFC\xF6" => '&#21742;',
 "\xFC\xF7" => '&#22150;',
 "\xFC\xF8" => '&#23389;',
 "\xFC\xF9" => '&#25928;',
 "\xFC\xFA" => '&#25989;',
 "\xFC\xFB" => '&#26313;',
 "\xFC\xFC" => '&#26783;',
 "\xFC\xFD" => '&#28045;',
 "\xFC\xFE" => '&#28102;',
 "\xFD\xA1" => '&#29243;',
 "\xFD\xA2" => '&#32948;',
 "\xFD\xA3" => '&#37237;',
 "\xFD\xA4" => '&#39501;',
 "\xFD\xA5" => '&#20399;',
 "\xFD\xA6" => '&#20505;',
 "\xFD\xA7" => '&#21402;',
 "\xFD\xA8" => '&#21518;',
 "\xFD\xA9" => '&#21564;',
 "\xFD\xAA" => '&#21897;',
 "\xFD\xAB" => '&#21957;',
 "\xFD\xAC" => '&#24127;',
 "\xFD\xAD" => '&#24460;',
 "\xFD\xAE" => '&#26429;',
 "\xFD\xAF" => '&#29030;',
 "\xFD\xB0" => '&#29661;',
 "\xFD\xB1" => '&#36869;',
 "\xFD\xB2" => '&#21211;',
 "\xFD\xB3" => '&#21235;',
 "\xFD\xB4" => '&#22628;',
 "\xFD\xB5" => '&#22734;',
 "\xFD\xB6" => '&#28932;',
 "\xFD\xB7" => '&#29071;',
 "\xFD\xB8" => '&#29179;',
 "\xFD\xB9" => '&#34224;',
 "\xFD\xBA" => '&#35347;',
 "\xFD\xBB" => '&#26248;',
 "\xFD\xBC" => '&#34216;',
 "\xFD\xBD" => '&#21927;',
 "\xFD\xBE" => '&#26244;',
 "\xFD\xBF" => '&#29002;',
 "\xFD\xC0" => '&#33841;',
 "\xFD\xC1" => '&#21321;',
 "\xFD\xC2" => '&#21913;',
 "\xFD\xC3" => '&#27585;',
 "\xFD\xC4" => '&#24409;',
 "\xFD\xC5" => '&#24509;',
 "\xFD\xC6" => '&#25582;',
 "\xFD\xC7" => '&#26249;',
 "\xFD\xC8" => '&#28999;',
 "\xFD\xC9" => '&#35569;',
 "\xFD\xCA" => '&#36637;',
 "\xFD\xCB" => '&#40638;',
 "\xFD\xCC" => '&#20241;',
 "\xFD\xCD" => '&#25658;',
 "\xFD\xCE" => '&#28875;',
 "\xFD\xCF" => '&#30054;',
 "\xFD\xD0" => '&#34407;',
 "\xFD\xD1" => '&#24676;',
 "\xFD\xD2" => '&#35662;',
 "\xFD\xD3" => '&#40440;',
 "\xFD\xD4" => '&#20807;',
 "\xFD\xD5" => '&#20982;',
 "\xFD\xD6" => '&#21256;',
 "\xFD\xD7" => '&#27958;',
 "\xFD\xD8" => '&#33016;',
 "\xFD\xD9" => '&#40657;',
 "\xFD\xDA" => '&#26133;',
 "\xFD\xDB" => '&#27427;',
 "\xFD\xDC" => '&#28824;',
 "\xFD\xDD" => '&#30165;',
 "\xFD\xDE" => '&#21507;',
 "\xFD\xDF" => '&#23673;',
 "\xFD\xE0" => '&#32007;',
 "\xFD\xE1" => '&#35350;',
 "\xFD\xE2" => '&#27424;',
 "\xFD\xE3" => '&#27453;',
 "\xFD\xE4" => '&#27462;',
 "\xFD\xE5" => '&#21560;',
 "\xFD\xE6" => '&#24688;',
 "\xFD\xE7" => '&#27965;',
 "\xFD\xE8" => '&#32725;',
 "\xFD\xE9" => '&#33288;',
 "\xFD\xEA" => '&#20694;',
 "\xFD\xEB" => '&#20958;',
 "\xFD\xEC" => '&#21916;',
 "\xFD\xED" => '&#22123;',
 "\xFD\xEE" => '&#22221;',
 "\xFD\xEF" => '&#23020;',
 "\xFD\xF0" => '&#23305;',
 "\xFD\xF1" => '&#24076;',
 "\xFD\xF2" => '&#24985;',
 "\xFD\xF3" => '&#24984;',
 "\xFD\xF4" => '&#25137;',
 "\xFD\xF5" => '&#26206;',
 "\xFD\xF6" => '&#26342;',
 "\xFD\xF7" => '&#29081;',
 "\xFD\xF8" => '&#29113;',
 "\xFD\xF9" => '&#29114;',
 "\xFD\xFA" => '&#29351;',
 "\xFD\xFB" => '&#31143;',
 "\xFD\xFC" => '&#31232;',
 "\xFD\xFD" => '&#32690;',
 "\xFD\xFE" => '&#35440;');


    $index=0;
    $ret='';

    while ( $index < strlen($string)) {
      if ( preg_match('/[\200-\237]|\240|[\241-\375]/', $string[$index])) {
        $ret.= str_replace(array_keys($cp949), array_values($cp949), $string[$index] . $string[$index+1]);
        $index=$index+2;
      } else {
        $ret.= $string[$index];
        $index=$index+1;
      }
    }

    return $ret;
}

?>