from unittest import makeSuite,TestSuite

from base import SquishdotBase, PlainBase, Demo2Base

from Products.Squishdot import manage_addSquishdot
from Products.PluginIndexes.FieldIndex.FieldIndex import FieldIndex
from Products.PluginIndexes.TextIndex.TextIndex import TextIndex

class SquishSiteTests(SquishdotBase):

    def testCreation1(self):
        "Test Squishdot Site creation using Fancy Demo 1"
        pass

    def testIndexes(self):
        "Test the correct indexes are created"
        mapping = {
            'meta_type':FieldIndex,
            'author':FieldIndex,
            'textToSearch':TextIndex,
            'subject':FieldIndex,
            'reviewed':FieldIndex,
            'date':FieldIndex,
            'title':TextIndex,
            }
        for index in self.Site.index_objects():
            id = index.getId()
            self.failUnless(mapping.has_key(id),'Unexpected index:'+id)
            self.failUnless(isinstance(index,mapping[id]))
            del mapping[id]

        self.failIf(mapping,'Indexes not found:'+`mapping`)

    def testMetadata(self):
        "Test the correct metadata columns are created"
        actual = self.Site.schema()
        actual.sort()
        expected = ['summary','date_posted','id','title','reply_cnt','author','thread_path','date']
        expected.sort()
        self.assertEqual(actual,expected)

    def testCreation2(self):
        "Test Squishdot Site creation using Fancy Demo 2"
        manage_addSquishdot(self.Folder,'testSquish2',default_doc='demo2')

    def testCreation3(self):
        "Test Squishdot Site creation using Plain Demo"
        manage_addSquishdot(self.Folder,'testSquish3',default_doc='plain')

    def testRender1(self):
        "Test Render Method doesn't wrap in <html></html> when doing STX"
        html = self.Site.render([''],'STX')
        assert html=='' or html=='<p>\012<TABLE BORDER=1 CELLPADDING=2>\012</TABLE></p>',`html`

    def testRender2(self):
        "Test 2 for Render Method doesn't wrap in <html></html> when doing STX"
        html = self.Site.render(['test'],'STX')
        assert html=='<p>test</p>' or html=='<p>test</p>\n',`html`

    def testManageEdit (self):
        "test mange_edit works when called not TTW"
        self.Site.manage_edit(0,0,'articles',30)

    def testUnmoderatedPostings1 (self):
        "test unmoderated_postings works when a reply is posted and moderation is enabled"
        # put us into "articles moderated" mode
        S= self.Site
        S.manage_edit(0,0,'articles',30)
        # check there aren't any unmoderated articles
        assert not S.unmoderated_postings()
        # post an article
        self._addPosting(title    = 'testSquishSiteAddPosting',
                         author   = 'tester',
                         body     = 'body',
                         email    = 'email',
                         notify   = 1,
                         encoding = 'Plain',
                         subject  = 'test subject',
                         summary  = 'summary',
                         dept     = 'dept')
        # check there are now unoderated articles
        assert S.unmoderated_postings()
        # post an reply
        parent = self._getPosting()
        id = self._addPosting(object   = parent,
                              title    = 'testArticleAddPosting',
                              author   = 'tester',
                              body     = 'body',
                              email    = 'email',
                              notify   = 1,
                              encoding = 'Plain')
        # check there are still unoderated articles
        assert S.unmoderated_postings()
        
    def testRecatalogPostings(self):
        "test recatalogPostings doesn't barf"
        # NB: This dosn't actually check it does it's job properly ;-)
        S= self.Site
        # post a reply
        parent = self._getPosting()
        id = self._addPosting(object   = parent,
                              title    = 'testArticleAddPosting',
                              author   = 'tester',
                              body     = 'body',
                              email    = 'email',
                              notify   = 1,
                              encoding = 'Plain')
        S.recatalogPostings()

    def testDeleteItems(self):
        "test delete of articles and comments works"
        S= self.Site
        # post a reply
        parent = self._getPosting()
        id = self._addPosting(object   = parent,
                              title    = 'testArticleAddPosting',
                              author   = 'tester',
                              body     = 'body',
                              email    = 'email',
                              notify   = 1,
                              encoding = 'Plain')
        parent_id = parent.id
        
        # delete the reply
        S.delItem(int(id))
        # check we can't traverse to it
        try:
            p = S[parent_id][id]
        except KeyError:
            pass
        else:
            self.fail('Comment not deleted')
            
        # delete the article
        S.delItem(int(parent_id))
        # check we can't traverse to it
        try:
            p = S[parent_id]
        except KeyError:
            pass
        else:
            self.fail('Article not deleted')
        
    def testPreviewPosting(self):
        "Check that previewPosting doesnt barf"
        self.Site.previewPosting(self.Site,self.Site.REQUEST)

    def testManageReview(self):
        """
        Test that manage_review works when there's a posting to review
        """
        # put us into "articles and replies moderated" mode
        S= self.Site
        S.manage_edit(0,0,'both',30)
        # post an reply
        parent = self._getPosting()
        id = self._addPosting(object   = parent,
                              title    = 'testArticleAddPosting',
                              author   = 'tester',
                              body     = 'body',
                              email    = 'email',
                              notify   = 1,
                              encoding = 'Plain')
        # check there are unmoderated replies
        assert S.unmoderated_postings()
        # moderate using manage_review
        S.manage_review(ids=[`id`])
        # check there are now no unmoderated replies
        assert not S.unmoderated_postings()
    
class SquishSiteDemo2Tests(Demo2Base):

    def testCreation(self):
        "Test Squishdot Site creation using Fancy Demo 2"
        pass
    
    def testPreviewPosting(self):
        "Check that previewPosting doesnt barf"
        self.Site.previewPosting(self.Site,self.Site.REQUEST)

class SquishSitePlainTests(PlainBase):

    def testCreation(self):
        "Test Squishdot Site creation using Plain Demo"
        pass

    def testPreviewPosting(self):
        "Check that previewPosting doesnt barf"
        self.Site.previewPosting(self.Site,self.Site.REQUEST)

def test_suite():
    return TestSuite((
        makeSuite(SquishSiteTests),
        makeSuite(SquishSiteDemo2Tests),
        makeSuite(SquishSitePlainTests),
        ))

def debug():
   test_suite().debug()
    
