// StarPlot - A program for interactively viewing 3D maps of stellar positions.
// Copyright (C) 2000  Kevin B. McCarty
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


#ifndef _STARPLOT_H
#define _STARPLOT_H

#include <gtk/gtk.h>
#include <cmath>
#include <cstdio>
#include <cstdlib>
using namespace std;

#include "../classes/stararray.h"
#include "gtkviewer.h"
#include "menu.h"

#ifndef DATADIR // it should be defined in this directory's Makefile
#define DATADIR "/usr/local/share/starplot"
#endif

#ifndef DOCDIR // likewise
#define DOCDIR "/usr/local/share/doc/starplot"
#endif

#define DEGREES  * M_PI_180
#define HOURS    * M_PI_12


// Default program values

const unsigned int STARPLOT_WIDTH  = 550;
const unsigned int STARPLOT_HEIGHT = 500;

const StringList DEFAULT_FILENAMES =
	StringList(DATADIR "/examples/sample.stars"); 
	// DATADIR is defined in Makefile

const Vector     DEFAULT_CENTER      = Vector(0,0,0);
const SolidAngle DEFAULT_ORIENTATION = SolidAngle(21 HOURS, +30 DEGREES);
const double     DEFAULT_RADIUS      = 10 /* light-years */;
const float      DEFAULT_DIM_MAG     = +25;
const float      DEFAULT_BRIGHT_MAG  = -25;
const bool       DEFAULT_AUTOSET_MAG = true; /* automatically set dim magnitude
						limit as a fn. of radius? */
const bool       DEFAULT_MODE        = true; /* celestial coordinates */

// If you edit the following, you also must reorder the menu items in
//  menuops.cc so that this default is the first of the starlabel menu
//  items.  Otherwise the initial toggle setting will not match this default.
const Diametertype DEFAULT_DIAMETERS = MAGNITUDE_DIAMETERS;
const Labeltype  DEFAULT_SHOW_LABELS = LANDMARK_LABEL;

/* default star filter: show all star classes */
const bool       DEFAULT_SHOW_CLASSES[10] =  { true, true, true, true, true,
	                                       true, true, true, true, true };

const bool       DEFAULT_SHOW_BARS   = true;
const bool       DEFAULT_SHOW_GRID   = true;
const bool       DEFAULT_SHOW_LEGEND = true;

const Rules initrules = Rules(DEFAULT_FILENAMES, 
			      DEFAULT_CENTER,
			      DEFAULT_ORIENTATION,
			      DEFAULT_RADIUS, 
			      DEFAULT_DIM_MAG, 
			      DEFAULT_BRIGHT_MAG,
			      DEFAULT_AUTOSET_MAG,
			      DEFAULT_SHOW_CLASSES,
			      DEFAULT_MODE, 
			      DEFAULT_DIAMETERS,
			      DEFAULT_SHOW_LABELS,
			      DEFAULT_SHOW_BARS, 
			      DEFAULT_SHOW_GRID,
			      DEFAULT_SHOW_LEGEND
                             );

const unsigned int BUTTONWIDTH = 75;  // global default value for size
const unsigned int BUTTONHEIGHT = 22; //  of OK / Cancel buttons

const unsigned int HR_WIDTH  = 480;
const unsigned int HR_HEIGHT = 360;
const double HR_BRIGHT_MAG = -8;
const double HR_DIM_MAG    = +12;


// Button bar callbacks, defined in menuops.cc

extern void button_zoom(GtkWidget *w, gpointer zoomfactor);
extern void button_rotate(GtkWidget *w, gpointer angle);
extern void button_tilt(GtkWidget *w, gpointer angle);
extern void button_magchange(GtkWidget *w, gpointer magchange);


// Useful adjunct functions

extern bool read_rc_file();
extern bool write_rc_file();
extern void help_select_and_open();
extern double automagnitude (double radius);
extern void my_gtk_star_popup (Star &);
extern void my_gtk_main_menu (GtkWidget *window, GtkWidget **menubar);
extern void my_gtk_push_buttons (GtkWidget *window, GtkWidget **buttonbar);
extern void my_gtk_button_bar (GtkWidget **OKbtn, GtkWidget **Defaultsbtn,
			       GtkWidget **Cancelbtn, GtkWidget *box);
extern void my_gtk_buttons_connect_destroy (GtkWidget *btn1, GtkWidget *btn2,
					    GtkWidget *btn3, GtkWidget *win);
extern void hr_redraw_display(GtkWidget *hr_display);
extern void update_info(GtkWidget *info_clist);
extern void redraw_all (Changetype);


// Functions to set menu toggle/radio buttons

template<class T> extern void 
set_item(T *, T, GtkWidget *, bool, Changetype = DECORATIONS_CHANGE);
extern void flip_toggle_item(bool *, int, bool);
extern void set_toggle_item(bool *, bool, int, bool);
extern void set_label_item(Labeltype, bool);
extern void set_diameter_item(Diametertype, bool);
extern void set_coord_item(bool, bool);


// Various global variables which need to be shared across object files

extern Rules starrules;              // By default set equal to initrules
extern StarArray *stararray;         // The StarArray used by StarPlot
extern GTKViewer *viewer;            // The GTKViewer used by StarPlot
extern GtkWidget *drawing_area;      // The GTK_DRAWING_AREA used
extern GtkWidget *statusline;        // status text at bottom of window

extern GTKViewer *hr_viewer;         // HR Diagram GTKViewer
extern GtkWidget *hr_drawing_area;   // HR Diagram GTK_DRAWING_AREA
extern double hr_brightmag, hr_dimmag; // magnitude bounds of HR diagram viewer

extern GtkWidget *info_clist;        // Chart Data list of stars
extern char *help_browser;           // default help browser

#endif // #include _STARPLOT_H
