
/* $Id: filedata.c,v 201.0 2002/02/14 09:29:14 sgifford Exp $ */

#include "filedata.h"
#include "phonebook.h"
#include "startalk.h"

#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <ctype.h>

struct startalk_phonebook_entry *
startalk_get_phonebook_entry_from_file(FILE *f)
{
  char buf[8192];
  char *c;
  char *val;
  int othertype;
  
  struct startalk_phonebook_entry *pbe;

  pbe = startalk_new_phonebook_entry();
  while (fgets(buf, 8191, f))
  {
    buf[8191] = 0;
    if ( buf[0] == '#' )
    {
      continue;
    }
    if ( (c=strchr(buf,'\n')) != 0)
      *c = '\0';

    if ( (buf[0] == 0) ) /* Blank line */
    {
      return pbe;
    }
    else if (strncasecmp(buf,"position:",9)==0)
    {
      val=startalk_cleanup_from_file(buf+9);
      pbe->pos=atoi(val);
    }
    else if (strncasecmp(buf,"name:",5)==0)
    {
      val=startalk_cleanup_from_file(buf+5);
      strncpy(pbe->name, val, 12);
      pbe->name[12]=0;
    }
    else if (strncasecmp(buf,"company:",8)==0)
    {
      val=startalk_cleanup_from_file(buf+8);
      strncpy(pbe->company, val, 12);
      pbe->company[12]=0;
    }
    else if (strncasecmp(buf,"phone-",6)==0)
    {
      if (strncasecmp(buf+6,"office:",7)==0)
      {
        val=startalk_cleanup_from_file(buf+13);
        startalk_add_phone_to_entry(pbe, STARTALK_PHONETYPE_OFFICE, val);
      }
      else if (strncasecmp(buf+6,"home:",5)==0)
      {
        val=startalk_cleanup_from_file(buf+11);
        startalk_add_phone_to_entry(pbe, STARTALK_PHONETYPE_HOME, val);
      }
      else if (strncasecmp(buf+6,"mobile:",7)==0)
      {
        val=startalk_cleanup_from_file(buf+13);
        startalk_add_phone_to_entry(pbe, STARTALK_PHONETYPE_MOBILE, val);
      }
      else if (strncasecmp(buf+6,"pager:",6)==0)
      {
        val=startalk_cleanup_from_file(buf+12);
        startalk_add_phone_to_entry(pbe, STARTALK_PHONETYPE_PAGER, val);
      }
      else if (strncasecmp(buf+6,"fax:",4)==0)
      {
        val=startalk_cleanup_from_file(buf+10);
        startalk_add_phone_to_entry(pbe, STARTALK_PHONETYPE_FAX, val);
      }
      else if (strncasecmp(buf+6,"qmark:",6)==0)
      {
        val=startalk_cleanup_from_file(buf+12);
        startalk_add_phone_to_entry(pbe, STARTALK_PHONETYPE_QMARK, val);
      }
      else if ((strncasecmp(buf+6,"other",5)==0) &&
               ( (buf[11] >= '0') && (buf[11] <= '9') ) &&
               buf[12] == ':' )
      {
        val=startalk_cleanup_from_file(buf+13);
        othertype = buf[11] - '0';
        startalk_add_phone_to_entry(pbe, othertype, val);
      }
      else
      {
        fprintf(stderr,"Warning: Unknown phone number type in '%s'\n",buf);
      }
    }
    else
    {
      fprintf(stderr, "Warning: Unknown attribute in '%s'\n",buf);
    }
  }
  startalk_delete_phonebook_entry(pbe);
  return NULL;
}

char *
startalk_cleanup_from_file(char *in)
{
  char *r;

  /* Remove whitespace from the end . . . */
  r=strchr(in,'\0')-1;
  while ( (r >= in) && isspace(*r) )
  {
    *r='\0';
    r--;
  }

  /* . . . And the beginning. */
  r=in;
  while (isspace(*r))
  {
    r++;
  }

  return r;
}
