package net.sf.statcvs.pages;

import net.sf.statcvs.charts.ChartImage;
import net.sf.statcvs.charts.LOCChartMaker.MainLOCChartMaker;
import net.sf.statcvs.output.ReportConfig;

public class LOCPageMaker {
    private final ReportConfig config;

    public LOCPageMaker(final ReportConfig config) {
        this.config = config;
    }

    public NavigationNode toFile() {
        final ChartImage chart = new MainLOCChartMaker(this.config, "loc.png", this.config.getLargeChartSize()).toFile();

        final Page result = config.createPage("loc", "Lines of Code", "Lines of Code");
        result.addAttribute("Total Lines of Code", this.config.getRepository().getCurrentLOC());
        result.addAttribute("Most Recent Commit", this.config.getRepository().getLastDate());
        result.add(chart);
        return result;
    }
}
