mapping read_config(string cfg_data, string rtag)
{
    if ( !stringp(cfg_data) || strlen(cfg_data) == 0 )
	return 0;
    
    Parser.XML.Tree.Node node = Parser.XML.Tree.parse_input(cfg_data);
    
    if ( !objectp(node) )
	error("Failed to parse data.");
    
    mapping conf = ([ ]); 
    
    node = node->get_first_element(rtag);
    foreach(node->get_elements(), Parser.XML.Tree.Node n) { 
      string t = n->get_tag_name();
      string val = n->get_last_child()->get_text();
      if ( stringp(conf[t]) )
	conf[t] = ({ conf[t], val });
      else if ( arrayp(conf[t]) )
	conf[t] += ({ val });
      else
	conf[n->get_tag_name()] = val;
    }
    return conf;
}

