# -*- perl -*-

#
#   Copyright (C) Heinz-Josef Claes (2002)
#                 hjclaes@web.de
#   
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#   
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#   
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#


push @VERSION, '$Id: splitLine.pl,v 1.1 2002/06/14 12:35:40 hjc Exp $ ';


use strict;



sub splitLine
{
    my $line = shift;
    my $length = shift;
    my $pattern = shift;

    my @ret;
    while (1)
    {
	if (length($line) <= $length)
	{
	    push @ret, $line;
	    return @ret;
	}
	# Zeile ist zu lang
	my $begin = substr($line, 0, $length);
	$line = substr($line, $length);

	if ($line =~ /^$pattern/)  # falls neue Zeile genau mit Pattern anfngt
	{
	    push @ret, $begin;
	    $line =~ s/^($pattern)//;   # Blanks o.. vorne lschen
	    next;
	}

	# $begin zerteilen
	my ($a, $b) = $begin =~ /^(.*)$pattern(.*)$/;
	if ($a)
	{
	    push @ret, $a;
	    $line = $b . $line;
	}
	else     # das erste Wort ist zu lang, einfach durchschneiden
	{
	    push @ret, $begin;
	}
    }
}
