/*
 * Storm Package Manager
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#define _GNU_SOURCE

#include <sys/types.h>
#include <sys/time.h>
#include <signal.h>
#include <string.h>
#include <pthread.h>

#include "../libstormpkg/libstormpkg_app_include.h"

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <gtk/gtk.h>
#include <stdlib.h>

#include "interface.h"
#include "support.h"
#include "main.h"

#include "stormpkg.h"

GtkWidget *main_window;
GtkWidget *filter_window;
GtkWidget *dependency_window;
GtkWidget *apply_changes_window;
GtkWidget *sources_window;
GtkWidget *msg_window;
GtkWidget *pwd_window;
GtkWidget *msg_dlg;
GtkWidget *help_window;

GdkColor *unchanged_foreground_color;
GdkColor *changed_foreground_color;
GdkColor *unchanged_background_color;
GdkColor *new_background_color;
GdkColor *install_background_color;
GdkColor *uninstall_background_color;
GdkColor *purge_background_color;
GdkColor *hold_background_color;
GdkColor *find_background_color;

static void get_color (char *cpp, GdkColor **colp){
   GdkColor *new_color;
   static GdkColorContext *color_context = NULL;
   int result;
   gint status;

   if (!color_context){
      color_context = gdk_color_context_new(gtk_widget_get_default_visual(),
                                            gtk_widget_get_default_colormap());
   }

   new_color = g_new (GdkColor, 1);
   result = gdk_color_parse (cpp, new_color);
   new_color->pixel = 0;

   if (result) {
      status = 0;
      gdk_color_context_get_pixel(color_context,
                                  new_color->red,new_color->green,new_color->blue,
                                  &status);
   } else
      new_color->red = new_color->green = new_color->blue = 0;

   *colp = new_color;
}



void start_main(){
    main_window = create_main_window();
    filter_window = create_filter_window();
    dependency_window = create_dependency_window();
    apply_changes_window = create_apply_changes_window();
    sources_window = create_sources_window();
    help_window = create_help_window();
//    gtk_window_set_transient_for((GtkWindow*)find_window, (GtkWindow*)main_window);

    populate_package_tree_search("",true,0,0);
    if   (msg_dlg_exit)  return;
    gtk_widget_show(main_window);
//    main_window_visible = 1;
    gray_buttons(1);
    gray_buttons(0);

    gtk_widget_show(filter_window);
    set_statusbar(main_window,_("Initializing..."));
    }

int main (int argc,char *argv[]){
//   jmp_buf ejbuf; 

   bindtextdomain (PACKAGE, GNOMELOCALEDIR);
   textdomain (PACKAGE);

   gnome_init("stormpkg", VERSION, argc, argv);

   unchanged_foreground_color = NULL;
   get_color("#000000",&changed_foreground_color);
   unchanged_background_color = NULL;
   get_color("#ffffaa",&new_background_color);
   get_color("#ccffcc",&install_background_color);
   get_color("#ffddbb",&uninstall_background_color);
   get_color("#ffcccc",&purge_background_color);
   get_color("#ccccff",&hold_background_color);
   get_color("#ffff00",&find_background_color);

   /*
    * The following code was added by Glade to create one of each component
    * (except popup menus), just so that you see something after building
    * the project. Delete any components that you don't want shown initially.
    */
    msg_dlg = create_msg_dlg ();

    uid_t myuid;
    myuid=getuid();
    if (myuid==0){
        start_main();
        }
    else {
        fprintf(stderr, _("Err: You should run stormpkg as root!\n"));
        MsgDlg(_("Err: You should run stormpkg as root!\n"), 1, 1);
//        MsgDlg(_("Err: You should run stormpkg as root!\n"), 1, 1);
//        return 1;
        }

   gtk_main();
//   error_unwind(ehflag_normaltidy);
   return 0;
}
