#! /usr/bin/perl -w
##
##	prepare.pl
##
##	Last modified: 25/01/02
##	
##	The modifies a copy of wartool.c to allow it to fit into WarTool's
##	Mac OS X wrapper.
##
##	Remember to use "chmod +x prepare.sh" before running this
##	script. 
##
##	This script is distributed as part of the FreeCraft software package 
##	and is therefore subject to the GNU General Public License.

## Read in wartool.c
open(WARTOOLSRC, "../../tools/wartool.c") || die("\"wartool.c\" could not be opened. This utility cannot proceed as a result.\n");
@wartoollns = <WARTOOLSRC>;
close(WARTOOLSRC);

## Create wartool.m for writing
open(WARTOOLDEST, ">wartool.m") || die("\"wartool.m\" could be created. This utility cannot proceed as a result.\n");

## Copy accross changes
foreach $cur_line (@wartoollns) {
	
	## Change int main to int wartool
	$cur_line =~ s/int\s*main/int wartool/;
	
	## Remove all __attribute__((unused))
	while ($cur_line =~ s/__attribute__\(\(unused\)\)//) { };
	
	## Print line to file 
	unless ($cur_line =~ /#undef\s*main/) {
		if ($cur_line =~ /#include\s*"freecraft/) {
			print WARTOOLDEST "extern id warController;\n\n";
		}
		if ($cur_line =~ /if\s*\(\s*UseMacCd/) {
			printf WARTOOLDEST "\t[warController progress];\n";
		}
		if ($cur_line =~ /#include\s*<stdio\.h>/) {
			printf WARTOOLDEST "#include <WarController\.h>\n";
		}
		if ($cur_line =~ /\/alamo.pud\"/) {
			printf WARTOOLDEST "\t[warController setMaxProgress:sizeof(Todo)/sizeof(*Todo)];\n";
		}
		unless ($cur_line =~ /_C_/ || $cur_line =~ /\bprintf\b/ || $cur_line =~ /\bDebugLevel[1-3]\b/ || $cur_line =~ /\bDebugLevel[1-3]Fn\b/) {
			print WARTOOLDEST $cur_line;
		}
		if ($cur_line =~ /\bprintf\s*\(\s*\"wartool/) {
			print WARTOOLDEST $cur_line;
		}
	}
}

## Close the wartool.m file
close(WARTOOLDEST);