/* This file is part of Strigi Desktop Search
 *
 * Copyright (C) 2006 Jos van den Oever <jos@vandenoever.info>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */
#include "qt3strigirunner.h"
#include <qprocess.h>
#include <qfileinfo.h>
#include <qapplication.h>
#include <qtimer.h>

Qt3StrigiRunner::Qt3StrigiRunner(QObject*parent) :QObject(parent) {
    // default to clucene for now
    backend = "clucene";
    process = 0;
}
Qt3StrigiRunner::~Qt3StrigiRunner() {
    stop();
}
void
Qt3StrigiRunner::stop() {
    if (process) {
        process->tryTerminate();
        QTimer::singleShot( 5000, process, SLOT( kill() ) );
        process = 0;
    }
}
void
Qt3StrigiRunner::startStrigi() {
    stop();
    
    // try to start the daemon
    QFileInfo exe(qApp->applicationDirPath() + "/../../daemon/strigidaemon");
    QString app;
    if (exe.exists()) {
	// start not installed version
        app = exe.absFilePath();
    } else {
        // check the same directory as this application
        exe = qApp->applicationDirPath()+"/strigidaemon";
        if (exe.exists()) {
            app = exe.absFilePath();
        } else {
            // not found yet, hope it is in the path
            app = "strigidaemon";
        }
    }
    
    QProcess* process = new QProcess(this);
    process->addArgument(app);
    process->addArgument(backend);
    process->start();
}
