/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_DIFF_SUMMARIZE_LVI_H
#define _SC_DIFF_SUMMARIZE_LVI_H

// sc
#include "svn/DiffSummarizeTypes.h"

// qt
#include <qlistview.h>


class DiffSummarizeLvi : public QListViewItem
{
  typedef QListViewItem super;

public:
  DiffSummarizeLvi( QListView* parent, svn::DiffSummarizePtr summarize );
  virtual ~DiffSummarizeLvi();

  QString text( int column ) const;
  QString key( int column, bool ascending ) const;
  int compare( QListViewItem * i, int col, bool ascending ) const;

  svn::DiffSummarizePtr getDiffSummarize() const;

private:
  svn::DiffSummarizePtr _summarize;
};

#endif // _SC_DIFF_SUMMARIZE_LVI_H
