/* ====================================================================
 * Copyright (c) 2006,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_LOGDATA_H
#define _SC_LOGDATA_H

// sc
#include "util/String.h"


namespace Log
{
  enum Type
  {
    Started  = 0x01,
    Running  = 0x02,
    Stopped  = 0x04,
    Canceled = 0x08,
    Time     = 0x10,
    Error    = 0x20
  };
};

class LogData
{
public:
  LogData( unsigned long id, unsigned long type,
    const sc::String& action, const sc::String& state, const sc::String& message )
    : _id(id), _type(type), _action(action), _state(state), _message(message)
  {
  }

  unsigned long getId() const
  {
    return _id;
  }

  unsigned long getType() const
  {
    return _type;
  }

  const sc::String& getAction() const
  {
    return _action;
  }

  const sc::String& getState() const
  {
    return _state;
  }

  const sc::String& getMsg() const
  {
    return _message;
  }

  bool isStart() const
  {
    return (_type & Log::Started) == Log::Started;
  }

  bool isStop() const
  {
    return (_type & Log::Stopped) == Log::Stopped;
  }

  bool isRunning() const
  {
    return (_type & Log::Running) == Log::Running;
  }

  bool isTime() const
  {
    return (_type & Log::Time) == Log::Time;
  }

  bool isError() const
  {
    return (_type & Log::Error) == Log::Error;
  }

private:
  unsigned long _id;
  unsigned long _type;
  sc::String _action;
  sc::String _state;
  sc::String _message;
};


#endif // _SC_LOGDATA_H
