/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_LOGDIALOG_H
#define _SC_LOGDIALOG_H

// sc
#include "sublib/TargetId.h"
#include "util/String.h"
#include "util/Mutex.h"
class RevisionWidget;
class BaseModel;
class Project;
class LogEntryLvi;
class LogCallback;
class LogBaton;
class ScCmd;

namespace svn
{
  class Error;
}

// qt
#include <qwidget.h>
class QCheckBox;
class QPushButton;
class QListView;
class QListViewItem;
class QTextEdit;
class QAction;
class QSpinBox;
class QGroupBox;
class QLineEdit;
class QPopupMenu;

// sys
#include <vector>

/**
 * Dialog class for displaying log messages information.
 */
class LogDialog : public QWidget, public TargetId
{
  typedef QWidget super;
  Q_OBJECT 

public:
  typedef std::vector<LogEntryLvi*> LogEntryLvis;  

  LogDialog( BaseModel* model, const Project* prj, const sc::String& src,
    bool folder, QWidget *parent = 0 );
  virtual ~LogDialog();

  void customEvent( QCustomEvent* ce );

  void setSource( const sc::String& source, bool folder );
  void showCat( const QString& pathOrUrl, const QString& text );

  void finished();

public slots:
  void run();
  void clicked( QListViewItem* item );
  void logChanged();

  void set();
  void diff();
  void diffc();
  void diffwc();
  void merge();
  void undo();
  void cat();

  void find( const QString& text );
  void findNext();
  void findPrev();

  void contextMenuRequest( QListViewItem* item, const QPoint& p ,int col );
  void updateSelection();

private:
  void merge( bool undo );
  void getSelectedRevisions( LogEntryLvis& entries );
  void find( const QString& text, bool forward, int findIndex );

  BaseModel*       _model;
  const Project*   _prj;

  sc::String       _source;
  bool             _folder; // _source is a folder?

  RevisionWidget*  _rwStart;
  RevisionWidget*  _rwStop;

  QGroupBox*       _limitGroup;
  QSpinBox*        _limit;

  QLineEdit*       _find;
  int              _findIdx;
  QString          _findLastText;
  LogEntryLvi*     _findLastLvi;

  QCheckBox*       _changedPaths;
  QCheckBox*       _strictHistory;

  QListView*       _revs;
  QListView*       _paths;
  QTextEdit*       _log;

  QPushButton*     _set;

  QPushButton*     _findNext;
  QPushButton*     _findPrev;

  QPushButton*     _run;
  QPushButton*     _done;

  // menu, keyboard
  QAction*         _diffAction;
  QAction*         _diffcAction;
  QAction*         _diffwcAction;
  QAction*         _mergeAction;
  QAction*         _catAction;
  QAction*         _undoAction;

  QPopupMenu*      _menu; 
};

#endif // _SC_LOGDIALOG_H
