/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _BLOCK_INFO_H
#define _BLOCK_INFO_H

// sc
#include "svn/svn.h"


class BlockInfo
{
public:
  BlockInfo() : _start(-1), _length(-1)
  {
  }

  BlockInfo(svn::Offset start, svn::Offset length)
  : _start(start), _length(length)
  {
  }

  svn::Offset getStart() const
  {
    return _start;
  }

  svn::Offset getLength() const
  {
    return _length;
  }

  bool isEmpty() const
  {
    return _start == -1;
  }

  void addLength(svn::Offset l)
  {
    _length += l;
  }

private:
  svn::Offset _start;
  svn::Offset _length;
};

#endif //  _BLOCK_INFO_H

