/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_UUID_H
#define _SC_UUID_H

// apr util
#include <apr_uuid.h>


class Uuid
{
public:
  static Uuid createEmpty();
  static Uuid createUuid();
  static void release( const char** uuid );

  Uuid( const Uuid& src );
  Uuid( const char* uuid );
  void operator=( const Uuid& src );
  bool operator==( const Uuid& src ) const;

  const char* toString() const;

private:
  Uuid( bool init );

  apr_uuid_t _uuid;
};


#endif //  _SC_UUID_H

