/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "CursorSupport.h"

// qt
#include <QtGui/QApplication>
#include <QtGui/QCursor>


void setArrowCursor()
{
  QApplication::setOverrideCursor( QCursor(Qt::ArrowCursor) );
}


void setWaitCursor()
{
  QApplication::setOverrideCursor( QCursor(Qt::WaitCursor) );
}

void restoreCursor()
{
  QApplication::restoreOverrideCursor();
}

void cleanupCursor()
{
  QCursor* c = QApplication::overrideCursor();

  if( c && c->shape() == Qt::WaitCursor )
  {
    restoreCursor();
  }
}
