/* ====================================================================
 * Copyright (c) 2009       Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _WCVIEWSIMILARFOLDERNAMES_H
#define _WCVIEWSIMILARFOLDERNAMES_H

// cppunit
#include <cppunit/TestFixture.h>
#include <cppunit/extensions/HelperMacros.h>

// sc
#include "subcommander/WcViewItem.h"
#include "util/String.h"
class WcViewItemModel;
class WcViewTreeItemModel;
class WcViewTreeProxyModel;

// qt
#include <QtCore/QObject>
#include <QtCore/QModelIndex>


class WcViewSimilarFolderNames : public QObject, public CppUnit::TestCase 
{
  Q_OBJECT;

  CPPUNIT_TEST_SUITE( WcViewSimilarFolderNames );

  CPPUNIT_TEST( showAllAfterRootFolderAdd );
  CPPUNIT_TEST( showAllAfterSubcommanderAdd );
  CPPUNIT_TEST( showAllAfterSubcommanderTestAdd );

  CPPUNIT_TEST( showOnlyRootAfterRootFolderAdd );
  CPPUNIT_TEST( showOnlyChildAfterSubcommanderAdd );
  CPPUNIT_TEST( showBothChildsAfterSubcommanderTestAdd );

  CPPUNIT_TEST_SUITE_END(); 

public:
  void setUp();
  void tearDown();

  // Tests
  void showAllAfterRootFolderAdd();
  void showAllAfterSubcommanderAdd();
  void showAllAfterSubcommanderTestAdd();

  void showOnlyRootAfterRootFolderAdd();
  void showOnlyChildAfterSubcommanderAdd();
  void showBothChildsAfterSubcommanderTestAdd();

private:
  void setup( long idx, const char* path, bool dir, bool changed );

  void insert( WcViewItemModel* model, long dataIdx );
  void assertIndex( const QModelIndex& idx, const char* expected );

  WcViewTreeItemModel*  _model;
  WcViewTreeProxyModel* _proxy;

  WcViewItems _items[10];
};

#endif // _WCVIEWSIMILARFOLDERNAMES_H
